import{s as ns,n as ss,o as ls}from"../chunks/scheduler.9039eef2.js";import{S as os,i as is,g as o,s,r as p,A as rs,h as i,f as a,c as l,j as Da,u as d,x as r,k as Pa,l as es,y as _,a as n,v as c,d as m,t as h,w as u}from"../chunks/index.ded8f90d.js";import{D as as}from"../chunks/Docstring.a2ba2b54.js";import{C as f}from"../chunks/CodeBlock.8580f3e8.js";import{H as M}from"../chunks/Heading.f027f30d.js";function ps(an){let T,de,re,ce,k,me,j,nn="Supervised fine-tuning (or SFT for short) is a crucial step in RLHF. In TRL we provide an easy-to-use API to create your SFT models and train them with few lines of code on your dataset.",he,J,sn='Check out a complete flexible example at <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/sft.py" rel="nofollow"><code>examples/scripts/sft.py</code></a>.',ue,C,fe,x,ln=`If you have a dataset hosted on the 🤗 Hub, you can easily fine-tune your SFT model using <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> from TRL. Let us assume your dataset is <code>imdb</code>, the text you want to predict is inside the <code>text</code> field of the dataset, and you want to fine-tune the <code>facebook/opt-350m</code> model.
The following code-snippet takes care of all the data pre-processing and training for you:`,Me,$,ye,v,on="Make sure to pass a correct value for <code>max_seq_length</code> as the default value will be set to <code>min(tokenizer.model_max_length, 1024)</code>.",Te,F,rn="You can also construct a model outside of the trainer and pass it as follows:",ge,I,we,G,pn='The above snippets will use the default training arguments from the <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments" rel="nofollow"><code>transformers.TrainingArguments</code></a> class. If you want to modify that, make sure to create your own <code>TrainingArguments</code> object and pass it to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor as it is done on the <a href="https://github.com/huggingface/trl/blob/main/examples/stack_llama/scripts/supervised_finetuning.py" rel="nofollow"><code>supervised_finetuning.py</code> script</a> on the stack-llama example.',be,R,Ue,Z,_e,z,dn=`You can use the <code>DataCollatorForCompletionOnlyLM</code> to train your model on the generated prompts only. Note that this works only in the case when <code>packing=False</code>.
To instantiate that collator for instruction data, pass a response template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on completions only on the CodeAlpaca dataset:`,ke,B,je,S,cn="To instantiate that collator for assistant style conversation data, pass a response template, an instruction template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on assistant completions only on the Open Assistant Guanaco dataset:",Je,E,Ce,A,mn="Make sure to have a <code>pad_token_id</code> which is different from <code>eos_token_id</code> which can result in the model not properly predicting EOS (End of Sentence) tokens during generation.",xe,N,$e,X,hn="Some tokenizers like Llama 2 (<code>meta-llama/Llama-2-XXb-hf</code>) tokenize sequences differently depending whether they have context or not. For example:",ve,V,Fe,Q,un="In this case, and due to lack of context in <code>response_template</code>, the same string (”### Assistant:”) is tokenized differently:",Ie,W,fn="<li>Text (with context): <code>[2277, 29937, 4007, 22137, 29901]</code></li> <li><code>response_template</code> (without context): <code>[835, 4007, 22137, 29901]</code></li>",Ge,q,Mn="This will lead to an error when the <code>DataCollatorForCompletionOnlyLM</code> does not find the <code>response_template</code> in the dataset example text:",Re,L,Ze,H,yn="To solve this, you can tokenize the <code>response_template</code> with the same context than in the dataset, truncate it as needed and pass the <code>token_ids</code> directly to the <code>response_template</code> argument of the <code>DataCollatorForCompletionOnlyLM</code> class. For example:",ze,Y,Be,D,Se,P,Tn=`For instruction fine-tuning, it is quite common to have two columns inside the dataset: one for the prompt &amp; the other for the response.
This allows people to format examples like <a href="https://github.com/tatsu-lab/stanford_alpaca" rel="nofollow">Stanford-Alpaca</a> did as follows:`,Ee,O,Ae,K,gn="Let us assume your dataset has two fields, <code>question</code> and <code>answer</code>. Therefore you can just run:",Ne,tt,Xe,et,wn='To preperly format your input make sure to process all the examples by looping over them and returning a list of processed text. Check out a full example on how to use SFTTrainer on alpaca dataset <a href="https://github.com/huggingface/trl/pull/444#issue-1760952763" rel="nofollow">here</a>',Ve,at,Qe,nt,bn='<a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> supports <em>example packing</em>, where multiple short examples are packed in the same input sequence to increase training efficiency. This is done with the <code>ConstantLengthDataset</code> utility class that returns constant length chunks of tokens from a stream of examples. To enable the usage of this dataset class, simply pass <code>packing=True</code> to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor.',We,st,qe,lt,Un="Note that if you use a packed dataset and if you pass <code>max_steps</code> in the training arguments you will probably train your models for more than few epochs, depending on the way you have configured the packed dataset and the training protocol. Double check that you know and understand what you are doing.",Le,ot,He,it,_n="If your dataset has several fields that you want to combine, for example if the dataset has <code>question</code> and <code>answer</code> fields and you want to combine them, you can pass a formatting function to the trainer that will take care of that. For example:",Ye,rt,De,pt,kn='You can also customize the <code>ConstantLengthDataset</code> much more by directly passing the arguments to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor. Please refer to that class’ signature for more information.',Pe,dt,Oe,ct,jn='You can directly pass the kwargs of the <code>from_pretrained()</code> method to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a>. For example, if you want to load a model in a different precision, analogous to',Ke,mt,ta,ht,Jn="Note that all keyword arguments of <code>from_pretrained()</code> are supported.",ea,ut,aa,ft,Cn="We also support a tight integration with 🤗 PEFT library so that any user can conveniently train adapters and share them on the Hub instead of training the entire model",na,Mt,sa,yt,xn="Note that in case of training adapters, we manually add a saving callback to automatically save the adapters only:",la,Tt,oa,gt,$n="If you want to add more callbacks, make sure to add this one as well to properly save the adapters only during training.",ia,wt,ra,bt,vn="You can also continue training your <code>PeftModel</code>. For that, first load a <code>PeftModel</code> outside <code>SFTTrainer</code> and pass it directly to the trainer without the <code>peft_config</code> argument being passed.",pa,Ut,da,_t,Fn="For that you need to first load your 8bit model outside the Trainer and pass a <code>PeftConfig</code> to the trainer. For example:",ca,kt,ma,jt,ha,Jt,In=`You can benefit from Flash Attention 1 & 2 using SFTTrainer out of the box with minimal changes of code.
First, to make sure you have all the latest features from transformers, install transformers from source`,ua,Ct,fa,xt,Gn=`Note that Flash Attention only works on GPU now and under half-precision regime (when using adapters, base model loaded in half-precision)
Note also both features are perfectly compatible with other tools such as quantization.`,Ma,$t,ya,vt,Rn="For Flash Attention 1 you can use the <code>BetterTransformer</code> API and force-dispatch the API to use Flash Attention kernel. First, install the latest optimum package:",Ta,Ft,ga,It,Zn="Once you have loaded your model, wrap the <code>trainer.train()</code> call under the <code>with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</code> context manager:",wa,Gt,ba,Rt,zn="Note that you cannot train your model using Flash Attention 1 on an arbitrary dataset as <code>torch.scaled_dot_product_attention</code> does not support training with padding tokens if you use Flash Attention kernels. Therefore you can only use that feature with <code>packing=True</code>. If your dataset contains padding tokens, consider switching to Flash Attention 2 integration.",Ua,Zt,Bn="Below are some numbers you can get in terms of speedup and memory efficiency, using Flash Attention 1, on a single NVIDIA-T4 16GB.",_a,zt,Sn="<thead><tr><th>use_flash_attn_1</th> <th>model_name</th> <th>max_seq_len</th> <th>batch_size</th> <th>time per training step</th></tr></thead> <tbody><tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td>~59.1s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td><strong>OOM</strong></td></tr> <tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~30.3s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~148.9s</td></tr></tbody>",ka,Bt,ja,St,En="To use Flash Attention 2, first install the latest <code>flash-attn</code> package:",Ja,Et,Ca,At,An="And add <code>use_flash_attention_2=True</code> when calling <code>from_pretrained</code>:",xa,Nt,$a,Xt,Nn=`If you don’t use quantization, make sure your model is loaded in half-precision and dispatch your model on a supported GPU device.
After loading your model, you can either train it as it is, or attach adapters and train adapters on it in case your model is quantized.`,va,Vt,Xn="In contrary to Flash Attention 1, the integration makes it possible to train your model on an arbitrary dataset that also includes padding tokens.",Fa,Qt,Ia,Wt,Vn='NEFTune is a technique to boost the performance of chat models and was introduced by the paper <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">“NEFTune: Noisy Embeddings Improve Instruction Finetuning”</a> from Jain et al. it consists of adding noise to the embedding vectors during training. According to the abstract of the paper:',Ga,qt,Qn="<p>Standard finetuning of LLaMA-2-7B using Alpaca achieves 29.79% on AlpacaEval, which rises to 64.69% using noisy embeddings. NEFTune also improves over strong baselines on modern instruction datasets. Models trained with Evol-Instruct see a 10% improvement, with ShareGPT an 8% improvement, and with OpenPlatypus an 8% improvement. Even powerful models further refined with RLHF such as LLaMA-2-Chat benefit from additional training with NEFTune.</p>",Ra,w,Wn='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/neft-screenshot.png"/>',Za,Lt,qn="To use it in <code>SFTTrainer</code> simply pass <code>neftune_noise_alpha</code> when creating your <code>SFTTrainer</code> instance. Note that to avoid any surprising behaviour, NEFTune is disabled after training to retrieve back the original behaviour of the embedding layer.",za,Ht,Ba,Yt,Ln='We have tested NEFTune by training <code>mistralai/Mistral-7B-v0.1</code> on the <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow">OpenAssistant dataset</a> and validated that using NEFTune led to a performance boost of ~25% on MT Bench.',Sa,b,Hn='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl-neftune-mistral-7b.png"/>',Ea,Dt,Yn='Note however, that the amount of performance gain is <em>dataset dependent</em> and in particular, applying NEFTune on synthetic datasets like <a href="https://huggingface.co/datasets/stingning/ultrachat" rel="nofollow">UltraChat</a> typically produces smaller gains.',Aa,Pt,Na,Ot,Dn="Pay attention to the following best practices when training a model with that trainer:",Xa,Kt,Pn='<li><a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> always pads by default the sequences to the <code>max_seq_length</code> argument of the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a>. If none is passed, the trainer will retrieve that value from the tokenizer. Some tokenizers do not provide default value, so there is a check to retrieve the minimum between 2048 and that value. Make sure to check it before training.</li> <li>For training adapters in 8bit, you might need to tweak the arguments of the <code>prepare_model_for_kbit_training</code> method from PEFT, hence we advise users to use <code>prepare_in_int8_kwargs</code> field, or create the <code>PeftModel</code> outside the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> and pass it.</li> <li>For a more memory-efficient training using adapters, you can load the base model in 8bit, for that simply add <code>load_in_8bit</code> argument when creating the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a>, or create a base model in 8bit outside the trainer and pass it.</li> <li>If you create a model outside the trainer, make sure to not pass to the trainer any additional keyword arguments that are relative to <code>from_pretrained()</code> method.</li>',Va,te,Qa,g,ee,Oa,le,On=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,Wa,ae,qa,y,ne,Ka,oe,Kn=`Iterable dataset that returns constant length chunks of tokens from stream of text files.
The dataset also formats the text before tokenization with a specific format that is provided
by the user.`,tn,se,en,ie,ts=`”<code>infinite (</code>bool<code>, *optional*, defaults to </code>False<code>): If True the iterator is reset after dataset reaches end else stops. seq_length (</code>int<code>, *optional*, defaults to </code>1024<code>): Length of token sequences to return. num_of_sequences (</code>int<code>, *optional*, defaults to </code>1024<code>): Number of token sequences to keep in buffer. chars_per_token (</code>int<code>, *optional*, defaults to </code>3.6<code>): Number of characters per token used to estimate number of tokens in text buffer. eos_token_id (</code>int<code>, *optional*, defaults to </code>0\`):
Id of the end of sequence token if the passed tokenizer does not have an EOS token.
shuffle (‘bool’, <em>optional</em>, defaults to True)
Shuffle the examples before they are returned`,La,pe,Ha;return k=new M({props:{title:"Supervised Fine-tuning Trainer",local:"supervised-fine-tuning-trainer",headingTag:"h1"}}),C=new M({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),$=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)
trainer.train()`,wrap:!1}}),I=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)

trainer.train()`,wrap:!1}}),R=new M({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),Z=new M({props:{title:"Train on completions only",local:"train-on-completions-only",headingTag:"h3"}}),B=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybHVjYXNtY2NhYmUtbG1pJTJGQ29kZUFscGFjYS0yMGslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFkZWYlMjBmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyhleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF90ZXh0cyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihleGFtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTVCaSU1RCU3RCU1Q24lMjAlMjMlMjMlMjMlMjBBbnN3ZXIlM0ElMjAlN0JleGFtcGxlJTVCJ291dHB1dCclNUQlNUJpJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X3RleHRzLmFwcGVuZCh0ZXh0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dF90ZXh0cyUwQSUwQXJlc3BvbnNlX3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIwJTIzJTIzJTIzJTIwQW5zd2VyJTNBJTIyJTBBY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JDb21wbGV0aW9uT25seUxNKHJlc3BvbnNlX3RlbXBsYXRlJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBmb3JtYXR0aW5nX2Z1bmMlM0Rmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCklMjA=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;lucasmccabe-lmi/CodeAlpaca-20k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;instruction&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;output&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

response_template = <span class="hljs-string">&quot; ### Answer:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(response_template, tokenizer=tokenizer)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
    data_collator=collator,
)

trainer.train() `,wrap:!1}}),E=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydGltZGV0dG1lcnMlMkZvcGVuYXNzaXN0YW50LWd1YW5hY28lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEh1bWFuJTNBJTIyJTBBcmVzcG9uc2VfdGVtcGxhdGUlMjAlM0QlMjAlMjIlMjMlMjMlMjMlMjBBc3Npc3RhbnQlM0ElMjIlMEFjb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvckNvbXBsZXRpb25Pbmx5TE0oaW5zdHJ1Y3Rpb25fdGVtcGxhdGUlM0RpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyQyUyMHJlc3BvbnNlX3RlbXBsYXRlJTNEcmVzcG9uc2VfdGVtcGxhdGUlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBtbG0lM0RGYWxzZSklMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCklMjA=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;timdettmers/openassistant-guanaco&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

instruction_template = <span class="hljs-string">&quot;### Human:&quot;</span>
response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(instruction_template=instruction_template, response_template=response_template, tokenizer=tokenizer, mlm=<span class="hljs-literal">False</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    data_collator=collator,
)

trainer.train() `,wrap:!1}}),N=new M({props:{title:"Using token_ids directly for response_template",local:"using-tokenids-directly-for-responsetemplate",headingTag:"h4"}}),V=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEElMEFkZWYlMjBwcmludF90b2tlbnNfd2l0aF9pZHModHh0KSUzQSUwQSUyMCUyMCUyMCUyMHRva2VucyUyMCUzRCUyMHRva2VuaXplci50b2tlbml6ZSh0eHQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSklMEElMjAlMjAlMjAlMjB0b2tlbl9pZHMlMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKHR4dCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMHByaW50KGxpc3QoemlwKHRva2VucyUyQyUyMHRva2VuX2lkcykpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUyMyUyMyUyMyUyMFVzZXIlM0ElMjBIZWxsbyU1Q24lNUNuJTIzJTIzJTIzJTIwQXNzaXN0YW50JTNBJTIwSGklMkMlMjBob3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUzRiUyMiUyMiUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhwcm9tcHQpJTIwJTIwJTIzJTIwJTVCLi4uJTJDJTIwKCclRTIlOTYlODFIZWxsbyclMkMlMjAxNTA0MyklMkMlMjAoJyUzQzB4MEElM0UnJTJDJTIwMTMpJTJDJTIwKCclM0MweDBBJTNFJyUyQyUyMDEzKSUyQyUyMCgnJTIzJTIzJyUyQyUyMDIyNzcpJTJDJTIwKCclMjMnJTJDJTIwMjk5MzcpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklMkMlMjAuLi4lNUQlMEElMEFyZXNwb25zZV90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhyZXNwb25zZV90ZW1wbGF0ZSklMjAlMjAlMjMlMjAlNUIoJyVFMiU5NiU4MSUyMyUyMyUyMyclMkMlMjA4MzUpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_tokens_with_ids</span>(<span class="hljs-params">txt</span>):
    tokens = tokenizer.tokenize(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    token_ids = tokenizer.encode(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(<span class="hljs-built_in">zip</span>(tokens, token_ids)))

prompt = <span class="hljs-string">&quot;&quot;&quot;### User: Hello\\n\\n### Assistant: Hi, how can I help you?&quot;&quot;&quot;</span>
print_tokens_with_ids(prompt)  <span class="hljs-comment"># [..., (&#x27;▁Hello&#x27;, 15043), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;##&#x27;, 2277), (&#x27;#&#x27;, 29937), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901), ...]</span>

response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
print_tokens_with_ids(response_template)  <span class="hljs-comment"># [(&#x27;▁###&#x27;, 835), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901)]</span>`,wrap:!1}}),L=new f({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ291bGQlMjBub3QlMjBmaW5kJTIwcmVzcG9uc2UlMjBrZXklMjAlNUI4MzUlMkMlMjA0MDA3JTJDJTIwMjIxMzclMkMlMjAyOTkwMSU1RCUyMGluJTIwdG9rZW4lMjBJRHMlMjB0ZW5zb3IoJTVCJTIwJTIwJTIwJTIwMSUyQyUyMCUyMCUyMDgzNSUyQyUyMCUyMC4uLiU1RCklMjAlMjAlMjA=",highlighted:'RuntimeError: Could not find response key <span class="hljs-selector-attr">[835, 4007, 22137, 29901]</span> <span class="hljs-keyword">in</span> token IDs <span class="hljs-built_in">tensor</span>(<span class="hljs-selector-attr">[    1,   835,  ...]</span>)   ',wrap:!1}}),Y=new f({props:{code:"cmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTIwJTNEJTIwJTIyJTVDbiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUyMCUyMCUyMyUyMFdlJTIwYWRkZWQlMjBjb250ZXh0JTIwaGVyZSUzQSUyMCUyMiU1Q24lMjIuJTIwVGhpcyUyMGlzJTIwZW5vdWdoJTIwZm9yJTIwdGhpcyUyMHRva2VuaXplciUwQXJlc3BvbnNlX3RlbXBsYXRlX2lkcyUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUocmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpJTVCMiUzQSU1RCUyMCUyMCUyMyUyME5vdyUyMHdlJTIwaGF2ZSUyMGl0JTIwbGlrZSUyMGluJTIwdGhlJTIwZGF0YXNldCUyMHRleHRzJTNBJTIwJTYwJTVCMjI3NyUyQyUyMDI5OTM3JTJDJTIwNDAwNyUyQyUyMDIyMTM3JTJDJTIwMjk5MDElNUQlNjAlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTShyZXNwb25zZV90ZW1wbGF0ZV9pZHMlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`response_template_with_context = <span class="hljs-string">&quot;\\n### Assistant:&quot;</span>  <span class="hljs-comment"># We added context here: &quot;\\n&quot;. This is enough for this tokenizer</span>
response_template_ids = tokenizer.encode(response_template_with_context, add_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-number">2</span>:]  <span class="hljs-comment"># Now we have it like in the dataset texts: \`[2277, 29937, 4007, 22137, 29901]\`</span>

data_collator = DataCollatorForCompletionOnlyLM(response_template_ids, tokenizer=tokenizer)`,wrap:!1}}),D=new M({props:{title:"Format your input prompts",local:"format-your-input-prompts",headingTag:"h3"}}),O=new f({props:{code:"QmVsb3clMjBpcyUyMGFuJTIwaW5zdHJ1Y3Rpb24lMjAuLi4lMEElMEElMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiUwQSU3QnByb21wdCU3RCUwQSUwQSUyMyUyMyUyMyUyMFJlc3BvbnNlJTNBJTBBJTdCY29tcGxldGlvbiU3RA==",highlighted:`Below is an instruction ...

<span class="hljs-comment">### Instruction</span>
{prompt}

<span class="hljs-comment">### Response:</span>
{completion}`,wrap:!1}}),tt=new f({props:{code:"JTBB",highlighted:`...
<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;question&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
)

trainer.train()`,wrap:!1}}),at=new M({props:{title:"Packing dataset ( ConstantLengthDataset )",local:"packing-dataset--constantlengthdataset-",headingTag:"h3"}}),st=new f({props:{code:"JTBB",highlighted:`...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    packing=<span class="hljs-literal">True</span>
)

trainer.train()`,wrap:!1}}),ot=new M({props:{title:"Customize your prompts using packed dataset",local:"customize-your-prompts-using-packed-dataset",headingTag:"h4"}}),rt=new f({props:{code:"ZGVmJTIwZm9ybWF0dGluZ19mdW5jKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTdEJTVDbiUyMCUyMyUyMyUyMyUyMEFuc3dlciUzQSUyMCU3QmV4YW1wbGUlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBwYWNraW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGZvcm1hdHRpbmdfZnVuYyUzRGZvcm1hdHRpbmdfZnVuYyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_func</span>(<span class="hljs-params">example</span>):
    text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">return</span> text

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    packing=<span class="hljs-literal">True</span>,
    formatting_func=formatting_func
)

trainer.train()`,wrap:!1}}),dt=new M({props:{title:"Control over the pretrained model",local:"trl.SFTTrainer",headingTag:"h3"}}),mt=new f({props:{code:"JTBBJTBB",highlighted:`model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, torch_dtype=torch.bfloat16)

\`\`\`python
...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
)

trainer.train()`,wrap:!1}}),ut=new M({props:{title:"Training adapters",local:"training-adapters",headingTag:"h3"}}),Mt=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwJTIyRWxldXRoZXJBSSUyRmdwdC1uZW8tMTI1bSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEcGVmdF9jb25maWclMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config
)

trainer.train()`,wrap:!1}}),Tt=new f({props:{code:"Y2xhc3MlMjBQZWZ0U2F2aW5nQ2FsbGJhY2soVHJhaW5lckNhbGxiYWNrKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMG9uX3NhdmUoc2VsZiUyQyUyMGFyZ3MlMkMlMjBzdGF0ZSUyQyUyMGNvbnRyb2wlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjaGVja3BvaW50X3BhdGglMjAlM0QlMjBvcy5wYXRoLmpvaW4oYXJncy5vdXRwdXRfZGlyJTJDJTIwZiUyMmNoZWNrcG9pbnQtJTdCc3RhdGUuZ2xvYmFsX3N0ZXAlN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa3dhcmdzJTVCJTIybW9kZWwlMjIlNUQuc2F2ZV9wcmV0cmFpbmVkKGNoZWNrcG9pbnRfcGF0aCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMCUyMnB5dG9yY2hfbW9kZWwuYmluJTIyJTIwaW4lMjBvcy5saXN0ZGlyKGNoZWNrcG9pbnRfcGF0aCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcy5yZW1vdmUob3MucGF0aC5qb2luKGNoZWNrcG9pbnRfcGF0aCUyQyUyMCUyMnB5dG9yY2hfbW9kZWwuYmluJTIyKSk=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PeftSavingCallback</span>(<span class="hljs-title class_ inherited__">TrainerCallback</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">on_save</span>(<span class="hljs-params">self, args, state, control, **kwargs</span>):
        checkpoint_path = os.path.join(args.output_dir, <span class="hljs-string">f&quot;checkpoint-<span class="hljs-subst">{state.global_step}</span>&quot;</span>)
        kwargs[<span class="hljs-string">&quot;model&quot;</span>].save_pretrained(checkpoint_path)

        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;pytorch_model.bin&quot;</span> <span class="hljs-keyword">in</span> os.listdir(checkpoint_path):
            os.remove(os.path.join(checkpoint_path, <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>))`,wrap:!1}}),wt=new f({props:{code:"JTBBJTBB",highlighted:`...

callbacks = [YourCustomCallback(), PeftSavingCallback()]

trainer = SFTTrainer(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config,
    callbacks=callbacks
)

trainer.train()`,wrap:!1}}),Ut=new M({props:{title:"Training adapters with base 8 bit models",local:"training-adapters-with-base-8-bit-models",headingTag:"h3"}}),kt=new f({props:{code:"JTBBJTBBJTBB",highlighted:`...

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config,
)

trainer.train()`,wrap:!1}}),jt=new M({props:{title:"Using Flash Attention and Flash Attention 2",local:"using-flash-attention-and-flash-attention-2",headingTag:"h2"}}),Ct=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMuZ2l0",highlighted:"pip install -U git+https://github.com/huggingface/transformers.git",wrap:!1}}),$t=new M({props:{title:"Using Flash-Attention 1",local:"using-flash-attention-1",headingTag:"h3"}}),Ft=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwb3B0aW11bQ==",highlighted:"pip install -U optimum",wrap:!1}}),Gt=new f({props:{code:"",highlighted:`...

<span class="hljs-addition">+ with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</span>
    trainer.train()`,wrap:!1}}),Bt=new M({props:{title:"Using Flash Attention-2",local:"using-flash-attention-2",headingTag:"h3"}}),Et=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0bg==",highlighted:"pip install -U flash-attn",wrap:!1}}),Nt=new f({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2ZsYXNoX2F0dGVudGlvbl8yJTNEVHJ1ZSUwQSk=",highlighted:`model = AutoModelForCausalLM.from_pretrained(
    model_id,
    load_in_4bit=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Qt=new M({props:{title:"Enhance model’s performances using NEFTune",local:"enhance-models-performances-using-neftune",headingTag:"h3"}}),Ht=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMG5lZnR1bmVfbm9pc2VfYWxwaGElM0Q1JTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
    neftune_noise_alpha=<span class="hljs-number">5</span>,
)
trainer.train()`,wrap:!1}}),Pt=new M({props:{title:"Best practices",local:"best-practices",headingTag:"h2"}}),te=new M({props:{title:"SFTTrainer",local:"sfttrainer",headingTag:"h2"}}),ee=new as({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalPrediction], typing.Dict], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"peft_config",val:": typing.Optional[ForwardRef('PeftConfig')] = None"},{name:"dataset_text_field",val:": typing.Optional[str] = None"},{name:"packing",val:": typing.Optional[bool] = False"},{name:"formatting_func",val:": typing.Optional[typing.Callable] = None"},{name:"max_seq_length",val:": typing.Optional[int] = None"},{name:"infinite",val:": typing.Optional[bool] = False"},{name:"num_of_sequences",val:": typing.Optional[int] = 1024"},{name:"chars_per_token",val:": typing.Optional[float] = 3.6"},{name:"dataset_num_proc",val:": typing.Optional[int] = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"},{name:"model_init_kwargs",val:": typing.Optional[typing.Dict] = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">transformers.TrainingArguments</a>) &#x2014;
The arguments to tweak for training. Please refer to the official documentation of <code>transformers.TrainingArguments</code>
for more information.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (Optional<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (Optional<a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">datasets.Dataset</a>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer" rel="nofollow">transformers.PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to <code>compute_accuracy</code>) &#x2014;
The metrics to use for evaluation. If no metrics are specified, the default metric (<code>compute_accuracy</code>) will be used.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>) &#x2014;
The name of the text field of the dataset, in case this is passed by a user, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on the <code>dataset_text_field</code> argument.`,name:"dataset_text_field"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"},{anchor:"trl.SFTTrainer.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>) &#x2014;
The maximum sequence length to use for the <code>ConstantLengthDataset</code> and for automaticallty creating the Dataset. Defaults to <code>512</code>.`,name:"max_seq_length"},{anchor:"trl.SFTTrainer.infinite",description:`<strong>infinite</strong> (<code>Optional[bool]</code>) &#x2014;
Whether to use an infinite dataset or not. Defaults to <code>False</code>.`,name:"infinite"},{anchor:"trl.SFTTrainer.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>Optional[int]</code>) &#x2014;
The number of sequences to use for the <code>ConstantLengthDataset</code>. Defaults to <code>1024</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTTrainer.chars_per_token",description:`<strong>chars_per_token</strong> (<code>Optional[float]</code>) &#x2014;
The number of characters per token to use for the <code>ConstantLengthDataset</code>. Defaults to <code>3.6</code>. You can check how this is computed in the
stack-llama example: <a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53</a>.`,name:"chars_per_token"},{anchor:"trl.SFTTrainer.packing",description:`<strong>packing</strong> (<code>Optional[bool]</code>) &#x2014;
Used only in case <code>dataset_text_field</code> is passed. This argument is used by the <code>ConstantLengthDataset</code> to pack the sequences
of the dataset.`,name:"packing"},{anchor:"trl.SFTTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>) &#x2014;
The number of workers to use to tokenize the data. Only used when <code>packing=False</code>. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.SFTTrainer.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>int</code>) &#x2014;
The number of examples to tokenize per batch. If batch_size &lt;= 0 or batch_size == None,
tokenize the full dataset as a single batch. Defaults to 1000.`,name:"dataset_batch_size"},{anchor:"trl.SFTTrainer.neftune_noise_alpha",description:`<strong>neftune_noise_alpha</strong> (<code>Optional[float]</code>) &#x2014;
If not <code>None</code>, this will activate NEFTune noise embeddings. This has been proven to drastically improve model performances for instrcution
fine-tuning. Check out the original paper here: <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">https://arxiv.org/abs/2310.05914</a> and the original code here: <a href="https://github.com/neelsjain/NEFTune" rel="nofollow">https://github.com/neelsjain/NEFTune</a>
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"neftune_noise_alpha"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/sft_trainer.py#L50"}}),ae=new M({props:{title:"ConstantLengthDataset",local:"constantlengthdataset",headingTag:"h2"}}),ne=new as({props:{name:"class trl.trainer.ConstantLengthDataset",anchor:"trl.trainer.ConstantLengthDataset",parameters:[{name:"*args",val:""},{name:"**kwds",val:""}],parametersDescription:[{anchor:"trl.trainer.ConstantLengthDataset.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizer</code>) &#x2014;
The processor used for processing the data.`,name:"tokenizer"},{anchor:"trl.trainer.ConstantLengthDataset.dataset",description:`<strong>dataset</strong> (<code>dataset.Dataset</code>) &#x2014;
Dataset with text files.`,name:"dataset"},{anchor:"trl.trainer.ConstantLengthDataset.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>str</code>, <strong>optional</strong>) &#x2014;
Name of the field in the dataset that contains the text. Used only if <code>formatting_func</code> is <code>None</code>.`,name:"dataset_text_field"},{anchor:"trl.trainer.ConstantLengthDataset.formatting_func",description:`<strong>formatting_func</strong> (<code>Callable</code>, <strong>optional</strong>) &#x2014;
Function that formats the text before tokenization. Usually it is recommended to have follows a certain
pattern such as \`&#x201D;### Question: {question}`,name:"formatting_func"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/utils.py#L490"}}),se=new M({props:{title:"Answer: {answer}",local:"answer-answer",headingTag:"h3"}}),{c(){T=o("meta"),de=s(),re=o("p"),ce=s(),p(k.$$.fragment),me=s(),j=o("p"),j.textContent=nn,he=s(),J=o("p"),J.innerHTML=sn,ue=s(),p(C.$$.fragment),fe=s(),x=o("p"),x.innerHTML=ln,Me=s(),p($.$$.fragment),ye=s(),v=o("p"),v.innerHTML=on,Te=s(),F=o("p"),F.textContent=rn,ge=s(),p(I.$$.fragment),we=s(),G=o("p"),G.innerHTML=pn,be=s(),p(R.$$.fragment),Ue=s(),p(Z.$$.fragment),_e=s(),z=o("p"),z.innerHTML=dn,ke=s(),p(B.$$.fragment),je=s(),S=o("p"),S.innerHTML=cn,Je=s(),p(E.$$.fragment),Ce=s(),A=o("p"),A.innerHTML=mn,xe=s(),p(N.$$.fragment),$e=s(),X=o("p"),X.innerHTML=hn,ve=s(),p(V.$$.fragment),Fe=s(),Q=o("p"),Q.innerHTML=un,Ie=s(),W=o("ul"),W.innerHTML=fn,Ge=s(),q=o("p"),q.innerHTML=Mn,Re=s(),p(L.$$.fragment),Ze=s(),H=o("p"),H.innerHTML=yn,ze=s(),p(Y.$$.fragment),Be=s(),p(D.$$.fragment),Se=s(),P=o("p"),P.innerHTML=Tn,Ee=s(),p(O.$$.fragment),Ae=s(),K=o("p"),K.innerHTML=gn,Ne=s(),p(tt.$$.fragment),Xe=s(),et=o("p"),et.innerHTML=wn,Ve=s(),p(at.$$.fragment),Qe=s(),nt=o("p"),nt.innerHTML=bn,We=s(),p(st.$$.fragment),qe=s(),lt=o("p"),lt.innerHTML=Un,Le=s(),p(ot.$$.fragment),He=s(),it=o("p"),it.innerHTML=_n,Ye=s(),p(rt.$$.fragment),De=s(),pt=o("p"),pt.innerHTML=kn,Pe=s(),p(dt.$$.fragment),Oe=s(),ct=o("p"),ct.innerHTML=jn,Ke=s(),p(mt.$$.fragment),ta=s(),ht=o("p"),ht.innerHTML=Jn,ea=s(),p(ut.$$.fragment),aa=s(),ft=o("p"),ft.textContent=Cn,na=s(),p(Mt.$$.fragment),sa=s(),yt=o("p"),yt.textContent=xn,la=s(),p(Tt.$$.fragment),oa=s(),gt=o("p"),gt.textContent=$n,ia=s(),p(wt.$$.fragment),ra=s(),bt=o("p"),bt.innerHTML=vn,pa=s(),p(Ut.$$.fragment),da=s(),_t=o("p"),_t.innerHTML=Fn,ca=s(),p(kt.$$.fragment),ma=s(),p(jt.$$.fragment),ha=s(),Jt=o("p"),Jt.textContent=In,ua=s(),p(Ct.$$.fragment),fa=s(),xt=o("p"),xt.textContent=Gn,Ma=s(),p($t.$$.fragment),ya=s(),vt=o("p"),vt.innerHTML=Rn,Ta=s(),p(Ft.$$.fragment),ga=s(),It=o("p"),It.innerHTML=Zn,wa=s(),p(Gt.$$.fragment),ba=s(),Rt=o("p"),Rt.innerHTML=zn,Ua=s(),Zt=o("p"),Zt.textContent=Bn,_a=s(),zt=o("table"),zt.innerHTML=Sn,ka=s(),p(Bt.$$.fragment),ja=s(),St=o("p"),St.innerHTML=En,Ja=s(),p(Et.$$.fragment),Ca=s(),At=o("p"),At.innerHTML=An,xa=s(),p(Nt.$$.fragment),$a=s(),Xt=o("p"),Xt.textContent=Nn,va=s(),Vt=o("p"),Vt.textContent=Xn,Fa=s(),p(Qt.$$.fragment),Ia=s(),Wt=o("p"),Wt.innerHTML=Vn,Ga=s(),qt=o("blockquote"),qt.innerHTML=Qn,Ra=s(),w=o("div"),w.innerHTML=Wn,Za=s(),Lt=o("p"),Lt.innerHTML=qn,za=s(),p(Ht.$$.fragment),Ba=s(),Yt=o("p"),Yt.innerHTML=Ln,Sa=s(),b=o("div"),b.innerHTML=Hn,Ea=s(),Dt=o("p"),Dt.innerHTML=Yn,Aa=s(),p(Pt.$$.fragment),Na=s(),Ot=o("p"),Ot.textContent=Dn,Xa=s(),Kt=o("ul"),Kt.innerHTML=Pn,Va=s(),p(te.$$.fragment),Qa=s(),g=o("div"),p(ee.$$.fragment),Oa=s(),le=o("p"),le.innerHTML=On,Wa=s(),p(ae.$$.fragment),qa=s(),y=o("div"),p(ne.$$.fragment),Ka=s(),oe=o("p"),oe.textContent=Kn,tn=s(),p(se.$$.fragment),en=s(),ie=o("p"),ie.innerHTML=ts,La=s(),pe=o("p"),this.h()},l(t){const e=rs("svelte-u9bgzb",document.head);T=i(e,"META",{name:!0,content:!0}),e.forEach(a),de=l(t),re=i(t,"P",{}),Da(re).forEach(a),ce=l(t),d(k.$$.fragment,t),me=l(t),j=i(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-o839x3"&&(j.textContent=nn),he=l(t),J=i(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-exgkch"&&(J.innerHTML=sn),ue=l(t),d(C.$$.fragment,t),fe=l(t),x=i(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-8asaew"&&(x.innerHTML=ln),Me=l(t),d($.$$.fragment,t),ye=l(t),v=i(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1gbidw"&&(v.innerHTML=on),Te=l(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-ulikv8"&&(F.textContent=rn),ge=l(t),d(I.$$.fragment,t),we=l(t),G=i(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-ryagwl"&&(G.innerHTML=pn),be=l(t),d(R.$$.fragment,t),Ue=l(t),d(Z.$$.fragment,t),_e=l(t),z=i(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-13sbeoj"&&(z.innerHTML=dn),ke=l(t),d(B.$$.fragment,t),je=l(t),S=i(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1a743rp"&&(S.innerHTML=cn),Je=l(t),d(E.$$.fragment,t),Ce=l(t),A=i(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-17fkgzr"&&(A.innerHTML=mn),xe=l(t),d(N.$$.fragment,t),$e=l(t),X=i(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-dfggk8"&&(X.innerHTML=hn),ve=l(t),d(V.$$.fragment,t),Fe=l(t),Q=i(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-xlwe87"&&(Q.innerHTML=un),Ie=l(t),W=i(t,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-1enki0k"&&(W.innerHTML=fn),Ge=l(t),q=i(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-14yxh0m"&&(q.innerHTML=Mn),Re=l(t),d(L.$$.fragment,t),Ze=l(t),H=i(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-13h81gp"&&(H.innerHTML=yn),ze=l(t),d(Y.$$.fragment,t),Be=l(t),d(D.$$.fragment,t),Se=l(t),P=i(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-cqsf2h"&&(P.innerHTML=Tn),Ee=l(t),d(O.$$.fragment,t),Ae=l(t),K=i(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-l25vq0"&&(K.innerHTML=gn),Ne=l(t),d(tt.$$.fragment,t),Xe=l(t),et=i(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1iqmdsd"&&(et.innerHTML=wn),Ve=l(t),d(at.$$.fragment,t),Qe=l(t),nt=i(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1a4epj8"&&(nt.innerHTML=bn),We=l(t),d(st.$$.fragment,t),qe=l(t),lt=i(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-wtbvzy"&&(lt.innerHTML=Un),Le=l(t),d(ot.$$.fragment,t),He=l(t),it=i(t,"P",{"data-svelte-h":!0}),r(it)!=="svelte-iejqw3"&&(it.innerHTML=_n),Ye=l(t),d(rt.$$.fragment,t),De=l(t),pt=i(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-qqgn8q"&&(pt.innerHTML=kn),Pe=l(t),d(dt.$$.fragment,t),Oe=l(t),ct=i(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-oxgwyg"&&(ct.innerHTML=jn),Ke=l(t),d(mt.$$.fragment,t),ta=l(t),ht=i(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1rnsxc5"&&(ht.innerHTML=Jn),ea=l(t),d(ut.$$.fragment,t),aa=l(t),ft=i(t,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-11jfbzz"&&(ft.textContent=Cn),na=l(t),d(Mt.$$.fragment,t),sa=l(t),yt=i(t,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-1iplhln"&&(yt.textContent=xn),la=l(t),d(Tt.$$.fragment,t),oa=l(t),gt=i(t,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-645tfb"&&(gt.textContent=$n),ia=l(t),d(wt.$$.fragment,t),ra=l(t),bt=i(t,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-pwdaav"&&(bt.innerHTML=vn),pa=l(t),d(Ut.$$.fragment,t),da=l(t),_t=i(t,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-zbh7v5"&&(_t.innerHTML=Fn),ca=l(t),d(kt.$$.fragment,t),ma=l(t),d(jt.$$.fragment,t),ha=l(t),Jt=i(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-fyvvsj"&&(Jt.textContent=In),ua=l(t),d(Ct.$$.fragment,t),fa=l(t),xt=i(t,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-yypgof"&&(xt.textContent=Gn),Ma=l(t),d($t.$$.fragment,t),ya=l(t),vt=i(t,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-yugu96"&&(vt.innerHTML=Rn),Ta=l(t),d(Ft.$$.fragment,t),ga=l(t),It=i(t,"P",{"data-svelte-h":!0}),r(It)!=="svelte-1qms4cl"&&(It.innerHTML=Zn),wa=l(t),d(Gt.$$.fragment,t),ba=l(t),Rt=i(t,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-qe5zfz"&&(Rt.innerHTML=zn),Ua=l(t),Zt=i(t,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-69u1rz"&&(Zt.textContent=Bn),_a=l(t),zt=i(t,"TABLE",{"data-svelte-h":!0}),r(zt)!=="svelte-8fq96j"&&(zt.innerHTML=Sn),ka=l(t),d(Bt.$$.fragment,t),ja=l(t),St=i(t,"P",{"data-svelte-h":!0}),r(St)!=="svelte-1rqlm78"&&(St.innerHTML=En),Ja=l(t),d(Et.$$.fragment,t),Ca=l(t),At=i(t,"P",{"data-svelte-h":!0}),r(At)!=="svelte-sqoxna"&&(At.innerHTML=An),xa=l(t),d(Nt.$$.fragment,t),$a=l(t),Xt=i(t,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-vfpk19"&&(Xt.textContent=Nn),va=l(t),Vt=i(t,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-zatc00"&&(Vt.textContent=Xn),Fa=l(t),d(Qt.$$.fragment,t),Ia=l(t),Wt=i(t,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-6trhkk"&&(Wt.innerHTML=Vn),Ga=l(t),qt=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(qt)!=="svelte-1ejl1pl"&&(qt.innerHTML=Qn),Ra=l(t),w=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(w)!=="svelte-1wkjgyb"&&(w.innerHTML=Wn),Za=l(t),Lt=i(t,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-7jwpzy"&&(Lt.innerHTML=qn),za=l(t),d(Ht.$$.fragment,t),Ba=l(t),Yt=i(t,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-sqj12"&&(Yt.innerHTML=Ln),Sa=l(t),b=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(b)!=="svelte-a1m5gi"&&(b.innerHTML=Hn),Ea=l(t),Dt=i(t,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-rwofnh"&&(Dt.innerHTML=Yn),Aa=l(t),d(Pt.$$.fragment,t),Na=l(t),Ot=i(t,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-g801h1"&&(Ot.textContent=Dn),Xa=l(t),Kt=i(t,"UL",{"data-svelte-h":!0}),r(Kt)!=="svelte-1mmsr46"&&(Kt.innerHTML=Pn),Va=l(t),d(te.$$.fragment,t),Qa=l(t),g=i(t,"DIV",{class:!0});var Ya=Da(g);d(ee.$$.fragment,Ya),Oa=l(Ya),le=i(Ya,"P",{"data-svelte-h":!0}),r(le)!=="svelte-14oyph8"&&(le.innerHTML=On),Ya.forEach(a),Wa=l(t),d(ae.$$.fragment,t),qa=l(t),y=i(t,"DIV",{class:!0});var U=Da(y);d(ne.$$.fragment,U),Ka=l(U),oe=i(U,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1dlriq1"&&(oe.textContent=Kn),tn=l(U),d(se.$$.fragment,U),en=l(U),ie=i(U,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1quwuq5"&&(ie.innerHTML=ts),U.forEach(a),La=l(t),pe=i(t,"P",{}),Da(pe).forEach(a),this.h()},h(){Pa(T,"name","hf:doc:metadata"),Pa(T,"content",ds),es(w,"text-align","center"),es(b,"text-align","center"),Pa(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Pa(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){_(document.head,T),n(t,de,e),n(t,re,e),n(t,ce,e),c(k,t,e),n(t,me,e),n(t,j,e),n(t,he,e),n(t,J,e),n(t,ue,e),c(C,t,e),n(t,fe,e),n(t,x,e),n(t,Me,e),c($,t,e),n(t,ye,e),n(t,v,e),n(t,Te,e),n(t,F,e),n(t,ge,e),c(I,t,e),n(t,we,e),n(t,G,e),n(t,be,e),c(R,t,e),n(t,Ue,e),c(Z,t,e),n(t,_e,e),n(t,z,e),n(t,ke,e),c(B,t,e),n(t,je,e),n(t,S,e),n(t,Je,e),c(E,t,e),n(t,Ce,e),n(t,A,e),n(t,xe,e),c(N,t,e),n(t,$e,e),n(t,X,e),n(t,ve,e),c(V,t,e),n(t,Fe,e),n(t,Q,e),n(t,Ie,e),n(t,W,e),n(t,Ge,e),n(t,q,e),n(t,Re,e),c(L,t,e),n(t,Ze,e),n(t,H,e),n(t,ze,e),c(Y,t,e),n(t,Be,e),c(D,t,e),n(t,Se,e),n(t,P,e),n(t,Ee,e),c(O,t,e),n(t,Ae,e),n(t,K,e),n(t,Ne,e),c(tt,t,e),n(t,Xe,e),n(t,et,e),n(t,Ve,e),c(at,t,e),n(t,Qe,e),n(t,nt,e),n(t,We,e),c(st,t,e),n(t,qe,e),n(t,lt,e),n(t,Le,e),c(ot,t,e),n(t,He,e),n(t,it,e),n(t,Ye,e),c(rt,t,e),n(t,De,e),n(t,pt,e),n(t,Pe,e),c(dt,t,e),n(t,Oe,e),n(t,ct,e),n(t,Ke,e),c(mt,t,e),n(t,ta,e),n(t,ht,e),n(t,ea,e),c(ut,t,e),n(t,aa,e),n(t,ft,e),n(t,na,e),c(Mt,t,e),n(t,sa,e),n(t,yt,e),n(t,la,e),c(Tt,t,e),n(t,oa,e),n(t,gt,e),n(t,ia,e),c(wt,t,e),n(t,ra,e),n(t,bt,e),n(t,pa,e),c(Ut,t,e),n(t,da,e),n(t,_t,e),n(t,ca,e),c(kt,t,e),n(t,ma,e),c(jt,t,e),n(t,ha,e),n(t,Jt,e),n(t,ua,e),c(Ct,t,e),n(t,fa,e),n(t,xt,e),n(t,Ma,e),c($t,t,e),n(t,ya,e),n(t,vt,e),n(t,Ta,e),c(Ft,t,e),n(t,ga,e),n(t,It,e),n(t,wa,e),c(Gt,t,e),n(t,ba,e),n(t,Rt,e),n(t,Ua,e),n(t,Zt,e),n(t,_a,e),n(t,zt,e),n(t,ka,e),c(Bt,t,e),n(t,ja,e),n(t,St,e),n(t,Ja,e),c(Et,t,e),n(t,Ca,e),n(t,At,e),n(t,xa,e),c(Nt,t,e),n(t,$a,e),n(t,Xt,e),n(t,va,e),n(t,Vt,e),n(t,Fa,e),c(Qt,t,e),n(t,Ia,e),n(t,Wt,e),n(t,Ga,e),n(t,qt,e),n(t,Ra,e),n(t,w,e),n(t,Za,e),n(t,Lt,e),n(t,za,e),c(Ht,t,e),n(t,Ba,e),n(t,Yt,e),n(t,Sa,e),n(t,b,e),n(t,Ea,e),n(t,Dt,e),n(t,Aa,e),c(Pt,t,e),n(t,Na,e),n(t,Ot,e),n(t,Xa,e),n(t,Kt,e),n(t,Va,e),c(te,t,e),n(t,Qa,e),n(t,g,e),c(ee,g,null),_(g,Oa),_(g,le),n(t,Wa,e),c(ae,t,e),n(t,qa,e),n(t,y,e),c(ne,y,null),_(y,Ka),_(y,oe),_(y,tn),c(se,y,null),_(y,en),_(y,ie),n(t,La,e),n(t,pe,e),Ha=!0},p:ss,i(t){Ha||(m(k.$$.fragment,t),m(C.$$.fragment,t),m($.$$.fragment,t),m(I.$$.fragment,t),m(R.$$.fragment,t),m(Z.$$.fragment,t),m(B.$$.fragment,t),m(E.$$.fragment,t),m(N.$$.fragment,t),m(V.$$.fragment,t),m(L.$$.fragment,t),m(Y.$$.fragment,t),m(D.$$.fragment,t),m(O.$$.fragment,t),m(tt.$$.fragment,t),m(at.$$.fragment,t),m(st.$$.fragment,t),m(ot.$$.fragment,t),m(rt.$$.fragment,t),m(dt.$$.fragment,t),m(mt.$$.fragment,t),m(ut.$$.fragment,t),m(Mt.$$.fragment,t),m(Tt.$$.fragment,t),m(wt.$$.fragment,t),m(Ut.$$.fragment,t),m(kt.$$.fragment,t),m(jt.$$.fragment,t),m(Ct.$$.fragment,t),m($t.$$.fragment,t),m(Ft.$$.fragment,t),m(Gt.$$.fragment,t),m(Bt.$$.fragment,t),m(Et.$$.fragment,t),m(Nt.$$.fragment,t),m(Qt.$$.fragment,t),m(Ht.$$.fragment,t),m(Pt.$$.fragment,t),m(te.$$.fragment,t),m(ee.$$.fragment,t),m(ae.$$.fragment,t),m(ne.$$.fragment,t),m(se.$$.fragment,t),Ha=!0)},o(t){h(k.$$.fragment,t),h(C.$$.fragment,t),h($.$$.fragment,t),h(I.$$.fragment,t),h(R.$$.fragment,t),h(Z.$$.fragment,t),h(B.$$.fragment,t),h(E.$$.fragment,t),h(N.$$.fragment,t),h(V.$$.fragment,t),h(L.$$.fragment,t),h(Y.$$.fragment,t),h(D.$$.fragment,t),h(O.$$.fragment,t),h(tt.$$.fragment,t),h(at.$$.fragment,t),h(st.$$.fragment,t),h(ot.$$.fragment,t),h(rt.$$.fragment,t),h(dt.$$.fragment,t),h(mt.$$.fragment,t),h(ut.$$.fragment,t),h(Mt.$$.fragment,t),h(Tt.$$.fragment,t),h(wt.$$.fragment,t),h(Ut.$$.fragment,t),h(kt.$$.fragment,t),h(jt.$$.fragment,t),h(Ct.$$.fragment,t),h($t.$$.fragment,t),h(Ft.$$.fragment,t),h(Gt.$$.fragment,t),h(Bt.$$.fragment,t),h(Et.$$.fragment,t),h(Nt.$$.fragment,t),h(Qt.$$.fragment,t),h(Ht.$$.fragment,t),h(Pt.$$.fragment,t),h(te.$$.fragment,t),h(ee.$$.fragment,t),h(ae.$$.fragment,t),h(ne.$$.fragment,t),h(se.$$.fragment,t),Ha=!1},d(t){t&&(a(de),a(re),a(ce),a(me),a(j),a(he),a(J),a(ue),a(fe),a(x),a(Me),a(ye),a(v),a(Te),a(F),a(ge),a(we),a(G),a(be),a(Ue),a(_e),a(z),a(ke),a(je),a(S),a(Je),a(Ce),a(A),a(xe),a($e),a(X),a(ve),a(Fe),a(Q),a(Ie),a(W),a(Ge),a(q),a(Re),a(Ze),a(H),a(ze),a(Be),a(Se),a(P),a(Ee),a(Ae),a(K),a(Ne),a(Xe),a(et),a(Ve),a(Qe),a(nt),a(We),a(qe),a(lt),a(Le),a(He),a(it),a(Ye),a(De),a(pt),a(Pe),a(Oe),a(ct),a(Ke),a(ta),a(ht),a(ea),a(aa),a(ft),a(na),a(sa),a(yt),a(la),a(oa),a(gt),a(ia),a(ra),a(bt),a(pa),a(da),a(_t),a(ca),a(ma),a(ha),a(Jt),a(ua),a(fa),a(xt),a(Ma),a(ya),a(vt),a(Ta),a(ga),a(It),a(wa),a(ba),a(Rt),a(Ua),a(Zt),a(_a),a(zt),a(ka),a(ja),a(St),a(Ja),a(Ca),a(At),a(xa),a($a),a(Xt),a(va),a(Vt),a(Fa),a(Ia),a(Wt),a(Ga),a(qt),a(Ra),a(w),a(Za),a(Lt),a(za),a(Ba),a(Yt),a(Sa),a(b),a(Ea),a(Dt),a(Aa),a(Na),a(Ot),a(Xa),a(Kt),a(Va),a(Qa),a(g),a(Wa),a(qa),a(y),a(La),a(pe)),a(T),u(k,t),u(C,t),u($,t),u(I,t),u(R,t),u(Z,t),u(B,t),u(E,t),u(N,t),u(V,t),u(L,t),u(Y,t),u(D,t),u(O,t),u(tt,t),u(at,t),u(st,t),u(ot,t),u(rt,t),u(dt,t),u(mt,t),u(ut,t),u(Mt,t),u(Tt,t),u(wt,t),u(Ut,t),u(kt,t),u(jt,t),u(Ct,t),u($t,t),u(Ft,t),u(Gt,t),u(Bt,t),u(Et,t),u(Nt,t),u(Qt,t),u(Ht,t),u(Pt,t),u(te,t),u(ee),u(ae,t),u(ne),u(se)}}}const ds='{"title":"Supervised Fine-tuning Trainer","local":"supervised-fine-tuning-trainer","sections":[{"title":"Quickstart","local":"quickstart","sections":[],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Train on completions only","local":"train-on-completions-only","sections":[{"title":"Using token_ids directly for response_template","local":"using-tokenids-directly-for-responsetemplate","sections":[],"depth":4}],"depth":3},{"title":"Format your input prompts","local":"format-your-input-prompts","sections":[],"depth":3},{"title":"Packing dataset ( ConstantLengthDataset )","local":"packing-dataset--constantlengthdataset-","sections":[{"title":"Customize your prompts using packed dataset","local":"customize-your-prompts-using-packed-dataset","sections":[],"depth":4}],"depth":3},{"title":"Control over the pretrained model","local":"trl.SFTTrainer","sections":[],"depth":3},{"title":"Training adapters","local":"training-adapters","sections":[],"depth":3},{"title":"Training adapters with base 8 bit models","local":"training-adapters-with-base-8-bit-models","sections":[],"depth":3}],"depth":2},{"title":"Using Flash Attention and Flash Attention 2","local":"using-flash-attention-and-flash-attention-2","sections":[{"title":"Using Flash-Attention 1","local":"using-flash-attention-1","sections":[],"depth":3},{"title":"Using Flash Attention-2","local":"using-flash-attention-2","sections":[],"depth":3},{"title":"Enhance model’s performances using NEFTune","local":"enhance-models-performances-using-neftune","sections":[],"depth":3}],"depth":2},{"title":"Best practices","local":"best-practices","sections":[],"depth":2},{"title":"SFTTrainer","local":"sfttrainer","sections":[],"depth":2},{"title":"ConstantLengthDataset","local":"constantlengthdataset","sections":[{"title":"Answer: {answer}","local":"answer-answer","sections":[],"depth":3}],"depth":2}],"depth":1}';function cs(an){return ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ys extends os{constructor(T){super(),is(this,T,cs,ps,ns,{})}}export{ys as component};
