import{s as pt,f as gt,o as ht,n as Fe}from"../chunks/scheduler.9bc65507.js";import{S as ft,i as ut,g as l,s,r as g,A as bt,h as c,f as o,c as r,j as N,u as h,x as M,k as x,y as p,a as n,v as f,d as u,t as b,w as _}from"../chunks/index.707bf1b6.js";import{T as ct}from"../chunks/Tip.c2ecdbf4.js";import{D as ge}from"../chunks/Docstring.17db21ae.js";import{C as dt}from"../chunks/CodeBlock.54a9f38d.js";import{E as mt}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as he}from"../chunks/Heading.342b1fa6.js";function _t(U){let a,y="The model expects both the image and trimap (concatenated) as input. Use <code>ViTMatteImageProcessor</code> for this purpose.";return{c(){a=l("p"),a.innerHTML=y},l(m){a=c(m,"P",{"data-svelte-h":!0}),M(a)!=="svelte-8i6ct1"&&(a.innerHTML=y)},m(m,d){n(m,a,d)},p:Fe,d(m){m&&o(a)}}}function Mt(U){let a,y="Example:",m,d,v;return d=new dt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpdE1hdHRlQ29uZmlnJTJDJTIwVml0TWF0dGVGb3JJbWFnZU1hdHRpbmclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwVmlUTWF0dGUlMjBodXN0dmwlMkZ2aXRtYXR0ZS1zbWFsbC1jb21wb3NpdGlvbi0xayUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBWaXRNYXR0ZUNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBodXN0dmwlMkZ2aXRtYXR0ZS1zbWFsbC1jb21wb3NpdGlvbi0xayUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwVml0TWF0dGVGb3JJbWFnZU1hdHRpbmcoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VitMatteConfig, VitMatteForImageMatting

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a ViTMatte hustvl/vitmatte-small-composition-1k style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = VitMatteConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the hustvl/vitmatte-small-composition-1k style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VitMatteForImageMatting(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,m=s(),g(d.$$.fragment)},l(i){a=c(i,"P",{"data-svelte-h":!0}),M(a)!=="svelte-11lpom8"&&(a.textContent=y),m=r(i),h(d.$$.fragment,i)},m(i,T){n(i,a,T),n(i,m,T),f(d,i,T),v=!0},p:Fe,i(i){v||(u(d.$$.fragment,i),v=!0)},o(i){b(d.$$.fragment,i),v=!1},d(i){i&&(o(a),o(m)),_(d,i)}}}function vt(U){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=y},l(m){a=c(m,"P",{"data-svelte-h":!0}),M(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(m,d){n(m,a,d)},p:Fe,d(m){m&&o(a)}}}function yt(U){let a,y="Examples:",m,d,v;return d=new dt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpdE1hdHRlSW1hZ2VQcm9jZXNzb3IlMkMlMjBWaXRNYXR0ZUZvckltYWdlTWF0dGluZyUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMFZpdE1hdHRlSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmh1c3R2bCUyRnZpdG1hdHRlLXNtYWxsLWNvbXBvc2l0aW9uLTFrJTIyKSUwQW1vZGVsJTIwJTNEJTIwVml0TWF0dGVGb3JJbWFnZU1hdHRpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmh1c3R2bCUyRnZpdG1hdHRlLXNtYWxsLWNvbXBvc2l0aW9uLTFrJTIyKSUwQSUwQWZpbGVwYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGaW1hZ2UtbWF0dGluZy1maXh0dXJlcyUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyaW1hZ2UucG5nJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUwQSklMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4oZmlsZXBhdGgpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWZpbGVwYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGaW1hZ2UtbWF0dGluZy1maXh0dXJlcyUyMiUyQyUyMGZpbGVuYW1lJTNEJTIydHJpbWFwLnBuZyUyMiUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMEEpJTBBdHJpbWFwJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlcGF0aCkuY29udmVydCglMjJMJTIyKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUyMCUyQiUyMHRyaW1hcCUyMGZvciUyMHRoZSUyMG1vZGVsJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwdHJpbWFwcyUzRHRyaW1hcCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGFscGhhcyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5hbHBoYXMlMEFwcmludChhbHBoYXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VitMatteImageProcessor, VitMatteForImageMatting
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = VitMatteImageProcessor.from_pretrained(<span class="hljs-string">&quot;hustvl/vitmatte-small-composition-1k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VitMatteForImageMatting.from_pretrained(<span class="hljs-string">&quot;hustvl/vitmatte-small-composition-1k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>filepath = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/image-matting-fixtures&quot;</span>, filename=<span class="hljs-string">&quot;image.png&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(filepath).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>filepath = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/image-matting-fixtures&quot;</span>, filename=<span class="hljs-string">&quot;trimap.png&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>trimap = Image.<span class="hljs-built_in">open</span>(filepath).convert(<span class="hljs-string">&quot;L&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image + trimap for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, trimaps=trimap, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    alphas = model(**inputs).alphas
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(alphas.shape)
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">640</span>, <span class="hljs-number">960</span>])`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,m=s(),g(d.$$.fragment)},l(i){a=c(i,"P",{"data-svelte-h":!0}),M(a)!=="svelte-kvfsh7"&&(a.textContent=y),m=r(i),h(d.$$.fragment,i)},m(i,T){n(i,a,T),n(i,m,T),f(d,i,T),v=!0},p:Fe,i(i){v||(u(d.$$.fragment,i),v=!0)},o(i){b(d.$$.fragment,i),v=!1},d(i){i&&(o(a),o(m)),_(d,i)}}}function Tt(U){let a,y,m,d,v,i,T,ue,R,Ye=`The ViTMatte model was proposed in <a href="https://arxiv.org/abs/2305.15272" rel="nofollow">Boosting Image Matting with Pretrained Plain Vision Transformers</a> by Jingfeng Yao, Xinggang Wang, Shusheng Yang, Baoyuan Wang.
ViTMatte leverages plain <a href="vit">Vision Transformers</a> for the task of image matting, which is the process of accurately estimating the foreground object in images and videos.`,be,H,De="The abstract from the paper is the following:",_e,L,Qe="<em>Recently, plain vision Transformers (ViTs) have shown impressive performance on various computer vision tasks, thanks to their strong modeling capacity and large-scale pretraining. However, they have not yet conquered the problem of image matting. We hypothesize that image matting could also be boosted by ViTs and present a new efficient and robust ViT-based matting system, named ViTMatte. Our method utilizes (i) a hybrid attention mechanism combined with a convolution neck to help ViTs achieve an excellent performance-computation trade-off in matting tasks. (ii) Additionally, we introduce the detail capture module, which just consists of simple lightweight convolutions to complement the detailed information required by matting. To the best of our knowledge, ViTMatte is the first work to unleash the potential of ViT on image matting with concise adaptation. It inherits many superior properties from ViT to matting, including various pretraining strategies, concise architecture design, and flexible inference strategies. We evaluate ViTMatte on Composition-1k and Distinctions-646, the most commonly used benchmark for image matting, our method achieves state-of-the-art performance and outperforms prior matting works by a large margin.</em>",Me,S,Ae=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/hustvl/ViTMatte" rel="nofollow">here</a>.`,ve,J,Oe,ye,E,Ke='ViTMatte high-level overview. Taken from the <a href="https://arxiv.org/abs/2305.15272">original paper.</a>',Te,B,we,X,et="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with ViTMatte.",$e,q,tt='<li>A demo notebook regarding inference with <a href="/docs/transformers/main/en/model_doc/vitmatte#transformers.VitMatteForImageMatting">VitMatteForImageMatting</a>, including background replacement, can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/ViTMatte" rel="nofollow">here</a>.</li>',Ve,j,Ce,Y,Ie,w,D,ze,se,ot=`This is the configuration class to store the configuration of <a href="/docs/transformers/main/en/model_doc/vitmatte#transformers.VitMatteForImageMatting">VitMatteForImageMatting</a>. It is used to
instantiate a ViTMatte model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the ViTMatte
<a href="https://huggingface.co/hustvl/vitmatte-small-composition-1k" rel="nofollow">hustvl/vitmatte-small-composition-1k</a> architecture.`,Ze,re,at=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Pe,W,Ge,F,Q,Ne,ie,nt=`Serializes this instance to a Python dictionary. Override the default <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig.to_dict">to_dict()</a>. Returns:
<code>Dict[str, any]</code>: Dictionary of all the attributes that make up this configuration instance,`,xe,A,Ue,C,O,Re,le,st="Constructs a ViTMatte image processor.",He,z,K,Le,ce,rt="Preprocess an image or batch of images.",ke,ee,Je,I,te,Se,me,it="ViTMatte framework leveraging any vision backbone e.g. for ADE20k, CityScapes.",Ee,V,oe,Be,de,lt='The <a href="/docs/transformers/main/en/model_doc/vitmatte#transformers.VitMatteForImageMatting">VitMatteForImageMatting</a> forward method, overrides the <code>__call__</code> special method.',Xe,Z,qe,P,je,fe,We;return v=new he({props:{title:"ViTMatte",local:"vitmatte",headingTag:"h1"}}),T=new he({props:{title:"Overview",local:"overview",headingTag:"h2"}}),B=new he({props:{title:"Resources",local:"resources",headingTag:"h2"}}),j=new ct({props:{$$slots:{default:[_t]},$$scope:{ctx:U}}}),Y=new he({props:{title:"VitMatteConfig",local:"transformers.VitMatteConfig",headingTag:"h2"}}),D=new ge({props:{name:"class transformers.VitMatteConfig",anchor:"transformers.VitMatteConfig",parameters:[{name:"backbone_config",val:": PretrainedConfig = None"},{name:"backbone",val:" = None"},{name:"use_pretrained_backbone",val:" = False"},{name:"use_timm_backbone",val:" = False"},{name:"backbone_kwargs",val:" = None"},{name:"hidden_size",val:": int = 384"},{name:"batch_norm_eps",val:": float = 1e-05"},{name:"initializer_range",val:": float = 0.02"},{name:"convstream_hidden_sizes",val:": List = [48, 96, 192]"},{name:"fusion_hidden_sizes",val:": List = [256, 128, 64, 32]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VitMatteConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>, defaults to <code>VitDetConfig()</code>) &#x2014;
The configuration of the backbone model.`,name:"backbone_config"},{anchor:"transformers.VitMatteConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.VitMatteConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.VitMatteConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to load <code>backbone</code> from the timm library. If <code>False</code>, the backbone is loaded from the transformers
library.`,name:"use_timm_backbone"},{anchor:"transformers.VitMatteConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.VitMatteConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
The number of input channels of the decoder.`,name:"hidden_size"},{anchor:"transformers.VitMatteConfig.batch_norm_eps",description:`<strong>batch_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the batch norm layers.`,name:"batch_norm_eps"},{anchor:"transformers.VitMatteConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.VitMatteConfig.convstream_hidden_sizes",description:`<strong>convstream_hidden_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[48, 96, 192]</code>) &#x2014;
The output channels of the ConvStream module.`,name:"convstream_hidden_sizes"},{anchor:"transformers.VitMatteConfig.fusion_hidden_sizes",description:`<strong>fusion_hidden_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[256, 128, 64, 32]</code>) &#x2014;
The output channels of the Fusion blocks.`,name:"fusion_hidden_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitmatte/configuration_vitmatte.py#L31"}}),W=new mt({props:{anchor:"transformers.VitMatteConfig.example",$$slots:{default:[Mt]},$$scope:{ctx:U}}}),Q=new ge({props:{name:"to_dict",anchor:"transformers.VitMatteConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitmatte/configuration_vitmatte.py#L128"}}),A=new he({props:{title:"VitMatteImageProcessor",local:"transformers.VitMatteImageProcessor",headingTag:"h2"}}),O=new ge({props:{name:"class transformers.VitMatteImageProcessor",anchor:"transformers.VitMatteImageProcessor",parameters:[{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_pad",val:": bool = True"},{name:"size_divisibility",val:": int = 32"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VitMatteImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.VitMatteImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.VitMatteImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.VitMatteImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.VitMatteImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.VitMatteImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image to make the width and height divisible by <code>size_divisibility</code>. Can be overridden
by the <code>do_pad</code> parameter in the <code>preprocess</code> method.`,name:"do_pad"},{anchor:"transformers.VitMatteImageProcessor.size_divisibility",description:`<strong>size_divisibility</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The width and height of the image will be padded to be divisible by this number.`,name:"size_divisibility"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitmatte/image_processing_vitmatte.py#L43"}}),K=new ge({props:{name:"preprocess",anchor:"transformers.VitMatteImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"trimaps",val:": Union"},{name:"do_rescale",val:": Optional = None"},{name:"rescale_factor",val:": Optional = None"},{name:"do_normalize",val:": Optional = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"do_pad",val:": Optional = None"},{name:"size_divisibility",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": Union = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VitMatteImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.VitMatteImageProcessor.preprocess.trimaps",description:`<strong>trimaps</strong> (<code>ImageInput</code>) &#x2014;
Trimap to preprocess.`,name:"trimaps"},{anchor:"transformers.VitMatteImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.VitMatteImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.VitMatteImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.VitMatteImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.VitMatteImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_std"},{anchor:"transformers.VitMatteImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the image.`,name:"do_pad"},{anchor:"transformers.VitMatteImageProcessor.preprocess.size_divisibility",description:`<strong>size_divisibility</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.size_divisibility</code>) &#x2014;
The size divisibility to pad the image to if <code>do_pad</code> is set to <code>True</code>.`,name:"size_divisibility"},{anchor:"transformers.VitMatteImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.VitMatteImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.VitMatteImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitmatte/image_processing_vitmatte.py#L147"}}),ee=new he({props:{title:"VitMatteForImageMatting",local:"transformers.VitMatteForImageMatting",headingTag:"h2"}}),te=new ge({props:{name:"class transformers.VitMatteForImageMatting",anchor:"transformers.VitMatteForImageMatting",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.VitMatteForImageMatting.This",description:"<strong>This</strong> model is a PyTorch [torch.nn.Module](https &#x2014;//pytorch.org/docs/stable/nn.html#torch.nn.Module) sub-class. Use",name:"This"},{anchor:"transformers.VitMatteForImageMatting.it",description:`<strong>it</strong> as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and &#x2014;
behavior. &#x2014;
config (<a href="/docs/transformers/main/en/model_doc/upernet#transformers.UperNetConfig">UperNetConfig</a>): Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"it"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitmatte/modeling_vitmatte.py#L249"}}),oe=new ge({props:{name:"forward",anchor:"transformers.VitMatteForImageMatting.forward",parameters:[{name:"pixel_values",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.VitMatteForImageMatting.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuImageProcessor.__call__">VitMatteImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.VitMatteForImageMatting.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers in case the backbone has them. See
<code>attentions</code> under returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VitMatteForImageMatting.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers of the backbone. See <code>hidden_states</code> under
returned tensors for more detail.`,name:"output_hidden_states"},{anchor:"transformers.VitMatteForImageMatting.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.VitMatteForImageMatting.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth image matting for computing the loss.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitmatte/modeling_vitmatte.py#L264",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.vitmatte.modeling_vitmatte.ImageMattingOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/vitmatte#transformers.VitMatteConfig"
>VitMatteConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Loss.</p>
</li>
<li>
<p><strong>alphas</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Estimated alpha values.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.vitmatte.modeling_vitmatte.ImageMattingOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Z=new ct({props:{$$slots:{default:[vt]},$$scope:{ctx:U}}}),P=new mt({props:{anchor:"transformers.VitMatteForImageMatting.forward.example",$$slots:{default:[yt]},$$scope:{ctx:U}}}),{c(){a=l("meta"),y=s(),m=l("p"),d=s(),g(v.$$.fragment),i=s(),g(T.$$.fragment),ue=s(),R=l("p"),R.innerHTML=Ye,be=s(),H=l("p"),H.textContent=De,_e=s(),L=l("p"),L.innerHTML=Qe,Me=s(),S=l("p"),S.innerHTML=Ae,ve=s(),J=l("img"),ye=s(),E=l("small"),E.innerHTML=Ke,Te=s(),g(B.$$.fragment),we=s(),X=l("p"),X.textContent=et,$e=s(),q=l("ul"),q.innerHTML=tt,Ve=s(),g(j.$$.fragment),Ce=s(),g(Y.$$.fragment),Ie=s(),w=l("div"),g(D.$$.fragment),ze=s(),se=l("p"),se.innerHTML=ot,Ze=s(),re=l("p"),re.innerHTML=at,Pe=s(),g(W.$$.fragment),Ge=s(),F=l("div"),g(Q.$$.fragment),Ne=s(),ie=l("p"),ie.innerHTML=nt,xe=s(),g(A.$$.fragment),Ue=s(),C=l("div"),g(O.$$.fragment),Re=s(),le=l("p"),le.textContent=st,He=s(),z=l("div"),g(K.$$.fragment),Le=s(),ce=l("p"),ce.textContent=rt,ke=s(),g(ee.$$.fragment),Je=s(),I=l("div"),g(te.$$.fragment),Se=s(),me=l("p"),me.textContent=it,Ee=s(),V=l("div"),g(oe.$$.fragment),Be=s(),de=l("p"),de.innerHTML=lt,Xe=s(),g(Z.$$.fragment),qe=s(),g(P.$$.fragment),je=s(),fe=l("p"),this.h()},l(e){const t=bt("svelte-u9bgzb",document.head);a=c(t,"META",{name:!0,content:!0}),t.forEach(o),y=r(e),m=c(e,"P",{}),N(m).forEach(o),d=r(e),h(v.$$.fragment,e),i=r(e),h(T.$$.fragment,e),ue=r(e),R=c(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1oupqpp"&&(R.innerHTML=Ye),be=r(e),H=c(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-vfdo9a"&&(H.textContent=De),_e=r(e),L=c(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-ejbjbx"&&(L.innerHTML=Qe),Me=r(e),S=c(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-cgl4x9"&&(S.innerHTML=Ae),ve=r(e),J=c(e,"IMG",{src:!0,alt:!0,width:!0}),ye=r(e),E=c(e,"SMALL",{"data-svelte-h":!0}),M(E)!=="svelte-htuduo"&&(E.innerHTML=Ke),Te=r(e),h(B.$$.fragment,e),we=r(e),X=c(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1h6mpjr"&&(X.textContent=et),$e=r(e),q=c(e,"UL",{"data-svelte-h":!0}),M(q)!=="svelte-v530fr"&&(q.innerHTML=tt),Ve=r(e),h(j.$$.fragment,e),Ce=r(e),h(Y.$$.fragment,e),Ie=r(e),w=c(e,"DIV",{class:!0});var $=N(w);h(D.$$.fragment,$),ze=r($),se=c($,"P",{"data-svelte-h":!0}),M(se)!=="svelte-12czi7a"&&(se.innerHTML=ot),Ze=r($),re=c($,"P",{"data-svelte-h":!0}),M(re)!=="svelte-o55m63"&&(re.innerHTML=at),Pe=r($),h(W.$$.fragment,$),Ge=r($),F=c($,"DIV",{class:!0});var ae=N(F);h(Q.$$.fragment,ae),Ne=r(ae),ie=c(ae,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-f91b28"&&(ie.innerHTML=nt),ae.forEach(o),$.forEach(o),xe=r(e),h(A.$$.fragment,e),Ue=r(e),C=c(e,"DIV",{class:!0});var k=N(C);h(O.$$.fragment,k),Re=r(k),le=c(k,"P",{"data-svelte-h":!0}),M(le)!=="svelte-ohhgeg"&&(le.textContent=st),He=r(k),z=c(k,"DIV",{class:!0});var ne=N(z);h(K.$$.fragment,ne),Le=r(ne),ce=c(ne,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-1x3yxsa"&&(ce.textContent=rt),ne.forEach(o),k.forEach(o),ke=r(e),h(ee.$$.fragment,e),Je=r(e),I=c(e,"DIV",{class:!0});var pe=N(I);h(te.$$.fragment,pe),Se=r(pe),me=c(pe,"P",{"data-svelte-h":!0}),M(me)!=="svelte-hfzn9x"&&(me.textContent=it),Ee=r(pe),V=c(pe,"DIV",{class:!0});var G=N(V);h(oe.$$.fragment,G),Be=r(G),de=c(G,"P",{"data-svelte-h":!0}),M(de)!=="svelte-frucsj"&&(de.innerHTML=lt),Xe=r(G),h(Z.$$.fragment,G),qe=r(G),h(P.$$.fragment,G),G.forEach(o),pe.forEach(o),je=r(e),fe=c(e,"P",{}),N(fe).forEach(o),this.h()},h(){x(a,"name","hf:doc:metadata"),x(a,"content",wt),gt(J.src,Oe="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/vitmatte_architecture.png")||x(J,"src",Oe),x(J,"alt","drawing"),x(J,"width","600"),x(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,a),n(e,y,t),n(e,m,t),n(e,d,t),f(v,e,t),n(e,i,t),f(T,e,t),n(e,ue,t),n(e,R,t),n(e,be,t),n(e,H,t),n(e,_e,t),n(e,L,t),n(e,Me,t),n(e,S,t),n(e,ve,t),n(e,J,t),n(e,ye,t),n(e,E,t),n(e,Te,t),f(B,e,t),n(e,we,t),n(e,X,t),n(e,$e,t),n(e,q,t),n(e,Ve,t),f(j,e,t),n(e,Ce,t),f(Y,e,t),n(e,Ie,t),n(e,w,t),f(D,w,null),p(w,ze),p(w,se),p(w,Ze),p(w,re),p(w,Pe),f(W,w,null),p(w,Ge),p(w,F),f(Q,F,null),p(F,Ne),p(F,ie),n(e,xe,t),f(A,e,t),n(e,Ue,t),n(e,C,t),f(O,C,null),p(C,Re),p(C,le),p(C,He),p(C,z),f(K,z,null),p(z,Le),p(z,ce),n(e,ke,t),f(ee,e,t),n(e,Je,t),n(e,I,t),f(te,I,null),p(I,Se),p(I,me),p(I,Ee),p(I,V),f(oe,V,null),p(V,Be),p(V,de),p(V,Xe),f(Z,V,null),p(V,qe),f(P,V,null),n(e,je,t),n(e,fe,t),We=!0},p(e,[t]){const $={};t&2&&($.$$scope={dirty:t,ctx:e}),j.$set($);const ae={};t&2&&(ae.$$scope={dirty:t,ctx:e}),W.$set(ae);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),Z.$set(k);const ne={};t&2&&(ne.$$scope={dirty:t,ctx:e}),P.$set(ne)},i(e){We||(u(v.$$.fragment,e),u(T.$$.fragment,e),u(B.$$.fragment,e),u(j.$$.fragment,e),u(Y.$$.fragment,e),u(D.$$.fragment,e),u(W.$$.fragment,e),u(Q.$$.fragment,e),u(A.$$.fragment,e),u(O.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(oe.$$.fragment,e),u(Z.$$.fragment,e),u(P.$$.fragment,e),We=!0)},o(e){b(v.$$.fragment,e),b(T.$$.fragment,e),b(B.$$.fragment,e),b(j.$$.fragment,e),b(Y.$$.fragment,e),b(D.$$.fragment,e),b(W.$$.fragment,e),b(Q.$$.fragment,e),b(A.$$.fragment,e),b(O.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(oe.$$.fragment,e),b(Z.$$.fragment,e),b(P.$$.fragment,e),We=!1},d(e){e&&(o(y),o(m),o(d),o(i),o(ue),o(R),o(be),o(H),o(_e),o(L),o(Me),o(S),o(ve),o(J),o(ye),o(E),o(Te),o(we),o(X),o($e),o(q),o(Ve),o(Ce),o(Ie),o(w),o(xe),o(Ue),o(C),o(ke),o(Je),o(I),o(je),o(fe)),o(a),_(v,e),_(T,e),_(B,e),_(j,e),_(Y,e),_(D),_(W),_(Q),_(A,e),_(O),_(K),_(ee,e),_(te),_(oe),_(Z),_(P)}}}const wt='{"title":"ViTMatte","local":"vitmatte","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"VitMatteConfig","local":"transformers.VitMatteConfig","sections":[],"depth":2},{"title":"VitMatteImageProcessor","local":"transformers.VitMatteImageProcessor","sections":[],"depth":2},{"title":"VitMatteForImageMatting","local":"transformers.VitMatteForImageMatting","sections":[],"depth":2}],"depth":1}';function $t(U){return ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jt extends ft{constructor(a){super(),ut(this,a,$t,Tt,pt,{})}}export{jt as component};
