import{s as $n,n as xn,o as Fn}from"../chunks/scheduler.9039eef2.js";import{S as vn,i as In,g as o,s,r as p,A as Gn,h as r,f as a,c as l,j as Fa,u as d,x as i,k as va,y as b,a as n,v as c,d as m,t as u,w as h}from"../chunks/index.ded8f90d.js";import{D as Cn}from"../chunks/Docstring.a2ba2b54.js";import{C as f}from"../chunks/CodeBlock.8580f3e8.js";import{H as M}from"../chunks/Heading.f027f30d.js";function Rn(za){let T,te,Ot,ee,U,ae,_,Ba="Supervised fine-tuning (or SFT for short) is a crucial step in RLHF. In TRL we provide an easy-to-use API to create your SFT models and train them with few lines of code on your dataset.",ne,k,Aa='Check out a complete flexible example inside <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/sft.py" rel="nofollow"><code>examples/scripts</code></a> folder.',se,J,le,j,Sa=`If you have a dataset hosted on the 🤗 Hub, you can easily fine-tune your SFT model using <a href="/docs/trl/v0.7.2/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> from TRL. Let us assume your dataset is <code>imdb</code>, the text you want to predict is inside the <code>text</code> field of the dataset, and you want to fine-tune the <code>facebook/opt-350m</code> model.
The following code-snippet takes care of all the data pre-processing and training for you:`,oe,C,re,$,Xa="Make sure to pass a correct value for <code>max_seq_length</code> as the default value will be set to <code>min(tokenizer.model_max_length, 1024)</code>.",ie,x,Va="You can also construct a model outside of the trainer and pass it as follows:",pe,F,de,v,Na='The above snippets will use the default training arguments from the <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments" rel="nofollow"><code>transformers.TrainingArguments</code></a> class. If you want to modify that, make sure to create your own <code>TrainingArguments</code> object and pass it to the <a href="/docs/trl/v0.7.2/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> constructor as it is done on the <a href="https://github.com/huggingface/trl/blob/main/examples/stack_llama/scripts/supervised_finetuning.py" rel="nofollow"><code>supervised_finetuning.py</code> script</a> on the stack-llama example.',ce,I,me,G,ue,R,Qa=`You can use the <code>DataCollatorForCompletionOnlyLM</code> to train your model on the generated prompts only. Note that this works only in the case when <code>packing=False</code>.
To instantiate that collator for instruction data, pass a response template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on completions only on the CodeAlpaca dataset:`,he,Z,fe,z,Ea="To instantiate that collator for assistant style conversation data, pass a response template, an instruction template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on assistant completions only on the Open Assistant Guanaco dataset:",Me,B,ye,A,Te,S,Wa="Some tokenizers like Llama 2 (<code>meta-llama/Llama-2-XXb-hf</code>) tokenize sequences differently depending whether they have context or not. For example:",ge,X,we,V,qa="In this case, and due to lack of context in <code>response_template</code>, the same string (”### Assistant:”) is tokenized differently:",be,N,Ya="<li>Text (with context): <code>[2277, 29937, 4007, 22137, 29901]</code></li> <li><code>response_template</code> (without context): <code>[835, 4007, 22137, 29901]</code></li>",Ue,Q,La="This will lead to an error when the <code>DataCollatorForCompletionOnlyLM</code> does not find the <code>response_template</code> in the dataset example text:",_e,E,ke,W,Ha="To solve this, you can tokenize the <code>response_template</code> with the same context than in the dataset, truncate it as needed and pass the <code>token_ids</code> directly to the <code>response_template</code> argument of the <code>DataCollatorForCompletionOnlyLM</code> class. For example:",Je,q,je,Y,Ce,L,Da=`For instruction fine-tuning, it is quite common to have two columns inside the dataset: one for the prompt &amp; the other for the response.
This allows people to format examples like <a href="https://github.com/tatsu-lab/stanford_alpaca" rel="nofollow">Stanford-Alpaca</a> did as follows:`,$e,H,xe,D,Pa="Let us assume your dataset has two fields, <code>question</code> and <code>answer</code>. Therefore you can just run:",Fe,P,ve,O,Oa='To preperly format your input make sure to process all the examples by looping over them and returning a list of processed text. Check out a full example on how to use SFTTrainer on alpaca dataset <a href="https://github.com/huggingface/trl/pull/444#issue-1760952763" rel="nofollow">here</a>',Ie,K,Ge,tt,Ka='<a href="/docs/trl/v0.7.2/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> supports <em>example packing</em>, where multiple short examples are packed in the same input sequence to increase training efficiency. This is done with the <code>ConstantLengthDataset</code> utility class that returns constant length chunks of tokens from a stream of examples. To enable the usage of this dataset class, simply pass <code>packing=True</code> to the <a href="/docs/trl/v0.7.2/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> constructor.',Re,et,Ze,at,tn="Note that if you use a packed dataset and if you pass <code>max_steps</code> in the training arguments you will probably train your models for more than few epochs, depending on the way you have configured the packed dataset and the training protocol. Double check that you know and understand what you are doing.",ze,nt,Be,st,en="If your dataset has several fields that you want to combine, for example if the dataset has <code>question</code> and <code>answer</code> fields and you want to combine them, you can pass a formatting function to the trainer that will take care of that. For example:",Ae,lt,Se,ot,an='You can also customize the <code>ConstantLengthDataset</code> much more by directly passing the arguments to the <a href="/docs/trl/v0.7.2/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> constructor. Please refer to that class’ signature for more information.',Xe,rt,Ve,it,nn='You can directly pass the kwargs of the <code>from_pretrained()</code> method to the <a href="/docs/trl/v0.7.2/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>. For example, if you want to load a model in a different precision, analogous to',Ne,pt,Qe,dt,sn="Note that all keyword arguments of <code>from_pretrained()</code> are supported.",Ee,ct,We,mt,ln="We also support a tight integration with 🤗 PEFT library so that any user can conveniently train adapters and share them on the Hub instead of training the entire model",qe,ut,Ye,ht,on="Note that in case of training adapters, we manually add a saving callback to automatically save the adapters only:",Le,ft,He,Mt,rn="If you want to add more callbacks, make sure to add this one as well to properly save the adapters only during training.",De,yt,Pe,Tt,pn="You can also continue training your <code>PeftModel</code>. For that, first load a <code>PeftModel</code> outside <code>SFTTrainer</code> and pass it directly to the trainer without the <code>peft_config</code> argument being passed.",Oe,gt,Ke,wt,dn="For that you need to first load your 8bit model outside the Trainer and pass a <code>PeftConfig</code> to the trainer. For example:",ta,bt,ea,Ut,aa,_t,cn=`You can benefit from Flash Attention 1 & 2 using SFTTrainer out of the box with minimal changes of code.
First, to make sure you have all the latest features from transformers, install transformers from source`,na,kt,sa,Jt,mn=`Note that Flash Attention only works on GPU now and under half-precision regime (when using adapters, base model loaded in half-precision)
Note also both features are perfectly compatible with other tools such as quantization.`,la,jt,oa,Ct,un="For Flash Attention 1 you can use the <code>BetterTransformer</code> API and force-dispatch the API to use Flash Attention kernel. First, install the latest optimum package:",ra,$t,ia,xt,hn="Once you have loaded your model, wrap the <code>trainer.train()</code> call under the <code>with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</code> context manager:",pa,Ft,da,vt,fn="Note that you cannot train your model using Flash Attention 1 on an arbitrary dataset as <code>torch.scaled_dot_product_attention</code> does not support training with padding tokens if you use Flash Attention kernels. Therefore you can only use that feature with <code>packing=True</code>. If your dataset contains padding tokens, consider switching to Flash Attention 2 integration.",ca,It,Mn="Below are some numbers you can get in terms of speedup and memory efficiency, using Flash Attention 1, on a single NVIDIA-T4 16GB.",ma,Gt,yn="<thead><tr><th>use_flash_attn_1</th> <th>model_name</th> <th>max_seq_len</th> <th>batch_size</th> <th>time per training step</th></tr></thead> <tbody><tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td>~59.1s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td><strong>OOM</strong></td></tr> <tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~30.3s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~148.9s</td></tr></tbody>",ua,Rt,ha,Zt,Tn="To use Flash Attention 2, first install the latest <code>flash-attn</code> package:",fa,zt,Ma,Bt,gn="And add <code>use_flash_attention_2=True</code> when calling <code>from_pretrained</code>:",ya,At,Ta,St,wn=`If you don’t use quantization, make sure your model is loaded in half-precision and dispatch your model on a supported GPU device.
After loading your model, you can either train it as it is, or attach adapters and train adapters on it in case your model is quantized.`,ga,Xt,bn="In contrary to Flash Attention 1, the integration makes it possible to train your model on an arbitrary dataset that also includes padding tokens.",wa,Vt,ba,Nt,Un="Pay attention to the following best practices when training a model with that trainer:",Ua,Qt,_n='<li><a href="/docs/trl/v0.7.2/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> always pads by default the sequences to the <code>max_seq_length</code> argument of the <a href="/docs/trl/v0.7.2/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>. If none is passed, the trainer will retrieve that value from the tokenizer. Some tokenizers do not provide default value, so there is a check to retrieve the minimum between 2048 and that value. Make sure to check it before training.</li> <li>For training adapters in 8bit, you might need to tweak the arguments of the <code>prepare_model_for_kbit_training</code> method from PEFT, hence we advise users to use <code>prepare_in_int8_kwargs</code> field, or create the <code>PeftModel</code> outside the <a href="/docs/trl/v0.7.2/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> and pass it.</li> <li>For a more memory-efficient training using adapters, you can load the base model in 8bit, for that simply add <code>load_in_8bit</code> argument when creating the <a href="/docs/trl/v0.7.2/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>, or create a base model in 8bit outside the trainer and pass it.</li> <li>If you create a model outside the trainer, make sure to not pass to the trainer any additional keyword arguments that are relative to <code>from_pretrained()</code> method.</li>',_a,Et,ka,g,Wt,Ia,Ht,kn=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,Ja,qt,ja,y,Yt,Ga,Dt,Jn=`Iterable dataset that returns constant length chunks of tokens from stream of text files.
The dataset also formats the text before tokenization with a specific format that is provided
by the user.`,Ra,Lt,Za,Pt,jn=`”<code>infinite (</code>bool<code>, *optional*, defaults to </code>False<code>): If True the iterator is reset after dataset reaches end else stops. seq_length (</code>int<code>, *optional*, defaults to </code>1024<code>): Length of token sequences to return. num_of_sequences (</code>int<code>, *optional*, defaults to </code>1024<code>): Number of token sequences to keep in buffer. chars_per_token (</code>int<code>, *optional*, defaults to </code>3.6<code>): Number of characters per token used to estimate number of tokens in text buffer. eos_token_id (</code>int<code>, *optional*, defaults to </code>0\`):
Id of the end of sequence token if the passed tokenizer does not have an EOS token.
shuffle (‘bool’, <em>optional</em>, defaults to True)
Shuffle the examples before they are returned`,Ca,Kt,$a;return U=new M({props:{title:"Supervised Fine-tuning Trainer",local:"supervised-fine-tuning-trainer",headingTag:"h1"}}),J=new M({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),C=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)
trainer.train()`,wrap:!1}}),F=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)

trainer.train()`,wrap:!1}}),I=new M({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),G=new M({props:{title:"Train on completions only",local:"train-on-completions-only",headingTag:"h3"}}),Z=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybHVjYXNtY2NhYmUtbG1pJTJGQ29kZUFscGFjYS0yMGslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFkZWYlMjBmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyhleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF90ZXh0cyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihleGFtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTVCaSU1RCU3RCU1Q24lMjAlMjMlMjMlMjMlMjBBbnN3ZXIlM0ElMjAlN0JleGFtcGxlJTVCJ291dHB1dCclNUQlNUJpJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X3RleHRzLmFwcGVuZCh0ZXh0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dF90ZXh0cyUwQSUwQXJlc3BvbnNlX3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIwJTIzJTIzJTIzJTIwQW5zd2VyJTNBJTIyJTBBY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JDb21wbGV0aW9uT25seUxNKHJlc3BvbnNlX3RlbXBsYXRlJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBmb3JtYXR0aW5nX2Z1bmMlM0Rmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCklMjA=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;lucasmccabe-lmi/CodeAlpaca-20k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;instruction&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;output&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

response_template = <span class="hljs-string">&quot; ### Answer:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(response_template, tokenizer=tokenizer)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
    data_collator=collator,
)

trainer.train() `,wrap:!1}}),B=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydGltZGV0dG1lcnMlMkZvcGVuYXNzaXN0YW50LWd1YW5hY28lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEh1bWFuJTNBJTIyJTBBcmVzcG9uc2VfdGVtcGxhdGUlMjAlM0QlMjAlMjIlMjMlMjMlMjMlMjBBc3Npc3RhbnQlM0ElMjIlMEFjb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvckNvbXBsZXRpb25Pbmx5TE0oaW5zdHJ1Y3Rpb25fdGVtcGxhdGUlM0RpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyQyUyMHJlc3BvbnNlX3RlbXBsYXRlJTNEcmVzcG9uc2VfdGVtcGxhdGUlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBtbG0lM0RGYWxzZSklMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCklMjA=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;timdettmers/openassistant-guanaco&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

instruction_template = <span class="hljs-string">&quot;### Human:&quot;</span>
response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(instruction_template=instruction_template, response_template=response_template, tokenizer=tokenizer, mlm=<span class="hljs-literal">False</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    data_collator=collator,
)

trainer.train() `,wrap:!1}}),A=new M({props:{title:"Using token_ids directly for response_template",local:"using-tokenids-directly-for-responsetemplate",headingTag:"h4"}}),X=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEElMEFkZWYlMjBwcmludF90b2tlbnNfd2l0aF9pZHModHh0KSUzQSUwQSUyMCUyMCUyMCUyMHRva2VucyUyMCUzRCUyMHRva2VuaXplci50b2tlbml6ZSh0eHQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSklMEElMjAlMjAlMjAlMjB0b2tlbl9pZHMlMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKHR4dCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMHByaW50KGxpc3QoemlwKHRva2VucyUyQyUyMHRva2VuX2lkcykpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUyMyUyMyUyMyUyMFVzZXIlM0ElMjBIZWxsbyU1Q24lNUNuJTIzJTIzJTIzJTIwQXNzaXN0YW50JTNBJTIwSGklMkMlMjBob3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUzRiUyMiUyMiUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhwcm9tcHQpJTIwJTIwJTIzJTIwJTVCLi4uJTJDJTIwKCclRTIlOTYlODFIZWxsbyclMkMlMjAxNTA0MyklMkMlMjAoJyUzQzB4MEElM0UnJTJDJTIwMTMpJTJDJTIwKCclM0MweDBBJTNFJyUyQyUyMDEzKSUyQyUyMCgnJTIzJTIzJyUyQyUyMDIyNzcpJTJDJTIwKCclMjMnJTJDJTIwMjk5MzcpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklMkMlMjAuLi4lNUQlMEElMEFyZXNwb25zZV90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhyZXNwb25zZV90ZW1wbGF0ZSklMjAlMjAlMjMlMjAlNUIoJyVFMiU5NiU4MSUyMyUyMyUyMyclMkMlMjA4MzUpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_tokens_with_ids</span>(<span class="hljs-params">txt</span>):
    tokens = tokenizer.tokenize(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    token_ids = tokenizer.encode(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(<span class="hljs-built_in">zip</span>(tokens, token_ids)))

prompt = <span class="hljs-string">&quot;&quot;&quot;### User: Hello\\n\\n### Assistant: Hi, how can I help you?&quot;&quot;&quot;</span>
print_tokens_with_ids(prompt)  <span class="hljs-comment"># [..., (&#x27;▁Hello&#x27;, 15043), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;##&#x27;, 2277), (&#x27;#&#x27;, 29937), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901), ...]</span>

response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
print_tokens_with_ids(response_template)  <span class="hljs-comment"># [(&#x27;▁###&#x27;, 835), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901)]</span>`,wrap:!1}}),E=new f({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ291bGQlMjBub3QlMjBmaW5kJTIwcmVzcG9uc2UlMjBrZXklMjAlNUI4MzUlMkMlMjA0MDA3JTJDJTIwMjIxMzclMkMlMjAyOTkwMSU1RCUyMGluJTIwdG9rZW4lMjBJRHMlMjB0ZW5zb3IoJTVCJTIwJTIwJTIwJTIwMSUyQyUyMCUyMCUyMDgzNSUyQyUyMCUyMC4uLiU1RCklMjAlMjAlMjA=",highlighted:'RuntimeError: Could not find response key <span class="hljs-selector-attr">[835, 4007, 22137, 29901]</span> <span class="hljs-keyword">in</span> token IDs <span class="hljs-built_in">tensor</span>(<span class="hljs-selector-attr">[    1,   835,  ...]</span>)   ',wrap:!1}}),q=new f({props:{code:"cmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTIwJTNEJTIwJTIyJTVDbiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUyMCUyMCUyMyUyMFdlJTIwYWRkZWQlMjBjb250ZXh0JTIwaGVyZSUzQSUyMCUyMiU1Q24lMjIuJTIwVGhpcyUyMGlzJTIwZW5vdWdoJTIwZm9yJTIwdGhpcyUyMHRva2VuaXplciUwQXJlc3BvbnNlX3RlbXBsYXRlX2lkcyUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUocmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpJTVCMiUzQSU1RCUyMCUyMCUyMyUyME5vdyUyMHdlJTIwaGF2ZSUyMGl0JTIwbGlrZSUyMGluJTIwdGhlJTIwZGF0YXNldCUyMHRleHRzJTNBJTIwJTYwJTVCMjI3NyUyQyUyMDI5OTM3JTJDJTIwNDAwNyUyQyUyMDIyMTM3JTJDJTIwMjk5MDElNUQlNjAlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTShyZXNwb25zZV90ZW1wbGF0ZV9pZHMlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`response_template_with_context = <span class="hljs-string">&quot;\\n### Assistant:&quot;</span>  <span class="hljs-comment"># We added context here: &quot;\\n&quot;. This is enough for this tokenizer</span>
response_template_ids = tokenizer.encode(response_template_with_context, add_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-number">2</span>:]  <span class="hljs-comment"># Now we have it like in the dataset texts: \`[2277, 29937, 4007, 22137, 29901]\`</span>

data_collator = DataCollatorForCompletionOnlyLM(response_template_ids, tokenizer=tokenizer)`,wrap:!1}}),Y=new M({props:{title:"Format your input prompts",local:"format-your-input-prompts",headingTag:"h3"}}),H=new f({props:{code:"QmVsb3clMjBpcyUyMGFuJTIwaW5zdHJ1Y3Rpb24lMjAuLi4lMEElMEElMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiUwQSU3QnByb21wdCU3RCUwQSUwQSUyMyUyMyUyMyUyMFJlc3BvbnNlJTNBJTBBJTdCY29tcGxldGlvbiU3RA==",highlighted:`Below is an instruction ...

<span class="hljs-comment">### Instruction</span>
{prompt}

<span class="hljs-comment">### Response:</span>
{completion}`,wrap:!1}}),P=new f({props:{code:"JTBB",highlighted:`...
<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;question&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
)

trainer.train()`,wrap:!1}}),K=new M({props:{title:"Packing dataset ( ConstantLengthDataset )",local:"packing-dataset--constantlengthdataset-",headingTag:"h3"}}),et=new f({props:{code:"JTBB",highlighted:`...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    packing=<span class="hljs-literal">True</span>
)

trainer.train()`,wrap:!1}}),nt=new M({props:{title:"Customize your prompts using packed dataset",local:"customize-your-prompts-using-packed-dataset",headingTag:"h4"}}),lt=new f({props:{code:"ZGVmJTIwZm9ybWF0dGluZ19mdW5jKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTdEJTVDbiUyMCUyMyUyMyUyMyUyMEFuc3dlciUzQSUyMCU3QmV4YW1wbGUlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBwYWNraW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGZvcm1hdHRpbmdfZnVuYyUzRGZvcm1hdHRpbmdfZnVuYyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_func</span>(<span class="hljs-params">example</span>):
    text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">return</span> text

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    packing=<span class="hljs-literal">True</span>,
    formatting_func=formatting_func
)

trainer.train()`,wrap:!1}}),rt=new M({props:{title:"Control over the pretrained model",local:"trl.SFTTrainer",headingTag:"h3"}}),pt=new f({props:{code:"JTBBJTBB",highlighted:`model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, torch_dtype=torch.bfloat16)

\`\`\`python
...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
)

trainer.train()`,wrap:!1}}),ct=new M({props:{title:"Training adapters",local:"training-adapters",headingTag:"h3"}}),ut=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwJTIyRWxldXRoZXJBSSUyRmdwdC1uZW8tMTI1bSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEcGVmdF9jb25maWclMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config
)

trainer.train()`,wrap:!1}}),ft=new f({props:{code:"Y2xhc3MlMjBQZWZ0U2F2aW5nQ2FsbGJhY2soVHJhaW5lckNhbGxiYWNrKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMG9uX3NhdmUoc2VsZiUyQyUyMGFyZ3MlMkMlMjBzdGF0ZSUyQyUyMGNvbnRyb2wlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjaGVja3BvaW50X3BhdGglMjAlM0QlMjBvcy5wYXRoLmpvaW4oYXJncy5vdXRwdXRfZGlyJTJDJTIwZiUyMmNoZWNrcG9pbnQtJTdCc3RhdGUuZ2xvYmFsX3N0ZXAlN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa3dhcmdzJTVCJTIybW9kZWwlMjIlNUQuc2F2ZV9wcmV0cmFpbmVkKGNoZWNrcG9pbnRfcGF0aCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMCUyMnB5dG9yY2hfbW9kZWwuYmluJTIyJTIwaW4lMjBvcy5saXN0ZGlyKGNoZWNrcG9pbnRfcGF0aCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcy5yZW1vdmUob3MucGF0aC5qb2luKGNoZWNrcG9pbnRfcGF0aCUyQyUyMCUyMnB5dG9yY2hfbW9kZWwuYmluJTIyKSk=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PeftSavingCallback</span>(<span class="hljs-title class_ inherited__">TrainerCallback</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">on_save</span>(<span class="hljs-params">self, args, state, control, **kwargs</span>):
        checkpoint_path = os.path.join(args.output_dir, <span class="hljs-string">f&quot;checkpoint-<span class="hljs-subst">{state.global_step}</span>&quot;</span>)
        kwargs[<span class="hljs-string">&quot;model&quot;</span>].save_pretrained(checkpoint_path)

        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;pytorch_model.bin&quot;</span> <span class="hljs-keyword">in</span> os.listdir(checkpoint_path):
            os.remove(os.path.join(checkpoint_path, <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>))`,wrap:!1}}),yt=new f({props:{code:"JTBBJTBB",highlighted:`...

callbacks = [YourCustomCallback(), PeftSavingCallback()]

trainer = SFTTrainer(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config,
    callbacks=callbacks
)

trainer.train()`,wrap:!1}}),gt=new M({props:{title:"Training adapters with base 8 bit models",local:"training-adapters-with-base-8-bit-models",headingTag:"h3"}}),bt=new f({props:{code:"JTBBJTBBJTBB",highlighted:`...

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config,
)

trainer.train()`,wrap:!1}}),Ut=new M({props:{title:"Using Flash Attention and Flash Attention 2",local:"using-flash-attention-and-flash-attention-2",headingTag:"h2"}}),kt=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMuZ2l0",highlighted:"pip install -U git+https://github.com/huggingface/transformers.git",wrap:!1}}),jt=new M({props:{title:"Using Flash-Attention 1",local:"using-flash-attention-1",headingTag:"h3"}}),$t=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwb3B0aW11bQ==",highlighted:"pip install -U optimum",wrap:!1}}),Ft=new f({props:{code:"",highlighted:`...

<span class="hljs-addition">+ with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</span>
    trainer.train()`,wrap:!1}}),Rt=new M({props:{title:"Using Flash Attention-2",local:"using-flash-attention-2",headingTag:"h3"}}),zt=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0bg==",highlighted:"pip install -U flash-attn",wrap:!1}}),At=new f({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2ZsYXNoX2F0dGVudGlvbl8yJTNEVHJ1ZSUwQSk=",highlighted:`model = AutoModelForCausalLM.from_pretrained(
    model_id,
    load_in_4bit=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Vt=new M({props:{title:"Best practices",local:"best-practices",headingTag:"h2"}}),Et=new M({props:{title:"SFTTrainer",local:"sfttrainer",headingTag:"h2"}}),Wt=new Cn({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalPrediction], typing.Dict], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"peft_config",val:": typing.Optional[typing.Dict] = None"},{name:"dataset_text_field",val:": typing.Optional[str] = None"},{name:"packing",val:": typing.Optional[bool] = False"},{name:"formatting_func",val:": typing.Optional[typing.Callable] = None"},{name:"max_seq_length",val:": typing.Optional[int] = None"},{name:"infinite",val:": typing.Optional[bool] = False"},{name:"num_of_sequences",val:": typing.Optional[int] = 1024"},{name:"chars_per_token",val:": typing.Optional[float] = 3.6"},{name:"dataset_num_proc",val:": typing.Optional[int] = None"},{name:"dataset_batch_size",val:": int = 1000"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (Optional<a href="https://huggingface.co/docs/transformers/v4.34.1/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">transformers.TrainingArguments</a>) &#x2014;
The arguments to tweak for training. Please refer to the official documentation of <code>transformers.TrainingArguments</code>
for more information.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (Optional<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (Optional<a href="https://huggingface.co/docs/datasets/v2.14.5/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">datasets.Dataset</a>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (Optional<a href="https://huggingface.co/docs/transformers/v4.34.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizer" rel="nofollow">transformers.PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to <code>compute_accuracy</code>) &#x2014;
The metrics to use for evaluation. If no metrics are specified, the default metric (<code>compute_accuracy</code>) will be used.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>) &#x2014;
The name of the text field of the dataset, in case this is passed by a user, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on the <code>dataset_text_field</code> argument.`,name:"dataset_text_field"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"},{anchor:"trl.SFTTrainer.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>) &#x2014;
The maximum sequence length to use for the <code>ConstantLengthDataset</code> and for automaticallty creating the Dataset. Defaults to <code>512</code>.`,name:"max_seq_length"},{anchor:"trl.SFTTrainer.infinite",description:`<strong>infinite</strong> (<code>Optional[bool]</code>) &#x2014;
Whether to use an infinite dataset or not. Defaults to <code>False</code>.`,name:"infinite"},{anchor:"trl.SFTTrainer.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>Optional[int]</code>) &#x2014;
The number of sequences to use for the <code>ConstantLengthDataset</code>. Defaults to <code>1024</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTTrainer.chars_per_token",description:`<strong>chars_per_token</strong> (<code>Optional[float]</code>) &#x2014;
The number of characters per token to use for the <code>ConstantLengthDataset</code>. Defaults to <code>3.6</code>. You can check how this is computed in the
stack-llama example: <a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53</a>.`,name:"chars_per_token"},{anchor:"trl.SFTTrainer.packing",description:`<strong>packing</strong> (<code>Optional[bool]</code>) &#x2014;
Used only in case <code>dataset_text_field</code> is passed. This argument is used by the <code>ConstantLengthDataset</code> to pack the sequences
of the dataset.`,name:"packing"},{anchor:"trl.SFTTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>) &#x2014;
The number of workers to use to tokenize the data. Only used when <code>packing=False</code>. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.SFTTrainer.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>int</code>) &#x2014;
The number of examples to tokenize per batch. If batch_size &lt;= 0 or batch_size == None,
tokenize the full dataset as a single batch. Defaults to 1000.`,name:"dataset_batch_size"}],source:"https://github.com/huggingface/trl/blob/v0.7.2/trl/trainer/sft_trainer.py#L42"}}),qt=new M({props:{title:"ConstantLengthDataset",local:"constantlengthdataset",headingTag:"h2"}}),Yt=new Cn({props:{name:"class trl.trainer.ConstantLengthDataset",anchor:"trl.trainer.ConstantLengthDataset",parameters:[{name:"*args",val:""},{name:"**kwds",val:""}],parametersDescription:[{anchor:"trl.trainer.ConstantLengthDataset.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizer</code>) &#x2014;
The processor used for processing the data.`,name:"tokenizer"},{anchor:"trl.trainer.ConstantLengthDataset.dataset",description:`<strong>dataset</strong> (<code>dataset.Dataset</code>) &#x2014;
Dataset with text files.`,name:"dataset"},{anchor:"trl.trainer.ConstantLengthDataset.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>str</code>, <strong>optional</strong>) &#x2014;
Name of the field in the dataset that contains the text. Used only if <code>formatting_func</code> is <code>None</code>.`,name:"dataset_text_field"},{anchor:"trl.trainer.ConstantLengthDataset.formatting_func",description:`<strong>formatting_func</strong> (<code>Callable</code>, <strong>optional</strong>) &#x2014;
Function that formats the text before tokenization. Usually it is recommended to have follows a certain
pattern such as \`&#x201D;### Question: {question}`,name:"formatting_func"}],source:"https://github.com/huggingface/trl/blob/v0.7.2/trl/trainer/utils.py#L482"}}),Lt=new M({props:{title:"Answer: {answer}",local:"answer-answer",headingTag:"h3"}}),{c(){T=o("meta"),te=s(),Ot=o("p"),ee=s(),p(U.$$.fragment),ae=s(),_=o("p"),_.textContent=Ba,ne=s(),k=o("p"),k.innerHTML=Aa,se=s(),p(J.$$.fragment),le=s(),j=o("p"),j.innerHTML=Sa,oe=s(),p(C.$$.fragment),re=s(),$=o("p"),$.innerHTML=Xa,ie=s(),x=o("p"),x.textContent=Va,pe=s(),p(F.$$.fragment),de=s(),v=o("p"),v.innerHTML=Na,ce=s(),p(I.$$.fragment),me=s(),p(G.$$.fragment),ue=s(),R=o("p"),R.innerHTML=Qa,he=s(),p(Z.$$.fragment),fe=s(),z=o("p"),z.innerHTML=Ea,Me=s(),p(B.$$.fragment),ye=s(),p(A.$$.fragment),Te=s(),S=o("p"),S.innerHTML=Wa,ge=s(),p(X.$$.fragment),we=s(),V=o("p"),V.innerHTML=qa,be=s(),N=o("ul"),N.innerHTML=Ya,Ue=s(),Q=o("p"),Q.innerHTML=La,_e=s(),p(E.$$.fragment),ke=s(),W=o("p"),W.innerHTML=Ha,Je=s(),p(q.$$.fragment),je=s(),p(Y.$$.fragment),Ce=s(),L=o("p"),L.innerHTML=Da,$e=s(),p(H.$$.fragment),xe=s(),D=o("p"),D.innerHTML=Pa,Fe=s(),p(P.$$.fragment),ve=s(),O=o("p"),O.innerHTML=Oa,Ie=s(),p(K.$$.fragment),Ge=s(),tt=o("p"),tt.innerHTML=Ka,Re=s(),p(et.$$.fragment),Ze=s(),at=o("p"),at.innerHTML=tn,ze=s(),p(nt.$$.fragment),Be=s(),st=o("p"),st.innerHTML=en,Ae=s(),p(lt.$$.fragment),Se=s(),ot=o("p"),ot.innerHTML=an,Xe=s(),p(rt.$$.fragment),Ve=s(),it=o("p"),it.innerHTML=nn,Ne=s(),p(pt.$$.fragment),Qe=s(),dt=o("p"),dt.innerHTML=sn,Ee=s(),p(ct.$$.fragment),We=s(),mt=o("p"),mt.textContent=ln,qe=s(),p(ut.$$.fragment),Ye=s(),ht=o("p"),ht.textContent=on,Le=s(),p(ft.$$.fragment),He=s(),Mt=o("p"),Mt.textContent=rn,De=s(),p(yt.$$.fragment),Pe=s(),Tt=o("p"),Tt.innerHTML=pn,Oe=s(),p(gt.$$.fragment),Ke=s(),wt=o("p"),wt.innerHTML=dn,ta=s(),p(bt.$$.fragment),ea=s(),p(Ut.$$.fragment),aa=s(),_t=o("p"),_t.textContent=cn,na=s(),p(kt.$$.fragment),sa=s(),Jt=o("p"),Jt.textContent=mn,la=s(),p(jt.$$.fragment),oa=s(),Ct=o("p"),Ct.innerHTML=un,ra=s(),p($t.$$.fragment),ia=s(),xt=o("p"),xt.innerHTML=hn,pa=s(),p(Ft.$$.fragment),da=s(),vt=o("p"),vt.innerHTML=fn,ca=s(),It=o("p"),It.textContent=Mn,ma=s(),Gt=o("table"),Gt.innerHTML=yn,ua=s(),p(Rt.$$.fragment),ha=s(),Zt=o("p"),Zt.innerHTML=Tn,fa=s(),p(zt.$$.fragment),Ma=s(),Bt=o("p"),Bt.innerHTML=gn,ya=s(),p(At.$$.fragment),Ta=s(),St=o("p"),St.textContent=wn,ga=s(),Xt=o("p"),Xt.textContent=bn,wa=s(),p(Vt.$$.fragment),ba=s(),Nt=o("p"),Nt.textContent=Un,Ua=s(),Qt=o("ul"),Qt.innerHTML=_n,_a=s(),p(Et.$$.fragment),ka=s(),g=o("div"),p(Wt.$$.fragment),Ia=s(),Ht=o("p"),Ht.innerHTML=kn,Ja=s(),p(qt.$$.fragment),ja=s(),y=o("div"),p(Yt.$$.fragment),Ga=s(),Dt=o("p"),Dt.textContent=Jn,Ra=s(),p(Lt.$$.fragment),Za=s(),Pt=o("p"),Pt.innerHTML=jn,Ca=s(),Kt=o("p"),this.h()},l(t){const e=Gn("svelte-u9bgzb",document.head);T=r(e,"META",{name:!0,content:!0}),e.forEach(a),te=l(t),Ot=r(t,"P",{}),Fa(Ot).forEach(a),ee=l(t),d(U.$$.fragment,t),ae=l(t),_=r(t,"P",{"data-svelte-h":!0}),i(_)!=="svelte-o839x3"&&(_.textContent=Ba),ne=l(t),k=r(t,"P",{"data-svelte-h":!0}),i(k)!=="svelte-sgh7d7"&&(k.innerHTML=Aa),se=l(t),d(J.$$.fragment,t),le=l(t),j=r(t,"P",{"data-svelte-h":!0}),i(j)!=="svelte-1t5xhlk"&&(j.innerHTML=Sa),oe=l(t),d(C.$$.fragment,t),re=l(t),$=r(t,"P",{"data-svelte-h":!0}),i($)!=="svelte-1gbidw"&&($.innerHTML=Xa),ie=l(t),x=r(t,"P",{"data-svelte-h":!0}),i(x)!=="svelte-ulikv8"&&(x.textContent=Va),pe=l(t),d(F.$$.fragment,t),de=l(t),v=r(t,"P",{"data-svelte-h":!0}),i(v)!=="svelte-fsrr41"&&(v.innerHTML=Na),ce=l(t),d(I.$$.fragment,t),me=l(t),d(G.$$.fragment,t),ue=l(t),R=r(t,"P",{"data-svelte-h":!0}),i(R)!=="svelte-13sbeoj"&&(R.innerHTML=Qa),he=l(t),d(Z.$$.fragment,t),fe=l(t),z=r(t,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1a743rp"&&(z.innerHTML=Ea),Me=l(t),d(B.$$.fragment,t),ye=l(t),d(A.$$.fragment,t),Te=l(t),S=r(t,"P",{"data-svelte-h":!0}),i(S)!=="svelte-dfggk8"&&(S.innerHTML=Wa),ge=l(t),d(X.$$.fragment,t),we=l(t),V=r(t,"P",{"data-svelte-h":!0}),i(V)!=="svelte-xlwe87"&&(V.innerHTML=qa),be=l(t),N=r(t,"UL",{"data-svelte-h":!0}),i(N)!=="svelte-1enki0k"&&(N.innerHTML=Ya),Ue=l(t),Q=r(t,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-14yxh0m"&&(Q.innerHTML=La),_e=l(t),d(E.$$.fragment,t),ke=l(t),W=r(t,"P",{"data-svelte-h":!0}),i(W)!=="svelte-13h81gp"&&(W.innerHTML=Ha),Je=l(t),d(q.$$.fragment,t),je=l(t),d(Y.$$.fragment,t),Ce=l(t),L=r(t,"P",{"data-svelte-h":!0}),i(L)!=="svelte-cqsf2h"&&(L.innerHTML=Da),$e=l(t),d(H.$$.fragment,t),xe=l(t),D=r(t,"P",{"data-svelte-h":!0}),i(D)!=="svelte-l25vq0"&&(D.innerHTML=Pa),Fe=l(t),d(P.$$.fragment,t),ve=l(t),O=r(t,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1iqmdsd"&&(O.innerHTML=Oa),Ie=l(t),d(K.$$.fragment,t),Ge=l(t),tt=r(t,"P",{"data-svelte-h":!0}),i(tt)!=="svelte-tszk1s"&&(tt.innerHTML=Ka),Re=l(t),d(et.$$.fragment,t),Ze=l(t),at=r(t,"P",{"data-svelte-h":!0}),i(at)!=="svelte-wtbvzy"&&(at.innerHTML=tn),ze=l(t),d(nt.$$.fragment,t),Be=l(t),st=r(t,"P",{"data-svelte-h":!0}),i(st)!=="svelte-iejqw3"&&(st.innerHTML=en),Ae=l(t),d(lt.$$.fragment,t),Se=l(t),ot=r(t,"P",{"data-svelte-h":!0}),i(ot)!=="svelte-1giyemu"&&(ot.innerHTML=an),Xe=l(t),d(rt.$$.fragment,t),Ve=l(t),it=r(t,"P",{"data-svelte-h":!0}),i(it)!=="svelte-gsjitu"&&(it.innerHTML=nn),Ne=l(t),d(pt.$$.fragment,t),Qe=l(t),dt=r(t,"P",{"data-svelte-h":!0}),i(dt)!=="svelte-1rnsxc5"&&(dt.innerHTML=sn),Ee=l(t),d(ct.$$.fragment,t),We=l(t),mt=r(t,"P",{"data-svelte-h":!0}),i(mt)!=="svelte-11jfbzz"&&(mt.textContent=ln),qe=l(t),d(ut.$$.fragment,t),Ye=l(t),ht=r(t,"P",{"data-svelte-h":!0}),i(ht)!=="svelte-1iplhln"&&(ht.textContent=on),Le=l(t),d(ft.$$.fragment,t),He=l(t),Mt=r(t,"P",{"data-svelte-h":!0}),i(Mt)!=="svelte-645tfb"&&(Mt.textContent=rn),De=l(t),d(yt.$$.fragment,t),Pe=l(t),Tt=r(t,"P",{"data-svelte-h":!0}),i(Tt)!=="svelte-pwdaav"&&(Tt.innerHTML=pn),Oe=l(t),d(gt.$$.fragment,t),Ke=l(t),wt=r(t,"P",{"data-svelte-h":!0}),i(wt)!=="svelte-zbh7v5"&&(wt.innerHTML=dn),ta=l(t),d(bt.$$.fragment,t),ea=l(t),d(Ut.$$.fragment,t),aa=l(t),_t=r(t,"P",{"data-svelte-h":!0}),i(_t)!=="svelte-fyvvsj"&&(_t.textContent=cn),na=l(t),d(kt.$$.fragment,t),sa=l(t),Jt=r(t,"P",{"data-svelte-h":!0}),i(Jt)!=="svelte-yypgof"&&(Jt.textContent=mn),la=l(t),d(jt.$$.fragment,t),oa=l(t),Ct=r(t,"P",{"data-svelte-h":!0}),i(Ct)!=="svelte-yugu96"&&(Ct.innerHTML=un),ra=l(t),d($t.$$.fragment,t),ia=l(t),xt=r(t,"P",{"data-svelte-h":!0}),i(xt)!=="svelte-1qms4cl"&&(xt.innerHTML=hn),pa=l(t),d(Ft.$$.fragment,t),da=l(t),vt=r(t,"P",{"data-svelte-h":!0}),i(vt)!=="svelte-qe5zfz"&&(vt.innerHTML=fn),ca=l(t),It=r(t,"P",{"data-svelte-h":!0}),i(It)!=="svelte-69u1rz"&&(It.textContent=Mn),ma=l(t),Gt=r(t,"TABLE",{"data-svelte-h":!0}),i(Gt)!=="svelte-8fq96j"&&(Gt.innerHTML=yn),ua=l(t),d(Rt.$$.fragment,t),ha=l(t),Zt=r(t,"P",{"data-svelte-h":!0}),i(Zt)!=="svelte-1rqlm78"&&(Zt.innerHTML=Tn),fa=l(t),d(zt.$$.fragment,t),Ma=l(t),Bt=r(t,"P",{"data-svelte-h":!0}),i(Bt)!=="svelte-sqoxna"&&(Bt.innerHTML=gn),ya=l(t),d(At.$$.fragment,t),Ta=l(t),St=r(t,"P",{"data-svelte-h":!0}),i(St)!=="svelte-vfpk19"&&(St.textContent=wn),ga=l(t),Xt=r(t,"P",{"data-svelte-h":!0}),i(Xt)!=="svelte-zatc00"&&(Xt.textContent=bn),wa=l(t),d(Vt.$$.fragment,t),ba=l(t),Nt=r(t,"P",{"data-svelte-h":!0}),i(Nt)!=="svelte-g801h1"&&(Nt.textContent=Un),Ua=l(t),Qt=r(t,"UL",{"data-svelte-h":!0}),i(Qt)!=="svelte-7ljqbc"&&(Qt.innerHTML=_n),_a=l(t),d(Et.$$.fragment,t),ka=l(t),g=r(t,"DIV",{class:!0});var xa=Fa(g);d(Wt.$$.fragment,xa),Ia=l(xa),Ht=r(xa,"P",{"data-svelte-h":!0}),i(Ht)!=="svelte-14oyph8"&&(Ht.innerHTML=kn),xa.forEach(a),Ja=l(t),d(qt.$$.fragment,t),ja=l(t),y=r(t,"DIV",{class:!0});var w=Fa(y);d(Yt.$$.fragment,w),Ga=l(w),Dt=r(w,"P",{"data-svelte-h":!0}),i(Dt)!=="svelte-1dlriq1"&&(Dt.textContent=Jn),Ra=l(w),d(Lt.$$.fragment,w),Za=l(w),Pt=r(w,"P",{"data-svelte-h":!0}),i(Pt)!=="svelte-1quwuq5"&&(Pt.innerHTML=jn),w.forEach(a),Ca=l(t),Kt=r(t,"P",{}),Fa(Kt).forEach(a),this.h()},h(){va(T,"name","hf:doc:metadata"),va(T,"content",Zn),va(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),va(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){b(document.head,T),n(t,te,e),n(t,Ot,e),n(t,ee,e),c(U,t,e),n(t,ae,e),n(t,_,e),n(t,ne,e),n(t,k,e),n(t,se,e),c(J,t,e),n(t,le,e),n(t,j,e),n(t,oe,e),c(C,t,e),n(t,re,e),n(t,$,e),n(t,ie,e),n(t,x,e),n(t,pe,e),c(F,t,e),n(t,de,e),n(t,v,e),n(t,ce,e),c(I,t,e),n(t,me,e),c(G,t,e),n(t,ue,e),n(t,R,e),n(t,he,e),c(Z,t,e),n(t,fe,e),n(t,z,e),n(t,Me,e),c(B,t,e),n(t,ye,e),c(A,t,e),n(t,Te,e),n(t,S,e),n(t,ge,e),c(X,t,e),n(t,we,e),n(t,V,e),n(t,be,e),n(t,N,e),n(t,Ue,e),n(t,Q,e),n(t,_e,e),c(E,t,e),n(t,ke,e),n(t,W,e),n(t,Je,e),c(q,t,e),n(t,je,e),c(Y,t,e),n(t,Ce,e),n(t,L,e),n(t,$e,e),c(H,t,e),n(t,xe,e),n(t,D,e),n(t,Fe,e),c(P,t,e),n(t,ve,e),n(t,O,e),n(t,Ie,e),c(K,t,e),n(t,Ge,e),n(t,tt,e),n(t,Re,e),c(et,t,e),n(t,Ze,e),n(t,at,e),n(t,ze,e),c(nt,t,e),n(t,Be,e),n(t,st,e),n(t,Ae,e),c(lt,t,e),n(t,Se,e),n(t,ot,e),n(t,Xe,e),c(rt,t,e),n(t,Ve,e),n(t,it,e),n(t,Ne,e),c(pt,t,e),n(t,Qe,e),n(t,dt,e),n(t,Ee,e),c(ct,t,e),n(t,We,e),n(t,mt,e),n(t,qe,e),c(ut,t,e),n(t,Ye,e),n(t,ht,e),n(t,Le,e),c(ft,t,e),n(t,He,e),n(t,Mt,e),n(t,De,e),c(yt,t,e),n(t,Pe,e),n(t,Tt,e),n(t,Oe,e),c(gt,t,e),n(t,Ke,e),n(t,wt,e),n(t,ta,e),c(bt,t,e),n(t,ea,e),c(Ut,t,e),n(t,aa,e),n(t,_t,e),n(t,na,e),c(kt,t,e),n(t,sa,e),n(t,Jt,e),n(t,la,e),c(jt,t,e),n(t,oa,e),n(t,Ct,e),n(t,ra,e),c($t,t,e),n(t,ia,e),n(t,xt,e),n(t,pa,e),c(Ft,t,e),n(t,da,e),n(t,vt,e),n(t,ca,e),n(t,It,e),n(t,ma,e),n(t,Gt,e),n(t,ua,e),c(Rt,t,e),n(t,ha,e),n(t,Zt,e),n(t,fa,e),c(zt,t,e),n(t,Ma,e),n(t,Bt,e),n(t,ya,e),c(At,t,e),n(t,Ta,e),n(t,St,e),n(t,ga,e),n(t,Xt,e),n(t,wa,e),c(Vt,t,e),n(t,ba,e),n(t,Nt,e),n(t,Ua,e),n(t,Qt,e),n(t,_a,e),c(Et,t,e),n(t,ka,e),n(t,g,e),c(Wt,g,null),b(g,Ia),b(g,Ht),n(t,Ja,e),c(qt,t,e),n(t,ja,e),n(t,y,e),c(Yt,y,null),b(y,Ga),b(y,Dt),b(y,Ra),c(Lt,y,null),b(y,Za),b(y,Pt),n(t,Ca,e),n(t,Kt,e),$a=!0},p:xn,i(t){$a||(m(U.$$.fragment,t),m(J.$$.fragment,t),m(C.$$.fragment,t),m(F.$$.fragment,t),m(I.$$.fragment,t),m(G.$$.fragment,t),m(Z.$$.fragment,t),m(B.$$.fragment,t),m(A.$$.fragment,t),m(X.$$.fragment,t),m(E.$$.fragment,t),m(q.$$.fragment,t),m(Y.$$.fragment,t),m(H.$$.fragment,t),m(P.$$.fragment,t),m(K.$$.fragment,t),m(et.$$.fragment,t),m(nt.$$.fragment,t),m(lt.$$.fragment,t),m(rt.$$.fragment,t),m(pt.$$.fragment,t),m(ct.$$.fragment,t),m(ut.$$.fragment,t),m(ft.$$.fragment,t),m(yt.$$.fragment,t),m(gt.$$.fragment,t),m(bt.$$.fragment,t),m(Ut.$$.fragment,t),m(kt.$$.fragment,t),m(jt.$$.fragment,t),m($t.$$.fragment,t),m(Ft.$$.fragment,t),m(Rt.$$.fragment,t),m(zt.$$.fragment,t),m(At.$$.fragment,t),m(Vt.$$.fragment,t),m(Et.$$.fragment,t),m(Wt.$$.fragment,t),m(qt.$$.fragment,t),m(Yt.$$.fragment,t),m(Lt.$$.fragment,t),$a=!0)},o(t){u(U.$$.fragment,t),u(J.$$.fragment,t),u(C.$$.fragment,t),u(F.$$.fragment,t),u(I.$$.fragment,t),u(G.$$.fragment,t),u(Z.$$.fragment,t),u(B.$$.fragment,t),u(A.$$.fragment,t),u(X.$$.fragment,t),u(E.$$.fragment,t),u(q.$$.fragment,t),u(Y.$$.fragment,t),u(H.$$.fragment,t),u(P.$$.fragment,t),u(K.$$.fragment,t),u(et.$$.fragment,t),u(nt.$$.fragment,t),u(lt.$$.fragment,t),u(rt.$$.fragment,t),u(pt.$$.fragment,t),u(ct.$$.fragment,t),u(ut.$$.fragment,t),u(ft.$$.fragment,t),u(yt.$$.fragment,t),u(gt.$$.fragment,t),u(bt.$$.fragment,t),u(Ut.$$.fragment,t),u(kt.$$.fragment,t),u(jt.$$.fragment,t),u($t.$$.fragment,t),u(Ft.$$.fragment,t),u(Rt.$$.fragment,t),u(zt.$$.fragment,t),u(At.$$.fragment,t),u(Vt.$$.fragment,t),u(Et.$$.fragment,t),u(Wt.$$.fragment,t),u(qt.$$.fragment,t),u(Yt.$$.fragment,t),u(Lt.$$.fragment,t),$a=!1},d(t){t&&(a(te),a(Ot),a(ee),a(ae),a(_),a(ne),a(k),a(se),a(le),a(j),a(oe),a(re),a($),a(ie),a(x),a(pe),a(de),a(v),a(ce),a(me),a(ue),a(R),a(he),a(fe),a(z),a(Me),a(ye),a(Te),a(S),a(ge),a(we),a(V),a(be),a(N),a(Ue),a(Q),a(_e),a(ke),a(W),a(Je),a(je),a(Ce),a(L),a($e),a(xe),a(D),a(Fe),a(ve),a(O),a(Ie),a(Ge),a(tt),a(Re),a(Ze),a(at),a(ze),a(Be),a(st),a(Ae),a(Se),a(ot),a(Xe),a(Ve),a(it),a(Ne),a(Qe),a(dt),a(Ee),a(We),a(mt),a(qe),a(Ye),a(ht),a(Le),a(He),a(Mt),a(De),a(Pe),a(Tt),a(Oe),a(Ke),a(wt),a(ta),a(ea),a(aa),a(_t),a(na),a(sa),a(Jt),a(la),a(oa),a(Ct),a(ra),a(ia),a(xt),a(pa),a(da),a(vt),a(ca),a(It),a(ma),a(Gt),a(ua),a(ha),a(Zt),a(fa),a(Ma),a(Bt),a(ya),a(Ta),a(St),a(ga),a(Xt),a(wa),a(ba),a(Nt),a(Ua),a(Qt),a(_a),a(ka),a(g),a(Ja),a(ja),a(y),a(Ca),a(Kt)),a(T),h(U,t),h(J,t),h(C,t),h(F,t),h(I,t),h(G,t),h(Z,t),h(B,t),h(A,t),h(X,t),h(E,t),h(q,t),h(Y,t),h(H,t),h(P,t),h(K,t),h(et,t),h(nt,t),h(lt,t),h(rt,t),h(pt,t),h(ct,t),h(ut,t),h(ft,t),h(yt,t),h(gt,t),h(bt,t),h(Ut,t),h(kt,t),h(jt,t),h($t,t),h(Ft,t),h(Rt,t),h(zt,t),h(At,t),h(Vt,t),h(Et,t),h(Wt),h(qt,t),h(Yt),h(Lt)}}}const Zn='{"title":"Supervised Fine-tuning Trainer","local":"supervised-fine-tuning-trainer","sections":[{"title":"Quickstart","local":"quickstart","sections":[],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Train on completions only","local":"train-on-completions-only","sections":[{"title":"Using token_ids directly for response_template","local":"using-tokenids-directly-for-responsetemplate","sections":[],"depth":4}],"depth":3},{"title":"Format your input prompts","local":"format-your-input-prompts","sections":[],"depth":3},{"title":"Packing dataset ( ConstantLengthDataset )","local":"packing-dataset--constantlengthdataset-","sections":[{"title":"Customize your prompts using packed dataset","local":"customize-your-prompts-using-packed-dataset","sections":[],"depth":4}],"depth":3},{"title":"Control over the pretrained model","local":"trl.SFTTrainer","sections":[],"depth":3},{"title":"Training adapters","local":"training-adapters","sections":[],"depth":3},{"title":"Training adapters with base 8 bit models","local":"training-adapters-with-base-8-bit-models","sections":[],"depth":3}],"depth":2},{"title":"Using Flash Attention and Flash Attention 2","local":"using-flash-attention-and-flash-attention-2","sections":[{"title":"Using Flash-Attention 1","local":"using-flash-attention-1","sections":[],"depth":3},{"title":"Using Flash Attention-2","local":"using-flash-attention-2","sections":[],"depth":3}],"depth":2},{"title":"Best practices","local":"best-practices","sections":[],"depth":2},{"title":"SFTTrainer","local":"sfttrainer","sections":[],"depth":2},{"title":"ConstantLengthDataset","local":"constantlengthdataset","sections":[{"title":"Answer: {answer}","local":"answer-answer","sections":[],"depth":3}],"depth":2}],"depth":1}';function zn(za){return Fn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nn extends vn{constructor(T){super(),In(this,T,zn,Rn,$n,{})}}export{Nn as component};
