import{s as MM,n as tM,o as eM}from"../chunks/scheduler.362310b7.js";import{S as sM,i as aM,g as n,s,r as U,A as nM,h as y,f as t,c as a,j as lM,u as i,x as J,k as ql,y as yM,a as e,v as o,d as j,t as T,w as p}from"../chunks/index.57dfc70d.js";import{C as c}from"../chunks/CodeBlock.5d40996c.js";import{H as D,E as JM}from"../chunks/getInferenceSnippets.9a9f9361.js";function UM(El){let w,K,P,ll,I,Ml,C,Rl="Visual Language Model (VLM) are models that consume both image and text inputs to generate text.",tl,m,vl="VLM’s are trained on a combination of image and text data and can handle a wide range of tasks, such as image captioning, visual question answering, and visual dialog.",el,r,Vl="<p>What distinguishes VLMs from other text and image models is their ability to handle long context and generate text that is coherent and relevant to the image even after multiple turns or in some cases, multiple images.</p>",sl,h,kl="Below are couple of common use cases for vision language models:",al,d,Xl="<li><strong>Image Captioning</strong>: Given an image, generate a caption that describes the image.</li> <li><strong>Visual Question Answering (VQA)</strong>: Given an image and a question about the image, generate an answer to the question.</li> <li><strong>Mulimodal Dialog</strong>: Generate response to multiple turns of images and conversations.</li> <li><strong>Image Information Retrieval</strong>: Given an image, retrieve information from the image.</li>",nl,b,yl,A,Jl,g,xl='To infer with vision language models through Python, you can use the <a href="https://pypi.org/project/huggingface-hub/" rel="nofollow"><code>huggingface_hub</code></a> library. The <code>InferenceClient</code> class provides a simple way to interact with the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>. Images can be passed as URLs or base64-encoded strings. The <code>InferenceClient</code> will automatically detect the image format.',Ul,G,il,Z,ol,f,Sl="or via the <code>chat_completion</code> endpoint:",jl,B,Tl,W,Hl='or with OpenAI’s <a href="https://github.com/openai/openai-python" rel="nofollow">client library</a>:',pl,N,wl,Q,cl,Y,zl="To use the <code>generate_stream</code> endpoint with curl, you can add the <code>-N</code> flag. This flag disables curl default buffering and shows data as it arrives from the server.",ul,q,Il,E,Cl,R,Fl="First, we need to install the <code>@huggingface/inference</code> library.",ml,v,rl,V,$l="Whether you use Inference Providers (our serverless API), or Inference Endpoints, you can call <code>InferenceClient</code>.",hl,k,_l='We can create a <code>InferenceClient</code> providing our endpoint URL and <a href="https://huggingface.co/settings/tokens" rel="nofollow">Hugging Face access token</a>.',dl,X,bl,x,Al,S,Ll='VLMs in TGI have several advantages, for example these models can be used in tandem with other features for more complex tasks. For example, you can use VLMs with <a href="/docs/conceptual/guided-generation">Guided Generation</a> to generate specific JSON data from an image.',gl,u,Dl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png" width="400"/>',Gl,H,Pl="For example we can extract information from the rabbit image and generate a JSON object with the location, activity, number of animals seen, and the animals seen. That would look like this:",Zl,z,fl,F,Ol="All we need to do is provide a JSON schema to the VLM model and it will generate the JSON object for us.",Bl,$,Wl,_,Kl='Want to learn more about how Vision Language Models work? Check out the <a href="https://huggingface.co/blog/vlms" rel="nofollow">awesome blog post on the topic</a>.',Nl,L,Ql,O,Yl;return I=new D({props:{title:"Vision Language Model Inference in TGI",local:"vision-language-model-inference-in-tgi",headingTag:"h1"}}),b=new D({props:{title:"How to Use a Vision Language Model?",local:"how-to-use-a-vision-language-model",headingTag:"h2"}}),A=new D({props:{title:"Hugging Face Hub Python Library",local:"hugging-face-hub-python-library",headingTag:"h3"}}),G=new c({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChiYXNlX3VybCUzRCUyMmh0dHAlM0ElMkYlMkYxMjcuMC4wLjElM0EzMDAwJTIyKSUwQWltYWdlJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGdHJhbnNmb3JtZXJzJTJGcmFiYml0LnBuZyUyMiUwQXByb21wdCUyMCUzRCUyMGYlMjIhJTVCJTVEKCU3QmltYWdlJTdEKVdoYXQlMjBpcyUyMHRoaXMlMjBhJTIwcGljdHVyZSUyMG9mJTNGJTVDbiU1Q24lMjIlMEFmb3IlMjB0b2tlbiUyMGluJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbihwcm9tcHQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDE2JTJDJTIwc3RyZWFtJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbiklMEElMEElMjMlMjBUaGlzJTIwaXMlMjBhJTIwcGljdHVyZSUyMG9mJTIwYW4lMjBhbnRocm9wb21vcnBoaWMlMjByYWJiaXQlMjBpbiUyMGElMjBzcGFjZSUyMHN1aXQu",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(base_url=<span class="hljs-string">&quot;http://127.0.0.1:3000&quot;</span>)
image = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png&quot;</span>
prompt = <span class="hljs-string">f&quot;![](<span class="hljs-subst">{image}</span>)What is this a picture of?\\n\\n&quot;</span>
<span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(prompt, max_new_tokens=<span class="hljs-number">16</span>, stream=<span class="hljs-literal">True</span>):
    <span class="hljs-built_in">print</span>(token)

<span class="hljs-comment"># This is a picture of an anthropomorphic rabbit in a space suit.</span>`,wrap:!1}}),Z=new c({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWltcG9ydCUyMGJhc2U2NCUwQWltcG9ydCUyMHJlcXVlc3RzJTBBaW1wb3J0JTIwaW8lMEElMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoYmFzZV91cmwlM0QlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBMzAwMCUyMiklMEElMEElMjMlMjByZWFkJTIwaW1hZ2UlMjBmcm9tJTIwbG9jYWwlMjBmaWxlJTBBaW1hZ2VfcGF0aCUyMCUzRCUyMCUyMnJhYmJpdC5wbmclMjIlMEF3aXRoJTIwb3BlbihpbWFnZV9wYXRoJTJDJTIwJTIycmIlMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBiYXNlNjQuYjY0ZW5jb2RlKGYucmVhZCgpKS5kZWNvZGUoJTIydXRmLTglMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBmJTIyZGF0YSUzQWltYWdlJTJGcG5nJTNCYmFzZTY0JTJDJTdCaW1hZ2UlN0QlMjIlMEFwcm9tcHQlMjAlM0QlMjBmJTIyISU1QiU1RCglN0JpbWFnZSU3RClXaGF0JTIwaXMlMjB0aGlzJTIwYSUyMHBpY3R1cmUlMjBvZiUzRiU1Q24lNUNuJTIyJTBBJTBBZm9yJTIwdG9rZW4lMjBpbiUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24ocHJvbXB0JTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUyMHN0cmVhbSUzRFRydWUpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQodG9rZW4pJTBBJTBBJTIzJTIwVGhpcyUyMGlzJTIwYSUyMHBpY3R1cmUlMjBvZiUyMGFuJTIwYW50aHJvcG9tb3JwaGljJTIwcmFiYml0JTIwaW4lMjBhJTIwc3BhY2UlMjBzdWl0Lg==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-keyword">import</span> base64
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> io

client = InferenceClient(base_url=<span class="hljs-string">&quot;http://127.0.0.1:3000&quot;</span>)

<span class="hljs-comment"># read image from local file</span>
image_path = <span class="hljs-string">&quot;rabbit.png&quot;</span>
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(image_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> f:
    image = base64.b64encode(f.read()).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)

image = <span class="hljs-string">f&quot;data:image/png;base64,<span class="hljs-subst">{image}</span>&quot;</span>
prompt = <span class="hljs-string">f&quot;![](<span class="hljs-subst">{image}</span>)What is this a picture of?\\n\\n&quot;</span>

<span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(prompt, max_new_tokens=<span class="hljs-number">10</span>, stream=<span class="hljs-literal">True</span>):
    <span class="hljs-built_in">print</span>(token)

<span class="hljs-comment"># This is a picture of an anthropomorphic rabbit in a space suit.</span>`,wrap:!1}}),B=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(base_url=<span class="hljs-string">&quot;http://127.0.0.1:3000&quot;</span>)

chat = client.chat_completion(
    messages=[
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [
                {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Whats in this image?&quot;</span>},
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                    <span class="hljs-string">&quot;image_url&quot;</span>: {
                        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png&quot;</span>
                    },
                },
            ],
        },
    ],
    seed=<span class="hljs-number">42</span>,
    max_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(chat)
<span class="hljs-comment"># ChatCompletionOutput(choices=[ChatCompletionOutputComplete(finish_reason=&#x27;length&#x27;, index=0, message=ChatCompletionOutputMessage(role=&#x27;assistant&#x27;, content=&quot; The image you&#x27;ve provided features an anthropomorphic rabbit in spacesuit attire. This rabbit is depicted with human-like posture and movement, standing on a rocky terrain with a vast, reddish-brown landscape in the background. The spacesuit is detailed with mission patches, circuitry, and a helmet that covers the rabbit&#x27;s face and ear, with an illuminated red light on the chest area.\\n\\nThe artwork style is that of a&quot;, name=None, tool_calls=None), logprobs=None)], created=1714589614, id=&#x27;&#x27;, model=&#x27;llava-hf/llava-v1.6-mistral-7b-hf&#x27;, object=&#x27;text_completion&#x27;, system_fingerprint=&#x27;2.0.2-native&#x27;, usage=ChatCompletionOutputUsage(completion_tokens=100, prompt_tokens=2943, total_tokens=3043))</span>
`,wrap:!1}}),N=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># init the client but point it to TGI</span>
client = OpenAI(base_url=<span class="hljs-string">&quot;http://localhost:3000/v1&quot;</span>, api_key=<span class="hljs-string">&quot;-&quot;</span>)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [
                {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Whats in this image?&quot;</span>},
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                    <span class="hljs-string">&quot;image_url&quot;</span>: {
                        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png&quot;</span>
                    },
                },
            ],
        },
    ],
    stream=<span class="hljs-literal">False</span>,
)

<span class="hljs-built_in">print</span>(chat_completion)
<span class="hljs-comment"># ChatCompletion(id=&#x27;&#x27;, choices=[Choice(finish_reason=&#x27;eos_token&#x27;, index=0, logprobs=None, message=ChatCompletionMessage(content=&#x27; The image depicts an anthropomorphic rabbit dressed in a space suit with gear that resembles NASA attire. The setting appears to be a solar eclipse with dramatic mountain peaks and a partial celestial body in the sky. The artwork is detailed and vivid, with a warm color palette and a sense of an adventurous bunny exploring or preparing for a journey beyond Earth. &#x27;, role=&#x27;assistant&#x27;, function_call=None, tool_calls=None))], created=1714589732, model=&#x27;llava-hf/llava-v1.6-mistral-7b-hf&#x27;, object=&#x27;text_completion&#x27;, system_fingerprint=&#x27;2.0.2-native&#x27;, usage=CompletionUsage(completion_tokens=84, prompt_tokens=2943, total_tokens=3027))</span>`,wrap:!1}}),Q=new D({props:{title:"Inference Through Sending cURL Requests",local:"inference-through-sending-curl-requests",headingTag:"h3"}}),q=new c({props:{code:"Y3VybCUyMC1OJTIwMTI3LjAuMC4xJTNBMzAwMCUyRmdlbmVyYXRlX3N0cmVhbSUyMCU1QyUwQSUyMCUyMCUyMCUyMC1YJTIwUE9TVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUyMmlucHV0cyUyMiUzQSUyMiElNUIlNUQoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGdHJhbnNmb3JtZXJzJTJGcmFiYml0LnBuZylXaGF0JTIwaXMlMjB0aGlzJTIwYSUyMHBpY3R1cmUlMjBvZiUzRiU1Q24lNUNuJTIyJTJDJTIycGFyYW1ldGVycyUyMiUzQSU3QiUyMm1heF9uZXdfdG9rZW5zJTIyJTNBMTYlMkMlMjAlMjJzZWVkJTIyJTNBJTIwNDIlN0QlN0QnJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAnQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJyUwQSUwQSUyMyUyMC4uLiUwQSUyMyUyMGRhdGElM0ElN0IlMjJpbmRleCUyMiUzQTE2JTJDJTIydG9rZW4lMjIlM0ElN0IlMjJpZCUyMiUzQTI4NzIzJTJDJTIydGV4dCUyMiUzQSUyMi4lMjIlMkMlMjJsb2dwcm9iJTIyJTNBLTAuNjE5NjI4OSUyQyUyMnNwZWNpYWwlMjIlM0FmYWxzZSU3RCUyQyUyMmdlbmVyYXRlZF90ZXh0JTIyJTNBJTIyVGhpcyUyMGlzJTIwYSUyMHBpY3R1cmUlMjBvZiUyMGFuJTIwYW50aHJvcG9tb3JwaGljJTIwcmFiYml0JTIwaW4lMjBhJTIwc3BhY2UlMjBzdWl0LiUyMiUyQyUyMmRldGFpbHMlMjIlM0FudWxsJTdE",highlighted:`curl -N 127.0.0.1:3000/generate_stream \\
    -X POST \\
    -d <span class="hljs-string">&#x27;{&quot;inputs&quot;:&quot;![](https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png)What is this a picture of?\\n\\n&quot;,&quot;parameters&quot;:{&quot;max_new_tokens&quot;:16, &quot;seed&quot;: 42}}&#x27;</span> \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span>

<span class="hljs-comment"># ...</span>
<span class="hljs-comment"># data:{&quot;index&quot;:16,&quot;token&quot;:{&quot;id&quot;:28723,&quot;text&quot;:&quot;.&quot;,&quot;logprob&quot;:-0.6196289,&quot;special&quot;:false},&quot;generated_text&quot;:&quot;This is a picture of an anthropomorphic rabbit in a space suit.&quot;,&quot;details&quot;:null}</span>`,wrap:!1}}),E=new D({props:{title:"Inference Through JavaScript",local:"inference-through-javascript",headingTag:"h3"}}),v=new c({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNl",highlighted:"npm install @huggingface/inference",wrap:!1}}),X=new c({props:{code:"aW1wb3J0JTIwJTdCJTIwSW5mZXJlbmNlQ2xpZW50JTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTIyJTNCJTBBJTBBY29uc3QlMjBjbGllbnQlMjAlM0QlMjBuZXclMjBJbmZlcmVuY2VDbGllbnQoJ2hmX1lPVVJfVE9LRU4nJTJDJTIwJTdCJTIwZW5kcG9pbnRVcmwlM0ElMjAnaHR0cHMlM0ElMkYlMkZZT1VSX0VORFBPSU5ULmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCclMjAlN0QpJTNCJTBBJTBBY29uc3QlMjBwcm9tcHQlMjAlM0QlMEElMjAlMjAlMjIhJTVCJTVEKGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnRyYW5zZm9ybWVycyUyRnJhYmJpdC5wbmcpV2hhdCUyMGlzJTIwdGhpcyUyMGElMjBwaWN0dXJlJTIwb2YlM0YlNUNuJTVDbiUyMiUzQiUwQSUwQWNvbnN0JTIwc3RyZWFtJTIwJTNEJTIwY2xpZW50LnRleHRHZW5lcmF0aW9uU3RyZWFtKCU3QiUwQSUyMCUyMGlucHV0cyUzQSUyMHByb21wdCUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMjBtYXhfbmV3X3Rva2VucyUzQSUyMDE2JTJDJTIwc2VlZCUzQSUyMDQyJTIwJTdEJTJDJTBBJTdEKSUzQiUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwciUyMG9mJTIwc3RyZWFtKSUyMCU3QiUwQSUyMCUyMCUyRiUyRiUyMHlpZWxkJTIwdGhlJTIwZ2VuZXJhdGVkJTIwdG9rZW4lMEElMjAlMjBwcm9jZXNzLnN0ZG91dC53cml0ZShyLnRva2VuLnRleHQpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwVGhpcyUyMGlzJTIwYSUyMHBpY3R1cmUlMjBvZiUyMGFuJTIwYW50aHJvcG9tb3JwaGljJTIwcmFiYml0JTIwaW4lMjBhJTIwc3BhY2UlMjBzdWl0Lg==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">InferenceClient</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">const</span> client = <span class="hljs-keyword">new</span> <span class="hljs-title class_">InferenceClient</span>(<span class="hljs-string">&#x27;hf_YOUR_TOKEN&#x27;</span>, { <span class="hljs-attr">endpointUrl</span>: <span class="hljs-string">&#x27;https://YOUR_ENDPOINT.endpoints.huggingface.cloud&#x27;</span> });

<span class="hljs-keyword">const</span> prompt =
  <span class="hljs-string">&quot;![](https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png)What is this a picture of?\\n\\n&quot;</span>;

<span class="hljs-keyword">const</span> stream = client.<span class="hljs-title function_">textGenerationStream</span>({
  <span class="hljs-attr">inputs</span>: prompt,
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">16</span>, <span class="hljs-attr">seed</span>: <span class="hljs-number">42</span> },
});
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> r <span class="hljs-keyword">of</span> stream) {
  <span class="hljs-comment">// yield the generated token</span>
  process.<span class="hljs-property">stdout</span>.<span class="hljs-title function_">write</span>(r.<span class="hljs-property">token</span>.<span class="hljs-property">text</span>);
}

<span class="hljs-comment">// This is a picture of an anthropomorphic rabbit in a space suit.</span>`,wrap:!1}}),x=new D({props:{title:"Combining Vision Language Models with Other Features",local:"combining-vision-language-models-with-other-features",headingTag:"h2"}}),z=new c({props:{code:"JTdCJTBBJTIwJTIwJTIyYWN0aXZpdHklMjIlM0ElMjAlMjJTdGFuZGluZyUyMiUyQyUwQSUyMCUyMCUyMmFuaW1hbHMlMjIlM0ElMjAlNUIlMjJSYWJiaXQlMjIlNUQlMkMlMEElMjAlMjAlMjJhbmltYWxzX3NlZW4lMjIlM0ElMjAxJTJDJTBBJTIwJTIwJTIybG9jYXRpb24lMjIlM0ElMjAlMjJSb2NreSUyMHN1cmZhY2UlMjB3aXRoJTIwbW91bnRhaW5zJTIwaW4lMjB0aGUlMjBiYWNrZ3JvdW5kJTIwYW5kJTIwYSUyMHJlZCUyMGxpZ2h0JTIwb24lMjB0aGUlMjByYWJiaXQncyUyMGNoZXN0JTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;activity&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Standing&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;animals&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;Rabbit&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;animals_seen&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Rocky surface with mountains in the background and a red light on the rabbit&#x27;s chest&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),$=new c({props:{code:"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",highlighted:`curl localhost:3000/generate \\
    -X POST \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> \\
    -d <span class="hljs-string">&#x27;{
    &quot;inputs&quot;:&quot;![](https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png)What is this a picture of?\\n\\n&quot;,
    &quot;parameters&quot;: {
        &quot;max_new_tokens&quot;: 100,
        &quot;seed&quot;: 42,
        &quot;grammar&quot;: {
            &quot;type&quot;: &quot;json&quot;,
            &quot;value&quot;: {
                &quot;properties&quot;: {
                    &quot;location&quot;: {
                        &quot;type&quot;: &quot;string&quot;
                    },
                    &quot;activity&quot;: {
                        &quot;type&quot;: &quot;string&quot;
                    },
                    &quot;animals_seen&quot;: {
                        &quot;type&quot;: &quot;integer&quot;,
                        &quot;minimum&quot;: 1,
                        &quot;maximum&quot;: 5
                    },
                    &quot;animals&quot;: {
                        &quot;type&quot;: &quot;array&quot;,
                        &quot;items&quot;: {
                            &quot;type&quot;: &quot;string&quot;
                        }
                    }
                },
                &quot;required&quot;: [&quot;location&quot;, &quot;activity&quot;, &quot;animals_seen&quot;, &quot;animals&quot;]
            }
        }
    }
}&#x27;</span>

<span class="hljs-comment"># {</span>
<span class="hljs-comment">#   &quot;generated_text&quot;: &quot;{ \\&quot;activity\\&quot;: \\&quot;Standing\\&quot;, \\&quot;animals\\&quot;: [ \\&quot;Rabbit\\&quot; ], \\&quot;animals_seen\\&quot;: 1, \\&quot;location\\&quot;: \\&quot;Rocky surface with mountains in the background and a red light on the rabbit&#x27;s chest\\&quot; }&quot;</span>
<span class="hljs-comment"># }</span>`,wrap:!1}}),L=new JM({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/basic_tutorials/visual_language_models.md"}}),{c(){w=n("meta"),K=s(),P=n("p"),ll=s(),U(I.$$.fragment),Ml=s(),C=n("p"),C.textContent=Rl,tl=s(),m=n("p"),m.textContent=vl,el=s(),r=n("blockquote"),r.innerHTML=Vl,sl=s(),h=n("p"),h.textContent=kl,al=s(),d=n("ul"),d.innerHTML=Xl,nl=s(),U(b.$$.fragment),yl=s(),U(A.$$.fragment),Jl=s(),g=n("p"),g.innerHTML=xl,Ul=s(),U(G.$$.fragment),il=s(),U(Z.$$.fragment),ol=s(),f=n("p"),f.innerHTML=Sl,jl=s(),U(B.$$.fragment),Tl=s(),W=n("p"),W.innerHTML=Hl,pl=s(),U(N.$$.fragment),wl=s(),U(Q.$$.fragment),cl=s(),Y=n("p"),Y.innerHTML=zl,ul=s(),U(q.$$.fragment),Il=s(),U(E.$$.fragment),Cl=s(),R=n("p"),R.innerHTML=Fl,ml=s(),U(v.$$.fragment),rl=s(),V=n("p"),V.innerHTML=$l,hl=s(),k=n("p"),k.innerHTML=_l,dl=s(),U(X.$$.fragment),bl=s(),U(x.$$.fragment),Al=s(),S=n("p"),S.innerHTML=Ll,gl=s(),u=n("div"),u.innerHTML=Dl,Gl=s(),H=n("p"),H.textContent=Pl,Zl=s(),U(z.$$.fragment),fl=s(),F=n("p"),F.textContent=Ol,Bl=s(),U($.$$.fragment),Wl=s(),_=n("p"),_.innerHTML=Kl,Nl=s(),U(L.$$.fragment),Ql=s(),O=n("p"),this.h()},l(l){const M=nM("svelte-u9bgzb",document.head);w=y(M,"META",{name:!0,content:!0}),M.forEach(t),K=a(l),P=y(l,"P",{}),lM(P).forEach(t),ll=a(l),i(I.$$.fragment,l),Ml=a(l),C=y(l,"P",{"data-svelte-h":!0}),J(C)!=="svelte-c5mqsg"&&(C.textContent=Rl),tl=a(l),m=y(l,"P",{"data-svelte-h":!0}),J(m)!=="svelte-bme3bd"&&(m.textContent=vl),el=a(l),r=y(l,"BLOCKQUOTE",{"data-svelte-h":!0}),J(r)!=="svelte-oo54gt"&&(r.innerHTML=Vl),sl=a(l),h=y(l,"P",{"data-svelte-h":!0}),J(h)!=="svelte-1u3863s"&&(h.textContent=kl),al=a(l),d=y(l,"UL",{"data-svelte-h":!0}),J(d)!=="svelte-9wqdub"&&(d.innerHTML=Xl),nl=a(l),i(b.$$.fragment,l),yl=a(l),i(A.$$.fragment,l),Jl=a(l),g=y(l,"P",{"data-svelte-h":!0}),J(g)!=="svelte-fwtu6p"&&(g.innerHTML=xl),Ul=a(l),i(G.$$.fragment,l),il=a(l),i(Z.$$.fragment,l),ol=a(l),f=y(l,"P",{"data-svelte-h":!0}),J(f)!=="svelte-1bhwrgr"&&(f.innerHTML=Sl),jl=a(l),i(B.$$.fragment,l),Tl=a(l),W=y(l,"P",{"data-svelte-h":!0}),J(W)!=="svelte-6ske6k"&&(W.innerHTML=Hl),pl=a(l),i(N.$$.fragment,l),wl=a(l),i(Q.$$.fragment,l),cl=a(l),Y=y(l,"P",{"data-svelte-h":!0}),J(Y)!=="svelte-omocvk"&&(Y.innerHTML=zl),ul=a(l),i(q.$$.fragment,l),Il=a(l),i(E.$$.fragment,l),Cl=a(l),R=y(l,"P",{"data-svelte-h":!0}),J(R)!=="svelte-1qcvblx"&&(R.innerHTML=Fl),ml=a(l),i(v.$$.fragment,l),rl=a(l),V=y(l,"P",{"data-svelte-h":!0}),J(V)!=="svelte-1jcra9t"&&(V.innerHTML=$l),hl=a(l),k=y(l,"P",{"data-svelte-h":!0}),J(k)!=="svelte-3gec97"&&(k.innerHTML=_l),dl=a(l),i(X.$$.fragment,l),bl=a(l),i(x.$$.fragment,l),Al=a(l),S=y(l,"P",{"data-svelte-h":!0}),J(S)!=="svelte-kstfyt"&&(S.innerHTML=Ll),gl=a(l),u=y(l,"DIV",{class:!0,"data-svelte-h":!0}),J(u)!=="svelte-vm0v0f"&&(u.innerHTML=Dl),Gl=a(l),H=y(l,"P",{"data-svelte-h":!0}),J(H)!=="svelte-1fqoo0l"&&(H.textContent=Pl),Zl=a(l),i(z.$$.fragment,l),fl=a(l),F=y(l,"P",{"data-svelte-h":!0}),J(F)!=="svelte-4bcx48"&&(F.textContent=Ol),Bl=a(l),i($.$$.fragment,l),Wl=a(l),_=y(l,"P",{"data-svelte-h":!0}),J(_)!=="svelte-am908w"&&(_.innerHTML=Kl),Nl=a(l),i(L.$$.fragment,l),Ql=a(l),O=y(l,"P",{}),lM(O).forEach(t),this.h()},h(){ql(w,"name","hf:doc:metadata"),ql(w,"content",iM),ql(u,"class","flex justify-center")},m(l,M){yM(document.head,w),e(l,K,M),e(l,P,M),e(l,ll,M),o(I,l,M),e(l,Ml,M),e(l,C,M),e(l,tl,M),e(l,m,M),e(l,el,M),e(l,r,M),e(l,sl,M),e(l,h,M),e(l,al,M),e(l,d,M),e(l,nl,M),o(b,l,M),e(l,yl,M),o(A,l,M),e(l,Jl,M),e(l,g,M),e(l,Ul,M),o(G,l,M),e(l,il,M),o(Z,l,M),e(l,ol,M),e(l,f,M),e(l,jl,M),o(B,l,M),e(l,Tl,M),e(l,W,M),e(l,pl,M),o(N,l,M),e(l,wl,M),o(Q,l,M),e(l,cl,M),e(l,Y,M),e(l,ul,M),o(q,l,M),e(l,Il,M),o(E,l,M),e(l,Cl,M),e(l,R,M),e(l,ml,M),o(v,l,M),e(l,rl,M),e(l,V,M),e(l,hl,M),e(l,k,M),e(l,dl,M),o(X,l,M),e(l,bl,M),o(x,l,M),e(l,Al,M),e(l,S,M),e(l,gl,M),e(l,u,M),e(l,Gl,M),e(l,H,M),e(l,Zl,M),o(z,l,M),e(l,fl,M),e(l,F,M),e(l,Bl,M),o($,l,M),e(l,Wl,M),e(l,_,M),e(l,Nl,M),o(L,l,M),e(l,Ql,M),e(l,O,M),Yl=!0},p:tM,i(l){Yl||(j(I.$$.fragment,l),j(b.$$.fragment,l),j(A.$$.fragment,l),j(G.$$.fragment,l),j(Z.$$.fragment,l),j(B.$$.fragment,l),j(N.$$.fragment,l),j(Q.$$.fragment,l),j(q.$$.fragment,l),j(E.$$.fragment,l),j(v.$$.fragment,l),j(X.$$.fragment,l),j(x.$$.fragment,l),j(z.$$.fragment,l),j($.$$.fragment,l),j(L.$$.fragment,l),Yl=!0)},o(l){T(I.$$.fragment,l),T(b.$$.fragment,l),T(A.$$.fragment,l),T(G.$$.fragment,l),T(Z.$$.fragment,l),T(B.$$.fragment,l),T(N.$$.fragment,l),T(Q.$$.fragment,l),T(q.$$.fragment,l),T(E.$$.fragment,l),T(v.$$.fragment,l),T(X.$$.fragment,l),T(x.$$.fragment,l),T(z.$$.fragment,l),T($.$$.fragment,l),T(L.$$.fragment,l),Yl=!1},d(l){l&&(t(K),t(P),t(ll),t(Ml),t(C),t(tl),t(m),t(el),t(r),t(sl),t(h),t(al),t(d),t(nl),t(yl),t(Jl),t(g),t(Ul),t(il),t(ol),t(f),t(jl),t(Tl),t(W),t(pl),t(wl),t(cl),t(Y),t(ul),t(Il),t(Cl),t(R),t(ml),t(rl),t(V),t(hl),t(k),t(dl),t(bl),t(Al),t(S),t(gl),t(u),t(Gl),t(H),t(Zl),t(fl),t(F),t(Bl),t(Wl),t(_),t(Nl),t(Ql),t(O)),t(w),p(I,l),p(b,l),p(A,l),p(G,l),p(Z,l),p(B,l),p(N,l),p(Q,l),p(q,l),p(E,l),p(v,l),p(X,l),p(x,l),p(z,l),p($,l),p(L,l)}}}const iM='{"title":"Vision Language Model Inference in TGI","local":"vision-language-model-inference-in-tgi","sections":[{"title":"How to Use a Vision Language Model?","local":"how-to-use-a-vision-language-model","sections":[{"title":"Hugging Face Hub Python Library","local":"hugging-face-hub-python-library","sections":[],"depth":3},{"title":"Inference Through Sending cURL Requests","local":"inference-through-sending-curl-requests","sections":[],"depth":3},{"title":"Inference Through JavaScript","local":"inference-through-javascript","sections":[],"depth":3}],"depth":2},{"title":"Combining Vision Language Models with Other Features","local":"combining-vision-language-models-with-other-features","sections":[],"depth":2}],"depth":1}';function oM(El){return eM(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cM extends sM{constructor(w){super(),aM(this,w,oM,UM,MM,{})}}export{cM as component};
