import{s as at,n as rt,o as it}from"../chunks/scheduler.182ea377.js";import{S as lt,i as dt,g as i,s as o,r as u,A as ct,h as l,f as n,c as s,j as y,u as f,x as b,k as _,y as t,a as c,v as p,d as m,t as h,w as g}from"../chunks/index.abf12888.js";import{D as w}from"../chunks/Docstring.93f6f462.js";import{C as st}from"../chunks/CodeBlock.57fe6e13.js";import{H as Se}from"../chunks/Heading.16916d63.js";function ut(Le){let T,ae,oe,re,A,ie,Z,Ne='Tiny AutoEncoder for Stable Diffusion (TAESD) was introduced in <a href="https://github.com/madebyollin/taesd" rel="nofollow">madebyollin/taesd</a> by Ollin Boer Bohan. It is a tiny distilled version of Stable Diffusion’s VAE that can quickly decode the latents in a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> or <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a> almost instantly.',le,C,Ye="To use with Stable Diffusion v-2.1:",de,E,ce,V,qe="To use with Stable Diffusion XL 1.0",ue,W,fe,j,pe,a,I,xe,q,Fe="A tiny distilled VAE model for encoding images into latents and decoding latent representations into images.",Je,F,ze='<a href="/docs/diffusers/main/en/api/models/autoencoder_tiny#diffusers.AutoencoderTiny">AutoencoderTiny</a> is a wrapper around the original implementation of <code>TAESD</code>.',Ue,z,Pe=`This model inherits from <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a>. Check the superclass documentation for its generic methods implemented for
all models (such as downloading or saving).`,ke,$,G,Ae,P,He=`Disable sliced VAE decoding. If <code>enable_slicing</code> was previously enabled, this method will go back to computing
decoding in one step.`,Ze,M,B,Ce,H,Qe=`Disable tiled VAE decoding. If <code>enable_tiling</code> was previously enabled, this method will go back to computing
decoding in one step.`,Ee,x,X,Ve,Q,Oe=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,We,J,D,je,O,Ke=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Ie,K,R,Ge,U,S,Be,ee,et="raw latents -> [0, 1]",Xe,k,L,De,te,tt="[0, 1] -> raw latents",me,N,he,v,Y,Re,ne,nt="Output of AutoencoderTiny encoding method.",ge,se,be;return A=new Se({props:{title:"Tiny AutoEncoder",local:"tiny-autoencoder",headingTag:"h1"}}),E=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBBdXRvZW5jb2RlclRpbnklMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0yLTEtYmFzZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyVGlueS5mcm9tX3ByZXRyYWluZWQoJTIybWFkZWJ5b2xsaW4lMkZ0YWVzZCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMnNsaWNlJTIwb2YlMjBkZWxpY2lvdXMlMjBOZXclMjBZb3JrLXN0eWxlJTIwYmVycnklMjBjaGVlc2VjYWtlJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyY2hlZXNlY2FrZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, AutoencoderTiny

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1-base&quot;</span>, torch_dtype=torch.float16
)
pipe.vae = AutoencoderTiny.from_pretrained(<span class="hljs-string">&quot;madebyollin/taesd&quot;</span>, torch_dtype=torch.float16)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;slice of delicious New York-style berry cheesecake&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cheesecake.png&quot;</span>)`,wrap:!1}}),W=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBBdXRvZW5jb2RlclRpbnklMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyVGlueS5mcm9tX3ByZXRyYWluZWQoJTIybWFkZWJ5b2xsaW4lMkZ0YWVzZHhsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyc2xpY2UlMjBvZiUyMGRlbGljaW91cyUyME5ldyUyMFlvcmstc3R5bGUlMjBiZXJyeSUyMGNoZWVzZWNha2UlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJjaGVlc2VjYWtlX3NkeGwucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, AutoencoderTiny

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
)
pipe.vae = AutoencoderTiny.from_pretrained(<span class="hljs-string">&quot;madebyollin/taesdxl&quot;</span>, torch_dtype=torch.float16)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;slice of delicious New York-style berry cheesecake&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cheesecake_sdxl.png&quot;</span>)`,wrap:!1}}),j=new Se({props:{title:"AutoencoderTiny",local:"diffusers.AutoencoderTiny",headingTag:"h2"}}),I=new w({props:{name:"class diffusers.AutoencoderTiny",anchor:"diffusers.AutoencoderTiny",parameters:[{name:"in_channels",val:" = 3"},{name:"out_channels",val:" = 3"},{name:"encoder_block_out_channels",val:": typing.Tuple[int] = (64, 64, 64, 64)"},{name:"decoder_block_out_channels",val:": typing.Tuple[int] = (64, 64, 64, 64)"},{name:"act_fn",val:": str = 'relu'"},{name:"latent_channels",val:": int = 4"},{name:"upsampling_scaling_factor",val:": int = 2"},{name:"num_encoder_blocks",val:": typing.Tuple[int] = (1, 3, 3, 3)"},{name:"num_decoder_blocks",val:": typing.Tuple[int] = (3, 3, 3, 1)"},{name:"latent_magnitude",val:": int = 3"},{name:"latent_shift",val:": float = 0.5"},{name:"force_upcast",val:": float = False"},{name:"scaling_factor",val:": float = 1.0"}],parametersDescription:[{anchor:"diffusers.AutoencoderTiny.in_channels",description:"<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014; Number of channels in the input image.",name:"in_channels"},{anchor:"diffusers.AutoencoderTiny.out_channels",description:"<strong>out_channels</strong> (<code>int</code>,  <em>optional</em>, defaults to 3) &#x2014; Number of channels in the output.",name:"out_channels"},{anchor:"diffusers.AutoencoderTiny.encoder_block_out_channels",description:`<strong>encoder_block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(64, 64, 64, 64)</code>) &#x2014;
Tuple of integers representing the number of output channels for each encoder block. The length of the
tuple should be equal to the number of encoder blocks.`,name:"encoder_block_out_channels"},{anchor:"diffusers.AutoencoderTiny.decoder_block_out_channels",description:`<strong>decoder_block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(64, 64, 64, 64)</code>) &#x2014;
Tuple of integers representing the number of output channels for each decoder block. The length of the
tuple should be equal to the number of decoder blocks.`,name:"decoder_block_out_channels"},{anchor:"diffusers.AutoencoderTiny.act_fn",description:`<strong>act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
Activation function to be used throughout the model.`,name:"act_fn"},{anchor:"diffusers.AutoencoderTiny.latent_channels",description:`<strong>latent_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of channels in the latent representation. The latent space acts as a compressed representation of
the input image.`,name:"latent_channels"},{anchor:"diffusers.AutoencoderTiny.upsampling_scaling_factor",description:`<strong>upsampling_scaling_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Scaling factor for upsampling in the decoder. It determines the size of the output image during the
upsampling process.`,name:"upsampling_scaling_factor"},{anchor:"diffusers.AutoencoderTiny.num_encoder_blocks",description:`<strong>num_encoder_blocks</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(1, 3, 3, 3)</code>) &#x2014;
Tuple of integers representing the number of encoder blocks at each stage of the encoding process. The
length of the tuple should be equal to the number of stages in the encoder. Each stage has a different
number of encoder blocks.`,name:"num_encoder_blocks"},{anchor:"diffusers.AutoencoderTiny.num_decoder_blocks",description:`<strong>num_decoder_blocks</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(3, 3, 3, 1)</code>) &#x2014;
Tuple of integers representing the number of decoder blocks at each stage of the decoding process. The
length of the tuple should be equal to the number of stages in the decoder. Each stage has a different
number of decoder blocks.`,name:"num_decoder_blocks"},{anchor:"diffusers.AutoencoderTiny.latent_magnitude",description:`<strong>latent_magnitude</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
Magnitude of the latent representation. This parameter scales the latent representation values to control
the extent of information preservation.`,name:"latent_magnitude"},{anchor:"diffusers.AutoencoderTiny.latent_shift",description:`<strong>latent_shift</strong> (float, <em>optional</em>, defaults to 0.5) &#x2014;
Shift applied to the latent representation. This parameter controls the center of the latent space.`,name:"latent_shift"},{anchor:"diffusers.AutoencoderTiny.scaling_factor",description:`<strong>scaling_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The component-wise standard deviation of the trained latent space computed using the first batch of the
training set. This is used to scale the latent space to have unit variance when training the diffusion
model. The latents are scaled with the formula <code>z = z * scaling_factor</code> before being passed to the
diffusion model. When decoding, the latents are scaled back to the original scale with the formula: <code>z = 1 / scaling_factor * z</code>. For more details, refer to sections 4.3.2 and D.1 of the <a href="https://arxiv.org/abs/2112.10752" rel="nofollow">High-Resolution Image
Synthesis with Latent Diffusion Models</a> paper. For this Autoencoder,
however, no such scaling factor was used, hence the value of 1.0 as the default.`,name:"scaling_factor"},{anchor:"diffusers.AutoencoderTiny.force_upcast",description:`<strong>force_upcast</strong> (<code>bool</code>, <em>optional</em>, default to <code>False</code>) &#x2014;
If enabled it will force the VAE to run in float32 for high image resolution pipelines, such as SD-XL. VAE
can be fine-tuned / trained to a lower range without losing too much precision, in which case
<code>force_upcast</code> can be set to <code>False</code> (see this fp16-friendly
<a href="https://huggingface.co/madebyollin/sdxl-vae-fp16-fix" rel="nofollow">AutoEncoder</a>).`,name:"force_upcast"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoder_tiny.py#L41"}}),G=new w({props:{name:"disable_slicing",anchor:"diffusers.AutoencoderTiny.disable_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoder_tiny.py#L169"}}),B=new w({props:{name:"disable_tiling",anchor:"diffusers.AutoencoderTiny.disable_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoder_tiny.py#L184"}}),X=new w({props:{name:"enable_slicing",anchor:"diffusers.AutoencoderTiny.enable_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoder_tiny.py#L162"}}),D=new w({props:{name:"enable_tiling",anchor:"diffusers.AutoencoderTiny.enable_tiling",parameters:[{name:"use_tiling",val:": bool = True"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoder_tiny.py#L176"}}),R=new w({props:{name:"forward",anchor:"diffusers.AutoencoderTiny.forward",parameters:[{name:"sample",val:": FloatTensor"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.AutoencoderTiny.forward.sample",description:"<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014; Input sample.",name:"sample"},{anchor:"diffusers.AutoencoderTiny.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>DecoderOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoder_tiny.py#L324"}}),S=new w({props:{name:"scale_latents",anchor:"diffusers.AutoencoderTiny.scale_latents",parameters:[{name:"x",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoder_tiny.py#L154"}}),L=new w({props:{name:"unscale_latents",anchor:"diffusers.AutoencoderTiny.unscale_latents",parameters:[{name:"x",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoder_tiny.py#L158"}}),N=new Se({props:{title:"AutoencoderTinyOutput",local:"diffusers.models.autoencoder_tiny.AutoencoderTinyOutput",headingTag:"h2"}}),Y=new w({props:{name:"class diffusers.models.autoencoder_tiny.AutoencoderTinyOutput",anchor:"diffusers.models.autoencoder_tiny.AutoencoderTinyOutput",parameters:[{name:"latents",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.models.autoencoder_tiny.AutoencoderTinyOutput.latents",description:"<strong>latents</strong> (<code>torch.Tensor</code>) &#x2014; Encoded outputs of the <code>Encoder</code>.",name:"latents"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/autoencoder_tiny.py#L29"}}),{c(){T=i("meta"),ae=o(),oe=i("p"),re=o(),u(A.$$.fragment),ie=o(),Z=i("p"),Z.innerHTML=Ne,le=o(),C=i("p"),C.textContent=Ye,de=o(),u(E.$$.fragment),ce=o(),V=i("p"),V.textContent=qe,ue=o(),u(W.$$.fragment),fe=o(),u(j.$$.fragment),pe=o(),a=i("div"),u(I.$$.fragment),xe=o(),q=i("p"),q.textContent=Fe,Je=o(),F=i("p"),F.innerHTML=ze,Ue=o(),z=i("p"),z.innerHTML=Pe,ke=o(),$=i("div"),u(G.$$.fragment),Ae=o(),P=i("p"),P.innerHTML=He,Ze=o(),M=i("div"),u(B.$$.fragment),Ce=o(),H=i("p"),H.innerHTML=Qe,Ee=o(),x=i("div"),u(X.$$.fragment),Ve=o(),Q=i("p"),Q.textContent=Oe,We=o(),J=i("div"),u(D.$$.fragment),je=o(),O=i("p"),O.textContent=Ke,Ie=o(),K=i("div"),u(R.$$.fragment),Ge=o(),U=i("div"),u(S.$$.fragment),Be=o(),ee=i("p"),ee.textContent=et,Xe=o(),k=i("div"),u(L.$$.fragment),De=o(),te=i("p"),te.textContent=tt,me=o(),u(N.$$.fragment),he=o(),v=i("div"),u(Y.$$.fragment),Re=o(),ne=i("p"),ne.textContent=nt,ge=o(),se=i("p"),this.h()},l(e){const r=ct("svelte-u9bgzb",document.head);T=l(r,"META",{name:!0,content:!0}),r.forEach(n),ae=s(e),oe=l(e,"P",{}),y(oe).forEach(n),re=s(e),f(A.$$.fragment,e),ie=s(e),Z=l(e,"P",{"data-svelte-h":!0}),b(Z)!=="svelte-18sualu"&&(Z.innerHTML=Ne),le=s(e),C=l(e,"P",{"data-svelte-h":!0}),b(C)!=="svelte-1j0g63g"&&(C.textContent=Ye),de=s(e),f(E.$$.fragment,e),ce=s(e),V=l(e,"P",{"data-svelte-h":!0}),b(V)!=="svelte-dyqzt3"&&(V.textContent=qe),ue=s(e),f(W.$$.fragment,e),fe=s(e),f(j.$$.fragment,e),pe=s(e),a=l(e,"DIV",{class:!0});var d=y(a);f(I.$$.fragment,d),xe=s(d),q=l(d,"P",{"data-svelte-h":!0}),b(q)!=="svelte-pqpiv3"&&(q.textContent=Fe),Je=s(d),F=l(d,"P",{"data-svelte-h":!0}),b(F)!=="svelte-1otkjue"&&(F.innerHTML=ze),Ue=s(d),z=l(d,"P",{"data-svelte-h":!0}),b(z)!=="svelte-1j6sdev"&&(z.innerHTML=Pe),ke=s(d),$=l(d,"DIV",{class:!0});var ye=y($);f(G.$$.fragment,ye),Ae=s(ye),P=l(ye,"P",{"data-svelte-h":!0}),b(P)!=="svelte-189cc7b"&&(P.innerHTML=He),ye.forEach(n),Ze=s(d),M=l(d,"DIV",{class:!0});var _e=y(M);f(B.$$.fragment,_e),Ce=s(_e),H=l(_e,"P",{"data-svelte-h":!0}),b(H)!=="svelte-1f366pl"&&(H.innerHTML=Qe),_e.forEach(n),Ee=s(d),x=l(d,"DIV",{class:!0});var Te=y(x);f(X.$$.fragment,Te),Ve=s(Te),Q=l(Te,"P",{"data-svelte-h":!0}),b(Q)!=="svelte-14bnrb6"&&(Q.textContent=Oe),Te.forEach(n),We=s(d),J=l(d,"DIV",{class:!0});var ve=y(J);f(D.$$.fragment,ve),je=s(ve),O=l(ve,"P",{"data-svelte-h":!0}),b(O)!=="svelte-1xwrf7t"&&(O.textContent=Ke),ve.forEach(n),Ie=s(d),K=l(d,"DIV",{class:!0});var ot=y(K);f(R.$$.fragment,ot),ot.forEach(n),Ge=s(d),U=l(d,"DIV",{class:!0});var we=y(U);f(S.$$.fragment,we),Be=s(we),ee=l(we,"P",{"data-svelte-h":!0}),b(ee)!=="svelte-1jovd99"&&(ee.textContent=et),we.forEach(n),Xe=s(d),k=l(d,"DIV",{class:!0});var $e=y(k);f(L.$$.fragment,$e),De=s($e),te=l($e,"P",{"data-svelte-h":!0}),b(te)!=="svelte-hggkbx"&&(te.textContent=tt),$e.forEach(n),d.forEach(n),me=s(e),f(N.$$.fragment,e),he=s(e),v=l(e,"DIV",{class:!0});var Me=y(v);f(Y.$$.fragment,Me),Re=s(Me),ne=l(Me,"P",{"data-svelte-h":!0}),b(ne)!=="svelte-11to6kt"&&(ne.textContent=nt),Me.forEach(n),ge=s(e),se=l(e,"P",{}),y(se).forEach(n),this.h()},h(){_(T,"name","hf:doc:metadata"),_(T,"content",ft),_($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(a,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){t(document.head,T),c(e,ae,r),c(e,oe,r),c(e,re,r),p(A,e,r),c(e,ie,r),c(e,Z,r),c(e,le,r),c(e,C,r),c(e,de,r),p(E,e,r),c(e,ce,r),c(e,V,r),c(e,ue,r),p(W,e,r),c(e,fe,r),p(j,e,r),c(e,pe,r),c(e,a,r),p(I,a,null),t(a,xe),t(a,q),t(a,Je),t(a,F),t(a,Ue),t(a,z),t(a,ke),t(a,$),p(G,$,null),t($,Ae),t($,P),t(a,Ze),t(a,M),p(B,M,null),t(M,Ce),t(M,H),t(a,Ee),t(a,x),p(X,x,null),t(x,Ve),t(x,Q),t(a,We),t(a,J),p(D,J,null),t(J,je),t(J,O),t(a,Ie),t(a,K),p(R,K,null),t(a,Ge),t(a,U),p(S,U,null),t(U,Be),t(U,ee),t(a,Xe),t(a,k),p(L,k,null),t(k,De),t(k,te),c(e,me,r),p(N,e,r),c(e,he,r),c(e,v,r),p(Y,v,null),t(v,Re),t(v,ne),c(e,ge,r),c(e,se,r),be=!0},p:rt,i(e){be||(m(A.$$.fragment,e),m(E.$$.fragment,e),m(W.$$.fragment,e),m(j.$$.fragment,e),m(I.$$.fragment,e),m(G.$$.fragment,e),m(B.$$.fragment,e),m(X.$$.fragment,e),m(D.$$.fragment,e),m(R.$$.fragment,e),m(S.$$.fragment,e),m(L.$$.fragment,e),m(N.$$.fragment,e),m(Y.$$.fragment,e),be=!0)},o(e){h(A.$$.fragment,e),h(E.$$.fragment,e),h(W.$$.fragment,e),h(j.$$.fragment,e),h(I.$$.fragment,e),h(G.$$.fragment,e),h(B.$$.fragment,e),h(X.$$.fragment,e),h(D.$$.fragment,e),h(R.$$.fragment,e),h(S.$$.fragment,e),h(L.$$.fragment,e),h(N.$$.fragment,e),h(Y.$$.fragment,e),be=!1},d(e){e&&(n(ae),n(oe),n(re),n(ie),n(Z),n(le),n(C),n(de),n(ce),n(V),n(ue),n(fe),n(pe),n(a),n(me),n(he),n(v),n(ge),n(se)),n(T),g(A,e),g(E,e),g(W,e),g(j,e),g(I),g(G),g(B),g(X),g(D),g(R),g(S),g(L),g(N,e),g(Y)}}}const ft='{"title":"Tiny AutoEncoder","local":"tiny-autoencoder","sections":[{"title":"AutoencoderTiny","local":"diffusers.AutoencoderTiny","sections":[],"depth":2},{"title":"AutoencoderTinyOutput","local":"diffusers.models.autoencoder_tiny.AutoencoderTinyOutput","sections":[],"depth":2}],"depth":1}';function pt(Le){return it(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _t extends lt{constructor(T){super(),dt(this,T,pt,ut,at,{})}}export{_t as component};
