import{s as sp,n as np,o as op}from"../chunks/scheduler.b108d059.js";import{S as ip,i as rp,g as i,s as n,r as a,A as dp,h as r,f as l,c as o,j as h,u as m,x as d,k as u,y as up,a as s,v as p,d as c,t as f,w as T}from"../chunks/index.008de539.js";import{C as Eu}from"../chunks/CodeBlock.3968c746.js";import{H as _}from"../chunks/Heading.88bfeb84.js";function ap(ku){let $,Rs,gs,zs,v,js,y,Js,b,Du="Helper module for <code>Tensor</code> processing.",Es,M,Iu=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,ks,x,qu='<li><a href="#module_utils/tensor">utils/tensor</a><ul><li><em>static</em><ul><li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+transpose"><code>.transpose(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><a href="#module_utils/tensor.transpose"><code>.transpose(tensor, axes)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.interpolate"><code>.interpolate(input, size, mode, align_corners)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.mean_pooling"><code>.mean_pooling(last_hidden_state, attention_mask)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.cat"><code>.cat(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.stack"><code>.stack(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.std_mean"><code>.std_mean(input, dim, correction, keepdim)</code></a> ⇒ <code>Array.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.mean"><code>.mean(input, dim, keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.dynamicTimeWarping"><code>.dynamicTimeWarping(matrix)</code></a> ⇒ <code>Array.&lt;Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/tensor.ones"><code>.ones(size)</code></a></li> <li><a href="#module_utils/tensor.ones_like"><code>.ones_like(tensor)</code></a> ⇒</li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/tensor..ONNXTensor"><code>~ONNXTensor</code></a> : <code>Object</code></li> <li><a href="#module_utils/tensor..reshape"><code>~reshape(data, dimensions)</code></a> ⇒ <code>*</code><ul><li><a href="#module_utils/tensor..reshape..reshapedArray"><code>~reshapedArray</code></a> : <code>any</code></li></ul></li> <li><a href="#module_utils/tensor..DataArray"><code>~DataArray</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..NestArray"><code>~NestArray</code></a> : <code>*</code></li></ul></li></ul></li>',Ds,Is,qs,C,Ns,H,Ks,L,Nu='<strong>Kind</strong>: static class of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Vs,w,Ku='<li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+transpose"><code>.transpose(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li>',Bs,Qs,Ss,A,Os,U,Ws,g,Vu="Create a new Tensor or copy an existing Tensor.",Ys,P,Bu="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",Fs,Xs,Gs,R,Zs,z,en,j,Qu=`Returns an iterator object for iterating over the tensor data in row-major order.
If the tensor has more than one dimension, the iterator will yield subarrays.`,tn,J,Su='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Iterator</code> - An iterator object for iterating over the tensor data in row-major order.',ln,sn,nn,E,on,k,rn,D,Ou="Index into a Tensor object.",dn,I,Wu='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The data at the specified index.',un,q,Yu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td><td><p>The index to access.</p></td></tr></tbody>",an,mn,pn,N,cn,K,fn,V,Fu='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the first occurrence of item in the tensor data.',Tn,B,Xu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>number</code> | <code>bigint</code></td><td><p>The item to search for in the tensor</p></td></tr></tbody>",hn,_n,$n,Q,vn,S,yn,O,Gu='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',bn,W,Zu="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td> </tr><tr><td>iterSize</td><td><code>number</code></td> </tr><tr><td>iterDims</td><td><code>any</code></td></tr></tbody>",Mn,xn,Cn,Y,Hn,F,Ln,X,ea=`Returns the value of this tensor as a standard JavaScript Number. This only works
for tensors with one element. For other cases, see <code>Tensor.tolist()</code>.`,wn,G,ta='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The value of this tensor as a standard JavaScript Number.<br/> <strong>Throws</strong>:',An,Z,la="<li><code>Error</code> If the tensor has more than one element.</li>",Un,gn,Pn,ee,Rn,te,zn,le,sa="Convert tensor data to a n-dimensional JS list",jn,se,na='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Jn,En,kn,ne,Dn,oe,In,ie,oa="Return a new Tensor with the sigmoid function applied to each element.",qn,re,ia='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the sigmoid function applied.',Nn,Kn,Vn,de,Bn,ue,Qn,ae,ra="Applies the sigmoid function to the tensor in place.",Sn,me,da='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',On,Wn,Yn,pe,Fn,ce,Xn,fe,ua="Return a new Tensor with every element multiplied by a constant.",Gn,Te,aa='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',Zn,he,ma="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",eo,to,lo,_e,so,$e,no,ve,pa="Multiply the tensor by a constant in place.",oo,ye,ca='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',io,be,fa="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",ro,uo,ao,Me,mo,xe,po,Ce,Ta="Return a new Tensor with every element added by a constant.",co,He,ha='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',fo,Le,_a="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",To,ho,_o,we,$o,Ae,vo,Ue,$a="Add the tensor by a constant in place.",yo,ge,va='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',bo,Pe,ya="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",Mo,xo,Co,Re,Ho,ze,Lo,je,ba="Return a transposed version of this Tensor, according to the provided dimensions.",wo,Je,Ma='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The transposed tensor.',Ao,Ee,xa="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>Dimensions to transpose.</p></td></tr></tbody>",Uo,go,Po,ke,Ro,De,zo,Ie,Ca="Returns the sum of each row of the input tensor in the given dimension dim.",jo,qe,Ha='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The summed tensor',Jo,Ne,La="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>The dimension or dimensions to reduce. If <code>null</code>, all dimensions are reduced.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensor has <code>dim</code> retained or not.</p></td></tr></tbody>",Eo,ko,Do,Ke,Io,Ve,qo,Be,wa="Returns the matrix norm or vector norm of a given tensor.",No,Qe,Aa='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The norm of the tensor.',Ko,Se,Ua=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code> | <code>string</code></td><td><code>&#39;fro&#39;</code></td><td><p>The order of norm</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>Specifies which dimension of the tensor to calculate the norm across.
If dim is None, the norm will be calculated across all dimensions of input.</p></td> </tr><tr><td>[keepdim]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensors have dim retained or not.</p></td></tr></tbody>`,Vo,Bo,Qo,Oe,So,We,Oo,Ye,ga="Performs <code>L_p</code> normalization of inputs over specified dimension. Operates in place.",Wo,Fe,Pa='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - <code>this</code> for operation chaining.',Yo,Xe,Ra="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",Fo,Xo,Go,Ge,Zo,Ze,ei,et,za="Performs <code>L_p</code> normalization of inputs over specified dimension.",ti,tt,ja='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',li,lt,Ja="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",si,ni,oi,st,ii,nt,ri,ot,Ea=`Compute and return the stride of this tensor.
Stride is the jump necessary to go from one element to the next one in the specified dimension dim.`,di,it,ka='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The stride of this tensor.',ui,ai,mi,rt,pi,dt,ci,ut,Da="Returns a tensor with all specified dimensions of input of size 1 removed.",fi,at,Ia=`NOTE: The returned tensor shares the storage with the input tensor, so changing the contents of one will change the contents of the other.
If you would like a copy, use <code>tensor.clone()</code> before squeezing.`,Ti,mt,qa='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The squeezed tensor',hi,pt,Na="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>If given, the input will be squeezed only in the specified dimensions.</p></td></tr></tbody>",_i,$i,vi,ct,yi,ft,bi,Tt,Ka='In-place version of @see <a href="Tensor.squeeze">Tensor.squeeze</a>',Mi,ht,Va='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',xi,Ci,Hi,_t,Li,$t,wi,vt,Ba="Returns a new tensor with a dimension of size one inserted at the specified position.",Ai,yt,Qa="NOTE: The returned tensor shares the same underlying data with this tensor.",Ui,bt,Sa='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The unsqueezed tensor',gi,Mt,Oa="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>dim</td><td><code>number</code></td><td><code></code></td><td><p>The index at which to insert the singleton dimension</p></td></tr></tbody>",Pi,Ri,zi,xt,ji,Ct,Ji,Ht,Wa='In-place version of @see <a href="Tensor.unsqueeze">Tensor.unsqueeze</a>',Ei,Lt,Ya='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',ki,Di,Ii,wt,qi,At,Ni,Ut,Fa='In-place version of @see <a href="Tensor.flatten">Tensor.flatten</a>',Ki,gt,Xa='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Vi,Bi,Qi,Pt,Si,Rt,Oi,zt,Ga=`Flattens input by reshaping it into a one-dimensional tensor.
If <code>start_dim</code> or <code>end_dim</code> are passed, only dimensions starting with <code>start_dim</code>
and ending with <code>end_dim</code> are flattened. The order of elements in input is unchanged.`,Wi,jt,Za='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The flattened tensor.',Yi,Jt,em="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>start_dim</td><td><code>number</code></td><td><code>0</code></td><td><p>the first dim to flatten</p></td> </tr><tr><td>end_dim</td><td><code>number</code></td><td></td><td><p>the last dim to flatten</p></td></tr></tbody>",Fi,Xi,Gi,Et,Zi,kt,er,Dt,tm="Returns a new tensor with the same data as the <code>self</code> tensor but of a different <code>shape</code>.",tr,It,lm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the same data but different shape',lr,qt,sm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>the desired size</p></td></tr></tbody>",sr,nr,or,Nt,ir,Kt,rr,Vt,nm='In-place version of @see <a href="Tensor.clamp">Tensor.clamp</a>',dr,Bt,om='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',ur,ar,mr,Qt,pr,St,cr,Ot,im="Clamps all elements in input into the range [ min, max ]",fr,Wt,rm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: the output tensor.',Tr,Yt,dm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>min</td><td><code>number</code></td><td><p>lower-bound of the range to be clamped to</p></td> </tr><tr><td>max</td><td><code>number</code></td><td><p>upper-bound of the range to be clamped to</p></td></tr></tbody>",hr,_r,$r,Ft,vr,Xt,yr,Gt,um='In-place version of @see <a href="Tensor.round">Tensor.round</a>',br,Zt,am='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Mr,xr,Cr,el,Hr,tl,Lr,ll,mm="Rounds elements of input to the nearest integer.",wr,sl,pm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: the output tensor.',Ar,Ur,gr,nl,Pr,ol,Rr,il,cm="Performs Tensor dtype conversion.",zr,rl,fm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The converted tensor.',jr,dl,Tm="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>type</td><td><code>&#39;bool&#39;</code> | <code>&#39;float32&#39;</code> | <code>&#39;float64&#39;</code> | <code>&#39;string&#39;</code> | <code>&#39;int8&#39;</code> | <code>&#39;uint8&#39;</code> | <code>&#39;int16&#39;</code> | <code>&#39;uint16&#39;</code> | <code>&#39;int32&#39;</code> | <code>&#39;uint32&#39;</code> | <code>&#39;int64&#39;</code></td></tr></tbody>",Jr,Er,kr,ul,Dr,al,Ir,ml,hm="Transposes a tensor according to the provided axes.",qr,pl,_m='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The transposed tensor.',Nr,cl,$m="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>any</code></td><td><p>The input tensor to transpose.</p></td> </tr><tr><td>axes</td><td><code>Array</code></td><td><p>The axes to transpose the tensor along.</p></td></tr></tbody>",Kr,Vr,Br,fl,Qr,Tl,Sr,hl,vm="Interpolates an Tensor to the given size.",Or,_l,ym='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The interpolated tensor.',Wr,$l,bm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>The input tensor to interpolate. Data must be channel-first (i.e., [c, h, w])</p></td> </tr><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>The output size of the image</p></td> </tr><tr><td>mode</td><td><code>string</code></td><td><p>The interpolation mode</p></td> </tr><tr><td>align_corners</td><td><code>boolean</code></td><td><p>Whether to align corners.</p></td></tr></tbody>",Yr,Fr,Xr,vl,Gr,yl,Zr,bl,Mm="Perform mean pooling of the last hidden state followed by a normalization step.",ed,Ml,xm='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns a new Tensor of shape [batchSize, embedDim].',td,xl,Cm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>last_hidden_state</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength, embedDim]</p></td> </tr><tr><td>attention_mask</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength]</p></td></tr></tbody>",ld,sd,nd,Cl,od,Hl,id,Ll,Hm="Concatenates an array of tensors along a specified dimension.",rd,wl,Lm='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The concatenated tensor.',dd,Al,wm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to concatenate.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to concatenate along.</p></td></tr></tbody>",ud,ad,md,Ul,pd,gl,cd,Pl,Am="Stack an array of tensors along a specified dimension.",fd,Rl,Um='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The stacked tensor.',Td,zl,gm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to stack.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to stack along.</p></td></tr></tbody>",hd,_d,$d,jl,vd,Jl,yd,El,Pm="Calculates the standard deviation and mean over the dimensions specified by dim. dim can be a single dimension or <code>null</code> to reduce over all dimensions.",bd,kl,Rm='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Tensor&gt;</code> - A tuple of (std, mean) tensors.',Md,Dl,zm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tenso</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce. If None, all dimensions are reduced.</p></td> </tr><tr><td>correction</td><td><code>number</code></td><td><p>difference between the sample size and sample degrees of freedom. Defaults to Bessel&#39;s correction, correction=1.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",xd,Cd,Hd,Il,Ld,ql,wd,Nl,jm="Returns the mean value of each row of the input tensor in the given dimension dim.",Ad,Kl,Jm='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: A new tensor with means taken along the specified dimension.',Ud,Vl,Em="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tensor.</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",gd,Pd,Rd,Bl,zd,Ql,jd,Sl,km=`Measures similarity between two temporal sequences (e.g., input audio and output tokens
to generate token-level timestamps).`,Jd,Ol,Dm='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Ed,Wl,Im="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>matrix</td><td><code>Tensor</code></td></tr></tbody>",kd,Dd,Id,Yl,qd,Fl,Nd,Xl,qm="Returns a tensor filled with the scalar value 1, with the shape defined by the variable argument size.",Kd,Gl,Nm='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Vd,Zl,Km="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",Bd,Qd,Sd,es,Od,ts,Wd,ls,Vm="Returns a tensor filled with the scalar value 1, with the same size as input.",Yd,ss,Bm='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: The ones tensor.',Fd,ns,Qm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>",Xd,Gd,Zd,os,eu,is,tu,rs,Sm='<strong>Kind</strong>: inner constant of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',lu,su,nu,ds,ou,us,iu,as,Om="Reshapes a 1-dimensional array into an n-dimensional array, according to the provided dimensions.",ru,ms,Wm='<strong>Kind</strong>: inner method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The reshaped array.',du,ps,Ym="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Array.&lt;T&gt;</code></td><td><p>The input array to reshape.</p></td> </tr><tr><td>dimensions</td><td><code>DIM</code></td><td><p>The target shape/dimensions.</p></td></tr></tbody>",uu,cs,Fm="<strong>Example</strong>",au,fs,mu,pu,cu,Ts,fu,hs,Tu,_s,Xm='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor..reshape"><code>reshape</code></a>',hu,_u,$u,$s,vu,vs,yu,ys,Gm='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',bu,Mu,xu,bs,Cu,Ms,Hu,xs,Zm="This creates a nested array of a given type and depth (see examples).",Lu,Cs,ep='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Example</strong>',wu,Hs,Au,Ls,tp="<strong>Example</strong>",Uu,ws,gu,As,lp="<strong>Example</strong>",Pu,Us,Ru,zu,ju,Ps,Ju;return y=new _({props:{title:"utils/tensor",local:"utilstensor",headingTag:"h1"}}),H=new _({props:{title:"utils/tensor.Tensor",local:"utilstensortensor",headingTag:"h2"}}),U=new _({props:{title:"new Tensor(...args)",local:"new-tensorargs",headingTag:"h3"}}),z=new _({props:{title:"tensor.Symbol.iterator() ⇒ <code> Iterator </code>",local:"tensorsymboliterator--code-iterator-code",headingTag:"h3"}}),k=new _({props:{title:"tensor._getitem(index) ⇒ <code> Tensor </code>",local:"tensorgetitemindex--code-tensor-code",headingTag:"h3"}}),K=new _({props:{title:"tensor.indexOf(item) ⇒ <code> number </code>",local:"tensorindexofitem--code-number-code",headingTag:"h3"}}),S=new _({props:{title:"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>",local:"tensorsubarrayindex-itersize-iterdims--code-tensor-code",headingTag:"h3"}}),F=new _({props:{title:"tensor.item() ⇒ <code> number </code>",local:"tensoritem--code-number-code",headingTag:"h3"}}),te=new _({props:{title:"tensor.tolist() ⇒ <code> Array </code>",local:"tensortolist--code-array-code",headingTag:"h3"}}),oe=new _({props:{title:"tensor.sigmoid() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ue=new _({props:{title:"tensor.sigmoid_() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ce=new _({props:{title:"tensor.mul(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),$e=new _({props:{title:"tensor.mul_(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),xe=new _({props:{title:"tensor.add(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),Ae=new _({props:{title:"tensor.add_(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),ze=new _({props:{title:"tensor.transpose(...dims) ⇒ <code> Tensor </code>",local:"tensortransposedims--code-tensor-code",headingTag:"h3"}}),De=new _({props:{title:"tensor.sum([dim], keepdim) ⇒",local:"tensorsumdim-keepdim-",headingTag:"h3"}}),Ve=new _({props:{title:"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>",local:"tensornormp-dim-keepdim--code-tensor-code",headingTag:"h3"}}),We=new _({props:{title:"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),Ze=new _({props:{title:"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),nt=new _({props:{title:"tensor.stride() ⇒ <code> Array. < number > </code>",local:"tensorstride--code-array--number--code",headingTag:"h3"}}),dt=new _({props:{title:"tensor.squeeze([dim]) ⇒",local:"tensorsqueezedim-",headingTag:"h3"}}),ft=new _({props:{title:"tensor.squeeze_()",local:"tensorsqueeze",headingTag:"h3"}}),$t=new _({props:{title:"tensor.unsqueeze(dim) ⇒",local:"tensorunsqueezedim-",headingTag:"h3"}}),Ct=new _({props:{title:"tensor.unsqueeze_()",local:"tensorunsqueeze",headingTag:"h3"}}),At=new _({props:{title:"tensor.flatten_()",local:"tensorflatten",headingTag:"h3"}}),Rt=new _({props:{title:"tensor.flatten(start_dim, end_dim) ⇒",local:"tensorflattenstartdim-enddim-",headingTag:"h3"}}),kt=new _({props:{title:"tensor.view(...dims) ⇒ <code> Tensor </code>",local:"tensorviewdims--code-tensor-code",headingTag:"h3"}}),Kt=new _({props:{title:"tensor.clamp_()",local:"tensorclamp",headingTag:"h3"}}),St=new _({props:{title:"tensor.clamp(min, max) ⇒",local:"tensorclampmin-max-",headingTag:"h3"}}),Xt=new _({props:{title:"tensor.round_()",local:"tensorround",headingTag:"h3"}}),tl=new _({props:{title:"tensor.round() ⇒",local:"tensorround-",headingTag:"h3"}}),ol=new _({props:{title:"tensor.to(type) ⇒ <code> Tensor </code>",local:"tensortotype--code-tensor-code",headingTag:"h3"}}),al=new _({props:{title:"utils/tensor.transpose(tensor, axes) ⇒ <code> Tensor </code>",local:"utilstensortransposetensor-axes--code-tensor-code",headingTag:"h2"}}),Tl=new _({props:{title:"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>",local:"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code",headingTag:"h2"}}),yl=new _({props:{title:"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>",local:"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code",headingTag:"h2"}}),Hl=new _({props:{title:"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorcattensors-dim--code-tensor-code",headingTag:"h2"}}),gl=new _({props:{title:"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorstacktensors-dim--code-tensor-code",headingTag:"h2"}}),Jl=new _({props:{title:"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>",local:"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code",headingTag:"h2"}}),ql=new _({props:{title:"utils/tensor.mean(input, dim, keepdim) ⇒",local:"utilstensormeaninput-dim-keepdim-",headingTag:"h2"}}),Ql=new _({props:{title:"utils/tensor.dynamicTimeWarping(matrix) ⇒ <code> Array. < Array < number > > </code>",local:"utilstensordynamictimewarpingmatrix--code-array--array--number---code",headingTag:"h2"}}),Fl=new _({props:{title:"utils/tensor.ones(size)",local:"utilstensoronessize",headingTag:"h2"}}),ts=new _({props:{title:"utils/tensor.ones_like(tensor) ⇒",local:"utilstensoronesliketensor-",headingTag:"h2"}}),is=new _({props:{title:"utils/tensor~ONNXTensor : <code> Object </code>",local:"utilstensoronnxtensor--code-object-code",headingTag:"h2"}}),us=new _({props:{title:"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>",local:"utilstensorreshapedata-dimensions--code--code",headingTag:"h2"}}),fs=new Eu({props:{code:"cmVzaGFwZSglNUIxMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUyMCU1QjElMjAlMjAlMjAlMjAlMjAlMjAlNUQpJTNCJTIwJTJGJTJGJTIwVHlwZSUzQSUyMG51bWJlciU1QiU1RCUyMCUyMCUyMCUyMCUyMCUyMFZhbHVlJTNBJTIwJTVCMTAlNUQlMEElMjAlMjByZXNoYXBlKCU1QjElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMjAlNUIyJTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBJTIwJTIwcmVzaGFwZSglNUIxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTJDJTIwOCU1RCUyQyUyMCU1QjIlMkMlMjAyJTJDJTIwMiU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTVCJTVEJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQSUyMCUyMHJlc2hhcGUoJTVCMSUyQyUyMDIlMkMlMjAzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglNUQlMkMlMjAlNUI0JTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTJDJTIwJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RA==",highlighted:`<span class="hljs-title function_">reshape</span>([<span class="hljs-number">10</span>                    ], [<span class="hljs-number">1</span>      ]); <span class="hljs-comment">// Type: number[]      Value: [10]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>            ], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>]); <span class="hljs-comment">// Type: number[][][]  Value: [[[1, 2], [3, 4]], [[5, 6], [7, 8]]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">4</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4], [5, 6], [7, 8]]</span>`,wrap:!1}}),hs=new _({props:{title:"reshape~reshapedArray : <code> any </code>",local:"reshapereshapedarray--code-any-code",headingTag:"h3"}}),vs=new _({props:{title:"utils/tensor~DataArray : <code> * </code>",local:"utilstensordataarray--code--code",headingTag:"h2"}}),Ms=new _({props:{title:"utils/tensor~NestArray : <code> * </code>",local:"utilstensornestarray--code--code",headingTag:"h2"}}),Hs=new Eu({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMSUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">1</span>&gt;; <span class="hljs-comment">// string[]</span>',wrap:!1}}),ws=new Eu({props:{code:"TmVzdEFycmF5JTNDbnVtYmVyJTJDJTIwMiUzRSUzQiUyMCUyRiUyRiUyMG51bWJlciU1QiU1RCU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;number, <span class="hljs-number">2</span>&gt;; <span class="hljs-comment">// number[][]</span>',wrap:!1}}),Us=new Eu({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMyUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RCU1QiU1RCU1QiU1RCUyMGV0Yy4=",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">3</span>&gt;; <span class="hljs-comment">// string[][][] etc.</span>',wrap:!1}}),{c(){$=i("meta"),Rs=n(),gs=i("p"),zs=n(),v=i("a"),js=n(),a(y.$$.fragment),Js=n(),b=i("p"),b.innerHTML=Du,Es=n(),M=i("p"),M.textContent=Iu,ks=n(),x=i("ul"),x.innerHTML=qu,Ds=n(),Is=i("hr"),qs=n(),C=i("a"),Ns=n(),a(H.$$.fragment),Ks=n(),L=i("p"),L.innerHTML=Nu,Vs=n(),w=i("ul"),w.innerHTML=Ku,Bs=n(),Qs=i("hr"),Ss=n(),A=i("a"),Os=n(),a(U.$$.fragment),Ws=n(),g=i("p"),g.textContent=Vu,Ys=n(),P=i("table"),P.innerHTML=Bu,Fs=n(),Xs=i("hr"),Gs=n(),R=i("a"),Zs=n(),a(z.$$.fragment),en=n(),j=i("p"),j.textContent=Qu,tn=n(),J=i("p"),J.innerHTML=Su,ln=n(),sn=i("hr"),nn=n(),E=i("a"),on=n(),a(k.$$.fragment),rn=n(),D=i("p"),D.textContent=Ou,dn=n(),I=i("p"),I.innerHTML=Wu,un=n(),q=i("table"),q.innerHTML=Yu,an=n(),mn=i("hr"),pn=n(),N=i("a"),cn=n(),a(K.$$.fragment),fn=n(),V=i("p"),V.innerHTML=Fu,Tn=n(),B=i("table"),B.innerHTML=Xu,hn=n(),_n=i("hr"),$n=n(),Q=i("a"),vn=n(),a(S.$$.fragment),yn=n(),O=i("p"),O.innerHTML=Gu,bn=n(),W=i("table"),W.innerHTML=Zu,Mn=n(),xn=i("hr"),Cn=n(),Y=i("a"),Hn=n(),a(F.$$.fragment),Ln=n(),X=i("p"),X.innerHTML=ea,wn=n(),G=i("p"),G.innerHTML=ta,An=n(),Z=i("ul"),Z.innerHTML=la,Un=n(),gn=i("hr"),Pn=n(),ee=i("a"),Rn=n(),a(te.$$.fragment),zn=n(),le=i("p"),le.textContent=sa,jn=n(),se=i("p"),se.innerHTML=na,Jn=n(),En=i("hr"),kn=n(),ne=i("a"),Dn=n(),a(oe.$$.fragment),In=n(),ie=i("p"),ie.textContent=oa,qn=n(),re=i("p"),re.innerHTML=ia,Nn=n(),Kn=i("hr"),Vn=n(),de=i("a"),Bn=n(),a(ue.$$.fragment),Qn=n(),ae=i("p"),ae.textContent=ra,Sn=n(),me=i("p"),me.innerHTML=da,On=n(),Wn=i("hr"),Yn=n(),pe=i("a"),Fn=n(),a(ce.$$.fragment),Xn=n(),fe=i("p"),fe.textContent=ua,Gn=n(),Te=i("p"),Te.innerHTML=aa,Zn=n(),he=i("table"),he.innerHTML=ma,eo=n(),to=i("hr"),lo=n(),_e=i("a"),so=n(),a($e.$$.fragment),no=n(),ve=i("p"),ve.textContent=pa,oo=n(),ye=i("p"),ye.innerHTML=ca,io=n(),be=i("table"),be.innerHTML=fa,ro=n(),uo=i("hr"),ao=n(),Me=i("a"),mo=n(),a(xe.$$.fragment),po=n(),Ce=i("p"),Ce.textContent=Ta,co=n(),He=i("p"),He.innerHTML=ha,fo=n(),Le=i("table"),Le.innerHTML=_a,To=n(),ho=i("hr"),_o=n(),we=i("a"),$o=n(),a(Ae.$$.fragment),vo=n(),Ue=i("p"),Ue.textContent=$a,yo=n(),ge=i("p"),ge.innerHTML=va,bo=n(),Pe=i("table"),Pe.innerHTML=ya,Mo=n(),xo=i("hr"),Co=n(),Re=i("a"),Ho=n(),a(ze.$$.fragment),Lo=n(),je=i("p"),je.textContent=ba,wo=n(),Je=i("p"),Je.innerHTML=Ma,Ao=n(),Ee=i("table"),Ee.innerHTML=xa,Uo=n(),go=i("hr"),Po=n(),ke=i("a"),Ro=n(),a(De.$$.fragment),zo=n(),Ie=i("p"),Ie.textContent=Ca,jo=n(),qe=i("p"),qe.innerHTML=Ha,Jo=n(),Ne=i("table"),Ne.innerHTML=La,Eo=n(),ko=i("hr"),Do=n(),Ke=i("a"),Io=n(),a(Ve.$$.fragment),qo=n(),Be=i("p"),Be.textContent=wa,No=n(),Qe=i("p"),Qe.innerHTML=Aa,Ko=n(),Se=i("table"),Se.innerHTML=Ua,Vo=n(),Bo=i("hr"),Qo=n(),Oe=i("a"),So=n(),a(We.$$.fragment),Oo=n(),Ye=i("p"),Ye.innerHTML=ga,Wo=n(),Fe=i("p"),Fe.innerHTML=Pa,Yo=n(),Xe=i("table"),Xe.innerHTML=Ra,Fo=n(),Xo=i("hr"),Go=n(),Ge=i("a"),Zo=n(),a(Ze.$$.fragment),ei=n(),et=i("p"),et.innerHTML=za,ti=n(),tt=i("p"),tt.innerHTML=ja,li=n(),lt=i("table"),lt.innerHTML=Ja,si=n(),ni=i("hr"),oi=n(),st=i("a"),ii=n(),a(nt.$$.fragment),ri=n(),ot=i("p"),ot.textContent=Ea,di=n(),it=i("p"),it.innerHTML=ka,ui=n(),ai=i("hr"),mi=n(),rt=i("a"),pi=n(),a(dt.$$.fragment),ci=n(),ut=i("p"),ut.textContent=Da,fi=n(),at=i("p"),at.innerHTML=Ia,Ti=n(),mt=i("p"),mt.innerHTML=qa,hi=n(),pt=i("table"),pt.innerHTML=Na,_i=n(),$i=i("hr"),vi=n(),ct=i("a"),yi=n(),a(ft.$$.fragment),bi=n(),Tt=i("p"),Tt.innerHTML=Ka,Mi=n(),ht=i("p"),ht.innerHTML=Va,xi=n(),Ci=i("hr"),Hi=n(),_t=i("a"),Li=n(),a($t.$$.fragment),wi=n(),vt=i("p"),vt.textContent=Ba,Ai=n(),yt=i("p"),yt.textContent=Qa,Ui=n(),bt=i("p"),bt.innerHTML=Sa,gi=n(),Mt=i("table"),Mt.innerHTML=Oa,Pi=n(),Ri=i("hr"),zi=n(),xt=i("a"),ji=n(),a(Ct.$$.fragment),Ji=n(),Ht=i("p"),Ht.innerHTML=Wa,Ei=n(),Lt=i("p"),Lt.innerHTML=Ya,ki=n(),Di=i("hr"),Ii=n(),wt=i("a"),qi=n(),a(At.$$.fragment),Ni=n(),Ut=i("p"),Ut.innerHTML=Fa,Ki=n(),gt=i("p"),gt.innerHTML=Xa,Vi=n(),Bi=i("hr"),Qi=n(),Pt=i("a"),Si=n(),a(Rt.$$.fragment),Oi=n(),zt=i("p"),zt.innerHTML=Ga,Wi=n(),jt=i("p"),jt.innerHTML=Za,Yi=n(),Jt=i("table"),Jt.innerHTML=em,Fi=n(),Xi=i("hr"),Gi=n(),Et=i("a"),Zi=n(),a(kt.$$.fragment),er=n(),Dt=i("p"),Dt.innerHTML=tm,tr=n(),It=i("p"),It.innerHTML=lm,lr=n(),qt=i("table"),qt.innerHTML=sm,sr=n(),nr=i("hr"),or=n(),Nt=i("a"),ir=n(),a(Kt.$$.fragment),rr=n(),Vt=i("p"),Vt.innerHTML=nm,dr=n(),Bt=i("p"),Bt.innerHTML=om,ur=n(),ar=i("hr"),mr=n(),Qt=i("a"),pr=n(),a(St.$$.fragment),cr=n(),Ot=i("p"),Ot.textContent=im,fr=n(),Wt=i("p"),Wt.innerHTML=rm,Tr=n(),Yt=i("table"),Yt.innerHTML=dm,hr=n(),_r=i("hr"),$r=n(),Ft=i("a"),vr=n(),a(Xt.$$.fragment),yr=n(),Gt=i("p"),Gt.innerHTML=um,br=n(),Zt=i("p"),Zt.innerHTML=am,Mr=n(),xr=i("hr"),Cr=n(),el=i("a"),Hr=n(),a(tl.$$.fragment),Lr=n(),ll=i("p"),ll.textContent=mm,wr=n(),sl=i("p"),sl.innerHTML=pm,Ar=n(),Ur=i("hr"),gr=n(),nl=i("a"),Pr=n(),a(ol.$$.fragment),Rr=n(),il=i("p"),il.textContent=cm,zr=n(),rl=i("p"),rl.innerHTML=fm,jr=n(),dl=i("table"),dl.innerHTML=Tm,Jr=n(),Er=i("hr"),kr=n(),ul=i("a"),Dr=n(),a(al.$$.fragment),Ir=n(),ml=i("p"),ml.textContent=hm,qr=n(),pl=i("p"),pl.innerHTML=_m,Nr=n(),cl=i("table"),cl.innerHTML=$m,Kr=n(),Vr=i("hr"),Br=n(),fl=i("a"),Qr=n(),a(Tl.$$.fragment),Sr=n(),hl=i("p"),hl.textContent=vm,Or=n(),_l=i("p"),_l.innerHTML=ym,Wr=n(),$l=i("table"),$l.innerHTML=bm,Yr=n(),Fr=i("hr"),Xr=n(),vl=i("a"),Gr=n(),a(yl.$$.fragment),Zr=n(),bl=i("p"),bl.textContent=Mm,ed=n(),Ml=i("p"),Ml.innerHTML=xm,td=n(),xl=i("table"),xl.innerHTML=Cm,ld=n(),sd=i("hr"),nd=n(),Cl=i("a"),od=n(),a(Hl.$$.fragment),id=n(),Ll=i("p"),Ll.textContent=Hm,rd=n(),wl=i("p"),wl.innerHTML=Lm,dd=n(),Al=i("table"),Al.innerHTML=wm,ud=n(),ad=i("hr"),md=n(),Ul=i("a"),pd=n(),a(gl.$$.fragment),cd=n(),Pl=i("p"),Pl.textContent=Am,fd=n(),Rl=i("p"),Rl.innerHTML=Um,Td=n(),zl=i("table"),zl.innerHTML=gm,hd=n(),_d=i("hr"),$d=n(),jl=i("a"),vd=n(),a(Jl.$$.fragment),yd=n(),El=i("p"),El.innerHTML=Pm,bd=n(),kl=i("p"),kl.innerHTML=Rm,Md=n(),Dl=i("table"),Dl.innerHTML=zm,xd=n(),Cd=i("hr"),Hd=n(),Il=i("a"),Ld=n(),a(ql.$$.fragment),wd=n(),Nl=i("p"),Nl.textContent=jm,Ad=n(),Kl=i("p"),Kl.innerHTML=Jm,Ud=n(),Vl=i("table"),Vl.innerHTML=Em,gd=n(),Pd=i("hr"),Rd=n(),Bl=i("a"),zd=n(),a(Ql.$$.fragment),jd=n(),Sl=i("p"),Sl.textContent=km,Jd=n(),Ol=i("p"),Ol.innerHTML=Dm,Ed=n(),Wl=i("table"),Wl.innerHTML=Im,kd=n(),Dd=i("hr"),Id=n(),Yl=i("a"),qd=n(),a(Fl.$$.fragment),Nd=n(),Xl=i("p"),Xl.textContent=qm,Kd=n(),Gl=i("p"),Gl.innerHTML=Nm,Vd=n(),Zl=i("table"),Zl.innerHTML=Km,Bd=n(),Qd=i("hr"),Sd=n(),es=i("a"),Od=n(),a(ts.$$.fragment),Wd=n(),ls=i("p"),ls.textContent=Vm,Yd=n(),ss=i("p"),ss.innerHTML=Bm,Fd=n(),ns=i("table"),ns.innerHTML=Qm,Xd=n(),Gd=i("hr"),Zd=n(),os=i("a"),eu=n(),a(is.$$.fragment),tu=n(),rs=i("p"),rs.innerHTML=Sm,lu=n(),su=i("hr"),nu=n(),ds=i("a"),ou=n(),a(us.$$.fragment),iu=n(),as=i("p"),as.textContent=Om,ru=n(),ms=i("p"),ms.innerHTML=Wm,du=n(),ps=i("table"),ps.innerHTML=Ym,uu=n(),cs=i("p"),cs.innerHTML=Fm,au=n(),a(fs.$$.fragment),mu=n(),pu=i("hr"),cu=n(),Ts=i("a"),fu=n(),a(hs.$$.fragment),Tu=n(),_s=i("p"),_s.innerHTML=Xm,hu=n(),_u=i("hr"),$u=n(),$s=i("a"),vu=n(),a(vs.$$.fragment),yu=n(),ys=i("p"),ys.innerHTML=Gm,bu=n(),Mu=i("hr"),xu=n(),bs=i("a"),Cu=n(),a(Ms.$$.fragment),Hu=n(),xs=i("p"),xs.textContent=Zm,Lu=n(),Cs=i("p"),Cs.innerHTML=ep,wu=n(),a(Hs.$$.fragment),Au=n(),Ls=i("p"),Ls.innerHTML=tp,Uu=n(),a(ws.$$.fragment),gu=n(),As=i("p"),As.innerHTML=lp,Pu=n(),a(Us.$$.fragment),Ru=n(),zu=i("hr"),ju=n(),Ps=i("p"),this.h()},l(e){const t=dp("svelte-u9bgzb",document.head);$=r(t,"META",{name:!0,content:!0}),t.forEach(l),Rs=o(e),gs=r(e,"P",{}),h(gs).forEach(l),zs=o(e),v=r(e,"A",{id:!0,class:!0}),h(v).forEach(l),js=o(e),m(y.$$.fragment,e),Js=o(e),b=r(e,"P",{"data-svelte-h":!0}),d(b)!=="svelte-uw4y1m"&&(b.innerHTML=Du),Es=o(e),M=r(e,"P",{"data-svelte-h":!0}),d(M)!=="svelte-il3kl8"&&(M.textContent=Iu),ks=o(e),x=r(e,"UL",{"data-svelte-h":!0}),d(x)!=="svelte-1rws04c"&&(x.innerHTML=qu),Ds=o(e),Is=r(e,"HR",{}),qs=o(e),C=r(e,"A",{id:!0,class:!0}),h(C).forEach(l),Ns=o(e),m(H.$$.fragment,e),Ks=o(e),L=r(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1ugrfrw"&&(L.innerHTML=Nu),Vs=o(e),w=r(e,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-dqe61m"&&(w.innerHTML=Ku),Bs=o(e),Qs=r(e,"HR",{}),Ss=o(e),A=r(e,"A",{id:!0,class:!0}),h(A).forEach(l),Os=o(e),m(U.$$.fragment,e),Ws=o(e),g=r(e,"P",{"data-svelte-h":!0}),d(g)!=="svelte-55wecd"&&(g.textContent=Vu),Ys=o(e),P=r(e,"TABLE",{"data-svelte-h":!0}),d(P)!=="svelte-ee7emz"&&(P.innerHTML=Bu),Fs=o(e),Xs=r(e,"HR",{}),Gs=o(e),R=r(e,"A",{id:!0,class:!0}),h(R).forEach(l),Zs=o(e),m(z.$$.fragment,e),en=o(e),j=r(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-1adn56z"&&(j.textContent=Qu),tn=o(e),J=r(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-1gxgvk6"&&(J.innerHTML=Su),ln=o(e),sn=r(e,"HR",{}),nn=o(e),E=r(e,"A",{id:!0,class:!0}),h(E).forEach(l),on=o(e),m(k.$$.fragment,e),rn=o(e),D=r(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-1u97xg1"&&(D.textContent=Ou),dn=o(e),I=r(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-1afa2dz"&&(I.innerHTML=Wu),un=o(e),q=r(e,"TABLE",{"data-svelte-h":!0}),d(q)!=="svelte-1kq04ga"&&(q.innerHTML=Yu),an=o(e),mn=r(e,"HR",{}),pn=o(e),N=r(e,"A",{id:!0,class:!0}),h(N).forEach(l),cn=o(e),m(K.$$.fragment,e),fn=o(e),V=r(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1cg22af"&&(V.innerHTML=Fu),Tn=o(e),B=r(e,"TABLE",{"data-svelte-h":!0}),d(B)!=="svelte-1hful42"&&(B.innerHTML=Xu),hn=o(e),_n=r(e,"HR",{}),$n=o(e),Q=r(e,"A",{id:!0,class:!0}),h(Q).forEach(l),vn=o(e),m(S.$$.fragment,e),yn=o(e),O=r(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-1mr58c3"&&(O.innerHTML=Gu),bn=o(e),W=r(e,"TABLE",{"data-svelte-h":!0}),d(W)!=="svelte-153ftfy"&&(W.innerHTML=Zu),Mn=o(e),xn=r(e,"HR",{}),Cn=o(e),Y=r(e,"A",{id:!0,class:!0}),h(Y).forEach(l),Hn=o(e),m(F.$$.fragment,e),Ln=o(e),X=r(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-13nzfs3"&&(X.innerHTML=ea),wn=o(e),G=r(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-18jnqwq"&&(G.innerHTML=ta),An=o(e),Z=r(e,"UL",{"data-svelte-h":!0}),d(Z)!=="svelte-5t2sg3"&&(Z.innerHTML=la),Un=o(e),gn=r(e,"HR",{}),Pn=o(e),ee=r(e,"A",{id:!0,class:!0}),h(ee).forEach(l),Rn=o(e),m(te.$$.fragment,e),zn=o(e),le=r(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-87xdyr"&&(le.textContent=sa),jn=o(e),se=r(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-1mr58c3"&&(se.innerHTML=na),Jn=o(e),En=r(e,"HR",{}),kn=o(e),ne=r(e,"A",{id:!0,class:!0}),h(ne).forEach(l),Dn=o(e),m(oe.$$.fragment,e),In=o(e),ie=r(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-2wti2w"&&(ie.textContent=oa),qn=o(e),re=r(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-kpq7mo"&&(re.innerHTML=ia),Nn=o(e),Kn=r(e,"HR",{}),Vn=o(e),de=r(e,"A",{id:!0,class:!0}),h(de).forEach(l),Bn=o(e),m(ue.$$.fragment,e),Qn=o(e),ae=r(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1edu6c8"&&(ae.textContent=ra),Sn=o(e),me=r(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1hc4oxa"&&(me.innerHTML=da),On=o(e),Wn=r(e,"HR",{}),Yn=o(e),pe=r(e,"A",{id:!0,class:!0}),h(pe).forEach(l),Fn=o(e),m(ce.$$.fragment,e),Xn=o(e),fe=r(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-xg80lg"&&(fe.textContent=ua),Gn=o(e),Te=r(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-1aygav2"&&(Te.innerHTML=aa),Zn=o(e),he=r(e,"TABLE",{"data-svelte-h":!0}),d(he)!=="svelte-1tbtmqd"&&(he.innerHTML=ma),eo=o(e),to=r(e,"HR",{}),lo=o(e),_e=r(e,"A",{id:!0,class:!0}),h(_e).forEach(l),so=o(e),m($e.$$.fragment,e),no=o(e),ve=r(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-1i12x1s"&&(ve.textContent=pa),oo=o(e),ye=r(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1hc4oxa"&&(ye.innerHTML=ca),io=o(e),be=r(e,"TABLE",{"data-svelte-h":!0}),d(be)!=="svelte-1tbtmqd"&&(be.innerHTML=fa),ro=o(e),uo=r(e,"HR",{}),ao=o(e),Me=r(e,"A",{id:!0,class:!0}),h(Me).forEach(l),mo=o(e),m(xe.$$.fragment,e),po=o(e),Ce=r(e,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-1hl64jn"&&(Ce.textContent=Ta),co=o(e),He=r(e,"P",{"data-svelte-h":!0}),d(He)!=="svelte-1aygav2"&&(He.innerHTML=ha),fo=o(e),Le=r(e,"TABLE",{"data-svelte-h":!0}),d(Le)!=="svelte-1p5444"&&(Le.innerHTML=_a),To=o(e),ho=r(e,"HR",{}),_o=o(e),we=r(e,"A",{id:!0,class:!0}),h(we).forEach(l),$o=o(e),m(Ae.$$.fragment,e),vo=o(e),Ue=r(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-bbf4x3"&&(Ue.textContent=$a),yo=o(e),ge=r(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-1hc4oxa"&&(ge.innerHTML=va),bo=o(e),Pe=r(e,"TABLE",{"data-svelte-h":!0}),d(Pe)!=="svelte-1p5444"&&(Pe.innerHTML=ya),Mo=o(e),xo=r(e,"HR",{}),Co=o(e),Re=r(e,"A",{id:!0,class:!0}),h(Re).forEach(l),Ho=o(e),m(ze.$$.fragment,e),Lo=o(e),je=r(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-lesh1u"&&(je.textContent=ba),wo=o(e),Je=r(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-rvzl1t"&&(Je.innerHTML=Ma),Ao=o(e),Ee=r(e,"TABLE",{"data-svelte-h":!0}),d(Ee)!=="svelte-onq75m"&&(Ee.innerHTML=xa),Uo=o(e),go=r(e,"HR",{}),Po=o(e),ke=r(e,"A",{id:!0,class:!0}),h(ke).forEach(l),Ro=o(e),m(De.$$.fragment,e),zo=o(e),Ie=r(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-yjryb1"&&(Ie.textContent=Ca),jo=o(e),qe=r(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-xtr8tc"&&(qe.innerHTML=Ha),Jo=o(e),Ne=r(e,"TABLE",{"data-svelte-h":!0}),d(Ne)!=="svelte-6xvdso"&&(Ne.innerHTML=La),Eo=o(e),ko=r(e,"HR",{}),Do=o(e),Ke=r(e,"A",{id:!0,class:!0}),h(Ke).forEach(l),Io=o(e),m(Ve.$$.fragment,e),qo=o(e),Be=r(e,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-1okfsqx"&&(Be.textContent=wa),No=o(e),Qe=r(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-1t556pk"&&(Qe.innerHTML=Aa),Ko=o(e),Se=r(e,"TABLE",{"data-svelte-h":!0}),d(Se)!=="svelte-13m2wni"&&(Se.innerHTML=Ua),Vo=o(e),Bo=r(e,"HR",{}),Qo=o(e),Oe=r(e,"A",{id:!0,class:!0}),h(Oe).forEach(l),So=o(e),m(We.$$.fragment,e),Oo=o(e),Ye=r(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-1htpbrk"&&(Ye.innerHTML=ga),Wo=o(e),Fe=r(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1t0m8l6"&&(Fe.innerHTML=Pa),Yo=o(e),Xe=r(e,"TABLE",{"data-svelte-h":!0}),d(Xe)!=="svelte-1qi99pl"&&(Xe.innerHTML=Ra),Fo=o(e),Xo=r(e,"HR",{}),Go=o(e),Ge=r(e,"A",{id:!0,class:!0}),h(Ge).forEach(l),Zo=o(e),m(Ze.$$.fragment,e),ei=o(e),et=r(e,"P",{"data-svelte-h":!0}),d(et)!=="svelte-1ztgqp"&&(et.innerHTML=za),ti=o(e),tt=r(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-mvb39p"&&(tt.innerHTML=ja),li=o(e),lt=r(e,"TABLE",{"data-svelte-h":!0}),d(lt)!=="svelte-1qi99pl"&&(lt.innerHTML=Ja),si=o(e),ni=r(e,"HR",{}),oi=o(e),st=r(e,"A",{id:!0,class:!0}),h(st).forEach(l),ii=o(e),m(nt.$$.fragment,e),ri=o(e),ot=r(e,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-1a7u185"&&(ot.textContent=Ea),di=o(e),it=r(e,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1eu3doh"&&(it.innerHTML=ka),ui=o(e),ai=r(e,"HR",{}),mi=o(e),rt=r(e,"A",{id:!0,class:!0}),h(rt).forEach(l),pi=o(e),m(dt.$$.fragment,e),ci=o(e),ut=r(e,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-qls17b"&&(ut.textContent=Da),fi=o(e),at=r(e,"P",{"data-svelte-h":!0}),d(at)!=="svelte-5nabmy"&&(at.innerHTML=Ia),Ti=o(e),mt=r(e,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-1skbfxl"&&(mt.innerHTML=qa),hi=o(e),pt=r(e,"TABLE",{"data-svelte-h":!0}),d(pt)!=="svelte-52pnzr"&&(pt.innerHTML=Na),_i=o(e),$i=r(e,"HR",{}),vi=o(e),ct=r(e,"A",{id:!0,class:!0}),h(ct).forEach(l),yi=o(e),m(ft.$$.fragment,e),bi=o(e),Tt=r(e,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-19w0pic"&&(Tt.innerHTML=Ka),Mi=o(e),ht=r(e,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1mr58c3"&&(ht.innerHTML=Va),xi=o(e),Ci=r(e,"HR",{}),Hi=o(e),_t=r(e,"A",{id:!0,class:!0}),h(_t).forEach(l),Li=o(e),m($t.$$.fragment,e),wi=o(e),vt=r(e,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-18ws76n"&&(vt.textContent=Ba),Ai=o(e),yt=r(e,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-1tnr5gm"&&(yt.textContent=Qa),Ui=o(e),bt=r(e,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-1aoa5jo"&&(bt.innerHTML=Sa),gi=o(e),Mt=r(e,"TABLE",{"data-svelte-h":!0}),d(Mt)!=="svelte-1u9lyxp"&&(Mt.innerHTML=Oa),Pi=o(e),Ri=r(e,"HR",{}),zi=o(e),xt=r(e,"A",{id:!0,class:!0}),h(xt).forEach(l),ji=o(e),m(Ct.$$.fragment,e),Ji=o(e),Ht=r(e,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-1b9ygao"&&(Ht.innerHTML=Wa),Ei=o(e),Lt=r(e,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-1mr58c3"&&(Lt.innerHTML=Ya),ki=o(e),Di=r(e,"HR",{}),Ii=o(e),wt=r(e,"A",{id:!0,class:!0}),h(wt).forEach(l),qi=o(e),m(At.$$.fragment,e),Ni=o(e),Ut=r(e,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-1vkr5xo"&&(Ut.innerHTML=Fa),Ki=o(e),gt=r(e,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-1mr58c3"&&(gt.innerHTML=Xa),Vi=o(e),Bi=r(e,"HR",{}),Qi=o(e),Pt=r(e,"A",{id:!0,class:!0}),h(Pt).forEach(l),Si=o(e),m(Rt.$$.fragment,e),Oi=o(e),zt=r(e,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-1gguudf"&&(zt.innerHTML=Ga),Wi=o(e),jt=r(e,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-9ffe42"&&(jt.innerHTML=Za),Yi=o(e),Jt=r(e,"TABLE",{"data-svelte-h":!0}),d(Jt)!=="svelte-z6whez"&&(Jt.innerHTML=em),Fi=o(e),Xi=r(e,"HR",{}),Gi=o(e),Et=r(e,"A",{id:!0,class:!0}),h(Et).forEach(l),Zi=o(e),m(kt.$$.fragment,e),er=o(e),Dt=r(e,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-d6gvut"&&(Dt.innerHTML=tm),tr=o(e),It=r(e,"P",{"data-svelte-h":!0}),d(It)!=="svelte-18n9ux4"&&(It.innerHTML=lm),lr=o(e),qt=r(e,"TABLE",{"data-svelte-h":!0}),d(qt)!=="svelte-jj58dd"&&(qt.innerHTML=sm),sr=o(e),nr=r(e,"HR",{}),or=o(e),Nt=r(e,"A",{id:!0,class:!0}),h(Nt).forEach(l),ir=o(e),m(Kt.$$.fragment,e),rr=o(e),Vt=r(e,"P",{"data-svelte-h":!0}),d(Vt)!=="svelte-1adolpg"&&(Vt.innerHTML=nm),dr=o(e),Bt=r(e,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-1mr58c3"&&(Bt.innerHTML=om),ur=o(e),ar=r(e,"HR",{}),mr=o(e),Qt=r(e,"A",{id:!0,class:!0}),h(Qt).forEach(l),pr=o(e),m(St.$$.fragment,e),cr=o(e),Ot=r(e,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-1hm8vtj"&&(Ot.textContent=im),fr=o(e),Wt=r(e,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-106ei5g"&&(Wt.innerHTML=rm),Tr=o(e),Yt=r(e,"TABLE",{"data-svelte-h":!0}),d(Yt)!=="svelte-9ff0sy"&&(Yt.innerHTML=dm),hr=o(e),_r=r(e,"HR",{}),$r=o(e),Ft=r(e,"A",{id:!0,class:!0}),h(Ft).forEach(l),vr=o(e),m(Xt.$$.fragment,e),yr=o(e),Gt=r(e,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-1e6kzks"&&(Gt.innerHTML=um),br=o(e),Zt=r(e,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-1mr58c3"&&(Zt.innerHTML=am),Mr=o(e),xr=r(e,"HR",{}),Cr=o(e),el=r(e,"A",{id:!0,class:!0}),h(el).forEach(l),Hr=o(e),m(tl.$$.fragment,e),Lr=o(e),ll=r(e,"P",{"data-svelte-h":!0}),d(ll)!=="svelte-t5k6jp"&&(ll.textContent=mm),wr=o(e),sl=r(e,"P",{"data-svelte-h":!0}),d(sl)!=="svelte-106ei5g"&&(sl.innerHTML=pm),Ar=o(e),Ur=r(e,"HR",{}),gr=o(e),nl=r(e,"A",{id:!0,class:!0}),h(nl).forEach(l),Pr=o(e),m(ol.$$.fragment,e),Rr=o(e),il=r(e,"P",{"data-svelte-h":!0}),d(il)!=="svelte-avw2a1"&&(il.textContent=cm),zr=o(e),rl=r(e,"P",{"data-svelte-h":!0}),d(rl)!=="svelte-16q99cu"&&(rl.innerHTML=fm),jr=o(e),dl=r(e,"TABLE",{"data-svelte-h":!0}),d(dl)!=="svelte-8w2c3y"&&(dl.innerHTML=Tm),Jr=o(e),Er=r(e,"HR",{}),kr=o(e),ul=r(e,"A",{id:!0,class:!0}),h(ul).forEach(l),Dr=o(e),m(al.$$.fragment,e),Ir=o(e),ml=r(e,"P",{"data-svelte-h":!0}),d(ml)!=="svelte-15z3tv8"&&(ml.textContent=hm),qr=o(e),pl=r(e,"P",{"data-svelte-h":!0}),d(pl)!=="svelte-sv4gxb"&&(pl.innerHTML=_m),Nr=o(e),cl=r(e,"TABLE",{"data-svelte-h":!0}),d(cl)!=="svelte-q8pfpb"&&(cl.innerHTML=$m),Kr=o(e),Vr=r(e,"HR",{}),Br=o(e),fl=r(e,"A",{id:!0,class:!0}),h(fl).forEach(l),Qr=o(e),m(Tl.$$.fragment,e),Sr=o(e),hl=r(e,"P",{"data-svelte-h":!0}),d(hl)!=="svelte-fju8tm"&&(hl.textContent=vm),Or=o(e),_l=r(e,"P",{"data-svelte-h":!0}),d(_l)!=="svelte-13s6o0v"&&(_l.innerHTML=ym),Wr=o(e),$l=r(e,"TABLE",{"data-svelte-h":!0}),d($l)!=="svelte-8i278m"&&($l.innerHTML=bm),Yr=o(e),Fr=r(e,"HR",{}),Xr=o(e),vl=r(e,"A",{id:!0,class:!0}),h(vl).forEach(l),Gr=o(e),m(yl.$$.fragment,e),Zr=o(e),bl=r(e,"P",{"data-svelte-h":!0}),d(bl)!=="svelte-11ei68w"&&(bl.textContent=Mm),ed=o(e),Ml=r(e,"P",{"data-svelte-h":!0}),d(Ml)!=="svelte-1p3llh"&&(Ml.innerHTML=xm),td=o(e),xl=r(e,"TABLE",{"data-svelte-h":!0}),d(xl)!=="svelte-1xe0vb8"&&(xl.innerHTML=Cm),ld=o(e),sd=r(e,"HR",{}),nd=o(e),Cl=r(e,"A",{id:!0,class:!0}),h(Cl).forEach(l),od=o(e),m(Hl.$$.fragment,e),id=o(e),Ll=r(e,"P",{"data-svelte-h":!0}),d(Ll)!=="svelte-k6p1db"&&(Ll.textContent=Hm),rd=o(e),wl=r(e,"P",{"data-svelte-h":!0}),d(wl)!=="svelte-1o30xnd"&&(wl.innerHTML=Lm),dd=o(e),Al=r(e,"TABLE",{"data-svelte-h":!0}),d(Al)!=="svelte-101obk2"&&(Al.innerHTML=wm),ud=o(e),ad=r(e,"HR",{}),md=o(e),Ul=r(e,"A",{id:!0,class:!0}),h(Ul).forEach(l),pd=o(e),m(gl.$$.fragment,e),cd=o(e),Pl=r(e,"P",{"data-svelte-h":!0}),d(Pl)!=="svelte-8afo9v"&&(Pl.textContent=Am),fd=o(e),Rl=r(e,"P",{"data-svelte-h":!0}),d(Rl)!=="svelte-1vvmhgz"&&(Rl.innerHTML=Um),Td=o(e),zl=r(e,"TABLE",{"data-svelte-h":!0}),d(zl)!=="svelte-wz2jkw"&&(zl.innerHTML=gm),hd=o(e),_d=r(e,"HR",{}),$d=o(e),jl=r(e,"A",{id:!0,class:!0}),h(jl).forEach(l),vd=o(e),m(Jl.$$.fragment,e),yd=o(e),El=r(e,"P",{"data-svelte-h":!0}),d(El)!=="svelte-11plveb"&&(El.innerHTML=Pm),bd=o(e),kl=r(e,"P",{"data-svelte-h":!0}),d(kl)!=="svelte-1wu8g4g"&&(kl.innerHTML=Rm),Md=o(e),Dl=r(e,"TABLE",{"data-svelte-h":!0}),d(Dl)!=="svelte-1vsvca3"&&(Dl.innerHTML=zm),xd=o(e),Cd=r(e,"HR",{}),Hd=o(e),Il=r(e,"A",{id:!0,class:!0}),h(Il).forEach(l),Ld=o(e),m(ql.$$.fragment,e),wd=o(e),Nl=r(e,"P",{"data-svelte-h":!0}),d(Nl)!=="svelte-17f4oxi"&&(Nl.textContent=jm),Ad=o(e),Kl=r(e,"P",{"data-svelte-h":!0}),d(Kl)!=="svelte-1lh8r1a"&&(Kl.innerHTML=Jm),Ud=o(e),Vl=r(e,"TABLE",{"data-svelte-h":!0}),d(Vl)!=="svelte-m4z8c4"&&(Vl.innerHTML=Em),gd=o(e),Pd=r(e,"HR",{}),Rd=o(e),Bl=r(e,"A",{id:!0,class:!0}),h(Bl).forEach(l),zd=o(e),m(Ql.$$.fragment,e),jd=o(e),Sl=r(e,"P",{"data-svelte-h":!0}),d(Sl)!=="svelte-kcewlk"&&(Sl.textContent=km),Jd=o(e),Ol=r(e,"P",{"data-svelte-h":!0}),d(Ol)!=="svelte-17f480h"&&(Ol.innerHTML=Dm),Ed=o(e),Wl=r(e,"TABLE",{"data-svelte-h":!0}),d(Wl)!=="svelte-1to7jw8"&&(Wl.innerHTML=Im),kd=o(e),Dd=r(e,"HR",{}),Id=o(e),Yl=r(e,"A",{id:!0,class:!0}),h(Yl).forEach(l),qd=o(e),m(Fl.$$.fragment,e),Nd=o(e),Xl=r(e,"P",{"data-svelte-h":!0}),d(Xl)!=="svelte-1ayje0f"&&(Xl.textContent=qm),Kd=o(e),Gl=r(e,"P",{"data-svelte-h":!0}),d(Gl)!=="svelte-17f480h"&&(Gl.innerHTML=Nm),Vd=o(e),Zl=r(e,"TABLE",{"data-svelte-h":!0}),d(Zl)!=="svelte-gyxne1"&&(Zl.innerHTML=Km),Bd=o(e),Qd=r(e,"HR",{}),Sd=o(e),es=r(e,"A",{id:!0,class:!0}),h(es).forEach(l),Od=o(e),m(ts.$$.fragment,e),Wd=o(e),ls=r(e,"P",{"data-svelte-h":!0}),d(ls)!=="svelte-1wvb8sq"&&(ls.textContent=Vm),Yd=o(e),ss=r(e,"P",{"data-svelte-h":!0}),d(ss)!=="svelte-154yhp4"&&(ss.innerHTML=Bm),Fd=o(e),ns=r(e,"TABLE",{"data-svelte-h":!0}),d(ns)!=="svelte-1fk5fng"&&(ns.innerHTML=Qm),Xd=o(e),Gd=r(e,"HR",{}),Zd=o(e),os=r(e,"A",{id:!0,class:!0}),h(os).forEach(l),eu=o(e),m(is.$$.fragment,e),tu=o(e),rs=r(e,"P",{"data-svelte-h":!0}),d(rs)!=="svelte-l5lzdu"&&(rs.innerHTML=Sm),lu=o(e),su=r(e,"HR",{}),nu=o(e),ds=r(e,"A",{id:!0,class:!0}),h(ds).forEach(l),ou=o(e),m(us.$$.fragment,e),iu=o(e),as=r(e,"P",{"data-svelte-h":!0}),d(as)!=="svelte-40isdg"&&(as.textContent=Om),ru=o(e),ms=r(e,"P",{"data-svelte-h":!0}),d(ms)!=="svelte-tlsa2h"&&(ms.innerHTML=Wm),du=o(e),ps=r(e,"TABLE",{"data-svelte-h":!0}),d(ps)!=="svelte-1j7v21a"&&(ps.innerHTML=Ym),uu=o(e),cs=r(e,"P",{"data-svelte-h":!0}),d(cs)!=="svelte-1aswmub"&&(cs.innerHTML=Fm),au=o(e),m(fs.$$.fragment,e),mu=o(e),pu=r(e,"HR",{}),cu=o(e),Ts=r(e,"A",{id:!0,class:!0}),h(Ts).forEach(l),fu=o(e),m(hs.$$.fragment,e),Tu=o(e),_s=r(e,"P",{"data-svelte-h":!0}),d(_s)!=="svelte-kp31r8"&&(_s.innerHTML=Xm),hu=o(e),_u=r(e,"HR",{}),$u=o(e),$s=r(e,"A",{id:!0,class:!0}),h($s).forEach(l),vu=o(e),m(vs.$$.fragment,e),yu=o(e),ys=r(e,"P",{"data-svelte-h":!0}),d(ys)!=="svelte-1fs9no9"&&(ys.innerHTML=Gm),bu=o(e),Mu=r(e,"HR",{}),xu=o(e),bs=r(e,"A",{id:!0,class:!0}),h(bs).forEach(l),Cu=o(e),m(Ms.$$.fragment,e),Hu=o(e),xs=r(e,"P",{"data-svelte-h":!0}),d(xs)!=="svelte-2mif9c"&&(xs.textContent=Zm),Lu=o(e),Cs=r(e,"P",{"data-svelte-h":!0}),d(Cs)!=="svelte-1jas2kw"&&(Cs.innerHTML=ep),wu=o(e),m(Hs.$$.fragment,e),Au=o(e),Ls=r(e,"P",{"data-svelte-h":!0}),d(Ls)!=="svelte-1aswmub"&&(Ls.innerHTML=tp),Uu=o(e),m(ws.$$.fragment,e),gu=o(e),As=r(e,"P",{"data-svelte-h":!0}),d(As)!=="svelte-1aswmub"&&(As.innerHTML=lp),Pu=o(e),m(Us.$$.fragment,e),Ru=o(e),zu=r(e,"HR",{}),ju=o(e),Ps=r(e,"P",{}),h(Ps).forEach(l),this.h()},h(){u($,"name","hf:doc:metadata"),u($,"content",mp),u(v,"id","module_utils/tensor"),u(v,"class","group"),u(C,"id","module_utils/tensor.Tensor"),u(C,"class","group"),u(A,"id","new_module_utils/tensor.Tensor_new"),u(A,"class","group"),u(R,"id","module_utils/tensor.Tensor+Symbol.iterator"),u(R,"class","group"),u(E,"id","module_utils/tensor.Tensor+_getitem"),u(E,"class","group"),u(N,"id","module_utils/tensor.Tensor+indexOf"),u(N,"class","group"),u(Q,"id","module_utils/tensor.Tensor+_subarray"),u(Q,"class","group"),u(Y,"id","module_utils/tensor.Tensor+item"),u(Y,"class","group"),u(ee,"id","module_utils/tensor.Tensor+tolist"),u(ee,"class","group"),u(ne,"id","module_utils/tensor.Tensor+sigmoid"),u(ne,"class","group"),u(de,"id","module_utils/tensor.Tensor+sigmoid_"),u(de,"class","group"),u(pe,"id","module_utils/tensor.Tensor+mul"),u(pe,"class","group"),u(_e,"id","module_utils/tensor.Tensor+mul_"),u(_e,"class","group"),u(Me,"id","module_utils/tensor.Tensor+add"),u(Me,"class","group"),u(we,"id","module_utils/tensor.Tensor+add_"),u(we,"class","group"),u(Re,"id","module_utils/tensor.Tensor+transpose"),u(Re,"class","group"),u(ke,"id","module_utils/tensor.Tensor+sum"),u(ke,"class","group"),u(Ke,"id","module_utils/tensor.Tensor+norm"),u(Ke,"class","group"),u(Oe,"id","module_utils/tensor.Tensor+normalize_"),u(Oe,"class","group"),u(Ge,"id","module_utils/tensor.Tensor+normalize"),u(Ge,"class","group"),u(st,"id","module_utils/tensor.Tensor+stride"),u(st,"class","group"),u(rt,"id","module_utils/tensor.Tensor+squeeze"),u(rt,"class","group"),u(ct,"id","module_utils/tensor.Tensor+squeeze_"),u(ct,"class","group"),u(_t,"id","module_utils/tensor.Tensor+unsqueeze"),u(_t,"class","group"),u(xt,"id","module_utils/tensor.Tensor+unsqueeze_"),u(xt,"class","group"),u(wt,"id","module_utils/tensor.Tensor+flatten_"),u(wt,"class","group"),u(Pt,"id","module_utils/tensor.Tensor+flatten"),u(Pt,"class","group"),u(Et,"id","module_utils/tensor.Tensor+view"),u(Et,"class","group"),u(Nt,"id","module_utils/tensor.Tensor+clamp_"),u(Nt,"class","group"),u(Qt,"id","module_utils/tensor.Tensor+clamp"),u(Qt,"class","group"),u(Ft,"id","module_utils/tensor.Tensor+round_"),u(Ft,"class","group"),u(el,"id","module_utils/tensor.Tensor+round"),u(el,"class","group"),u(nl,"id","module_utils/tensor.Tensor+to"),u(nl,"class","group"),u(ul,"id","module_utils/tensor.transpose"),u(ul,"class","group"),u(fl,"id","module_utils/tensor.interpolate"),u(fl,"class","group"),u(vl,"id","module_utils/tensor.mean_pooling"),u(vl,"class","group"),u(Cl,"id","module_utils/tensor.cat"),u(Cl,"class","group"),u(Ul,"id","module_utils/tensor.stack"),u(Ul,"class","group"),u(jl,"id","module_utils/tensor.std_mean"),u(jl,"class","group"),u(Il,"id","module_utils/tensor.mean"),u(Il,"class","group"),u(Bl,"id","module_utils/tensor.dynamicTimeWarping"),u(Bl,"class","group"),u(Yl,"id","module_utils/tensor.ones"),u(Yl,"class","group"),u(es,"id","module_utils/tensor.ones_like"),u(es,"class","group"),u(os,"id","module_utils/tensor..ONNXTensor"),u(os,"class","group"),u(ds,"id","module_utils/tensor..reshape"),u(ds,"class","group"),u(Ts,"id","module_utils/tensor..reshape..reshapedArray"),u(Ts,"class","group"),u($s,"id","module_utils/tensor..DataArray"),u($s,"class","group"),u(bs,"id","module_utils/tensor..NestArray"),u(bs,"class","group")},m(e,t){up(document.head,$),s(e,Rs,t),s(e,gs,t),s(e,zs,t),s(e,v,t),s(e,js,t),p(y,e,t),s(e,Js,t),s(e,b,t),s(e,Es,t),s(e,M,t),s(e,ks,t),s(e,x,t),s(e,Ds,t),s(e,Is,t),s(e,qs,t),s(e,C,t),s(e,Ns,t),p(H,e,t),s(e,Ks,t),s(e,L,t),s(e,Vs,t),s(e,w,t),s(e,Bs,t),s(e,Qs,t),s(e,Ss,t),s(e,A,t),s(e,Os,t),p(U,e,t),s(e,Ws,t),s(e,g,t),s(e,Ys,t),s(e,P,t),s(e,Fs,t),s(e,Xs,t),s(e,Gs,t),s(e,R,t),s(e,Zs,t),p(z,e,t),s(e,en,t),s(e,j,t),s(e,tn,t),s(e,J,t),s(e,ln,t),s(e,sn,t),s(e,nn,t),s(e,E,t),s(e,on,t),p(k,e,t),s(e,rn,t),s(e,D,t),s(e,dn,t),s(e,I,t),s(e,un,t),s(e,q,t),s(e,an,t),s(e,mn,t),s(e,pn,t),s(e,N,t),s(e,cn,t),p(K,e,t),s(e,fn,t),s(e,V,t),s(e,Tn,t),s(e,B,t),s(e,hn,t),s(e,_n,t),s(e,$n,t),s(e,Q,t),s(e,vn,t),p(S,e,t),s(e,yn,t),s(e,O,t),s(e,bn,t),s(e,W,t),s(e,Mn,t),s(e,xn,t),s(e,Cn,t),s(e,Y,t),s(e,Hn,t),p(F,e,t),s(e,Ln,t),s(e,X,t),s(e,wn,t),s(e,G,t),s(e,An,t),s(e,Z,t),s(e,Un,t),s(e,gn,t),s(e,Pn,t),s(e,ee,t),s(e,Rn,t),p(te,e,t),s(e,zn,t),s(e,le,t),s(e,jn,t),s(e,se,t),s(e,Jn,t),s(e,En,t),s(e,kn,t),s(e,ne,t),s(e,Dn,t),p(oe,e,t),s(e,In,t),s(e,ie,t),s(e,qn,t),s(e,re,t),s(e,Nn,t),s(e,Kn,t),s(e,Vn,t),s(e,de,t),s(e,Bn,t),p(ue,e,t),s(e,Qn,t),s(e,ae,t),s(e,Sn,t),s(e,me,t),s(e,On,t),s(e,Wn,t),s(e,Yn,t),s(e,pe,t),s(e,Fn,t),p(ce,e,t),s(e,Xn,t),s(e,fe,t),s(e,Gn,t),s(e,Te,t),s(e,Zn,t),s(e,he,t),s(e,eo,t),s(e,to,t),s(e,lo,t),s(e,_e,t),s(e,so,t),p($e,e,t),s(e,no,t),s(e,ve,t),s(e,oo,t),s(e,ye,t),s(e,io,t),s(e,be,t),s(e,ro,t),s(e,uo,t),s(e,ao,t),s(e,Me,t),s(e,mo,t),p(xe,e,t),s(e,po,t),s(e,Ce,t),s(e,co,t),s(e,He,t),s(e,fo,t),s(e,Le,t),s(e,To,t),s(e,ho,t),s(e,_o,t),s(e,we,t),s(e,$o,t),p(Ae,e,t),s(e,vo,t),s(e,Ue,t),s(e,yo,t),s(e,ge,t),s(e,bo,t),s(e,Pe,t),s(e,Mo,t),s(e,xo,t),s(e,Co,t),s(e,Re,t),s(e,Ho,t),p(ze,e,t),s(e,Lo,t),s(e,je,t),s(e,wo,t),s(e,Je,t),s(e,Ao,t),s(e,Ee,t),s(e,Uo,t),s(e,go,t),s(e,Po,t),s(e,ke,t),s(e,Ro,t),p(De,e,t),s(e,zo,t),s(e,Ie,t),s(e,jo,t),s(e,qe,t),s(e,Jo,t),s(e,Ne,t),s(e,Eo,t),s(e,ko,t),s(e,Do,t),s(e,Ke,t),s(e,Io,t),p(Ve,e,t),s(e,qo,t),s(e,Be,t),s(e,No,t),s(e,Qe,t),s(e,Ko,t),s(e,Se,t),s(e,Vo,t),s(e,Bo,t),s(e,Qo,t),s(e,Oe,t),s(e,So,t),p(We,e,t),s(e,Oo,t),s(e,Ye,t),s(e,Wo,t),s(e,Fe,t),s(e,Yo,t),s(e,Xe,t),s(e,Fo,t),s(e,Xo,t),s(e,Go,t),s(e,Ge,t),s(e,Zo,t),p(Ze,e,t),s(e,ei,t),s(e,et,t),s(e,ti,t),s(e,tt,t),s(e,li,t),s(e,lt,t),s(e,si,t),s(e,ni,t),s(e,oi,t),s(e,st,t),s(e,ii,t),p(nt,e,t),s(e,ri,t),s(e,ot,t),s(e,di,t),s(e,it,t),s(e,ui,t),s(e,ai,t),s(e,mi,t),s(e,rt,t),s(e,pi,t),p(dt,e,t),s(e,ci,t),s(e,ut,t),s(e,fi,t),s(e,at,t),s(e,Ti,t),s(e,mt,t),s(e,hi,t),s(e,pt,t),s(e,_i,t),s(e,$i,t),s(e,vi,t),s(e,ct,t),s(e,yi,t),p(ft,e,t),s(e,bi,t),s(e,Tt,t),s(e,Mi,t),s(e,ht,t),s(e,xi,t),s(e,Ci,t),s(e,Hi,t),s(e,_t,t),s(e,Li,t),p($t,e,t),s(e,wi,t),s(e,vt,t),s(e,Ai,t),s(e,yt,t),s(e,Ui,t),s(e,bt,t),s(e,gi,t),s(e,Mt,t),s(e,Pi,t),s(e,Ri,t),s(e,zi,t),s(e,xt,t),s(e,ji,t),p(Ct,e,t),s(e,Ji,t),s(e,Ht,t),s(e,Ei,t),s(e,Lt,t),s(e,ki,t),s(e,Di,t),s(e,Ii,t),s(e,wt,t),s(e,qi,t),p(At,e,t),s(e,Ni,t),s(e,Ut,t),s(e,Ki,t),s(e,gt,t),s(e,Vi,t),s(e,Bi,t),s(e,Qi,t),s(e,Pt,t),s(e,Si,t),p(Rt,e,t),s(e,Oi,t),s(e,zt,t),s(e,Wi,t),s(e,jt,t),s(e,Yi,t),s(e,Jt,t),s(e,Fi,t),s(e,Xi,t),s(e,Gi,t),s(e,Et,t),s(e,Zi,t),p(kt,e,t),s(e,er,t),s(e,Dt,t),s(e,tr,t),s(e,It,t),s(e,lr,t),s(e,qt,t),s(e,sr,t),s(e,nr,t),s(e,or,t),s(e,Nt,t),s(e,ir,t),p(Kt,e,t),s(e,rr,t),s(e,Vt,t),s(e,dr,t),s(e,Bt,t),s(e,ur,t),s(e,ar,t),s(e,mr,t),s(e,Qt,t),s(e,pr,t),p(St,e,t),s(e,cr,t),s(e,Ot,t),s(e,fr,t),s(e,Wt,t),s(e,Tr,t),s(e,Yt,t),s(e,hr,t),s(e,_r,t),s(e,$r,t),s(e,Ft,t),s(e,vr,t),p(Xt,e,t),s(e,yr,t),s(e,Gt,t),s(e,br,t),s(e,Zt,t),s(e,Mr,t),s(e,xr,t),s(e,Cr,t),s(e,el,t),s(e,Hr,t),p(tl,e,t),s(e,Lr,t),s(e,ll,t),s(e,wr,t),s(e,sl,t),s(e,Ar,t),s(e,Ur,t),s(e,gr,t),s(e,nl,t),s(e,Pr,t),p(ol,e,t),s(e,Rr,t),s(e,il,t),s(e,zr,t),s(e,rl,t),s(e,jr,t),s(e,dl,t),s(e,Jr,t),s(e,Er,t),s(e,kr,t),s(e,ul,t),s(e,Dr,t),p(al,e,t),s(e,Ir,t),s(e,ml,t),s(e,qr,t),s(e,pl,t),s(e,Nr,t),s(e,cl,t),s(e,Kr,t),s(e,Vr,t),s(e,Br,t),s(e,fl,t),s(e,Qr,t),p(Tl,e,t),s(e,Sr,t),s(e,hl,t),s(e,Or,t),s(e,_l,t),s(e,Wr,t),s(e,$l,t),s(e,Yr,t),s(e,Fr,t),s(e,Xr,t),s(e,vl,t),s(e,Gr,t),p(yl,e,t),s(e,Zr,t),s(e,bl,t),s(e,ed,t),s(e,Ml,t),s(e,td,t),s(e,xl,t),s(e,ld,t),s(e,sd,t),s(e,nd,t),s(e,Cl,t),s(e,od,t),p(Hl,e,t),s(e,id,t),s(e,Ll,t),s(e,rd,t),s(e,wl,t),s(e,dd,t),s(e,Al,t),s(e,ud,t),s(e,ad,t),s(e,md,t),s(e,Ul,t),s(e,pd,t),p(gl,e,t),s(e,cd,t),s(e,Pl,t),s(e,fd,t),s(e,Rl,t),s(e,Td,t),s(e,zl,t),s(e,hd,t),s(e,_d,t),s(e,$d,t),s(e,jl,t),s(e,vd,t),p(Jl,e,t),s(e,yd,t),s(e,El,t),s(e,bd,t),s(e,kl,t),s(e,Md,t),s(e,Dl,t),s(e,xd,t),s(e,Cd,t),s(e,Hd,t),s(e,Il,t),s(e,Ld,t),p(ql,e,t),s(e,wd,t),s(e,Nl,t),s(e,Ad,t),s(e,Kl,t),s(e,Ud,t),s(e,Vl,t),s(e,gd,t),s(e,Pd,t),s(e,Rd,t),s(e,Bl,t),s(e,zd,t),p(Ql,e,t),s(e,jd,t),s(e,Sl,t),s(e,Jd,t),s(e,Ol,t),s(e,Ed,t),s(e,Wl,t),s(e,kd,t),s(e,Dd,t),s(e,Id,t),s(e,Yl,t),s(e,qd,t),p(Fl,e,t),s(e,Nd,t),s(e,Xl,t),s(e,Kd,t),s(e,Gl,t),s(e,Vd,t),s(e,Zl,t),s(e,Bd,t),s(e,Qd,t),s(e,Sd,t),s(e,es,t),s(e,Od,t),p(ts,e,t),s(e,Wd,t),s(e,ls,t),s(e,Yd,t),s(e,ss,t),s(e,Fd,t),s(e,ns,t),s(e,Xd,t),s(e,Gd,t),s(e,Zd,t),s(e,os,t),s(e,eu,t),p(is,e,t),s(e,tu,t),s(e,rs,t),s(e,lu,t),s(e,su,t),s(e,nu,t),s(e,ds,t),s(e,ou,t),p(us,e,t),s(e,iu,t),s(e,as,t),s(e,ru,t),s(e,ms,t),s(e,du,t),s(e,ps,t),s(e,uu,t),s(e,cs,t),s(e,au,t),p(fs,e,t),s(e,mu,t),s(e,pu,t),s(e,cu,t),s(e,Ts,t),s(e,fu,t),p(hs,e,t),s(e,Tu,t),s(e,_s,t),s(e,hu,t),s(e,_u,t),s(e,$u,t),s(e,$s,t),s(e,vu,t),p(vs,e,t),s(e,yu,t),s(e,ys,t),s(e,bu,t),s(e,Mu,t),s(e,xu,t),s(e,bs,t),s(e,Cu,t),p(Ms,e,t),s(e,Hu,t),s(e,xs,t),s(e,Lu,t),s(e,Cs,t),s(e,wu,t),p(Hs,e,t),s(e,Au,t),s(e,Ls,t),s(e,Uu,t),p(ws,e,t),s(e,gu,t),s(e,As,t),s(e,Pu,t),p(Us,e,t),s(e,Ru,t),s(e,zu,t),s(e,ju,t),s(e,Ps,t),Ju=!0},p:np,i(e){Ju||(c(y.$$.fragment,e),c(H.$$.fragment,e),c(U.$$.fragment,e),c(z.$$.fragment,e),c(k.$$.fragment,e),c(K.$$.fragment,e),c(S.$$.fragment,e),c(F.$$.fragment,e),c(te.$$.fragment,e),c(oe.$$.fragment,e),c(ue.$$.fragment,e),c(ce.$$.fragment,e),c($e.$$.fragment,e),c(xe.$$.fragment,e),c(Ae.$$.fragment,e),c(ze.$$.fragment,e),c(De.$$.fragment,e),c(Ve.$$.fragment,e),c(We.$$.fragment,e),c(Ze.$$.fragment,e),c(nt.$$.fragment,e),c(dt.$$.fragment,e),c(ft.$$.fragment,e),c($t.$$.fragment,e),c(Ct.$$.fragment,e),c(At.$$.fragment,e),c(Rt.$$.fragment,e),c(kt.$$.fragment,e),c(Kt.$$.fragment,e),c(St.$$.fragment,e),c(Xt.$$.fragment,e),c(tl.$$.fragment,e),c(ol.$$.fragment,e),c(al.$$.fragment,e),c(Tl.$$.fragment,e),c(yl.$$.fragment,e),c(Hl.$$.fragment,e),c(gl.$$.fragment,e),c(Jl.$$.fragment,e),c(ql.$$.fragment,e),c(Ql.$$.fragment,e),c(Fl.$$.fragment,e),c(ts.$$.fragment,e),c(is.$$.fragment,e),c(us.$$.fragment,e),c(fs.$$.fragment,e),c(hs.$$.fragment,e),c(vs.$$.fragment,e),c(Ms.$$.fragment,e),c(Hs.$$.fragment,e),c(ws.$$.fragment,e),c(Us.$$.fragment,e),Ju=!0)},o(e){f(y.$$.fragment,e),f(H.$$.fragment,e),f(U.$$.fragment,e),f(z.$$.fragment,e),f(k.$$.fragment,e),f(K.$$.fragment,e),f(S.$$.fragment,e),f(F.$$.fragment,e),f(te.$$.fragment,e),f(oe.$$.fragment,e),f(ue.$$.fragment,e),f(ce.$$.fragment,e),f($e.$$.fragment,e),f(xe.$$.fragment,e),f(Ae.$$.fragment,e),f(ze.$$.fragment,e),f(De.$$.fragment,e),f(Ve.$$.fragment,e),f(We.$$.fragment,e),f(Ze.$$.fragment,e),f(nt.$$.fragment,e),f(dt.$$.fragment,e),f(ft.$$.fragment,e),f($t.$$.fragment,e),f(Ct.$$.fragment,e),f(At.$$.fragment,e),f(Rt.$$.fragment,e),f(kt.$$.fragment,e),f(Kt.$$.fragment,e),f(St.$$.fragment,e),f(Xt.$$.fragment,e),f(tl.$$.fragment,e),f(ol.$$.fragment,e),f(al.$$.fragment,e),f(Tl.$$.fragment,e),f(yl.$$.fragment,e),f(Hl.$$.fragment,e),f(gl.$$.fragment,e),f(Jl.$$.fragment,e),f(ql.$$.fragment,e),f(Ql.$$.fragment,e),f(Fl.$$.fragment,e),f(ts.$$.fragment,e),f(is.$$.fragment,e),f(us.$$.fragment,e),f(fs.$$.fragment,e),f(hs.$$.fragment,e),f(vs.$$.fragment,e),f(Ms.$$.fragment,e),f(Hs.$$.fragment,e),f(ws.$$.fragment,e),f(Us.$$.fragment,e),Ju=!1},d(e){e&&(l(Rs),l(gs),l(zs),l(v),l(js),l(Js),l(b),l(Es),l(M),l(ks),l(x),l(Ds),l(Is),l(qs),l(C),l(Ns),l(Ks),l(L),l(Vs),l(w),l(Bs),l(Qs),l(Ss),l(A),l(Os),l(Ws),l(g),l(Ys),l(P),l(Fs),l(Xs),l(Gs),l(R),l(Zs),l(en),l(j),l(tn),l(J),l(ln),l(sn),l(nn),l(E),l(on),l(rn),l(D),l(dn),l(I),l(un),l(q),l(an),l(mn),l(pn),l(N),l(cn),l(fn),l(V),l(Tn),l(B),l(hn),l(_n),l($n),l(Q),l(vn),l(yn),l(O),l(bn),l(W),l(Mn),l(xn),l(Cn),l(Y),l(Hn),l(Ln),l(X),l(wn),l(G),l(An),l(Z),l(Un),l(gn),l(Pn),l(ee),l(Rn),l(zn),l(le),l(jn),l(se),l(Jn),l(En),l(kn),l(ne),l(Dn),l(In),l(ie),l(qn),l(re),l(Nn),l(Kn),l(Vn),l(de),l(Bn),l(Qn),l(ae),l(Sn),l(me),l(On),l(Wn),l(Yn),l(pe),l(Fn),l(Xn),l(fe),l(Gn),l(Te),l(Zn),l(he),l(eo),l(to),l(lo),l(_e),l(so),l(no),l(ve),l(oo),l(ye),l(io),l(be),l(ro),l(uo),l(ao),l(Me),l(mo),l(po),l(Ce),l(co),l(He),l(fo),l(Le),l(To),l(ho),l(_o),l(we),l($o),l(vo),l(Ue),l(yo),l(ge),l(bo),l(Pe),l(Mo),l(xo),l(Co),l(Re),l(Ho),l(Lo),l(je),l(wo),l(Je),l(Ao),l(Ee),l(Uo),l(go),l(Po),l(ke),l(Ro),l(zo),l(Ie),l(jo),l(qe),l(Jo),l(Ne),l(Eo),l(ko),l(Do),l(Ke),l(Io),l(qo),l(Be),l(No),l(Qe),l(Ko),l(Se),l(Vo),l(Bo),l(Qo),l(Oe),l(So),l(Oo),l(Ye),l(Wo),l(Fe),l(Yo),l(Xe),l(Fo),l(Xo),l(Go),l(Ge),l(Zo),l(ei),l(et),l(ti),l(tt),l(li),l(lt),l(si),l(ni),l(oi),l(st),l(ii),l(ri),l(ot),l(di),l(it),l(ui),l(ai),l(mi),l(rt),l(pi),l(ci),l(ut),l(fi),l(at),l(Ti),l(mt),l(hi),l(pt),l(_i),l($i),l(vi),l(ct),l(yi),l(bi),l(Tt),l(Mi),l(ht),l(xi),l(Ci),l(Hi),l(_t),l(Li),l(wi),l(vt),l(Ai),l(yt),l(Ui),l(bt),l(gi),l(Mt),l(Pi),l(Ri),l(zi),l(xt),l(ji),l(Ji),l(Ht),l(Ei),l(Lt),l(ki),l(Di),l(Ii),l(wt),l(qi),l(Ni),l(Ut),l(Ki),l(gt),l(Vi),l(Bi),l(Qi),l(Pt),l(Si),l(Oi),l(zt),l(Wi),l(jt),l(Yi),l(Jt),l(Fi),l(Xi),l(Gi),l(Et),l(Zi),l(er),l(Dt),l(tr),l(It),l(lr),l(qt),l(sr),l(nr),l(or),l(Nt),l(ir),l(rr),l(Vt),l(dr),l(Bt),l(ur),l(ar),l(mr),l(Qt),l(pr),l(cr),l(Ot),l(fr),l(Wt),l(Tr),l(Yt),l(hr),l(_r),l($r),l(Ft),l(vr),l(yr),l(Gt),l(br),l(Zt),l(Mr),l(xr),l(Cr),l(el),l(Hr),l(Lr),l(ll),l(wr),l(sl),l(Ar),l(Ur),l(gr),l(nl),l(Pr),l(Rr),l(il),l(zr),l(rl),l(jr),l(dl),l(Jr),l(Er),l(kr),l(ul),l(Dr),l(Ir),l(ml),l(qr),l(pl),l(Nr),l(cl),l(Kr),l(Vr),l(Br),l(fl),l(Qr),l(Sr),l(hl),l(Or),l(_l),l(Wr),l($l),l(Yr),l(Fr),l(Xr),l(vl),l(Gr),l(Zr),l(bl),l(ed),l(Ml),l(td),l(xl),l(ld),l(sd),l(nd),l(Cl),l(od),l(id),l(Ll),l(rd),l(wl),l(dd),l(Al),l(ud),l(ad),l(md),l(Ul),l(pd),l(cd),l(Pl),l(fd),l(Rl),l(Td),l(zl),l(hd),l(_d),l($d),l(jl),l(vd),l(yd),l(El),l(bd),l(kl),l(Md),l(Dl),l(xd),l(Cd),l(Hd),l(Il),l(Ld),l(wd),l(Nl),l(Ad),l(Kl),l(Ud),l(Vl),l(gd),l(Pd),l(Rd),l(Bl),l(zd),l(jd),l(Sl),l(Jd),l(Ol),l(Ed),l(Wl),l(kd),l(Dd),l(Id),l(Yl),l(qd),l(Nd),l(Xl),l(Kd),l(Gl),l(Vd),l(Zl),l(Bd),l(Qd),l(Sd),l(es),l(Od),l(Wd),l(ls),l(Yd),l(ss),l(Fd),l(ns),l(Xd),l(Gd),l(Zd),l(os),l(eu),l(tu),l(rs),l(lu),l(su),l(nu),l(ds),l(ou),l(iu),l(as),l(ru),l(ms),l(du),l(ps),l(uu),l(cs),l(au),l(mu),l(pu),l(cu),l(Ts),l(fu),l(Tu),l(_s),l(hu),l(_u),l($u),l($s),l(vu),l(yu),l(ys),l(bu),l(Mu),l(xu),l(bs),l(Cu),l(Hu),l(xs),l(Lu),l(Cs),l(wu),l(Au),l(Ls),l(Uu),l(gu),l(As),l(Pu),l(Ru),l(zu),l(ju),l(Ps)),l($),T(y,e),T(H,e),T(U,e),T(z,e),T(k,e),T(K,e),T(S,e),T(F,e),T(te,e),T(oe,e),T(ue,e),T(ce,e),T($e,e),T(xe,e),T(Ae,e),T(ze,e),T(De,e),T(Ve,e),T(We,e),T(Ze,e),T(nt,e),T(dt,e),T(ft,e),T($t,e),T(Ct,e),T(At,e),T(Rt,e),T(kt,e),T(Kt,e),T(St,e),T(Xt,e),T(tl,e),T(ol,e),T(al,e),T(Tl,e),T(yl,e),T(Hl,e),T(gl,e),T(Jl,e),T(ql,e),T(Ql,e),T(Fl,e),T(ts,e),T(is,e),T(us,e),T(fs,e),T(hs,e),T(vs,e),T(Ms,e),T(Hs,e),T(ws,e),T(Us,e)}}}const mp='{"title":"utils/tensor","local":"utilstensor","sections":[{"title":"utils/tensor.Tensor","local":"utilstensortensor","sections":[{"title":"new Tensor(...args)","local":"new-tensorargs","sections":[],"depth":3},{"title":"tensor.Symbol.iterator() ⇒ <code> Iterator </code>","local":"tensorsymboliterator--code-iterator-code","sections":[],"depth":3},{"title":"tensor._getitem(index) ⇒ <code> Tensor </code>","local":"tensorgetitemindex--code-tensor-code","sections":[],"depth":3},{"title":"tensor.indexOf(item) ⇒ <code> number </code>","local":"tensorindexofitem--code-number-code","sections":[],"depth":3},{"title":"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>","local":"tensorsubarrayindex-itersize-iterdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.item() ⇒ <code> number </code>","local":"tensoritem--code-number-code","sections":[],"depth":3},{"title":"tensor.tolist() ⇒ <code> Array </code>","local":"tensortolist--code-array-code","sections":[],"depth":3},{"title":"tensor.sigmoid() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sigmoid_() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul_(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add_(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.transpose(...dims) ⇒ <code> Tensor </code>","local":"tensortransposedims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sum([dim], keepdim) ⇒","local":"tensorsumdim-keepdim-","sections":[],"depth":3},{"title":"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>","local":"tensornormp-dim-keepdim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.stride() ⇒ <code> Array. < number > </code>","local":"tensorstride--code-array--number--code","sections":[],"depth":3},{"title":"tensor.squeeze([dim]) ⇒","local":"tensorsqueezedim-","sections":[],"depth":3},{"title":"tensor.squeeze_()","local":"tensorsqueeze","sections":[],"depth":3},{"title":"tensor.unsqueeze(dim) ⇒","local":"tensorunsqueezedim-","sections":[],"depth":3},{"title":"tensor.unsqueeze_()","local":"tensorunsqueeze","sections":[],"depth":3},{"title":"tensor.flatten_()","local":"tensorflatten","sections":[],"depth":3},{"title":"tensor.flatten(start_dim, end_dim) ⇒","local":"tensorflattenstartdim-enddim-","sections":[],"depth":3},{"title":"tensor.view(...dims) ⇒ <code> Tensor </code>","local":"tensorviewdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clamp_()","local":"tensorclamp","sections":[],"depth":3},{"title":"tensor.clamp(min, max) ⇒","local":"tensorclampmin-max-","sections":[],"depth":3},{"title":"tensor.round_()","local":"tensorround","sections":[],"depth":3},{"title":"tensor.round() ⇒","local":"tensorround-","sections":[],"depth":3},{"title":"tensor.to(type) ⇒ <code> Tensor </code>","local":"tensortotype--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor.transpose(tensor, axes) ⇒ <code> Tensor </code>","local":"utilstensortransposetensor-axes--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>","local":"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>","local":"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorcattensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorstacktensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>","local":"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.mean(input, dim, keepdim) ⇒","local":"utilstensormeaninput-dim-keepdim-","sections":[],"depth":2},{"title":"utils/tensor.dynamicTimeWarping(matrix) ⇒ <code> Array. < Array < number > > </code>","local":"utilstensordynamictimewarpingmatrix--code-array--array--number---code","sections":[],"depth":2},{"title":"utils/tensor.ones(size)","local":"utilstensoronessize","sections":[],"depth":2},{"title":"utils/tensor.ones_like(tensor) ⇒","local":"utilstensoronesliketensor-","sections":[],"depth":2},{"title":"utils/tensor~ONNXTensor : <code> Object </code>","local":"utilstensoronnxtensor--code-object-code","sections":[],"depth":2},{"title":"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>","local":"utilstensorreshapedata-dimensions--code--code","sections":[{"title":"reshape~reshapedArray : <code> any </code>","local":"reshapereshapedarray--code-any-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor~DataArray : <code> * </code>","local":"utilstensordataarray--code--code","sections":[],"depth":2},{"title":"utils/tensor~NestArray : <code> * </code>","local":"utilstensornestarray--code--code","sections":[],"depth":2}],"depth":1}';function pp(ku){return op(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _p extends ip{constructor($){super(),rp(this,$,pp,ap,sp,{})}}export{_p as component};
