import{s as SJ,n as LJ,o as FJ}from"../chunks/scheduler.b108d059.js";import{S as DJ,i as qJ,g as a,s as i,r as c,A as OJ,h as p,f as l,c as n,j as u,u as r,x as o,k as d,y as KJ,a as s,v as M,d as m,t as T,w as y}from"../chunks/index.008de539.js";import{C as h}from"../chunks/CodeBlock.3968c746.js";import{H as J}from"../chunks/Heading.88bfeb84.js";function eh(wT){let w,En,Pn,Wn,j,Xn,U,zn,f,jT="Pipelines provide a high-level, easy to use, API for running machine learning models.",Sn,b,UT="<strong>Example:</strong> Instantiate pipeline using the <code>pipeline</code> function.",Ln,x,Fn,C,fT='<li><a href="#module_pipelines">pipelines</a><ul><li><em>static</em><ul><li><a href="#module_pipelines.Pipeline">.Pipeline</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_pipelines.Pipeline_new"><code>new Pipeline(options)</code></a></li> <li><a href="#module_pipelines.Pipeline+dispose"><code>.dispose()</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li> <li><a href="#module_pipelines.Pipeline+_call"><code>._call(texts, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.TextClassificationPipeline">.TextClassificationPipeline</a><ul><li><a href="#module_pipelines.TextClassificationPipeline+_call"><code>._call(texts, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.TokenClassificationPipeline">.TokenClassificationPipeline</a><ul><li><a href="#module_pipelines.TokenClassificationPipeline+_call"><code>._call(texts, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.QuestionAnsweringPipeline">.QuestionAnsweringPipeline</a><ul><li><a href="#module_pipelines.QuestionAnsweringPipeline+_call"><code>._call(question, context, options)</code></a> ⇒ <code>QuestionAnsweringReturnType</code></li></ul></li> <li><a href="#module_pipelines.FillMaskPipeline">.FillMaskPipeline</a><ul><li><a href="#module_pipelines.FillMaskPipeline+_call"><code>._call(texts, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.Text2TextGenerationPipeline">.Text2TextGenerationPipeline</a><ul><li><a href="#module_pipelines.Text2TextGenerationPipeline+_call"><code>._call(texts, [options])</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.SummarizationPipeline">.SummarizationPipeline</a></li> <li><a href="#module_pipelines.TranslationPipeline">.TranslationPipeline</a></li> <li><a href="#module_pipelines.TextGenerationPipeline">.TextGenerationPipeline</a><ul><li><a href="#module_pipelines.TextGenerationPipeline+_call"><code>._call(texts, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline">.ZeroShotClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotClassificationPipeline_new"><code>new ZeroShotClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline+_call"><code>._call(texts, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li> <li><a href="#module_pipelines.FeatureExtractionPipeline">.FeatureExtractionPipeline</a><ul><li><a href="#module_pipelines.FeatureExtractionPipeline+_call"><code>._call(texts, options)</code></a> ⇒</li></ul></li> <li><a href="#module_pipelines.AudioClassificationPipeline">.AudioClassificationPipeline</a><ul><li><a href="#new_module_pipelines.AudioClassificationPipeline_new"><code>new AudioClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.AudioClassificationPipeline+_call"><code>._call(audio, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline">.AutomaticSpeechRecognitionPipeline</a><ul><li><a href="#new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"><code>new AutomaticSpeechRecognitionPipeline(options)</code></a></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline+_call"><code>._call(audio, [kwargs])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageToTextPipeline">.ImageToTextPipeline</a><ul><li><a href="#new_module_pipelines.ImageToTextPipeline_new"><code>new ImageToTextPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageToTextPipeline+_call"><code>._call(images, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageClassificationPipeline">.ImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ImageClassificationPipeline_new"><code>new ImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageClassificationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageSegmentationPipeline">.ImageSegmentationPipeline</a><ul><li><a href="#new_module_pipelines.ImageSegmentationPipeline_new"><code>new ImageSegmentationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageSegmentationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;Array&gt;</code></li></ul></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline">.ZeroShotImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotImageClassificationPipeline_new"><code>new ZeroShotImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline+_call"><code>._call(images, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.ObjectDetectionPipeline">.ObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ObjectDetectionPipeline_new"><code>new ObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ObjectDetectionPipeline+_call"><code>._call(images, options)</code></a></li></ul></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline">.DocumentQuestionAnsweringPipeline</a><ul><li><a href="#new_module_pipelines.DocumentQuestionAnsweringPipeline_new"><code>new DocumentQuestionAnsweringPipeline(options)</code></a></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline+_call"><code>._call(image, question, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li> <li><a href="#module_pipelines.TextToAudioPipeline">.TextToAudioPipeline</a><ul><li><a href="#new_module_pipelines.TextToAudioPipeline_new"><code>new TextToAudioPipeline(options)</code></a></li> <li><a href="#module_pipelines.TextToAudioPipeline+_call"><code>._call(text_inputs, options)</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageToImagePipeline">.ImageToImagePipeline</a><ul><li><a href="#module_pipelines.ImageToImagePipeline+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.pipeline"><code>.pipeline(task, [model], [options])</code></a> ⇒ <code>Promise.&lt;Pipeline&gt;</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_pipelines..QuestionAnsweringResult"><code>~QuestionAnsweringResult</code></a> : <code>object</code></li> <li><a href="#module_pipelines..QuestionAnsweringReturnType"><code>~QuestionAnsweringReturnType</code></a> : <code>Promise.&lt;(QuestionAnsweringResult|Array&lt;QuestionAnsweringResult&gt;)&gt;</code></li> <li><a href="#module_pipelines..ChunkCallback"><code>~ChunkCallback</code></a> : <code>function</code></li></ul></li></ul></li>',Dn,qn,On,g,Kn,I,ea,k,bT=`The Pipeline class is the class from which all pipelines inherit.
Refer to this class for methods shared across different pipelines.`,ta,G,xT='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',la,Z,CT='<li><a href="#module_pipelines.Pipeline">.Pipeline</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_pipelines.Pipeline_new"><code>new Pipeline(options)</code></a></li> <li><a href="#module_pipelines.Pipeline+dispose"><code>.dispose()</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li> <li><a href="#module_pipelines.Pipeline+_call"><code>._call(texts, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',sa,ia,na,B,aa,Q,pa,v,gT="Create a new Pipeline.",oa,N,IT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><code></code></td><td><p>The tokenizer to use (if any).</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><code></code></td><td><p>The processor to use (if any).</p></td></tr></tbody>",da,ca,ra,A,Ma,_,ma,$,kT="Disposes the model.",Ta,R,GT='<strong>Kind</strong>: instance method of <a href="#module_pipelines.Pipeline"><code>Pipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;void&gt;</code> - A promise that resolves when the model has been disposed.',ya,ua,Ja,V,ha,Y,wa,P,ZT="Executes the task associated with the pipeline.",ja,H,BT='<strong>Kind</strong>: instance method of <a href="#module_pipelines.Pipeline"><code>Pipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A promise that resolves to an array containing the inputs and outputs of the task.',Ua,E,QT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td><p>The input texts to be processed.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",fa,ba,xa,W,Ca,X,ga,z,vT="Text classification pipeline using any <code>ModelForSequenceClassification</code>.",Ia,S,NT="<strong>Example:</strong> Sentiment-analysis w/ <code>Xenova/distilbert-base-uncased-finetuned-sst-2-english</code>.",ka,L,Ga,F,AT="<strong>Example:</strong> Multilingual sentiment-analysis w/ <code>Xenova/bert-base-multilingual-uncased-sentiment</code> (and return top 5 classes).",Za,D,Ba,q,_T="<strong>Example:</strong> Toxic comment classification w/ <code>Xenova/toxic-bert</code> (and return all classes).",Qa,O,va,K,$T='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Na,Aa,_a,ee,$a,te,Ra,le,RT="Executes the text classification task.",Va,se,VT='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextClassificationPipeline"><code>TextClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted labels and scores.',Ya,ie,YT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td></td><td><p>The input texts to be classified.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top predictions to be returned.</p></td></tr></tbody>",Pa,Ha,Ea,ne,Wa,ae,Xa,pe,PT="Named Entity Recognition pipeline using any <code>ModelForTokenClassification</code>.",za,oe,HT="<strong>Example:</strong> Perform named entity recognition with <code>Xenova/bert-base-NER</code>.",Sa,de,La,ce,ET="<strong>Example:</strong> Perform named entity recognition with <code>Xenova/bert-base-NER</code> (and return all labels).",Fa,re,Da,Me,WT='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',qa,Oa,Ka,me,ep,Te,tp,ye,XT="Executes the token classification task.",lp,ue,zT='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TokenClassificationPipeline"><code>TokenClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted labels and scores.',sp,Je,ST="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td><p>The input texts to be classified.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>An optional object containing the following properties:</p></td></tr></tbody>",ip,np,ap,he,pp,we,op,je,LT="Question Answering pipeline using any <code>ModelForQuestionAnswering</code>.",dp,Ue,FT="<strong>Example:</strong> Run question answering with <code>Xenova/distilbert-base-uncased-distilled-squad</code>.",cp,fe,rp,be,DT='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Mp,mp,Tp,xe,yp,Ce,up,ge,qT="Executes the question answering task.",Jp,Ie,OT=`<strong>Kind</strong>: instance method of <a href="#module_pipelines.QuestionAnsweringPipeline"><code>QuestionAnsweringPipeline</code></a><br/> <strong>Returns</strong>: <code>QuestionAnsweringReturnType</code> - A promise that resolves to an array or object
containing the predicted answers and scores.`,hp,ke,KT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>question</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The question(s) to be answered.</p></td> </tr><tr><td>context</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The context(s) where the answer(s) can be found.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top answer predictions to be returned.</p></td></tr></tbody>",wp,jp,Up,Ge,fp,Ze,bp,Be,ey="Masked language modeling prediction pipeline using any <code>ModelWithLMHead</code>.",xp,Qe,ty="<strong>Example:</strong> Perform masked language modelling (a.k.a. “fill-mask”) with <code>Xenova/bert-base-uncased</code>.",Cp,ve,gp,Ne,ly="<strong>Example:</strong> Perform masked language modelling (a.k.a. “fill-mask”) with <code>Xenova/bert-base-cased</code> (and return top result).",Ip,Ae,kp,_e,sy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Gp,Zp,Bp,$e,Qp,Re,vp,Ve,iy="Fill the masked token in the text(s) given as inputs.",Np,Ye,ny='<strong>Kind</strong>: instance method of <a href="#module_pipelines.FillMaskPipeline"><code>FillMaskPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted tokens and scores.',Ap,Pe,ay="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td></td><td><p>The masked input texts.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>5</code></td><td><p>The number of top predictions to be returned.</p></td></tr></tbody>",_p,$p,Rp,He,Vp,Ee,Yp,We,py="Text2TextGenerationPipeline class for generating text using a model that performs text-to-text generation tasks.",Pp,Xe,oy="<strong>Example:</strong> Text-to-text generation w/ <code>Xenova/LaMini-Flan-T5-783M</code>.",Hp,ze,Ep,Se,dy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Wp,Xp,zp,Le,Sp,Fe,Lp,De,cy="Fill the masked token in the text(s) given as inputs.",Fp,qe,ry=`<strong>Kind</strong>: instance method of <a href="#module_pipelines.Text2TextGenerationPipeline"><code>Text2TextGenerationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - An array of objects containing the score, predicted token, predicted token string,
and the sequence with the predicted token filled in, or an array of such arrays (one for each input text).
If only one input text is given, the output will be an array of objects.<br/> <strong>Throws</strong>:`,Dp,Oe,My="<li><code>Error</code> When the mask token is not found in the input text.</li>",qp,Ke,my="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The text or array of texts to be processed.</p></td> </tr><tr><td>[options]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Options for the fill-mask pipeline.</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>5</code></td><td><p>The number of top-k predictions to return.</p></td></tr></tbody>",Op,Kp,eo,et,to,tt,lo,lt,Ty="A pipeline for summarization tasks, inheriting from Text2TextGenerationPipeline.",so,st,yy="<strong>Example:</strong> Summarization w/ <code>Xenova/distilbart-cnn-6-6</code>.",io,it,no,nt,uy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',ao,po,oo,at,co,pt,ro,ot,Jy="Translates text from one language to another.",Mo,dt,hy="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/nllb-200-distilled-600M</code>.",mo,ct,wy=`See <a href="https://github.com/facebookresearch/flores/blob/main/flores200/README.md#languages-in-flores-200" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,To,rt,yo,Mt,jy="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/m2m100_418M</code>.",uo,mt,Uy=`See <a href="https://huggingface.co/facebook/m2m100_418M#languages-covered" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,Jo,Tt,ho,yt,fy="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/mbart-large-50-many-to-many-mmt</code>.",wo,ut,by=`See <a href="https://huggingface.co/facebook/mbart-large-50-many-to-many-mmt#languages-covered" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,jo,Jt,Uo,ht,xy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',fo,bo,xo,wt,Co,jt,go,Ut,Cy=`Language generation pipeline using any <code>ModelWithLMHead</code> or <code>ModelForCausalLM</code>.
This pipeline predicts the words that will follow a specified text prompt.
NOTE: For the full list of generation parameters, see <a href="./utils/generation#module_utils/generation.GenerationConfig"><code>GenerationConfig</code></a>.`,Io,ft,gy="<strong>Example:</strong> Text generation with <code>Xenova/distilgpt2</code> (default settings).",ko,bt,Go,xt,Iy="<strong>Example:</strong> Text generation with <code>Xenova/distilgpt2</code> (custom settings).",Zo,Ct,Bo,gt,ky="<strong>Example:</strong> Run code generation with <code>Xenova/codegen-350M-mono</code>.",Qo,It,vo,kt,Gy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',No,Ao,_o,Gt,$o,Zt,Ro,Bt,Zy="Generates text based on an input prompt.",Vo,Qt,By='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextGenerationPipeline"><code>TextGenerationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - The generated text or texts.',Yo,vt,Qy="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td></td><td><p>The input prompt or prompts to generate text from.</p></td> </tr><tr><td>[generate_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Additional arguments for text generation.</p></td></tr></tbody>",Po,Ho,Eo,Nt,Wo,At,Xo,_t,vy=`NLI-based zero-shot classification pipeline using a <code>ModelForSequenceClassification</code>
trained on NLI (natural language inference) tasks. Equivalent of <code>text-classification</code>
pipelines, but these models don’t require a hardcoded number of potential classes, they
can be chosen at runtime. It usually means it’s slower but it is <strong>much</strong> more flexible.`,zo,$t,Ny="<strong>Example:</strong> Zero shot classification with <code>Xenova/mobilebert-uncased-mnli</code>.",So,Rt,Lo,Vt,Ay="<strong>Example:</strong> Zero shot classification with <code>Xenova/nli-deberta-v3-xsmall</code> (multi-label).",Fo,Yt,Do,Pt,_y='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',qo,Ht,$y='<li><a href="#module_pipelines.ZeroShotClassificationPipeline">.ZeroShotClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotClassificationPipeline_new"><code>new ZeroShotClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline+_call"><code>._call(texts, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li>',Oo,Ko,ed,Et,td,Wt,ld,Xt,Ry="Create a new ZeroShotClassificationPipeline.",sd,zt,Vy="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td></tr></tbody>",id,nd,ad,St,pd,Lt,od,Ft,Yy='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ZeroShotClassificationPipeline"><code>ZeroShotClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code> - The prediction(s), as a map (or list of maps) from label to score.',dd,Dt,Py=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>Array.&lt;any&gt;</code></td><td></td><td></td> </tr><tr><td>candidate_labels</td><td><code>Array.&lt;string&gt;</code></td><td></td><td></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Additional options:</p></td> </tr><tr><td>[options.hypothesis_template]</td><td><code>string</code></td><td><code>&quot;&quot;This example is {}.&quot;&quot;</code></td><td><p>The template used to turn each
candidate label into an NLI-style hypothesis. The candidate label will replace the &amp;#123;} placeholder.</p></td> </tr><tr><td>[options.multi_label]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not multiple candidate labels can be true.
If <code>false</code>, the scores are normalized such that the sum of the label likelihoods for each sequence
is 1. If <code>true</code>, the labels are considered independent and probabilities are normalized for each
candidate by doing a softmax of the entailment score vs. the contradiction score.</p></td></tr></tbody>`,cd,rd,Md,qt,md,Ot,Td,Kt,Hy=`Feature extraction pipeline using no model head. This pipeline extracts the hidden
states from the base transformer, which can be used as features in downstream tasks.`,yd,el,Ey="<strong>Example:</strong> Run feature extraction with <code>bert-base-uncased</code> (without pooling/normalization).",ud,tl,Jd,ll,Wy="<strong>Example:</strong> Run feature extraction with <code>bert-base-uncased</code> (with pooling/normalization).",hd,sl,wd,il,Xy="<strong>Example:</strong> Calculating embeddings with <code>sentence-transformers</code> models.",jd,nl,Ud,al,zy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',fd,bd,xd,pl,Cd,ol,gd,dl,Sy="Extract the features of the input(s).",Id,cl,Ly='<strong>Kind</strong>: instance method of <a href="#module_pipelines.FeatureExtractionPipeline"><code>FeatureExtractionPipeline</code></a><br/> <strong>Returns</strong>: The features computed by the model.',kd,rl,Fy="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The input texts</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Additional options:</p></td> </tr><tr><td>[options.pooling]</td><td><code>string</code></td><td><code>&quot;&quot;none&quot;&quot;</code></td><td><p>The pooling method to use. Can be one of: &quot;none&quot;, &quot;mean&quot;.</p></td> </tr><tr><td>[options.normalize]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to normalize the embeddings in the last dimension.</p></td></tr></tbody>",Gd,Zd,Bd,Ml,Qd,ml,vd,Tl,Dy=`Audio classification pipeline using any <code>AutoModelForAudioClassification</code>.
This pipeline predicts the class of a raw waveform or an audio file.`,Nd,yl,qy="<strong>Example:</strong> Perform audio classification.",Ad,ul,_d,Jl,Oy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',$d,hl,Ky='<li><a href="#module_pipelines.AudioClassificationPipeline">.AudioClassificationPipeline</a><ul><li><a href="#new_module_pipelines.AudioClassificationPipeline_new"><code>new AudioClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.AudioClassificationPipeline+_call"><code>._call(audio, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li>',Rd,Vd,Yd,wl,Pd,jl,Hd,Ul,eu="Create a new AudioClassificationPipeline.",Ed,fl,tu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",Wd,Xd,zd,bl,Sd,xl,Ld,Cl,lu="Executes the audio classification task.",Fd,gl,su='<strong>Kind</strong>: instance method of <a href="#module_pipelines.AudioClassificationPipeline"><code>AudioClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted labels and scores.',Dd,Il,iu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>any</code></td><td></td><td><p>The input audio files to be classified.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>5</code></td><td><p>The number of top predictions to be returned.</p></td></tr></tbody>",qd,Od,Kd,kl,ec,Gl,tc,Zl,nu="Pipeline that aims at extracting spoken text contained within some audio.",lc,Bl,au="<strong>Example:</strong> Transcribe English.",sc,Ql,ic,vl,pu="<strong>Example:</strong> Transcribe English w/ timestamps.",nc,Nl,ac,Al,ou="<strong>Example:</strong> Transcribe English w/ word-level timestamps.",pc,_l,oc,$l,du="<strong>Example:</strong> Transcribe French.",dc,Rl,cc,Vl,cu="<strong>Example:</strong> Translate French to English.",rc,Yl,Mc,Pl,ru="<strong>Example:</strong> Transcribe/translate audio longer than 30 seconds.",mc,Hl,Tc,El,Mu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',yc,Wl,mu='<li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline">.AutomaticSpeechRecognitionPipeline</a><ul><li><a href="#new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"><code>new AutomaticSpeechRecognitionPipeline(options)</code></a></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline+_call"><code>._call(audio, [kwargs])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',uc,Jc,hc,Xl,wc,zl,jc,Sl,Tu="Create a new AutomaticSpeechRecognitionPipeline.",Uc,Ll,yu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",fc,bc,xc,Fl,Cc,Dl,gc,ql,uu="Asynchronously processes audio and generates text transcription using the model.",Ic,Ol,Ju='<strong>Kind</strong>: instance method of <a href="#module_pipelines.AutomaticSpeechRecognitionPipeline"><code>AutomaticSpeechRecognitionPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - A Promise that resolves to an object containing the transcription text and optionally timestamps if <code>return_timestamps</code> is <code>true</code>.',kc,Kl,hu=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>Float32Array</code> | <code>Array&lt;Float32Array&gt;</code></td><td></td><td><p>The audio to be transcribed. Can be a single Float32Array or an array of Float32Arrays.</p></td> </tr><tr><td>[kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Optional arguments.</p></td> </tr><tr><td>[kwargs.return_timestamps]</td><td><code>boolean</code> | <code>&#39;word&#39;</code></td><td></td><td><p>Whether to return timestamps or not. Default is <code>false</code>.</p></td> </tr><tr><td>[kwargs.chunk_length_s]</td><td><code>number</code></td><td></td><td><p>The length of audio chunks to process in seconds. Default is 0 (no chunking).</p></td> </tr><tr><td>[kwargs.stride_length_s]</td><td><code>number</code></td><td></td><td><p>The length of overlap between consecutive audio chunks in seconds. If not provided, defaults to <code>chunk_length_s / 6</code>.</p></td> </tr><tr><td>[kwargs.chunk_callback]</td><td><code>ChunkCallback</code></td><td></td><td><p>Callback function to be called with each chunk processed.</p></td> </tr><tr><td>[kwargs.force_full_sequences]</td><td><code>boolean</code></td><td></td><td><p>Whether to force outputting full sequences or not. Default is <code>false</code>.</p></td> </tr><tr><td>[kwargs.language]</td><td><code>string</code></td><td></td><td><p>The source language. Default is <code>null</code>, meaning it should be auto-detected. Use this to potentially improve performance if the source language is known.</p></td> </tr><tr><td>[kwargs.task]</td><td><code>string</code></td><td></td><td><p>The task to perform. Default is <code>null</code>, meaning it should be auto-detected.</p></td> </tr><tr><td>[kwargs.forced_decoder_ids]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td></td><td><p>A list of pairs of integers which indicates a mapping from generation indices to token indices
that will be forced before sampling. For example, [[1, 123]] means the second generated token will always be a token of index 123.</p></td></tr></tbody>`,Gc,Zc,Bc,es,Qc,ts,vc,ls,wu="Image To Text pipeline using a <code>AutoModelForVision2Seq</code>. This pipeline predicts a caption for a given image.",Nc,ss,ju="<strong>Example:</strong> Generate a caption for an image w/ <code>Xenova/vit-gpt2-image-captioning</code>.",Ac,is,_c,ns,Uu="<strong>Example:</strong> Optical Character Recognition (OCR) w/ <code>Xenova/trocr-small-handwritten</code>.",$c,as,Rc,ps,fu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Vc,os,bu='<li><a href="#module_pipelines.ImageToTextPipeline">.ImageToTextPipeline</a><ul><li><a href="#new_module_pipelines.ImageToTextPipeline_new"><code>new ImageToTextPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageToTextPipeline+_call"><code>._call(images, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li>',Yc,Pc,Hc,ds,Ec,cs,Wc,rs,xu="Create a new ImageToTextPipeline.",Xc,Ms,Cu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",zc,Sc,Lc,ms,Fc,Ts,Dc,ys,gu="Assign labels to the image(s) passed as inputs.",qc,us,Iu='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageToTextPipeline"><code>ImageToTextPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code> - A Promise that resolves to an object (or array of objects) containing the generated text(s).',Oc,Js,ku="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;any&gt;</code></td><td></td><td><p>The images to be captioned.</p></td> </tr><tr><td>[generate_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Optional generation arguments.</p></td></tr></tbody>",Kc,er,tr,hs,lr,ws,sr,js,Gu=`Image classification pipeline using any <code>AutoModelForImageClassification</code>.
This pipeline predicts the class of an image.`,ir,Us,Zu="<strong>Example:</strong> Classify an image.",nr,fs,ar,bs,Bu="<strong>Example:</strong> Classify an image and return top <code>n</code> classes.",pr,xs,or,Cs,Qu="<strong>Example:</strong> Classify an image and return all classes.",dr,gs,cr,Is,vu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',rr,ks,Nu='<li><a href="#module_pipelines.ImageClassificationPipeline">.ImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ImageClassificationPipeline_new"><code>new ImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageClassificationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',Mr,mr,Tr,Gs,yr,Zs,ur,Bs,Au="Create a new ImageClassificationPipeline.",Jr,Qs,_u="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",hr,wr,jr,vs,Ur,Ns,fr,As,$u="Classify the given images.",br,_s,Ru='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageClassificationPipeline"><code>ImageClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - The top classification results for the images.',xr,$s,Vu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>any</code></td><td></td><td><p>The images to classify.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options to use for classification.</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top results to return.</p></td></tr></tbody>",Cr,gr,Ir,Rs,kr,Vs,Gr,Ys,Yu=`Image segmentation pipeline using any <code>AutoModelForXXXSegmentation</code>.
This pipeline predicts masks of objects and their classes.`,Zr,Ps,Pu="<strong>Example:</strong> Perform image segmentation with <code>Xenova/detr-resnet-50-panoptic</code>.",Br,Hs,Qr,Es,Hu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',vr,Ws,Eu='<li><a href="#module_pipelines.ImageSegmentationPipeline">.ImageSegmentationPipeline</a><ul><li><a href="#new_module_pipelines.ImageSegmentationPipeline_new"><code>new ImageSegmentationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageSegmentationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;Array&gt;</code></li></ul></li>',Nr,Ar,_r,Xs,$r,zs,Rr,Ss,Wu="Create a new ImageSegmentationPipeline.",Vr,Ls,Xu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",Yr,Pr,Hr,Fs,Er,Ds,Wr,qs,zu="Segment the input images.",Xr,Os,Su='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageSegmentationPipeline"><code>ImageSegmentationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Array&gt;</code> - The annotated segments.',zr,Ks,Lu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array</code></td><td></td><td><p>The input images.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options to use for segmentation.</p></td> </tr><tr><td>[options.threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Probability threshold to filter out predicted masks.</p></td> </tr><tr><td>[options.mask_threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Threshold to use when turning the predicted masks into binary values.</p></td> </tr><tr><td>[options.overlap_mask_area_threshold]</td><td><code>number</code></td><td><code>0.8</code></td><td><p>Mask overlap threshold to eliminate small, disconnected segments.</p></td> </tr><tr><td>[options.subtask]</td><td><code>null</code> | <code>string</code></td><td><code></code></td><td><p>Segmentation task to be performed. One of [<code>panoptic</code>, <code>instance</code>, and <code>semantic</code>], depending on model capabilities. If not set, the pipeline will attempt to resolve (in that order).</p></td> </tr><tr><td>[options.label_ids_to_fuse]</td><td><code>Array</code></td><td><code></code></td><td><p>List of label ids to fuse. If not set, do not fuse any labels.</p></td> </tr><tr><td>[options.target_sizes]</td><td><code>Array</code></td><td><code></code></td><td><p>List of target sizes for the input images. If not set, use the original image sizes.</p></td></tr></tbody>",Sr,Lr,Fr,ei,Dr,ti,qr,li,Fu=`Zero shot image classification pipeline. This pipeline predicts the class of
an image when you provide an image and a set of <code>candidate_labels</code>.`,Or,si,Du="<strong>Example:</strong> Zero shot image classification w/ <code>Xenova/clip-vit-base-patch32</code>.",Kr,ii,eM,ni,qu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',tM,ai,Ou='<li><a href="#module_pipelines.ZeroShotImageClassificationPipeline">.ZeroShotImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotImageClassificationPipeline_new"><code>new ZeroShotImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline+_call"><code>._call(images, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',lM,sM,iM,pi,nM,oi,aM,di,Ku="Create a new ZeroShotImageClassificationPipeline.",pM,ci,eJ="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",oM,dM,cM,ri,rM,Mi,MM,mi,tJ="Classify the input images with candidate labels using a zero-shot approach.",mM,Ti,lJ='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ZeroShotImageClassificationPipeline"><code>ZeroShotImageClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - An array of classifications for each input image or a single classification object if only one input image is provided.',TM,yi,sJ="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array</code></td><td><p>The input images.</p></td> </tr><tr><td>candidate_labels</td><td><code>Array.&lt;string&gt;</code></td><td><p>The candidate labels.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>The options for the classification.</p></td> </tr><tr><td>[options.hypothesis_template]</td><td><code>string</code></td><td><p>The hypothesis template to use for zero-shot classification. Default: &quot;This is a photo of &amp;#123;}&quot;.</p></td></tr></tbody>",yM,uM,JM,ui,hM,Ji,wM,hi,iJ=`Object detection pipeline using any <code>AutoModelForObjectDetection</code>.
This pipeline predicts bounding boxes of objects and their classes.`,jM,wi,nJ="<strong>Example:</strong> Run object-detection with <code>facebook/detr-resnet-50</code>.",UM,ji,fM,Ui,aJ='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',bM,fi,pJ='<li><a href="#module_pipelines.ObjectDetectionPipeline">.ObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ObjectDetectionPipeline_new"><code>new ObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ObjectDetectionPipeline+_call"><code>._call(images, options)</code></a></li></ul></li>',xM,CM,gM,bi,IM,xi,kM,Ci,oJ="Create a new ObjectDetectionPipeline.",GM,gi,dJ="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",ZM,BM,QM,Ii,vM,ki,NM,Gi,cJ="Detect objects (bounding boxes & classes) in the image(s) passed as inputs.",AM,Zi,rJ='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ObjectDetectionPipeline"><code>ObjectDetectionPipeline</code></a>',_M,Bi,MJ="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;any&gt;</code></td><td></td><td><p>The input images.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the object detection.</p></td> </tr><tr><td>[options.threshold]</td><td><code>number</code></td><td><code>0.9</code></td><td><p>The threshold used to filter boxes by score.</p></td> </tr><tr><td>[options.percentage]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to return the boxes coordinates in percentage (true) or in pixels (false).</p></td></tr></tbody>",$M,RM,VM,Qi,YM,vi,PM,Ni,mJ=`Document Question Answering pipeline using any <code>AutoModelForDocumentQuestionAnswering</code>.
The inputs/outputs are similar to the (extractive) question answering pipeline; however,
the pipeline takes an image (and optional OCR’d words/boxes) as input instead of text context.`,HM,Ai,TJ="<strong>Example:</strong> Answer questions about a document with <code>Xenova/donut-base-finetuned-docvqa</code>.",EM,_i,WM,$i,yJ='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',XM,Ri,uJ='<li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline">.DocumentQuestionAnsweringPipeline</a><ul><li><a href="#new_module_pipelines.DocumentQuestionAnsweringPipeline_new"><code>new DocumentQuestionAnsweringPipeline(options)</code></a></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline+_call"><code>._call(image, question, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li>',zM,SM,LM,Vi,FM,Yi,DM,Pi,JJ="Create a new DocumentQuestionAnsweringPipeline.",qM,Hi,hJ="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",OM,KM,em,Ei,tm,Wi,lm,Xi,wJ="Answer the question given as input by using the document.",sm,zi,jJ='<strong>Kind</strong>: instance method of <a href="#module_pipelines.DocumentQuestionAnsweringPipeline"><code>DocumentQuestionAnsweringPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code> - A Promise that resolves to an object (or array of objects) containing the generated text(s).',im,Si,UJ="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>any</code></td><td></td><td><p>The image of the document to use.</p></td> </tr><tr><td>question</td><td><code>string</code></td><td></td><td><p>A question to ask of the document.</p></td> </tr><tr><td>[generate_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Optional generation arguments.</p></td></tr></tbody>",nm,am,pm,Li,om,Fi,dm,Di,fJ=`Text-to-audio generation pipeline using any <code>AutoModelForTextToWaveform</code> or <code>AutoModelForTextToSpectrogram</code>.
This pipeline generates an audio file from an input text and optional other conditional inputs.`,cm,qi,bJ="<strong>Example:</strong> Generate audio from text with <code>Xenova/speecht5_tts</code>.",rm,Oi,Mm,Ki,xJ="You can then save the audio to a .wav file with the <code>wavefile</code> package:",mm,en,Tm,tn,CJ='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',ym,ln,gJ='<li><a href="#module_pipelines.TextToAudioPipeline">.TextToAudioPipeline</a><ul><li><a href="#new_module_pipelines.TextToAudioPipeline_new"><code>new TextToAudioPipeline(options)</code></a></li> <li><a href="#module_pipelines.TextToAudioPipeline+_call"><code>._call(text_inputs, options)</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',um,Jm,hm,sn,wm,nn,jm,an,IJ="Create a new TextToAudioPipeline.",Um,pn,kJ="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td> </tr><tr><td>[options.vocoder]</td><td><code>PreTrainedModel</code></td><td><p>The vocoder to use.</p></td></tr></tbody>",fm,bm,xm,on,Cm,dn,gm,cn,GJ="Generates speech/audio from the inputs.",Im,rn,ZJ='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextToAudioPipeline"><code>TextToAudioPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - An object containing the generated audio and sampling rate.',km,Mn,BJ="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>text_inputs</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The text(s) to generate.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Parameters passed to the model generation/forward method.</p></td> </tr><tr><td>[options.vocoder]</td><td><code>PreTrainedModel</code></td><td><code></code></td><td><p>The vocoder to use (if the model uses one). If not provided, use the default HifiGan vocoder.</p></td> </tr><tr><td>[options.speaker_embeddings]</td><td><code>Tensor</code> | <code>Float32Array</code> | <code>string</code> | <code>URL</code></td><td><code></code></td><td></td></tr></tbody>",Gm,Zm,Bm,mn,Qm,Tn,vm,yn,QJ="Image to Image pipeline using any <code>AutoModelForImageToImage</code>. This pipeline generates an image based on a previous image input.",Nm,un,vJ="<strong>Example:</strong> Super-resolution w/ <code>Xenova/swin2SR-classical-sr-x2-64</code>",Am,Jn,_m,hn,NJ='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',$m,Rm,Vm,wn,Ym,jn,Pm,Un,AJ="Transform the image(s) passed as inputs.",Hm,fn,_J='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageToImagePipeline"><code>ImageToImagePipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - An image or a list of images containing result(s).',Em,bn,$J="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>any</code></td><td><p>The images to transform.</p></td></tr></tbody>",Wm,Xm,zm,xn,Sm,Cn,Lm,gn,RJ="Utility factory method to build a [<code>Pipeline</code>] object.",Fm,In,VJ='<strong>Kind</strong>: static method of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Pipeline&gt;</code> - A Pipeline object for the specified task.<br/> <strong>Throws</strong>:',Dm,kn,YJ="<li><code>Error</code> If an unsupported pipeline is requested.</li>",qm,Gn,PJ="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>task</td><td><code>string</code></td><td></td><td><p>The task defining which pipeline will be returned. Currently accepted tasks are:</p> <ul><li><code>&quot;audio-classification&quot;</code>: will return a <code>AudioClassificationPipeline</code>.</li> <li><code>&quot;automatic-speech-recognition&quot;</code>: will return a <code>AutomaticSpeechRecognitionPipeline</code>.</li> <li><code>&quot;document-question-answering&quot;</code>: will return a <code>DocumentQuestionAnsweringPipeline</code>.</li> <li><code>&quot;feature-extraction&quot;</code>: will return a <code>FeatureExtractionPipeline</code>.</li> <li><code>&quot;fill-mask&quot;</code>: will return a <code>FillMaskPipeline</code>.</li> <li><code>&quot;image-classification&quot;</code>: will return a <code>ImageClassificationPipeline</code>.</li> <li><code>&quot;image-segmentation&quot;</code>: will return a <code>ImageSegmentationPipeline</code>.</li> <li><code>&quot;image-to-text&quot;</code>: will return a <code>ImageToTextPipeline</code>.</li> <li><code>&quot;object-detection&quot;</code>: will return a <code>ObjectDetectionPipeline</code>.</li> <li><code>&quot;question-answering&quot;</code>: will return a <code>QuestionAnsweringPipeline</code>.</li> <li><code>&quot;summarization&quot;</code>: will return a <code>SummarizationPipeline</code>.</li> <li><code>&quot;text2text-generation&quot;</code>: will return a <code>Text2TextGenerationPipeline</code>.</li> <li><code>&quot;text-classification&quot;</code> (alias &quot;sentiment-analysis&quot; available): will return a <code>TextClassificationPipeline</code>.</li> <li><code>&quot;text-generation&quot;</code>: will return a <code>TextGenerationPipeline</code>.</li> <li><code>&quot;token-classification&quot;</code> (alias &quot;ner&quot; available): will return a <code>TokenClassificationPipeline</code>.</li> <li><code>&quot;translation&quot;</code>: will return a <code>TranslationPipeline</code>.</li> <li><code>&quot;translation_xx_to_yy&quot;</code>: will return a <code>TranslationPipeline</code>.</li> <li><code>&quot;zero-shot-classification&quot;</code>: will return a <code>ZeroShotClassificationPipeline</code>.</li> <li><code>&quot;zero-shot-image-classification&quot;</code>: will return a <code>ZeroShotImageClassificationPipeline</code>.</li></ul></td> </tr><tr><td>[model]</td><td><code>string</code></td><td><code>null</code></td><td><p>The name of the pre-trained model to use. If not specified, the default model for the task will be used.</p></td> </tr><tr><td>[options]</td><td><code>*</code></td><td></td><td><p>Optional parameters for the pipeline.</p></td></tr></tbody>",Om,Km,eT,Zn,tT,Bn,lT,Qn,HJ='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Properties</strong>',sT,vn,EJ="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>answer</td><td><code>string</code></td><td><p>The answer.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td><p>The score.</p></td></tr></tbody>",iT,nT,aT,Nn,pT,An,oT,_n,WJ='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a>',dT,cT,rT,$n,MT,Rn,mT,Vn,XJ='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a>',TT,Yn,zJ="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>chunk</td><td><code>Chunk</code></td><td><p>The chunk to process.</p></td></tr></tbody>",yT,uT,JT,Hn,hT;return U=new J({props:{title:"pipelines",local:"pipelines",headingTag:"h1"}}),x=new h({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEElMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnc2VudGltZW50LWFuYWx5c2lzJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ0klMjBsb3ZlJTIwdHJhbnNmb3JtZXJzIScpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJ2xhYmVsJyUzQSUyMCdQT1NJVElWRSclMkMlMjAnc2NvcmUnJTNBJTIwMC45OTk4MTc2ODYlN0QlNUQ=",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;

<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>);
<span class="hljs-comment">// [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.999817686}]</span>`,wrap:!1}}),I=new J({props:{title:"pipelines.Pipeline ⇐ <code> Callable </code>",local:"pipelinespipeline--code-callable-code",headingTag:"h2"}}),Q=new J({props:{title:"new Pipeline(options)",local:"new-pipelineoptions",headingTag:"h3"}}),_=new J({props:{title:"pipeline.dispose() ⇒ <code> Promise. < void > </code>",local:"pipelinedispose--code-promise--void--code",headingTag:"h3"}}),Y=new J({props:{title:"pipeline._call(texts, ...args) ⇒ <code> Promise. < any > </code>",local:"pipelinecalltexts-args--code-promise--any--code",headingTag:"h3"}}),X=new J({props:{title:"pipelines.TextClassificationPipeline",local:"pipelinestextclassificationpipeline",headingTag:"h2"}}),L=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcyclMkMlMjAnWGVub3ZhJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcignSSUyMGxvdmUlMjB0cmFuc2Zvcm1lcnMhJyklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjBsYWJlbCUzQSUyMCdQT1NJVElWRSclMkMlMjBzY29yZSUzQSUyMDAuOTk5Nzg4NzYxMTM4OTE2JTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>);
<span class="hljs-comment">// [{ label: &#x27;POSITIVE&#x27;, score: 0.999788761138916 }]</span>`,wrap:!1}}),D=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcyclMkMlMjAnWGVub3ZhJTJGYmVydC1iYXNlLW11bHRpbGluZ3VhbC11bmNhc2VkLXNlbnRpbWVudCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKCdMZSUyMG1laWxsZXVyJTIwZmlsbSUyMGRlJTIwdG91cyUyMGxlcyUyMHRlbXBzLiclMkMlMjAlN0IlMjB0b3BrJTNBJTIwNSUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCc1JTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjk2MTA3NTk2MTU4OTgxMzIlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCc0JTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjAzMzIzMzUxNTkxODI1NDg1JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnMyUyMHN0YXJzJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDM2MTU1MTgxMDA1NTk3MTE1JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnMSUyMHN0YXInJTJDJTIwc2NvcmUlM0ElMjAwLjAwMTEzMjU5Njc0OTgxMjM2NDYlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCcyJTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjAwMDk0MjM5NzEwNTk3MzIxMzklMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-multilingual-uncased-sentiment&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;Le meilleur film de tous les temps.&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-number">5</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;5 stars&#x27;, score: 0.9610759615898132 },</span>
<span class="hljs-comment">//   { label: &#x27;4 stars&#x27;, score: 0.03323351591825485 },</span>
<span class="hljs-comment">//   { label: &#x27;3 stars&#x27;, score: 0.0036155181005597115 },</span>
<span class="hljs-comment">//   { label: &#x27;1 star&#x27;, score: 0.0011325967498123646 },</span>
<span class="hljs-comment">//   { label: &#x27;2 stars&#x27;, score: 0.0009423971059732139 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),O=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RleHQtY2xhc3NpZmljYXRpb24nJTJDJTIwJ1hlbm92YSUyRnRveGljLWJlcnQnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcignSSUyMGhhdGUlMjB5b3UhJyUyQyUyMCU3QiUyMHRvcGslM0ElMjBudWxsJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RveGljJyUyQyUyMHNjb3JlJTNBJTIwMC45NTkzMTQwNDgyOTAyNTI3JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnaW5zdWx0JyUyQyUyMHNjb3JlJTNBJTIwMC4xNjE4NzMzNDA2MDY2ODk0NSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ29ic2NlbmUnJTJDJTIwc2NvcmUlM0ElMjAwLjAzNDUyNjgwNjMyNDcyMDM4JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnaWRlbnRpdHlfaGF0ZSclMkMlMjBzY29yZSUzQSUyMDAuMDIyMzI1MDU3NTM2MzYzNiUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RocmVhdCclMkMlMjBzY29yZSUzQSUyMDAuMDE5MTk3MDQxMTY4ODA4OTM3JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnc2V2ZXJlX3RveGljJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDU2NTEwOTk2MDczNDg0NDIlMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/toxic-bert&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I hate you!&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-literal">null</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;toxic&#x27;, score: 0.9593140482902527 },</span>
<span class="hljs-comment">//   { label: &#x27;insult&#x27;, score: 0.16187334060668945 },</span>
<span class="hljs-comment">//   { label: &#x27;obscene&#x27;, score: 0.03452680632472038 },</span>
<span class="hljs-comment">//   { label: &#x27;identity_hate&#x27;, score: 0.0223250575363636 },</span>
<span class="hljs-comment">//   { label: &#x27;threat&#x27;, score: 0.019197041168808937 },</span>
<span class="hljs-comment">//   { label: &#x27;severe_toxic&#x27;, score: 0.005651099607348442 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),te=new J({props:{title:"textClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"textclassificationpipelinecalltexts-options--code-promise--array--object--object--code",headingTag:"h3"}}),ae=new J({props:{title:"pipelines.TokenClassificationPipeline",local:"pipelinestokenclassificationpipeline",headingTag:"h2"}}),de=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3Rva2VuLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtTkVSJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ015JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwTG9uZG9uJyklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBlbnRpdHklM0ElMjAnQi1QRVInJTJDJTIwc2NvcmUlM0ElMjAwLjk5ODAyMDI5MTMyODQzMDIlMkMlMjBpbmRleCUzQSUyMDQlMkMlMjB3b3JkJTNBJTIwJ1NhcmFoJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdCLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk5NDQ3NDA1MzM4Mjg3NCUyQyUyMGluZGV4JTNBJTIwOSUyQyUyMHdvcmQlM0ElMjAnTG9uZG9uJyUyMCU3RCUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;token-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-NER&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;My name is Sarah and I live in London&#x27;</span>);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { entity: &#x27;B-PER&#x27;, score: 0.9980202913284302, index: 4, word: &#x27;Sarah&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;B-LOC&#x27;, score: 0.9994474053382874, index: 9, word: &#x27;London&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),re=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3Rva2VuLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtTkVSJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ1NhcmFoJTIwbGl2ZXMlMjBpbiUyMHRoZSUyMFVuaXRlZCUyMFN0YXRlcyUyMG9mJTIwQW1lcmljYSclMkMlMjAlN0IlMjBpZ25vcmVfbGFiZWxzJTNBJTIwJTVCJTVEJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdCLVBFUiclMkMlMjBzY29yZSUzQSUyMDAuOTk2NjU4NzQyNDI3ODI1OSUyQyUyMGluZGV4JTNBJTIwMSUyQyUyMHdvcmQlM0ElMjAnU2FyYWgnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwZW50aXR5JTNBJTIwJ08nJTJDJTIwc2NvcmUlM0ElMjAwLjk5ODczODU4NjkwMjYxODQlMkMlMjBpbmRleCUzQSUyMDIlMkMlMjB3b3JkJTNBJTIwJ2xpdmVzJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdPJyUyQyUyMHNjb3JlJTNBJTIwMC45OTkwMDcyODQ2NDEyNjU5JTJDJTIwaW5kZXglM0ElMjAzJTJDJTIwd29yZCUzQSUyMCdpbiclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBlbnRpdHklM0ElMjAnTyclMkMlMjBzY29yZSUzQSUyMDAuOTk4ODI5ODQxNjEzNzY5NSUyQyUyMGluZGV4JTNBJTIwNCUyQyUyMHdvcmQlM0ElMjAndGhlJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdCLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk5NTUxMDU3ODE1NTUxOCUyQyUyMGluZGV4JTNBJTIwNSUyQyUyMHdvcmQlM0ElMjAnVW5pdGVkJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdJLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk5MDM5NTMwNzU0MDg5NCUyQyUyMGluZGV4JTNBJTIwNiUyQyUyMHdvcmQlM0ElMjAnU3RhdGVzJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdJLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk4NjcyNDg1MzUxNTYyNSUyQyUyMGluZGV4JTNBJTIwNyUyQyUyMHdvcmQlM0ElMjAnb2YnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwZW50aXR5JTNBJTIwJ0ktTE9DJyUyQyUyMHNjb3JlJTNBJTIwMC45OTc1Mjk0NDcwNzg3MDQ4JTJDJTIwaW5kZXglM0ElMjA4JTJDJTIwd29yZCUzQSUyMCdBbWVyaWNhJyUyMCU3RCUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;token-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-NER&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;Sarah lives in the United States of America&#x27;</span>, { <span class="hljs-attr">ignore_labels</span>: [] });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { entity: &#x27;B-PER&#x27;, score: 0.9966587424278259, index: 1, word: &#x27;Sarah&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9987385869026184, index: 2, word: &#x27;lives&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9990072846412659, index: 3, word: &#x27;in&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9988298416137695, index: 4, word: &#x27;the&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;B-LOC&#x27;, score: 0.9995510578155518, index: 5, word: &#x27;United&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9990395307540894, index: 6, word: &#x27;States&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9986724853515625, index: 7, word: &#x27;of&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9975294470787048, index: 8, word: &#x27;America&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Te=new J({props:{title:"tokenClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"tokenclassificationpipelinecalltexts-options--code-promise--array--object--object--code",headingTag:"h3"}}),we=new J({props:{title:"pipelines.QuestionAnsweringPipeline",local:"pipelinesquestionansweringpipeline",headingTag:"h2"}}),fe=new h({props:{code:"bGV0JTIwcXVlc3Rpb24lMjAlM0QlMjAnV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJyUzQiUwQWxldCUyMGNvbnRleHQlMjAlM0QlMjAnSmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQuJyUzQiUwQSUwQWxldCUyMGFuc3dlcmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgncXVlc3Rpb24tYW5zd2VyaW5nJyUyQyUyMCdYZW5vdmElMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1kaXN0aWxsZWQtc3F1YWQnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwYW5zd2VyZXIocXVlc3Rpb24lMkMlMjBjb250ZXh0KSUzQiUwQSUyRiUyRiUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMCUyMmFuc3dlciUyMiUzQSUyMCUyMmElMjBuaWNlJTIwcHVwcGV0JTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIyc2NvcmUlMjIlM0ElMjAwLjU3Njg5MTE1MDI1MjY3NDElMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> question = <span class="hljs-string">&#x27;Who was Jim Henson?&#x27;</span>;
<span class="hljs-keyword">let</span> context = <span class="hljs-string">&#x27;Jim Henson was a nice puppet.&#x27;</span>;

<span class="hljs-keyword">let</span> answerer = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;question-answering&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-distilled-squad&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">answerer</span>(question, context);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;answer&quot;: &quot;a nice puppet&quot;,</span>
<span class="hljs-comment">//   &quot;score&quot;: 0.5768911502526741</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Ce=new J({props:{title:"questionAnsweringPipeline._call(question, context, options) ⇒ <code> QuestionAnsweringReturnType </code>",local:"questionansweringpipelinecallquestion-context-options--code-questionansweringreturntype-code",headingTag:"h3"}}),Ze=new J({props:{title:"pipelines.FillMaskPipeline",local:"pipelinesfillmaskpipeline",headingTag:"h2"}}),ve=new h({props:{code:"bGV0JTIwdW5tYXNrZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdmaWxsLW1hc2snJTJDJTIwJ1hlbm92YSUyRmJlcnQtYmFzZS1jYXNlZCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB1bm1hc2tlcignVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwJTVCTUFTSyU1RC4nKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHRva2VuX3N0ciUzQSUyMCdzdXJ2aXZhbCclMkMlMjBzY29yZSUzQSUyMDAuMDYxMzc0MTk0OTIwMDYzMDIlMkMlMjB0b2tlbiUzQSUyMDgxMTUlMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBzdXJ2aXZhbC4nJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwdG9rZW5fc3RyJTNBJTIwJ2xvdmUnJTJDJTIwc2NvcmUlM0ElMjAwLjAzOTAyNDUwMjAzODk1NTY5JTJDJTIwdG9rZW4lM0ElMjAxNTY3JTJDJTIwc2VxdWVuY2UlM0ElMjAnVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwbG92ZS4nJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwdG9rZW5fc3RyJTNBJTIwJ2hhcHBpbmVzcyclMkMlMjBzY29yZSUzQSUyMDAuMDMyNTMxODM1MTM4Nzk3NzYlMkMlMjB0b2tlbiUzQSUyMDkyNjYlMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBoYXBwaW5lc3MuJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHRva2VuX3N0ciUzQSUyMCdmcmVlZG9tJyUyQyUyMHNjb3JlJTNBJTIwMC4wMTg3MzYzMDY1Nzc5MjA5MTQlMkMlMjB0b2tlbiUzQSUyMDQ0MzglMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBmcmVlZG9tLiclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjB0b2tlbl9zdHIlM0ElMjAnbGlmZSclMkMlMjBzY29yZSUzQSUyMDAuMDE4NTk3OTQ3NDMzNTkwODklMkMlMjB0b2tlbiUzQSUyMDEyOTclMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBsaWZlLiclMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> unmasker = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;fill-mask&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-cased&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">unmasker</span>(<span class="hljs-string">&#x27;The goal of life is [MASK].&#x27;</span>);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { token_str: &#x27;survival&#x27;, score: 0.06137419492006302, token: 8115, sequence: &#x27;The goal of life is survival.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;love&#x27;, score: 0.03902450203895569, token: 1567, sequence: &#x27;The goal of life is love.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;happiness&#x27;, score: 0.03253183513879776, token: 9266, sequence: &#x27;The goal of life is happiness.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;freedom&#x27;, score: 0.018736306577920914, token: 4438, sequence: &#x27;The goal of life is freedom.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;life&#x27;, score: 0.01859794743359089, token: 1297, sequence: &#x27;The goal of life is life.&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Ae=new h({props:{code:"bGV0JTIwdW5tYXNrZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdmaWxsLW1hc2snJTJDJTIwJ1hlbm92YSUyRmJlcnQtYmFzZS1jYXNlZCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB1bm1hc2tlcignVGhlJTIwTWlsa3klMjBXYXklMjBpcyUyMGElMjAlNUJNQVNLJTVEJTIwZ2FsYXh5LiclMkMlMjAlN0IlMjB0b3BrJTNBJTIwMSUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjB0b2tlbl9zdHIlM0ElMjAnc3BpcmFsJyUyQyUyMHNjb3JlJTNBJTIwMC42Mjk5OTg3NDM1MzQwODgxJTJDJTIwdG9rZW4lM0ElMjAxNDA2MSUyQyUyMHNlcXVlbmNlJTNBJTIwJ1RoZSUyME1pbGt5JTIwV2F5JTIwaXMlMjBhJTIwc3BpcmFsJTIwZ2FsYXh5LiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> unmasker = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;fill-mask&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-cased&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">unmasker</span>(<span class="hljs-string">&#x27;The Milky Way is a [MASK] galaxy.&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-number">1</span> });
<span class="hljs-comment">// [{ token_str: &#x27;spiral&#x27;, score: 0.6299987435340881, token: 14061, sequence: &#x27;The Milky Way is a spiral galaxy.&#x27; }]</span>`,wrap:!1}}),Re=new J({props:{title:"fillMaskPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"fillmaskpipelinecalltexts-options--code-promise--array--object--object--code",headingTag:"h3"}}),Ee=new J({props:{title:"pipelines.Text2TextGenerationPipeline",local:"pipelinestext2textgenerationpipeline",headingTag:"h2"}}),ze=new h({props:{code:"bGV0JTIwZ2VuZXJhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dDJ0ZXh0LWdlbmVyYXRpb24nJTJDJTIwJ1hlbm92YSUyRkxhTWluaS1GbGFuLVQ1LTc4M00nKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwZ2VuZXJhdG9yKCdob3clMjBjYW4lMjBJJTIwYmVjb21lJTIwbW9yZSUyMGhlYWx0aHklM0YnJTJDJTIwJTdCJTBBJTIwJTIwbWF4X25ld190b2tlbnMlM0ElMjAxMDAlMkMlMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAlMjJUbyUyMGJlY29tZSUyMG1vcmUlMjBoZWFsdGh5JTJDJTIweW91JTIwY2FuJTNBJTIwMS4lMjBFYXQlMjBhJTIwYmFsYW5jZWQlMjBkaWV0JTIwd2l0aCUyMHBsZW50eSUyMG9mJTIwZnJ1aXRzJTJDJTIwdmVnZXRhYmxlcyUyQyUyMHdob2xlJTIwZ3JhaW5zJTJDJTIwbGVhbiUyMHByb3RlaW5zJTJDJTIwYW5kJTIwaGVhbHRoeSUyMGZhdHMuJTIwMi4lMjBTdGF5JTIwaHlkcmF0ZWQlMjBieSUyMGRyaW5raW5nJTIwcGxlbnR5JTIwb2YlMjB3YXRlci4lMjAzLiUyMEdldCUyMGVub3VnaCUyMHNsZWVwJTIwYW5kJTIwbWFuYWdlJTIwc3RyZXNzJTIwbGV2ZWxzLiUyMDQuJTIwQXZvaWQlMjBzbW9raW5nJTIwYW5kJTIwZXhjZXNzaXZlJTIwYWxjb2hvbCUyMGNvbnN1bXB0aW9uLiUyMDUuJTIwUmVndWxhcmx5JTIwZXhlcmNpc2UlMjBhbmQlMjBtYWludGFpbiUyMGElMjBoZWFsdGh5JTIwd2VpZ2h0LiUyMDYuJTIwUHJhY3RpY2UlMjBnb29kJTIwaHlnaWVuZSUyMGFuZCUyMHNhbml0YXRpb24uJTIwNy4lMjBTZWVrJTIwbWVkaWNhbCUyMGF0dGVudGlvbiUyMGlmJTIweW91JTIwZXhwZXJpZW5jZSUyMGFueSUyMGhlYWx0aCUyMGlzc3Vlcy4lMjIlMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text2text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/LaMini-Flan-T5-783M&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(<span class="hljs-string">&#x27;how can I become more healthy?&#x27;</span>, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">100</span>,
});
<span class="hljs-comment">// [{ generated_text: &quot;To become more healthy, you can: 1. Eat a balanced diet with plenty of fruits, vegetables, whole grains, lean proteins, and healthy fats. 2. Stay hydrated by drinking plenty of water. 3. Get enough sleep and manage stress levels. 4. Avoid smoking and excessive alcohol consumption. 5. Regularly exercise and maintain a healthy weight. 6. Practice good hygiene and sanitation. 7. Seek medical attention if you experience any health issues.&quot; }]</span>`,wrap:!1}}),Fe=new J({props:{title:"text2TextGenerationPipeline._call(texts, [options]) ⇒ <code> Promise. < any > </code>",local:"text2textgenerationpipelinecalltexts-options--code-promise--any--code",headingTag:"h3"}}),tt=new J({props:{title:"pipelines.SummarizationPipeline",local:"pipelinessummarizationpipeline",headingTag:"h2"}}),it=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;The tower is 324 metres (1,063 ft) tall, about the same height as an 81-storey building, &#x27;</span> +
  <span class="hljs-string">&#x27;and the tallest structure in Paris. Its base is square, measuring 125 metres (410 ft) on each side. &#x27;</span> +
  <span class="hljs-string">&#x27;During its construction, the Eiffel Tower surpassed the Washington Monument to become the tallest &#x27;</span> +
  <span class="hljs-string">&#x27;man-made structure in the world, a title it held for 41 years until the Chrysler Building in New &#x27;</span> +
  <span class="hljs-string">&#x27;York City was finished in 1930. It was the first structure to reach a height of 300 metres. Due to &#x27;</span> +
  <span class="hljs-string">&#x27;the addition of a broadcasting aerial at the top of the tower in 1957, it is now taller than the &#x27;</span> +
  <span class="hljs-string">&#x27;Chrysler Building by 5.2 metres (17 ft). Excluding transmitters, the Eiffel Tower is the second &#x27;</span> +
  <span class="hljs-string">&#x27;tallest free-standing structure in France after the Millau Viaduct.&#x27;</span>;

<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;summarization&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbart-cnn-6-6&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">100</span>,
});
<span class="hljs-comment">// [{ summary_text: &#x27; The Eiffel Tower is about the same height as an 81-storey building and the tallest structure in Paris. It is the second tallest free-standing structure in France after the Millau Viaduct.&#x27; }]</span>`,wrap:!1}}),pt=new J({props:{title:"pipelines.TranslationPipeline",local:"pipelinestranslationpipeline",headingTag:"h2"}}),rt=new h({props:{code:"bGV0JTIwdHJhbnNsYXRvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RyYW5zbGF0aW9uJyUyQyUyMCdYZW5vdmElMkZubGxiLTIwMC1kaXN0aWxsZWQtNjAwTScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdG9yKCclRTAlQTQlOUMlRTAlQTUlODAlRTAlQTQlQjUlRTAlQTQlQTglMjAlRTAlQTQlOEYlRTAlQTQlOTUlMjAlRTAlQTQlOUElRTAlQTUlODklRTAlQTQlOTUlRTAlQTQlQjIlRTAlQTUlODclRTAlQTQlOUYlMjAlRTAlQTQlQUMlRTAlQTUlODklRTAlQTQlOTUlRTAlQTUlOEQlRTAlQTQlQjglMjAlRTAlQTQlOTUlRTAlQTUlODAlMjAlRTAlQTQlQTQlRTAlQTQlQjAlRTAlQTQlQjklMjAlRTAlQTQlQjklRTAlQTUlODglRTAlQTUlQTQnJTJDJTIwJTdCJTBBJTIwJTIwc3JjX2xhbmclM0ElMjAnaGluX0RldmEnJTJDJTIwJTJGJTJGJTIwSGluZGklMEElMjAlMjB0Z3RfbGFuZyUzQSUyMCdmcmFfTGF0biclMkMlMjAlMkYlMkYlMjBGcmVuY2glMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwdHJhbnNsYXRpb25fdGV4dCUzQSUyMCdMYSUyMHZpZSUyMGVzdCUyMGNvbW1lJTIwdW5lJTIwYm8lQzMlQUV0ZSUyMCVDMyVBMCUyMGNob2NvbGF0LiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/nllb-200-distilled-600M&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;जीवन एक चॉकलेट बॉक्स की तरह है।&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;hin_Deva&#x27;</span>, <span class="hljs-comment">// Hindi</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;fra_Latn&#x27;</span>, <span class="hljs-comment">// French</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;La vie est comme une boîte à chocolat.&#x27; }]</span>`,wrap:!1}}),Tt=new h({props:{code:"bGV0JTIwdHJhbnNsYXRvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RyYW5zbGF0aW9uJyUyQyUyMCdYZW5vdmElMkZtMm0xMDBfNDE4TScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdG9yKCclRTclOTQlOUYlRTYlQjQlQkIlRTUlQjAlQjElRTUlODMlOEYlRTQlQjglODAlRTclOUIlOTIlRTUlQjclQTclRTUlODUlOEIlRTUlOEElOUIlRTMlODAlODInJTJDJTIwJTdCJTBBJTIwJTIwc3JjX2xhbmclM0ElMjAnemgnJTJDJTIwJTJGJTJGJTIwQ2hpbmVzZSUwQSUyMCUyMHRndF9sYW5nJTNBJTIwJ2VuJyUyQyUyMCUyRiUyRiUyMEVuZ2xpc2glMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwdHJhbnNsYXRpb25fdGV4dCUzQSUyMCdMaWZlJTIwaXMlMjBsaWtlJTIwYSUyMGJveCUyMG9mJTIwY2hvY29sYXRlLiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/m2m100_418M&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;生活就像一盒巧克力。&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;zh&#x27;</span>, <span class="hljs-comment">// Chinese</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-comment">// English</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;Life is like a box of chocolate.&#x27; }]</span>`,wrap:!1}}),Jt=new h({props:{code:"bGV0JTIwdHJhbnNsYXRvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RyYW5zbGF0aW9uJyUyQyUyMCdYZW5vdmElMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zbGF0b3IoJyVFMCVBNCVCOCVFMCVBNCU4MiVFMCVBNCVBRiVFMCVBNSU4MSVFMCVBNCU5NSVFMCVBNSU4RCVFMCVBNCVBNCUyMCVFMCVBNCVCMCVFMCVBNCVCRSVFMCVBNCVCNyVFMCVBNSU4RCVFMCVBNCU5RiVFMCVBNSU4RCVFMCVBNCVCMCUyMCVFMCVBNCU5NSVFMCVBNSU4NyUyMCVFMCVBNCVBQSVFMCVBNSU4RCVFMCVBNCVCMCVFMCVBNCVBRSVFMCVBNSU4MSVFMCVBNCU5NiUyMCVFMCVBNCU5NSVFMCVBNCVCRSUyMCVFMCVBNCU5NSVFMCVBNCVCOSVFMCVBNCVBOCVFMCVBNCVCRSUyMCVFMCVBNCVCOSVFMCVBNSU4OCUyMCVFMCVBNCU5NSVFMCVBNCVCRiUyMCVFMCVBNCVCOCVFMCVBNSU4MCVFMCVBNCVCMCVFMCVBNCVCRiVFMCVBNCVBRiVFMCVBNCVCRSUyMCVFMCVBNCVBRSVFMCVBNSU4NyVFMCVBNCU4MiUyMCVFMCVBNCU5NSVFMCVBNSU4QiVFMCVBNCU4OCUyMCVFMCVBNCVCOCVFMCVBNSU4OCVFMCVBNCVBOCVFMCVBNSU4RCVFMCVBNCVBRiUyMCVFMCVBNCVCOCVFMCVBNCVBRSVFMCVBNCVCRSVFMCVBNCVBNyVFMCVBNCVCRSVFMCVBNCVBOCUyMCVFMCVBNCVBOCVFMCVBNCVCOSVFMCVBNSU4MCVFMCVBNCU4MiUyMCVFMCVBNCVCOSVFMCVBNSU4OCclMkMlMjAlN0IlMEElMjAlMjBzcmNfbGFuZyUzQSUyMCdoaV9JTiclMkMlMjAlMkYlMkYlMjBIaW5kaSUwQSUyMCUyMHRndF9sYW5nJTNBJTIwJ2ZyX1hYJyUyQyUyMCUyRiUyRiUyMEZyZW5jaCUwQSU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjB0cmFuc2xhdGlvbl90ZXh0JTNBJTIwJ0xlJTIwY2hlZiUyMGRlcyUyME5hdGlvbnMlMjBhZmZpcm1lJTIwcXUlMjAnaWwlMjBuJTIwJ3klMjBhJTIwbWlsaXRhcnklMjBzb2x1dGlvbiUyMGluJTIwU3lyaWEuJyUyMCU3RCU1RA==",highlighted:`<span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/mbart-large-50-many-to-many-mmt&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;संयुक्त राष्ट्र के प्रमुख का कहना है कि सीरिया में कोई सैन्य समाधान नहीं है&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;hi_IN&#x27;</span>, <span class="hljs-comment">// Hindi</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;fr_XX&#x27;</span>, <span class="hljs-comment">// French</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;Le chef des Nations affirme qu &#x27;il n &#x27;y a military solution in Syria.&#x27; }]</span>`,wrap:!1}}),jt=new J({props:{title:"pipelines.TextGenerationPipeline",local:"pipelinestextgenerationpipeline",headingTag:"h2"}}),bt=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdJJTIwZW5qb3klMjB3YWxraW5nJTIwd2l0aCUyMG15JTIwY3V0ZSUyMGRvZyUyQyclM0IlMEFsZXQlMjBnZW5lcmF0b3IlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCd0ZXh0LWdlbmVyYXRpb24nJTJDJTIwJ1hlbm92YSUyRmRpc3RpbGdwdDInKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwZ2VuZXJhdG9yKHRleHQpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAlMjJJJTIwZW5qb3klMjB3YWxraW5nJTIwd2l0aCUyMG15JTIwY3V0ZSUyMGRvZyUyQyUyMGFuZCUyMEklMjBsb3ZlJTIwdG8lMjBwbGF5JTIwd2l0aCUyMHRoZSUyMG90aGVyJTIwZG9ncy4lMjIlMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;I enjoy walking with my cute dog,&#x27;</span>;
<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilgpt2&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text);
<span class="hljs-comment">// [{ generated_text: &quot;I enjoy walking with my cute dog, and I love to play with the other dogs.&quot; }]</span>`,wrap:!1}}),Ct=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwdGhlcmUlMjB3YXMnJTNCJTBBbGV0JTIwZ2VuZXJhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dC1nZW5lcmF0aW9uJyUyQyUyMCdYZW5vdmElMkZkaXN0aWxncHQyJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGdlbmVyYXRvcih0ZXh0JTJDJTIwJTdCJTBBJTIwJTIwdGVtcGVyYXR1cmUlM0ElMjAyJTJDJTBBJTIwJTIwbWF4X25ld190b2tlbnMlM0ElMjAxMCUyQyUwQSUyMCUyMHJlcGV0aXRpb25fcGVuYWx0eSUzQSUyMDEuNSUyQyUwQSUyMCUyMG5vX3JlcGVhdF9uZ3JhbV9zaXplJTNBJTIwMiUyQyUwQSUyMCUyMG51bV9iZWFtcyUzQSUyMDIlMkMlMEElMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzQSUyMDIlMkMlMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIyZ2VuZXJhdGVkX3RleHQlMjIlM0ElMjAlMjJPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwdGhlcmUlMjB3YXMlMjBhbiUyMGFidW5kYW5jZSUyMG9mJTIwaW5mb3JtYXRpb24lMjBhYm91dCUyMHRoZSUyMGhpc3RvcnklMjBhbmQlMjBhY3Rpdml0aWVzJTIwdGhhdCUyMiUwQSUyRiUyRiUyMCU3RCUyQyUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMCUyMmdlbmVyYXRlZF90ZXh0JTIyJTNBJTIwJTIyT25jZSUyMHVwb24lMjBhJTIwdGltZSUyQyUyMHRoZXJlJTIwd2FzJTIwYW4lMjBhYnVuZGFuY2UlMjBvZiUyMGluZm9ybWF0aW9uJTIwYWJvdXQlMjB0aGUlMjBtb3N0JTIwaW1wb3J0YW50JTIwYW5kJTIwaW5mbHVlbnRpYWwlMjIlMEElMkYlMkYlMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;Once upon a time, there was&#x27;</span>;
<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilgpt2&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text, {
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">10</span>,
  <span class="hljs-attr">repetition_penalty</span>: <span class="hljs-number">1.5</span>,
  <span class="hljs-attr">no_repeat_ngram_size</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">num_beams</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">num_return_sequences</span>: <span class="hljs-number">2</span>,
});
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   &quot;generated_text&quot;: &quot;Once upon a time, there was an abundance of information about the history and activities that&quot;</span>
<span class="hljs-comment">// }, {</span>
<span class="hljs-comment">//   &quot;generated_text&quot;: &quot;Once upon a time, there was an abundance of information about the most important and influential&quot;</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),It=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdkZWYlMjBmaWIobiklM0EnJTNCJTBBbGV0JTIwZ2VuZXJhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dC1nZW5lcmF0aW9uJyUyQyUyMCdYZW5vdmElMkZjb2RlZ2VuLTM1ME0tbW9ubycpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBnZW5lcmF0b3IodGV4dCUyQyUyMCU3QiUwQSUyMCUyMG1heF9uZXdfdG9rZW5zJTNBJTIwNDQlMkMlMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTBBJTJGJTJGJTIwJTIwJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAnZGVmJTIwZmliKG4pJTNBJTVDbiclMjAlMkIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAnJTIwJTIwJTIwJTIwaWYlMjBuJTIwJTNEJTNEJTIwMCUzQSU1Q24nJTIwJTJCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMDAlNUNuJyUyMCUyQiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCclMjAlMjAlMjAlMjBlbGlmJTIwbiUyMCUzRCUzRCUyMDElM0ElNUNuJyUyMCUyQiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCclMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAxJTVDbiclMjAlMkIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAnJTIwJTIwJTIwJTIwZWxzZSUzQSU1Q24nJTIwJTJCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGZpYihuLTEpJTIwJTJCJTIwZmliKG4tMiklNUNuJyUwQSUyRiUyRiUyMCU3RCU1RA==",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;def fib(n):&#x27;</span>;
<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/codegen-350M-mono&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">44</span>,
});
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   generated_text: &#x27;def fib(n):\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    if n == 0:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return 0\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    elif n == 1:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return 1\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    else:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return fib(n-1) + fib(n-2)\\n&#x27;</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),Zt=new J({props:{title:"textGenerationPipeline._call(texts, [generate_kwargs]) ⇒ <code> Promise. < any > </code>",local:"textgenerationpipelinecalltexts-generatekwargs--code-promise--any--code",headingTag:"h3"}}),At=new J({props:{title:"pipelines.ZeroShotClassificationPipeline",local:"pipelineszeroshotclassificationpipeline",headingTag:"h2"}}),Rt=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdMYXN0JTIwd2VlayUyMEklMjB1cGdyYWRlZCUyMG15JTIwaU9TJTIwdmVyc2lvbiUyMGFuZCUyMGV2ZXIlMjBzaW5jZSUyMHRoZW4lMjBteSUyMHBob25lJTIwaGFzJTIwYmVlbiUyMG92ZXJoZWF0aW5nJTIwd2hlbmV2ZXIlMjBJJTIwdXNlJTIweW91ciUyMGFwcC4nJTNCJTBBbGV0JTIwbGFiZWxzJTIwJTNEJTIwJTVCJTIwJ21vYmlsZSclMkMlMjAnYmlsbGluZyclMkMlMjAnd2Vic2l0ZSclMkMlMjAnYWNjb3VudCUyMGFjY2VzcyclMjAlNUQlM0IlMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZtb2JpbGViZXJ0LXVuY2FzZWQtbW5saScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHRleHQlMkMlMjBsYWJlbHMpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwc2VxdWVuY2UlM0ElMjAnTGFzdCUyMHdlZWslMjBJJTIwdXBncmFkZWQlMjBteSUyMGlPUyUyMHZlcnNpb24lMjBhbmQlMjBldmVyJTIwc2luY2UlMjB0aGVuJTIwbXklMjBwaG9uZSUyMGhhcyUyMGJlZW4lMjBvdmVyaGVhdGluZyUyMHdoZW5ldmVyJTIwSSUyMHVzZSUyMHlvdXIlMjBhcHAuJyUyQyUwQSUyRiUyRiUyMCUyMCUyMGxhYmVscyUzQSUyMCU1QiUyMCdtb2JpbGUnJTJDJTIwJ3dlYnNpdGUnJTJDJTIwJ2JpbGxpbmcnJTJDJTIwJ2FjY291bnQlMjBhY2Nlc3MnJTIwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwc2NvcmVzJTNBJTIwJTVCJTIwMC41NTYyMDkxMDQwNDgyMDE4JTJDJTIwMC4xODQzNjIxMzA3ODYwODUzJTJDJTIwMC4xMzk0MjY0NjYzOTMzNjM3NiUyQyUyMDAuMTIwMDAyMjk4NzcyMzQ5MjMlMjAlNUQlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;Last week I upgraded my iOS version and ever since then my phone has been overheating whenever I use your app.&#x27;</span>;
<span class="hljs-keyword">let</span> labels = [ <span class="hljs-string">&#x27;mobile&#x27;</span>, <span class="hljs-string">&#x27;billing&#x27;</span>, <span class="hljs-string">&#x27;website&#x27;</span>, <span class="hljs-string">&#x27;account access&#x27;</span> ];
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/mobilebert-uncased-mnli&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text, labels);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   sequence: &#x27;Last week I upgraded my iOS version and ever since then my phone has been overheating whenever I use your app.&#x27;,</span>
<span class="hljs-comment">//   labels: [ &#x27;mobile&#x27;, &#x27;website&#x27;, &#x27;billing&#x27;, &#x27;account access&#x27; ],</span>
<span class="hljs-comment">//   scores: [ 0.5562091040482018, 0.1843621307860853, 0.13942646639336376, 0.12000229877234923 ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Yt=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdJJTIwaGF2ZSUyMGElMjBwcm9ibGVtJTIwd2l0aCUyMG15JTIwaXBob25lJTIwdGhhdCUyMG5lZWRzJTIwdG8lMjBiZSUyMHJlc29sdmVkJTIwYXNhcCEnJTNCJTBBbGV0JTIwbGFiZWxzJTIwJTNEJTIwJTVCJTIwJ3VyZ2VudCclMkMlMjAnbm90JTIwdXJnZW50JyUyQyUyMCdwaG9uZSclMkMlMjAndGFibGV0JyUyQyUyMCdjb21wdXRlciclMjAlNUQlM0IlMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZubGktZGViZXJ0YS12My14c21hbGwnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcih0ZXh0JTJDJTIwbGFiZWxzJTJDJTIwJTdCJTIwbXVsdGlfbGFiZWwlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMHNlcXVlbmNlJTNBJTIwJ0klMjBoYXZlJTIwYSUyMHByb2JsZW0lMjB3aXRoJTIwbXklMjBpcGhvbmUlMjB0aGF0JTIwbmVlZHMlMjB0byUyMGJlJTIwcmVzb2x2ZWQlMjBhc2FwISclMkMlMEElMkYlMkYlMjAlMjAlMjBsYWJlbHMlM0ElMjAlNUIlMjAndXJnZW50JyUyQyUyMCdwaG9uZSclMkMlMjAnY29tcHV0ZXInJTJDJTIwJ3RhYmxldCclMkMlMjAnbm90JTIwdXJnZW50JyUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMHNjb3JlcyUzQSUyMCU1QiUyMDAuOTk1ODg3MDk1NjM2MDI3NSUyQyUyMDAuOTkyMzk2MzQwMDY5NzAzNSUyQyUyMDAuMDAyMzMzNTM3OTQ2MTYwMjM1JTJDJTIwMC4wMDE1MTM0MTM4NTY3NTk4NzY1JTJDJTIwMC4wMDEwNjk5Mzg0MjA4Mzc3MTYzJTIwJTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;I have a problem with my iphone that needs to be resolved asap!&#x27;</span>;
<span class="hljs-keyword">let</span> labels = [ <span class="hljs-string">&#x27;urgent&#x27;</span>, <span class="hljs-string">&#x27;not urgent&#x27;</span>, <span class="hljs-string">&#x27;phone&#x27;</span>, <span class="hljs-string">&#x27;tablet&#x27;</span>, <span class="hljs-string">&#x27;computer&#x27;</span> ];
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/nli-deberta-v3-xsmall&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text, labels, { <span class="hljs-attr">multi_label</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   sequence: &#x27;I have a problem with my iphone that needs to be resolved asap!&#x27;,</span>
<span class="hljs-comment">//   labels: [ &#x27;urgent&#x27;, &#x27;phone&#x27;, &#x27;computer&#x27;, &#x27;tablet&#x27;, &#x27;not urgent&#x27; ],</span>
<span class="hljs-comment">//   scores: [ 0.9958870956360275, 0.9923963400697035, 0.002333537946160235, 0.0015134138567598765, 0.0010699384208377163 ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Wt=new J({props:{title:"new ZeroShotClassificationPipeline(options)",local:"new-zeroshotclassificationpipelineoptions",headingTag:"h3"}}),Lt=new J({props:{title:"zeroShotClassificationPipeline._call(texts, candidate_labels, options) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>",local:"zeroshotclassificationpipelinecalltexts-candidatelabels-options--code-promise--objectarray--object----code",headingTag:"h3"}}),Ot=new J({props:{title:"pipelines.FeatureExtractionPipeline",local:"pipelinesfeatureextractionpipeline",headingTag:"h2"}}),tl=new h({props:{code:"bGV0JTIwZXh0cmFjdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMjAlN0IlMjByZXZpc2lvbiUzQSUyMCdkZWZhdWx0JyUyMCU3RCklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGV4dHJhY3RvcignVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMHRlc3QuJyklM0IlMEElMkYlMkYlMjBUZW5zb3IlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjB0eXBlJTNBJTIwJ2Zsb2F0MzInJTJDJTBBJTJGJTJGJTIwJTIwJTIwZGF0YSUzQSUyMEZsb2F0MzJBcnJheSUyMCU1QjAuMDU5Mzk5MjQ3MTY5NDk0NjMlMkMlMjAwLjAyMTY1NTkzNTc5NDExNTA2NyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwOCUyQyUyMDc2OCU1RCUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">let</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-uncased&#x27;</span>, { <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;default&#x27;</span> });
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.05939924716949463, 0.021655935794115067, ...],</span>
<span class="hljs-comment">//   dims: [1, 8, 768]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),sl=new h({props:{code:"bGV0JTIwZXh0cmFjdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMjAlN0IlMjByZXZpc2lvbiUzQSUyMCdkZWZhdWx0JyUyMCU3RCklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGV4dHJhY3RvcignVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMHRlc3QuJyUyQyUyMCU3QiUyMHBvb2xpbmclM0ElMjAnbWVhbiclMkMlMjBub3JtYWxpemUlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQSUyRiUyRiUyMFRlbnNvciUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMHR5cGUlM0ElMjAnZmxvYXQzMiclMkMlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCMC4wMzM3Mzc3ODk4Mzk1MDYxNSUyQyUyMC0wLjAxMDEwNjA3NzQxNzczMTI4NSUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwNzY4JTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-uncased&#x27;</span>, { <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;default&#x27;</span> });
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>, { <span class="hljs-attr">pooling</span>: <span class="hljs-string">&#x27;mean&#x27;</span>, <span class="hljs-attr">normalize</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.03373778983950615, -0.010106077417731285, ...],</span>
<span class="hljs-comment">//   dims: [1, 768]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),nl=new h({props:{code:"bGV0JTIwZXh0cmFjdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZhbGwtTWluaUxNLUw2LXYyJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGV4dHJhY3RvcignVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMHRlc3QuJyUyQyUyMCU3QiUyMHBvb2xpbmclM0ElMjAnbWVhbiclMkMlMjBub3JtYWxpemUlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQSUyRiUyRiUyMFRlbnNvciUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMHR5cGUlM0ElMjAnZmxvYXQzMiclMkMlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCMC4wOTA5NDk4MjU5NDI1MTYzMyUyQyUyMC0wLjAxNDc3NDI0NjE0MTMxNDUwNyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwMzg0JTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/all-MiniLM-L6-v2&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>, { <span class="hljs-attr">pooling</span>: <span class="hljs-string">&#x27;mean&#x27;</span>, <span class="hljs-attr">normalize</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.09094982594251633, -0.014774246141314507, ...],</span>
<span class="hljs-comment">//   dims: [1, 384]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),ol=new J({props:{title:"featureExtractionPipeline._call(texts, options) ⇒",local:"featureextractionpipelinecalltexts-options-",headingTag:"h3"}}),ml=new J({props:{title:"pipelines.AudioClassificationPipeline",local:"pipelinesaudioclassificationpipeline",headingTag:"h2"}}),ul=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMGNsYXNzaWZpZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdhdWRpby1jbGFzc2lmaWNhdGlvbiclMkMlMjAnWGVub3ZhJTJGd2F2MnZlYzItbGFyZ2UteGxzci01My1nZW5kZXItcmVjb2duaXRpb24tbGlicmlzcGVlY2gnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnbWFsZSclMkMlMjBzY29yZSUzQSUyMDAuOTk4MTU0MjIyOTY1MjQwNSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ2ZlbWFsZSclMkMlMjBzY29yZSUzQSUyMDAuMDAxODQ1NzQ3ODE0NTEzNzQzJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;audio-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/wav2vec2-large-xlsr-53-gender-recognition-librispeech&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;male&#x27;, score: 0.9981542229652405 },</span>
<span class="hljs-comment">//   { label: &#x27;female&#x27;, score: 0.001845747814513743 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),jl=new J({props:{title:"new AudioClassificationPipeline(options)",local:"new-audioclassificationpipelineoptions",headingTag:"h3"}}),xl=new J({props:{title:"audioClassificationPipeline._call(audio, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"audioclassificationpipelinecallaudio-options--code-promise--array--object--object--code",headingTag:"h3"}}),Gl=new J({props:{title:"pipelines.AutomaticSpeechRecognitionPipeline",local:"pipelinesautomaticspeechrecognitionpipeline",headingTag:"h2"}}),Ql=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCklM0IlMEElMkYlMkYlMjAlN0IlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTJDJTIwYXNrJTIwd2hhdCUyMHlvdSUyMGNhbiUyMGRvJTIwZm9yJTIweW91ciUyMGNvdW50cnkuJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url);
<span class="hljs-comment">// { text: &quot; And so my fellow Americans ask not what your country can do for you, ask what you can do for your country.&quot; }</span>`,wrap:!1}}),Nl=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMHJldHVybl90aW1lc3RhbXBzJTNBJTIwdHJ1ZSUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTJDJTIwYXNrJTIwd2hhdCUyMHlvdSUyMGNhbiUyMGRvJTIwZm9yJTIweW91ciUyMGNvdW50cnkuJTIyJTBBJTJGJTJGJTIwJTIwJTIwY2h1bmtzJTNBJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwdGltZXN0YW1wJTNBJTIwJTVCMCUyQyUyMDglNUQlMkMlMjAlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTIyJTIwJTdEJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwdGltZXN0YW1wJTNBJTIwJTVCOCUyQyUyMDExJTVEJTJDJTIwdGV4dCUzQSUyMCUyMiUyMGFzayUyMHdoYXQlMjB5b3UlMjBjYW4lMjBkbyUyMGZvciUyMHlvdXIlMjBjb3VudHJ5LiUyMiUyMCU3RCUwQSUyRiUyRiUyMCUyMCUyMCU1RCUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">return_timestamps</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   text: &quot; And so my fellow Americans ask not what your country can do for you, ask what you can do for your country.&quot;</span>
<span class="hljs-comment">//   chunks: [</span>
<span class="hljs-comment">//     { timestamp: [0, 8],  text: &quot; And so my fellow Americans ask not what your country can do for you&quot; }</span>
<span class="hljs-comment">//     { timestamp: [8, 11], text: &quot; ask what you can do for your country.&quot; }</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),_l=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyUyQyUyMCU3QiUwQSUyMCUyMCUyMCUyMHJldmlzaW9uJTNBJTIwJ291dHB1dF9hdHRlbnRpb25zJyUyQyUwQSU3RCklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMHJldHVybl90aW1lc3RhbXBzJTNBJTIwJ3dvcmQnJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMCUyMnRleHQlMjIlM0ElMjAlMjIlMjBBbmQlMjBzbyUyMG15JTIwZmVsbG93JTIwQW1lcmljYW5zJTIwYXNrJTIwbm90JTIwd2hhdCUyMHlvdXIlMjBjb3VudHJ5JTIwY2FuJTIwZG8lMjBmb3IlMjB5b3UlMjBhc2slMjB3aGF0JTIweW91JTIwY2FuJTIwZG8lMjBmb3IlMjB5b3VyJTIwY291bnRyeS4lMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjJjaHVua3MlMjIlM0ElMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwQW5kJTIyJTJDJTIwJTIydGltZXN0YW1wJTIyJTNBJTIwJTVCMCUyQyUyMDAuNzglNUQlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwc28lMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUIwLjc4JTJDJTIwMS4wNiU1RCUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU3QiUyMCUyMnRleHQlMjIlM0ElMjAlMjIlMjBteSUyMiUyQyUyMCUyMnRpbWVzdGFtcCUyMiUzQSUyMCU1QjEuMDYlMkMlMjAxLjQ2JTVEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIydGV4dCUyMiUzQSUyMCUyMiUyMGZvciUyMiUyQyUyMCUyMnRpbWVzdGFtcCUyMiUzQSUyMCU1QjkuNzIlMkMlMjA5LjkyJTVEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIydGV4dCUyMiUzQSUyMCUyMiUyMHlvdXIlMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUI5LjkyJTJDJTIwMTAuMjIlNUQlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwY291bnRyeS4lMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUIxMC4yMiUyQyUyMDEzLjUlNUQlMjAlN0QlMEElMkYlMkYlMjAlMjAlMjAlNUQlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>, {
    <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;output_attentions&#x27;</span>,
});
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">return_timestamps</span>: <span class="hljs-string">&#x27;word&#x27;</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;text&quot;: &quot; And so my fellow Americans ask not what your country can do for you ask what you can do for your country.&quot;,</span>
<span class="hljs-comment">//   &quot;chunks&quot;: [</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; And&quot;, &quot;timestamp&quot;: [0, 0.78] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; so&quot;, &quot;timestamp&quot;: [0.78, 1.06] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; my&quot;, &quot;timestamp&quot;: [1.06, 1.46] },</span>
<span class="hljs-comment">//     ...</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; for&quot;, &quot;timestamp&quot;: [9.72, 9.92] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; your&quot;, &quot;timestamp&quot;: [9.92, 10.22] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; country.&quot;, &quot;timestamp&quot;: [10.22, 13.5] }</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Rl=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmcmVuY2gtYXVkaW8ubXAzJyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci1zbWFsbCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2NyaWJlcih1cmwlMkMlMjAlN0IlMjBsYW5ndWFnZSUzQSUyMCdmcmVuY2gnJTJDJTIwdGFzayUzQSUyMCd0cmFuc2NyaWJlJyUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMjB0ZXh0JTNBJTIwJTIyJTIwSidhZG9yZSUyQyUyMGonYWltZSUyQyUyMGplJTIwbidhaW1lJTIwcGFzJTJDJTIwamUlMjBkJUMzJUE5dGVzdGUuJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/french-audio.mp3&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-small&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">language</span>: <span class="hljs-string">&#x27;french&#x27;</span>, <span class="hljs-attr">task</span>: <span class="hljs-string">&#x27;transcribe&#x27;</span> });
<span class="hljs-comment">// { text: &quot; J&#x27;adore, j&#x27;aime, je n&#x27;aime pas, je déteste.&quot; }</span>`,wrap:!1}}),Yl=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmcmVuY2gtYXVkaW8ubXAzJyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci1zbWFsbCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2NyaWJlcih1cmwlMkMlMjAlN0IlMjBsYW5ndWFnZSUzQSUyMCdmcmVuY2gnJTJDJTIwdGFzayUzQSUyMCd0cmFuc2xhdGUnJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUyMHRleHQlM0ElMjAlMjIlMjBJJTIwbG92ZSUyQyUyMEklMjBsaWtlJTJDJTIwSSUyMGRvbid0JTIwbGlrZSUyQyUyMEklMjBoYXRlLiUyMiUyMCU3RA==",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/french-audio.mp3&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-small&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">language</span>: <span class="hljs-string">&#x27;french&#x27;</span>, <span class="hljs-attr">task</span>: <span class="hljs-string">&#x27;translate&#x27;</span> });
<span class="hljs-comment">// { text: &quot; I love, I like, I don&#x27;t like, I hate.&quot; }</span>`,wrap:!1}}),Hl=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0ZWRfNjAud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMGNodW5rX2xlbmd0aF9zJTNBJTIwMzAlMkMlMjBzdHJpZGVfbGVuZ3RoX3MlM0ElMjA1JTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUyMHRleHQlM0ElMjAlMjIlMjBTbyUyMGluJTIwY29sbGVnZSUyQyUyMEklMjB3YXMlMjBhJTIwZ292ZXJubWVudCUyMG1ham9yJTJDJTIwd2hpY2glMjBtZWFucyUyMCU1Qi4uLiU1RCUyMFNvJTIwSSdkJTIwc3RhcnQlMjBvZmYlMjBsaWdodCUyMGFuZCUyMEknZCUyMGJ1bXAlMjBpdCUyMHVwJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/ted_60.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">chunk_length_s</span>: <span class="hljs-number">30</span>, <span class="hljs-attr">stride_length_s</span>: <span class="hljs-number">5</span> });
<span class="hljs-comment">// { text: &quot; So in college, I was a government major, which means [...] So I&#x27;d start off light and I&#x27;d bump it up&quot; }</span>`,wrap:!1}}),zl=new J({props:{title:"new AutomaticSpeechRecognitionPipeline(options)",local:"new-automaticspeechrecognitionpipelineoptions",headingTag:"h3"}}),Dl=new J({props:{title:"automaticSpeechRecognitionPipeline._call(audio, [kwargs]) ⇒ <code> Promise. < Object > </code>",local:"automaticspeechrecognitionpipelinecallaudio-kwargs--code-promise--object--code",headingTag:"h3"}}),ts=new J({props:{title:"pipelines.ImageToTextPipeline",local:"pipelinesimagetotextpipeline",headingTag:"h2"}}),is=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEFsZXQlMjBjYXB0aW9uZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdpbWFnZS10by10ZXh0JyUyQyUyMCdYZW5vdmElMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNhcHRpb25lcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAnYSUyMGNhdCUyMGxheWluZyUyMG9uJTIwYSUyMGNvdWNoJTIwd2l0aCUyMGFub3RoZXIlMjBjYXQnJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> captioner = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-to-text&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-gpt2-image-captioning&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">captioner</span>(url);
<span class="hljs-comment">// [{ generated_text: &#x27;a cat laying on a couch with another cat&#x27; }]</span>`,wrap:!1}}),as=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZoYW5kd3JpdGluZy5qcGcnJTNCJTBBbGV0JTIwY2FwdGlvbmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnaW1hZ2UtdG8tdGV4dCclMkMlMjAnWGVub3ZhJTJGdHJvY3Itc21hbGwtaGFuZHdyaXR0ZW4nKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2FwdGlvbmVyKHVybCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjBnZW5lcmF0ZWRfdGV4dCUzQSUyMCdNci4lMjBCcm93biUyMGNvbW1lbnRlZCUyMGljaWx5LiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/handwriting.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> captioner = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-to-text&#x27;</span>, <span class="hljs-string">&#x27;Xenova/trocr-small-handwritten&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">captioner</span>(url);
<span class="hljs-comment">// [{ generated_text: &#x27;Mr. Brown commented icily.&#x27; }]</span>`,wrap:!1}}),cs=new J({props:{title:"new ImageToTextPipeline(options)",local:"new-imagetotextpipelineoptions",headingTag:"h3"}}),Ts=new J({props:{title:"imageToTextPipeline._call(images, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>",local:"imagetotextpipelinecallimages-generatekwargs--code-promise--objectarray--object----code",headingTag:"h3"}}),ws=new J({props:{title:"pipelines.ImageClassificationPipeline",local:"pipelinesimageclassificationpipeline",headingTag:"h2"}}),fs=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCcpJTNCJTBBbGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGcnJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0JsYWJlbCUzQSUyMCd0aWdlciUyQyUyMFBhbnRoZXJhJTIwdGlncmlzJyUyQyUyMHNjb3JlJTNBJTIwMC42MzI2OTU3MzQ1MDA4ODUlN0QlMkMlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   {label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885},</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),xs=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCcpJTNCJTBBbGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGcnJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCUyQyUyMCU3QiUyMHRvcGslM0ElMjAzJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RpZ2VyJTJDJTIwUGFudGhlcmElMjB0aWdyaXMnJTJDJTIwc2NvcmUlM0ElMjAwLjYzMjY5NTczNDUwMDg4NSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RpZ2VyJTIwY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC4zNjM0ODI1NjQ2ODc3Mjg5JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnbGlvbiUyQyUyMGtpbmclMjBvZiUyMGJlYXN0cyUyQyUyMFBhbnRoZXJhJTIwbGVvJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDA0NTA2MDMwODE4NDQ3NDcwNyUyMCU3RCUyQyUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, { <span class="hljs-attr">topk</span>: <span class="hljs-number">3</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885 },</span>
<span class="hljs-comment">//   { label: &#x27;tiger cat&#x27;, score: 0.3634825646877289 },</span>
<span class="hljs-comment">//   { label: &#x27;lion, king of beasts, Panthera leo&#x27;, score: 0.00045060308184474707 },</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),gs=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCcpJTNCJTBBbGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGcnJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCUyQyUyMCU3QiUyMHRvcGslM0ElMjAwJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QmxhYmVsJTNBJTIwJ3RpZ2VyJTJDJTIwUGFudGhlcmElMjB0aWdyaXMnJTJDJTIwc2NvcmUlM0ElMjAwLjYzMjY5NTczNDUwMDg4NSU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QmxhYmVsJTNBJTIwJ3RpZ2VyJTIwY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC4zNjM0ODI1NjQ2ODc3Mjg5JTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCbGFiZWwlM0ElMjAnbGlvbiUyQyUyMGtpbmclMjBvZiUyMGJlYXN0cyUyQyUyMFBhbnRoZXJhJTIwbGVvJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDA0NTA2MDMwODE4NDQ3NDcwNyU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QmxhYmVsJTNBJTIwJ2phZ3VhciUyQyUyMHBhbnRoZXIlMkMlMjBQYW50aGVyYSUyMG9uY2ElMkMlMjBGZWxpcyUyMG9uY2EnJTJDJTIwc2NvcmUlM0ElMjAwLjAwMDM1NDY1NDk5OTY4MjY3OTc3JTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwLi4uJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, { <span class="hljs-attr">topk</span>: <span class="hljs-number">0</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   {label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885},</span>
<span class="hljs-comment">//   {label: &#x27;tiger cat&#x27;, score: 0.3634825646877289},</span>
<span class="hljs-comment">//   {label: &#x27;lion, king of beasts, Panthera leo&#x27;, score: 0.00045060308184474707},</span>
<span class="hljs-comment">//   {label: &#x27;jaguar, panther, Panthera onca, Felis onca&#x27;, score: 0.00035465499968267977},</span>
<span class="hljs-comment">//   ...</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Zs=new J({props:{title:"new ImageClassificationPipeline(options)",local:"new-imageclassificationpipelineoptions",headingTag:"h3"}}),Ns=new J({props:{title:"imageClassificationPipeline._call(images, options) ⇒ <code> Promise. < any > </code>",local:"imageclassificationpipelinecallimages-options--code-promise--any--code",headingTag:"h3"}}),Vs=new J({props:{title:"pipelines.ImageSegmentationPipeline",local:"pipelinesimagesegmentationpipeline",headingTag:"h2"}}),Hs=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEFsZXQlMjBzZWdtZW50ZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdpbWFnZS1zZWdtZW50YXRpb24nJTJDJTIwJ1hlbm92YSUyRmRldHItcmVzbmV0LTUwLXBhbm9wdGljJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHNlZ21lbnRlcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAncmVtb3RlJyUyQyUyMHNjb3JlJTNBJTIwMC45OTg0NjQ5NDE5Nzg0NTQ2JTJDJTIwbWFzayUzQSUyMFJhd0ltYWdlJTIwJTdCJTIwLi4uJTIwJTdEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC45OTk0MzE2MTAxMDc0MjE5JTJDJTIwbWFzayUzQSUyMFJhd0ltYWdlJTIwJTdCJTIwLi4uJTIwJTdEJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> segmenter = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-segmentation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/detr-resnet-50-panoptic&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">segmenter</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;remote&#x27;, score: 0.9984649419784546, mask: RawImage { ... } },</span>
<span class="hljs-comment">//   { label: &#x27;cat&#x27;, score: 0.9994316101074219, mask: RawImage { ... } }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),zs=new J({props:{title:"new ImageSegmentationPipeline(options)",local:"new-imagesegmentationpipelineoptions",headingTag:"h3"}}),Ds=new J({props:{title:"imageSegmentationPipeline._call(images, options) ⇒ <code> Promise. < Array > </code>",local:"imagesegmentationpipelinecallimages-options--code-promise--array--code",headingTag:"h3"}}),ti=new J({props:{title:"pipelines.ZeroShotImageClassificationPipeline",local:"pipelineszeroshotimageclassificationpipeline",headingTag:"h2"}}),ii=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3plcm8tc2hvdC1pbWFnZS1jbGFzc2lmaWNhdGlvbiclMkMlMjAnWGVub3ZhJTJGY2xpcC12aXQtYmFzZS1wYXRjaDMyJyklM0IlMEFsZXQlMjB1cmwlMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRnRpZ2VyLmpwZyclM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIodXJsJTJDJTIwJTVCJ3RpZ2VyJyUyQyUyMCdob3JzZSclMkMlMjAnZG9nJyU1RCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBzY29yZSUzQSUyMDAuOTk5MzkxNzk0MjA0NzExOSUyQyUyMGxhYmVsJTNBJTIwJ3RpZ2VyJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHNjb3JlJTNBJTIwMC4wMDAzNTE5Mjk0ODQxNjgwNjc2JTJDJTIwbGFiZWwlM0ElMjAnaG9yc2UnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwc2NvcmUlM0ElMjAwLjAwMDI1NjI2OTg3OTE3MzQ4NzQlMkMlMjBsYWJlbCUzQSUyMCdkb2cnJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/clip-vit-base-patch32&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, [<span class="hljs-string">&#x27;tiger&#x27;</span>, <span class="hljs-string">&#x27;horse&#x27;</span>, <span class="hljs-string">&#x27;dog&#x27;</span>]);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { score: 0.9993917942047119, label: &#x27;tiger&#x27; },</span>
<span class="hljs-comment">//   { score: 0.0003519294841680676, label: &#x27;horse&#x27; },</span>
<span class="hljs-comment">//   { score: 0.0002562698791734874, label: &#x27;dog&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),oi=new J({props:{title:"new ZeroShotImageClassificationPipeline(options)",local:"new-zeroshotimageclassificationpipelineoptions",headingTag:"h3"}}),Mi=new J({props:{title:"zeroShotImageClassificationPipeline._call(images, candidate_labels, options) ⇒ <code> Promise. < any > </code>",local:"zeroshotimageclassificationpipelinecallimages-candidatelabels-options--code-promise--any--code",headingTag:"h3"}}),Ji=new J({props:{title:"pipelines.ObjectDetectionPipeline",local:"pipelinesobjectdetectionpipeline",headingTag:"h2"}}),ji=new h({props:{code:"bGV0JTIwaW1nJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEElMEFsZXQlMjBkZXRlY3RvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ29iamVjdC1kZXRlY3Rpb24nJTJDJTIwJ1hlbm92YSUyRmRldHItcmVzbmV0LTUwJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGRldGVjdG9yKGltZyUyQyUyMCU3QiUyMHRocmVzaG9sZCUzQSUyMDAuOSUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMEElMkYlMkYlMjAlMjAlMjAlMjJzY29yZSUyMiUzQSUyMDAuOTk3NjM3MDkzMDY3MTY5MiUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTIycmVtb3RlJTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIyYm94JTIyJTNBJTIwJTdCJTIwJTIyeG1pbiUyMiUzQSUyMDMxJTJDJTIwJTIyeW1pbiUyMiUzQSUyMDY4JTJDJTIwJTIyeG1heCUyMiUzQSUyMDE5MCUyQyUyMCUyMnltYXglMjIlM0ElMjAxMTglMjAlN0QlMEElMkYlMkYlMjAlN0QlMkMlMEElMkYlMkYlMjAuLi4lMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjAlMjJzY29yZSUyMiUzQSUyMDAuOTk4NDA5MjExNjM1NTg5NiUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyY2F0JTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIyYm94JTIyJTNBJTIwJTdCJTIwJTIyeG1pbiUyMiUzQSUyMDMzMSUyQyUyMCUyMnltaW4lMjIlM0ElMjAxOSUyQyUyMCUyMnhtYXglMjIlM0ElMjA2NDklMkMlMjAlMjJ5bWF4JTIyJTNBJTIwMzcxJTIwJTdEJTBBJTJGJTJGJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> img = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;

<span class="hljs-keyword">let</span> detector = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;object-detection&#x27;</span>, <span class="hljs-string">&#x27;Xenova/detr-resnet-50&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">detector</span>(img, { <span class="hljs-attr">threshold</span>: <span class="hljs-number">0.9</span> });
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   &quot;score&quot;: 0.9976370930671692,</span>
<span class="hljs-comment">//   &quot;label&quot;: &quot;remote&quot;,</span>
<span class="hljs-comment">//   &quot;box&quot;: { &quot;xmin&quot;: 31, &quot;ymin&quot;: 68, &quot;xmax&quot;: 190, &quot;ymax&quot;: 118 }</span>
<span class="hljs-comment">// },</span>
<span class="hljs-comment">// ...</span>
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;score&quot;: 0.9984092116355896,</span>
<span class="hljs-comment">//   &quot;label&quot;: &quot;cat&quot;,</span>
<span class="hljs-comment">//   &quot;box&quot;: { &quot;xmin&quot;: 331, &quot;ymin&quot;: 19, &quot;xmax&quot;: 649, &quot;ymax&quot;: 371 }</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),xi=new J({props:{title:"new ObjectDetectionPipeline(options)",local:"new-objectdetectionpipelineoptions",headingTag:"h3"}}),ki=new J({props:{title:"objectDetectionPipeline._call(images, options)",local:"objectdetectionpipelinecallimages-options",headingTag:"h3"}}),vi=new J({props:{title:"pipelines.DocumentQuestionAnsweringPipeline",local:"pipelinesdocumentquestionansweringpipeline",headingTag:"h2"}}),_i=new h({props:{code:"bGV0JTIwaW1hZ2UlMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmludm9pY2UucG5nJyUzQiUwQWxldCUyMHF1ZXN0aW9uJTIwJTNEJTIwJ1doYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YnJTNCJTBBJTBBbGV0JTIwcWFfcGlwZWxpbmUlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdkb2N1bWVudC1xdWVzdGlvbi1hbnN3ZXJpbmcnJTJDJTIwJ1hlbm92YSUyRmRvbnV0LWJhc2UtZmluZXR1bmVkLWRvY3ZxYScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBxYV9waXBlbGluZShpbWFnZSUyQyUyMHF1ZXN0aW9uKSUzQiUwQSUyRiUyRiUyMCU1QiU3QiUyMGFuc3dlciUzQSUyMCd1cy0wMDEnJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> image = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/invoice.png&#x27;</span>;
<span class="hljs-keyword">let</span> question = <span class="hljs-string">&#x27;What is the invoice number?&#x27;</span>;

<span class="hljs-keyword">let</span> qa_pipeline = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;document-question-answering&#x27;</span>, <span class="hljs-string">&#x27;Xenova/donut-base-finetuned-docvqa&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">qa_pipeline</span>(image, question);
<span class="hljs-comment">// [{ answer: &#x27;us-001&#x27; }]</span>`,wrap:!1}}),Yi=new J({props:{title:"new DocumentQuestionAnsweringPipeline(options)",local:"new-documentquestionansweringpipelineoptions",headingTag:"h3"}}),Wi=new J({props:{title:"documentQuestionAnsweringPipeline._call(image, question, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>",local:"documentquestionansweringpipelinecallimage-question-generatekwargs--code-promise--objectarray--object----code",headingTag:"h3"}}),Fi=new J({props:{title:"pipelines.TextToAudioPipeline",local:"pipelinestexttoaudiopipeline",headingTag:"h2"}}),Oi=new h({props:{code:"bGV0JTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZzcGVha2VyX2VtYmVkZGluZ3MuYmluJyUzQiUwQWxldCUyMHN5bnRoZXNpemVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dC10by1zcGVlY2gnJTJDJTIwJ1hlbm92YSUyRnNwZWVjaHQ1X3R0cyclMkMlMjAlN0IlMjBxdWFudGl6ZWQlM0ElMjBmYWxzZSUyMCU3RCklM0IlMEFsZXQlMjBvdXQlMjAlM0QlMjBhd2FpdCUyMHN5bnRoZXNpemVyKCdIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJyUyQyUyMCU3QiUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjBhdWRpbyUzQSUyMEZsb2F0MzJBcnJheSgyNjExMiklMjAlNUItMC4wMDAwNTY1NzMzNzg5Njk5MTUyMSUyQyUyMDAuMDAwMjA1ODM4NzQ3MjA2MTQ0MDMlMkMlMjAuLi4lNUQlMkMlMEElMkYlMkYlMjAlMjAlMjBzYW1wbGluZ19yYXRlJTNBJTIwMTYwMDAlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> speaker_embeddings = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/speaker_embeddings.bin&#x27;</span>;
<span class="hljs-keyword">let</span> synthesizer = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-to-speech&#x27;</span>, <span class="hljs-string">&#x27;Xenova/speecht5_tts&#x27;</span>, { <span class="hljs-attr">quantized</span>: <span class="hljs-literal">false</span> });
<span class="hljs-keyword">let</span> out = <span class="hljs-keyword">await</span> <span class="hljs-title function_">synthesizer</span>(<span class="hljs-string">&#x27;Hello, my dog is cute&#x27;</span>, { speaker_embeddings });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   audio: Float32Array(26112) [-0.00005657337896991521, 0.00020583874720614403, ...],</span>
<span class="hljs-comment">//   sampling_rate: 16000</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),en=new h({props:{code:"aW1wb3J0JTIwd2F2ZWZpbGUlMjBmcm9tJTIwJ3dhdmVmaWxlJyUzQiUwQWltcG9ydCUyMGZzJTIwZnJvbSUyMCdmcyclM0IlMEElMEFsZXQlMjB3YXYlMjAlM0QlMjBuZXclMjB3YXZlZmlsZS5XYXZlRmlsZSgpJTNCJTBBd2F2LmZyb21TY3JhdGNoKDElMkMlMjBvdXQuc2FtcGxpbmdfcmF0ZSUyQyUyMCczMmYnJTJDJTIwb3V0LmF1ZGlvKSUzQiUwQWZzLndyaXRlRmlsZVN5bmMoJ291dC53YXYnJTJDJTIwd2F2LnRvQnVmZmVyKCkpJTNC",highlighted:`<span class="hljs-keyword">import</span> wavefile <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;wavefile&#x27;</span>;
<span class="hljs-keyword">import</span> fs <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;fs&#x27;</span>;

<span class="hljs-keyword">let</span> wav = <span class="hljs-keyword">new</span> wavefile.<span class="hljs-title class_">WaveFile</span>();
wav.<span class="hljs-title function_">fromScratch</span>(<span class="hljs-number">1</span>, out.<span class="hljs-property">sampling_rate</span>, <span class="hljs-string">&#x27;32f&#x27;</span>, out.<span class="hljs-property">audio</span>);
fs.<span class="hljs-title function_">writeFileSync</span>(<span class="hljs-string">&#x27;out.wav&#x27;</span>, wav.<span class="hljs-title function_">toBuffer</span>());`,wrap:!1}}),nn=new J({props:{title:"new TextToAudioPipeline(options)",local:"new-texttoaudiopipelineoptions",headingTag:"h3"}}),dn=new J({props:{title:"textToAudioPipeline._call(text_inputs, options) ⇒ <code> Promise. < Object > </code>",local:"texttoaudiopipelinecalltextinputs-options--code-promise--object--code",headingTag:"h3"}}),Tn=new J({props:{title:"pipelines.ImageToImagePipeline",local:"pipelinesimagetoimagepipeline",headingTag:"h2"}}),Jn=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZidXR0ZXJmbHkuanBnJyUzQiUwQWxldCUyMHVwc2NhbGVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnaW1hZ2UtdG8taW1hZ2UnJTJDJTIwJ1hlbm92YSUyRnN3aW4yU1ItY2xhc3NpY2FsLXNyLXgyLTY0JyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHVwc2NhbGVyKHVybCklM0IlMEElMkYlMkYlMjBSYXdJbWFnZSUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMGRhdGElM0ElMjBVaW50OEFycmF5KDc4NjQzMiklMjAlNUIlMjA0MSUyQyUyMDMxJTJDJTIwMjQlMkMlMjAlMjA0MyUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMHdpZHRoJTNBJTIwNTEyJTJDJTBBJTJGJTJGJTIwJTIwJTIwaGVpZ2h0JTNBJTIwNTEyJTJDJTBBJTJGJTJGJTIwJTIwJTIwY2hhbm5lbHMlM0ElMjAzJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/butterfly.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> upscaler = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-to-image&#x27;</span>, <span class="hljs-string">&#x27;Xenova/swin2SR-classical-sr-x2-64&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">upscaler</span>(url);
<span class="hljs-comment">// RawImage {</span>
<span class="hljs-comment">//   data: Uint8Array(786432) [ 41, 31, 24,  43, ... ],</span>
<span class="hljs-comment">//   width: 512,</span>
<span class="hljs-comment">//   height: 512,</span>
<span class="hljs-comment">//   channels: 3</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),jn=new J({props:{title:"imageToImagePipeline._call(images) ⇒ <code> Promise. < any > </code>",local:"imagetoimagepipelinecallimages--code-promise--any--code",headingTag:"h3"}}),Cn=new J({props:{title:"pipelines.pipeline(task, [model], [options]) ⇒ <code> Promise. < Pipeline > </code>",local:"pipelinespipelinetask-model-options--code-promise--pipeline--code",headingTag:"h2"}}),Bn=new J({props:{title:"pipelines~QuestionAnsweringResult : <code> object </code>",local:"pipelinesquestionansweringresult--code-object-code",headingTag:"h2"}}),An=new J({props:{title:"pipelines~QuestionAnsweringReturnType : <code> Promise. < (QuestionAnsweringResult|Array < QuestionAnsweringResult > ) > </code>",local:"pipelinesquestionansweringreturntype--code-promise--questionansweringresultarray--questionansweringresult----code",headingTag:"h2"}}),Rn=new J({props:{title:"pipelines~ChunkCallback : <code> function </code>",local:"pipelineschunkcallback--code-function-code",headingTag:"h2"}}),{c(){w=a("meta"),En=i(),Pn=a("p"),Wn=i(),j=a("a"),Xn=i(),c(U.$$.fragment),zn=i(),f=a("p"),f.textContent=jT,Sn=i(),b=a("p"),b.innerHTML=UT,Ln=i(),c(x.$$.fragment),Fn=i(),C=a("ul"),C.innerHTML=fT,Dn=i(),qn=a("hr"),On=i(),g=a("a"),Kn=i(),c(I.$$.fragment),ea=i(),k=a("p"),k.textContent=bT,ta=i(),G=a("p"),G.innerHTML=xT,la=i(),Z=a("ul"),Z.innerHTML=CT,sa=i(),ia=a("hr"),na=i(),B=a("a"),aa=i(),c(Q.$$.fragment),pa=i(),v=a("p"),v.textContent=gT,oa=i(),N=a("table"),N.innerHTML=IT,da=i(),ca=a("hr"),ra=i(),A=a("a"),Ma=i(),c(_.$$.fragment),ma=i(),$=a("p"),$.textContent=kT,Ta=i(),R=a("p"),R.innerHTML=GT,ya=i(),ua=a("hr"),Ja=i(),V=a("a"),ha=i(),c(Y.$$.fragment),wa=i(),P=a("p"),P.textContent=ZT,ja=i(),H=a("p"),H.innerHTML=BT,Ua=i(),E=a("table"),E.innerHTML=QT,fa=i(),ba=a("hr"),xa=i(),W=a("a"),Ca=i(),c(X.$$.fragment),ga=i(),z=a("p"),z.innerHTML=vT,Ia=i(),S=a("p"),S.innerHTML=NT,ka=i(),c(L.$$.fragment),Ga=i(),F=a("p"),F.innerHTML=AT,Za=i(),c(D.$$.fragment),Ba=i(),q=a("p"),q.innerHTML=_T,Qa=i(),c(O.$$.fragment),va=i(),K=a("p"),K.innerHTML=$T,Na=i(),Aa=a("hr"),_a=i(),ee=a("a"),$a=i(),c(te.$$.fragment),Ra=i(),le=a("p"),le.textContent=RT,Va=i(),se=a("p"),se.innerHTML=VT,Ya=i(),ie=a("table"),ie.innerHTML=YT,Pa=i(),Ha=a("hr"),Ea=i(),ne=a("a"),Wa=i(),c(ae.$$.fragment),Xa=i(),pe=a("p"),pe.innerHTML=PT,za=i(),oe=a("p"),oe.innerHTML=HT,Sa=i(),c(de.$$.fragment),La=i(),ce=a("p"),ce.innerHTML=ET,Fa=i(),c(re.$$.fragment),Da=i(),Me=a("p"),Me.innerHTML=WT,qa=i(),Oa=a("hr"),Ka=i(),me=a("a"),ep=i(),c(Te.$$.fragment),tp=i(),ye=a("p"),ye.textContent=XT,lp=i(),ue=a("p"),ue.innerHTML=zT,sp=i(),Je=a("table"),Je.innerHTML=ST,ip=i(),np=a("hr"),ap=i(),he=a("a"),pp=i(),c(we.$$.fragment),op=i(),je=a("p"),je.innerHTML=LT,dp=i(),Ue=a("p"),Ue.innerHTML=FT,cp=i(),c(fe.$$.fragment),rp=i(),be=a("p"),be.innerHTML=DT,Mp=i(),mp=a("hr"),Tp=i(),xe=a("a"),yp=i(),c(Ce.$$.fragment),up=i(),ge=a("p"),ge.textContent=qT,Jp=i(),Ie=a("p"),Ie.innerHTML=OT,hp=i(),ke=a("table"),ke.innerHTML=KT,wp=i(),jp=a("hr"),Up=i(),Ge=a("a"),fp=i(),c(Ze.$$.fragment),bp=i(),Be=a("p"),Be.innerHTML=ey,xp=i(),Qe=a("p"),Qe.innerHTML=ty,Cp=i(),c(ve.$$.fragment),gp=i(),Ne=a("p"),Ne.innerHTML=ly,Ip=i(),c(Ae.$$.fragment),kp=i(),_e=a("p"),_e.innerHTML=sy,Gp=i(),Zp=a("hr"),Bp=i(),$e=a("a"),Qp=i(),c(Re.$$.fragment),vp=i(),Ve=a("p"),Ve.textContent=iy,Np=i(),Ye=a("p"),Ye.innerHTML=ny,Ap=i(),Pe=a("table"),Pe.innerHTML=ay,_p=i(),$p=a("hr"),Rp=i(),He=a("a"),Vp=i(),c(Ee.$$.fragment),Yp=i(),We=a("p"),We.textContent=py,Pp=i(),Xe=a("p"),Xe.innerHTML=oy,Hp=i(),c(ze.$$.fragment),Ep=i(),Se=a("p"),Se.innerHTML=dy,Wp=i(),Xp=a("hr"),zp=i(),Le=a("a"),Sp=i(),c(Fe.$$.fragment),Lp=i(),De=a("p"),De.textContent=cy,Fp=i(),qe=a("p"),qe.innerHTML=ry,Dp=i(),Oe=a("ul"),Oe.innerHTML=My,qp=i(),Ke=a("table"),Ke.innerHTML=my,Op=i(),Kp=a("hr"),eo=i(),et=a("a"),to=i(),c(tt.$$.fragment),lo=i(),lt=a("p"),lt.textContent=Ty,so=i(),st=a("p"),st.innerHTML=yy,io=i(),c(it.$$.fragment),no=i(),nt=a("p"),nt.innerHTML=uy,ao=i(),po=a("hr"),oo=i(),at=a("a"),co=i(),c(pt.$$.fragment),ro=i(),ot=a("p"),ot.textContent=Jy,Mo=i(),dt=a("p"),dt.innerHTML=hy,mo=i(),ct=a("p"),ct.innerHTML=wy,To=i(),c(rt.$$.fragment),yo=i(),Mt=a("p"),Mt.innerHTML=jy,uo=i(),mt=a("p"),mt.innerHTML=Uy,Jo=i(),c(Tt.$$.fragment),ho=i(),yt=a("p"),yt.innerHTML=fy,wo=i(),ut=a("p"),ut.innerHTML=by,jo=i(),c(Jt.$$.fragment),Uo=i(),ht=a("p"),ht.innerHTML=xy,fo=i(),bo=a("hr"),xo=i(),wt=a("a"),Co=i(),c(jt.$$.fragment),go=i(),Ut=a("p"),Ut.innerHTML=Cy,Io=i(),ft=a("p"),ft.innerHTML=gy,ko=i(),c(bt.$$.fragment),Go=i(),xt=a("p"),xt.innerHTML=Iy,Zo=i(),c(Ct.$$.fragment),Bo=i(),gt=a("p"),gt.innerHTML=ky,Qo=i(),c(It.$$.fragment),vo=i(),kt=a("p"),kt.innerHTML=Gy,No=i(),Ao=a("hr"),_o=i(),Gt=a("a"),$o=i(),c(Zt.$$.fragment),Ro=i(),Bt=a("p"),Bt.textContent=Zy,Vo=i(),Qt=a("p"),Qt.innerHTML=By,Yo=i(),vt=a("table"),vt.innerHTML=Qy,Po=i(),Ho=a("hr"),Eo=i(),Nt=a("a"),Wo=i(),c(At.$$.fragment),Xo=i(),_t=a("p"),_t.innerHTML=vy,zo=i(),$t=a("p"),$t.innerHTML=Ny,So=i(),c(Rt.$$.fragment),Lo=i(),Vt=a("p"),Vt.innerHTML=Ay,Fo=i(),c(Yt.$$.fragment),Do=i(),Pt=a("p"),Pt.innerHTML=_y,qo=i(),Ht=a("ul"),Ht.innerHTML=$y,Oo=i(),Ko=a("hr"),ed=i(),Et=a("a"),td=i(),c(Wt.$$.fragment),ld=i(),Xt=a("p"),Xt.textContent=Ry,sd=i(),zt=a("table"),zt.innerHTML=Vy,id=i(),nd=a("hr"),ad=i(),St=a("a"),pd=i(),c(Lt.$$.fragment),od=i(),Ft=a("p"),Ft.innerHTML=Yy,dd=i(),Dt=a("table"),Dt.innerHTML=Py,cd=i(),rd=a("hr"),Md=i(),qt=a("a"),md=i(),c(Ot.$$.fragment),Td=i(),Kt=a("p"),Kt.textContent=Hy,yd=i(),el=a("p"),el.innerHTML=Ey,ud=i(),c(tl.$$.fragment),Jd=i(),ll=a("p"),ll.innerHTML=Wy,hd=i(),c(sl.$$.fragment),wd=i(),il=a("p"),il.innerHTML=Xy,jd=i(),c(nl.$$.fragment),Ud=i(),al=a("p"),al.innerHTML=zy,fd=i(),bd=a("hr"),xd=i(),pl=a("a"),Cd=i(),c(ol.$$.fragment),gd=i(),dl=a("p"),dl.textContent=Sy,Id=i(),cl=a("p"),cl.innerHTML=Ly,kd=i(),rl=a("table"),rl.innerHTML=Fy,Gd=i(),Zd=a("hr"),Bd=i(),Ml=a("a"),Qd=i(),c(ml.$$.fragment),vd=i(),Tl=a("p"),Tl.innerHTML=Dy,Nd=i(),yl=a("p"),yl.innerHTML=qy,Ad=i(),c(ul.$$.fragment),_d=i(),Jl=a("p"),Jl.innerHTML=Oy,$d=i(),hl=a("ul"),hl.innerHTML=Ky,Rd=i(),Vd=a("hr"),Yd=i(),wl=a("a"),Pd=i(),c(jl.$$.fragment),Hd=i(),Ul=a("p"),Ul.textContent=eu,Ed=i(),fl=a("table"),fl.innerHTML=tu,Wd=i(),Xd=a("hr"),zd=i(),bl=a("a"),Sd=i(),c(xl.$$.fragment),Ld=i(),Cl=a("p"),Cl.textContent=lu,Fd=i(),gl=a("p"),gl.innerHTML=su,Dd=i(),Il=a("table"),Il.innerHTML=iu,qd=i(),Od=a("hr"),Kd=i(),kl=a("a"),ec=i(),c(Gl.$$.fragment),tc=i(),Zl=a("p"),Zl.textContent=nu,lc=i(),Bl=a("p"),Bl.innerHTML=au,sc=i(),c(Ql.$$.fragment),ic=i(),vl=a("p"),vl.innerHTML=pu,nc=i(),c(Nl.$$.fragment),ac=i(),Al=a("p"),Al.innerHTML=ou,pc=i(),c(_l.$$.fragment),oc=i(),$l=a("p"),$l.innerHTML=du,dc=i(),c(Rl.$$.fragment),cc=i(),Vl=a("p"),Vl.innerHTML=cu,rc=i(),c(Yl.$$.fragment),Mc=i(),Pl=a("p"),Pl.innerHTML=ru,mc=i(),c(Hl.$$.fragment),Tc=i(),El=a("p"),El.innerHTML=Mu,yc=i(),Wl=a("ul"),Wl.innerHTML=mu,uc=i(),Jc=a("hr"),hc=i(),Xl=a("a"),wc=i(),c(zl.$$.fragment),jc=i(),Sl=a("p"),Sl.textContent=Tu,Uc=i(),Ll=a("table"),Ll.innerHTML=yu,fc=i(),bc=a("hr"),xc=i(),Fl=a("a"),Cc=i(),c(Dl.$$.fragment),gc=i(),ql=a("p"),ql.textContent=uu,Ic=i(),Ol=a("p"),Ol.innerHTML=Ju,kc=i(),Kl=a("table"),Kl.innerHTML=hu,Gc=i(),Zc=a("hr"),Bc=i(),es=a("a"),Qc=i(),c(ts.$$.fragment),vc=i(),ls=a("p"),ls.innerHTML=wu,Nc=i(),ss=a("p"),ss.innerHTML=ju,Ac=i(),c(is.$$.fragment),_c=i(),ns=a("p"),ns.innerHTML=Uu,$c=i(),c(as.$$.fragment),Rc=i(),ps=a("p"),ps.innerHTML=fu,Vc=i(),os=a("ul"),os.innerHTML=bu,Yc=i(),Pc=a("hr"),Hc=i(),ds=a("a"),Ec=i(),c(cs.$$.fragment),Wc=i(),rs=a("p"),rs.textContent=xu,Xc=i(),Ms=a("table"),Ms.innerHTML=Cu,zc=i(),Sc=a("hr"),Lc=i(),ms=a("a"),Fc=i(),c(Ts.$$.fragment),Dc=i(),ys=a("p"),ys.textContent=gu,qc=i(),us=a("p"),us.innerHTML=Iu,Oc=i(),Js=a("table"),Js.innerHTML=ku,Kc=i(),er=a("hr"),tr=i(),hs=a("a"),lr=i(),c(ws.$$.fragment),sr=i(),js=a("p"),js.innerHTML=Gu,ir=i(),Us=a("p"),Us.innerHTML=Zu,nr=i(),c(fs.$$.fragment),ar=i(),bs=a("p"),bs.innerHTML=Bu,pr=i(),c(xs.$$.fragment),or=i(),Cs=a("p"),Cs.innerHTML=Qu,dr=i(),c(gs.$$.fragment),cr=i(),Is=a("p"),Is.innerHTML=vu,rr=i(),ks=a("ul"),ks.innerHTML=Nu,Mr=i(),mr=a("hr"),Tr=i(),Gs=a("a"),yr=i(),c(Zs.$$.fragment),ur=i(),Bs=a("p"),Bs.textContent=Au,Jr=i(),Qs=a("table"),Qs.innerHTML=_u,hr=i(),wr=a("hr"),jr=i(),vs=a("a"),Ur=i(),c(Ns.$$.fragment),fr=i(),As=a("p"),As.textContent=$u,br=i(),_s=a("p"),_s.innerHTML=Ru,xr=i(),$s=a("table"),$s.innerHTML=Vu,Cr=i(),gr=a("hr"),Ir=i(),Rs=a("a"),kr=i(),c(Vs.$$.fragment),Gr=i(),Ys=a("p"),Ys.innerHTML=Yu,Zr=i(),Ps=a("p"),Ps.innerHTML=Pu,Br=i(),c(Hs.$$.fragment),Qr=i(),Es=a("p"),Es.innerHTML=Hu,vr=i(),Ws=a("ul"),Ws.innerHTML=Eu,Nr=i(),Ar=a("hr"),_r=i(),Xs=a("a"),$r=i(),c(zs.$$.fragment),Rr=i(),Ss=a("p"),Ss.textContent=Wu,Vr=i(),Ls=a("table"),Ls.innerHTML=Xu,Yr=i(),Pr=a("hr"),Hr=i(),Fs=a("a"),Er=i(),c(Ds.$$.fragment),Wr=i(),qs=a("p"),qs.textContent=zu,Xr=i(),Os=a("p"),Os.innerHTML=Su,zr=i(),Ks=a("table"),Ks.innerHTML=Lu,Sr=i(),Lr=a("hr"),Fr=i(),ei=a("a"),Dr=i(),c(ti.$$.fragment),qr=i(),li=a("p"),li.innerHTML=Fu,Or=i(),si=a("p"),si.innerHTML=Du,Kr=i(),c(ii.$$.fragment),eM=i(),ni=a("p"),ni.innerHTML=qu,tM=i(),ai=a("ul"),ai.innerHTML=Ou,lM=i(),sM=a("hr"),iM=i(),pi=a("a"),nM=i(),c(oi.$$.fragment),aM=i(),di=a("p"),di.textContent=Ku,pM=i(),ci=a("table"),ci.innerHTML=eJ,oM=i(),dM=a("hr"),cM=i(),ri=a("a"),rM=i(),c(Mi.$$.fragment),MM=i(),mi=a("p"),mi.textContent=tJ,mM=i(),Ti=a("p"),Ti.innerHTML=lJ,TM=i(),yi=a("table"),yi.innerHTML=sJ,yM=i(),uM=a("hr"),JM=i(),ui=a("a"),hM=i(),c(Ji.$$.fragment),wM=i(),hi=a("p"),hi.innerHTML=iJ,jM=i(),wi=a("p"),wi.innerHTML=nJ,UM=i(),c(ji.$$.fragment),fM=i(),Ui=a("p"),Ui.innerHTML=aJ,bM=i(),fi=a("ul"),fi.innerHTML=pJ,xM=i(),CM=a("hr"),gM=i(),bi=a("a"),IM=i(),c(xi.$$.fragment),kM=i(),Ci=a("p"),Ci.textContent=oJ,GM=i(),gi=a("table"),gi.innerHTML=dJ,ZM=i(),BM=a("hr"),QM=i(),Ii=a("a"),vM=i(),c(ki.$$.fragment),NM=i(),Gi=a("p"),Gi.textContent=cJ,AM=i(),Zi=a("p"),Zi.innerHTML=rJ,_M=i(),Bi=a("table"),Bi.innerHTML=MJ,$M=i(),RM=a("hr"),VM=i(),Qi=a("a"),YM=i(),c(vi.$$.fragment),PM=i(),Ni=a("p"),Ni.innerHTML=mJ,HM=i(),Ai=a("p"),Ai.innerHTML=TJ,EM=i(),c(_i.$$.fragment),WM=i(),$i=a("p"),$i.innerHTML=yJ,XM=i(),Ri=a("ul"),Ri.innerHTML=uJ,zM=i(),SM=a("hr"),LM=i(),Vi=a("a"),FM=i(),c(Yi.$$.fragment),DM=i(),Pi=a("p"),Pi.textContent=JJ,qM=i(),Hi=a("table"),Hi.innerHTML=hJ,OM=i(),KM=a("hr"),em=i(),Ei=a("a"),tm=i(),c(Wi.$$.fragment),lm=i(),Xi=a("p"),Xi.textContent=wJ,sm=i(),zi=a("p"),zi.innerHTML=jJ,im=i(),Si=a("table"),Si.innerHTML=UJ,nm=i(),am=a("hr"),pm=i(),Li=a("a"),om=i(),c(Fi.$$.fragment),dm=i(),Di=a("p"),Di.innerHTML=fJ,cm=i(),qi=a("p"),qi.innerHTML=bJ,rm=i(),c(Oi.$$.fragment),Mm=i(),Ki=a("p"),Ki.innerHTML=xJ,mm=i(),c(en.$$.fragment),Tm=i(),tn=a("p"),tn.innerHTML=CJ,ym=i(),ln=a("ul"),ln.innerHTML=gJ,um=i(),Jm=a("hr"),hm=i(),sn=a("a"),wm=i(),c(nn.$$.fragment),jm=i(),an=a("p"),an.textContent=IJ,Um=i(),pn=a("table"),pn.innerHTML=kJ,fm=i(),bm=a("hr"),xm=i(),on=a("a"),Cm=i(),c(dn.$$.fragment),gm=i(),cn=a("p"),cn.textContent=GJ,Im=i(),rn=a("p"),rn.innerHTML=ZJ,km=i(),Mn=a("table"),Mn.innerHTML=BJ,Gm=i(),Zm=a("hr"),Bm=i(),mn=a("a"),Qm=i(),c(Tn.$$.fragment),vm=i(),yn=a("p"),yn.innerHTML=QJ,Nm=i(),un=a("p"),un.innerHTML=vJ,Am=i(),c(Jn.$$.fragment),_m=i(),hn=a("p"),hn.innerHTML=NJ,$m=i(),Rm=a("hr"),Vm=i(),wn=a("a"),Ym=i(),c(jn.$$.fragment),Pm=i(),Un=a("p"),Un.textContent=AJ,Hm=i(),fn=a("p"),fn.innerHTML=_J,Em=i(),bn=a("table"),bn.innerHTML=$J,Wm=i(),Xm=a("hr"),zm=i(),xn=a("a"),Sm=i(),c(Cn.$$.fragment),Lm=i(),gn=a("p"),gn.innerHTML=RJ,Fm=i(),In=a("p"),In.innerHTML=VJ,Dm=i(),kn=a("ul"),kn.innerHTML=YJ,qm=i(),Gn=a("table"),Gn.innerHTML=PJ,Om=i(),Km=a("hr"),eT=i(),Zn=a("a"),tT=i(),c(Bn.$$.fragment),lT=i(),Qn=a("p"),Qn.innerHTML=HJ,sT=i(),vn=a("table"),vn.innerHTML=EJ,iT=i(),nT=a("hr"),aT=i(),Nn=a("a"),pT=i(),c(An.$$.fragment),oT=i(),_n=a("p"),_n.innerHTML=WJ,dT=i(),cT=a("hr"),rT=i(),$n=a("a"),MT=i(),c(Rn.$$.fragment),mT=i(),Vn=a("p"),Vn.innerHTML=XJ,TT=i(),Yn=a("table"),Yn.innerHTML=zJ,yT=i(),uT=a("hr"),JT=i(),Hn=a("p"),this.h()},l(e){const t=OJ("svelte-u9bgzb",document.head);w=p(t,"META",{name:!0,content:!0}),t.forEach(l),En=n(e),Pn=p(e,"P",{}),u(Pn).forEach(l),Wn=n(e),j=p(e,"A",{id:!0,class:!0}),u(j).forEach(l),Xn=n(e),r(U.$$.fragment,e),zn=n(e),f=p(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1inm2t9"&&(f.textContent=jT),Sn=n(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1pjech"&&(b.innerHTML=UT),Ln=n(e),r(x.$$.fragment,e),Fn=n(e),C=p(e,"UL",{"data-svelte-h":!0}),o(C)!=="svelte-krmx9k"&&(C.innerHTML=fT),Dn=n(e),qn=p(e,"HR",{}),On=n(e),g=p(e,"A",{id:!0,class:!0}),u(g).forEach(l),Kn=n(e),r(I.$$.fragment,e),ea=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-16ix8v2"&&(k.textContent=bT),ta=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1olpg2f"&&(G.innerHTML=xT),la=n(e),Z=p(e,"UL",{"data-svelte-h":!0}),o(Z)!=="svelte-1wo4saj"&&(Z.innerHTML=CT),sa=n(e),ia=p(e,"HR",{}),na=n(e),B=p(e,"A",{id:!0,class:!0}),u(B).forEach(l),aa=n(e),r(Q.$$.fragment,e),pa=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-10jkwj"&&(v.textContent=gT),oa=n(e),N=p(e,"TABLE",{"data-svelte-h":!0}),o(N)!=="svelte-13q0syp"&&(N.innerHTML=IT),da=n(e),ca=p(e,"HR",{}),ra=n(e),A=p(e,"A",{id:!0,class:!0}),u(A).forEach(l),Ma=n(e),r(_.$$.fragment,e),ma=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1yhr8qe"&&($.textContent=kT),Ta=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1yqombv"&&(R.innerHTML=GT),ya=n(e),ua=p(e,"HR",{}),Ja=n(e),V=p(e,"A",{id:!0,class:!0}),u(V).forEach(l),ha=n(e),r(Y.$$.fragment,e),wa=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-phuke9"&&(P.textContent=ZT),ja=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1xajepz"&&(H.innerHTML=BT),Ua=n(e),E=p(e,"TABLE",{"data-svelte-h":!0}),o(E)!=="svelte-1dl6le6"&&(E.innerHTML=QT),fa=n(e),ba=p(e,"HR",{}),xa=n(e),W=p(e,"A",{id:!0,class:!0}),u(W).forEach(l),Ca=n(e),r(X.$$.fragment,e),ga=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1aega0x"&&(z.innerHTML=vT),Ia=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-twv4w2"&&(S.innerHTML=NT),ka=n(e),r(L.$$.fragment,e),Ga=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-9l8wqs"&&(F.innerHTML=AT),Za=n(e),r(D.$$.fragment,e),Ba=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-63pkoo"&&(q.innerHTML=_T),Qa=n(e),r(O.$$.fragment,e),va=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-s10qq4"&&(K.innerHTML=$T),Na=n(e),Aa=p(e,"HR",{}),_a=n(e),ee=p(e,"A",{id:!0,class:!0}),u(ee).forEach(l),$a=n(e),r(te.$$.fragment,e),Ra=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-319swt"&&(le.textContent=RT),Va=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1vshn55"&&(se.innerHTML=VT),Ya=n(e),ie=p(e,"TABLE",{"data-svelte-h":!0}),o(ie)!=="svelte-mqkhxk"&&(ie.innerHTML=YT),Pa=n(e),Ha=p(e,"HR",{}),Ea=n(e),ne=p(e,"A",{id:!0,class:!0}),u(ne).forEach(l),Wa=n(e),r(ae.$$.fragment,e),Xa=n(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-199l8oj"&&(pe.innerHTML=PT),za=n(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-3ojewp"&&(oe.innerHTML=HT),Sa=n(e),r(de.$$.fragment,e),La=n(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1ln7q61"&&(ce.innerHTML=ET),Fa=n(e),r(re.$$.fragment,e),Da=n(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-s10qq4"&&(Me.innerHTML=WT),qa=n(e),Oa=p(e,"HR",{}),Ka=n(e),me=p(e,"A",{id:!0,class:!0}),u(me).forEach(l),ep=n(e),r(Te.$$.fragment,e),tp=n(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-qfvk6r"&&(ye.textContent=XT),lp=n(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1tvkl0p"&&(ue.innerHTML=zT),sp=n(e),Je=p(e,"TABLE",{"data-svelte-h":!0}),o(Je)!=="svelte-1p6smdx"&&(Je.innerHTML=ST),ip=n(e),np=p(e,"HR",{}),ap=n(e),he=p(e,"A",{id:!0,class:!0}),u(he).forEach(l),pp=n(e),r(we.$$.fragment,e),op=n(e),je=p(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-14f3xkz"&&(je.innerHTML=LT),dp=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-o2pgcr"&&(Ue.innerHTML=FT),cp=n(e),r(fe.$$.fragment,e),rp=n(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-s10qq4"&&(be.innerHTML=DT),Mp=n(e),mp=p(e,"HR",{}),Tp=n(e),xe=p(e,"A",{id:!0,class:!0}),u(xe).forEach(l),yp=n(e),r(Ce.$$.fragment,e),up=n(e),ge=p(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-v1s8i"&&(ge.textContent=qT),Jp=n(e),Ie=p(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1jet258"&&(Ie.innerHTML=OT),hp=n(e),ke=p(e,"TABLE",{"data-svelte-h":!0}),o(ke)!=="svelte-dmekw3"&&(ke.innerHTML=KT),wp=n(e),jp=p(e,"HR",{}),Up=n(e),Ge=p(e,"A",{id:!0,class:!0}),u(Ge).forEach(l),fp=n(e),r(Ze.$$.fragment,e),bp=n(e),Be=p(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-nzjx48"&&(Be.innerHTML=ey),xp=n(e),Qe=p(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1xict4f"&&(Qe.innerHTML=ty),Cp=n(e),r(ve.$$.fragment,e),gp=n(e),Ne=p(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1sz7ava"&&(Ne.innerHTML=ly),Ip=n(e),r(Ae.$$.fragment,e),kp=n(e),_e=p(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-s10qq4"&&(_e.innerHTML=sy),Gp=n(e),Zp=p(e,"HR",{}),Bp=n(e),$e=p(e,"A",{id:!0,class:!0}),u($e).forEach(l),Qp=n(e),r(Re.$$.fragment,e),vp=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-1dgb1r"&&(Ve.textContent=iy),Np=n(e),Ye=p(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-ht5bcu"&&(Ye.innerHTML=ny),Ap=n(e),Pe=p(e,"TABLE",{"data-svelte-h":!0}),o(Pe)!=="svelte-dhvci0"&&(Pe.innerHTML=ay),_p=n(e),$p=p(e,"HR",{}),Rp=n(e),He=p(e,"A",{id:!0,class:!0}),u(He).forEach(l),Vp=n(e),r(Ee.$$.fragment,e),Yp=n(e),We=p(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-e2spcq"&&(We.textContent=py),Pp=n(e),Xe=p(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-j4hwgn"&&(Xe.innerHTML=oy),Hp=n(e),r(ze.$$.fragment,e),Ep=n(e),Se=p(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-s10qq4"&&(Se.innerHTML=dy),Wp=n(e),Xp=p(e,"HR",{}),zp=n(e),Le=p(e,"A",{id:!0,class:!0}),u(Le).forEach(l),Sp=n(e),r(Fe.$$.fragment,e),Lp=n(e),De=p(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-1dgb1r"&&(De.textContent=cy),Fp=n(e),qe=p(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-k5n4xx"&&(qe.innerHTML=ry),Dp=n(e),Oe=p(e,"UL",{"data-svelte-h":!0}),o(Oe)!=="svelte-wmzf9w"&&(Oe.innerHTML=My),qp=n(e),Ke=p(e,"TABLE",{"data-svelte-h":!0}),o(Ke)!=="svelte-18cf78d"&&(Ke.innerHTML=my),Op=n(e),Kp=p(e,"HR",{}),eo=n(e),et=p(e,"A",{id:!0,class:!0}),u(et).forEach(l),to=n(e),r(tt.$$.fragment,e),lo=n(e),lt=p(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-1axdht2"&&(lt.textContent=Ty),so=n(e),st=p(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-1416cqx"&&(st.innerHTML=yy),io=n(e),r(it.$$.fragment,e),no=n(e),nt=p(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-s10qq4"&&(nt.innerHTML=uy),ao=n(e),po=p(e,"HR",{}),oo=n(e),at=p(e,"A",{id:!0,class:!0}),u(at).forEach(l),co=n(e),r(pt.$$.fragment,e),ro=n(e),ot=p(e,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-3abd20"&&(ot.textContent=Jy),Mo=n(e),dt=p(e,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-1ut0vme"&&(dt.innerHTML=hy),mo=n(e),ct=p(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-dr1wsd"&&(ct.innerHTML=wy),To=n(e),r(rt.$$.fragment,e),yo=n(e),Mt=p(e,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-mqh15a"&&(Mt.innerHTML=jy),uo=n(e),mt=p(e,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-zf4dht"&&(mt.innerHTML=Uy),Jo=n(e),r(Tt.$$.fragment,e),ho=n(e),yt=p(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-1877ohf"&&(yt.innerHTML=fy),wo=n(e),ut=p(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1ox1juk"&&(ut.innerHTML=by),jo=n(e),r(Jt.$$.fragment,e),Uo=n(e),ht=p(e,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-s10qq4"&&(ht.innerHTML=xy),fo=n(e),bo=p(e,"HR",{}),xo=n(e),wt=p(e,"A",{id:!0,class:!0}),u(wt).forEach(l),Co=n(e),r(jt.$$.fragment,e),go=n(e),Ut=p(e,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-1yek3op"&&(Ut.innerHTML=Cy),Io=n(e),ft=p(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-11p32pq"&&(ft.innerHTML=gy),ko=n(e),r(bt.$$.fragment,e),Go=n(e),xt=p(e,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-1uqom1e"&&(xt.innerHTML=Iy),Zo=n(e),r(Ct.$$.fragment,e),Bo=n(e),gt=p(e,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-1a7k67n"&&(gt.innerHTML=ky),Qo=n(e),r(It.$$.fragment,e),vo=n(e),kt=p(e,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-s10qq4"&&(kt.innerHTML=Gy),No=n(e),Ao=p(e,"HR",{}),_o=n(e),Gt=p(e,"A",{id:!0,class:!0}),u(Gt).forEach(l),$o=n(e),r(Zt.$$.fragment,e),Ro=n(e),Bt=p(e,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-6m3xhk"&&(Bt.textContent=Zy),Vo=n(e),Qt=p(e,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-1f5btis"&&(Qt.innerHTML=By),Yo=n(e),vt=p(e,"TABLE",{"data-svelte-h":!0}),o(vt)!=="svelte-5kvkn6"&&(vt.innerHTML=Qy),Po=n(e),Ho=p(e,"HR",{}),Eo=n(e),Nt=p(e,"A",{id:!0,class:!0}),u(Nt).forEach(l),Wo=n(e),r(At.$$.fragment,e),Xo=n(e),_t=p(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-104v5zf"&&(_t.innerHTML=vy),zo=n(e),$t=p(e,"P",{"data-svelte-h":!0}),o($t)!=="svelte-17n9q32"&&($t.innerHTML=Ny),So=n(e),r(Rt.$$.fragment,e),Lo=n(e),Vt=p(e,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-v99qry"&&(Vt.innerHTML=Ay),Fo=n(e),r(Yt.$$.fragment,e),Do=n(e),Pt=p(e,"P",{"data-svelte-h":!0}),o(Pt)!=="svelte-s10qq4"&&(Pt.innerHTML=_y),qo=n(e),Ht=p(e,"UL",{"data-svelte-h":!0}),o(Ht)!=="svelte-svwcak"&&(Ht.innerHTML=$y),Oo=n(e),Ko=p(e,"HR",{}),ed=n(e),Et=p(e,"A",{id:!0,class:!0}),u(Et).forEach(l),td=n(e),r(Wt.$$.fragment,e),ld=n(e),Xt=p(e,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-1n1xlcl"&&(Xt.textContent=Ry),sd=n(e),zt=p(e,"TABLE",{"data-svelte-h":!0}),o(zt)!=="svelte-1h8f"&&(zt.innerHTML=Vy),id=n(e),nd=p(e,"HR",{}),ad=n(e),St=p(e,"A",{id:!0,class:!0}),u(St).forEach(l),pd=n(e),r(Lt.$$.fragment,e),od=n(e),Ft=p(e,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-c8gx4u"&&(Ft.innerHTML=Yy),dd=n(e),Dt=p(e,"TABLE",{"data-svelte-h":!0}),o(Dt)!=="svelte-y9oo3q"&&(Dt.innerHTML=Py),cd=n(e),rd=p(e,"HR",{}),Md=n(e),qt=p(e,"A",{id:!0,class:!0}),u(qt).forEach(l),md=n(e),r(Ot.$$.fragment,e),Td=n(e),Kt=p(e,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-tzucv0"&&(Kt.textContent=Hy),yd=n(e),el=p(e,"P",{"data-svelte-h":!0}),o(el)!=="svelte-zrdgvs"&&(el.innerHTML=Ey),ud=n(e),r(tl.$$.fragment,e),Jd=n(e),ll=p(e,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-et9i9m"&&(ll.innerHTML=Wy),hd=n(e),r(sl.$$.fragment,e),wd=n(e),il=p(e,"P",{"data-svelte-h":!0}),o(il)!=="svelte-162t9ct"&&(il.innerHTML=Xy),jd=n(e),r(nl.$$.fragment,e),Ud=n(e),al=p(e,"P",{"data-svelte-h":!0}),o(al)!=="svelte-s10qq4"&&(al.innerHTML=zy),fd=n(e),bd=p(e,"HR",{}),xd=n(e),pl=p(e,"A",{id:!0,class:!0}),u(pl).forEach(l),Cd=n(e),r(ol.$$.fragment,e),gd=n(e),dl=p(e,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-11eoigb"&&(dl.textContent=Sy),Id=n(e),cl=p(e,"P",{"data-svelte-h":!0}),o(cl)!=="svelte-un4fzt"&&(cl.innerHTML=Ly),kd=n(e),rl=p(e,"TABLE",{"data-svelte-h":!0}),o(rl)!=="svelte-1qj38gf"&&(rl.innerHTML=Fy),Gd=n(e),Zd=p(e,"HR",{}),Bd=n(e),Ml=p(e,"A",{id:!0,class:!0}),u(Ml).forEach(l),Qd=n(e),r(ml.$$.fragment,e),vd=n(e),Tl=p(e,"P",{"data-svelte-h":!0}),o(Tl)!=="svelte-9xhkxa"&&(Tl.innerHTML=Dy),Nd=n(e),yl=p(e,"P",{"data-svelte-h":!0}),o(yl)!=="svelte-gobmso"&&(yl.innerHTML=qy),Ad=n(e),r(ul.$$.fragment,e),_d=n(e),Jl=p(e,"P",{"data-svelte-h":!0}),o(Jl)!=="svelte-s10qq4"&&(Jl.innerHTML=Oy),$d=n(e),hl=p(e,"UL",{"data-svelte-h":!0}),o(hl)!=="svelte-fjr04l"&&(hl.innerHTML=Ky),Rd=n(e),Vd=p(e,"HR",{}),Yd=n(e),wl=p(e,"A",{id:!0,class:!0}),u(wl).forEach(l),Pd=n(e),r(jl.$$.fragment,e),Hd=n(e),Ul=p(e,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-1enract"&&(Ul.textContent=eu),Ed=n(e),fl=p(e,"TABLE",{"data-svelte-h":!0}),o(fl)!=="svelte-dgeggs"&&(fl.innerHTML=tu),Wd=n(e),Xd=p(e,"HR",{}),zd=n(e),bl=p(e,"A",{id:!0,class:!0}),u(bl).forEach(l),Sd=n(e),r(xl.$$.fragment,e),Ld=n(e),Cl=p(e,"P",{"data-svelte-h":!0}),o(Cl)!=="svelte-19qhuwa"&&(Cl.textContent=lu),Fd=n(e),gl=p(e,"P",{"data-svelte-h":!0}),o(gl)!=="svelte-1gq3dbn"&&(gl.innerHTML=su),Dd=n(e),Il=p(e,"TABLE",{"data-svelte-h":!0}),o(Il)!=="svelte-17m2nm1"&&(Il.innerHTML=iu),qd=n(e),Od=p(e,"HR",{}),Kd=n(e),kl=p(e,"A",{id:!0,class:!0}),u(kl).forEach(l),ec=n(e),r(Gl.$$.fragment,e),tc=n(e),Zl=p(e,"P",{"data-svelte-h":!0}),o(Zl)!=="svelte-vm8asa"&&(Zl.textContent=nu),lc=n(e),Bl=p(e,"P",{"data-svelte-h":!0}),o(Bl)!=="svelte-p9nqmy"&&(Bl.innerHTML=au),sc=n(e),r(Ql.$$.fragment,e),ic=n(e),vl=p(e,"P",{"data-svelte-h":!0}),o(vl)!=="svelte-1xb4yln"&&(vl.innerHTML=pu),nc=n(e),r(Nl.$$.fragment,e),ac=n(e),Al=p(e,"P",{"data-svelte-h":!0}),o(Al)!=="svelte-aly754"&&(Al.innerHTML=ou),pc=n(e),r(_l.$$.fragment,e),oc=n(e),$l=p(e,"P",{"data-svelte-h":!0}),o($l)!=="svelte-127z1r2"&&($l.innerHTML=du),dc=n(e),r(Rl.$$.fragment,e),cc=n(e),Vl=p(e,"P",{"data-svelte-h":!0}),o(Vl)!=="svelte-5ad2vc"&&(Vl.innerHTML=cu),rc=n(e),r(Yl.$$.fragment,e),Mc=n(e),Pl=p(e,"P",{"data-svelte-h":!0}),o(Pl)!=="svelte-1ybp4y9"&&(Pl.innerHTML=ru),mc=n(e),r(Hl.$$.fragment,e),Tc=n(e),El=p(e,"P",{"data-svelte-h":!0}),o(El)!=="svelte-s10qq4"&&(El.innerHTML=Mu),yc=n(e),Wl=p(e,"UL",{"data-svelte-h":!0}),o(Wl)!=="svelte-32csn1"&&(Wl.innerHTML=mu),uc=n(e),Jc=p(e,"HR",{}),hc=n(e),Xl=p(e,"A",{id:!0,class:!0}),u(Xl).forEach(l),wc=n(e),r(zl.$$.fragment,e),jc=n(e),Sl=p(e,"P",{"data-svelte-h":!0}),o(Sl)!=="svelte-1kkefov"&&(Sl.textContent=Tu),Uc=n(e),Ll=p(e,"TABLE",{"data-svelte-h":!0}),o(Ll)!=="svelte-1a94q5m"&&(Ll.innerHTML=yu),fc=n(e),bc=p(e,"HR",{}),xc=n(e),Fl=p(e,"A",{id:!0,class:!0}),u(Fl).forEach(l),Cc=n(e),r(Dl.$$.fragment,e),gc=n(e),ql=p(e,"P",{"data-svelte-h":!0}),o(ql)!=="svelte-d8vj38"&&(ql.textContent=uu),Ic=n(e),Ol=p(e,"P",{"data-svelte-h":!0}),o(Ol)!=="svelte-hgdjqs"&&(Ol.innerHTML=Ju),kc=n(e),Kl=p(e,"TABLE",{"data-svelte-h":!0}),o(Kl)!=="svelte-1usuiaq"&&(Kl.innerHTML=hu),Gc=n(e),Zc=p(e,"HR",{}),Bc=n(e),es=p(e,"A",{id:!0,class:!0}),u(es).forEach(l),Qc=n(e),r(ts.$$.fragment,e),vc=n(e),ls=p(e,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-yuzbfo"&&(ls.innerHTML=wu),Nc=n(e),ss=p(e,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-gwolyd"&&(ss.innerHTML=ju),Ac=n(e),r(is.$$.fragment,e),_c=n(e),ns=p(e,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-vvjehq"&&(ns.innerHTML=Uu),$c=n(e),r(as.$$.fragment,e),Rc=n(e),ps=p(e,"P",{"data-svelte-h":!0}),o(ps)!=="svelte-s10qq4"&&(ps.innerHTML=fu),Vc=n(e),os=p(e,"UL",{"data-svelte-h":!0}),o(os)!=="svelte-3k2o01"&&(os.innerHTML=bu),Yc=n(e),Pc=p(e,"HR",{}),Hc=n(e),ds=p(e,"A",{id:!0,class:!0}),u(ds).forEach(l),Ec=n(e),r(cs.$$.fragment,e),Wc=n(e),rs=p(e,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-10qze5e"&&(rs.textContent=xu),Xc=n(e),Ms=p(e,"TABLE",{"data-svelte-h":!0}),o(Ms)!=="svelte-1a94q5m"&&(Ms.innerHTML=Cu),zc=n(e),Sc=p(e,"HR",{}),Lc=n(e),ms=p(e,"A",{id:!0,class:!0}),u(ms).forEach(l),Fc=n(e),r(Ts.$$.fragment,e),Dc=n(e),ys=p(e,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-ypfmt8"&&(ys.textContent=gu),qc=n(e),us=p(e,"P",{"data-svelte-h":!0}),o(us)!=="svelte-sv0g8q"&&(us.innerHTML=Iu),Oc=n(e),Js=p(e,"TABLE",{"data-svelte-h":!0}),o(Js)!=="svelte-1d2oy3p"&&(Js.innerHTML=ku),Kc=n(e),er=p(e,"HR",{}),tr=n(e),hs=p(e,"A",{id:!0,class:!0}),u(hs).forEach(l),lr=n(e),r(ws.$$.fragment,e),sr=n(e),js=p(e,"P",{"data-svelte-h":!0}),o(js)!=="svelte-w5osnc"&&(js.innerHTML=Gu),ir=n(e),Us=p(e,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-1h4310j"&&(Us.innerHTML=Zu),nr=n(e),r(fs.$$.fragment,e),ar=n(e),bs=p(e,"P",{"data-svelte-h":!0}),o(bs)!=="svelte-xv6hak"&&(bs.innerHTML=Bu),pr=n(e),r(xs.$$.fragment,e),or=n(e),Cs=p(e,"P",{"data-svelte-h":!0}),o(Cs)!=="svelte-1ids6l"&&(Cs.innerHTML=Qu),dr=n(e),r(gs.$$.fragment,e),cr=n(e),Is=p(e,"P",{"data-svelte-h":!0}),o(Is)!=="svelte-s10qq4"&&(Is.innerHTML=vu),rr=n(e),ks=p(e,"UL",{"data-svelte-h":!0}),o(ks)!=="svelte-z3581k"&&(ks.innerHTML=Nu),Mr=n(e),mr=p(e,"HR",{}),Tr=n(e),Gs=p(e,"A",{id:!0,class:!0}),u(Gs).forEach(l),yr=n(e),r(Zs.$$.fragment,e),ur=n(e),Bs=p(e,"P",{"data-svelte-h":!0}),o(Bs)!=="svelte-71b02w"&&(Bs.textContent=Au),Jr=n(e),Qs=p(e,"TABLE",{"data-svelte-h":!0}),o(Qs)!=="svelte-dgeggs"&&(Qs.innerHTML=_u),hr=n(e),wr=p(e,"HR",{}),jr=n(e),vs=p(e,"A",{id:!0,class:!0}),u(vs).forEach(l),Ur=n(e),r(Ns.$$.fragment,e),fr=n(e),As=p(e,"P",{"data-svelte-h":!0}),o(As)!=="svelte-1rpepg8"&&(As.textContent=$u),br=n(e),_s=p(e,"P",{"data-svelte-h":!0}),o(_s)!=="svelte-zgzruq"&&(_s.innerHTML=Ru),xr=n(e),$s=p(e,"TABLE",{"data-svelte-h":!0}),o($s)!=="svelte-17j2fmt"&&($s.innerHTML=Vu),Cr=n(e),gr=p(e,"HR",{}),Ir=n(e),Rs=p(e,"A",{id:!0,class:!0}),u(Rs).forEach(l),kr=n(e),r(Vs.$$.fragment,e),Gr=n(e),Ys=p(e,"P",{"data-svelte-h":!0}),o(Ys)!=="svelte-1rwi35s"&&(Ys.innerHTML=Yu),Zr=n(e),Ps=p(e,"P",{"data-svelte-h":!0}),o(Ps)!=="svelte-1tpbwb6"&&(Ps.innerHTML=Pu),Br=n(e),r(Hs.$$.fragment,e),Qr=n(e),Es=p(e,"P",{"data-svelte-h":!0}),o(Es)!=="svelte-s10qq4"&&(Es.innerHTML=Hu),vr=n(e),Ws=p(e,"UL",{"data-svelte-h":!0}),o(Ws)!=="svelte-1n3ebqn"&&(Ws.innerHTML=Eu),Nr=n(e),Ar=p(e,"HR",{}),_r=n(e),Xs=p(e,"A",{id:!0,class:!0}),u(Xs).forEach(l),$r=n(e),r(zs.$$.fragment,e),Rr=n(e),Ss=p(e,"P",{"data-svelte-h":!0}),o(Ss)!=="svelte-1ctgtyq"&&(Ss.textContent=Wu),Vr=n(e),Ls=p(e,"TABLE",{"data-svelte-h":!0}),o(Ls)!=="svelte-dgeggs"&&(Ls.innerHTML=Xu),Yr=n(e),Pr=p(e,"HR",{}),Hr=n(e),Fs=p(e,"A",{id:!0,class:!0}),u(Fs).forEach(l),Er=n(e),r(Ds.$$.fragment,e),Wr=n(e),qs=p(e,"P",{"data-svelte-h":!0}),o(qs)!=="svelte-1v51wpq"&&(qs.textContent=zu),Xr=n(e),Os=p(e,"P",{"data-svelte-h":!0}),o(Os)!=="svelte-7em0sw"&&(Os.innerHTML=Su),zr=n(e),Ks=p(e,"TABLE",{"data-svelte-h":!0}),o(Ks)!=="svelte-usc03t"&&(Ks.innerHTML=Lu),Sr=n(e),Lr=p(e,"HR",{}),Fr=n(e),ei=p(e,"A",{id:!0,class:!0}),u(ei).forEach(l),Dr=n(e),r(ti.$$.fragment,e),qr=n(e),li=p(e,"P",{"data-svelte-h":!0}),o(li)!=="svelte-20dgme"&&(li.innerHTML=Fu),Or=n(e),si=p(e,"P",{"data-svelte-h":!0}),o(si)!=="svelte-eob2i5"&&(si.innerHTML=Du),Kr=n(e),r(ii.$$.fragment,e),eM=n(e),ni=p(e,"P",{"data-svelte-h":!0}),o(ni)!=="svelte-s10qq4"&&(ni.innerHTML=qu),tM=n(e),ai=p(e,"UL",{"data-svelte-h":!0}),o(ai)!=="svelte-1psrxkl"&&(ai.innerHTML=Ou),lM=n(e),sM=p(e,"HR",{}),iM=n(e),pi=p(e,"A",{id:!0,class:!0}),u(pi).forEach(l),nM=n(e),r(oi.$$.fragment,e),aM=n(e),di=p(e,"P",{"data-svelte-h":!0}),o(di)!=="svelte-3wys82"&&(di.textContent=Ku),pM=n(e),ci=p(e,"TABLE",{"data-svelte-h":!0}),o(ci)!=="svelte-1a94q5m"&&(ci.innerHTML=eJ),oM=n(e),dM=p(e,"HR",{}),cM=n(e),ri=p(e,"A",{id:!0,class:!0}),u(ri).forEach(l),rM=n(e),r(Mi.$$.fragment,e),MM=n(e),mi=p(e,"P",{"data-svelte-h":!0}),o(mi)!=="svelte-g4x6jx"&&(mi.textContent=tJ),mM=n(e),Ti=p(e,"P",{"data-svelte-h":!0}),o(Ti)!=="svelte-zhb55f"&&(Ti.innerHTML=lJ),TM=n(e),yi=p(e,"TABLE",{"data-svelte-h":!0}),o(yi)!=="svelte-tncnks"&&(yi.innerHTML=sJ),yM=n(e),uM=p(e,"HR",{}),JM=n(e),ui=p(e,"A",{id:!0,class:!0}),u(ui).forEach(l),hM=n(e),r(Ji.$$.fragment,e),wM=n(e),hi=p(e,"P",{"data-svelte-h":!0}),o(hi)!=="svelte-11wm84h"&&(hi.innerHTML=iJ),jM=n(e),wi=p(e,"P",{"data-svelte-h":!0}),o(wi)!=="svelte-yzldbw"&&(wi.innerHTML=nJ),UM=n(e),r(ji.$$.fragment,e),fM=n(e),Ui=p(e,"P",{"data-svelte-h":!0}),o(Ui)!=="svelte-s10qq4"&&(Ui.innerHTML=aJ),bM=n(e),fi=p(e,"UL",{"data-svelte-h":!0}),o(fi)!=="svelte-1kysuxh"&&(fi.innerHTML=pJ),xM=n(e),CM=p(e,"HR",{}),gM=n(e),bi=p(e,"A",{id:!0,class:!0}),u(bi).forEach(l),IM=n(e),r(xi.$$.fragment,e),kM=n(e),Ci=p(e,"P",{"data-svelte-h":!0}),o(Ci)!=="svelte-1la8w69"&&(Ci.textContent=oJ),GM=n(e),gi=p(e,"TABLE",{"data-svelte-h":!0}),o(gi)!=="svelte-dgeggs"&&(gi.innerHTML=dJ),ZM=n(e),BM=p(e,"HR",{}),QM=n(e),Ii=p(e,"A",{id:!0,class:!0}),u(Ii).forEach(l),vM=n(e),r(ki.$$.fragment,e),NM=n(e),Gi=p(e,"P",{"data-svelte-h":!0}),o(Gi)!=="svelte-1ws18e1"&&(Gi.textContent=cJ),AM=n(e),Zi=p(e,"P",{"data-svelte-h":!0}),o(Zi)!=="svelte-i9mudt"&&(Zi.innerHTML=rJ),_M=n(e),Bi=p(e,"TABLE",{"data-svelte-h":!0}),o(Bi)!=="svelte-th688q"&&(Bi.innerHTML=MJ),$M=n(e),RM=p(e,"HR",{}),VM=n(e),Qi=p(e,"A",{id:!0,class:!0}),u(Qi).forEach(l),YM=n(e),r(vi.$$.fragment,e),PM=n(e),Ni=p(e,"P",{"data-svelte-h":!0}),o(Ni)!=="svelte-iv1c6p"&&(Ni.innerHTML=mJ),HM=n(e),Ai=p(e,"P",{"data-svelte-h":!0}),o(Ai)!=="svelte-1mtx2cy"&&(Ai.innerHTML=TJ),EM=n(e),r(_i.$$.fragment,e),WM=n(e),$i=p(e,"P",{"data-svelte-h":!0}),o($i)!=="svelte-s10qq4"&&($i.innerHTML=yJ),XM=n(e),Ri=p(e,"UL",{"data-svelte-h":!0}),o(Ri)!=="svelte-1x43yje"&&(Ri.innerHTML=uJ),zM=n(e),SM=p(e,"HR",{}),LM=n(e),Vi=p(e,"A",{id:!0,class:!0}),u(Vi).forEach(l),FM=n(e),r(Yi.$$.fragment,e),DM=n(e),Pi=p(e,"P",{"data-svelte-h":!0}),o(Pi)!=="svelte-at8fug"&&(Pi.textContent=JJ),qM=n(e),Hi=p(e,"TABLE",{"data-svelte-h":!0}),o(Hi)!=="svelte-1a94q5m"&&(Hi.innerHTML=hJ),OM=n(e),KM=p(e,"HR",{}),em=n(e),Ei=p(e,"A",{id:!0,class:!0}),u(Ei).forEach(l),tm=n(e),r(Wi.$$.fragment,e),lm=n(e),Xi=p(e,"P",{"data-svelte-h":!0}),o(Xi)!=="svelte-bu7lod"&&(Xi.textContent=wJ),sm=n(e),zi=p(e,"P",{"data-svelte-h":!0}),o(zi)!=="svelte-1or1fiw"&&(zi.innerHTML=jJ),im=n(e),Si=p(e,"TABLE",{"data-svelte-h":!0}),o(Si)!=="svelte-55abd5"&&(Si.innerHTML=UJ),nm=n(e),am=p(e,"HR",{}),pm=n(e),Li=p(e,"A",{id:!0,class:!0}),u(Li).forEach(l),om=n(e),r(Fi.$$.fragment,e),dm=n(e),Di=p(e,"P",{"data-svelte-h":!0}),o(Di)!=="svelte-1nzvfes"&&(Di.innerHTML=fJ),cm=n(e),qi=p(e,"P",{"data-svelte-h":!0}),o(qi)!=="svelte-1qq0cp9"&&(qi.innerHTML=bJ),rm=n(e),r(Oi.$$.fragment,e),Mm=n(e),Ki=p(e,"P",{"data-svelte-h":!0}),o(Ki)!=="svelte-1mslt41"&&(Ki.innerHTML=xJ),mm=n(e),r(en.$$.fragment,e),Tm=n(e),tn=p(e,"P",{"data-svelte-h":!0}),o(tn)!=="svelte-s10qq4"&&(tn.innerHTML=CJ),ym=n(e),ln=p(e,"UL",{"data-svelte-h":!0}),o(ln)!=="svelte-1p37gsh"&&(ln.innerHTML=gJ),um=n(e),Jm=p(e,"HR",{}),hm=n(e),sn=p(e,"A",{id:!0,class:!0}),u(sn).forEach(l),wm=n(e),r(nn.$$.fragment,e),jm=n(e),an=p(e,"P",{"data-svelte-h":!0}),o(an)!=="svelte-ipwl63"&&(an.textContent=IJ),Um=n(e),pn=p(e,"TABLE",{"data-svelte-h":!0}),o(pn)!=="svelte-11vehfm"&&(pn.innerHTML=kJ),fm=n(e),bm=p(e,"HR",{}),xm=n(e),on=p(e,"A",{id:!0,class:!0}),u(on).forEach(l),Cm=n(e),r(dn.$$.fragment,e),gm=n(e),cn=p(e,"P",{"data-svelte-h":!0}),o(cn)!=="svelte-1a4c4hr"&&(cn.textContent=GJ),Im=n(e),rn=p(e,"P",{"data-svelte-h":!0}),o(rn)!=="svelte-70tp0b"&&(rn.innerHTML=ZJ),km=n(e),Mn=p(e,"TABLE",{"data-svelte-h":!0}),o(Mn)!=="svelte-1hspmv9"&&(Mn.innerHTML=BJ),Gm=n(e),Zm=p(e,"HR",{}),Bm=n(e),mn=p(e,"A",{id:!0,class:!0}),u(mn).forEach(l),Qm=n(e),r(Tn.$$.fragment,e),vm=n(e),yn=p(e,"P",{"data-svelte-h":!0}),o(yn)!=="svelte-1y1a6n"&&(yn.innerHTML=QJ),Nm=n(e),un=p(e,"P",{"data-svelte-h":!0}),o(un)!=="svelte-el75jg"&&(un.innerHTML=vJ),Am=n(e),r(Jn.$$.fragment,e),_m=n(e),hn=p(e,"P",{"data-svelte-h":!0}),o(hn)!=="svelte-s10qq4"&&(hn.innerHTML=NJ),$m=n(e),Rm=p(e,"HR",{}),Vm=n(e),wn=p(e,"A",{id:!0,class:!0}),u(wn).forEach(l),Ym=n(e),r(jn.$$.fragment,e),Pm=n(e),Un=p(e,"P",{"data-svelte-h":!0}),o(Un)!=="svelte-1ega32d"&&(Un.textContent=AJ),Hm=n(e),fn=p(e,"P",{"data-svelte-h":!0}),o(fn)!=="svelte-mkrlem"&&(fn.innerHTML=_J),Em=n(e),bn=p(e,"TABLE",{"data-svelte-h":!0}),o(bn)!=="svelte-1l7b6wj"&&(bn.innerHTML=$J),Wm=n(e),Xm=p(e,"HR",{}),zm=n(e),xn=p(e,"A",{id:!0,class:!0}),u(xn).forEach(l),Sm=n(e),r(Cn.$$.fragment,e),Lm=n(e),gn=p(e,"P",{"data-svelte-h":!0}),o(gn)!=="svelte-mcsd8f"&&(gn.innerHTML=RJ),Fm=n(e),In=p(e,"P",{"data-svelte-h":!0}),o(In)!=="svelte-lb0vbj"&&(In.innerHTML=VJ),Dm=n(e),kn=p(e,"UL",{"data-svelte-h":!0}),o(kn)!=="svelte-wk6owh"&&(kn.innerHTML=YJ),qm=n(e),Gn=p(e,"TABLE",{"data-svelte-h":!0}),o(Gn)!=="svelte-1hm9kaq"&&(Gn.innerHTML=PJ),Om=n(e),Km=p(e,"HR",{}),eT=n(e),Zn=p(e,"A",{id:!0,class:!0}),u(Zn).forEach(l),tT=n(e),r(Bn.$$.fragment,e),lT=n(e),Qn=p(e,"P",{"data-svelte-h":!0}),o(Qn)!=="svelte-ptv3i7"&&(Qn.innerHTML=HJ),sT=n(e),vn=p(e,"TABLE",{"data-svelte-h":!0}),o(vn)!=="svelte-2eqjop"&&(vn.innerHTML=EJ),iT=n(e),nT=p(e,"HR",{}),aT=n(e),Nn=p(e,"A",{id:!0,class:!0}),u(Nn).forEach(l),pT=n(e),r(An.$$.fragment,e),oT=n(e),_n=p(e,"P",{"data-svelte-h":!0}),o(_n)!=="svelte-1axcw5l"&&(_n.innerHTML=WJ),dT=n(e),cT=p(e,"HR",{}),rT=n(e),$n=p(e,"A",{id:!0,class:!0}),u($n).forEach(l),MT=n(e),r(Rn.$$.fragment,e),mT=n(e),Vn=p(e,"P",{"data-svelte-h":!0}),o(Vn)!=="svelte-1axcw5l"&&(Vn.innerHTML=XJ),TT=n(e),Yn=p(e,"TABLE",{"data-svelte-h":!0}),o(Yn)!=="svelte-flnl7b"&&(Yn.innerHTML=zJ),yT=n(e),uT=p(e,"HR",{}),JT=n(e),Hn=p(e,"P",{}),u(Hn).forEach(l),this.h()},h(){d(w,"name","hf:doc:metadata"),d(w,"content",th),d(j,"id","module_pipelines"),d(j,"class","group"),d(g,"id","module_pipelines.Pipeline"),d(g,"class","group"),d(B,"id","new_module_pipelines.Pipeline_new"),d(B,"class","group"),d(A,"id","module_pipelines.Pipeline+dispose"),d(A,"class","group"),d(V,"id","module_pipelines.Pipeline+_call"),d(V,"class","group"),d(W,"id","module_pipelines.TextClassificationPipeline"),d(W,"class","group"),d(ee,"id","module_pipelines.TextClassificationPipeline+_call"),d(ee,"class","group"),d(ne,"id","module_pipelines.TokenClassificationPipeline"),d(ne,"class","group"),d(me,"id","module_pipelines.TokenClassificationPipeline+_call"),d(me,"class","group"),d(he,"id","module_pipelines.QuestionAnsweringPipeline"),d(he,"class","group"),d(xe,"id","module_pipelines.QuestionAnsweringPipeline+_call"),d(xe,"class","group"),d(Ge,"id","module_pipelines.FillMaskPipeline"),d(Ge,"class","group"),d($e,"id","module_pipelines.FillMaskPipeline+_call"),d($e,"class","group"),d(He,"id","module_pipelines.Text2TextGenerationPipeline"),d(He,"class","group"),d(Le,"id","module_pipelines.Text2TextGenerationPipeline+_call"),d(Le,"class","group"),d(et,"id","module_pipelines.SummarizationPipeline"),d(et,"class","group"),d(at,"id","module_pipelines.TranslationPipeline"),d(at,"class","group"),d(wt,"id","module_pipelines.TextGenerationPipeline"),d(wt,"class","group"),d(Gt,"id","module_pipelines.TextGenerationPipeline+_call"),d(Gt,"class","group"),d(Nt,"id","module_pipelines.ZeroShotClassificationPipeline"),d(Nt,"class","group"),d(Et,"id","new_module_pipelines.ZeroShotClassificationPipeline_new"),d(Et,"class","group"),d(St,"id","module_pipelines.ZeroShotClassificationPipeline+_call"),d(St,"class","group"),d(qt,"id","module_pipelines.FeatureExtractionPipeline"),d(qt,"class","group"),d(pl,"id","module_pipelines.FeatureExtractionPipeline+_call"),d(pl,"class","group"),d(Ml,"id","module_pipelines.AudioClassificationPipeline"),d(Ml,"class","group"),d(wl,"id","new_module_pipelines.AudioClassificationPipeline_new"),d(wl,"class","group"),d(bl,"id","module_pipelines.AudioClassificationPipeline+_call"),d(bl,"class","group"),d(kl,"id","module_pipelines.AutomaticSpeechRecognitionPipeline"),d(kl,"class","group"),d(Xl,"id","new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"),d(Xl,"class","group"),d(Fl,"id","module_pipelines.AutomaticSpeechRecognitionPipeline+_call"),d(Fl,"class","group"),d(es,"id","module_pipelines.ImageToTextPipeline"),d(es,"class","group"),d(ds,"id","new_module_pipelines.ImageToTextPipeline_new"),d(ds,"class","group"),d(ms,"id","module_pipelines.ImageToTextPipeline+_call"),d(ms,"class","group"),d(hs,"id","module_pipelines.ImageClassificationPipeline"),d(hs,"class","group"),d(Gs,"id","new_module_pipelines.ImageClassificationPipeline_new"),d(Gs,"class","group"),d(vs,"id","module_pipelines.ImageClassificationPipeline+_call"),d(vs,"class","group"),d(Rs,"id","module_pipelines.ImageSegmentationPipeline"),d(Rs,"class","group"),d(Xs,"id","new_module_pipelines.ImageSegmentationPipeline_new"),d(Xs,"class","group"),d(Fs,"id","module_pipelines.ImageSegmentationPipeline+_call"),d(Fs,"class","group"),d(ei,"id","module_pipelines.ZeroShotImageClassificationPipeline"),d(ei,"class","group"),d(pi,"id","new_module_pipelines.ZeroShotImageClassificationPipeline_new"),d(pi,"class","group"),d(ri,"id","module_pipelines.ZeroShotImageClassificationPipeline+_call"),d(ri,"class","group"),d(ui,"id","module_pipelines.ObjectDetectionPipeline"),d(ui,"class","group"),d(bi,"id","new_module_pipelines.ObjectDetectionPipeline_new"),d(bi,"class","group"),d(Ii,"id","module_pipelines.ObjectDetectionPipeline+_call"),d(Ii,"class","group"),d(Qi,"id","module_pipelines.DocumentQuestionAnsweringPipeline"),d(Qi,"class","group"),d(Vi,"id","new_module_pipelines.DocumentQuestionAnsweringPipeline_new"),d(Vi,"class","group"),d(Ei,"id","module_pipelines.DocumentQuestionAnsweringPipeline+_call"),d(Ei,"class","group"),d(Li,"id","module_pipelines.TextToAudioPipeline"),d(Li,"class","group"),d(sn,"id","new_module_pipelines.TextToAudioPipeline_new"),d(sn,"class","group"),d(on,"id","module_pipelines.TextToAudioPipeline+_call"),d(on,"class","group"),d(mn,"id","module_pipelines.ImageToImagePipeline"),d(mn,"class","group"),d(wn,"id","module_pipelines.ImageToImagePipeline+_call"),d(wn,"class","group"),d(xn,"id","module_pipelines.pipeline"),d(xn,"class","group"),d(Zn,"id","module_pipelines..QuestionAnsweringResult"),d(Zn,"class","group"),d(Nn,"id","module_pipelines..QuestionAnsweringReturnType"),d(Nn,"class","group"),d($n,"id","module_pipelines..ChunkCallback"),d($n,"class","group")},m(e,t){KJ(document.head,w),s(e,En,t),s(e,Pn,t),s(e,Wn,t),s(e,j,t),s(e,Xn,t),M(U,e,t),s(e,zn,t),s(e,f,t),s(e,Sn,t),s(e,b,t),s(e,Ln,t),M(x,e,t),s(e,Fn,t),s(e,C,t),s(e,Dn,t),s(e,qn,t),s(e,On,t),s(e,g,t),s(e,Kn,t),M(I,e,t),s(e,ea,t),s(e,k,t),s(e,ta,t),s(e,G,t),s(e,la,t),s(e,Z,t),s(e,sa,t),s(e,ia,t),s(e,na,t),s(e,B,t),s(e,aa,t),M(Q,e,t),s(e,pa,t),s(e,v,t),s(e,oa,t),s(e,N,t),s(e,da,t),s(e,ca,t),s(e,ra,t),s(e,A,t),s(e,Ma,t),M(_,e,t),s(e,ma,t),s(e,$,t),s(e,Ta,t),s(e,R,t),s(e,ya,t),s(e,ua,t),s(e,Ja,t),s(e,V,t),s(e,ha,t),M(Y,e,t),s(e,wa,t),s(e,P,t),s(e,ja,t),s(e,H,t),s(e,Ua,t),s(e,E,t),s(e,fa,t),s(e,ba,t),s(e,xa,t),s(e,W,t),s(e,Ca,t),M(X,e,t),s(e,ga,t),s(e,z,t),s(e,Ia,t),s(e,S,t),s(e,ka,t),M(L,e,t),s(e,Ga,t),s(e,F,t),s(e,Za,t),M(D,e,t),s(e,Ba,t),s(e,q,t),s(e,Qa,t),M(O,e,t),s(e,va,t),s(e,K,t),s(e,Na,t),s(e,Aa,t),s(e,_a,t),s(e,ee,t),s(e,$a,t),M(te,e,t),s(e,Ra,t),s(e,le,t),s(e,Va,t),s(e,se,t),s(e,Ya,t),s(e,ie,t),s(e,Pa,t),s(e,Ha,t),s(e,Ea,t),s(e,ne,t),s(e,Wa,t),M(ae,e,t),s(e,Xa,t),s(e,pe,t),s(e,za,t),s(e,oe,t),s(e,Sa,t),M(de,e,t),s(e,La,t),s(e,ce,t),s(e,Fa,t),M(re,e,t),s(e,Da,t),s(e,Me,t),s(e,qa,t),s(e,Oa,t),s(e,Ka,t),s(e,me,t),s(e,ep,t),M(Te,e,t),s(e,tp,t),s(e,ye,t),s(e,lp,t),s(e,ue,t),s(e,sp,t),s(e,Je,t),s(e,ip,t),s(e,np,t),s(e,ap,t),s(e,he,t),s(e,pp,t),M(we,e,t),s(e,op,t),s(e,je,t),s(e,dp,t),s(e,Ue,t),s(e,cp,t),M(fe,e,t),s(e,rp,t),s(e,be,t),s(e,Mp,t),s(e,mp,t),s(e,Tp,t),s(e,xe,t),s(e,yp,t),M(Ce,e,t),s(e,up,t),s(e,ge,t),s(e,Jp,t),s(e,Ie,t),s(e,hp,t),s(e,ke,t),s(e,wp,t),s(e,jp,t),s(e,Up,t),s(e,Ge,t),s(e,fp,t),M(Ze,e,t),s(e,bp,t),s(e,Be,t),s(e,xp,t),s(e,Qe,t),s(e,Cp,t),M(ve,e,t),s(e,gp,t),s(e,Ne,t),s(e,Ip,t),M(Ae,e,t),s(e,kp,t),s(e,_e,t),s(e,Gp,t),s(e,Zp,t),s(e,Bp,t),s(e,$e,t),s(e,Qp,t),M(Re,e,t),s(e,vp,t),s(e,Ve,t),s(e,Np,t),s(e,Ye,t),s(e,Ap,t),s(e,Pe,t),s(e,_p,t),s(e,$p,t),s(e,Rp,t),s(e,He,t),s(e,Vp,t),M(Ee,e,t),s(e,Yp,t),s(e,We,t),s(e,Pp,t),s(e,Xe,t),s(e,Hp,t),M(ze,e,t),s(e,Ep,t),s(e,Se,t),s(e,Wp,t),s(e,Xp,t),s(e,zp,t),s(e,Le,t),s(e,Sp,t),M(Fe,e,t),s(e,Lp,t),s(e,De,t),s(e,Fp,t),s(e,qe,t),s(e,Dp,t),s(e,Oe,t),s(e,qp,t),s(e,Ke,t),s(e,Op,t),s(e,Kp,t),s(e,eo,t),s(e,et,t),s(e,to,t),M(tt,e,t),s(e,lo,t),s(e,lt,t),s(e,so,t),s(e,st,t),s(e,io,t),M(it,e,t),s(e,no,t),s(e,nt,t),s(e,ao,t),s(e,po,t),s(e,oo,t),s(e,at,t),s(e,co,t),M(pt,e,t),s(e,ro,t),s(e,ot,t),s(e,Mo,t),s(e,dt,t),s(e,mo,t),s(e,ct,t),s(e,To,t),M(rt,e,t),s(e,yo,t),s(e,Mt,t),s(e,uo,t),s(e,mt,t),s(e,Jo,t),M(Tt,e,t),s(e,ho,t),s(e,yt,t),s(e,wo,t),s(e,ut,t),s(e,jo,t),M(Jt,e,t),s(e,Uo,t),s(e,ht,t),s(e,fo,t),s(e,bo,t),s(e,xo,t),s(e,wt,t),s(e,Co,t),M(jt,e,t),s(e,go,t),s(e,Ut,t),s(e,Io,t),s(e,ft,t),s(e,ko,t),M(bt,e,t),s(e,Go,t),s(e,xt,t),s(e,Zo,t),M(Ct,e,t),s(e,Bo,t),s(e,gt,t),s(e,Qo,t),M(It,e,t),s(e,vo,t),s(e,kt,t),s(e,No,t),s(e,Ao,t),s(e,_o,t),s(e,Gt,t),s(e,$o,t),M(Zt,e,t),s(e,Ro,t),s(e,Bt,t),s(e,Vo,t),s(e,Qt,t),s(e,Yo,t),s(e,vt,t),s(e,Po,t),s(e,Ho,t),s(e,Eo,t),s(e,Nt,t),s(e,Wo,t),M(At,e,t),s(e,Xo,t),s(e,_t,t),s(e,zo,t),s(e,$t,t),s(e,So,t),M(Rt,e,t),s(e,Lo,t),s(e,Vt,t),s(e,Fo,t),M(Yt,e,t),s(e,Do,t),s(e,Pt,t),s(e,qo,t),s(e,Ht,t),s(e,Oo,t),s(e,Ko,t),s(e,ed,t),s(e,Et,t),s(e,td,t),M(Wt,e,t),s(e,ld,t),s(e,Xt,t),s(e,sd,t),s(e,zt,t),s(e,id,t),s(e,nd,t),s(e,ad,t),s(e,St,t),s(e,pd,t),M(Lt,e,t),s(e,od,t),s(e,Ft,t),s(e,dd,t),s(e,Dt,t),s(e,cd,t),s(e,rd,t),s(e,Md,t),s(e,qt,t),s(e,md,t),M(Ot,e,t),s(e,Td,t),s(e,Kt,t),s(e,yd,t),s(e,el,t),s(e,ud,t),M(tl,e,t),s(e,Jd,t),s(e,ll,t),s(e,hd,t),M(sl,e,t),s(e,wd,t),s(e,il,t),s(e,jd,t),M(nl,e,t),s(e,Ud,t),s(e,al,t),s(e,fd,t),s(e,bd,t),s(e,xd,t),s(e,pl,t),s(e,Cd,t),M(ol,e,t),s(e,gd,t),s(e,dl,t),s(e,Id,t),s(e,cl,t),s(e,kd,t),s(e,rl,t),s(e,Gd,t),s(e,Zd,t),s(e,Bd,t),s(e,Ml,t),s(e,Qd,t),M(ml,e,t),s(e,vd,t),s(e,Tl,t),s(e,Nd,t),s(e,yl,t),s(e,Ad,t),M(ul,e,t),s(e,_d,t),s(e,Jl,t),s(e,$d,t),s(e,hl,t),s(e,Rd,t),s(e,Vd,t),s(e,Yd,t),s(e,wl,t),s(e,Pd,t),M(jl,e,t),s(e,Hd,t),s(e,Ul,t),s(e,Ed,t),s(e,fl,t),s(e,Wd,t),s(e,Xd,t),s(e,zd,t),s(e,bl,t),s(e,Sd,t),M(xl,e,t),s(e,Ld,t),s(e,Cl,t),s(e,Fd,t),s(e,gl,t),s(e,Dd,t),s(e,Il,t),s(e,qd,t),s(e,Od,t),s(e,Kd,t),s(e,kl,t),s(e,ec,t),M(Gl,e,t),s(e,tc,t),s(e,Zl,t),s(e,lc,t),s(e,Bl,t),s(e,sc,t),M(Ql,e,t),s(e,ic,t),s(e,vl,t),s(e,nc,t),M(Nl,e,t),s(e,ac,t),s(e,Al,t),s(e,pc,t),M(_l,e,t),s(e,oc,t),s(e,$l,t),s(e,dc,t),M(Rl,e,t),s(e,cc,t),s(e,Vl,t),s(e,rc,t),M(Yl,e,t),s(e,Mc,t),s(e,Pl,t),s(e,mc,t),M(Hl,e,t),s(e,Tc,t),s(e,El,t),s(e,yc,t),s(e,Wl,t),s(e,uc,t),s(e,Jc,t),s(e,hc,t),s(e,Xl,t),s(e,wc,t),M(zl,e,t),s(e,jc,t),s(e,Sl,t),s(e,Uc,t),s(e,Ll,t),s(e,fc,t),s(e,bc,t),s(e,xc,t),s(e,Fl,t),s(e,Cc,t),M(Dl,e,t),s(e,gc,t),s(e,ql,t),s(e,Ic,t),s(e,Ol,t),s(e,kc,t),s(e,Kl,t),s(e,Gc,t),s(e,Zc,t),s(e,Bc,t),s(e,es,t),s(e,Qc,t),M(ts,e,t),s(e,vc,t),s(e,ls,t),s(e,Nc,t),s(e,ss,t),s(e,Ac,t),M(is,e,t),s(e,_c,t),s(e,ns,t),s(e,$c,t),M(as,e,t),s(e,Rc,t),s(e,ps,t),s(e,Vc,t),s(e,os,t),s(e,Yc,t),s(e,Pc,t),s(e,Hc,t),s(e,ds,t),s(e,Ec,t),M(cs,e,t),s(e,Wc,t),s(e,rs,t),s(e,Xc,t),s(e,Ms,t),s(e,zc,t),s(e,Sc,t),s(e,Lc,t),s(e,ms,t),s(e,Fc,t),M(Ts,e,t),s(e,Dc,t),s(e,ys,t),s(e,qc,t),s(e,us,t),s(e,Oc,t),s(e,Js,t),s(e,Kc,t),s(e,er,t),s(e,tr,t),s(e,hs,t),s(e,lr,t),M(ws,e,t),s(e,sr,t),s(e,js,t),s(e,ir,t),s(e,Us,t),s(e,nr,t),M(fs,e,t),s(e,ar,t),s(e,bs,t),s(e,pr,t),M(xs,e,t),s(e,or,t),s(e,Cs,t),s(e,dr,t),M(gs,e,t),s(e,cr,t),s(e,Is,t),s(e,rr,t),s(e,ks,t),s(e,Mr,t),s(e,mr,t),s(e,Tr,t),s(e,Gs,t),s(e,yr,t),M(Zs,e,t),s(e,ur,t),s(e,Bs,t),s(e,Jr,t),s(e,Qs,t),s(e,hr,t),s(e,wr,t),s(e,jr,t),s(e,vs,t),s(e,Ur,t),M(Ns,e,t),s(e,fr,t),s(e,As,t),s(e,br,t),s(e,_s,t),s(e,xr,t),s(e,$s,t),s(e,Cr,t),s(e,gr,t),s(e,Ir,t),s(e,Rs,t),s(e,kr,t),M(Vs,e,t),s(e,Gr,t),s(e,Ys,t),s(e,Zr,t),s(e,Ps,t),s(e,Br,t),M(Hs,e,t),s(e,Qr,t),s(e,Es,t),s(e,vr,t),s(e,Ws,t),s(e,Nr,t),s(e,Ar,t),s(e,_r,t),s(e,Xs,t),s(e,$r,t),M(zs,e,t),s(e,Rr,t),s(e,Ss,t),s(e,Vr,t),s(e,Ls,t),s(e,Yr,t),s(e,Pr,t),s(e,Hr,t),s(e,Fs,t),s(e,Er,t),M(Ds,e,t),s(e,Wr,t),s(e,qs,t),s(e,Xr,t),s(e,Os,t),s(e,zr,t),s(e,Ks,t),s(e,Sr,t),s(e,Lr,t),s(e,Fr,t),s(e,ei,t),s(e,Dr,t),M(ti,e,t),s(e,qr,t),s(e,li,t),s(e,Or,t),s(e,si,t),s(e,Kr,t),M(ii,e,t),s(e,eM,t),s(e,ni,t),s(e,tM,t),s(e,ai,t),s(e,lM,t),s(e,sM,t),s(e,iM,t),s(e,pi,t),s(e,nM,t),M(oi,e,t),s(e,aM,t),s(e,di,t),s(e,pM,t),s(e,ci,t),s(e,oM,t),s(e,dM,t),s(e,cM,t),s(e,ri,t),s(e,rM,t),M(Mi,e,t),s(e,MM,t),s(e,mi,t),s(e,mM,t),s(e,Ti,t),s(e,TM,t),s(e,yi,t),s(e,yM,t),s(e,uM,t),s(e,JM,t),s(e,ui,t),s(e,hM,t),M(Ji,e,t),s(e,wM,t),s(e,hi,t),s(e,jM,t),s(e,wi,t),s(e,UM,t),M(ji,e,t),s(e,fM,t),s(e,Ui,t),s(e,bM,t),s(e,fi,t),s(e,xM,t),s(e,CM,t),s(e,gM,t),s(e,bi,t),s(e,IM,t),M(xi,e,t),s(e,kM,t),s(e,Ci,t),s(e,GM,t),s(e,gi,t),s(e,ZM,t),s(e,BM,t),s(e,QM,t),s(e,Ii,t),s(e,vM,t),M(ki,e,t),s(e,NM,t),s(e,Gi,t),s(e,AM,t),s(e,Zi,t),s(e,_M,t),s(e,Bi,t),s(e,$M,t),s(e,RM,t),s(e,VM,t),s(e,Qi,t),s(e,YM,t),M(vi,e,t),s(e,PM,t),s(e,Ni,t),s(e,HM,t),s(e,Ai,t),s(e,EM,t),M(_i,e,t),s(e,WM,t),s(e,$i,t),s(e,XM,t),s(e,Ri,t),s(e,zM,t),s(e,SM,t),s(e,LM,t),s(e,Vi,t),s(e,FM,t),M(Yi,e,t),s(e,DM,t),s(e,Pi,t),s(e,qM,t),s(e,Hi,t),s(e,OM,t),s(e,KM,t),s(e,em,t),s(e,Ei,t),s(e,tm,t),M(Wi,e,t),s(e,lm,t),s(e,Xi,t),s(e,sm,t),s(e,zi,t),s(e,im,t),s(e,Si,t),s(e,nm,t),s(e,am,t),s(e,pm,t),s(e,Li,t),s(e,om,t),M(Fi,e,t),s(e,dm,t),s(e,Di,t),s(e,cm,t),s(e,qi,t),s(e,rm,t),M(Oi,e,t),s(e,Mm,t),s(e,Ki,t),s(e,mm,t),M(en,e,t),s(e,Tm,t),s(e,tn,t),s(e,ym,t),s(e,ln,t),s(e,um,t),s(e,Jm,t),s(e,hm,t),s(e,sn,t),s(e,wm,t),M(nn,e,t),s(e,jm,t),s(e,an,t),s(e,Um,t),s(e,pn,t),s(e,fm,t),s(e,bm,t),s(e,xm,t),s(e,on,t),s(e,Cm,t),M(dn,e,t),s(e,gm,t),s(e,cn,t),s(e,Im,t),s(e,rn,t),s(e,km,t),s(e,Mn,t),s(e,Gm,t),s(e,Zm,t),s(e,Bm,t),s(e,mn,t),s(e,Qm,t),M(Tn,e,t),s(e,vm,t),s(e,yn,t),s(e,Nm,t),s(e,un,t),s(e,Am,t),M(Jn,e,t),s(e,_m,t),s(e,hn,t),s(e,$m,t),s(e,Rm,t),s(e,Vm,t),s(e,wn,t),s(e,Ym,t),M(jn,e,t),s(e,Pm,t),s(e,Un,t),s(e,Hm,t),s(e,fn,t),s(e,Em,t),s(e,bn,t),s(e,Wm,t),s(e,Xm,t),s(e,zm,t),s(e,xn,t),s(e,Sm,t),M(Cn,e,t),s(e,Lm,t),s(e,gn,t),s(e,Fm,t),s(e,In,t),s(e,Dm,t),s(e,kn,t),s(e,qm,t),s(e,Gn,t),s(e,Om,t),s(e,Km,t),s(e,eT,t),s(e,Zn,t),s(e,tT,t),M(Bn,e,t),s(e,lT,t),s(e,Qn,t),s(e,sT,t),s(e,vn,t),s(e,iT,t),s(e,nT,t),s(e,aT,t),s(e,Nn,t),s(e,pT,t),M(An,e,t),s(e,oT,t),s(e,_n,t),s(e,dT,t),s(e,cT,t),s(e,rT,t),s(e,$n,t),s(e,MT,t),M(Rn,e,t),s(e,mT,t),s(e,Vn,t),s(e,TT,t),s(e,Yn,t),s(e,yT,t),s(e,uT,t),s(e,JT,t),s(e,Hn,t),hT=!0},p:LJ,i(e){hT||(m(U.$$.fragment,e),m(x.$$.fragment,e),m(I.$$.fragment,e),m(Q.$$.fragment,e),m(_.$$.fragment,e),m(Y.$$.fragment,e),m(X.$$.fragment,e),m(L.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(de.$$.fragment,e),m(re.$$.fragment,e),m(Te.$$.fragment,e),m(we.$$.fragment,e),m(fe.$$.fragment,e),m(Ce.$$.fragment,e),m(Ze.$$.fragment,e),m(ve.$$.fragment,e),m(Ae.$$.fragment,e),m(Re.$$.fragment,e),m(Ee.$$.fragment,e),m(ze.$$.fragment,e),m(Fe.$$.fragment,e),m(tt.$$.fragment,e),m(it.$$.fragment,e),m(pt.$$.fragment,e),m(rt.$$.fragment,e),m(Tt.$$.fragment,e),m(Jt.$$.fragment,e),m(jt.$$.fragment,e),m(bt.$$.fragment,e),m(Ct.$$.fragment,e),m(It.$$.fragment,e),m(Zt.$$.fragment,e),m(At.$$.fragment,e),m(Rt.$$.fragment,e),m(Yt.$$.fragment,e),m(Wt.$$.fragment,e),m(Lt.$$.fragment,e),m(Ot.$$.fragment,e),m(tl.$$.fragment,e),m(sl.$$.fragment,e),m(nl.$$.fragment,e),m(ol.$$.fragment,e),m(ml.$$.fragment,e),m(ul.$$.fragment,e),m(jl.$$.fragment,e),m(xl.$$.fragment,e),m(Gl.$$.fragment,e),m(Ql.$$.fragment,e),m(Nl.$$.fragment,e),m(_l.$$.fragment,e),m(Rl.$$.fragment,e),m(Yl.$$.fragment,e),m(Hl.$$.fragment,e),m(zl.$$.fragment,e),m(Dl.$$.fragment,e),m(ts.$$.fragment,e),m(is.$$.fragment,e),m(as.$$.fragment,e),m(cs.$$.fragment,e),m(Ts.$$.fragment,e),m(ws.$$.fragment,e),m(fs.$$.fragment,e),m(xs.$$.fragment,e),m(gs.$$.fragment,e),m(Zs.$$.fragment,e),m(Ns.$$.fragment,e),m(Vs.$$.fragment,e),m(Hs.$$.fragment,e),m(zs.$$.fragment,e),m(Ds.$$.fragment,e),m(ti.$$.fragment,e),m(ii.$$.fragment,e),m(oi.$$.fragment,e),m(Mi.$$.fragment,e),m(Ji.$$.fragment,e),m(ji.$$.fragment,e),m(xi.$$.fragment,e),m(ki.$$.fragment,e),m(vi.$$.fragment,e),m(_i.$$.fragment,e),m(Yi.$$.fragment,e),m(Wi.$$.fragment,e),m(Fi.$$.fragment,e),m(Oi.$$.fragment,e),m(en.$$.fragment,e),m(nn.$$.fragment,e),m(dn.$$.fragment,e),m(Tn.$$.fragment,e),m(Jn.$$.fragment,e),m(jn.$$.fragment,e),m(Cn.$$.fragment,e),m(Bn.$$.fragment,e),m(An.$$.fragment,e),m(Rn.$$.fragment,e),hT=!0)},o(e){T(U.$$.fragment,e),T(x.$$.fragment,e),T(I.$$.fragment,e),T(Q.$$.fragment,e),T(_.$$.fragment,e),T(Y.$$.fragment,e),T(X.$$.fragment,e),T(L.$$.fragment,e),T(D.$$.fragment,e),T(O.$$.fragment,e),T(te.$$.fragment,e),T(ae.$$.fragment,e),T(de.$$.fragment,e),T(re.$$.fragment,e),T(Te.$$.fragment,e),T(we.$$.fragment,e),T(fe.$$.fragment,e),T(Ce.$$.fragment,e),T(Ze.$$.fragment,e),T(ve.$$.fragment,e),T(Ae.$$.fragment,e),T(Re.$$.fragment,e),T(Ee.$$.fragment,e),T(ze.$$.fragment,e),T(Fe.$$.fragment,e),T(tt.$$.fragment,e),T(it.$$.fragment,e),T(pt.$$.fragment,e),T(rt.$$.fragment,e),T(Tt.$$.fragment,e),T(Jt.$$.fragment,e),T(jt.$$.fragment,e),T(bt.$$.fragment,e),T(Ct.$$.fragment,e),T(It.$$.fragment,e),T(Zt.$$.fragment,e),T(At.$$.fragment,e),T(Rt.$$.fragment,e),T(Yt.$$.fragment,e),T(Wt.$$.fragment,e),T(Lt.$$.fragment,e),T(Ot.$$.fragment,e),T(tl.$$.fragment,e),T(sl.$$.fragment,e),T(nl.$$.fragment,e),T(ol.$$.fragment,e),T(ml.$$.fragment,e),T(ul.$$.fragment,e),T(jl.$$.fragment,e),T(xl.$$.fragment,e),T(Gl.$$.fragment,e),T(Ql.$$.fragment,e),T(Nl.$$.fragment,e),T(_l.$$.fragment,e),T(Rl.$$.fragment,e),T(Yl.$$.fragment,e),T(Hl.$$.fragment,e),T(zl.$$.fragment,e),T(Dl.$$.fragment,e),T(ts.$$.fragment,e),T(is.$$.fragment,e),T(as.$$.fragment,e),T(cs.$$.fragment,e),T(Ts.$$.fragment,e),T(ws.$$.fragment,e),T(fs.$$.fragment,e),T(xs.$$.fragment,e),T(gs.$$.fragment,e),T(Zs.$$.fragment,e),T(Ns.$$.fragment,e),T(Vs.$$.fragment,e),T(Hs.$$.fragment,e),T(zs.$$.fragment,e),T(Ds.$$.fragment,e),T(ti.$$.fragment,e),T(ii.$$.fragment,e),T(oi.$$.fragment,e),T(Mi.$$.fragment,e),T(Ji.$$.fragment,e),T(ji.$$.fragment,e),T(xi.$$.fragment,e),T(ki.$$.fragment,e),T(vi.$$.fragment,e),T(_i.$$.fragment,e),T(Yi.$$.fragment,e),T(Wi.$$.fragment,e),T(Fi.$$.fragment,e),T(Oi.$$.fragment,e),T(en.$$.fragment,e),T(nn.$$.fragment,e),T(dn.$$.fragment,e),T(Tn.$$.fragment,e),T(Jn.$$.fragment,e),T(jn.$$.fragment,e),T(Cn.$$.fragment,e),T(Bn.$$.fragment,e),T(An.$$.fragment,e),T(Rn.$$.fragment,e),hT=!1},d(e){e&&(l(En),l(Pn),l(Wn),l(j),l(Xn),l(zn),l(f),l(Sn),l(b),l(Ln),l(Fn),l(C),l(Dn),l(qn),l(On),l(g),l(Kn),l(ea),l(k),l(ta),l(G),l(la),l(Z),l(sa),l(ia),l(na),l(B),l(aa),l(pa),l(v),l(oa),l(N),l(da),l(ca),l(ra),l(A),l(Ma),l(ma),l($),l(Ta),l(R),l(ya),l(ua),l(Ja),l(V),l(ha),l(wa),l(P),l(ja),l(H),l(Ua),l(E),l(fa),l(ba),l(xa),l(W),l(Ca),l(ga),l(z),l(Ia),l(S),l(ka),l(Ga),l(F),l(Za),l(Ba),l(q),l(Qa),l(va),l(K),l(Na),l(Aa),l(_a),l(ee),l($a),l(Ra),l(le),l(Va),l(se),l(Ya),l(ie),l(Pa),l(Ha),l(Ea),l(ne),l(Wa),l(Xa),l(pe),l(za),l(oe),l(Sa),l(La),l(ce),l(Fa),l(Da),l(Me),l(qa),l(Oa),l(Ka),l(me),l(ep),l(tp),l(ye),l(lp),l(ue),l(sp),l(Je),l(ip),l(np),l(ap),l(he),l(pp),l(op),l(je),l(dp),l(Ue),l(cp),l(rp),l(be),l(Mp),l(mp),l(Tp),l(xe),l(yp),l(up),l(ge),l(Jp),l(Ie),l(hp),l(ke),l(wp),l(jp),l(Up),l(Ge),l(fp),l(bp),l(Be),l(xp),l(Qe),l(Cp),l(gp),l(Ne),l(Ip),l(kp),l(_e),l(Gp),l(Zp),l(Bp),l($e),l(Qp),l(vp),l(Ve),l(Np),l(Ye),l(Ap),l(Pe),l(_p),l($p),l(Rp),l(He),l(Vp),l(Yp),l(We),l(Pp),l(Xe),l(Hp),l(Ep),l(Se),l(Wp),l(Xp),l(zp),l(Le),l(Sp),l(Lp),l(De),l(Fp),l(qe),l(Dp),l(Oe),l(qp),l(Ke),l(Op),l(Kp),l(eo),l(et),l(to),l(lo),l(lt),l(so),l(st),l(io),l(no),l(nt),l(ao),l(po),l(oo),l(at),l(co),l(ro),l(ot),l(Mo),l(dt),l(mo),l(ct),l(To),l(yo),l(Mt),l(uo),l(mt),l(Jo),l(ho),l(yt),l(wo),l(ut),l(jo),l(Uo),l(ht),l(fo),l(bo),l(xo),l(wt),l(Co),l(go),l(Ut),l(Io),l(ft),l(ko),l(Go),l(xt),l(Zo),l(Bo),l(gt),l(Qo),l(vo),l(kt),l(No),l(Ao),l(_o),l(Gt),l($o),l(Ro),l(Bt),l(Vo),l(Qt),l(Yo),l(vt),l(Po),l(Ho),l(Eo),l(Nt),l(Wo),l(Xo),l(_t),l(zo),l($t),l(So),l(Lo),l(Vt),l(Fo),l(Do),l(Pt),l(qo),l(Ht),l(Oo),l(Ko),l(ed),l(Et),l(td),l(ld),l(Xt),l(sd),l(zt),l(id),l(nd),l(ad),l(St),l(pd),l(od),l(Ft),l(dd),l(Dt),l(cd),l(rd),l(Md),l(qt),l(md),l(Td),l(Kt),l(yd),l(el),l(ud),l(Jd),l(ll),l(hd),l(wd),l(il),l(jd),l(Ud),l(al),l(fd),l(bd),l(xd),l(pl),l(Cd),l(gd),l(dl),l(Id),l(cl),l(kd),l(rl),l(Gd),l(Zd),l(Bd),l(Ml),l(Qd),l(vd),l(Tl),l(Nd),l(yl),l(Ad),l(_d),l(Jl),l($d),l(hl),l(Rd),l(Vd),l(Yd),l(wl),l(Pd),l(Hd),l(Ul),l(Ed),l(fl),l(Wd),l(Xd),l(zd),l(bl),l(Sd),l(Ld),l(Cl),l(Fd),l(gl),l(Dd),l(Il),l(qd),l(Od),l(Kd),l(kl),l(ec),l(tc),l(Zl),l(lc),l(Bl),l(sc),l(ic),l(vl),l(nc),l(ac),l(Al),l(pc),l(oc),l($l),l(dc),l(cc),l(Vl),l(rc),l(Mc),l(Pl),l(mc),l(Tc),l(El),l(yc),l(Wl),l(uc),l(Jc),l(hc),l(Xl),l(wc),l(jc),l(Sl),l(Uc),l(Ll),l(fc),l(bc),l(xc),l(Fl),l(Cc),l(gc),l(ql),l(Ic),l(Ol),l(kc),l(Kl),l(Gc),l(Zc),l(Bc),l(es),l(Qc),l(vc),l(ls),l(Nc),l(ss),l(Ac),l(_c),l(ns),l($c),l(Rc),l(ps),l(Vc),l(os),l(Yc),l(Pc),l(Hc),l(ds),l(Ec),l(Wc),l(rs),l(Xc),l(Ms),l(zc),l(Sc),l(Lc),l(ms),l(Fc),l(Dc),l(ys),l(qc),l(us),l(Oc),l(Js),l(Kc),l(er),l(tr),l(hs),l(lr),l(sr),l(js),l(ir),l(Us),l(nr),l(ar),l(bs),l(pr),l(or),l(Cs),l(dr),l(cr),l(Is),l(rr),l(ks),l(Mr),l(mr),l(Tr),l(Gs),l(yr),l(ur),l(Bs),l(Jr),l(Qs),l(hr),l(wr),l(jr),l(vs),l(Ur),l(fr),l(As),l(br),l(_s),l(xr),l($s),l(Cr),l(gr),l(Ir),l(Rs),l(kr),l(Gr),l(Ys),l(Zr),l(Ps),l(Br),l(Qr),l(Es),l(vr),l(Ws),l(Nr),l(Ar),l(_r),l(Xs),l($r),l(Rr),l(Ss),l(Vr),l(Ls),l(Yr),l(Pr),l(Hr),l(Fs),l(Er),l(Wr),l(qs),l(Xr),l(Os),l(zr),l(Ks),l(Sr),l(Lr),l(Fr),l(ei),l(Dr),l(qr),l(li),l(Or),l(si),l(Kr),l(eM),l(ni),l(tM),l(ai),l(lM),l(sM),l(iM),l(pi),l(nM),l(aM),l(di),l(pM),l(ci),l(oM),l(dM),l(cM),l(ri),l(rM),l(MM),l(mi),l(mM),l(Ti),l(TM),l(yi),l(yM),l(uM),l(JM),l(ui),l(hM),l(wM),l(hi),l(jM),l(wi),l(UM),l(fM),l(Ui),l(bM),l(fi),l(xM),l(CM),l(gM),l(bi),l(IM),l(kM),l(Ci),l(GM),l(gi),l(ZM),l(BM),l(QM),l(Ii),l(vM),l(NM),l(Gi),l(AM),l(Zi),l(_M),l(Bi),l($M),l(RM),l(VM),l(Qi),l(YM),l(PM),l(Ni),l(HM),l(Ai),l(EM),l(WM),l($i),l(XM),l(Ri),l(zM),l(SM),l(LM),l(Vi),l(FM),l(DM),l(Pi),l(qM),l(Hi),l(OM),l(KM),l(em),l(Ei),l(tm),l(lm),l(Xi),l(sm),l(zi),l(im),l(Si),l(nm),l(am),l(pm),l(Li),l(om),l(dm),l(Di),l(cm),l(qi),l(rm),l(Mm),l(Ki),l(mm),l(Tm),l(tn),l(ym),l(ln),l(um),l(Jm),l(hm),l(sn),l(wm),l(jm),l(an),l(Um),l(pn),l(fm),l(bm),l(xm),l(on),l(Cm),l(gm),l(cn),l(Im),l(rn),l(km),l(Mn),l(Gm),l(Zm),l(Bm),l(mn),l(Qm),l(vm),l(yn),l(Nm),l(un),l(Am),l(_m),l(hn),l($m),l(Rm),l(Vm),l(wn),l(Ym),l(Pm),l(Un),l(Hm),l(fn),l(Em),l(bn),l(Wm),l(Xm),l(zm),l(xn),l(Sm),l(Lm),l(gn),l(Fm),l(In),l(Dm),l(kn),l(qm),l(Gn),l(Om),l(Km),l(eT),l(Zn),l(tT),l(lT),l(Qn),l(sT),l(vn),l(iT),l(nT),l(aT),l(Nn),l(pT),l(oT),l(_n),l(dT),l(cT),l(rT),l($n),l(MT),l(mT),l(Vn),l(TT),l(Yn),l(yT),l(uT),l(JT),l(Hn)),l(w),y(U,e),y(x,e),y(I,e),y(Q,e),y(_,e),y(Y,e),y(X,e),y(L,e),y(D,e),y(O,e),y(te,e),y(ae,e),y(de,e),y(re,e),y(Te,e),y(we,e),y(fe,e),y(Ce,e),y(Ze,e),y(ve,e),y(Ae,e),y(Re,e),y(Ee,e),y(ze,e),y(Fe,e),y(tt,e),y(it,e),y(pt,e),y(rt,e),y(Tt,e),y(Jt,e),y(jt,e),y(bt,e),y(Ct,e),y(It,e),y(Zt,e),y(At,e),y(Rt,e),y(Yt,e),y(Wt,e),y(Lt,e),y(Ot,e),y(tl,e),y(sl,e),y(nl,e),y(ol,e),y(ml,e),y(ul,e),y(jl,e),y(xl,e),y(Gl,e),y(Ql,e),y(Nl,e),y(_l,e),y(Rl,e),y(Yl,e),y(Hl,e),y(zl,e),y(Dl,e),y(ts,e),y(is,e),y(as,e),y(cs,e),y(Ts,e),y(ws,e),y(fs,e),y(xs,e),y(gs,e),y(Zs,e),y(Ns,e),y(Vs,e),y(Hs,e),y(zs,e),y(Ds,e),y(ti,e),y(ii,e),y(oi,e),y(Mi,e),y(Ji,e),y(ji,e),y(xi,e),y(ki,e),y(vi,e),y(_i,e),y(Yi,e),y(Wi,e),y(Fi,e),y(Oi,e),y(en,e),y(nn,e),y(dn,e),y(Tn,e),y(Jn,e),y(jn,e),y(Cn,e),y(Bn,e),y(An,e),y(Rn,e)}}}const th='{"title":"pipelines","local":"pipelines","sections":[{"title":"pipelines.Pipeline ⇐ <code> Callable </code>","local":"pipelinespipeline--code-callable-code","sections":[{"title":"new Pipeline(options)","local":"new-pipelineoptions","sections":[],"depth":3},{"title":"pipeline.dispose() ⇒ <code> Promise. < void > </code>","local":"pipelinedispose--code-promise--void--code","sections":[],"depth":3},{"title":"pipeline._call(texts, ...args) ⇒ <code> Promise. < any > </code>","local":"pipelinecalltexts-args--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TextClassificationPipeline","local":"pipelinestextclassificationpipeline","sections":[{"title":"textClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"textclassificationpipelinecalltexts-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TokenClassificationPipeline","local":"pipelinestokenclassificationpipeline","sections":[{"title":"tokenClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"tokenclassificationpipelinecalltexts-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.QuestionAnsweringPipeline","local":"pipelinesquestionansweringpipeline","sections":[{"title":"questionAnsweringPipeline._call(question, context, options) ⇒ <code> QuestionAnsweringReturnType </code>","local":"questionansweringpipelinecallquestion-context-options--code-questionansweringreturntype-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.FillMaskPipeline","local":"pipelinesfillmaskpipeline","sections":[{"title":"fillMaskPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"fillmaskpipelinecalltexts-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.Text2TextGenerationPipeline","local":"pipelinestext2textgenerationpipeline","sections":[{"title":"text2TextGenerationPipeline._call(texts, [options]) ⇒ <code> Promise. < any > </code>","local":"text2textgenerationpipelinecalltexts-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.SummarizationPipeline","local":"pipelinessummarizationpipeline","sections":[],"depth":2},{"title":"pipelines.TranslationPipeline","local":"pipelinestranslationpipeline","sections":[],"depth":2},{"title":"pipelines.TextGenerationPipeline","local":"pipelinestextgenerationpipeline","sections":[{"title":"textGenerationPipeline._call(texts, [generate_kwargs]) ⇒ <code> Promise. < any > </code>","local":"textgenerationpipelinecalltexts-generatekwargs--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ZeroShotClassificationPipeline","local":"pipelineszeroshotclassificationpipeline","sections":[{"title":"new ZeroShotClassificationPipeline(options)","local":"new-zeroshotclassificationpipelineoptions","sections":[],"depth":3},{"title":"zeroShotClassificationPipeline._call(texts, candidate_labels, options) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>","local":"zeroshotclassificationpipelinecalltexts-candidatelabels-options--code-promise--objectarray--object----code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.FeatureExtractionPipeline","local":"pipelinesfeatureextractionpipeline","sections":[{"title":"featureExtractionPipeline._call(texts, options) ⇒","local":"featureextractionpipelinecalltexts-options-","sections":[],"depth":3}],"depth":2},{"title":"pipelines.AudioClassificationPipeline","local":"pipelinesaudioclassificationpipeline","sections":[{"title":"new AudioClassificationPipeline(options)","local":"new-audioclassificationpipelineoptions","sections":[],"depth":3},{"title":"audioClassificationPipeline._call(audio, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"audioclassificationpipelinecallaudio-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.AutomaticSpeechRecognitionPipeline","local":"pipelinesautomaticspeechrecognitionpipeline","sections":[{"title":"new AutomaticSpeechRecognitionPipeline(options)","local":"new-automaticspeechrecognitionpipelineoptions","sections":[],"depth":3},{"title":"automaticSpeechRecognitionPipeline._call(audio, [kwargs]) ⇒ <code> Promise. < Object > </code>","local":"automaticspeechrecognitionpipelinecallaudio-kwargs--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageToTextPipeline","local":"pipelinesimagetotextpipeline","sections":[{"title":"new ImageToTextPipeline(options)","local":"new-imagetotextpipelineoptions","sections":[],"depth":3},{"title":"imageToTextPipeline._call(images, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>","local":"imagetotextpipelinecallimages-generatekwargs--code-promise--objectarray--object----code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageClassificationPipeline","local":"pipelinesimageclassificationpipeline","sections":[{"title":"new ImageClassificationPipeline(options)","local":"new-imageclassificationpipelineoptions","sections":[],"depth":3},{"title":"imageClassificationPipeline._call(images, options) ⇒ <code> Promise. < any > </code>","local":"imageclassificationpipelinecallimages-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageSegmentationPipeline","local":"pipelinesimagesegmentationpipeline","sections":[{"title":"new ImageSegmentationPipeline(options)","local":"new-imagesegmentationpipelineoptions","sections":[],"depth":3},{"title":"imageSegmentationPipeline._call(images, options) ⇒ <code> Promise. < Array > </code>","local":"imagesegmentationpipelinecallimages-options--code-promise--array--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ZeroShotImageClassificationPipeline","local":"pipelineszeroshotimageclassificationpipeline","sections":[{"title":"new ZeroShotImageClassificationPipeline(options)","local":"new-zeroshotimageclassificationpipelineoptions","sections":[],"depth":3},{"title":"zeroShotImageClassificationPipeline._call(images, candidate_labels, options) ⇒ <code> Promise. < any > </code>","local":"zeroshotimageclassificationpipelinecallimages-candidatelabels-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ObjectDetectionPipeline","local":"pipelinesobjectdetectionpipeline","sections":[{"title":"new ObjectDetectionPipeline(options)","local":"new-objectdetectionpipelineoptions","sections":[],"depth":3},{"title":"objectDetectionPipeline._call(images, options)","local":"objectdetectionpipelinecallimages-options","sections":[],"depth":3}],"depth":2},{"title":"pipelines.DocumentQuestionAnsweringPipeline","local":"pipelinesdocumentquestionansweringpipeline","sections":[{"title":"new DocumentQuestionAnsweringPipeline(options)","local":"new-documentquestionansweringpipelineoptions","sections":[],"depth":3},{"title":"documentQuestionAnsweringPipeline._call(image, question, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>","local":"documentquestionansweringpipelinecallimage-question-generatekwargs--code-promise--objectarray--object----code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TextToAudioPipeline","local":"pipelinestexttoaudiopipeline","sections":[{"title":"new TextToAudioPipeline(options)","local":"new-texttoaudiopipelineoptions","sections":[],"depth":3},{"title":"textToAudioPipeline._call(text_inputs, options) ⇒ <code> Promise. < Object > </code>","local":"texttoaudiopipelinecalltextinputs-options--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageToImagePipeline","local":"pipelinesimagetoimagepipeline","sections":[{"title":"imageToImagePipeline._call(images) ⇒ <code> Promise. < any > </code>","local":"imagetoimagepipelinecallimages--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.pipeline(task, [model], [options]) ⇒ <code> Promise. < Pipeline > </code>","local":"pipelinespipelinetask-model-options--code-promise--pipeline--code","sections":[],"depth":2},{"title":"pipelines~QuestionAnsweringResult : <code> object </code>","local":"pipelinesquestionansweringresult--code-object-code","sections":[],"depth":2},{"title":"pipelines~QuestionAnsweringReturnType : <code> Promise. < (QuestionAnsweringResult|Array < QuestionAnsweringResult > ) > </code>","local":"pipelinesquestionansweringreturntype--code-promise--questionansweringresultarray--questionansweringresult----code","sections":[],"depth":2},{"title":"pipelines~ChunkCallback : <code> function </code>","local":"pipelineschunkcallback--code-function-code","sections":[],"depth":2}],"depth":1}';function lh(wT){return FJ(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ph extends DJ{constructor(w){super(),qJ(this,w,lh,eh,SJ,{})}}export{ph as component};
