import{s as Pd,n as kd,o as Hd}from"../chunks/scheduler.b108d059.js";import{S as Id,i as Fd,g as a,s as o,r as p,A as Ld,h as d,f as r,c as l,j as f,u as n,x as c,k as i,y as Ad,a as s,v as m,d as u,t as h,w as _}from"../chunks/index.008de539.js";import{C as ta}from"../chunks/CodeBlock.3968c746.js";import{H as g}from"../chunks/Heading.88bfeb84.js";function Rd(ra){let b,lr,sr,ar,x,dr,T,cr,y,sa="Processors are used to prepare non-textual inputs (e.g., image or audio) for a model.",ir,v,oa="<strong>Example:</strong> Using a <code>WhisperProcessor</code> to prepare an audio input for a model.",pr,$,nr,M,la='<li><a href="#module_processors">processors</a><ul><li><em>static</em><ul><li><a href="#module_processors.FeatureExtractor">.FeatureExtractor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.FeatureExtractor_new"><code>new FeatureExtractor(config)</code></a></li></ul></li> <li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li> <li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(urls)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li> <li><a href="#module_processors.Processor">.Processor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.WhisperProcessor">.WhisperProcessor</a> ⇐ <code>Processor</code><ul><li><a href="#module_processors.WhisperProcessor+_call"><code>._call(audio)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.AutoProcessor">.AutoProcessor</a><ul><li><a href="#module_processors.AutoProcessor.from_pretrained"><code>.from_pretrained(pretrained_model_name_or_path, options)</code></a> ⇒ <code>Promise.&lt;Processor&gt;</code></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_processors..center_to_corners_format"><code>~center_to_corners_format(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_processors..post_process_object_detection"><code>~post_process_object_detection(outputs)</code></a> ⇒ <code>Array.&lt;Object&gt;</code><ul><li><a href="#module_processors..post_process_object_detection..box"><code>~box</code></a> : <code>Array.&lt;number&gt;</code></li></ul></li> <li><a href="#module_processors..HeightWidth"><code>~HeightWidth</code></a> : <code>*</code></li> <li><a href="#module_processors..ImageFeatureExtractorResult"><code>~ImageFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..PreprocessedImage"><code>~PreprocessedImage</code></a> : <code>object</code></li> <li><a href="#module_processors..DetrFeatureExtractorResult"><code>~DetrFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..SamImageProcessorResult"><code>~SamImageProcessorResult</code></a> : <code>object</code></li></ul></li></ul></li>',mr,ur,hr,w,_r,E,fr,j,aa="Base class for feature extractors.",gr,C,da='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',br,xr,Tr,J,yr,P,vr,k,ca="Constructs a new FeatureExtractor instance.",$r,H,ia="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td><p>The configuration for the feature extractor.</p></td></tr></tbody>",Mr,wr,Er,I,jr,F,Cr,L,pa="Feature extractor for image models.",Jr,A,na='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>FeatureExtractor</code>',Pr,R,ma='<li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li>',kr,Hr,Ir,U,Fr,z,Lr,D,ua="Constructs a new ImageFeatureExtractor instance.",Ar,B,ha="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td><p>The configuration for the feature extractor.</p></td> </tr><tr><td>config.image_mean</td><td><code>Array.&lt;number&gt;</code></td><td><p>The mean values for image normalization.</p></td> </tr><tr><td>config.image_std</td><td><code>Array.&lt;number&gt;</code></td><td><p>The standard deviation values for image normalization.</p></td> </tr><tr><td>config.do_rescale</td><td><code>boolean</code></td><td><p>Whether to rescale the image pixel values to the [0,1] range.</p></td> </tr><tr><td>config.rescale_factor</td><td><code>number</code></td><td><p>The factor to use for rescaling the image pixel values.</p></td> </tr><tr><td>config.do_normalize</td><td><code>boolean</code></td><td><p>Whether to normalize the image pixel values.</p></td> </tr><tr><td>config.do_resize</td><td><code>boolean</code></td><td><p>Whether to resize the image.</p></td> </tr><tr><td>config.resample</td><td><code>number</code></td><td><p>What method to use for resampling.</p></td> </tr><tr><td>config.size</td><td><code>number</code></td><td><p>The size to resize the image to.</p></td></tr></tbody>",Rr,Ur,zr,W,Dr,N,Br,G,_a=`Resize the image to make a thumbnail. The image is resized so that no dimension is larger than any
corresponding dimension of the specified size.`,Wr,Z,fa='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The resized image.',Nr,Q,ga="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be resized.</p></td> </tr><tr><td>size</td><td><code>Object</code></td><td></td><td><p>The size <code>{&quot;height&quot;: h, &quot;width&quot;: w}</code> to resize the image to.</p></td> </tr><tr><td>[resample]</td><td><code>string</code> | <code>0</code> | <code>1</code> | <code>2</code> | <code>3</code> | <code>4</code> | <code>5</code></td><td><code>2</code></td><td><p>The resampling filter to use.</p></td></tr></tbody>",Gr,Zr,Qr,X,Xr,V,Vr,Y,ba="Pad the image by a certain amount.",Yr,S,xa='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The padded pixel data and image dimensions.',Sr,q,Ta="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>pixelData</td><td><code>Float32Array</code></td><td></td><td><p>The pixel data to pad.</p></td> </tr><tr><td>imgDims</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The dimensions of the image.</p></td> </tr><tr><td>padSize</td><td><code>*</code></td><td></td><td><p>The dimensions of the padded image.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for padding.</p></td> </tr><tr><td>[options.mode]</td><td><code>&#39;constant&#39;</code> | <code>&#39;symmetric&#39;</code></td><td><code>&#39;constant&#39;</code></td><td><p>The type of padding to add.</p></td> </tr><tr><td>[options.center]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to center the image.</p></td> </tr><tr><td>[options.constant_values]</td><td><code>number</code></td><td><code>0</code></td><td><p>The constant value to use for padding.</p></td></tr></tbody>",qr,Kr,Or,K,es,O,ts,ee,ya="Preprocesses the given image.",rs,te,va='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;PreprocessedImage&gt;</code> - The preprocessed image.',ss,re,$a="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to preprocess.</p></td></tr></tbody>",os,ls,as,se,ds,oe,cs,le,Ma=`Calls the feature extraction process on an array of image
URLs, preprocesses each image, and concatenates the resulting
features into a single Tensor.`,is,ae,wa='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values (and other metadata) of the preprocessed images.',ps,de,Ea="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;any&gt;</code></td><td><p>The URL(s) of the image(s) to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",ns,ms,us,ce,hs,ie,_s,pe,ja="Detr Feature Extractor.",fs,ne,Ca='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>ImageFeatureExtractor</code>',gs,me,Ja='<li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(urls)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li>',bs,xs,Ts,ue,ys,he,vs,_e,Pa=`Calls the feature extraction process on an array of image URLs, preprocesses
each image, and concatenates the resulting features into a single Tensor.`,$s,fe,ka='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values of the preprocessed images.',Ms,ge,Ha="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>urls</td><td><code>Array.&lt;any&gt;</code></td><td><p>The URL(s) of the image(s) to extract features from.</p></td></tr></tbody>",ws,Es,js,be,Cs,xe,Js,Te,Ia='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',Ps,ks,Hs,ye,Is,ve,Fs,$e,Fa="Binarize the given masks using <code>object_mask_threshold</code>, it returns the associated values of <code>masks</code>, <code>scores</code> and <code>labels</code>.",Ls,Me,La='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The binarized masks, the scores, and the labels.',As,we,Aa="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>class_logits</td><td><code>Tensor</code></td><td><p>The class logits.</p></td> </tr><tr><td>mask_logits</td><td><code>Tensor</code></td><td><p>The mask logits.</p></td> </tr><tr><td>object_mask_threshold</td><td><code>number</code></td><td><p>A number between 0 and 1 used to binarize the masks.</p></td> </tr><tr><td>num_labels</td><td><code>number</code></td><td><p>The number of labels.</p></td></tr></tbody>",Rs,Us,zs,Ee,Ds,je,Bs,Ce,Ra="Checks whether the segment is valid or not.",Ws,Je,Ua='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - Whether the segment is valid or not, and the indices of the valid labels.',Ns,Pe,za="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_labels</td><td><code>Int32Array</code></td><td></td><td><p>Labels for each pixel in the mask.</p></td> </tr><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>Probabilities for each pixel in the masks.</p></td> </tr><tr><td>k</td><td><code>number</code></td><td></td><td><p>The class id of the segment.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold.</p></td></tr></tbody>",Gs,Zs,Qs,ke,Xs,He,Vs,Ie,Da="Computes the segments.",Ys,Fe,Ba='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The computed segments.',Ss,Le,Wa="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>The mask probabilities.</p></td> </tr><tr><td>pred_scores</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted scores.</p></td> </tr><tr><td>pred_labels</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted labels.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td></td><td><p>The overlap mask area threshold.</p></td> </tr><tr><td>label_ids_to_fuse</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The label ids to fuse.</p></td> </tr><tr><td>target_size</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>The target size of the image.</p></td></tr></tbody>",qs,Ks,Os,Ae,eo,Re,to,Ue,Na="Post-process the model output to generate the final panoptic segmentation.",ro,ze,Ga='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',so,De,Za="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>outputs</td><td><code>*</code></td><td></td><td><p>The model output to post process</p></td> </tr><tr><td>[threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The probability score threshold to keep predicted instance masks.</p></td> </tr><tr><td>[mask_threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Threshold to use when turning the predicted masks into binary values.</p></td> </tr><tr><td>[overlap_mask_area_threshold]</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold to merge or discard small disconnected parts within each binary instance mask.</p></td> </tr><tr><td>[label_ids_to_fuse]</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The labels in this state will have all their instances be fused together.</p></td> </tr><tr><td>[target_sizes]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>The target sizes to resize the masks to.</p></td></tr></tbody>",oo,lo,ao,Be,co,We,io,Ne,Qa="Represents a Processor that extracts features from an input.",po,Ge,Xa='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',no,Ze,Va='<li><a href="#module_processors.Processor">.Processor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',mo,uo,ho,Qe,_o,Xe,fo,Ve,Ya="Creates a new Processor with the given feature extractor.",go,Ye,Sa="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>feature_extractor</td><td><code>FeatureExtractor</code></td><td><p>The function used to extract features from the input.</p></td></tr></tbody>",bo,xo,To,Se,yo,qe,vo,Ke,qa="Calls the feature_extractor function with the given input.",$o,Oe,Ka='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',Mo,et,Oa="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>any</code></td><td><p>The input to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",wo,Eo,jo,tt,Co,rt,Jo,st,ed="Represents a WhisperProcessor that extracts features from an audio input.",Po,ot,td='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Processor</code>',ko,Ho,Io,lt,Fo,at,Lo,dt,rd="Calls the feature_extractor function with the given audio input.",Ao,ct,sd='<strong>Kind</strong>: instance method of <a href="#module_processors.WhisperProcessor"><code>WhisperProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',Ro,it,od="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>any</code></td><td><p>The audio input to extract features from.</p></td></tr></tbody>",Uo,zo,Do,pt,Bo,nt,Wo,mt,ld=`Helper class which is used to instantiate pretrained processors with the <code>from_pretrained</code> function.
The chosen processor class is determined by the type specified in the processor config.`,No,ut,ad="<strong>Example:</strong> Load a processor using <code>from_pretrained</code>.",Go,ht,Zo,_t,dd="<strong>Example:</strong> Run an image through a processor.",Qo,ft,Xo,gt,cd='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a>',Vo,Yo,So,bt,qo,xt,Ko,Tt,id="Instantiate one of the processor classes of the library from a pretrained model.",Oo,yt,pd=`The processor class to instantiate is selected based on the <code>feature_extractor_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible)`,el,vt,nd='<strong>Kind</strong>: static method of <a href="#module_processors.AutoProcessor"><code>AutoProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Processor&gt;</code> - A new instance of the Processor class.',tl,$t,md=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pretrained_model_name_or_path</td><td><code>string</code></td><td><p>The name or path of the pretrained model. Can be either:</p> <ul><li>A string, the <em>model id</em> of a pretrained processor hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li> <li>A path to a <em>directory</em> containing processor files, e.g., <code>./my_model_directory/</code>.</li></ul></td> </tr><tr><td>options</td><td><code>*</code></td><td><p>Additional options for loading the processor.</p></td></tr></tbody>`,rl,sl,ol,Mt,ll,wt,al,Et,ud="Converts bounding boxes from center format to corners format.",dl,jt,hd='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The coodinates for the top-left and bottom-right corners of the box (top_left_x, top_left_y, bottom_right_x, bottom_right_y)',cl,Ct,_d="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The coordinate for the center of the box and its width, height dimensions (center_x, center_y, width, height)</p></td></tr></tbody>",il,pl,nl,Jt,ml,Pt,ul,kt,fd="Post-processes the outputs of the model (for object detection).",hl,Ht,gd='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Object&gt;</code> - An array of objects containing the post-processed outputs.',_l,It,bd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>outputs</td><td><code>Object</code></td><td><p>The outputs of the model that must be post-processed</p></td> </tr><tr><td>outputs.logits</td><td><code>Tensor</code></td><td><p>The logits</p></td> </tr><tr><td>outputs.pred_boxes</td><td><code>Tensor</code></td><td><p>The predicted boxes.</p></td></tr></tbody>",fl,gl,bl,Ft,xl,Lt,Tl,At,xd='<strong>Kind</strong>: inner property of <a href="#module_processors..post_process_object_detection"><code>post_process_object_detection</code></a>',yl,vl,$l,Rt,Ml,Ut,wl,zt,Td=`Named tuple to indicate the order we are using is (height x width), even though
the Graphics’ industry standard is (width x height).`,El,Dt,yd='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a>',jl,Cl,Jl,Bt,Pl,Wt,kl,Nt,vd='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Hl,Gt,$d="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the batched preprocessed images.</p></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[480, 640]].</p></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[1000, 1330]].</p></td></tr></tbody>",Il,Fl,Ll,Zt,Al,Qt,Rl,Xt,Md='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Ul,Vt,wd="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>original_size</td><td><code>HeightWidth</code></td><td><p>The original size of the image.</p></td> </tr><tr><td>reshaped_input_size</td><td><code>HeightWidth</code></td><td><p>The reshaped input size of the image.</p></td> </tr><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the preprocessed image.</p></td></tr></tbody>",zl,Dl,Bl,Yt,Wl,St,Nl,qt,Ed='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Gl,Kt,jd="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_mask</td><td><code>Tensor</code></td></tr></tbody>",Zl,Ql,Xl,Ot,Vl,er,Yl,tr,Cd='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Sl,rr,Jd="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>input_points</td><td><code>Tensor</code></td></tr></tbody>",ql,Kl,Ol,or,ea;return T=new g({props:{title:"processors",local:"processors",headingTag:"h1"}}),$=new ta({props:{code:"aW1wb3J0JTIwJTdCJTIwQXV0b1Byb2Nlc3NvciUyQyUyMHJlYWRfYXVkaW8lMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEElMEFsZXQlMjBwcm9jZXNzb3IlMjAlM0QlMjBhd2FpdCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCdvcGVuYWklMkZ3aGlzcGVyLXRpbnkuZW4nKSUzQiUwQWxldCUyMGF1ZGlvJTIwJTNEJTIwYXdhaXQlMjByZWFkX2F1ZGlvKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJyUyQyUyMDE2MDAwKSUzQiUwQWxldCUyMCU3QiUyMGlucHV0X2ZlYXR1cmVzJTIwJTdEJTIwJTNEJTIwYXdhaXQlMjBwcm9jZXNzb3IoYXVkaW8pJTNCJTBBJTJGJTJGJTIwVGVuc29yJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwZGF0YSUzQSUyMEZsb2F0MzJBcnJheSgyNDAwMDApJTIwJTVCMC40NzUyOTg0NjQyOTgyNDgzJTJDJTIwMC41NTk3MjU4ODA2MjI4NjM4JTJDJTIwMC41NjQzNDE2NjQzMTQyNyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwODAlMkMlMjAzMDAwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwdHlwZSUzQSUyMCdmbG9hdDMyJyUyQyUwQSUyRiUyRiUyMCUyMCUyMHNpemUlM0ElMjAyNDAwMDAlMkMlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">AutoProcessor</span>, read_audio } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;

<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> audio = <span class="hljs-keyword">await</span> <span class="hljs-title function_">read_audio</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&#x27;</span>, <span class="hljs-number">16000</span>);
<span class="hljs-keyword">let</span> { input_features } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(audio);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   data: Float32Array(240000) [0.4752984642982483, 0.5597258806228638, 0.56434166431427, ...],</span>
<span class="hljs-comment">//   dims: [1, 80, 3000],</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   size: 240000,</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),E=new g({props:{title:"processors.FeatureExtractor ⇐ <code> Callable </code>",local:"processorsfeatureextractor--code-callable-code",headingTag:"h2"}}),P=new g({props:{title:"new FeatureExtractor(config)",local:"new-featureextractorconfig",headingTag:"h3"}}),F=new g({props:{title:"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>",local:"processorsimagefeatureextractor--code-featureextractor-code",headingTag:"h2"}}),z=new g({props:{title:"new ImageFeatureExtractor(config)",local:"new-imagefeatureextractorconfig",headingTag:"h3"}}),N=new g({props:{title:"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code",headingTag:"h3"}}),V=new g({props:{title:"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>",local:"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code",headingTag:"h3"}}),O=new g({props:{title:"imageFeatureExtractor.preprocess(image) ⇒ <code> Promise. < PreprocessedImage > </code>",local:"imagefeatureextractorpreprocessimage--code-promise--preprocessedimage--code",headingTag:"h3"}}),oe=new g({props:{title:"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>",local:"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code",headingTag:"h3"}}),ie=new g({props:{title:"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>",local:"processorsdetrfeatureextractor--code-imagefeatureextractor-code",headingTag:"h2"}}),he=new g({props:{title:"detrFeatureExtractor._call(urls) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>",local:"detrfeatureextractorcallurls--code-promise--detrfeatureextractorresult--code",headingTag:"h3"}}),xe=new g({props:{title:"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>",local:"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code",headingTag:"h3"}}),ve=new g({props:{title:"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>",local:"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code",headingTag:"h3"}}),je=new g({props:{title:"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>",local:"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code",headingTag:"h3"}}),He=new g({props:{title:"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>",local:"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code",headingTag:"h3"}}),Re=new g({props:{title:"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>",local:"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code",headingTag:"h3"}}),We=new g({props:{title:"processors.Processor ⇐ <code> Callable </code>",local:"processorsprocessor--code-callable-code",headingTag:"h2"}}),Xe=new g({props:{title:"new Processor(feature_extractor)",local:"new-processorfeatureextractor",headingTag:"h3"}}),qe=new g({props:{title:"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>",local:"processorcallinput-args--code-promise--any--code",headingTag:"h3"}}),rt=new g({props:{title:"processors.WhisperProcessor ⇐ <code> Processor </code>",local:"processorswhisperprocessor--code-processor-code",headingTag:"h2"}}),at=new g({props:{title:"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>",local:"whisperprocessorcallaudio--code-promise--any--code",headingTag:"h3"}}),nt=new g({props:{title:"processors.AutoProcessor",local:"processorsautoprocessor",headingTag:"h2"}}),ht=new ta({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJyklM0I=",highlighted:'<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);',wrap:!1}}),ft=new ta({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnWGVub3ZhJTJGY2xpcC12aXQtYmFzZS1wYXRjaDE2JyklM0IlMEFsZXQlMjBpbWFnZSUyMCUzRCUyMGF3YWl0JTIwUmF3SW1hZ2UucmVhZCgnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmZvb3RiYWxsLW1hdGNoLmpwZycpJTNCJTBBbGV0JTIwaW1hZ2VfaW5wdXRzJTIwJTNEJTIwYXdhaXQlMjBwcm9jZXNzb3IoaW1hZ2UpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIyZGltcyUyMiUzQSUyMCU1QiUyMDElMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZsb2F0MzIlMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjJkYXRhJTIyJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTQ0MDg5MzE3MzIxNzc3MyUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMnNpemUlMjIlM0ElMjAxNTA1MjglMEElMkYlMkYlMjAlMjAlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjJvcmlnaW5hbF9zaXplcyUyMiUzQSUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU1QiUyMDUzMyUyQyUyMDgwMCUyMCU1RCUwQSUyRiUyRiUyMCUyMCUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMnJlc2hhcGVkX2lucHV0X3NpemVzJTIyJTNBJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTVCJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTBBJTJGJTJGJTIwJTIwJTIwJTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;Xenova/clip-vit-base-patch16&#x27;</span>);
<span class="hljs-keyword">let</span> image = <span class="hljs-keyword">await</span> <span class="hljs-title class_">RawImage</span>.<span class="hljs-title function_">read</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/football-match.jpg&#x27;</span>);
<span class="hljs-keyword">let</span> image_inputs = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(image);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;pixel_values&quot;: {</span>
<span class="hljs-comment">//     &quot;dims&quot;: [ 1, 3, 224, 224 ],</span>
<span class="hljs-comment">//     &quot;type&quot;: &quot;float32&quot;,</span>
<span class="hljs-comment">//     &quot;data&quot;: Float32Array [ -1.558687686920166, -1.558687686920166, -1.5440893173217773, ... ],</span>
<span class="hljs-comment">//     &quot;size&quot;: 150528</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   &quot;original_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 533, 800 ]</span>
<span class="hljs-comment">//   ],</span>
<span class="hljs-comment">//   &quot;reshaped_input_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 224, 224 ]</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),xt=new g({props:{title:"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>",local:"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code",headingTag:"h3"}}),wt=new g({props:{title:"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>",local:"processorscentertocornersformatarr--code-array--number--code",headingTag:"h2"}}),Pt=new g({props:{title:"processors~post_process_object_detection(outputs) ⇒ <code> Array. < Object > </code>",local:"processorspostprocessobjectdetectionoutputs--code-array--object--code",headingTag:"h2"}}),Lt=new g({props:{title:"post_process_object_detection~box : <code> Array. < number > </code>",local:"postprocessobjectdetectionbox--code-array--number--code",headingTag:"h3"}}),Ut=new g({props:{title:"processors~HeightWidth : <code> * </code>",local:"processorsheightwidth--code--code",headingTag:"h2"}}),Wt=new g({props:{title:"processors~ImageFeatureExtractorResult : <code> object </code>",local:"processorsimagefeatureextractorresult--code-object-code",headingTag:"h2"}}),Qt=new g({props:{title:"processors~PreprocessedImage : <code> object </code>",local:"processorspreprocessedimage--code-object-code",headingTag:"h2"}}),St=new g({props:{title:"processors~DetrFeatureExtractorResult : <code> object </code>",local:"processorsdetrfeatureextractorresult--code-object-code",headingTag:"h2"}}),er=new g({props:{title:"processors~SamImageProcessorResult : <code> object </code>",local:"processorssamimageprocessorresult--code-object-code",headingTag:"h2"}}),{c(){b=a("meta"),lr=o(),sr=a("p"),ar=o(),x=a("a"),dr=o(),p(T.$$.fragment),cr=o(),y=a("p"),y.textContent=sa,ir=o(),v=a("p"),v.innerHTML=oa,pr=o(),p($.$$.fragment),nr=o(),M=a("ul"),M.innerHTML=la,mr=o(),ur=a("hr"),hr=o(),w=a("a"),_r=o(),p(E.$$.fragment),fr=o(),j=a("p"),j.textContent=aa,gr=o(),C=a("p"),C.innerHTML=da,br=o(),xr=a("hr"),Tr=o(),J=a("a"),yr=o(),p(P.$$.fragment),vr=o(),k=a("p"),k.textContent=ca,$r=o(),H=a("table"),H.innerHTML=ia,Mr=o(),wr=a("hr"),Er=o(),I=a("a"),jr=o(),p(F.$$.fragment),Cr=o(),L=a("p"),L.textContent=pa,Jr=o(),A=a("p"),A.innerHTML=na,Pr=o(),R=a("ul"),R.innerHTML=ma,kr=o(),Hr=a("hr"),Ir=o(),U=a("a"),Fr=o(),p(z.$$.fragment),Lr=o(),D=a("p"),D.textContent=ua,Ar=o(),B=a("table"),B.innerHTML=ha,Rr=o(),Ur=a("hr"),zr=o(),W=a("a"),Dr=o(),p(N.$$.fragment),Br=o(),G=a("p"),G.textContent=_a,Wr=o(),Z=a("p"),Z.innerHTML=fa,Nr=o(),Q=a("table"),Q.innerHTML=ga,Gr=o(),Zr=a("hr"),Qr=o(),X=a("a"),Xr=o(),p(V.$$.fragment),Vr=o(),Y=a("p"),Y.textContent=ba,Yr=o(),S=a("p"),S.innerHTML=xa,Sr=o(),q=a("table"),q.innerHTML=Ta,qr=o(),Kr=a("hr"),Or=o(),K=a("a"),es=o(),p(O.$$.fragment),ts=o(),ee=a("p"),ee.textContent=ya,rs=o(),te=a("p"),te.innerHTML=va,ss=o(),re=a("table"),re.innerHTML=$a,os=o(),ls=a("hr"),as=o(),se=a("a"),ds=o(),p(oe.$$.fragment),cs=o(),le=a("p"),le.textContent=Ma,is=o(),ae=a("p"),ae.innerHTML=wa,ps=o(),de=a("table"),de.innerHTML=Ea,ns=o(),ms=a("hr"),us=o(),ce=a("a"),hs=o(),p(ie.$$.fragment),_s=o(),pe=a("p"),pe.textContent=ja,fs=o(),ne=a("p"),ne.innerHTML=Ca,gs=o(),me=a("ul"),me.innerHTML=Ja,bs=o(),xs=a("hr"),Ts=o(),ue=a("a"),ys=o(),p(he.$$.fragment),vs=o(),_e=a("p"),_e.textContent=Pa,$s=o(),fe=a("p"),fe.innerHTML=ka,Ms=o(),ge=a("table"),ge.innerHTML=Ha,ws=o(),Es=a("hr"),js=o(),be=a("a"),Cs=o(),p(xe.$$.fragment),Js=o(),Te=a("p"),Te.innerHTML=Ia,Ps=o(),ks=a("hr"),Hs=o(),ye=a("a"),Is=o(),p(ve.$$.fragment),Fs=o(),$e=a("p"),$e.innerHTML=Fa,Ls=o(),Me=a("p"),Me.innerHTML=La,As=o(),we=a("table"),we.innerHTML=Aa,Rs=o(),Us=a("hr"),zs=o(),Ee=a("a"),Ds=o(),p(je.$$.fragment),Bs=o(),Ce=a("p"),Ce.textContent=Ra,Ws=o(),Je=a("p"),Je.innerHTML=Ua,Ns=o(),Pe=a("table"),Pe.innerHTML=za,Gs=o(),Zs=a("hr"),Qs=o(),ke=a("a"),Xs=o(),p(He.$$.fragment),Vs=o(),Ie=a("p"),Ie.textContent=Da,Ys=o(),Fe=a("p"),Fe.innerHTML=Ba,Ss=o(),Le=a("table"),Le.innerHTML=Wa,qs=o(),Ks=a("hr"),Os=o(),Ae=a("a"),eo=o(),p(Re.$$.fragment),to=o(),Ue=a("p"),Ue.textContent=Na,ro=o(),ze=a("p"),ze.innerHTML=Ga,so=o(),De=a("table"),De.innerHTML=Za,oo=o(),lo=a("hr"),ao=o(),Be=a("a"),co=o(),p(We.$$.fragment),io=o(),Ne=a("p"),Ne.textContent=Qa,po=o(),Ge=a("p"),Ge.innerHTML=Xa,no=o(),Ze=a("ul"),Ze.innerHTML=Va,mo=o(),uo=a("hr"),ho=o(),Qe=a("a"),_o=o(),p(Xe.$$.fragment),fo=o(),Ve=a("p"),Ve.textContent=Ya,go=o(),Ye=a("table"),Ye.innerHTML=Sa,bo=o(),xo=a("hr"),To=o(),Se=a("a"),yo=o(),p(qe.$$.fragment),vo=o(),Ke=a("p"),Ke.textContent=qa,$o=o(),Oe=a("p"),Oe.innerHTML=Ka,Mo=o(),et=a("table"),et.innerHTML=Oa,wo=o(),Eo=a("hr"),jo=o(),tt=a("a"),Co=o(),p(rt.$$.fragment),Jo=o(),st=a("p"),st.textContent=ed,Po=o(),ot=a("p"),ot.innerHTML=td,ko=o(),Ho=a("hr"),Io=o(),lt=a("a"),Fo=o(),p(at.$$.fragment),Lo=o(),dt=a("p"),dt.textContent=rd,Ao=o(),ct=a("p"),ct.innerHTML=sd,Ro=o(),it=a("table"),it.innerHTML=od,Uo=o(),zo=a("hr"),Do=o(),pt=a("a"),Bo=o(),p(nt.$$.fragment),Wo=o(),mt=a("p"),mt.innerHTML=ld,No=o(),ut=a("p"),ut.innerHTML=ad,Go=o(),p(ht.$$.fragment),Zo=o(),_t=a("p"),_t.innerHTML=dd,Qo=o(),p(ft.$$.fragment),Xo=o(),gt=a("p"),gt.innerHTML=cd,Vo=o(),Yo=a("hr"),So=o(),bt=a("a"),qo=o(),p(xt.$$.fragment),Ko=o(),Tt=a("p"),Tt.textContent=id,Oo=o(),yt=a("p"),yt.innerHTML=pd,el=o(),vt=a("p"),vt.innerHTML=nd,tl=o(),$t=a("table"),$t.innerHTML=md,rl=o(),sl=a("hr"),ol=o(),Mt=a("a"),ll=o(),p(wt.$$.fragment),al=o(),Et=a("p"),Et.textContent=ud,dl=o(),jt=a("p"),jt.innerHTML=hd,cl=o(),Ct=a("table"),Ct.innerHTML=_d,il=o(),pl=a("hr"),nl=o(),Jt=a("a"),ml=o(),p(Pt.$$.fragment),ul=o(),kt=a("p"),kt.textContent=fd,hl=o(),Ht=a("p"),Ht.innerHTML=gd,_l=o(),It=a("table"),It.innerHTML=bd,fl=o(),gl=a("hr"),bl=o(),Ft=a("a"),xl=o(),p(Lt.$$.fragment),Tl=o(),At=a("p"),At.innerHTML=xd,yl=o(),vl=a("hr"),$l=o(),Rt=a("a"),Ml=o(),p(Ut.$$.fragment),wl=o(),zt=a("p"),zt.textContent=Td,El=o(),Dt=a("p"),Dt.innerHTML=yd,jl=o(),Cl=a("hr"),Jl=o(),Bt=a("a"),Pl=o(),p(Wt.$$.fragment),kl=o(),Nt=a("p"),Nt.innerHTML=vd,Hl=o(),Gt=a("table"),Gt.innerHTML=$d,Il=o(),Fl=a("hr"),Ll=o(),Zt=a("a"),Al=o(),p(Qt.$$.fragment),Rl=o(),Xt=a("p"),Xt.innerHTML=Md,Ul=o(),Vt=a("table"),Vt.innerHTML=wd,zl=o(),Dl=a("hr"),Bl=o(),Yt=a("a"),Wl=o(),p(St.$$.fragment),Nl=o(),qt=a("p"),qt.innerHTML=Ed,Gl=o(),Kt=a("table"),Kt.innerHTML=jd,Zl=o(),Ql=a("hr"),Xl=o(),Ot=a("a"),Vl=o(),p(er.$$.fragment),Yl=o(),tr=a("p"),tr.innerHTML=Cd,Sl=o(),rr=a("table"),rr.innerHTML=Jd,ql=o(),Kl=a("hr"),Ol=o(),or=a("p"),this.h()},l(e){const t=Ld("svelte-u9bgzb",document.head);b=d(t,"META",{name:!0,content:!0}),t.forEach(r),lr=l(e),sr=d(e,"P",{}),f(sr).forEach(r),ar=l(e),x=d(e,"A",{id:!0,class:!0}),f(x).forEach(r),dr=l(e),n(T.$$.fragment,e),cr=l(e),y=d(e,"P",{"data-svelte-h":!0}),c(y)!=="svelte-w0rx8m"&&(y.textContent=sa),ir=l(e),v=d(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1olsie5"&&(v.innerHTML=oa),pr=l(e),n($.$$.fragment,e),nr=l(e),M=d(e,"UL",{"data-svelte-h":!0}),c(M)!=="svelte-1ykpik5"&&(M.innerHTML=la),mr=l(e),ur=d(e,"HR",{}),hr=l(e),w=d(e,"A",{id:!0,class:!0}),f(w).forEach(r),_r=l(e),n(E.$$.fragment,e),fr=l(e),j=d(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-14r3pvv"&&(j.textContent=aa),gr=l(e),C=d(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-fac4cj"&&(C.innerHTML=da),br=l(e),xr=d(e,"HR",{}),Tr=l(e),J=d(e,"A",{id:!0,class:!0}),f(J).forEach(r),yr=l(e),n(P.$$.fragment,e),vr=l(e),k=d(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-k3m2wg"&&(k.textContent=ca),$r=l(e),H=d(e,"TABLE",{"data-svelte-h":!0}),c(H)!=="svelte-rd7ds7"&&(H.innerHTML=ia),Mr=l(e),wr=d(e,"HR",{}),Er=l(e),I=d(e,"A",{id:!0,class:!0}),f(I).forEach(r),jr=l(e),n(F.$$.fragment,e),Cr=l(e),L=d(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-8k8cys"&&(L.textContent=pa),Jr=l(e),A=d(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-18p52n5"&&(A.innerHTML=na),Pr=l(e),R=d(e,"UL",{"data-svelte-h":!0}),c(R)!=="svelte-et94dj"&&(R.innerHTML=ma),kr=l(e),Hr=d(e,"HR",{}),Ir=l(e),U=d(e,"A",{id:!0,class:!0}),f(U).forEach(r),Fr=l(e),n(z.$$.fragment,e),Lr=l(e),D=d(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-1mp2vol"&&(D.textContent=ua),Ar=l(e),B=d(e,"TABLE",{"data-svelte-h":!0}),c(B)!=="svelte-eb9kev"&&(B.innerHTML=ha),Rr=l(e),Ur=d(e,"HR",{}),zr=l(e),W=d(e,"A",{id:!0,class:!0}),f(W).forEach(r),Dr=l(e),n(N.$$.fragment,e),Br=l(e),G=d(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1q6eyx4"&&(G.textContent=_a),Wr=l(e),Z=d(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-ar7q77"&&(Z.innerHTML=fa),Nr=l(e),Q=d(e,"TABLE",{"data-svelte-h":!0}),c(Q)!=="svelte-klyf4z"&&(Q.innerHTML=ga),Gr=l(e),Zr=d(e,"HR",{}),Qr=l(e),X=d(e,"A",{id:!0,class:!0}),f(X).forEach(r),Xr=l(e),n(V.$$.fragment,e),Vr=l(e),Y=d(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1mmkb9p"&&(Y.textContent=ba),Yr=l(e),S=d(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-110o3sn"&&(S.innerHTML=xa),Sr=l(e),q=d(e,"TABLE",{"data-svelte-h":!0}),c(q)!=="svelte-iqjbgm"&&(q.innerHTML=Ta),qr=l(e),Kr=d(e,"HR",{}),Or=l(e),K=d(e,"A",{id:!0,class:!0}),f(K).forEach(r),es=l(e),n(O.$$.fragment,e),ts=l(e),ee=d(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-10g8wi9"&&(ee.textContent=ya),rs=l(e),te=d(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-cd20o3"&&(te.innerHTML=va),ss=l(e),re=d(e,"TABLE",{"data-svelte-h":!0}),c(re)!=="svelte-nvuziu"&&(re.innerHTML=$a),os=l(e),ls=d(e,"HR",{}),as=l(e),se=d(e,"A",{id:!0,class:!0}),f(se).forEach(r),ds=l(e),n(oe.$$.fragment,e),cs=l(e),le=d(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-1ljq1px"&&(le.textContent=Ma),is=l(e),ae=d(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-1pa0uk8"&&(ae.innerHTML=wa),ps=l(e),de=d(e,"TABLE",{"data-svelte-h":!0}),c(de)!=="svelte-74khbv"&&(de.innerHTML=Ea),ns=l(e),ms=d(e,"HR",{}),us=l(e),ce=d(e,"A",{id:!0,class:!0}),f(ce).forEach(r),hs=l(e),n(ie.$$.fragment,e),_s=l(e),pe=d(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-y1gxwn"&&(pe.textContent=ja),fs=l(e),ne=d(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-1xz91ac"&&(ne.innerHTML=Ca),gs=l(e),me=d(e,"UL",{"data-svelte-h":!0}),c(me)!=="svelte-1ezq2y6"&&(me.innerHTML=Ja),bs=l(e),xs=d(e,"HR",{}),Ts=l(e),ue=d(e,"A",{id:!0,class:!0}),f(ue).forEach(r),ys=l(e),n(he.$$.fragment,e),vs=l(e),_e=d(e,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-1qlqxsv"&&(_e.textContent=Pa),$s=l(e),fe=d(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-6tjpr7"&&(fe.innerHTML=ka),Ms=l(e),ge=d(e,"TABLE",{"data-svelte-h":!0}),c(ge)!=="svelte-1hxx2o3"&&(ge.innerHTML=Ha),ws=l(e),Es=d(e,"HR",{}),js=l(e),be=d(e,"A",{id:!0,class:!0}),f(be).forEach(r),Cs=l(e),n(xe.$$.fragment,e),Js=l(e),Te=d(e,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-j2v54d"&&(Te.innerHTML=Ia),Ps=l(e),ks=d(e,"HR",{}),Hs=l(e),ye=d(e,"A",{id:!0,class:!0}),f(ye).forEach(r),Is=l(e),n(ve.$$.fragment,e),Fs=l(e),$e=d(e,"P",{"data-svelte-h":!0}),c($e)!=="svelte-75c7d5"&&($e.innerHTML=Fa),Ls=l(e),Me=d(e,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-o8p6wm"&&(Me.innerHTML=La),As=l(e),we=d(e,"TABLE",{"data-svelte-h":!0}),c(we)!=="svelte-yqya7v"&&(we.innerHTML=Aa),Rs=l(e),Us=d(e,"HR",{}),zs=l(e),Ee=d(e,"A",{id:!0,class:!0}),f(Ee).forEach(r),Ds=l(e),n(je.$$.fragment,e),Bs=l(e),Ce=d(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-gl8gb6"&&(Ce.textContent=Ra),Ws=l(e),Je=d(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-1qxvzd2"&&(Je.innerHTML=Ua),Ns=l(e),Pe=d(e,"TABLE",{"data-svelte-h":!0}),c(Pe)!=="svelte-1f7z42u"&&(Pe.innerHTML=za),Gs=l(e),Zs=d(e,"HR",{}),Qs=l(e),ke=d(e,"A",{id:!0,class:!0}),f(ke).forEach(r),Xs=l(e),n(He.$$.fragment,e),Vs=l(e),Ie=d(e,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-7vs1p7"&&(Ie.textContent=Da),Ys=l(e),Fe=d(e,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-15rcpil"&&(Fe.innerHTML=Ba),Ss=l(e),Le=d(e,"TABLE",{"data-svelte-h":!0}),c(Le)!=="svelte-3xdz32"&&(Le.innerHTML=Wa),qs=l(e),Ks=d(e,"HR",{}),Os=l(e),Ae=d(e,"A",{id:!0,class:!0}),f(Ae).forEach(r),eo=l(e),n(Re.$$.fragment,e),to=l(e),Ue=d(e,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-frdp8m"&&(Ue.textContent=Na),ro=l(e),ze=d(e,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-j2v54d"&&(ze.innerHTML=Ga),so=l(e),De=d(e,"TABLE",{"data-svelte-h":!0}),c(De)!=="svelte-11rkhka"&&(De.innerHTML=Za),oo=l(e),lo=d(e,"HR",{}),ao=l(e),Be=d(e,"A",{id:!0,class:!0}),f(Be).forEach(r),co=l(e),n(We.$$.fragment,e),io=l(e),Ne=d(e,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-o9f953"&&(Ne.textContent=Qa),po=l(e),Ge=d(e,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-fac4cj"&&(Ge.innerHTML=Xa),no=l(e),Ze=d(e,"UL",{"data-svelte-h":!0}),c(Ze)!=="svelte-1v579im"&&(Ze.innerHTML=Va),mo=l(e),uo=d(e,"HR",{}),ho=l(e),Qe=d(e,"A",{id:!0,class:!0}),f(Qe).forEach(r),_o=l(e),n(Xe.$$.fragment,e),fo=l(e),Ve=d(e,"P",{"data-svelte-h":!0}),c(Ve)!=="svelte-1naom0u"&&(Ve.textContent=Ya),go=l(e),Ye=d(e,"TABLE",{"data-svelte-h":!0}),c(Ye)!=="svelte-ilxs6c"&&(Ye.innerHTML=Sa),bo=l(e),xo=d(e,"HR",{}),To=l(e),Se=d(e,"A",{id:!0,class:!0}),f(Se).forEach(r),yo=l(e),n(qe.$$.fragment,e),vo=l(e),Ke=d(e,"P",{"data-svelte-h":!0}),c(Ke)!=="svelte-zbbm3j"&&(Ke.textContent=qa),$o=l(e),Oe=d(e,"P",{"data-svelte-h":!0}),c(Oe)!=="svelte-kflsb2"&&(Oe.innerHTML=Ka),Mo=l(e),et=d(e,"TABLE",{"data-svelte-h":!0}),c(et)!=="svelte-pm1u9z"&&(et.innerHTML=Oa),wo=l(e),Eo=d(e,"HR",{}),jo=l(e),tt=d(e,"A",{id:!0,class:!0}),f(tt).forEach(r),Co=l(e),n(rt.$$.fragment,e),Jo=l(e),st=d(e,"P",{"data-svelte-h":!0}),c(st)!=="svelte-17pib55"&&(st.textContent=ed),Po=l(e),ot=d(e,"P",{"data-svelte-h":!0}),c(ot)!=="svelte-1ljhyyr"&&(ot.innerHTML=td),ko=l(e),Ho=d(e,"HR",{}),Io=l(e),lt=d(e,"A",{id:!0,class:!0}),f(lt).forEach(r),Fo=l(e),n(at.$$.fragment,e),Lo=l(e),dt=d(e,"P",{"data-svelte-h":!0}),c(dt)!=="svelte-r5x3fh"&&(dt.textContent=rd),Ao=l(e),ct=d(e,"P",{"data-svelte-h":!0}),c(ct)!=="svelte-1vpvonk"&&(ct.innerHTML=sd),Ro=l(e),it=d(e,"TABLE",{"data-svelte-h":!0}),c(it)!=="svelte-nv3lon"&&(it.innerHTML=od),Uo=l(e),zo=d(e,"HR",{}),Do=l(e),pt=d(e,"A",{id:!0,class:!0}),f(pt).forEach(r),Bo=l(e),n(nt.$$.fragment,e),Wo=l(e),mt=d(e,"P",{"data-svelte-h":!0}),c(mt)!=="svelte-62dsf9"&&(mt.innerHTML=ld),No=l(e),ut=d(e,"P",{"data-svelte-h":!0}),c(ut)!=="svelte-11vd43e"&&(ut.innerHTML=ad),Go=l(e),n(ht.$$.fragment,e),Zo=l(e),_t=d(e,"P",{"data-svelte-h":!0}),c(_t)!=="svelte-c0cgha"&&(_t.innerHTML=dd),Qo=l(e),n(ft.$$.fragment,e),Xo=l(e),gt=d(e,"P",{"data-svelte-h":!0}),c(gt)!=="svelte-wmyz1o"&&(gt.innerHTML=cd),Vo=l(e),Yo=d(e,"HR",{}),So=l(e),bt=d(e,"A",{id:!0,class:!0}),f(bt).forEach(r),qo=l(e),n(xt.$$.fragment,e),Ko=l(e),Tt=d(e,"P",{"data-svelte-h":!0}),c(Tt)!=="svelte-jwfdp9"&&(Tt.textContent=id),Oo=l(e),yt=d(e,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-t85gxq"&&(yt.innerHTML=pd),el=l(e),vt=d(e,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-y7m8db"&&(vt.innerHTML=nd),tl=l(e),$t=d(e,"TABLE",{"data-svelte-h":!0}),c($t)!=="svelte-1oj79mt"&&($t.innerHTML=md),rl=l(e),sl=d(e,"HR",{}),ol=l(e),Mt=d(e,"A",{id:!0,class:!0}),f(Mt).forEach(r),ll=l(e),n(wt.$$.fragment,e),al=l(e),Et=d(e,"P",{"data-svelte-h":!0}),c(Et)!=="svelte-kjzox5"&&(Et.textContent=ud),dl=l(e),jt=d(e,"P",{"data-svelte-h":!0}),c(jt)!=="svelte-19qboln"&&(jt.innerHTML=hd),cl=l(e),Ct=d(e,"TABLE",{"data-svelte-h":!0}),c(Ct)!=="svelte-1bv5sxq"&&(Ct.innerHTML=_d),il=l(e),pl=d(e,"HR",{}),nl=l(e),Jt=d(e,"A",{id:!0,class:!0}),f(Jt).forEach(r),ml=l(e),n(Pt.$$.fragment,e),ul=l(e),kt=d(e,"P",{"data-svelte-h":!0}),c(kt)!=="svelte-16rftxc"&&(kt.textContent=fd),hl=l(e),Ht=d(e,"P",{"data-svelte-h":!0}),c(Ht)!=="svelte-1tnxmuc"&&(Ht.innerHTML=gd),_l=l(e),It=d(e,"TABLE",{"data-svelte-h":!0}),c(It)!=="svelte-16qfwhw"&&(It.innerHTML=bd),fl=l(e),gl=d(e,"HR",{}),bl=l(e),Ft=d(e,"A",{id:!0,class:!0}),f(Ft).forEach(r),xl=l(e),n(Lt.$$.fragment,e),Tl=l(e),At=d(e,"P",{"data-svelte-h":!0}),c(At)!=="svelte-164871i"&&(At.innerHTML=xd),yl=l(e),vl=d(e,"HR",{}),$l=l(e),Rt=d(e,"A",{id:!0,class:!0}),f(Rt).forEach(r),Ml=l(e),n(Ut.$$.fragment,e),wl=l(e),zt=d(e,"P",{"data-svelte-h":!0}),c(zt)!=="svelte-2u8xbp"&&(zt.textContent=Td),El=l(e),Dt=d(e,"P",{"data-svelte-h":!0}),c(Dt)!=="svelte-3xndnt"&&(Dt.innerHTML=yd),jl=l(e),Cl=d(e,"HR",{}),Jl=l(e),Bt=d(e,"A",{id:!0,class:!0}),f(Bt).forEach(r),Pl=l(e),n(Wt.$$.fragment,e),kl=l(e),Nt=d(e,"P",{"data-svelte-h":!0}),c(Nt)!=="svelte-cy5pwv"&&(Nt.innerHTML=vd),Hl=l(e),Gt=d(e,"TABLE",{"data-svelte-h":!0}),c(Gt)!=="svelte-1dyar84"&&(Gt.innerHTML=$d),Il=l(e),Fl=d(e,"HR",{}),Ll=l(e),Zt=d(e,"A",{id:!0,class:!0}),f(Zt).forEach(r),Al=l(e),n(Qt.$$.fragment,e),Rl=l(e),Xt=d(e,"P",{"data-svelte-h":!0}),c(Xt)!=="svelte-cy5pwv"&&(Xt.innerHTML=Md),Ul=l(e),Vt=d(e,"TABLE",{"data-svelte-h":!0}),c(Vt)!=="svelte-1cnys15"&&(Vt.innerHTML=wd),zl=l(e),Dl=d(e,"HR",{}),Bl=l(e),Yt=d(e,"A",{id:!0,class:!0}),f(Yt).forEach(r),Wl=l(e),n(St.$$.fragment,e),Nl=l(e),qt=d(e,"P",{"data-svelte-h":!0}),c(qt)!=="svelte-cy5pwv"&&(qt.innerHTML=Ed),Gl=l(e),Kt=d(e,"TABLE",{"data-svelte-h":!0}),c(Kt)!=="svelte-179cln2"&&(Kt.innerHTML=jd),Zl=l(e),Ql=d(e,"HR",{}),Xl=l(e),Ot=d(e,"A",{id:!0,class:!0}),f(Ot).forEach(r),Vl=l(e),n(er.$$.fragment,e),Yl=l(e),tr=d(e,"P",{"data-svelte-h":!0}),c(tr)!=="svelte-cy5pwv"&&(tr.innerHTML=Cd),Sl=l(e),rr=d(e,"TABLE",{"data-svelte-h":!0}),c(rr)!=="svelte-1btb1vt"&&(rr.innerHTML=Jd),ql=l(e),Kl=d(e,"HR",{}),Ol=l(e),or=d(e,"P",{}),f(or).forEach(r),this.h()},h(){i(b,"name","hf:doc:metadata"),i(b,"content",Ud),i(x,"id","module_processors"),i(x,"class","group"),i(w,"id","module_processors.FeatureExtractor"),i(w,"class","group"),i(J,"id","new_module_processors.FeatureExtractor_new"),i(J,"class","group"),i(I,"id","module_processors.ImageFeatureExtractor"),i(I,"class","group"),i(U,"id","new_module_processors.ImageFeatureExtractor_new"),i(U,"class","group"),i(W,"id","module_processors.ImageFeatureExtractor+thumbnail"),i(W,"class","group"),i(X,"id","module_processors.ImageFeatureExtractor+pad_image"),i(X,"class","group"),i(K,"id","module_processors.ImageFeatureExtractor+preprocess"),i(K,"class","group"),i(se,"id","module_processors.ImageFeatureExtractor+_call"),i(se,"class","group"),i(ce,"id","module_processors.DetrFeatureExtractor"),i(ce,"class","group"),i(ue,"id","module_processors.DetrFeatureExtractor+_call"),i(ue,"class","group"),i(be,"id","module_processors.DetrFeatureExtractor+post_process_object_detection"),i(be,"class","group"),i(ye,"id","module_processors.DetrFeatureExtractor+remove_low_and_no_objects"),i(ye,"class","group"),i(Ee,"id","module_processors.DetrFeatureExtractor+check_segment_validity"),i(Ee,"class","group"),i(ke,"id","module_processors.DetrFeatureExtractor+compute_segments"),i(ke,"class","group"),i(Ae,"id","module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"),i(Ae,"class","group"),i(Be,"id","module_processors.Processor"),i(Be,"class","group"),i(Qe,"id","new_module_processors.Processor_new"),i(Qe,"class","group"),i(Se,"id","module_processors.Processor+_call"),i(Se,"class","group"),i(tt,"id","module_processors.WhisperProcessor"),i(tt,"class","group"),i(lt,"id","module_processors.WhisperProcessor+_call"),i(lt,"class","group"),i(pt,"id","module_processors.AutoProcessor"),i(pt,"class","group"),i(bt,"id","module_processors.AutoProcessor.from_pretrained"),i(bt,"class","group"),i(Mt,"id","module_processors..center_to_corners_format"),i(Mt,"class","group"),i(Jt,"id","module_processors..post_process_object_detection"),i(Jt,"class","group"),i(Ft,"id","module_processors..post_process_object_detection..box"),i(Ft,"class","group"),i(Rt,"id","module_processors..HeightWidth"),i(Rt,"class","group"),i(Bt,"id","module_processors..ImageFeatureExtractorResult"),i(Bt,"class","group"),i(Zt,"id","module_processors..PreprocessedImage"),i(Zt,"class","group"),i(Yt,"id","module_processors..DetrFeatureExtractorResult"),i(Yt,"class","group"),i(Ot,"id","module_processors..SamImageProcessorResult"),i(Ot,"class","group")},m(e,t){Ad(document.head,b),s(e,lr,t),s(e,sr,t),s(e,ar,t),s(e,x,t),s(e,dr,t),m(T,e,t),s(e,cr,t),s(e,y,t),s(e,ir,t),s(e,v,t),s(e,pr,t),m($,e,t),s(e,nr,t),s(e,M,t),s(e,mr,t),s(e,ur,t),s(e,hr,t),s(e,w,t),s(e,_r,t),m(E,e,t),s(e,fr,t),s(e,j,t),s(e,gr,t),s(e,C,t),s(e,br,t),s(e,xr,t),s(e,Tr,t),s(e,J,t),s(e,yr,t),m(P,e,t),s(e,vr,t),s(e,k,t),s(e,$r,t),s(e,H,t),s(e,Mr,t),s(e,wr,t),s(e,Er,t),s(e,I,t),s(e,jr,t),m(F,e,t),s(e,Cr,t),s(e,L,t),s(e,Jr,t),s(e,A,t),s(e,Pr,t),s(e,R,t),s(e,kr,t),s(e,Hr,t),s(e,Ir,t),s(e,U,t),s(e,Fr,t),m(z,e,t),s(e,Lr,t),s(e,D,t),s(e,Ar,t),s(e,B,t),s(e,Rr,t),s(e,Ur,t),s(e,zr,t),s(e,W,t),s(e,Dr,t),m(N,e,t),s(e,Br,t),s(e,G,t),s(e,Wr,t),s(e,Z,t),s(e,Nr,t),s(e,Q,t),s(e,Gr,t),s(e,Zr,t),s(e,Qr,t),s(e,X,t),s(e,Xr,t),m(V,e,t),s(e,Vr,t),s(e,Y,t),s(e,Yr,t),s(e,S,t),s(e,Sr,t),s(e,q,t),s(e,qr,t),s(e,Kr,t),s(e,Or,t),s(e,K,t),s(e,es,t),m(O,e,t),s(e,ts,t),s(e,ee,t),s(e,rs,t),s(e,te,t),s(e,ss,t),s(e,re,t),s(e,os,t),s(e,ls,t),s(e,as,t),s(e,se,t),s(e,ds,t),m(oe,e,t),s(e,cs,t),s(e,le,t),s(e,is,t),s(e,ae,t),s(e,ps,t),s(e,de,t),s(e,ns,t),s(e,ms,t),s(e,us,t),s(e,ce,t),s(e,hs,t),m(ie,e,t),s(e,_s,t),s(e,pe,t),s(e,fs,t),s(e,ne,t),s(e,gs,t),s(e,me,t),s(e,bs,t),s(e,xs,t),s(e,Ts,t),s(e,ue,t),s(e,ys,t),m(he,e,t),s(e,vs,t),s(e,_e,t),s(e,$s,t),s(e,fe,t),s(e,Ms,t),s(e,ge,t),s(e,ws,t),s(e,Es,t),s(e,js,t),s(e,be,t),s(e,Cs,t),m(xe,e,t),s(e,Js,t),s(e,Te,t),s(e,Ps,t),s(e,ks,t),s(e,Hs,t),s(e,ye,t),s(e,Is,t),m(ve,e,t),s(e,Fs,t),s(e,$e,t),s(e,Ls,t),s(e,Me,t),s(e,As,t),s(e,we,t),s(e,Rs,t),s(e,Us,t),s(e,zs,t),s(e,Ee,t),s(e,Ds,t),m(je,e,t),s(e,Bs,t),s(e,Ce,t),s(e,Ws,t),s(e,Je,t),s(e,Ns,t),s(e,Pe,t),s(e,Gs,t),s(e,Zs,t),s(e,Qs,t),s(e,ke,t),s(e,Xs,t),m(He,e,t),s(e,Vs,t),s(e,Ie,t),s(e,Ys,t),s(e,Fe,t),s(e,Ss,t),s(e,Le,t),s(e,qs,t),s(e,Ks,t),s(e,Os,t),s(e,Ae,t),s(e,eo,t),m(Re,e,t),s(e,to,t),s(e,Ue,t),s(e,ro,t),s(e,ze,t),s(e,so,t),s(e,De,t),s(e,oo,t),s(e,lo,t),s(e,ao,t),s(e,Be,t),s(e,co,t),m(We,e,t),s(e,io,t),s(e,Ne,t),s(e,po,t),s(e,Ge,t),s(e,no,t),s(e,Ze,t),s(e,mo,t),s(e,uo,t),s(e,ho,t),s(e,Qe,t),s(e,_o,t),m(Xe,e,t),s(e,fo,t),s(e,Ve,t),s(e,go,t),s(e,Ye,t),s(e,bo,t),s(e,xo,t),s(e,To,t),s(e,Se,t),s(e,yo,t),m(qe,e,t),s(e,vo,t),s(e,Ke,t),s(e,$o,t),s(e,Oe,t),s(e,Mo,t),s(e,et,t),s(e,wo,t),s(e,Eo,t),s(e,jo,t),s(e,tt,t),s(e,Co,t),m(rt,e,t),s(e,Jo,t),s(e,st,t),s(e,Po,t),s(e,ot,t),s(e,ko,t),s(e,Ho,t),s(e,Io,t),s(e,lt,t),s(e,Fo,t),m(at,e,t),s(e,Lo,t),s(e,dt,t),s(e,Ao,t),s(e,ct,t),s(e,Ro,t),s(e,it,t),s(e,Uo,t),s(e,zo,t),s(e,Do,t),s(e,pt,t),s(e,Bo,t),m(nt,e,t),s(e,Wo,t),s(e,mt,t),s(e,No,t),s(e,ut,t),s(e,Go,t),m(ht,e,t),s(e,Zo,t),s(e,_t,t),s(e,Qo,t),m(ft,e,t),s(e,Xo,t),s(e,gt,t),s(e,Vo,t),s(e,Yo,t),s(e,So,t),s(e,bt,t),s(e,qo,t),m(xt,e,t),s(e,Ko,t),s(e,Tt,t),s(e,Oo,t),s(e,yt,t),s(e,el,t),s(e,vt,t),s(e,tl,t),s(e,$t,t),s(e,rl,t),s(e,sl,t),s(e,ol,t),s(e,Mt,t),s(e,ll,t),m(wt,e,t),s(e,al,t),s(e,Et,t),s(e,dl,t),s(e,jt,t),s(e,cl,t),s(e,Ct,t),s(e,il,t),s(e,pl,t),s(e,nl,t),s(e,Jt,t),s(e,ml,t),m(Pt,e,t),s(e,ul,t),s(e,kt,t),s(e,hl,t),s(e,Ht,t),s(e,_l,t),s(e,It,t),s(e,fl,t),s(e,gl,t),s(e,bl,t),s(e,Ft,t),s(e,xl,t),m(Lt,e,t),s(e,Tl,t),s(e,At,t),s(e,yl,t),s(e,vl,t),s(e,$l,t),s(e,Rt,t),s(e,Ml,t),m(Ut,e,t),s(e,wl,t),s(e,zt,t),s(e,El,t),s(e,Dt,t),s(e,jl,t),s(e,Cl,t),s(e,Jl,t),s(e,Bt,t),s(e,Pl,t),m(Wt,e,t),s(e,kl,t),s(e,Nt,t),s(e,Hl,t),s(e,Gt,t),s(e,Il,t),s(e,Fl,t),s(e,Ll,t),s(e,Zt,t),s(e,Al,t),m(Qt,e,t),s(e,Rl,t),s(e,Xt,t),s(e,Ul,t),s(e,Vt,t),s(e,zl,t),s(e,Dl,t),s(e,Bl,t),s(e,Yt,t),s(e,Wl,t),m(St,e,t),s(e,Nl,t),s(e,qt,t),s(e,Gl,t),s(e,Kt,t),s(e,Zl,t),s(e,Ql,t),s(e,Xl,t),s(e,Ot,t),s(e,Vl,t),m(er,e,t),s(e,Yl,t),s(e,tr,t),s(e,Sl,t),s(e,rr,t),s(e,ql,t),s(e,Kl,t),s(e,Ol,t),s(e,or,t),ea=!0},p:kd,i(e){ea||(u(T.$$.fragment,e),u($.$$.fragment,e),u(E.$$.fragment,e),u(P.$$.fragment,e),u(F.$$.fragment,e),u(z.$$.fragment,e),u(N.$$.fragment,e),u(V.$$.fragment,e),u(O.$$.fragment,e),u(oe.$$.fragment,e),u(ie.$$.fragment,e),u(he.$$.fragment,e),u(xe.$$.fragment,e),u(ve.$$.fragment,e),u(je.$$.fragment,e),u(He.$$.fragment,e),u(Re.$$.fragment,e),u(We.$$.fragment,e),u(Xe.$$.fragment,e),u(qe.$$.fragment,e),u(rt.$$.fragment,e),u(at.$$.fragment,e),u(nt.$$.fragment,e),u(ht.$$.fragment,e),u(ft.$$.fragment,e),u(xt.$$.fragment,e),u(wt.$$.fragment,e),u(Pt.$$.fragment,e),u(Lt.$$.fragment,e),u(Ut.$$.fragment,e),u(Wt.$$.fragment,e),u(Qt.$$.fragment,e),u(St.$$.fragment,e),u(er.$$.fragment,e),ea=!0)},o(e){h(T.$$.fragment,e),h($.$$.fragment,e),h(E.$$.fragment,e),h(P.$$.fragment,e),h(F.$$.fragment,e),h(z.$$.fragment,e),h(N.$$.fragment,e),h(V.$$.fragment,e),h(O.$$.fragment,e),h(oe.$$.fragment,e),h(ie.$$.fragment,e),h(he.$$.fragment,e),h(xe.$$.fragment,e),h(ve.$$.fragment,e),h(je.$$.fragment,e),h(He.$$.fragment,e),h(Re.$$.fragment,e),h(We.$$.fragment,e),h(Xe.$$.fragment,e),h(qe.$$.fragment,e),h(rt.$$.fragment,e),h(at.$$.fragment,e),h(nt.$$.fragment,e),h(ht.$$.fragment,e),h(ft.$$.fragment,e),h(xt.$$.fragment,e),h(wt.$$.fragment,e),h(Pt.$$.fragment,e),h(Lt.$$.fragment,e),h(Ut.$$.fragment,e),h(Wt.$$.fragment,e),h(Qt.$$.fragment,e),h(St.$$.fragment,e),h(er.$$.fragment,e),ea=!1},d(e){e&&(r(lr),r(sr),r(ar),r(x),r(dr),r(cr),r(y),r(ir),r(v),r(pr),r(nr),r(M),r(mr),r(ur),r(hr),r(w),r(_r),r(fr),r(j),r(gr),r(C),r(br),r(xr),r(Tr),r(J),r(yr),r(vr),r(k),r($r),r(H),r(Mr),r(wr),r(Er),r(I),r(jr),r(Cr),r(L),r(Jr),r(A),r(Pr),r(R),r(kr),r(Hr),r(Ir),r(U),r(Fr),r(Lr),r(D),r(Ar),r(B),r(Rr),r(Ur),r(zr),r(W),r(Dr),r(Br),r(G),r(Wr),r(Z),r(Nr),r(Q),r(Gr),r(Zr),r(Qr),r(X),r(Xr),r(Vr),r(Y),r(Yr),r(S),r(Sr),r(q),r(qr),r(Kr),r(Or),r(K),r(es),r(ts),r(ee),r(rs),r(te),r(ss),r(re),r(os),r(ls),r(as),r(se),r(ds),r(cs),r(le),r(is),r(ae),r(ps),r(de),r(ns),r(ms),r(us),r(ce),r(hs),r(_s),r(pe),r(fs),r(ne),r(gs),r(me),r(bs),r(xs),r(Ts),r(ue),r(ys),r(vs),r(_e),r($s),r(fe),r(Ms),r(ge),r(ws),r(Es),r(js),r(be),r(Cs),r(Js),r(Te),r(Ps),r(ks),r(Hs),r(ye),r(Is),r(Fs),r($e),r(Ls),r(Me),r(As),r(we),r(Rs),r(Us),r(zs),r(Ee),r(Ds),r(Bs),r(Ce),r(Ws),r(Je),r(Ns),r(Pe),r(Gs),r(Zs),r(Qs),r(ke),r(Xs),r(Vs),r(Ie),r(Ys),r(Fe),r(Ss),r(Le),r(qs),r(Ks),r(Os),r(Ae),r(eo),r(to),r(Ue),r(ro),r(ze),r(so),r(De),r(oo),r(lo),r(ao),r(Be),r(co),r(io),r(Ne),r(po),r(Ge),r(no),r(Ze),r(mo),r(uo),r(ho),r(Qe),r(_o),r(fo),r(Ve),r(go),r(Ye),r(bo),r(xo),r(To),r(Se),r(yo),r(vo),r(Ke),r($o),r(Oe),r(Mo),r(et),r(wo),r(Eo),r(jo),r(tt),r(Co),r(Jo),r(st),r(Po),r(ot),r(ko),r(Ho),r(Io),r(lt),r(Fo),r(Lo),r(dt),r(Ao),r(ct),r(Ro),r(it),r(Uo),r(zo),r(Do),r(pt),r(Bo),r(Wo),r(mt),r(No),r(ut),r(Go),r(Zo),r(_t),r(Qo),r(Xo),r(gt),r(Vo),r(Yo),r(So),r(bt),r(qo),r(Ko),r(Tt),r(Oo),r(yt),r(el),r(vt),r(tl),r($t),r(rl),r(sl),r(ol),r(Mt),r(ll),r(al),r(Et),r(dl),r(jt),r(cl),r(Ct),r(il),r(pl),r(nl),r(Jt),r(ml),r(ul),r(kt),r(hl),r(Ht),r(_l),r(It),r(fl),r(gl),r(bl),r(Ft),r(xl),r(Tl),r(At),r(yl),r(vl),r($l),r(Rt),r(Ml),r(wl),r(zt),r(El),r(Dt),r(jl),r(Cl),r(Jl),r(Bt),r(Pl),r(kl),r(Nt),r(Hl),r(Gt),r(Il),r(Fl),r(Ll),r(Zt),r(Al),r(Rl),r(Xt),r(Ul),r(Vt),r(zl),r(Dl),r(Bl),r(Yt),r(Wl),r(Nl),r(qt),r(Gl),r(Kt),r(Zl),r(Ql),r(Xl),r(Ot),r(Vl),r(Yl),r(tr),r(Sl),r(rr),r(ql),r(Kl),r(Ol),r(or)),r(b),_(T,e),_($,e),_(E,e),_(P,e),_(F,e),_(z,e),_(N,e),_(V,e),_(O,e),_(oe,e),_(ie,e),_(he,e),_(xe,e),_(ve,e),_(je,e),_(He,e),_(Re,e),_(We,e),_(Xe,e),_(qe,e),_(rt,e),_(at,e),_(nt,e),_(ht,e),_(ft,e),_(xt,e),_(wt,e),_(Pt,e),_(Lt,e),_(Ut,e),_(Wt,e),_(Qt,e),_(St,e),_(er,e)}}}const Ud='{"title":"processors","local":"processors","sections":[{"title":"processors.FeatureExtractor ⇐ <code> Callable </code>","local":"processorsfeatureextractor--code-callable-code","sections":[{"title":"new FeatureExtractor(config)","local":"new-featureextractorconfig","sections":[],"depth":3}],"depth":2},{"title":"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>","local":"processorsimagefeatureextractor--code-featureextractor-code","sections":[{"title":"new ImageFeatureExtractor(config)","local":"new-imagefeatureextractorconfig","sections":[],"depth":3},{"title":"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>","local":"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.preprocess(image) ⇒ <code> Promise. < PreprocessedImage > </code>","local":"imagefeatureextractorpreprocessimage--code-promise--preprocessedimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>","local":"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code","sections":[],"depth":3}],"depth":2},{"title":"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>","local":"processorsdetrfeatureextractor--code-imagefeatureextractor-code","sections":[{"title":"detrFeatureExtractor._call(urls) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>","local":"detrfeatureextractorcallurls--code-promise--detrfeatureextractorresult--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>","local":"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code","sections":[],"depth":3},{"title":"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>","local":"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>","local":"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>","local":"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>","local":"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code","sections":[],"depth":3}],"depth":2},{"title":"processors.Processor ⇐ <code> Callable </code>","local":"processorsprocessor--code-callable-code","sections":[{"title":"new Processor(feature_extractor)","local":"new-processorfeatureextractor","sections":[],"depth":3},{"title":"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>","local":"processorcallinput-args--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.WhisperProcessor ⇐ <code> Processor </code>","local":"processorswhisperprocessor--code-processor-code","sections":[{"title":"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>","local":"whisperprocessorcallaudio--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.AutoProcessor","local":"processorsautoprocessor","sections":[{"title":"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>","local":"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code","sections":[],"depth":3}],"depth":2},{"title":"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>","local":"processorscentertocornersformatarr--code-array--number--code","sections":[],"depth":2},{"title":"processors~post_process_object_detection(outputs) ⇒ <code> Array. < Object > </code>","local":"processorspostprocessobjectdetectionoutputs--code-array--object--code","sections":[{"title":"post_process_object_detection~box : <code> Array. < number > </code>","local":"postprocessobjectdetectionbox--code-array--number--code","sections":[],"depth":3}],"depth":2},{"title":"processors~HeightWidth : <code> * </code>","local":"processorsheightwidth--code--code","sections":[],"depth":2},{"title":"processors~ImageFeatureExtractorResult : <code> object </code>","local":"processorsimagefeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~PreprocessedImage : <code> object </code>","local":"processorspreprocessedimage--code-object-code","sections":[],"depth":2},{"title":"processors~DetrFeatureExtractorResult : <code> object </code>","local":"processorsdetrfeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~SamImageProcessorResult : <code> object </code>","local":"processorssamimageprocessorresult--code-object-code","sections":[],"depth":2}],"depth":1}';function zd(ra){return Hd(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gd extends Id{constructor(b){super(),Fd(this,b,zd,Rd,Pd,{})}}export{Gd as component};
