import{s as Te,n as ke,o as He}from"../chunks/scheduler.d6170356.js";import{S as je,i as Ze,g as i,s as a,r as f,A as Je,h as r,f as n,c as l,j as xe,u as h,x as o,k as I,y as Le,a as s,v as g,d as u,t as y,w as b}from"../chunks/index.fcd4cc08.js";import{H as R,g as Ge}from"../chunks/Heading.d2e2e783.js";import{C as de}from"../chunks/CodeBlock.7b16bdef.js";function Ne(pe){let m,z,S,Y,M,X,w,fe="<code>sentence-transformers</code> is a library that provides easy methods to compute embeddings (dense vector representations) for sentences, paragraphs and images. Texts are embedded in a vector space such that similar text is close, which enables applications such as semantic search, clustering, and retrieval.",E,U,B,v,he='You can find over 500 hundred <code>sentence-transformer</code> models by filtering at the left of the <a href="https://huggingface.co/models?library=sentence-transformers&amp;sort=downloads" rel="nofollow">models page</a>. Most of these models support different tasks, such as doing <a href="https://huggingface.co/models?library=sentence-transformers&amp;pipeline_tag=feature-extraction&amp;sort=downloads" rel="nofollow"><code>feature-extraction</code></a> to generate the embedding, and <a href="https://huggingface.co/models?library=sentence-transformers&amp;pipeline_tag=sentence-similarity&amp;sort=downloads" rel="nofollow"><code>sentence-similarity</code></a> as a way to determine how similar is a given sentence to other. You can also find an overview of the official pre-trained models in <a href="https://www.sbert.net/docs/pretrained_models.html" rel="nofollow">the official docs</a>.',P,C,ge="All models on the Hub come up with features:",Q,$,ue="<li>An automatically generated model card with a description, example code snippets, architecture overview, and more.</li> <li>Metadata tags that help for discoverability and contain information such as license.</li> <li>An interactive widget you can use to play out with the model directly in the browser.</li> <li>An Inference API that allows to make inference requests.</li>",F,c,ye='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-sentence_transformers_widget.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-sentence_transformers_widget-dark.png"/>',q,_,A,x,be="The pre-trained models on the Hub can be loaded with a single line of code",D,T,K,k,Me="Here is an example that encodes sentences and then computes the distance between them for doing semantic search.",O,H,ee,j,we="If you want to see how to load a specific model, you can click <code>Use in sentence-transformers</code> and you will be given a working snippet that you can load it!",te,d,Ue='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-sentence_transformers_snippet1.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-sentence_transformers_snippet1-dark.png"/>',ne,p,ve='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-sentence_transformers_snippet2.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-sentence_transformers_snippet2-dark.png"/>',se,Z,ae,J,Ce="You can share your Sentence Transformers by using the <code>save_to_hub</code> method from a trained model.",le,L,ie,G,$e='This command creates a repository with an automatically generated model card, an inference widget, example code snippets, and more! <a href="https://huggingface.co/osanseviero/my_new_model" rel="nofollow">Here</a> is an example.',re,N,oe,V,_e='<li>Sentence Transformers <a href="https://github.com/UKPLab/sentence-transformers" rel="nofollow">library</a>.</li> <li>Sentence Transformers <a href="https://www.sbert.net/" rel="nofollow">docs</a>.</li> <li>Integration with Hub <a href="https://huggingface.co/blog/sentence-transformers-in-the-hub" rel="nofollow">announcement</a>.</li>',me,W,ce;return M=new R({props:{title:"Using Sentence Transformers at Hugging Face",local:"using-sentence-transformers-at-hugging-face",headingTag:"h1"}}),U=new R({props:{title:"Exploring sentence-transformers in the Hub",local:"exploring-sentence-transformers-in-the-hub",headingTag:"h2"}}),_=new R({props:{title:"Using existing models",local:"using-existing-models",headingTag:"h2"}}),T=new de({props:{code:"ZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEFtb2RlbCUyMCUzRCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIoJ21vZGVsX25hbWUnKQ==",highlighted:`<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer
model = SentenceTransformer(<span class="hljs-string">&#x27;model_name&#x27;</span>)`,wrap:!1}}),H=new de({props:{code:"ZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMkMlMjB1dGlsJTBBbW9kZWwlMjAlM0QlMjBTZW50ZW5jZVRyYW5zZm9ybWVyKCdtdWx0aS1xYS1NaW5pTE0tTDYtY29zLXYxJyklMEElMEFxdWVyeV9lbWJlZGRpbmclMjAlM0QlMjBtb2RlbC5lbmNvZGUoJ0hvdyUyMGJpZyUyMGlzJTIwTG9uZG9uJyklMEFwYXNzYWdlX2VtYmVkZGluZyUyMCUzRCUyMG1vZGVsLmVuY29kZSglNUInTG9uZG9uJTIwaGFzJTIwOSUyQzc4NyUyQzQyNiUyMGluaGFiaXRhbnRzJTIwYXQlMjB0aGUlMjAyMDExJTIwY2Vuc3VzJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdMb25kb24lMjBpcyUyMGtub3duJTIwZm9yJTIwaXRzJTIwZmluYWNpYWwlMjBkaXN0cmljdCclNUQpJTBBJTBBcHJpbnQoJTIyU2ltaWxhcml0eSUzQSUyMiUyQyUyMHV0aWwuZG90X3Njb3JlKHF1ZXJ5X2VtYmVkZGluZyUyQyUyMHBhc3NhZ2VfZW1iZWRkaW5nKSk=",highlighted:`<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer, util
model = SentenceTransformer(<span class="hljs-string">&#x27;multi-qa-MiniLM-L6-cos-v1&#x27;</span>)

query_embedding = model.encode(<span class="hljs-string">&#x27;How big is London&#x27;</span>)
passage_embedding = model.encode([<span class="hljs-string">&#x27;London has 9,787,426 inhabitants at the 2011 census&#x27;</span>,
                                  <span class="hljs-string">&#x27;London is known for its finacial district&#x27;</span>])

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Similarity:&quot;</span>, util.dot_score(query_embedding, passage_embedding))`,wrap:!1}}),Z=new R({props:{title:"Sharing your models",local:"sharing-your-models",headingTag:"h2"}}),L=new de({props:{code:"ZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEElMEElMjMlMjBMb2FkJTIwb3IlMjB0cmFpbiUyMGElMjBtb2RlbCUwQW1vZGVsLnNhdmVfdG9faHViKCUyMm15X25ld19tb2RlbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

<span class="hljs-comment"># Load or train a model</span>
model.save_to_hub(<span class="hljs-string">&quot;my_new_model&quot;</span>)`,wrap:!1}}),N=new R({props:{title:"Additional resources",local:"additional-resources",headingTag:"h2"}}),{c(){m=i("meta"),z=a(),S=i("p"),Y=a(),f(M.$$.fragment),X=a(),w=i("p"),w.innerHTML=fe,E=a(),f(U.$$.fragment),B=a(),v=i("p"),v.innerHTML=he,P=a(),C=i("p"),C.textContent=ge,Q=a(),$=i("ol"),$.innerHTML=ue,F=a(),c=i("div"),c.innerHTML=ye,q=a(),f(_.$$.fragment),A=a(),x=i("p"),x.textContent=be,D=a(),f(T.$$.fragment),K=a(),k=i("p"),k.textContent=Me,O=a(),f(H.$$.fragment),ee=a(),j=i("p"),j.innerHTML=we,te=a(),d=i("div"),d.innerHTML=Ue,ne=a(),p=i("div"),p.innerHTML=ve,se=a(),f(Z.$$.fragment),ae=a(),J=i("p"),J.innerHTML=Ce,le=a(),f(L.$$.fragment),ie=a(),G=i("p"),G.innerHTML=$e,re=a(),f(N.$$.fragment),oe=a(),V=i("ul"),V.innerHTML=_e,me=a(),W=i("p"),this.h()},l(e){const t=Je("svelte-u9bgzb",document.head);m=r(t,"META",{name:!0,content:!0}),t.forEach(n),z=l(e),S=r(e,"P",{}),xe(S).forEach(n),Y=l(e),h(M.$$.fragment,e),X=l(e),w=r(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1wv75gz"&&(w.innerHTML=fe),E=l(e),h(U.$$.fragment,e),B=l(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1kwq3q9"&&(v.innerHTML=he),P=l(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1fjy6ak"&&(C.textContent=ge),Q=l(e),$=r(e,"OL",{"data-svelte-h":!0}),o($)!=="svelte-ps2y1k"&&($.innerHTML=ue),F=l(e),c=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(c)!=="svelte-6f1q4b"&&(c.innerHTML=ye),q=l(e),h(_.$$.fragment,e),A=l(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-17convi"&&(x.textContent=be),D=l(e),h(T.$$.fragment,e),K=l(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1coip9"&&(k.textContent=Me),O=l(e),h(H.$$.fragment,e),ee=l(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-j79ve8"&&(j.innerHTML=we),te=l(e),d=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(d)!=="svelte-1dfa4gr"&&(d.innerHTML=Ue),ne=l(e),p=r(e,"DIV",{class:!0,"data-svelte-h":!0}),o(p)!=="svelte-1pl1odp"&&(p.innerHTML=ve),se=l(e),h(Z.$$.fragment,e),ae=l(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-17y3b3y"&&(J.innerHTML=Ce),le=l(e),h(L.$$.fragment,e),ie=l(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1jzzki7"&&(G.innerHTML=$e),re=l(e),h(N.$$.fragment,e),oe=l(e),V=r(e,"UL",{"data-svelte-h":!0}),o(V)!=="svelte-1gh4ozl"&&(V.innerHTML=_e),me=l(e),W=r(e,"P",{}),xe(W).forEach(n),this.h()},h(){I(m,"name","hf:doc:metadata"),I(m,"content",Ve),I(c,"class","flex justify-center"),I(d,"class","flex justify-center"),I(p,"class","flex justify-center")},m(e,t){Le(document.head,m),s(e,z,t),s(e,S,t),s(e,Y,t),g(M,e,t),s(e,X,t),s(e,w,t),s(e,E,t),g(U,e,t),s(e,B,t),s(e,v,t),s(e,P,t),s(e,C,t),s(e,Q,t),s(e,$,t),s(e,F,t),s(e,c,t),s(e,q,t),g(_,e,t),s(e,A,t),s(e,x,t),s(e,D,t),g(T,e,t),s(e,K,t),s(e,k,t),s(e,O,t),g(H,e,t),s(e,ee,t),s(e,j,t),s(e,te,t),s(e,d,t),s(e,ne,t),s(e,p,t),s(e,se,t),g(Z,e,t),s(e,ae,t),s(e,J,t),s(e,le,t),g(L,e,t),s(e,ie,t),s(e,G,t),s(e,re,t),g(N,e,t),s(e,oe,t),s(e,V,t),s(e,me,t),s(e,W,t),ce=!0},p:ke,i(e){ce||(u(M.$$.fragment,e),u(U.$$.fragment,e),u(_.$$.fragment,e),u(T.$$.fragment,e),u(H.$$.fragment,e),u(Z.$$.fragment,e),u(L.$$.fragment,e),u(N.$$.fragment,e),ce=!0)},o(e){y(M.$$.fragment,e),y(U.$$.fragment,e),y(_.$$.fragment,e),y(T.$$.fragment,e),y(H.$$.fragment,e),y(Z.$$.fragment,e),y(L.$$.fragment,e),y(N.$$.fragment,e),ce=!1},d(e){e&&(n(z),n(S),n(Y),n(X),n(w),n(E),n(B),n(v),n(P),n(C),n(Q),n($),n(F),n(c),n(q),n(A),n(x),n(D),n(K),n(k),n(O),n(ee),n(j),n(te),n(d),n(ne),n(p),n(se),n(ae),n(J),n(le),n(ie),n(G),n(re),n(oe),n(V),n(me),n(W)),n(m),b(M,e),b(U,e),b(_,e),b(T,e),b(H,e),b(Z,e),b(L,e),b(N,e)}}}const Ve='{"title":"Using Sentence Transformers at Hugging Face","local":"using-sentence-transformers-at-hugging-face","sections":[{"title":"Exploring sentence-transformers in the Hub","local":"exploring-sentence-transformers-in-the-hub","sections":[],"depth":2},{"title":"Using existing models","local":"using-existing-models","sections":[],"depth":2},{"title":"Sharing your models","local":"sharing-your-models","sections":[],"depth":2},{"title":"Additional resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function Se(pe){return He(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Ge}),[]}class Ye extends je{constructor(m){super(),Ze(this,m,Se,Ne,Te,{})}}export{Ye as component};
