import{s as Kt,f as Dt,o as Pt,n as C}from"../chunks/scheduler.25b97de1.js";import{S as Ot,i as el,g as h,s as c,r as T,A as tl,h as y,f as s,c as m,j as Tt,u as J,x as f,k as $e,y as ll,a as n,v as w,d as b,t as U,w as j}from"../chunks/index.d9030fc9.js";import{T as Y}from"../chunks/Tip.baa67368.js";import{C as X}from"../chunks/CodeBlock.e6cd0d95.js";import{H as P,E as sl}from"../chunks/EditOnGithub.91d95064.js";import{H as Jt,a as Ie}from"../chunks/HfOption.1e589c90.js";function al(g){let t,p='Hugging Face also provides <a href="https://hf.co/docs/text-generation-inference" rel="nofollow">Text Generation Inference (TGI)</a>, a library dedicated to deploying and serving highly optimized LLMs for inference. It includes deployment-oriented optimization features not included in Transformers, such as continuous batching for increasing throughput and tensor parallelism for multi-GPU inference.';return{c(){t=h("p"),t.innerHTML=p},l(l){t=y(l,"P",{"data-svelte-h":!0}),f(t)!=="svelte-utq275"&&(t.innerHTML=p)},m(l,o){n(l,t,o)},p:C,d(l){l&&s(t)}}}function nl(g){let t,p='Currently, only <a href="./model_doc/llama2">Llama</a> and a few other models support static kv-cache and <code>torch.compile</code>. Check <a href="https://github.com/huggingface/transformers/issues/28981" rel="nofollow">this issue</a> for a live model compatibility list.';return{c(){t=h("p"),t.innerHTML=p},l(l){t=y(l,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1cpz1yf"&&(t.innerHTML=p)},m(l,o){n(l,t,o)},p:C,d(l){l&&s(t)}}}function ol(g){let t,p='Regardless of the strategy used with <code>torch.compile</code>, you can avoid shape-related recompilations if you left-pad your LLM inputs to a limited set of values. The <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizer.__call__.pad_to_multiple_of" rel="nofollow"><code>pad_to_multiple_of</code> tokenizer flag</a> is your friend!';return{c(){t=h("p"),t.innerHTML=p},l(l){t=y(l,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1m3bnto"&&(t.innerHTML=p)},m(l,o){n(l,t,o)},p:C,d(l){l&&s(t)}}}function il(g){let t,p='For a more advanced usage of the static cache, such as multi-turn conversations, we recommend instantiating and manipulating the cache object outside <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>. See the advanced usage tab.';return{c(){t=h("p"),t.innerHTML=p},l(l){t=y(l,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1u2oe25"&&(t.innerHTML=p)},m(l,o){n(l,t,o)},p:C,d(l){l&&s(t)}}}function rl(g){let t,p='For this example, let’s use the <a href="https://hf.co/google/gemma-2b" rel="nofollow">Gemma</a> model. All we need to do is to:',l,o,i="<li>Access the model’s <code>generation_config</code> attribute and set the <code>cache_implementation</code> to “static”;</li> <li>Call <code>torch.compile</code> on the model to compile the forward pass with the static kv-cache.</li>",r,M,G="And that’s it!",_,v,k,Z,I="Under the hood, <code>generate</code> will attempt to reuse the same cache object, removing the need for re-compilation at each call. Avoiding re-compilation is critical to get the most out of <code>torch.compile</code>, and you should be aware of the following:",F,V,R="<li>If the batch size changes or the maximum output length increases between calls, the cache will have to be reinitialized, triggering a new compilation;</li> <li>The first couple of calls of the compiled function are slower, as the function is being compiled.</li>",z,B,W;return v=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwb3MlMEFvcy5lbnZpcm9uJTVCJTIyVE9LRU5JWkVSU19QQVJBTExFTElTTSUyMiU1RCUyMCUzRCUyMCUyMmZhbHNlJTIyJTIwJTIwJTIzJTIwVG8lMjBwcmV2ZW50JTIwbG9uZyUyMHdhcm5pbmdzJTIwJTNBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuY2FjaGVfaW1wbGVtZW50YXRpb24lMjAlM0QlMjAlMjJzdGF0aWMlMjIlMEElMEFtb2RlbC5mb3J3YXJkJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbC5mb3J3YXJkJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMlRoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUInVGhlJTIwdGhlb3J5JTIwb2YlMjBzcGVjaWFsJTIwcmVsYXRpdml0eSUyMHN0YXRlcyUyMDEuJTIwVGhlJTIwc3BlZWQlMjBvZiUyMGxpZ2h0JTIwaXMlMjBjb25zdGFudCUyMGluJTIwYWxsJTIwaW5lcnRpYWwlMjByZWZlcmVuY2UnJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># To prevent long warnings :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.generation_config.cache_implementation = <span class="hljs-string">&quot;static&quot;</span>

model.forward = torch.<span class="hljs-built_in">compile</span>(model.forward, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

outputs = model.generate(**input_ids)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference&#x27;</span>]`,wrap:!1}}),B=new Y({props:{warning:!0,$$slots:{default:[il]},$$scope:{ctx:g}}}),{c(){t=h("p"),t.innerHTML=p,l=c(),o=h("ol"),o.innerHTML=i,r=c(),M=h("p"),M.textContent=G,_=c(),T(v.$$.fragment),k=c(),Z=h("p"),Z.innerHTML=I,F=c(),V=h("ol"),V.innerHTML=R,z=c(),T(B.$$.fragment)},l(u){t=y(u,"P",{"data-svelte-h":!0}),f(t)!=="svelte-oys3sj"&&(t.innerHTML=p),l=m(u),o=y(u,"OL",{"data-svelte-h":!0}),f(o)!=="svelte-1fw1ivc"&&(o.innerHTML=i),r=m(u),M=y(u,"P",{"data-svelte-h":!0}),f(M)!=="svelte-9wooxy"&&(M.textContent=G),_=m(u),J(v.$$.fragment,u),k=m(u),Z=y(u,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-yth3sl"&&(Z.innerHTML=I),F=m(u),V=y(u,"OL",{"data-svelte-h":!0}),f(V)!=="svelte-u5kopl"&&(V.innerHTML=R),z=m(u),J(B.$$.fragment,u)},m(u,d){n(u,t,d),n(u,l,d),n(u,o,d),n(u,r,d),n(u,M,d),n(u,_,d),w(v,u,d),n(u,k,d),n(u,Z,d),n(u,F,d),n(u,V,d),n(u,z,d),w(B,u,d),W=!0},p(u,d){const $={};d&2&&($.$$scope={dirty:d,ctx:u}),B.$set($)},i(u){W||(b(v.$$.fragment,u),b(B.$$.fragment,u),W=!0)},o(u){U(v.$$.fragment,u),U(B.$$.fragment,u),W=!1},d(u){u&&(s(t),s(l),s(o),s(r),s(M),s(_),s(k),s(Z),s(F),s(V),s(z)),j(v,u),j(B,u)}}}function pl(g){let t,p='If you want to reuse the same <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> object on a new prompt, be sure to reset its contents with the <code>.reset()</code> method between calls';return{c(){t=h("p"),t.innerHTML=p},l(l){t=y(l,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1m69puv"&&(t.innerHTML=p)},m(l,o){n(l,t,o)},p:C,d(l){l&&s(t)}}}function cl(g){let t,p='A <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> object can be passed to the model’s <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> under the <code>past_key_values</code> argument. The object will retain the cache contents, so you can pass it to a new <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> call to continue generation, like you would do with a dynamic cache.',l,o,i,r,M,G,_='If you want to go further down a level, the <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> object can also be passed to the model’s forward pass under the same <code>past_key_values</code> argument. Using this strategy, you can write your own function to decode the next token given the current token and position and cache position of previously generated tokens.',v,k,Z,I,F="There are a few important things you must do to enable static kv-cache and <code>torch.compile</code> with the <code>StaticCache</code> method:",V,R,z='<li>Initialize the <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StaticCache">StaticCache</a> instance before using the model for inference. There you can configure parameters like the maximum batch size and sequence length.</li> <li>Call <code>torch.compile</code> on the model to compile the forward pass with the static kv-cache.</li> <li>Set <code>enable_math=True</code> in the <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">torch.backends.cuda.sdp_kernel</a> context manager to enable the native PyTorch C++ implementation of scaled dot product attention to speed up inference even more.</li>',B,W,u;return o=new X({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, StaticCache
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># To prevent long warnings :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.forward = torch.<span class="hljs-built_in">compile</span>(model.forward, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt_length = input_ids.input_ids.shape[<span class="hljs-number">1</span>]
model.generation_config.max_new_tokens = <span class="hljs-number">16</span>

past_key_values = StaticCache(
    config=model.config,
    batch_size=<span class="hljs-number">1</span>,
    <span class="hljs-comment"># If you plan to reuse the cache, make sure the cache length is large enough for all cases</span>
    max_cache_len=prompt_length+(model.generation_config.max_new_tokens*<span class="hljs-number">2</span>),
    device=model.device,
    dtype=model.dtype
)
outputs = model.generate(**input_ids, past_key_values=past_key_values)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference frames. 2&#x27;</span>]

<span class="hljs-comment"># pass in the generated text and the same cache object to continue generation from where it left off. Optionally, in a</span>
<span class="hljs-comment"># multi-turn conversation, append the new user input to the generated text.</span>
new_input_ids = outputs
outputs = model.generate(new_input_ids, past_key_values=past_key_values)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference frames. 2. The speed of light is constant in all inertial reference frames. 3.&#x27;</span>]`,wrap:!1}}),r=new Y({props:{warning:!1,$$slots:{default:[pl]},$$scope:{ctx:g}}}),k=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hVG9rZW5pemVyJTJDJTIwTGxhbWFGb3JDYXVzYWxMTSUyQyUyMFN0YXRpY0NhY2hlJTJDJTIwbG9nZ2luZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMudGVzdGluZ191dGlscyUyMGltcG9ydCUyMENhcHR1cmVMb2dnZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJTaW1wbHklMjBwdXQlMkMlMjB0aGUlMjB0aGVvcnklMjBvZiUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjB0aGF0JTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyTXklMjBmYXZvcml0ZSUyMGFsbCUyMHRpbWUlMjBmYXZvcml0ZSUyMGNvbmRpbWVudCUyMGlzJTIwa2V0Y2h1cC4lMjIlMkMlMEElNUQlMEElMEFOVU1fVE9LRU5TX1RPX0dFTkVSQVRFJTIwJTNEJTIwNDAlMEF0b3JjaF9kZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwTGxhbWFUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0yLTdiLWhmJTIyJTJDJTIwcGFkX3Rva2VuJTNEJTIyJTNDJTJGcyUzRSUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMnJpZ2h0JTIyKSUwQW1vZGVsJTIwJTNEJTIwTGxhbWFGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItaGYlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyc2VxdWVudGlhbCUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0cyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSkudG8obW9kZWwuZGV2aWNlKSUwQSUwQWRlZiUyMGRlY29kZV9vbmVfdG9rZW5zKG1vZGVsJTJDJTIwY3VyX3Rva2VuJTJDJTIwaW5wdXRfcG9zJTJDJTIwY2FjaGVfcG9zaXRpb24lMkMlMjBwYXN0X2tleV92YWx1ZXMpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3VyX3Rva2VuJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zaXRpb25faWRzJTNEaW5wdXRfcG9zJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FjaGVfcG9zaXRpb24lM0RjYWNoZV9wb3NpdGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybl9kaWN0JTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2VfY2FjaGUlM0RUcnVlJTBBJTIwJTIwJTIwJTIwKSU1QjAlNUQlMEElMjAlMjAlMjAlMjBuZXdfdG9rZW4lMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTVCJTNBJTJDJTIwLTElNUQlMkMlMjBkaW0lM0QtMSklNUIlM0ElMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbmV3X3Rva2Vu",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaTokenizer, LlamaForCausalLM, StaticCache, logging
<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> CaptureLogger
<span class="hljs-keyword">import</span> torch

prompts = [
    <span class="hljs-string">&quot;Simply put, the theory of relativity states that &quot;</span>,
    <span class="hljs-string">&quot;My favorite all time favorite condiment is ketchup.&quot;</span>,
]

NUM_TOKENS_TO_GENERATE = <span class="hljs-number">40</span>
torch_device = <span class="hljs-string">&quot;cuda&quot;</span>

tokenizer = LlamaTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>, padding_side=<span class="hljs-string">&quot;right&quot;</span>)
model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>, device_map=<span class="hljs-string">&quot;sequential&quot;</span>)
inputs = tokenizer(prompts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>).to(model.device)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decode_one_tokens</span>(<span class="hljs-params">model, cur_token, input_pos, cache_position, past_key_values</span>):
    logits = model(
        cur_token,
        position_ids=input_pos,
        cache_position=cache_position,
        past_key_values=past_key_values,
        return_dict=<span class="hljs-literal">False</span>,
        use_cache=<span class="hljs-literal">True</span>
    )[<span class="hljs-number">0</span>]
    new_token = torch.argmax(logits[:, -<span class="hljs-number">1</span>], dim=-<span class="hljs-number">1</span>)[:, <span class="hljs-literal">None</span>]
    <span class="hljs-keyword">return</span> new_token`,wrap:!1}}),W=new X({props:{code:"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",highlighted:`batch_size, seq_length = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape
<span class="hljs-keyword">with</span> torch.no_grad():
    past_key_values = StaticCache(
        config=model.config, batch_size=<span class="hljs-number">2</span>, max_cache_len=<span class="hljs-number">4096</span>, device=torch_device, dtype=model.dtype
    )
    cache_position = torch.arange(seq_length, device=torch_device)
    generated_ids = torch.zeros(
        batch_size, seq_length + NUM_TOKENS_TO_GENERATE + <span class="hljs-number">1</span>, dtype=torch.<span class="hljs-built_in">int</span>, device=torch_device
    )
    generated_ids[:, cache_position] = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].to(torch_device).to(torch.<span class="hljs-built_in">int</span>)

    logits = model(
        **inputs, cache_position=cache_position, past_key_values=past_key_values,return_dict=<span class="hljs-literal">False</span>, use_cache=<span class="hljs-literal">True</span>
    )[<span class="hljs-number">0</span>]
    next_token = torch.argmax(logits[:, -<span class="hljs-number">1</span>], dim=-<span class="hljs-number">1</span>)[:, <span class="hljs-literal">None</span>]
    generated_ids[:, seq_length] = next_token[:, <span class="hljs-number">0</span>]

    decode_one_tokens = torch.<span class="hljs-built_in">compile</span>(decode_one_tokens, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
    cache_position = torch.tensor([seq_length + <span class="hljs-number">1</span>], device=torch_device)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, NUM_TOKENS_TO_GENERATE):
        <span class="hljs-keyword">with</span> torch.backends.cuda.sdp_kernel(enable_flash=<span class="hljs-literal">False</span>, enable_mem_efficient=<span class="hljs-literal">False</span>, enable_math=<span class="hljs-literal">True</span>):
            next_token = decode_one_tokens(model, next_token.clone(), <span class="hljs-literal">None</span>, cache_position, past_key_values)
            generated_ids[:, cache_position] = next_token.<span class="hljs-built_in">int</span>()
        cache_position += <span class="hljs-number">1</span>

text = tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
text
[<span class="hljs-string">&#x27;Simply put, the theory of relativity states that 1) the speed of light is constant, 2) the speed of light is the same for all observers, and 3) the laws of physics are the same for all observers.&#x27;</span>,
 <span class="hljs-string">&#x27;My favorite all time favorite condiment is ketchup. I love it on everything. I love it on my eggs, my fries, my chicken, my burgers, my hot dogs, my sandwiches, my salads, my p&#x27;</span>]`,wrap:!1}}),{c(){t=h("p"),t.innerHTML=p,l=c(),T(o.$$.fragment),i=c(),T(r.$$.fragment),M=c(),G=h("p"),G.innerHTML=_,v=c(),T(k.$$.fragment),Z=c(),I=h("p"),I.innerHTML=F,V=c(),R=h("ol"),R.innerHTML=z,B=c(),T(W.$$.fragment)},l(d){t=y(d,"P",{"data-svelte-h":!0}),f(t)!=="svelte-104od17"&&(t.innerHTML=p),l=m(d),J(o.$$.fragment,d),i=m(d),J(r.$$.fragment,d),M=m(d),G=y(d,"P",{"data-svelte-h":!0}),f(G)!=="svelte-10560d5"&&(G.innerHTML=_),v=m(d),J(k.$$.fragment,d),Z=m(d),I=y(d,"P",{"data-svelte-h":!0}),f(I)!=="svelte-1haj213"&&(I.innerHTML=F),V=m(d),R=y(d,"OL",{"data-svelte-h":!0}),f(R)!=="svelte-6jxljc"&&(R.innerHTML=z),B=m(d),J(W.$$.fragment,d)},m(d,$){n(d,t,$),n(d,l,$),w(o,d,$),n(d,i,$),w(r,d,$),n(d,M,$),n(d,G,$),n(d,v,$),w(k,d,$),n(d,Z,$),n(d,I,$),n(d,V,$),n(d,R,$),n(d,B,$),w(W,d,$),u=!0},p(d,$){const N={};$&2&&(N.$$scope={dirty:$,ctx:d}),r.$set(N)},i(d){u||(b(o.$$.fragment,d),b(r.$$.fragment,d),b(k.$$.fragment,d),b(W.$$.fragment,d),u=!0)},o(d){U(o.$$.fragment,d),U(r.$$.fragment,d),U(k.$$.fragment,d),U(W.$$.fragment,d),u=!1},d(d){d&&(s(t),s(l),s(i),s(M),s(G),s(v),s(Z),s(I),s(V),s(R),s(B)),j(o,d),j(r,d),j(k,d),j(W,d)}}}function ml(g){let t,p="Compiling the entire <code>generate</code> function, in terms of code, is even simpler than in the basic usage: call <code>torch.compile</code> on <code>generate</code> to compile the entire function. No need to specify the use of the static cache: although it is compatible, dynamic cache (default) was faster in our benchmarks.",l,o,i,r,M="As a result, we compile not only the model forward pass, but also all input preparation, logit processor operations, and so on. The result should be a slightly <code>generate</code> call, compared to the basic usage example, and the compiled graph may be better suited to more exotic hardware devices or use cases. However, there are severe drawbacks in using this approach:",G,_,v="<li>Compilation is much slower;</li> <li>All parameterization of <code>generate</code> must be done through <code>generation_config</code>;</li> <li>Many warnings and exceptions are suppressed — we suggest testing with its uncompiled form first;</li> <li>Although we are working on it, it is heavily feature restricted (for instance, at the time of writing, generation does not stop if an EOS token is selected).</li>",k;return o=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwb3MlMEFvcy5lbnZpcm9uJTVCJTIyVE9LRU5JWkVSU19QQVJBTExFTElTTSUyMiU1RCUyMCUzRCUyMCUyMmZhbHNlJTIyJTIwJTIwJTIzJTIwVG8lMjBwcmV2ZW50JTIwbG9uZyUyMHdhcm5pbmdzJTIwJTNBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBJTBBbW9kZWwuZ2VuZXJhdGUlMjAlM0QlMjB0b3JjaC5jb21waWxlKG1vZGVsLmdlbmVyYXRlJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMlRoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUInVGhlJTIwdGhlb3J5JTIwb2YlMjBzcGVjaWFsJTIwcmVsYXRpdml0eSUyMHN0YXRlcyUyMDEuJTIwVGhlJTIwc3BlZWQlMjBvZiUyMGxpZ2h0JTIwaXMlMjBjb25zdGFudCUyMGluJTIwYWxsJTIwaW5lcnRpYWwlMjByZWZlcmVuY2UnJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># To prevent long warnings :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.generate = torch.<span class="hljs-built_in">compile</span>(model.generate, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

outputs = model.generate(**input_ids)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference&#x27;</span>]`,wrap:!1}}),{c(){t=h("p"),t.innerHTML=p,l=c(),T(o.$$.fragment),i=c(),r=h("p"),r.innerHTML=M,G=c(),_=h("ol"),_.innerHTML=v},l(Z){t=y(Z,"P",{"data-svelte-h":!0}),f(t)!=="svelte-5smhof"&&(t.innerHTML=p),l=m(Z),J(o.$$.fragment,Z),i=m(Z),r=y(Z,"P",{"data-svelte-h":!0}),f(r)!=="svelte-1sxxqo6"&&(r.innerHTML=M),G=m(Z),_=y(Z,"OL",{"data-svelte-h":!0}),f(_)!=="svelte-tj5w3v"&&(_.innerHTML=v)},m(Z,I){n(Z,t,I),n(Z,l,I),w(o,Z,I),n(Z,i,I),n(Z,r,I),n(Z,G,I),n(Z,_,I),k=!0},p:C,i(Z){k||(b(o.$$.fragment,Z),k=!0)},o(Z){U(o.$$.fragment,Z),k=!1},d(Z){Z&&(s(t),s(l),s(i),s(r),s(G),s(_)),j(o,Z)}}}function dl(g){let t,p,l,o,i,r;return t=new Ie({props:{id:"static-kv",option:"basic usage: generation_config",$$slots:{default:[rl]},$$scope:{ctx:g}}}),l=new Ie({props:{id:"static-kv",option:"advanced usage: control Static Cache",$$slots:{default:[cl]},$$scope:{ctx:g}}}),i=new Ie({props:{id:"static-kv",option:"advanced usage: end-to-end generate compilation",$$slots:{default:[ml]},$$scope:{ctx:g}}}),{c(){T(t.$$.fragment),p=c(),T(l.$$.fragment),o=c(),T(i.$$.fragment)},l(M){J(t.$$.fragment,M),p=m(M),J(l.$$.fragment,M),o=m(M),J(i.$$.fragment,M)},m(M,G){w(t,M,G),n(M,p,G),w(l,M,G),n(M,o,G),w(i,M,G),r=!0},p(M,G){const _={};G&2&&(_.$$scope={dirty:G,ctx:M}),t.$set(_);const v={};G&2&&(v.$$scope={dirty:G,ctx:M}),l.$set(v);const k={};G&2&&(k.$$scope={dirty:G,ctx:M}),i.$set(k)},i(M){r||(b(t.$$.fragment,M),b(l.$$.fragment,M),b(i.$$.fragment,M),r=!0)},o(M){U(t.$$.fragment,M),U(l.$$.fragment,M),U(i.$$.fragment,M),r=!1},d(M){M&&(s(p),s(o)),j(t,M),j(l,M),j(i,M)}}}function Ml(g){let t,p='For a more in-depth explanation, take a look at the <a href="https://hf.co/blog/assisted-generation" rel="nofollow">Assisted Generation: a new direction toward low-latency text generation</a> blog post!';return{c(){t=h("p"),t.innerHTML=p},l(l){t=y(l,"P",{"data-svelte-h":!0}),f(t)!=="svelte-112w74b"&&(t.innerHTML=p)},m(l,o){n(l,t,o)},p:C,d(l){l&&s(t)}}}function ul(g){let t,p="Speculative decoding is only supported for the greedy search and sampling decoding strategies, and it also doesn’t support batched inputs.";return{c(){t=h("p"),t.textContent=p},l(l){t=y(l,"P",{"data-svelte-h":!0}),f(t)!=="svelte-eq929k"&&(t.textContent=p)},m(l,o){n(l,t,o)},p:C,d(l){l&&s(t)}}}function hl(g){let t,p;return t=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGFzc2lzdGFudF9tb2RlbCUzRGFzc2lzdGFudF9tb2RlbCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEElNUIlMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIwdGhhdCUyMHRoZSUyMHNwZWVkJTIwb2YlMjBsaWdodCUyMGlzJTIwY29uc3RhbnQuJTIwJTIwJTIwJTIwJTIyJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, assistant_model=assistant_model)
tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states that the speed of light is constant.    &quot;</span>]`,wrap:!1}}),{c(){T(t.$$.fragment)},l(l){J(t.$$.fragment,l)},m(l,o){w(t,l,o),p=!0},p:C,i(l){p||(b(t.$$.fragment,l),p=!0)},o(l){U(t.$$.fragment,l),p=!1},d(l){j(t,l)}}}function yl(g){let t,p='For speculative sampling decoding, add the <code>do_sample</code> and <code>temperature</code> parameters to the <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method in addition to the assistant model.',l,o,i;return o=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGFzc2lzdGFudF9tb2RlbCUzRGFzc2lzdGFudF9tb2RlbCUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0ZW1wZXJhdHVyZSUzRDAuNyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTVCJTIyRWluc3RlaW4ncyUyMHRoZW9yeSUyMG9mJTIwcmVsYXRpdml0eSUyMHN0YXRlcyUyMHRoYXQlMjBtb3Rpb24lMjBpbiUyMHRoZSUyMHVuaXZlcnNlJTIwaXMlMjBub3QlMjBhJTIwc3RyYWlnaHQlMjBsaW5lLiU1Q24lMjIlNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, assistant_model=assistant_model, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.7</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states that motion in the universe is not a straight line.\\n&quot;</span>]`,wrap:!1}}),{c(){t=h("p"),t.innerHTML=p,l=c(),T(o.$$.fragment)},l(r){t=y(r,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1nmf1gl"&&(t.innerHTML=p),l=m(r),J(o.$$.fragment,r)},m(r,M){n(r,t,M),n(r,l,M),w(o,r,M),i=!0},p:C,i(r){i||(b(o.$$.fragment,r),i=!0)},o(r){U(o.$$.fragment,r),i=!1},d(r){r&&(s(t),s(l)),j(o,r)}}}function fl(g){let t,p,l,o;return t=new Ie({props:{id:"spec-decoding",option:"greedy search",$$slots:{default:[hl]},$$scope:{ctx:g}}}),l=new Ie({props:{id:"spec-decoding",option:"sampling",$$slots:{default:[yl]},$$scope:{ctx:g}}}),{c(){T(t.$$.fragment),p=c(),T(l.$$.fragment)},l(i){J(t.$$.fragment,i),p=m(i),J(l.$$.fragment,i)},m(i,r){w(t,i,r),n(i,p,r),w(l,i,r),o=!0},p(i,r){const M={};r&2&&(M.$$scope={dirty:r,ctx:i}),t.$set(M);const G={};r&2&&(G.$$scope={dirty:r,ctx:i}),l.$set(G)},i(i){o||(b(t.$$.fragment,i),b(l.$$.fragment,i),o=!0)},o(i){U(t.$$.fragment,i),U(l.$$.fragment,i),o=!1},d(i){i&&s(p),j(t,i),j(l,i)}}}function Tl(g){let t,p;return t=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHByb21wdF9sb29rdXBfbnVtX3Rva2VucyUzRDMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSU1QidUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIwdGhhdCUyMGVudHJvcHklMjBpbmNyZWFzZXMlMjB3aXRoJTIwdGVtcGVyYXR1cmUuJTIwJTIwJTIwJTIwJTIwJTIwJyU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;The second law of thermodynamics states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, prompt_lookup_num_tokens=<span class="hljs-number">3</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The second law of thermodynamics states that entropy increases with temperature.      &#x27;</span>]`,wrap:!1}}),{c(){T(t.$$.fragment)},l(l){J(t.$$.fragment,l)},m(l,o){w(t,l,o),p=!0},p:C,i(l){p||(b(t.$$.fragment,l),p=!0)},o(l){U(t.$$.fragment,l),p=!1},d(l){j(t,l)}}}function Jl(g){let t,p='For prompt lookup decoding with sampling, add the <code>do_sample</code> and <code>temperature</code> parameters to the <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method.',l,o,i;return o=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBwcm9tcHRfbG9va3VwX251bV90b2tlbnMlM0QzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRlbXBlcmF0dXJlJTNEMC43KSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUIlMjJUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIwdGhhdCUyMGVuZXJneSUyMGNhbm5vdCUyMGJlJTIwY3JlYXRlZCUyMG5vciUyMGRlc3Ryb3llZC4lMjBJdCdzJTIwbm90JTIwYSUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;The second law of thermodynamics states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
outputs = model.generate(**inputs, prompt_lookup_num_tokens=<span class="hljs-number">3</span>, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.7</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&quot;The second law of thermodynamics states that energy cannot be created nor destroyed. It&#x27;s not a&quot;</span>]`,wrap:!1}}),{c(){t=h("p"),t.innerHTML=p,l=c(),T(o.$$.fragment)},l(r){t=y(r,"P",{"data-svelte-h":!0}),f(t)!=="svelte-arx1ua"&&(t.innerHTML=p),l=m(r),J(o.$$.fragment,r)},m(r,M){n(r,t,M),n(r,l,M),w(o,r,M),i=!0},p:C,i(r){i||(b(o.$$.fragment,r),i=!0)},o(r){U(o.$$.fragment,r),i=!1},d(r){r&&(s(t),s(l)),j(o,r)}}}function wl(g){let t,p,l,o;return t=new Ie({props:{id:"pld",option:"greedy decoding",$$slots:{default:[Tl]},$$scope:{ctx:g}}}),l=new Ie({props:{id:"pld",option:"sampling",$$slots:{default:[Jl]},$$scope:{ctx:g}}}),{c(){T(t.$$.fragment),p=c(),T(l.$$.fragment)},l(i){J(t.$$.fragment,i),p=m(i),J(l.$$.fragment,i)},m(i,r){w(t,i,r),n(i,p,r),w(l,i,r),o=!0},p(i,r){const M={};r&2&&(M.$$scope={dirty:r,ctx:i}),t.$set(M);const G={};r&2&&(G.$$scope={dirty:r,ctx:i}),l.$set(G)},i(i){o||(b(t.$$.fragment,i),b(l.$$.fragment,i),o=!0)},o(i){U(t.$$.fragment,i),U(l.$$.fragment,i),o=!1},d(i){i&&s(p),j(t,i),j(l,i)}}}function bl(g){let t,p="SDPA supports FlashAttention-2 as long as you have the latest PyTorch version installed.";return{c(){t=h("p"),t.textContent=p},l(l){t=y(l,"P",{"data-svelte-h":!0}),f(t)!=="svelte-12yxz1f"&&(t.textContent=p)},m(l,o){n(l,t,o)},p:C,d(l){l&&s(t)}}}function Ul(g){let t,p='There are many quantization libraries (see the <a href="./quantization">Quantization</a> guide for more details) available, such as Quanto, AQLM, AWQ, and AutoGPTQ. Feel free to try them out and see which one works best for your use case. We also recommend reading the <a href="https://hf.co/blog/overview-quantization-transformers" rel="nofollow">Overview of natively supported quantization schemes in 🤗 Transformers</a> blog post which compares AutoGPTQ and bitsandbytes.';return{c(){t=h("p"),t.innerHTML=p},l(l){t=y(l,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1b7gbou"&&(t.innerHTML=p)},m(l,o){n(l,t,o)},p:C,d(l){l&&s(t)}}}function jl(g){let t,p,l,o,i,r,M,G="Large language models (LLMs) have pushed text generation applications, such as chat and code completion models, to the next level by producing text that displays a high level of understanding and fluency. But what makes LLMs so powerful - namely their size - also presents challenges for inference.",_,v,k="Basic inference is slow because LLMs have to be called repeatedly to generate the next token. The input sequence increases as generation progresses, which takes longer and longer for the LLM to process. LLMs also have billions of parameters, making it a challenge to store and handle all those weights in memory.",Z,I,F="This guide will show you how to use the optimization techniques available in Transformers to accelerate LLM inference.",V,R,z,B,W,u,d="During decoding, a LLM computes the key-value (kv) values for each input token and since it is autoregressive, it computes the same kv values each time because the generated output becomes part of the input now. This is not very efficient because you’re recomputing the same kv values each time.",$,N,wt='To optimize this, you can use a kv-cache to store the past keys and values instead of recomputing them each time. However, since the kv-cache grows with each generation step and is dynamic, it prevents you from taking advantage of <a href="./perf_torch_compile"><code>torch.compile</code></a>, a powerful optimization tool that fuses PyTorch code into fast and optimized kernels.',ke,O,bt="The <em>static kv-cache</em> solves this issue by pre-allocating the kv-cache size to a maximum value which allows you to combine it with <code>torch.compile</code> for up to a 4x speed up. Your speed up may vary depending on the model size (larger models have a smaller speed up) and hardware.",Be,E,Re,ee,Ut="There are three flavors of static kv-cache usage, depending on the complexity of your task:",Ve,te,jt="<li>Basic usage: simply set a flag in <code>generation_config</code> (recommended);</li> <li>Advanced usage: handle a cache object for multi-turn generation or a custom generation loop;</li> <li>Advanced usage: compile the entire <code>generate</code> function into a single graph, if having a single graph is relevant for you.</li>",We,le,gt="Select the correct tab below for further instructions on each of these flavors.",Ce,x,Xe,Q,ze,se,Fe,S,Ne,ae,Zt="Another issue with autoregression is that for each input token you need to load the model weights each time during the forward pass. This is slow and cumbersome for LLMs which have billions of parameters. Speculative decoding alleviates this slowdown by using a second smaller and faster assistant model to generate candidate tokens that are verified by the larger LLM in a single forward pass. If the verified tokens are correct, the LLM essentially gets them for “free” without having to generate them itself. There is no degradation in accuracy because the verification forward pass ensures the same outputs are generated as if the LLM had generated them on its own.",He,ne,Gt="To get the largest speed up, the assistant model should be a lot smaller than the LLM so that it can generate tokens quickly. The assistant and LLM model must also share the same tokenizer to avoid re-encoding and decoding tokens.",Ye,L,Ee,oe,vt='Enable speculative decoding by loading an assistant model and passing it to the <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method.',xe,q,Qe,ie,Se,re,It="Prompt lookup decoding is a variant of speculative decoding that is also compatible with greedy search and sampling. Prompt lookup works especially well for input-grounded tasks - such as summarization - where there is often overlapping words between the prompt and output. These overlapping n-grams are used as the LLM candidate tokens.",Le,pe,$t='To enable prompt lookup decoding, specify the number of tokens that should be overlapping in the <code>prompt_lookup_num_tokens</code> parameter. Then you can pass this parameter to the <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method.',qe,A,Ae,ce,Ke,me,_t="A known issue with transformer models is that the self-attention mechanism grows quadratically in compute and memory with the number of input tokens. This limitation is only magnified in LLMs which handles much longer sequences. To address this, try FlashAttention2 or PyTorch’s scaled dot product attention (SDPA), which are more memory efficient attention implementations and can accelerate inference.",De,de,Pe,Me,kt='FlashAttention and <a href="./perf_infer_gpu_one#flashattention-2">FlashAttention-2</a> break up the attention computation into smaller chunks and reduces the number of intermediate read/write operations to GPU memory to speed up inference. FlashAttention-2 improves on the original FlashAttention algorithm by also parallelizing over sequence length dimension and better partitioning work on the hardware to reduce synchronization and communication overhead.',Oe,ue,Bt='To use FlashAttention-2, set <code>attn_implementation=&quot;flash_attention_2&quot;</code> in the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method.',et,he,tt,ye,lt,fe,Rt="Scaled dot product attention (SDPA) is automatically enabled in PyTorch 2.0 and it supports FlashAttention, xFormers, and PyTorch’s C++ implementation. SDPA chooses the most performant attention algorithm if you’re using a CUDA backend. For other backends, SDPA defaults to the PyTorch C++ implementation.",st,K,at,Te,Vt='Use the <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">torch.backends.cuda.sdp_kernel</a> context manager to explicitly enable or disable any of the three attention algorithms. For example, set <code>enable_flash=True</code> to enable FlashAttention.',nt,Je,ot,we,it,be,Wt="Quantization reduces the size of the LLM weights by storing them in a lower precision. This translates to lower memory usage and makes loading LLMs for inference more accessible if you’re constrained by your GPUs memory. If you aren’t limited by your GPU, you don’t necessarily need to quantize your model because it can incur a small latency cost (except for AWQ and fused AWQ modules) due to the extra step required to quantize and dequantize the weights.",rt,D,pt,Ue,Ct='Use the Model Memory Calculator below to estimate and compare how much memory is required to load a model. For example, try estimating how much memory it costs to load <a href="https://huggingface.co/mistralai/Mistral-7B-v0.1" rel="nofollow">Mistral-7B-v0.1</a>.',ct,H,Xt,mt,je,zt='To load Mistral-7B-v0.1 in half-precision, set the <code>torch_dtype</code> parameter in the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModel.from_pretrained">from_pretrained()</a> method to <code>torch.bfloat16</code>. This requires 13.74GB of memory.',dt,ge,Mt,Ze,Ft='To load a quantized model (8-bit or 4-bit) for inference, try <a href="https://hf.co/docs/bitsandbytes" rel="nofollow">bitsandbytes</a> and set the <code>load_in_4bit</code> or <code>load_in_8bit</code> parameters to <code>True</code>. Loading the model in 8-bits only requires 6.87 GB of memory.',ut,Ge,ht,ve,yt,_e,ft;return i=new P({props:{title:"LLM inference optimization",local:"llm-inference-optimization",headingTag:"h1"}}),R=new Y({props:{warning:!1,$$slots:{default:[al]},$$scope:{ctx:g}}}),B=new P({props:{title:"Static kv-cache and torch.compile",local:"static-kv-cache-and-torchcompile",headingTag:"h2"}}),E=new Y({props:{warning:!0,$$slots:{default:[nl]},$$scope:{ctx:g}}}),x=new Y({props:{warning:!1,$$slots:{default:[ol]},$$scope:{ctx:g}}}),Q=new Jt({props:{id:"static-kv",options:["basic usage: generation_config","advanced usage: control Static Cache","advanced usage: end-to-end generate compilation"],$$slots:{default:[dl]},$$scope:{ctx:g}}}),se=new P({props:{title:"Speculative decoding",local:"speculative-decoding",headingTag:"h2"}}),S=new Y({props:{warning:!1,$$slots:{default:[Ml]},$$scope:{ctx:g}}}),L=new Y({props:{warning:!0,$$slots:{default:[ul]},$$scope:{ctx:g}}}),q=new Jt({props:{id:"spec-decoding",options:["greedy search","sampling"],$$slots:{default:[fl]},$$scope:{ctx:g}}}),ie=new P({props:{title:"Prompt lookup decoding",local:"prompt-lookup-decoding",headingTag:"h3"}}),A=new Jt({props:{id:"pld",options:["greedy decoding","sampling"],$$slots:{default:[wl]},$$scope:{ctx:g}}}),ce=new P({props:{title:"Attention optimizations",local:"attention-optimizations",headingTag:"h2"}}),de=new P({props:{title:"FlashAttention-2",local:"flashattention-2",headingTag:"h3"}}),he=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZ2VtbWEtMmIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;google/gemma-2b&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.bfloat16,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
)`,wrap:!1}}),ye=new P({props:{title:"PyTorch scaled dot product attention",local:"pytorch-scaled-dot-product-attention",headingTag:"h3"}}),K=new Y({props:{warning:!1,$$slots:{default:[bl]},$$scope:{ctx:g}}}),Je=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJnb29nbGUlMkZnZW1tYS0yYiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBJTBBd2l0aCUyMHRvcmNoLmJhY2tlbmRzLmN1ZGEuc2RwX2tlcm5lbChlbmFibGVfZmxhc2glM0RUcnVlJTJDJTIwZW5hYmxlX21hdGglM0RGYWxzZSUyQyUyMGVuYWJsZV9tZW1fZWZmaWNpZW50JTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;google/gemma-2b&quot;</span>,
    torch_dtype=torch.bfloat16,
)

<span class="hljs-keyword">with</span> torch.backends.cuda.sdp_kernel(enable_flash=<span class="hljs-literal">True</span>, enable_math=<span class="hljs-literal">False</span>, enable_mem_efficient=<span class="hljs-literal">False</span>):
    outputs = model.generate(**inputs)`,wrap:!1}}),we=new P({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),D=new Y({props:{warning:!1,$$slots:{default:[Ul]},$$scope:{ctx:g}}}),ge=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)`,wrap:!1}}),Ge=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig
<span class="hljs-keyword">import</span> torch

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=quant_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),ve=new sl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/llm_optims.md"}}),{c(){t=h("meta"),p=c(),l=h("p"),o=c(),T(i.$$.fragment),r=c(),M=h("p"),M.textContent=G,_=c(),v=h("p"),v.textContent=k,Z=c(),I=h("p"),I.textContent=F,V=c(),T(R.$$.fragment),z=c(),T(B.$$.fragment),W=c(),u=h("p"),u.textContent=d,$=c(),N=h("p"),N.innerHTML=wt,ke=c(),O=h("p"),O.innerHTML=bt,Be=c(),T(E.$$.fragment),Re=c(),ee=h("p"),ee.textContent=Ut,Ve=c(),te=h("ol"),te.innerHTML=jt,We=c(),le=h("p"),le.textContent=gt,Ce=c(),T(x.$$.fragment),Xe=c(),T(Q.$$.fragment),ze=c(),T(se.$$.fragment),Fe=c(),T(S.$$.fragment),Ne=c(),ae=h("p"),ae.textContent=Zt,He=c(),ne=h("p"),ne.textContent=Gt,Ye=c(),T(L.$$.fragment),Ee=c(),oe=h("p"),oe.innerHTML=vt,xe=c(),T(q.$$.fragment),Qe=c(),T(ie.$$.fragment),Se=c(),re=h("p"),re.textContent=It,Le=c(),pe=h("p"),pe.innerHTML=$t,qe=c(),T(A.$$.fragment),Ae=c(),T(ce.$$.fragment),Ke=c(),me=h("p"),me.textContent=_t,De=c(),T(de.$$.fragment),Pe=c(),Me=h("p"),Me.innerHTML=kt,Oe=c(),ue=h("p"),ue.innerHTML=Bt,et=c(),T(he.$$.fragment),tt=c(),T(ye.$$.fragment),lt=c(),fe=h("p"),fe.textContent=Rt,st=c(),T(K.$$.fragment),at=c(),Te=h("p"),Te.innerHTML=Vt,nt=c(),T(Je.$$.fragment),ot=c(),T(we.$$.fragment),it=c(),be=h("p"),be.textContent=Wt,rt=c(),T(D.$$.fragment),pt=c(),Ue=h("p"),Ue.innerHTML=Ct,ct=c(),H=h("iframe"),mt=c(),je=h("p"),je.innerHTML=zt,dt=c(),T(ge.$$.fragment),Mt=c(),Ze=h("p"),Ze.innerHTML=Ft,ut=c(),T(Ge.$$.fragment),ht=c(),T(ve.$$.fragment),yt=c(),_e=h("p"),this.h()},l(e){const a=tl("svelte-u9bgzb",document.head);t=y(a,"META",{name:!0,content:!0}),a.forEach(s),p=m(e),l=y(e,"P",{}),Tt(l).forEach(s),o=m(e),J(i.$$.fragment,e),r=m(e),M=y(e,"P",{"data-svelte-h":!0}),f(M)!=="svelte-1kjw8nj"&&(M.textContent=G),_=m(e),v=y(e,"P",{"data-svelte-h":!0}),f(v)!=="svelte-1l3iyos"&&(v.textContent=k),Z=m(e),I=y(e,"P",{"data-svelte-h":!0}),f(I)!=="svelte-1wb7yan"&&(I.textContent=F),V=m(e),J(R.$$.fragment,e),z=m(e),J(B.$$.fragment,e),W=m(e),u=y(e,"P",{"data-svelte-h":!0}),f(u)!=="svelte-bq37ce"&&(u.textContent=d),$=m(e),N=y(e,"P",{"data-svelte-h":!0}),f(N)!=="svelte-1cg6awh"&&(N.innerHTML=wt),ke=m(e),O=y(e,"P",{"data-svelte-h":!0}),f(O)!=="svelte-jt9td8"&&(O.innerHTML=bt),Be=m(e),J(E.$$.fragment,e),Re=m(e),ee=y(e,"P",{"data-svelte-h":!0}),f(ee)!=="svelte-1439wi2"&&(ee.textContent=Ut),Ve=m(e),te=y(e,"OL",{"data-svelte-h":!0}),f(te)!=="svelte-165n3j5"&&(te.innerHTML=jt),We=m(e),le=y(e,"P",{"data-svelte-h":!0}),f(le)!=="svelte-etip6m"&&(le.textContent=gt),Ce=m(e),J(x.$$.fragment,e),Xe=m(e),J(Q.$$.fragment,e),ze=m(e),J(se.$$.fragment,e),Fe=m(e),J(S.$$.fragment,e),Ne=m(e),ae=y(e,"P",{"data-svelte-h":!0}),f(ae)!=="svelte-18z9bzk"&&(ae.textContent=Zt),He=m(e),ne=y(e,"P",{"data-svelte-h":!0}),f(ne)!=="svelte-1nm1j4o"&&(ne.textContent=Gt),Ye=m(e),J(L.$$.fragment,e),Ee=m(e),oe=y(e,"P",{"data-svelte-h":!0}),f(oe)!=="svelte-4l211j"&&(oe.innerHTML=vt),xe=m(e),J(q.$$.fragment,e),Qe=m(e),J(ie.$$.fragment,e),Se=m(e),re=y(e,"P",{"data-svelte-h":!0}),f(re)!=="svelte-123yl06"&&(re.textContent=It),Le=m(e),pe=y(e,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-1xnaq70"&&(pe.innerHTML=$t),qe=m(e),J(A.$$.fragment,e),Ae=m(e),J(ce.$$.fragment,e),Ke=m(e),me=y(e,"P",{"data-svelte-h":!0}),f(me)!=="svelte-zxt0p7"&&(me.textContent=_t),De=m(e),J(de.$$.fragment,e),Pe=m(e),Me=y(e,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-pa091d"&&(Me.innerHTML=kt),Oe=m(e),ue=y(e,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-1ym14uu"&&(ue.innerHTML=Bt),et=m(e),J(he.$$.fragment,e),tt=m(e),J(ye.$$.fragment,e),lt=m(e),fe=y(e,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-16n93px"&&(fe.textContent=Rt),st=m(e),J(K.$$.fragment,e),at=m(e),Te=y(e,"P",{"data-svelte-h":!0}),f(Te)!=="svelte-cbkj1o"&&(Te.innerHTML=Vt),nt=m(e),J(Je.$$.fragment,e),ot=m(e),J(we.$$.fragment,e),it=m(e),be=y(e,"P",{"data-svelte-h":!0}),f(be)!=="svelte-x4c749"&&(be.textContent=Wt),rt=m(e),J(D.$$.fragment,e),pt=m(e),Ue=y(e,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-1i2aaqz"&&(Ue.innerHTML=Ct),ct=m(e),H=y(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Tt(H).forEach(s),mt=m(e),je=y(e,"P",{"data-svelte-h":!0}),f(je)!=="svelte-l6iyvl"&&(je.innerHTML=zt),dt=m(e),J(ge.$$.fragment,e),Mt=m(e),Ze=y(e,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-a32zwr"&&(Ze.innerHTML=Ft),ut=m(e),J(Ge.$$.fragment,e),ht=m(e),J(ve.$$.fragment,e),yt=m(e),_e=y(e,"P",{}),Tt(_e).forEach(s),this.h()},h(){$e(t,"name","hf:doc:metadata"),$e(t,"content",gl),Dt(H.src,Xt="https://hf-accelerate-model-memory-usage.hf.space")||$e(H,"src",Xt),$e(H,"frameborder","0"),$e(H,"width","850"),$e(H,"height","450")},m(e,a){ll(document.head,t),n(e,p,a),n(e,l,a),n(e,o,a),w(i,e,a),n(e,r,a),n(e,M,a),n(e,_,a),n(e,v,a),n(e,Z,a),n(e,I,a),n(e,V,a),w(R,e,a),n(e,z,a),w(B,e,a),n(e,W,a),n(e,u,a),n(e,$,a),n(e,N,a),n(e,ke,a),n(e,O,a),n(e,Be,a),w(E,e,a),n(e,Re,a),n(e,ee,a),n(e,Ve,a),n(e,te,a),n(e,We,a),n(e,le,a),n(e,Ce,a),w(x,e,a),n(e,Xe,a),w(Q,e,a),n(e,ze,a),w(se,e,a),n(e,Fe,a),w(S,e,a),n(e,Ne,a),n(e,ae,a),n(e,He,a),n(e,ne,a),n(e,Ye,a),w(L,e,a),n(e,Ee,a),n(e,oe,a),n(e,xe,a),w(q,e,a),n(e,Qe,a),w(ie,e,a),n(e,Se,a),n(e,re,a),n(e,Le,a),n(e,pe,a),n(e,qe,a),w(A,e,a),n(e,Ae,a),w(ce,e,a),n(e,Ke,a),n(e,me,a),n(e,De,a),w(de,e,a),n(e,Pe,a),n(e,Me,a),n(e,Oe,a),n(e,ue,a),n(e,et,a),w(he,e,a),n(e,tt,a),w(ye,e,a),n(e,lt,a),n(e,fe,a),n(e,st,a),w(K,e,a),n(e,at,a),n(e,Te,a),n(e,nt,a),w(Je,e,a),n(e,ot,a),w(we,e,a),n(e,it,a),n(e,be,a),n(e,rt,a),w(D,e,a),n(e,pt,a),n(e,Ue,a),n(e,ct,a),n(e,H,a),n(e,mt,a),n(e,je,a),n(e,dt,a),w(ge,e,a),n(e,Mt,a),n(e,Ze,a),n(e,ut,a),w(Ge,e,a),n(e,ht,a),w(ve,e,a),n(e,yt,a),n(e,_e,a),ft=!0},p(e,[a]){const Nt={};a&2&&(Nt.$$scope={dirty:a,ctx:e}),R.$set(Nt);const Ht={};a&2&&(Ht.$$scope={dirty:a,ctx:e}),E.$set(Ht);const Yt={};a&2&&(Yt.$$scope={dirty:a,ctx:e}),x.$set(Yt);const Et={};a&2&&(Et.$$scope={dirty:a,ctx:e}),Q.$set(Et);const xt={};a&2&&(xt.$$scope={dirty:a,ctx:e}),S.$set(xt);const Qt={};a&2&&(Qt.$$scope={dirty:a,ctx:e}),L.$set(Qt);const St={};a&2&&(St.$$scope={dirty:a,ctx:e}),q.$set(St);const Lt={};a&2&&(Lt.$$scope={dirty:a,ctx:e}),A.$set(Lt);const qt={};a&2&&(qt.$$scope={dirty:a,ctx:e}),K.$set(qt);const At={};a&2&&(At.$$scope={dirty:a,ctx:e}),D.$set(At)},i(e){ft||(b(i.$$.fragment,e),b(R.$$.fragment,e),b(B.$$.fragment,e),b(E.$$.fragment,e),b(x.$$.fragment,e),b(Q.$$.fragment,e),b(se.$$.fragment,e),b(S.$$.fragment,e),b(L.$$.fragment,e),b(q.$$.fragment,e),b(ie.$$.fragment,e),b(A.$$.fragment,e),b(ce.$$.fragment,e),b(de.$$.fragment,e),b(he.$$.fragment,e),b(ye.$$.fragment,e),b(K.$$.fragment,e),b(Je.$$.fragment,e),b(we.$$.fragment,e),b(D.$$.fragment,e),b(ge.$$.fragment,e),b(Ge.$$.fragment,e),b(ve.$$.fragment,e),ft=!0)},o(e){U(i.$$.fragment,e),U(R.$$.fragment,e),U(B.$$.fragment,e),U(E.$$.fragment,e),U(x.$$.fragment,e),U(Q.$$.fragment,e),U(se.$$.fragment,e),U(S.$$.fragment,e),U(L.$$.fragment,e),U(q.$$.fragment,e),U(ie.$$.fragment,e),U(A.$$.fragment,e),U(ce.$$.fragment,e),U(de.$$.fragment,e),U(he.$$.fragment,e),U(ye.$$.fragment,e),U(K.$$.fragment,e),U(Je.$$.fragment,e),U(we.$$.fragment,e),U(D.$$.fragment,e),U(ge.$$.fragment,e),U(Ge.$$.fragment,e),U(ve.$$.fragment,e),ft=!1},d(e){e&&(s(p),s(l),s(o),s(r),s(M),s(_),s(v),s(Z),s(I),s(V),s(z),s(W),s(u),s($),s(N),s(ke),s(O),s(Be),s(Re),s(ee),s(Ve),s(te),s(We),s(le),s(Ce),s(Xe),s(ze),s(Fe),s(Ne),s(ae),s(He),s(ne),s(Ye),s(Ee),s(oe),s(xe),s(Qe),s(Se),s(re),s(Le),s(pe),s(qe),s(Ae),s(Ke),s(me),s(De),s(Pe),s(Me),s(Oe),s(ue),s(et),s(tt),s(lt),s(fe),s(st),s(at),s(Te),s(nt),s(ot),s(it),s(be),s(rt),s(pt),s(Ue),s(ct),s(H),s(mt),s(je),s(dt),s(Mt),s(Ze),s(ut),s(ht),s(yt),s(_e)),s(t),j(i,e),j(R,e),j(B,e),j(E,e),j(x,e),j(Q,e),j(se,e),j(S,e),j(L,e),j(q,e),j(ie,e),j(A,e),j(ce,e),j(de,e),j(he,e),j(ye,e),j(K,e),j(Je,e),j(we,e),j(D,e),j(ge,e),j(Ge,e),j(ve,e)}}}const gl='{"title":"LLM inference optimization","local":"llm-inference-optimization","sections":[{"title":"Static kv-cache and torch.compile","local":"static-kv-cache-and-torchcompile","sections":[],"depth":2},{"title":"Speculative decoding","local":"speculative-decoding","sections":[{"title":"Prompt lookup decoding","local":"prompt-lookup-decoding","sections":[],"depth":3}],"depth":2},{"title":"Attention optimizations","local":"attention-optimizations","sections":[{"title":"FlashAttention-2","local":"flashattention-2","sections":[],"depth":3},{"title":"PyTorch scaled dot product attention","local":"pytorch-scaled-dot-product-attention","sections":[],"depth":3}],"depth":2},{"title":"Quantization","local":"quantization","sections":[],"depth":2}],"depth":1}';function Zl(g){return Pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bl extends Ot{constructor(t){super(),el(this,t,Zl,jl,Kt,{})}}export{Bl as component};
