import{s as go,o as _o,n as or}from"../chunks/scheduler.9bc65507.js";import{S as vo,i as xo,g as n,s as a,r as p,A as $o,h as l,f as t,c as o,j as $,u as f,x as m,k as b,y as s,a as i,v as u,d as h,t as g,w as _}from"../chunks/index.707bf1b6.js";import{T as fa}from"../chunks/Tip.c2ecdbf4.js";import{D as M}from"../chunks/Docstring.86474e80.js";import{C as lr}from"../chunks/CodeBlock.54a9f38d.js";import{E as ua}from"../chunks/ExampleCodeBlock.034f3a73.js";import{H as pe,E as bo}from"../chunks/EditOnGithub.922df6ba.js";function yo(X){let d,T=`This class method is simply calling the feature extractor
<a href="/docs/transformers/main/ja/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/main/ja/internal/image_processing_utils#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){d=n("p"),d.innerHTML=T},l(v){d=l(v,"P",{"data-svelte-h":!0}),m(d)!=="svelte-p7kr8l"&&(d.innerHTML=T)},m(v,x){i(v,d,x)},p:or,d(v){v&&t(d)}}}function Mo(X){let d,T="Examples:",v,x,C;return x=new lr({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBQdXNoJTIwdGhlJTIwcHJvY2Vzc29yJTIwdG8lMjB5b3VyJTIwbmFtZXNwYWNlJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtYmVydCUyMi4lMEFwcm9jZXNzb3IucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLWJlcnQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMHByb2Nlc3NvciUyMHRvJTIwYW4lMjBvcmdhbml6YXRpb24lMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC1iZXJ0JTIyLiUwQXByb2Nlc3Nvci5wdXNoX3RvX2h1YiglMjJodWdnaW5nZmFjZSUyRm15LWZpbmV0dW5lZC1iZXJ0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-comment"># Push the processor to your namespace with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;my-finetuned-bert&quot;</span>)

<span class="hljs-comment"># Push the processor to an organization with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;huggingface/my-finetuned-bert&quot;</span>)`,wrap:!1}}),{c(){d=n("p"),d.textContent=T,v=a(),p(x.$$.fragment)},l(c){d=l(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-kvfsh7"&&(d.textContent=T),v=o(c),f(x.$$.fragment,c)},m(c,j){i(c,d,j),i(c,v,j),u(x,c,j),C=!0},p:or,i(c){C||(h(x.$$.fragment,c),C=!0)},o(c){g(x.$$.fragment,c),C=!1},d(c){c&&(t(d),t(v)),_(x,c)}}}function wo(X){let d,T="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){d=n("p"),d.textContent=T},l(v){d=l(v,"P",{"data-svelte-h":!0}),m(d)!=="svelte-15rpg4"&&(d.textContent=T)},m(v,x){i(v,d,x)},p:or,d(v){v&&t(d)}}}function To(X){let d,T=`This class method is simply calling <a href="/docs/transformers/main/ja/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){d=n("p"),d.innerHTML=T},l(v){d=l(v,"P",{"data-svelte-h":!0}),m(d)!=="svelte-3qu6we"&&(d.innerHTML=T)},m(v,x){i(v,d,x)},p:or,d(v){v&&t(d)}}}function Co(X){let d,T="Examples:",v,x,C;return x=new lr({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMGFzJTIwdGZkcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBJTBBdHJhaW5pbmdfZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzREZhbHNlKSUwQWV2YWx1YXRpb25fZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow_datasets <span class="hljs-keyword">as</span> tfds

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>training_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>evaluation_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){d=n("p"),d.textContent=T,v=a(),p(x.$$.fragment)},l(c){d=l(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-kvfsh7"&&(d.textContent=T),v=o(c),f(x.$$.fragment,c)},m(c,j){i(c,d,j),i(c,v,j),u(x,c,j),C=!0},p:or,i(c){C||(h(x.$$.fragment,c),C=!0)},o(c){g(x.$$.fragment,c),C=!1},d(c){c&&(t(d),t(v)),_(x,c)}}}function Po(X){let d,T="Example:",v,x,C;return x=new lr({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwU3F1YWRWMlByb2Nlc3NvcigpJTBBZXhhbXBsZXMlMjAlM0QlMjBwcm9jZXNzb3IuZ2V0X2Rldl9leGFtcGxlcyhkYXRhX2RpciklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEYXJncy5tYXhfc2VxX2xlbmd0aCUyQyUwQSUyMCUyMCUyMCUyMGRvY19zdHJpZGUlM0RhcmdzLmRvY19zdHJpZGUlMkMlMEElMjAlMjAlMjAlMjBtYXhfcXVlcnlfbGVuZ3RoJTNEYXJncy5tYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`processor = SquadV2Processor()
examples = processor.get_dev_examples(data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=args.max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=args.max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){d=n("p"),d.textContent=T,v=a(),p(x.$$.fragment)},l(c){d=l(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lpom8"&&(d.textContent=T),v=o(c),f(x.$$.fragment,c)},m(c,j){i(c,d,j),i(c,v,j),u(x,c,j),C=!0},p:or,i(c){C||(h(x.$$.fragment,c),C=!0)},o(c){g(x.$$.fragment,c),C=!1},d(c){c&&(t(d),t(v)),_(x,c)}}}function jo(X){let d,T,v,x,C,c,j,ha="Transformers ライブラリでは、プロセッサは 2 つの異なる意味を持ちます。",ir,fe,ga=`<li><a href="../model_doc/wav2vec2">Wav2Vec2</a> などのマルチモーダル モデルの入力を前処理するオブジェクト (音声とテキスト)
または <a href="../model_doc/clip">CLIP</a> (テキストとビジョン)</li> <li>古いバージョンのライブラリで GLUE または SQUAD のデータを前処理するために使用されていたオブジェクトは非推奨になりました。</li>`,mr,ue,dr,he,_a=`マルチモーダル モデルでは、オブジェクトが複数のモダリティ (テキスト、
視覚と音声）。これは、2 つ以上の処理オブジェクトをグループ化するプロセッサーと呼ばれるオブジェクトによって処理されます。
トークナイザー (テキスト モダリティ用)、画像プロセッサー (視覚用)、特徴抽出器 (オーディオ用) など。`,cr,ge,va="これらのプロセッサは、保存およびロード機能を実装する次の基本クラスを継承します。",pr,y,_e,ps,Tt,xa="This is a mixin used to provide saving/loading functionality for all processor classes.",fs,F,ve,us,Ct,$a=`Similar to the <code>apply_chat_template</code> method on tokenizers, this method applies a Jinja template to input
conversations to turn them into a single tokenizable string.`,hs,S,xe,gs,Pt,ba="Instantiates a type of <code>~processing_utils.ProcessingMixin</code> from a Python dictionary of parameters.",_s,Z,$e,vs,jt,ya="Instantiate a processor associated with a pretrained model.",xs,R,$s,G,be,bs,It,Ma=`From a <code>pretrained_model_name_or_path</code>, resolve to a dictionary of parameters, to be used for instantiating a
processor of type <code>~processing_utils.ProcessingMixin</code> using <code>from_args_and_dict</code>.`,ys,q,ye,Ms,kt,wa="Upload the processor files to the 🤗 Model Hub.",ws,W,Ts,V,Me,Cs,Xt,Ta=`Register this class with a given auto class. This should only be used for custom feature extractors as the ones
in the library are already mapped with <code>AutoProcessor</code>.`,Ps,Q,js,z,we,Is,Jt,Ca=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/main/ja/main_classes/processors#transformers.ProcessorMixin.from_pretrained">from_pretrained()</a> method.`,ks,Y,Xs,A,Te,Js,Lt,Pa="Serializes this instance to a Python dictionary.",Ls,O,Ce,Us,Ut,ja="Save this instance to a JSON file.",Zs,K,Pe,qs,Zt,Ia="Serializes this instance to a JSON string.",fr,je,ur,Ie,ka=`すべてのプロセッサは、同じアーキテクチャに従っています。
<a href="/docs/transformers/main/ja/main_classes/processors#transformers.DataProcessor">DataProcessor</a>。プロセッサは次のリストを返します。
<a href="/docs/transformers/main/ja/main_classes/processors#transformers.InputExample">InputExample</a>。これら
<a href="/docs/transformers/main/ja/main_classes/processors#transformers.InputExample">InputExample</a> は次のように変換できます。
<code>~data.processors.utils.Input features</code> をモデルにフィードします。`,hr,P,ke,Vs,qt,Xa="Base class for data converters for sequence classification data sets.",zs,ee,Xe,Es,Vt,Ja='Gets a collection of <a href="/docs/transformers/main/ja/main_classes/processors#transformers.InputExample">InputExample</a> for the dev set.',Hs,te,Je,Ns,zt,La="Gets an example from a dict with tensorflow tensors.",Bs,re,Le,Ds,Et,Ua="Gets the list of labels for this data set.",Fs,se,Ue,Ss,Ht,Za='Gets a collection of <a href="/docs/transformers/main/ja/main_classes/processors#transformers.InputExample">InputExample</a> for the test set.',Rs,ae,Ze,Gs,Nt,qa='Gets a collection of <a href="/docs/transformers/main/ja/main_classes/processors#transformers.InputExample">InputExample</a> for the train set.',Ws,oe,qe,Qs,Bt,Va=`Some tensorflow_datasets datasets are not formatted the same way the GLUE datasets are. This method converts
examples to the correct format.`,gr,J,Ve,Ys,Dt,za="A single training/test example for simple sequence classification.",As,ne,ze,Os,Ft,Ea="Serializes this instance to a JSON string.",_r,L,Ee,Ks,St,Ha="A single set of features of data. Property names are the same names as the corresponding inputs to a model.",ea,le,He,ta,Rt,Na="Serializes this instance to a JSON string.",vr,Ne,xr,Be,Ba=`<a href="https://gluebenchmark.com/" rel="nofollow">一般言語理解評価 (GLUE)</a> は、
既存の NLU タスクの多様なセットにわたるモデルのパフォーマンス。紙と同時発売された <a href="https://openreview.net/pdf?id=rJ4km2R5t7" rel="nofollow">GLUE: A
自然言語理解のためのマルチタスクベンチマークおよび分析プラットフォーム</a>`,$r,De,Da=`このライブラリは、MRPC、MNLI、MNLI (不一致)、CoLA、SST2、STSB、
QQP、QNLI、RTE、WNLI。`,br,Fe,Fa="それらのプロセッサは次のとおりです。",yr,Se,Sa="<li><code>~data.processors.utils.MrpcProcessor</code></li> <li><code>~data.processors.utils.MnliProcessor</code></li> <li><code>~data.processors.utils.MnliMismatchedProcessor</code></li> <li><code>~data.processors.utils.Sst2Processor</code></li> <li><code>~data.processors.utils.StsbProcessor</code></li> <li><code>~data.processors.utils.QqpProcessor</code></li> <li><code>~data.processors.utils.QnliProcessor</code></li> <li><code>~data.processors.utils.RteProcessor</code></li> <li><code>~data.processors.utils.WnliProcessor</code></li>",Mr,Re,Ra=`さらに、次のメソッドを使用して、データ ファイルから値をロードし、それらをリストに変換することができます。
<a href="/docs/transformers/main/ja/main_classes/processors#transformers.InputExample">InputExample</a>。`,wr,N,Ge,ra,Gt,Ga="Loads a data file into a list of <code>InputFeatures</code>",Tr,We,Cr,Qe,Wa=`<a href="https://www.nyu.edu/projects/bowman/xnli/" rel="nofollow">クロスリンガル NLI コーパス (XNLI)</a> は、
言語を超えたテキスト表現の品質。 XNLI は、<a href="http://www.nyu.edu/projects/bowman/multinli/" rel="nofollow"><em>MultiNLI</em></a> に基づくクラウドソースのデータセットです。テキストのペアには、15 個のテキスト含意アノテーションがラベル付けされています。
さまざまな言語 (英語などの高リソース言語とスワヒリ語などの低リソース言語の両方を含む)。`,Pr,Ye,Qa='論文 <a href="https://arxiv.org/abs/1809.05053" rel="nofollow">XNLI: Evaluating Cross-lingual Sentence Representations</a> と同時にリリースされました。',jr,Ae,Ya="このライブラリは、XNLI データをロードするプロセッサをホストします。",Ir,Oe,Aa="<li><code>~data.processors.utils.XnliProcessor</code></li>",kr,Ke,Oa="テストセットにはゴールドラベルが付いているため、評価はテストセットで行われますのでご了承ください。",Xr,et,Ka='これらのプロセッサを使用する例は、<a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-classification/run_xnli.py" rel="nofollow">run_xnli.py</a> スクリプトに示されています。',Jr,tt,Lr,rt,eo=`<a href="https://rajpurkar.github.io/SQuAD-explorer//" rel="nofollow">The Stanford Question Answering Dataset (SQuAD)</a> は、次のベンチマークです。
質問応答に関するモデルのパフォーマンスを評価します。 v1.1 と v2.0 の 2 つのバージョンが利用可能です。最初のバージョン
(v1.1) は、論文 <a href="https://arxiv.org/abs/1606.05250" rel="nofollow">SQuAD: 100,000+ question for Machine Comprehension of Text</a> とともにリリースされました。 2 番目のバージョン (v2.0) は、論文 <a href="https://arxiv.org/abs/1806.03822" rel="nofollow">Know What You Don’t と同時にリリースされました。
知っておくべき: SQuAD の答えられない質問</a>。`,Ur,st,to="このライブラリは、次の 2 つのバージョンのそれぞれのプロセッサをホストします。",Zr,at,qr,ot,ro="それらのプロセッサは次のとおりです。",Vr,nt,so="<li><code>~data.processors.utils.SquadV1Processor</code></li> <li><code>~data.processors.utils.SquadV2Processor</code></li>",zr,lt,ao="どちらも抽象クラス <code>~data.processors.utils.SquadProcessor</code> を継承しています。",Er,k,it,sa,Wt,oo=`Processor for the SQuAD data set. overridden by SquadV1Processor and SquadV2Processor, used by the version 1.1 and
version 2.0 of SQuAD, respectively.`,aa,ie,mt,oa,Qt,no="Returns the evaluation example from the data directory.",na,E,dt,la,Yt,lo="Creates a list of <code>SquadExample</code> using a TFDS dataset.",ia,me,ma,de,ct,da,At,io="Returns the training examples from the data directory.",Hr,pt,mo=`さらに、次のメソッドを使用して、SQuAD の例を次の形式に変換できます。
モデルの入力として使用できる <code>~data.processors.utils.SquadFeatures</code>。`,Nr,U,ft,ca,Ot,co=`Converts a list of examples into a list of features that can be directly given as input to a model. It is
model-dependant and takes advantage of many of the tokenizer’s features to create the model’s inputs.`,pa,ce,Br,ut,po=`これらのプロセッサと前述の方法は、データを含むファイルだけでなく、
<em>tensorflow_datasets</em> パッケージ。以下に例を示します。`,Dr,ht,Fr,gt,fo="以下にプロセッサを使用した例と、データ ファイルを使用した変換方法を示します。",Sr,_t,Rr,vt,uo="<em>tensorflow_datasets</em> の使用は、データ ファイルを使用するのと同じくらい簡単です。",Gr,xt,Wr,$t,ho='これらのプロセッサを使用する別の例は、<a href="https://github.com/huggingface/transformers/tree/main/examples/legacy/question-answering/run_squad.py" rel="nofollow">run_squad.py</a> スクリプトに示されています。',Qr,bt,Yr,nr,Ar;return C=new pe({props:{title:"Processors",local:"processors",headingTag:"h1"}}),ue=new pe({props:{title:"Multi-modal processors",local:"transformers.ProcessorMixin",headingTag:"h2"}}),_e=new M({props:{name:"class transformers.ProcessorMixin",anchor:"transformers.ProcessorMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L313"}}),ve=new M({props:{name:"apply_chat_template",anchor:"transformers.ProcessorMixin.apply_chat_template",parameters:[{name:"conversation",val:": List"},{name:"chat_template",val:": Optional = None"},{name:"tokenize",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.apply_chat_template.conversation",description:`<strong>conversation</strong> (<code>List[Dict, str, str]</code>) &#x2014;
The conversation to format.`,name:"conversation"},{anchor:"transformers.ProcessorMixin.apply_chat_template.chat_template",description:`<strong>chat_template</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
The Jinja template to use for formatting the conversation. If not provided, the tokenizer&#x2019;s
chat template is used.`,name:"chat_template"},{anchor:"transformers.ProcessorMixin.apply_chat_template.tokenize",description:`<strong>tokenize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tokenize the output or not.
**kwargs &#x2014;
Additional keyword arguments`,name:"tokenize"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L959"}}),xe=new M({props:{name:"from_args_and_dict",anchor:"transformers.ProcessorMixin.from_args_and_dict",parameters:[{name:"args",val:""},{name:"processor_dict",val:": Dict"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_args_and_dict.processor_dict",description:`<strong>processor_dict</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary that will be used to instantiate the processor object. Such a dictionary can be
retrieved from a pretrained checkpoint by leveraging the
<code>~processing_utils.ProcessingMixin.to_dict</code> method.`,name:"processor_dict"},{anchor:"transformers.ProcessorMixin.from_args_and_dict.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Additional parameters from which to initialize the processor object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L682",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processor object instantiated from those
parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~processing_utils.ProcessingMixin</code></p>
`}}),$e=new M({props:{name:"from_pretrained",anchor:"transformers.ProcessorMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/main/ja/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/main/ja/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L833"}}),R=new fa({props:{$$slots:{default:[yo]},$$scope:{ctx:X}}}),be=new M({props:{name:"get_processor_dict",anchor:"transformers.ProcessorMixin.get_processor_dict",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.get_processor_dict.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The identifier of the pre-trained checkpoint from which we want the dictionary of parameters.`,name:"pretrained_model_name_or_path"},{anchor:"transformers.ProcessorMixin.get_processor_dict.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L529",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary(ies) that will be used to instantiate the processor object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[Dict, Dict]</code></p>
`}}),ye=new M({props:{name:"push_to_hub",anchor:"transformers.ProcessorMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"use_temp_dir",val:": Optional = None"},{name:"commit_message",val:": Optional = None"},{name:"private",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"max_shard_size",val:": Union = '5GB'"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"revision",val:": str = None"},{name:"commit_description",val:": str = None"},{name:"tags",val:": Optional = None"},{name:"**deprecated_kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your processor to. It should contain your organization name
when pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.ProcessorMixin.push_to_hub.use_temp_dir",description:`<strong>use_temp_dir</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to use a temporary directory to store the files saved before they are pushed to the Hub.
Will default to <code>True</code> if there is no directory named like <code>repo_id</code>, <code>False</code> otherwise.`,name:"use_temp_dir"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Will default to <code>&quot;Upload processor&quot;</code>.`,name:"commit_message"},{anchor:"transformers.ProcessorMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.ProcessorMixin.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>). Will default to <code>True</code> if <code>repo_url</code>
is not specified.`,name:"token"},{anchor:"transformers.ProcessorMixin.push_to_hub.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;5GB&quot;</code>) &#x2014;
Only applicable for models. The maximum size for a checkpoint before being sharded. Checkpoints shard
will then be each of size lower than this size. If expressed as a string, needs to be digits followed
by a unit (like <code>&quot;5MB&quot;</code>). We default it to <code>&quot;5GB&quot;</code> so that users can easily load models on free-tier
Google Colab instances without any CPU OOM issues.`,name:"max_shard_size"},{anchor:"transformers.ProcessorMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"transformers.ProcessorMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights in safetensors format for safer serialization.`,name:"safe_serialization"},{anchor:"transformers.ProcessorMixin.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Branch to push the uploaded files to.`,name:"revision"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"},{anchor:"transformers.ProcessorMixin.push_to_hub.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of tags to push on the Hub.`,name:"tags"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/hub.py#L819"}}),W=new ua({props:{anchor:"transformers.ProcessorMixin.push_to_hub.example",$$slots:{default:[Mo]},$$scope:{ctx:X}}}),Me=new M({props:{name:"register_for_auto_class",anchor:"transformers.ProcessorMixin.register_for_auto_class",parameters:[{name:"auto_class",val:" = 'AutoProcessor'"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.register_for_auto_class.auto_class",description:`<strong>auto_class</strong> (<code>str</code> or <code>type</code>, <em>optional</em>, defaults to <code>&quot;AutoProcessor&quot;</code>) &#x2014;
The auto class to register this new feature extractor with.`,name:"auto_class"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L897"}}),Q=new fa({props:{warning:!0,$$slots:{default:[wo]},$$scope:{ctx:X}}}),we=new M({props:{name:"save_pretrained",anchor:"transformers.ProcessorMixin.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.ProcessorMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.ProcessorMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/main/ja/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L430"}}),Y=new fa({props:{$$slots:{default:[To]},$$scope:{ctx:X}}}),Te=new M({props:{name:"to_dict",anchor:"transformers.ProcessorMixin.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L365",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this processor instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Ce=new M({props:{name:"to_json_file",anchor:"transformers.ProcessorMixin.to_json_file",parameters:[{name:"json_file_path",val:": Union"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.to_json_file.json_file_path",description:`<strong>json_file_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Path to the JSON file in which this processor instance&#x2019;s parameters will be saved.`,name:"json_file_path"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L414"}}),Pe=new M({props:{name:"to_json_string",anchor:"transformers.ProcessorMixin.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/processing_utils.py#L403",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>String containing all the attributes that make up this feature_extractor instance in JSON format.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),je=new pe({props:{title:"Deprecated processors",local:"transformers.DataProcessor",headingTag:"h2"}}),ke=new M({props:{name:"class transformers.DataProcessor",anchor:"transformers.DataProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L80"}}),Xe=new M({props:{name:"get_dev_examples",anchor:"transformers.DataProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L97"}}),Je=new M({props:{name:"get_example_from_tensor_dict",anchor:"transformers.DataProcessor.get_example_from_tensor_dict",parameters:[{name:"tensor_dict",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L83"}}),Le=new M({props:{name:"get_labels",anchor:"transformers.DataProcessor.get_labels",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L105"}}),Ue=new M({props:{name:"get_test_examples",anchor:"transformers.DataProcessor.get_test_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L101"}}),Ze=new M({props:{name:"get_train_examples",anchor:"transformers.DataProcessor.get_train_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L93"}}),qe=new M({props:{name:"tfds_map",anchor:"transformers.DataProcessor.tfds_map",parameters:[{name:"example",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L109"}}),Ve=new M({props:{name:"class transformers.InputExample",anchor:"transformers.InputExample",parameters:[{name:"guid",val:": str"},{name:"text_a",val:": str"},{name:"text_b",val:": Optional = None"},{name:"label",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L29"}}),ze=new M({props:{name:"to_json_string",anchor:"transformers.InputExample.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L49"}}),Ee=new M({props:{name:"class transformers.InputFeatures",anchor:"transformers.InputFeatures",parameters:[{name:"input_ids",val:": List"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"label",val:": Union = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L54"}}),He=new M({props:{name:"to_json_string",anchor:"transformers.InputFeatures.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/utils.py#L75"}}),Ne=new pe({props:{title:"GLUE",local:"transformers.glue_convert_examples_to_features",headingTag:"h2"}}),Ge=new M({props:{name:"transformers.glue_convert_examples_to_features",anchor:"transformers.glue_convert_examples_to_features",parameters:[{name:"examples",val:": Union"},{name:"tokenizer",val:": PreTrainedTokenizer"},{name:"max_length",val:": Optional = None"},{name:"task",val:" = None"},{name:"label_list",val:" = None"},{name:"output_mode",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/glue.py#L41",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If the <code>examples</code> input is a <code>tf.data.Dataset</code>, will return a <code>tf.data.Dataset</code> containing the task-specific
features. If the input is a list of <code>InputExamples</code>, will return a list of task-specific <code>InputFeatures</code> which
can be fed to the model.</p>
`}}),We=new pe({props:{title:"XNLI",local:"xnli",headingTag:"h2"}}),tt=new pe({props:{title:"SQuAD",local:"squad",headingTag:"h2"}}),at=new pe({props:{title:"Processors",local:"transformers.data.processors.squad.SquadProcessor",headingTag:"h3"}}),it=new M({props:{name:"class transformers.data.processors.squad.SquadProcessor",anchor:"transformers.data.processors.squad.SquadProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L541"}}),mt=new M({props:{name:"get_dev_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L629"}}),dt=new M({props:{name:"get_examples_from_dataset",anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset",parameters:[{name:"dataset",val:""},{name:"evaluate",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of SquadExample</p>
`}}),me=new ua({props:{anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset.example",$$slots:{default:[Co]},$$scope:{ctx:X}}}),ct=new M({props:{name:"get_train_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_train_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L607"}}),ft=new M({props:{name:"transformers.squad_convert_examples_to_features",anchor:"transformers.squad_convert_examples_to_features",parameters:[{name:"examples",val:""},{name:"tokenizer",val:""},{name:"max_seq_length",val:""},{name:"doc_stride",val:""},{name:"max_query_length",val:""},{name:"is_training",val:""},{name:"padding_strategy",val:" = 'max_length'"},{name:"return_dataset",val:" = False"},{name:"threads",val:" = 1"},{name:"tqdm_enabled",val:" = True"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/data/processors/squad.py#L316",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <code>SquadFeatures</code></p>
`}}),ce=new ua({props:{anchor:"transformers.squad_convert_examples_to_features.example",$$slots:{default:[Po]},$$scope:{ctx:X}}}),ht=new pe({props:{title:"Example usage",local:"example-usage",headingTag:"h3"}}),_t=new lr({props:{code:"JTIzJTIwTG9hZGluZyUyMGElMjBWMiUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjJQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjJfZGF0YV9kaXIpJTBBJTBBJTIzJTIwTG9hZGluZyUyMGElMjBWMSUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjFQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjFfZGF0YV9kaXIpJTBBJTBBZmVhdHVyZXMlMjAlM0QlMjBzcXVhZF9jb252ZXJ0X2V4YW1wbGVzX3RvX2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEZXhhbXBsZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRG1heF9zZXFfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwZG9jX3N0cmlkZSUzRGFyZ3MuZG9jX3N0cmlkZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9xdWVyeV9sZW5ndGglM0RtYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Loading a V2 processor</span>
processor = SquadV2Processor()
examples = processor.get_dev_examples(squad_v2_data_dir)

<span class="hljs-comment"># Loading a V1 processor</span>
processor = SquadV1Processor()
examples = processor.get_dev_examples(squad_v1_data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),xt=new lr({props:{code:"JTIzJTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMG9ubHklMjBoYW5kbGUlMjBTcXVhZCUyMFYxLiUwQXRmZHNfZXhhbXBsZXMlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBZXhhbXBsZXMlMjAlM0QlMjBTcXVhZFYxUHJvY2Vzc29yKCkuZ2V0X2V4YW1wbGVzX2Zyb21fZGF0YXNldCh0ZmRzX2V4YW1wbGVzJTJDJTIwZXZhbHVhdGUlM0RldmFsdWF0ZSklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEbWF4X3NlcV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBkb2Nfc3RyaWRlJTNEYXJncy5kb2Nfc3RyaWRlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3F1ZXJ5X2xlbmd0aCUzRG1heF9xdWVyeV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBpc190cmFpbmluZyUzRG5vdCUyMGV2YWx1YXRlJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># tensorflow_datasets only handle Squad V1.</span>
tfds_examples = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)
examples = SquadV1Processor().get_examples_from_dataset(tfds_examples, evaluate=evaluate)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),bt=new bo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ja/main_classes/processors.md"}}),{c(){d=n("meta"),T=a(),v=n("p"),x=a(),p(C.$$.fragment),c=a(),j=n("p"),j.textContent=ha,ir=a(),fe=n("ul"),fe.innerHTML=ga,mr=a(),p(ue.$$.fragment),dr=a(),he=n("p"),he.textContent=_a,cr=a(),ge=n("p"),ge.textContent=va,pr=a(),y=n("div"),p(_e.$$.fragment),ps=a(),Tt=n("p"),Tt.textContent=xa,fs=a(),F=n("div"),p(ve.$$.fragment),us=a(),Ct=n("p"),Ct.innerHTML=$a,hs=a(),S=n("div"),p(xe.$$.fragment),gs=a(),Pt=n("p"),Pt.innerHTML=ba,_s=a(),Z=n("div"),p($e.$$.fragment),vs=a(),jt=n("p"),jt.textContent=ya,xs=a(),p(R.$$.fragment),$s=a(),G=n("div"),p(be.$$.fragment),bs=a(),It=n("p"),It.innerHTML=Ma,ys=a(),q=n("div"),p(ye.$$.fragment),Ms=a(),kt=n("p"),kt.textContent=wa,ws=a(),p(W.$$.fragment),Ts=a(),V=n("div"),p(Me.$$.fragment),Cs=a(),Xt=n("p"),Xt.innerHTML=Ta,Ps=a(),p(Q.$$.fragment),js=a(),z=n("div"),p(we.$$.fragment),Is=a(),Jt=n("p"),Jt.innerHTML=Ca,ks=a(),p(Y.$$.fragment),Xs=a(),A=n("div"),p(Te.$$.fragment),Js=a(),Lt=n("p"),Lt.textContent=Pa,Ls=a(),O=n("div"),p(Ce.$$.fragment),Us=a(),Ut=n("p"),Ut.textContent=ja,Zs=a(),K=n("div"),p(Pe.$$.fragment),qs=a(),Zt=n("p"),Zt.textContent=Ia,fr=a(),p(je.$$.fragment),ur=a(),Ie=n("p"),Ie.innerHTML=ka,hr=a(),P=n("div"),p(ke.$$.fragment),Vs=a(),qt=n("p"),qt.textContent=Xa,zs=a(),ee=n("div"),p(Xe.$$.fragment),Es=a(),Vt=n("p"),Vt.innerHTML=Ja,Hs=a(),te=n("div"),p(Je.$$.fragment),Ns=a(),zt=n("p"),zt.textContent=La,Bs=a(),re=n("div"),p(Le.$$.fragment),Ds=a(),Et=n("p"),Et.textContent=Ua,Fs=a(),se=n("div"),p(Ue.$$.fragment),Ss=a(),Ht=n("p"),Ht.innerHTML=Za,Rs=a(),ae=n("div"),p(Ze.$$.fragment),Gs=a(),Nt=n("p"),Nt.innerHTML=qa,Ws=a(),oe=n("div"),p(qe.$$.fragment),Qs=a(),Bt=n("p"),Bt.textContent=Va,gr=a(),J=n("div"),p(Ve.$$.fragment),Ys=a(),Dt=n("p"),Dt.textContent=za,As=a(),ne=n("div"),p(ze.$$.fragment),Os=a(),Ft=n("p"),Ft.textContent=Ea,_r=a(),L=n("div"),p(Ee.$$.fragment),Ks=a(),St=n("p"),St.textContent=Ha,ea=a(),le=n("div"),p(He.$$.fragment),ta=a(),Rt=n("p"),Rt.textContent=Na,vr=a(),p(Ne.$$.fragment),xr=a(),Be=n("p"),Be.innerHTML=Ba,$r=a(),De=n("p"),De.textContent=Da,br=a(),Fe=n("p"),Fe.textContent=Fa,yr=a(),Se=n("ul"),Se.innerHTML=Sa,Mr=a(),Re=n("p"),Re.innerHTML=Ra,wr=a(),N=n("div"),p(Ge.$$.fragment),ra=a(),Gt=n("p"),Gt.innerHTML=Ga,Tr=a(),p(We.$$.fragment),Cr=a(),Qe=n("p"),Qe.innerHTML=Wa,Pr=a(),Ye=n("p"),Ye.innerHTML=Qa,jr=a(),Ae=n("p"),Ae.textContent=Ya,Ir=a(),Oe=n("ul"),Oe.innerHTML=Aa,kr=a(),Ke=n("p"),Ke.textContent=Oa,Xr=a(),et=n("p"),et.innerHTML=Ka,Jr=a(),p(tt.$$.fragment),Lr=a(),rt=n("p"),rt.innerHTML=eo,Ur=a(),st=n("p"),st.textContent=to,Zr=a(),p(at.$$.fragment),qr=a(),ot=n("p"),ot.textContent=ro,Vr=a(),nt=n("ul"),nt.innerHTML=so,zr=a(),lt=n("p"),lt.innerHTML=ao,Er=a(),k=n("div"),p(it.$$.fragment),sa=a(),Wt=n("p"),Wt.textContent=oo,aa=a(),ie=n("div"),p(mt.$$.fragment),oa=a(),Qt=n("p"),Qt.textContent=no,na=a(),E=n("div"),p(dt.$$.fragment),la=a(),Yt=n("p"),Yt.innerHTML=lo,ia=a(),p(me.$$.fragment),ma=a(),de=n("div"),p(ct.$$.fragment),da=a(),At=n("p"),At.textContent=io,Hr=a(),pt=n("p"),pt.innerHTML=mo,Nr=a(),U=n("div"),p(ft.$$.fragment),ca=a(),Ot=n("p"),Ot.textContent=co,pa=a(),p(ce.$$.fragment),Br=a(),ut=n("p"),ut.innerHTML=po,Dr=a(),p(ht.$$.fragment),Fr=a(),gt=n("p"),gt.textContent=fo,Sr=a(),p(_t.$$.fragment),Rr=a(),vt=n("p"),vt.innerHTML=uo,Gr=a(),p(xt.$$.fragment),Wr=a(),$t=n("p"),$t.innerHTML=ho,Qr=a(),p(bt.$$.fragment),Yr=a(),nr=n("p"),this.h()},l(e){const r=$o("svelte-u9bgzb",document.head);d=l(r,"META",{name:!0,content:!0}),r.forEach(t),T=o(e),v=l(e,"P",{}),$(v).forEach(t),x=o(e),f(C.$$.fragment,e),c=o(e),j=l(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-4gs895"&&(j.textContent=ha),ir=o(e),fe=l(e,"UL",{"data-svelte-h":!0}),m(fe)!=="svelte-1h23xz2"&&(fe.innerHTML=ga),mr=o(e),f(ue.$$.fragment,e),dr=o(e),he=l(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-hbbv64"&&(he.textContent=_a),cr=o(e),ge=l(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-t565jj"&&(ge.textContent=va),pr=o(e),y=l(e,"DIV",{class:!0});var w=$(y);f(_e.$$.fragment,w),ps=o(w),Tt=l(w,"P",{"data-svelte-h":!0}),m(Tt)!=="svelte-1s4wckx"&&(Tt.textContent=xa),fs=o(w),F=l(w,"DIV",{class:!0});var yt=$(F);f(ve.$$.fragment,yt),us=o(yt),Ct=l(yt,"P",{"data-svelte-h":!0}),m(Ct)!=="svelte-10dqwuv"&&(Ct.innerHTML=$a),yt.forEach(t),hs=o(w),S=l(w,"DIV",{class:!0});var Mt=$(S);f(xe.$$.fragment,Mt),gs=o(Mt),Pt=l(Mt,"P",{"data-svelte-h":!0}),m(Pt)!=="svelte-1i2d3vx"&&(Pt.innerHTML=ba),Mt.forEach(t),_s=o(w),Z=l(w,"DIV",{class:!0});var B=$(Z);f($e.$$.fragment,B),vs=o(B),jt=l(B,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-1cj8dcb"&&(jt.textContent=ya),xs=o(B),f(R.$$.fragment,B),B.forEach(t),$s=o(w),G=l(w,"DIV",{class:!0});var wt=$(G);f(be.$$.fragment,wt),bs=o(wt),It=l(wt,"P",{"data-svelte-h":!0}),m(It)!=="svelte-hsvutq"&&(It.innerHTML=Ma),wt.forEach(t),ys=o(w),q=l(w,"DIV",{class:!0});var D=$(q);f(ye.$$.fragment,D),Ms=o(D),kt=l(D,"P",{"data-svelte-h":!0}),m(kt)!=="svelte-1cwsjho"&&(kt.textContent=wa),ws=o(D),f(W.$$.fragment,D),D.forEach(t),Ts=o(w),V=l(w,"DIV",{class:!0});var Kt=$(V);f(Me.$$.fragment,Kt),Cs=o(Kt),Xt=l(Kt,"P",{"data-svelte-h":!0}),m(Xt)!=="svelte-hhsvto"&&(Xt.innerHTML=Ta),Ps=o(Kt),f(Q.$$.fragment,Kt),Kt.forEach(t),js=o(w),z=l(w,"DIV",{class:!0});var er=$(z);f(we.$$.fragment,er),Is=o(er),Jt=l(er,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-1yuddp1"&&(Jt.innerHTML=Ca),ks=o(er),f(Y.$$.fragment,er),er.forEach(t),Xs=o(w),A=l(w,"DIV",{class:!0});var Or=$(A);f(Te.$$.fragment,Or),Js=o(Or),Lt=l(Or,"P",{"data-svelte-h":!0}),m(Lt)!=="svelte-1ww3wqq"&&(Lt.textContent=Pa),Or.forEach(t),Ls=o(w),O=l(w,"DIV",{class:!0});var Kr=$(O);f(Ce.$$.fragment,Kr),Us=o(Kr),Ut=l(Kr,"P",{"data-svelte-h":!0}),m(Ut)!=="svelte-1g70y32"&&(Ut.textContent=ja),Kr.forEach(t),Zs=o(w),K=l(w,"DIV",{class:!0});var es=$(K);f(Pe.$$.fragment,es),qs=o(es),Zt=l(es,"P",{"data-svelte-h":!0}),m(Zt)!=="svelte-5ayq1f"&&(Zt.textContent=Ia),es.forEach(t),w.forEach(t),fr=o(e),f(je.$$.fragment,e),ur=o(e),Ie=l(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-g98oo1"&&(Ie.innerHTML=ka),hr=o(e),P=l(e,"DIV",{class:!0});var I=$(P);f(ke.$$.fragment,I),Vs=o(I),qt=l(I,"P",{"data-svelte-h":!0}),m(qt)!=="svelte-1bsw04k"&&(qt.textContent=Xa),zs=o(I),ee=l(I,"DIV",{class:!0});var ts=$(ee);f(Xe.$$.fragment,ts),Es=o(ts),Vt=l(ts,"P",{"data-svelte-h":!0}),m(Vt)!=="svelte-1szdena"&&(Vt.innerHTML=Ja),ts.forEach(t),Hs=o(I),te=l(I,"DIV",{class:!0});var rs=$(te);f(Je.$$.fragment,rs),Ns=o(rs),zt=l(rs,"P",{"data-svelte-h":!0}),m(zt)!=="svelte-pplryq"&&(zt.textContent=La),rs.forEach(t),Bs=o(I),re=l(I,"DIV",{class:!0});var ss=$(re);f(Le.$$.fragment,ss),Ds=o(ss),Et=l(ss,"P",{"data-svelte-h":!0}),m(Et)!=="svelte-3oqyjr"&&(Et.textContent=Ua),ss.forEach(t),Fs=o(I),se=l(I,"DIV",{class:!0});var as=$(se);f(Ue.$$.fragment,as),Ss=o(as),Ht=l(as,"P",{"data-svelte-h":!0}),m(Ht)!=="svelte-6j503t"&&(Ht.innerHTML=Za),as.forEach(t),Rs=o(I),ae=l(I,"DIV",{class:!0});var os=$(ae);f(Ze.$$.fragment,os),Gs=o(os),Nt=l(os,"P",{"data-svelte-h":!0}),m(Nt)!=="svelte-w0fgcv"&&(Nt.innerHTML=qa),os.forEach(t),Ws=o(I),oe=l(I,"DIV",{class:!0});var ns=$(oe);f(qe.$$.fragment,ns),Qs=o(ns),Bt=l(ns,"P",{"data-svelte-h":!0}),m(Bt)!=="svelte-1jevh15"&&(Bt.textContent=Va),ns.forEach(t),I.forEach(t),gr=o(e),J=l(e,"DIV",{class:!0});var tr=$(J);f(Ve.$$.fragment,tr),Ys=o(tr),Dt=l(tr,"P",{"data-svelte-h":!0}),m(Dt)!=="svelte-vkt0pi"&&(Dt.textContent=za),As=o(tr),ne=l(tr,"DIV",{class:!0});var ls=$(ne);f(ze.$$.fragment,ls),Os=o(ls),Ft=l(ls,"P",{"data-svelte-h":!0}),m(Ft)!=="svelte-5ayq1f"&&(Ft.textContent=Ea),ls.forEach(t),tr.forEach(t),_r=o(e),L=l(e,"DIV",{class:!0});var rr=$(L);f(Ee.$$.fragment,rr),Ks=o(rr),St=l(rr,"P",{"data-svelte-h":!0}),m(St)!=="svelte-168wf64"&&(St.textContent=Ha),ea=o(rr),le=l(rr,"DIV",{class:!0});var is=$(le);f(He.$$.fragment,is),ta=o(is),Rt=l(is,"P",{"data-svelte-h":!0}),m(Rt)!=="svelte-5ayq1f"&&(Rt.textContent=Na),is.forEach(t),rr.forEach(t),vr=o(e),f(Ne.$$.fragment,e),xr=o(e),Be=l(e,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-dz9ydi"&&(Be.innerHTML=Ba),$r=o(e),De=l(e,"P",{"data-svelte-h":!0}),m(De)!=="svelte-1lukeag"&&(De.textContent=Da),br=o(e),Fe=l(e,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-w2nqkz"&&(Fe.textContent=Fa),yr=o(e),Se=l(e,"UL",{"data-svelte-h":!0}),m(Se)!=="svelte-my8qym"&&(Se.innerHTML=Sa),Mr=o(e),Re=l(e,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-1j6tfx9"&&(Re.innerHTML=Ra),wr=o(e),N=l(e,"DIV",{class:!0});var ms=$(N);f(Ge.$$.fragment,ms),ra=o(ms),Gt=l(ms,"P",{"data-svelte-h":!0}),m(Gt)!=="svelte-5lvrve"&&(Gt.innerHTML=Ga),ms.forEach(t),Tr=o(e),f(We.$$.fragment,e),Cr=o(e),Qe=l(e,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-1cfncyx"&&(Qe.innerHTML=Wa),Pr=o(e),Ye=l(e,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-10048a6"&&(Ye.innerHTML=Qa),jr=o(e),Ae=l(e,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-1z0bn35"&&(Ae.textContent=Ya),Ir=o(e),Oe=l(e,"UL",{"data-svelte-h":!0}),m(Oe)!=="svelte-1e2xq99"&&(Oe.innerHTML=Aa),kr=o(e),Ke=l(e,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-1d3nf11"&&(Ke.textContent=Oa),Xr=o(e),et=l(e,"P",{"data-svelte-h":!0}),m(et)!=="svelte-7zvs7i"&&(et.innerHTML=Ka),Jr=o(e),f(tt.$$.fragment,e),Lr=o(e),rt=l(e,"P",{"data-svelte-h":!0}),m(rt)!=="svelte-5cjvlv"&&(rt.innerHTML=eo),Ur=o(e),st=l(e,"P",{"data-svelte-h":!0}),m(st)!=="svelte-10uynke"&&(st.textContent=to),Zr=o(e),f(at.$$.fragment,e),qr=o(e),ot=l(e,"P",{"data-svelte-h":!0}),m(ot)!=="svelte-w2nqkz"&&(ot.textContent=ro),Vr=o(e),nt=l(e,"UL",{"data-svelte-h":!0}),m(nt)!=="svelte-1qiv3qf"&&(nt.innerHTML=so),zr=o(e),lt=l(e,"P",{"data-svelte-h":!0}),m(lt)!=="svelte-ii491f"&&(lt.innerHTML=ao),Er=o(e),k=l(e,"DIV",{class:!0});var H=$(k);f(it.$$.fragment,H),sa=o(H),Wt=l(H,"P",{"data-svelte-h":!0}),m(Wt)!=="svelte-173gxyd"&&(Wt.textContent=oo),aa=o(H),ie=l(H,"DIV",{class:!0});var ds=$(ie);f(mt.$$.fragment,ds),oa=o(ds),Qt=l(ds,"P",{"data-svelte-h":!0}),m(Qt)!=="svelte-wmaktk"&&(Qt.textContent=no),ds.forEach(t),na=o(H),E=l(H,"DIV",{class:!0});var sr=$(E);f(dt.$$.fragment,sr),la=o(sr),Yt=l(sr,"P",{"data-svelte-h":!0}),m(Yt)!=="svelte-11nqnea"&&(Yt.innerHTML=lo),ia=o(sr),f(me.$$.fragment,sr),sr.forEach(t),ma=o(H),de=l(H,"DIV",{class:!0});var cs=$(de);f(ct.$$.fragment,cs),da=o(cs),At=l(cs,"P",{"data-svelte-h":!0}),m(At)!=="svelte-d5zv1x"&&(At.textContent=io),cs.forEach(t),H.forEach(t),Hr=o(e),pt=l(e,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-18mz77q"&&(pt.innerHTML=mo),Nr=o(e),U=l(e,"DIV",{class:!0});var ar=$(U);f(ft.$$.fragment,ar),ca=o(ar),Ot=l(ar,"P",{"data-svelte-h":!0}),m(Ot)!=="svelte-169nh0g"&&(Ot.textContent=co),pa=o(ar),f(ce.$$.fragment,ar),ar.forEach(t),Br=o(e),ut=l(e,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-1esudax"&&(ut.innerHTML=po),Dr=o(e),f(ht.$$.fragment,e),Fr=o(e),gt=l(e,"P",{"data-svelte-h":!0}),m(gt)!=="svelte-3glna9"&&(gt.textContent=fo),Sr=o(e),f(_t.$$.fragment,e),Rr=o(e),vt=l(e,"P",{"data-svelte-h":!0}),m(vt)!=="svelte-jzuhjq"&&(vt.innerHTML=uo),Gr=o(e),f(xt.$$.fragment,e),Wr=o(e),$t=l(e,"P",{"data-svelte-h":!0}),m($t)!=="svelte-fac3c8"&&($t.innerHTML=ho),Qr=o(e),f(bt.$$.fragment,e),Yr=o(e),nr=l(e,"P",{}),$(nr).forEach(t),this.h()},h(){b(d,"name","hf:doc:metadata"),b(d,"content",Io),b(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){s(document.head,d),i(e,T,r),i(e,v,r),i(e,x,r),u(C,e,r),i(e,c,r),i(e,j,r),i(e,ir,r),i(e,fe,r),i(e,mr,r),u(ue,e,r),i(e,dr,r),i(e,he,r),i(e,cr,r),i(e,ge,r),i(e,pr,r),i(e,y,r),u(_e,y,null),s(y,ps),s(y,Tt),s(y,fs),s(y,F),u(ve,F,null),s(F,us),s(F,Ct),s(y,hs),s(y,S),u(xe,S,null),s(S,gs),s(S,Pt),s(y,_s),s(y,Z),u($e,Z,null),s(Z,vs),s(Z,jt),s(Z,xs),u(R,Z,null),s(y,$s),s(y,G),u(be,G,null),s(G,bs),s(G,It),s(y,ys),s(y,q),u(ye,q,null),s(q,Ms),s(q,kt),s(q,ws),u(W,q,null),s(y,Ts),s(y,V),u(Me,V,null),s(V,Cs),s(V,Xt),s(V,Ps),u(Q,V,null),s(y,js),s(y,z),u(we,z,null),s(z,Is),s(z,Jt),s(z,ks),u(Y,z,null),s(y,Xs),s(y,A),u(Te,A,null),s(A,Js),s(A,Lt),s(y,Ls),s(y,O),u(Ce,O,null),s(O,Us),s(O,Ut),s(y,Zs),s(y,K),u(Pe,K,null),s(K,qs),s(K,Zt),i(e,fr,r),u(je,e,r),i(e,ur,r),i(e,Ie,r),i(e,hr,r),i(e,P,r),u(ke,P,null),s(P,Vs),s(P,qt),s(P,zs),s(P,ee),u(Xe,ee,null),s(ee,Es),s(ee,Vt),s(P,Hs),s(P,te),u(Je,te,null),s(te,Ns),s(te,zt),s(P,Bs),s(P,re),u(Le,re,null),s(re,Ds),s(re,Et),s(P,Fs),s(P,se),u(Ue,se,null),s(se,Ss),s(se,Ht),s(P,Rs),s(P,ae),u(Ze,ae,null),s(ae,Gs),s(ae,Nt),s(P,Ws),s(P,oe),u(qe,oe,null),s(oe,Qs),s(oe,Bt),i(e,gr,r),i(e,J,r),u(Ve,J,null),s(J,Ys),s(J,Dt),s(J,As),s(J,ne),u(ze,ne,null),s(ne,Os),s(ne,Ft),i(e,_r,r),i(e,L,r),u(Ee,L,null),s(L,Ks),s(L,St),s(L,ea),s(L,le),u(He,le,null),s(le,ta),s(le,Rt),i(e,vr,r),u(Ne,e,r),i(e,xr,r),i(e,Be,r),i(e,$r,r),i(e,De,r),i(e,br,r),i(e,Fe,r),i(e,yr,r),i(e,Se,r),i(e,Mr,r),i(e,Re,r),i(e,wr,r),i(e,N,r),u(Ge,N,null),s(N,ra),s(N,Gt),i(e,Tr,r),u(We,e,r),i(e,Cr,r),i(e,Qe,r),i(e,Pr,r),i(e,Ye,r),i(e,jr,r),i(e,Ae,r),i(e,Ir,r),i(e,Oe,r),i(e,kr,r),i(e,Ke,r),i(e,Xr,r),i(e,et,r),i(e,Jr,r),u(tt,e,r),i(e,Lr,r),i(e,rt,r),i(e,Ur,r),i(e,st,r),i(e,Zr,r),u(at,e,r),i(e,qr,r),i(e,ot,r),i(e,Vr,r),i(e,nt,r),i(e,zr,r),i(e,lt,r),i(e,Er,r),i(e,k,r),u(it,k,null),s(k,sa),s(k,Wt),s(k,aa),s(k,ie),u(mt,ie,null),s(ie,oa),s(ie,Qt),s(k,na),s(k,E),u(dt,E,null),s(E,la),s(E,Yt),s(E,ia),u(me,E,null),s(k,ma),s(k,de),u(ct,de,null),s(de,da),s(de,At),i(e,Hr,r),i(e,pt,r),i(e,Nr,r),i(e,U,r),u(ft,U,null),s(U,ca),s(U,Ot),s(U,pa),u(ce,U,null),i(e,Br,r),i(e,ut,r),i(e,Dr,r),u(ht,e,r),i(e,Fr,r),i(e,gt,r),i(e,Sr,r),u(_t,e,r),i(e,Rr,r),i(e,vt,r),i(e,Gr,r),u(xt,e,r),i(e,Wr,r),i(e,$t,r),i(e,Qr,r),u(bt,e,r),i(e,Yr,r),i(e,nr,r),Ar=!0},p(e,[r]){const w={};r&2&&(w.$$scope={dirty:r,ctx:e}),R.$set(w);const yt={};r&2&&(yt.$$scope={dirty:r,ctx:e}),W.$set(yt);const Mt={};r&2&&(Mt.$$scope={dirty:r,ctx:e}),Q.$set(Mt);const B={};r&2&&(B.$$scope={dirty:r,ctx:e}),Y.$set(B);const wt={};r&2&&(wt.$$scope={dirty:r,ctx:e}),me.$set(wt);const D={};r&2&&(D.$$scope={dirty:r,ctx:e}),ce.$set(D)},i(e){Ar||(h(C.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(xe.$$.fragment,e),h($e.$$.fragment,e),h(R.$$.fragment,e),h(be.$$.fragment,e),h(ye.$$.fragment,e),h(W.$$.fragment,e),h(Me.$$.fragment,e),h(Q.$$.fragment,e),h(we.$$.fragment,e),h(Y.$$.fragment,e),h(Te.$$.fragment,e),h(Ce.$$.fragment,e),h(Pe.$$.fragment,e),h(je.$$.fragment,e),h(ke.$$.fragment,e),h(Xe.$$.fragment,e),h(Je.$$.fragment,e),h(Le.$$.fragment,e),h(Ue.$$.fragment,e),h(Ze.$$.fragment,e),h(qe.$$.fragment,e),h(Ve.$$.fragment,e),h(ze.$$.fragment,e),h(Ee.$$.fragment,e),h(He.$$.fragment,e),h(Ne.$$.fragment,e),h(Ge.$$.fragment,e),h(We.$$.fragment,e),h(tt.$$.fragment,e),h(at.$$.fragment,e),h(it.$$.fragment,e),h(mt.$$.fragment,e),h(dt.$$.fragment,e),h(me.$$.fragment,e),h(ct.$$.fragment,e),h(ft.$$.fragment,e),h(ce.$$.fragment,e),h(ht.$$.fragment,e),h(_t.$$.fragment,e),h(xt.$$.fragment,e),h(bt.$$.fragment,e),Ar=!0)},o(e){g(C.$$.fragment,e),g(ue.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(xe.$$.fragment,e),g($e.$$.fragment,e),g(R.$$.fragment,e),g(be.$$.fragment,e),g(ye.$$.fragment,e),g(W.$$.fragment,e),g(Me.$$.fragment,e),g(Q.$$.fragment,e),g(we.$$.fragment,e),g(Y.$$.fragment,e),g(Te.$$.fragment,e),g(Ce.$$.fragment,e),g(Pe.$$.fragment,e),g(je.$$.fragment,e),g(ke.$$.fragment,e),g(Xe.$$.fragment,e),g(Je.$$.fragment,e),g(Le.$$.fragment,e),g(Ue.$$.fragment,e),g(Ze.$$.fragment,e),g(qe.$$.fragment,e),g(Ve.$$.fragment,e),g(ze.$$.fragment,e),g(Ee.$$.fragment,e),g(He.$$.fragment,e),g(Ne.$$.fragment,e),g(Ge.$$.fragment,e),g(We.$$.fragment,e),g(tt.$$.fragment,e),g(at.$$.fragment,e),g(it.$$.fragment,e),g(mt.$$.fragment,e),g(dt.$$.fragment,e),g(me.$$.fragment,e),g(ct.$$.fragment,e),g(ft.$$.fragment,e),g(ce.$$.fragment,e),g(ht.$$.fragment,e),g(_t.$$.fragment,e),g(xt.$$.fragment,e),g(bt.$$.fragment,e),Ar=!1},d(e){e&&(t(T),t(v),t(x),t(c),t(j),t(ir),t(fe),t(mr),t(dr),t(he),t(cr),t(ge),t(pr),t(y),t(fr),t(ur),t(Ie),t(hr),t(P),t(gr),t(J),t(_r),t(L),t(vr),t(xr),t(Be),t($r),t(De),t(br),t(Fe),t(yr),t(Se),t(Mr),t(Re),t(wr),t(N),t(Tr),t(Cr),t(Qe),t(Pr),t(Ye),t(jr),t(Ae),t(Ir),t(Oe),t(kr),t(Ke),t(Xr),t(et),t(Jr),t(Lr),t(rt),t(Ur),t(st),t(Zr),t(qr),t(ot),t(Vr),t(nt),t(zr),t(lt),t(Er),t(k),t(Hr),t(pt),t(Nr),t(U),t(Br),t(ut),t(Dr),t(Fr),t(gt),t(Sr),t(Rr),t(vt),t(Gr),t(Wr),t($t),t(Qr),t(Yr),t(nr)),t(d),_(C,e),_(ue,e),_(_e),_(ve),_(xe),_($e),_(R),_(be),_(ye),_(W),_(Me),_(Q),_(we),_(Y),_(Te),_(Ce),_(Pe),_(je,e),_(ke),_(Xe),_(Je),_(Le),_(Ue),_(Ze),_(qe),_(Ve),_(ze),_(Ee),_(He),_(Ne,e),_(Ge),_(We,e),_(tt,e),_(at,e),_(it),_(mt),_(dt),_(me),_(ct),_(ft),_(ce),_(ht,e),_(_t,e),_(xt,e),_(bt,e)}}}const Io='{"title":"Processors","local":"processors","sections":[{"title":"Multi-modal processors","local":"transformers.ProcessorMixin","sections":[],"depth":2},{"title":"Deprecated processors","local":"transformers.DataProcessor","sections":[],"depth":2},{"title":"GLUE","local":"transformers.glue_convert_examples_to_features","sections":[],"depth":2},{"title":"XNLI","local":"xnli","sections":[],"depth":2},{"title":"SQuAD","local":"squad","sections":[{"title":"Processors","local":"transformers.data.processors.squad.SquadProcessor","sections":[],"depth":3},{"title":"Example usage","local":"example-usage","sections":[],"depth":3}],"depth":2}],"depth":1}';function ko(X){return _o(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zo extends vo{constructor(d){super(),xo(this,d,ko,jo,go,{})}}export{zo as component};
