import{s as Es,n as Gs,o as Xs}from"../chunks/scheduler.85c25b89.js";import{S as Fs,i as Hs,g as h,s as a,r as p,A as Ys,h as u,f as t,c as n,j as Ds,u as i,x as M,k as Ws,y as As,a as l,v as r,d as m,t as o,w as c}from"../chunks/index.c9bcf812.js";import{C as y}from"../chunks/CodeBlock.94efc595.js";import{H as f}from"../chunks/Heading.3c6e5b17.js";function Ks(gs){let g,ge,ye,je,j,de,d,js="All of the models in <code>timm</code> have consistent mechanisms for obtaining various types of features from the model for tasks besides classification.",Ue,U,Je,J,ds="The features from the penultimate model layer can be obtained in several ways without requiring model surgery (although feel free to do surgery). One must first decide if they want pooled or un-pooled features.",we,w,be,b,Us="There are three ways to obtain unpooled features.",$e,$,Js="Without modifying the network, one can call <code>model.forward_features(input)</code> on any model instead of the usual <code>model(input)</code>. This will bypass the head classifier and global pooling for networks.",Te,T,ws="If one wants to explicitly modify the network to return unpooled features, they can either create the model without a classifier and pooling, or remove it later. Both paths remove the parameters associated with the classifier from the network.",Ce,C,ke,k,xe,x,bs="Output:",Qe,Q,ve,v,Be,B,Ne,N,$s="Output:",Ie,I,Ze,Z,Se,S,_e,_,Ts="Output:",Re,R,ze,z,Ve,V,Cs="To modify the network to return pooled features, one can use <code>forward_features()</code> and pool/flatten the result themselves, or modify the network like above but keep pooling intact.",De,D,We,W,Ee,E,ks="Output:",Ge,G,Xe,X,Fe,F,He,H,xs="Output:",Ye,Y,Ae,A,Ke,K,Qs="Object detection, segmentation, keypoint, and a variety of dense pixel tasks require access to feature maps from the backbone network at multiple scales. This is often done by modifying the original classification network. Since each network varies quite a bit in structure, it’s not uncommon to see only a few backbones supported in any given obj detection or segmentation library.",Le,L,vs="<code>timm</code> allows a consistent interface for creating any of the included models as feature backbones that output feature maps for selected levels.",Pe,P,Bs="A feature backbone can be created by adding the argument <code>features_only=True</code> to any <code>create_model</code> call. By default 5 strides will be output from most models (not all have that many), with the first starting at 2 (some start at 1 or 4).",Oe,O,qe,q,es,ee,Ns="Output:",ss,se,ts,te,ls,le,Is="After a feature backbone has been created, it can be queried to provide channel or resolution reduction information to the downstream heads without requiring static config or hardcoded constants. The <code>.feature_info</code> attribute is a class encapsulating the information about the feature extraction points.",as,ae,ns,ne,Zs="Output:",ps,pe,is,ie,rs,re,Ss="There are two additional creation arguments impacting the output features.",ms,me,_s="<li><code>out_indices</code> selects which indices to output</li> <li><code>output_stride</code> limits the feature output stride of the network (also works in classification mode BTW)</li>",os,oe,Rs="<code>out_indices</code> is supported by all models, but not all models have the same index to feature stride mapping. Look at the code or check feature_info to compare. The out indices generally correspond to the <code>C(i+1)th</code> feature level (a <code>2^(i+1)</code> reduction). For most models, index 0 is the stride 2 features, and index 4 is stride 32.",cs,ce,zs="<code>output_stride</code> is achieved by converting layers to use dilated convolutions. Doing so is not always straightforward, some networks only support <code>output_stride=32</code>.",hs,he,us,ue,Vs="Output:",Ms,Me,ys,fe,fs;return j=new f({props:{title:"Feature Extraction",local:"feature-extraction",headingTag:"h1"}}),U=new f({props:{title:"Penultimate Layer Features (Pre-Classifier Features)",local:"penultimate-layer-features-pre-classifier-features",headingTag:"h2"}}),w=new f({props:{title:"Unpooled",local:"unpooled",headingTag:"h3"}}),C=new f({props:{title:"forward_features()",local:"forwardfeatures",headingTag:"h4"}}),k=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCd4Y2VwdGlvbjQxJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW8lMjAlM0QlMjBtKHRvcmNoLnJhbmRuKDIlMkMlMjAzJTJDJTIwMjk5JTJDJTIwMjk5KSklMEFwcmludChmJ09yaWdpbmFsJTIwc2hhcGUlM0ElMjAlN0JvLnNoYXBlJTdEJyklMEFvJTIwJTNEJTIwbS5mb3J3YXJkX2ZlYXR1cmVzKHRvcmNoLnJhbmRuKDIlMkMlMjAzJTJDJTIwMjk5JTJDJTIwMjk5KSklMEFwcmludChmJ1VucG9vbGVkJTIwc2hhcGUlM0ElMjAlN0JvLnNoYXBlJTdEJyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;xception41&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">299</span>, <span class="hljs-number">299</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Original shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m.forward_features(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">299</span>, <span class="hljs-number">299</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Unpooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),Q=new y({props:{code:"T3JpZ2luYWwlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMDAlNUQpJTBBVW5wb29sZWQlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDIwNDglMkMlMjAxMCUyQyUyMDEwJTVEKQ==",highlighted:`Original shape: torch.Size([2, 1000])
Unpooled shape: torch.Size([2, 2048, 10, 10])`,wrap:!1}}),v=new f({props:{title:"Create with no classifier and pooling",local:"create-with-no-classifier-and-pooling",headingTag:"h4"}}),B=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZXNuZXQ1MCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNEMCUyQyUyMGdsb2JhbF9wb29sJTNEJycpJTBBbyUyMCUzRCUyMG0odG9yY2gucmFuZG4oMiUyQyUyMDMlMkMlMjAyMjQlMkMlMjAyMjQpKSUwQXByaW50KGYnVW5wb29sZWQlMjBzaGFwZSUzQSUyMCU3Qm8uc2hhcGUlN0QnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;resnet50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-number">0</span>, global_pool=<span class="hljs-string">&#x27;&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Unpooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),I=new y({props:{code:"VW5wb29sZWQlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDIwNDglMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:"Unpooled shape: torch.Size([2, 2048, 7, 7])",wrap:!1}}),Z=new f({props:{title:"Remove it later",local:"remove-it-later",headingTag:"h4"}}),S=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdkZW5zZW5ldDEyMSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidPcmlnaW5hbCUyMHNoYXBlJTNBJTIwJTdCby5zaGFwZSU3RCcpJTBBbS5yZXNldF9jbGFzc2lmaWVyKDAlMkMlMjAnJyklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidVbnBvb2xlZCUyMHNoYXBlJTNBJTIwJTdCby5zaGFwZSU3RCcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;densenet121&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Original shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>m.reset_classifier(<span class="hljs-number">0</span>, <span class="hljs-string">&#x27;&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Unpooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),R=new y({props:{code:"T3JpZ2luYWwlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMDAlNUQpJTBBVW5wb29sZWQlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMjQlMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:`Original shape: torch.Size([2, 1000])
Unpooled shape: torch.Size([2, 1024, 7, 7])`,wrap:!1}}),z=new f({props:{title:"Pooled",local:"pooled",headingTag:"h3"}}),D=new f({props:{title:"Create with no classifier",local:"create-with-no-classifier",headingTag:"h4"}}),W=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZXNuZXQ1MCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNEMCklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidQb29sZWQlMjBzaGFwZSUzQSUyMCU3Qm8uc2hhcGUlN0QnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;resnet50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Pooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),G=new y({props:{code:"UG9vbGVkJTIwc2hhcGUlM0ElMjB0b3JjaC5TaXplKCU1QjIlMkMlMjAyMDQ4JTVEKQ==",highlighted:"Pooled shape: torch.Size([2, 2048])",wrap:!1}}),X=new f({props:{title:"Remove it later",local:"remove-it-later",headingTag:"h4"}}),F=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdlc2Vfdm92bmV0MTliX2R3JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW8lMjAlM0QlMjBtKHRvcmNoLnJhbmRuKDIlMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0KSklMEFwcmludChmJ09yaWdpbmFsJTIwc2hhcGUlM0ElMjAlN0JvLnNoYXBlJTdEJyklMEFtLnJlc2V0X2NsYXNzaWZpZXIoMCklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidQb29sZWQlMjBzaGFwZSUzQSUyMCU3Qm8uc2hhcGUlN0QnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;ese_vovnet19b_dw&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Original shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>m.reset_classifier(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Pooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),Y=new y({props:{code:"T3JpZ2luYWwlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMDAlNUQpJTBBUG9vbGVkJTIwc2hhcGUlM0ElMjB0b3JjaC5TaXplKCU1QjIlMkMlMjAxMDI0JTVEKQ==",highlighted:`Original shape: torch.Size([2, 1000])
Pooled shape: torch.Size([2, 1024])`,wrap:!1}}),A=new f({props:{title:"Multi-scale Feature Maps (Feature Pyramid)",local:"multi-scale-feature-maps-feature-pyramid",headingTag:"h2"}}),O=new f({props:{title:"Create a feature map extraction model",local:"create-a-feature-map-extraction-model",headingTag:"h3"}}),q=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZXNuZXN0MjZkJyUyQyUyMGZlYXR1cmVzX29ubHklM0RUcnVlJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbyUyMCUzRCUyMG0odG9yY2gucmFuZG4oMiUyQyUyMDMlMkMlMjAyMjQlMkMlMjAyMjQpKSUwQWZvciUyMHglMjBpbiUyMG8lM0ElMEElMjAlMjAlMjAlMjBwcmludCh4LnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;resnest26d&#x27;</span>, features_only=<span class="hljs-literal">True</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> o:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(x.shape)`,wrap:!1}}),se=new y({props:{code:"dG9yY2guU2l6ZSglNUIyJTJDJTIwNjQlMkMlMjAxMTIlMkMlMjAxMTIlNUQpJTBBdG9yY2guU2l6ZSglNUIyJTJDJTIwMjU2JTJDJTIwNTYlMkMlMjA1NiU1RCklMEF0b3JjaC5TaXplKCU1QjIlMkMlMjA1MTIlMkMlMjAyOCUyQyUyMDI4JTVEKSUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMjQlMkMlMjAxNCUyQyUyMDE0JTVEKSUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDIwNDglMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:`torch.Size([2, 64, 112, 112])
torch.Size([2, 256, 56, 56])
torch.Size([2, 512, 28, 28])
torch.Size([2, 1024, 14, 14])
torch.Size([2, 2048, 7, 7])`,wrap:!1}}),te=new f({props:{title:"Query the feature information",local:"query-the-feature-information",headingTag:"h3"}}),ae=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZWduZXR5XzAzMiclMkMlMjBmZWF0dXJlc19vbmx5JTNEVHJ1ZSUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXByaW50KGYnRmVhdHVyZSUyMGNoYW5uZWxzJTNBJTIwJTdCbS5mZWF0dXJlX2luZm8uY2hhbm5lbHMoKSU3RCcpJTBBbyUyMCUzRCUyMG0odG9yY2gucmFuZG4oMiUyQyUyMDMlMkMlMjAyMjQlMkMlMjAyMjQpKSUwQWZvciUyMHglMjBpbiUyMG8lM0ElMEElMjAlMjAlMjAlMjBwcmludCh4LnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;regnety_032&#x27;</span>, features_only=<span class="hljs-literal">True</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Feature channels: <span class="hljs-subst">{m.feature_info.channels()}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> o:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(x.shape)`,wrap:!1}}),pe=new y({props:{code:"RmVhdHVyZSUyMGNoYW5uZWxzJTNBJTIwJTVCMzIlMkMlMjA3MiUyQyUyMDIxNiUyQyUyMDU3NiUyQyUyMDE1MTIlNUQlMEF0b3JjaC5TaXplKCU1QjIlMkMlMjAzMiUyQyUyMDExMiUyQyUyMDExMiU1RCklMEF0b3JjaC5TaXplKCU1QjIlMkMlMjA3MiUyQyUyMDU2JTJDJTIwNTYlNUQpJTBBdG9yY2guU2l6ZSglNUIyJTJDJTIwMjE2JTJDJTIwMjglMkMlMjAyOCU1RCklMEF0b3JjaC5TaXplKCU1QjIlMkMlMjA1NzYlMkMlMjAxNCUyQyUyMDE0JTVEKSUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDE1MTIlMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:`Feature channels: [32, 72, 216, 576, 1512]
torch.Size([2, 32, 112, 112])
torch.Size([2, 72, 56, 56])
torch.Size([2, 216, 28, 28])
torch.Size([2, 576, 14, 14])
torch.Size([2, 1512, 7, 7])`,wrap:!1}}),ie=new f({props:{title:"Select specific feature levels or limit the stride",local:"select-specific-feature-levels-or-limit-the-stride",headingTag:"h3"}}),he=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdlY2FyZXNuZXQxMDFkJyUyQyUyMGZlYXR1cmVzX29ubHklM0RUcnVlJTJDJTIwb3V0cHV0X3N0cmlkZSUzRDglMkMlMjBvdXRfaW5kaWNlcyUzRCgyJTJDJTIwNCklMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFwcmludChmJ0ZlYXR1cmUlMjBjaGFubmVscyUzQSUyMCU3Qm0uZmVhdHVyZV9pbmZvLmNoYW5uZWxzKCklN0QnKSUwQXByaW50KGYnRmVhdHVyZSUyMHJlZHVjdGlvbiUzQSUyMCU3Qm0uZmVhdHVyZV9pbmZvLnJlZHVjdGlvbigpJTdEJyklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDMyMCUyQyUyMDMyMCkpJTBBZm9yJTIweCUyMGluJTIwbyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHguc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;ecaresnet101d&#x27;</span>, features_only=<span class="hljs-literal">True</span>, output_stride=<span class="hljs-number">8</span>, out_indices=(<span class="hljs-number">2</span>, <span class="hljs-number">4</span>), pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Feature channels: <span class="hljs-subst">{m.feature_info.channels()}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Feature reduction: <span class="hljs-subst">{m.feature_info.reduction()}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">320</span>, <span class="hljs-number">320</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> o:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(x.shape)`,wrap:!1}}),Me=new y({props:{code:"RmVhdHVyZSUyMGNoYW5uZWxzJTNBJTIwJTVCNTEyJTJDJTIwMjA0OCU1RCUwQUZlYXR1cmUlMjByZWR1Y3Rpb24lM0ElMjAlNUI4JTJDJTIwOCU1RCUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDUxMiUyQyUyMDQwJTJDJTIwNDAlNUQpJTBBdG9yY2guU2l6ZSglNUIyJTJDJTIwMjA0OCUyQyUyMDQwJTJDJTIwNDAlNUQp",highlighted:`Feature channels: [512, 2048]
Feature reduction: [8, 8]
torch.Size([2, 512, 40, 40])
torch.Size([2, 2048, 40, 40])`,wrap:!1}}),{c(){g=h("meta"),ge=a(),ye=h("p"),je=a(),p(j.$$.fragment),de=a(),d=h("p"),d.innerHTML=js,Ue=a(),p(U.$$.fragment),Je=a(),J=h("p"),J.textContent=ds,we=a(),p(w.$$.fragment),be=a(),b=h("p"),b.textContent=Us,$e=a(),$=h("p"),$.innerHTML=Js,Te=a(),T=h("p"),T.textContent=ws,Ce=a(),p(C.$$.fragment),ke=a(),p(k.$$.fragment),xe=a(),x=h("p"),x.textContent=bs,Qe=a(),p(Q.$$.fragment),ve=a(),p(v.$$.fragment),Be=a(),p(B.$$.fragment),Ne=a(),N=h("p"),N.textContent=$s,Ie=a(),p(I.$$.fragment),Ze=a(),p(Z.$$.fragment),Se=a(),p(S.$$.fragment),_e=a(),_=h("p"),_.textContent=Ts,Re=a(),p(R.$$.fragment),ze=a(),p(z.$$.fragment),Ve=a(),V=h("p"),V.innerHTML=Cs,De=a(),p(D.$$.fragment),We=a(),p(W.$$.fragment),Ee=a(),E=h("p"),E.textContent=ks,Ge=a(),p(G.$$.fragment),Xe=a(),p(X.$$.fragment),Fe=a(),p(F.$$.fragment),He=a(),H=h("p"),H.textContent=xs,Ye=a(),p(Y.$$.fragment),Ae=a(),p(A.$$.fragment),Ke=a(),K=h("p"),K.textContent=Qs,Le=a(),L=h("p"),L.innerHTML=vs,Pe=a(),P=h("p"),P.innerHTML=Bs,Oe=a(),p(O.$$.fragment),qe=a(),p(q.$$.fragment),es=a(),ee=h("p"),ee.textContent=Ns,ss=a(),p(se.$$.fragment),ts=a(),p(te.$$.fragment),ls=a(),le=h("p"),le.innerHTML=Is,as=a(),p(ae.$$.fragment),ns=a(),ne=h("p"),ne.textContent=Zs,ps=a(),p(pe.$$.fragment),is=a(),p(ie.$$.fragment),rs=a(),re=h("p"),re.textContent=Ss,ms=a(),me=h("ul"),me.innerHTML=_s,os=a(),oe=h("p"),oe.innerHTML=Rs,cs=a(),ce=h("p"),ce.innerHTML=zs,hs=a(),p(he.$$.fragment),us=a(),ue=h("p"),ue.textContent=Vs,Ms=a(),p(Me.$$.fragment),ys=a(),fe=h("p"),this.h()},l(e){const s=Ys("svelte-u9bgzb",document.head);g=u(s,"META",{name:!0,content:!0}),s.forEach(t),ge=n(e),ye=u(e,"P",{}),Ds(ye).forEach(t),je=n(e),i(j.$$.fragment,e),de=n(e),d=u(e,"P",{"data-svelte-h":!0}),M(d)!=="svelte-1w5xc9e"&&(d.innerHTML=js),Ue=n(e),i(U.$$.fragment,e),Je=n(e),J=u(e,"P",{"data-svelte-h":!0}),M(J)!=="svelte-1i0y2af"&&(J.textContent=ds),we=n(e),i(w.$$.fragment,e),be=n(e),b=u(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-gzowzl"&&(b.textContent=Us),$e=n(e),$=u(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1c1de84"&&($.innerHTML=Js),Te=n(e),T=u(e,"P",{"data-svelte-h":!0}),M(T)!=="svelte-1c79pr0"&&(T.textContent=ws),Ce=n(e),i(C.$$.fragment,e),ke=n(e),i(k.$$.fragment,e),xe=n(e),x=u(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1wuxk0l"&&(x.textContent=bs),Qe=n(e),i(Q.$$.fragment,e),ve=n(e),i(v.$$.fragment,e),Be=n(e),i(B.$$.fragment,e),Ne=n(e),N=u(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1wuxk0l"&&(N.textContent=$s),Ie=n(e),i(I.$$.fragment,e),Ze=n(e),i(Z.$$.fragment,e),Se=n(e),i(S.$$.fragment,e),_e=n(e),_=u(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1wuxk0l"&&(_.textContent=Ts),Re=n(e),i(R.$$.fragment,e),ze=n(e),i(z.$$.fragment,e),Ve=n(e),V=u(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-jci7dg"&&(V.innerHTML=Cs),De=n(e),i(D.$$.fragment,e),We=n(e),i(W.$$.fragment,e),Ee=n(e),E=u(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1wuxk0l"&&(E.textContent=ks),Ge=n(e),i(G.$$.fragment,e),Xe=n(e),i(X.$$.fragment,e),Fe=n(e),i(F.$$.fragment,e),He=n(e),H=u(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1wuxk0l"&&(H.textContent=xs),Ye=n(e),i(Y.$$.fragment,e),Ae=n(e),i(A.$$.fragment,e),Ke=n(e),K=u(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-56ounp"&&(K.textContent=Qs),Le=n(e),L=u(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-1j7o0l4"&&(L.innerHTML=vs),Pe=n(e),P=u(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-qgbd6k"&&(P.innerHTML=Bs),Oe=n(e),i(O.$$.fragment,e),qe=n(e),i(q.$$.fragment,e),es=n(e),ee=u(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-1wuxk0l"&&(ee.textContent=Ns),ss=n(e),i(se.$$.fragment,e),ts=n(e),i(te.$$.fragment,e),ls=n(e),le=u(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-2ryznm"&&(le.innerHTML=Is),as=n(e),i(ae.$$.fragment,e),ns=n(e),ne=u(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-1wuxk0l"&&(ne.textContent=Zs),ps=n(e),i(pe.$$.fragment,e),is=n(e),i(ie.$$.fragment,e),rs=n(e),re=u(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-18fc4zz"&&(re.textContent=Ss),ms=n(e),me=u(e,"UL",{"data-svelte-h":!0}),M(me)!=="svelte-1c2ig9e"&&(me.innerHTML=_s),os=n(e),oe=u(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-1sy35a7"&&(oe.innerHTML=Rs),cs=n(e),ce=u(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-nvrnid"&&(ce.innerHTML=zs),hs=n(e),i(he.$$.fragment,e),us=n(e),ue=u(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-1wuxk0l"&&(ue.textContent=Vs),Ms=n(e),i(Me.$$.fragment,e),ys=n(e),fe=u(e,"P",{}),Ds(fe).forEach(t),this.h()},h(){Ws(g,"name","hf:doc:metadata"),Ws(g,"content",Ls)},m(e,s){As(document.head,g),l(e,ge,s),l(e,ye,s),l(e,je,s),r(j,e,s),l(e,de,s),l(e,d,s),l(e,Ue,s),r(U,e,s),l(e,Je,s),l(e,J,s),l(e,we,s),r(w,e,s),l(e,be,s),l(e,b,s),l(e,$e,s),l(e,$,s),l(e,Te,s),l(e,T,s),l(e,Ce,s),r(C,e,s),l(e,ke,s),r(k,e,s),l(e,xe,s),l(e,x,s),l(e,Qe,s),r(Q,e,s),l(e,ve,s),r(v,e,s),l(e,Be,s),r(B,e,s),l(e,Ne,s),l(e,N,s),l(e,Ie,s),r(I,e,s),l(e,Ze,s),r(Z,e,s),l(e,Se,s),r(S,e,s),l(e,_e,s),l(e,_,s),l(e,Re,s),r(R,e,s),l(e,ze,s),r(z,e,s),l(e,Ve,s),l(e,V,s),l(e,De,s),r(D,e,s),l(e,We,s),r(W,e,s),l(e,Ee,s),l(e,E,s),l(e,Ge,s),r(G,e,s),l(e,Xe,s),r(X,e,s),l(e,Fe,s),r(F,e,s),l(e,He,s),l(e,H,s),l(e,Ye,s),r(Y,e,s),l(e,Ae,s),r(A,e,s),l(e,Ke,s),l(e,K,s),l(e,Le,s),l(e,L,s),l(e,Pe,s),l(e,P,s),l(e,Oe,s),r(O,e,s),l(e,qe,s),r(q,e,s),l(e,es,s),l(e,ee,s),l(e,ss,s),r(se,e,s),l(e,ts,s),r(te,e,s),l(e,ls,s),l(e,le,s),l(e,as,s),r(ae,e,s),l(e,ns,s),l(e,ne,s),l(e,ps,s),r(pe,e,s),l(e,is,s),r(ie,e,s),l(e,rs,s),l(e,re,s),l(e,ms,s),l(e,me,s),l(e,os,s),l(e,oe,s),l(e,cs,s),l(e,ce,s),l(e,hs,s),r(he,e,s),l(e,us,s),l(e,ue,s),l(e,Ms,s),r(Me,e,s),l(e,ys,s),l(e,fe,s),fs=!0},p:Gs,i(e){fs||(m(j.$$.fragment,e),m(U.$$.fragment,e),m(w.$$.fragment,e),m(C.$$.fragment,e),m(k.$$.fragment,e),m(Q.$$.fragment,e),m(v.$$.fragment,e),m(B.$$.fragment,e),m(I.$$.fragment,e),m(Z.$$.fragment,e),m(S.$$.fragment,e),m(R.$$.fragment,e),m(z.$$.fragment,e),m(D.$$.fragment,e),m(W.$$.fragment,e),m(G.$$.fragment,e),m(X.$$.fragment,e),m(F.$$.fragment,e),m(Y.$$.fragment,e),m(A.$$.fragment,e),m(O.$$.fragment,e),m(q.$$.fragment,e),m(se.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(pe.$$.fragment,e),m(ie.$$.fragment,e),m(he.$$.fragment,e),m(Me.$$.fragment,e),fs=!0)},o(e){o(j.$$.fragment,e),o(U.$$.fragment,e),o(w.$$.fragment,e),o(C.$$.fragment,e),o(k.$$.fragment,e),o(Q.$$.fragment,e),o(v.$$.fragment,e),o(B.$$.fragment,e),o(I.$$.fragment,e),o(Z.$$.fragment,e),o(S.$$.fragment,e),o(R.$$.fragment,e),o(z.$$.fragment,e),o(D.$$.fragment,e),o(W.$$.fragment,e),o(G.$$.fragment,e),o(X.$$.fragment,e),o(F.$$.fragment,e),o(Y.$$.fragment,e),o(A.$$.fragment,e),o(O.$$.fragment,e),o(q.$$.fragment,e),o(se.$$.fragment,e),o(te.$$.fragment,e),o(ae.$$.fragment,e),o(pe.$$.fragment,e),o(ie.$$.fragment,e),o(he.$$.fragment,e),o(Me.$$.fragment,e),fs=!1},d(e){e&&(t(ge),t(ye),t(je),t(de),t(d),t(Ue),t(Je),t(J),t(we),t(be),t(b),t($e),t($),t(Te),t(T),t(Ce),t(ke),t(xe),t(x),t(Qe),t(ve),t(Be),t(Ne),t(N),t(Ie),t(Ze),t(Se),t(_e),t(_),t(Re),t(ze),t(Ve),t(V),t(De),t(We),t(Ee),t(E),t(Ge),t(Xe),t(Fe),t(He),t(H),t(Ye),t(Ae),t(Ke),t(K),t(Le),t(L),t(Pe),t(P),t(Oe),t(qe),t(es),t(ee),t(ss),t(ts),t(ls),t(le),t(as),t(ns),t(ne),t(ps),t(is),t(rs),t(re),t(ms),t(me),t(os),t(oe),t(cs),t(ce),t(hs),t(us),t(ue),t(Ms),t(ys),t(fe)),t(g),c(j,e),c(U,e),c(w,e),c(C,e),c(k,e),c(Q,e),c(v,e),c(B,e),c(I,e),c(Z,e),c(S,e),c(R,e),c(z,e),c(D,e),c(W,e),c(G,e),c(X,e),c(F,e),c(Y,e),c(A,e),c(O,e),c(q,e),c(se,e),c(te,e),c(ae,e),c(pe,e),c(ie,e),c(he,e),c(Me,e)}}}const Ls='{"title":"Feature Extraction","local":"feature-extraction","sections":[{"title":"Penultimate Layer Features (Pre-Classifier Features)","local":"penultimate-layer-features-pre-classifier-features","sections":[{"title":"Unpooled","local":"unpooled","sections":[{"title":"forward_features()","local":"forwardfeatures","sections":[],"depth":4},{"title":"Create with no classifier and pooling","local":"create-with-no-classifier-and-pooling","sections":[],"depth":4},{"title":"Remove it later","local":"remove-it-later","sections":[],"depth":4}],"depth":3},{"title":"Pooled","local":"pooled","sections":[{"title":"Create with no classifier","local":"create-with-no-classifier","sections":[],"depth":4},{"title":"Remove it later","local":"remove-it-later","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Multi-scale Feature Maps (Feature Pyramid)","local":"multi-scale-feature-maps-feature-pyramid","sections":[{"title":"Create a feature map extraction model","local":"create-a-feature-map-extraction-model","sections":[],"depth":3},{"title":"Query the feature information","local":"query-the-feature-information","sections":[],"depth":3},{"title":"Select specific feature levels or limit the stride","local":"select-specific-feature-levels-or-limit-the-stride","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ps(gs){return Xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tt extends Fs{constructor(g){super(),Hs(this,g,Ps,Ks,Es,{})}}export{tt as component};
