import{s as pt,n as rt,o as ct}from"../chunks/scheduler.9991993c.js";import{S as it,i as ft,g as p,s as a,r as i,A as mt,h as r,f as l,c as n,j as at,u as f,x as c,k as nt,y as dt,a as s,v as m,d,t as o,w as h}from"../chunks/index.7fc9a5e7.js";import{C as $}from"../chunks/CodeBlock.e11cba92.js";import{H as U}from"../chunks/Heading.e3de321f.js";function ot(Ee){let _,te,K,le,M,se,u,Ge=`<a href="https://pytorch.org/blog/introducing-pytorch-fully-sharded-data-parallel-api/" rel="nofollow">完全分片数据并行（FSDP）</a>是一种数据并行方法，
它将模型的参数、梯度和优化器状态在可用 GPU（也称为 Worker 或 <em>rank</em>）的数量上进行分片。
与<a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html" rel="nofollow">分布式数据并行（DDP）</a>不同，
FSDP 减少了内存使用量，因为模型在每个 GPU 上都被复制了一次。这就提高了 GPU 内存效率，
使您能够用较少的 GPU 训练更大的模型。FSDP 已经集成到 Accelerate 中，
这是一个用于在分布式环境中轻松管理训练的库，这意味着可以从 <code>Trainer</code> 类中调用这个库。`,ae,T,ve="在开始之前，请确保已安装 Accelerate，并且至少使用 PyTorch 2.1.0 或更高版本。",ne,j,pe,y,re,g,De=`首先，运行 <a href="https://huggingface.co/docs/accelerate/package_reference/cli#accelerate-config" rel="nofollow"><code>accelerate config</code></a>
命令为您的训练环境创建一个配置文件。Accelerate 使用此配置文件根据您在 <code>accelerate config</code>
中选择的训练选项来自动搭建正确的训练环境。`,ce,w,ie,J,Qe=`运行 <code>accelerate config</code> 时，您将被提示一系列选项来配置训练环境。
本节涵盖了一些最重要的 FSDP 选项。要了解有关其他可用的 FSDP 选项的更多信息，
请查阅 <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments.fsdp_config" rel="nofollow">fsdp_config</a> 参数。`,fe,Z,me,S,ke="FSDP 提供了多种可选择的分片策略：",de,B,We="<li><code>FULL_SHARD</code> - 将模型参数、梯度和优化器状态跨 Worker 进行分片；为此选项选择 <code>1</code></li> <li><code>SHARD_GRAD_OP</code>- 将梯度和优化器状态跨 Worker 进行分片；为此选项选择 <code>2</code></li> <li><code>NO_SHARD</code> - 不分片任何内容（这等同于 DDP）；为此选项选择 <code>3</code></li> <li><code>HYBRID_SHARD</code> - 在每个 Worker 中分片模型参数、梯度和优化器状态，其中每个 Worker 也有完整副本；为此选项选择 <code>4</code></li> <li><code>HYBRID_SHARD_ZERO2</code> - 在每个 Worker 中分片梯度和优化器状态，其中每个 Worker 也有完整副本；为此选项选择 <code>5</code></li>",oe,C,Ae="这由 <code>fsdp_sharding_strategy</code> 标志启用。",he,F,_e,R,Le=`当参数和梯度在不使用时可以卸载到 CPU 上，以节省更多 GPU 内存并帮助您适应即使 FSDP 也不足以容纳大型模型的情况。
在运行 <code>accelerate config</code> 时，通过设置 <code>fsdp_offload_params: true</code> 来启用此功能。`,Ue,b,$e,P,ze=`FSDP 是通过包装网络中的每个层来应用的。通常，包装是以嵌套方式应用的，其中完整的权重在每次前向传递后被丢弃，
以便在下一层使用内存。<strong>自动包装</strong>策略是实现这一点的最简单方法，您不需要更改任何代码。
您应该选择 <code>fsdp_auto_wrap_policy: TRANSFORMER_BASED_WRAP</code> 来包装一个 Transformer 层，
并且 <code>fsdp_transformer_layer_cls_to_wrap</code> 来指定要包装的层（例如 <code>BertLayer</code>）。`,Me,V,Ye=`否则，您可以选择基于大小的包装策略，其中如果一层的参数超过一定数量，则应用 FSDP。通过设置
<code>fsdp_wrap_policy: SIZE_BASED_WRAP</code> 和 <code>min_num_param</code> 来启用此功能，将参数设置为所需的大小阈值。`,ue,H,Te,X,Ie=`应该使用 <code>fsdp_state_dict_type: SHARDED_STATE_DICT</code> 来保存中间检查点，
因为在排名 0 上保存完整状态字典需要很长时间，通常会导致 <code>NCCL Timeout</code> 错误，因为在广播过程中会无限期挂起。
您可以使用 \`load_state“ 方法加载分片状态字典以恢复训练。`,je,x,ye,N,Oe="然而，当训练结束时，您希望保存完整状态字典，因为分片状态字典仅与 FSDP 兼容。",ge,E,we,G,Je,v,qe=`<a href="https://pytorch.org/xla/release/2.1/index.html" rel="nofollow">PyTorch XLA</a> 支持用于 TPUs 的 FSDP 训练，
可以通过修改由 <code>accelerate config</code> 生成的 FSDP 配置文件来启用。除了上面指定的分片策略和包装选项外，
您还可以将以下参数添加到文件中。`,Ze,D,Se,Q,Ke=`<a href="https://github.com/pytorch/xla/blob/2e6e183e0724818f137c8135b34ef273dea33318/torch_xla/distributed/fsdp/xla_fully_sharded_data_parallel.py#L128" rel="nofollow"><code>xla_fsdp_settings</code></a>
允许您配置用于 FSDP 的额外 XLA 特定参数。`,Be,k,Ce,W,et="FSDP 配置文件示例如下所示：",Fe,A,Re,L,tt=`要启动训练，请运行 <a href="https://huggingface.co/docs/accelerate/package_reference/cli#accelerate-launch" rel="nofollow"><code>accelerate launch</code></a>
命令，它将自动使用您之前使用 <code>accelerate config</code> 创建的配置文件。`,be,z,Pe,Y,Ve,I,He,O,lt=`FSDP 在大规模模型训练方面是一个强大的工具，您可以使用多个 GPU 或 TPU。
通过分片模型参数、优化器和梯度状态，甚至在它们不活动时将其卸载到 CPU 上，
FSDP 可以减少大规模训练的高成本。如果您希望了解更多信息，下面的内容可能会有所帮助：`,Xe,q,st=`<li>深入参考 Accelerate 指南，了解有关
<a href="https://huggingface.co/docs/accelerate/usage_guides/fsdp" rel="nofollow">FSDP</a>的更多信息。</li> <li>阅读<a href="https://pytorch.org/blog/introducing-pytorch-fully-sharded-data-parallel-api/" rel="nofollow">介绍 PyTorch 完全分片数据并行（FSDP）API</a> 博文。</li> <li>阅读<a href="https://pytorch.org/blog/scaling-pytorch-models-on-cloud-tpus-with-fsdp/" rel="nofollow">使用 FSDP 在云 TPU 上扩展 PyTorch 模型</a>博文。</li>`,xe,ee,Ne;return M=new U({props:{title:"完全分片数据并行",local:"完全分片数据并行",headingTag:"h1"}}),j=new $({props:{code:"cGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGU=",highlighted:"pip install accelerate",wrap:!1}}),y=new U({props:{title:"FSDP 配置",local:"fsdp-配置",headingTag:"h2"}}),w=new $({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),Z=new U({props:{title:"分片策略",local:"分片策略",headingTag:"h3"}}),F=new U({props:{title:"CPU 卸载",local:"cpu-卸载",headingTag:"h3"}}),b=new U({props:{title:"包装策略",local:"包装策略",headingTag:"h3"}}),H=new U({props:{title:"检查点",local:"检查点",headingTag:"h3"}}),x=new $({props:{code:"JTIzJTIwJUU1JThDJTg1JUU1JTkwJUFCJUU2JUEzJTgwJUU2JTlGJUE1JUU3JTgyJUI5JUU3JTlBJTg0JUU3JTlCJUFFJUU1JUJEJTk1JTBBYWNjZWxlcmF0b3IubG9hZF9zdGF0ZSglMjJja3B0JTIyKQ==",highlighted:`<span class="hljs-comment"># 包含检查点的目录</span>
accelerator.load_state(<span class="hljs-string">&quot;ckpt&quot;</span>)`,wrap:!1}}),E=new $({props:{code:"aWYlMjB0cmFpbmVyLmlzX2ZzZHBfZW5hYmxlZCUzQSUwQSUyMCUyMCUyMCUyMHRyYWluZXIuYWNjZWxlcmF0b3Iuc3RhdGUuZnNkcF9wbHVnaW4uc2V0X3N0YXRlX2RpY3RfdHlwZSglMjJGVUxMX1NUQVRFX0RJQ1QlMjIpJTBBJTBBdHJhaW5lci5zYXZlX21vZGVsKHNjcmlwdF9hcmdzLm91dHB1dF9kaXIp",highlighted:`<span class="hljs-keyword">if</span> trainer.is_fsdp_enabled:
    trainer.accelerator.state.fsdp_plugin.set_state_dict_type(<span class="hljs-string">&quot;FULL_STATE_DICT&quot;</span>)

trainer.save_model(script_args.output_dir)`,wrap:!1}}),G=new U({props:{title:"TPU",local:"tpu",headingTag:"h3"}}),D=new $({props:{code:"eGxhJTNBJTIwVHJ1ZSUyMCUyMyUyMCVFNSVCRiU4NSVFOSVBMSVCQiVFOCVBRSVCRSVFNyVCRCVBRSVFNCVCOCVCQSUyMFRydWUlMjAlRTQlQkIlQTUlRTUlOTAlQUYlRTclOTQlQTglMjBQeVRvcmNoJTJGWExBJTBBeGxhX2ZzZHBfc2V0dGluZ3MlM0ElMjAlMjMlMjBYTEElMjAlRTclODklQjklRTUlQUUlOUElRTclOUElODQlMjBGU0RQJTIwJUU1JThGJTgyJUU2JTk1JUIwJTBBeGxhX2ZzZHBfZ3JhZF9ja3B0JTNBJTIwVHJ1ZSUyMCUyMyUyMCVFNCVCRCVCRiVFNyU5NCVBOCVFNiVBMiVBRiVFNSVCQSVBNiVFNiVBMyU4MCVFNiU5RiVBNSVFNyU4MiVCOQ==",highlighted:`<span class="hljs-attr">xla:</span> <span class="hljs-literal">True</span> <span class="hljs-comment"># 必须设置为 True 以启用 PyTorch/XLA</span>
<span class="hljs-attr">xla_fsdp_settings:</span> <span class="hljs-comment"># XLA 特定的 FSDP 参数</span>
<span class="hljs-attr">xla_fsdp_grad_ckpt:</span> <span class="hljs-literal">True</span> <span class="hljs-comment"># 使用梯度检查点</span>`,wrap:!1}}),k=new U({props:{title:"启动训练",local:"启动训练",headingTag:"h2"}}),A=new $({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWJ1ZyUzQSUyMGZhbHNlJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMEZTRFAlMEFkb3duY2FzdF9iZjE2JTNBJTIwJTIybm8lMjIlMEFmc2RwX2NvbmZpZyUzQSUwQSUyMCUyMGZzZHBfYXV0b193cmFwX3BvbGljeSUzQSUyMFRSQU5TRk9STUVSX0JBU0VEX1dSQVAlMEElMjAlMjBmc2RwX2JhY2t3YXJkX3ByZWZldGNoX3BvbGljeSUzQSUyMEJBQ0tXQVJEX1BSRSUwQSUyMCUyMGZzZHBfY3B1X3JhbV9lZmZpY2llbnRfbG9hZGluZyUzQSUyMHRydWUlMEElMjAlMjBmc2RwX2ZvcndhcmRfcHJlZmV0Y2glM0ElMjBmYWxzZSUwQSUyMCUyMGZzZHBfb2ZmbG9hZF9wYXJhbXMlM0ElMjB0cnVlJTBBJTIwJTIwZnNkcF9zaGFyZGluZ19zdHJhdGVneSUzQSUyMDElMEElMjAlMjBmc2RwX3N0YXRlX2RpY3RfdHlwZSUzQSUyMFNIQVJERURfU1RBVEVfRElDVCUwQSUyMCUyMGZzZHBfc3luY19tb2R1bGVfc3RhdGVzJTNBJTIwdHJ1ZSUwQSUyMCUyMGZzZHBfdHJhbnNmb3JtZXJfbGF5ZXJfY2xzX3RvX3dyYXAlM0ElMjBCZXJ0TGF5ZXIlMEElMjAlMjBmc2RwX3VzZV9vcmlnX3BhcmFtcyUzQSUyMHRydWUlMEFtYWNoaW5lX3JhbmslM0ElMjAwJTBBbWFpbl90cmFpbmluZ19mdW5jdGlvbiUzQSUyMG1haW4lMEFtaXhlZF9wcmVjaXNpb24lM0ElMjBiZjE2JTBBbnVtX21hY2hpbmVzJTNBJTIwMSUwQW51bV9wcm9jZXNzZXMlM0ElMjAyJTBBcmR6dl9iYWNrZW5kJTNBJTIwc3RhdGljJTBBc2FtZV9uZXR3b3JrJTNBJTIwdHJ1ZSUwQXRwdV9lbnYlM0ElMjAlNUIlNUQlMEF0cHVfdXNlX2NsdXN0ZXIlM0ElMjBmYWxzZSUwQXRwdV91c2Vfc3VkbyUzQSUyMGZhbHNlJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">debug:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">FSDP</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&quot;no&quot;</span>
<span class="hljs-attr">fsdp_config:</span>
  <span class="hljs-attr">fsdp_auto_wrap_policy:</span> <span class="hljs-string">TRANSFORMER_BASED_WRAP</span>
  <span class="hljs-attr">fsdp_backward_prefetch_policy:</span> <span class="hljs-string">BACKWARD_PRE</span>
  <span class="hljs-attr">fsdp_cpu_ram_efficient_loading:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_forward_prefetch:</span> <span class="hljs-literal">false</span>
  <span class="hljs-attr">fsdp_offload_params:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_sharding_strategy:</span> <span class="hljs-number">1</span>
  <span class="hljs-attr">fsdp_state_dict_type:</span> <span class="hljs-string">SHARDED_STATE_DICT</span>
  <span class="hljs-attr">fsdp_sync_module_states:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_transformer_layer_cls_to_wrap:</span> <span class="hljs-string">BertLayer</span>
  <span class="hljs-attr">fsdp_use_orig_params:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">bf16</span>
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">2</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">tpu_env:</span> []
<span class="hljs-attr">tpu_use_cluster:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">tpu_use_sudo:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),z=new $({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMG15LXRyYWluZXItc2NyaXB0LnB5",highlighted:"accelerate launch my-trainer-script.py",wrap:!1}}),Y=new $({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tZnNkcCUzRCUyMmZ1bGwlMjBzaGFyZCUyMiUyMC0tZnNkcF9jb25maWclM0QlMjJwYXRoJTJGdG8lMkZmc2RwX2NvbmZpZyUyRiUyMG15LXRyYWluZXItc2NyaXB0LnB5",highlighted:'accelerate launch --fsdp=<span class="hljs-string">&quot;full shard&quot;</span> --fsdp_config=<span class="hljs-string">&quot;path/to/fsdp_config/ my-trainer-script.py</span>',wrap:!1}}),I=new U({props:{title:"下一步",local:"下一步",headingTag:"h2"}}),{c(){_=p("meta"),te=a(),K=p("p"),le=a(),i(M.$$.fragment),se=a(),u=p("p"),u.innerHTML=Ge,ae=a(),T=p("p"),T.textContent=ve,ne=a(),i(j.$$.fragment),pe=a(),i(y.$$.fragment),re=a(),g=p("p"),g.innerHTML=De,ce=a(),i(w.$$.fragment),ie=a(),J=p("p"),J.innerHTML=Qe,fe=a(),i(Z.$$.fragment),me=a(),S=p("p"),S.textContent=ke,de=a(),B=p("ul"),B.innerHTML=We,oe=a(),C=p("p"),C.innerHTML=Ae,he=a(),i(F.$$.fragment),_e=a(),R=p("p"),R.innerHTML=Le,Ue=a(),i(b.$$.fragment),$e=a(),P=p("p"),P.innerHTML=ze,Me=a(),V=p("p"),V.innerHTML=Ye,ue=a(),i(H.$$.fragment),Te=a(),X=p("p"),X.innerHTML=Ie,je=a(),i(x.$$.fragment),ye=a(),N=p("p"),N.textContent=Oe,ge=a(),i(E.$$.fragment),we=a(),i(G.$$.fragment),Je=a(),v=p("p"),v.innerHTML=qe,Ze=a(),i(D.$$.fragment),Se=a(),Q=p("p"),Q.innerHTML=Ke,Be=a(),i(k.$$.fragment),Ce=a(),W=p("p"),W.textContent=et,Fe=a(),i(A.$$.fragment),Re=a(),L=p("p"),L.innerHTML=tt,be=a(),i(z.$$.fragment),Pe=a(),i(Y.$$.fragment),Ve=a(),i(I.$$.fragment),He=a(),O=p("p"),O.textContent=lt,Xe=a(),q=p("ul"),q.innerHTML=st,xe=a(),ee=p("p"),this.h()},l(e){const t=mt("svelte-u9bgzb",document.head);_=r(t,"META",{name:!0,content:!0}),t.forEach(l),te=n(e),K=r(e,"P",{}),at(K).forEach(l),le=n(e),f(M.$$.fragment,e),se=n(e),u=r(e,"P",{"data-svelte-h":!0}),c(u)!=="svelte-130rbfi"&&(u.innerHTML=Ge),ae=n(e),T=r(e,"P",{"data-svelte-h":!0}),c(T)!=="svelte-1n4z3n9"&&(T.textContent=ve),ne=n(e),f(j.$$.fragment,e),pe=n(e),f(y.$$.fragment,e),re=n(e),g=r(e,"P",{"data-svelte-h":!0}),c(g)!=="svelte-1o6qixw"&&(g.innerHTML=De),ce=n(e),f(w.$$.fragment,e),ie=n(e),J=r(e,"P",{"data-svelte-h":!0}),c(J)!=="svelte-2mox0k"&&(J.innerHTML=Qe),fe=n(e),f(Z.$$.fragment,e),me=n(e),S=r(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-18ncnte"&&(S.textContent=ke),de=n(e),B=r(e,"UL",{"data-svelte-h":!0}),c(B)!=="svelte-7jg32h"&&(B.innerHTML=We),oe=n(e),C=r(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-isacvu"&&(C.innerHTML=Ae),he=n(e),f(F.$$.fragment,e),_e=n(e),R=r(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-13eqbk2"&&(R.innerHTML=Le),Ue=n(e),f(b.$$.fragment,e),$e=n(e),P=r(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-1xtp75a"&&(P.innerHTML=ze),Me=n(e),V=r(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-wtqcp1"&&(V.innerHTML=Ye),ue=n(e),f(H.$$.fragment,e),Te=n(e),X=r(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-tanzhp"&&(X.innerHTML=Ie),je=n(e),f(x.$$.fragment,e),ye=n(e),N=r(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-1e8kodj"&&(N.textContent=Oe),ge=n(e),f(E.$$.fragment,e),we=n(e),f(G.$$.fragment,e),Je=n(e),v=r(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-l882fb"&&(v.innerHTML=qe),Ze=n(e),f(D.$$.fragment,e),Se=n(e),Q=r(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-1fe7485"&&(Q.innerHTML=Ke),Be=n(e),f(k.$$.fragment,e),Ce=n(e),W=r(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-12574pf"&&(W.textContent=et),Fe=n(e),f(A.$$.fragment,e),Re=n(e),L=r(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1244lfp"&&(L.innerHTML=tt),be=n(e),f(z.$$.fragment,e),Pe=n(e),f(Y.$$.fragment,e),Ve=n(e),f(I.$$.fragment,e),He=n(e),O=r(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-qjrava"&&(O.textContent=lt),Xe=n(e),q=r(e,"UL",{"data-svelte-h":!0}),c(q)!=="svelte-w3rkgj"&&(q.innerHTML=st),xe=n(e),ee=r(e,"P",{}),at(ee).forEach(l),this.h()},h(){nt(_,"name","hf:doc:metadata"),nt(_,"content",ht)},m(e,t){dt(document.head,_),s(e,te,t),s(e,K,t),s(e,le,t),m(M,e,t),s(e,se,t),s(e,u,t),s(e,ae,t),s(e,T,t),s(e,ne,t),m(j,e,t),s(e,pe,t),m(y,e,t),s(e,re,t),s(e,g,t),s(e,ce,t),m(w,e,t),s(e,ie,t),s(e,J,t),s(e,fe,t),m(Z,e,t),s(e,me,t),s(e,S,t),s(e,de,t),s(e,B,t),s(e,oe,t),s(e,C,t),s(e,he,t),m(F,e,t),s(e,_e,t),s(e,R,t),s(e,Ue,t),m(b,e,t),s(e,$e,t),s(e,P,t),s(e,Me,t),s(e,V,t),s(e,ue,t),m(H,e,t),s(e,Te,t),s(e,X,t),s(e,je,t),m(x,e,t),s(e,ye,t),s(e,N,t),s(e,ge,t),m(E,e,t),s(e,we,t),m(G,e,t),s(e,Je,t),s(e,v,t),s(e,Ze,t),m(D,e,t),s(e,Se,t),s(e,Q,t),s(e,Be,t),m(k,e,t),s(e,Ce,t),s(e,W,t),s(e,Fe,t),m(A,e,t),s(e,Re,t),s(e,L,t),s(e,be,t),m(z,e,t),s(e,Pe,t),m(Y,e,t),s(e,Ve,t),m(I,e,t),s(e,He,t),s(e,O,t),s(e,Xe,t),s(e,q,t),s(e,xe,t),s(e,ee,t),Ne=!0},p:rt,i(e){Ne||(d(M.$$.fragment,e),d(j.$$.fragment,e),d(y.$$.fragment,e),d(w.$$.fragment,e),d(Z.$$.fragment,e),d(F.$$.fragment,e),d(b.$$.fragment,e),d(H.$$.fragment,e),d(x.$$.fragment,e),d(E.$$.fragment,e),d(G.$$.fragment,e),d(D.$$.fragment,e),d(k.$$.fragment,e),d(A.$$.fragment,e),d(z.$$.fragment,e),d(Y.$$.fragment,e),d(I.$$.fragment,e),Ne=!0)},o(e){o(M.$$.fragment,e),o(j.$$.fragment,e),o(y.$$.fragment,e),o(w.$$.fragment,e),o(Z.$$.fragment,e),o(F.$$.fragment,e),o(b.$$.fragment,e),o(H.$$.fragment,e),o(x.$$.fragment,e),o(E.$$.fragment,e),o(G.$$.fragment,e),o(D.$$.fragment,e),o(k.$$.fragment,e),o(A.$$.fragment,e),o(z.$$.fragment,e),o(Y.$$.fragment,e),o(I.$$.fragment,e),Ne=!1},d(e){e&&(l(te),l(K),l(le),l(se),l(u),l(ae),l(T),l(ne),l(pe),l(re),l(g),l(ce),l(ie),l(J),l(fe),l(me),l(S),l(de),l(B),l(oe),l(C),l(he),l(_e),l(R),l(Ue),l($e),l(P),l(Me),l(V),l(ue),l(Te),l(X),l(je),l(ye),l(N),l(ge),l(we),l(Je),l(v),l(Ze),l(Se),l(Q),l(Be),l(Ce),l(W),l(Fe),l(Re),l(L),l(be),l(Pe),l(Ve),l(He),l(O),l(Xe),l(q),l(xe),l(ee)),l(_),h(M,e),h(j,e),h(y,e),h(w,e),h(Z,e),h(F,e),h(b,e),h(H,e),h(x,e),h(E,e),h(G,e),h(D,e),h(k,e),h(A,e),h(z,e),h(Y,e),h(I,e)}}}const ht='{"title":"完全分片数据并行","local":"完全分片数据并行","sections":[{"title":"FSDP 配置","local":"fsdp-配置","sections":[{"title":"分片策略","local":"分片策略","sections":[],"depth":3},{"title":"CPU 卸载","local":"cpu-卸载","sections":[],"depth":3},{"title":"包装策略","local":"包装策略","sections":[],"depth":3},{"title":"检查点","local":"检查点","sections":[],"depth":3},{"title":"TPU","local":"tpu","sections":[],"depth":3}],"depth":2},{"title":"启动训练","local":"启动训练","sections":[],"depth":2},{"title":"下一步","local":"下一步","sections":[],"depth":2}],"depth":1}';function _t(Ee){return ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tt extends it{constructor(_){super(),ft(this,_,_t,ot,pt,{})}}export{Tt as component};
