import{s as is,o as ls,n as $n}from"../chunks/scheduler.6062bdaf.js";import{S as cs,i as gs,g as r,s as o,r as d,A as ds,h as a,f as s,c as n,j as b,u as p,x as c,k as v,y as t,a as _,v as h,d as u,t as m,w as f}from"../chunks/index.4bca734e.js";import{T as oa}from"../chunks/Tip.b9ac1f03.js";import{D as $}from"../chunks/Docstring.ed07512f.js";import{C as ps}from"../chunks/CodeBlock.fa01571c.js";import{E as hs}from"../chunks/ExampleCodeBlock.823fb173.js";import{H as yn}from"../chunks/Heading.723dceba.js";function us(H){let y,T=`<a href="/docs/huggingface_hub/v0.21.0/en/package_reference/repository#huggingface_hub.Repository">Repository</a> is deprecated in favor of the http-based alternatives implemented in
<a href="/docs/huggingface_hub/v0.21.0/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>. Given its large adoption in legacy code, the complete removal of
<a href="/docs/huggingface_hub/v0.21.0/en/package_reference/repository#huggingface_hub.Repository">Repository</a> will only happen in release <code>v1.0</code>. For more details, please read
<a href="https://huggingface.co/docs/huggingface_hub/concepts/git_vs_http" rel="nofollow">https://huggingface.co/docs/huggingface_hub/concepts/git_vs_http</a>.`;return{c(){y=r("p"),y.innerHTML=T},l(w){y=a(w,"P",{"data-svelte-h":!0}),c(y)!=="svelte-1gl7ih8"&&(y.innerHTML=T)},m(w,C){_(w,y,C)},p:$n,d(w){w&&s(y)}}}function ms(H){let y,T="Raises the following error:",w,C,R=`<li><p><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if an organization token (starts with “api_org”) is passed. Use must use
your own personal access token (see <a href="https://hf.co/settings/tokens" rel="nofollow">https://hf.co/settings/tokens</a>).</p></li> <li><p><a href="https://docs.python.org/3/library/exceptions.html#EnvironmentError" rel="nofollow"><code>EnvironmentError</code></a>
if you are trying to clone the repository in a non-empty folder, or if the
<code>git</code> operations raise errors.</p></li>`;return{c(){y=r("p"),y.textContent=T,w=o(),C=r("ul"),C.innerHTML=R},l(x){y=a(x,"P",{"data-svelte-h":!0}),c(y)!=="svelte-1f6kjc7"&&(y.textContent=T),w=n(x),C=a(x,"UL",{"data-svelte-h":!0}),c(C)!=="svelte-dnmxmk"&&(C.innerHTML=R)},m(x,I){_(x,y,I),_(x,w,I),_(x,C,I)},p:$n,d(x){x&&(s(y),s(w),s(C))}}}function fs(H){let y,T="Examples:",w,C,R;return C=new ps({props:{code:"d2l0aCUyMFJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIydGV4dC1maWxlcyUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsb25lX2Zyb20lM0QlMjIlM0N1c2VyJTNFJTJGdGV4dC1maWxlcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEVHJ1ZSUyQyUwQSkuY29tbWl0KCUyMk15JTIwZmlyc3QlMjBmaWxlJTIwJTNBKSUyMiklM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwb3BlbiglMjJmaWxlLnR4dCUyMiUyQyUyMCUyMnclMkIlMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShqc29uLmR1bXBzKCU3QiUyMmhleSUyMiUzQSUyMDglN0QpKSUwQSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjB0b3JjaC5ubi5UcmFuc2Zvcm1lcigpJTBBd2l0aCUyMFJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIydG9yY2gtbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBjbG9uZV9mcm9tJTNEJTIyJTNDdXNlciUzRSUyRnRvcmNoLW1vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW4lM0RUcnVlJTJDJTBBKS5jb21taXQoJTIyTXklMjBjb29sJTIwbW9kZWwlMjAlM0EpJTIyKSUzQSUwQSUyMCUyMCUyMCUyMHRvcmNoLnNhdmUobW9kZWwuc3RhdGVfZGljdCgpJTJDJTIwJTIybW9kZWwucHQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> Repository(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;text-files&quot;</span>,
<span class="hljs-meta">... </span>    clone_from=<span class="hljs-string">&quot;&lt;user&gt;/text-files&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">&gt;&gt;&gt; </span>).commit(<span class="hljs-string">&quot;My first file :)&quot;</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;file.txt&quot;</span>, <span class="hljs-string">&quot;w+&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        f.write(json.dumps({<span class="hljs-string">&quot;hey&quot;</span>: <span class="hljs-number">8</span>}))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = torch.nn.Transformer()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> Repository(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;torch-model&quot;</span>,
<span class="hljs-meta">... </span>    clone_from=<span class="hljs-string">&quot;&lt;user&gt;/torch-model&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">&gt;&gt;&gt; </span>).commit(<span class="hljs-string">&quot;My cool model :)&quot;</span>):
<span class="hljs-meta">... </span>    torch.save(model.state_dict(), <span class="hljs-string">&quot;model.pt&quot;</span>)`,wrap:!1}}),{c(){y=r("p"),y.textContent=T,w=o(),d(C.$$.fragment)},l(x){y=a(x,"P",{"data-svelte-h":!0}),c(y)!=="svelte-kvfsh7"&&(y.textContent=T),w=n(x),p(C.$$.fragment,x)},m(x,I){_(x,y,I),_(x,w,I),h(C,x,I),R=!0},p:$n,i(x){R||(u(C.$$.fragment,x),R=!0)},o(x){m(C.$$.fragment,x),R=!1},d(x){x&&(s(y),s(w)),f(C,x)}}}function _s(H){let y,T=`<a href="/docs/huggingface_hub/v0.21.0/en/package_reference/repository#huggingface_hub.Repository">Repository</a> is deprecated in favor of the http-based alternatives implemented in
<a href="/docs/huggingface_hub/v0.21.0/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>. Given its large adoption in legacy code, the complete removal of
<a href="/docs/huggingface_hub/v0.21.0/en/package_reference/repository#huggingface_hub.Repository">Repository</a> will only happen in release <code>v1.0</code>. For more details, please read
<a href="https://huggingface.co/docs/huggingface_hub/concepts/git_vs_http" rel="nofollow">https://huggingface.co/docs/huggingface_hub/concepts/git_vs_http</a>.`;return{c(){y=r("p"),y.innerHTML=T},l(w){y=a(w,"P",{"data-svelte-h":!0}),c(y)!=="svelte-1gl7ih8"&&(y.innerHTML=T)},m(w,C){_(w,y,C)},p:$n,d(w){w&&s(y)}}}function bs(H){let y,T,w,C,R,x,I,na=`The <code>Repository</code> class is a helper class that wraps <code>git</code> and <code>git-lfs</code> commands. It provides tooling adapted
for managing repositories which can be very large.`,ko,we,ra=`It is the recommended tool as soon as any <code>git</code> operation is involved, or when collaboration will be a point
of focus with the repository itself.`,To,Ce,Ro,i,ke,xn,bt,aa="Helper class to wrap the git and git-lfs commands.",wn,vt,sa=`The aim is to facilitate interacting with huggingface.co hosted model or
dataset repos, though not a lot here (if any) is actually specific to
huggingface.co.`,Cn,Q,kn,M,Te,Tn,yt,ia="Instantiate a local clone of a git repo.",Rn,$t,la=`If <code>clone_from</code> is set, the repo will be cloned from an existing remote repository.
If the remote repo does not exist, a <code>EnvironmentError</code> exception will be thrown.
Please create the remote repo first using <a href="/docs/huggingface_hub/v0.21.0/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`,In,xt,ca=`<code>Repository</code> uses the local git credentials by default. If explicitly set, the <code>token</code>
or the <code>git_user</code>/<code>git_email</code> pair will be used instead.`,Dn,Z,Re,Mn,wt,ga="Returns the current checked out branch.",Ln,L,Ie,Pn,Ct,da="Add a tag at the current head and push it",En,kt,pa="If remote is None, will just be updated locally",jn,Tt,ha=`If no message is provided, the tag will be lightweight. if a message is
provided, the tag will be annotated.`,Un,X,De,Hn,Rt,ua="Automatically track binary files with git-lfs.",Jn,K,Me,Vn,It,ma=`Automatically track large files (files that weigh more than 10MBs) with
git-lfs.`,Fn,Y,Le,Nn,Dt,fa="Checks that <code>git</code> and <code>git-lfs</code> can be run.",qn,P,Pe,Wn,Mt,_a=`Clone from a remote. If the folder already exists, will try to clone the
repository within it.`,Bn,Lt,ba=`If this folder is a git repository with linked history, will try to
update the repository.`,Sn,ee,An,J,Ee,On,Pt,va=`Context manager utility to handle committing to a repository. This
automatically tracks large files (&gt;10Mb) with git-lfs. Set the
<code>track_large_files</code> argument to <code>False</code> if you wish to ignore that
behavior.`,Gn,te,zn,oe,je,Qn,Et,ya="Delete a tag, both local and remote, if it exists",Zn,V,Ue,Xn,jt,$a="git add",Kn,Ut,xa=`Setting the <code>auto_lfs_track</code> parameter to <code>True</code> will automatically
track files that are larger than 10MB with <code>git-lfs</code>.`,Yn,F,He,er,Ht,wa="git checkout a given revision",tr,Jt,Ca=`Specifying <code>create_branch_ok</code> to <code>True</code> will create the branch to the
given revision if that revision doesn’t exist.`,or,ne,Je,nr,Vt,ka="git commit",rr,re,Ve,ar,Ft,Ta="Sets git username and email (only in the current repo).",sr,ae,Fe,ir,Nt,Ra="Sets the git credential helper to <code>store</code>",lr,se,Ne,cr,qt,Ia=`Get URL to last commit on HEAD. We assume it’s been pushed, and the url
scheme is the same one as for GitHub or HuggingFace.`,gr,ie,qe,dr,Wt,Da="Get commit sha on top of HEAD.",pr,le,We,hr,Bt,Ma="git pull",ur,N,Be,mr,St,La="git push",fr,At,Pa=`If used without setting <code>blocking</code>, will return url to commit on remote
repo. If used with <code>blocking=True</code>, will return a tuple containing the
url to commit and the command object to follow for information about the
process.`,_r,ce,Se,br,Ot,Ea="Get URL to origin remote.",vr,ge,Ae,yr,Gt,ja="Return whether or not the git status is clean or not",$r,de,Oe,xr,zt,Ua="HF-specific. This enables upload support of files >5GB.",wr,pe,Ge,Cr,Qt,Ha="git lfs prune",kr,q,ze,Tr,Zt,Ja="Tell git-lfs to track files according to a pattern.",Rr,Xt,Va=`Setting the <code>filename</code> argument to <code>True</code> will treat the arguments as
literal filenames, not as patterns. Any special glob characters in the
filename will be escaped when writing to the <code>.gitattributes</code> file.`,Ir,he,Qe,Dr,Kt,Fa="Tell git-lfs to untrack those files.",Mr,ue,Ze,Lr,Yt,Na=`Returns a list of the files that are deleted in the working directory or
index.`,Pr,me,Xe,Er,eo,qa=`Helper to add, commit, and push files to remote repository on the
HuggingFace Hub. Will automatically track large files (>10MB).`,jr,fe,Ke,Ur,to,Wa="Check if a tag exists or not.",Hr,_e,Ye,Jr,oo,Ba=`Blocking method: blocks all subsequent execution until all commands have
been processed.`,Io,et,Do,W,tt,Vr,no,Sa="Check if the folder is the root or part of a git repository",Mo,B,ot,Fr,ro,Aa="Check if the folder is a local clone of the remote_url",Lo,S,nt,Nr,ao,Oa="Check if the file passed is tracked with git-lfs.",Po,A,rt,qr,so,Ga="Check if file is git-ignored. Supports nested .gitignore files.",Eo,O,at,Wr,io,za="Returns a list of filenames that are to be staged.",jo,G,st,Br,lo,Qa="Check if the current checked-out branch is tracked upstream.",Uo,E,it,Sr,co,Za="Check the number of commits that would be pushed upstream",Ar,go,Xa=`The name of the upstream repository with which the comparison should be
made.`,Ho,lt,Jo,ct,Ka="The <code>Repository</code> utility offers several methods which can be launched asynchronously:",Vo,gt,Ya="<li><code>git_push</code></li> <li><code>git_pull</code></li> <li><code>push_to_hub</code></li> <li>The <code>commit</code> context manager</li>",Fo,dt,es="See below for utilities to manage such asynchronous methods.",No,k,pt,Or,po,ts="Helper class to wrap the git and git-lfs commands.",Gr,ho,os=`The aim is to facilitate interacting with huggingface.co hosted model or
dataset repos, though not a lot here (if any) is actually specific to
huggingface.co.`,zr,be,Qr,ve,ht,Zr,uo,ns="Returns the asynchronous commands that failed.",Xr,ye,ut,Kr,mo,rs="Returns the asynchronous commands that are currently in progress.",Yr,$e,mt,ea,fo,as=`Blocking method: blocks all subsequent execution until all commands have
been processed.`,qo,z,ft,ta,_o,ss="Utility to follow commands launched asynchronously.",Wo,Co,Bo;return R=new yn({props:{title:"Managing local and online repositories",local:"managing-local-and-online-repositories",headingTag:"h1"}}),Ce=new yn({props:{title:"The Repository class",local:"huggingface_hub.Repository",headingTag:"h2"}}),ke=new $({props:{name:"class huggingface_hub.Repository",anchor:"huggingface_hub.Repository",parameters:[{name:"local_dir",val:": Union"},{name:"clone_from",val:": Optional = None"},{name:"repo_type",val:": Optional = None"},{name:"token",val:": Union = True"},{name:"git_user",val:": Optional = None"},{name:"git_email",val:": Optional = None"},{name:"revision",val:": Optional = None"},{name:"skip_lfs_files",val:": bool = False"},{name:"client",val:": Optional = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L425"}}),Q=new oa({props:{warning:!0,$$slots:{default:[us]},$$scope:{ctx:H}}}),Te=new $({props:{name:"__init__",anchor:"huggingface_hub.Repository.__init__",parameters:[{name:"local_dir",val:": Union"},{name:"clone_from",val:": Optional = None"},{name:"repo_type",val:": Optional = None"},{name:"token",val:": Union = True"},{name:"git_user",val:": Optional = None"},{name:"git_email",val:": Optional = None"},{name:"revision",val:": Optional = None"},{name:"skip_lfs_files",val:": bool = False"},{name:"client",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.__init__.local_dir",description:`<strong>local_dir</strong> (<code>str</code> or <code>Path</code>) &#x2014;
path (e.g. <code>&apos;my_trained_model/&apos;</code>) to the local directory, where
the <code>Repository</code> will be initialized.`,name:"local_dir"},{anchor:"huggingface_hub.Repository.__init__.clone_from",description:`<strong>clone_from</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Either a repository url or <code>repo_id</code>.
Example:<ul>
<li><code>&quot;https://huggingface.co/philschmid/playground-tests&quot;</code></li>
<li><code>&quot;philschmid/playground-tests&quot;</code></li>
</ul>`,name:"clone_from"},{anchor:"huggingface_hub.Repository.__init__.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
To set when cloning a repo from a repo_id. Default is model.`,name:"repo_type"},{anchor:"huggingface_hub.Repository.__init__.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
A valid authentication token (see <a href="https://huggingface.co/settings/token" rel="nofollow">https://huggingface.co/settings/token</a>).
If <code>None</code> or <code>True</code> and machine is logged in (through <code>huggingface-cli login</code>
or <a href="/docs/huggingface_hub/v0.21.0/en/package_reference/login#huggingface_hub.login">login()</a>), token will be retrieved from the cache.
If <code>False</code>, token is not sent in the request header.`,name:"token"},{anchor:"huggingface_hub.Repository.__init__.git_user",description:`<strong>git_user</strong> (<code>str</code>, <em>optional</em>) &#x2014;
will override the <code>git config user.name</code> for committing and
pushing files to the hub.`,name:"git_user"},{anchor:"huggingface_hub.Repository.__init__.git_email",description:`<strong>git_email</strong> (<code>str</code>, <em>optional</em>) &#x2014;
will override the <code>git config user.email</code> for committing and
pushing files to the hub.`,name:"git_email"},{anchor:"huggingface_hub.Repository.__init__.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision to checkout after initializing the repository. If the
revision doesn&#x2019;t exist, a branch will be created with that
revision name from the default branch&#x2019;s current HEAD.`,name:"revision"},{anchor:"huggingface_hub.Repository.__init__.skip_lfs_files",description:`<strong>skip_lfs_files</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
whether to skip git-LFS files or not.`,name:"skip_lfs_files"},{anchor:"huggingface_hub.Repository.__init__.client",description:`<strong>client</strong> (<code>HfApi</code>, <em>optional</em>) &#x2014;
Instance of <a href="/docs/huggingface_hub/v0.21.0/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> to use when calling the HF Hub API. A new
instance will be created if this is left to <code>None</code>.`,name:"client"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L445",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><ul>
<li>— <a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a>
if the remote repository set in <code>clone_from</code> does not exist.</li>
</ul></li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li></li>
</ul>
`}}),Re=new $({props:{name:"current_branch",anchor:"huggingface_hub.Repository.current_branch",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L562",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Current checked out branch.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Ie=new $({props:{name:"add_tag",anchor:"huggingface_hub.Repository.add_tag",parameters:[{name:"tag_name",val:": str"},{name:"message",val:": Optional = None"},{name:"remote",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.add_tag.tag_name",description:`<strong>tag_name</strong> (<code>str</code>) &#x2014;
The name of the tag to be added.`,name:"tag_name"},{anchor:"huggingface_hub.Repository.add_tag.message",description:`<strong>message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The message that accompanies the tag. The tag will turn into an
annotated tag if a message is passed.`,name:"message"},{anchor:"huggingface_hub.Repository.add_tag.remote",description:`<strong>remote</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The remote on which to add the tag.`,name:"remote"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L1246"}}),De=new $({props:{name:"auto_track_binary_files",anchor:"huggingface_hub.Repository.auto_track_binary_files",parameters:[{name:"pattern",val:": str = '.'"}],parametersDescription:[{anchor:"huggingface_hub.Repository.auto_track_binary_files.pattern",description:`<strong>pattern</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201D;.&#x201C;) &#x2014;
The pattern with which to track files that are binary.`,name:"pattern"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L888",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of filenames that are now tracked due to being
binary files</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),Me=new $({props:{name:"auto_track_large_files",anchor:"huggingface_hub.Repository.auto_track_large_files",parameters:[{name:"pattern",val:": str = '.'"}],parametersDescription:[{anchor:"huggingface_hub.Repository.auto_track_large_files.pattern",description:`<strong>pattern</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201D;.&#x201C;) &#x2014;
The pattern with which to track files that are above 10MBs.`,name:"pattern"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L931",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of filenames that are now tracked due to their
size.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),Le=new $({props:{name:"check_git_versions",anchor:"huggingface_hub.Repository.check_git_versions",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L577",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><ul>
<li>— <a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a>
if <code>git</code> or <code>git-lfs</code> are not installed.</li>
</ul></li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li></li>
</ul>
`}}),Pe=new $({props:{name:"clone_from",anchor:"huggingface_hub.Repository.clone_from",parameters:[{name:"repo_url",val:": str"},{name:"token",val:": Union = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.clone_from.repo_url",description:`<strong>repo_url</strong> (<code>str</code>) &#x2014;
The URL from which to clone the repository`,name:"repo_url"},{anchor:"huggingface_hub.Repository.clone_from.token",description:`<strong>token</strong> (<code>Union[str, bool]</code>, <em>optional</em>) &#x2014;
Whether to use the authentication token. It can be:<ul>
<li>a string which is the token itself</li>
<li><code>False</code>, which would not use the authentication token</li>
<li><code>True</code>, which would fetch the authentication token from the
local folder and use it (you should be logged in for this to
work).</li>
<li><code>None</code>, which would retrieve the value of
<code>self.huggingface_token</code>.</li>
</ul>`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L600"}}),ee=new oa({props:{$$slots:{default:[ms]},$$scope:{ctx:H}}}),Ee=new $({props:{name:"commit",anchor:"huggingface_hub.Repository.commit",parameters:[{name:"commit_message",val:": str"},{name:"branch",val:": Optional = None"},{name:"track_large_files",val:": bool = True"},{name:"blocking",val:": bool = True"},{name:"auto_lfs_prune",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.commit.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
Message to use for the commit.`,name:"commit_message"},{anchor:"huggingface_hub.Repository.commit.branch",description:`<strong>branch</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The branch on which the commit will appear. This branch will be
checked-out before any operation.`,name:"branch"},{anchor:"huggingface_hub.Repository.commit.track_large_files",description:`<strong>track_large_files</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to automatically track large files or not. Will do so by
default.`,name:"track_large_files"},{anchor:"huggingface_hub.Repository.commit.blocking",description:`<strong>blocking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the function should return only when the <code>git push</code> has
finished.`,name:"blocking"},{anchor:"huggingface_hub.Repository.commit.auto_lfs_prune",description:`<strong>auto_lfs_prune</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to automatically prune files once they have been pushed
to the remote.`,name:"auto_lfs_prune"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L1330"}}),te=new hs({props:{anchor:"huggingface_hub.Repository.commit.example",$$slots:{default:[fs]},$$scope:{ctx:H}}}),je=new $({props:{name:"delete_tag",anchor:"huggingface_hub.Repository.delete_tag",parameters:[{name:"tag_name",val:": str"},{name:"remote",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.delete_tag.tag_name",description:`<strong>tag_name</strong> (<code>str</code>) &#x2014;
The tag name to delete.`,name:"tag_name"},{anchor:"huggingface_hub.Repository.delete_tag.remote",description:`<strong>remote</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The remote on which to delete the tag.`,name:"remote"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L1209",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if deleted, <code>False</code> if the tag didn’t exist.
If remote is not passed, will just be updated locally</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),Ue=new $({props:{name:"git_add",anchor:"huggingface_hub.Repository.git_add",parameters:[{name:"pattern",val:": str = '.'"},{name:"auto_lfs_track",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_add.pattern",description:`<strong>pattern</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201D;.&#x201C;) &#x2014;
The pattern with which to add files to staging.`,name:"pattern"},{anchor:"huggingface_hub.Repository.git_add.auto_lfs_track",description:`<strong>auto_lfs_track</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to automatically track large and binary files with
git-lfs. Any file over 10MB in size, or in binary format, will
be automatically tracked.`,name:"auto_lfs_track"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L1006"}}),He=new $({props:{name:"git_checkout",anchor:"huggingface_hub.Repository.git_checkout",parameters:[{name:"revision",val:": str"},{name:"create_branch_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_checkout.revision",description:`<strong>revision</strong> (<code>str</code>) &#x2014;
The revision to checkout.`,name:"revision"},{anchor:"huggingface_hub.Repository.git_checkout.create_branch_ok",description:`<strong>create_branch_ok</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether creating a branch named with the <code>revision</code> passed at
the current checked-out reference if <code>revision</code> isn&#x2019;t an
existing revision is allowed.`,name:"create_branch_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L1147"}}),Je=new $({props:{name:"git_commit",anchor:"huggingface_hub.Repository.git_commit",parameters:[{name:"commit_message",val:": str = 'commit files to HF hub'"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_commit.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;commit files to HF hub&#x201D;) &#x2014;
The message attributed to the commit.`,name:"commit_message"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L1040"}}),Ve=new $({props:{name:"git_config_username_and_email",anchor:"huggingface_hub.Repository.git_config_username_and_email",parameters:[{name:"git_user",val:": Optional = None"},{name:"git_email",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_config_username_and_email.git_user",description:`<strong>git_user</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The username to register through <code>git</code>.`,name:"git_user"},{anchor:"huggingface_hub.Repository.git_config_username_and_email.git_email",description:`<strong>git_email</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The email to register through <code>git</code>.`,name:"git_email"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L728"}}),Fe=new $({props:{name:"git_credential_helper_store",anchor:"huggingface_hub.Repository.git_credential_helper_store",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L747"}}),Ne=new $({props:{name:"git_head_commit_url",anchor:"huggingface_hub.Repository.git_head_commit_url",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L784",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The URL to the current checked-out commit.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),qe=new $({props:{name:"git_head_hash",anchor:"huggingface_hub.Repository.git_head_hash",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L756",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The current checked out commit SHA.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),We=new $({props:{name:"git_pull",anchor:"huggingface_hub.Repository.git_pull",parameters:[{name:"rebase",val:": bool = False"},{name:"lfs",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_pull.rebase",description:`<strong>rebase</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to rebase the current branch on top of the upstream
branch after fetching.`,name:"rebase"},{anchor:"huggingface_hub.Repository.git_pull.lfs",description:`<strong>lfs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to fetch the LFS files too. This option only changes the
behavior when a repository was cloned without fetching the LFS
files; calling <code>repo.git_pull(lfs=True)</code> will then fetch the LFS
file from the remote repository.`,name:"lfs"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L982"}}),Be=new $({props:{name:"git_push",anchor:"huggingface_hub.Repository.git_push",parameters:[{name:"upstream",val:": Optional = None"},{name:"blocking",val:": bool = True"},{name:"auto_lfs_prune",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_push.upstream",description:`<strong>upstream</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Upstream to which this should push. If not specified, will push
to the lastly defined upstream or to the default one (<code>origin main</code>).`,name:"upstream"},{anchor:"huggingface_hub.Repository.git_push.blocking",description:`<strong>blocking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the function should return only when the push has
finished. Setting this to <code>False</code> will return an
<code>CommandInProgress</code> object which has an <code>is_done</code> property. This
property will be set to <code>True</code> when the push is finished.`,name:"blocking"},{anchor:"huggingface_hub.Repository.git_push.auto_lfs_prune",description:`<strong>auto_lfs_prune</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to automatically prune files once they have been pushed
to the remote.`,name:"auto_lfs_prune"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L1057"}}),Se=new $({props:{name:"git_remote_url",anchor:"huggingface_hub.Repository.git_remote_url",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L769",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The URL of the <code>origin</code> remote.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Ae=new $({props:{name:"is_repo_clean",anchor:"huggingface_hub.Repository.is_repo_clean",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L1280",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the git status is clean, <code>False</code> otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),Oe=new $({props:{name:"lfs_enable_largefiles",anchor:"huggingface_hub.Repository.lfs_enable_largefiles",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L874"}}),Ge=new $({props:{name:"lfs_prune",anchor:"huggingface_hub.Repository.lfs_prune",parameters:[{name:"recent",val:" = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.lfs_prune.recent",description:`<strong>recent</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to prune files even if they were referenced by recent
commits. See the following
<a href="https://github.com/git-lfs/git-lfs/blob/f3d43f0428a84fc4f1e5405b76b5a73ec2437e65/docs/man/git-lfs-prune.1.ronn#recent-files" rel="nofollow">link</a>
for more information.`,name:"recent"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L964"}}),ze=new $({props:{name:"lfs_track",anchor:"huggingface_hub.Repository.lfs_track",parameters:[{name:"patterns",val:": Union"},{name:"filename",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.lfs_track.patterns",description:`<strong>patterns</strong> (<code>Union[str, List[str]]</code>) &#x2014;
The pattern, or list of patterns, to track with git-lfs.`,name:"patterns"},{anchor:"huggingface_hub.Repository.lfs_track.filename",description:`<strong>filename</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use the patterns as literal filenames.`,name:"filename"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L833"}}),Qe=new $({props:{name:"lfs_untrack",anchor:"huggingface_hub.Repository.lfs_untrack",parameters:[{name:"patterns",val:": Union"}],parametersDescription:[{anchor:"huggingface_hub.Repository.lfs_untrack.patterns",description:`<strong>patterns</strong> (<code>Union[str, List[str]]</code>) &#x2014;
The pattern, or list of patterns, to untrack with git-lfs.`,name:"patterns"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L858"}}),Ze=new $({props:{name:"list_deleted_files",anchor:"huggingface_hub.Repository.list_deleted_files",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L798",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of files that have been deleted in the working
directory or index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),Xe=new $({props:{name:"push_to_hub",anchor:"huggingface_hub.Repository.push_to_hub",parameters:[{name:"commit_message",val:": str = 'commit files to HF hub'"},{name:"blocking",val:": bool = True"},{name:"clean_ok",val:": bool = True"},{name:"auto_lfs_prune",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
Message to use for the commit.`,name:"commit_message"},{anchor:"huggingface_hub.Repository.push_to_hub.blocking",description:`<strong>blocking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the function should return only when the <code>git push</code> has
finished.`,name:"blocking"},{anchor:"huggingface_hub.Repository.push_to_hub.clean_ok",description:`<strong>clean_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If True, this function will return None if the repo is
untouched. Default behavior is to fail because the git command
fails.`,name:"clean_ok"},{anchor:"huggingface_hub.Repository.push_to_hub.auto_lfs_prune",description:`<strong>auto_lfs_prune</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to automatically prune files once they have been pushed
to the remote.`,name:"auto_lfs_prune"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L1294"}}),Ke=new $({props:{name:"tag_exists",anchor:"huggingface_hub.Repository.tag_exists",parameters:[{name:"tag_name",val:": str"},{name:"remote",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.tag_exists.tag_name",description:`<strong>tag_name</strong> (<code>str</code>) &#x2014;
The name of the tag to check.`,name:"tag_name"},{anchor:"huggingface_hub.Repository.tag_exists.remote",description:`<strong>remote</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Whether to check if the tag exists on a remote. This parameter
should be the identifier of the remote.`,name:"remote"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L1179",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Whether the tag exists.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),Ye=new $({props:{name:"wait_for_commands",anchor:"huggingface_hub.Repository.wait_for_commands",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L1458"}}),et=new yn({props:{title:"Helper methods",local:"huggingface_hub.repository.is_git_repo",headingTag:"h2"}}),tt=new $({props:{name:"huggingface_hub.repository.is_git_repo",anchor:"huggingface_hub.repository.is_git_repo",parameters:[{name:"folder",val:": Union"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_git_repo.folder",description:`<strong>folder</strong> (<code>str</code>) &#x2014;
The folder in which to run the command.`,name:"folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L114",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the repository is part of a repository, <code>False</code>
otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),ot=new $({props:{name:"huggingface_hub.repository.is_local_clone",anchor:"huggingface_hub.repository.is_local_clone",parameters:[{name:"folder",val:": Union"},{name:"remote_url",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_local_clone.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"},{anchor:"huggingface_hub.repository.is_local_clone.remote_url",description:`<strong>remote_url</strong> (<code>str</code>) &#x2014;
The url of a git repository.`,name:"remote_url"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L131",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the repository is a local clone of the remote
repository specified, <code>False</code> otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),nt=new $({props:{name:"huggingface_hub.repository.is_tracked_with_lfs",anchor:"huggingface_hub.repository.is_tracked_with_lfs",parameters:[{name:"filename",val:": Union"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_tracked_with_lfs.filename",description:`<strong>filename</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The filename to check.`,name:"filename"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L156",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the file passed is tracked with git-lfs, <code>False</code>
otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),rt=new $({props:{name:"huggingface_hub.repository.is_git_ignored",anchor:"huggingface_hub.repository.is_git_ignored",parameters:[{name:"filename",val:": Union"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_git_ignored.filename",description:`<strong>filename</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The filename to check.`,name:"filename"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L193",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the file passed is ignored by <code>git</code>, <code>False</code>
otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),at=new $({props:{name:"huggingface_hub.repository.files_to_be_staged",anchor:"huggingface_hub.repository.files_to_be_staged",parameters:[{name:"pattern",val:": str = '.'"},{name:"folder",val:": Union = None"}],parametersDescription:[{anchor:"huggingface_hub.repository.files_to_be_staged.pattern",description:`<strong>pattern</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The pattern of filenames to check. Put <code>.</code> to get all files.`,name:"pattern"},{anchor:"huggingface_hub.repository.files_to_be_staged.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L241",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of files that are to be staged.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),st=new $({props:{name:"huggingface_hub.repository.is_tracked_upstream",anchor:"huggingface_hub.repository.is_tracked_upstream",parameters:[{name:"folder",val:": Union"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_tracked_upstream.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L266",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>True</code> if the current checked-out branch is tracked upstream,
<code>False</code> otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),it=new $({props:{name:"huggingface_hub.repository.commits_to_push",anchor:"huggingface_hub.repository.commits_to_push",parameters:[{name:"folder",val:": Union"},{name:"upstream",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.repository.commits_to_push.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"},{anchor:"huggingface_hub.repository.commits_to_push.upstream",description:"<strong>upstream</strong> (<code>str</code>, <em>optional</em>) &#x2014;",name:"upstream"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L288",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Number of commits that would be pushed upstream were a <code>git push</code> to proceed.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>int</code></p>
`}}),lt=new yn({props:{title:"Following asynchronous commands",local:"huggingface_hub.Repository",headingTag:"h2"}}),pt=new $({props:{name:"class huggingface_hub.Repository",anchor:"huggingface_hub.Repository",parameters:[{name:"local_dir",val:": Union"},{name:"clone_from",val:": Optional = None"},{name:"repo_type",val:": Optional = None"},{name:"token",val:": Union = True"},{name:"git_user",val:": Optional = None"},{name:"git_email",val:": Optional = None"},{name:"revision",val:": Optional = None"},{name:"skip_lfs_files",val:": bool = False"},{name:"client",val:": Optional = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L425"}}),be=new oa({props:{warning:!0,$$slots:{default:[_s]},$$scope:{ctx:H}}}),ht=new $({props:{name:"commands_failed",anchor:"huggingface_hub.Repository.commands_failed",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L1444"}}),ut=new $({props:{name:"commands_in_progress",anchor:"huggingface_hub.Repository.commands_in_progress",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L1451"}}),mt=new $({props:{name:"wait_for_commands",anchor:"huggingface_hub.Repository.wait_for_commands",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L1458"}}),ft=new $({props:{name:"class huggingface_hub.repository.CommandInProgress",anchor:"huggingface_hub.repository.CommandInProgress",parameters:[{name:"title",val:": str"},{name:"is_done_method",val:": Callable"},{name:"status_method",val:": Callable"},{name:"process",val:": Popen"},{name:"post_method",val:": Optional = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.0/src/huggingface_hub/repository.py#L31"}}),{c(){y=r("meta"),T=o(),w=r("p"),C=o(),d(R.$$.fragment),x=o(),I=r("p"),I.innerHTML=na,ko=o(),we=r("p"),we.innerHTML=ra,To=o(),d(Ce.$$.fragment),Ro=o(),i=r("div"),d(ke.$$.fragment),xn=o(),bt=r("p"),bt.textContent=aa,wn=o(),vt=r("p"),vt.textContent=sa,Cn=o(),d(Q.$$.fragment),kn=o(),M=r("div"),d(Te.$$.fragment),Tn=o(),yt=r("p"),yt.textContent=ia,Rn=o(),$t=r("p"),$t.innerHTML=la,In=o(),xt=r("p"),xt.innerHTML=ca,Dn=o(),Z=r("div"),d(Re.$$.fragment),Mn=o(),wt=r("p"),wt.textContent=ga,Ln=o(),L=r("div"),d(Ie.$$.fragment),Pn=o(),Ct=r("p"),Ct.textContent=da,En=o(),kt=r("p"),kt.textContent=pa,jn=o(),Tt=r("p"),Tt.textContent=ha,Un=o(),X=r("div"),d(De.$$.fragment),Hn=o(),Rt=r("p"),Rt.textContent=ua,Jn=o(),K=r("div"),d(Me.$$.fragment),Vn=o(),It=r("p"),It.textContent=ma,Fn=o(),Y=r("div"),d(Le.$$.fragment),Nn=o(),Dt=r("p"),Dt.innerHTML=fa,qn=o(),P=r("div"),d(Pe.$$.fragment),Wn=o(),Mt=r("p"),Mt.textContent=_a,Bn=o(),Lt=r("p"),Lt.textContent=ba,Sn=o(),d(ee.$$.fragment),An=o(),J=r("div"),d(Ee.$$.fragment),On=o(),Pt=r("p"),Pt.innerHTML=va,Gn=o(),d(te.$$.fragment),zn=o(),oe=r("div"),d(je.$$.fragment),Qn=o(),Et=r("p"),Et.textContent=ya,Zn=o(),V=r("div"),d(Ue.$$.fragment),Xn=o(),jt=r("p"),jt.textContent=$a,Kn=o(),Ut=r("p"),Ut.innerHTML=xa,Yn=o(),F=r("div"),d(He.$$.fragment),er=o(),Ht=r("p"),Ht.textContent=wa,tr=o(),Jt=r("p"),Jt.innerHTML=Ca,or=o(),ne=r("div"),d(Je.$$.fragment),nr=o(),Vt=r("p"),Vt.textContent=ka,rr=o(),re=r("div"),d(Ve.$$.fragment),ar=o(),Ft=r("p"),Ft.textContent=Ta,sr=o(),ae=r("div"),d(Fe.$$.fragment),ir=o(),Nt=r("p"),Nt.innerHTML=Ra,lr=o(),se=r("div"),d(Ne.$$.fragment),cr=o(),qt=r("p"),qt.textContent=Ia,gr=o(),ie=r("div"),d(qe.$$.fragment),dr=o(),Wt=r("p"),Wt.textContent=Da,pr=o(),le=r("div"),d(We.$$.fragment),hr=o(),Bt=r("p"),Bt.textContent=Ma,ur=o(),N=r("div"),d(Be.$$.fragment),mr=o(),St=r("p"),St.textContent=La,fr=o(),At=r("p"),At.innerHTML=Pa,_r=o(),ce=r("div"),d(Se.$$.fragment),br=o(),Ot=r("p"),Ot.textContent=Ea,vr=o(),ge=r("div"),d(Ae.$$.fragment),yr=o(),Gt=r("p"),Gt.textContent=ja,$r=o(),de=r("div"),d(Oe.$$.fragment),xr=o(),zt=r("p"),zt.textContent=Ua,wr=o(),pe=r("div"),d(Ge.$$.fragment),Cr=o(),Qt=r("p"),Qt.textContent=Ha,kr=o(),q=r("div"),d(ze.$$.fragment),Tr=o(),Zt=r("p"),Zt.textContent=Ja,Rr=o(),Xt=r("p"),Xt.innerHTML=Va,Ir=o(),he=r("div"),d(Qe.$$.fragment),Dr=o(),Kt=r("p"),Kt.textContent=Fa,Mr=o(),ue=r("div"),d(Ze.$$.fragment),Lr=o(),Yt=r("p"),Yt.textContent=Na,Pr=o(),me=r("div"),d(Xe.$$.fragment),Er=o(),eo=r("p"),eo.textContent=qa,jr=o(),fe=r("div"),d(Ke.$$.fragment),Ur=o(),to=r("p"),to.textContent=Wa,Hr=o(),_e=r("div"),d(Ye.$$.fragment),Jr=o(),oo=r("p"),oo.textContent=Ba,Io=o(),d(et.$$.fragment),Do=o(),W=r("div"),d(tt.$$.fragment),Vr=o(),no=r("p"),no.textContent=Sa,Mo=o(),B=r("div"),d(ot.$$.fragment),Fr=o(),ro=r("p"),ro.textContent=Aa,Lo=o(),S=r("div"),d(nt.$$.fragment),Nr=o(),ao=r("p"),ao.textContent=Oa,Po=o(),A=r("div"),d(rt.$$.fragment),qr=o(),so=r("p"),so.textContent=Ga,Eo=o(),O=r("div"),d(at.$$.fragment),Wr=o(),io=r("p"),io.textContent=za,jo=o(),G=r("div"),d(st.$$.fragment),Br=o(),lo=r("p"),lo.textContent=Qa,Uo=o(),E=r("div"),d(it.$$.fragment),Sr=o(),co=r("p"),co.textContent=Za,Ar=o(),go=r("p"),go.textContent=Xa,Ho=o(),d(lt.$$.fragment),Jo=o(),ct=r("p"),ct.innerHTML=Ka,Vo=o(),gt=r("ul"),gt.innerHTML=Ya,Fo=o(),dt=r("p"),dt.textContent=es,No=o(),k=r("div"),d(pt.$$.fragment),Or=o(),po=r("p"),po.textContent=ts,Gr=o(),ho=r("p"),ho.textContent=os,zr=o(),d(be.$$.fragment),Qr=o(),ve=r("div"),d(ht.$$.fragment),Zr=o(),uo=r("p"),uo.textContent=ns,Xr=o(),ye=r("div"),d(ut.$$.fragment),Kr=o(),mo=r("p"),mo.textContent=rs,Yr=o(),$e=r("div"),d(mt.$$.fragment),ea=o(),fo=r("p"),fo.textContent=as,qo=o(),z=r("div"),d(ft.$$.fragment),ta=o(),_o=r("p"),_o.textContent=ss,Wo=o(),Co=r("p"),this.h()},l(e){const g=ds("svelte-u9bgzb",document.head);y=a(g,"META",{name:!0,content:!0}),g.forEach(s),T=n(e),w=a(e,"P",{}),b(w).forEach(s),C=n(e),p(R.$$.fragment,e),x=n(e),I=a(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-fqtivw"&&(I.innerHTML=na),ko=n(e),we=a(e,"P",{"data-svelte-h":!0}),c(we)!=="svelte-1mkssuw"&&(we.innerHTML=ra),To=n(e),p(Ce.$$.fragment,e),Ro=n(e),i=a(e,"DIV",{class:!0});var l=b(i);p(ke.$$.fragment,l),xn=n(l),bt=a(l,"P",{"data-svelte-h":!0}),c(bt)!=="svelte-sfljep"&&(bt.textContent=aa),wn=n(l),vt=a(l,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-130r937"&&(vt.textContent=sa),Cn=n(l),p(Q.$$.fragment,l),kn=n(l),M=a(l,"DIV",{class:!0});var j=b(M);p(Te.$$.fragment,j),Tn=n(j),yt=a(j,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-u91m2x"&&(yt.textContent=ia),Rn=n(j),$t=a(j,"P",{"data-svelte-h":!0}),c($t)!=="svelte-15u8jgr"&&($t.innerHTML=la),In=n(j),xt=a(j,"P",{"data-svelte-h":!0}),c(xt)!=="svelte-1rccgws"&&(xt.innerHTML=ca),j.forEach(s),Dn=n(l),Z=a(l,"DIV",{class:!0});var _t=b(Z);p(Re.$$.fragment,_t),Mn=n(_t),wt=a(_t,"P",{"data-svelte-h":!0}),c(wt)!=="svelte-1931o36"&&(wt.textContent=ga),_t.forEach(s),Ln=n(l),L=a(l,"DIV",{class:!0});var U=b(L);p(Ie.$$.fragment,U),Pn=n(U),Ct=a(U,"P",{"data-svelte-h":!0}),c(Ct)!=="svelte-63n9b3"&&(Ct.textContent=da),En=n(U),kt=a(U,"P",{"data-svelte-h":!0}),c(kt)!=="svelte-1mgqvlx"&&(kt.textContent=pa),jn=n(U),Tt=a(U,"P",{"data-svelte-h":!0}),c(Tt)!=="svelte-10sq8kk"&&(Tt.textContent=ha),U.forEach(s),Un=n(l),X=a(l,"DIV",{class:!0});var So=b(X);p(De.$$.fragment,So),Hn=n(So),Rt=a(So,"P",{"data-svelte-h":!0}),c(Rt)!=="svelte-1xz8ip4"&&(Rt.textContent=ua),So.forEach(s),Jn=n(l),K=a(l,"DIV",{class:!0});var Ao=b(K);p(Me.$$.fragment,Ao),Vn=n(Ao),It=a(Ao,"P",{"data-svelte-h":!0}),c(It)!=="svelte-gpfomi"&&(It.textContent=ma),Ao.forEach(s),Fn=n(l),Y=a(l,"DIV",{class:!0});var Oo=b(Y);p(Le.$$.fragment,Oo),Nn=n(Oo),Dt=a(Oo,"P",{"data-svelte-h":!0}),c(Dt)!=="svelte-i6ef2h"&&(Dt.innerHTML=fa),Oo.forEach(s),qn=n(l),P=a(l,"DIV",{class:!0});var xe=b(P);p(Pe.$$.fragment,xe),Wn=n(xe),Mt=a(xe,"P",{"data-svelte-h":!0}),c(Mt)!=="svelte-yrpdu4"&&(Mt.textContent=_a),Bn=n(xe),Lt=a(xe,"P",{"data-svelte-h":!0}),c(Lt)!=="svelte-kcbb31"&&(Lt.textContent=ba),Sn=n(xe),p(ee.$$.fragment,xe),xe.forEach(s),An=n(l),J=a(l,"DIV",{class:!0});var bo=b(J);p(Ee.$$.fragment,bo),On=n(bo),Pt=a(bo,"P",{"data-svelte-h":!0}),c(Pt)!=="svelte-srmdei"&&(Pt.innerHTML=va),Gn=n(bo),p(te.$$.fragment,bo),bo.forEach(s),zn=n(l),oe=a(l,"DIV",{class:!0});var Go=b(oe);p(je.$$.fragment,Go),Qn=n(Go),Et=a(Go,"P",{"data-svelte-h":!0}),c(Et)!=="svelte-x8sm21"&&(Et.textContent=ya),Go.forEach(s),Zn=n(l),V=a(l,"DIV",{class:!0});var vo=b(V);p(Ue.$$.fragment,vo),Xn=n(vo),jt=a(vo,"P",{"data-svelte-h":!0}),c(jt)!=="svelte-1eaw53"&&(jt.textContent=$a),Kn=n(vo),Ut=a(vo,"P",{"data-svelte-h":!0}),c(Ut)!=="svelte-1gwi68h"&&(Ut.innerHTML=xa),vo.forEach(s),Yn=n(l),F=a(l,"DIV",{class:!0});var yo=b(F);p(He.$$.fragment,yo),er=n(yo),Ht=a(yo,"P",{"data-svelte-h":!0}),c(Ht)!=="svelte-fr7o3n"&&(Ht.textContent=wa),tr=n(yo),Jt=a(yo,"P",{"data-svelte-h":!0}),c(Jt)!=="svelte-1f8uww9"&&(Jt.innerHTML=Ca),yo.forEach(s),or=n(l),ne=a(l,"DIV",{class:!0});var zo=b(ne);p(Je.$$.fragment,zo),nr=n(zo),Vt=a(zo,"P",{"data-svelte-h":!0}),c(Vt)!=="svelte-10kdqwr"&&(Vt.textContent=ka),zo.forEach(s),rr=n(l),re=a(l,"DIV",{class:!0});var Qo=b(re);p(Ve.$$.fragment,Qo),ar=n(Qo),Ft=a(Qo,"P",{"data-svelte-h":!0}),c(Ft)!=="svelte-1jc3bks"&&(Ft.textContent=Ta),Qo.forEach(s),sr=n(l),ae=a(l,"DIV",{class:!0});var Zo=b(ae);p(Fe.$$.fragment,Zo),ir=n(Zo),Nt=a(Zo,"P",{"data-svelte-h":!0}),c(Nt)!=="svelte-1pc1msi"&&(Nt.innerHTML=Ra),Zo.forEach(s),lr=n(l),se=a(l,"DIV",{class:!0});var Xo=b(se);p(Ne.$$.fragment,Xo),cr=n(Xo),qt=a(Xo,"P",{"data-svelte-h":!0}),c(qt)!=="svelte-1v7pd4y"&&(qt.textContent=Ia),Xo.forEach(s),gr=n(l),ie=a(l,"DIV",{class:!0});var Ko=b(ie);p(qe.$$.fragment,Ko),dr=n(Ko),Wt=a(Ko,"P",{"data-svelte-h":!0}),c(Wt)!=="svelte-vce47s"&&(Wt.textContent=Da),Ko.forEach(s),pr=n(l),le=a(l,"DIV",{class:!0});var Yo=b(le);p(We.$$.fragment,Yo),hr=n(Yo),Bt=a(Yo,"P",{"data-svelte-h":!0}),c(Bt)!=="svelte-14r2tu1"&&(Bt.textContent=Ma),Yo.forEach(s),ur=n(l),N=a(l,"DIV",{class:!0});var $o=b(N);p(Be.$$.fragment,$o),mr=n($o),St=a($o,"P",{"data-svelte-h":!0}),c(St)!=="svelte-7q6b1s"&&(St.textContent=La),fr=n($o),At=a($o,"P",{"data-svelte-h":!0}),c(At)!=="svelte-13r9fow"&&(At.innerHTML=Pa),$o.forEach(s),_r=n(l),ce=a(l,"DIV",{class:!0});var en=b(ce);p(Se.$$.fragment,en),br=n(en),Ot=a(en,"P",{"data-svelte-h":!0}),c(Ot)!=="svelte-1gemtfc"&&(Ot.textContent=Ea),en.forEach(s),vr=n(l),ge=a(l,"DIV",{class:!0});var tn=b(ge);p(Ae.$$.fragment,tn),yr=n(tn),Gt=a(tn,"P",{"data-svelte-h":!0}),c(Gt)!=="svelte-1szkij9"&&(Gt.textContent=ja),tn.forEach(s),$r=n(l),de=a(l,"DIV",{class:!0});var on=b(de);p(Oe.$$.fragment,on),xr=n(on),zt=a(on,"P",{"data-svelte-h":!0}),c(zt)!=="svelte-ywq4p5"&&(zt.textContent=Ua),on.forEach(s),wr=n(l),pe=a(l,"DIV",{class:!0});var nn=b(pe);p(Ge.$$.fragment,nn),Cr=n(nn),Qt=a(nn,"P",{"data-svelte-h":!0}),c(Qt)!=="svelte-o0hw73"&&(Qt.textContent=Ha),nn.forEach(s),kr=n(l),q=a(l,"DIV",{class:!0});var xo=b(q);p(ze.$$.fragment,xo),Tr=n(xo),Zt=a(xo,"P",{"data-svelte-h":!0}),c(Zt)!=="svelte-rew8wo"&&(Zt.textContent=Ja),Rr=n(xo),Xt=a(xo,"P",{"data-svelte-h":!0}),c(Xt)!=="svelte-9edfgw"&&(Xt.innerHTML=Va),xo.forEach(s),Ir=n(l),he=a(l,"DIV",{class:!0});var rn=b(he);p(Qe.$$.fragment,rn),Dr=n(rn),Kt=a(rn,"P",{"data-svelte-h":!0}),c(Kt)!=="svelte-un1lv4"&&(Kt.textContent=Fa),rn.forEach(s),Mr=n(l),ue=a(l,"DIV",{class:!0});var an=b(ue);p(Ze.$$.fragment,an),Lr=n(an),Yt=a(an,"P",{"data-svelte-h":!0}),c(Yt)!=="svelte-1i0xpsk"&&(Yt.textContent=Na),an.forEach(s),Pr=n(l),me=a(l,"DIV",{class:!0});var sn=b(me);p(Xe.$$.fragment,sn),Er=n(sn),eo=a(sn,"P",{"data-svelte-h":!0}),c(eo)!=="svelte-jqquke"&&(eo.textContent=qa),sn.forEach(s),jr=n(l),fe=a(l,"DIV",{class:!0});var ln=b(fe);p(Ke.$$.fragment,ln),Ur=n(ln),to=a(ln,"P",{"data-svelte-h":!0}),c(to)!=="svelte-j7abay"&&(to.textContent=Wa),ln.forEach(s),Hr=n(l),_e=a(l,"DIV",{class:!0});var cn=b(_e);p(Ye.$$.fragment,cn),Jr=n(cn),oo=a(cn,"P",{"data-svelte-h":!0}),c(oo)!=="svelte-11wx7zp"&&(oo.textContent=Ba),cn.forEach(s),l.forEach(s),Io=n(e),p(et.$$.fragment,e),Do=n(e),W=a(e,"DIV",{class:!0});var gn=b(W);p(tt.$$.fragment,gn),Vr=n(gn),no=a(gn,"P",{"data-svelte-h":!0}),c(no)!=="svelte-5hpmfd"&&(no.textContent=Sa),gn.forEach(s),Mo=n(e),B=a(e,"DIV",{class:!0});var dn=b(B);p(ot.$$.fragment,dn),Fr=n(dn),ro=a(dn,"P",{"data-svelte-h":!0}),c(ro)!=="svelte-1d1mfv5"&&(ro.textContent=Aa),dn.forEach(s),Lo=n(e),S=a(e,"DIV",{class:!0});var pn=b(S);p(nt.$$.fragment,pn),Nr=n(pn),ao=a(pn,"P",{"data-svelte-h":!0}),c(ao)!=="svelte-oqtt44"&&(ao.textContent=Oa),pn.forEach(s),Po=n(e),A=a(e,"DIV",{class:!0});var hn=b(A);p(rt.$$.fragment,hn),qr=n(hn),so=a(hn,"P",{"data-svelte-h":!0}),c(so)!=="svelte-1jg2eg8"&&(so.textContent=Ga),hn.forEach(s),Eo=n(e),O=a(e,"DIV",{class:!0});var un=b(O);p(at.$$.fragment,un),Wr=n(un),io=a(un,"P",{"data-svelte-h":!0}),c(io)!=="svelte-97mwvc"&&(io.textContent=za),un.forEach(s),jo=n(e),G=a(e,"DIV",{class:!0});var mn=b(G);p(st.$$.fragment,mn),Br=n(mn),lo=a(mn,"P",{"data-svelte-h":!0}),c(lo)!=="svelte-vpsey2"&&(lo.textContent=Qa),mn.forEach(s),Uo=n(e),E=a(e,"DIV",{class:!0});var wo=b(E);p(it.$$.fragment,wo),Sr=n(wo),co=a(wo,"P",{"data-svelte-h":!0}),c(co)!=="svelte-18uhass"&&(co.textContent=Za),Ar=n(wo),go=a(wo,"P",{"data-svelte-h":!0}),c(go)!=="svelte-zq2g9v"&&(go.textContent=Xa),wo.forEach(s),Ho=n(e),p(lt.$$.fragment,e),Jo=n(e),ct=a(e,"P",{"data-svelte-h":!0}),c(ct)!=="svelte-1w5vmm6"&&(ct.innerHTML=Ka),Vo=n(e),gt=a(e,"UL",{"data-svelte-h":!0}),c(gt)!=="svelte-1dzo48z"&&(gt.innerHTML=Ya),Fo=n(e),dt=a(e,"P",{"data-svelte-h":!0}),c(dt)!=="svelte-1k7k7po"&&(dt.textContent=es),No=n(e),k=a(e,"DIV",{class:!0});var D=b(k);p(pt.$$.fragment,D),Or=n(D),po=a(D,"P",{"data-svelte-h":!0}),c(po)!=="svelte-sfljep"&&(po.textContent=ts),Gr=n(D),ho=a(D,"P",{"data-svelte-h":!0}),c(ho)!=="svelte-130r937"&&(ho.textContent=os),zr=n(D),p(be.$$.fragment,D),Qr=n(D),ve=a(D,"DIV",{class:!0});var fn=b(ve);p(ht.$$.fragment,fn),Zr=n(fn),uo=a(fn,"P",{"data-svelte-h":!0}),c(uo)!=="svelte-1qshjwq"&&(uo.textContent=ns),fn.forEach(s),Xr=n(D),ye=a(D,"DIV",{class:!0});var _n=b(ye);p(ut.$$.fragment,_n),Kr=n(_n),mo=a(_n,"P",{"data-svelte-h":!0}),c(mo)!=="svelte-54rv4h"&&(mo.textContent=rs),_n.forEach(s),Yr=n(D),$e=a(D,"DIV",{class:!0});var bn=b($e);p(mt.$$.fragment,bn),ea=n(bn),fo=a(bn,"P",{"data-svelte-h":!0}),c(fo)!=="svelte-11wx7zp"&&(fo.textContent=as),bn.forEach(s),D.forEach(s),qo=n(e),z=a(e,"DIV",{class:!0});var vn=b(z);p(ft.$$.fragment,vn),ta=n(vn),_o=a(vn,"P",{"data-svelte-h":!0}),c(_o)!=="svelte-1na97wh"&&(_o.textContent=ss),vn.forEach(s),Wo=n(e),Co=a(e,"P",{}),b(Co).forEach(s),this.h()},h(){v(y,"name","hf:doc:metadata"),v(y,"content",vs),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(i,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,g){t(document.head,y),_(e,T,g),_(e,w,g),_(e,C,g),h(R,e,g),_(e,x,g),_(e,I,g),_(e,ko,g),_(e,we,g),_(e,To,g),h(Ce,e,g),_(e,Ro,g),_(e,i,g),h(ke,i,null),t(i,xn),t(i,bt),t(i,wn),t(i,vt),t(i,Cn),h(Q,i,null),t(i,kn),t(i,M),h(Te,M,null),t(M,Tn),t(M,yt),t(M,Rn),t(M,$t),t(M,In),t(M,xt),t(i,Dn),t(i,Z),h(Re,Z,null),t(Z,Mn),t(Z,wt),t(i,Ln),t(i,L),h(Ie,L,null),t(L,Pn),t(L,Ct),t(L,En),t(L,kt),t(L,jn),t(L,Tt),t(i,Un),t(i,X),h(De,X,null),t(X,Hn),t(X,Rt),t(i,Jn),t(i,K),h(Me,K,null),t(K,Vn),t(K,It),t(i,Fn),t(i,Y),h(Le,Y,null),t(Y,Nn),t(Y,Dt),t(i,qn),t(i,P),h(Pe,P,null),t(P,Wn),t(P,Mt),t(P,Bn),t(P,Lt),t(P,Sn),h(ee,P,null),t(i,An),t(i,J),h(Ee,J,null),t(J,On),t(J,Pt),t(J,Gn),h(te,J,null),t(i,zn),t(i,oe),h(je,oe,null),t(oe,Qn),t(oe,Et),t(i,Zn),t(i,V),h(Ue,V,null),t(V,Xn),t(V,jt),t(V,Kn),t(V,Ut),t(i,Yn),t(i,F),h(He,F,null),t(F,er),t(F,Ht),t(F,tr),t(F,Jt),t(i,or),t(i,ne),h(Je,ne,null),t(ne,nr),t(ne,Vt),t(i,rr),t(i,re),h(Ve,re,null),t(re,ar),t(re,Ft),t(i,sr),t(i,ae),h(Fe,ae,null),t(ae,ir),t(ae,Nt),t(i,lr),t(i,se),h(Ne,se,null),t(se,cr),t(se,qt),t(i,gr),t(i,ie),h(qe,ie,null),t(ie,dr),t(ie,Wt),t(i,pr),t(i,le),h(We,le,null),t(le,hr),t(le,Bt),t(i,ur),t(i,N),h(Be,N,null),t(N,mr),t(N,St),t(N,fr),t(N,At),t(i,_r),t(i,ce),h(Se,ce,null),t(ce,br),t(ce,Ot),t(i,vr),t(i,ge),h(Ae,ge,null),t(ge,yr),t(ge,Gt),t(i,$r),t(i,de),h(Oe,de,null),t(de,xr),t(de,zt),t(i,wr),t(i,pe),h(Ge,pe,null),t(pe,Cr),t(pe,Qt),t(i,kr),t(i,q),h(ze,q,null),t(q,Tr),t(q,Zt),t(q,Rr),t(q,Xt),t(i,Ir),t(i,he),h(Qe,he,null),t(he,Dr),t(he,Kt),t(i,Mr),t(i,ue),h(Ze,ue,null),t(ue,Lr),t(ue,Yt),t(i,Pr),t(i,me),h(Xe,me,null),t(me,Er),t(me,eo),t(i,jr),t(i,fe),h(Ke,fe,null),t(fe,Ur),t(fe,to),t(i,Hr),t(i,_e),h(Ye,_e,null),t(_e,Jr),t(_e,oo),_(e,Io,g),h(et,e,g),_(e,Do,g),_(e,W,g),h(tt,W,null),t(W,Vr),t(W,no),_(e,Mo,g),_(e,B,g),h(ot,B,null),t(B,Fr),t(B,ro),_(e,Lo,g),_(e,S,g),h(nt,S,null),t(S,Nr),t(S,ao),_(e,Po,g),_(e,A,g),h(rt,A,null),t(A,qr),t(A,so),_(e,Eo,g),_(e,O,g),h(at,O,null),t(O,Wr),t(O,io),_(e,jo,g),_(e,G,g),h(st,G,null),t(G,Br),t(G,lo),_(e,Uo,g),_(e,E,g),h(it,E,null),t(E,Sr),t(E,co),t(E,Ar),t(E,go),_(e,Ho,g),h(lt,e,g),_(e,Jo,g),_(e,ct,g),_(e,Vo,g),_(e,gt,g),_(e,Fo,g),_(e,dt,g),_(e,No,g),_(e,k,g),h(pt,k,null),t(k,Or),t(k,po),t(k,Gr),t(k,ho),t(k,zr),h(be,k,null),t(k,Qr),t(k,ve),h(ht,ve,null),t(ve,Zr),t(ve,uo),t(k,Xr),t(k,ye),h(ut,ye,null),t(ye,Kr),t(ye,mo),t(k,Yr),t(k,$e),h(mt,$e,null),t($e,ea),t($e,fo),_(e,qo,g),_(e,z,g),h(ft,z,null),t(z,ta),t(z,_o),_(e,Wo,g),_(e,Co,g),Bo=!0},p(e,[g]){const l={};g&2&&(l.$$scope={dirty:g,ctx:e}),Q.$set(l);const j={};g&2&&(j.$$scope={dirty:g,ctx:e}),ee.$set(j);const _t={};g&2&&(_t.$$scope={dirty:g,ctx:e}),te.$set(_t);const U={};g&2&&(U.$$scope={dirty:g,ctx:e}),be.$set(U)},i(e){Bo||(u(R.$$.fragment,e),u(Ce.$$.fragment,e),u(ke.$$.fragment,e),u(Q.$$.fragment,e),u(Te.$$.fragment,e),u(Re.$$.fragment,e),u(Ie.$$.fragment,e),u(De.$$.fragment,e),u(Me.$$.fragment,e),u(Le.$$.fragment,e),u(Pe.$$.fragment,e),u(ee.$$.fragment,e),u(Ee.$$.fragment,e),u(te.$$.fragment,e),u(je.$$.fragment,e),u(Ue.$$.fragment,e),u(He.$$.fragment,e),u(Je.$$.fragment,e),u(Ve.$$.fragment,e),u(Fe.$$.fragment,e),u(Ne.$$.fragment,e),u(qe.$$.fragment,e),u(We.$$.fragment,e),u(Be.$$.fragment,e),u(Se.$$.fragment,e),u(Ae.$$.fragment,e),u(Oe.$$.fragment,e),u(Ge.$$.fragment,e),u(ze.$$.fragment,e),u(Qe.$$.fragment,e),u(Ze.$$.fragment,e),u(Xe.$$.fragment,e),u(Ke.$$.fragment,e),u(Ye.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(ot.$$.fragment,e),u(nt.$$.fragment,e),u(rt.$$.fragment,e),u(at.$$.fragment,e),u(st.$$.fragment,e),u(it.$$.fragment,e),u(lt.$$.fragment,e),u(pt.$$.fragment,e),u(be.$$.fragment,e),u(ht.$$.fragment,e),u(ut.$$.fragment,e),u(mt.$$.fragment,e),u(ft.$$.fragment,e),Bo=!0)},o(e){m(R.$$.fragment,e),m(Ce.$$.fragment,e),m(ke.$$.fragment,e),m(Q.$$.fragment,e),m(Te.$$.fragment,e),m(Re.$$.fragment,e),m(Ie.$$.fragment,e),m(De.$$.fragment,e),m(Me.$$.fragment,e),m(Le.$$.fragment,e),m(Pe.$$.fragment,e),m(ee.$$.fragment,e),m(Ee.$$.fragment,e),m(te.$$.fragment,e),m(je.$$.fragment,e),m(Ue.$$.fragment,e),m(He.$$.fragment,e),m(Je.$$.fragment,e),m(Ve.$$.fragment,e),m(Fe.$$.fragment,e),m(Ne.$$.fragment,e),m(qe.$$.fragment,e),m(We.$$.fragment,e),m(Be.$$.fragment,e),m(Se.$$.fragment,e),m(Ae.$$.fragment,e),m(Oe.$$.fragment,e),m(Ge.$$.fragment,e),m(ze.$$.fragment,e),m(Qe.$$.fragment,e),m(Ze.$$.fragment,e),m(Xe.$$.fragment,e),m(Ke.$$.fragment,e),m(Ye.$$.fragment,e),m(et.$$.fragment,e),m(tt.$$.fragment,e),m(ot.$$.fragment,e),m(nt.$$.fragment,e),m(rt.$$.fragment,e),m(at.$$.fragment,e),m(st.$$.fragment,e),m(it.$$.fragment,e),m(lt.$$.fragment,e),m(pt.$$.fragment,e),m(be.$$.fragment,e),m(ht.$$.fragment,e),m(ut.$$.fragment,e),m(mt.$$.fragment,e),m(ft.$$.fragment,e),Bo=!1},d(e){e&&(s(T),s(w),s(C),s(x),s(I),s(ko),s(we),s(To),s(Ro),s(i),s(Io),s(Do),s(W),s(Mo),s(B),s(Lo),s(S),s(Po),s(A),s(Eo),s(O),s(jo),s(G),s(Uo),s(E),s(Ho),s(Jo),s(ct),s(Vo),s(gt),s(Fo),s(dt),s(No),s(k),s(qo),s(z),s(Wo),s(Co)),s(y),f(R,e),f(Ce,e),f(ke),f(Q),f(Te),f(Re),f(Ie),f(De),f(Me),f(Le),f(Pe),f(ee),f(Ee),f(te),f(je),f(Ue),f(He),f(Je),f(Ve),f(Fe),f(Ne),f(qe),f(We),f(Be),f(Se),f(Ae),f(Oe),f(Ge),f(ze),f(Qe),f(Ze),f(Xe),f(Ke),f(Ye),f(et,e),f(tt),f(ot),f(nt),f(rt),f(at),f(st),f(it),f(lt,e),f(pt),f(be),f(ht),f(ut),f(mt),f(ft)}}}const vs='{"title":"Managing local and online repositories","local":"managing-local-and-online-repositories","sections":[{"title":"The Repository class","local":"huggingface_hub.Repository","sections":[],"depth":2},{"title":"Helper methods","local":"huggingface_hub.repository.is_git_repo","sections":[],"depth":2},{"title":"Following asynchronous commands","local":"huggingface_hub.Repository","sections":[],"depth":2}],"depth":1}';function ys(H){return ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Is extends cs{constructor(y){super(),gs(this,y,ys,bs,is,{})}}export{Is as component};
