import{s as vT,o as DT,n as YT}from"../chunks/scheduler.f6319a2a.js";import{S as XT,i as zT,g as t,s as M,r as s,m as AT,A as ST,h as a,f as T,c as e,j as Zl,u as n,x as i,n as WT,k as fT,y as r,a as J,v as y,d as w,t as C,w as o}from"../chunks/index.85aa684c.js";import{T as HT}from"../chunks/Tip.3d397a88.js";import{C as h}from"../chunks/CodeBlock.3400fc53.js";import{D as ET}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as N,E as xT}from"../chunks/index.c8a0819f.js";function _T(Al){let d,c='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){d=t("p"),d.innerHTML=c},l(I){d=a(I,"P",{"data-svelte-h":!0}),i(d)!=="svelte-1p1d9vw"&&(d.innerHTML=c)},m(I,Rl){J(I,d,Rl)},p:YT,d(I){I&&T(d)}}}function $T(Al){let d,c,I,Rl,m,Wl,b,fl,k,qU=`There’s a world of difference between building an agent that works and one that doesn’t.
How can we build agents that fall into the former category?
In this guide, we’re going to talk about best practices for building agents.`,vl,u,Dl,V,Yl,F,LU="Giving an LLM some agency in your workflow introduces some risk of errors.",Xl,j,PU="Well-programmed agentic systems have good error logging and retry mechanisms anyway, so the LLM engine has a chance to self-correct their mistake. But to reduce the risk of LLM error to the maximum, you should simplify your workflow!",zl,R,KU=`Let’s revisit the example from the <a href="../conceptual_guides/intro_agents">intro to agents</a>: a bot that answers user queries for a surf trip company.
Instead of letting the agent do 2 different calls for “travel distance API” and “weather API” each time they are asked about a new surf spot, you could just make one unified tool “return_spot_information”, a function that calls both APIs at once and returns their concatenated outputs to the user.`,Sl,B,lT="This will reduce costs, latency, and error risk!",Hl,O,UT="The main guideline is: Reduce the number of LLM calls as much as you can.",El,Q,TT="This leads to a few takeaways:",xl,G,JT="<li>Whenever possible, group 2 tools in one, like in our example of the two APIs.</li> <li>Whenever possible, logic should be based on deterministic functions rather than agentic decisions.</li>",_l,Z,$l,A,MT="Remember that your LLM engine is like an <em>intelligent</em> robot, trapped into a room with the only communication with the outside world being notes passed under a door.",ql,W,eT="It won’t know of anything that happened if you don’t explicitly put that into its prompt.",Ll,f,tT=`So first start with making your task very clear!
Since an agent is powered by an LLM, minor variations in your task formulation might yield completely different results.`,Pl,v,aT="Then, improve the information flow towards your agent in tool use.",Kl,D,iT="Particular guidelines to follow:",lU,Y,sT="<li>Each tool should log (by simply using <code>print</code> statements inside the tool’s <code>forward</code> method) everything that could be useful for the LLM engine.<ul><li>In particular, logging detail on tool execution errors would help a lot!</li></ul></li>",UU,X,nT="For instance, here’s a tool that retrieves weather data based on location and date-time:",TU,z,yT="First, here’s a poor version:",JU,S,MU,H,wT="Why is it bad?",eU,E,CT="<li>there’s no precision of the format that should be used for <code>date_time</code></li> <li>there’s no detail on how location should be specified.</li> <li>there’s no logging mechanism trying to make explicit failure cases like location not being in a proper format, or date_time not being properly formatted.</li> <li>the output format is hard to understand</li>",tU,x,oT="If the tool call fails, the error trace logged in memory can help the LLM reverse engineer the tool to fix the errors. But why leave it with so much heavy lifting to do?",aU,_,dT="A better way to build this tool would have been the following:",iU,$,sU,q,IT="In general, to ease the load on your LLM, the good question to ask yourself is: “How easy would it be for me, if I was dumb and using this tool for the first time ever, to program with this tool and correct my own errors?“.",nU,L,yU,P,pT="To pass some additional objects to your agent beyond the simple string describing the task, you can use the <code>additional_args</code> argument to pass any type of object:",wU,K,CU,ll,hT="For instance, you can use this <code>additional_args</code> argument to pass images or strings that you want your agent to leverage.",oU,Ul,dU,Tl,IU,Jl,gT=`In an agentic workflows, some of the errors are actual errors, some other are the fault of your LLM engine not reasoning properly.
For instance, consider this trace for an <code>CodeAgent</code> that I asked to create a car picture:`,pU,Ml,hU,el,NT=`The user sees, instead of an image being returned, a path being returned to them.
It could look like a bug from the system, but actually the agentic system didn’t cause the error: it’s just that the LLM brain did the mistake of not saving the image output into a variable.
Thus it cannot access the image again except by leveraging the path that was logged while saving the image, so it returns the path instead of an image.`,gU,tl,uT="The first step to debugging your agent is thus “Use a more powerful LLM”. Alternatives like <code>Qwen2/5-72B-Instruct</code> wouldn’t have made that mistake.",NU,al,uU,il,rT="You can also use less powerful models, provided you guide them more effectively.",rU,sl,cT="Put yourself in the shoes of your model: if you were the model solving the task, would you struggle with the information available to you (from the system prompt + task formulation + tool description) ?",cU,nl,mT="Would you need some added clarifications?",mU,yl,bT=`To provide extra information, we do not recommend to change the system prompt right away: the default system prompt has many adjustments that you do not want to mess up except if you understand the prompt very well.
Better ways to guide your LLM engine are:`,bU,wl,kT="<li>If it’s about the task to solve: add all these details to the task. The task could be 100s of pages long.</li> <li>If it’s about how to use tools: the description attribute of your tools.</li>",kU,Cl,VU,ol,VT="If above clarifications are not sufficient, you can change the system prompt.",FU,dl,FT='Let’s see how it works. For example, let us check the default system prompt for the <a href="/docs/smolagents/v1.16.0/en/reference/agents#smolagents.CodeAgent">CodeAgent</a> (below version is shortened by skipping zero-shot examples).',jU,Il,RU,pl,jT="Here is what you get:",BU,hl,OU,gl,RT="As you can see, there are placeholders like <code>&quot;{{ tool.description }}&quot;</code>: these will be used upon agent initialization to insert certain automatically generated descriptions of tools or managed agents.",QU,Nl,BT="So while you can overwrite this system prompt template by passing your custom prompt as an argument to the <code>system_prompt</code> parameter, your new system prompt can contain the following placeholders:",GU,p,Bl,SU,ul,HU,Ol,EU,rl,xU,Ql,OT="For <code>CodeAgent</code> only, to insert the list of authorized imports: <code>&quot;{{authorized_imports}}&quot;</code>",ZU,cl,QT="Then you can change the system prompt as follows:",AU,ml,WU,bl,GT='This also works with the <a href="/docs/smolagents/v1.16.0/en/reference/agents#smolagents.ToolCallingAgent">ToolCallingAgent</a>.',fU,kl,vU,Vl,ZT="We provide a model for a supplementary planning step, that an agent can run regularly in-between normal action steps. In this step, there is no tool call, the LLM is simply asked to update a list of facts it knows and to reflect on what steps it should take next based on those facts.",DU,Fl,YU,jl,XU,Gl,zU;return m=new N({props:{title:"Building good agents",local:"building-good-agents",headingTag:"h1"}}),b=new ET({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/building_good_agents.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/building_good_agents.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/building_good_agents.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/building_good_agents.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/building_good_agents.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/building_good_agents.ipynb"}]}}),u=new HT({props:{warning:!1,$$slots:{default:[_T]},$$scope:{ctx:Al}}}),V=new N({props:{title:"The best agentic systems are the simplest: simplify the workflow as much as you can",local:"the-best-agentic-systems-are-the-simplest-simplify-the-workflow-as-much-as-you-can",headingTag:"h3"}}),Z=new N({props:{title:"Improve the information flow to the LLM engine",local:"improve-the-information-flow-to-the-llm-engine",headingTag:"h3"}}),S=new h({props:{code:"aW1wb3J0JTIwZGF0ZXRpbWUlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMHRvb2wlMEElMEFkZWYlMjBnZXRfd2VhdGhlcl9yZXBvcnRfYXRfY29vcmRpbmF0ZXMoY29vcmRpbmF0ZXMlMkMlMjBkYXRlX3RpbWUpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRHVtbXklMjBmdW5jdGlvbiUyQyUyMHJldHVybnMlMjBhJTIwbGlzdCUyMG9mJTIwJTVCdGVtcGVyYXR1cmUlMjBpbiUyMCVDMiVCMEMlMkMlMjByaXNrJTIwb2YlMjByYWluJTIwb24lMjBhJTIwc2NhbGUlMjAwLTElMkMlMjB3YXZlJTIwaGVpZ2h0JTIwaW4lMjBtJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCMjguMCUyQyUyMDAuMzUlMkMlMjAwLjg1JTVEJTBBJTBBZGVmJTIwY29udmVydF9sb2NhdGlvbl90b19jb29yZGluYXRlcyhsb2NhdGlvbiklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBSZXR1cm5zJTIwZHVtbXklMjBjb29yZGluYXRlcyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU1QjMuMyUyQyUyMC00Mi4wJTVEJTBBJTBBJTQwdG9vbCUwQWRlZiUyMGdldF93ZWF0aGVyX2FwaShsb2NhdGlvbiUzQSUyMHN0ciUyQyUyMGRhdGVfdGltZSUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUyMHRoZSUyMHdlYXRoZXIlMjByZXBvcnQuJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvY2F0aW9uJTNBJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwcGxhY2UlMjB0aGF0JTIweW91JTIwd2FudCUyMHRoZSUyMHdlYXRoZXIlMjBmb3IuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0ZV90aW1lJTNBJTIwdGhlJTIwZGF0ZSUyMGFuZCUyMHRpbWUlMjBmb3IlMjB3aGljaCUyMHlvdSUyMHdhbnQlMjB0aGUlMjByZXBvcnQuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwbG9uJTJDJTIwbGF0JTIwJTNEJTIwY29udmVydF9sb2NhdGlvbl90b19jb29yZGluYXRlcyhsb2NhdGlvbiklMEElMjAlMjAlMjAlMjBkYXRlX3RpbWUlMjAlM0QlMjBkYXRldGltZS5zdHJwdGltZShkYXRlX3RpbWUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3RyKGdldF93ZWF0aGVyX3JlcG9ydF9hdF9jb29yZGluYXRlcygobG9uJTJDJTIwbGF0KSUyQyUyMGRhdGVfdGltZSkp",highlighted:`<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_report_at_coordinates</span>(<span class="hljs-params">coordinates, date_time</span>):
    <span class="hljs-comment"># Dummy function, returns a list of [temperature in °C, risk of rain on a scale 0-1, wave height in m]</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">28.0</span>, <span class="hljs-number">0.35</span>, <span class="hljs-number">0.85</span>]

<span class="hljs-keyword">def</span> <span class="hljs-title function_">convert_location_to_coordinates</span>(<span class="hljs-params">location</span>):
    <span class="hljs-comment"># Returns dummy coordinates</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">3.3</span>, -<span class="hljs-number">42.0</span>]

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_api</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, date_time: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Returns the weather report.

    Args:
        location: the name of the place that you want the weather for.
        date_time: the date and time for which you want the report.
    &quot;&quot;&quot;</span>
    lon, lat = convert_location_to_coordinates(location)
    date_time = datetime.strptime(date_time)
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(get_weather_report_at_coordinates((lon, lat), date_time))`,wrap:!1}}),$=new h({props:{code:"JTQwdG9vbCUwQWRlZiUyMGdldF93ZWF0aGVyX2FwaShsb2NhdGlvbiUzQSUyMHN0ciUyQyUyMGRhdGVfdGltZSUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUyMHRoZSUyMHdlYXRoZXIlMjByZXBvcnQuJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvY2F0aW9uJTNBJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwcGxhY2UlMjB0aGF0JTIweW91JTIwd2FudCUyMHRoZSUyMHdlYXRoZXIlMjBmb3IuJTIwU2hvdWxkJTIwYmUlMjBhJTIwcGxhY2UlMjBuYW1lJTJDJTIwZm9sbG93ZWQlMjBieSUyMHBvc3NpYmx5JTIwYSUyMGNpdHklMjBuYW1lJTJDJTIwdGhlbiUyMGElMjBjb3VudHJ5JTJDJTIwbGlrZSUyMCUyMkFuY2hvciUyMFBvaW50JTJDJTIwVGFnaGF6b3V0JTJDJTIwTW9yb2NjbyUyMi4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRlX3RpbWUlM0ElMjB0aGUlMjBkYXRlJTIwYW5kJTIwdGltZSUyMGZvciUyMHdoaWNoJTIweW91JTIwd2FudCUyMHRoZSUyMHJlcG9ydCUyQyUyMGZvcm1hdHRlZCUyMGFzJTIwJyUyNW0lMkYlMjVkJTJGJTI1eSUyMCUyNUglM0ElMjVNJTNBJTI1UycuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwbG9uJTJDJTIwbGF0JTIwJTNEJTIwY29udmVydF9sb2NhdGlvbl90b19jb29yZGluYXRlcyhsb2NhdGlvbiklMEElMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRlX3RpbWUlMjAlM0QlMjBkYXRldGltZS5zdHJwdGltZShkYXRlX3RpbWUpJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwRXhjZXB0aW9uJTIwYXMlMjBlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjBWYWx1ZUVycm9yKCUyMkNvbnZlcnNpb24lMjBvZiUyMCU2MGRhdGVfdGltZSU2MCUyMHRvJTIwZGF0ZXRpbWUlMjBmb3JtYXQlMjBmYWlsZWQlMkMlMjBtYWtlJTIwc3VyZSUyMHRvJTIwcHJvdmlkZSUyMGElMjBzdHJpbmclMjBpbiUyMGZvcm1hdCUyMCclMjVtJTJGJTI1ZCUyRiUyNXklMjAlMjVIJTNBJTI1TSUzQSUyNVMnLiUyMEZ1bGwlMjB0cmFjZSUzQSUyMiUyMCUyQiUyMHN0cihlKSklMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZV9jZWxzaXVzJTJDJTIwcmlza19vZl9yYWluJTJDJTIwd2F2ZV9oZWlnaHQlMjAlM0QlMjBnZXRfd2VhdGhlcl9yZXBvcnRfYXRfY29vcmRpbmF0ZXMoKGxvbiUyQyUyMGxhdCklMkMlMjBkYXRlX3RpbWUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZiUyMldlYXRoZXIlMjByZXBvcnQlMjBmb3IlMjAlN0Jsb2NhdGlvbiU3RCUyQyUyMCU3QmRhdGVfdGltZSU3RCUzQSUyMFRlbXBlcmF0dXJlJTIwd2lsbCUyMGJlJTIwJTdCdGVtcGVyYXR1cmVfY2Vsc2l1cyU3RCVDMiVCMEMlMkMlMjByaXNrJTIwb2YlMjByYWluJTIwaXMlMjAlN0JyaXNrX29mX3JhaW4qMTAwJTNBLjBmJTdEJTI1JTJDJTIwd2F2ZSUyMGhlaWdodCUyMGlzJTIwJTdCd2F2ZV9oZWlnaHQlN0RtLiUyMg==",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_api</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, date_time: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Returns the weather report.

    Args:
        location: the name of the place that you want the weather for. Should be a place name, followed by possibly a city name, then a country, like &quot;Anchor Point, Taghazout, Morocco&quot;.
        date_time: the date and time for which you want the report, formatted as &#x27;%m/%d/%y %H:%M:%S&#x27;.
    &quot;&quot;&quot;</span>
    lon, lat = convert_location_to_coordinates(location)
    <span class="hljs-keyword">try</span>:
        date_time = datetime.strptime(date_time)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;Conversion of \`date_time\` to datetime format failed, make sure to provide a string in format &#x27;%m/%d/%y %H:%M:%S&#x27;. Full trace:&quot;</span> + <span class="hljs-built_in">str</span>(e))
    temperature_celsius, risk_of_rain, wave_height = get_weather_report_at_coordinates((lon, lat), date_time)
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Weather report for <span class="hljs-subst">{location}</span>, <span class="hljs-subst">{date_time}</span>: Temperature will be <span class="hljs-subst">{temperature_celsius}</span>°C, risk of rain is <span class="hljs-subst">{risk_of_rain*<span class="hljs-number">100</span>:<span class="hljs-number">.0</span>f}</span>%, wave height is <span class="hljs-subst">{wave_height}</span>m.&quot;</span>`,wrap:!1}}),L=new N({props:{title:"Give more arguments to the agent",local:"give-more-arguments-to-the-agent",headingTag:"h3"}}),K=new h({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMy03MEItSW5zdHJ1Y3QlMjIlMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0Rtb2RlbF9pZCklMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMldoeSUyMGRvZXMlMjBNaWtlJTIwbm90JTIwa25vdyUyMG1hbnklMjBwZW9wbGUlMjBpbiUyME5ldyUyMFlvcmslM0YlMjIlMkMlMEElMjAlMjAlMjAlMjBhZGRpdGlvbmFsX2FyZ3MlM0QlN0IlMjJtcDNfc291bmRfZmlsZV91cmwlMjIlM0EnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGdHJhbnNmb3JtZXJzJTJGcmVjb3JkaW5nLm1wMyclN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.3-70B-Instruct&quot;</span>

agent = CodeAgent(tools=[], model=InferenceClientModel(model_id=model_id), add_base_tools=<span class="hljs-literal">True</span>)

agent.run(
    <span class="hljs-string">&quot;Why does Mike not know many people in New York?&quot;</span>,
    additional_args={<span class="hljs-string">&quot;mp3_sound_file_url&quot;</span>:<span class="hljs-string">&#x27;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/recording.mp3&#x27;</span>}
)`,wrap:!1}}),Ul=new N({props:{title:"How to debug your agent",local:"how-to-debug-your-agent",headingTag:"h2"}}),Tl=new N({props:{title:"1. Use a stronger LLM",local:"1-use-a-stronger-llm",headingTag:"h3"}}),Ml=new h({props:{code:"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",highlighted:`==================================================================================================== <span class="hljs-keyword">New</span> <span class="hljs-keyword">task</span> ====================================================================================================
Make me a cool car picture
──────────────────────────────────────────────────────────────────────────────────────────────────── <span class="hljs-keyword">New</span> <span class="hljs-keyword">step</span> ────────────────────────────────────────────────────────────────────────────────────────────────────
Agent is executing the code below: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
image_generator(prompt=<span class="hljs-string">&quot;A cool, futuristic sports car with LED headlights, aerodynamic design, and vibrant color, high-res, photorealistic&quot;</span>)
──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────

Last output <span class="hljs-keyword">from</span> code snippet: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png
<span class="hljs-keyword">Step</span> <span class="hljs-number">1</span>:

- Time taken: <span class="hljs-number">16.35</span> seconds
- Input tokens: <span class="hljs-number">1</span>,<span class="hljs-number">383</span>
- Output tokens: <span class="hljs-number">77</span>
──────────────────────────────────────────────────────────────────────────────────────────────────── <span class="hljs-keyword">New</span> <span class="hljs-keyword">step</span> ────────────────────────────────────────────────────────────────────────────────────────────────────
Agent is executing the code below: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
final_answer(<span class="hljs-string">&quot;/var/folders/6m/9b1tts6d5w960j80wbw9tx3m0000gn/T/tmpx09qfsdd/652f0007-3ee9-44e2-94ac-90dae6bb89a4.png&quot;</span>)
──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-keyword">Print</span> outputs:

Last output <span class="hljs-keyword">from</span> code snippet: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png
<span class="hljs-keyword">Final</span> answer:
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png`,wrap:!1}}),al=new N({props:{title:"2. Provide more guidance / more information",local:"2-provide-more-guidance--more-information",headingTag:"h3"}}),Cl=new N({props:{title:"3. Change the system prompt (generally not advised)",local:"3-change-the-system-prompt-generally-not-advised",headingTag:"h3"}}),Il=new h({props:{code:"cHJpbnQoYWdlbnQucHJvbXB0X3RlbXBsYXRlcyU1QiUyMnN5c3RlbV9wcm9tcHQlMjIlNUQp",highlighted:'<span class="hljs-built_in">print</span>(agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>])',wrap:!1}}),hl=new h({props:{code:"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",highlighted:`You are an expert assistant who can solve any task using code blobs. You will be given a task to solve as best you can.
To do so, you have been given access to a list of tools: these tools are basically Python functions which you can call with code.
To solve the task, you must plan forward to proceed in a series of steps, in a cycle of &#x27;Thought:&#x27;, &#x27;Code:&#x27;, and &#x27;Observation:&#x27; sequences.

At each step, in the &#x27;Thought:&#x27; sequence, you should first explain your reasoning towards solving the task and the tools that you want to use.
Then in the &#x27;Code:&#x27; sequence, you should write the code in simple Python. The code sequence must end with &#x27;&lt;end_code&gt;&#x27; sequence.
During each intermediate step, you can use &#x27;print()&#x27; to save whatever important information you will then need.
These print outputs will then appear in the &#x27;Observation:&#x27; field, which will be available as input for the next step.
In the end you have to return a final answer using the \`final_answer\` tool.

Here are a few examples using notional tools:
---
Task: &quot;Generate an image of the oldest person in this document.&quot;

Thought: I will proceed step by step and use the following tools: \`document_qa\` to find the oldest person in the document, then \`image_generator\` to generate an image according to the answer.
Code:
\`\`\`py
answer = document_qa(document=document, question=&quot;Who is the oldest person mentioned?&quot;)
print(answer)
\`\`\`&lt;end_code&gt;
Observation: &quot;The oldest person in the document is John Doe, a 55 year old lumberjack living in Newfoundland.&quot;

Thought: I will now generate an image showcasing the oldest person.
Code:
\`\`\`py
image = image_generator(&quot;A portrait of John Doe, a 55-year-old man living in Canada.&quot;)
final_answer(image)
\`\`\`&lt;end_code&gt;

---
Task: &quot;What is the result of the following operation: 5 + 3 + 1294.678?&quot;

Thought: I will use python code to compute the result of the operation and then return the final answer using the \`final_answer\` tool
Code:
\`\`\`py
result = 5 + 3 + 1294.678
final_answer(result)
\`\`\`&lt;end_code&gt;

---
Task:
&quot;Answer the question in the variable \`question\` about the image stored in the variable \`image\`. The question is in French.
You have been provided with these additional arguments, that you can access using the keys as variables in your python code:
{&#x27;question&#x27;: &#x27;Quel est l&#x27;animal sur l&#x27;image?&#x27;, &#x27;image&#x27;: &#x27;path/to/image.jpg&#x27;}&quot;

Thought: I will use the following tools: \`translator\` to translate the question into English and then \`image_qa\` to answer the question on the input image.
Code:
\`\`\`py
translated_question = translator(question=question, src_lang=&quot;French&quot;, tgt_lang=&quot;English&quot;)
print(f&quot;The translated question is {translated_question}.&quot;)
answer = image_qa(image=image, question=translated_question)
final_answer(f&quot;The answer is {answer}&quot;)
\`\`\`&lt;end_code&gt;

---
Task:
In a 1979 interview, Stanislaus Ulam discusses with Martin Sherwin about other great physicists of his time, including Oppenheimer.
What does he say was the consequence of Einstein learning too much math on his creativity, in one word?

Thought: I need to find and read the 1979 interview of Stanislaus Ulam with Martin Sherwin.
Code:
\`\`\`py
pages = search(query=&quot;1979 interview Stanislaus Ulam Martin Sherwin physicists Einstein&quot;)
print(pages)
\`\`\`&lt;end_code&gt;
Observation:
No result found for query &quot;1979 interview Stanislaus Ulam Martin Sherwin physicists Einstein&quot;.

Thought: The query was maybe too restrictive and did not find any results. Let&#x27;s try again with a broader query.
Code:
\`\`\`py
pages = search(query=&quot;1979 interview Stanislaus Ulam&quot;)
print(pages)
\`\`\`&lt;end_code&gt;
Observation:
Found 6 pages:
[Stanislaus Ulam 1979 interview](https://ahf.nuclearmuseum.org/voices/oral-histories/stanislaus-ulams-interview-1979/)

[Ulam discusses Manhattan Project](https://ahf.nuclearmuseum.org/manhattan-project/ulam-manhattan-project/)

(truncated)

Thought: I will read the first 2 pages to know more.
Code:
\`\`\`py
for url in [&quot;https://ahf.nuclearmuseum.org/voices/oral-histories/stanislaus-ulams-interview-1979/&quot;, &quot;https://ahf.nuclearmuseum.org/manhattan-project/ulam-manhattan-project/&quot;]:
    whole_page = visit_webpage(url)
    print(whole_page)
    print(&quot;\\n&quot; + &quot;=&quot;*80 + &quot;\\n&quot;)  # Print separator between pages
\`\`\`&lt;end_code&gt;
Observation:
Manhattan Project Locations:
Los Alamos, NM
Stanislaus Ulam was a Polish-American mathematician. He worked on the Manhattan Project at Los Alamos and later helped design the hydrogen bomb. In this interview, he discusses his work at
(truncated)

Thought: I now have the final answer: from the webpages visited, Stanislaus Ulam says of Einstein: &quot;He learned too much mathematics and sort of diminished, it seems to me personally, it seems to me his purely physics creativity.&quot; Let&#x27;s answer in one word.
Code:
\`\`\`py
final_answer(&quot;diminished&quot;)
\`\`\`&lt;end_code&gt;

---
Task: &quot;Which city has the highest population: Guangzhou or Shanghai?&quot;

Thought: I need to get the populations for both cities and compare them: I will use the tool \`search\` to get the population of both cities.
Code:
\`\`\`py
for city in [&quot;Guangzhou&quot;, &quot;Shanghai&quot;]:
    print(f&quot;Population {city}:&quot;, search(f&quot;{city} population&quot;)
\`\`\`&lt;end_code&gt;
Observation:
Population Guangzhou: [&#x27;Guangzhou has a population of 15 million inhabitants as of 2021.&#x27;]
Population Shanghai: &#x27;26 million (2019)&#x27;

Thought: Now I know that Shanghai has the highest population.
Code:
\`\`\`py
final_answer(&quot;Shanghai&quot;)
\`\`\`&lt;end_code&gt;

---
Task: &quot;What is the current age of the pope, raised to the power 0.36?&quot;

Thought: I will use the tool \`wiki\` to get the age of the pope, and confirm that with a web search.
Code:
\`\`\`py
pope_age_wiki = wiki(query=&quot;current pope age&quot;)
print(&quot;Pope age as per wikipedia:&quot;, pope_age_wiki)
pope_age_search = web_search(query=&quot;current pope age&quot;)
print(&quot;Pope age as per google search:&quot;, pope_age_search)
\`\`\`&lt;end_code&gt;
Observation:
Pope age: &quot;The pope Francis is currently 88 years old.&quot;

Thought: I know that the pope is 88 years old. Let&#x27;s compute the result using python code.
Code:
\`\`\`py
pope_current_age = 88 ** 0.36
final_answer(pope_current_age)
\`\`\`&lt;end_code&gt;

Above example were using notional tools that might not exist for you. On top of performing computations in the Python code snippets that you create, you only have access to these tools:
{%- for tool in tools.values() %}
- {{ tool.name }}: {{ tool.description }}
    Takes inputs: {{tool.inputs}}
    Returns an output of type: {{tool.output_type}}
{%- endfor %}

{%- if managed_agents and managed_agents.values() | list %}
You can also give tasks to team members.
Calling a team member works the same as for calling a tool: simply, the only argument you can give in the call is &#x27;task&#x27;, a long string explaining your task.
Given that this team member is a real human, you should be very verbose in your task.
Here is a list of the team members that you can call:
{%- for agent in managed_agents.values() %}
- {{ agent.name }}: {{ agent.description }}
{%- endfor %}
{%- else %}
{%- endif %}

Here are the rules you should always follow to solve your task:
1. Always provide a &#x27;Thought:&#x27; sequence, and a &#x27;Code:\\n\`\`\`py&#x27; sequence ending with &#x27;\`\`\`&lt;end_code&gt;&#x27; sequence, else you will fail.
2. Use only variables that you have defined!
3. Always use the right arguments for the tools. DO NOT pass the arguments as a dict as in &#x27;answer = wiki({&#x27;query&#x27;: &quot;What is the place where James Bond lives?&quot;})&#x27;, but use the arguments directly as in &#x27;answer = wiki(query=&quot;What is the place where James Bond lives?&quot;)&#x27;.
4. Take care to not chain too many sequential tool calls in the same code block, especially when the output format is unpredictable. For instance, a call to search has an unpredictable return format, so do not have another tool call that depends on its output in the same block: rather output results with print() to use them in the next block.
5. Call a tool only when needed, and never re-do a tool call that you previously did with the exact same parameters.
6. Don&#x27;t name any new variable with the same name as a tool: for instance don&#x27;t name a variable &#x27;final_answer&#x27;.
7. Never create any notional variables in our code, as having these in your logs will derail you from the true variables.
8. You can use imports in your code, but only from the following list of modules: {{authorized_imports}}
9. The state persists between code executions: so if in one step you&#x27;ve created variables or imported modules, these will all persist.
10. Don&#x27;t give up! You&#x27;re in charge of solving the task, not providing directions to solve it.

Now Begin! If you solve the task correctly, you will receive a reward of $1,000,000.`,wrap:!1}}),ul=new h({props:{code:"JTdCJTI1LSUyMGZvciUyMHRvb2wlMjBpbiUyMHRvb2xzLnZhbHVlcygpJTIwJTI1JTdEJTBBLSUyMCU3QiU3QiUyMHRvb2wubmFtZSUyMCU3RCU3RCUzQSUyMCU3QiU3QiUyMHRvb2wuZGVzY3JpcHRpb24lMjAlN0QlN0QlMEElMjAlMjAlMjAlMjBUYWtlcyUyMGlucHV0cyUzQSUyMCU3QiU3QnRvb2wuaW5wdXRzJTdEJTdEJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUyMGFuJTIwb3V0cHV0JTIwb2YlMjB0eXBlJTNBJTIwJTdCJTdCdG9vbC5vdXRwdXRfdHlwZSU3RCU3RCUwQSU3QiUyNS0lMjBlbmRmb3IlMjAlMjUlN0Q=",highlighted:`<span class="language-xml">{%- for tool in tools.values() %}
- </span><span class="hljs-template-variable">{{ <span class="hljs-name">tool.name</span> }}</span><span class="language-xml">: </span><span class="hljs-template-variable">{{ <span class="hljs-name">tool.description</span> }}</span><span class="language-xml">
    Takes inputs: </span><span class="hljs-template-variable">{{<span class="hljs-name">tool.inputs</span>}}</span><span class="language-xml">
    Returns an output of type: </span><span class="hljs-template-variable">{{<span class="hljs-name">tool.output_type</span>}}</span><span class="language-xml">
{%- endfor %}</span>`,wrap:!1}}),rl=new h({props:{code:"JTdCJTI1LSUyMGlmJTIwbWFuYWdlZF9hZ2VudHMlMjBhbmQlMjBtYW5hZ2VkX2FnZW50cy52YWx1ZXMoKSUyMCU3QyUyMGxpc3QlMjAlMjUlN0QlMEFZb3UlMjBjYW4lMjBhbHNvJTIwZ2l2ZSUyMHRhc2tzJTIwdG8lMjB0ZWFtJTIwbWVtYmVycy4lMEFDYWxsaW5nJTIwYSUyMHRlYW0lMjBtZW1iZXIlMjB3b3JrcyUyMHRoZSUyMHNhbWUlMjBhcyUyMGZvciUyMGNhbGxpbmclMjBhJTIwdG9vbCUzQSUyMHNpbXBseSUyQyUyMHRoZSUyMG9ubHklMjBhcmd1bWVudCUyMHlvdSUyMGNhbiUyMGdpdmUlMjBpbiUyMHRoZSUyMGNhbGwlMjBpcyUyMCd0YXNrJyUyQyUyMGElMjBsb25nJTIwc3RyaW5nJTIwZXhwbGFpbmluZyUyMHlvdXIlMjB0YXNrLiUwQUdpdmVuJTIwdGhhdCUyMHRoaXMlMjB0ZWFtJTIwbWVtYmVyJTIwaXMlMjBhJTIwcmVhbCUyMGh1bWFuJTJDJTIweW91JTIwc2hvdWxkJTIwYmUlMjB2ZXJ5JTIwdmVyYm9zZSUyMGluJTIweW91ciUyMHRhc2suJTBBSGVyZSUyMGlzJTIwYSUyMGxpc3QlMjBvZiUyMHRoZSUyMHRlYW0lMjBtZW1iZXJzJTIwdGhhdCUyMHlvdSUyMGNhbiUyMGNhbGwlM0ElMEElN0IlMjUtJTIwZm9yJTIwYWdlbnQlMjBpbiUyMG1hbmFnZWRfYWdlbnRzLnZhbHVlcygpJTIwJTI1JTdEJTBBLSUyMCU3QiU3QiUyMGFnZW50Lm5hbWUlMjAlN0QlN0QlM0ElMjAlN0IlN0IlMjBhZ2VudC5kZXNjcmlwdGlvbiUyMCU3RCU3RCUwQSU3QiUyNS0lMjBlbmRmb3IlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0Q=",highlighted:`{%- <span class="hljs-keyword">if</span> managed_agents <span class="hljs-built_in">and</span> managed_agents.<span class="hljs-built_in">values</span>() | <span class="hljs-keyword">list</span> %}
You can also give tasks <span class="hljs-keyword">to</span> team members.
Calling <span class="hljs-keyword">a</span> team member works the same <span class="hljs-keyword">as</span> <span class="hljs-keyword">for</span> calling <span class="hljs-keyword">a</span> tool: simply, the <span class="hljs-keyword">only</span> <span class="hljs-keyword">argument</span> you can give in the <span class="hljs-keyword">call</span> <span class="hljs-keyword">is</span> <span class="hljs-string">&#x27;task&#x27;</span>, <span class="hljs-keyword">a</span> long <span class="hljs-built_in">string</span> explaining your task.
Given that this team member <span class="hljs-keyword">is</span> <span class="hljs-keyword">a</span> real human, you should <span class="hljs-keyword">be</span> very <span class="hljs-keyword">verbose</span> in your task.
Here <span class="hljs-keyword">is</span> <span class="hljs-keyword">a</span> <span class="hljs-keyword">list</span> of the team members that you can <span class="hljs-keyword">call</span>:
{%- <span class="hljs-keyword">for</span> agent in managed_agents.<span class="hljs-built_in">values</span>() %}
- {{ agent.name }}: {{ agent.description }}
{%- <span class="hljs-keyword">endfor</span> %}
{%- <span class="hljs-keyword">endif</span> %}`,wrap:!1}}),ml=new h({props:{code:"YWdlbnQucHJvbXB0X3RlbXBsYXRlcyU1QiUyMnN5c3RlbV9wcm9tcHQlMjIlNUQlMjAlM0QlMjBhZ2VudC5wcm9tcHRfdGVtcGxhdGVzJTVCJTIyc3lzdGVtX3Byb21wdCUyMiU1RCUyMCUyQiUyMCUyMiU1Q25IZXJlJTIweW91JTIwZ28hJTIy",highlighted:'agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>] = agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>] + <span class="hljs-string">&quot;\\nHere you go!&quot;</span>',wrap:!1}}),kl=new N({props:{title:"4. Extra planning",local:"4-extra-planning",headingTag:"h3"}}),Fl=new h({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFdlYlNlYXJjaFRvb2wlMEFmcm9tJTIwZG90ZW52JTIwaW1wb3J0JTIwbG9hZF9kb3RlbnYlMEElMEFsb2FkX2RvdGVudigpJTBBJTBBJTIzJTIwSW1wb3J0JTIwdG9vbCUyMGZyb20lMjBIdWIlMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZ0ZXh0LXRvLWltYWdlJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQSUwQXNlYXJjaF90b29sJTIwJTNEJTIwV2ViU2VhcmNoVG9vbCgpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzZWFyY2hfdG9vbCUyQyUyMGltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjIpJTJDJTBBJTIwJTIwJTIwJTIwcGxhbm5pbmdfaW50ZXJ2YWwlM0QzJTIwJTIzJTIwVGhpcyUyMGlzJTIwd2hlcmUlMjB5b3UlMjBhY3RpdmF0ZSUyMHBsYW5uaW5nISUwQSklMEElMEElMjMlMjBSdW4lMjBpdCElMEFyZXN1bHQlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySG93JTIwbG9uZyUyMHdvdWxkJTIwYSUyMGNoZWV0YWglMjBhdCUyMGZ1bGwlMjBzcGVlZCUyMHRha2UlMjB0byUyMHJ1biUyMHRoZSUyMGxlbmd0aCUyMG9mJTIwUG9udCUyMEFsZXhhbmRyZSUyMElJSSUzRiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent, InferenceClientModel, WebSearchTool
<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv

load_dotenv()

<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

search_tool = WebSearchTool()

agent = CodeAgent(
    tools=[search_tool, image_generation_tool],
    model=InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>),
    planning_interval=<span class="hljs-number">3</span> <span class="hljs-comment"># This is where you activate planning!</span>
)

<span class="hljs-comment"># Run it!</span>
result = agent.run(
    <span class="hljs-string">&quot;How long would a cheetah at full speed take to run the length of Pont Alexandre III?&quot;</span>,
)`,wrap:!1}}),jl=new xT({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/building_good_agents.mdx"}}),{c(){d=t("meta"),c=M(),I=t("p"),Rl=M(),s(m.$$.fragment),Wl=M(),s(b.$$.fragment),fl=M(),k=t("p"),k.textContent=qU,vl=M(),s(u.$$.fragment),Dl=M(),s(V.$$.fragment),Yl=M(),F=t("p"),F.textContent=LU,Xl=M(),j=t("p"),j.textContent=PU,zl=M(),R=t("p"),R.innerHTML=KU,Sl=M(),B=t("p"),B.textContent=lT,Hl=M(),O=t("p"),O.textContent=UT,El=M(),Q=t("p"),Q.textContent=TT,xl=M(),G=t("ul"),G.innerHTML=JT,_l=M(),s(Z.$$.fragment),$l=M(),A=t("p"),A.innerHTML=MT,ql=M(),W=t("p"),W.textContent=eT,Ll=M(),f=t("p"),f.textContent=tT,Pl=M(),v=t("p"),v.textContent=aT,Kl=M(),D=t("p"),D.textContent=iT,lU=M(),Y=t("ul"),Y.innerHTML=sT,UU=M(),X=t("p"),X.textContent=nT,TU=M(),z=t("p"),z.textContent=yT,JU=M(),s(S.$$.fragment),MU=M(),H=t("p"),H.textContent=wT,eU=M(),E=t("ul"),E.innerHTML=CT,tU=M(),x=t("p"),x.textContent=oT,aU=M(),_=t("p"),_.textContent=dT,iU=M(),s($.$$.fragment),sU=M(),q=t("p"),q.textContent=IT,nU=M(),s(L.$$.fragment),yU=M(),P=t("p"),P.innerHTML=pT,wU=M(),s(K.$$.fragment),CU=M(),ll=t("p"),ll.innerHTML=hT,oU=M(),s(Ul.$$.fragment),dU=M(),s(Tl.$$.fragment),IU=M(),Jl=t("p"),Jl.innerHTML=gT,pU=M(),s(Ml.$$.fragment),hU=M(),el=t("p"),el.textContent=NT,gU=M(),tl=t("p"),tl.innerHTML=uT,NU=M(),s(al.$$.fragment),uU=M(),il=t("p"),il.textContent=rT,rU=M(),sl=t("p"),sl.textContent=cT,cU=M(),nl=t("p"),nl.textContent=mT,mU=M(),yl=t("p"),yl.textContent=bT,bU=M(),wl=t("ul"),wl.innerHTML=kT,kU=M(),s(Cl.$$.fragment),VU=M(),ol=t("p"),ol.textContent=VT,FU=M(),dl=t("p"),dl.innerHTML=FT,jU=M(),s(Il.$$.fragment),RU=M(),pl=t("p"),pl.textContent=jT,BU=M(),s(hl.$$.fragment),OU=M(),gl=t("p"),gl.innerHTML=RT,QU=M(),Nl=t("p"),Nl.innerHTML=BT,GU=M(),p=t("ul"),Bl=t("li"),SU=AT(`To insert tool descriptions:
	`),s(ul.$$.fragment),HU=M(),Ol=t("li"),EU=AT(`To insert the descriptions for managed agents if there are any:
	`),s(rl.$$.fragment),xU=M(),Ql=t("li"),Ql.innerHTML=OT,ZU=M(),cl=t("p"),cl.textContent=QT,AU=M(),s(ml.$$.fragment),WU=M(),bl=t("p"),bl.innerHTML=GT,fU=M(),s(kl.$$.fragment),vU=M(),Vl=t("p"),Vl.textContent=ZT,DU=M(),s(Fl.$$.fragment),YU=M(),s(jl.$$.fragment),XU=M(),Gl=t("p"),this.h()},l(l){const U=ST("svelte-u9bgzb",document.head);d=a(U,"META",{name:!0,content:!0}),U.forEach(T),c=e(l),I=a(l,"P",{}),Zl(I).forEach(T),Rl=e(l),n(m.$$.fragment,l),Wl=e(l),n(b.$$.fragment,l),fl=e(l),k=a(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-vt7d0l"&&(k.textContent=qU),vl=e(l),n(u.$$.fragment,l),Dl=e(l),n(V.$$.fragment,l),Yl=e(l),F=a(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-jydojv"&&(F.textContent=LU),Xl=e(l),j=a(l,"P",{"data-svelte-h":!0}),i(j)!=="svelte-f19v2r"&&(j.textContent=PU),zl=e(l),R=a(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-v4rmo7"&&(R.innerHTML=KU),Sl=e(l),B=a(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1265t8d"&&(B.textContent=lT),Hl=e(l),O=a(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-67t7fl"&&(O.textContent=UT),El=e(l),Q=a(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-zyva75"&&(Q.textContent=TT),xl=e(l),G=a(l,"UL",{"data-svelte-h":!0}),i(G)!=="svelte-nty9k8"&&(G.innerHTML=JT),_l=e(l),n(Z.$$.fragment,l),$l=e(l),A=a(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1xcggba"&&(A.innerHTML=MT),ql=e(l),W=a(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1bz3os9"&&(W.textContent=eT),Ll=e(l),f=a(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-kvre75"&&(f.textContent=tT),Pl=e(l),v=a(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-s4b558"&&(v.textContent=aT),Kl=e(l),D=a(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-19k59ru"&&(D.textContent=iT),lU=e(l),Y=a(l,"UL",{"data-svelte-h":!0}),i(Y)!=="svelte-sky73b"&&(Y.innerHTML=sT),UU=e(l),X=a(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1pp4kyh"&&(X.textContent=nT),TU=e(l),z=a(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-14ogt9"&&(z.textContent=yT),JU=e(l),n(S.$$.fragment,l),MU=e(l),H=a(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1invwxb"&&(H.textContent=wT),eU=e(l),E=a(l,"UL",{"data-svelte-h":!0}),i(E)!=="svelte-1vekrxk"&&(E.innerHTML=CT),tU=e(l),x=a(l,"P",{"data-svelte-h":!0}),i(x)!=="svelte-73i6xx"&&(x.textContent=oT),aU=e(l),_=a(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-np4knk"&&(_.textContent=dT),iU=e(l),n($.$$.fragment,l),sU=e(l),q=a(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-q0zmuw"&&(q.textContent=IT),nU=e(l),n(L.$$.fragment,l),yU=e(l),P=a(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-jz4g6f"&&(P.innerHTML=pT),wU=e(l),n(K.$$.fragment,l),CU=e(l),ll=a(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-usmqd6"&&(ll.innerHTML=hT),oU=e(l),n(Ul.$$.fragment,l),dU=e(l),n(Tl.$$.fragment,l),IU=e(l),Jl=a(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-jh63p8"&&(Jl.innerHTML=gT),pU=e(l),n(Ml.$$.fragment,l),hU=e(l),el=a(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-y1pddw"&&(el.textContent=NT),gU=e(l),tl=a(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-y3io9r"&&(tl.innerHTML=uT),NU=e(l),n(al.$$.fragment,l),uU=e(l),il=a(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-1b7s4xp"&&(il.textContent=rT),rU=e(l),sl=a(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-ofl7w0"&&(sl.textContent=cT),cU=e(l),nl=a(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-56ojdu"&&(nl.textContent=mT),mU=e(l),yl=a(l,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-1k3y8ke"&&(yl.textContent=bT),bU=e(l),wl=a(l,"UL",{"data-svelte-h":!0}),i(wl)!=="svelte-1eh12ms"&&(wl.innerHTML=kT),kU=e(l),n(Cl.$$.fragment,l),VU=e(l),ol=a(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-1yp27v1"&&(ol.textContent=VT),FU=e(l),dl=a(l,"P",{"data-svelte-h":!0}),i(dl)!=="svelte-15ho74p"&&(dl.innerHTML=FT),jU=e(l),n(Il.$$.fragment,l),RU=e(l),pl=a(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-174l3zr"&&(pl.textContent=jT),BU=e(l),n(hl.$$.fragment,l),OU=e(l),gl=a(l,"P",{"data-svelte-h":!0}),i(gl)!=="svelte-yb3mzp"&&(gl.innerHTML=RT),QU=e(l),Nl=a(l,"P",{"data-svelte-h":!0}),i(Nl)!=="svelte-148o4aa"&&(Nl.innerHTML=BT),GU=e(l),p=a(l,"UL",{});var g=Zl(p);Bl=a(g,"LI",{});var _U=Zl(Bl);SU=WT(_U,`To insert tool descriptions:
	`),n(ul.$$.fragment,_U),_U.forEach(T),HU=e(g),Ol=a(g,"LI",{});var $U=Zl(Ol);EU=WT($U,`To insert the descriptions for managed agents if there are any:
	`),n(rl.$$.fragment,$U),$U.forEach(T),xU=e(g),Ql=a(g,"LI",{"data-svelte-h":!0}),i(Ql)!=="svelte-1fwgx7s"&&(Ql.innerHTML=OT),g.forEach(T),ZU=e(l),cl=a(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-1gu6gc"&&(cl.textContent=QT),AU=e(l),n(ml.$$.fragment,l),WU=e(l),bl=a(l,"P",{"data-svelte-h":!0}),i(bl)!=="svelte-1hurx4n"&&(bl.innerHTML=GT),fU=e(l),n(kl.$$.fragment,l),vU=e(l),Vl=a(l,"P",{"data-svelte-h":!0}),i(Vl)!=="svelte-f8c96r"&&(Vl.textContent=ZT),DU=e(l),n(Fl.$$.fragment,l),YU=e(l),n(jl.$$.fragment,l),XU=e(l),Gl=a(l,"P",{}),Zl(Gl).forEach(T),this.h()},h(){fT(d,"name","hf:doc:metadata"),fT(d,"content",qT)},m(l,U){r(document.head,d),J(l,c,U),J(l,I,U),J(l,Rl,U),y(m,l,U),J(l,Wl,U),y(b,l,U),J(l,fl,U),J(l,k,U),J(l,vl,U),y(u,l,U),J(l,Dl,U),y(V,l,U),J(l,Yl,U),J(l,F,U),J(l,Xl,U),J(l,j,U),J(l,zl,U),J(l,R,U),J(l,Sl,U),J(l,B,U),J(l,Hl,U),J(l,O,U),J(l,El,U),J(l,Q,U),J(l,xl,U),J(l,G,U),J(l,_l,U),y(Z,l,U),J(l,$l,U),J(l,A,U),J(l,ql,U),J(l,W,U),J(l,Ll,U),J(l,f,U),J(l,Pl,U),J(l,v,U),J(l,Kl,U),J(l,D,U),J(l,lU,U),J(l,Y,U),J(l,UU,U),J(l,X,U),J(l,TU,U),J(l,z,U),J(l,JU,U),y(S,l,U),J(l,MU,U),J(l,H,U),J(l,eU,U),J(l,E,U),J(l,tU,U),J(l,x,U),J(l,aU,U),J(l,_,U),J(l,iU,U),y($,l,U),J(l,sU,U),J(l,q,U),J(l,nU,U),y(L,l,U),J(l,yU,U),J(l,P,U),J(l,wU,U),y(K,l,U),J(l,CU,U),J(l,ll,U),J(l,oU,U),y(Ul,l,U),J(l,dU,U),y(Tl,l,U),J(l,IU,U),J(l,Jl,U),J(l,pU,U),y(Ml,l,U),J(l,hU,U),J(l,el,U),J(l,gU,U),J(l,tl,U),J(l,NU,U),y(al,l,U),J(l,uU,U),J(l,il,U),J(l,rU,U),J(l,sl,U),J(l,cU,U),J(l,nl,U),J(l,mU,U),J(l,yl,U),J(l,bU,U),J(l,wl,U),J(l,kU,U),y(Cl,l,U),J(l,VU,U),J(l,ol,U),J(l,FU,U),J(l,dl,U),J(l,jU,U),y(Il,l,U),J(l,RU,U),J(l,pl,U),J(l,BU,U),y(hl,l,U),J(l,OU,U),J(l,gl,U),J(l,QU,U),J(l,Nl,U),J(l,GU,U),J(l,p,U),r(p,Bl),r(Bl,SU),y(ul,Bl,null),r(p,HU),r(p,Ol),r(Ol,EU),y(rl,Ol,null),r(p,xU),r(p,Ql),J(l,ZU,U),J(l,cl,U),J(l,AU,U),y(ml,l,U),J(l,WU,U),J(l,bl,U),J(l,fU,U),y(kl,l,U),J(l,vU,U),J(l,Vl,U),J(l,DU,U),y(Fl,l,U),J(l,YU,U),y(jl,l,U),J(l,XU,U),J(l,Gl,U),zU=!0},p(l,[U]){const g={};U&2&&(g.$$scope={dirty:U,ctx:l}),u.$set(g)},i(l){zU||(w(m.$$.fragment,l),w(b.$$.fragment,l),w(u.$$.fragment,l),w(V.$$.fragment,l),w(Z.$$.fragment,l),w(S.$$.fragment,l),w($.$$.fragment,l),w(L.$$.fragment,l),w(K.$$.fragment,l),w(Ul.$$.fragment,l),w(Tl.$$.fragment,l),w(Ml.$$.fragment,l),w(al.$$.fragment,l),w(Cl.$$.fragment,l),w(Il.$$.fragment,l),w(hl.$$.fragment,l),w(ul.$$.fragment,l),w(rl.$$.fragment,l),w(ml.$$.fragment,l),w(kl.$$.fragment,l),w(Fl.$$.fragment,l),w(jl.$$.fragment,l),zU=!0)},o(l){C(m.$$.fragment,l),C(b.$$.fragment,l),C(u.$$.fragment,l),C(V.$$.fragment,l),C(Z.$$.fragment,l),C(S.$$.fragment,l),C($.$$.fragment,l),C(L.$$.fragment,l),C(K.$$.fragment,l),C(Ul.$$.fragment,l),C(Tl.$$.fragment,l),C(Ml.$$.fragment,l),C(al.$$.fragment,l),C(Cl.$$.fragment,l),C(Il.$$.fragment,l),C(hl.$$.fragment,l),C(ul.$$.fragment,l),C(rl.$$.fragment,l),C(ml.$$.fragment,l),C(kl.$$.fragment,l),C(Fl.$$.fragment,l),C(jl.$$.fragment,l),zU=!1},d(l){l&&(T(c),T(I),T(Rl),T(Wl),T(fl),T(k),T(vl),T(Dl),T(Yl),T(F),T(Xl),T(j),T(zl),T(R),T(Sl),T(B),T(Hl),T(O),T(El),T(Q),T(xl),T(G),T(_l),T($l),T(A),T(ql),T(W),T(Ll),T(f),T(Pl),T(v),T(Kl),T(D),T(lU),T(Y),T(UU),T(X),T(TU),T(z),T(JU),T(MU),T(H),T(eU),T(E),T(tU),T(x),T(aU),T(_),T(iU),T(sU),T(q),T(nU),T(yU),T(P),T(wU),T(CU),T(ll),T(oU),T(dU),T(IU),T(Jl),T(pU),T(hU),T(el),T(gU),T(tl),T(NU),T(uU),T(il),T(rU),T(sl),T(cU),T(nl),T(mU),T(yl),T(bU),T(wl),T(kU),T(VU),T(ol),T(FU),T(dl),T(jU),T(RU),T(pl),T(BU),T(OU),T(gl),T(QU),T(Nl),T(GU),T(p),T(ZU),T(cl),T(AU),T(WU),T(bl),T(fU),T(vU),T(Vl),T(DU),T(YU),T(XU),T(Gl)),T(d),o(m,l),o(b,l),o(u,l),o(V,l),o(Z,l),o(S,l),o($,l),o(L,l),o(K,l),o(Ul,l),o(Tl,l),o(Ml,l),o(al,l),o(Cl,l),o(Il,l),o(hl,l),o(ul),o(rl),o(ml,l),o(kl,l),o(Fl,l),o(jl,l)}}}const qT='{"title":"Building good agents","local":"building-good-agents","sections":[{"title":"The best agentic systems are the simplest: simplify the workflow as much as you can","local":"the-best-agentic-systems-are-the-simplest-simplify-the-workflow-as-much-as-you-can","sections":[],"depth":3},{"title":"Improve the information flow to the LLM engine","local":"improve-the-information-flow-to-the-llm-engine","sections":[],"depth":3},{"title":"Give more arguments to the agent","local":"give-more-arguments-to-the-agent","sections":[],"depth":3},{"title":"How to debug your agent","local":"how-to-debug-your-agent","sections":[{"title":"1. Use a stronger LLM","local":"1-use-a-stronger-llm","sections":[],"depth":3},{"title":"2. Provide more guidance / more information","local":"2-provide-more-guidance--more-information","sections":[],"depth":3},{"title":"3. Change the system prompt (generally not advised)","local":"3-change-the-system-prompt-generally-not-advised","sections":[],"depth":3},{"title":"4. Extra planning","local":"4-extra-planning","sections":[],"depth":3}],"depth":2}],"depth":1}';function LT(Al){return DT(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class MJ extends XT{constructor(d){super(),zT(this,d,LT,$T,vT,{})}}export{MJ as component};
