import{s as vl,n as Ul,o as xl}from"../chunks/scheduler.39a43cde.js";import{S as $l,i as jl,g as i,s,r,A as Cl,h as o,f as l,c as a,j as Tl,u as m,x as p,k as Jl,y as Gl,a as n,v as d,d as u,t as h,w as c}from"../chunks/index.23ec2204.js";import{D as kl,C as b}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as ve}from"../chunks/Heading.c42e7061.js";function Bl(Ht){let f,$e,Ue,je,y,Ce,M,Ge,w,Rt='<em>Authored by: <a href="https://github.com/MKhalusova" rel="nofollow">Maria Khalusova</a></em>',ke,g,Wt='This notebook demonstrates how you can quickly build a RAG (Retrieval Augmented Generation) for a project’s GitHub issues using <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a> model, and LangChain.',Be,T,Xt="<strong>What is RAG?</strong>",Ze,J,Nt="RAG is a popular approach to address the issue of a powerful LLM not being aware of specific content due to said content not being in its training data, or hallucinating even when it has seen it before. Such specific content may be proprietary, sensitive, or, as in this example, recent and updated often.",_e,v,Vt="If your data is static and doesn’t change regularly, you may consider fine-tuning a large model. In many cases, however, fine-tuning can be costly, and, when done repeatedly (e.g. to address data drift), leads to “model shift”. This is when the model’s behavior changes in ways that are not desirable.",Ie,U,Ft="<strong>RAG (Retrieval Augmented Generation)</strong> does not require model fine-tuning. Instead, RAG works by providing an LLM with additional context that is retrieved from relevant data so that it can generate a better-informed response.",He,x,zt="Here’s a quick illustration:",Re,$,Lt='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/rag-diagram.png" alt="RAG diagram"/>',We,j,St="<li><p>The external data is converted into embedding vectors with a separate embeddings model, and the vectors are kept in a database. Embeddings models are typically small, so updating the embedding vectors on a regular basis is faster, cheaper, and easier than fine-tuning a model.</p></li> <li><p>At the same time, the fact that fine-tuning is not required gives you the freedom to swap your LLM for a more powerful one when it becomes available, or switch to a smaller distilled version, should you need faster inference.</p></li>",Xe,C,qt="Let’s illustrate building a RAG using an open-source LLM, embeddings model, and LangChain.",Ne,G,Et="First, install the required dependencies:",Ve,k,Fe,B,ze,Z,Le,_,Se,I,Qt='In this example, we’ll load all of the issues (both open and closed) from <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT library’s repo</a>.',qe,H,At='First, you need to acquire a <a href="https://github.com/settings/tokens?type=beta" rel="nofollow">GitHub personal access token</a> to access the GitHub API.',Ee,R,Qe,W,Yt='Next, we’ll load all of the issues in the <a href="https://github.com/huggingface/peft" rel="nofollow">huggingface/peft</a> repo:',Ae,X,Pt="<li>By default, pull requests are considered issues as well, here we chose to exclude them from data with by setting <code>include_prs=False</code></li> <li>Setting <code>state = &quot;all&quot;</code> means we will load both open and closed issues.</li>",Ye,N,Pe,V,Dt="The content of individual GitHub issues may be longer than what an embedding model can take as input. If we want to embed all of the available content, we need to chunk the documents into appropriately sized pieces.",De,F,Kt="The most common and straightforward approach to chunking is to define a fixed size of chunks and whether there should be any overlap between them. Keeping some overlap between chunks allows us to preserve some semantic context between the chunks.",Ke,z,Ot="Other approaches are typically more involved and take into account the documents’ structure and context. For example, one may want to split a document based on sentences or paragraphs, or create chunks based on the",Oe,L,el="The fixed-size chunking, however, works well for most common cases, so that is what we’ll do here.",et,S,tt,q,lt,E,tl="Now that the docs are all of the appropriate size, we can create a database with their embeddings.",nt,Q,ll='To create document chunk embeddings we’ll use the <code>HuggingFaceEmbeddings</code> and the <a href="https://huggingface.co/BAAI/bge-base-en-v1.5" rel="nofollow"><code>BAAI/bge-base-en-v1.5</code></a> embeddings model. There are many other embeddings models available on the Hub, and you can keep an eye on the best performing ones by checking the <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">Massive Text Embedding Benchmark (MTEB) Leaderboard</a>.',st,A,nl="To create the vector database, we’ll use <code>FAISS</code>, a library developed by Facebook AI. This library offers efficient similarity search and clustering of dense vectors, which is what we need here. FAISS is currently one of the most used libraries for NN search in massive datasets.",at,Y,sl="We’ll access both the embeddings model and FAISS via LangChain API.",it,P,ot,D,al="We need a way to return(retrieve) the documents given an unstructured query. For that, we’ll use the <code>as_retriever</code> method using the <code>db</code> as a backbone:",pt,K,il="<li><code>search_type=&quot;similarity&quot;</code> means we want to perform similarity search between the query and documents</li> <li><code>search_kwargs={&#39;k&#39;: 4}</code> instructs the retriever to return top 4 results.</li>",rt,O,mt,ee,ol="The vector database and retriever are now set up, next we need to set up the next piece of the chain - the model.",dt,te,ut,le,pl='For this example, we chose <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a>, a small but powerful model.',ht,ne,rl='With many models being released every week, you may want to substitute this model to the latest and greatest. The best way to keep track of open source LLMs is to check the <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open-source LLM leaderboard</a>.',ct,se,ml="To make inference faster, we will load the quantized version of the model:",bt,ae,ft,ie,yt,oe,dl="Finally, we have all the pieces we need to set up the LLM chain.",Mt,pe,ul="First, create a text_generation pipeline using the loaded model and its tokenizer.",wt,re,hl="Next, create a prompt template - this should follow the format of the model, so if you substitute the model checkpoint, make sure to use the appropriate formatting.",gt,me,Tt,de,cl="Note: <em>You can also use <code>tokenizer.apply_chat_template</code> to convert a list of messages (as dicts: <code>{&#39;role&#39;: &#39;user&#39;, &#39;content&#39;: &#39;(...)&#39;}</code>) into a string with the appropriate chat format.</em>",Jt,ue,bl="Finally, we need to combine the <code>llm_chain</code> with the retriever to create a RAG chain. We pass the original question through to the final generation step, as well as the retrieved context docs:",vt,he,Ut,ce,xt,be,fl="Let’s see the difference RAG makes in generating answers to the library-specific questions.",$t,fe,jt,ye,yl="First, let’s see what kind of answer we can get with just the model itself, no context added:",Ct,Me,Gt,we,Ml=`As you can see, the model interpreted the question as one about physical computer adapters, while in the context of PEFT, “adapters” refer to LoRA adapters.
Let’s see if adding context from GitHub issues helps the model give a more relevant answer:`,kt,ge,Bt,Te,wl="As we can see, the added context, really helps the exact same model, provide a much more relevant and informed answer to the library-specific question.",Zt,Je,gl="Notably, combining multiple adapters for inference has been added to the library, and one can find this information in the documentation, so for the next iteration of this RAG it may be worth including documentation embeddings.",_t,xe,It;return y=new kl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/rag_zephyr_langchain.ipynb"}]}}),M=new ve({props:{title:"Simple RAG for GitHub issues using Hugging Face Zephyr and LangChain",local:"simple-rag-for-github-issues-using-hugging-face-zephyr-and-langchain",headingTag:"h1"}}),k=new b({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRvcmNoJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGJpdHNhbmRieXRlcyUyMHRyYW5zZm9ybWVycyUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWdwdQ==",highlighted:"!pip install -q torch transformers accelerate bitsandbytes transformers sentence-transformers faiss-gpu",wrap:!1}}),B=new b({props:{code:"JTIzJTIwSWYlMjBydW5uaW5nJTIwaW4lMjBHb29nbGUlMjBDb2xhYiUyQyUyMHlvdSUyMG1heSUyMG5lZWQlMjB0byUyMHJ1biUyMHRoaXMlMjBjZWxsJTIwdG8lMjBtYWtlJTIwc3VyZSUyMHlvdSdyZSUyMHVzaW5nJTIwVVRGLTglMjBsb2NhbGUlMjB0byUyMGluc3RhbGwlMjBMYW5nQ2hhaW4lMEFpbXBvcnQlMjBsb2NhbGUlMEElMEFsb2NhbGUuZ2V0cHJlZmVycmVkZW5jb2RpbmclMjAlM0QlMjBsYW1iZGElM0ElMjAlMjJVVEYtOCUyMg==",highlighted:`<span class="hljs-comment"># If running in Google Colab, you may need to run this cell to make sure you&#x27;re using UTF-8 locale to install LangChain</span>
<span class="hljs-keyword">import</span> locale

locale.getpreferredencoding = <span class="hljs-keyword">lambda</span>: <span class="hljs-string">&quot;UTF-8&quot;</span>`,wrap:!1}}),Z=new b({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGxhbmdjaGFpbg==",highlighted:"!pip install -q langchain",wrap:!1}}),_=new ve({props:{title:"Prepare the data",local:"prepare-the-data",headingTag:"h2"}}),R=new b({props:{code:"ZnJvbSUyMGdldHBhc3MlMjBpbXBvcnQlMjBnZXRwYXNzJTBBJTBBQUNDRVNTX1RPS0VOJTIwJTNEJTIwZ2V0cGFzcyglMjJZT1VSX0dJVEhVQl9QRVJTT05BTF9UT0tFTiUyMik=",highlighted:`<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass

ACCESS_TOKEN = getpass(<span class="hljs-string">&quot;YOUR_GITHUB_PERSONAL_TOKEN&quot;</span>)`,wrap:!1}}),N=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2N1bWVudF9sb2FkZXJzJTIwaW1wb3J0JTIwR2l0SHViSXNzdWVzTG9hZGVyJTBBJTBBbG9hZGVyJTIwJTNEJTIwR2l0SHViSXNzdWVzTG9hZGVyKHJlcG8lM0QlMjJodWdnaW5nZmFjZSUyRnBlZnQlMjIlMkMlMjBhY2Nlc3NfdG9rZW4lM0RBQ0NFU1NfVE9LRU4lMkMlMjBpbmNsdWRlX3BycyUzREZhbHNlJTJDJTIwc3RhdGUlM0QlMjJhbGwlMjIpJTBBJTBBZG9jcyUyMCUzRCUyMGxvYWRlci5sb2FkKCk=",highlighted:`<span class="hljs-keyword">from</span> langchain.document_loaders <span class="hljs-keyword">import</span> GitHubIssuesLoader

loader = GitHubIssuesLoader(repo=<span class="hljs-string">&quot;huggingface/peft&quot;</span>, access_token=ACCESS_TOKEN, include_prs=<span class="hljs-literal">False</span>, state=<span class="hljs-string">&quot;all&quot;</span>)

docs = loader.load()`,wrap:!1}}),S=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBJTBBc3BsaXR0ZXIlMjAlM0QlMjBDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUxMiUyQyUyMGNodW5rX292ZXJsYXAlM0QzMCklMEElMEFjaHVua2VkX2RvY3MlMjAlM0QlMjBzcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoZG9jcyk=",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> CharacterTextSplitter

splitter = CharacterTextSplitter(chunk_size=<span class="hljs-number">512</span>, chunk_overlap=<span class="hljs-number">30</span>)

chunked_docs = splitter.split_documents(docs)`,wrap:!1}}),q=new ve({props:{title:"Create the embeddings + retriever",local:"create-the-embeddings--retriever",headingTag:"h2"}}),P=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW4uZW1iZWRkaW5ncyUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5ncyUwQSUwQWRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoY2h1bmtlZF9kb2NzJTJDJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmdzKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLWJhc2UtZW4tdjEuNSUyMikp",highlighted:`<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

db = FAISS.from_documents(chunked_docs, HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;BAAI/bge-base-en-v1.5&quot;</span>))`,wrap:!1}}),O=new b({props:{code:"cmV0cmlldmVyJTIwJTNEJTIwZGIuYXNfcmV0cmlldmVyKHNlYXJjaF90eXBlJTNEJTIyc2ltaWxhcml0eSUyMiUyQyUyMHNlYXJjaF9rd2FyZ3MlM0QlN0IlMjJrJTIyJTNBJTIwNCU3RCk=",highlighted:'retriever = db.as_retriever(search_type=<span class="hljs-string">&quot;similarity&quot;</span>, search_kwargs={<span class="hljs-string">&quot;k&quot;</span>: <span class="hljs-number">4</span>})',wrap:!1}}),te=new ve({props:{title:"Load quantized model",local:"load-quantized-model",headingTag:"h2"}}),ae=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiUwQSUwQWJuYl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGJuYl9jb25maWcpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig

model_name = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>, bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>, bnb_4bit_compute_dtype=torch.bfloat16
)

model = AutoModelForCausalLM.from_pretrained(model_name, quantization_config=bnb_config)
tokenizer = AutoTokenizer.from_pretrained(model_name)`,wrap:!1}}),ie=new ve({props:{title:"Setup the LLM chain",local:"setup-the-llm-chain",headingTag:"h2"}}),me=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5sbG1zJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VQaXBlbGluZSUwQWZyb20lMjBsYW5nY2hhaW4ucHJvbXB0cyUyMGltcG9ydCUyMFByb21wdFRlbXBsYXRlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMGxhbmdjaGFpbl9jb3JlLm91dHB1dF9wYXJzZXJzJTIwaW1wb3J0JTIwU3RyT3V0cHV0UGFyc2VyJTBBJTBBdGV4dF9nZW5lcmF0aW9uX3BpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMiUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjElMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZnVsbF90ZXh0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNENDAwJTJDJTBBKSUwQSUwQWxsbSUyMCUzRCUyMEh1Z2dpbmdGYWNlUGlwZWxpbmUocGlwZWxpbmUlM0R0ZXh0X2dlbmVyYXRpb25fcGlwZWxpbmUpJTBBJTBBcHJvbXB0X3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIyJTIyJTBBJTNDJTdDc3lzdGVtJTdDJTNFJTBBQW5zd2VyJTIwdGhlJTIwcXVlc3Rpb24lMjBiYXNlZCUyMG9uJTIweW91ciUyMGtub3dsZWRnZS4lMjBVc2UlMjB0aGUlMjBmb2xsb3dpbmclMjBjb250ZXh0JTIwdG8lMjBoZWxwJTNBJTBBJTBBJTdCY29udGV4dCU3RCUwQSUwQSUzQyUyRnMlM0UlMEElM0MlN0N1c2VyJTdDJTNFJTBBJTdCcXVlc3Rpb24lN0QlMEElM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBJTBBJTIwJTIyJTIyJTIyJTBBJTBBcHJvbXB0JTIwJTNEJTIwUHJvbXB0VGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwaW5wdXRfdmFyaWFibGVzJTNEJTVCJTIyY29udGV4dCUyMiUyQyUyMCUyMnF1ZXN0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGxhdGUlM0Rwcm9tcHRfdGVtcGxhdGUlMkMlMEEpJTBBJTBBbGxtX2NoYWluJTIwJTNEJTIwcHJvbXB0JTIwJTdDJTIwbGxtJTIwJTdDJTIwU3RyT3V0cHV0UGFyc2VyKCk=",highlighted:`<span class="hljs-keyword">from</span> langchain.llms <span class="hljs-keyword">import</span> HuggingFacePipeline
<span class="hljs-keyword">from</span> langchain.prompts <span class="hljs-keyword">import</span> PromptTemplate
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> langchain_core.output_parsers <span class="hljs-keyword">import</span> StrOutputParser

text_generation_pipeline = pipeline(
    model=model,
    tokenizer=tokenizer,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    temperature=<span class="hljs-number">0.2</span>,
    do_sample=<span class="hljs-literal">True</span>,
    repetition_penalty=<span class="hljs-number">1.1</span>,
    return_full_text=<span class="hljs-literal">True</span>,
    max_new_tokens=<span class="hljs-number">400</span>,
)

llm = HuggingFacePipeline(pipeline=text_generation_pipeline)

prompt_template = <span class="hljs-string">&quot;&quot;&quot;
&lt;|system|&gt;
Answer the question based on your knowledge. Use the following context to help:

{context}

&lt;/s&gt;
&lt;|user|&gt;
{question}
&lt;/s&gt;
&lt;|assistant|&gt;

 &quot;&quot;&quot;</span>

prompt = PromptTemplate(
    input_variables=[<span class="hljs-string">&quot;context&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>],
    template=prompt_template,
)

llm_chain = prompt | llm | StrOutputParser()`,wrap:!1}}),he=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb3JlLnJ1bm5hYmxlcyUyMGltcG9ydCUyMFJ1bm5hYmxlUGFzc3Rocm91Z2glMEElMEFyZXRyaWV2ZXIlMjAlM0QlMjBkYi5hc19yZXRyaWV2ZXIoKSUwQSUwQXJhZ19jaGFpbiUyMCUzRCUyMCU3QiUyMmNvbnRleHQlMjIlM0ElMjByZXRyaWV2ZXIlMkMlMjAlMjJxdWVzdGlvbiUyMiUzQSUyMFJ1bm5hYmxlUGFzc3Rocm91Z2goKSU3RCUyMCU3QyUyMGxsbV9jaGFpbg==",highlighted:`<span class="hljs-keyword">from</span> langchain_core.runnables <span class="hljs-keyword">import</span> RunnablePassthrough

retriever = db.as_retriever()

rag_chain = {<span class="hljs-string">&quot;context&quot;</span>: retriever, <span class="hljs-string">&quot;question&quot;</span>: RunnablePassthrough()} | llm_chain`,wrap:!1}}),ce=new ve({props:{title:"Compare the results",local:"compare-the-results",headingTag:"h2"}}),fe=new b({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJIb3clMjBkbyUyMHlvdSUyMGNvbWJpbmUlMjBtdWx0aXBsZSUyMGFkYXB0ZXJzJTNGJTIy",highlighted:'question = <span class="hljs-string">&quot;How do you combine multiple adapters?&quot;</span>',wrap:!1}}),Me=new b({props:{code:"bGxtX2NoYWluLmludm9rZSglN0IlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTIyJTJDJTIwJTIycXVlc3Rpb24lMjIlM0ElMjBxdWVzdGlvbiU3RCk=",highlighted:'llm_chain.invoke({<span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>: question})',wrap:!1}}),ge=new b({props:{code:"cmFnX2NoYWluLmludm9rZShxdWVzdGlvbik=",highlighted:"rag_chain.invoke(question)",wrap:!1}}),{c(){f=i("meta"),$e=s(),Ue=i("p"),je=s(),r(y.$$.fragment),Ce=s(),r(M.$$.fragment),Ge=s(),w=i("p"),w.innerHTML=Rt,ke=s(),g=i("p"),g.innerHTML=Wt,Be=s(),T=i("p"),T.innerHTML=Xt,Ze=s(),J=i("p"),J.textContent=Nt,_e=s(),v=i("p"),v.textContent=Vt,Ie=s(),U=i("p"),U.innerHTML=Ft,He=s(),x=i("p"),x.textContent=zt,Re=s(),$=i("p"),$.innerHTML=Lt,We=s(),j=i("ul"),j.innerHTML=St,Xe=s(),C=i("p"),C.textContent=qt,Ne=s(),G=i("p"),G.textContent=Et,Ve=s(),r(k.$$.fragment),Fe=s(),r(B.$$.fragment),ze=s(),r(Z.$$.fragment),Le=s(),r(_.$$.fragment),Se=s(),I=i("p"),I.innerHTML=Qt,qe=s(),H=i("p"),H.innerHTML=At,Ee=s(),r(R.$$.fragment),Qe=s(),W=i("p"),W.innerHTML=Yt,Ae=s(),X=i("ul"),X.innerHTML=Pt,Ye=s(),r(N.$$.fragment),Pe=s(),V=i("p"),V.textContent=Dt,De=s(),F=i("p"),F.textContent=Kt,Ke=s(),z=i("p"),z.textContent=Ot,Oe=s(),L=i("p"),L.textContent=el,et=s(),r(S.$$.fragment),tt=s(),r(q.$$.fragment),lt=s(),E=i("p"),E.textContent=tl,nt=s(),Q=i("p"),Q.innerHTML=ll,st=s(),A=i("p"),A.innerHTML=nl,at=s(),Y=i("p"),Y.textContent=sl,it=s(),r(P.$$.fragment),ot=s(),D=i("p"),D.innerHTML=al,pt=s(),K=i("ul"),K.innerHTML=il,rt=s(),r(O.$$.fragment),mt=s(),ee=i("p"),ee.textContent=ol,dt=s(),r(te.$$.fragment),ut=s(),le=i("p"),le.innerHTML=pl,ht=s(),ne=i("p"),ne.innerHTML=rl,ct=s(),se=i("p"),se.textContent=ml,bt=s(),r(ae.$$.fragment),ft=s(),r(ie.$$.fragment),yt=s(),oe=i("p"),oe.textContent=dl,Mt=s(),pe=i("p"),pe.textContent=ul,wt=s(),re=i("p"),re.textContent=hl,gt=s(),r(me.$$.fragment),Tt=s(),de=i("p"),de.innerHTML=cl,Jt=s(),ue=i("p"),ue.innerHTML=bl,vt=s(),r(he.$$.fragment),Ut=s(),r(ce.$$.fragment),xt=s(),be=i("p"),be.textContent=fl,$t=s(),r(fe.$$.fragment),jt=s(),ye=i("p"),ye.textContent=yl,Ct=s(),r(Me.$$.fragment),Gt=s(),we=i("p"),we.textContent=Ml,kt=s(),r(ge.$$.fragment),Bt=s(),Te=i("p"),Te.textContent=wl,Zt=s(),Je=i("p"),Je.textContent=gl,_t=s(),xe=i("p"),this.h()},l(e){const t=Cl("svelte-u9bgzb",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(l),$e=a(e),Ue=o(e,"P",{}),Tl(Ue).forEach(l),je=a(e),m(y.$$.fragment,e),Ce=a(e),m(M.$$.fragment,e),Ge=a(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-26mfp8"&&(w.innerHTML=Rt),ke=a(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1ef5fle"&&(g.innerHTML=Wt),Be=a(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1ty8bu"&&(T.innerHTML=Xt),Ze=a(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-7wteio"&&(J.textContent=Nt),_e=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1x9vu2c"&&(v.textContent=Vt),Ie=a(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-14i5lt5"&&(U.innerHTML=Ft),He=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-5qqm02"&&(x.textContent=zt),Re=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1c1z86r"&&($.innerHTML=Lt),We=a(e),j=o(e,"UL",{"data-svelte-h":!0}),p(j)!=="svelte-8anxeq"&&(j.innerHTML=St),Xe=a(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-r4q734"&&(C.textContent=qt),Ne=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1f3oki6"&&(G.textContent=Et),Ve=a(e),m(k.$$.fragment,e),Fe=a(e),m(B.$$.fragment,e),ze=a(e),m(Z.$$.fragment,e),Le=a(e),m(_.$$.fragment,e),Se=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1htvfcb"&&(I.innerHTML=Qt),qe=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1y7zwpt"&&(H.innerHTML=At),Ee=a(e),m(R.$$.fragment,e),Qe=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1sitgme"&&(W.innerHTML=Yt),Ae=a(e),X=o(e,"UL",{"data-svelte-h":!0}),p(X)!=="svelte-ktvuvk"&&(X.innerHTML=Pt),Ye=a(e),m(N.$$.fragment,e),Pe=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-oungvg"&&(V.textContent=Dt),De=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1c4l20y"&&(F.textContent=Kt),Ke=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-r5k8di"&&(z.textContent=Ot),Oe=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1u7b0nv"&&(L.textContent=el),et=a(e),m(S.$$.fragment,e),tt=a(e),m(q.$$.fragment,e),lt=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1ng4z3s"&&(E.textContent=tl),nt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-z63x34"&&(Q.innerHTML=ll),st=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1hq28ne"&&(A.innerHTML=nl),at=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1n2sms8"&&(Y.textContent=sl),it=a(e),m(P.$$.fragment,e),ot=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-140j4it"&&(D.innerHTML=al),pt=a(e),K=o(e,"UL",{"data-svelte-h":!0}),p(K)!=="svelte-hejw60"&&(K.innerHTML=il),rt=a(e),m(O.$$.fragment,e),mt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-4c9ypi"&&(ee.textContent=ol),dt=a(e),m(te.$$.fragment,e),ut=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1fynfov"&&(le.innerHTML=pl),ht=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-gklra8"&&(ne.innerHTML=rl),ct=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1bs26eu"&&(se.textContent=ml),bt=a(e),m(ae.$$.fragment,e),ft=a(e),m(ie.$$.fragment,e),yt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-dvcewb"&&(oe.textContent=dl),Mt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-8iwm5k"&&(pe.textContent=ul),wt=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-qz9rvk"&&(re.textContent=hl),gt=a(e),m(me.$$.fragment,e),Tt=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-15zr00j"&&(de.innerHTML=cl),Jt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1plvon"&&(ue.innerHTML=bl),vt=a(e),m(he.$$.fragment,e),Ut=a(e),m(ce.$$.fragment,e),xt=a(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-1m90it0"&&(be.textContent=fl),$t=a(e),m(fe.$$.fragment,e),jt=a(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1m8rs90"&&(ye.textContent=yl),Ct=a(e),m(Me.$$.fragment,e),Gt=a(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-10i2mx0"&&(we.textContent=Ml),kt=a(e),m(ge.$$.fragment,e),Bt=a(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1gvzgod"&&(Te.textContent=wl),Zt=a(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-rlk7jz"&&(Je.textContent=gl),_t=a(e),xe=o(e,"P",{}),Tl(xe).forEach(l),this.h()},h(){Jl(f,"name","hf:doc:metadata"),Jl(f,"content",Zl)},m(e,t){Gl(document.head,f),n(e,$e,t),n(e,Ue,t),n(e,je,t),d(y,e,t),n(e,Ce,t),d(M,e,t),n(e,Ge,t),n(e,w,t),n(e,ke,t),n(e,g,t),n(e,Be,t),n(e,T,t),n(e,Ze,t),n(e,J,t),n(e,_e,t),n(e,v,t),n(e,Ie,t),n(e,U,t),n(e,He,t),n(e,x,t),n(e,Re,t),n(e,$,t),n(e,We,t),n(e,j,t),n(e,Xe,t),n(e,C,t),n(e,Ne,t),n(e,G,t),n(e,Ve,t),d(k,e,t),n(e,Fe,t),d(B,e,t),n(e,ze,t),d(Z,e,t),n(e,Le,t),d(_,e,t),n(e,Se,t),n(e,I,t),n(e,qe,t),n(e,H,t),n(e,Ee,t),d(R,e,t),n(e,Qe,t),n(e,W,t),n(e,Ae,t),n(e,X,t),n(e,Ye,t),d(N,e,t),n(e,Pe,t),n(e,V,t),n(e,De,t),n(e,F,t),n(e,Ke,t),n(e,z,t),n(e,Oe,t),n(e,L,t),n(e,et,t),d(S,e,t),n(e,tt,t),d(q,e,t),n(e,lt,t),n(e,E,t),n(e,nt,t),n(e,Q,t),n(e,st,t),n(e,A,t),n(e,at,t),n(e,Y,t),n(e,it,t),d(P,e,t),n(e,ot,t),n(e,D,t),n(e,pt,t),n(e,K,t),n(e,rt,t),d(O,e,t),n(e,mt,t),n(e,ee,t),n(e,dt,t),d(te,e,t),n(e,ut,t),n(e,le,t),n(e,ht,t),n(e,ne,t),n(e,ct,t),n(e,se,t),n(e,bt,t),d(ae,e,t),n(e,ft,t),d(ie,e,t),n(e,yt,t),n(e,oe,t),n(e,Mt,t),n(e,pe,t),n(e,wt,t),n(e,re,t),n(e,gt,t),d(me,e,t),n(e,Tt,t),n(e,de,t),n(e,Jt,t),n(e,ue,t),n(e,vt,t),d(he,e,t),n(e,Ut,t),d(ce,e,t),n(e,xt,t),n(e,be,t),n(e,$t,t),d(fe,e,t),n(e,jt,t),n(e,ye,t),n(e,Ct,t),d(Me,e,t),n(e,Gt,t),n(e,we,t),n(e,kt,t),d(ge,e,t),n(e,Bt,t),n(e,Te,t),n(e,Zt,t),n(e,Je,t),n(e,_t,t),n(e,xe,t),It=!0},p:Ul,i(e){It||(u(y.$$.fragment,e),u(M.$$.fragment,e),u(k.$$.fragment,e),u(B.$$.fragment,e),u(Z.$$.fragment,e),u(_.$$.fragment,e),u(R.$$.fragment,e),u(N.$$.fragment,e),u(S.$$.fragment,e),u(q.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(me.$$.fragment,e),u(he.$$.fragment,e),u(ce.$$.fragment,e),u(fe.$$.fragment,e),u(Me.$$.fragment,e),u(ge.$$.fragment,e),It=!0)},o(e){h(y.$$.fragment,e),h(M.$$.fragment,e),h(k.$$.fragment,e),h(B.$$.fragment,e),h(Z.$$.fragment,e),h(_.$$.fragment,e),h(R.$$.fragment,e),h(N.$$.fragment,e),h(S.$$.fragment,e),h(q.$$.fragment,e),h(P.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(me.$$.fragment,e),h(he.$$.fragment,e),h(ce.$$.fragment,e),h(fe.$$.fragment,e),h(Me.$$.fragment,e),h(ge.$$.fragment,e),It=!1},d(e){e&&(l($e),l(Ue),l(je),l(Ce),l(Ge),l(w),l(ke),l(g),l(Be),l(T),l(Ze),l(J),l(_e),l(v),l(Ie),l(U),l(He),l(x),l(Re),l($),l(We),l(j),l(Xe),l(C),l(Ne),l(G),l(Ve),l(Fe),l(ze),l(Le),l(Se),l(I),l(qe),l(H),l(Ee),l(Qe),l(W),l(Ae),l(X),l(Ye),l(Pe),l(V),l(De),l(F),l(Ke),l(z),l(Oe),l(L),l(et),l(tt),l(lt),l(E),l(nt),l(Q),l(st),l(A),l(at),l(Y),l(it),l(ot),l(D),l(pt),l(K),l(rt),l(mt),l(ee),l(dt),l(ut),l(le),l(ht),l(ne),l(ct),l(se),l(bt),l(ft),l(yt),l(oe),l(Mt),l(pe),l(wt),l(re),l(gt),l(Tt),l(de),l(Jt),l(ue),l(vt),l(Ut),l(xt),l(be),l($t),l(jt),l(ye),l(Ct),l(Gt),l(we),l(kt),l(Bt),l(Te),l(Zt),l(Je),l(_t),l(xe)),l(f),c(y,e),c(M,e),c(k,e),c(B,e),c(Z,e),c(_,e),c(R,e),c(N,e),c(S,e),c(q,e),c(P,e),c(O,e),c(te,e),c(ae,e),c(ie,e),c(me,e),c(he,e),c(ce,e),c(fe,e),c(Me,e),c(ge,e)}}}const Zl='{"title":"Simple RAG for GitHub issues using Hugging Face Zephyr and LangChain","local":"simple-rag-for-github-issues-using-hugging-face-zephyr-and-langchain","sections":[{"title":"Prepare the data","local":"prepare-the-data","sections":[],"depth":2},{"title":"Create the embeddings + retriever","local":"create-the-embeddings--retriever","sections":[],"depth":2},{"title":"Load quantized model","local":"load-quantized-model","sections":[],"depth":2},{"title":"Setup the LLM chain","local":"setup-the-llm-chain","sections":[],"depth":2},{"title":"Compare the results","local":"compare-the-results","sections":[],"depth":2}],"depth":1}';function _l(Ht){return xl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xl extends $l{constructor(f){super(),jl(this,f,_l,Bl,vl,{})}}export{Xl as component};
