import{s as yt,o as $t,n as We}from"../chunks/scheduler.d6170356.js";import{S as jt,i as vt,g as o,s as l,r as h,A as _t,h as p,f as s,c as n,j as Mt,u as d,x as r,k as Tt,y as Jt,a,v as f,d as m,t as g,w}from"../chunks/index.fcd4cc08.js";import{T as Pe}from"../chunks/Tip.b09c67cf.js";import{C as bt}from"../chunks/CodeBlock.db16bf50.js";import{H as ae,E as Ut}from"../chunks/index.9f2da87a.js";function Ct(T){let i,u='This guide will take you through the process of integrating a <em>Sign-In with HF</em> button into any Space. If you’re seeking a fast and simple method to implement this in a <strong>Gradio</strong> Space, take a look at its <a href="https://www.gradio.app/guides/sharing-your-app#o-auth-login-via-hugging-face" rel="nofollow">built-in integration</a>.';return{c(){i=o("p"),i.innerHTML=u},l(c){i=p(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1nqltc0"&&(i.innerHTML=u)},m(c,M){a(c,i,M)},p:We,d(c){c&&s(i)}}}function It(T){let i,u='You can also use the HF OAuth flow to create a “Sign in with HF” flow in any website or App, outside of Spaces. <a href="./oauth">Read our general OAuth page</a>.';return{c(){i=o("p"),i.innerHTML=u},l(c){i=p(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-138wjpm"&&(i.innerHTML=u)},m(c,M){a(c,i,M)},p:We,d(c){c&&s(i)}}}function Ht(T){let i,u="You should use <code>target=_blank</code> on the button to open the sign-in page in a new tab, unless you run the space outside its <code>iframe</code>. Otherwise, you might encounter issues with cookies on some browsers.";return{c(){i=o("p"),i.innerHTML=u},l(c){i=p(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-9c51kn"&&(i.innerHTML=u)},m(c,M){a(c,i,M)},p:We,d(c){c&&s(i)}}}function St(T){let i,u,c,M,j,ne,v,Fe='You can enable a built-in sign-in flow in your Space by seamlessly creating and associating an <a href="https://developer.okta.com/blog/2019/10/21/illustrated-guide-to-oauth-and-oidc" rel="nofollow">OAuth/OpenID connect</a> app so users can log in with their HF account.',ie,_,Ne='This enables new use cases for your Space. For instance, when combined with <a href="https://huggingface.co/docs/hub/spaces-storage" rel="nofollow">Persistent Storage</a>, a generative AI Space could allow users to log in to access their previous generations, only accessible to them.',oe,b,pe,y,re,J,ce,U,Oe="All you need to do is add <code>hf_oauth: true</code> to your Space’s metadata inside your <code>README.md</code> file.",ue,C,Ye="Here’s an example of metadata for a Gradio Space:",he,I,de,H,Ve='You can check out the <a href="./spaces-config-reference">configuration reference docs</a> for more information.',fe,S,Qe='This will add the following <a href="https://huggingface.co/docs/hub/spaces-overview#helper-environment-variables" rel="nofollow">environment variables</a> to your space:',me,L,qe='<li><code>OAUTH_CLIENT_ID</code>: the client ID of your OAuth app (public)</li> <li><code>OAUTH_CLIENT_SECRET</code>: the client secret of your OAuth app</li> <li><code>OAUTH_SCOPES</code>: scopes accessible by your OAuth app.</li> <li><code>OPENID_PROVIDER_URL</code>: The URL of the OpenID provider. The OpenID metadata will be available at <a href="https://huggingface.co/.well-known/openid-configuration" rel="nofollow"><code>{OPENID_PROVIDER_URL}/.well-known/openid-configuration</code></a>.</li>',ge,G,De="As for any other environment variable, you can use them in your code by using <code>os.getenv(&quot;OAUTH_CLIENT_ID&quot;)</code>, for example.",we,x,Me,E,Ke="You can use any redirect URL you want, as long as it targets your Space.",Te,k,et='Note that <code>SPACE_HOST</code> is <a href="https://huggingface.co/docs/hub/spaces-overview#helper-environment-variables" rel="nofollow">available</a> as an environment variable.',be,R,tt="For example, you can use <code>https://{SPACE_HOST}/login/callback</code> as a redirect URI.",ye,B,$e,Z,st="The following scopes are always included for Spaces:",je,A,at="<li><code>openid</code>: Get the ID token in addition to the access token.</li> <li><code>profile</code>: Get the user’s profile information (username, avatar, etc.)</li>",ve,X,lt="Those scopes are optional and can be added by setting <code>hf_oauth_scopes</code> in your Space’s metadata:",_e,z,nt='<li><code>email</code>: Get the user’s email address.</li> <li><code>read-billing</code>: Know whether the user has a payment method set up.</li> <li><code>read-repos</code>: Get read access to the user’s personal repos.</li> <li><code>write-repos</code>: Get write/read access to the user’s personal repos.</li> <li><code>manage-repos</code>: Get full access to the user’s personal repos. Also grants repo creation and deletion.</li> <li><code>inference-api</code>: Get access to the <a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">Inference API</a>, you will be able to make inference requests on behalf of the user.</li> <li><code>write-discussions</code>: Open discussions and Pull Requests on behalf of the user as well as interact with discussions (including reactions, posting/editing comments, closing discussions, …). To open Pull Requests on private repos, you need to request the <code>read-repos</code> scope as well.</li>',Je,P,Ue,W,it="By default, the oauth app does not need to access organization resources.",Ce,F,ot="But some scopes like <code>read-repos</code> or <code>read-billing</code> apply to organizations as well.",Ie,N,pt="The user can select which organizations to grant access to when authorizing the app. If you require access to a specific organization, you can add <code>orgIds=ORG_ID</code> as a query parameter to the OAuth authorization URL. You have to replace <code>ORG_ID</code> with the organization ID, which is available in the <code>organizations.sub</code> field of the userinfo response.",He,O,Se,Y,rt='You now have all the information to add a “Sign-in with HF” button to your Space. Some libraries (<a href="https://github.com/lepture/authlib" rel="nofollow">Python</a>, <a href="https://github.com/panva/node-openid-client" rel="nofollow">NodeJS</a>) can help you implement the OpenID/OAuth protocol.',Le,V,ct='Gradio and huggingface.js also provide <strong>built-in support</strong>, making implementing the Sign-in with HF button a breeze; you can check out the associated guides with <a href="https://www.gradio.app/guides/sharing-your-app#o-auth-login-via-hugging-face" rel="nofollow">gradio</a> and with <a href="https://huggingface.co/docs/huggingface.js/hub/README#oauth-login" rel="nofollow">huggingface.js</a>.',Ge,Q,ut="Basically, you need to:",xe,q,ht="<li>Redirect the user to <code>https://huggingface.co/oauth/authorize?redirect_uri={REDIRECT_URI}&amp;scope=openid%20profile&amp;client_id={CLIENT_ID}&amp;state={STATE}</code>, where <code>STATE</code> is a random string that you will need to verify later.</li> <li>Handle the callback on <code>/auth/callback</code> or <code>/login/callback</code> (or your own custom callback URL) and verify the <code>state</code> parameter.</li> <li>Use the <code>code</code> query parameter to get an access token and id token from <code>https://huggingface.co/oauth/token</code> (POST request with <code>client_id</code>, <code>code</code>, <code>grant_type=authorization_code</code> and <code>redirect_uri</code> as form data, and with <code>Authorization: Basic {base64(client_id:client_secret)}</code> as a header).</li>",Ee,$,ke,D,Re,K,dt='<li><a href="https://huggingface.co/spaces/Wauplin/gradio-oauth-test" rel="nofollow">Gradio test app</a></li> <li><a href="https://huggingface.co/spaces/huggingchat/chat-ui" rel="nofollow">Hugging Chat (NodeJS/SvelteKit)</a></li> <li><a href="https://huggingface.co/spaces/huggingfacejs/inference-widgets" rel="nofollow">Inference Widgets (Auth.js/SvelteKit)</a>, uses the <code>inference-api</code> scope to make inference requests on behalf of the user.</li> <li><a href="https://huggingface.co/spaces/huggingfacejs/client-side-oauth" rel="nofollow">Client-Side in a Static Space (huggingface.js)</a> - very simple JavaScript example.</li>',Be,ee,ft="JS Code example:",Ze,te,Ae,se,Xe,le,ze;return j=new ae({props:{title:"Adding a Sign-In with HF button to your Space",local:"adding-a-sign-in-with-hf-button-to-your-space",headingTag:"h1"}}),b=new Pe({props:{$$slots:{default:[Ct]},$$scope:{ctx:T}}}),y=new Pe({props:{$$slots:{default:[It]},$$scope:{ctx:T}}}),J=new ae({props:{title:"Create an OAuth app",local:"create-an-oauth-app",headingTag:"h2"}}),I=new bt({props:{code:"dGl0bGUlM0ElMjBHcmFkaW8lMjBPYXV0aCUyMFRlc3QlMEFlbW9qaSUzQSUyMCVGMCU5RiU4RiU4NiUwQWNvbG9yRnJvbSUzQSUyMHBpbmslMEFjb2xvclRvJTNBJTIwcGluayUwQXNkayUzQSUyMGdyYWRpbyUwQXNka192ZXJzaW9uJTNBJTIwMy40MC4wJTBBcHl0aG9uX3ZlcnNpb24lM0ElMjAzLjEwLjYlMEFhcHBfZmlsZSUzQSUyMGFwcC5weSUwQSUwQWhmX29hdXRoJTNBJTIwdHJ1ZSUwQSUyMyUyMG9wdGlvbmFsJTJDJTIwZGVmYXVsdCUyMGR1cmF0aW9uJTIwaXMlMjA4JTIwaG91cnMlMkY0ODAlMjBtaW51dGVzLiUyME1heCUyMGR1cmF0aW9uJTIwaXMlMjAzMCUyMGRheXMlMkY0MzIwMCUyMG1pbnV0ZXMuJTBBaGZfb2F1dGhfZXhwaXJhdGlvbl9taW51dGVzJTNBJTIwNDgwJTBBJTIzJTIwb3B0aW9uYWwlMkMlMjBzZWUlMjAlMjJTY29wZXMlMjIlMjBiZWxvdy4lMjAlMjJvcGVuaWQlMjBwcm9maWxlJTIyJTIwaXMlMjBhbHdheXMlMjBpbmNsdWRlZC4lMEFoZl9vYXV0aF9zY29wZXMlM0ElMEElMjAtJTIwcmVhZC1yZXBvcyUwQSUyMC0lMjB3cml0ZS1yZXBvcyUwQSUyMC0lMjBtYW5hZ2UtcmVwb3MlMEElMjAtJTIwaW5mZXJlbmNlLWFwaSUwQSUyMyUyMG9wdGlvbmFsJTJDJTIwcmVzdHJpY3QlMjBhY2Nlc3MlMjB0byUyMG1lbWJlcnMlMjBvZiUyMHNwZWNpZmljJTIwb3JnYW5pemF0aW9ucyUwQWhmX29hdXRoX2F1dGhvcml6ZWRfb3JnJTNBJTIwT1JHX05BTUUlMEFoZl9vYXV0aF9hdXRob3JpemVkX29yZyUzQSUwQSUyMCUyMC0lMjBPUkdfTkFNRTElMEElMjAlMjAtJTIwT1JHX05BTUUy",highlighted:`<span class="hljs-attr">title:</span> <span class="hljs-string">Gradio</span> <span class="hljs-string">Oauth</span> <span class="hljs-string">Test</span>
<span class="hljs-attr">emoji:</span> <span class="hljs-string">🏆</span>
<span class="hljs-attr">colorFrom:</span> <span class="hljs-string">pink</span>
<span class="hljs-attr">colorTo:</span> <span class="hljs-string">pink</span>
<span class="hljs-attr">sdk:</span> <span class="hljs-string">gradio</span>
<span class="hljs-attr">sdk_version:</span> <span class="hljs-number">3.40</span><span class="hljs-number">.0</span>
<span class="hljs-attr">python_version:</span> <span class="hljs-number">3.10</span><span class="hljs-number">.6</span>
<span class="hljs-attr">app_file:</span> <span class="hljs-string">app.py</span>

<span class="hljs-attr">hf_oauth:</span> <span class="hljs-literal">true</span>
<span class="hljs-comment"># optional, default duration is 8 hours/480 minutes. Max duration is 30 days/43200 minutes.</span>
<span class="hljs-attr">hf_oauth_expiration_minutes:</span> <span class="hljs-number">480</span>
<span class="hljs-comment"># optional, see &quot;Scopes&quot; below. &quot;openid profile&quot; is always included.</span>
<span class="hljs-attr">hf_oauth_scopes:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">read-repos</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">write-repos</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">manage-repos</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">inference-api</span>
<span class="hljs-comment"># optional, restrict access to members of specific organizations</span>
<span class="hljs-attr">hf_oauth_authorized_org:</span> <span class="hljs-string">ORG_NAME</span>
<span class="hljs-attr">hf_oauth_authorized_org:</span>
  <span class="hljs-bullet">-</span> <span class="hljs-string">ORG_NAME1</span>
  <span class="hljs-bullet">-</span> <span class="hljs-string">ORG_NAME2</span>`,wrap:!1}}),x=new ae({props:{title:"Redirect URLs",local:"redirect-urls",headingTag:"h2"}}),B=new ae({props:{title:"Scopes",local:"scopes",headingTag:"h2"}}),P=new ae({props:{title:"Accessing organization resources",local:"accessing-organization-resources",headingTag:"h2"}}),O=new ae({props:{title:"Adding the button to your Space",local:"adding-the-button-to-your-space",headingTag:"h2"}}),$=new Pe({props:{warning:!0,$$slots:{default:[Ht]},$$scope:{ctx:T}}}),D=new ae({props:{title:"Examples:",local:"examples",headingTag:"h2"}}),te=new bt({props:{code:"aW1wb3J0JTIwJTdCJTIwb2F1dGhMb2dpblVybCUyQyUyMG9hdXRoSGFuZGxlUmVkaXJlY3RJZlByZXNlbnQlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEElMEFjb25zdCUyMG9hdXRoUmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBvYXV0aEhhbmRsZVJlZGlyZWN0SWZQcmVzZW50KCklM0IlMEElMEFpZiUyMCghb2F1dGhSZXN1bHQpJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwSWYlMjB0aGUlMjB1c2VyJTIwaXMlMjBub3QlMjBsb2dnZWQlMjBpbiUyQyUyMHJlZGlyZWN0JTIwdG8lMjB0aGUlMjBsb2dpbiUyMHBhZ2UlMEElMjAlMjB3aW5kb3cubG9jYXRpb24uaHJlZiUyMCUzRCUyMGF3YWl0JTIwb2F1dGhMb2dpblVybCgpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwWW91JTIwY2FuJTIwdXNlJTIwb2F1dGhSZXN1bHQuYWNjZXNzVG9rZW4lMkMlMjBvYXV0aFJlc3VsdC51c2VySW5mbyUyMGFtb25nJTIwb3RoZXIlMjB0aGluZ3MlMEFjb25zb2xlLmxvZyhvYXV0aFJlc3VsdCklM0I=",highlighted:`<span class="hljs-keyword">import</span> { oauthLoginUrl, oauthHandleRedirectIfPresent } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> oauthResult = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthHandleRedirectIfPresent</span>();

<span class="hljs-keyword">if</span> (!oauthResult) {
  <span class="hljs-comment">// If the user is not logged in, redirect to the login page</span>
  <span class="hljs-variable language_">window</span>.<span class="hljs-property">location</span>.<span class="hljs-property">href</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthLoginUrl</span>();
}

<span class="hljs-comment">// You can use oauthResult.accessToken, oauthResult.userInfo among other things</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(oauthResult);`,wrap:!1}}),se=new Ut({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/spaces-oauth.md"}}),{c(){i=o("meta"),u=l(),c=o("p"),M=l(),h(j.$$.fragment),ne=l(),v=o("p"),v.innerHTML=Fe,ie=l(),_=o("p"),_.innerHTML=Ne,oe=l(),h(b.$$.fragment),pe=l(),h(y.$$.fragment),re=l(),h(J.$$.fragment),ce=l(),U=o("p"),U.innerHTML=Oe,ue=l(),C=o("p"),C.textContent=Ye,he=l(),h(I.$$.fragment),de=l(),H=o("p"),H.innerHTML=Ve,fe=l(),S=o("p"),S.innerHTML=Qe,me=l(),L=o("ul"),L.innerHTML=qe,ge=l(),G=o("p"),G.innerHTML=De,we=l(),h(x.$$.fragment),Me=l(),E=o("p"),E.textContent=Ke,Te=l(),k=o("p"),k.innerHTML=et,be=l(),R=o("p"),R.innerHTML=tt,ye=l(),h(B.$$.fragment),$e=l(),Z=o("p"),Z.textContent=st,je=l(),A=o("ul"),A.innerHTML=at,ve=l(),X=o("p"),X.innerHTML=lt,_e=l(),z=o("ul"),z.innerHTML=nt,Je=l(),h(P.$$.fragment),Ue=l(),W=o("p"),W.textContent=it,Ce=l(),F=o("p"),F.innerHTML=ot,Ie=l(),N=o("p"),N.innerHTML=pt,He=l(),h(O.$$.fragment),Se=l(),Y=o("p"),Y.innerHTML=rt,Le=l(),V=o("p"),V.innerHTML=ct,Ge=l(),Q=o("p"),Q.textContent=ut,xe=l(),q=o("ul"),q.innerHTML=ht,Ee=l(),h($.$$.fragment),ke=l(),h(D.$$.fragment),Re=l(),K=o("ul"),K.innerHTML=dt,Be=l(),ee=o("p"),ee.textContent=ft,Ze=l(),h(te.$$.fragment),Ae=l(),h(se.$$.fragment),Xe=l(),le=o("p"),this.h()},l(e){const t=_t("svelte-u9bgzb",document.head);i=p(t,"META",{name:!0,content:!0}),t.forEach(s),u=n(e),c=p(e,"P",{}),Mt(c).forEach(s),M=n(e),d(j.$$.fragment,e),ne=n(e),v=p(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1nfjaew"&&(v.innerHTML=Fe),ie=n(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1t83yje"&&(_.innerHTML=Ne),oe=n(e),d(b.$$.fragment,e),pe=n(e),d(y.$$.fragment,e),re=n(e),d(J.$$.fragment,e),ce=n(e),U=p(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1u00faw"&&(U.innerHTML=Oe),ue=n(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-vlpqut"&&(C.textContent=Ye),he=n(e),d(I.$$.fragment,e),de=n(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-ml9rcy"&&(H.innerHTML=Ve),fe=n(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-12m1u10"&&(S.innerHTML=Qe),me=n(e),L=p(e,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-k73zcv"&&(L.innerHTML=qe),ge=n(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-qqxlx3"&&(G.innerHTML=De),we=n(e),d(x.$$.fragment,e),Me=n(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-eoih5g"&&(E.textContent=Ke),Te=n(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1a014a5"&&(k.innerHTML=et),be=n(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-4fyftp"&&(R.innerHTML=tt),ye=n(e),d(B.$$.fragment,e),$e=n(e),Z=p(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-sd96qs"&&(Z.textContent=st),je=n(e),A=p(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-3wn6r0"&&(A.innerHTML=at),ve=n(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-181zoj"&&(X.innerHTML=lt),_e=n(e),z=p(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-1m84wi9"&&(z.innerHTML=nt),Je=n(e),d(P.$$.fragment,e),Ue=n(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-10n2v6"&&(W.textContent=it),Ce=n(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-zh86jr"&&(F.innerHTML=ot),Ie=n(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-99lcmx"&&(N.innerHTML=pt),He=n(e),d(O.$$.fragment,e),Se=n(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1a3vuj4"&&(Y.innerHTML=rt),Le=n(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1k7h2p0"&&(V.innerHTML=ct),Ge=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-g0kxak"&&(Q.textContent=ut),xe=n(e),q=p(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-159xo4d"&&(q.innerHTML=ht),Ee=n(e),d($.$$.fragment,e),ke=n(e),d(D.$$.fragment,e),Re=n(e),K=p(e,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-lipo2y"&&(K.innerHTML=dt),Be=n(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1g8zr10"&&(ee.textContent=ft),Ze=n(e),d(te.$$.fragment,e),Ae=n(e),d(se.$$.fragment,e),Xe=n(e),le=p(e,"P",{}),Mt(le).forEach(s),this.h()},h(){Tt(i,"name","hf:doc:metadata"),Tt(i,"content",Lt)},m(e,t){Jt(document.head,i),a(e,u,t),a(e,c,t),a(e,M,t),f(j,e,t),a(e,ne,t),a(e,v,t),a(e,ie,t),a(e,_,t),a(e,oe,t),f(b,e,t),a(e,pe,t),f(y,e,t),a(e,re,t),f(J,e,t),a(e,ce,t),a(e,U,t),a(e,ue,t),a(e,C,t),a(e,he,t),f(I,e,t),a(e,de,t),a(e,H,t),a(e,fe,t),a(e,S,t),a(e,me,t),a(e,L,t),a(e,ge,t),a(e,G,t),a(e,we,t),f(x,e,t),a(e,Me,t),a(e,E,t),a(e,Te,t),a(e,k,t),a(e,be,t),a(e,R,t),a(e,ye,t),f(B,e,t),a(e,$e,t),a(e,Z,t),a(e,je,t),a(e,A,t),a(e,ve,t),a(e,X,t),a(e,_e,t),a(e,z,t),a(e,Je,t),f(P,e,t),a(e,Ue,t),a(e,W,t),a(e,Ce,t),a(e,F,t),a(e,Ie,t),a(e,N,t),a(e,He,t),f(O,e,t),a(e,Se,t),a(e,Y,t),a(e,Le,t),a(e,V,t),a(e,Ge,t),a(e,Q,t),a(e,xe,t),a(e,q,t),a(e,Ee,t),f($,e,t),a(e,ke,t),f(D,e,t),a(e,Re,t),a(e,K,t),a(e,Be,t),a(e,ee,t),a(e,Ze,t),f(te,e,t),a(e,Ae,t),f(se,e,t),a(e,Xe,t),a(e,le,t),ze=!0},p(e,[t]){const mt={};t&2&&(mt.$$scope={dirty:t,ctx:e}),b.$set(mt);const gt={};t&2&&(gt.$$scope={dirty:t,ctx:e}),y.$set(gt);const wt={};t&2&&(wt.$$scope={dirty:t,ctx:e}),$.$set(wt)},i(e){ze||(m(j.$$.fragment,e),m(b.$$.fragment,e),m(y.$$.fragment,e),m(J.$$.fragment,e),m(I.$$.fragment,e),m(x.$$.fragment,e),m(B.$$.fragment,e),m(P.$$.fragment,e),m(O.$$.fragment,e),m($.$$.fragment,e),m(D.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),ze=!0)},o(e){g(j.$$.fragment,e),g(b.$$.fragment,e),g(y.$$.fragment,e),g(J.$$.fragment,e),g(I.$$.fragment,e),g(x.$$.fragment,e),g(B.$$.fragment,e),g(P.$$.fragment,e),g(O.$$.fragment,e),g($.$$.fragment,e),g(D.$$.fragment,e),g(te.$$.fragment,e),g(se.$$.fragment,e),ze=!1},d(e){e&&(s(u),s(c),s(M),s(ne),s(v),s(ie),s(_),s(oe),s(pe),s(re),s(ce),s(U),s(ue),s(C),s(he),s(de),s(H),s(fe),s(S),s(me),s(L),s(ge),s(G),s(we),s(Me),s(E),s(Te),s(k),s(be),s(R),s(ye),s($e),s(Z),s(je),s(A),s(ve),s(X),s(_e),s(z),s(Je),s(Ue),s(W),s(Ce),s(F),s(Ie),s(N),s(He),s(Se),s(Y),s(Le),s(V),s(Ge),s(Q),s(xe),s(q),s(Ee),s(ke),s(Re),s(K),s(Be),s(ee),s(Ze),s(Ae),s(Xe),s(le)),s(i),w(j,e),w(b,e),w(y,e),w(J,e),w(I,e),w(x,e),w(B,e),w(P,e),w(O,e),w($,e),w(D,e),w(te,e),w(se,e)}}}const Lt='{"title":"Adding a Sign-In with HF button to your Space","local":"adding-a-sign-in-with-hf-button-to-your-space","sections":[{"title":"Create an OAuth app","local":"create-an-oauth-app","sections":[],"depth":2},{"title":"Redirect URLs","local":"redirect-urls","sections":[],"depth":2},{"title":"Scopes","local":"scopes","sections":[],"depth":2},{"title":"Accessing organization resources","local":"accessing-organization-resources","sections":[],"depth":2},{"title":"Adding the button to your Space","local":"adding-the-button-to-your-space","sections":[],"depth":2},{"title":"Examples:","local":"examples","sections":[],"depth":2}],"depth":1}';function Gt(T){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zt extends jt{constructor(i){super(),vt(this,i,Gt,St,yt,{})}}export{Zt as component};
