import{s as He,n as We,o as Xe}from"../chunks/scheduler.d6170356.js";import{S as Ee,i as Fe,g as i,s as a,r as m,A as ze,h as o,f as l,c as n,j as Re,u as r,x as h,k as Be,y as Le,a as s,v as p,d as c,t as d,w as M}from"../chunks/index.fcd4cc08.js";import{C as Te}from"../chunks/CodeBlock.db16bf50.js";import{H as w,E as Qe}from"../chunks/index.9f2da87a.js";function Ye(Je){let g,N,Q,V,y,A,f,be='<a href="https://github.com/riccardomusmeci/mlx-image" rel="nofollow"><code>mlx-image</code></a> is an image models library developed by <a href="https://github.com/riccardomusmeci" rel="nofollow">Riccardo Musmeci</a> built on Apple <a href="https://github.com/ml-explore/mlx" rel="nofollow">MLX</a>. It tries to replicate the great <a href="https://github.com/huggingface/pytorch-image-models" rel="nofollow">timm</a>, but for MLX models.',S,u,q,T,$e=`You can find <code>mlx-image</code> models by filtering using the <code>mlx-image</code> library name, like in <a href="https://huggingface.co/models?library=mlx-image&amp;sort=trending" rel="nofollow">this query</a>.
There’s also an open <a href="https://huggingface.co/mlx-vision" rel="nofollow">mlx-vision</a> community for contributors converting and publishing weights for MLX format.`,P,J,D,b,K,$,O,j,je='Model weights are available on the <a href="https://huggingface.co/mlx-vision" rel="nofollow"><code>mlx-vision</code></a> community on HuggingFace.',ee,U,Ue="To load a model with pre-trained weights:",te,I,le,x,Ie="To list all available models:",se,C,ae,Z,ne,v,xe='Go to <a href="https://github.com/riccardomusmeci/mlx-image/blob/main/results/results-imagenet-1k.csv" rel="nofollow">results-imagenet-1k.csv</a> to check every model converted to <code>mlx-image</code> and its performance on ImageNet-1K with different settings.',ie,G,Ce="<p><strong>TL;DR</strong> performance is comparable to the original models from PyTorch implementations.</p>",oe,k,me,_,Ze="<code>mlx-image</code> tries to be as close as possible to PyTorch:",re,R,ve="<li><p><code>DataLoader</code> -&gt; you can define your own <code>collate_fn</code> and also use <code>num_workers</code> to speed up data loading</p></li> <li><p><code>Dataset</code> -&gt; <code>mlx-image</code> already supports <code>LabelFolderDataset</code> (the good and old PyTorch <code>ImageFolder</code>) and <code>FolderDataset</code> (a generic folder with images in it)</p></li> <li><p><code>ModelCheckpoint</code> -&gt; keeps track of the best model and saves it to disk (similar to PyTorchLightning). It also suggests early stopping</p></li>",pe,B,ce,H,Ge="Training is similar to PyTorch. Here’s an example of how to train a model:",de,W,Me,X,he,E,ke='<li><a href="https://github.com/riccardomusmeci/mlx-image" rel="nofollow">mlx-image repository</a></li> <li><a href="https://huggingface.co/mlx-vision" rel="nofollow">mlx-vision community</a></li>',ge,F,we,z,_e="If you have any questions, please email <code>riccardomusmeci92@gmail.com</code>.",ye,L,fe,Y,ue;return y=new w({props:{title:"Using mlx-image at Hugging Face",local:"using-mlx-image-at-hugging-face",headingTag:"h1"}}),u=new w({props:{title:"Exploring mlx-image on the Hub",local:"exploring-mlx-image-on-the-hub",headingTag:"h2"}}),J=new w({props:{title:"Installation",local:"installation",headingTag:"h2"}}),b=new Te({props:{code:"cGlwJTIwaW5zdGFsbCUyMG1seC1pbWFnZQ==",highlighted:"pip install mlx-image",wrap:!1}}),$=new w({props:{title:"Models",local:"models",headingTag:"h2"}}),I=new Te({props:{code:"ZnJvbSUyMG1seGltLm1vZGVsJTIwaW1wb3J0JTIwY3JlYXRlX21vZGVsJTBBJTBBJTIzJTIwbG9hZGluZyUyMHdlaWdodHMlMjBmcm9tJTIwSHVnZ2luZ0ZhY2UlMjAoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRm1seC12aXNpb24lMkZyZXNuZXQxOC1tbHhpbSklMEFtb2RlbCUyMCUzRCUyMGNyZWF0ZV9tb2RlbCglMjJyZXNuZXQxOCUyMiklMjAlMjMlMjBwcmV0cmFpbmVkJTIwd2VpZ2h0cyUyMGxvYWRlZCUyMGZyb20lMjBIRiUwQSUwQSUyMyUyMGxvYWRpbmclMjB3ZWlnaHRzJTIwZnJvbSUyMGxvY2FsJTIwZmlsZSUwQW1vZGVsJTIwJTNEJTIwY3JlYXRlX21vZGVsKCUyMnJlc25ldDE4JTIyJTJDJTIwd2VpZ2h0cyUzRCUyMnBhdGglMkZ0byUyRnJlc25ldDE4JTJGbW9kZWwuc2FmZXRlbnNvcnMlMjIp",highlighted:`<span class="hljs-keyword">from</span> mlxim.model <span class="hljs-keyword">import</span> create_model

<span class="hljs-comment"># loading weights from HuggingFace (https://huggingface.co/mlx-vision/resnet18-mlxim)</span>
model = create_model(<span class="hljs-string">&quot;resnet18&quot;</span>) <span class="hljs-comment"># pretrained weights loaded from HF</span>

<span class="hljs-comment"># loading weights from local file</span>
model = create_model(<span class="hljs-string">&quot;resnet18&quot;</span>, weights=<span class="hljs-string">&quot;path/to/resnet18/model.safetensors&quot;</span>)`,wrap:!1}}),C=new Te({props:{code:"ZnJvbSUyMG1seGltLm1vZGVsJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEFsaXN0X21vZGVscygp",highlighted:`<span class="hljs-keyword">from</span> mlxim.model <span class="hljs-keyword">import</span> list_models
list_models()`,wrap:!1}}),Z=new w({props:{title:"ImageNet-1K Results",local:"imagenet-1k-results",headingTag:"h2"}}),k=new w({props:{title:"Similarity to PyTorch and other familiar tools",local:"similarity-to-pytorch-and-other-familiar-tools",headingTag:"h2"}}),B=new w({props:{title:"Training",local:"training",headingTag:"h2"}}),W=new Te({props:{code:"aW1wb3J0JTIwbWx4Lm5uJTIwYXMlMjBubiUwQWltcG9ydCUyMG1seC5vcHRpbWl6ZXJzJTIwYXMlMjBvcHRpbSUwQWZyb20lMjBtbHhpbS5tb2RlbCUyMGltcG9ydCUyMGNyZWF0ZV9tb2RlbCUwQWZyb20lMjBtbHhpbS5kYXRhJTIwaW1wb3J0JTIwTGFiZWxGb2xkZXJEYXRhc2V0JTJDJTIwRGF0YUxvYWRlciUwQSUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBMYWJlbEZvbGRlckRhdGFzZXQoJTBBJTIwJTIwJTIwJTIwcm9vdF9kaXIlM0QlMjJwYXRoJTJGdG8lMkZ0cmFpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsYXNzX21hcCUzRCU3QjAlM0ElMjAlMjJjbGFzc18wJTIyJTJDJTIwMSUzQSUyMCUyMmNsYXNzXzElMjIlMkMlMjAyJTNBJTIwJTVCJTIyY2xhc3NfMiUyMiUyQyUyMCUyMmNsYXNzXzMlMjIlNUQlN0QlMEEpJTBBdHJhaW5fbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjBkYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0QzMiUyQyUwQSUyMCUyMCUyMCUyMHNodWZmbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3dvcmtlcnMlM0Q0JTBBKSUwQW1vZGVsJTIwJTNEJTIwY3JlYXRlX21vZGVsKCUyMnJlc25ldDE4JTIyKSUyMCUyMyUyMHByZXRyYWluZWQlMjB3ZWlnaHRzJTIwbG9hZGVkJTIwZnJvbSUyMEhGJTBBb3B0aW1pemVyJTIwJTNEJTIwb3B0aW0uQWRhbShsZWFybmluZ19yYXRlJTNEMWUtMyklMEElMEFkZWYlMjB0cmFpbl9zdGVwKG1vZGVsJTJDJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG14Lm1lYW4obm4ubG9zc2VzLmNyb3NzX2VudHJvcHkobG9naXRzJTJDJTIwdGFyZ2V0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb3NzJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZSgxMCklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBiYXRjaCUyMGluJTIwdHJhaW5fbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyQyUyMHRhcmdldCUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhaW5fc3RlcF9mbiUyMCUzRCUyMG5uLnZhbHVlX2FuZF9ncmFkKG1vZGVsJTJDJTIwdHJhaW5fc3RlcCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTJDJTIwZ3JhZHMlMjAlM0QlMjB0cmFpbl9zdGVwX2ZuKHglMkMlMjB0YXJnZXQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnVwZGF0ZShtb2RlbCUyQyUyMGdyYWRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG14LmV2YWwobW9kZWwuc3RhdGUlMkMlMjBvcHRpbWl6ZXIuc3RhdGUp",highlighted:`<span class="hljs-keyword">import</span> mlx.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> mlx.optimizers <span class="hljs-keyword">as</span> optim
<span class="hljs-keyword">from</span> mlxim.model <span class="hljs-keyword">import</span> create_model
<span class="hljs-keyword">from</span> mlxim.data <span class="hljs-keyword">import</span> LabelFolderDataset, DataLoader

train_dataset = LabelFolderDataset(
    root_dir=<span class="hljs-string">&quot;path/to/train&quot;</span>,
    class_map={<span class="hljs-number">0</span>: <span class="hljs-string">&quot;class_0&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;class_1&quot;</span>, <span class="hljs-number">2</span>: [<span class="hljs-string">&quot;class_2&quot;</span>, <span class="hljs-string">&quot;class_3&quot;</span>]}
)
train_loader = DataLoader(
    dataset=train_dataset,
    batch_size=<span class="hljs-number">32</span>,
    shuffle=<span class="hljs-literal">True</span>,
    num_workers=<span class="hljs-number">4</span>
)
model = create_model(<span class="hljs-string">&quot;resnet18&quot;</span>) <span class="hljs-comment"># pretrained weights loaded from HF</span>
optimizer = optim.Adam(learning_rate=<span class="hljs-number">1e-3</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">train_step</span>(<span class="hljs-params">model, inputs, targets</span>):
    logits = model(inputs)
    loss = mx.mean(nn.losses.cross_entropy(logits, target))
    <span class="hljs-keyword">return</span> loss

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_loader:
        x, target = batch
        train_step_fn = nn.value_and_grad(model, train_step)
        loss, grads = train_step_fn(x, target)
        optimizer.update(model, grads)
        mx.<span class="hljs-built_in">eval</span>(model.state, optimizer.state)`,wrap:!1}}),X=new w({props:{title:"Additional Resources",local:"additional-resources",headingTag:"h2"}}),F=new w({props:{title:"Contact",local:"contact",headingTag:"h2"}}),L=new Qe({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/mlx-image.md"}}),{c(){g=i("meta"),N=a(),Q=i("p"),V=a(),m(y.$$.fragment),A=a(),f=i("p"),f.innerHTML=be,S=a(),m(u.$$.fragment),q=a(),T=i("p"),T.innerHTML=$e,P=a(),m(J.$$.fragment),D=a(),m(b.$$.fragment),K=a(),m($.$$.fragment),O=a(),j=i("p"),j.innerHTML=je,ee=a(),U=i("p"),U.textContent=Ue,te=a(),m(I.$$.fragment),le=a(),x=i("p"),x.textContent=Ie,se=a(),m(C.$$.fragment),ae=a(),m(Z.$$.fragment),ne=a(),v=i("p"),v.innerHTML=xe,ie=a(),G=i("blockquote"),G.innerHTML=Ce,oe=a(),m(k.$$.fragment),me=a(),_=i("p"),_.innerHTML=Ze,re=a(),R=i("ul"),R.innerHTML=ve,pe=a(),m(B.$$.fragment),ce=a(),H=i("p"),H.textContent=Ge,de=a(),m(W.$$.fragment),Me=a(),m(X.$$.fragment),he=a(),E=i("ul"),E.innerHTML=ke,ge=a(),m(F.$$.fragment),we=a(),z=i("p"),z.innerHTML=_e,ye=a(),m(L.$$.fragment),fe=a(),Y=i("p"),this.h()},l(e){const t=ze("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(l),N=n(e),Q=o(e,"P",{}),Re(Q).forEach(l),V=n(e),r(y.$$.fragment,e),A=n(e),f=o(e,"P",{"data-svelte-h":!0}),h(f)!=="svelte-1c0kah6"&&(f.innerHTML=be),S=n(e),r(u.$$.fragment,e),q=n(e),T=o(e,"P",{"data-svelte-h":!0}),h(T)!=="svelte-15ir2pb"&&(T.innerHTML=$e),P=n(e),r(J.$$.fragment,e),D=n(e),r(b.$$.fragment,e),K=n(e),r($.$$.fragment,e),O=n(e),j=o(e,"P",{"data-svelte-h":!0}),h(j)!=="svelte-13m84xx"&&(j.innerHTML=je),ee=n(e),U=o(e,"P",{"data-svelte-h":!0}),h(U)!=="svelte-rlp6qh"&&(U.textContent=Ue),te=n(e),r(I.$$.fragment,e),le=n(e),x=o(e,"P",{"data-svelte-h":!0}),h(x)!=="svelte-1xjx8g7"&&(x.textContent=Ie),se=n(e),r(C.$$.fragment,e),ae=n(e),r(Z.$$.fragment,e),ne=n(e),v=o(e,"P",{"data-svelte-h":!0}),h(v)!=="svelte-kcleo1"&&(v.innerHTML=xe),ie=n(e),G=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),h(G)!=="svelte-1xz4blu"&&(G.innerHTML=Ce),oe=n(e),r(k.$$.fragment,e),me=n(e),_=o(e,"P",{"data-svelte-h":!0}),h(_)!=="svelte-11sjtis"&&(_.innerHTML=Ze),re=n(e),R=o(e,"UL",{"data-svelte-h":!0}),h(R)!=="svelte-jcjia8"&&(R.innerHTML=ve),pe=n(e),r(B.$$.fragment,e),ce=n(e),H=o(e,"P",{"data-svelte-h":!0}),h(H)!=="svelte-1cvxtzq"&&(H.textContent=Ge),de=n(e),r(W.$$.fragment,e),Me=n(e),r(X.$$.fragment,e),he=n(e),E=o(e,"UL",{"data-svelte-h":!0}),h(E)!=="svelte-k2vhlo"&&(E.innerHTML=ke),ge=n(e),r(F.$$.fragment,e),we=n(e),z=o(e,"P",{"data-svelte-h":!0}),h(z)!=="svelte-12c9hfs"&&(z.innerHTML=_e),ye=n(e),r(L.$$.fragment,e),fe=n(e),Y=o(e,"P",{}),Re(Y).forEach(l),this.h()},h(){Be(g,"name","hf:doc:metadata"),Be(g,"content",Ne)},m(e,t){Le(document.head,g),s(e,N,t),s(e,Q,t),s(e,V,t),p(y,e,t),s(e,A,t),s(e,f,t),s(e,S,t),p(u,e,t),s(e,q,t),s(e,T,t),s(e,P,t),p(J,e,t),s(e,D,t),p(b,e,t),s(e,K,t),p($,e,t),s(e,O,t),s(e,j,t),s(e,ee,t),s(e,U,t),s(e,te,t),p(I,e,t),s(e,le,t),s(e,x,t),s(e,se,t),p(C,e,t),s(e,ae,t),p(Z,e,t),s(e,ne,t),s(e,v,t),s(e,ie,t),s(e,G,t),s(e,oe,t),p(k,e,t),s(e,me,t),s(e,_,t),s(e,re,t),s(e,R,t),s(e,pe,t),p(B,e,t),s(e,ce,t),s(e,H,t),s(e,de,t),p(W,e,t),s(e,Me,t),p(X,e,t),s(e,he,t),s(e,E,t),s(e,ge,t),p(F,e,t),s(e,we,t),s(e,z,t),s(e,ye,t),p(L,e,t),s(e,fe,t),s(e,Y,t),ue=!0},p:We,i(e){ue||(c(y.$$.fragment,e),c(u.$$.fragment,e),c(J.$$.fragment,e),c(b.$$.fragment,e),c($.$$.fragment,e),c(I.$$.fragment,e),c(C.$$.fragment,e),c(Z.$$.fragment,e),c(k.$$.fragment,e),c(B.$$.fragment,e),c(W.$$.fragment,e),c(X.$$.fragment,e),c(F.$$.fragment,e),c(L.$$.fragment,e),ue=!0)},o(e){d(y.$$.fragment,e),d(u.$$.fragment,e),d(J.$$.fragment,e),d(b.$$.fragment,e),d($.$$.fragment,e),d(I.$$.fragment,e),d(C.$$.fragment,e),d(Z.$$.fragment,e),d(k.$$.fragment,e),d(B.$$.fragment,e),d(W.$$.fragment,e),d(X.$$.fragment,e),d(F.$$.fragment,e),d(L.$$.fragment,e),ue=!1},d(e){e&&(l(N),l(Q),l(V),l(A),l(f),l(S),l(q),l(T),l(P),l(D),l(K),l(O),l(j),l(ee),l(U),l(te),l(le),l(x),l(se),l(ae),l(ne),l(v),l(ie),l(G),l(oe),l(me),l(_),l(re),l(R),l(pe),l(ce),l(H),l(de),l(Me),l(he),l(E),l(ge),l(we),l(z),l(ye),l(fe),l(Y)),l(g),M(y,e),M(u,e),M(J,e),M(b,e),M($,e),M(I,e),M(C,e),M(Z,e),M(k,e),M(B,e),M(W,e),M(X,e),M(F,e),M(L,e)}}}const Ne='{"title":"Using mlx-image at Hugging Face","local":"using-mlx-image-at-hugging-face","sections":[{"title":"Exploring mlx-image on the Hub","local":"exploring-mlx-image-on-the-hub","sections":[],"depth":2},{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"Models","local":"models","sections":[],"depth":2},{"title":"ImageNet-1K Results","local":"imagenet-1k-results","sections":[],"depth":2},{"title":"Similarity to PyTorch and other familiar tools","local":"similarity-to-pytorch-and-other-familiar-tools","sections":[],"depth":2},{"title":"Training","local":"training","sections":[],"depth":2},{"title":"Additional Resources","local":"additional-resources","sections":[],"depth":2},{"title":"Contact","local":"contact","sections":[],"depth":2}],"depth":1}';function Ve(Je){return Xe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class De extends Ee{constructor(g){super(),Fe(this,g,Ve,Ye,He,{})}}export{De as component};
