import{s as Ll,f as Rl,o as Zl,n as ql}from"../chunks/scheduler.85c25b89.js";import{S as Wl,i as El,g as r,s as n,r as p,A as zl,h as s,f as a,c as l,j as T,u as c,x as d,k as y,y as i,a as o,v as m,d as h,t as u,w as f}from"../chunks/index.c142fe32.js";import{D as $}from"../chunks/Docstring.e6639b56.js";import{C as G}from"../chunks/CodeBlock.a5e95a57.js";import{E as Nl}from"../chunks/ExampleCodeBlock.59b8d777.js";import{H as M,E as Hl}from"../chunks/EditOnGithub.a592e7aa.js";function Ql(Ut){let v,P="Example:",C,w,x;return w=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQWZlYXR1cmVzJTIwJTNEJTIwJTdCJTIycHJvbXB0JTIyJTNBJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlMkMlMjAlMjJjaG9zZW4lMjIlM0ElMjAlMjIlMjBibHVlJTIyJTJDJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlMjIlMjBncmVlbiUyMiU3RCUwQURQT1RyYWluZXIudG9rZW5pemVfcm93KGZlYXR1cmVzJTJDJTIwdG9rZW5pemVyJTJDJTIwbWF4X3Byb21wdF9sZW5ndGglM0QzJTJDJTIwbWF4X2NvbXBsZXRpb25fbGVuZ3RoJTNEMyUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>features = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;chosen&quot;</span>: <span class="hljs-string">&quot; blue&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>: <span class="hljs-string">&quot; green&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>DPOTrainer.tokenize_row(features, tokenizer, max_prompt_length=<span class="hljs-number">3</span>, max_completion_length=<span class="hljs-number">3</span>, add_special_tokens=<span class="hljs-literal">False</span>)
{<span class="hljs-string">&#x27;prompt_input_ids&#x27;</span>: [<span class="hljs-number">464</span>, <span class="hljs-number">6766</span>, <span class="hljs-number">318</span>], <span class="hljs-string">&#x27;chosen_input_ids&#x27;</span>: [<span class="hljs-number">4171</span>, <span class="hljs-number">50256</span>], <span class="hljs-string">&#x27;rejected_input_ids&#x27;</span>: [<span class="hljs-number">4077</span>, <span class="hljs-number">50256</span>]}`,wrap:!1}}),{c(){v=r("p"),v.textContent=P,C=n(),p(w.$$.fragment)},l(b){v=s(b,"P",{"data-svelte-h":!0}),d(v)!=="svelte-11lpom8"&&(v.textContent=P),C=l(b),c(w.$$.fragment,b)},m(b,j){o(b,v,j),o(b,C,j),m(w,b,j),x=!0},p:ql,i(b){x||(h(w.$$.fragment,b),x=!0)},o(b){u(w.$$.fragment,b),x=!1},d(b){b&&(a(v),a(C)),f(w,b)}}}function Bl(Ut){let v,P="Examples:",C,w,x;return w=new G({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFByZWZlcmVuY2VDb2xsYXRvciUwQWNvbGxhdG9yJTIwJTNEJTIwUHJlZmVyZW5jZUNvbGxhdG9yKHBhZF90b2tlbl9pZCUzRDApJTBBZXhhbXBsZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJwcm9tcHRfaW5wdXRfaWRzJTIyJTNBJTIwJTVCMSUyQyUyMDIlMkMlMjAzJTVEJTJDJTIwJTIyY2hvc2VuX2lucHV0X2lkcyUyMiUzQSUyMCU1QjQlMkMlMjA1JTVEJTJDJTIwJTIycmVqZWN0ZWRfaW5wdXRfaWRzJTIyJTNBJTIwJTVCNiU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnByb21wdF9pbnB1dF9pZHMlMjIlM0ElMjAlNUI3JTJDJTIwOCU1RCUyQyUyMCUyMmNob3Nlbl9pbnB1dF9pZHMlMjIlM0ElMjAlNUI5JTJDJTIwMTAlNUQlMkMlMjAlMjJyZWplY3RlZF9pbnB1dF9pZHMlMjIlM0ElMjAlNUIxMSUyQyUyMDEyJTJDJTIwMTMlNUQlN0QlMEElNUQlMEFjb2xsYXRvcihleGFtcGxlcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PreferenceCollator
<span class="hljs-meta">&gt;&gt;&gt; </span>collator = PreferenceCollator(pad_token_id=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>examples = [
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;prompt_input_ids&quot;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>], <span class="hljs-string">&quot;chosen_input_ids&quot;</span>: [<span class="hljs-number">4</span>, <span class="hljs-number">5</span>], <span class="hljs-string">&quot;rejected_input_ids&quot;</span>: [<span class="hljs-number">6</span>]},
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;prompt_input_ids&quot;</span>: [<span class="hljs-number">7</span>, <span class="hljs-number">8</span>], <span class="hljs-string">&quot;chosen_input_ids&quot;</span>: [<span class="hljs-number">9</span>, <span class="hljs-number">10</span>], <span class="hljs-string">&quot;rejected_input_ids&quot;</span>: [<span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>]}
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>collator(examples)
{<span class="hljs-string">&#x27;prompt_input_ids&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>],
                             [<span class="hljs-number">0</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]),
 <span class="hljs-string">&#x27;prompt_attention_mask&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
                                  [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]]),
 <span class="hljs-string">&#x27;chosen_input_ids&#x27;</span>: tensor([[ <span class="hljs-number">4</span>,  <span class="hljs-number">5</span>],
                             [ <span class="hljs-number">9</span>, <span class="hljs-number">10</span>]]),
 <span class="hljs-string">&#x27;chosen_attention_mask&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
                                  [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>]]),
 <span class="hljs-string">&#x27;rejected_input_ids&#x27;</span>: tensor([[ <span class="hljs-number">6</span>,  <span class="hljs-number">0</span>,  <span class="hljs-number">0</span>],
                               [<span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>]]),
 <span class="hljs-string">&#x27;rejected_attention_mask&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
                                    [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]])
}`,wrap:!1}}),{c(){v=r("p"),v.textContent=P,C=n(),p(w.$$.fragment)},l(b){v=s(b,"P",{"data-svelte-h":!0}),d(v)!=="svelte-kvfsh7"&&(v.textContent=P),C=l(b),c(w.$$.fragment,b)},m(b,j){o(b,v,j),o(b,C,j),m(w,b,j),x=!0},p:ql,i(b){x||(h(w.$$.fragment,b),x=!0)},o(b){u(w.$$.fragment,b),x=!1},d(b){b&&(a(v),a(C)),f(w,b)}}}function Vl(Ut){let v,P,C,w,x,b,j,Tn='<a href="https://huggingface.co/models?other=dpo,trl" rel="nofollow"><img src="https://img.shields.io/badge/All_models-DPO-blue"/></a>',sa,A,ia,X,Mn='TRL supports the DPO Trainer for training language models from preference data, as described in the paper <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">Direct Preference Optimization: Your Language Model is Secretly a Reward Model</a> by <a href="https://huggingface.co/rmrafailov" rel="nofollow">Rafael Rafailov</a>, Archit Sharma, Eric Mitchell, <a href="https://huggingface.co/ermonste" rel="nofollow">Stefano Ermon</a>, <a href="https://huggingface.co/manning" rel="nofollow">Christopher D. Manning</a>, <a href="https://huggingface.co/cbfinn" rel="nofollow">Chelsea Finn</a>.',da,S,xn="The abstract from the paper is the following:",pa,Y,$n="<p>While large-scale unsupervised language models (LMs) learn broad world knowledge and some reasoning skills, achieving precise control of their behavior is difficult due to the completely unsupervised nature of their training. Existing methods for gaining such steerability collect human labels of the relative quality of model generations and fine-tune the unsupervised LM to align with these preferences, often with reinforcement learning from human feedback (RLHF). However, RLHF is a complex and often unstable procedure, first fitting a reward model that reflects the human preferences, and then fine-tuning the large unsupervised LM using reinforcement learning to maximize this estimated reward without drifting too far from the original model. In this paper we introduce a new parameterization of the reward model in RLHF that enables extraction of the corresponding optimal policy in closed form, allowing us to solve the standard RLHF problem with only a simple classification loss. The resulting algorithm, which we call Direct Preference Optimization (DPO), is stable, performant, and computationally lightweight, eliminating the need for sampling from the LM during fine-tuning or performing significant hyperparameter tuning. Our experiments show that DPO can fine-tune LMs to align with human preferences as well as or better than existing methods. Notably, fine-tuning with DPO exceeds PPO-based RLHF in ability to control sentiment of generations, and matches or improves response quality in summarization and single-turn dialogue while being substantially simpler to implement and train.</p>",ca,K,Cn="The first step is to train an SFT model, to ensure the data we train on is in-distribution for the DPO algorithm.",ma,ee,jn='Then, fine-tuning a language model via DPO consists of two steps and is easier than <a href="ppo_trainer">PPO</a>:',ha,te,Un='<li><strong>Data collection</strong>: Gather a <a href="dataset_formats#preference">preference dataset</a> with positive and negative selected pairs of generation, given a prompt.</li> <li><strong>Optimization</strong>: Maximize the log-likelihood of the DPO loss directly.</li>',ua,ae,On='This process is illustrated in the sketch below (from <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">Figure 1 of the DPO paper</a>):',fa,oe,Pn='<img src="https://github.com/huggingface/trl/assets/49240599/9150fac6-3d88-4ca2-8ec6-2a6f3473216d"/>',ga,ne,Jn='Read more about DPO algorithm in the <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">original paper</a>.',_a,le,ba,re,kn='This example demonstrates how to train a model using the DPO method. We use the <a href="https://huggingface.co/Qwen/Qwen2-0.5B-Instruct" rel="nofollow">Qwen 0.5B model</a> as the base model. We use the preference data from the <a href="https://huggingface.co/datasets/openbmb/UltraFeedback" rel="nofollow">UltraFeedback dataset</a>. You can view the data in the dataset here:',va,J,Dn,ya,se,Fn="Below is the script to train the model:",wa,ie,Ta,de,In="Execute the script using the following command:",Ma,pe,xa,ce,Nn="Distributed across 8 GPUs, the training takes approximately 3 minutes. You can verify the training progress by checking the reward graph. An increasing trend in the reward margin indicates that the model is improving and generating better responses over time.",$a,me,qn='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/dpo-qwen2-reward-margin.png"/>',Ca,he,Ln='To see how the <a href="https://huggingface.co/trl-lib/Qwen2-0.5B-DPO" rel="nofollow">trained model</a> performs, you can use the <a href="clis#chat-interface">TRL Chat CLI</a>.',ja,ue,Rn=`<code>$ trl chat --model_name_or_path trl-lib/Qwen2-0.5B-DPO
<strong><span style="color: red;">&lt;quentin_gallouedec&gt;:</span></strong>
What is the best programming language?

<strong><span style="color: blue;">&lt;trl-lib/Qwen2-0.5B-DPO&gt;:</span></strong>
The best programming language for specific applications can vary depending on the use case and knowledge level of the programmer. Here are some general factors that can be used as input to choose the best programming language:

 <strong><span style="color: green;">1</span></strong> Ease of use: Some programming languages are more user-friendly than others, such as Python, Java, or Ruby. Python is popular due to its simplicity and great scalability.
 <strong><span style="color: green;">2</span></strong> Versatility: The ability to work with a wide range of data structures and frameworks can define the language as versatile.
 <strong><span style="color: green;">3</span></strong> Ease of learning: Different programming languages have different learning curves, so users must be willing to take some time to master one.
 <strong><span style="color: green;">4</span></strong> Community support: The broader community of developers and enthusiasts in the selected programming language can provide great support and resources.
 <strong><span style="color: green;">5</span></strong> Reusability: Languages that emphasize code reuse and can be easily modifiable can be more suitable for software development.

The best programming language based on these factors is subjective and depends on what the programmer intends to accomplish.
</code>`,Ua,fe,Oa,ge,Zn='DPO requires a <a href="dataset_formats#preference">preference dataset</a>. The <a href="/docs/trl/v0.12.1/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a> supports both <a href="dataset_formats#conversational">conversational</a> and <a href="dataset_formats#standard">standard</a> dataset format. When provided with a conversational dataset, the trainer will automatically apply the chat template to the dataset.',Pa,_e,Wn='Although the <a href="/docs/trl/v0.12.1/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a> supports both explicit and implicit prompts, we recommend using explicit prompts. If provided with an implicit prompt dataset, the trainer will automatically extract the prompt from the <code>&quot;chosen&quot;</code> and <code>&quot;rejected&quot;</code> columns. For more information, refer to the <a href="dataset_formats#preference">preference style</a> section.',Ja,be,ka,ve,En='The <a href="/docs/trl/v0.12.1/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a> supports fine-tuning vision-language models (VLMs). For these models, a vision dataset is required. To learn more about the specific format for vision datasets, refer to the <a href="dataset_formats#vision-datasets">Vision dataset format</a> section.',Da,ye,zn="Additionally, unlike standard text-based models where a <code>tokenizer</code> is used, for VLMs, you should replace the <code>tokenizer</code> with a <code>processor</code>.",Fa,we,Ia,Te,Hn='For a complete example of fine-tuning a vision-language model, refer to the script in <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/dpo_vlm.py" rel="nofollow"><code>examples/scripts/dpo_vlm.py</code></a>.',Na,Me,qa,xe,Qn='We provide an example script to train a model using the DPO method. The script is available in <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/dpo.py" rel="nofollow"><code>examples/scripts/dpo.py</code></a>',La,$e,Bn='To test the DPO script with the <a href="https://huggingface.co/Qwen/Qwen2-0.5B-Instruct" rel="nofollow">Qwen2 0.5B model</a> on the <a href="https://huggingface.co/datasets/trl-lib/ultrafeedback_binarized" rel="nofollow">UltraFeedback dataset</a>, run the following command:',Ra,Ce,Za,je,Wa,Ue,Vn="While training and evaluating we record the following reward metrics:",Ea,Oe,Gn="<li><code>rewards/chosen</code>: the mean difference between the log probabilities of the policy model and the reference model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean difference between the log probabilities of the policy model and the reference model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li>",za,Pe,Ha,Je,An='The DPO algorithm supports several loss functions. The loss function can be set using the <code>loss_type</code> parameter in the <a href="/docs/trl/v0.12.1/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>. The following loss functions are supported:',Qa,ke,Xn='<thead><tr><th><code>loss_type=</code></th> <th>Description</th></tr></thead> <tbody><tr><td><code>&quot;sigmoid&quot;</code> (default)</td> <td>Given the preference data, we can fit a binary classifier according to the Bradley-Terry model and in fact the <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">DPO</a> authors propose the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression.</td></tr> <tr><td><code>&quot;hinge&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://huggingface.co/papers/2305.10425" rel="nofollow">SLiC</a> paper. In this case, the <code>beta</code> is the reciprocal of the margin.</td></tr> <tr><td><code>&quot;ipo&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the DPO algorithms and identify an issue with overfitting and propose an alternative loss. In this case, the <code>beta</code> is the reciprocal of the gap between the log-likelihood ratios of the chosen vs the rejected completion pair and thus the smaller the <code>beta</code> the larger this gaps is. As per the paper the loss is averaged over log-likelihoods of the completion (unlike DPO which is summed only).</td></tr> <tr><td><code>&quot;exo_pair&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2402.00856" rel="nofollow">EXO</a> authors propose to minimize the reverse KL instead of the negative log-sigmoid loss of DPO which corresponds to forward KL. Setting non-zero <code>label_smoothing</code> (default <code>1e-3</code>) leads to a simplified version of EXO on pair-wise preferences (see Eqn. (16) of the <a href="https://huggingface.co/papers/2402.00856" rel="nofollow">EXO paper</a>). The full version of EXO uses <code>K&gt;2</code> completions generated by the SFT policy, which becomes an unbiased estimator of the PPO objective (up to a constant) when <code>K</code> is sufficiently large.</td></tr> <tr><td><code>&quot;nca_pair&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2402.05369" rel="nofollow">NCA</a> authors shows that NCA optimizes the absolute likelihood for each response rather than the relative likelihood.</td></tr> <tr><td><code>&quot;robust&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2403.00409" rel="nofollow">Robust DPO</a> authors propose an unbiased estimate of the DPO loss that is robust to preference noise in the data. Like in cDPO, it assumes that the preference labels are noisy with some probability. In this approach, the <code>label_smoothing</code> parameter in the <a href="/docs/trl/v0.12.1/en/dpo_trainer#trl.DPOConfig">DPOConfig</a> is used to model the probability of existing label noise. To apply this conservative loss, set <code>label_smoothing</code> to a value greater than 0.0 (between 0.0 and 0.5; the default is 0.0)</td></tr> <tr><td><code>&quot;bco_pair&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2404.04656" rel="nofollow">BCO</a> authors train a binary classifier whose logit serves as a reward so that the classifier maps {prompt, chosen completion} pairs to 1 and {prompt, rejected completion} pairs to 0. For unpaired data, we recommend the dedicated <a href="/docs/trl/v0.12.1/en/bco_trainer#trl.BCOTrainer">BCOTrainer</a>.</td></tr> <tr><td><code>&quot;sppo_hard&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2405.00675" rel="nofollow">SPPO</a> authors claim that SPPO is capable of solving the Nash equilibrium iteratively by pushing the chosen rewards to be as large as 1/2 and the rejected rewards to be as small as -1/2 and can alleviate data sparsity issues. The implementation approximates this algorithm by employing hard label probabilities, assigning 1 to the winner and 0 to the loser.</td></tr> <tr><td><code>&quot;aot&quot;</code>  or <code>loss_type=&quot;aot_pair&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2406.05882" rel="nofollow">AOT</a> authors propose to use Distributional Preference Alignment Via Optimal Transport. Traditionally, the alignment algorithms use paired preferences at a sample level, which does not ensure alignment on the distributional level. AOT, on the other hand, can align LLMs on paired or unpaired preference data by making the reward distribution of the positive samples stochastically dominant in the first order on the distribution of negative samples. Specifically, <code>loss_type=&quot;aot&quot;</code> is appropriate for paired datasets, where each prompt has both chosen and rejected responses; <code>loss_type=&quot;aot_pair&quot;</code> is for unpaired datasets. In a nutshell, <code>loss_type=&quot;aot&quot;</code> ensures that the log-likelihood ratio of chosen to rejected of the aligned model has higher quantiles than that ratio for the reference model. <code>loss_type=&quot;aot_pair&quot;</code> ensures that the chosen reward is higher on all quantiles than the rejected reward. Note that in both cases quantiles are obtained via sorting. To fully leverage the advantages of the AOT algorithm, it is important to maximize the per-GPU batch size.</td></tr> <tr><td><code>&quot;apo_zero&quot;</code> or <code>loss_type=&quot;apo_down&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2408.06266" rel="nofollow">APO</a> method introduces an “anchored” version of the alignment objective. There are two variants: <code>apo_zero</code> and <code>apo_down</code>. The <code>apo_zero</code> loss increases the likelihood of winning outputs while decreasing the likelihood of losing outputs, making it suitable when the model is less performant than the winning outputs. On the other hand, <code>apo_down</code> decreases the likelihood of both winning and losing outputs, but with a stronger emphasis on reducing the likelihood of losing outputs. This variant is more effective when the model is better than the winning outputs.</td></tr></tbody>',Ba,De,Va,Fe,Sn='The <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> is a tweak on the DPO loss where we assume that the preference labels are noisy with some probability. In this approach, the <code>label_smoothing</code> parameter in the <a href="/docs/trl/v0.12.1/en/dpo_trainer#trl.DPOConfig">DPOConfig</a> is used to model the probability of existing label noise. To apply this conservative loss, set <code>label_smoothing</code> to a value greater than 0.0 (between 0.0 and 0.5; the default is 0.0).',Ga,Ie,Aa,Ne,Yn='The <a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper suggests syncing the reference model weights after every <code>ref_model_sync_steps</code> steps of SGD with weight <code>ref_model_mixup_alpha</code> during DPO training. To toggle this callback use the <code>sync_ref_model=True</code> in the <a href="/docs/trl/v0.12.1/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',Xa,qe,Sa,Le,Kn='The <a href="https://huggingface.co/papers/2404.19733" rel="nofollow">RPO</a> paper implements an iterative preference tuning algorithm using a loss related to the RPO loss in this <a href="https://huggingface.co/papers/2405.16436" rel="nofollow">paper</a> that essentially consists of a weighted SFT loss on the chosen preferences together with the DPO loss. To use this loss, set the <code>rpo_alpha</code> in the <a href="/docs/trl/v0.12.1/en/dpo_trainer#trl.DPOConfig">DPOConfig</a> to an appropriate value. The paper suggests setting this weight to <code>1.0</code>.',Ya,Re,Ka,Ze,el='The <a href="https://huggingface.co/papers/2406.11827" rel="nofollow">WPO</a> paper adapts off-policy data to resemble on-policy data more closely by reweighting preference pairs according to their probability under the current policy. To use this method, set the <code>use_weighting</code> flag to <code>True</code> in the <a href="/docs/trl/v0.12.1/en/dpo_trainer#trl.DPOConfig">DPOConfig</a>.',eo,We,to,Ee,tl=`MOEs are the most efficient if the load is about equally distributed between experts.<br/>
To ensure that we train MOEs similarly during preference-tuning, it is beneficial to add the auxiliary loss from the load balancer to the final loss.`,ao,ze,al=`This option is enabled by setting <code>output_router_logits=True</code> in the model config (e.g. <a href="https://huggingface.co/docs/transformers/v4.46.2/en/model_doc/mixtral#transformers.MixtralConfig" rel="nofollow">MixtralConfig</a>).<br/>
To scale how much the auxiliary loss contributes to the total loss, use the hyperparameter <code>router_aux_loss_coef=...</code> (default: <code>0.001</code>) in the model config.`,oo,He,no,Qe,ol='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks for DPO listed below:',lo,Be,nl="<thead><tr><th>GPU</th> <th>Model</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>A100 40G</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.24x</td> <td><strong>1.88x</strong></td> <td>-11.6%</td></tr> <tr><td>Tesla T4</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.09x</td> <td><strong>1.55x</strong></td> <td>-18.6%</td></tr></tbody>",ro,Ve,ll='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',so,Ge,io,Ae,rl='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',po,Xe,co,Se,sl="You have three main options (plus several variants) for how the reference model works when using PEFT, assuming the model that you would like to further enhance with DPO was tuned using (Q)LoRA.",mo,Ye,il="<li>Simply create two instances of the model, each loading your adapter - works fine but is very inefficient.</li> <li>Merge the adapter into the base model, create another adapter on top, then leave the <code>ref_model</code> param null, in which case DPOTrainer will unload the adapter for reference inference - efficient, but has potential downsides discussed below.</li> <li>Load the adapter twice with different names, then use <code>set_adapter</code> during training to swap between the adapter being DPO’d and the reference adapter - slightly less efficient compared to 2 (~adapter size VRAM overhead), but avoids the pitfalls.</li>",ho,Ke,uo,et,dl='As suggested by <a href="https://medium.com/@bnjmn_marie/dont-merge-your-lora-adapter-into-a-4-bit-llm-65b6da287997" rel="nofollow">Benjamin Marie</a>, the best option for merging QLoRA adapters is to first dequantize the base model, then merge the adapter. Something similar to <a href="https://github.com/jondurbin/qlora/blob/main/qmerge.py" rel="nofollow">this script</a>.',fo,tt,pl="However, after using this approach, you will have an unquantized base model. Therefore, to use QLoRA for DPO, you will need to re-quantize the merged model or use the unquantized merge (resulting in higher memory demand).",go,at,_o,ot,cl='To avoid the downsides with option 2, you can load your fine-tuned adapter into the model twice, with different names, and set the model/ref adapter names in <a href="/docs/trl/v0.12.1/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a>.',bo,nt,ml="For example:",vo,lt,yo,rt,wo,g,st,No,Ot,hl="Initialize DPOTrainer.",qo,L,it,Lo,Pt,ul="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",Ro,k,dt,Zo,Jt,fl="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Wo,kt,gl="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Eo,D,pt,zo,Dt,_l=`Concatenate the <code>chosen</code> and <code>rejected</code> inputs from the batch into a single tensor for both the prompt
and completion sequences.`,Ho,Ft,bl=`Notes:
The completion input IDs and attention masks are padded to the maximum completion length of the chosen
or rejected sequences.`,Qo,R,ct,Bo,It,vl="Creates a draft of a model card using the information available to the <code>Trainer</code>.",Vo,Z,mt,Go,Nt,yl="Compute the DPO loss for a batch of policy and reference model log probabilities.",Ao,F,ht,Xo,qt,wl=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,So,Lt,Tl="Works both with or without labels.",Yo,W,ut,Ko,Rt,Ml="Generate samples from the model and reference model for the given batch of inputs.",en,E,ft,tn,Zt,xl="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",an,I,gt,on,Wt,$l="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",nn,Et,Cl="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",ln,N,_t,rn,zt,jl="Returns the training <code>~torch.utils.data.DataLoader</code>.",sn,Ht,Ul="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",dn,z,bt,pn,Qt,Ol="Log <code>logs</code> on the various objects watching training, including stored metrics.",cn,H,vt,mn,Bt,Pl="Context manager for handling null reference model (that is, peft adapter manipulation).",hn,Q,yt,un,Vt,Jl="Same as <code>tokenize_row</code> but for vision models. Please refer to <code>tokenize_row</code> for more information.",fn,q,wt,gn,Gt,kl="Tokenize a row of the dataset.",_n,B,To,Tt,Mo,U,Mt,bn,At,Dl='Configuration class for the <a href="/docs/trl/v0.12.1/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a>.',vn,Xt,Fl=`Using <a href="https://huggingface.co/docs/transformers/v4.46.2/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,xo,xt,$o,O,$t,yn,St,Il=`Data collator used for preference data. Inputs are dynamically padded to the maximum length of a batch if they
are not all of the same length.`,wn,V,Co,Ct,jo,ra,Uo;return x=new M({props:{title:"DPO Trainer",local:"dpo-trainer",headingTag:"h1"}}),A=new M({props:{title:"Overview",local:"overview",headingTag:"h2"}}),le=new M({props:{title:"Quick start",local:"quick-start",headingTag:"h2"}}),ie=new G({props:{code:"JTIzJTIwdHJhaW5fZHBvLnB5JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMERQT0NvbmZpZyUyQyUyMERQT1RyYWluZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ0cmwtbGliJTJGdWx0cmFmZWVkYmFja19iaW5hcml6ZWQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBEUE9Db25maWcob3V0cHV0X2RpciUzRCUyMlF3ZW4yLTAuNUItRFBPJTIyJTJDJTIwbG9nZ2luZ19zdGVwcyUzRDEwKSUwQXRyYWluZXIlMjAlM0QlMjBEUE9UcmFpbmVyKG1vZGVsJTNEbW9kZWwlMkMlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUyMHByb2Nlc3NpbmdfY2xhc3MlM0R0b2tlbml6ZXIlMkMlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-comment"># train_dpo.py</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOConfig, DPOTrainer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
train_dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/ultrafeedback_binarized&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

training_args = DPOConfig(output_dir=<span class="hljs-string">&quot;Qwen2-0.5B-DPO&quot;</span>, logging_steps=<span class="hljs-number">10</span>)
trainer = DPOTrainer(model=model, args=training_args, processing_class=tokenizer, train_dataset=train_dataset)
trainer.train()`,wrap:!1}}),pe=new G({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2Rwby5weQ==",highlighted:"accelerate launch train_dpo.py",wrap:!1}}),fe=new M({props:{title:"Expected dataset type",local:"expected-dataset-type",headingTag:"h2"}}),be=new M({props:{title:"Special considerations for vision-language models",local:"special-considerations-for-vision-language-models",headingTag:"h3"}}),we=new G({props:{code:"LSUyMG1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUyQiUyMG1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBLSUyMHRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUyQiUyMHByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUwQSUyMCUyMHRyYWluZXIlMjAlM0QlMjBEUE9UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQS0lMjAlMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBJTJCJTIwJTIwJTIwJTIwJTIwcHJvY2Vzc2luZ19jbGFzcyUzRHByb2Nlc3NvciUyQyUwQSk=",highlighted:`<span class="hljs-deletion">- model = AutoModelForCausalLM.from_pretrained(model_id)</span>
<span class="hljs-addition">+ model = AutoModelForVision2Seq.from_pretrained(model_id)</span>

<span class="hljs-deletion">- tokenizer = AutoTokenizer.from_pretrained(model_id)</span>
<span class="hljs-addition">+ processor = AutoProcessor.from_pretrained(model_id)</span>

  trainer = DPOTrainer(
      model,
      args=training_args,
      train_dataset=train_dataset,
<span class="hljs-deletion">-     processing_class=tokenizer,</span>
<span class="hljs-addition">+     processing_class=processor,</span>
)`,wrap:!1}}),Me=new M({props:{title:"Example script",local:"example-script",headingTag:"h2"}}),Ce=new G({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGV4YW1wbGVzJTJGc2NyaXB0cyUyRmRwby5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFzZXRfbmFtZSUyMHRybC1saWIlMkZ1bHRyYWZlZWRiYWNrX2JpbmFyaXplZCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWxvZ2dpbmdfc3RlcHMlMjAyNSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMFF3ZW4yLTAuNUItRFBP",highlighted:`accelerate launch examples/scripts/dpo.py \\
    --model_name_or_path Qwen/Qwen2-0.5B-Instruct \\
    --dataset_name trl-lib/ultrafeedback_binarized \\
    --num_train_epochs 1 \\
    --logging_steps 25 \\
    --output_dir Qwen2-0.5B-DPO`,wrap:!1}}),je=new M({props:{title:"Logged metrics",local:"logged-metrics",headingTag:"h2"}}),Pe=new M({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),De=new M({props:{title:"Label smoothing",local:"label-smoothing",headingTag:"h3"}}),Ie=new M({props:{title:"Syncing the reference model",local:"syncing-the-reference-model",headingTag:"h3"}}),qe=new M({props:{title:"RPO loss",local:"rpo-loss",headingTag:"h3"}}),Re=new M({props:{title:"WPO loss",local:"wpo-loss",headingTag:"h3"}}),We=new M({props:{title:"For Mixture of Experts Models: Enabling the auxiliary loss",local:"for-mixture-of-experts-models-enabling-the-auxiliary-loss",headingTag:"h3"}}),He=new M({props:{title:"Accelerate DPO fine-tuning using unsloth",local:"accelerate-dpo-fine-tuning-using-unsloth",headingTag:"h2"}}),Ge=new G({props:{code:"JTIwJTIwZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTIwJTIwZnJvbSUyMHRybCUyMGltcG9ydCUyMERQT0NvbmZpZyUyQyUyMERQT1RyYWluZXIlMEEtJTIwZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUyQiUyMGZyb20lMjB1bnNsb3RoJTIwaW1wb3J0JTIwRmFzdExhbmd1YWdlTW9kZWwlMEElMEEtJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBLSUyMHRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQSUyQiUyMG1vZGVsJTJDJTIwdG9rZW5pemVyJTIwJTNEJTIwRmFzdExhbmd1YWdlTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQSUyQiUyMG1vZGVsJTIwJTNEJTIwRmFzdExhbmd1YWdlTW9kZWwuZ2V0X3BlZnRfbW9kZWwobW9kZWwpJTBBJTIwJTIwdHJhaW5fZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ0cmwtbGliJTJGdWx0cmFmZWVkYmFja19iaW5hcml6ZWQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQS0lMjB0cmFpbmluZ19hcmdzJTIwJTNEJTIwRFBPQ29uZmlnKG91dHB1dF9kaXIlM0QlMjJRd2VuMi0wLjVCLURQTyUyMiUyQyUyMGxvZ2dpbmdfc3RlcHMlM0QxMCklMEElMkIlMjB0cmFpbmluZ19hcmdzJTIwJTNEJTIwRFBPQ29uZmlnKG91dHB1dF9kaXIlM0QlMjJRd2VuMi0wLjVCLURQTyUyMiUyQyUyMGxvZ2dpbmdfc3RlcHMlM0QxMCUyQyUyMGJmMTYlM0RUcnVlKSUwQSUyMCUyMHRyYWluZXIlMjAlM0QlMjBEUE9UcmFpbmVyKG1vZGVsJTNEbW9kZWwlMkMlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUyMHByb2Nlc3NpbmdfY2xhc3MlM0R0b2tlbml6ZXIlMkMlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCklMEElMjAlMjB0cmFpbmVyLnRyYWluKCklMEE=",highlighted:`  from datasets import load_dataset
  from trl import DPOConfig, DPOTrainer
<span class="hljs-deletion">- from transformers import AutoModelForCausalLM, AutoTokenizer</span>
<span class="hljs-addition">+ from unsloth import FastLanguageModel</span>

<span class="hljs-deletion">- model = AutoModelForCausalLM.from_pretrained(&quot;Qwen/Qwen2-0.5B-Instruct&quot;)</span>
<span class="hljs-deletion">- tokenizer = AutoTokenizer.from_pretrained(&quot;Qwen/Qwen2-0.5B-Instruct&quot;)</span>
<span class="hljs-addition">+ model, tokenizer = FastLanguageModel.from_pretrained(&quot;Qwen/Qwen2-0.5B-Instruct&quot;)</span>
<span class="hljs-addition">+ model = FastLanguageModel.get_peft_model(model)</span>
  train_dataset = load_dataset(&quot;trl-lib/ultrafeedback_binarized&quot;, split=&quot;train&quot;)

<span class="hljs-deletion">- training_args = DPOConfig(output_dir=&quot;Qwen2-0.5B-DPO&quot;, logging_steps=10)</span>
<span class="hljs-addition">+ training_args = DPOConfig(output_dir=&quot;Qwen2-0.5B-DPO&quot;, logging_steps=10, bf16=True)</span>
  trainer = DPOTrainer(model=model, args=training_args, processing_class=tokenizer, train_dataset=train_dataset)
  trainer.train()
`,wrap:!1}}),Xe=new M({props:{title:"Reference model considerations with PEFT",local:"reference-model-considerations-with-peft",headingTag:"h2"}}),Ke=new M({props:{title:"Downsides to merging QLoRA before DPO (approach 2)",local:"downsides-to-merging-qlora-before-dpo-approach-2",headingTag:"h3"}}),at=new M({props:{title:"Using option 3 - load the adapter twice",local:"using-option-3---load-the-adapter-twice",headingTag:"h3"}}),lt=new G({props:{code:"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",highlighted:`<span class="hljs-comment"># Load the base model.</span>
bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    llm_int8_threshold=<span class="hljs-number">6.0</span>,
    llm_int8_has_fp16_weight=<span class="hljs-literal">False</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/mixtral-8x7b-v0.1&quot;</span>,
    load_in_4bit=<span class="hljs-literal">True</span>,
    quantization_config=bnb_config,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># Load the adapter.</span>
model = PeftModel.from_pretrained(
    model,
    <span class="hljs-string">&quot;/path/to/peft&quot;</span>,
    is_trainable=<span class="hljs-literal">True</span>,
    adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
)
<span class="hljs-comment"># Load the adapter a second time, with a different name, which will be our reference model.</span>
model.load_adapter(<span class="hljs-string">&quot;/path/to/peft&quot;</span>, adapter_name=<span class="hljs-string">&quot;reference&quot;</span>)

<span class="hljs-comment"># Initialize the trainer, without a ref_model param.</span>
training_args = DPOConfig(
    model_adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
    ref_adapter_name=<span class="hljs-string">&quot;reference&quot;</span>,
)
dpo_trainer = DPOTrainer(
    model,
    args=training_args,
    ...
)`,wrap:!1}}),rt=new M({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),st=new $({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Optional = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"processing_class",val:": Union = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>DPOConfig</code>) &#x2014;
The DPO config arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.processing_class",description:`<strong>processing_class</strong> (<code>PreTrainedTokenizerBase</code> or <code>BaseImageProcessor</code> or <code>FeatureExtractionMixin</code> or <code>ProcessorMixin</code>, <em>optional</em>) &#x2014;
Processing class used to process the data. If provided, will be used to automatically process the inputs
for the model, and it will be saved along the model to make it easier to rerun an interrupted training or
reuse the fine-tuned model.
This supercedes the <code>tokenizer</code> argument, which is now deprecated.`,name:"processing_class"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/v0.12.1/trl/trainer/dpo_trainer.py#L149"}}),it=new $({props:{name:"compute_ref_log_probs",anchor:"trl.DPOTrainer.compute_ref_log_probs",parameters:[{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.12.1/trl/trainer/dpo_trainer.py#L942"}}),dt=new $({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.12.1/trl/trainer/dpo_trainer.py#L1194"}}),pt=new $({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"padding_value",val:": int"}],parametersDescription:[{anchor:"trl.DPOTrainer.concatenated_inputs.batch",description:`<strong>batch</strong> (<code>Dict[str, Union[List, torch.LongTensor]]</code>) &#x2014;
A batch of input data. The batch must contain the following keys:</p>
<ul>
<li><code>&quot;prompt_input_ids&quot;</code>: Tensor of shape <code>(batch_size, prompt_length)</code> representing the prompt input IDs.</li>
<li><code>&quot;chosen_input_ids&quot;</code>: Tensor of shape <code>(batch_size, chosen_length)</code> representing the chosen completion input IDs.</li>
<li><code>&quot;rejected_input_ids&quot;</code>: Tensor of shape <code>(batch_size, rejected_length)</code> representing the rejected completion input IDs.</li>
<li><code>&quot;prompt_pixel_values&quot;</code> (optional): Tensor for pixel values, if available.</li>
<li><code>&quot;prompt_pixel_attention_mask&quot;</code> (optional): Tensor for pixel attention masks, if available.</li>
</ul>`,name:"batch"},{anchor:"trl.DPOTrainer.concatenated_inputs.padding_value",description:`<strong>padding_value</strong> (<code>int</code>) &#x2014;
The padding value to use for the concatenated completion sequences (<code>chosen_input_ids</code> and
<code>rejected_input_ids</code>).`,name:"padding_value"}],source:"https://github.com/huggingface/trl/blob/v0.12.1/trl/trainer/dpo_trainer.py#L953",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing:</p>
<ul>
<li><code>"prompt_input_ids"</code>: Concatenated prompt input IDs of shape <code>(2 * batch_size, prompt_length)</code>.</li>
<li><code>"completion_input_ids"</code>: Concatenated chosen and rejected completion input IDs of shape <code>(2 * batch_size, max_completion_length)</code>.</li>
<li><code>"prompt_attention_mask"</code>: Concatenated prompt attention masks of shape <code>(2 * batch_size, prompt_length)</code>.</li>
<li><code>"completion_attention_mask"</code>: Concatenated chosen and rejected attention masks of shape <code>(2 * batch_size, max_completion_length)</code>.</li>
<li><code>"pixel_values"</code> (optional): Concatenated pixel values if <code>"prompt_pixel_values"</code> are present.</li>
<li><code>"pixel_attention_mask"</code> (optional): Concatenated pixel attention masks if <code>"prompt_pixel_attention_mask"</code> are present.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, torch.LongTensor]</code></p>
`}}),ct=new $({props:{name:"create_model_card",anchor:"trl.DPOTrainer.create_model_card",parameters:[{name:"model_name",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"tags",val:": Union = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.create_model_card.model_name",description:`<strong>model_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The name of the model.`,name:"model_name"},{anchor:"trl.DPOTrainer.create_model_card.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The name of the dataset used for training.`,name:"dataset_name"},{anchor:"trl.DPOTrainer.create_model_card.tags",description:`<strong>tags</strong> (<code>str</code>, <code>List[str]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Tags to be associated with the model card.`,name:"tags"}],source:"https://github.com/huggingface/trl/blob/v0.12.1/trl/trainer/dpo_trainer.py#L1534"}}),mt=new $({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"chosen_logps",val:": FloatTensor"},{name:"rejected_logps",val:": FloatTensor"},{name:"ref_chosen_logps",val:": FloatTensor"},{name:"ref_rejected_logps",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.DPOTrainer.dpo_loss.chosen_logps",description:`<strong>chosen_logps</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model for the chosen responses. Shape: <code>(batch_size,)</code>.`,name:"chosen_logps"},{anchor:"trl.DPOTrainer.dpo_loss.rejected_logps",description:`<strong>rejected_logps</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model for the rejected responses. Shape: <code>(batch_size,)</code>.`,name:"rejected_logps"},{anchor:"trl.DPOTrainer.dpo_loss.ref_chosen_logps",description:`<strong>ref_chosen_logps</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the reference model for the chosen responses. Shape: <code>(batch_size,)</code>.`,name:"ref_chosen_logps"},{anchor:"trl.DPOTrainer.dpo_loss.ref_rejected_logps",description:`<strong>ref_rejected_logps</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the reference model for the rejected responses. Shape: <code>(batch_size,)</code>.`,name:"ref_rejected_logps"}],source:"https://github.com/huggingface/trl/blob/v0.12.1/trl/trainer/dpo_trainer.py#L1021",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>(losses, chosen_rewards, rejected_rewards)</code>.
The losses tensor contains the DPO loss for each example in the batch.
The <code>chosen_rewards</code> and <code>rejected_rewards</code> tensors contain the rewards for the chosen and rejected
responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),ht=new $({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/v0.12.1/trl/trainer/dpo_trainer.py#L1468"}}),ut=new $({props:{name:"generate_from_model_and_ref",anchor:"trl.DPOTrainer.generate_from_model_and_ref",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.12.1/trl/trainer/dpo_trainer.py#L1383"}}),ft=new $({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/v0.12.1/trl/trainer/dpo_trainer.py#L1314"}}),gt=new $({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/v3.1.0/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/v0.12.1/trl/trainer/dpo_trainer.py#L880"}}),_t=new $({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.12.1/trl/trainer/dpo_trainer.py#L835"}}),bt=new $({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/v0.12.1/trl/trainer/dpo_trainer.py#L1518"}}),vt=new $({props:{name:"null_ref_context",anchor:"trl.DPOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.12.1/trl/trainer/dpo_trainer.py#L930"}}),yt=new $({props:{name:"process_row",anchor:"trl.DPOTrainer.process_row",parameters:[{name:"features",val:""},{name:"processing_class",val:""},{name:"max_prompt_length",val:""},{name:"max_completion_length",val:""},{name:"add_special_tokens",val:""}],source:"https://github.com/huggingface/trl/blob/v0.12.1/trl/trainer/dpo_trainer.py#L755"}}),wt=new $({props:{name:"tokenize_row",anchor:"trl.DPOTrainer.tokenize_row",parameters:[{name:"features",val:""},{name:"processing_class",val:""},{name:"max_prompt_length",val:""},{name:"max_completion_length",val:""},{name:"add_special_tokens",val:""}],parametersDescription:[{anchor:"trl.DPOTrainer.tokenize_row.features",description:`<strong>features</strong> (<code>Dict[str, str]</code>) &#x2014;
Row of the dataset, should contain the keys <code>&quot;prompt&quot;</code>, <code>&quot;chosen&quot;</code>, and <code>&quot;rejected&quot;</code>.`,name:"features"},{anchor:"trl.DPOTrainer.tokenize_row.processing_class",description:`<strong>processing_class</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014;
Processing class used to process the data.`,name:"processing_class"},{anchor:"trl.DPOTrainer.tokenize_row.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code> or <code>None</code>) &#x2014;
Maximum length of the prompt sequence. If <code>None</code>, the prompt sequence is not truncated.`,name:"max_prompt_length"},{anchor:"trl.DPOTrainer.tokenize_row.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code> or <code>None</code>) &#x2014;
Maximum length of the completion sequences. If <code>None</code>, the completion sequences are not truncated.`,name:"max_completion_length"},{anchor:"trl.DPOTrainer.tokenize_row.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>) &#x2014;
Whether to add special tokens to the sequences. Typically used for encoder-decoder models. If <code>True</code>,
the prompt sequence will have a bos token prepended and an eos token appended. In any case, the
completion sequences will have an eos token appended.`,name:"add_special_tokens"}],source:"https://github.com/huggingface/trl/blob/v0.12.1/trl/trainer/dpo_trainer.py#L695",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Tokenized sequences with the keys <code>"prompt_input_ids"</code>, <code>"chosen_input_ids"</code>, and
\`“rejected_input_ids”.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, List[int]]</code></p>
`}}),B=new Nl({props:{anchor:"trl.DPOTrainer.tokenize_row.example",$$slots:{default:[Ql]},$$scope:{ctx:Ut}}}),Tt=new M({props:{title:"DPOConfig",local:"trl.DPOConfig",headingTag:"h2"}}),Mt=new $({props:{name:"class trl.DPOConfig",anchor:"trl.DPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"torch_empty_cache_steps",val:": Optional = None"},{name:"learning_rate",val:": float = 1e-06"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": List = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": Optional = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"average_tokens_across_devices",val:": Optional = False"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0.0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"use_weighting",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"},{name:"f_divergence_type",val:": FDivergenceType = <FDivergenceType.REVERSE_KL: 'reverse_kl'>"},{name:"f_alpha_divergence_coef",val:": float = 1.0"},{name:"sync_ref_model",val:": bool = False"},{name:"ref_model_mixup_alpha",val:": float = 0.9"},{name:"ref_model_sync_steps",val:": int = 64"},{name:"rpo_alpha",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOConfig.learning_rate",description:`<strong>learning_rate</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1e-6</code>) &#x2014;
Initial learning rate for <code>AdamW</code> optimizer. The default value replaces that of
<a href="https://huggingface.co/docs/transformers/v4.46.2/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a>.`,name:"learning_rate"},{anchor:"trl.DPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.1</code>) &#x2014;
Parameter controlling the deviation from the reference model. Higher &#x3B2; means less deviation from the
reference model. For the IPO loss (<code>loss_type=&quot;ipo&quot;</code>), &#x3B2; is the regularization parameter denoted by &#x3C4; in
the <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">paper</a>.`,name:"beta"},{anchor:"trl.DPOConfig.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.0</code>) &#x2014;
Robust DPO label smoothing parameter from the <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> report and
<a href="https://huggingface.co/papers/2403.00409" rel="nofollow">Robust DPO</a> paper that should be between <code>0.0</code> and <code>0.5</code>.`,name:"label_smoothing"},{anchor:"trl.DPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
Type of loss to use. Possible values are:</p>
<ul>
<li><code>&quot;sigmoid&quot;</code>: sigmoid loss from the original <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">DPO</a> paper.</li>
<li><code>&quot;hinge&quot;</code>: hinge loss on the normalized likelihood from the <a href="https://huggingface.co/papers/2305.10425" rel="nofollow">SLiC</a> paper.</li>
<li><code>&quot;ipo&quot;</code>: IPO loss from the <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">IPO</a> paper.</li>
<li><code>&quot;exo_pair&quot;</code>: pairwise EXO loss from the <a href="https://huggingface.co/papers/2402.00856" rel="nofollow">EXO</a> paper.</li>
<li><code>&quot;nca_pair&quot;</code>: pairwise NCA loss from the <a href="https://huggingface.co/papers/2402.05369" rel="nofollow">NCA</a> paper.</li>
<li><code>&quot;robust&quot;</code>: unbiased estimate of the DPO loss that is robust to preference noise from the <a href="https://huggingface.co/papers/2403.00409" rel="nofollow">Robust DPO</a> paper.</li>
<li><code>&quot;bco_pair&quot;</code>: pairwise BCO loss from the <a href="https://huggingface.co/papers/2404.04656" rel="nofollow">BCO</a> paper.</li>
<li><code>&quot;sppo_hard&quot;</code>: SPPO loss with hard label from the <a href="https://huggingface.co/papers/2405.00675" rel="nofollow">SPPO</a> paper.</li>
<li><code>&quot;aot&quot;</code>: AOT loss for paired datasets from the <a href="https://huggingface.co/papers/2406.05882" rel="nofollow">AOT</a> paper.</li>
<li><code>&quot;aot_pair&quot;</code>: AOT loss for unpaired datasets from the <a href="https://huggingface.co/papers/2406.05882" rel="nofollow">AOT</a> paper.</li>
<li><code>&quot;apo_zero&quot;</code>: APO-zero loss from the <a href="https://huggingface.co/papers/2408.06266" rel="nofollow">APO</a> paper.</li>
<li><code>&quot;apo_down&quot;</code>: APO-down loss from the <a href="https://huggingface.co/papers/2408.06266" rel="nofollow">APO</a> paper.</li>
</ul>`,name:"loss_type"},{anchor:"trl.DPOConfig.use_weighting",description:`<strong>use_weighting</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to weight the loss as done in the <a href="https://huggingface.co/papers/2406.11827" rel="nofollow">WPO</a> paper.`,name:"use_weighting"},{anchor:"trl.DPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>-100</code>) &#x2014;
Label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Padding value to use. If <code>None</code>, the padding value of the tokenizer is used.`,name:"padding_value"},{anchor:"trl.DPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;keep_end&quot;</code>) &#x2014;
Truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the
default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOConfig.max_length",description:`<strong>max_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the sequences (prompt + completion) in the batch. This argument is required if you want
to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the target. This argument is required if you want to use the default data collator and
your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.DPOConfig.is_encoder_decoder(Optional[int],",description:`<strong>is_encoder_decoder(<code>Optional[int]</code>,</strong> <em>optional</em>, defaults to <code>None</code>) &#x2014;
When using the <code>model_init</code> argument (callable) to instantiate the model instead of the <code>model</code> argument,
you need to specify if the model returned by the callable is an encoder-decoder model.`,name:"is_encoder_decoder(Optional[int],"},{anchor:"trl.DPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to disable dropout in the model and reference model.`,name:"disable_dropout"},{anchor:"trl.DPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Truncation mode to use when the prompt is too long. Possible values are <code>&quot;keep_end&quot;</code> or <code>&quot;keep_start&quot;</code>.
This argument is required if you want to use the default data collator.`,name:"generate_during_eval"},{anchor:"trl.DPOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to precompute reference model log probabilities for training and evaluation datasets. This is
useful when training without the reference model to reduce the total GPU memory needed.`,name:"precompute_ref_log_probs"},{anchor:"trl.DPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes to use for processing the dataset.`,name:"dataset_num_proc"},{anchor:"trl.DPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the model from a
string.`,name:"model_init_kwargs"},{anchor:"trl.DPOConfig.ref_model_init_kwargs",description:`<strong>ref_model_init_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the reference model
from a string.`,name:"ref_model_init_kwargs"},{anchor:"trl.DPOConfig.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.DPOConfig.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"},{anchor:"trl.DPOConfig.reference_free",description:`<strong>reference_free</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, we ignore the <em>provided</em> reference model and implicitly use a reference model that assigns equal
probability to all responses.`,name:"reference_free"},{anchor:"trl.DPOConfig.force_use_ref_model",description:`<strong>force_use_ref_model</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
In case one passes a PEFT model for the active model and you want to use a different model for the
ref_model, set this flag to <code>True</code>.`,name:"force_use_ref_model"},{anchor:"trl.DPOConfig.f_divergence_type",description:`<strong>f_divergence_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>FDivergenceType.REVERSE_KL</code>) &#x2014;
Type of f-divergence regularization function to compute divergence between policy and reference model.`,name:"f_divergence_type"},{anchor:"trl.DPOConfig.f_alpha_divergence_coef",description:`<strong>f_alpha_divergence_coef</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
&#x3B1; coefficient in the &#x3B1;-divergence u^-&#x3B1; regularization function for DPO loss.`,name:"f_alpha_divergence_coef"},{anchor:"trl.DPOConfig.sync_ref_model",description:`<strong>sync_ref_model</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
When set to <code>True</code>, the reference model is synchronized with the active model every <code>ref_model_sync_steps</code>
steps, using the <code>ref_model_mixup_alpha</code> parameter. This synchronization originites from the
<a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper.`,name:"sync_ref_model"},{anchor:"trl.DPOConfig.ref_model_mixup_alpha",description:`<strong>ref_model_mixup_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.9</code>) &#x2014;
&#x3B1; parameter from the <a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper, which controls the mix
between the current policy and the previous reference policy during updates. The reference policy is
updated according to the equation: <code>&#x3C0;_ref = &#x3B1; * &#x3C0;_&#x3B8; + (1 - &#x3B1;) * &#x3C0;_ref_prev</code>
To use this parameter, you must set <code>sync_ref_model=True</code>.`,name:"ref_model_mixup_alpha"},{anchor:"trl.DPOConfig.ref_model_sync_steps",description:`<strong>ref_model_sync_steps</strong> (<code>int</code>, <em>optional</em>, defaults to <code>64</code>) &#x2014;
&#x3C4; parameter from the <a href="https://huggingface.co/papers/2404.09656" rel="nofollow">TR-DPO</a> paper, which determines how
frequently the current policy is synchronized with the reference policy. To use this parameter, you must
set <code>sync_ref_model=True</code>.`,name:"ref_model_sync_steps"},{anchor:"trl.DPOConfig.rpo_alpha",description:`<strong>rpo_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
&#x3B1; parameter from the <a href="https://huggingface.co/papers/2404.19733" rel="nofollow">RPO</a> paper (v3), which controls the
weighting of the NLL term in the loss. If <code>None</code>, no weighting is applied and the loss is the same as the
DPO loss. The paper recommends <code>rpo_alpha=1.0</code>.`,name:"rpo_alpha"}],source:"https://github.com/huggingface/trl/blob/v0.12.1/trl/trainer/dpo_config.py#L33"}}),xt=new M({props:{title:"PreferenceCollator",local:"trl.trainer.dpo_trainer.PreferenceCollator",headingTag:"h2"}}),$t=new $({props:{name:"class trl.trainer.dpo_trainer.PreferenceCollator",anchor:"trl.trainer.dpo_trainer.PreferenceCollator",parameters:[{name:"pad_token_id",val:": int"},{name:"return_tensors",val:": str = 'pt'"}],parametersDescription:[{anchor:"trl.trainer.dpo_trainer.PreferenceCollator.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>) &#x2014;
Token ID to use for padding.`,name:"pad_token_id"},{anchor:"trl.trainer.dpo_trainer.PreferenceCollator.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
Type of Tensor to return. Only <code>&quot;pt&quot;</code> is currently supported.`,name:"return_tensors"}],source:"https://github.com/huggingface/trl/blob/v0.12.1/trl/trainer/dpo_trainer.py#L80"}}),V=new Nl({props:{anchor:"trl.trainer.dpo_trainer.PreferenceCollator.example",$$slots:{default:[Bl]},$$scope:{ctx:Ut}}}),Ct=new Hl({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/dpo_trainer.mdx"}}),{c(){v=r("meta"),P=n(),C=r("p"),w=n(),p(x.$$.fragment),b=n(),j=r("p"),j.innerHTML=Tn,sa=n(),p(A.$$.fragment),ia=n(),X=r("p"),X.innerHTML=Mn,da=n(),S=r("p"),S.textContent=xn,pa=n(),Y=r("blockquote"),Y.innerHTML=$n,ca=n(),K=r("p"),K.textContent=Cn,ma=n(),ee=r("p"),ee.innerHTML=jn,ha=n(),te=r("ol"),te.innerHTML=Un,ua=n(),ae=r("p"),ae.innerHTML=On,fa=n(),oe=r("p"),oe.innerHTML=Pn,ga=n(),ne=r("p"),ne.innerHTML=Jn,_a=n(),p(le.$$.fragment),ba=n(),re=r("p"),re.innerHTML=kn,va=n(),J=r("iframe"),ya=n(),se=r("p"),se.textContent=Fn,wa=n(),p(ie.$$.fragment),Ta=n(),de=r("p"),de.textContent=In,Ma=n(),p(pe.$$.fragment),xa=n(),ce=r("p"),ce.textContent=Nn,$a=n(),me=r("p"),me.innerHTML=qn,Ca=n(),he=r("p"),he.innerHTML=Ln,ja=n(),ue=r("pre"),ue.innerHTML=Rn,Ua=n(),p(fe.$$.fragment),Oa=n(),ge=r("p"),ge.innerHTML=Zn,Pa=n(),_e=r("p"),_e.innerHTML=Wn,Ja=n(),p(be.$$.fragment),ka=n(),ve=r("p"),ve.innerHTML=En,Da=n(),ye=r("p"),ye.innerHTML=zn,Fa=n(),p(we.$$.fragment),Ia=n(),Te=r("p"),Te.innerHTML=Hn,Na=n(),p(Me.$$.fragment),qa=n(),xe=r("p"),xe.innerHTML=Qn,La=n(),$e=r("p"),$e.innerHTML=Bn,Ra=n(),p(Ce.$$.fragment),Za=n(),p(je.$$.fragment),Wa=n(),Ue=r("p"),Ue.textContent=Vn,Ea=n(),Oe=r("ul"),Oe.innerHTML=Gn,za=n(),p(Pe.$$.fragment),Ha=n(),Je=r("p"),Je.innerHTML=An,Qa=n(),ke=r("table"),ke.innerHTML=Xn,Ba=n(),p(De.$$.fragment),Va=n(),Fe=r("p"),Fe.innerHTML=Sn,Ga=n(),p(Ie.$$.fragment),Aa=n(),Ne=r("p"),Ne.innerHTML=Yn,Xa=n(),p(qe.$$.fragment),Sa=n(),Le=r("p"),Le.innerHTML=Kn,Ya=n(),p(Re.$$.fragment),Ka=n(),Ze=r("p"),Ze.innerHTML=el,eo=n(),p(We.$$.fragment),to=n(),Ee=r("p"),Ee.innerHTML=tl,ao=n(),ze=r("p"),ze.innerHTML=al,oo=n(),p(He.$$.fragment),no=n(),Qe=r("p"),Qe.innerHTML=ol,lo=n(),Be=r("table"),Be.innerHTML=nl,ro=n(),Ve=r("p"),Ve.innerHTML=ll,so=n(),p(Ge.$$.fragment),io=n(),Ae=r("p"),Ae.innerHTML=rl,po=n(),p(Xe.$$.fragment),co=n(),Se=r("p"),Se.textContent=sl,mo=n(),Ye=r("ol"),Ye.innerHTML=il,ho=n(),p(Ke.$$.fragment),uo=n(),et=r("p"),et.innerHTML=dl,fo=n(),tt=r("p"),tt.textContent=pl,go=n(),p(at.$$.fragment),_o=n(),ot=r("p"),ot.innerHTML=cl,bo=n(),nt=r("p"),nt.textContent=ml,vo=n(),p(lt.$$.fragment),yo=n(),p(rt.$$.fragment),wo=n(),g=r("div"),p(st.$$.fragment),No=n(),Ot=r("p"),Ot.textContent=hl,qo=n(),L=r("div"),p(it.$$.fragment),Lo=n(),Pt=r("p"),Pt.textContent=ul,Ro=n(),k=r("div"),p(dt.$$.fragment),Zo=n(),Jt=r("p"),Jt.textContent=fl,Wo=n(),kt=r("p"),kt.textContent=gl,Eo=n(),D=r("div"),p(pt.$$.fragment),zo=n(),Dt=r("p"),Dt.innerHTML=_l,Ho=n(),Ft=r("p"),Ft.textContent=bl,Qo=n(),R=r("div"),p(ct.$$.fragment),Bo=n(),It=r("p"),It.innerHTML=vl,Vo=n(),Z=r("div"),p(mt.$$.fragment),Go=n(),Nt=r("p"),Nt.textContent=yl,Ao=n(),F=r("div"),p(ht.$$.fragment),Xo=n(),qt=r("p"),qt.innerHTML=wl,So=n(),Lt=r("p"),Lt.textContent=Tl,Yo=n(),W=r("div"),p(ut.$$.fragment),Ko=n(),Rt=r("p"),Rt.textContent=Ml,en=n(),E=r("div"),p(ft.$$.fragment),tn=n(),Zt=r("p"),Zt.textContent=xl,an=n(),I=r("div"),p(gt.$$.fragment),on=n(),Wt=r("p"),Wt.innerHTML=$l,nn=n(),Et=r("p"),Et.innerHTML=Cl,ln=n(),N=r("div"),p(_t.$$.fragment),rn=n(),zt=r("p"),zt.innerHTML=jl,sn=n(),Ht=r("p"),Ht.innerHTML=Ul,dn=n(),z=r("div"),p(bt.$$.fragment),pn=n(),Qt=r("p"),Qt.innerHTML=Ol,cn=n(),H=r("div"),p(vt.$$.fragment),mn=n(),Bt=r("p"),Bt.textContent=Pl,hn=n(),Q=r("div"),p(yt.$$.fragment),un=n(),Vt=r("p"),Vt.innerHTML=Jl,fn=n(),q=r("div"),p(wt.$$.fragment),gn=n(),Gt=r("p"),Gt.textContent=kl,_n=n(),p(B.$$.fragment),To=n(),p(Tt.$$.fragment),Mo=n(),U=r("div"),p(Mt.$$.fragment),bn=n(),At=r("p"),At.innerHTML=Dl,vn=n(),Xt=r("p"),Xt.innerHTML=Fl,xo=n(),p(xt.$$.fragment),$o=n(),O=r("div"),p($t.$$.fragment),yn=n(),St=r("p"),St.textContent=Il,wn=n(),p(V.$$.fragment),Co=n(),p(Ct.$$.fragment),jo=n(),ra=r("p"),this.h()},l(e){const t=zl("svelte-u9bgzb",document.head);v=s(t,"META",{name:!0,content:!0}),t.forEach(a),P=l(e),C=s(e,"P",{}),T(C).forEach(a),w=l(e),c(x.$$.fragment,e),b=l(e),j=s(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-1phtljg"&&(j.innerHTML=Tn),sa=l(e),c(A.$$.fragment,e),ia=l(e),X=s(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-z3e1vo"&&(X.innerHTML=Mn),da=l(e),S=s(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-vfdo9a"&&(S.textContent=xn),pa=l(e),Y=s(e,"BLOCKQUOTE",{"data-svelte-h":!0}),d(Y)!=="svelte-79s4co"&&(Y.innerHTML=$n),ca=l(e),K=s(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-nj0mw8"&&(K.textContent=Cn),ma=l(e),ee=s(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1shy0cc"&&(ee.innerHTML=jn),ha=l(e),te=s(e,"OL",{"data-svelte-h":!0}),d(te)!=="svelte-191izpi"&&(te.innerHTML=Un),ua=l(e),ae=s(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-12mg2q5"&&(ae.innerHTML=On),fa=l(e),oe=s(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1281kkc"&&(oe.innerHTML=Pn),ga=l(e),ne=s(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-16acsjo"&&(ne.innerHTML=Jn),_a=l(e),c(le.$$.fragment,e),ba=l(e),re=s(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-hit9c8"&&(re.innerHTML=kn),va=l(e),J=s(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),T(J).forEach(a),ya=l(e),se=s(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-uqytq6"&&(se.textContent=Fn),wa=l(e),c(ie.$$.fragment,e),Ta=l(e),de=s(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-15hino8"&&(de.textContent=In),Ma=l(e),c(pe.$$.fragment,e),xa=l(e),ce=s(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-yajp6a"&&(ce.textContent=Nn),$a=l(e),me=s(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-4zuv47"&&(me.innerHTML=qn),Ca=l(e),he=s(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-kj7i7s"&&(he.innerHTML=Ln),ja=l(e),ue=s(e,"PRE",{"data-svelte-h":!0}),d(ue)!=="svelte-1d8earv"&&(ue.innerHTML=Rn),Ua=l(e),c(fe.$$.fragment,e),Oa=l(e),ge=s(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-meubv"&&(ge.innerHTML=Zn),Pa=l(e),_e=s(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-reegzf"&&(_e.innerHTML=Wn),Ja=l(e),c(be.$$.fragment,e),ka=l(e),ve=s(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-n8pr7l"&&(ve.innerHTML=En),Da=l(e),ye=s(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1641qgj"&&(ye.innerHTML=zn),Fa=l(e),c(we.$$.fragment,e),Ia=l(e),Te=s(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-112nfxj"&&(Te.innerHTML=Hn),Na=l(e),c(Me.$$.fragment,e),qa=l(e),xe=s(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-1k7pp2t"&&(xe.innerHTML=Qn),La=l(e),$e=s(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-ob6zvc"&&($e.innerHTML=Bn),Ra=l(e),c(Ce.$$.fragment,e),Za=l(e),c(je.$$.fragment,e),Wa=l(e),Ue=s(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-132s7j9"&&(Ue.textContent=Vn),Ea=l(e),Oe=s(e,"UL",{"data-svelte-h":!0}),d(Oe)!=="svelte-1oji3mm"&&(Oe.innerHTML=Gn),za=l(e),c(Pe.$$.fragment,e),Ha=l(e),Je=s(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1bj71gt"&&(Je.innerHTML=An),Qa=l(e),ke=s(e,"TABLE",{"data-svelte-h":!0}),d(ke)!=="svelte-19i9mhe"&&(ke.innerHTML=Xn),Ba=l(e),c(De.$$.fragment,e),Va=l(e),Fe=s(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1dbleoh"&&(Fe.innerHTML=Sn),Ga=l(e),c(Ie.$$.fragment,e),Aa=l(e),Ne=s(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-4vz9vz"&&(Ne.innerHTML=Yn),Xa=l(e),c(qe.$$.fragment,e),Sa=l(e),Le=s(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-2lln2b"&&(Le.innerHTML=Kn),Ya=l(e),c(Re.$$.fragment,e),Ka=l(e),Ze=s(e,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-16z2qil"&&(Ze.innerHTML=el),eo=l(e),c(We.$$.fragment,e),to=l(e),Ee=s(e,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-14px1ga"&&(Ee.innerHTML=tl),ao=l(e),ze=s(e,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1m72n2k"&&(ze.innerHTML=al),oo=l(e),c(He.$$.fragment,e),no=l(e),Qe=s(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-2145zu"&&(Qe.innerHTML=ol),lo=l(e),Be=s(e,"TABLE",{"data-svelte-h":!0}),d(Be)!=="svelte-435mua"&&(Be.innerHTML=nl),ro=l(e),Ve=s(e,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-1p74c9x"&&(Ve.innerHTML=ll),so=l(e),c(Ge.$$.fragment,e),io=l(e),Ae=s(e,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1o18rwj"&&(Ae.innerHTML=rl),po=l(e),c(Xe.$$.fragment,e),co=l(e),Se=s(e,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-4infz6"&&(Se.textContent=sl),mo=l(e),Ye=s(e,"OL",{"data-svelte-h":!0}),d(Ye)!=="svelte-4ytutj"&&(Ye.innerHTML=il),ho=l(e),c(Ke.$$.fragment,e),uo=l(e),et=s(e,"P",{"data-svelte-h":!0}),d(et)!=="svelte-rqj7uy"&&(et.innerHTML=dl),fo=l(e),tt=s(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-1xhv3st"&&(tt.textContent=pl),go=l(e),c(at.$$.fragment,e),_o=l(e),ot=s(e,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-2fpxhy"&&(ot.innerHTML=cl),bo=l(e),nt=s(e,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-1gkqha7"&&(nt.textContent=ml),vo=l(e),c(lt.$$.fragment,e),yo=l(e),c(rt.$$.fragment,e),wo=l(e),g=s(e,"DIV",{class:!0});var _=T(g);c(st.$$.fragment,_),No=l(_),Ot=s(_,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-n6cc8y"&&(Ot.textContent=hl),qo=l(_),L=s(_,"DIV",{class:!0});var jt=T(L);c(it.$$.fragment,jt),Lo=l(jt),Pt=s(jt,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-10t1062"&&(Pt.textContent=ul),jt.forEach(a),Ro=l(_),k=s(_,"DIV",{class:!0});var Yt=T(k);c(dt.$$.fragment,Yt),Zo=l(Yt),Jt=s(Yt,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-16i1nac"&&(Jt.textContent=fl),Wo=l(Yt),kt=s(Yt,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-tgti68"&&(kt.textContent=gl),Yt.forEach(a),Eo=l(_),D=s(_,"DIV",{class:!0});var Kt=T(D);c(pt.$$.fragment,Kt),zo=l(Kt),Dt=s(Kt,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-1tqislr"&&(Dt.innerHTML=_l),Ho=l(Kt),Ft=s(Kt,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-1a2t2mf"&&(Ft.textContent=bl),Kt.forEach(a),Qo=l(_),R=s(_,"DIV",{class:!0});var Oo=T(R);c(ct.$$.fragment,Oo),Bo=l(Oo),It=s(Oo,"P",{"data-svelte-h":!0}),d(It)!=="svelte-1mh859w"&&(It.innerHTML=vl),Oo.forEach(a),Vo=l(_),Z=s(_,"DIV",{class:!0});var Po=T(Z);c(mt.$$.fragment,Po),Go=l(Po),Nt=s(Po,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-ymgxq7"&&(Nt.textContent=yl),Po.forEach(a),Ao=l(_),F=s(_,"DIV",{class:!0});var ea=T(F);c(ht.$$.fragment,ea),Xo=l(ea),qt=s(ea,"P",{"data-svelte-h":!0}),d(qt)!=="svelte-8qlty5"&&(qt.innerHTML=wl),So=l(ea),Lt=s(ea,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-1tyo99t"&&(Lt.textContent=Tl),ea.forEach(a),Yo=l(_),W=s(_,"DIV",{class:!0});var Jo=T(W);c(ut.$$.fragment,Jo),Ko=l(Jo),Rt=s(Jo,"P",{"data-svelte-h":!0}),d(Rt)!=="svelte-18uwvbi"&&(Rt.textContent=Ml),Jo.forEach(a),en=l(_),E=s(_,"DIV",{class:!0});var ko=T(E);c(ft.$$.fragment,ko),tn=l(ko),Zt=s(ko,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-11q8u7l"&&(Zt.textContent=xl),ko.forEach(a),an=l(_),I=s(_,"DIV",{class:!0});var ta=T(I);c(gt.$$.fragment,ta),on=l(ta),Wt=s(ta,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-xesobz"&&(Wt.innerHTML=$l),nn=l(ta),Et=s(ta,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-qg43tm"&&(Et.innerHTML=Cl),ta.forEach(a),ln=l(_),N=s(_,"DIV",{class:!0});var aa=T(N);c(_t.$$.fragment,aa),rn=l(aa),zt=s(aa,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-dkae9b"&&(zt.innerHTML=jl),sn=l(aa),Ht=s(aa,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-hmd5cw"&&(Ht.innerHTML=Ul),aa.forEach(a),dn=l(_),z=s(_,"DIV",{class:!0});var Do=T(z);c(bt.$$.fragment,Do),pn=l(Do),Qt=s(Do,"P",{"data-svelte-h":!0}),d(Qt)!=="svelte-nqksfz"&&(Qt.innerHTML=Ol),Do.forEach(a),cn=l(_),H=s(_,"DIV",{class:!0});var Fo=T(H);c(vt.$$.fragment,Fo),mn=l(Fo),Bt=s(Fo,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-17kjsy4"&&(Bt.textContent=Pl),Fo.forEach(a),hn=l(_),Q=s(_,"DIV",{class:!0});var Io=T(Q);c(yt.$$.fragment,Io),un=l(Io),Vt=s(Io,"P",{"data-svelte-h":!0}),d(Vt)!=="svelte-ps14rv"&&(Vt.innerHTML=Jl),Io.forEach(a),fn=l(_),q=s(_,"DIV",{class:!0});var oa=T(q);c(wt.$$.fragment,oa),gn=l(oa),Gt=s(oa,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-dujibq"&&(Gt.textContent=kl),_n=l(oa),c(B.$$.fragment,oa),oa.forEach(a),_.forEach(a),To=l(e),c(Tt.$$.fragment,e),Mo=l(e),U=s(e,"DIV",{class:!0});var na=T(U);c(Mt.$$.fragment,na),bn=l(na),At=s(na,"P",{"data-svelte-h":!0}),d(At)!=="svelte-iwavvm"&&(At.innerHTML=Dl),vn=l(na),Xt=s(na,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-u0d370"&&(Xt.innerHTML=Fl),na.forEach(a),xo=l(e),c(xt.$$.fragment,e),$o=l(e),O=s(e,"DIV",{class:!0});var la=T(O);c($t.$$.fragment,la),yn=l(la),St=s(la,"P",{"data-svelte-h":!0}),d(St)!=="svelte-jiakry"&&(St.textContent=Il),wn=l(la),c(V.$$.fragment,la),la.forEach(a),Co=l(e),c(Ct.$$.fragment,e),jo=l(e),ra=s(e,"P",{}),T(ra).forEach(a),this.h()},h(){y(v,"name","hf:doc:metadata"),y(v,"content",Gl),Rl(J.src,Dn="https://huggingface.co/datasets/trl-lib/ultrafeedback_binarized/embed/viewer/default/train?row=0")||y(J,"src",Dn),y(J,"frameborder","0"),y(J,"width","100%"),y(J,"height","560px"),y(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,v),o(e,P,t),o(e,C,t),o(e,w,t),m(x,e,t),o(e,b,t),o(e,j,t),o(e,sa,t),m(A,e,t),o(e,ia,t),o(e,X,t),o(e,da,t),o(e,S,t),o(e,pa,t),o(e,Y,t),o(e,ca,t),o(e,K,t),o(e,ma,t),o(e,ee,t),o(e,ha,t),o(e,te,t),o(e,ua,t),o(e,ae,t),o(e,fa,t),o(e,oe,t),o(e,ga,t),o(e,ne,t),o(e,_a,t),m(le,e,t),o(e,ba,t),o(e,re,t),o(e,va,t),o(e,J,t),o(e,ya,t),o(e,se,t),o(e,wa,t),m(ie,e,t),o(e,Ta,t),o(e,de,t),o(e,Ma,t),m(pe,e,t),o(e,xa,t),o(e,ce,t),o(e,$a,t),o(e,me,t),o(e,Ca,t),o(e,he,t),o(e,ja,t),o(e,ue,t),o(e,Ua,t),m(fe,e,t),o(e,Oa,t),o(e,ge,t),o(e,Pa,t),o(e,_e,t),o(e,Ja,t),m(be,e,t),o(e,ka,t),o(e,ve,t),o(e,Da,t),o(e,ye,t),o(e,Fa,t),m(we,e,t),o(e,Ia,t),o(e,Te,t),o(e,Na,t),m(Me,e,t),o(e,qa,t),o(e,xe,t),o(e,La,t),o(e,$e,t),o(e,Ra,t),m(Ce,e,t),o(e,Za,t),m(je,e,t),o(e,Wa,t),o(e,Ue,t),o(e,Ea,t),o(e,Oe,t),o(e,za,t),m(Pe,e,t),o(e,Ha,t),o(e,Je,t),o(e,Qa,t),o(e,ke,t),o(e,Ba,t),m(De,e,t),o(e,Va,t),o(e,Fe,t),o(e,Ga,t),m(Ie,e,t),o(e,Aa,t),o(e,Ne,t),o(e,Xa,t),m(qe,e,t),o(e,Sa,t),o(e,Le,t),o(e,Ya,t),m(Re,e,t),o(e,Ka,t),o(e,Ze,t),o(e,eo,t),m(We,e,t),o(e,to,t),o(e,Ee,t),o(e,ao,t),o(e,ze,t),o(e,oo,t),m(He,e,t),o(e,no,t),o(e,Qe,t),o(e,lo,t),o(e,Be,t),o(e,ro,t),o(e,Ve,t),o(e,so,t),m(Ge,e,t),o(e,io,t),o(e,Ae,t),o(e,po,t),m(Xe,e,t),o(e,co,t),o(e,Se,t),o(e,mo,t),o(e,Ye,t),o(e,ho,t),m(Ke,e,t),o(e,uo,t),o(e,et,t),o(e,fo,t),o(e,tt,t),o(e,go,t),m(at,e,t),o(e,_o,t),o(e,ot,t),o(e,bo,t),o(e,nt,t),o(e,vo,t),m(lt,e,t),o(e,yo,t),m(rt,e,t),o(e,wo,t),o(e,g,t),m(st,g,null),i(g,No),i(g,Ot),i(g,qo),i(g,L),m(it,L,null),i(L,Lo),i(L,Pt),i(g,Ro),i(g,k),m(dt,k,null),i(k,Zo),i(k,Jt),i(k,Wo),i(k,kt),i(g,Eo),i(g,D),m(pt,D,null),i(D,zo),i(D,Dt),i(D,Ho),i(D,Ft),i(g,Qo),i(g,R),m(ct,R,null),i(R,Bo),i(R,It),i(g,Vo),i(g,Z),m(mt,Z,null),i(Z,Go),i(Z,Nt),i(g,Ao),i(g,F),m(ht,F,null),i(F,Xo),i(F,qt),i(F,So),i(F,Lt),i(g,Yo),i(g,W),m(ut,W,null),i(W,Ko),i(W,Rt),i(g,en),i(g,E),m(ft,E,null),i(E,tn),i(E,Zt),i(g,an),i(g,I),m(gt,I,null),i(I,on),i(I,Wt),i(I,nn),i(I,Et),i(g,ln),i(g,N),m(_t,N,null),i(N,rn),i(N,zt),i(N,sn),i(N,Ht),i(g,dn),i(g,z),m(bt,z,null),i(z,pn),i(z,Qt),i(g,cn),i(g,H),m(vt,H,null),i(H,mn),i(H,Bt),i(g,hn),i(g,Q),m(yt,Q,null),i(Q,un),i(Q,Vt),i(g,fn),i(g,q),m(wt,q,null),i(q,gn),i(q,Gt),i(q,_n),m(B,q,null),o(e,To,t),m(Tt,e,t),o(e,Mo,t),o(e,U,t),m(Mt,U,null),i(U,bn),i(U,At),i(U,vn),i(U,Xt),o(e,xo,t),m(xt,e,t),o(e,$o,t),o(e,O,t),m($t,O,null),i(O,yn),i(O,St),i(O,wn),m(V,O,null),o(e,Co,t),m(Ct,e,t),o(e,jo,t),o(e,ra,t),Uo=!0},p(e,[t]){const _={};t&2&&(_.$$scope={dirty:t,ctx:e}),B.$set(_);const jt={};t&2&&(jt.$$scope={dirty:t,ctx:e}),V.$set(jt)},i(e){Uo||(h(x.$$.fragment,e),h(A.$$.fragment,e),h(le.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(fe.$$.fragment,e),h(be.$$.fragment,e),h(we.$$.fragment,e),h(Me.$$.fragment,e),h(Ce.$$.fragment,e),h(je.$$.fragment,e),h(Pe.$$.fragment,e),h(De.$$.fragment,e),h(Ie.$$.fragment,e),h(qe.$$.fragment,e),h(Re.$$.fragment,e),h(We.$$.fragment,e),h(He.$$.fragment,e),h(Ge.$$.fragment,e),h(Xe.$$.fragment,e),h(Ke.$$.fragment,e),h(at.$$.fragment,e),h(lt.$$.fragment,e),h(rt.$$.fragment,e),h(st.$$.fragment,e),h(it.$$.fragment,e),h(dt.$$.fragment,e),h(pt.$$.fragment,e),h(ct.$$.fragment,e),h(mt.$$.fragment,e),h(ht.$$.fragment,e),h(ut.$$.fragment,e),h(ft.$$.fragment,e),h(gt.$$.fragment,e),h(_t.$$.fragment,e),h(bt.$$.fragment,e),h(vt.$$.fragment,e),h(yt.$$.fragment,e),h(wt.$$.fragment,e),h(B.$$.fragment,e),h(Tt.$$.fragment,e),h(Mt.$$.fragment,e),h(xt.$$.fragment,e),h($t.$$.fragment,e),h(V.$$.fragment,e),h(Ct.$$.fragment,e),Uo=!0)},o(e){u(x.$$.fragment,e),u(A.$$.fragment,e),u(le.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(fe.$$.fragment,e),u(be.$$.fragment,e),u(we.$$.fragment,e),u(Me.$$.fragment,e),u(Ce.$$.fragment,e),u(je.$$.fragment,e),u(Pe.$$.fragment,e),u(De.$$.fragment,e),u(Ie.$$.fragment,e),u(qe.$$.fragment,e),u(Re.$$.fragment,e),u(We.$$.fragment,e),u(He.$$.fragment,e),u(Ge.$$.fragment,e),u(Xe.$$.fragment,e),u(Ke.$$.fragment,e),u(at.$$.fragment,e),u(lt.$$.fragment,e),u(rt.$$.fragment,e),u(st.$$.fragment,e),u(it.$$.fragment,e),u(dt.$$.fragment,e),u(pt.$$.fragment,e),u(ct.$$.fragment,e),u(mt.$$.fragment,e),u(ht.$$.fragment,e),u(ut.$$.fragment,e),u(ft.$$.fragment,e),u(gt.$$.fragment,e),u(_t.$$.fragment,e),u(bt.$$.fragment,e),u(vt.$$.fragment,e),u(yt.$$.fragment,e),u(wt.$$.fragment,e),u(B.$$.fragment,e),u(Tt.$$.fragment,e),u(Mt.$$.fragment,e),u(xt.$$.fragment,e),u($t.$$.fragment,e),u(V.$$.fragment,e),u(Ct.$$.fragment,e),Uo=!1},d(e){e&&(a(P),a(C),a(w),a(b),a(j),a(sa),a(ia),a(X),a(da),a(S),a(pa),a(Y),a(ca),a(K),a(ma),a(ee),a(ha),a(te),a(ua),a(ae),a(fa),a(oe),a(ga),a(ne),a(_a),a(ba),a(re),a(va),a(J),a(ya),a(se),a(wa),a(Ta),a(de),a(Ma),a(xa),a(ce),a($a),a(me),a(Ca),a(he),a(ja),a(ue),a(Ua),a(Oa),a(ge),a(Pa),a(_e),a(Ja),a(ka),a(ve),a(Da),a(ye),a(Fa),a(Ia),a(Te),a(Na),a(qa),a(xe),a(La),a($e),a(Ra),a(Za),a(Wa),a(Ue),a(Ea),a(Oe),a(za),a(Ha),a(Je),a(Qa),a(ke),a(Ba),a(Va),a(Fe),a(Ga),a(Aa),a(Ne),a(Xa),a(Sa),a(Le),a(Ya),a(Ka),a(Ze),a(eo),a(to),a(Ee),a(ao),a(ze),a(oo),a(no),a(Qe),a(lo),a(Be),a(ro),a(Ve),a(so),a(io),a(Ae),a(po),a(co),a(Se),a(mo),a(Ye),a(ho),a(uo),a(et),a(fo),a(tt),a(go),a(_o),a(ot),a(bo),a(nt),a(vo),a(yo),a(wo),a(g),a(To),a(Mo),a(U),a(xo),a($o),a(O),a(Co),a(jo),a(ra)),a(v),f(x,e),f(A,e),f(le,e),f(ie,e),f(pe,e),f(fe,e),f(be,e),f(we,e),f(Me,e),f(Ce,e),f(je,e),f(Pe,e),f(De,e),f(Ie,e),f(qe,e),f(Re,e),f(We,e),f(He,e),f(Ge,e),f(Xe,e),f(Ke,e),f(at,e),f(lt,e),f(rt,e),f(st),f(it),f(dt),f(pt),f(ct),f(mt),f(ht),f(ut),f(ft),f(gt),f(_t),f(bt),f(vt),f(yt),f(wt),f(B),f(Tt,e),f(Mt),f(xt,e),f($t),f(V),f(Ct,e)}}}const Gl='{"title":"DPO Trainer","local":"dpo-trainer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Quick start","local":"quick-start","sections":[],"depth":2},{"title":"Expected dataset type","local":"expected-dataset-type","sections":[{"title":"Special considerations for vision-language models","local":"special-considerations-for-vision-language-models","sections":[],"depth":3}],"depth":2},{"title":"Example script","local":"example-script","sections":[],"depth":2},{"title":"Logged metrics","local":"logged-metrics","sections":[],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[{"title":"Label smoothing","local":"label-smoothing","sections":[],"depth":3},{"title":"Syncing the reference model","local":"syncing-the-reference-model","sections":[],"depth":3},{"title":"RPO loss","local":"rpo-loss","sections":[],"depth":3},{"title":"WPO loss","local":"wpo-loss","sections":[],"depth":3},{"title":"For Mixture of Experts Models: Enabling the auxiliary loss","local":"for-mixture-of-experts-models-enabling-the-auxiliary-loss","sections":[],"depth":3}],"depth":2},{"title":"Accelerate DPO fine-tuning using unsloth","local":"accelerate-dpo-fine-tuning-using-unsloth","sections":[],"depth":2},{"title":"Reference model considerations with PEFT","local":"reference-model-considerations-with-peft","sections":[{"title":"Downsides to merging QLoRA before DPO (approach 2)","local":"downsides-to-merging-qlora-before-dpo-approach-2","sections":[],"depth":3},{"title":"Using option 3 - load the adapter twice","local":"using-option-3---load-the-adapter-twice","sections":[],"depth":3}],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2},{"title":"DPOConfig","local":"trl.DPOConfig","sections":[],"depth":2},{"title":"PreferenceCollator","local":"trl.trainer.dpo_trainer.PreferenceCollator","sections":[],"depth":2}],"depth":1}';function Al(Ut){return Zl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ar extends Wl{constructor(v){super(),El(this,v,Al,Vl,Ll,{})}}export{ar as component};
