import{s as pl,n as ol,o as rl}from"../chunks/scheduler.d627b047.js";import{S as dl,i as Ml,g as i,s,r,A as cl,h as p,f as l,c as n,j as il,u as d,x as o,k as we,y as ml,a,v as M,d as c,t as m,w as h}from"../chunks/index.d48c4817.js";import{C as u}from"../chunks/CodeBlock.5da89496.js";import{H as Je}from"../chunks/Heading.47e562a9.js";function hl(Zt){let f,Te,je,be,J,_e,T,Gt=`This guide demonstrates how to use LoRA, a low-rank approximation technique, to fine-tune DreamBooth with the
<code>CompVis/stable-diffusion-v1-4</code> model.`,ge,b,Ct=`Although LoRA was initially designed as a technique for reducing the number of trainable parameters in
large-language models, the technique can also be applied to diffusion models. Performing a complete model fine-tuning
of diffusion models is a time-consuming task, which is why lightweight techniques like DreamBooth or Textual Inversion
gained popularity. With the introduction of LoRA, customizing and fine-tuning a model on a specific dataset has become
even faster.`,Ze,_,It=`In this guide we’ll be using a DreamBooth fine-tuning script that is available in
<a href="https://github.com/huggingface/peft/tree/main/examples/lora_dreambooth" rel="nofollow">PEFT’s GitHub repo</a>. Feel free to explore it and
learn how things work.`,Ge,g,Ce,Z,Rt="Start by cloning the PEFT repository:",Ie,G,Re,C,Xt="Navigate to the directory containing the training scripts for fine-tuning Dreambooth with LoRA:",Xe,I,ve,R,vt=`Set up your environment: install PEFT, and all the required libraries. At the time of writing this guide we recommend
installing PEFT from source.`,We,X,Be,v,$e,W,Wt="Prepare the images that you will use for fine-tuning the model. Set up a few environment variables:",ke,B,Ae,$,Bt="Here:",xe,k,$t="<li><code>INSTANCE_DIR</code>: The directory containing the images that you intend to use for training your model.</li> <li><code>CLASS_DIR</code>: The directory containing class-specific images. In this example, we use prior preservation to avoid overfitting and language-drift. For prior preservation, you need other images of the same class as part of the training process. However, these images can be generated and the training script will save them to a local path you specify here.</li> <li><code>OUTPUT_DIR</code>: The destination folder for storing the trained model’s weights.</li>",Ve,A,kt='To learn more about DreamBooth fine-tuning with prior-preserving loss, check out the <a href="https://huggingface.co/docs/diffusers/training/dreambooth#finetuning-with-priorpreserving-loss" rel="nofollow">Diffusers documentation</a>.',Ne,x,At="Launch the training script with <code>accelerate</code> and pass hyperparameters, as well as LoRa-specific arguments to it such as:",He,V,xt="<li><code>use_lora</code>: Enables LoRa in the training script.</li> <li><code>lora_r</code>:  The dimension used by the LoRA update matrices.</li> <li><code>lora_alpha</code>: Scaling factor.</li> <li><code>lora_text_encoder_r</code>: LoRA rank for text encoder.</li> <li><code>lora_text_encoder_alpha</code>: LoRA alpha (scaling factor) for text encoder.</li>",Qe,N,Vt="Here’s what the full set of script arguments may look like:",Ye,H,Ee,Q,Nt="If you are running this script on Windows, you may need to set the <code>--num_dataloader_workers</code> to 0.",Fe,Y,Se,E,Ht="To run inference with the fine-tuned model, first specify the base model with which the fine-tuned LoRA weights will be combined:",Le,F,qe,S,Qt=`Next, add a function that will create a Stable Diffusion pipeline for image generation. It will combine the weights of
the base model with the fine-tuned LoRA weights using <code>LoraConfig</code>.`,ze,L,De,q,Yt=`Now you can use the function above to create a Stable Diffusion pipeline using the LoRA weights that you have created during the fine-tuning step.<br/>
Note, if you’re running inference on the same machine, the path you specify here will be the same as <code>OUTPUT_DIR</code>.`,Pe,z,Ke,D,Et="Once you have the pipeline with your fine-tuned model, you can use it to generate images:",Oe,P,et,y,Ft='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_dreambooth_dog_park.png" alt="Generated image of a dog in a park"/>',tt,K,lt,O,St=`With PEFT you can combine multiple adapters for inference. In the previous example you have fine-tuned Stable Diffusion on
some dog images. The pipeline created based on these weights got a name - <code>adapter_name=&quot;dog&quot;</code>. Now, suppose you also fine-tuned
this base model on images of a crochet toy. Let’s see how we can use both adapters.`,at,ee,Lt="First, you’ll need to perform all the steps as in the single adapter inference example:",st,te,qt="<li>Specify the base model.</li> <li>Add a function that creates a Stable Diffusion pipeline for image generation uses LoRA weights.</li> <li>Create a <code>pipe</code> with <code>adapter_name=&quot;dog&quot;</code> based on the model fine-tuned on dog images.</li>",nt,le,zt=`Next, you’re going to need a few more helper functions.
To load another adapter, create a <code>load_adapter()</code> function that leverages <code>load_adapter()</code> method of <code>PeftModel</code> (e.g. <code>pipe.unet.load_adapter(peft_model_path, adapter_name)</code>):`,it,ae,pt,se,Dt="To switch between adapters, write a function that uses <code>set_adapter()</code> method of <code>PeftModel</code> (see <code>pipe.unet.set_adapter(adapter_name)</code>)",ot,ne,rt,ie,Pt="Finally, add a function to create weighted LoRA adapter.",dt,pe,Mt,oe,Kt="Let’s load the second adapter from the model fine-tuned on images of a crochet toy, and give it a unique name:",ct,re,mt,de,Ot="Create a pipeline using weighted adapters:",ht,Me,ut,ce,el="Now you can switch between adapters. If you’d like to generate more dog images, set the adapter to <code>&quot;dog&quot;</code>:",ft,me,yt,w,tl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_dreambooth_dog_supermarket.png" alt="Generated image of a dog in a supermarket"/>',wt,he,ll="In the same way, you can switch to the second adapter:",jt,ue,Ut,j,al='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_dreambooth_fish.png" alt="Generated image of a crochet fish"/>',Jt,fe,sl="Finally, you can use combined weighted adapters:",Tt,ye,bt,U,nl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_dreambooth_crochet_dog.png" alt="Generated image of a crochet dog"/>',_t,Ue,gt;return J=new Je({props:{title:"DreamBooth fine-tuning with LoRA",local:"dreambooth-fine-tuning-with-lora",headingTag:"h1"}}),g=new Je({props:{title:"Set up your environment",local:"set-up-your-environment",headingTag:"h2"}}),G=new u({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnBlZnQ=",highlighted:'git <span class="hljs-built_in">clone</span> https://github.com/huggingface/peft',wrap:!1}}),I=new u({props:{code:"Y2QlMjBwZWZ0JTJGZXhhbXBsZXMlMkZsb3JhX2RyZWFtYm9vdGg=",highlighted:'<span class="hljs-built_in">cd</span> peft/examples/lora_dreambooth',wrap:!1}}),X=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1yJTIwcmVxdWlyZW1lbnRzLnR4dCUwQXBpcCUyMGluc3RhbGwlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnBlZnQ=",highlighted:`pip install -r requirements.txt
pip install git+https://github.com/huggingface/peft`,wrap:!1}}),v=new Je({props:{title:"Fine-tuning DreamBooth",local:"fine-tuning-dreambooth",headingTag:"h2"}}),B=new u({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMjAlMEFleHBvcnQlMjBJTlNUQU5DRV9ESVIlM0QlMjJwYXRoLXRvLWluc3RhbmNlLWltYWdlcyUyMiUwQWV4cG9ydCUyMENMQVNTX0RJUiUzRCUyMnBhdGgtdG8tY2xhc3MtaW1hZ2VzJTIyJTBBZXhwb3J0JTIwT1VUUFVUX0RJUiUzRCUyMnBhdGgtdG8tc2F2ZS1tb2RlbCUyMg==",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span> 
<span class="hljs-built_in">export</span> INSTANCE_DIR=<span class="hljs-string">&quot;path-to-instance-images&quot;</span>
<span class="hljs-built_in">export</span> CLASS_DIR=<span class="hljs-string">&quot;path-to-class-images&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path-to-save-model&quot;</span>`,wrap:!1}}),H=new u({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2RyZWFtYm9vdGgucHklMjAlNUMlMEElMjAlMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfTkFNRSUyMCUyMCU1QyUwQSUyMCUyMC0taW5zdGFuY2VfZGF0YV9kaXIlM0QlMjRJTlNUQU5DRV9ESVIlMjAlNUMlMEElMjAlMjAtLWNsYXNzX2RhdGFfZGlyJTNEJTI0Q0xBU1NfRElSJTIwJTVDJTBBJTIwJTIwLS1vdXRwdXRfZGlyJTNEJTI0T1VUUFVUX0RJUiUyMCU1QyUwQSUyMCUyMC0tdHJhaW5fdGV4dF9lbmNvZGVyJTIwJTVDJTBBJTIwJTIwLS13aXRoX3ByaW9yX3ByZXNlcnZhdGlvbiUyMC0tcHJpb3JfbG9zc193ZWlnaHQlM0QxLjAlMjAlNUMlMEElMjAlMjAtLW51bV9kYXRhbG9hZGVyX3dvcmtlcnMlM0QxJTIwJTVDJTBBJTIwJTIwLS1pbnN0YW5jZV9wcm9tcHQlM0QlMjJhJTIwcGhvdG8lMjBvZiUyMHNrcyUyMGRvZyUyMiUyMCU1QyUwQSUyMCUyMC0tY2xhc3NfcHJvbXB0JTNEJTIyYSUyMHBob3RvJTIwb2YlMjBkb2clMjIlMjAlNUMlMEElMjAlMjAtLXJlc29sdXRpb24lM0Q1MTIlMjAlNUMlMEElMjAlMjAtLXRyYWluX2JhdGNoX3NpemUlM0QxJTIwJTVDJTBBJTIwJTIwLS1scl9zY2hlZHVsZXIlM0QlMjJjb25zdGFudCUyMiUyMCU1QyUwQSUyMCUyMC0tbHJfd2FybXVwX3N0ZXBzJTNEMCUyMCU1QyUwQSUyMCUyMC0tbnVtX2NsYXNzX2ltYWdlcyUzRDIwMCUyMCU1QyUwQSUyMCUyMC0tdXNlX2xvcmElMjAlNUMlMEElMjAlMjAtLWxvcmFfciUyMDE2JTIwJTVDJTBBJTIwJTIwLS1sb3JhX2FscGhhJTIwMjclMjAlNUMlMEElMjAlMjAtLWxvcmFfdGV4dF9lbmNvZGVyX3IlMjAxNiUyMCU1QyUwQSUyMCUyMC0tbG9yYV90ZXh0X2VuY29kZXJfYWxwaGElMjAxNyUyMCU1QyUwQSUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUzRDFlLTQlMjAlNUMlMEElMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDElMjAlNUMlMEElMjAlMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlNUMlMEElMjAlMjAtLW1heF90cmFpbl9zdGVwcyUzRDgwMA==",highlighted:`accelerate launch train_dreambooth.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span>  \\
  --instance_data_dir=<span class="hljs-variable">$INSTANCE_DIR</span> \\
  --class_data_dir=<span class="hljs-variable">$CLASS_DIR</span> \\
  --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
  --train_text_encoder \\
  --with_prior_preservation --prior_loss_weight=1.0 \\
  --num_dataloader_workers=1 \\
  --instance_prompt=<span class="hljs-string">&quot;a photo of sks dog&quot;</span> \\
  --class_prompt=<span class="hljs-string">&quot;a photo of dog&quot;</span> \\
  --resolution=512 \\
  --train_batch_size=1 \\
  --lr_scheduler=<span class="hljs-string">&quot;constant&quot;</span> \\
  --lr_warmup_steps=0 \\
  --num_class_images=200 \\
  --use_lora \\
  --lora_r 16 \\
  --lora_alpha 27 \\
  --lora_text_encoder_r 16 \\
  --lora_text_encoder_alpha 17 \\
  --learning_rate=1e-4 \\
  --gradient_accumulation_steps=1 \\
  --gradient_checkpointing \\
  --max_train_steps=800`,wrap:!1}}),Y=new Je({props:{title:"Inference with a single adapter",local:"inference-with-a-single-adapter",headingTag:"h2"}}),F=new u({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTJDJTIwTG9yYUNvbmZpZyUwQSUwQU1PREVMX05BTUUlMjAlM0QlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIy",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, LoraConfig

MODEL_NAME = <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>`,wrap:!1}}),L=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_lora_sd_pipeline</span>(<span class="hljs-params">
    ckpt_dir, base_model_name_or_path=<span class="hljs-literal">None</span>, dtype=torch.float16, device=<span class="hljs-string">&quot;cuda&quot;</span>, adapter_name=<span class="hljs-string">&quot;default&quot;</span>
</span>):
    unet_sub_dir = os.path.join(ckpt_dir, <span class="hljs-string">&quot;unet&quot;</span>)
    text_encoder_sub_dir = os.path.join(ckpt_dir, <span class="hljs-string">&quot;text_encoder&quot;</span>)
    <span class="hljs-keyword">if</span> os.path.exists(text_encoder_sub_dir) <span class="hljs-keyword">and</span> base_model_name_or_path <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        config = LoraConfig.from_pretrained(text_encoder_sub_dir)
        base_model_name_or_path = config.base_model_name_or_path

    <span class="hljs-keyword">if</span> base_model_name_or_path <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;Please specify the base model name or path&quot;</span>)

    pipe = StableDiffusionPipeline.from_pretrained(base_model_name_or_path, torch_dtype=dtype).to(device)
    pipe.unet = PeftModel.from_pretrained(pipe.unet, unet_sub_dir, adapter_name=adapter_name)

    <span class="hljs-keyword">if</span> os.path.exists(text_encoder_sub_dir):
        pipe.text_encoder = PeftModel.from_pretrained(
            pipe.text_encoder, text_encoder_sub_dir, adapter_name=adapter_name
        )

    <span class="hljs-keyword">if</span> dtype <span class="hljs-keyword">in</span> (torch.float16, torch.bfloat16):
        pipe.unet.half()
        pipe.text_encoder.half()

    pipe.to(device)
    <span class="hljs-keyword">return</span> pipe`,wrap:!1}}),z=new u({props:{code:"cGlwZSUyMCUzRCUyMGdldF9sb3JhX3NkX3BpcGVsaW5lKFBhdGgoJTIycGF0aC10by1zYXZlZC1tb2RlbCUyMiklMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkb2clMjIp",highlighted:'pipe = get_lora_sd_pipeline(Path(<span class="hljs-string">&quot;path-to-saved-model&quot;</span>), adapter_name=<span class="hljs-string">&quot;dog&quot;</span>)',wrap:!1}}),P=new u({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyc2tzJTIwZG9nJTIwcGxheWluZyUyMGZldGNoJTIwaW4lMjB0aGUlMjBwYXJrJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIybG93JTIwcXVhbGl0eSUyQyUyMGJsdXJyeSUyQyUyMHVuZmluaXNoZWQlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q3JTJDJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJERVNUSU5BVElPTl9QQVRIX0ZPUl9USEVfSU1BR0UlMjIp",highlighted:`prompt = <span class="hljs-string">&quot;sks dog playing fetch in the park&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, blurry, unfinished&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">7</span>, negative_prompt=negative_prompt).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;DESTINATION_PATH_FOR_THE_IMAGE&quot;</span>)`,wrap:!1}}),K=new Je({props:{title:"Multi-adapter inference",local:"multi-adapter-inference",headingTag:"h2"}}),ae=new u({props:{code:"ZGVmJTIwbG9hZF9hZGFwdGVyKHBpcGUlMkMlMjBja3B0X2RpciUyQyUyMGFkYXB0ZXJfbmFtZSklM0ElMEElMjAlMjAlMjAlMjB1bmV0X3N1Yl9kaXIlMjAlM0QlMjBvcy5wYXRoLmpvaW4oY2twdF9kaXIlMkMlMjAlMjJ1bmV0JTIyKSUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl9zdWJfZGlyJTIwJTNEJTIwb3MucGF0aC5qb2luKGNrcHRfZGlyJTJDJTIwJTIydGV4dF9lbmNvZGVyJTIyKSUwQSUyMCUyMCUyMCUyMHBpcGUudW5ldC5sb2FkX2FkYXB0ZXIodW5ldF9zdWJfZGlyJTJDJTIwYWRhcHRlcl9uYW1lJTNEYWRhcHRlcl9uYW1lKSUwQSUyMCUyMCUyMCUyMGlmJTIwb3MucGF0aC5leGlzdHModGV4dF9lbmNvZGVyX3N1Yl9kaXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZS50ZXh0X2VuY29kZXIubG9hZF9hZGFwdGVyKHRleHRfZW5jb2Rlcl9zdWJfZGlyJTJDJTIwYWRhcHRlcl9uYW1lJTNEYWRhcHRlcl9uYW1lKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">load_adapter</span>(<span class="hljs-params">pipe, ckpt_dir, adapter_name</span>):
    unet_sub_dir = os.path.join(ckpt_dir, <span class="hljs-string">&quot;unet&quot;</span>)
    text_encoder_sub_dir = os.path.join(ckpt_dir, <span class="hljs-string">&quot;text_encoder&quot;</span>)
    pipe.unet.load_adapter(unet_sub_dir, adapter_name=adapter_name)
    <span class="hljs-keyword">if</span> os.path.exists(text_encoder_sub_dir):
        pipe.text_encoder.load_adapter(text_encoder_sub_dir, adapter_name=adapter_name)`,wrap:!1}}),ne=new u({props:{code:"ZGVmJTIwc2V0X2FkYXB0ZXIocGlwZSUyQyUyMGFkYXB0ZXJfbmFtZSklM0ElMEElMjAlMjAlMjAlMjBwaXBlLnVuZXQuc2V0X2FkYXB0ZXIoYWRhcHRlcl9uYW1lKSUwQSUyMCUyMCUyMCUyMGlmJTIwaXNpbnN0YW5jZShwaXBlLnRleHRfZW5jb2RlciUyQyUyMFBlZnRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBlLnRleHRfZW5jb2Rlci5zZXRfYWRhcHRlcihhZGFwdGVyX25hbWUp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">set_adapter</span>(<span class="hljs-params">pipe, adapter_name</span>):
    pipe.unet.set_adapter(adapter_name)
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(pipe.text_encoder, PeftModel):
        pipe.text_encoder.set_adapter(adapter_name)`,wrap:!1}}),pe=new u({props:{code:"ZGVmJTIwY3JlYXRlX3dlaWdodGVkX2xvcmFfYWRhcHRlcihwaXBlJTJDJTIwYWRhcHRlcnMlMkMlMjB3ZWlnaHRzJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyZGVmYXVsdCUyMiklM0ElMEElMjAlMjAlMjAlMjBwaXBlLnVuZXQuYWRkX3dlaWdodGVkX2FkYXB0ZXIoYWRhcHRlcnMlMkMlMjB3ZWlnaHRzJTJDJTIwYWRhcHRlcl9uYW1lKSUwQSUyMCUyMCUyMCUyMGlmJTIwaXNpbnN0YW5jZShwaXBlLnRleHRfZW5jb2RlciUyQyUyMFBlZnRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwaXBlLnRleHRfZW5jb2Rlci5hZGRfd2VpZ2h0ZWRfYWRhcHRlcihhZGFwdGVycyUyQyUyMHdlaWdodHMlMkMlMjBhZGFwdGVyX25hbWUpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcGlwZQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_weighted_lora_adapter</span>(<span class="hljs-params">pipe, adapters, weights, adapter_name=<span class="hljs-string">&quot;default&quot;</span></span>):
    pipe.unet.add_weighted_adapter(adapters, weights, adapter_name)
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(pipe.text_encoder, PeftModel):
        pipe.text_encoder.add_weighted_adapter(adapters, weights, adapter_name)

    <span class="hljs-keyword">return</span> pipe`,wrap:!1}}),re=new u({props:{code:"bG9hZF9hZGFwdGVyKHBpcGUlMkMlMjBQYXRoKCUyMnBhdGgtdG8tdGhlLXNlY29uZC1zYXZlZC1tb2RlbCUyMiklMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJjcm9jaGV0JTIyKQ==",highlighted:'load_adapter(pipe, Path(<span class="hljs-string">&quot;path-to-the-second-saved-model&quot;</span>), adapter_name=<span class="hljs-string">&quot;crochet&quot;</span>)',wrap:!1}}),Me=new u({props:{code:"cGlwZSUyMCUzRCUyMGNyZWF0ZV93ZWlnaHRlZF9sb3JhX2FkYXB0ZXIocGlwZSUyQyUyMCU1QiUyMmNyb2NoZXQlMjIlMkMlMjAlMjJkb2clMjIlNUQlMkMlMjAlNUIxLjAlMkMlMjAxLjA1JTVEJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyY3JvY2hldF9kb2clMjIp",highlighted:'pipe = create_weighted_lora_adapter(pipe, [<span class="hljs-string">&quot;crochet&quot;</span>, <span class="hljs-string">&quot;dog&quot;</span>], [<span class="hljs-number">1.0</span>, <span class="hljs-number">1.05</span>], adapter_name=<span class="hljs-string">&quot;crochet_dog&quot;</span>)',wrap:!1}}),me=new u({props:{code:"c2V0X2FkYXB0ZXIocGlwZSUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRvZyUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJza3MlMjBkb2clMjBpbiUyMGElMjBzdXBlcm1hcmtldCUyMGlzbGUlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJsb3clMjBxdWFsaXR5JTJDJTIwYmx1cnJ5JTJDJTIwdW5maW5pc2hlZCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDclMkMlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`set_adapter(pipe, adapter_name=<span class="hljs-string">&quot;dog&quot;</span>)
prompt = <span class="hljs-string">&quot;sks dog in a supermarket isle&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, blurry, unfinished&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">7</span>, negative_prompt=negative_prompt).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ue=new u({props:{code:"c2V0X2FkYXB0ZXIocGlwZSUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmNyb2NoZXQlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGZpc2glMjByZW5kZXJlZCUyMGluJTIwdGhlJTIwc3R5bGUlMjBvZiUyMCUzQzElM0UlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJsb3clMjBxdWFsaXR5JTJDJTIwYmx1cnJ5JTJDJTIwdW5maW5pc2hlZCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDclMkMlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`set_adapter(pipe, adapter_name=<span class="hljs-string">&quot;crochet&quot;</span>)
prompt = <span class="hljs-string">&quot;a fish rendered in the style of &lt;1&gt;&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, blurry, unfinished&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">7</span>, negative_prompt=negative_prompt).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ye=new u({props:{code:"c2V0X2FkYXB0ZXIocGlwZSUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmNyb2NoZXRfZG9nJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMnNrcyUyMGRvZyUyMHJlbmRlcmVkJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwJTNDMSUzRSUyQyUyMGNsb3NlJTIwdXAlMjBwb3J0cmFpdCUyQyUyMDRLJTIwSEQlMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJsb3clMjBxdWFsaXR5JTJDJTIwYmx1cnJ5JTJDJTIwdW5maW5pc2hlZCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDclMkMlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`set_adapter(pipe, adapter_name=<span class="hljs-string">&quot;crochet_dog&quot;</span>)
prompt = <span class="hljs-string">&quot;sks dog rendered in the style of &lt;1&gt;, close up portrait, 4K HD&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, blurry, unfinished&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">7</span>, negative_prompt=negative_prompt).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){f=i("meta"),Te=s(),je=i("p"),be=s(),r(J.$$.fragment),_e=s(),T=i("p"),T.innerHTML=Gt,ge=s(),b=i("p"),b.textContent=Ct,Ze=s(),_=i("p"),_.innerHTML=It,Ge=s(),r(g.$$.fragment),Ce=s(),Z=i("p"),Z.textContent=Rt,Ie=s(),r(G.$$.fragment),Re=s(),C=i("p"),C.textContent=Xt,Xe=s(),r(I.$$.fragment),ve=s(),R=i("p"),R.textContent=vt,We=s(),r(X.$$.fragment),Be=s(),r(v.$$.fragment),$e=s(),W=i("p"),W.textContent=Wt,ke=s(),r(B.$$.fragment),Ae=s(),$=i("p"),$.textContent=Bt,xe=s(),k=i("ul"),k.innerHTML=$t,Ve=s(),A=i("p"),A.innerHTML=kt,Ne=s(),x=i("p"),x.innerHTML=At,He=s(),V=i("ul"),V.innerHTML=xt,Qe=s(),N=i("p"),N.textContent=Vt,Ye=s(),r(H.$$.fragment),Ee=s(),Q=i("p"),Q.innerHTML=Nt,Fe=s(),r(Y.$$.fragment),Se=s(),E=i("p"),E.textContent=Ht,Le=s(),r(F.$$.fragment),qe=s(),S=i("p"),S.innerHTML=Qt,ze=s(),r(L.$$.fragment),De=s(),q=i("p"),q.innerHTML=Yt,Pe=s(),r(z.$$.fragment),Ke=s(),D=i("p"),D.textContent=Et,Oe=s(),r(P.$$.fragment),et=s(),y=i("div"),y.innerHTML=Ft,tt=s(),r(K.$$.fragment),lt=s(),O=i("p"),O.innerHTML=St,at=s(),ee=i("p"),ee.textContent=Lt,st=s(),te=i("ol"),te.innerHTML=qt,nt=s(),le=i("p"),le.innerHTML=zt,it=s(),r(ae.$$.fragment),pt=s(),se=i("p"),se.innerHTML=Dt,ot=s(),r(ne.$$.fragment),rt=s(),ie=i("p"),ie.textContent=Pt,dt=s(),r(pe.$$.fragment),Mt=s(),oe=i("p"),oe.textContent=Kt,ct=s(),r(re.$$.fragment),mt=s(),de=i("p"),de.textContent=Ot,ht=s(),r(Me.$$.fragment),ut=s(),ce=i("p"),ce.innerHTML=el,ft=s(),r(me.$$.fragment),yt=s(),w=i("div"),w.innerHTML=tl,wt=s(),he=i("p"),he.textContent=ll,jt=s(),r(ue.$$.fragment),Ut=s(),j=i("div"),j.innerHTML=al,Jt=s(),fe=i("p"),fe.textContent=sl,Tt=s(),r(ye.$$.fragment),bt=s(),U=i("div"),U.innerHTML=nl,_t=s(),Ue=i("p"),this.h()},l(e){const t=cl("svelte-u9bgzb",document.head);f=p(t,"META",{name:!0,content:!0}),t.forEach(l),Te=n(e),je=p(e,"P",{}),il(je).forEach(l),be=n(e),d(J.$$.fragment,e),_e=n(e),T=p(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-i4284a"&&(T.innerHTML=Gt),ge=n(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1dejz68"&&(b.textContent=Ct),Ze=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-18fgk7y"&&(_.innerHTML=It),Ge=n(e),d(g.$$.fragment,e),Ce=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-pxn7b7"&&(Z.textContent=Rt),Ie=n(e),d(G.$$.fragment,e),Re=n(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-a2i2v3"&&(C.textContent=Xt),Xe=n(e),d(I.$$.fragment,e),ve=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-18c5jsl"&&(R.textContent=vt),We=n(e),d(X.$$.fragment,e),Be=n(e),d(v.$$.fragment,e),$e=n(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1repjk"&&(W.textContent=Wt),ke=n(e),d(B.$$.fragment,e),Ae=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1vuwyaw"&&($.textContent=Bt),xe=n(e),k=p(e,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-x6kqao"&&(k.innerHTML=$t),Ve=n(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-10y2hi5"&&(A.innerHTML=kt),Ne=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-7ccaxr"&&(x.innerHTML=At),He=n(e),V=p(e,"UL",{"data-svelte-h":!0}),o(V)!=="svelte-1dm7o23"&&(V.innerHTML=xt),Qe=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-11r7hrr"&&(N.textContent=Vt),Ye=n(e),d(H.$$.fragment,e),Ee=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-66i7k2"&&(Q.innerHTML=Nt),Fe=n(e),d(Y.$$.fragment,e),Se=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1apgfqi"&&(E.textContent=Ht),Le=n(e),d(F.$$.fragment,e),qe=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1p89jr"&&(S.innerHTML=Qt),ze=n(e),d(L.$$.fragment,e),De=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-bgs6sh"&&(q.innerHTML=Yt),Pe=n(e),d(z.$$.fragment,e),Ke=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1cenv69"&&(D.textContent=Et),Oe=n(e),d(P.$$.fragment,e),et=n(e),y=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-1hia4bn"&&(y.innerHTML=Ft),tt=n(e),d(K.$$.fragment,e),lt=n(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-sco3y7"&&(O.innerHTML=St),at=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-mwwver"&&(ee.textContent=Lt),st=n(e),te=p(e,"OL",{"data-svelte-h":!0}),o(te)!=="svelte-1gkcmas"&&(te.innerHTML=qt),nt=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-xiz6st"&&(le.innerHTML=zt),it=n(e),d(ae.$$.fragment,e),pt=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-f4lw3s"&&(se.innerHTML=Dt),ot=n(e),d(ne.$$.fragment,e),rt=n(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-q73wxm"&&(ie.textContent=Pt),dt=n(e),d(pe.$$.fragment,e),Mt=n(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-fx7zod"&&(oe.textContent=Kt),ct=n(e),d(re.$$.fragment,e),mt=n(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1uthdyu"&&(de.textContent=Ot),ht=n(e),d(Me.$$.fragment,e),ut=n(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-bep1v2"&&(ce.innerHTML=el),ft=n(e),d(me.$$.fragment,e),yt=n(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-1qy283v"&&(w.innerHTML=tl),wt=n(e),he=p(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-v1nd15"&&(he.textContent=ll),jt=n(e),d(ue.$$.fragment,e),Ut=n(e),j=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(j)!=="svelte-1awtarq"&&(j.innerHTML=al),Jt=n(e),fe=p(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-ddp1rv"&&(fe.textContent=sl),Tt=n(e),d(ye.$$.fragment,e),bt=n(e),U=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-1w1m79d"&&(U.innerHTML=nl),_t=n(e),Ue=p(e,"P",{}),il(Ue).forEach(l),this.h()},h(){we(f,"name","hf:doc:metadata"),we(f,"content",ul),we(y,"class","flex justify-center"),we(w,"class","flex justify-center"),we(j,"class","flex justify-center"),we(U,"class","flex justify-center")},m(e,t){ml(document.head,f),a(e,Te,t),a(e,je,t),a(e,be,t),M(J,e,t),a(e,_e,t),a(e,T,t),a(e,ge,t),a(e,b,t),a(e,Ze,t),a(e,_,t),a(e,Ge,t),M(g,e,t),a(e,Ce,t),a(e,Z,t),a(e,Ie,t),M(G,e,t),a(e,Re,t),a(e,C,t),a(e,Xe,t),M(I,e,t),a(e,ve,t),a(e,R,t),a(e,We,t),M(X,e,t),a(e,Be,t),M(v,e,t),a(e,$e,t),a(e,W,t),a(e,ke,t),M(B,e,t),a(e,Ae,t),a(e,$,t),a(e,xe,t),a(e,k,t),a(e,Ve,t),a(e,A,t),a(e,Ne,t),a(e,x,t),a(e,He,t),a(e,V,t),a(e,Qe,t),a(e,N,t),a(e,Ye,t),M(H,e,t),a(e,Ee,t),a(e,Q,t),a(e,Fe,t),M(Y,e,t),a(e,Se,t),a(e,E,t),a(e,Le,t),M(F,e,t),a(e,qe,t),a(e,S,t),a(e,ze,t),M(L,e,t),a(e,De,t),a(e,q,t),a(e,Pe,t),M(z,e,t),a(e,Ke,t),a(e,D,t),a(e,Oe,t),M(P,e,t),a(e,et,t),a(e,y,t),a(e,tt,t),M(K,e,t),a(e,lt,t),a(e,O,t),a(e,at,t),a(e,ee,t),a(e,st,t),a(e,te,t),a(e,nt,t),a(e,le,t),a(e,it,t),M(ae,e,t),a(e,pt,t),a(e,se,t),a(e,ot,t),M(ne,e,t),a(e,rt,t),a(e,ie,t),a(e,dt,t),M(pe,e,t),a(e,Mt,t),a(e,oe,t),a(e,ct,t),M(re,e,t),a(e,mt,t),a(e,de,t),a(e,ht,t),M(Me,e,t),a(e,ut,t),a(e,ce,t),a(e,ft,t),M(me,e,t),a(e,yt,t),a(e,w,t),a(e,wt,t),a(e,he,t),a(e,jt,t),M(ue,e,t),a(e,Ut,t),a(e,j,t),a(e,Jt,t),a(e,fe,t),a(e,Tt,t),M(ye,e,t),a(e,bt,t),a(e,U,t),a(e,_t,t),a(e,Ue,t),gt=!0},p:ol,i(e){gt||(c(J.$$.fragment,e),c(g.$$.fragment,e),c(G.$$.fragment,e),c(I.$$.fragment,e),c(X.$$.fragment,e),c(v.$$.fragment,e),c(B.$$.fragment,e),c(H.$$.fragment,e),c(Y.$$.fragment,e),c(F.$$.fragment,e),c(L.$$.fragment,e),c(z.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(ae.$$.fragment,e),c(ne.$$.fragment,e),c(pe.$$.fragment,e),c(re.$$.fragment,e),c(Me.$$.fragment,e),c(me.$$.fragment,e),c(ue.$$.fragment,e),c(ye.$$.fragment,e),gt=!0)},o(e){m(J.$$.fragment,e),m(g.$$.fragment,e),m(G.$$.fragment,e),m(I.$$.fragment,e),m(X.$$.fragment,e),m(v.$$.fragment,e),m(B.$$.fragment,e),m(H.$$.fragment,e),m(Y.$$.fragment,e),m(F.$$.fragment,e),m(L.$$.fragment,e),m(z.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(ae.$$.fragment,e),m(ne.$$.fragment,e),m(pe.$$.fragment,e),m(re.$$.fragment,e),m(Me.$$.fragment,e),m(me.$$.fragment,e),m(ue.$$.fragment,e),m(ye.$$.fragment,e),gt=!1},d(e){e&&(l(Te),l(je),l(be),l(_e),l(T),l(ge),l(b),l(Ze),l(_),l(Ge),l(Ce),l(Z),l(Ie),l(Re),l(C),l(Xe),l(ve),l(R),l(We),l(Be),l($e),l(W),l(ke),l(Ae),l($),l(xe),l(k),l(Ve),l(A),l(Ne),l(x),l(He),l(V),l(Qe),l(N),l(Ye),l(Ee),l(Q),l(Fe),l(Se),l(E),l(Le),l(qe),l(S),l(ze),l(De),l(q),l(Pe),l(Ke),l(D),l(Oe),l(et),l(y),l(tt),l(lt),l(O),l(at),l(ee),l(st),l(te),l(nt),l(le),l(it),l(pt),l(se),l(ot),l(rt),l(ie),l(dt),l(Mt),l(oe),l(ct),l(mt),l(de),l(ht),l(ut),l(ce),l(ft),l(yt),l(w),l(wt),l(he),l(jt),l(Ut),l(j),l(Jt),l(fe),l(Tt),l(bt),l(U),l(_t),l(Ue)),l(f),h(J,e),h(g,e),h(G,e),h(I,e),h(X,e),h(v,e),h(B,e),h(H,e),h(Y,e),h(F,e),h(L,e),h(z,e),h(P,e),h(K,e),h(ae,e),h(ne,e),h(pe,e),h(re,e),h(Me,e),h(me,e),h(ue,e),h(ye,e)}}}const ul='{"title":"DreamBooth fine-tuning with LoRA","local":"dreambooth-fine-tuning-with-lora","sections":[{"title":"Set up your environment","local":"set-up-your-environment","sections":[],"depth":2},{"title":"Fine-tuning DreamBooth","local":"fine-tuning-dreambooth","sections":[],"depth":2},{"title":"Inference with a single adapter","local":"inference-with-a-single-adapter","sections":[],"depth":2},{"title":"Multi-adapter inference","local":"multi-adapter-inference","sections":[],"depth":2}],"depth":1}';function fl(Zt){return rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jl extends dl{constructor(f){super(),Ml(this,f,fl,hl,pl,{})}}export{Jl as component};
