import{s as pa,o as ga,n as S}from"../chunks/scheduler.6062bdaf.js";import{S as ma,i as _a,g as d,s as o,r as _,A as fa,h,f as s,c as i,j as H,u as f,x as g,k as U,y as r,a as l,v as u,d as b,t as v,w as $}from"../chunks/index.4bca734e.js";import{T as Ue}from"../chunks/Tip.b9ac1f03.js";import{D as ue}from"../chunks/Docstring.d7918b6d.js";import{C as Ut}from"../chunks/CodeBlock.fa01571c.js";import{E as Ht}from"../chunks/ExampleCodeBlock.d27cbfa4.js";import{H as R,E as ua}from"../chunks/EditOnGithub.74ab2baa.js";function ba(y){let t,m=`If one of the model’s tensor is bigger than <code>max_shard_size</code>, it will end up in its own shard which will have a
size greater than <code>max_shard_size</code>.`;return{c(){t=d("p"),t.innerHTML=m},l(n){t=h(n,"P",{"data-svelte-h":!0}),g(t)!=="svelte-16sq104"&&(t.innerHTML=m)},m(n,p){l(n,t,p)},p:S,d(n){n&&s(t)}}}function va(y){let t,m="Example:",n,p,w;return p=new Ut({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNhdmVfdG9yY2hfbW9kZWwlMEFtb2RlbCUyMCUzRCUyMC4uLiUyMCUyMyUyMEElMjBQeVRvcmNoJTIwbW9kZWwlMEElMEFzYXZlX3RvcmNoX21vZGVsKG1vZGVsJTJDJTIwJTIycGF0aCUyRnRvJTJGZm9sZGVyJTIyKSUwQSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBsb2FkX3RvcmNoX21vZGVsJTIwJTIwJTIzJTIwVE9ETyUwQWxvYWRfdG9yY2hfbW9kZWwobW9kZWwlMkMlMjAlMjJwYXRoJTJGdG8lMkZmb2xkZXIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> save_torch_model
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ... <span class="hljs-comment"># A PyTorch model</span>

<span class="hljs-comment"># Save state dict to &quot;path/to/folder&quot;. The model will be split into shards of 5GB each and saved as safetensors.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_torch_model(model, <span class="hljs-string">&quot;path/to/folder&quot;</span>)

<span class="hljs-comment"># Load model back</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> load_torch_model  <span class="hljs-comment"># TODO</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>load_torch_model(model, <span class="hljs-string">&quot;path/to/folder&quot;</span>)
&gt;&gt;&gt;`,wrap:!1}}),{c(){t=d("p"),t.textContent=m,n=o(),_(p.$$.fragment)},l(c){t=h(c,"P",{"data-svelte-h":!0}),g(t)!=="svelte-11lpom8"&&(t.textContent=m),n=i(c),f(p.$$.fragment,c)},m(c,x){l(c,t,x),l(c,n,x),u(p,c,x),w=!0},p:S,i(c){w||(b(p.$$.fragment,c),w=!0)},o(c){v(p.$$.fragment,c),w=!1},d(c){c&&(s(t),s(n)),$(p,c)}}}function $a(y){let t,m=`If one of the model’s tensor is bigger than <code>max_shard_size</code>, it will end up in its own shard which will have a
size greater than <code>max_shard_size</code>.`;return{c(){t=d("p"),t.innerHTML=m},l(n){t=h(n,"P",{"data-svelte-h":!0}),g(t)!=="svelte-16sq104"&&(t.innerHTML=m)},m(n,p){l(n,t,p)},p:S,d(n){n&&s(t)}}}function wa(y){let t,m="Example:",n,p,w;return p=new Ut({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNhdmVfdG9yY2hfc3RhdGVfZGljdCUwQW1vZGVsJTIwJTNEJTIwLi4uJTIwJTIzJTIwQSUyMFB5VG9yY2glMjBtb2RlbCUwQSUwQXN0YXRlX2RpY3QlMjAlM0QlMjBtb2RlbF90b19zYXZlLnN0YXRlX2RpY3QoKSUwQXNhdmVfdG9yY2hfc3RhdGVfZGljdChzdGF0ZV9kaWN0JTJDJTIwJTIycGF0aCUyRnRvJTJGZm9sZGVyJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> save_torch_state_dict
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ... <span class="hljs-comment"># A PyTorch model</span>

<span class="hljs-comment"># Save state dict to &quot;path/to/folder&quot;. The model will be split into shards of 5GB each and saved as safetensors.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>state_dict = model_to_save.state_dict()
<span class="hljs-meta">&gt;&gt;&gt; </span>save_torch_state_dict(state_dict, <span class="hljs-string">&quot;path/to/folder&quot;</span>)`,wrap:!1}}),{c(){t=d("p"),t.textContent=m,n=o(),_(p.$$.fragment)},l(c){t=h(c,"P",{"data-svelte-h":!0}),g(t)!=="svelte-11lpom8"&&(t.textContent=m),n=i(c),f(p.$$.fragment,c)},m(c,x){l(c,t,x),l(c,n,x),u(p,c,x),w=!0},p:S,i(c){w||(b(p.$$.fragment,c),w=!0)},o(c){v(p.$$.fragment,c),w=!1},d(c){c&&(s(t),s(n)),$(p,c)}}}function Ta(y){let t,m=`If one of the model’s tensor is bigger than <code>max_shard_size</code>, it will end up in its own shard which will have a
size greater than <code>max_shard_size</code>.`;return{c(){t=d("p"),t.innerHTML=m},l(n){t=h(n,"P",{"data-svelte-h":!0}),g(t)!=="svelte-16sq104"&&(t.innerHTML=m)},m(n,p){l(n,t,p)},p:S,d(n){n&&s(t)}}}function Ma(y){let t,m=`To save a model state dictionary to the disk, see <a href="/docs/huggingface_hub/main/en/package_reference/serialization#huggingface_hub.save_torch_state_dict">save_torch_state_dict()</a>. This helper uses
<code>split_torch_state_dict_into_shards</code> under the hood.`;return{c(){t=d("p"),t.innerHTML=m},l(n){t=h(n,"P",{"data-svelte-h":!0}),g(t)!=="svelte-6g0ega"&&(t.innerHTML=m)},m(n,p){l(n,t,p)},p:S,d(n){n&&s(t)}}}function ya(y){let t,m=`If one of the model’s tensor is bigger than <code>max_shard_size</code>, it will end up in its own shard which will have a
size greater than <code>max_shard_size</code>.`;return{c(){t=d("p"),t.innerHTML=m},l(n){t=h(n,"P",{"data-svelte-h":!0}),g(t)!=="svelte-16sq104"&&(t.innerHTML=m)},m(n,p){l(n,t,p)},p:S,d(n){n&&s(t)}}}function xa(y){let t,m="Example:",n,p,w;return p=new Ut({props:{code:"aW1wb3J0JTIwanNvbiUwQWltcG9ydCUyMG9zJTBBZnJvbSUyMHNhZmV0ZW5zb3JzLnRvcmNoJTIwaW1wb3J0JTIwc2F2ZV9maWxlJTIwYXMlMjBzYWZlX3NhdmVfZmlsZSUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBzcGxpdF90b3JjaF9zdGF0ZV9kaWN0X2ludG9fc2hhcmRzJTBBJTBBZGVmJTIwc2F2ZV9zdGF0ZV9kaWN0KHN0YXRlX2RpY3QlM0ElMjBEaWN0JTVCc3RyJTJDJTIwdG9yY2guVGVuc29yJTVEJTJDJTIwc2F2ZV9kaXJlY3RvcnklM0ElMjBzdHIpJTNBJTBBJTIwJTIwJTIwJTIwc3RhdGVfZGljdF9zcGxpdCUyMCUzRCUyMHNwbGl0X3RvcmNoX3N0YXRlX2RpY3RfaW50b19zaGFyZHMoc3RhdGVfZGljdCklMEElMjAlMjAlMjAlMjBmb3IlMjBmaWxlbmFtZSUyQyUyMHRlbnNvcnMlMjBpbiUyMHN0YXRlX2RpY3Rfc3BsaXQuZmlsZW5hbWVfdG9fdGVuc29ycy5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2hhcmQlMjAlM0QlMjAlN0J0ZW5zb3IlM0ElMjBzdGF0ZV9kaWN0JTVCdGVuc29yJTVEJTIwZm9yJTIwdGVuc29yJTIwaW4lMjB0ZW5zb3JzJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2FmZV9zYXZlX2ZpbGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2hhcmQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcy5wYXRoLmpvaW4oc2F2ZV9kaXJlY3RvcnklMkMlMjBmaWxlbmFtZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUyMmZvcm1hdCUyMiUzQSUyMCUyMnB0JTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGlmJTIwc3RhdGVfZGljdF9zcGxpdC5pc19zaGFyZGVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5kZXglMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtZXRhZGF0YSUyMiUzQSUyMHN0YXRlX2RpY3Rfc3BsaXQubWV0YWRhdGElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3ZWlnaHRfbWFwJTIyJTNBJTIwc3RhdGVfZGljdF9zcGxpdC50ZW5zb3JfdG9fZmlsZW5hbWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aXRoJTIwb3Blbihvcy5wYXRoLmpvaW4oc2F2ZV9kaXJlY3RvcnklMkMlMjAlMjJtb2RlbC5zYWZldGVuc29ycy5pbmRleC5qc29uJTIyKSUyQyUyMCUyMnclMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShqc29uLmR1bXBzKGluZGV4JTJDJTIwaW5kZW50JTNEMikp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> safetensors.torch <span class="hljs-keyword">import</span> save_file <span class="hljs-keyword">as</span> safe_save_file
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> split_torch_state_dict_into_shards

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">save_state_dict</span>(<span class="hljs-params">state_dict: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor], save_directory: <span class="hljs-built_in">str</span></span>):
<span class="hljs-meta">... </span>    state_dict_split = split_torch_state_dict_into_shards(state_dict)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> filename, tensors <span class="hljs-keyword">in</span> state_dict_split.filename_to_tensors.items():
<span class="hljs-meta">... </span>        shard = {tensor: state_dict[tensor] <span class="hljs-keyword">for</span> tensor <span class="hljs-keyword">in</span> tensors}
<span class="hljs-meta">... </span>        safe_save_file(
<span class="hljs-meta">... </span>            shard,
<span class="hljs-meta">... </span>            os.path.join(save_directory, filename),
<span class="hljs-meta">... </span>            metadata={<span class="hljs-string">&quot;format&quot;</span>: <span class="hljs-string">&quot;pt&quot;</span>},
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> state_dict_split.is_sharded:
<span class="hljs-meta">... </span>        index = {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;metadata&quot;</span>: state_dict_split.metadata,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;weight_map&quot;</span>: state_dict_split.tensor_to_filename,
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(os.path.join(save_directory, <span class="hljs-string">&quot;model.safetensors.index.json&quot;</span>), <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>            f.write(json.dumps(index, indent=<span class="hljs-number">2</span>))`,wrap:!1}}),{c(){t=d("p"),t.textContent=m,n=o(),_(p.$$.fragment)},l(c){t=h(c,"P",{"data-svelte-h":!0}),g(t)!=="svelte-11lpom8"&&(t.textContent=m),n=i(c),f(p.$$.fragment,c)},m(c,x){l(c,t,x),l(c,n,x),u(p,c,x),w=!0},p:S,i(c){w||(b(p.$$.fragment,c),w=!0)},o(c){v(p.$$.fragment,c),w=!1},d(c){c&&(s(t),s(n)),$(p,c)}}}function ja(y){let t,m=`If one of the model’s tensor is bigger than <code>max_shard_size</code>, it will end up in its own shard which will have a
size greater than <code>max_shard_size</code>.`;return{c(){t=d("p"),t.innerHTML=m},l(n){t=h(n,"P",{"data-svelte-h":!0}),g(t)!=="svelte-16sq104"&&(t.innerHTML=m)},m(n,p){l(n,t,p)},p:S,d(n){n&&s(t)}}}function Ja(y){let t,m,n,p,w,c,x,Rt="<code>huggingface_hub</code> contains helpers to help ML libraries serialize models weights in a standardized way. This part of the lib is still under development and will be improved in future releases. The goal is to harmonize how weights are serialized on the Hub, both to remove code duplication across libraries and to foster conventions on the Hub.",Se,Y,Ve,Q,St='The main helper of the <code>serialization</code> module takes a torch <code>nn.Module</code> as input and saves it to disk. It handles the logic to save shared tensors (see <a href="https://huggingface.co/docs/safetensors/torch_shared_tensors" rel="nofollow">safetensors explanation</a>) as well as logic to split the state dictionary into shards, using <a href="/docs/huggingface_hub/main/en/package_reference/serialization#huggingface_hub.split_torch_state_dict_into_shards">split_torch_state_dict_into_shards()</a> under the hood. At the moment, only <code>torch</code> framework is supported.',We,O,Vt='If you want to save a state dictionary (e.g. a mapping between layer names and related tensors) instead of a <code>nn.Module</code>, you can use <a href="/docs/huggingface_hub/main/en/package_reference/serialization#huggingface_hub.save_torch_state_dict">save_torch_state_dict()</a> which provides the same features. This is useful for example if you want to apply custom logic to the state dict before saving it.',Ee,T,K,lt,be,Wt="Saves a given torch model to disk, handling sharding and shared tensors issues.",ct,ve,Et='See also <a href="/docs/huggingface_hub/main/en/package_reference/serialization#huggingface_hub.save_torch_state_dict">save_torch_state_dict()</a> to save a state dict with more flexibility.',dt,$e,Dt='For more information about tensor sharing, check out <a href="https://huggingface.co/docs/safetensors/torch_shared_tensors" rel="nofollow">this guide</a>.',ht,we,Pt=`The model state dictionary is split into shards so that each shard is smaller than a given size. The shards are
saved in the <code>save_directory</code> with the given <code>filename_pattern</code>. If the model is too big to fit in a single shard,
an index file is saved in the <code>save_directory</code> to indicate where each tensor is saved. This helper uses
<a href="/docs/huggingface_hub/main/en/package_reference/serialization#huggingface_hub.split_torch_state_dict_into_shards">split_torch_state_dict_into_shards()</a> under the hood. If <code>safe_serialization</code> is <code>True</code>, the shards are saved as
safetensors (the default). Otherwise, the shards are saved as pickle.`,pt,Te,qt="Before saving the model, the <code>save_directory</code> is cleaned from any previous shard files.",gt,V,mt,W,De,M,ee,_t,Me,Xt="Save a model state dictionary to the disk, handling sharding and shared tensors issues.",ft,ye,Ft='See also <a href="/docs/huggingface_hub/main/en/package_reference/serialization#huggingface_hub.save_torch_model">save_torch_model()</a> to directly save a PyTorch model.',ut,xe,Nt='For more information about tensor sharing, check out <a href="https://huggingface.co/docs/safetensors/torch_shared_tensors" rel="nofollow">this guide</a>.',bt,je,Yt=`The model state dictionary is split into shards so that each shard is smaller than a given size. The shards are
saved in the <code>save_directory</code> with the given <code>filename_pattern</code>. If the model is too big to fit in a single shard,
an index file is saved in the <code>save_directory</code> to indicate where each tensor is saved. This helper uses
<a href="/docs/huggingface_hub/main/en/package_reference/serialization#huggingface_hub.split_torch_state_dict_into_shards">split_torch_state_dict_into_shards()</a> under the hood. If <code>safe_serialization</code> is <code>True</code>, the shards are saved as
safetensors (the default). Otherwise, the shards are saved as pickle.`,vt,Je,Qt="Before saving the model, the <code>save_directory</code> is cleaned from any previous shard files.",$t,E,wt,D,Pe,te,qe,ae,Ot="The <code>serialization</code> module also contains low-level helpers to split a state dictionary into several shards, while creating a proper index in the process. These helpers are available for <code>torch</code> and <code>tensorflow</code> tensors and are designed to be easily extended to any other ML frameworks.",Xe,se,Fe,G,ne,Tt,ze,Kt="Split a model state dictionary in shards so that each shard is smaller than a given size.",Mt,Ie,ea=`The shards are determined by iterating through the <code>state_dict</code> in the order of its keys. There is no optimization
made to make each shard as close as possible to the maximum size passed. For example, if the limit is 10GB and we
have tensors of sizes [6GB, 6GB, 2GB, 6GB, 2GB, 2GB] they will get sharded as [6GB], [6+2GB], [6+2+2GB] and not
[6+2+2GB], [6+2GB], [6GB].`,yt,P,Ne,oe,Ye,z,ie,xt,Ge,ta="Split a model state dictionary in shards so that each shard is smaller than a given size.",jt,Be,aa=`The shards are determined by iterating through the <code>state_dict</code> in the order of its keys. There is no optimization
made to make each shard as close as possible to the maximum size passed. For example, if the limit is 10GB and we
have tensors of sizes [6GB, 6GB, 2GB, 6GB, 2GB, 2GB] they will get sharded as [6GB], [6+2GB], [6+2+2GB] and not
[6+2+2GB], [6+2GB], [6GB].`,Jt,q,zt,X,It,F,Qe,re,Oe,le,sa='This is the underlying factory from which each framework-specific helper is derived. In practice, you are not expected to use this factory directly except if you need to adapt it to a framework that is not yet supported. If that is the case, please let us know by <a href="https://github.com/huggingface/huggingface_hub/issues/new" rel="nofollow">opening a new issue</a> on the <code>huggingface_hub</code> repo.',Ke,B,ce,Gt,ke,na="Split a model state dictionary in shards so that each shard is smaller than a given size.",Bt,Ce,oa=`The shards are determined by iterating through the <code>state_dict</code> in the order of its keys. There is no optimization
made to make each shard as close as possible to the maximum size passed. For example, if the limit is 10GB and we
have tensors of sizes [6GB, 6GB, 2GB, 6GB, 2GB, 2GB] they will get sharded as [6GB], [6+2GB], [6+2+2GB] and not
[6+2+2GB], [6+2GB], [6GB].`,kt,N,et,de,tt,he,at,k,pe,Ct,Ae,ia="Return unique identifier to a tensor storage.",At,Ze,ra=`Multiple different tensors can share the same underlying storage. For
example, “meta” tensors all share the same storage, and thus their identifier will all be equal. This identifier is
guaranteed to be unique and constant for this tensor’s storage during its lifetime. Two tensor storages with
non-overlapping lifetimes may have the same id.`,Zt,Le,la='Taken from <a href="https://github.com/huggingface/transformers/blob/1ecf5f7c982d761b4daaa96719d162c324187c64/src/transformers/pytorch_utils.py#L278" rel="nofollow">https://github.com/huggingface/transformers/blob/1ecf5f7c982d761b4daaa96719d162c324187c64/src/transformers/pytorch_utils.py#L278</a>.',st,ge,nt,L,me,Lt,He,ca='Taken from <a href="https://github.com/huggingface/safetensors/blob/08db34094e9e59e2f9218f2df133b7b4aaff5a99/bindings/python/py_src/safetensors/torch.py#L31C1-L41C59" rel="nofollow">https://github.com/huggingface/safetensors/blob/08db34094e9e59e2f9218f2df133b7b4aaff5a99/bindings/python/py_src/safetensors/torch.py#L31C1-L41C59</a>',ot,_e,it,Re,rt;return w=new R({props:{title:"Serialization",local:"serialization",headingTag:"h1"}}),Y=new R({props:{title:"Save torch state dict",local:"huggingface_hub.save_torch_model",headingTag:"h2"}}),K=new ue({props:{name:"huggingface_hub.save_torch_model",anchor:"huggingface_hub.save_torch_model",parameters:[{name:"model",val:": torch.nn.Module"},{name:"save_directory",val:": Union"},{name:"filename_pattern",val:": Optional = None"},{name:"force_contiguous",val:": bool = True"},{name:"max_shard_size",val:": Union = '5GB'"},{name:"metadata",val:": Optional = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"huggingface_hub.save_torch_model.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model to save on disk.`,name:"model"},{anchor:"huggingface_hub.save_torch_model.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The directory in which the model will be saved.`,name:"save_directory"},{anchor:"huggingface_hub.save_torch_model.filename_pattern",description:`<strong>filename_pattern</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The pattern to generate the files names in which the model will be saved. Pattern must be a string that
can be formatted with <code>filename_pattern.format(suffix=...)</code> and must contain the keyword <code>suffix</code>
Defaults to <code>&quot;model{suffix}.safetensors&quot;</code> or <code>pytorch_model{suffix}.bin</code> depending on <code>safe_serialization</code>
parameter.`,name:"filename_pattern"},{anchor:"huggingface_hub.save_torch_model.force_contiguous",description:`<strong>force_contiguous</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Forcing the state_dict to be saved as contiguous tensors. This has no effect on the correctness of the
model, but it could potentially change performance if the layout of the tensor was chosen specifically for
that reason. Defaults to <code>True</code>.`,name:"force_contiguous"},{anchor:"huggingface_hub.save_torch_model.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>) &#x2014;
The maximum size of each shard, in bytes. Defaults to 5GB.`,name:"max_shard_size"},{anchor:"huggingface_hub.save_torch_model.metadata",description:`<strong>metadata</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Extra information to save along with the model. Some metadata will be added for each dropped tensors.
This information will not be enough to recover the entire shared structure but might help understanding
things.`,name:"metadata"},{anchor:"huggingface_hub.save_torch_model.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to save as safetensors, which is the default behavior. If <code>False</code>, the shards are saved as pickle.
Safe serialization is recommended for security reasons. Saving as pickle is deprecated and will be removed
in a future version.`,name:"safe_serialization"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/serialization/_torch.py#L35"}}),V=new Ue({props:{warning:!0,$$slots:{default:[ba]},$$scope:{ctx:y}}}),W=new Ht({props:{anchor:"huggingface_hub.save_torch_model.example",$$slots:{default:[va]},$$scope:{ctx:y}}}),ee=new ue({props:{name:"huggingface_hub.save_torch_state_dict",anchor:"huggingface_hub.save_torch_state_dict",parameters:[{name:"state_dict",val:": Dict"},{name:"save_directory",val:": Union"},{name:"filename_pattern",val:": Optional = None"},{name:"force_contiguous",val:": bool = True"},{name:"max_shard_size",val:": Union = '5GB'"},{name:"metadata",val:": Optional = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"huggingface_hub.save_torch_state_dict.state_dict",description:`<strong>state_dict</strong> (<code>Dict[str, torch.Tensor]</code>) &#x2014;
The state dictionary to save.`,name:"state_dict"},{anchor:"huggingface_hub.save_torch_state_dict.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The directory in which the model will be saved.`,name:"save_directory"},{anchor:"huggingface_hub.save_torch_state_dict.filename_pattern",description:`<strong>filename_pattern</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The pattern to generate the files names in which the model will be saved. Pattern must be a string that
can be formatted with <code>filename_pattern.format(suffix=...)</code> and must contain the keyword <code>suffix</code>
Defaults to <code>&quot;model{suffix}.safetensors&quot;</code> or <code>pytorch_model{suffix}.bin</code> depending on <code>safe_serialization</code>
parameter.`,name:"filename_pattern"},{anchor:"huggingface_hub.save_torch_state_dict.force_contiguous",description:`<strong>force_contiguous</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Forcing the state_dict to be saved as contiguous tensors. This has no effect on the correctness of the
model, but it could potentially change performance if the layout of the tensor was chosen specifically for
that reason. Defaults to <code>True</code>.`,name:"force_contiguous"},{anchor:"huggingface_hub.save_torch_state_dict.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>) &#x2014;
The maximum size of each shard, in bytes. Defaults to 5GB.`,name:"max_shard_size"},{anchor:"huggingface_hub.save_torch_state_dict.metadata",description:`<strong>metadata</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
Extra information to save along with the model. Some metadata will be added for each dropped tensors.
This information will not be enough to recover the entire shared structure but might help understanding
things.`,name:"metadata"},{anchor:"huggingface_hub.save_torch_state_dict.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to save as safetensors, which is the default behavior. If <code>False</code>, the shards are saved as pickle.
Safe serialization is recommended for security reasons. Saving as pickle is deprecated and will be removed
in a future version.`,name:"safe_serialization"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/serialization/_torch.py#L118"}}),E=new Ue({props:{warning:!0,$$slots:{default:[$a]},$$scope:{ctx:y}}}),D=new Ht({props:{anchor:"huggingface_hub.save_torch_state_dict.example",$$slots:{default:[wa]},$$scope:{ctx:y}}}),te=new R({props:{title:"Split state dict into shards",local:"split-state-dict-into-shards",headingTag:"h2"}}),se=new R({props:{title:"split_tf_state_dict_into_shards",local:"huggingface_hub.split_tf_state_dict_into_shards",headingTag:"h3"}}),ne=new ue({props:{name:"huggingface_hub.split_tf_state_dict_into_shards",anchor:"huggingface_hub.split_tf_state_dict_into_shards",parameters:[{name:"state_dict",val:": Dict"},{name:"filename_pattern",val:": str = 'tf_model{suffix}.h5'"},{name:"max_shard_size",val:": Union = '5GB'"}],parametersDescription:[{anchor:"huggingface_hub.split_tf_state_dict_into_shards.state_dict",description:`<strong>state_dict</strong> (<code>Dict[str, Tensor]</code>) &#x2014;
The state dictionary to save.`,name:"state_dict"},{anchor:"huggingface_hub.split_tf_state_dict_into_shards.filename_pattern",description:`<strong>filename_pattern</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The pattern to generate the files names in which the model will be saved. Pattern must be a string that
can be formatted with <code>filename_pattern.format(suffix=...)</code> and must contain the keyword <code>suffix</code>
Defaults to <code>&quot;tf_model{suffix}.h5&quot;</code>.`,name:"filename_pattern"},{anchor:"huggingface_hub.split_tf_state_dict_into_shards.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>) &#x2014;
The maximum size of each shard, in bytes. Defaults to 5GB.`,name:"max_shard_size"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/serialization/_tensorflow.py#L28",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>StateDictSplit</code> object containing the shards and the index to retrieve them.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>StateDictSplit</code></p>
`}}),P=new Ue({props:{warning:!0,$$slots:{default:[Ta]},$$scope:{ctx:y}}}),oe=new R({props:{title:"split_torch_state_dict_into_shards",local:"huggingface_hub.split_torch_state_dict_into_shards",headingTag:"h3"}}),ie=new ue({props:{name:"huggingface_hub.split_torch_state_dict_into_shards",anchor:"huggingface_hub.split_torch_state_dict_into_shards",parameters:[{name:"state_dict",val:": Dict"},{name:"filename_pattern",val:": str = 'model{suffix}.safetensors'"},{name:"max_shard_size",val:": Union = '5GB'"}],parametersDescription:[{anchor:"huggingface_hub.split_torch_state_dict_into_shards.state_dict",description:`<strong>state_dict</strong> (<code>Dict[str, torch.Tensor]</code>) &#x2014;
The state dictionary to save.`,name:"state_dict"},{anchor:"huggingface_hub.split_torch_state_dict_into_shards.filename_pattern",description:`<strong>filename_pattern</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The pattern to generate the files names in which the model will be saved. Pattern must be a string that
can be formatted with <code>filename_pattern.format(suffix=...)</code> and must contain the keyword <code>suffix</code>
Defaults to <code>&quot;model{suffix}.safetensors&quot;</code>.`,name:"filename_pattern"},{anchor:"huggingface_hub.split_torch_state_dict_into_shards.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>) &#x2014;
The maximum size of each shard, in bytes. Defaults to 5GB.`,name:"max_shard_size"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/serialization/_torch.py#L263",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>StateDictSplit</code> object containing the shards and the index to retrieve them.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>StateDictSplit</code></p>
`}}),q=new Ue({props:{$$slots:{default:[Ma]},$$scope:{ctx:y}}}),X=new Ue({props:{warning:!0,$$slots:{default:[ya]},$$scope:{ctx:y}}}),F=new Ht({props:{anchor:"huggingface_hub.split_torch_state_dict_into_shards.example",$$slots:{default:[xa]},$$scope:{ctx:y}}}),re=new R({props:{title:"split_state_dict_into_shards_factory",local:"huggingface_hub.split_state_dict_into_shards_factory",headingTag:"h3"}}),ce=new ue({props:{name:"huggingface_hub.split_state_dict_into_shards_factory",anchor:"huggingface_hub.split_state_dict_into_shards_factory",parameters:[{name:"state_dict",val:": Dict"},{name:"get_storage_size",val:": Callable"},{name:"filename_pattern",val:": str"},{name:"get_storage_id",val:": Callable = <function <lambda> at 0x7f90659ca3b0>"},{name:"max_shard_size",val:": Union = '5GB'"}],parametersDescription:[{anchor:"huggingface_hub.split_state_dict_into_shards_factory.state_dict",description:`<strong>state_dict</strong> (<code>Dict[str, Tensor]</code>) &#x2014;
The state dictionary to save.`,name:"state_dict"},{anchor:"huggingface_hub.split_state_dict_into_shards_factory.get_storage_size",description:`<strong>get_storage_size</strong> (<code>Callable[[Tensor], int]</code>) &#x2014;
A function that returns the size of a tensor when saved on disk in bytes.`,name:"get_storage_size"},{anchor:"huggingface_hub.split_state_dict_into_shards_factory.get_storage_id",description:`<strong>get_storage_id</strong> (<code>Callable[[Tensor], Optional[Any]]</code>, <em>optional</em>) &#x2014;
A function that returns a unique identifier to a tensor storage. Multiple different tensors can share the
same underlying storage. This identifier is guaranteed to be unique and constant for this tensor&#x2019;s storage
during its lifetime. Two tensor storages with non-overlapping lifetimes may have the same id.`,name:"get_storage_id"},{anchor:"huggingface_hub.split_state_dict_into_shards_factory.filename_pattern",description:`<strong>filename_pattern</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The pattern to generate the files names in which the model will be saved. Pattern must be a string that
can be formatted with <code>filename_pattern.format(suffix=...)</code> and must contain the keyword <code>suffix</code>`,name:"filename_pattern"},{anchor:"huggingface_hub.split_state_dict_into_shards_factory.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>) &#x2014;
The maximum size of each shard, in bytes. Defaults to 5GB.`,name:"max_shard_size"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/serialization/_base.py#L49",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>StateDictSplit</code> object containing the shards and the index to retrieve them.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>StateDictSplit</code></p>
`}}),N=new Ue({props:{warning:!0,$$slots:{default:[ja]},$$scope:{ctx:y}}}),de=new R({props:{title:"Helpers",local:"helpers",headingTag:"h2"}}),he=new R({props:{title:"get_torch_storage_id",local:"huggingface_hub.get_torch_storage_id",headingTag:"h3"}}),pe=new ue({props:{name:"huggingface_hub.get_torch_storage_id",anchor:"huggingface_hub.get_torch_storage_id",parameters:[{name:"tensor",val:": torch.Tensor"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/serialization/_torch.py#L371"}}),ge=new R({props:{title:"get_torch_storage_size",local:"huggingface_hub.get_torch_storage_size",headingTag:"h3"}}),me=new ue({props:{name:"huggingface_hub.get_torch_storage_size",anchor:"huggingface_hub.get_torch_storage_size",parameters:[{name:"tensor",val:": torch.Tensor"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/serialization/_torch.py#L385"}}),_e=new ua({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/serialization.md"}}),{c(){t=d("meta"),m=o(),n=d("p"),p=o(),_(w.$$.fragment),c=o(),x=d("p"),x.innerHTML=Rt,Se=o(),_(Y.$$.fragment),Ve=o(),Q=d("p"),Q.innerHTML=St,We=o(),O=d("p"),O.innerHTML=Vt,Ee=o(),T=d("div"),_(K.$$.fragment),lt=o(),be=d("p"),be.textContent=Wt,ct=o(),ve=d("p"),ve.innerHTML=Et,dt=o(),$e=d("p"),$e.innerHTML=Dt,ht=o(),we=d("p"),we.innerHTML=Pt,pt=o(),Te=d("p"),Te.innerHTML=qt,gt=o(),_(V.$$.fragment),mt=o(),_(W.$$.fragment),De=o(),M=d("div"),_(ee.$$.fragment),_t=o(),Me=d("p"),Me.textContent=Xt,ft=o(),ye=d("p"),ye.innerHTML=Ft,ut=o(),xe=d("p"),xe.innerHTML=Nt,bt=o(),je=d("p"),je.innerHTML=Yt,vt=o(),Je=d("p"),Je.innerHTML=Qt,$t=o(),_(E.$$.fragment),wt=o(),_(D.$$.fragment),Pe=o(),_(te.$$.fragment),qe=o(),ae=d("p"),ae.innerHTML=Ot,Xe=o(),_(se.$$.fragment),Fe=o(),G=d("div"),_(ne.$$.fragment),Tt=o(),ze=d("p"),ze.textContent=Kt,Mt=o(),Ie=d("p"),Ie.innerHTML=ea,yt=o(),_(P.$$.fragment),Ne=o(),_(oe.$$.fragment),Ye=o(),z=d("div"),_(ie.$$.fragment),xt=o(),Ge=d("p"),Ge.textContent=ta,jt=o(),Be=d("p"),Be.innerHTML=aa,Jt=o(),_(q.$$.fragment),zt=o(),_(X.$$.fragment),It=o(),_(F.$$.fragment),Qe=o(),_(re.$$.fragment),Oe=o(),le=d("p"),le.innerHTML=sa,Ke=o(),B=d("div"),_(ce.$$.fragment),Gt=o(),ke=d("p"),ke.textContent=na,Bt=o(),Ce=d("p"),Ce.innerHTML=oa,kt=o(),_(N.$$.fragment),et=o(),_(de.$$.fragment),tt=o(),_(he.$$.fragment),at=o(),k=d("div"),_(pe.$$.fragment),Ct=o(),Ae=d("p"),Ae.textContent=ia,At=o(),Ze=d("p"),Ze.textContent=ra,Zt=o(),Le=d("p"),Le.innerHTML=la,st=o(),_(ge.$$.fragment),nt=o(),L=d("div"),_(me.$$.fragment),Lt=o(),He=d("p"),He.innerHTML=ca,ot=o(),_(_e.$$.fragment),it=o(),Re=d("p"),this.h()},l(e){const a=fa("svelte-u9bgzb",document.head);t=h(a,"META",{name:!0,content:!0}),a.forEach(s),m=i(e),n=h(e,"P",{}),H(n).forEach(s),p=i(e),f(w.$$.fragment,e),c=i(e),x=h(e,"P",{"data-svelte-h":!0}),g(x)!=="svelte-pikz64"&&(x.innerHTML=Rt),Se=i(e),f(Y.$$.fragment,e),Ve=i(e),Q=h(e,"P",{"data-svelte-h":!0}),g(Q)!=="svelte-1gnm445"&&(Q.innerHTML=St),We=i(e),O=h(e,"P",{"data-svelte-h":!0}),g(O)!=="svelte-1mocwb"&&(O.innerHTML=Vt),Ee=i(e),T=h(e,"DIV",{class:!0});var j=H(T);f(K.$$.fragment,j),lt=i(j),be=h(j,"P",{"data-svelte-h":!0}),g(be)!=="svelte-ts5jcq"&&(be.textContent=Wt),ct=i(j),ve=h(j,"P",{"data-svelte-h":!0}),g(ve)!=="svelte-12jpcei"&&(ve.innerHTML=Et),dt=i(j),$e=h(j,"P",{"data-svelte-h":!0}),g($e)!=="svelte-hxbjn2"&&($e.innerHTML=Dt),ht=i(j),we=h(j,"P",{"data-svelte-h":!0}),g(we)!=="svelte-b08cux"&&(we.innerHTML=Pt),pt=i(j),Te=h(j,"P",{"data-svelte-h":!0}),g(Te)!=="svelte-zotpm4"&&(Te.innerHTML=qt),gt=i(j),f(V.$$.fragment,j),mt=i(j),f(W.$$.fragment,j),j.forEach(s),De=i(e),M=h(e,"DIV",{class:!0});var J=H(M);f(ee.$$.fragment,J),_t=i(J),Me=h(J,"P",{"data-svelte-h":!0}),g(Me)!=="svelte-1hwpwyy"&&(Me.textContent=Xt),ft=i(J),ye=h(J,"P",{"data-svelte-h":!0}),g(ye)!=="svelte-1sy8rkx"&&(ye.innerHTML=Ft),ut=i(J),xe=h(J,"P",{"data-svelte-h":!0}),g(xe)!=="svelte-hxbjn2"&&(xe.innerHTML=Nt),bt=i(J),je=h(J,"P",{"data-svelte-h":!0}),g(je)!=="svelte-b08cux"&&(je.innerHTML=Yt),vt=i(J),Je=h(J,"P",{"data-svelte-h":!0}),g(Je)!=="svelte-zotpm4"&&(Je.innerHTML=Qt),$t=i(J),f(E.$$.fragment,J),wt=i(J),f(D.$$.fragment,J),J.forEach(s),Pe=i(e),f(te.$$.fragment,e),qe=i(e),ae=h(e,"P",{"data-svelte-h":!0}),g(ae)!=="svelte-1jvx2r9"&&(ae.innerHTML=Ot),Xe=i(e),f(se.$$.fragment,e),Fe=i(e),G=h(e,"DIV",{class:!0});var C=H(G);f(ne.$$.fragment,C),Tt=i(C),ze=h(C,"P",{"data-svelte-h":!0}),g(ze)!=="svelte-1q1pe7b"&&(ze.textContent=Kt),Mt=i(C),Ie=h(C,"P",{"data-svelte-h":!0}),g(Ie)!=="svelte-17rio2z"&&(Ie.innerHTML=ea),yt=i(C),f(P.$$.fragment,C),C.forEach(s),Ne=i(e),f(oe.$$.fragment,e),Ye=i(e),z=h(e,"DIV",{class:!0});var I=H(z);f(ie.$$.fragment,I),xt=i(I),Ge=h(I,"P",{"data-svelte-h":!0}),g(Ge)!=="svelte-1q1pe7b"&&(Ge.textContent=ta),jt=i(I),Be=h(I,"P",{"data-svelte-h":!0}),g(Be)!=="svelte-17rio2z"&&(Be.innerHTML=aa),Jt=i(I),f(q.$$.fragment,I),zt=i(I),f(X.$$.fragment,I),It=i(I),f(F.$$.fragment,I),I.forEach(s),Qe=i(e),f(re.$$.fragment,e),Oe=i(e),le=h(e,"P",{"data-svelte-h":!0}),g(le)!=="svelte-1hva642"&&(le.innerHTML=sa),Ke=i(e),B=h(e,"DIV",{class:!0});var A=H(B);f(ce.$$.fragment,A),Gt=i(A),ke=h(A,"P",{"data-svelte-h":!0}),g(ke)!=="svelte-1q1pe7b"&&(ke.textContent=na),Bt=i(A),Ce=h(A,"P",{"data-svelte-h":!0}),g(Ce)!=="svelte-17rio2z"&&(Ce.innerHTML=oa),kt=i(A),f(N.$$.fragment,A),A.forEach(s),et=i(e),f(de.$$.fragment,e),tt=i(e),f(he.$$.fragment,e),at=i(e),k=h(e,"DIV",{class:!0});var Z=H(k);f(pe.$$.fragment,Z),Ct=i(Z),Ae=h(Z,"P",{"data-svelte-h":!0}),g(Ae)!=="svelte-lfv2l4"&&(Ae.textContent=ia),At=i(Z),Ze=h(Z,"P",{"data-svelte-h":!0}),g(Ze)!=="svelte-4klsmr"&&(Ze.textContent=ra),Zt=i(Z),Le=h(Z,"P",{"data-svelte-h":!0}),g(Le)!=="svelte-akggeo"&&(Le.innerHTML=la),Z.forEach(s),st=i(e),f(ge.$$.fragment,e),nt=i(e),L=h(e,"DIV",{class:!0});var fe=H(L);f(me.$$.fragment,fe),Lt=i(fe),He=h(fe,"P",{"data-svelte-h":!0}),g(He)!=="svelte-1ey7lf2"&&(He.innerHTML=ca),fe.forEach(s),ot=i(e),f(_e.$$.fragment,e),it=i(e),Re=h(e,"P",{}),H(Re).forEach(s),this.h()},h(){U(t,"name","hf:doc:metadata"),U(t,"content",za),U(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){r(document.head,t),l(e,m,a),l(e,n,a),l(e,p,a),u(w,e,a),l(e,c,a),l(e,x,a),l(e,Se,a),u(Y,e,a),l(e,Ve,a),l(e,Q,a),l(e,We,a),l(e,O,a),l(e,Ee,a),l(e,T,a),u(K,T,null),r(T,lt),r(T,be),r(T,ct),r(T,ve),r(T,dt),r(T,$e),r(T,ht),r(T,we),r(T,pt),r(T,Te),r(T,gt),u(V,T,null),r(T,mt),u(W,T,null),l(e,De,a),l(e,M,a),u(ee,M,null),r(M,_t),r(M,Me),r(M,ft),r(M,ye),r(M,ut),r(M,xe),r(M,bt),r(M,je),r(M,vt),r(M,Je),r(M,$t),u(E,M,null),r(M,wt),u(D,M,null),l(e,Pe,a),u(te,e,a),l(e,qe,a),l(e,ae,a),l(e,Xe,a),u(se,e,a),l(e,Fe,a),l(e,G,a),u(ne,G,null),r(G,Tt),r(G,ze),r(G,Mt),r(G,Ie),r(G,yt),u(P,G,null),l(e,Ne,a),u(oe,e,a),l(e,Ye,a),l(e,z,a),u(ie,z,null),r(z,xt),r(z,Ge),r(z,jt),r(z,Be),r(z,Jt),u(q,z,null),r(z,zt),u(X,z,null),r(z,It),u(F,z,null),l(e,Qe,a),u(re,e,a),l(e,Oe,a),l(e,le,a),l(e,Ke,a),l(e,B,a),u(ce,B,null),r(B,Gt),r(B,ke),r(B,Bt),r(B,Ce),r(B,kt),u(N,B,null),l(e,et,a),u(de,e,a),l(e,tt,a),u(he,e,a),l(e,at,a),l(e,k,a),u(pe,k,null),r(k,Ct),r(k,Ae),r(k,At),r(k,Ze),r(k,Zt),r(k,Le),l(e,st,a),u(ge,e,a),l(e,nt,a),l(e,L,a),u(me,L,null),r(L,Lt),r(L,He),l(e,ot,a),u(_e,e,a),l(e,it,a),l(e,Re,a),rt=!0},p(e,[a]){const j={};a&2&&(j.$$scope={dirty:a,ctx:e}),V.$set(j);const J={};a&2&&(J.$$scope={dirty:a,ctx:e}),W.$set(J);const C={};a&2&&(C.$$scope={dirty:a,ctx:e}),E.$set(C);const I={};a&2&&(I.$$scope={dirty:a,ctx:e}),D.$set(I);const A={};a&2&&(A.$$scope={dirty:a,ctx:e}),P.$set(A);const Z={};a&2&&(Z.$$scope={dirty:a,ctx:e}),q.$set(Z);const fe={};a&2&&(fe.$$scope={dirty:a,ctx:e}),X.$set(fe);const da={};a&2&&(da.$$scope={dirty:a,ctx:e}),F.$set(da);const ha={};a&2&&(ha.$$scope={dirty:a,ctx:e}),N.$set(ha)},i(e){rt||(b(w.$$.fragment,e),b(Y.$$.fragment,e),b(K.$$.fragment,e),b(V.$$.fragment,e),b(W.$$.fragment,e),b(ee.$$.fragment,e),b(E.$$.fragment,e),b(D.$$.fragment,e),b(te.$$.fragment,e),b(se.$$.fragment,e),b(ne.$$.fragment,e),b(P.$$.fragment,e),b(oe.$$.fragment,e),b(ie.$$.fragment,e),b(q.$$.fragment,e),b(X.$$.fragment,e),b(F.$$.fragment,e),b(re.$$.fragment,e),b(ce.$$.fragment,e),b(N.$$.fragment,e),b(de.$$.fragment,e),b(he.$$.fragment,e),b(pe.$$.fragment,e),b(ge.$$.fragment,e),b(me.$$.fragment,e),b(_e.$$.fragment,e),rt=!0)},o(e){v(w.$$.fragment,e),v(Y.$$.fragment,e),v(K.$$.fragment,e),v(V.$$.fragment,e),v(W.$$.fragment,e),v(ee.$$.fragment,e),v(E.$$.fragment,e),v(D.$$.fragment,e),v(te.$$.fragment,e),v(se.$$.fragment,e),v(ne.$$.fragment,e),v(P.$$.fragment,e),v(oe.$$.fragment,e),v(ie.$$.fragment,e),v(q.$$.fragment,e),v(X.$$.fragment,e),v(F.$$.fragment,e),v(re.$$.fragment,e),v(ce.$$.fragment,e),v(N.$$.fragment,e),v(de.$$.fragment,e),v(he.$$.fragment,e),v(pe.$$.fragment,e),v(ge.$$.fragment,e),v(me.$$.fragment,e),v(_e.$$.fragment,e),rt=!1},d(e){e&&(s(m),s(n),s(p),s(c),s(x),s(Se),s(Ve),s(Q),s(We),s(O),s(Ee),s(T),s(De),s(M),s(Pe),s(qe),s(ae),s(Xe),s(Fe),s(G),s(Ne),s(Ye),s(z),s(Qe),s(Oe),s(le),s(Ke),s(B),s(et),s(tt),s(at),s(k),s(st),s(nt),s(L),s(ot),s(it),s(Re)),s(t),$(w,e),$(Y,e),$(K),$(V),$(W),$(ee),$(E),$(D),$(te,e),$(se,e),$(ne),$(P),$(oe,e),$(ie),$(q),$(X),$(F),$(re,e),$(ce),$(N),$(de,e),$(he,e),$(pe),$(ge,e),$(me),$(_e,e)}}}const za='{"title":"Serialization","local":"serialization","sections":[{"title":"Save torch state dict","local":"huggingface_hub.save_torch_model","sections":[],"depth":2},{"title":"Split state dict into shards","local":"split-state-dict-into-shards","sections":[{"title":"split_tf_state_dict_into_shards","local":"huggingface_hub.split_tf_state_dict_into_shards","sections":[],"depth":3},{"title":"split_torch_state_dict_into_shards","local":"huggingface_hub.split_torch_state_dict_into_shards","sections":[],"depth":3},{"title":"split_state_dict_into_shards_factory","local":"huggingface_hub.split_state_dict_into_shards_factory","sections":[],"depth":3}],"depth":2},{"title":"Helpers","local":"helpers","sections":[{"title":"get_torch_storage_id","local":"huggingface_hub.get_torch_storage_id","sections":[],"depth":3},{"title":"get_torch_storage_size","local":"huggingface_hub.get_torch_storage_size","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ia(y){return ga(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ha extends ma{constructor(t){super(),_a(this,t,Ia,Ja,pa,{})}}export{Ha as component};
