import{s as hs,o as fs,n as F}from"../chunks/scheduler.9bc65507.js";import{S as us,i as gs,g as d,s,r as h,A as _s,h as c,f as a,c as r,j as M,u as f,x as k,k as $,y as o,a as p,v as u,d as g,t as _,w as b}from"../chunks/index.707bf1b6.js";import{T as Pt}from"../chunks/Tip.c2ecdbf4.js";import{D as x}from"../chunks/Docstring.17db21ae.js";import{C as Me}from"../chunks/CodeBlock.54a9f38d.js";import{E as we}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as D}from"../chunks/Heading.342b1fa6.js";function bs(w){let n,v="Example:",m,l,y;return l=new Me({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlYWxtQ29uZmlnJTJDJTIwUmVhbG1FbWJlZGRlciUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBSRUFMTSUyMHJlYWxtLWNjLW5ld3MtcHJldHJhaW5lZC0qJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFJlYWxtQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGdvb2dsZSUyRnJlYWxtLWNjLW5ld3MtcHJldHJhaW5lZC1lbWJlZGRlciUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwUmVhbG1FbWJlZGRlcihjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> RealmConfig, RealmEmbedder

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a REALM realm-cc-news-pretrained-* style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = RealmConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the google/realm-cc-news-pretrained-embedder style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = RealmEmbedder(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=d("p"),n.textContent=v,m=s(),h(l.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),k(n)!=="svelte-11lpom8"&&(n.textContent=v),m=r(t),f(l.$$.fragment,t)},m(t,T){p(t,n,T),p(t,m,T),u(l,t,T),y=!0},p:F,i(t){y||(g(l.$$.fragment,t),y=!0)},o(t){_(l.$$.fragment,t),y=!1},d(t){t&&(a(n),a(m)),b(l,t)}}}function ks(w){let n,v="pair mask has the following format:",m,l,y;return l=new Me({props:{code:"MCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMEElN0MlMjBmaXJzdCUyMHNlcXVlbmNlJTIwJTIwJTIwJTIwJTdDJTIwc2Vjb25kJTIwc2VxdWVuY2UlMjAlN0M=",highlighted:`0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1 1
| first sequence    | second sequence |`,wrap:!1}}),{c(){n=d("p"),n.textContent=v,m=s(),h(l.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),k(n)!=="svelte-qjgeij"&&(n.textContent=v),m=r(t),f(l.$$.fragment,t)},m(t,T){p(t,n,T),p(t,m,T),u(l,t,T),y=!0},p:F,i(t){y||(g(l.$$.fragment,t),y=!0)},o(t){_(l.$$.fragment,t),y=!1},d(t){t&&(a(n),a(m)),b(l,t)}}}function ys(w){let n,v="Example:",m,l,y;return l=new Me({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlYWxtVG9rZW5pemVyJTBBJTBBJTIzJTIwYmF0Y2hfc2l6ZSUyMCUzRCUyMDIlMkMlMjBudW1fY2FuZGlkYXRlcyUyMCUzRCUyMDIlMEF0ZXh0JTIwJTNEJTIwJTVCJTVCJTIySGVsbG8lMjB3b3JsZCElMjIlMkMlMjAlMjJOaWNlJTIwdG8lMjBtZWV0JTIweW91ISUyMiU1RCUyQyUyMCU1QiUyMlRoZSUyMGN1dGUlMjBjYXQuJTIyJTJDJTIwJTIyVGhlJTIwYWRvcmFibGUlMjBkb2cuJTIyJTVEJTVEJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwUmVhbG1Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnJlYWxtLWNjLW5ld3MtcHJldHJhaW5lZC1lbmNvZGVyJTIyKSUwQXRva2VuaXplZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2VuY29kZV9jYW5kaWRhdGVzKHRleHQlMkMlMjBtYXhfbGVuZ3RoJTNEMTAlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> RealmTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># batch_size = 2, num_candidates = 2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = [[<span class="hljs-string">&quot;Hello world!&quot;</span>, <span class="hljs-string">&quot;Nice to meet you!&quot;</span>], [<span class="hljs-string">&quot;The cute cat.&quot;</span>, <span class="hljs-string">&quot;The adorable dog.&quot;</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = RealmTokenizer.from_pretrained(<span class="hljs-string">&quot;google/realm-cc-news-pretrained-encoder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_text = tokenizer.batch_encode_candidates(text, max_length=<span class="hljs-number">10</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),{c(){n=d("p"),n.textContent=v,m=s(),h(l.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),k(n)!=="svelte-11lpom8"&&(n.textContent=v),m=r(t),f(l.$$.fragment,t)},m(t,T){p(t,n,T),p(t,m,T),u(l,t,T),y=!0},p:F,i(t){y||(g(l.$$.fragment,t),y=!0)},o(t){_(l.$$.fragment,t),y=!1},d(t){t&&(a(n),a(m)),b(l,t)}}}function vs(w){let n,v="Example:",m,l,y;return l=new Me({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlYWxtVG9rZW5pemVyRmFzdCUwQSUwQSUyMyUyMGJhdGNoX3NpemUlMjAlM0QlMjAyJTJDJTIwbnVtX2NhbmRpZGF0ZXMlMjAlM0QlMjAyJTBBdGV4dCUyMCUzRCUyMCU1QiU1QiUyMkhlbGxvJTIwd29ybGQhJTIyJTJDJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlNUQlMkMlMjAlNUIlMjJUaGUlMjBjdXRlJTIwY2F0LiUyMiUyQyUyMCUyMlRoZSUyMGFkb3JhYmxlJTIwZG9nLiUyMiU1RCU1RCUwQSUwQXRva2VuaXplciUyMCUzRCUyMFJlYWxtVG9rZW5pemVyRmFzdC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcmVhbG0tY2MtbmV3cy1wcmV0cmFpbmVkLWVuY29kZXIlMjIpJTBBdG9rZW5pemVkX3RleHQlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZW5jb2RlX2NhbmRpZGF0ZXModGV4dCUyQyUyMG1heF9sZW5ndGglM0QxMCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> RealmTokenizerFast

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># batch_size = 2, num_candidates = 2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = [[<span class="hljs-string">&quot;Hello world!&quot;</span>, <span class="hljs-string">&quot;Nice to meet you!&quot;</span>], [<span class="hljs-string">&quot;The cute cat.&quot;</span>, <span class="hljs-string">&quot;The adorable dog.&quot;</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = RealmTokenizerFast.from_pretrained(<span class="hljs-string">&quot;google/realm-cc-news-pretrained-encoder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_text = tokenizer.batch_encode_candidates(text, max_length=<span class="hljs-number">10</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),{c(){n=d("p"),n.textContent=v,m=s(),h(l.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),k(n)!=="svelte-11lpom8"&&(n.textContent=v),m=r(t),f(l.$$.fragment,t)},m(t,T){p(t,n,T),p(t,m,T),u(l,t,T),y=!0},p:F,i(t){y||(g(l.$$.fragment,t),y=!0)},o(t){_(l.$$.fragment,t),y=!1},d(t){t&&(a(n),a(m)),b(l,t)}}}function Ts(w){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=v},l(m){n=c(m,"P",{"data-svelte-h":!0}),k(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(m,l){p(m,n,l)},p:F,d(m){m&&a(n)}}}function ws(w){let n,v="Example:",m,l,y;return l=new Me({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBSZWFsbUVtYmVkZGVyJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZyZWFsbS1jYy1uZXdzLXByZXRyYWluZWQtZW1iZWRkZXIlMjIpJTBBbW9kZWwlMjAlM0QlMjBSZWFsbUVtYmVkZGVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZyZWFsbS1jYy1uZXdzLXByZXRyYWluZWQtZW1iZWRkZXIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFwcm9qZWN0ZWRfc2NvcmUlMjAlM0QlMjBvdXRwdXRzLnByb2plY3RlZF9zY29yZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, RealmEmbedder
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/realm-cc-news-pretrained-embedder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = RealmEmbedder.from_pretrained(<span class="hljs-string">&quot;google/realm-cc-news-pretrained-embedder&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>projected_score = outputs.projected_score`,wrap:!1}}),{c(){n=d("p"),n.textContent=v,m=s(),h(l.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),k(n)!=="svelte-11lpom8"&&(n.textContent=v),m=r(t),f(l.$$.fragment,t)},m(t,T){p(t,n,T),p(t,m,T),u(l,t,T),y=!0},p:F,i(t){y||(g(l.$$.fragment,t),y=!0)},o(t){_(l.$$.fragment,t),y=!1},d(t){t&&(a(n),a(m)),b(l,t)}}}function Ms(w){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=v},l(m){n=c(m,"P",{"data-svelte-h":!0}),k(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(m,l){p(m,n,l)},p:F,d(m){m&&a(n)}}}function $s(w){let n,v="Example:",m,l,y;return l=new Me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFJlYWxtU2NvcmVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcmVhbG0tY2MtbmV3cy1wcmV0cmFpbmVkLXNjb3JlciUyMiklMEFtb2RlbCUyMCUzRCUyMFJlYWxtU2NvcmVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZyZWFsbS1jYy1uZXdzLXByZXRyYWluZWQtc2NvcmVyJTIyJTJDJTIwbnVtX2NhbmRpZGF0ZXMlM0QyKSUwQSUwQSUyMyUyMGJhdGNoX3NpemUlMjAlM0QlMjAyJTJDJTIwbnVtX2NhbmRpZGF0ZXMlMjAlM0QlMjAyJTBBaW5wdXRfdGV4dHMlMjAlM0QlMjAlNUIlMjJIb3clMjBhcmUlMjB5b3UlM0YlMjIlMkMlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBpdGVtJTIwaW4lMjB0aGUlMjBwaWN0dXJlJTNGJTIyJTVEJTBBY2FuZGlkYXRlc190ZXh0cyUyMCUzRCUyMCU1QiU1QiUyMkhlbGxvJTIwd29ybGQhJTIyJTJDJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlNUQlMkMlMjAlNUIlMjJBJTIwY3V0ZSUyMGNhdC4lMjIlMkMlMjAlMjJBbiUyMGFkb3JhYmxlJTIwZG9nLiUyMiU1RCU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihpbnB1dF90ZXh0cyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBY2FuZGlkYXRlc19pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZW5jb2RlX2NhbmRpZGF0ZXMoY2FuZGlkYXRlc190ZXh0cyUyQyUyMG1heF9sZW5ndGglM0QxMCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCUwQSUyMCUyMCUyMCUyMCoqaW5wdXRzJTJDJTBBJTIwJTIwJTIwJTIwY2FuZGlkYXRlX2lucHV0X2lkcyUzRGNhbmRpZGF0ZXNfaW5wdXRzLmlucHV0X2lkcyUyQyUwQSUyMCUyMCUyMCUyMGNhbmRpZGF0ZV9hdHRlbnRpb25fbWFzayUzRGNhbmRpZGF0ZXNfaW5wdXRzLmF0dGVudGlvbl9tYXNrJTJDJTBBJTIwJTIwJTIwJTIwY2FuZGlkYXRlX3Rva2VuX3R5cGVfaWRzJTNEY2FuZGlkYXRlc19pbnB1dHMudG9rZW5fdHlwZV9pZHMlMkMlMEEpJTBBcmVsZXZhbmNlX3Njb3JlJTIwJTNEJTIwb3V0cHV0cy5yZWxldmFuY2Vfc2NvcmU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, RealmScorer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/realm-cc-news-pretrained-scorer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = RealmScorer.from_pretrained(<span class="hljs-string">&quot;google/realm-cc-news-pretrained-scorer&quot;</span>, num_candidates=<span class="hljs-number">2</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># batch_size = 2, num_candidates = 2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_texts = [<span class="hljs-string">&quot;How are you?&quot;</span>, <span class="hljs-string">&quot;What is the item in the picture?&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>candidates_texts = [[<span class="hljs-string">&quot;Hello world!&quot;</span>, <span class="hljs-string">&quot;Nice to meet you!&quot;</span>], [<span class="hljs-string">&quot;A cute cat.&quot;</span>, <span class="hljs-string">&quot;An adorable dog.&quot;</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(input_texts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>candidates_inputs = tokenizer.batch_encode_candidates(candidates_texts, max_length=<span class="hljs-number">10</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    candidate_input_ids=candidates_inputs.input_ids,
<span class="hljs-meta">... </span>    candidate_attention_mask=candidates_inputs.attention_mask,
<span class="hljs-meta">... </span>    candidate_token_type_ids=candidates_inputs.token_type_ids,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>relevance_score = outputs.relevance_score`,wrap:!1}}),{c(){n=d("p"),n.textContent=v,m=s(),h(l.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),k(n)!=="svelte-11lpom8"&&(n.textContent=v),m=r(t),f(l.$$.fragment,t)},m(t,T){p(t,n,T),p(t,m,T),u(l,t,T),y=!0},p:F,i(t){y||(g(l.$$.fragment,t),y=!0)},o(t){_(l.$$.fragment,t),y=!1},d(t){t&&(a(n),a(m)),b(l,t)}}}function Rs(w){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=v},l(m){n=c(m,"P",{"data-svelte-h":!0}),k(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(m,l){p(m,n,l)},p:F,d(m){m&&a(n)}}}function xs(w){let n,v="Example:",m,l,y;return l=new Me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFJlYWxtS25vd2xlZGdlQXVnRW5jb2RlciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnJlYWxtLWNjLW5ld3MtcHJldHJhaW5lZC1lbmNvZGVyJTIyKSUwQW1vZGVsJTIwJTNEJTIwUmVhbG1Lbm93bGVkZ2VBdWdFbmNvZGVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJnb29nbGUlMkZyZWFsbS1jYy1uZXdzLXByZXRyYWluZWQtZW5jb2RlciUyMiUyQyUyMG51bV9jYW5kaWRhdGVzJTNEMiUwQSklMEElMEElMjMlMjBiYXRjaF9zaXplJTIwJTNEJTIwMiUyQyUyMG51bV9jYW5kaWRhdGVzJTIwJTNEJTIwMiUwQXRleHQlMjAlM0QlMjAlNUIlNUIlMjJIZWxsbyUyMHdvcmxkISUyMiUyQyUyMCUyMk5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTIyJTVEJTJDJTIwJTVCJTIyVGhlJTIwY3V0ZSUyMGNhdC4lMjIlMkMlMjAlMjJUaGUlMjBhZG9yYWJsZSUyMGRvZy4lMjIlNUQlNUQlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZW5jb2RlX2NhbmRpZGF0ZXModGV4dCUyQyUyMG1heF9sZW5ndGglM0QxMCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, RealmKnowledgeAugEncoder

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/realm-cc-news-pretrained-encoder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = RealmKnowledgeAugEncoder.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;google/realm-cc-news-pretrained-encoder&quot;</span>, num_candidates=<span class="hljs-number">2</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># batch_size = 2, num_candidates = 2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = [[<span class="hljs-string">&quot;Hello world!&quot;</span>, <span class="hljs-string">&quot;Nice to meet you!&quot;</span>], [<span class="hljs-string">&quot;The cute cat.&quot;</span>, <span class="hljs-string">&quot;The adorable dog.&quot;</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer.batch_encode_candidates(text, max_length=<span class="hljs-number">10</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=d("p"),n.textContent=v,m=s(),h(l.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),k(n)!=="svelte-11lpom8"&&(n.textContent=v),m=r(t),f(l.$$.fragment,t)},m(t,T){p(t,n,T),p(t,m,T),u(l,t,T),y=!0},p:F,i(t){y||(g(l.$$.fragment,t),y=!0)},o(t){_(l.$$.fragment,t),y=!1},d(t){t&&(a(n),a(m)),b(l,t)}}}function zs(w){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=v},l(m){n=c(m,"P",{"data-svelte-h":!0}),k(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(m,l){p(m,n,l)},p:F,d(m){m&&a(n)}}}function js(w){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=v},l(m){n=c(m,"P",{"data-svelte-h":!0}),k(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(m,l){p(m,n,l)},p:F,d(m){m&&a(n)}}}function Js(w){let n,v="Example:",m,l,y;return l=new Me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwUmVhbG1Gb3JPcGVuUUElMkMlMjBSZWFsbVJldHJpZXZlciUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEFyZXRyaWV2ZXIlMjAlM0QlMjBSZWFsbVJldHJpZXZlci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcmVhbG0tb3JxYS1ucS1vcGVucWElMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcmVhbG0tb3JxYS1ucS1vcGVucWElMjIpJTBBbW9kZWwlMjAlM0QlMjBSZWFsbUZvck9wZW5RQS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcmVhbG0tb3JxYS1ucS1vcGVucWElMjIlMkMlMjByZXRyaWV2ZXIlM0RyZXRyaWV2ZXIpJTBBJTBBcXVlc3Rpb24lMjAlM0QlMjAlMjJXaG8lMjBpcyUyMHRoZSUyMHBpb25lZXIlMjBpbiUyMG1vZGVybiUyMGNvbXB1dGVyJTIwc2NpZW5jZSUzRiUyMiUwQXF1ZXN0aW9uX2lkcyUyMCUzRCUyMHRva2VuaXplciglNUJxdWVzdGlvbiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBYW5zd2VyX2lkcyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlNUIlMjJhbGFuJTIwbWF0aGlzb24lMjB0dXJpbmclMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90b2tlbl90eXBlX2lkcyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX2F0dGVudGlvbl9tYXNrJTNERmFsc2UlMkMlMEEpLmlucHV0X2lkcyUwQSUwQXJlYWRlcl9vdXRwdXQlMkMlMjBwcmVkaWN0ZWRfYW5zd2VyX2lkcyUyMCUzRCUyMG1vZGVsKCoqcXVlc3Rpb25faWRzJTJDJTIwYW5zd2VyX2lkcyUzRGFuc3dlcl9pZHMlMkMlMjByZXR1cm5fZGljdCUzREZhbHNlKSUwQXByZWRpY3RlZF9hbnN3ZXIlMjAlM0QlMjB0b2tlbml6ZXIuZGVjb2RlKHByZWRpY3RlZF9hbnN3ZXJfaWRzKSUwQWxvc3MlMjAlM0QlMjByZWFkZXJfb3V0cHV0Lmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> RealmForOpenQA, RealmRetriever, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>retriever = RealmRetriever.from_pretrained(<span class="hljs-string">&quot;google/realm-orqa-nq-openqa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/realm-orqa-nq-openqa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = RealmForOpenQA.from_pretrained(<span class="hljs-string">&quot;google/realm-orqa-nq-openqa&quot;</span>, retriever=retriever)

<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;Who is the pioneer in modern computer science?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>question_ids = tokenizer([question], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_ids = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;alan mathison turing&quot;</span>],
<span class="hljs-meta">... </span>    add_special_tokens=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    return_token_type_ids=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    return_attention_mask=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>reader_output, predicted_answer_ids = model(**question_ids, answer_ids=answer_ids, return_dict=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_answer = tokenizer.decode(predicted_answer_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = reader_output.loss`,wrap:!1}}),{c(){n=d("p"),n.textContent=v,m=s(),h(l.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),k(n)!=="svelte-11lpom8"&&(n.textContent=v),m=r(t),f(l.$$.fragment,t)},m(t,T){p(t,n,T),p(t,m,T),u(l,t,T),y=!0},p:F,i(t){y||(g(l.$$.fragment,t),y=!0)},o(t){_(l.$$.fragment,t),y=!1},d(t){t&&(a(n),a(m)),b(l,t)}}}function Us(w){let n,v,m,l,y,t,T,Ot,$e,jo=`The REALM model was proposed in <a href="https://arxiv.org/abs/2002.08909" rel="nofollow">REALM: Retrieval-Augmented Language Model Pre-Training</a> by Kelvin Guu, Kenton Lee, Zora Tung, Panupong Pasupat and Ming-Wei Chang. It’s a
retrieval-augmented language model that firstly retrieves documents from a textual knowledge corpus and then
utilizes retrieved documents to process question answering tasks.`,Dt,Re,Jo="The abstract from the paper is the following:",Yt,xe,Uo=`<em>Language model pre-training has been shown to capture a surprising amount of world knowledge, crucial for NLP tasks
such as question answering. However, this knowledge is stored implicitly in the parameters of a neural network,
requiring ever-larger networks to cover more facts. To capture knowledge in a more modular and interpretable way, we
augment language model pre-training with a latent knowledge retriever, which allows the model to retrieve and attend
over documents from a large corpus such as Wikipedia, used during pre-training, fine-tuning and inference. For the
first time, we show how to pre-train such a knowledge retriever in an unsupervised manner, using masked language
modeling as the learning signal and backpropagating through a retrieval step that considers millions of documents. We
demonstrate the effectiveness of Retrieval-Augmented Language Model pre-training (REALM) by fine-tuning on the
challenging task of Open-domain Question Answering (Open-QA). We compare against state-of-the-art models for both
explicit and implicit knowledge storage on three popular Open-QA benchmarks, and find that we outperform all previous
methods by a significant margin (4-16% absolute accuracy), while also providing qualitative benefits such as
interpretability and modularity.</em>`,Kt,ze,qo=`This model was contributed by <a href="https://huggingface.co/qqaatw" rel="nofollow">qqaatw</a>. The original code can be found
<a href="https://github.com/google-research/language/tree/master/language/realm" rel="nofollow">here</a>.`,en,je,tn,j,Je,Tn,lt,Co="This is the configuration class to store the configuration of",wn,dt,Io='<li><a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmEmbedder">RealmEmbedder</a></li> <li><a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmScorer">RealmScorer</a></li> <li><a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmKnowledgeAugEncoder">RealmKnowledgeAugEncoder</a></li> <li><a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmRetriever">RealmRetriever</a></li> <li><a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmReader">RealmReader</a></li> <li><a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmForOpenQA">RealmForOpenQA</a></li>',Mn,ct,Lo=`It is used to instantiate an REALM model according to the specified arguments, defining the model architecture.
Instantiating a configuration with the defaults will yield a similar configuration to that of the REALM
<a href="https://huggingface.co/google/realm-cc-news-pretrained-embedder" rel="nofollow">google/realm-cc-news-pretrained-embedder</a>
architecture.`,$n,mt,Zo=`Configuration objects inherit from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Rn,oe,nn,Ue,on,R,qe,xn,pt,Wo="Construct a REALM tokenizer.",zn,ht,Fo=`<a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmTokenizer">RealmTokenizer</a> is identical to <a href="/docs/transformers/v4.34.0/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> and runs end-to-end tokenization: punctuation splitting and
wordpiece.`,jn,ft,Eo=`This tokenizer inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Jn,Y,Ce,Un,ut,Ao=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. A REALM sequence has the following format:`,qn,gt,Vo="<li>single sequence: <code>[CLS] X [SEP]</code></li> <li>pair of sequences: <code>[CLS] A [SEP] B [SEP]</code></li>",Cn,se,Ie,In,_t,Ho=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,Ln,E,Le,Zn,bt,Go="Create a mask from the two sequences passed to be used in a sequence-pair classification task. A REALM sequence",Wn,re,Fn,kt,Bo="If <code>token_ids_1</code> is <code>None</code>, this method only returns the first portion of the mask (0s).",En,yt,Ze,An,q,We,Vn,vt,No=`Encode a batch of text or text pair. This method is similar to regular <strong>call</strong> method but has the following
differences:`,Hn,Tt,So="<li>Handle additional num_candidate axis. (batch_size, num_candidates, text)</li> <li>Always pad the sequences to <em>max_length</em>.</li> <li>Must specify <em>max_length</em> in order to stack packs of candidates into a batch.</li>",Gn,wt,Xo="<li>single sequence: <code>[CLS] X [SEP]</code></li> <li>pair of sequences: <code>[CLS] A [SEP] B [SEP]</code></li>",Bn,ae,sn,Fe,rn,J,Ee,Nn,Mt,Qo="Construct a “fast” REALM tokenizer (backed by HuggingFace’s <em>tokenizers</em> library). Based on WordPiece.",Sn,$t,Po=`<a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmTokenizerFast">RealmTokenizerFast</a> is identical to <a href="/docs/transformers/v4.34.0/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> and runs end-to-end tokenization: punctuation
splitting and wordpiece.`,Xn,Rt,Oo=`This tokenizer inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,Qn,C,Ae,Pn,xt,Do=`Encode a batch of text or text pair. This method is similar to regular <strong>call</strong> method but has the following
differences:`,On,zt,Yo="<li>Handle additional num_candidate axis. (batch_size, num_candidates, text)</li> <li>Always pad the sequences to <em>max_length</em>.</li> <li>Must specify <em>max_length</em> in order to stack packs of candidates into a batch.</li>",Dn,jt,Ko="<li>single sequence: <code>[CLS] X [SEP]</code></li> <li>pair of sequences: <code>[CLS] A [SEP] B [SEP]</code></li>",Yn,ie,an,Ve,ln,B,He,Kn,Jt,es=`The retriever of REALM outputting the retrieved evidence block and whether the block has answers as well as answer
positions.”`,eo,le,Ge,to,Ut,ts="check if retrieved_blocks has answers.",dn,Be,cn,N,Ne,no,qt,ns=`The embedder of REALM outputting projected score that will be used to calculate relevance score.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,oo,A,Se,so,Ct,os='The <a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmEmbedder">RealmEmbedder</a> forward method, overrides the <code>__call__</code> special method.',ro,de,ao,ce,mn,Xe,pn,S,Qe,io,It,ss=`The scorer of REALM outputting relevance scores representing the score of document candidates (before softmax).
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,lo,V,Pe,co,Lt,rs='The <a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmScorer">RealmScorer</a> forward method, overrides the <code>__call__</code> special method.',mo,me,po,pe,hn,Oe,fn,X,De,ho,Zt,as=`The knowledge-augmented encoder of REALM outputting masked language model logits and marginal log-likelihood loss.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,fo,H,Ye,uo,Wt,is='The <a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmKnowledgeAugEncoder">RealmKnowledgeAugEncoder</a> forward method, overrides the <code>__call__</code> special method.',go,he,_o,fe,un,Ke,gn,Q,et,bo,Ft,ls=`The reader of REALM.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ko,K,tt,yo,Et,ds='The <a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmReader">RealmReader</a> forward method, overrides the <code>__call__</code> special method.',vo,ue,_n,nt,bn,I,ot,To,At,cs=`<code>RealmForOpenQA</code> for end-to-end open domain question answering.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,wo,ge,st,Mo,Vt,ms="Send <code>self.block_emb</code> to a specific device.",$o,G,rt,Ro,Ht,ps='The <a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmForOpenQA">RealmForOpenQA</a> forward method, overrides the <code>__call__</code> special method.',xo,_e,zo,be,kn,Xt,yn;return y=new D({props:{title:"REALM",local:"realm",headingTag:"h1"}}),T=new D({props:{title:"Overview",local:"overview",headingTag:"h2"}}),je=new D({props:{title:"RealmConfig",local:"transformers.RealmConfig",headingTag:"h2"}}),Je=new x({props:{name:"class transformers.RealmConfig",anchor:"transformers.RealmConfig",parameters:[{name:"vocab_size",val:" = 30522"},{name:"hidden_size",val:" = 768"},{name:"retriever_proj_size",val:" = 128"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"num_candidates",val:" = 8"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu_new'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 512"},{name:"type_vocab_size",val:" = 2"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"span_hidden_size",val:" = 256"},{name:"max_span_width",val:" = 10"},{name:"reader_layer_norm_eps",val:" = 0.001"},{name:"reader_beam_size",val:" = 5"},{name:"reader_seq_len",val:" = 320"},{name:"num_block_records",val:" = 13353718"},{name:"searcher_beam_size",val:" = 5000"},{name:"pad_token_id",val:" = 1"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.RealmConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30522) &#x2014;
Vocabulary size of the REALM model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmEmbedder">RealmEmbedder</a>, <a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmScorer">RealmScorer</a>, <a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmKnowledgeAugEncoder">RealmKnowledgeAugEncoder</a>, or
<a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmReader">RealmReader</a>.`,name:"vocab_size"},{anchor:"transformers.RealmConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimension of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.RealmConfig.retriever_proj_size",description:`<strong>retriever_proj_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Dimension of the retriever(embedder) projection.`,name:"retriever_proj_size"},{anchor:"transformers.RealmConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.RealmConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.RealmConfig.num_candidates",description:`<strong>num_candidates</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of candidates inputted to the RealmScorer or RealmKnowledgeAugEncoder.`,name:"num_candidates"},{anchor:"transformers.RealmConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.RealmConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu_new&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.RealmConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probabilitiy for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.RealmConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.RealmConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.RealmConfig.type_vocab_size",description:`<strong>type_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The vocabulary size of the <code>token_type_ids</code> passed when calling <a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmEmbedder">RealmEmbedder</a>, <a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmScorer">RealmScorer</a>,
<a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmKnowledgeAugEncoder">RealmKnowledgeAugEncoder</a>, or <a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmReader">RealmReader</a>.`,name:"type_vocab_size"},{anchor:"transformers.RealmConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.RealmConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.RealmConfig.span_hidden_size",description:`<strong>span_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension of the reader&#x2019;s spans.`,name:"span_hidden_size"},{anchor:"transformers.RealmConfig.max_span_width",description:`<strong>max_span_width</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Max span width of the reader.`,name:"max_span_width"},{anchor:"transformers.RealmConfig.reader_layer_norm_eps",description:`<strong>reader_layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-3) &#x2014;
The epsilon used by the reader&#x2019;s layer normalization layers.`,name:"reader_layer_norm_eps"},{anchor:"transformers.RealmConfig.reader_beam_size",description:`<strong>reader_beam_size</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
Beam size of the reader.`,name:"reader_beam_size"},{anchor:"transformers.RealmConfig.reader_seq_len",description:`<strong>reader_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 288+32) &#x2014;
Maximum sequence length of the reader.`,name:"reader_seq_len"},{anchor:"transformers.RealmConfig.num_block_records",description:`<strong>num_block_records</strong> (<code>int</code>, <em>optional</em>, defaults to 13353718) &#x2014;
Number of block records.`,name:"num_block_records"},{anchor:"transformers.RealmConfig.searcher_beam_size",description:`<strong>searcher_beam_size</strong> (<code>int</code>, <em>optional</em>, defaults to 5000) &#x2014;
Beam size of the searcher. Note that when eval mode is enabled, <em>searcher_beam_size</em> will be the same as
<em>reader_beam_size</em>.`,name:"searcher_beam_size"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/configuration_realm.py#L44"}}),oe=new we({props:{anchor:"transformers.RealmConfig.example",$$slots:{default:[bs]},$$scope:{ctx:w}}}),Ue=new D({props:{title:"RealmTokenizer",local:"transformers.RealmTokenizer",headingTag:"h2"}}),qe=new x({props:{name:"class transformers.RealmTokenizer",anchor:"transformers.RealmTokenizer",parameters:[{name:"vocab_file",val:""},{name:"do_lower_case",val:" = True"},{name:"do_basic_tokenize",val:" = True"},{name:"never_split",val:" = None"},{name:"unk_token",val:" = '[UNK]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '[PAD]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"tokenize_chinese_chars",val:" = True"},{name:"strip_accents",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.RealmTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.RealmTokenizer.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.RealmTokenizer.do_basic_tokenize",description:`<strong>do_basic_tokenize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to do basic tokenization before WordPiece.`,name:"do_basic_tokenize"},{anchor:"transformers.RealmTokenizer.never_split",description:`<strong>never_split</strong> (<code>Iterable</code>, <em>optional</em>) &#x2014;
Collection of tokens which will never be split during tokenization. Only has an effect when
<code>do_basic_tokenize=True</code>`,name:"never_split"},{anchor:"transformers.RealmTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[UNK]&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.RealmTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.RealmTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.RealmTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.RealmTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.RealmTokenizer.tokenize_chinese_chars",description:`<strong>tokenize_chinese_chars</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to tokenize Chinese characters.</p>
<p>This should likely be deactivated for Japanese (see this
<a href="https://github.com/huggingface/transformers/issues/328" rel="nofollow">issue</a>).`,name:"tokenize_chinese_chars"},{anchor:"transformers.RealmTokenizer.strip_accents",description:`<strong>strip_accents</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to strip all accents. If this option is not specified, then it will be determined by the
value for <code>lowercase</code> (as in the original BERT).`,name:"strip_accents"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/tokenization_realm.py#L95"}}),Ce=new x({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.RealmTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.RealmTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.RealmTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/tokenization_realm.py#L300",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Ie=new x({props:{name:"get_special_tokens_mask",anchor:"transformers.RealmTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.RealmTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.RealmTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.RealmTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/tokenization_realm.py#L325",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Le=new x({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.RealmTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.RealmTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.RealmTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/tokenization_realm.py#L353",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#token-type-ids">token type IDs</a> according to the given sequence(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),re=new we({props:{anchor:"transformers.RealmTokenizer.create_token_type_ids_from_sequences.example",$$slots:{default:[ks]},$$scope:{ctx:w}}}),Ze=new x({props:{name:"save_vocabulary",anchor:"transformers.RealmTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/tokenization_realm.py#L382"}}),We=new x({props:{name:"batch_encode_candidates",anchor:"transformers.RealmTokenizer.batch_encode_candidates",parameters:[{name:"text",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.RealmTokenizer.batch_encode_candidates.text",description:`<strong>text</strong> (<code>List[List[str]]</code>) &#x2014;
The batch of sequences to be encoded. Each sequence must be in this format: (batch_size,
num_candidates, text).`,name:"text"},{anchor:"transformers.RealmTokenizer.batch_encode_candidates.text_pair",description:`<strong>text_pair</strong> (<code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The batch of sequences to be encoded. Each sequence must be in this format: (batch_size,
num_candidates, text).
**kwargs &#x2014;
Keyword arguments of the <strong>call</strong> method.`,name:"text_pair"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/tokenization_realm.py#L227",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Encoded text or text pair.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a></p>
`}}),ae=new we({props:{anchor:"transformers.RealmTokenizer.batch_encode_candidates.example",$$slots:{default:[ys]},$$scope:{ctx:w}}}),Fe=new D({props:{title:"RealmTokenizerFast",local:"transformers.RealmTokenizerFast",headingTag:"h2"}}),Ee=new x({props:{name:"class transformers.RealmTokenizerFast",anchor:"transformers.RealmTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"do_lower_case",val:" = True"},{name:"unk_token",val:" = '[UNK]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '[PAD]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"tokenize_chinese_chars",val:" = True"},{name:"strip_accents",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.RealmTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.RealmTokenizerFast.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.RealmTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[UNK]&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.RealmTokenizerFast.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.RealmTokenizerFast.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.RealmTokenizerFast.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.RealmTokenizerFast.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.RealmTokenizerFast.clean_text",description:`<strong>clean_text</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the text before tokenization by removing any control characters and replacing all
whitespaces by the classic one.`,name:"clean_text"},{anchor:"transformers.RealmTokenizerFast.tokenize_chinese_chars",description:`<strong>tokenize_chinese_chars</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to tokenize Chinese characters. This should likely be deactivated for Japanese (see <a href="https://github.com/huggingface/transformers/issues/328" rel="nofollow">this
issue</a>).`,name:"tokenize_chinese_chars"},{anchor:"transformers.RealmTokenizerFast.strip_accents",description:`<strong>strip_accents</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to strip all accents. If this option is not specified, then it will be determined by the
value for <code>lowercase</code> (as in the original BERT).`,name:"strip_accents"},{anchor:"transformers.RealmTokenizerFast.wordpieces_prefix",description:`<strong>wordpieces_prefix</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;##&quot;</code>) &#x2014;
The prefix for subwords.`,name:"wordpieces_prefix"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/tokenization_realm_fast.py#L102"}}),Ae=new x({props:{name:"batch_encode_candidates",anchor:"transformers.RealmTokenizerFast.batch_encode_candidates",parameters:[{name:"text",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.RealmTokenizerFast.batch_encode_candidates.text",description:`<strong>text</strong> (<code>List[List[str]]</code>) &#x2014;
The batch of sequences to be encoded. Each sequence must be in this format: (batch_size,
num_candidates, text).`,name:"text"},{anchor:"transformers.RealmTokenizerFast.batch_encode_candidates.text_pair",description:`<strong>text_pair</strong> (<code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The batch of sequences to be encoded. Each sequence must be in this format: (batch_size,
num_candidates, text).
**kwargs &#x2014;
Keyword arguments of the <strong>call</strong> method.`,name:"text_pair"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/tokenization_realm_fast.py#L193",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Encoded text or text pair.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a></p>
`}}),ie=new we({props:{anchor:"transformers.RealmTokenizerFast.batch_encode_candidates.example",$$slots:{default:[vs]},$$scope:{ctx:w}}}),Ve=new D({props:{title:"RealmRetriever",local:"transformers.RealmRetriever",headingTag:"h2"}}),He=new x({props:{name:"class transformers.RealmRetriever",anchor:"transformers.RealmRetriever",parameters:[{name:"block_records",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.RealmRetriever.block_records",description:`<strong>block_records</strong> (<code>np.ndarray</code>) &#x2014;
A numpy array which cantains evidence texts.`,name:"block_records"},{anchor:"transformers.RealmRetriever.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmTokenizer">RealmTokenizer</a>) &#x2014;
The tokenizer to encode retrieved texts.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/retrieval_realm.py#L72"}}),Ge=new x({props:{name:"block_has_answer",anchor:"transformers.RealmRetriever.block_has_answer",parameters:[{name:"concat_inputs",val:""},{name:"answer_ids",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/retrieval_realm.py#L129"}}),Be=new D({props:{title:"RealmEmbedder",local:"transformers.RealmEmbedder",headingTag:"h2"}}),Ne=new x({props:{name:"class transformers.RealmEmbedder",anchor:"transformers.RealmEmbedder",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.RealmEmbedder.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmConfig">RealmConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/modeling_realm.py#L1151"}}),Se=new x({props:{name:"forward",anchor:"transformers.RealmEmbedder.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.RealmEmbedder.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RealmEmbedder.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.RealmEmbedder.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.RealmEmbedder.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.RealmEmbedder.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.RealmEmbedder.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.RealmEmbedder.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.RealmEmbedder.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.RealmEmbedder.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/modeling_realm.py#L1167",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.realm.modeling_realm.RealmEmbedderOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmConfig"
>RealmConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>projected_score</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.retriever_proj_size)</code>) — Projected score.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.realm.modeling_realm.RealmEmbedderOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),de=new Pt({props:{$$slots:{default:[Ts]},$$scope:{ctx:w}}}),ce=new we({props:{anchor:"transformers.RealmEmbedder.forward.example",$$slots:{default:[ws]},$$scope:{ctx:w}}}),Xe=new D({props:{title:"RealmScorer",local:"transformers.RealmScorer",headingTag:"h2"}}),Qe=new x({props:{name:"class transformers.RealmScorer",anchor:"transformers.RealmScorer",parameters:[{name:"config",val:""},{name:"query_embedder",val:" = None"}],parametersDescription:[{anchor:"transformers.RealmScorer.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmConfig">RealmConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.RealmScorer.query_embedder",description:`<strong>query_embedder</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmEmbedder">RealmEmbedder</a>) &#x2014;
Embedder for input sequences. If not specified, it will use the same embedder as candidate sequences.`,name:"query_embedder"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/modeling_realm.py#L1233"}}),Pe=new x({props:{name:"forward",anchor:"transformers.RealmScorer.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"candidate_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"candidate_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"candidate_token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"candidate_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.RealmScorer.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RealmScorer.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.RealmScorer.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.RealmScorer.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.RealmScorer.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.RealmScorer.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.RealmScorer.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.RealmScorer.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.RealmScorer.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.RealmScorer.forward.candidate_input_ids",description:`<strong>candidate_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_candidates, sequence_length)</code>) &#x2014;
Indices of candidate input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"candidate_input_ids"},{anchor:"transformers.RealmScorer.forward.candidate_attention_mask",description:`<strong>candidate_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_candidates, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"candidate_attention_mask"},{anchor:"transformers.RealmScorer.forward.candidate_token_type_ids",description:`<strong>candidate_token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_candidates, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"candidate_token_type_ids"},{anchor:"transformers.RealmScorer.forward.candidate_inputs_embeds",description:`<strong>candidate_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_candidates, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>candidate_input_ids</code> you can choose to directly pass an embedded
representation. This is useful if you want more control over how to convert <em>candidate_input_ids</em> indices
into associated vectors than the model&#x2019;s internal embedding lookup matrix.`,name:"candidate_inputs_embeds"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/modeling_realm.py#L1249",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.realm.modeling_realm.RealmScorerOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmConfig"
>RealmConfig</a>) and inputs.</p>
<ul>
<li><strong>relevance_score</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_candidates)</code>) — The relevance score of document candidates (before softmax).</li>
<li><strong>query_score</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.retriever_proj_size)</code>) — Query score derived from the query embedder.</li>
<li><strong>candidate_score</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_candidates, config.retriever_proj_size)</code>) — Candidate score derived from the embedder.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.realm.modeling_realm.RealmScorerOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),me=new Pt({props:{$$slots:{default:[Ms]},$$scope:{ctx:w}}}),pe=new we({props:{anchor:"transformers.RealmScorer.forward.example",$$slots:{default:[$s]},$$scope:{ctx:w}}}),Oe=new D({props:{title:"RealmKnowledgeAugEncoder",local:"transformers.RealmKnowledgeAugEncoder",headingTag:"h2"}}),De=new x({props:{name:"class transformers.RealmKnowledgeAugEncoder",anchor:"transformers.RealmKnowledgeAugEncoder",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.RealmKnowledgeAugEncoder.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmConfig">RealmConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/modeling_realm.py#L1381"}}),Ye=new x({props:{name:"forward",anchor:"transformers.RealmKnowledgeAugEncoder.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"relevance_score",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"mlm_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.RealmKnowledgeAugEncoder.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_candidates, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RealmKnowledgeAugEncoder.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_candidates, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.RealmKnowledgeAugEncoder.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_candidates, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.RealmKnowledgeAugEncoder.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_candidates, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.RealmKnowledgeAugEncoder.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.RealmKnowledgeAugEncoder.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_candidates, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.RealmKnowledgeAugEncoder.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.RealmKnowledgeAugEncoder.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.RealmKnowledgeAugEncoder.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.RealmKnowledgeAugEncoder.forward.relevance_score",description:`<strong>relevance_score</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_candidates)</code>, <em>optional</em>) &#x2014;
Relevance score derived from RealmScorer, must be specified if you want to compute the masked language
modeling loss.`,name:"relevance_score"},{anchor:"transformers.RealmKnowledgeAugEncoder.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.RealmKnowledgeAugEncoder.forward.mlm_mask",description:`<strong>mlm_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid calculating joint loss on certain positions. If not specified, the loss will not be masked.
Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>`,name:"mlm_mask"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/modeling_realm.py#L1402",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmConfig"
>RealmConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),he=new Pt({props:{$$slots:{default:[Rs]},$$scope:{ctx:w}}}),fe=new we({props:{anchor:"transformers.RealmKnowledgeAugEncoder.forward.example",$$slots:{default:[xs]},$$scope:{ctx:w}}}),Ke=new D({props:{title:"RealmReader",local:"transformers.RealmReader",headingTag:"h2"}}),et=new x({props:{name:"class transformers.RealmReader",anchor:"transformers.RealmReader",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.RealmReader.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmConfig">RealmConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/modeling_realm.py#L1531"}}),tt=new x({props:{name:"forward",anchor:"transformers.RealmReader.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"relevance_score",val:": typing.Optional[torch.FloatTensor] = None"},{name:"block_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"start_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"end_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"has_answers",val:": typing.Optional[torch.BoolTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.RealmReader.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(reader_beam_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RealmReader.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(reader_beam_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.RealmReader.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(reader_beam_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.RealmReader.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(reader_beam_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.RealmReader.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.RealmReader.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(reader_beam_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.RealmReader.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.RealmReader.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.RealmReader.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.RealmReader.forward.relevance_score",description:`<strong>relevance_score</strong> (<code>torch.FloatTensor</code> of shape <code>(searcher_beam_size,)</code>, <em>optional</em>) &#x2014;
Relevance score, which must be specified if you want to compute the logits and marginal log loss.`,name:"relevance_score"},{anchor:"transformers.RealmReader.forward.block_mask",description:`<strong>block_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(searcher_beam_size, sequence_length)</code>, <em>optional</em>) &#x2014;
The mask of the evidence block, which must be specified if you want to compute the logits and marginal log
loss.`,name:"block_mask"},{anchor:"transformers.RealmReader.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(searcher_beam_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.RealmReader.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(searcher_beam_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"},{anchor:"transformers.RealmReader.forward.has_answers",description:`<strong>has_answers</strong> (<code>torch.BoolTensor</code> of shape <code>(searcher_beam_size,)</code>, <em>optional</em>) &#x2014;
Whether or not the evidence block has answer(s).`,name:"has_answers"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/modeling_realm.py#L1542",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.realm.modeling_realm.RealmReaderOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmConfig"
>RealmConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>start_positions</code>, <code>end_positions</code>, <code>has_answers</code> are provided) — Total loss.</p>
</li>
<li>
<p><strong>retriever_loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>start_positions</code>, <code>end_positions</code>, <code>has_answers</code> are provided) — Retriever loss.</p>
</li>
<li>
<p><strong>reader_loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>start_positions</code>, <code>end_positions</code>, <code>has_answers</code> are provided) — Reader loss.</p>
</li>
<li>
<p><strong>retriever_correct</strong> (<code>torch.BoolTensor</code> of shape <code>(config.searcher_beam_size,)</code>, <em>optional</em>) — Whether or not an evidence block contains answer.</p>
</li>
<li>
<p><strong>reader_correct</strong> (<code>torch.BoolTensor</code> of shape <code>(config.reader_beam_size, num_candidates)</code>, <em>optional</em>) — Whether or not a span candidate contains answer.</p>
</li>
<li>
<p><strong>block_idx</strong> (<code>torch.LongTensor</code> of shape <code>()</code>) — The index of the retrieved evidence block in which the predicted answer is most likely.</p>
</li>
<li>
<p><strong>candidate</strong> (<code>torch.LongTensor</code> of shape <code>()</code>) — The index of the retrieved span candidates in which the predicted answer is most likely.</p>
</li>
<li>
<p><strong>start_pos</strong> (<code>torch.IntTensor</code> of shape <code>()</code>) — Predicted answer starting position in <em>RealmReader</em>’s inputs.</p>
</li>
<li>
<p><strong>end_pos</strong> (<code>torch.IntTensor</code> of shape <code>()</code>) — Predicted answer ending position in <em>RealmReader</em>’s inputs.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.realm.modeling_realm.RealmReaderOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ue=new Pt({props:{$$slots:{default:[zs]},$$scope:{ctx:w}}}),nt=new D({props:{title:"RealmForOpenQA",local:"transformers.RealmForOpenQA",headingTag:"h2"}}),ot=new x({props:{name:"class transformers.RealmForOpenQA",anchor:"transformers.RealmForOpenQA",parameters:[{name:"config",val:""},{name:"retriever",val:" = None"}],parametersDescription:[{anchor:"transformers.RealmForOpenQA.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmConfig">RealmConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/modeling_realm.py#L1735"}}),st=new x({props:{name:"block_embedding_to",anchor:"transformers.RealmForOpenQA.block_embedding_to",parameters:[{name:"device",val:""}],parametersDescription:[{anchor:"transformers.RealmForOpenQA.block_embedding_to.device",description:`<strong>device</strong> (<code>str</code> or <code>torch.device</code>) &#x2014;
The device to which <code>self.block_emb</code> will be sent.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/modeling_realm.py#L1758"}}),rt=new x({props:{name:"forward",anchor:"transformers.RealmForOpenQA.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor]"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"answer_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.RealmForOpenQA.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(1, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RealmForOpenQA.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(1, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.RealmForOpenQA.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(1, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token (should not be used in this model by design).</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.RealmForOpenQA.forward.answer_ids",description:`<strong>answer_ids</strong> (<code>list</code> of shape <code>(num_answers, answer_length)</code>, <em>optional</em>) &#x2014;
Answer ids for computing the marginal log-likelihood loss. Indices should be in <code>[-1, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-1</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"answer_ids"},{anchor:"transformers.RealmForOpenQA.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/realm/modeling_realm.py#L1768",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.realm.modeling_realm.RealmForOpenQAOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/realm#transformers.RealmConfig"
>RealmConfig</a>) and inputs.</p>
<ul>
<li><strong>reader_output</strong> (<code>dict</code>) — Reader output.</li>
<li><strong>predicted_answer_ids</strong> (<code>torch.LongTensor</code> of shape <code>(answer_sequence_length)</code>) — Predicted answer ids.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.realm.modeling_realm.RealmForOpenQAOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),_e=new Pt({props:{$$slots:{default:[js]},$$scope:{ctx:w}}}),be=new we({props:{anchor:"transformers.RealmForOpenQA.forward.example",$$slots:{default:[Js]},$$scope:{ctx:w}}}),{c(){n=d("meta"),v=s(),m=d("p"),l=s(),h(y.$$.fragment),t=s(),h(T.$$.fragment),Ot=s(),$e=d("p"),$e.innerHTML=jo,Dt=s(),Re=d("p"),Re.textContent=Jo,Yt=s(),xe=d("p"),xe.innerHTML=Uo,Kt=s(),ze=d("p"),ze.innerHTML=qo,en=s(),h(je.$$.fragment),tn=s(),j=d("div"),h(Je.$$.fragment),Tn=s(),lt=d("p"),lt.textContent=Co,wn=s(),dt=d("ol"),dt.innerHTML=Io,Mn=s(),ct=d("p"),ct.innerHTML=Lo,$n=s(),mt=d("p"),mt.innerHTML=Zo,Rn=s(),h(oe.$$.fragment),nn=s(),h(Ue.$$.fragment),on=s(),R=d("div"),h(qe.$$.fragment),xn=s(),pt=d("p"),pt.textContent=Wo,zn=s(),ht=d("p"),ht.innerHTML=Fo,jn=s(),ft=d("p"),ft.innerHTML=Eo,Jn=s(),Y=d("div"),h(Ce.$$.fragment),Un=s(),ut=d("p"),ut.textContent=Ao,qn=s(),gt=d("ul"),gt.innerHTML=Vo,Cn=s(),se=d("div"),h(Ie.$$.fragment),In=s(),_t=d("p"),_t.innerHTML=Ho,Ln=s(),E=d("div"),h(Le.$$.fragment),Zn=s(),bt=d("p"),bt.textContent=Go,Wn=s(),h(re.$$.fragment),Fn=s(),kt=d("p"),kt.innerHTML=Bo,En=s(),yt=d("div"),h(Ze.$$.fragment),An=s(),q=d("div"),h(We.$$.fragment),Vn=s(),vt=d("p"),vt.innerHTML=No,Hn=s(),Tt=d("ol"),Tt.innerHTML=So,Gn=s(),wt=d("ul"),wt.innerHTML=Xo,Bn=s(),h(ae.$$.fragment),sn=s(),h(Fe.$$.fragment),rn=s(),J=d("div"),h(Ee.$$.fragment),Nn=s(),Mt=d("p"),Mt.innerHTML=Qo,Sn=s(),$t=d("p"),$t.innerHTML=Po,Xn=s(),Rt=d("p"),Rt.innerHTML=Oo,Qn=s(),C=d("div"),h(Ae.$$.fragment),Pn=s(),xt=d("p"),xt.innerHTML=Do,On=s(),zt=d("ol"),zt.innerHTML=Yo,Dn=s(),jt=d("ul"),jt.innerHTML=Ko,Yn=s(),h(ie.$$.fragment),an=s(),h(Ve.$$.fragment),ln=s(),B=d("div"),h(He.$$.fragment),Kn=s(),Jt=d("p"),Jt.textContent=es,eo=s(),le=d("div"),h(Ge.$$.fragment),to=s(),Ut=d("p"),Ut.textContent=ts,dn=s(),h(Be.$$.fragment),cn=s(),N=d("div"),h(Ne.$$.fragment),no=s(),qt=d("p"),qt.innerHTML=ns,oo=s(),A=d("div"),h(Se.$$.fragment),so=s(),Ct=d("p"),Ct.innerHTML=os,ro=s(),h(de.$$.fragment),ao=s(),h(ce.$$.fragment),mn=s(),h(Xe.$$.fragment),pn=s(),S=d("div"),h(Qe.$$.fragment),io=s(),It=d("p"),It.innerHTML=ss,lo=s(),V=d("div"),h(Pe.$$.fragment),co=s(),Lt=d("p"),Lt.innerHTML=rs,mo=s(),h(me.$$.fragment),po=s(),h(pe.$$.fragment),hn=s(),h(Oe.$$.fragment),fn=s(),X=d("div"),h(De.$$.fragment),ho=s(),Zt=d("p"),Zt.innerHTML=as,fo=s(),H=d("div"),h(Ye.$$.fragment),uo=s(),Wt=d("p"),Wt.innerHTML=is,go=s(),h(he.$$.fragment),_o=s(),h(fe.$$.fragment),un=s(),h(Ke.$$.fragment),gn=s(),Q=d("div"),h(et.$$.fragment),bo=s(),Ft=d("p"),Ft.innerHTML=ls,ko=s(),K=d("div"),h(tt.$$.fragment),yo=s(),Et=d("p"),Et.innerHTML=ds,vo=s(),h(ue.$$.fragment),_n=s(),h(nt.$$.fragment),bn=s(),I=d("div"),h(ot.$$.fragment),To=s(),At=d("p"),At.innerHTML=cs,wo=s(),ge=d("div"),h(st.$$.fragment),Mo=s(),Vt=d("p"),Vt.innerHTML=ms,$o=s(),G=d("div"),h(rt.$$.fragment),Ro=s(),Ht=d("p"),Ht.innerHTML=ps,xo=s(),h(_e.$$.fragment),zo=s(),h(be.$$.fragment),kn=s(),Xt=d("p"),this.h()},l(e){const i=_s("svelte-u9bgzb",document.head);n=c(i,"META",{name:!0,content:!0}),i.forEach(a),v=r(e),m=c(e,"P",{}),M(m).forEach(a),l=r(e),f(y.$$.fragment,e),t=r(e),f(T.$$.fragment,e),Ot=r(e),$e=c(e,"P",{"data-svelte-h":!0}),k($e)!=="svelte-5xttfr"&&($e.innerHTML=jo),Dt=r(e),Re=c(e,"P",{"data-svelte-h":!0}),k(Re)!=="svelte-vfdo9a"&&(Re.textContent=Jo),Yt=r(e),xe=c(e,"P",{"data-svelte-h":!0}),k(xe)!=="svelte-gptcva"&&(xe.innerHTML=Uo),Kt=r(e),ze=c(e,"P",{"data-svelte-h":!0}),k(ze)!=="svelte-112zouf"&&(ze.innerHTML=qo),en=r(e),f(je.$$.fragment,e),tn=r(e),j=c(e,"DIV",{class:!0});var U=M(j);f(Je.$$.fragment,U),Tn=r(U),lt=c(U,"P",{"data-svelte-h":!0}),k(lt)!=="svelte-1txlcov"&&(lt.textContent=Co),wn=r(U),dt=c(U,"OL",{"data-svelte-h":!0}),k(dt)!=="svelte-17rmwrw"&&(dt.innerHTML=Io),Mn=r(U),ct=c(U,"P",{"data-svelte-h":!0}),k(ct)!=="svelte-15a8bjo"&&(ct.innerHTML=Lo),$n=r(U),mt=c(U,"P",{"data-svelte-h":!0}),k(mt)!=="svelte-10kqkkl"&&(mt.innerHTML=Zo),Rn=r(U),f(oe.$$.fragment,U),U.forEach(a),nn=r(e),f(Ue.$$.fragment,e),on=r(e),R=c(e,"DIV",{class:!0});var z=M(R);f(qe.$$.fragment,z),xn=r(z),pt=c(z,"P",{"data-svelte-h":!0}),k(pt)!=="svelte-x1le7e"&&(pt.textContent=Wo),zn=r(z),ht=c(z,"P",{"data-svelte-h":!0}),k(ht)!=="svelte-1tephpe"&&(ht.innerHTML=Fo),jn=r(z),ft=c(z,"P",{"data-svelte-h":!0}),k(ft)!=="svelte-1b0fouy"&&(ft.innerHTML=Eo),Jn=r(z),Y=c(z,"DIV",{class:!0});var ee=M(Y);f(Ce.$$.fragment,ee),Un=r(ee),ut=c(ee,"P",{"data-svelte-h":!0}),k(ut)!=="svelte-q7bpic"&&(ut.textContent=Ao),qn=r(ee),gt=c(ee,"UL",{"data-svelte-h":!0}),k(gt)!=="svelte-xi6653"&&(gt.innerHTML=Vo),ee.forEach(a),Cn=r(z),se=c(z,"DIV",{class:!0});var at=M(se);f(Ie.$$.fragment,at),In=r(at),_t=c(at,"P",{"data-svelte-h":!0}),k(_t)!=="svelte-1f4f5kp"&&(_t.innerHTML=Ho),at.forEach(a),Ln=r(z),E=c(z,"DIV",{class:!0});var P=M(E);f(Le.$$.fragment,P),Zn=r(P),bt=c(P,"P",{"data-svelte-h":!0}),k(bt)!=="svelte-11hyn6f"&&(bt.textContent=Go),Wn=r(P),f(re.$$.fragment,P),Fn=r(P),kt=c(P,"P",{"data-svelte-h":!0}),k(kt)!=="svelte-owoxgn"&&(kt.innerHTML=Bo),P.forEach(a),En=r(z),yt=c(z,"DIV",{class:!0});var Qt=M(yt);f(Ze.$$.fragment,Qt),Qt.forEach(a),An=r(z),q=c(z,"DIV",{class:!0});var L=M(q);f(We.$$.fragment,L),Vn=r(L),vt=c(L,"P",{"data-svelte-h":!0}),k(vt)!=="svelte-ykazgt"&&(vt.innerHTML=No),Hn=r(L),Tt=c(L,"OL",{"data-svelte-h":!0}),k(Tt)!=="svelte-1kcpahy"&&(Tt.innerHTML=So),Gn=r(L),wt=c(L,"UL",{"data-svelte-h":!0}),k(wt)!=="svelte-xi6653"&&(wt.innerHTML=Xo),Bn=r(L),f(ae.$$.fragment,L),L.forEach(a),z.forEach(a),sn=r(e),f(Fe.$$.fragment,e),rn=r(e),J=c(e,"DIV",{class:!0});var Z=M(J);f(Ee.$$.fragment,Z),Nn=r(Z),Mt=c(Z,"P",{"data-svelte-h":!0}),k(Mt)!=="svelte-q0n2sz"&&(Mt.innerHTML=Qo),Sn=r(Z),$t=c(Z,"P",{"data-svelte-h":!0}),k($t)!=="svelte-19u8ha2"&&($t.innerHTML=Po),Xn=r(Z),Rt=c(Z,"P",{"data-svelte-h":!0}),k(Rt)!=="svelte-ttxvs6"&&(Rt.innerHTML=Oo),Qn=r(Z),C=c(Z,"DIV",{class:!0});var W=M(C);f(Ae.$$.fragment,W),Pn=r(W),xt=c(W,"P",{"data-svelte-h":!0}),k(xt)!=="svelte-ykazgt"&&(xt.innerHTML=Do),On=r(W),zt=c(W,"OL",{"data-svelte-h":!0}),k(zt)!=="svelte-1kcpahy"&&(zt.innerHTML=Yo),Dn=r(W),jt=c(W,"UL",{"data-svelte-h":!0}),k(jt)!=="svelte-xi6653"&&(jt.innerHTML=Ko),Yn=r(W),f(ie.$$.fragment,W),W.forEach(a),Z.forEach(a),an=r(e),f(Ve.$$.fragment,e),ln=r(e),B=c(e,"DIV",{class:!0});var te=M(B);f(He.$$.fragment,te),Kn=r(te),Jt=c(te,"P",{"data-svelte-h":!0}),k(Jt)!=="svelte-ongswt"&&(Jt.textContent=es),eo=r(te),le=c(te,"DIV",{class:!0});var it=M(le);f(Ge.$$.fragment,it),to=r(it),Ut=c(it,"P",{"data-svelte-h":!0}),k(Ut)!=="svelte-1ig21z"&&(Ut.textContent=ts),it.forEach(a),te.forEach(a),dn=r(e),f(Be.$$.fragment,e),cn=r(e),N=c(e,"DIV",{class:!0});var ne=M(N);f(Ne.$$.fragment,ne),no=r(ne),qt=c(ne,"P",{"data-svelte-h":!0}),k(qt)!=="svelte-2kzyme"&&(qt.innerHTML=ns),oo=r(ne),A=c(ne,"DIV",{class:!0});var O=M(A);f(Se.$$.fragment,O),so=r(O),Ct=c(O,"P",{"data-svelte-h":!0}),k(Ct)!=="svelte-rpsi0"&&(Ct.innerHTML=os),ro=r(O),f(de.$$.fragment,O),ao=r(O),f(ce.$$.fragment,O),O.forEach(a),ne.forEach(a),mn=r(e),f(Xe.$$.fragment,e),pn=r(e),S=c(e,"DIV",{class:!0});var Gt=M(S);f(Qe.$$.fragment,Gt),io=r(Gt),It=c(Gt,"P",{"data-svelte-h":!0}),k(It)!=="svelte-1rwza5g"&&(It.innerHTML=ss),lo=r(Gt),V=c(Gt,"DIV",{class:!0});var ke=M(V);f(Pe.$$.fragment,ke),co=r(ke),Lt=c(ke,"P",{"data-svelte-h":!0}),k(Lt)!=="svelte-21aq1g"&&(Lt.innerHTML=rs),mo=r(ke),f(me.$$.fragment,ke),po=r(ke),f(pe.$$.fragment,ke),ke.forEach(a),Gt.forEach(a),hn=r(e),f(Oe.$$.fragment,e),fn=r(e),X=c(e,"DIV",{class:!0});var Bt=M(X);f(De.$$.fragment,Bt),ho=r(Bt),Zt=c(Bt,"P",{"data-svelte-h":!0}),k(Zt)!=="svelte-1rac53c"&&(Zt.innerHTML=as),fo=r(Bt),H=c(Bt,"DIV",{class:!0});var ye=M(H);f(Ye.$$.fragment,ye),uo=r(ye),Wt=c(ye,"P",{"data-svelte-h":!0}),k(Wt)!=="svelte-3o90s"&&(Wt.innerHTML=is),go=r(ye),f(he.$$.fragment,ye),_o=r(ye),f(fe.$$.fragment,ye),ye.forEach(a),Bt.forEach(a),un=r(e),f(Ke.$$.fragment,e),gn=r(e),Q=c(e,"DIV",{class:!0});var Nt=M(Q);f(et.$$.fragment,Nt),bo=r(Nt),Ft=c(Nt,"P",{"data-svelte-h":!0}),k(Ft)!=="svelte-1ybpoit"&&(Ft.innerHTML=ls),ko=r(Nt),K=c(Nt,"DIV",{class:!0});var St=M(K);f(tt.$$.fragment,St),yo=r(St),Et=c(St,"P",{"data-svelte-h":!0}),k(Et)!=="svelte-5g4ok0"&&(Et.innerHTML=ds),vo=r(St),f(ue.$$.fragment,St),St.forEach(a),Nt.forEach(a),_n=r(e),f(nt.$$.fragment,e),bn=r(e),I=c(e,"DIV",{class:!0});var ve=M(I);f(ot.$$.fragment,ve),To=r(ve),At=c(ve,"P",{"data-svelte-h":!0}),k(At)!=="svelte-16o09y2"&&(At.innerHTML=cs),wo=r(ve),ge=c(ve,"DIV",{class:!0});var vn=M(ge);f(st.$$.fragment,vn),Mo=r(vn),Vt=c(vn,"P",{"data-svelte-h":!0}),k(Vt)!=="svelte-4rmqa9"&&(Vt.innerHTML=ms),vn.forEach(a),$o=r(ve),G=c(ve,"DIV",{class:!0});var Te=M(G);f(rt.$$.fragment,Te),Ro=r(Te),Ht=c(Te,"P",{"data-svelte-h":!0}),k(Ht)!=="svelte-9au21w"&&(Ht.innerHTML=ps),xo=r(Te),f(_e.$$.fragment,Te),zo=r(Te),f(be.$$.fragment,Te),Te.forEach(a),ve.forEach(a),kn=r(e),Xt=c(e,"P",{}),M(Xt).forEach(a),this.h()},h(){$(n,"name","hf:doc:metadata"),$(n,"content",qs),$(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){o(document.head,n),p(e,v,i),p(e,m,i),p(e,l,i),u(y,e,i),p(e,t,i),u(T,e,i),p(e,Ot,i),p(e,$e,i),p(e,Dt,i),p(e,Re,i),p(e,Yt,i),p(e,xe,i),p(e,Kt,i),p(e,ze,i),p(e,en,i),u(je,e,i),p(e,tn,i),p(e,j,i),u(Je,j,null),o(j,Tn),o(j,lt),o(j,wn),o(j,dt),o(j,Mn),o(j,ct),o(j,$n),o(j,mt),o(j,Rn),u(oe,j,null),p(e,nn,i),u(Ue,e,i),p(e,on,i),p(e,R,i),u(qe,R,null),o(R,xn),o(R,pt),o(R,zn),o(R,ht),o(R,jn),o(R,ft),o(R,Jn),o(R,Y),u(Ce,Y,null),o(Y,Un),o(Y,ut),o(Y,qn),o(Y,gt),o(R,Cn),o(R,se),u(Ie,se,null),o(se,In),o(se,_t),o(R,Ln),o(R,E),u(Le,E,null),o(E,Zn),o(E,bt),o(E,Wn),u(re,E,null),o(E,Fn),o(E,kt),o(R,En),o(R,yt),u(Ze,yt,null),o(R,An),o(R,q),u(We,q,null),o(q,Vn),o(q,vt),o(q,Hn),o(q,Tt),o(q,Gn),o(q,wt),o(q,Bn),u(ae,q,null),p(e,sn,i),u(Fe,e,i),p(e,rn,i),p(e,J,i),u(Ee,J,null),o(J,Nn),o(J,Mt),o(J,Sn),o(J,$t),o(J,Xn),o(J,Rt),o(J,Qn),o(J,C),u(Ae,C,null),o(C,Pn),o(C,xt),o(C,On),o(C,zt),o(C,Dn),o(C,jt),o(C,Yn),u(ie,C,null),p(e,an,i),u(Ve,e,i),p(e,ln,i),p(e,B,i),u(He,B,null),o(B,Kn),o(B,Jt),o(B,eo),o(B,le),u(Ge,le,null),o(le,to),o(le,Ut),p(e,dn,i),u(Be,e,i),p(e,cn,i),p(e,N,i),u(Ne,N,null),o(N,no),o(N,qt),o(N,oo),o(N,A),u(Se,A,null),o(A,so),o(A,Ct),o(A,ro),u(de,A,null),o(A,ao),u(ce,A,null),p(e,mn,i),u(Xe,e,i),p(e,pn,i),p(e,S,i),u(Qe,S,null),o(S,io),o(S,It),o(S,lo),o(S,V),u(Pe,V,null),o(V,co),o(V,Lt),o(V,mo),u(me,V,null),o(V,po),u(pe,V,null),p(e,hn,i),u(Oe,e,i),p(e,fn,i),p(e,X,i),u(De,X,null),o(X,ho),o(X,Zt),o(X,fo),o(X,H),u(Ye,H,null),o(H,uo),o(H,Wt),o(H,go),u(he,H,null),o(H,_o),u(fe,H,null),p(e,un,i),u(Ke,e,i),p(e,gn,i),p(e,Q,i),u(et,Q,null),o(Q,bo),o(Q,Ft),o(Q,ko),o(Q,K),u(tt,K,null),o(K,yo),o(K,Et),o(K,vo),u(ue,K,null),p(e,_n,i),u(nt,e,i),p(e,bn,i),p(e,I,i),u(ot,I,null),o(I,To),o(I,At),o(I,wo),o(I,ge),u(st,ge,null),o(ge,Mo),o(ge,Vt),o(I,$o),o(I,G),u(rt,G,null),o(G,Ro),o(G,Ht),o(G,xo),u(_e,G,null),o(G,zo),u(be,G,null),p(e,kn,i),p(e,Xt,i),yn=!0},p(e,[i]){const U={};i&2&&(U.$$scope={dirty:i,ctx:e}),oe.$set(U);const z={};i&2&&(z.$$scope={dirty:i,ctx:e}),re.$set(z);const ee={};i&2&&(ee.$$scope={dirty:i,ctx:e}),ae.$set(ee);const at={};i&2&&(at.$$scope={dirty:i,ctx:e}),ie.$set(at);const P={};i&2&&(P.$$scope={dirty:i,ctx:e}),de.$set(P);const Qt={};i&2&&(Qt.$$scope={dirty:i,ctx:e}),ce.$set(Qt);const L={};i&2&&(L.$$scope={dirty:i,ctx:e}),me.$set(L);const Z={};i&2&&(Z.$$scope={dirty:i,ctx:e}),pe.$set(Z);const W={};i&2&&(W.$$scope={dirty:i,ctx:e}),he.$set(W);const te={};i&2&&(te.$$scope={dirty:i,ctx:e}),fe.$set(te);const it={};i&2&&(it.$$scope={dirty:i,ctx:e}),ue.$set(it);const ne={};i&2&&(ne.$$scope={dirty:i,ctx:e}),_e.$set(ne);const O={};i&2&&(O.$$scope={dirty:i,ctx:e}),be.$set(O)},i(e){yn||(g(y.$$.fragment,e),g(T.$$.fragment,e),g(je.$$.fragment,e),g(Je.$$.fragment,e),g(oe.$$.fragment,e),g(Ue.$$.fragment,e),g(qe.$$.fragment,e),g(Ce.$$.fragment,e),g(Ie.$$.fragment,e),g(Le.$$.fragment,e),g(re.$$.fragment,e),g(Ze.$$.fragment,e),g(We.$$.fragment,e),g(ae.$$.fragment,e),g(Fe.$$.fragment,e),g(Ee.$$.fragment,e),g(Ae.$$.fragment,e),g(ie.$$.fragment,e),g(Ve.$$.fragment,e),g(He.$$.fragment,e),g(Ge.$$.fragment,e),g(Be.$$.fragment,e),g(Ne.$$.fragment,e),g(Se.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),g(Xe.$$.fragment,e),g(Qe.$$.fragment,e),g(Pe.$$.fragment,e),g(me.$$.fragment,e),g(pe.$$.fragment,e),g(Oe.$$.fragment,e),g(De.$$.fragment,e),g(Ye.$$.fragment,e),g(he.$$.fragment,e),g(fe.$$.fragment,e),g(Ke.$$.fragment,e),g(et.$$.fragment,e),g(tt.$$.fragment,e),g(ue.$$.fragment,e),g(nt.$$.fragment,e),g(ot.$$.fragment,e),g(st.$$.fragment,e),g(rt.$$.fragment,e),g(_e.$$.fragment,e),g(be.$$.fragment,e),yn=!0)},o(e){_(y.$$.fragment,e),_(T.$$.fragment,e),_(je.$$.fragment,e),_(Je.$$.fragment,e),_(oe.$$.fragment,e),_(Ue.$$.fragment,e),_(qe.$$.fragment,e),_(Ce.$$.fragment,e),_(Ie.$$.fragment,e),_(Le.$$.fragment,e),_(re.$$.fragment,e),_(Ze.$$.fragment,e),_(We.$$.fragment,e),_(ae.$$.fragment,e),_(Fe.$$.fragment,e),_(Ee.$$.fragment,e),_(Ae.$$.fragment,e),_(ie.$$.fragment,e),_(Ve.$$.fragment,e),_(He.$$.fragment,e),_(Ge.$$.fragment,e),_(Be.$$.fragment,e),_(Ne.$$.fragment,e),_(Se.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(Xe.$$.fragment,e),_(Qe.$$.fragment,e),_(Pe.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(Oe.$$.fragment,e),_(De.$$.fragment,e),_(Ye.$$.fragment,e),_(he.$$.fragment,e),_(fe.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(tt.$$.fragment,e),_(ue.$$.fragment,e),_(nt.$$.fragment,e),_(ot.$$.fragment,e),_(st.$$.fragment,e),_(rt.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),yn=!1},d(e){e&&(a(v),a(m),a(l),a(t),a(Ot),a($e),a(Dt),a(Re),a(Yt),a(xe),a(Kt),a(ze),a(en),a(tn),a(j),a(nn),a(on),a(R),a(sn),a(rn),a(J),a(an),a(ln),a(B),a(dn),a(cn),a(N),a(mn),a(pn),a(S),a(hn),a(fn),a(X),a(un),a(gn),a(Q),a(_n),a(bn),a(I),a(kn),a(Xt)),a(n),b(y,e),b(T,e),b(je,e),b(Je),b(oe),b(Ue,e),b(qe),b(Ce),b(Ie),b(Le),b(re),b(Ze),b(We),b(ae),b(Fe,e),b(Ee),b(Ae),b(ie),b(Ve,e),b(He),b(Ge),b(Be,e),b(Ne),b(Se),b(de),b(ce),b(Xe,e),b(Qe),b(Pe),b(me),b(pe),b(Oe,e),b(De),b(Ye),b(he),b(fe),b(Ke,e),b(et),b(tt),b(ue),b(nt,e),b(ot),b(st),b(rt),b(_e),b(be)}}}const qs='{"title":"REALM","local":"realm","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"RealmConfig","local":"transformers.RealmConfig","sections":[],"depth":2},{"title":"RealmTokenizer","local":"transformers.RealmTokenizer","sections":[],"depth":2},{"title":"RealmTokenizerFast","local":"transformers.RealmTokenizerFast","sections":[],"depth":2},{"title":"RealmRetriever","local":"transformers.RealmRetriever","sections":[],"depth":2},{"title":"RealmEmbedder","local":"transformers.RealmEmbedder","sections":[],"depth":2},{"title":"RealmScorer","local":"transformers.RealmScorer","sections":[],"depth":2},{"title":"RealmKnowledgeAugEncoder","local":"transformers.RealmKnowledgeAugEncoder","sections":[],"depth":2},{"title":"RealmReader","local":"transformers.RealmReader","sections":[],"depth":2},{"title":"RealmForOpenQA","local":"transformers.RealmForOpenQA","sections":[],"depth":2}],"depth":1}';function Cs(w){return fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vs extends us{constructor(n){super(),gs(this,n,Cs,Us,hs,{})}}export{Vs as component};
