import{s as me,o as ye,n as Ce}from"../chunks/scheduler.9bc65507.js";import{S as je,i as Ie,g as a,s as M,r as i,A as re,h as p,f as e,c as n,j as Ue,u as U,x as T,k as we,y as ue,a as s,v as w,d as m,t as y,w as C}from"../chunks/index.707bf1b6.js";import{T as oe}from"../chunks/Tip.c2ecdbf4.js";import{C as I}from"../chunks/CodeBlock.54a9f38d.js";import{H as At}from"../chunks/Heading.342b1fa6.js";function fe(St){let J,u="複数の実験を実行する予定がある場合、実験間でメモリを適切にクリアするために、実験の間に Python カーネルを再起動してください。";return{c(){J=a("p"),J.textContent=u},l(j){J=p(j,"P",{"data-svelte-h":!0}),T(J)!=="svelte-r9g6re"&&(J.textContent=u)},m(j,ot){s(j,J,ot)},p:Ce,d(j){j&&e(J)}}}function Ae(St){let J,u,j,ot,o,Lt,f,cl="モデルトレーニングの効率を向上させるために適用できるパフォーマンス最適化テクニックを理解するには、トレーニング中にGPUがどのように利用されるか、および実行される操作に応じて計算強度がどのように変化するかを理解することが役立ちます。",dt,A,Ql="まずは、GPUの利用例とモデルのトレーニング実行に関する示唆に富む例を探求することから始めましょう。デモンストレーションのために、いくつかのライブラリをインストールする必要があります:",ct,S,Qt,L,bl="<code>nvidia-ml-py3</code> ライブラリは、Python内からモデルのメモリ使用状況をモニターすることを可能にします。おそらく、ターミナルでの <code>nvidia-smi</code> コマンドについてはお聞きかもしれませんが、このライブラリを使用すると、Pythonから同じ情報にアクセスできます。",bt,d,gl="それから、いくつかのダミーデータを作成します。100から30000の間のランダムなトークンIDと、分類器のためのバイナリラベルです。合計で、512のシーケンスがあり、それぞれの長さは512で、PyTorchフォーマットの <code>Dataset</code> に格納されます。",gt,c,Rt,Q,Rl='<a href="/docs/transformers/v4.39.2/ja/main_classes/trainer#transformers.Trainer">Trainer</a>を使用してGPU利用率とトレーニング実行の要約統計情報を表示するために、2つのヘルパー関数を定義します。',zt,b,$t,g,zl="以下は、無料のGPUメモリから開始していることを確認しましょう：",vt,R,ht,z,$l="GPUメモリがモデルを読み込む前のように占有されていないように見えます。これがお使いのマシンでの状況でない場合は、GPUメモリを使用しているすべてのプロセスを停止してください。ただし、すべての空きGPUメモリをユーザーが使用できるわけではありません。モデルがGPUに読み込まれると、カーネルも読み込まれ、1〜2GBのメモリを使用することがあります。それがどれくらいかを確認するために、GPUに小さなテンソルを読み込むと、カーネルも読み込まれます。",Gt,$,xt,v,vl="カーネルだけで1.3GBのGPUメモリを使用していることがわかります。次に、モデルがどれだけのスペースを使用しているかを見てみましょう。",_t,h,Bt,G,hl="まず、<code>google-bert/bert-large-uncased</code> モデルを読み込みます。モデルの重みを直接GPUに読み込むことで、重みだけがどれだけのスペースを使用しているかを確認できます。",Et,x,kt,_,Gl="モデルの重みだけで、GPUメモリを1.3 GB使用していることがわかります。正確な数値は、使用している具体的なGPUに依存します。新しいGPUでは、モデルの重みが最適化された方法で読み込まれるため、モデルの使用を高速化することがあるため、モデルがより多くのスペースを占有することがあります。さて、<code>nvidia-smi</code> CLIと同じ結果が得られるかを簡単に確認することもできます。",Vt,B,Pt,E,Zt,k,xl="前回と同じ数値を取得し、16GBのメモリを搭載したV100 GPUを使用していることがわかります。さて、モデルのトレーニングを開始し、GPUメモリの消費がどのように変化するかを確認してみましょう。まず、いくつかの標準的なトレーニング引数を設定します:",Wt,V,Ht,r,Nt,P,Xt,Z,_l='<a href="/docs/transformers/v4.39.2/ja/main_classes/trainer#transformers.Trainer">Trainer</a> を使用して、GPU パフォーマンスの最適化テクニックを使用せずにバッチサイズ 4 でモデルをトレーニングしましょう：',Dt,W,Ft,H,qt,N,Bl="既に、比較的小さいバッチサイズでも、GPUのほとんどのメモリがすでに使用されていることがわかります。しかし、より大きなバッチサイズを使用することは、しばしばモデルの収束が速くなったり、最終的な性能が向上したりすることがあります。したがって、理想的には、バッチサイズをモデルの要件に合わせて調整したいのですが、GPUの制限に合わせて調整する必要はありません。興味深いことに、モデルのサイズよりもはるかに多くのメモリを使用しています。なぜそうなるのかを少し理解するために、モデルの操作とメモリの必要性を見てみましょう。",Yt,X,Kt,D,El="Transformerアーキテクチャには、計算強度によって以下の3つの主要な操作グループが含まれています。",Ot,F,kl="<li><p><strong>テンソルの収縮</strong></p> <p>線形層とMulti-Head Attentionのコンポーネントは、すべてバッチ処理された <strong>行列-行列の乗算</strong> を行います。これらの操作は、Transformerのトレーニングにおいて最も計算集約的な部分です。</p></li> <li><p><strong>統計的正規化</strong></p> <p>Softmaxと層正規化は、テンソルの収縮よりも計算負荷が少なく、1つまたは複数の <strong>縮約操作</strong> を含み、その結果がマップを介して適用されます。</p></li> <li><p><strong>要素ごとの演算子</strong></p> <p>これらは残りの演算子です：<strong>バイアス、ドロップアウト、活性化、および残差接続</strong> です。これらは最も計算集約的な操作ではありません。</p></li>",tl,q,Vl="パフォーマンスのボトルネックを分析する際に、この知識は役立つことがあります。",ll,Y,Pl='この要約は、<a href="https://arxiv.org/abs/2007.00072" rel="nofollow">Data Movement Is All You Need: Optimizing Transformers 2020に関するケーススタディ</a>から派生しています。',el,K,sl,O,Zl="モデルのトレーニングがGPUに配置されたモデルよりもはるかに多くのメモリを使用することを見てきました。これは、トレーニング中にGPUメモリを使用する多くのコンポーネントが存在するためです。GPUメモリ上のコンポーネントは以下の通りです：",Ml,tt,Wl="<li>モデルの重み</li> <li>オプティマイザの状態</li> <li>勾配</li> <li>勾配計算のために保存された前向き活性化</li> <li>一時バッファ</li> <li>機能固有のメモリ</li>",nl,lt,Hl="通常、AdamWを使用して混合精度でトレーニングされたモデルは、モデルパラメータごとに18バイトとアクティベーションメモリが必要です。推論ではオプティマイザの状態と勾配は不要ですので、これらを差し引くことができます。したがって、混合精度の推論においては、モデルパラメータごとに6バイトとアクティベーションメモリが必要です。",al,et,Nl="詳細を見てみましょう。",pl,st,Xl="<strong>モデルの重み:</strong>",Tl,Mt,Dl="<li>fp32トレーニングのパラメーター数 * 4バイト</li> <li>ミックスプレシジョントレーニングのパラメーター数 * 6バイト（メモリ内にfp32とfp16のモデルを維持）</li>",Jl,nt,Fl="<strong>オプティマイザの状態:</strong>",il,at,ql='<li>通常のAdamWのパラメーター数 * 8バイト（2つの状態を維持）</li> <li>8-bit AdamWオプティマイザのパラメーター数 * 2バイト（<a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a>のようなオプティマイザ）</li> <li>モーメンタムを持つSGDのようなオプティマイザのパラメーター数 * 4バイト（1つの状態を維持）</li>',Ul,pt,Yl="<strong>勾配</strong>",wl,Tt,Kl="<li>fp32またはミックスプレシジョントレーニングのパラメーター数 * 4バイト（勾配は常にfp32で保持）</li>",ml,Jt,Ol="<strong>フォワードアクティベーション</strong>",yl,it,te="<li>サイズは多くの要因に依存し、主要な要因はシーケンスの長さ、隠れ層のサイズ、およびバッチサイズです。</li>",Cl,Ut,le="フォワードとバックワードの関数によって渡され、返される入力と出力、および勾配計算のために保存されるフォワードアクティベーションがあります。",jl,wt,ee="<strong>一時的なメモリ</strong>",Il,mt,se="さらに、計算が完了した後に解放されるさまざまな一時変数がありますが、これらは一時的に追加のメモリを必要とし、OOMに達する可能性があります。したがって、コーディング時にはこのような一時変数に戦略的に考え、必要なくなったら明示的に解放することが非常に重要です。",rl,yt,Me="<strong>機能固有のメモリ</strong>",ul,Ct,ne="次に、ソフトウェアには特別なメモリ要件がある場合があります。たとえば、ビームサーチを使用してテキストを生成する場合、ソフトウェアは複数の入力と出力のコピーを維持する必要があります。",ol,jt,ae="<strong><code>forward</code>と<code>backward</code>の実行速度</strong>",fl,It,pe="畳み込み層と線形層では、バックワードにフォワードと比べて2倍のFLOPSがあり、一般的には約2倍遅くなります（バックワードのサイズが不便であることがあるため、それ以上になることがあります）。 アクティベーションは通常、バンド幅制限されており、バックワードでアクティベーションがフォワードよりも多くのデータを読むことが一般的です（たとえば、アクティベーションフォワードは1回読み取り、1回書き込み、アクティベーションバックワードはフォワードのgradOutputおよび出力を2回読み取り、1回書き込みます）。",Al,rt,Te='ご覧の通り、GPUメモリを節約したり操作を高速化できる可能性のあるいくつかの場所があります。 GPUの利用と計算速度に影響を与える要因を理解したので、パフォーマンス最適化の技術については、<a href="perf_train_gpu_one">単一GPUでの効率的なトレーニングのための方法とツール</a>のドキュメンテーションページを参照してください。',Sl,ut,Je="詳細を見てみましょう。",Ll,ft,dl;return o=new At({props:{title:"Model training anatomy",local:"model-training-anatomy",headingTag:"h1"}}),S=new I({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwYWNjZWxlcmF0ZSUyMG52aWRpYS1tbC1weTM=",highlighted:"pip install transformers datasets accelerate nvidia-ml-py3",wrap:!1}}),c=new I({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQSUwQXNlcV9sZW4lMkMlMjBkYXRhc2V0X3NpemUlMjAlM0QlMjA1MTIlMkMlMjA1MTIlMEFkdW1teV9kYXRhJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyaW5wdXRfaWRzJTIyJTNBJTIwbnAucmFuZG9tLnJhbmRpbnQoMTAwJTJDJTIwMzAwMDAlMkMlMjAoZGF0YXNldF9zaXplJTJDJTIwc2VxX2xlbikpJTJDJTBBJTIwJTIwJTIwJTIwJTIybGFiZWxzJTIyJTNBJTIwbnAucmFuZG9tLnJhbmRpbnQoMCUyQyUyMDElMkMlMjAoZGF0YXNldF9zaXplKSklMkMlMEElN0QlMEFkcyUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KGR1bW15X2RhdGEpJTBBZHMuc2V0X2Zvcm1hdCglMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset


<span class="hljs-meta">&gt;&gt;&gt; </span>seq_len, dataset_size = <span class="hljs-number">512</span>, <span class="hljs-number">512</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dummy_data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;input_ids&quot;</span>: np.random.randint(<span class="hljs-number">100</span>, <span class="hljs-number">30000</span>, (dataset_size, seq_len)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;labels&quot;</span>: np.random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, (dataset_size)),
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict(dummy_data)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds.set_format(<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),b=new I({props:{code:"ZnJvbSUyMHB5bnZtbCUyMGltcG9ydCUyMColMEElMEElMEFkZWYlMjBwcmludF9ncHVfdXRpbGl6YXRpb24oKSUzQSUwQSUyMCUyMCUyMCUyMG52bWxJbml0KCklMEElMjAlMjAlMjAlMjBoYW5kbGUlMjAlM0QlMjBudm1sRGV2aWNlR2V0SGFuZGxlQnlJbmRleCgwKSUwQSUyMCUyMCUyMCUyMGluZm8lMjAlM0QlMjBudm1sRGV2aWNlR2V0TWVtb3J5SW5mbyhoYW5kbGUpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMkdQVSUyMG1lbW9yeSUyMG9jY3VwaWVkJTNBJTIwJTdCaW5mby51c2VkJTJGJTJGMTAyNCoqMiU3RCUyME1CLiUyMiklMEElMEElMEFkZWYlMjBwcmludF9zdW1tYXJ5KHJlc3VsdCklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyVGltZSUzQSUyMCU3QnJlc3VsdC5tZXRyaWNzJTVCJ3RyYWluX3J1bnRpbWUnJTVEJTNBLjJmJTdEJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJTYW1wbGVzJTJGc2Vjb25kJTNBJTIwJTdCcmVzdWx0Lm1ldHJpY3MlNUIndHJhaW5fc2FtcGxlc19wZXJfc2Vjb25kJyU1RCUzQS4yZiU3RCUyMiklMEElMjAlMjAlMjAlMjBwcmludF9ncHVfdXRpbGl6YXRpb24oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pynvml <span class="hljs-keyword">import</span> *


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">print_gpu_utilization</span>():
<span class="hljs-meta">... </span>    nvmlInit()
<span class="hljs-meta">... </span>    handle = nvmlDeviceGetHandleByIndex(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    info = nvmlDeviceGetMemoryInfo(handle)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;GPU memory occupied: <span class="hljs-subst">{info.used//<span class="hljs-number">1024</span>**<span class="hljs-number">2</span>}</span> MB.&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">print_summary</span>(<span class="hljs-params">result</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time: <span class="hljs-subst">{result.metrics[<span class="hljs-string">&#x27;train_runtime&#x27;</span>]:<span class="hljs-number">.2</span>f}</span>&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Samples/second: <span class="hljs-subst">{result.metrics[<span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>]:<span class="hljs-number">.2</span>f}</span>&quot;</span>)
<span class="hljs-meta">... </span>    print_gpu_utilization()`,wrap:!1}}),R=new I({props:{code:"cHJpbnRfZ3B1X3V0aWxpemF0aW9uKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>print_gpu_utilization()
GPU memory occupied: <span class="hljs-number">0</span> MB.`,wrap:!1}}),$=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEF0b3JjaC5vbmVzKCgxJTJDJTIwMSkpLnRvKCUyMmN1ZGElMjIpJTBBcHJpbnRfZ3B1X3V0aWxpemF0aW9uKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch


<span class="hljs-meta">&gt;&gt;&gt; </span>torch.ones((<span class="hljs-number">1</span>, <span class="hljs-number">1</span>)).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>print_gpu_utilization()
GPU memory occupied: <span class="hljs-number">1343</span> MB.`,wrap:!1}}),h=new At({props:{title:"Load Model",local:"load-model",headingTag:"h2"}}),x=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1sYXJnZS11bmNhc2VkJTIyKS50byglMjJjdWRhJTIyKSUwQXByaW50X2dwdV91dGlsaXphdGlvbigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification


<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-large-uncased&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>print_gpu_utilization()
GPU memory occupied: <span class="hljs-number">2631</span> MB.`,wrap:!1}}),B=new I({props:{code:"bnZpZGlhLXNtaQ==",highlighted:"nvidia-smi",wrap:!1}}),E=new I({props:{code:"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",highlighted:`Tue Jan 11 08:58:05 2022
+-----------------------------------------------------------------------------+
| NVIDIA-SMI 460.91.03    Driver Version: 460.91.03    CUDA Version: 11.2     |
|-------------------------------+----------------------+----------------------+
| GPU  Name        Persistence-M| Bus-Id        Disp.A | Volatile Uncorr. ECC |
| Fan  Temp  Perf  Pwr:Usage/Cap|         Memory-Usage | GPU-Util  Compute M. |
|                               |                      |               MIG M. |
|===============================+======================+======================|
|   0  Tesla V100-SXM2...  On   | 00000000:00:04.0 Off |                    0 |
| N/A   37C    P0    39W / 300W |   2631MiB / 16160MiB |      0%      Default |
|                               |                      |                  N/A |
+-------------------------------+----------------------+----------------------+

+-----------------------------------------------------------------------------+
| Processes:                                                                  |
|  GPU   GI   CI        PID   Type   Process name                  GPU Memory |
|        ID   ID                                                   Usage      |
|=============================================================================|
|    0   N/A  N/A      3721      C   ...nvs/codeparrot/bin/python     2629MiB |
+-----------------------------------------------------------------------------+`,wrap:!1}}),V=new I({props:{code:"ZGVmYXVsdF9hcmdzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyb3V0cHV0X2RpciUyMiUzQSUyMCUyMnRtcCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmV2YWx1YXRpb25fc3RyYXRlZ3klMjIlM0ElMjAlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm51bV90cmFpbl9lcG9jaHMlMjIlM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJTIybG9nX2xldmVsJTIyJTNBJTIwJTIyZXJyb3IlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJyZXBvcnRfdG8lMjIlM0ElMjAlMjJub25lJTIyJTJDJTBBJTdE",highlighted:`default_args = {
    <span class="hljs-string">&quot;output_dir&quot;</span>: <span class="hljs-string">&quot;tmp&quot;</span>,
    <span class="hljs-string">&quot;evaluation_strategy&quot;</span>: <span class="hljs-string">&quot;steps&quot;</span>,
    <span class="hljs-string">&quot;num_train_epochs&quot;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;log_level&quot;</span>: <span class="hljs-string">&quot;error&quot;</span>,
    <span class="hljs-string">&quot;report_to&quot;</span>: <span class="hljs-string">&quot;none&quot;</span>,
}`,wrap:!1}}),r=new oe({props:{$$slots:{default:[fe]},$$scope:{ctx:St}}}),P=new At({props:{title:"Memory utilization at vanilla training",local:"memory-utilization-at-vanilla-training",headingTag:"h2"}}),W=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUyQyUyMGxvZ2dpbmclMEElMEFsb2dnaW5nLnNldF92ZXJib3NpdHlfZXJyb3IoKSUwQSUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyhwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0Q0JTJDJTIwKipkZWZhdWx0X2FyZ3MpJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0Rtb2RlbCUyQyUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTIwdHJhaW5fZGF0YXNldCUzRGRzKSUwQXJlc3VsdCUyMCUzRCUyMHRyYWluZXIudHJhaW4oKSUwQXByaW50X3N1bW1hcnkocmVzdWx0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer, logging

<span class="hljs-meta">&gt;&gt;&gt; </span>logging.set_verbosity_error()


<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, **default_args)
<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(model=model, args=training_args, train_dataset=ds)
<span class="hljs-meta">&gt;&gt;&gt; </span>result = trainer.train()
<span class="hljs-meta">&gt;&gt;&gt; </span>print_summary(result)`,wrap:!1}}),H=new I({props:{code:"VGltZSUzQSUyMDU3LjgyJTBBU2FtcGxlcyUyRnNlY29uZCUzQSUyMDguODYlMEFHUFUlMjBtZW1vcnklMjBvY2N1cGllZCUzQSUyMDE0OTQ5JTIwTUIu",highlighted:`<span class="hljs-keyword">Time:</span> 57.82
Samples/second: 8.86
GPU memory occupied: 14949 MB.`,wrap:!1}}),X=new At({props:{title:"Anatomy of Model’s Operations",local:"anatomy-of-models-operations",headingTag:"h2"}}),K=new At({props:{title:"Anatomy of Model’s Memory",local:"anatomy-of-models-memory",headingTag:"h2"}}),{c(){J=a("meta"),u=M(),j=a("p"),ot=M(),i(o.$$.fragment),Lt=M(),f=a("p"),f.textContent=cl,dt=M(),A=a("p"),A.textContent=Ql,ct=M(),i(S.$$.fragment),Qt=M(),L=a("p"),L.innerHTML=bl,bt=M(),d=a("p"),d.innerHTML=gl,gt=M(),i(c.$$.fragment),Rt=M(),Q=a("p"),Q.innerHTML=Rl,zt=M(),i(b.$$.fragment),$t=M(),g=a("p"),g.textContent=zl,vt=M(),i(R.$$.fragment),ht=M(),z=a("p"),z.textContent=$l,Gt=M(),i($.$$.fragment),xt=M(),v=a("p"),v.textContent=vl,_t=M(),i(h.$$.fragment),Bt=M(),G=a("p"),G.innerHTML=hl,Et=M(),i(x.$$.fragment),kt=M(),_=a("p"),_.innerHTML=Gl,Vt=M(),i(B.$$.fragment),Pt=M(),i(E.$$.fragment),Zt=M(),k=a("p"),k.textContent=xl,Wt=M(),i(V.$$.fragment),Ht=M(),i(r.$$.fragment),Nt=M(),i(P.$$.fragment),Xt=M(),Z=a("p"),Z.innerHTML=_l,Dt=M(),i(W.$$.fragment),Ft=M(),i(H.$$.fragment),qt=M(),N=a("p"),N.textContent=Bl,Yt=M(),i(X.$$.fragment),Kt=M(),D=a("p"),D.textContent=El,Ot=M(),F=a("ol"),F.innerHTML=kl,tl=M(),q=a("p"),q.textContent=Vl,ll=M(),Y=a("p"),Y.innerHTML=Pl,el=M(),i(K.$$.fragment),sl=M(),O=a("p"),O.textContent=Zl,Ml=M(),tt=a("ol"),tt.innerHTML=Wl,nl=M(),lt=a("p"),lt.textContent=Hl,al=M(),et=a("p"),et.textContent=Nl,pl=M(),st=a("p"),st.innerHTML=Xl,Tl=M(),Mt=a("ul"),Mt.innerHTML=Dl,Jl=M(),nt=a("p"),nt.innerHTML=Fl,il=M(),at=a("ul"),at.innerHTML=ql,Ul=M(),pt=a("p"),pt.innerHTML=Yl,wl=M(),Tt=a("ul"),Tt.innerHTML=Kl,ml=M(),Jt=a("p"),Jt.innerHTML=Ol,yl=M(),it=a("ul"),it.innerHTML=te,Cl=M(),Ut=a("p"),Ut.textContent=le,jl=M(),wt=a("p"),wt.innerHTML=ee,Il=M(),mt=a("p"),mt.textContent=se,rl=M(),yt=a("p"),yt.innerHTML=Me,ul=M(),Ct=a("p"),Ct.textContent=ne,ol=M(),jt=a("p"),jt.innerHTML=ae,fl=M(),It=a("p"),It.textContent=pe,Al=M(),rt=a("p"),rt.innerHTML=Te,Sl=M(),ut=a("p"),ut.textContent=Je,Ll=M(),ft=a("p"),this.h()},l(t){const l=re("svelte-u9bgzb",document.head);J=p(l,"META",{name:!0,content:!0}),l.forEach(e),u=n(t),j=p(t,"P",{}),Ue(j).forEach(e),ot=n(t),U(o.$$.fragment,t),Lt=n(t),f=p(t,"P",{"data-svelte-h":!0}),T(f)!=="svelte-eqtck6"&&(f.textContent=cl),dt=n(t),A=p(t,"P",{"data-svelte-h":!0}),T(A)!=="svelte-1onv8vz"&&(A.textContent=Ql),ct=n(t),U(S.$$.fragment,t),Qt=n(t),L=p(t,"P",{"data-svelte-h":!0}),T(L)!=="svelte-1x72wcq"&&(L.innerHTML=bl),bt=n(t),d=p(t,"P",{"data-svelte-h":!0}),T(d)!=="svelte-1mr5hdp"&&(d.innerHTML=gl),gt=n(t),U(c.$$.fragment,t),Rt=n(t),Q=p(t,"P",{"data-svelte-h":!0}),T(Q)!=="svelte-hlu2kn"&&(Q.innerHTML=Rl),zt=n(t),U(b.$$.fragment,t),$t=n(t),g=p(t,"P",{"data-svelte-h":!0}),T(g)!=="svelte-2tk5qw"&&(g.textContent=zl),vt=n(t),U(R.$$.fragment,t),ht=n(t),z=p(t,"P",{"data-svelte-h":!0}),T(z)!=="svelte-ratoe1"&&(z.textContent=$l),Gt=n(t),U($.$$.fragment,t),xt=n(t),v=p(t,"P",{"data-svelte-h":!0}),T(v)!=="svelte-6mk52t"&&(v.textContent=vl),_t=n(t),U(h.$$.fragment,t),Bt=n(t),G=p(t,"P",{"data-svelte-h":!0}),T(G)!=="svelte-1chyu29"&&(G.innerHTML=hl),Et=n(t),U(x.$$.fragment,t),kt=n(t),_=p(t,"P",{"data-svelte-h":!0}),T(_)!=="svelte-a65j54"&&(_.innerHTML=Gl),Vt=n(t),U(B.$$.fragment,t),Pt=n(t),U(E.$$.fragment,t),Zt=n(t),k=p(t,"P",{"data-svelte-h":!0}),T(k)!=="svelte-foy1k2"&&(k.textContent=xl),Wt=n(t),U(V.$$.fragment,t),Ht=n(t),U(r.$$.fragment,t),Nt=n(t),U(P.$$.fragment,t),Xt=n(t),Z=p(t,"P",{"data-svelte-h":!0}),T(Z)!=="svelte-1lmh7qu"&&(Z.innerHTML=_l),Dt=n(t),U(W.$$.fragment,t),Ft=n(t),U(H.$$.fragment,t),qt=n(t),N=p(t,"P",{"data-svelte-h":!0}),T(N)!=="svelte-11ygb1k"&&(N.textContent=Bl),Yt=n(t),U(X.$$.fragment,t),Kt=n(t),D=p(t,"P",{"data-svelte-h":!0}),T(D)!=="svelte-1d6lg7k"&&(D.textContent=El),Ot=n(t),F=p(t,"OL",{"data-svelte-h":!0}),T(F)!=="svelte-245rwp"&&(F.innerHTML=kl),tl=n(t),q=p(t,"P",{"data-svelte-h":!0}),T(q)!=="svelte-ec3fwb"&&(q.textContent=Vl),ll=n(t),Y=p(t,"P",{"data-svelte-h":!0}),T(Y)!=="svelte-8zw5bh"&&(Y.innerHTML=Pl),el=n(t),U(K.$$.fragment,t),sl=n(t),O=p(t,"P",{"data-svelte-h":!0}),T(O)!=="svelte-b5yvgq"&&(O.textContent=Zl),Ml=n(t),tt=p(t,"OL",{"data-svelte-h":!0}),T(tt)!=="svelte-81qfbm"&&(tt.innerHTML=Wl),nl=n(t),lt=p(t,"P",{"data-svelte-h":!0}),T(lt)!=="svelte-q091fs"&&(lt.textContent=Hl),al=n(t),et=p(t,"P",{"data-svelte-h":!0}),T(et)!=="svelte-1tqb7ol"&&(et.textContent=Nl),pl=n(t),st=p(t,"P",{"data-svelte-h":!0}),T(st)!=="svelte-pltc9x"&&(st.innerHTML=Xl),Tl=n(t),Mt=p(t,"UL",{"data-svelte-h":!0}),T(Mt)!=="svelte-1ofvy53"&&(Mt.innerHTML=Dl),Jl=n(t),nt=p(t,"P",{"data-svelte-h":!0}),T(nt)!=="svelte-w2gg2k"&&(nt.innerHTML=Fl),il=n(t),at=p(t,"UL",{"data-svelte-h":!0}),T(at)!=="svelte-nhv9x5"&&(at.innerHTML=ql),Ul=n(t),pt=p(t,"P",{"data-svelte-h":!0}),T(pt)!=="svelte-1v03lvy"&&(pt.innerHTML=Yl),wl=n(t),Tt=p(t,"UL",{"data-svelte-h":!0}),T(Tt)!=="svelte-1n5rvq2"&&(Tt.innerHTML=Kl),ml=n(t),Jt=p(t,"P",{"data-svelte-h":!0}),T(Jt)!=="svelte-17140l5"&&(Jt.innerHTML=Ol),yl=n(t),it=p(t,"UL",{"data-svelte-h":!0}),T(it)!=="svelte-186gshk"&&(it.innerHTML=te),Cl=n(t),Ut=p(t,"P",{"data-svelte-h":!0}),T(Ut)!=="svelte-9ra66f"&&(Ut.textContent=le),jl=n(t),wt=p(t,"P",{"data-svelte-h":!0}),T(wt)!=="svelte-4i0cbm"&&(wt.innerHTML=ee),Il=n(t),mt=p(t,"P",{"data-svelte-h":!0}),T(mt)!=="svelte-163p89m"&&(mt.textContent=se),rl=n(t),yt=p(t,"P",{"data-svelte-h":!0}),T(yt)!=="svelte-16qv7y9"&&(yt.innerHTML=Me),ul=n(t),Ct=p(t,"P",{"data-svelte-h":!0}),T(Ct)!=="svelte-1de712h"&&(Ct.textContent=ne),ol=n(t),jt=p(t,"P",{"data-svelte-h":!0}),T(jt)!=="svelte-11b3n5n"&&(jt.innerHTML=ae),fl=n(t),It=p(t,"P",{"data-svelte-h":!0}),T(It)!=="svelte-1gz1cxl"&&(It.textContent=pe),Al=n(t),rt=p(t,"P",{"data-svelte-h":!0}),T(rt)!=="svelte-1fbv7yx"&&(rt.innerHTML=Te),Sl=n(t),ut=p(t,"P",{"data-svelte-h":!0}),T(ut)!=="svelte-1tqb7ol"&&(ut.textContent=Je),Ll=n(t),ft=p(t,"P",{}),Ue(ft).forEach(e),this.h()},h(){we(J,"name","hf:doc:metadata"),we(J,"content",Se)},m(t,l){ue(document.head,J),s(t,u,l),s(t,j,l),s(t,ot,l),w(o,t,l),s(t,Lt,l),s(t,f,l),s(t,dt,l),s(t,A,l),s(t,ct,l),w(S,t,l),s(t,Qt,l),s(t,L,l),s(t,bt,l),s(t,d,l),s(t,gt,l),w(c,t,l),s(t,Rt,l),s(t,Q,l),s(t,zt,l),w(b,t,l),s(t,$t,l),s(t,g,l),s(t,vt,l),w(R,t,l),s(t,ht,l),s(t,z,l),s(t,Gt,l),w($,t,l),s(t,xt,l),s(t,v,l),s(t,_t,l),w(h,t,l),s(t,Bt,l),s(t,G,l),s(t,Et,l),w(x,t,l),s(t,kt,l),s(t,_,l),s(t,Vt,l),w(B,t,l),s(t,Pt,l),w(E,t,l),s(t,Zt,l),s(t,k,l),s(t,Wt,l),w(V,t,l),s(t,Ht,l),w(r,t,l),s(t,Nt,l),w(P,t,l),s(t,Xt,l),s(t,Z,l),s(t,Dt,l),w(W,t,l),s(t,Ft,l),w(H,t,l),s(t,qt,l),s(t,N,l),s(t,Yt,l),w(X,t,l),s(t,Kt,l),s(t,D,l),s(t,Ot,l),s(t,F,l),s(t,tl,l),s(t,q,l),s(t,ll,l),s(t,Y,l),s(t,el,l),w(K,t,l),s(t,sl,l),s(t,O,l),s(t,Ml,l),s(t,tt,l),s(t,nl,l),s(t,lt,l),s(t,al,l),s(t,et,l),s(t,pl,l),s(t,st,l),s(t,Tl,l),s(t,Mt,l),s(t,Jl,l),s(t,nt,l),s(t,il,l),s(t,at,l),s(t,Ul,l),s(t,pt,l),s(t,wl,l),s(t,Tt,l),s(t,ml,l),s(t,Jt,l),s(t,yl,l),s(t,it,l),s(t,Cl,l),s(t,Ut,l),s(t,jl,l),s(t,wt,l),s(t,Il,l),s(t,mt,l),s(t,rl,l),s(t,yt,l),s(t,ul,l),s(t,Ct,l),s(t,ol,l),s(t,jt,l),s(t,fl,l),s(t,It,l),s(t,Al,l),s(t,rt,l),s(t,Sl,l),s(t,ut,l),s(t,Ll,l),s(t,ft,l),dl=!0},p(t,[l]){const ie={};l&2&&(ie.$$scope={dirty:l,ctx:t}),r.$set(ie)},i(t){dl||(m(o.$$.fragment,t),m(S.$$.fragment,t),m(c.$$.fragment,t),m(b.$$.fragment,t),m(R.$$.fragment,t),m($.$$.fragment,t),m(h.$$.fragment,t),m(x.$$.fragment,t),m(B.$$.fragment,t),m(E.$$.fragment,t),m(V.$$.fragment,t),m(r.$$.fragment,t),m(P.$$.fragment,t),m(W.$$.fragment,t),m(H.$$.fragment,t),m(X.$$.fragment,t),m(K.$$.fragment,t),dl=!0)},o(t){y(o.$$.fragment,t),y(S.$$.fragment,t),y(c.$$.fragment,t),y(b.$$.fragment,t),y(R.$$.fragment,t),y($.$$.fragment,t),y(h.$$.fragment,t),y(x.$$.fragment,t),y(B.$$.fragment,t),y(E.$$.fragment,t),y(V.$$.fragment,t),y(r.$$.fragment,t),y(P.$$.fragment,t),y(W.$$.fragment,t),y(H.$$.fragment,t),y(X.$$.fragment,t),y(K.$$.fragment,t),dl=!1},d(t){t&&(e(u),e(j),e(ot),e(Lt),e(f),e(dt),e(A),e(ct),e(Qt),e(L),e(bt),e(d),e(gt),e(Rt),e(Q),e(zt),e($t),e(g),e(vt),e(ht),e(z),e(Gt),e(xt),e(v),e(_t),e(Bt),e(G),e(Et),e(kt),e(_),e(Vt),e(Pt),e(Zt),e(k),e(Wt),e(Ht),e(Nt),e(Xt),e(Z),e(Dt),e(Ft),e(qt),e(N),e(Yt),e(Kt),e(D),e(Ot),e(F),e(tl),e(q),e(ll),e(Y),e(el),e(sl),e(O),e(Ml),e(tt),e(nl),e(lt),e(al),e(et),e(pl),e(st),e(Tl),e(Mt),e(Jl),e(nt),e(il),e(at),e(Ul),e(pt),e(wl),e(Tt),e(ml),e(Jt),e(yl),e(it),e(Cl),e(Ut),e(jl),e(wt),e(Il),e(mt),e(rl),e(yt),e(ul),e(Ct),e(ol),e(jt),e(fl),e(It),e(Al),e(rt),e(Sl),e(ut),e(Ll),e(ft)),e(J),C(o,t),C(S,t),C(c,t),C(b,t),C(R,t),C($,t),C(h,t),C(x,t),C(B,t),C(E,t),C(V,t),C(r,t),C(P,t),C(W,t),C(H,t),C(X,t),C(K,t)}}}const Se='{"title":"Model training anatomy","local":"model-training-anatomy","sections":[{"title":"Load Model","local":"load-model","sections":[],"depth":2},{"title":"Memory utilization at vanilla training","local":"memory-utilization-at-vanilla-training","sections":[],"depth":2},{"title":"Anatomy of Model’s Operations","local":"anatomy-of-models-operations","sections":[],"depth":2},{"title":"Anatomy of Model’s Memory","local":"anatomy-of-models-memory","sections":[],"depth":2}],"depth":1}';function Le(St){return ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Re extends je{constructor(J){super(),Ie(this,J,Le,Ae,me,{})}}export{Re as component};
