import{s as it,n as pt,o as yt}from"../chunks/scheduler.ddeee2a5.js";import{S as Jt,i as wt,e as n,s as M,c as y,h as Tt,a as i,d as t,b as a,f as ge,g as J,j as p,k as Il,l as rl,m as s,n as w,t as T,o as j,p as o}from"../chunks/index.10b70568.js";import{C as jt}from"../chunks/CopyLLMTxtMenu.68696f97.js";import{C as I}from"../chunks/CodeBlock.7ca4c11d.js";import{H as h,E as ot}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d66d689f.js";function Ut(fe){let r,gl,Cl,Al,g,Bl,A,bl,B,Ee='In this guide, we’ll build an AI-powered image editor that lets users upload images and edit them using natural language prompts. This project demonstrates how to combine Inference Providers with image-to-image models like <a href="https://huggingface.co/Qwen/Qwen-Image-Edit" rel="nofollow">Qwen’s Image Edit</a> and <a href="https://huggingface.co/black-forest-labs/FLUX.1-Kontext-dev" rel="nofollow">Black Forest Labs’ Flux Kontext</a>.',fl,b,Ze="Our app will:",El,f,We="<li><strong>Accept image uploads</strong> through a web interface</li> <li><strong>Process natural language prompts</strong> editing instructions like “Turn the cat into a tiger”</li> <li><strong>Transform images</strong> using Qwen Image Edit or FLUX.1 Kontext</li> <li><strong>Display results</strong> in a Gradio interface</li>",Zl,m,ke='<p>TL;DR - this guide will show you how to build an AI image editor with Gradio and Inference Providers, just like <a href="https://huggingface.co/spaces/Qwen/Qwen-Image-Edit" rel="nofollow">this one</a>.</p>',Wl,E,kl,Z,Ge="Before we start coding, authenticate with Hugging Face using your token:",Gl,W,vl,c,ve='<p>This guide assumes you have a Hugging Face account. If you don’t have one, you can create one for free at <a href="https://huggingface.co" rel="nofollow">huggingface.co</a>.</p>',Ql,k,Qe='When you set this environment variable, it handles authentication automatically for all your inference calls. You can generate a token from <a href="https://huggingface.co/settings/tokens/new?ownUserPermissions=inference.serverless.write&amp;tokenType=fineGrained" rel="nofollow">your settings page</a>.',Xl,G,Rl,v,Xe="Create a new project directory and initialize it with uv:",Sl,Q,$l,X,Re="This creates a basic project structure with a <code>pyproject.toml</code> file. Now add the required dependencies:",Hl,R,Vl,S,Se="The dependencies are now installed and ready to use! Also, <code>uv</code> will maintain the <code>pyproject.toml</code> file for you as you add dependencies.",_l,d,$e='<p>We’re using <code>uv</code> because it’s a fast Python package manager that handles dependency resolution and virtual environment management automatically. It’s much faster than pip and provides better dependency resolution. If you’re not familiar with <code>uv</code>, check it out <a href="https://docs.astral.sh/uv/" rel="nofollow">here</a>.</p>',ql,$,xl,H,He="Now let’s create the main logic for our application - the image editing function that transforms images using AI.",Fl,V,Ve="Create <code>main.py</code> then import the necessary libraries and instantiate the InferenceClient. We’re using the <code>fal-ai</code> provider for fast image processing, but other providers like <code>replicate</code> are also available.",Yl,_,Nl,q,_e="Now let’s create the image editing function. This function takes an input image and a prompt, and returns an edited image. We also want to handle errors gracefully and return the original image if there’s an error, so our UI always shows something.",zl,x,Ll,U,ml,qe="We’re using the <code>fal-ai</code> provider with the <code>Qwen/Qwen-Image-Edit</code> model. The fal-ai provider offers fast inference times, perfect for interactive applications.",Ae,cl,xe="However, you can experiment with different providers for various performance characteristics:",Be,F,Pl,Y,Dl,N,Fe="Now let’s build a simple user-friendly interface using Gradio.",Kl,z,Ol,L,Ye="In this app we’ll use some practical Gradio features to make a user-friendly app",le,P,Ne="<li>We’ll use blocks to create a two column layout with the image upload and the edited image.</li> <li>We’ll drop some markdown into to explain what the app does.</li> <li>And, we’ll use <code>gr.Examples</code> to show some example inputs to give the user some inspiration.</li>",ee,D,ze="Finally, add the launch configuration at the end of <code>main.py</code>:",te,K,se,O,Le="Now run your application:",Me,ll,ae,el,Pe="Your app will launch locally at <code>http://localhost:7860</code> and Gradio will also provide a public shareable link!",ne,tl,ie,u,dl,De="<strong>📋 Click to view the complete main.py file</strong>",be,sl,pe,Ml,ye,al,Ke="Let’s deploy our app to Hugging Face Spaces.",Je,nl,Oe="First, we will export our dependencies to a requirements file.",we,il,Te,pl,lt="This creates a <code>requirements.txt</code> file with all your project dependencies and their exact versions from the lockfile.",je,C,et="<p>The <code>uv export</code> command ensures that your Space will use the exact same dependency versions that you tested locally, preventing deployment issues caused by version mismatches.</p>",oe,yl,tt="Now you can deploy to Spaces:",Ue,Jl,st='<li><strong>Create a new Space</strong>: Go to <a href="https://huggingface.co/new-space" rel="nofollow">huggingface.co/new-space</a></li> <li><strong>Choose Gradio SDK</strong> and make it public</li> <li><strong>Upload your files</strong>: Upload <code>main.py</code>, <code>requirements.txt</code>, and any example images</li> <li><strong>Add your token</strong>: In Space settings, add <code>HF_TOKEN</code> as a secret</li> <li><strong>Launch</strong>: Your app will be live at <code>https://huggingface.co/spaces/your-username/your-space-name</code></li>',Ie,wl,re,Tl,Mt="Congratulations! You’ve created a production-ready AI image editor. Now that you have a working image editor, here are some ideas to extend it:",me,jl,at="<li><strong>Batch processing</strong>: Edit multiple images at once</li> <li><strong>Object removal</strong>: Remove unwanted objects from images</li> <li><strong>Provider comparison</strong>: Benchmark different providers for your use case</li>",ce,ol,nt="Happy building! And remember to share your app with the community on the Hub.",de,Ul,ue,hl,Ce;return g=new jt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),A=new h({props:{title:"Building an AI Image Editor with Gradio and Inference Providers",local:"building-an-ai-image-editor-with-gradio-and-inference-providers",headingTag:"h1"}}),E=new h({props:{title:"Step 1: Set Up Authentication",local:"step-1-set-up-authentication",headingTag:"h2"}}),W=new I({props:{code:"JTIzJTIwR2V0JTIweW91ciUyMHRva2VuJTIwZnJvbSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzZXR0aW5ncyUyRnRva2VucyUwQWV4cG9ydCUyMEhGX1RPS0VOJTNEJTIyeW91cl90b2tlbl9oZXJlJTIy",highlighted:`<span class="hljs-comment"># Get your token from https://huggingface.co/settings/tokens</span>
<span class="hljs-built_in">export</span> HF_TOKEN=<span class="hljs-string">&quot;your_token_here&quot;</span>`,wrap:!1}}),G=new h({props:{title:"Step 2: Project Setup",local:"step-2-project-setup",headingTag:"h2"}}),Q=new I({props:{code:"bWtkaXIlMjBpbWFnZS1lZGl0b3ItYXBwJTBBY2QlMjBpbWFnZS1lZGl0b3ItYXBwJTBBdXYlMjBpbml0",highlighted:`<span class="hljs-built_in">mkdir</span> image-editor-app
<span class="hljs-built_in">cd</span> image-editor-app
uv init`,wrap:!1}}),R=new I({props:{code:"dXYlMjBhZGQlMjBodWdnaW5nZmFjZS1odWIlM0UlM0QwLjM0LjQlMjBncmFkaW8lM0UlM0Q1LjAuMCUyMHBpbGxvdyUzRSUzRDExLjMuMA==",highlighted:"uv add huggingface-hub&gt;=0.34.4 gradio&gt;=5.0.0 pillow&gt;=11.3.0",wrap:!1}}),$=new h({props:{title:"Step 3: Build the Core Image Editing Function",local:"step-3-build-the-core-image-editing-function",headingTag:"h2"}}),_=new I({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBncmFkaW8lMjBhcyUyMGdyJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWltcG9ydCUyMGlvJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMGNsaWVudCUyMHdpdGglMjBmYWwtYWklMjBwcm92aWRlciUyMGZvciUyMGZhc3QlMjBpbWFnZSUyMHByb2Nlc3NpbmclMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTBBJTIwJTIwJTIwJTIwcHJvdmlkZXIlM0QlMjJmYWwtYWklMjIlMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEb3MuZW52aXJvbiU1QiUyMkhGX1RPS0VOJTIyJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-keyword">import</span> io

<span class="hljs-comment"># Initialize the client with fal-ai provider for fast image processing</span>
client = InferenceClient(
    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,
    api_key=os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>],
)`,wrap:!1}}),x=new I({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">edit_image</span>(<span class="hljs-params">input_image, prompt</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Edit an image using the given prompt.
    
    Args:
        input_image: PIL Image object from Gradio
        prompt: String prompt for image editing
    
    Returns:
        PIL Image object (edited image)
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> input_image <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>
    
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> prompt <span class="hljs-keyword">or</span> prompt.strip() == <span class="hljs-string">&quot;&quot;</span>:
        <span class="hljs-keyword">return</span> input_image
    
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Convert PIL Image to bytes</span>
        img_bytes = io.BytesIO()
        input_image.save(img_bytes, <span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;PNG&quot;</span>)
        img_bytes = img_bytes.getvalue()
        
        <span class="hljs-comment"># Use the image_to_image method with Qwen&#x27;s image editing model</span>
        edited_image = client.image_to_image(
            img_bytes,
            prompt=prompt.strip(),
            model=<span class="hljs-string">&quot;Qwen/Qwen-Image-Edit&quot;</span>,
        )
        
        <span class="hljs-keyword">return</span> edited_image
    
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Error editing image: <span class="hljs-subst">{e}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> input_image`,wrap:!1}}),F=new I({props:{code:"Y2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KHByb3ZpZGVyJTNEJTIycmVwbGljYXRlJTIyJTJDJTIwYXBpX2tleSUzRG9zLmVudmlyb24lNUIlMjJIRl9UT0tFTiUyMiU1RCklMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQocHJvdmlkZXIlM0QlMjJhdXRvJTIyJTJDJTIwYXBpX2tleSUzRG9zLmVudmlyb24lNUIlMjJIRl9UT0tFTiUyMiU1RCklMjAlMjAlMjMlMjBBdXRvbWF0aWMlMjBzZWxlY3Rpb24=",highlighted:`client = InferenceClient(provider=<span class="hljs-string">&quot;replicate&quot;</span>, api_key=os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>])
client = InferenceClient(provider=<span class="hljs-string">&quot;auto&quot;</span>, api_key=os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>])  <span class="hljs-comment"># Automatic selection</span>`,wrap:!1}}),Y=new h({props:{title:"Step 4: Create the Gradio Interface",local:"step-4-create-the-gradio-interface",headingTag:"h2"}}),z=new I({props:{code:"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",highlighted:`<span class="hljs-comment"># Create the Gradio interface</span>
<span class="hljs-keyword">with</span> gr.Blocks(title=<span class="hljs-string">&quot;Image Editor&quot;</span>, theme=gr.themes.Soft()) <span class="hljs-keyword">as</span> interface:
    gr.Markdown(
        <span class="hljs-string">&quot;&quot;&quot;
        # 🎨 AI Image Editor
        Upload an image and describe how you want to edit it using natural language!
        &quot;&quot;&quot;</span>
    )

    <span class="hljs-keyword">with</span> gr.Row():
        <span class="hljs-keyword">with</span> gr.Column():
            input_image = gr.Image(label=<span class="hljs-string">&quot;Upload Image&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;pil&quot;</span>, height=<span class="hljs-number">400</span>)
            prompt = gr.Textbox(
                label=<span class="hljs-string">&quot;Edit Prompt&quot;</span>,
                placeholder=<span class="hljs-string">&quot;Describe how you want to edit the image...&quot;</span>,
                lines=<span class="hljs-number">2</span>,
            )
            edit_btn = gr.Button(<span class="hljs-string">&quot;✨ Edit Image&quot;</span>, variant=<span class="hljs-string">&quot;primary&quot;</span>, size=<span class="hljs-string">&quot;lg&quot;</span>)

        <span class="hljs-keyword">with</span> gr.Column():
            output_image = gr.Image(label=<span class="hljs-string">&quot;Edited Image&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;pil&quot;</span>, height=<span class="hljs-number">400</span>)

    <span class="hljs-comment"># Example images and prompts</span>
    <span class="hljs-keyword">with</span> gr.Row():
        gr.Examples(
            examples=[
                [<span class="hljs-string">&quot;cat.png&quot;</span>, <span class="hljs-string">&quot;Turn the cat into a tiger&quot;</span>],
                [<span class="hljs-string">&quot;cat.png&quot;</span>, <span class="hljs-string">&quot;Make it look like a watercolor painting&quot;</span>],
                [<span class="hljs-string">&quot;cat.png&quot;</span>, <span class="hljs-string">&quot;Change the background to a forest&quot;</span>],
            ],
            inputs=[input_image, prompt],
            outputs=output_image,
            fn=edit_image,
            cache_examples=<span class="hljs-literal">False</span>,
        )

    <span class="hljs-comment"># Event handlers</span>
    edit_btn.click(fn=edit_image, inputs=[input_image, prompt], outputs=output_image)

    <span class="hljs-comment"># Allow Enter key to trigger editing</span>
    prompt.submit(fn=edit_image, inputs=[input_image, prompt], outputs=output_image)`,wrap:!1}}),K=new I({props:{code:"aWYlMjBfX25hbWVfXyUyMCUzRCUzRCUyMCUyMl9fbWFpbl9fJTIyJTNBJTBBJTIwJTIwJTIwJTIwaW50ZXJmYWNlLmxhdW5jaCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzaGFyZSUzRFRydWUlMkMlMjAlMjAlMjMlMjBDcmVhdGVzJTIwYSUyMHB1YmxpYyUyMGxpbmslMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZXJ2ZXJfbmFtZSUzRCUyMjAuMC4wLjAlMjIlMkMlMjAlMjAlMjMlMjBBbGxvdyUyMGV4dGVybmFsJTIwYWNjZXNzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VydmVyX3BvcnQlM0Q3ODYwJTJDJTIwJTIwJTIzJTIwRGVmYXVsdCUyMEdyYWRpbyUyMHBvcnQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzaG93X2Vycm9yJTNEVHJ1ZSUyQyUyMCUyMCUyMyUyMFNob3clMjBlcnJvcnMlMjBpbiUyMHRoZSUyMGludGVyZmFjZSUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    interface.launch(
        share=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Creates a public link</span>
        server_name=<span class="hljs-string">&quot;0.0.0.0&quot;</span>,  <span class="hljs-comment"># Allow external access</span>
        server_port=<span class="hljs-number">7860</span>,  <span class="hljs-comment"># Default Gradio port</span>
        show_error=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Show errors in the interface</span>
    )`,wrap:!1}}),ll=new I({props:{code:"cHl0aG9uJTIwbWFpbi5weQ==",highlighted:"python main.py",wrap:!1}}),tl=new h({props:{title:"Complete Working Code",local:"complete-working-code",headingTag:"h2"}}),sl=new I({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> io

<span class="hljs-comment"># Initialize the client</span>
client = InferenceClient(
    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,
    api_key=os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>],
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">edit_image</span>(<span class="hljs-params">input_image, prompt</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Edit an image using the given prompt.
    
    Args:
        input_image: PIL Image object from Gradio
        prompt: String prompt for image editing
    
    Returns:
        PIL Image object (edited image)
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> input_image <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>
    
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> prompt <span class="hljs-keyword">or</span> prompt.strip() == <span class="hljs-string">&quot;&quot;</span>:
        <span class="hljs-keyword">return</span> input_image
    
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Convert PIL Image to bytes</span>
        img_bytes = io.BytesIO()
        input_image.save(img_bytes, <span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;PNG&quot;</span>)
        img_bytes = img_bytes.getvalue()
        
        <span class="hljs-comment"># Use the image_to_image method</span>
        edited_image = client.image_to_image(
            img_bytes,
            prompt=prompt.strip(),
            model=<span class="hljs-string">&quot;Qwen/Qwen-Image-Edit&quot;</span>,
        )
        
        <span class="hljs-keyword">return</span> edited_image
    
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Error editing image: <span class="hljs-subst">{e}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> input_image

<span class="hljs-comment"># Create Gradio interface</span>
<span class="hljs-keyword">with</span> gr.Blocks(title=<span class="hljs-string">&quot;Image Editor&quot;</span>, theme=gr.themes.Soft()) <span class="hljs-keyword">as</span> interface:
    gr.Markdown(
        <span class="hljs-string">&quot;&quot;&quot;
        # 🎨 AI Image Editor
        Upload an image and describe how you want to edit it using natural language!
        &quot;&quot;&quot;</span>
    )

    <span class="hljs-keyword">with</span> gr.Row():
        <span class="hljs-keyword">with</span> gr.Column():
            input_image = gr.Image(label=<span class="hljs-string">&quot;Upload Image&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;pil&quot;</span>, height=<span class="hljs-number">400</span>)
            prompt = gr.Textbox(
                label=<span class="hljs-string">&quot;Edit Prompt&quot;</span>,
                placeholder=<span class="hljs-string">&quot;Describe how you want to edit the image...&quot;</span>,
                lines=<span class="hljs-number">2</span>,
            )
            edit_btn = gr.Button(<span class="hljs-string">&quot;✨ Edit Image&quot;</span>, variant=<span class="hljs-string">&quot;primary&quot;</span>, size=<span class="hljs-string">&quot;lg&quot;</span>)

        <span class="hljs-keyword">with</span> gr.Column():
            output_image = gr.Image(label=<span class="hljs-string">&quot;Edited Image&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;pil&quot;</span>, height=<span class="hljs-number">400</span>)

    <span class="hljs-comment"># Example images and prompts</span>
    <span class="hljs-keyword">with</span> gr.Row():
        gr.Examples(
            examples=[
                [<span class="hljs-string">&quot;cat.png&quot;</span>, <span class="hljs-string">&quot;Turn the cat into a tiger&quot;</span>],
                [<span class="hljs-string">&quot;cat.png&quot;</span>, <span class="hljs-string">&quot;Make it look like a watercolor painting&quot;</span>],
                [<span class="hljs-string">&quot;cat.png&quot;</span>, <span class="hljs-string">&quot;Change the background to a forest&quot;</span>],
            ],
            inputs=[input_image, prompt],
            outputs=output_image,
            fn=edit_image,
            cache_examples=<span class="hljs-literal">False</span>,
        )

    <span class="hljs-comment"># Event handlers</span>
    edit_btn.click(fn=edit_image, inputs=[input_image, prompt], outputs=output_image)

    <span class="hljs-comment"># Allow Enter key to trigger editing</span>
    prompt.submit(fn=edit_image, inputs=[input_image, prompt], outputs=output_image)

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    interface.launch(
        share=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Creates a public link</span>
        server_name=<span class="hljs-string">&quot;0.0.0.0&quot;</span>,  <span class="hljs-comment"># Allow external access</span>
        server_port=<span class="hljs-number">7860</span>,  <span class="hljs-comment"># Default Gradio port</span>
        show_error=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Show errors in the interface</span>
    )`,wrap:!1}}),Ml=new h({props:{title:"Deploy on Hugging Face Spaces",local:"deploy-on-hugging-face-spaces",headingTag:"h2"}}),il=new I({props:{code:"dXYlMjBleHBvcnQlMjAtLWZvcm1hdCUyMHJlcXVpcmVtZW50cy10eHQlMjAtLW91dHB1dC1maWxlJTIwcmVxdWlyZW1lbnRzLnR4dA==",highlighted:'uv <span class="hljs-built_in">export</span> --format requirements-txt --output-file requirements.txt',wrap:!1}}),wl=new h({props:{title:"Next Steps",local:"next-steps",headingTag:"h1"}}),Ul=new ot({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/inference-providers/guides/image-editor.md"}}),{c(){r=n("meta"),gl=M(),Cl=n("p"),Al=M(),y(g.$$.fragment),Bl=M(),y(A.$$.fragment),bl=M(),B=n("p"),B.innerHTML=Ee,fl=M(),b=n("p"),b.textContent=Ze,El=M(),f=n("ol"),f.innerHTML=We,Zl=M(),m=n("blockquote"),m.innerHTML=ke,Wl=M(),y(E.$$.fragment),kl=M(),Z=n("p"),Z.textContent=Ge,Gl=M(),y(W.$$.fragment),vl=M(),c=n("blockquote"),c.innerHTML=ve,Ql=M(),k=n("p"),k.innerHTML=Qe,Xl=M(),y(G.$$.fragment),Rl=M(),v=n("p"),v.textContent=Xe,Sl=M(),y(Q.$$.fragment),$l=M(),X=n("p"),X.innerHTML=Re,Hl=M(),y(R.$$.fragment),Vl=M(),S=n("p"),S.innerHTML=Se,_l=M(),d=n("blockquote"),d.innerHTML=$e,ql=M(),y($.$$.fragment),xl=M(),H=n("p"),H.textContent=He,Fl=M(),V=n("p"),V.innerHTML=Ve,Yl=M(),y(_.$$.fragment),Nl=M(),q=n("p"),q.textContent=_e,zl=M(),y(x.$$.fragment),Ll=M(),U=n("blockquote"),ml=n("p"),ml.innerHTML=qe,Ae=M(),cl=n("p"),cl.textContent=xe,Be=M(),y(F.$$.fragment),Pl=M(),y(Y.$$.fragment),Dl=M(),N=n("p"),N.textContent=Fe,Kl=M(),y(z.$$.fragment),Ol=M(),L=n("p"),L.textContent=Ye,le=M(),P=n("ul"),P.innerHTML=Ne,ee=M(),D=n("p"),D.innerHTML=ze,te=M(),y(K.$$.fragment),se=M(),O=n("p"),O.textContent=Le,Me=M(),y(ll.$$.fragment),ae=M(),el=n("p"),el.innerHTML=Pe,ne=M(),y(tl.$$.fragment),ie=M(),u=n("details"),dl=n("summary"),dl.innerHTML=De,be=M(),y(sl.$$.fragment),pe=M(),y(Ml.$$.fragment),ye=M(),al=n("p"),al.textContent=Ke,Je=M(),nl=n("p"),nl.textContent=Oe,we=M(),y(il.$$.fragment),Te=M(),pl=n("p"),pl.innerHTML=lt,je=M(),C=n("blockquote"),C.innerHTML=et,oe=M(),yl=n("p"),yl.textContent=tt,Ue=M(),Jl=n("ol"),Jl.innerHTML=st,Ie=M(),y(wl.$$.fragment),re=M(),Tl=n("p"),Tl.textContent=Mt,me=M(),jl=n("ul"),jl.innerHTML=at,ce=M(),ol=n("p"),ol.textContent=nt,de=M(),y(Ul.$$.fragment),ue=M(),hl=n("p"),this.h()},l(l){const e=Tt("svelte-u9bgzb",document.head);r=i(e,"META",{name:!0,content:!0}),e.forEach(t),gl=a(l),Cl=i(l,"P",{}),ge(Cl).forEach(t),Al=a(l),J(g.$$.fragment,l),Bl=a(l),J(A.$$.fragment,l),bl=a(l),B=i(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1lwj79"&&(B.innerHTML=Ee),fl=a(l),b=i(l,"P",{"data-svelte-h":!0}),p(b)!=="svelte-5khb3j"&&(b.textContent=Ze),El=a(l),f=i(l,"OL",{"data-svelte-h":!0}),p(f)!=="svelte-1tdc6o3"&&(f.innerHTML=We),Zl=a(l),m=i(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(m)!=="svelte-1l3d161"&&(m.innerHTML=ke),Wl=a(l),J(E.$$.fragment,l),kl=a(l),Z=i(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-tq00s0"&&(Z.textContent=Ge),Gl=a(l),J(W.$$.fragment,l),vl=a(l),c=i(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(c)!=="svelte-122ax3a"&&(c.innerHTML=ve),Ql=a(l),k=i(l,"P",{"data-svelte-h":!0}),p(k)!=="svelte-7lseeu"&&(k.innerHTML=Qe),Xl=a(l),J(G.$$.fragment,l),Rl=a(l),v=i(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-10bv6uk"&&(v.textContent=Xe),Sl=a(l),J(Q.$$.fragment,l),$l=a(l),X=i(l,"P",{"data-svelte-h":!0}),p(X)!=="svelte-j4q1gw"&&(X.innerHTML=Re),Hl=a(l),J(R.$$.fragment,l),Vl=a(l),S=i(l,"P",{"data-svelte-h":!0}),p(S)!=="svelte-lfv1uk"&&(S.innerHTML=Se),_l=a(l),d=i(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(d)!=="svelte-18me5cu"&&(d.innerHTML=$e),ql=a(l),J($.$$.fragment,l),xl=a(l),H=i(l,"P",{"data-svelte-h":!0}),p(H)!=="svelte-gq6411"&&(H.textContent=He),Fl=a(l),V=i(l,"P",{"data-svelte-h":!0}),p(V)!=="svelte-lqetpu"&&(V.innerHTML=Ve),Yl=a(l),J(_.$$.fragment,l),Nl=a(l),q=i(l,"P",{"data-svelte-h":!0}),p(q)!=="svelte-pkwggc"&&(q.textContent=_e),zl=a(l),J(x.$$.fragment,l),Ll=a(l),U=i(l,"BLOCKQUOTE",{class:!0});var ul=ge(U);ml=i(ul,"P",{"data-svelte-h":!0}),p(ml)!=="svelte-1fognct"&&(ml.innerHTML=qe),Ae=a(ul),cl=i(ul,"P",{"data-svelte-h":!0}),p(cl)!=="svelte-1abjc87"&&(cl.textContent=xe),Be=a(ul),J(F.$$.fragment,ul),ul.forEach(t),Pl=a(l),J(Y.$$.fragment,l),Dl=a(l),N=i(l,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1ifovm8"&&(N.textContent=Fe),Kl=a(l),J(z.$$.fragment,l),Ol=a(l),L=i(l,"P",{"data-svelte-h":!0}),p(L)!=="svelte-p4zrwe"&&(L.textContent=Ye),le=a(l),P=i(l,"UL",{"data-svelte-h":!0}),p(P)!=="svelte-10pi7wb"&&(P.innerHTML=Ne),ee=a(l),D=i(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-3szit3"&&(D.innerHTML=ze),te=a(l),J(K.$$.fragment,l),se=a(l),O=i(l,"P",{"data-svelte-h":!0}),p(O)!=="svelte-d2kn7k"&&(O.textContent=Le),Me=a(l),J(ll.$$.fragment,l),ae=a(l),el=i(l,"P",{"data-svelte-h":!0}),p(el)!=="svelte-17a15t8"&&(el.innerHTML=Pe),ne=a(l),J(tl.$$.fragment,l),ie=a(l),u=i(l,"DETAILS",{});var he=ge(u);dl=i(he,"SUMMARY",{"data-svelte-h":!0}),p(dl)!=="svelte-n96not"&&(dl.innerHTML=De),be=a(he),J(sl.$$.fragment,he),he.forEach(t),pe=a(l),J(Ml.$$.fragment,l),ye=a(l),al=i(l,"P",{"data-svelte-h":!0}),p(al)!=="svelte-1spby4r"&&(al.textContent=Ke),Je=a(l),nl=i(l,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-xvxsbj"&&(nl.textContent=Oe),we=a(l),J(il.$$.fragment,l),Te=a(l),pl=i(l,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-ni8320"&&(pl.innerHTML=lt),je=a(l),C=i(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(C)!=="svelte-ry2ejn"&&(C.innerHTML=et),oe=a(l),yl=i(l,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-l20dtq"&&(yl.textContent=tt),Ue=a(l),Jl=i(l,"OL",{"data-svelte-h":!0}),p(Jl)!=="svelte-1pxk9y6"&&(Jl.innerHTML=st),Ie=a(l),J(wl.$$.fragment,l),re=a(l),Tl=i(l,"P",{"data-svelte-h":!0}),p(Tl)!=="svelte-1urmb67"&&(Tl.textContent=Mt),me=a(l),jl=i(l,"UL",{"data-svelte-h":!0}),p(jl)!=="svelte-g1f6dz"&&(jl.innerHTML=at),ce=a(l),ol=i(l,"P",{"data-svelte-h":!0}),p(ol)!=="svelte-1xr8bs4"&&(ol.textContent=nt),de=a(l),J(Ul.$$.fragment,l),ue=a(l),hl=i(l,"P",{}),ge(hl).forEach(t),this.h()},h(){Il(r,"name","hf:doc:metadata"),Il(r,"content",It),Il(m,"class","tip"),Il(c,"class","tip"),Il(d,"class","tip"),Il(U,"class","tip"),Il(C,"class","tip")},m(l,e){rl(document.head,r),s(l,gl,e),s(l,Cl,e),s(l,Al,e),w(g,l,e),s(l,Bl,e),w(A,l,e),s(l,bl,e),s(l,B,e),s(l,fl,e),s(l,b,e),s(l,El,e),s(l,f,e),s(l,Zl,e),s(l,m,e),s(l,Wl,e),w(E,l,e),s(l,kl,e),s(l,Z,e),s(l,Gl,e),w(W,l,e),s(l,vl,e),s(l,c,e),s(l,Ql,e),s(l,k,e),s(l,Xl,e),w(G,l,e),s(l,Rl,e),s(l,v,e),s(l,Sl,e),w(Q,l,e),s(l,$l,e),s(l,X,e),s(l,Hl,e),w(R,l,e),s(l,Vl,e),s(l,S,e),s(l,_l,e),s(l,d,e),s(l,ql,e),w($,l,e),s(l,xl,e),s(l,H,e),s(l,Fl,e),s(l,V,e),s(l,Yl,e),w(_,l,e),s(l,Nl,e),s(l,q,e),s(l,zl,e),w(x,l,e),s(l,Ll,e),s(l,U,e),rl(U,ml),rl(U,Ae),rl(U,cl),rl(U,Be),w(F,U,null),s(l,Pl,e),w(Y,l,e),s(l,Dl,e),s(l,N,e),s(l,Kl,e),w(z,l,e),s(l,Ol,e),s(l,L,e),s(l,le,e),s(l,P,e),s(l,ee,e),s(l,D,e),s(l,te,e),w(K,l,e),s(l,se,e),s(l,O,e),s(l,Me,e),w(ll,l,e),s(l,ae,e),s(l,el,e),s(l,ne,e),w(tl,l,e),s(l,ie,e),s(l,u,e),rl(u,dl),rl(u,be),w(sl,u,null),s(l,pe,e),w(Ml,l,e),s(l,ye,e),s(l,al,e),s(l,Je,e),s(l,nl,e),s(l,we,e),w(il,l,e),s(l,Te,e),s(l,pl,e),s(l,je,e),s(l,C,e),s(l,oe,e),s(l,yl,e),s(l,Ue,e),s(l,Jl,e),s(l,Ie,e),w(wl,l,e),s(l,re,e),s(l,Tl,e),s(l,me,e),s(l,jl,e),s(l,ce,e),s(l,ol,e),s(l,de,e),w(Ul,l,e),s(l,ue,e),s(l,hl,e),Ce=!0},p:pt,i(l){Ce||(T(g.$$.fragment,l),T(A.$$.fragment,l),T(E.$$.fragment,l),T(W.$$.fragment,l),T(G.$$.fragment,l),T(Q.$$.fragment,l),T(R.$$.fragment,l),T($.$$.fragment,l),T(_.$$.fragment,l),T(x.$$.fragment,l),T(F.$$.fragment,l),T(Y.$$.fragment,l),T(z.$$.fragment,l),T(K.$$.fragment,l),T(ll.$$.fragment,l),T(tl.$$.fragment,l),T(sl.$$.fragment,l),T(Ml.$$.fragment,l),T(il.$$.fragment,l),T(wl.$$.fragment,l),T(Ul.$$.fragment,l),Ce=!0)},o(l){j(g.$$.fragment,l),j(A.$$.fragment,l),j(E.$$.fragment,l),j(W.$$.fragment,l),j(G.$$.fragment,l),j(Q.$$.fragment,l),j(R.$$.fragment,l),j($.$$.fragment,l),j(_.$$.fragment,l),j(x.$$.fragment,l),j(F.$$.fragment,l),j(Y.$$.fragment,l),j(z.$$.fragment,l),j(K.$$.fragment,l),j(ll.$$.fragment,l),j(tl.$$.fragment,l),j(sl.$$.fragment,l),j(Ml.$$.fragment,l),j(il.$$.fragment,l),j(wl.$$.fragment,l),j(Ul.$$.fragment,l),Ce=!1},d(l){l&&(t(gl),t(Cl),t(Al),t(Bl),t(bl),t(B),t(fl),t(b),t(El),t(f),t(Zl),t(m),t(Wl),t(kl),t(Z),t(Gl),t(vl),t(c),t(Ql),t(k),t(Xl),t(Rl),t(v),t(Sl),t($l),t(X),t(Hl),t(Vl),t(S),t(_l),t(d),t(ql),t(xl),t(H),t(Fl),t(V),t(Yl),t(Nl),t(q),t(zl),t(Ll),t(U),t(Pl),t(Dl),t(N),t(Kl),t(Ol),t(L),t(le),t(P),t(ee),t(D),t(te),t(se),t(O),t(Me),t(ae),t(el),t(ne),t(ie),t(u),t(pe),t(ye),t(al),t(Je),t(nl),t(we),t(Te),t(pl),t(je),t(C),t(oe),t(yl),t(Ue),t(Jl),t(Ie),t(re),t(Tl),t(me),t(jl),t(ce),t(ol),t(de),t(ue),t(hl)),t(r),o(g,l),o(A,l),o(E,l),o(W,l),o(G,l),o(Q,l),o(R,l),o($,l),o(_,l),o(x,l),o(F),o(Y,l),o(z,l),o(K,l),o(ll,l),o(tl,l),o(sl),o(Ml,l),o(il,l),o(wl,l),o(Ul,l)}}}const It='{"title":"Building an AI Image Editor with Gradio and Inference Providers","local":"building-an-ai-image-editor-with-gradio-and-inference-providers","sections":[{"title":"Step 1: Set Up Authentication","local":"step-1-set-up-authentication","sections":[],"depth":2},{"title":"Step 2: Project Setup","local":"step-2-project-setup","sections":[],"depth":2},{"title":"Step 3: Build the Core Image Editing Function","local":"step-3-build-the-core-image-editing-function","sections":[],"depth":2},{"title":"Step 4: Create the Gradio Interface","local":"step-4-create-the-gradio-interface","sections":[],"depth":2},{"title":"Complete Working Code","local":"complete-working-code","sections":[],"depth":2},{"title":"Deploy on Hugging Face Spaces","local":"deploy-on-hugging-face-spaces","sections":[],"depth":2}],"depth":1}';function rt(fe){return yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ht extends Jt{constructor(r){super(),wt(this,r,rt,Ut,it,{})}}export{ht as component};
