import{s as de,n as we,o as ue}from"../chunks/scheduler.85c25b89.js";import{S as je,i as ge,g as a,s as o,u as c,A as Te,h as n,f as e,c as p,j as h,v as M,y as m,k as i,o as r,a as l,w as y,d as J,t as d,x as w}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function fe(Xt){let u,ht,st,mt,j,U,lt,x,Qt,D,zt="Inception v3",ct,Z,Ht='<strong>Inception v3</strong> is a convolutional neural network architecture from the Inception family that makes several improvements including using <a href="https://paperswithcode.com/method/label-smoothing" rel="nofollow">Label Smoothing</a>, Factorized 7 x 7 convolutions, and the use of an <a href="https://paperswithcode.com/method/auxiliary-classifier" rel="nofollow">auxiliary classifer</a> to propagate label information lower down the network (along with the use of batch normalization for layers in the sidehead). The key building block is an <a href="https://paperswithcode.com/method/inception-v3-module" rel="nofollow">Inception Module</a>.',Mt,g,v,at,N,Vt,q,Ft="How do I use this model on an image?",yt,A,Pt="To load a pretrained model:",Jt,E,dt,B,Lt="To load and preprocess the image:",wt,$,ut,G,Dt="To get the model predictions:",jt,W,gt,_,qt="To get the top-5 predictions class names:",Tt,Q,ft,V,Kt="Replace the model name with the variant you want to use, e.g. <code>inception_v3</code>. You can find the IDs in the model summaries at the top of this page.",bt,S,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',Ut,T,C,nt,R,St,K,te="How do I finetune this model?",vt,Y,ee="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Ct,X,It,z,se=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,kt,f,I,ot,H,Rt,O,le="How do I train this model?",xt,F,ae='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Zt,b,k,pt,P,Yt,tt,ne="Citation",Nt,L,At,it,Et;return x=new rt({}),N=new rt({}),E=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2luY2VwdGlvbl92MyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;inception_v3&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),$=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),W=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),Q=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),R=new rt({}),X=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnaW5jZXB0aW9uX3YzJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;inception_v3&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),H=new rt({}),P=new rt({}),L=new et({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZTemVnZWR5VklTVzE1JTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCQ2hyaXN0aWFuJTIwU3plZ2VkeSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFZpbmNlbnQlMjBWYW5ob3Vja2UlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTZXJnZXklMjBJb2ZmZSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEpvbmF0aG9uJTIwU2hsZW5zJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwWmJpZ25pZXclMjBXb2puYSU3RCUyQyUwQSUyMCUyMHRpdGxlJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCUmV0aGlua2luZyUyMHRoZSUyMEluY2VwdGlvbiUyMEFyY2hpdGVjdHVyZSUyMGZvciUyMENvbXB1dGVyJTIwVmlzaW9uJTdEJTJDJTBBJTIwJTIwam91cm5hbCUyMCUyMCUyMCUzRCUyMCU3QkNvUlIlN0QlMkMlMEElMjAlMjB2b2x1bWUlMjAlMjAlMjAlMjAlM0QlMjAlN0JhYnMlMkYxNTEyLjAwNTY3JTdEJTJDJTBBJTIwJTIweWVhciUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QjIwMTUlN0QlMkMlMEElMjAlMjB1cmwlMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwJTNBJTJGJTJGYXJ4aXYub3JnJTJGYWJzJTJGMTUxMi4wMDU2NyU3RCUyQyUwQSUyMCUyMGFyY2hpdmVQcmVmaXglMjAlM0QlMjAlN0JhclhpdiU3RCUyQyUwQSUyMCUyMGVwcmludCUyMCUyMCUyMCUyMCUzRCUyMCU3QjE1MTIuMDA1NjclN0QlMkMlMEElMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjAlN0JNb24lMkMlMjAxMyUyMEF1ZyUyMDIwMTglMjAxNiUzQTQ5JTNBMDclMjAlMkIwMjAwJTdEJTJDJTBBJTIwJTIwYmlidXJsJTIwJTIwJTIwJTIwJTNEJTIwJTdCaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyUyRnJlYyUyRmpvdXJuYWxzJTJGY29yciUyRlN6ZWdlZHlWSVNXMTUuYmliJTdEJTJDJTBBJTIwJTIwYmlic291cmNlJTIwJTNEJTIwJTdCZGJscCUyMGNvbXB1dGVyJTIwc2NpZW5jZSUyMGJpYmxpb2dyYXBoeSUyQyUyMGh0dHBzJTNBJTJGJTJGZGJscC5vcmclN0QlMEElN0Q=",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>SzegedyVISW15,
  author    = {Christian Szegedy and
               Vincent Vanhoucke and
               Sergey Ioffe and
               Jonathon Shlens and
               Zbigniew Wojna},
  title     = {Rethinking the Inception Architecture <span class="hljs-keyword">for</span> Computer Vision},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1512.00567</span>},
  year      = {<span class="hljs-number">2015</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1512.00567</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1512.00567</span>},
  timestamp = {Mon, <span class="hljs-number">13</span> Aug <span class="hljs-number">2018</span> <span class="hljs-number">16</span>:<span class="hljs-number">49</span>:<span class="hljs-number">07</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>SzegedyVISW15.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`}}),{c(){u=a("meta"),ht=o(),st=a("p"),mt=o(),j=a("h1"),U=a("a"),lt=a("span"),c(x.$$.fragment),Qt=o(),D=a("span"),D.textContent=zt,ct=o(),Z=a("p"),Z.innerHTML=Ht,Mt=o(),g=a("h2"),v=a("a"),at=a("span"),c(N.$$.fragment),Vt=o(),q=a("span"),q.textContent=Ft,yt=o(),A=a("p"),A.textContent=Pt,Jt=o(),c(E.$$.fragment),dt=o(),B=a("p"),B.textContent=Lt,wt=o(),c($.$$.fragment),ut=o(),G=a("p"),G.textContent=Dt,jt=o(),c(W.$$.fragment),gt=o(),_=a("p"),_.textContent=qt,Tt=o(),c(Q.$$.fragment),ft=o(),V=a("p"),V.innerHTML=Kt,bt=o(),S=a("p"),S.innerHTML=Ot,Ut=o(),T=a("h2"),C=a("a"),nt=a("span"),c(R.$$.fragment),St=o(),K=a("span"),K.textContent=te,vt=o(),Y=a("p"),Y.textContent=ee,Ct=o(),c(X.$$.fragment),It=o(),z=a("p"),z.innerHTML=se,kt=o(),f=a("h2"),I=a("a"),ot=a("span"),c(H.$$.fragment),Rt=o(),O=a("span"),O.textContent=le,xt=o(),F=a("p"),F.innerHTML=ae,Zt=o(),b=a("h2"),k=a("a"),pt=a("span"),c(P.$$.fragment),Yt=o(),tt=a("span"),tt.textContent=ne,Nt=o(),c(L.$$.fragment),At=o(),it=a("p"),this.h()},l(t){const s=Te("svelte-1phssyn",document.head);u=n(s,"META",{name:!0,content:!0}),s.forEach(e),ht=p(t),st=n(t,"P",{}),h(st).forEach(e),mt=p(t),j=n(t,"H1",{class:!0});var Bt=h(j);U=n(Bt,"A",{id:!0,class:!0,href:!0});var oe=h(U);lt=n(oe,"SPAN",{});var pe=h(lt);M(x.$$.fragment,pe),pe.forEach(e),oe.forEach(e),Qt=p(Bt),D=n(Bt,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-1fe6433"&&(D.textContent=zt),Bt.forEach(e),ct=p(t),Z=n(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1q7bbkg"&&(Z.innerHTML=Ht),Mt=p(t),g=n(t,"H2",{class:!0});var $t=h(g);v=n($t,"A",{id:!0,class:!0,href:!0});var ie=h(v);at=n(ie,"SPAN",{});var re=h(at);M(N.$$.fragment,re),re.forEach(e),ie.forEach(e),Vt=p($t),q=n($t,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-1c1hspn"&&(q.textContent=Ft),$t.forEach(e),yt=p(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-18ywhxh"&&(A.textContent=Pt),Jt=p(t),M(E.$$.fragment,t),dt=p(t),B=n(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1c2ipa8"&&(B.textContent=Lt),wt=p(t),M($.$$.fragment,t),ut=p(t),G=n(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1n9qsq1"&&(G.textContent=Dt),jt=p(t),M(W.$$.fragment,t),gt=p(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-19cnvx1"&&(_.textContent=qt),Tt=p(t),M(Q.$$.fragment,t),ft=p(t),V=n(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-fzq2q9"&&(V.innerHTML=Kt),bt=p(t),S=n(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1wmi3ea"&&(S.innerHTML=Ot),Ut=p(t),T=n(t,"H2",{class:!0});var Gt=h(T);C=n(Gt,"A",{id:!0,class:!0,href:!0});var he=h(C);nt=n(he,"SPAN",{});var me=h(nt);M(R.$$.fragment,me),me.forEach(e),he.forEach(e),St=p(Gt),K=n(Gt,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=te),Gt.forEach(e),vt=p(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-9sr7nh"&&(Y.textContent=ee),Ct=p(t),M(X.$$.fragment,t),It=p(t),z=n(t,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1kguc51"&&(z.innerHTML=se),kt=p(t),f=n(t,"H2",{class:!0});var Wt=h(f);I=n(Wt,"A",{id:!0,class:!0,href:!0});var ce=h(I);ot=n(ce,"SPAN",{});var Me=h(ot);M(H.$$.fragment,Me),Me.forEach(e),ce.forEach(e),Rt=p(Wt),O=n(Wt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=le),Wt.forEach(e),xt=p(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1n0coha"&&(F.innerHTML=ae),Zt=p(t),b=n(t,"H2",{class:!0});var _t=h(b);k=n(_t,"A",{id:!0,class:!0,href:!0});var ye=h(k);pt=n(ye,"SPAN",{});var Je=h(pt);M(P.$$.fragment,Je),Je.forEach(e),ye.forEach(e),Yt=p(_t),tt=n(_t,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ne),_t.forEach(e),Nt=p(t),M(L.$$.fragment,t),At=p(t),it=n(t,"P",{}),h(it).forEach(e),this.h()},h(){i(u,"name","hf:doc:metadata"),i(u,"content",JSON.stringify(be)),i(U,"id","inception-v3"),i(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(U,"href","#inception-v3"),i(j,"class","relative group"),i(v,"id","how-do-i-use-this-model-on-an-image"),i(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(v,"href","#how-do-i-use-this-model-on-an-image"),i(g,"class","relative group"),i(C,"id","how-do-i-finetune-this-model"),i(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(C,"href","#how-do-i-finetune-this-model"),i(T,"class","relative group"),i(I,"id","how-do-i-train-this-model"),i(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(I,"href","#how-do-i-train-this-model"),i(f,"class","relative group"),i(k,"id","citation"),i(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(k,"href","#citation"),i(b,"class","relative group")},m(t,s){r(document.head,u),l(t,ht,s),l(t,st,s),l(t,mt,s),l(t,j,s),r(j,U),r(U,lt),y(x,lt,null),r(j,Qt),r(j,D),l(t,ct,s),l(t,Z,s),l(t,Mt,s),l(t,g,s),r(g,v),r(v,at),y(N,at,null),r(g,Vt),r(g,q),l(t,yt,s),l(t,A,s),l(t,Jt,s),y(E,t,s),l(t,dt,s),l(t,B,s),l(t,wt,s),y($,t,s),l(t,ut,s),l(t,G,s),l(t,jt,s),y(W,t,s),l(t,gt,s),l(t,_,s),l(t,Tt,s),y(Q,t,s),l(t,ft,s),l(t,V,s),l(t,bt,s),l(t,S,s),l(t,Ut,s),l(t,T,s),r(T,C),r(C,nt),y(R,nt,null),r(T,St),r(T,K),l(t,vt,s),l(t,Y,s),l(t,Ct,s),y(X,t,s),l(t,It,s),l(t,z,s),l(t,kt,s),l(t,f,s),r(f,I),r(I,ot),y(H,ot,null),r(f,Rt),r(f,O),l(t,xt,s),l(t,F,s),l(t,Zt,s),l(t,b,s),r(b,k),r(k,pt),y(P,pt,null),r(b,Yt),r(b,tt),l(t,Nt,s),y(L,t,s),l(t,At,s),l(t,it,s),Et=!0},p:we,i(t){Et||(J(x.$$.fragment,t),J(N.$$.fragment,t),J(E.$$.fragment,t),J($.$$.fragment,t),J(W.$$.fragment,t),J(Q.$$.fragment,t),J(R.$$.fragment,t),J(X.$$.fragment,t),J(H.$$.fragment,t),J(P.$$.fragment,t),J(L.$$.fragment,t),Et=!0)},o(t){d(x.$$.fragment,t),d(N.$$.fragment,t),d(E.$$.fragment,t),d($.$$.fragment,t),d(W.$$.fragment,t),d(Q.$$.fragment,t),d(R.$$.fragment,t),d(X.$$.fragment,t),d(H.$$.fragment,t),d(P.$$.fragment,t),d(L.$$.fragment,t),Et=!1},d(t){t&&(e(ht),e(st),e(mt),e(j),e(ct),e(Z),e(Mt),e(g),e(yt),e(A),e(Jt),e(dt),e(B),e(wt),e(ut),e(G),e(jt),e(gt),e(_),e(Tt),e(ft),e(V),e(bt),e(S),e(Ut),e(T),e(vt),e(Y),e(Ct),e(It),e(z),e(kt),e(f),e(xt),e(F),e(Zt),e(b),e(Nt),e(At),e(it)),e(u),w(x),w(N),w(E,t),w($,t),w(W,t),w(Q,t),w(R),w(X,t),w(H),w(P),w(L,t)}}}const be={local:"inception-v3",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"Inception v3"};function Ue(Xt){return ue(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xe extends je{constructor(u){super(),ge(this,u,Ue,fe,de,{})}}export{xe as component};
