import{s as ps,o as ms,n as R}from"../chunks/scheduler.18a86fab.js";import{S as hs,i as us,g as c,s as a,r as u,A as fs,h as p,f as s,c as r,j as v,u as f,x as h,k as $,y as i,a as d,v as g,d as _,t as b,w as y}from"../chunks/index.98837b22.js";import{T as Ln}from"../chunks/Tip.77304350.js";import{D as J}from"../chunks/Docstring.6758ea23.js";import{C as ee}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as ye}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as L}from"../chunks/Heading.7e7e0c5b.js";import{E as gs}from"../chunks/index.499f366c.js";function _s(C){let n,T="Example:",l,m,M;return m=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENhbmluZUNvbmZpZyUyQyUyMENhbmluZU1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMENBTklORSUyMGdvb2dsZSUyRmNhbmluZS1zJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMENhbmluZUNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBnb29nbGUlMkZjYW5pbmUtcyUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwQ2FuaW5lTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CanineConfig, CanineModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CANINE google/canine-s style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = CanineConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the google/canine-s style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CanineModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=c("p"),n.textContent=T,l=a(),u(m.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),h(n)!=="svelte-11lpom8"&&(n.textContent=T),l=r(t),f(m.$$.fragment,t)},m(t,w){d(t,n,w),d(t,l,w),g(m,t,w),M=!0},p:R,i(t){M||(_(m.$$.fragment,t),M=!0)},o(t){b(m.$$.fragment,t),M=!1},d(t){t&&(s(n),s(l)),y(m,t)}}}function bs(C){let n,T="sequence pair mask has the following format:",l,m,M;return m=new ee({props:{code:"MCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMEElN0MlMjBmaXJzdCUyMHNlcXVlbmNlJTIwJTIwJTIwJTIwJTdDJTIwc2Vjb25kJTIwc2VxdWVuY2UlMjAlN0M=",highlighted:`0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1 1
| first sequence    | second sequence |`,wrap:!1}}),{c(){n=c("p"),n.textContent=T,l=a(),u(m.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),h(n)!=="svelte-16klr56"&&(n.textContent=T),l=r(t),f(m.$$.fragment,t)},m(t,w){d(t,n,w),d(t,l,w),g(m,t,w),M=!0},p:R,i(t){M||(_(m.$$.fragment,t),M=!0)},o(t){b(m.$$.fragment,t),M=!1},d(t){t&&(s(n),s(l)),y(m,t)}}}function ys(C){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=T},l(l){n=p(l,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(l,m){d(l,n,m)},p:R,d(l){l&&s(n)}}}function Ts(C){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=T},l(l){n=p(l,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(l,m){d(l,n,m)},p:R,d(l){l&&s(n)}}}function Ms(C){let n,T="Example of single-label classification:",l,m,M;return m=new ee({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMENhbmluZUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZjYW5pbmUtcyUyMiklMEFtb2RlbCUyMCUzRCUyMENhbmluZUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmNhbmluZS1zJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9jbGFzc19pZCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoKS5pdGVtKCklMEFtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfY2xhc3NfaWQlNUQlMEElMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBDYW5pbmVGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZjYW5pbmUtcyUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcyUwQXJvdW5kKGxvc3MuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CanineForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/canine-s&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CanineForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google/canine-s&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.id2label[predicted_class_id]
...

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CanineForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google/canine-s&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){n=c("p"),n.textContent=T,l=a(),u(m.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),h(n)!=="svelte-ykxpe4"&&(n.textContent=T),l=r(t),f(m.$$.fragment,t)},m(t,w){d(t,n,w),d(t,l,w),g(m,t,w),M=!0},p:R,i(t){M||(_(m.$$.fragment,t),M=!0)},o(t){b(m.$$.fragment,t),M=!1},d(t){t&&(s(n),s(l)),y(m,t)}}}function ws(C){let n,T="Example of multi-label classification:",l,m,M;return m=new ee({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMENhbmluZUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZjYW5pbmUtcyUyMiklMEFtb2RlbCUyMCUzRCUyMENhbmluZUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmNhbmluZS1zJTIyJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyYW5nZSgwJTJDJTIwbG9naXRzLnNoYXBlJTVCLTElNUQpJTVCdG9yY2guc2lnbW9pZChsb2dpdHMpLnNxdWVlemUoZGltJTNEMCklMjAlM0UlMjAwLjUlNUQlMEElMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBDYW5pbmVGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJnb29nbGUlMkZjYW5pbmUtcyUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CanineForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/canine-s&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CanineForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google/canine-s&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CanineForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;google/canine-s&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){n=c("p"),n.textContent=T,l=a(),u(m.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),h(n)!=="svelte-1l8e32d"&&(n.textContent=T),l=r(t),f(m.$$.fragment,t)},m(t,w){d(t,n,w),d(t,l,w),g(m,t,w),M=!0},p:R,i(t){M||(_(m.$$.fragment,t),M=!0)},o(t){b(m.$$.fragment,t),M=!1},d(t){t&&(s(n),s(l)),y(m,t)}}}function Cs(C){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=T},l(l){n=p(l,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(l,m){d(l,n,m)},p:R,d(l){l&&s(n)}}}function ks(C){let n,T="Example:",l,m,M;return m=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBDYW5pbmVGb3JNdWx0aXBsZUNob2ljZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGY2FuaW5lLXMlMjIpJTBBbW9kZWwlMjAlM0QlMjBDYW5pbmVGb3JNdWx0aXBsZUNob2ljZS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGY2FuaW5lLXMlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySW4lMjBJdGFseSUyQyUyMHBpenphJTIwc2VydmVkJTIwaW4lMjBmb3JtYWwlMjBzZXR0aW5ncyUyQyUyMHN1Y2glMjBhcyUyMGF0JTIwYSUyMHJlc3RhdXJhbnQlMkMlMjBpcyUyMHByZXNlbnRlZCUyMHVuc2xpY2VkLiUyMiUwQWNob2ljZTAlMjAlM0QlMjAlMjJJdCUyMGlzJTIwZWF0ZW4lMjB3aXRoJTIwYSUyMGZvcmslMjBhbmQlMjBhJTIwa25pZmUuJTIyJTBBY2hvaWNlMSUyMCUzRCUyMCUyMkl0JTIwaXMlMjBlYXRlbiUyMHdoaWxlJTIwaGVsZCUyMGluJTIwdGhlJTIwaGFuZC4lMjIlMEFsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoMCkudW5zcXVlZXplKDApJTIwJTIwJTIzJTIwY2hvaWNlMCUyMGlzJTIwY29ycmVjdCUyMChhY2NvcmRpbmclMjB0byUyMFdpa2lwZWRpYSUyMCUzQikpJTJDJTIwYmF0Y2glMjBzaXplJTIwMSUwQSUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyKCU1QnByb21wdCUyQyUyMHByb21wdCU1RCUyQyUyMCU1QmNob2ljZTAlMkMlMjBjaG9pY2UxJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKiU3QmslM0ElMjB2LnVuc3F1ZWV6ZSgwKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBlbmNvZGluZy5pdGVtcygpJTdEJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUyMCUyMCUyMyUyMGJhdGNoJTIwc2l6ZSUyMGlzJTIwMSUwQSUwQSUyMyUyMHRoZSUyMGxpbmVhciUyMGNsYXNzaWZpZXIlMjBzdGlsbCUyMG5lZWRzJTIwdG8lMjBiZSUyMHRyYWluZWQlMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CanineForMultipleChoice
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/canine-s&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CanineForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google/canine-s&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;In Italy, pizza served in formal settings, such as at a restaurant, is presented unsliced.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice0 = <span class="hljs-string">&quot;It is eaten with a fork and a knife.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice1 = <span class="hljs-string">&quot;It is eaten while held in the hand.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor(<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)  <span class="hljs-comment"># choice0 is correct (according to Wikipedia ;)), batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer([prompt, prompt], [choice0, choice1], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**{k: v.unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> encoding.items()}, labels=labels)  <span class="hljs-comment"># batch size is 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the linear classifier still needs to be trained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=c("p"),n.textContent=T,l=a(),u(m.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),h(n)!=="svelte-11lpom8"&&(n.textContent=T),l=r(t),f(m.$$.fragment,t)},m(t,w){d(t,n,w),d(t,l,w),g(m,t,w),M=!0},p:R,i(t){M||(_(m.$$.fragment,t),M=!0)},o(t){b(m.$$.fragment,t),M=!1},d(t){t&&(s(n),s(l)),y(m,t)}}}function $s(C){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=T},l(l){n=p(l,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(l,m){d(l,n,m)},p:R,d(l){l&&s(n)}}}function vs(C){let n,T="Example:",l,m,M;return m=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBDYW5pbmVGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZjYW5pbmUtcyUyMiklMEFtb2RlbCUyMCUzRCUyMENhbmluZUZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmNhbmluZS1zJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJIdWdnaW5nRmFjZSUyMGlzJTIwYSUyMGNvbXBhbnklMjBiYXNlZCUyMGluJTIwUGFyaXMlMjBhbmQlMjBOZXclMjBZb3JrJTIyJTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpJTBBJTBBJTIzJTIwTm90ZSUyMHRoYXQlMjB0b2tlbnMlMjBhcmUlMjBjbGFzc2lmaWVkJTIwcmF0aGVyJTIwdGhlbiUyMGlucHV0JTIwd29yZHMlMjB3aGljaCUyMG1lYW5zJTIwdGhhdCUwQSUyMyUyMHRoZXJlJTIwbWlnaHQlMjBiZSUyMG1vcmUlMjBwcmVkaWN0ZWQlMjB0b2tlbiUyMGNsYXNzZXMlMjB0aGFuJTIwd29yZHMuJTBBJTIzJTIwTXVsdGlwbGUlMjB0b2tlbiUyMGNsYXNzZXMlMjBtaWdodCUyMGFjY291bnQlMjBmb3IlMjB0aGUlMjBzYW1lJTIwd29yZCUwQXByZWRpY3RlZF90b2tlbnNfY2xhc3NlcyUyMCUzRCUyMCU1Qm1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnQuaXRlbSgpJTVEJTIwZm9yJTIwdCUyMGluJTIwcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyU1QjAlNUQlNUQlMEFwcmVkaWN0ZWRfdG9rZW5zX2NsYXNzZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CanineForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/canine-s&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CanineForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google/canine-s&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes`,wrap:!1}}),{c(){n=c("p"),n.textContent=T,l=a(),u(m.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),h(n)!=="svelte-11lpom8"&&(n.textContent=T),l=r(t),f(m.$$.fragment,t)},m(t,w){d(t,n,w),d(t,l,w),g(m,t,w),M=!0},p:R,i(t){M||(_(m.$$.fragment,t),M=!0)},o(t){b(m.$$.fragment,t),M=!1},d(t){t&&(s(n),s(l)),y(m,t)}}}function js(C){let n,T;return n=new ee({props:{code:"bGFiZWxzJTIwJTNEJTIwcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcyUwQXJvdW5kKGxvc3MuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)`,wrap:!1}}),{c(){u(n.$$.fragment)},l(l){f(n.$$.fragment,l)},m(l,m){g(n,l,m),T=!0},p:R,i(l){T||(_(n.$$.fragment,l),T=!0)},o(l){b(n.$$.fragment,l),T=!1},d(l){y(n,l)}}}function Js(C){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=T},l(l){n=p(l,"P",{"data-svelte-h":!0}),h(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(l,m){d(l,n,m)},p:R,d(l){l&&s(n)}}}function xs(C){let n,T="Example:",l,m,M;return m=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBDYW5pbmVGb3JRdWVzdGlvbkFuc3dlcmluZyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGY2FuaW5lLXMlMjIpJTBBbW9kZWwlMjAlM0QlMjBDYW5pbmVGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGY2FuaW5lLXMlMjIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWFuc3dlcl9zdGFydF9pbmRleCUyMCUzRCUyMG91dHB1dHMuc3RhcnRfbG9naXRzLmFyZ21heCgpJTBBYW5zd2VyX2VuZF9pbmRleCUyMCUzRCUyMG91dHB1dHMuZW5kX2xvZ2l0cy5hcmdtYXgoKSUwQSUwQXByZWRpY3RfYW5zd2VyX3Rva2VucyUyMCUzRCUyMGlucHV0cy5pbnB1dF9pZHMlNUIwJTJDJTIwYW5zd2VyX3N0YXJ0X2luZGV4JTIwJTNBJTIwYW5zd2VyX2VuZF9pbmRleCUyMCUyQiUyMDElNUQlMEF0b2tlbml6ZXIuZGVjb2RlKHByZWRpY3RfYW5zd2VyX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQSUwQSUyMyUyMHRhcmdldCUyMGlzJTIwJTIybmljZSUyMHB1cHBldCUyMiUwQXRhcmdldF9zdGFydF9pbmRleCUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxNCU1RCklMEF0YXJnZXRfZW5kX2luZGV4JTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjE1JTVEKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHN0YXJ0X3Bvc2l0aW9ucyUzRHRhcmdldF9zdGFydF9pbmRleCUyQyUyMGVuZF9wb3NpdGlvbnMlM0R0YXJnZXRfZW5kX2luZGV4KSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFyb3VuZChsb3NzLml0ZW0oKSUyQyUyMDIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CanineForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/canine-s&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CanineForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/canine-s&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = outputs.start_logits.argmax()
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = outputs.end_logits.argmax()

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = inputs.input_ids[<span class="hljs-number">0</span>, answer_start_index : answer_end_index + <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(predict_answer_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
...

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># target is &quot;nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_start_index = torch.tensor([<span class="hljs-number">14</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>target_end_index = torch.tensor([<span class="hljs-number">15</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=target_start_index, end_positions=target_end_index)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){n=c("p"),n.textContent=T,l=a(),u(m.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),h(n)!=="svelte-11lpom8"&&(n.textContent=T),l=r(t),f(m.$$.fragment,t)},m(t,w){d(t,n,w),d(t,l,w),g(m,t,w),M=!0},p:R,i(t){M||(_(m.$$.fragment,t),M=!0)},o(t){b(m.$$.fragment,t),M=!1},d(t){t&&(s(n),s(l)),y(m,t)}}}function Us(C){let n,T,l,m,M,t,w,Co='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Rn,Te,Xn,Me,ko=`The CANINE model was proposed in <a href="https://arxiv.org/abs/2103.06874" rel="nofollow">CANINE: Pre-training an Efficient Tokenization-Free Encoder for Language
Representation</a> by Jonathan H. Clark, Dan Garrette, Iulia Turc, John Wieting. It’s
among the first papers that trains a Transformer without using an explicit tokenization step (such as Byte Pair
Encoding (BPE), WordPiece or SentencePiece). Instead, the model is trained directly at a Unicode character-level.
Training at a character-level inevitably comes with a longer sequence length, which CANINE solves with an efficient
downsampling strategy, before applying a deep Transformer encoder.`,En,we,$o="The abstract from the paper is the following:",Sn,Ce,vo=`<em>Pipelined NLP systems have largely been superseded by end-to-end neural modeling, yet nearly all commonly-used models
still require an explicit tokenization step. While recent tokenization approaches based on data-derived subword
lexicons are less brittle than manually engineered tokenizers, these techniques are not equally suited to all
languages, and the use of any fixed vocabulary may limit a model’s ability to adapt. In this paper, we present CANINE,
a neural encoder that operates directly on character sequences, without explicit tokenization or vocabulary, and a
pre-training strategy that operates either directly on characters or optionally uses subwords as a soft inductive bias.
To use its finer-grained input effectively and efficiently, CANINE combines downsampling, which reduces the input
sequence length, with a deep transformer stack, which encodes context. CANINE outperforms a comparable mBERT model by
2.8 F1 on TyDi QA, a challenging multilingual benchmark, despite having 28% fewer model parameters.</em>`,Qn,ke,jo='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/google-research/language/tree/master/language/canine" rel="nofollow">here</a>.',Yn,$e,An,ve,Jo=`<li>CANINE uses no less than 3 Transformer encoders internally: 2 “shallow” encoders (which only consist of a single
layer) and 1 “deep” encoder (which is a regular BERT encoder). First, a “shallow” encoder is used to contextualize
the character embeddings, using local attention. Next, after downsampling, a “deep” encoder is applied. Finally,
after upsampling, a “shallow” encoder is used to create the final character embeddings. Details regarding up- and
downsampling can be found in the paper.</li> <li>CANINE uses a max sequence length of 2048 characters by default. One can use <a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineTokenizer">CanineTokenizer</a>
to prepare text for the model.</li> <li>Classification can be done by placing a linear layer on top of the final hidden state of the special [CLS] token
(which has a predefined Unicode code point). For token classification tasks however, the downsampled sequence of
tokens needs to be upsampled again to match the length of the original character sequence (which is 2048). The
details for this can be found in the paper.</li>`,Pn,je,xo="Model checkpoints:",Dn,Je,Uo=`<li><a href="https://huggingface.co/google/canine-c" rel="nofollow">google/canine-c</a>: Pre-trained with autoregressive character loss,
12-layer, 768-hidden, 12-heads, 121M parameters (size ~500 MB).</li> <li><a href="https://huggingface.co/google/canine-s" rel="nofollow">google/canine-s</a>: Pre-trained with subword loss, 12-layer,
768-hidden, 12-heads, 121M parameters (size ~500 MB).</li>`,On,xe,Kn,Ue,zo="CANINE works on raw characters, so it can be used <strong>without a tokenizer</strong>:",et,ze,nt,Ie,Io=`For batched inference and training, it is however recommended to make use of the tokenizer (to pad/truncate all
sequences to the same length):`,tt,Fe,ot,Ze,st,We,Fo='<li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/token_classification">Token classification task guide</a></li> <li><a href="../tasks/question_answering">Question answering task guide</a></li> <li><a href="../tasks/multiple_choice">Multiple choice task guide</a></li>',at,Ne,rt,N,Be,kt,cn,Zo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineModel">CanineModel</a>. It is used to instantiate an
CANINE model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the CANINE
<a href="https://huggingface.co/google/canine-s" rel="nofollow">google/canine-s</a> architecture.`,$t,pn,Wo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,vt,se,it,qe,lt,k,Ge,jt,mn,No=`Construct a CANINE tokenizer (i.e. a character splitter). It turns text into a sequence of characters, and then
converts each character into its Unicode code point.`,Jt,hn,Bo='<a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineTokenizer">CanineTokenizer</a> inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>.',xt,un,qo='Refer to superclass <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> for usage examples and documentation concerning parameters.',Ut,P,Ve,zt,fn,Go=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. A CANINE sequence has the following format:`,It,gn,Vo="<li>single sequence: <code>[CLS] X [SEP]</code></li> <li>pair of sequences: <code>[CLS] A [SEP] B [SEP]</code></li>",Ft,ae,He,Zt,_n,Ho=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,Wt,X,Le,Nt,bn,Lo="Create a mask from the two sequences passed to be used in a sequence-pair classification task. A CANINE",Bt,re,qt,yn,Ro="If <code>token_ids_1</code> is <code>None</code>, this method only returns the first portion of the mask (0s).",dt,Re,ct,ne,Xe,Gt,Tn,Xo=`Output type of <a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineModel">CanineModel</a>. Based on <a href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling">BaseModelOutputWithPooling</a>, but with slightly
different <code>hidden_states</code> and <code>attentions</code>, as these also include the hidden states and attentions of the shallow
Transformer encoders.`,pt,Ee,mt,x,Se,Vt,Mn,Eo="The bare Canine Model outputting raw hidden-states without any specific head on top.",Ht,wn,So=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Lt,Cn,Qo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Rt,D,Qe,Xt,kn,Yo='The <a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineModel">CanineModel</a> forward method, overrides the <code>__call__</code> special method.',Et,ie,ht,Ye,ut,U,Ae,St,$n,Ao=`CANINE Model transformer with a sequence classification/regression head on top (a linear layer on top of the pooled
output) e.g. for GLUE tasks.`,Qt,vn,Po=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Yt,jn,Do=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,At,Z,Pe,Pt,Jn,Oo='The <a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineForSequenceClassification">CanineForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Dt,le,Ot,de,Kt,ce,ft,De,gt,z,Oe,eo,xn,Ko=`The Canine Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks.`,no,Un,es=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,to,zn,ns=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,oo,E,Ke,so,In,ts='The <a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineForMultipleChoice">CanineForMultipleChoice</a> forward method, overrides the <code>__call__</code> special method.',ao,pe,ro,me,_t,en,bt,I,nn,io,Fn,os=`The Canine transformer with a token classification head on top (a linear layer on top of the hidden-states
output) e.g. for Named-Entity-Recognition (NER) tasks.`,lo,Zn,ss=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,co,Wn,as=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,po,W,tn,mo,Nn,rs='The <a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineForTokenClassification">CanineForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',ho,he,uo,ue,fo,fe,yt,on,Tt,F,sn,go,Bn,is=`The Canine transformer with a span classification head on top for extractive question-answering tasks like
SQuAD (a linear layer on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,_o,qn,ls=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,bo,Gn,ds=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,yo,S,an,To,Vn,cs='The <a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineForQuestionAnswering">CanineForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',Mo,ge,wo,_e,Mt,rn,wt,Hn,Ct;return M=new L({props:{title:"CANINE",local:"canine",headingTag:"h1"}}),Te=new L({props:{title:"Overview",local:"overview",headingTag:"h2"}}),$e=new L({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),xe=new L({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),ze=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENhbmluZU1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbCUyMCUzRCUyMENhbmluZU1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZjYW5pbmUtYyUyMiklMjAlMjAlMjMlMjBtb2RlbCUyMHByZS10cmFpbmVkJTIwd2l0aCUyMGF1dG9yZWdyZXNzaXZlJTIwY2hhcmFjdGVyJTIwbG9zcyUwQSUwQXRleHQlMjAlM0QlMjAlMjJoZWxsbyUyMHdvcmxkJTIyJTBBJTIzJTIwdXNlJTIwUHl0aG9uJ3MlMjBidWlsdC1pbiUyMG9yZCgpJTIwZnVuY3Rpb24lMjB0byUyMHR1cm4lMjBlYWNoJTIwY2hhcmFjdGVyJTIwaW50byUyMGl0cyUyMHVuaWNvZGUlMjBjb2RlJTIwcG9pbnQlMjBpZCUwQWlucHV0X2lkcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIlNUJvcmQoY2hhciklMjBmb3IlMjBjaGFyJTIwaW4lMjB0ZXh0JTVEJTVEKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMpJTIwJTIwJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEFwb29sZWRfb3V0cHV0JTIwJTNEJTIwb3V0cHV0cy5wb29sZXJfb3V0cHV0JTBBc2VxdWVuY2Vfb3V0cHV0JTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CanineModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = CanineModel.from_pretrained(<span class="hljs-string">&quot;google/canine-c&quot;</span>)  <span class="hljs-comment"># model pre-trained with autoregressive character loss</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use Python&#x27;s built-in ord() function to turn each character into its unicode code point id</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([[<span class="hljs-built_in">ord</span>(char) <span class="hljs-keyword">for</span> char <span class="hljs-keyword">in</span> text]])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids)  <span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_output = outputs.last_hidden_state`,wrap:!1}}),Fe=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENhbmluZVRva2VuaXplciUyQyUyMENhbmluZU1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBDYW5pbmVNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGY2FuaW5lLWMlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQ2FuaW5lVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZjYW5pbmUtYyUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjAlNUIlMjJMaWZlJTIwaXMlMjBsaWtlJTIwYSUyMGJveCUyMG9mJTIwY2hvY29sYXRlcy4lMjIlMkMlMjAlMjJZb3UlMjBuZXZlciUyMGtub3clMjB3aGF0JTIweW91JTIwZ29ubmElMjBnZXQuJTIyJTVEJTBBZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRzJTJDJTIwcGFkZGluZyUzRCUyMmxvbmdlc3QlMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqZW5jb2RpbmcpJTIwJTIwJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEFwb29sZWRfb3V0cHV0JTIwJTNEJTIwb3V0cHV0cy5wb29sZXJfb3V0cHV0JTBBc2VxdWVuY2Vfb3V0cHV0JTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CanineTokenizer, CanineModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = CanineModel.from_pretrained(<span class="hljs-string">&quot;google/canine-c&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = CanineTokenizer.from_pretrained(<span class="hljs-string">&quot;google/canine-c&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = [<span class="hljs-string">&quot;Life is like a box of chocolates.&quot;</span>, <span class="hljs-string">&quot;You never know what you gonna get.&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(inputs, padding=<span class="hljs-string">&quot;longest&quot;</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**encoding)  <span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_output = outputs.last_hidden_state`,wrap:!1}}),Ze=new L({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Ne=new L({props:{title:"CanineConfig",local:"transformers.CanineConfig",headingTag:"h2"}}),Be=new J({props:{name:"class transformers.CanineConfig",anchor:"transformers.CanineConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 16384"},{name:"type_vocab_size",val:" = 16"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 57344"},{name:"eos_token_id",val:" = 57345"},{name:"downsampling_rate",val:" = 4"},{name:"upsampling_kernel_size",val:" = 4"},{name:"num_hash_functions",val:" = 8"},{name:"num_hash_buckets",val:" = 16384"},{name:"local_transformer_stride",val:" = 128"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CanineConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimension of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.CanineConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the deep Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.CanineConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoders.`,name:"num_attention_heads"},{anchor:"transformers.CanineConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoders.`,name:"intermediate_size"},{anchor:"transformers.CanineConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.CanineConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoders, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.CanineConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.CanineConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.CanineConfig.type_vocab_size",description:`<strong>type_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The vocabulary size of the <code>token_type_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineModel">CanineModel</a>.`,name:"type_vocab_size"},{anchor:"transformers.CanineConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.CanineConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.CanineConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.CanineConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 57344) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.CanineConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 57345) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.CanineConfig.downsampling_rate",description:`<strong>downsampling_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The rate at which to downsample the original character sequence length before applying the deep Transformer
encoder.`,name:"downsampling_rate"},{anchor:"transformers.CanineConfig.upsampling_kernel_size",description:`<strong>upsampling_kernel_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The kernel size (i.e. the number of characters in each window) of the convolutional projection layer when
projecting back from <code>hidden_size</code>*2 to <code>hidden_size</code>.`,name:"upsampling_kernel_size"},{anchor:"transformers.CanineConfig.num_hash_functions",description:`<strong>num_hash_functions</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The number of hash functions to use. Each hash function has its own embedding matrix.`,name:"num_hash_functions"},{anchor:"transformers.CanineConfig.num_hash_buckets",description:`<strong>num_hash_buckets</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014;
The number of hash buckets to use.`,name:"num_hash_buckets"},{anchor:"transformers.CanineConfig.local_transformer_stride",description:`<strong>local_transformer_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The stride of the local attention of the first shallow Transformer encoder. Defaults to 128 for good
TPU/XLA memory alignment.`,name:"local_transformer_stride"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/canine/configuration_canine.py#L24"}}),se=new ye({props:{anchor:"transformers.CanineConfig.example",$$slots:{default:[_s]},$$scope:{ctx:C}}}),qe=new L({props:{title:"CanineTokenizer",local:"transformers.CanineTokenizer",headingTag:"h2"}}),Ge=new J({props:{name:"class transformers.CanineTokenizer",anchor:"transformers.CanineTokenizer",parameters:[{name:"bos_token",val:" = '\\ue000'"},{name:"eos_token",val:" = '\\ue001'"},{name:"sep_token",val:" = '\\ue001'"},{name:"cls_token",val:" = '\\ue000'"},{name:"pad_token",val:" = '\\x00'"},{name:"mask_token",val:" = '\\ue003'"},{name:"add_prefix_space",val:" = False"},{name:"model_max_length",val:" = 2048"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CanineTokenizer.model_max_length",description:`<strong>model_max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sentence length the model accepts.`,name:"model_max_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/canine/tokenization_canine.py#L58"}}),Ve=new J({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.CanineTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.CanineTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.CanineTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/canine/tokenization_canine.py#L153",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),He=new J({props:{name:"get_special_tokens_mask",anchor:"transformers.CanineTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.CanineTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.CanineTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.CanineTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/canine/tokenization_canine.py#L180",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Le=new J({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.CanineTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.CanineTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.CanineTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/canine/tokenization_canine.py#L208",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#token-type-ids">token type IDs</a> according to the given sequence(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),re=new ye({props:{anchor:"transformers.CanineTokenizer.create_token_type_ids_from_sequences.example",$$slots:{default:[bs]},$$scope:{ctx:C}}}),Re=new L({props:{title:"CANINE specific outputs",local:"transformers.models.canine.modeling_canine.CanineModelOutputWithPooling",headingTag:"h2"}}),Xe=new J({props:{name:"class transformers.models.canine.modeling_canine.CanineModelOutputWithPooling",anchor:"transformers.models.canine.modeling_canine.CanineModelOutputWithPooling",parameters:[{name:"last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooler_output",val:": typing.Optional[torch.FloatTensor] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.canine.modeling_canine.CanineModelOutputWithPooling.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model (i.e. the output of the final
shallow Transformer encoder).`,name:"last_hidden_state"},{anchor:"transformers.models.canine.modeling_canine.CanineModelOutputWithPooling.pooler_output",description:`<strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Hidden-state of the first token of the sequence (classification token) at the last layer of the deep
Transformer encoder, further processed by a Linear layer and a Tanh activation function. The Linear layer
weights are trained from the next sentence prediction (classification) objective during pretraining.`,name:"pooler_output"},{anchor:"transformers.models.canine.modeling_canine.CanineModelOutputWithPooling.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the input to each encoder + one for the output of each layer of each
encoder) of shape <code>(batch_size, sequence_length, hidden_size)</code> and <code>(batch_size, sequence_length // config.downsampling_rate, hidden_size)</code>. Hidden-states of the model at the output of each layer plus the
initial input to each Transformer encoder. The hidden states of the shallow encoders have length
<code>sequence_length</code>, but the hidden states of the deep encoder have length <code>sequence_length</code> //
<code>config.downsampling_rate</code>.`,name:"hidden_states"},{anchor:"transformers.models.canine.modeling_canine.CanineModelOutputWithPooling.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of the 3 Transformer encoders of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code> and <code>(batch_size, num_heads, sequence_length // config.downsampling_rate, sequence_length // config.downsampling_rate)</code>. Attentions weights after the
attention softmax, used to compute the weighted average in the self-attention heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/canine/modeling_canine.py#L50"}}),Ee=new L({props:{title:"CanineModel",local:"transformers.CanineModel",headingTag:"h2"}}),Se=new J({props:{name:"class transformers.CanineModel",anchor:"transformers.CanineModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"}],parametersDescription:[{anchor:"transformers.CanineModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineModel">CanineModel</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.CanineModel.add_pooling_layer",description:`<strong>add_pooling_layer</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a pooling layer`,name:"add_pooling_layer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/canine/modeling_canine.py#L898"}}),Qe=new J({props:{name:"forward",anchor:"transformers.CanineModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CanineModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CanineModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CanineModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.CanineModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CanineModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.CanineModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.CanineModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CanineModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CanineModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/canine/modeling_canine.py#L1011",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/canine#transformers.models.canine.modeling_canine.CanineModelOutputWithPooling"
>transformers.models.canine.modeling_canine.CanineModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/canine#transformers.CanineConfig"
>CanineConfig</a>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model (i.e. the output of the final
shallow Transformer encoder).</li>
<li><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Hidden-state of the first token of the sequence (classification token) at the last layer of the deep
Transformer encoder, further processed by a Linear layer and a Tanh activation function. The Linear layer
weights are trained from the next sentence prediction (classification) objective during pretraining.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the input to each encoder + one for the output of each layer of each
encoder) of shape <code>(batch_size, sequence_length, hidden_size)</code> and <code>(batch_size, sequence_length // config.downsampling_rate, hidden_size)</code>. Hidden-states of the model at the output of each layer plus the
initial input to each Transformer encoder. The hidden states of the shallow encoders have length
<code>sequence_length</code>, but the hidden states of the deep encoder have length <code>sequence_length</code> //
<code>config.downsampling_rate</code>.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of the 3 Transformer encoders of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code> and <code>(batch_size, num_heads, sequence_length // config.downsampling_rate, sequence_length // config.downsampling_rate)</code>. Attentions weights after the
attention softmax, used to compute the weighted average in the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/canine#transformers.models.canine.modeling_canine.CanineModelOutputWithPooling"
>transformers.models.canine.modeling_canine.CanineModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ie=new Ln({props:{$$slots:{default:[ys]},$$scope:{ctx:C}}}),Ye=new L({props:{title:"CanineForSequenceClassification",local:"transformers.CanineForSequenceClassification",headingTag:"h2"}}),Ae=new J({props:{name:"class transformers.CanineForSequenceClassification",anchor:"transformers.CanineForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.CanineForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineForSequenceClassification">CanineForSequenceClassification</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/canine/modeling_canine.py#L1171"}}),Pe=new J({props:{name:"forward",anchor:"transformers.CanineForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CanineForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CanineForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CanineForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.CanineForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CanineForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.CanineForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.CanineForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.CanineForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CanineForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CanineForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/canine/modeling_canine.py#L1189",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/canine#transformers.CanineConfig"
>CanineConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),le=new Ln({props:{$$slots:{default:[Ts]},$$scope:{ctx:C}}}),de=new ye({props:{anchor:"transformers.CanineForSequenceClassification.forward.example",$$slots:{default:[Ms]},$$scope:{ctx:C}}}),ce=new ye({props:{anchor:"transformers.CanineForSequenceClassification.forward.example-2",$$slots:{default:[ws]},$$scope:{ctx:C}}}),De=new L({props:{title:"CanineForMultipleChoice",local:"transformers.CanineForMultipleChoice",headingTag:"h2"}}),Oe=new J({props:{name:"class transformers.CanineForMultipleChoice",anchor:"transformers.CanineForMultipleChoice",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.CanineForMultipleChoice.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineForMultipleChoice">CanineForMultipleChoice</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/canine/modeling_canine.py#L1262"}}),Ke=new J({props:{name:"forward",anchor:"transformers.CanineForMultipleChoice.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CanineForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CanineForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CanineForMultipleChoice.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.CanineForMultipleChoice.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CanineForMultipleChoice.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.CanineForMultipleChoice.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.CanineForMultipleChoice.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the multiple choice classification loss. Indices should be in <code>[0, ..., num_choices-1]</code> where <code>num_choices</code> is the size of the second dimension of the input tensors. (See
<code>input_ids</code> above)`,name:"labels"},{anchor:"transformers.CanineForMultipleChoice.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CanineForMultipleChoice.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CanineForMultipleChoice.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/canine/modeling_canine.py#L1274",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.MultipleChoiceModelOutput"
>transformers.modeling_outputs.MultipleChoiceModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/canine#transformers.CanineConfig"
>CanineConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <em>(1,)</em>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices)</code>) — <em>num_choices</em> is the second dimension of the input tensors. (see <em>input_ids</em> above).</p>
<p>Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.MultipleChoiceModelOutput"
>transformers.modeling_outputs.MultipleChoiceModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),pe=new Ln({props:{$$slots:{default:[Cs]},$$scope:{ctx:C}}}),me=new ye({props:{anchor:"transformers.CanineForMultipleChoice.forward.example",$$slots:{default:[ks]},$$scope:{ctx:C}}}),en=new L({props:{title:"CanineForTokenClassification",local:"transformers.CanineForTokenClassification",headingTag:"h2"}}),nn=new J({props:{name:"class transformers.CanineForTokenClassification",anchor:"transformers.CanineForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.CanineForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineForTokenClassification">CanineForTokenClassification</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/canine/modeling_canine.py#L1366"}}),tn=new J({props:{name:"forward",anchor:"transformers.CanineForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CanineForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CanineForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CanineForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.CanineForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CanineForTokenClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.CanineForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.CanineForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the token classification loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"},{anchor:"transformers.CanineForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CanineForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CanineForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/canine/modeling_canine.py#L1379",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/canine#transformers.CanineConfig"
>CanineConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),he=new Ln({props:{$$slots:{default:[$s]},$$scope:{ctx:C}}}),ue=new ye({props:{anchor:"transformers.CanineForTokenClassification.forward.example",$$slots:{default:[vs]},$$scope:{ctx:C}}}),fe=new ye({props:{anchor:"transformers.CanineForTokenClassification.forward.example-2",$$slots:{default:[js]},$$scope:{ctx:C}}}),on=new L({props:{title:"CanineForQuestionAnswering",local:"transformers.CanineForQuestionAnswering",headingTag:"h2"}}),sn=new J({props:{name:"class transformers.CanineForQuestionAnswering",anchor:"transformers.CanineForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.CanineForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/canine#transformers.CanineForQuestionAnswering">CanineForQuestionAnswering</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/canine/modeling_canine.py#L1463"}}),an=new J({props:{name:"forward",anchor:"transformers.CanineForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"start_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"end_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CanineForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CanineForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CanineForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.CanineForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CanineForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.CanineForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.CanineForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.CanineForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"},{anchor:"transformers.CanineForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CanineForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CanineForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/canine/modeling_canine.py#L1475",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/canine#transformers.CanineConfig"
>CanineConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ge=new Ln({props:{$$slots:{default:[Js]},$$scope:{ctx:C}}}),_e=new ye({props:{anchor:"transformers.CanineForQuestionAnswering.forward.example",$$slots:{default:[xs]},$$scope:{ctx:C}}}),rn=new gs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/canine.md"}}),{c(){n=c("meta"),T=a(),l=c("p"),m=a(),u(M.$$.fragment),t=a(),w=c("div"),w.innerHTML=Co,Rn=a(),u(Te.$$.fragment),Xn=a(),Me=c("p"),Me.innerHTML=ko,En=a(),we=c("p"),we.textContent=$o,Sn=a(),Ce=c("p"),Ce.innerHTML=vo,Qn=a(),ke=c("p"),ke.innerHTML=jo,Yn=a(),u($e.$$.fragment),An=a(),ve=c("ul"),ve.innerHTML=Jo,Pn=a(),je=c("p"),je.textContent=xo,Dn=a(),Je=c("ul"),Je.innerHTML=Uo,On=a(),u(xe.$$.fragment),Kn=a(),Ue=c("p"),Ue.innerHTML=zo,et=a(),u(ze.$$.fragment),nt=a(),Ie=c("p"),Ie.textContent=Io,tt=a(),u(Fe.$$.fragment),ot=a(),u(Ze.$$.fragment),st=a(),We=c("ul"),We.innerHTML=Fo,at=a(),u(Ne.$$.fragment),rt=a(),N=c("div"),u(Be.$$.fragment),kt=a(),cn=c("p"),cn.innerHTML=Zo,$t=a(),pn=c("p"),pn.innerHTML=Wo,vt=a(),u(se.$$.fragment),it=a(),u(qe.$$.fragment),lt=a(),k=c("div"),u(Ge.$$.fragment),jt=a(),mn=c("p"),mn.textContent=No,Jt=a(),hn=c("p"),hn.innerHTML=Bo,xt=a(),un=c("p"),un.innerHTML=qo,Ut=a(),P=c("div"),u(Ve.$$.fragment),zt=a(),fn=c("p"),fn.textContent=Go,It=a(),gn=c("ul"),gn.innerHTML=Vo,Ft=a(),ae=c("div"),u(He.$$.fragment),Zt=a(),_n=c("p"),_n.innerHTML=Ho,Wt=a(),X=c("div"),u(Le.$$.fragment),Nt=a(),bn=c("p"),bn.textContent=Lo,Bt=a(),u(re.$$.fragment),qt=a(),yn=c("p"),yn.innerHTML=Ro,dt=a(),u(Re.$$.fragment),ct=a(),ne=c("div"),u(Xe.$$.fragment),Gt=a(),Tn=c("p"),Tn.innerHTML=Xo,pt=a(),u(Ee.$$.fragment),mt=a(),x=c("div"),u(Se.$$.fragment),Vt=a(),Mn=c("p"),Mn.textContent=Eo,Ht=a(),wn=c("p"),wn.innerHTML=So,Lt=a(),Cn=c("p"),Cn.innerHTML=Qo,Rt=a(),D=c("div"),u(Qe.$$.fragment),Xt=a(),kn=c("p"),kn.innerHTML=Yo,Et=a(),u(ie.$$.fragment),ht=a(),u(Ye.$$.fragment),ut=a(),U=c("div"),u(Ae.$$.fragment),St=a(),$n=c("p"),$n.textContent=Ao,Qt=a(),vn=c("p"),vn.innerHTML=Po,Yt=a(),jn=c("p"),jn.innerHTML=Do,At=a(),Z=c("div"),u(Pe.$$.fragment),Pt=a(),Jn=c("p"),Jn.innerHTML=Oo,Dt=a(),u(le.$$.fragment),Ot=a(),u(de.$$.fragment),Kt=a(),u(ce.$$.fragment),ft=a(),u(De.$$.fragment),gt=a(),z=c("div"),u(Oe.$$.fragment),eo=a(),xn=c("p"),xn.textContent=Ko,no=a(),Un=c("p"),Un.innerHTML=es,to=a(),zn=c("p"),zn.innerHTML=ns,oo=a(),E=c("div"),u(Ke.$$.fragment),so=a(),In=c("p"),In.innerHTML=ts,ao=a(),u(pe.$$.fragment),ro=a(),u(me.$$.fragment),_t=a(),u(en.$$.fragment),bt=a(),I=c("div"),u(nn.$$.fragment),io=a(),Fn=c("p"),Fn.textContent=os,lo=a(),Zn=c("p"),Zn.innerHTML=ss,co=a(),Wn=c("p"),Wn.innerHTML=as,po=a(),W=c("div"),u(tn.$$.fragment),mo=a(),Nn=c("p"),Nn.innerHTML=rs,ho=a(),u(he.$$.fragment),uo=a(),u(ue.$$.fragment),fo=a(),u(fe.$$.fragment),yt=a(),u(on.$$.fragment),Tt=a(),F=c("div"),u(sn.$$.fragment),go=a(),Bn=c("p"),Bn.innerHTML=is,_o=a(),qn=c("p"),qn.innerHTML=ls,bo=a(),Gn=c("p"),Gn.innerHTML=ds,yo=a(),S=c("div"),u(an.$$.fragment),To=a(),Vn=c("p"),Vn.innerHTML=cs,Mo=a(),u(ge.$$.fragment),wo=a(),u(_e.$$.fragment),Mt=a(),u(rn.$$.fragment),wt=a(),Hn=c("p"),this.h()},l(e){const o=fs("svelte-u9bgzb",document.head);n=p(o,"META",{name:!0,content:!0}),o.forEach(s),T=r(e),l=p(e,"P",{}),v(l).forEach(s),m=r(e),f(M.$$.fragment,e),t=r(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),h(w)!=="svelte-13t8s2t"&&(w.innerHTML=Co),Rn=r(e),f(Te.$$.fragment,e),Xn=r(e),Me=p(e,"P",{"data-svelte-h":!0}),h(Me)!=="svelte-137vzwo"&&(Me.innerHTML=ko),En=r(e),we=p(e,"P",{"data-svelte-h":!0}),h(we)!=="svelte-vfdo9a"&&(we.textContent=$o),Sn=r(e),Ce=p(e,"P",{"data-svelte-h":!0}),h(Ce)!=="svelte-xuujf4"&&(Ce.innerHTML=vo),Qn=r(e),ke=p(e,"P",{"data-svelte-h":!0}),h(ke)!=="svelte-1v70qnc"&&(ke.innerHTML=jo),Yn=r(e),f($e.$$.fragment,e),An=r(e),ve=p(e,"UL",{"data-svelte-h":!0}),h(ve)!=="svelte-1un3d10"&&(ve.innerHTML=Jo),Pn=r(e),je=p(e,"P",{"data-svelte-h":!0}),h(je)!=="svelte-15q2gn0"&&(je.textContent=xo),Dn=r(e),Je=p(e,"UL",{"data-svelte-h":!0}),h(Je)!=="svelte-ttmd73"&&(Je.innerHTML=Uo),On=r(e),f(xe.$$.fragment,e),Kn=r(e),Ue=p(e,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-1hwazkj"&&(Ue.innerHTML=zo),et=r(e),f(ze.$$.fragment,e),nt=r(e),Ie=p(e,"P",{"data-svelte-h":!0}),h(Ie)!=="svelte-1sa0fj2"&&(Ie.textContent=Io),tt=r(e),f(Fe.$$.fragment,e),ot=r(e),f(Ze.$$.fragment,e),st=r(e),We=p(e,"UL",{"data-svelte-h":!0}),h(We)!=="svelte-1521k64"&&(We.innerHTML=Fo),at=r(e),f(Ne.$$.fragment,e),rt=r(e),N=p(e,"DIV",{class:!0});var Q=v(N);f(Be.$$.fragment,Q),kt=r(Q),cn=p(Q,"P",{"data-svelte-h":!0}),h(cn)!=="svelte-5gqeuz"&&(cn.innerHTML=Zo),$t=r(Q),pn=p(Q,"P",{"data-svelte-h":!0}),h(pn)!=="svelte-o55m63"&&(pn.innerHTML=Wo),vt=r(Q),f(se.$$.fragment,Q),Q.forEach(s),it=r(e),f(qe.$$.fragment,e),lt=r(e),k=p(e,"DIV",{class:!0});var j=v(k);f(Ge.$$.fragment,j),jt=r(j),mn=p(j,"P",{"data-svelte-h":!0}),h(mn)!=="svelte-12nibo4"&&(mn.textContent=No),Jt=r(j),hn=p(j,"P",{"data-svelte-h":!0}),h(hn)!=="svelte-tamnbt"&&(hn.innerHTML=Bo),xt=r(j),un=p(j,"P",{"data-svelte-h":!0}),h(un)!=="svelte-1u3q3cm"&&(un.innerHTML=qo),Ut=r(j),P=p(j,"DIV",{class:!0});var te=v(P);f(Ve.$$.fragment,te),zt=r(te),fn=p(te,"P",{"data-svelte-h":!0}),h(fn)!=="svelte-1angbpx"&&(fn.textContent=Go),It=r(te),gn=p(te,"UL",{"data-svelte-h":!0}),h(gn)!=="svelte-xi6653"&&(gn.innerHTML=Vo),te.forEach(s),Ft=r(j),ae=p(j,"DIV",{class:!0});var ln=v(ae);f(He.$$.fragment,ln),Zt=r(ln),_n=p(ln,"P",{"data-svelte-h":!0}),h(_n)!=="svelte-1f4f5kp"&&(_n.innerHTML=Ho),ln.forEach(s),Wt=r(j),X=p(j,"DIV",{class:!0});var Y=v(X);f(Le.$$.fragment,Y),Nt=r(Y),bn=p(Y,"P",{"data-svelte-h":!0}),h(bn)!=="svelte-l20oaj"&&(bn.textContent=Lo),Bt=r(Y),f(re.$$.fragment,Y),qt=r(Y),yn=p(Y,"P",{"data-svelte-h":!0}),h(yn)!=="svelte-owoxgn"&&(yn.innerHTML=Ro),Y.forEach(s),j.forEach(s),dt=r(e),f(Re.$$.fragment,e),ct=r(e),ne=p(e,"DIV",{class:!0});var dn=v(ne);f(Xe.$$.fragment,dn),Gt=r(dn),Tn=p(dn,"P",{"data-svelte-h":!0}),h(Tn)!=="svelte-1y3ujg9"&&(Tn.innerHTML=Xo),dn.forEach(s),pt=r(e),f(Ee.$$.fragment,e),mt=r(e),x=p(e,"DIV",{class:!0});var B=v(x);f(Se.$$.fragment,B),Vt=r(B),Mn=p(B,"P",{"data-svelte-h":!0}),h(Mn)!=="svelte-86lsjc"&&(Mn.textContent=Eo),Ht=r(B),wn=p(B,"P",{"data-svelte-h":!0}),h(wn)!=="svelte-6pahdo"&&(wn.innerHTML=So),Lt=r(B),Cn=p(B,"P",{"data-svelte-h":!0}),h(Cn)!=="svelte-hswkmf"&&(Cn.innerHTML=Qo),Rt=r(B),D=p(B,"DIV",{class:!0});var oe=v(D);f(Qe.$$.fragment,oe),Xt=r(oe),kn=p(oe,"P",{"data-svelte-h":!0}),h(kn)!=="svelte-182k3kr"&&(kn.innerHTML=Yo),Et=r(oe),f(ie.$$.fragment,oe),oe.forEach(s),B.forEach(s),ht=r(e),f(Ye.$$.fragment,e),ut=r(e),U=p(e,"DIV",{class:!0});var q=v(U);f(Ae.$$.fragment,q),St=r(q),$n=p(q,"P",{"data-svelte-h":!0}),h($n)!=="svelte-hlboli"&&($n.textContent=Ao),Qt=r(q),vn=p(q,"P",{"data-svelte-h":!0}),h(vn)!=="svelte-6pahdo"&&(vn.innerHTML=Po),Yt=r(q),jn=p(q,"P",{"data-svelte-h":!0}),h(jn)!=="svelte-hswkmf"&&(jn.innerHTML=Do),At=r(q),Z=p(q,"DIV",{class:!0});var G=v(Z);f(Pe.$$.fragment,G),Pt=r(G),Jn=p(G,"P",{"data-svelte-h":!0}),h(Jn)!=="svelte-1jvjbff"&&(Jn.innerHTML=Oo),Dt=r(G),f(le.$$.fragment,G),Ot=r(G),f(de.$$.fragment,G),Kt=r(G),f(ce.$$.fragment,G),G.forEach(s),q.forEach(s),ft=r(e),f(De.$$.fragment,e),gt=r(e),z=p(e,"DIV",{class:!0});var V=v(z);f(Oe.$$.fragment,V),eo=r(V),xn=p(V,"P",{"data-svelte-h":!0}),h(xn)!=="svelte-ljm4l1"&&(xn.textContent=Ko),no=r(V),Un=p(V,"P",{"data-svelte-h":!0}),h(Un)!=="svelte-6pahdo"&&(Un.innerHTML=es),to=r(V),zn=p(V,"P",{"data-svelte-h":!0}),h(zn)!=="svelte-hswkmf"&&(zn.innerHTML=ns),oo=r(V),E=p(V,"DIV",{class:!0});var A=v(E);f(Ke.$$.fragment,A),so=r(A),In=p(A,"P",{"data-svelte-h":!0}),h(In)!=="svelte-1m0e3gv"&&(In.innerHTML=ts),ao=r(A),f(pe.$$.fragment,A),ro=r(A),f(me.$$.fragment,A),A.forEach(s),V.forEach(s),_t=r(e),f(en.$$.fragment,e),bt=r(e),I=p(e,"DIV",{class:!0});var H=v(I);f(nn.$$.fragment,H),io=r(H),Fn=p(H,"P",{"data-svelte-h":!0}),h(Fn)!=="svelte-1pv5byc"&&(Fn.textContent=os),lo=r(H),Zn=p(H,"P",{"data-svelte-h":!0}),h(Zn)!=="svelte-6pahdo"&&(Zn.innerHTML=ss),co=r(H),Wn=p(H,"P",{"data-svelte-h":!0}),h(Wn)!=="svelte-hswkmf"&&(Wn.innerHTML=as),po=r(H),W=p(H,"DIV",{class:!0});var O=v(W);f(tn.$$.fragment,O),mo=r(O),Nn=p(O,"P",{"data-svelte-h":!0}),h(Nn)!=="svelte-1d6dnkz"&&(Nn.innerHTML=rs),ho=r(O),f(he.$$.fragment,O),uo=r(O),f(ue.$$.fragment,O),fo=r(O),f(fe.$$.fragment,O),O.forEach(s),H.forEach(s),yt=r(e),f(on.$$.fragment,e),Tt=r(e),F=p(e,"DIV",{class:!0});var K=v(F);f(sn.$$.fragment,K),go=r(K),Bn=p(K,"P",{"data-svelte-h":!0}),h(Bn)!=="svelte-1jcv9mx"&&(Bn.innerHTML=is),_o=r(K),qn=p(K,"P",{"data-svelte-h":!0}),h(qn)!=="svelte-6pahdo"&&(qn.innerHTML=ls),bo=r(K),Gn=p(K,"P",{"data-svelte-h":!0}),h(Gn)!=="svelte-hswkmf"&&(Gn.innerHTML=ds),yo=r(K),S=p(K,"DIV",{class:!0});var be=v(S);f(an.$$.fragment,be),To=r(be),Vn=p(be,"P",{"data-svelte-h":!0}),h(Vn)!=="svelte-1kkbs9"&&(Vn.innerHTML=cs),Mo=r(be),f(ge.$$.fragment,be),wo=r(be),f(_e.$$.fragment,be),be.forEach(s),K.forEach(s),Mt=r(e),f(rn.$$.fragment,e),wt=r(e),Hn=p(e,"P",{}),v(Hn).forEach(s),this.h()},h(){$(n,"name","hf:doc:metadata"),$(n,"content",zs),$(w,"class","flex flex-wrap space-x-1"),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){i(document.head,n),d(e,T,o),d(e,l,o),d(e,m,o),g(M,e,o),d(e,t,o),d(e,w,o),d(e,Rn,o),g(Te,e,o),d(e,Xn,o),d(e,Me,o),d(e,En,o),d(e,we,o),d(e,Sn,o),d(e,Ce,o),d(e,Qn,o),d(e,ke,o),d(e,Yn,o),g($e,e,o),d(e,An,o),d(e,ve,o),d(e,Pn,o),d(e,je,o),d(e,Dn,o),d(e,Je,o),d(e,On,o),g(xe,e,o),d(e,Kn,o),d(e,Ue,o),d(e,et,o),g(ze,e,o),d(e,nt,o),d(e,Ie,o),d(e,tt,o),g(Fe,e,o),d(e,ot,o),g(Ze,e,o),d(e,st,o),d(e,We,o),d(e,at,o),g(Ne,e,o),d(e,rt,o),d(e,N,o),g(Be,N,null),i(N,kt),i(N,cn),i(N,$t),i(N,pn),i(N,vt),g(se,N,null),d(e,it,o),g(qe,e,o),d(e,lt,o),d(e,k,o),g(Ge,k,null),i(k,jt),i(k,mn),i(k,Jt),i(k,hn),i(k,xt),i(k,un),i(k,Ut),i(k,P),g(Ve,P,null),i(P,zt),i(P,fn),i(P,It),i(P,gn),i(k,Ft),i(k,ae),g(He,ae,null),i(ae,Zt),i(ae,_n),i(k,Wt),i(k,X),g(Le,X,null),i(X,Nt),i(X,bn),i(X,Bt),g(re,X,null),i(X,qt),i(X,yn),d(e,dt,o),g(Re,e,o),d(e,ct,o),d(e,ne,o),g(Xe,ne,null),i(ne,Gt),i(ne,Tn),d(e,pt,o),g(Ee,e,o),d(e,mt,o),d(e,x,o),g(Se,x,null),i(x,Vt),i(x,Mn),i(x,Ht),i(x,wn),i(x,Lt),i(x,Cn),i(x,Rt),i(x,D),g(Qe,D,null),i(D,Xt),i(D,kn),i(D,Et),g(ie,D,null),d(e,ht,o),g(Ye,e,o),d(e,ut,o),d(e,U,o),g(Ae,U,null),i(U,St),i(U,$n),i(U,Qt),i(U,vn),i(U,Yt),i(U,jn),i(U,At),i(U,Z),g(Pe,Z,null),i(Z,Pt),i(Z,Jn),i(Z,Dt),g(le,Z,null),i(Z,Ot),g(de,Z,null),i(Z,Kt),g(ce,Z,null),d(e,ft,o),g(De,e,o),d(e,gt,o),d(e,z,o),g(Oe,z,null),i(z,eo),i(z,xn),i(z,no),i(z,Un),i(z,to),i(z,zn),i(z,oo),i(z,E),g(Ke,E,null),i(E,so),i(E,In),i(E,ao),g(pe,E,null),i(E,ro),g(me,E,null),d(e,_t,o),g(en,e,o),d(e,bt,o),d(e,I,o),g(nn,I,null),i(I,io),i(I,Fn),i(I,lo),i(I,Zn),i(I,co),i(I,Wn),i(I,po),i(I,W),g(tn,W,null),i(W,mo),i(W,Nn),i(W,ho),g(he,W,null),i(W,uo),g(ue,W,null),i(W,fo),g(fe,W,null),d(e,yt,o),g(on,e,o),d(e,Tt,o),d(e,F,o),g(sn,F,null),i(F,go),i(F,Bn),i(F,_o),i(F,qn),i(F,bo),i(F,Gn),i(F,yo),i(F,S),g(an,S,null),i(S,To),i(S,Vn),i(S,Mo),g(ge,S,null),i(S,wo),g(_e,S,null),d(e,Mt,o),g(rn,e,o),d(e,wt,o),d(e,Hn,o),Ct=!0},p(e,[o]){const Q={};o&2&&(Q.$$scope={dirty:o,ctx:e}),se.$set(Q);const j={};o&2&&(j.$$scope={dirty:o,ctx:e}),re.$set(j);const te={};o&2&&(te.$$scope={dirty:o,ctx:e}),ie.$set(te);const ln={};o&2&&(ln.$$scope={dirty:o,ctx:e}),le.$set(ln);const Y={};o&2&&(Y.$$scope={dirty:o,ctx:e}),de.$set(Y);const dn={};o&2&&(dn.$$scope={dirty:o,ctx:e}),ce.$set(dn);const B={};o&2&&(B.$$scope={dirty:o,ctx:e}),pe.$set(B);const oe={};o&2&&(oe.$$scope={dirty:o,ctx:e}),me.$set(oe);const q={};o&2&&(q.$$scope={dirty:o,ctx:e}),he.$set(q);const G={};o&2&&(G.$$scope={dirty:o,ctx:e}),ue.$set(G);const V={};o&2&&(V.$$scope={dirty:o,ctx:e}),fe.$set(V);const A={};o&2&&(A.$$scope={dirty:o,ctx:e}),ge.$set(A);const H={};o&2&&(H.$$scope={dirty:o,ctx:e}),_e.$set(H)},i(e){Ct||(_(M.$$.fragment,e),_(Te.$$.fragment,e),_($e.$$.fragment,e),_(xe.$$.fragment,e),_(ze.$$.fragment,e),_(Fe.$$.fragment,e),_(Ze.$$.fragment,e),_(Ne.$$.fragment,e),_(Be.$$.fragment,e),_(se.$$.fragment,e),_(qe.$$.fragment,e),_(Ge.$$.fragment,e),_(Ve.$$.fragment,e),_(He.$$.fragment,e),_(Le.$$.fragment,e),_(re.$$.fragment,e),_(Re.$$.fragment,e),_(Xe.$$.fragment,e),_(Ee.$$.fragment,e),_(Se.$$.fragment,e),_(Qe.$$.fragment,e),_(ie.$$.fragment,e),_(Ye.$$.fragment,e),_(Ae.$$.fragment,e),_(Pe.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(De.$$.fragment,e),_(Oe.$$.fragment,e),_(Ke.$$.fragment,e),_(pe.$$.fragment,e),_(me.$$.fragment,e),_(en.$$.fragment,e),_(nn.$$.fragment,e),_(tn.$$.fragment,e),_(he.$$.fragment,e),_(ue.$$.fragment,e),_(fe.$$.fragment,e),_(on.$$.fragment,e),_(sn.$$.fragment,e),_(an.$$.fragment,e),_(ge.$$.fragment,e),_(_e.$$.fragment,e),_(rn.$$.fragment,e),Ct=!0)},o(e){b(M.$$.fragment,e),b(Te.$$.fragment,e),b($e.$$.fragment,e),b(xe.$$.fragment,e),b(ze.$$.fragment,e),b(Fe.$$.fragment,e),b(Ze.$$.fragment,e),b(Ne.$$.fragment,e),b(Be.$$.fragment,e),b(se.$$.fragment,e),b(qe.$$.fragment,e),b(Ge.$$.fragment,e),b(Ve.$$.fragment,e),b(He.$$.fragment,e),b(Le.$$.fragment,e),b(re.$$.fragment,e),b(Re.$$.fragment,e),b(Xe.$$.fragment,e),b(Ee.$$.fragment,e),b(Se.$$.fragment,e),b(Qe.$$.fragment,e),b(ie.$$.fragment,e),b(Ye.$$.fragment,e),b(Ae.$$.fragment,e),b(Pe.$$.fragment,e),b(le.$$.fragment,e),b(de.$$.fragment,e),b(ce.$$.fragment,e),b(De.$$.fragment,e),b(Oe.$$.fragment,e),b(Ke.$$.fragment,e),b(pe.$$.fragment,e),b(me.$$.fragment,e),b(en.$$.fragment,e),b(nn.$$.fragment,e),b(tn.$$.fragment,e),b(he.$$.fragment,e),b(ue.$$.fragment,e),b(fe.$$.fragment,e),b(on.$$.fragment,e),b(sn.$$.fragment,e),b(an.$$.fragment,e),b(ge.$$.fragment,e),b(_e.$$.fragment,e),b(rn.$$.fragment,e),Ct=!1},d(e){e&&(s(T),s(l),s(m),s(t),s(w),s(Rn),s(Xn),s(Me),s(En),s(we),s(Sn),s(Ce),s(Qn),s(ke),s(Yn),s(An),s(ve),s(Pn),s(je),s(Dn),s(Je),s(On),s(Kn),s(Ue),s(et),s(nt),s(Ie),s(tt),s(ot),s(st),s(We),s(at),s(rt),s(N),s(it),s(lt),s(k),s(dt),s(ct),s(ne),s(pt),s(mt),s(x),s(ht),s(ut),s(U),s(ft),s(gt),s(z),s(_t),s(bt),s(I),s(yt),s(Tt),s(F),s(Mt),s(wt),s(Hn)),s(n),y(M,e),y(Te,e),y($e,e),y(xe,e),y(ze,e),y(Fe,e),y(Ze,e),y(Ne,e),y(Be),y(se),y(qe,e),y(Ge),y(Ve),y(He),y(Le),y(re),y(Re,e),y(Xe),y(Ee,e),y(Se),y(Qe),y(ie),y(Ye,e),y(Ae),y(Pe),y(le),y(de),y(ce),y(De,e),y(Oe),y(Ke),y(pe),y(me),y(en,e),y(nn),y(tn),y(he),y(ue),y(fe),y(on,e),y(sn),y(an),y(ge),y(_e),y(rn,e)}}}const zs='{"title":"CANINE","local":"canine","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"CanineConfig","local":"transformers.CanineConfig","sections":[],"depth":2},{"title":"CanineTokenizer","local":"transformers.CanineTokenizer","sections":[],"depth":2},{"title":"CANINE specific outputs","local":"transformers.models.canine.modeling_canine.CanineModelOutputWithPooling","sections":[],"depth":2},{"title":"CanineModel","local":"transformers.CanineModel","sections":[],"depth":2},{"title":"CanineForSequenceClassification","local":"transformers.CanineForSequenceClassification","sections":[],"depth":2},{"title":"CanineForMultipleChoice","local":"transformers.CanineForMultipleChoice","sections":[],"depth":2},{"title":"CanineForTokenClassification","local":"transformers.CanineForTokenClassification","sections":[],"depth":2},{"title":"CanineForQuestionAnswering","local":"transformers.CanineForQuestionAnswering","sections":[],"depth":2}],"depth":1}';function Is(C){return ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends hs{constructor(n){super(),us(this,n,Is,Us,ps,{})}}export{Hs as component};
