import{s as to,z as oo,o as no,n as Fe}from"../chunks/scheduler.18a86fab.js";import{S as so,i as ro,g as d,s,r as h,A as ao,h as c,f as o,c as r,j as E,u as f,x as v,k as M,y as l,a,v as g,d as u,t as _,w as b}from"../chunks/index.98837b22.js";import{T as Ct}from"../chunks/Tip.77304350.js";import{D as J}from"../chunks/Docstring.6758ea23.js";import{C as zt}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as It}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as Y}from"../chunks/Heading.7e7e0c5b.js";import{E as io}from"../chunks/index.499f366c.js";function lo(L){let n,$=`This is a recently introduced model so the API hasn’t been tested extensively. There may be some bugs or slight
breaking changes to fix it in the future. If you see something strange, file a <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=&amp;template=bug-report.md&amp;title" rel="nofollow">Github Issue</a>.`;return{c(){n=d("p"),n.innerHTML=$},l(m){n=c(m,"P",{"data-svelte-h":!0}),v(n)!=="svelte-j665pk"&&(n.innerHTML=$)},m(m,p){a(m,n,p)},p:Fe,d(m){m&&o(n)}}}function co(L){let n,$="Example:",m,p,y;return p=new zt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdMUE5Nb2RlbCUyQyUyMEdMUE5Db25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwR0xQTiUyMHZpbnZpbm8wMiUyRmdscG4ta2l0dGklMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwR0xQTkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMHZpbnZpbm8wMiUyRmdscG4ta2l0dGklMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMEdMUE5Nb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GLPNModel, GLPNConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a GLPN vinvino02/glpn-kitti style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = GLPNConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the vinvino02/glpn-kitti style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GLPNModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=d("p"),n.textContent=$,m=s(),h(p.$$.fragment)},l(i){n=c(i,"P",{"data-svelte-h":!0}),v(n)!=="svelte-11lpom8"&&(n.textContent=$),m=r(i),f(p.$$.fragment,i)},m(i,w){a(i,n,w),a(i,m,w),g(p,i,w),y=!0},p:Fe,i(i){y||(u(p.$$.fragment,i),y=!0)},o(i){_(p.$$.fragment,i),y=!1},d(i){i&&(o(n),o(m)),b(p,i)}}}function mo(L){let n,$=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=$},l(m){n=c(m,"P",{"data-svelte-h":!0}),v(n)!=="svelte-fincs2"&&(n.innerHTML=$)},m(m,p){a(m,n,p)},p:Fe,d(m){m&&o(n)}}}function po(L){let n,$="Example:",m,p,y;return p=new zt({props:{code:"",highlighted:"",wrap:!1}}),{c(){n=d("p"),n.textContent=$,m=s(),h(p.$$.fragment)},l(i){n=c(i,"P",{"data-svelte-h":!0}),v(n)!=="svelte-11lpom8"&&(n.textContent=$),m=r(i),f(p.$$.fragment,i)},m(i,w){a(i,n,w),a(i,m,w),g(p,i,w),y=!0},p:Fe,i(i){y||(u(p.$$.fragment,i),y=!0)},o(i){_(p.$$.fragment,i),y=!1},d(i){i&&(o(n),o(m)),b(p,i)}}}function ho(L){let n,$=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=$},l(m){n=c(m,"P",{"data-svelte-h":!0}),v(n)!=="svelte-fincs2"&&(n.innerHTML=$)},m(m,p){a(m,n,p)},p:Fe,d(m){m&&o(n)}}}function fo(L){let n,$="Examples:",m,p,y;return p=new zt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEdMUE5Gb3JEZXB0aEVzdGltYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIydmludmlubzAyJTJGZ2xwbi1raXR0aSUyMiklMEFtb2RlbCUyMCUzRCUyMEdMUE5Gb3JEZXB0aEVzdGltYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnZpbnZpbm8wMiUyRmdscG4ta2l0dGklMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwaW50ZXJwb2xhdGUlMjB0byUyMG9yaWdpbmFsJTIwc2l6ZSUwQXBvc3RfcHJvY2Vzc2VkX291dHB1dCUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wb3N0X3Byb2Nlc3NfZGVwdGhfZXN0aW1hdGlvbiglMEElMjAlMjAlMjAlMjBvdXRwdXRzJTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X3NpemVzJTNEJTVCKGltYWdlLmhlaWdodCUyQyUyMGltYWdlLndpZHRoKSU1RCUyQyUwQSklMEElMEElMjMlMjB2aXN1YWxpemUlMjB0aGUlMjBwcmVkaWN0aW9uJTBBcHJlZGljdGVkX2RlcHRoJTIwJTNEJTIwcG9zdF9wcm9jZXNzZWRfb3V0cHV0JTVCMCU1RCU1QiUyMnByZWRpY3RlZF9kZXB0aCUyMiU1RCUwQWRlcHRoJTIwJTNEJTIwcHJlZGljdGVkX2RlcHRoJTIwKiUyMDI1NSUyMCUyRiUyMHByZWRpY3RlZF9kZXB0aC5tYXgoKSUwQWRlcHRoJTIwJTNEJTIwZGVwdGguZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUwQWRlcHRoJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGRlcHRoLmFzdHlwZSglMjJ1aW50OCUyMikp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, GLPNForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;vinvino02/glpn-kitti&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GLPNForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;vinvino02/glpn-kitti&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>post_processed_output = image_processor.post_process_depth_estimation(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    target_sizes=[(image.height, image.width)],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_depth = post_processed_output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;predicted_depth&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = predicted_depth * <span class="hljs-number">255</span> / predicted_depth.<span class="hljs-built_in">max</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = depth.detach().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(depth.astype(<span class="hljs-string">&quot;uint8&quot;</span>))`,wrap:!1}}),{c(){n=d("p"),n.textContent=$,m=s(),h(p.$$.fragment)},l(i){n=c(i,"P",{"data-svelte-h":!0}),v(n)!=="svelte-kvfsh7"&&(n.textContent=$),m=r(i),f(p.$$.fragment,i)},m(i,w){a(i,n,w),a(i,m,w),g(p,i,w),y=!0},p:Fe,i(i){y||(u(p.$$.fragment,i),y=!0)},o(i){_(p.$$.fragment,i),y=!1},d(i){i&&(o(n),o(m)),b(p,i)}}}function go(L){let n,$,m,p,y,i,w,Et='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',ke,k,Re,A,De,O,jt=`The GLPN model was proposed in <a href="https://arxiv.org/abs/2201.07436" rel="nofollow">Global-Local Path Networks for Monocular Depth Estimation with Vertical CutDepth</a>  by Doyeon Kim, Woonghyun Ga, Pyungwhan Ahn, Donggyu Joo, Sehwan Chun, Junmo Kim.
GLPN combines <a href="segformer">SegFormer</a>’s hierarchical mix-Transformer with a lightweight decoder for monocular depth estimation. The proposed decoder shows better performance than the previously proposed decoders, with considerably
less computational complexity.`,Ze,Q,Ut="The abstract from the paper is the following:",We,K,Ft="<em>Depth estimation from a single image is an important task that can be applied to various fields in computer vision, and has grown rapidly with the development of convolutional neural networks. In this paper, we propose a novel structure and training strategy for monocular depth estimation to further improve the prediction accuracy of the network. We deploy a hierarchical transformer encoder to capture and convey the global context, and design a lightweight yet powerful decoder to generate an estimated depth map while considering local connectivity. By constructing connected paths between multi-scale local features and the global decoding stream with our proposed selective feature fusion module, the network can integrate both representations and recover fine details. In addition, the proposed decoder shows better performance than the previously proposed decoders, with considerably less computational complexity. Furthermore, we improve the depth-specific augmentation method by utilizing an important observation in depth estimation to enhance the model. Our network achieves state-of-the-art performance over the challenging depth dataset NYU Depth V2. Extensive experiments have been conducted to validate and show the effectiveness of the proposed approach. Finally, our model shows better generalisation ability and robustness than other comparative models.</em>",Be,R,Jt,He,ee,kt='Summary of the approach. Taken from the <a href="https://arxiv.org/abs/2201.07436" target="_blank">original paper</a>.',Se,te,Rt='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/vinvino02/GLPDepth" rel="nofollow">here</a>.',Ve,oe,Xe,ne,Dt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with GLPN.",qe,se,Zt='<li>Demo notebooks for <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNForDepthEstimation">GLPNForDepthEstimation</a> can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/GLPN" rel="nofollow">here</a>.</li> <li><a href="../tasks/monocular_depth_estimation">Monocular depth estimation task guide</a></li>',Ye,re,Ae,N,ae,lt,Te,Wt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNModel">GLPNModel</a>. It is used to instantiate an GLPN
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the GLPN
<a href="https://huggingface.co/vinvino02/glpn-kitti" rel="nofollow">vinvino02/glpn-kitti</a> architecture.`,dt,Pe,Bt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ct,D,Oe,ie,Qe,U,le,mt,Z,de,pt,Me,Ht="Preprocess an image or a batch of images.",Ke,ce,et,I,me,ht,Le,St="Constructs a GLPN image processor.",ft,W,pe,gt,Ne,Vt="Preprocess the given images.",tt,he,ot,T,fe,ut,xe,Xt="The bare Glpn Model outputting raw hidden-states without any specific head on top.",_t,Ge,qt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,bt,Ce,Yt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,vt,G,ge,$t,Ie,At='The <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNModel">GLPNModel</a> forward method, overrides the <code>__call__</code> special method.',yt,B,wt,H,nt,ue,st,P,_e,Tt,ze,Ot="GLPN Model transformer with a lightweight depth estimation head on top e.g. for KITTI, NYUv2.",Pt,Ee,Qt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Mt,je,Kt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Lt,C,be,Nt,Ue,eo='The <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNForDepthEstimation">GLPNForDepthEstimation</a> forward method, overrides the <code>__call__</code> special method.',xt,S,Gt,V,rt,ve,at,Je,it;return y=new Y({props:{title:"GLPN",local:"glpn",headingTag:"h1"}}),k=new Ct({props:{$$slots:{default:[lo]},$$scope:{ctx:L}}}),A=new Y({props:{title:"Overview",local:"overview",headingTag:"h2"}}),oe=new Y({props:{title:"Resources",local:"resources",headingTag:"h2"}}),re=new Y({props:{title:"GLPNConfig",local:"transformers.GLPNConfig",headingTag:"h2"}}),ae=new J({props:{name:"class transformers.GLPNConfig",anchor:"transformers.GLPNConfig",parameters:[{name:"num_channels",val:" = 3"},{name:"num_encoder_blocks",val:" = 4"},{name:"depths",val:" = [2, 2, 2, 2]"},{name:"sr_ratios",val:" = [8, 4, 2, 1]"},{name:"hidden_sizes",val:" = [32, 64, 160, 256]"},{name:"patch_sizes",val:" = [7, 3, 3, 3]"},{name:"strides",val:" = [4, 2, 2, 2]"},{name:"num_attention_heads",val:" = [1, 2, 5, 8]"},{name:"mlp_ratios",val:" = [4, 4, 4, 4]"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"drop_path_rate",val:" = 0.1"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"decoder_hidden_size",val:" = 64"},{name:"max_depth",val:" = 10"},{name:"head_in_index",val:" = -1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GLPNConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.GLPNConfig.num_encoder_blocks",description:`<strong>num_encoder_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of encoder blocks (i.e. stages in the Mix Transformer encoder).`,name:"num_encoder_blocks"},{anchor:"transformers.GLPNConfig.depths",description:`<strong>depths</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 2, 2, 2]</code>) &#x2014;
The number of layers in each encoder block.`,name:"depths"},{anchor:"transformers.GLPNConfig.sr_ratios",description:`<strong>sr_ratios</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[8, 4, 2, 1]</code>) &#x2014;
Sequence reduction ratios in each encoder block.`,name:"sr_ratios"},{anchor:"transformers.GLPNConfig.hidden_sizes",description:`<strong>hidden_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[32, 64, 160, 256]</code>) &#x2014;
Dimension of each of the encoder blocks.`,name:"hidden_sizes"},{anchor:"transformers.GLPNConfig.patch_sizes",description:`<strong>patch_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[7, 3, 3, 3]</code>) &#x2014;
Patch size before each encoder block.`,name:"patch_sizes"},{anchor:"transformers.GLPNConfig.strides",description:`<strong>strides</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 2, 2, 2]</code>) &#x2014;
Stride before each encoder block.`,name:"strides"},{anchor:"transformers.GLPNConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 2, 5, 8]</code>) &#x2014;
Number of attention heads for each attention layer in each block of the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.GLPNConfig.mlp_ratios",description:`<strong>mlp_ratios</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 4, 4, 4]</code>) &#x2014;
Ratio of the size of the hidden layer compared to the size of the input layer of the Mix FFNs in the
encoder blocks.`,name:"mlp_ratios"},{anchor:"transformers.GLPNConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.GLPNConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.GLPNConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.GLPNConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.GLPNConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for stochastic depth, used in the blocks of the Transformer encoder.`,name:"drop_path_rate"},{anchor:"transformers.GLPNConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.GLPNConfig.decoder_hidden_size",description:`<strong>decoder_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The dimension of the decoder.`,name:"decoder_hidden_size"},{anchor:"transformers.GLPNConfig.max_depth",description:`<strong>max_depth</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
The maximum depth of the decoder.`,name:"max_depth"},{anchor:"transformers.GLPNConfig.head_in_index",description:`<strong>head_in_index</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the features to use in the head.`,name:"head_in_index"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/configuration_glpn.py#L24"}}),D=new It({props:{anchor:"transformers.GLPNConfig.example",$$slots:{default:[co]},$$scope:{ctx:L}}}),ie=new Y({props:{title:"GLPNFeatureExtractor",local:"transformers.GLPNFeatureExtractor",headingTag:"h2"}}),le=new J({props:{name:"class transformers.GLPNFeatureExtractor",anchor:"transformers.GLPNFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/feature_extraction_glpn.py#L27"}}),de=new J({props:{name:"__call__",anchor:"transformers.GLPNFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/image_processing_utils.py#L42"}}),ce=new Y({props:{title:"GLPNImageProcessor",local:"transformers.GLPNImageProcessor",headingTag:"h2"}}),me=new J({props:{name:"class transformers.GLPNImageProcessor",anchor:"transformers.GLPNImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size_divisor",val:": int = 32"},{name:"resample",val:" = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GLPNImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions, rounding them down to the closest multiple of
<code>size_divisor</code>. Can be overridden by <code>do_resize</code> in <code>preprocess</code>.`,name:"do_resize"},{anchor:"transformers.GLPNImageProcessor.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
When <code>do_resize</code> is <code>True</code>, images are resized so their height and width are rounded down to the closest
multiple of <code>size_divisor</code>. Can be overridden by <code>size_divisor</code> in <code>preprocess</code>.`,name:"size_divisor"},{anchor:"transformers.GLPNImageProcessor.resample",description:`<strong>resample</strong> (<code>PIL.Image</code> resampling filter, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in <code>preprocess</code>.`,name:"resample"},{anchor:"transformers.GLPNImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to apply the scaling factor (to make pixel values floats between 0. and 1.). Can be
overridden by <code>do_rescale</code> in <code>preprocess</code>.`,name:"do_rescale"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/image_processing_glpn.py#L52"}}),pe=new J({props:{name:"preprocess",anchor:"transformers.GLPNImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), transformers.utils.generic.TensorType, typing.List[ForwardRef('PIL.Image.Image')], typing.List[transformers.utils.generic.TensorType]]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size_divisor",val:": typing.Optional[int] = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.GLPNImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code> or <code>TensorType</code> or <code>List[np.ndarray]</code> or <code>List[TensorType]</code>) &#x2014;
Images to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_normalize=False</code>.`,name:"images"},{anchor:"transformers.GLPNImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the input such that the (height, width) dimensions are a multiple of <code>size_divisor</code>.`,name:"do_resize"},{anchor:"transformers.GLPNImageProcessor.preprocess.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.size_divisor</code>) &#x2014;
When <code>do_resize</code> is <code>True</code>, images are resized so their height and width are rounded down to the
closest multiple of <code>size_divisor</code>.`,name:"size_divisor"},{anchor:"transformers.GLPNImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PIL.Image</code> resampling filter, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
<code>PIL.Image</code> resampling filter to use if resizing the image e.g. <code>PILImageResampling.BILINEAR</code>. Only has
an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.GLPNImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether or not to apply the scaling factor (to make pixel values floats between 0. and 1.).`,name:"do_rescale"},{anchor:"transformers.GLPNImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li><code>None</code>: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.GLPNImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.GLPNImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/image_processing_glpn.py#L137"}}),he=new Y({props:{title:"GLPNModel",local:"transformers.GLPNModel",headingTag:"h2"}}),fe=new J({props:{name:"class transformers.GLPNModel",anchor:"transformers.GLPNModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.GLPNModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNModel">GLPNModel</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/modeling_glpn.py#L427"}}),ge=new J({props:{name:"forward",anchor:"transformers.GLPNModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.GLPNModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.GLPNModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GLPNModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GLPNModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/modeling_glpn.py#L448",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNConfig"
>GLPNConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),B=new Ct({props:{$$slots:{default:[mo]},$$scope:{ctx:L}}}),H=new It({props:{anchor:"transformers.GLPNModel.forward.example",$$slots:{default:[po]},$$scope:{ctx:L}}}),ue=new Y({props:{title:"GLPNForDepthEstimation",local:"transformers.GLPNForDepthEstimation",headingTag:"h2"}}),_e=new J({props:{name:"class transformers.GLPNForDepthEstimation",anchor:"transformers.GLPNForDepthEstimation",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.GLPNForDepthEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNForDepthEstimation">GLPNForDepthEstimation</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/modeling_glpn.py#L618"}}),be=new J({props:{name:"forward",anchor:"transformers.GLPNForDepthEstimation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.GLPNForDepthEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.GLPNForDepthEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth depth estimation maps for computing the loss.`,name:"labels"},{anchor:"transformers.GLPNForDepthEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GLPNForDepthEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GLPNForDepthEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/modeling_glpn.py#L634",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNConfig"
>GLPNConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) — Predicted depth for each pixel.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),S=new Ct({props:{$$slots:{default:[ho]},$$scope:{ctx:L}}}),V=new It({props:{anchor:"transformers.GLPNForDepthEstimation.forward.example",$$slots:{default:[fo]},$$scope:{ctx:L}}}),ve=new io({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/glpn.md"}}),{c(){n=d("meta"),$=s(),m=d("p"),p=s(),h(y.$$.fragment),i=s(),w=d("div"),w.innerHTML=Et,ke=s(),h(k.$$.fragment),Re=s(),h(A.$$.fragment),De=s(),O=d("p"),O.innerHTML=jt,Ze=s(),Q=d("p"),Q.textContent=Ut,We=s(),K=d("p"),K.innerHTML=Ft,Be=s(),R=d("img"),He=s(),ee=d("small"),ee.innerHTML=kt,Se=s(),te=d("p"),te.innerHTML=Rt,Ve=s(),h(oe.$$.fragment),Xe=s(),ne=d("p"),ne.textContent=Dt,qe=s(),se=d("ul"),se.innerHTML=Zt,Ye=s(),h(re.$$.fragment),Ae=s(),N=d("div"),h(ae.$$.fragment),lt=s(),Te=d("p"),Te.innerHTML=Wt,dt=s(),Pe=d("p"),Pe.innerHTML=Bt,ct=s(),h(D.$$.fragment),Oe=s(),h(ie.$$.fragment),Qe=s(),U=d("div"),h(le.$$.fragment),mt=s(),Z=d("div"),h(de.$$.fragment),pt=s(),Me=d("p"),Me.textContent=Ht,Ke=s(),h(ce.$$.fragment),et=s(),I=d("div"),h(me.$$.fragment),ht=s(),Le=d("p"),Le.textContent=St,ft=s(),W=d("div"),h(pe.$$.fragment),gt=s(),Ne=d("p"),Ne.textContent=Vt,tt=s(),h(he.$$.fragment),ot=s(),T=d("div"),h(fe.$$.fragment),ut=s(),xe=d("p"),xe.textContent=Xt,_t=s(),Ge=d("p"),Ge.innerHTML=qt,bt=s(),Ce=d("p"),Ce.innerHTML=Yt,vt=s(),G=d("div"),h(ge.$$.fragment),$t=s(),Ie=d("p"),Ie.innerHTML=At,yt=s(),h(B.$$.fragment),wt=s(),h(H.$$.fragment),nt=s(),h(ue.$$.fragment),st=s(),P=d("div"),h(_e.$$.fragment),Tt=s(),ze=d("p"),ze.textContent=Ot,Pt=s(),Ee=d("p"),Ee.innerHTML=Qt,Mt=s(),je=d("p"),je.innerHTML=Kt,Lt=s(),C=d("div"),h(be.$$.fragment),Nt=s(),Ue=d("p"),Ue.innerHTML=eo,xt=s(),h(S.$$.fragment),Gt=s(),h(V.$$.fragment),rt=s(),h(ve.$$.fragment),at=s(),Je=d("p"),this.h()},l(e){const t=ao("svelte-u9bgzb",document.head);n=c(t,"META",{name:!0,content:!0}),t.forEach(o),$=r(e),m=c(e,"P",{}),E(m).forEach(o),p=r(e),f(y.$$.fragment,e),i=r(e),w=c(e,"DIV",{class:!0,"data-svelte-h":!0}),v(w)!=="svelte-13t8s2t"&&(w.innerHTML=Et),ke=r(e),f(k.$$.fragment,e),Re=r(e),f(A.$$.fragment,e),De=r(e),O=c(e,"P",{"data-svelte-h":!0}),v(O)!=="svelte-1rdmycr"&&(O.innerHTML=jt),Ze=r(e),Q=c(e,"P",{"data-svelte-h":!0}),v(Q)!=="svelte-vfdo9a"&&(Q.textContent=Ut),We=r(e),K=c(e,"P",{"data-svelte-h":!0}),v(K)!=="svelte-l8ay4x"&&(K.innerHTML=Ft),Be=r(e),R=c(e,"IMG",{src:!0,alt:!0,width:!0}),He=r(e),ee=c(e,"SMALL",{"data-svelte-h":!0}),v(ee)!=="svelte-bacs7t"&&(ee.innerHTML=kt),Se=r(e),te=c(e,"P",{"data-svelte-h":!0}),v(te)!=="svelte-1grdklu"&&(te.innerHTML=Rt),Ve=r(e),f(oe.$$.fragment,e),Xe=r(e),ne=c(e,"P",{"data-svelte-h":!0}),v(ne)!=="svelte-fq64ti"&&(ne.textContent=Dt),qe=r(e),se=c(e,"UL",{"data-svelte-h":!0}),v(se)!=="svelte-pb93f4"&&(se.innerHTML=Zt),Ye=r(e),f(re.$$.fragment,e),Ae=r(e),N=c(e,"DIV",{class:!0});var z=E(N);f(ae.$$.fragment,z),lt=r(z),Te=c(z,"P",{"data-svelte-h":!0}),v(Te)!=="svelte-qzaip8"&&(Te.innerHTML=Wt),dt=r(z),Pe=c(z,"P",{"data-svelte-h":!0}),v(Pe)!=="svelte-o55m63"&&(Pe.innerHTML=Bt),ct=r(z),f(D.$$.fragment,z),z.forEach(o),Oe=r(e),f(ie.$$.fragment,e),Qe=r(e),U=c(e,"DIV",{class:!0});var $e=E(U);f(le.$$.fragment,$e),mt=r($e),Z=c($e,"DIV",{class:!0});var ye=E(Z);f(de.$$.fragment,ye),pt=r(ye),Me=c(ye,"P",{"data-svelte-h":!0}),v(Me)!=="svelte-khengj"&&(Me.textContent=Ht),ye.forEach(o),$e.forEach(o),Ke=r(e),f(ce.$$.fragment,e),et=r(e),I=c(e,"DIV",{class:!0});var F=E(I);f(me.$$.fragment,F),ht=r(F),Le=c(F,"P",{"data-svelte-h":!0}),v(Le)!=="svelte-1e6g6g5"&&(Le.textContent=St),ft=r(F),W=c(F,"DIV",{class:!0});var we=E(W);f(pe.$$.fragment,we),gt=r(we),Ne=c(we,"P",{"data-svelte-h":!0}),v(Ne)!=="svelte-tvrlms"&&(Ne.textContent=Vt),we.forEach(o),F.forEach(o),tt=r(e),f(he.$$.fragment,e),ot=r(e),T=c(e,"DIV",{class:!0});var x=E(T);f(fe.$$.fragment,x),ut=r(x),xe=c(x,"P",{"data-svelte-h":!0}),v(xe)!=="svelte-2h15ft"&&(xe.textContent=Xt),_t=r(x),Ge=c(x,"P",{"data-svelte-h":!0}),v(Ge)!=="svelte-6pahdo"&&(Ge.innerHTML=qt),bt=r(x),Ce=c(x,"P",{"data-svelte-h":!0}),v(Ce)!=="svelte-hswkmf"&&(Ce.innerHTML=Yt),vt=r(x),G=c(x,"DIV",{class:!0});var X=E(G);f(ge.$$.fragment,X),$t=r(X),Ie=c(X,"P",{"data-svelte-h":!0}),v(Ie)!=="svelte-1brtns"&&(Ie.innerHTML=At),yt=r(X),f(B.$$.fragment,X),wt=r(X),f(H.$$.fragment,X),X.forEach(o),x.forEach(o),nt=r(e),f(ue.$$.fragment,e),st=r(e),P=c(e,"DIV",{class:!0});var j=E(P);f(_e.$$.fragment,j),Tt=r(j),ze=c(j,"P",{"data-svelte-h":!0}),v(ze)!=="svelte-1y1ccf6"&&(ze.textContent=Ot),Pt=r(j),Ee=c(j,"P",{"data-svelte-h":!0}),v(Ee)!=="svelte-6pahdo"&&(Ee.innerHTML=Qt),Mt=r(j),je=c(j,"P",{"data-svelte-h":!0}),v(je)!=="svelte-hswkmf"&&(je.innerHTML=Kt),Lt=r(j),C=c(j,"DIV",{class:!0});var q=E(C);f(be.$$.fragment,q),Nt=r(q),Ue=c(q,"P",{"data-svelte-h":!0}),v(Ue)!=="svelte-1vek7n8"&&(Ue.innerHTML=eo),xt=r(q),f(S.$$.fragment,q),Gt=r(q),f(V.$$.fragment,q),q.forEach(o),j.forEach(o),rt=r(e),f(ve.$$.fragment,e),at=r(e),Je=c(e,"P",{}),E(Je).forEach(o),this.h()},h(){M(n,"name","hf:doc:metadata"),M(n,"content",uo),M(w,"class","flex flex-wrap space-x-1"),oo(R.src,Jt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/glpn_architecture.jpg")||M(R,"src",Jt),M(R,"alt","drawing"),M(R,"width","600"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,n),a(e,$,t),a(e,m,t),a(e,p,t),g(y,e,t),a(e,i,t),a(e,w,t),a(e,ke,t),g(k,e,t),a(e,Re,t),g(A,e,t),a(e,De,t),a(e,O,t),a(e,Ze,t),a(e,Q,t),a(e,We,t),a(e,K,t),a(e,Be,t),a(e,R,t),a(e,He,t),a(e,ee,t),a(e,Se,t),a(e,te,t),a(e,Ve,t),g(oe,e,t),a(e,Xe,t),a(e,ne,t),a(e,qe,t),a(e,se,t),a(e,Ye,t),g(re,e,t),a(e,Ae,t),a(e,N,t),g(ae,N,null),l(N,lt),l(N,Te),l(N,dt),l(N,Pe),l(N,ct),g(D,N,null),a(e,Oe,t),g(ie,e,t),a(e,Qe,t),a(e,U,t),g(le,U,null),l(U,mt),l(U,Z),g(de,Z,null),l(Z,pt),l(Z,Me),a(e,Ke,t),g(ce,e,t),a(e,et,t),a(e,I,t),g(me,I,null),l(I,ht),l(I,Le),l(I,ft),l(I,W),g(pe,W,null),l(W,gt),l(W,Ne),a(e,tt,t),g(he,e,t),a(e,ot,t),a(e,T,t),g(fe,T,null),l(T,ut),l(T,xe),l(T,_t),l(T,Ge),l(T,bt),l(T,Ce),l(T,vt),l(T,G),g(ge,G,null),l(G,$t),l(G,Ie),l(G,yt),g(B,G,null),l(G,wt),g(H,G,null),a(e,nt,t),g(ue,e,t),a(e,st,t),a(e,P,t),g(_e,P,null),l(P,Tt),l(P,ze),l(P,Pt),l(P,Ee),l(P,Mt),l(P,je),l(P,Lt),l(P,C),g(be,C,null),l(C,Nt),l(C,Ue),l(C,xt),g(S,C,null),l(C,Gt),g(V,C,null),a(e,rt,t),g(ve,e,t),a(e,at,t),a(e,Je,t),it=!0},p(e,[t]){const z={};t&2&&(z.$$scope={dirty:t,ctx:e}),k.$set(z);const $e={};t&2&&($e.$$scope={dirty:t,ctx:e}),D.$set($e);const ye={};t&2&&(ye.$$scope={dirty:t,ctx:e}),B.$set(ye);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),H.$set(F);const we={};t&2&&(we.$$scope={dirty:t,ctx:e}),S.$set(we);const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),V.$set(x)},i(e){it||(u(y.$$.fragment,e),u(k.$$.fragment,e),u(A.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(ae.$$.fragment,e),u(D.$$.fragment,e),u(ie.$$.fragment,e),u(le.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(fe.$$.fragment,e),u(ge.$$.fragment,e),u(B.$$.fragment,e),u(H.$$.fragment,e),u(ue.$$.fragment,e),u(_e.$$.fragment,e),u(be.$$.fragment,e),u(S.$$.fragment,e),u(V.$$.fragment,e),u(ve.$$.fragment,e),it=!0)},o(e){_(y.$$.fragment,e),_(k.$$.fragment,e),_(A.$$.fragment,e),_(oe.$$.fragment,e),_(re.$$.fragment,e),_(ae.$$.fragment,e),_(D.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(he.$$.fragment,e),_(fe.$$.fragment,e),_(ge.$$.fragment,e),_(B.$$.fragment,e),_(H.$$.fragment,e),_(ue.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(S.$$.fragment,e),_(V.$$.fragment,e),_(ve.$$.fragment,e),it=!1},d(e){e&&(o($),o(m),o(p),o(i),o(w),o(ke),o(Re),o(De),o(O),o(Ze),o(Q),o(We),o(K),o(Be),o(R),o(He),o(ee),o(Se),o(te),o(Ve),o(Xe),o(ne),o(qe),o(se),o(Ye),o(Ae),o(N),o(Oe),o(Qe),o(U),o(Ke),o(et),o(I),o(tt),o(ot),o(T),o(nt),o(st),o(P),o(rt),o(at),o(Je)),o(n),b(y,e),b(k,e),b(A,e),b(oe,e),b(re,e),b(ae),b(D),b(ie,e),b(le),b(de),b(ce,e),b(me),b(pe),b(he,e),b(fe),b(ge),b(B),b(H),b(ue,e),b(_e),b(be),b(S),b(V),b(ve,e)}}}const uo='{"title":"GLPN","local":"glpn","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"GLPNConfig","local":"transformers.GLPNConfig","sections":[],"depth":2},{"title":"GLPNFeatureExtractor","local":"transformers.GLPNFeatureExtractor","sections":[],"depth":2},{"title":"GLPNImageProcessor","local":"transformers.GLPNImageProcessor","sections":[],"depth":2},{"title":"GLPNModel","local":"transformers.GLPNModel","sections":[],"depth":2},{"title":"GLPNForDepthEstimation","local":"transformers.GLPNForDepthEstimation","sections":[],"depth":2}],"depth":1}';function _o(L){return no(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Lo extends so{constructor(n){super(),ro(this,n,_o,go,to,{})}}export{Lo as component};
