import{s as xe,o as ze,n as Me}from"../chunks/scheduler.18a86fab.js";import{S as Ae,i as Ge,g as c,s as r,r as h,A as Se,h as m,f as n,c as l,j as pe,u as w,x as y,k as H,y as z,a as s,v as T,d as k,t as b,w as v}from"../chunks/index.98837b22.js";import{T as Pe}from"../chunks/Tip.77304350.js";import{D as ye}from"../chunks/Docstring.6758ea23.js";import{C as _e}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as $e}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as X}from"../chunks/Heading.7e7e0c5b.js";import{E as Ue}from"../chunks/index.499f366c.js";function Ce(V){let o,M=`The implementation uses the <code>GPT2Model</code> coupled with our <code>GPTSw3Tokenizer</code>. Refer to <a href="gpt2">GPT2Model documentation</a>
for API reference and examples.`,d,i,g="Note that sentencepiece is required to use our tokenizer and can be installed with <code>pip install transformers[sentencepiece]</code> or <code>pip install sentencepiece</code>";return{c(){o=c("p"),o.innerHTML=M,d=r(),i=c("p"),i.innerHTML=g},l(a){o=m(a,"P",{"data-svelte-h":!0}),y(o)!=="svelte-13njngq"&&(o.innerHTML=M),d=l(a),i=m(a,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1oicrkv"&&(i.innerHTML=g)},m(a,p){s(a,o,p),s(a,d,p),s(a,i,p)},p:Me,d(a){a&&(n(o),n(d),n(i))}}}function Je(V){let o,M="Example usage:",d,i,g;return i=new _e({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVFN3M1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEdQVFN3M1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyQUktU3dlZGVuLU1vZGVscyUyRmdwdC1zdzMtMTI2bSUyMiklMEF0b2tlbml6ZXIoJTIyU3ZlbnNrYSUyMCVDMyVBNHIlMjBrdWwhJTIyKSU1QiUyMmlucHV0X2lkcyUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPTSw3Tokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPTSw3Tokenizer.from_pretrained(<span class="hljs-string">&quot;AI-Sweden-Models/gpt-sw3-126m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer(<span class="hljs-string">&quot;Svenska är kul!&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
[<span class="hljs-number">1814</span>, <span class="hljs-number">377</span>, <span class="hljs-number">3617</span>, <span class="hljs-number">63504</span>]`,wrap:!1}}),{c(){o=c("p"),o.textContent=M,d=r(),h(i.$$.fragment)},l(a){o=m(a,"P",{"data-svelte-h":!0}),y(o)!=="svelte-1ni337v"&&(o.textContent=M),d=l(a),w(i.$$.fragment,a)},m(a,p){s(a,o,p),s(a,d,p),T(i,a,p),g=!0},p:Me,i(a){g||(k(i.$$.fragment,a),g=!0)},o(a){b(i.$$.fragment,a),g=!1},d(a){a&&(n(o),n(d)),v(i,a)}}}function Ze(V){let o,M,d,i,g,a,p,fe=`<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="TensorFlow" src="https://img.shields.io/badge/TensorFlow-FF6F00?style=flat&amp;logo=tensorflow&amp;logoColor=white"/> <img alt="Flax" src="https://img.shields.io/badge/Flax-29a79b.svg?style=flat&amp;logo=data:image/png;base64,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
"/>`,F,A,O,G,ue=`The GPT-Sw3 model was first proposed in
<a href="http://www.lrec-conf.org/proceedings/lrec2022/pdf/2022.lrec-1.376.pdf" rel="nofollow">Lessons Learned from GPT-SW3: Building the First Large-Scale Generative Language Model for Swedish</a>
by Ariel Ekgren, Amaru Cuba Gyllensten, Evangelia Gogoulou, Alice Heiman, Severine Verlinden, Joey Öhman,
Fredrik Carlsson, Magnus Sahlgren.`,B,S,he="Since that first paper the authors have extended their work and trained new models on their new 1.2TB corpora named The Nordic Pile.",Y,P,we=`GPT-Sw3 is a collection of large decoder-only pretrained transformer language models that were developed by AI Sweden
in collaboration with RISE and the WASP WARA for Media and Language. GPT-Sw3 has been trained on a dataset containing
320B tokens in Swedish, Norwegian, Danish, Icelandic, English, and programming code. The model was pretrained using a
causal language modeling (CLM) objective utilizing the NeMo Megatron GPT implementation.`,K,$,Te='This model was contributed by <a href="https://huggingface.co/AI-Sweden-Models" rel="nofollow">AI Sweden Models</a>.',D,U,ee,C,te,J,ne,Z,ke='<li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/token_classification">Token classification task guide</a></li> <li><a href="../tasks/language_modeling">Causal language modeling task guide</a></li>',se,_,ae,j,oe,f,E,ce,N,be='Construct an GPTSw3 tokenizer. Based on <a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a>.',me,W,ve=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,de,x,ge,R,L,re,I,le,Q,ie;return g=new X({props:{title:"GPT-Sw3",local:"gpt-sw3",headingTag:"h1"}}),A=new X({props:{title:"Overview",local:"overview",headingTag:"h2"}}),U=new X({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),C=new _e({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkFJLVN3ZWRlbi1Nb2RlbHMlMkZncHQtc3czLTM1Nm0lMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyQUktU3dlZGVuLU1vZGVscyUyRmdwdC1zdzMtMzU2bSUyMiklMEElMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyVHIlQzMlQTRkJTIwJUMzJUE0ciUyMGZpbmElMjBmJUMzJUI2ciUyMGF0dCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBZ2VuZXJhdGVkX3Rva2VuX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyUzRGlucHV0X2lkcyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSU1QjAlNUQlMEElMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKGdlbmVyYXRlZF90b2tlbl9pZHMpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;AI-Sweden-Models/gpt-sw3-356m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;AI-Sweden-Models/gpt-sw3-356m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(<span class="hljs-string">&quot;Träd är fina för att&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_token_ids = model.generate(inputs=input_ids, max_new_tokens=<span class="hljs-number">10</span>, do_sample=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(generated_token_ids))
Träd är fina för att de är färgstarka. Men ibland är det fint`,wrap:!1}}),J=new X({props:{title:"Resources",local:"resources",headingTag:"h2"}}),_=new Pe({props:{$$slots:{default:[Ce]},$$scope:{ctx:V}}}),j=new X({props:{title:"GPTSw3Tokenizer",local:"transformers.GPTSw3Tokenizer",headingTag:"h2"}}),E=new ye({props:{name:"class transformers.GPTSw3Tokenizer",anchor:"transformers.GPTSw3Tokenizer",parameters:[{name:"vocab_file",val:""},{name:"do_lower_case",val:" = False"},{name:"remove_space",val:" = False"},{name:"keep_accents",val:" = False"},{name:"pad_token",val:" = None"},{name:"unk_token",val:" = None"},{name:"eos_token",val:" = None"},{name:"bos_token",val:" = None"},{name:"sp_model_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GPTSw3Tokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a <em>.spm</em> extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.GPTSw3Tokenizer.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.GPTSw3Tokenizer.remove_space",description:`<strong>remove_space</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to strip the text when tokenizing (removing excess spaces before and after the string).`,name:"remove_space"},{anchor:"transformers.GPTSw3Tokenizer.keep_accents",description:`<strong>keep_accents</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to keep accents when tokenizing.`,name:"keep_accents"},{anchor:"transformers.GPTSw3Tokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token used for padding, for example when batching sequences of different lengths. If not provided, will
default to &#x2019;<pad>&#x2019; or &#x2019;<unk>&#x2019; depending on model size.</unk></pad>`,name:"pad_token"},{anchor:"transformers.GPTSw3Tokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead. If not provided, will default to &#x2019;<unk>&#x2018;.</unk>`,name:"unk_token"},{anchor:"transformers.GPTSw3Tokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The end of sequence token seen during pretraining. If not provided, will default to &#x2019;&lt;|endoftext|&gt;&#x2019;`,name:"eos_token"},{anchor:"transformers.GPTSw3Tokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The beginning of sequence token that can be used for downstream task, was not seen during pretraining. If
not provided, will default to &#x2019;<s>&#x2019; or &#x2019;&lt;|endoftext|&gt;&#x2019;, depending on model size.</s>`,name:"bos_token"},{anchor:"transformers.GPTSw3Tokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Will be passed to the <code>SentencePieceProcessor.__init__()</code> method. The <a href="https://github.com/google/sentencepiece/tree/master/python" rel="nofollow">Python wrapper for
SentencePiece</a> can be used, among other things,
to set:</p>
<ul>
<li>
<p><code>enable_sampling</code>: Enable subword regularization.</p>
</li>
<li>
<p><code>nbest_size</code>: Sampling parameters for unigram. Invalid for BPE-Dropout.</p>
<ul>
<li><code>nbest_size = {0,1}</code>: No sampling is performed.</li>
<li><code>nbest_size &gt; 1</code>: samples from the nbest_size results.</li>
<li><code>nbest_size &lt; 0</code>: assuming that nbest_size is infinite and samples from the all hypothesis (lattice)
using forward-filtering-and-backward-sampling algorithm.</li>
</ul>
</li>
<li>
<p><code>alpha</code>: Smoothing parameter for unigram sampling, and dropout probability of merge operations for
BPE-dropout.</p>
</li>
</ul>`,name:"sp_model_kwargs"},{anchor:"transformers.GPTSw3Tokenizer.sp_model",description:`<strong>sp_model</strong> (<code>SentencePieceProcessor</code>) &#x2014;
The <em>SentencePiece</em> processor that is used for every conversion (string, tokens and IDs).`,name:"sp_model"},{anchor:"transformers.GPTSw3Tokenizer.whitespaces",description:`<strong>whitespaces</strong> (<code>set</code>) &#x2014;
The whitespaces that are replaced in the whitespace normalization in preprocessing.`,name:"whitespaces"},{anchor:"transformers.GPTSw3Tokenizer.non_printing_characters_re",description:`<strong>non_printing_characters_re</strong> (<code>Pattern</code>) &#x2014;
The compiled regular expression to remove non-printing characters in preprocessing.`,name:"non_printing_characters_re"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gpt_sw3/tokenization_gpt_sw3.py#L24"}}),x=new $e({props:{anchor:"transformers.GPTSw3Tokenizer.example",$$slots:{default:[Je]},$$scope:{ctx:V}}}),L=new ye({props:{name:"save_vocabulary",anchor:"transformers.GPTSw3Tokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/gpt_sw3/tokenization_gpt_sw3.py#L236"}}),I=new Ue({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/gpt-sw3.md"}}),{c(){o=c("meta"),M=r(),d=c("p"),i=r(),h(g.$$.fragment),a=r(),p=c("div"),p.innerHTML=fe,F=r(),h(A.$$.fragment),O=r(),G=c("p"),G.innerHTML=ue,B=r(),S=c("p"),S.textContent=he,Y=r(),P=c("p"),P.textContent=we,K=r(),$=c("p"),$.innerHTML=Te,D=r(),h(U.$$.fragment),ee=r(),h(C.$$.fragment),te=r(),h(J.$$.fragment),ne=r(),Z=c("ul"),Z.innerHTML=ke,se=r(),h(_.$$.fragment),ae=r(),h(j.$$.fragment),oe=r(),f=c("div"),h(E.$$.fragment),ce=r(),N=c("p"),N.innerHTML=be,me=r(),W=c("p"),W.innerHTML=ve,de=r(),h(x.$$.fragment),ge=r(),R=c("div"),h(L.$$.fragment),re=r(),h(I.$$.fragment),le=r(),Q=c("p"),this.h()},l(e){const t=Se("svelte-u9bgzb",document.head);o=m(t,"META",{name:!0,content:!0}),t.forEach(n),M=l(e),d=m(e,"P",{}),pe(d).forEach(n),i=l(e),w(g.$$.fragment,e),a=l(e),p=m(e,"DIV",{class:!0,"data-svelte-h":!0}),y(p)!=="svelte-1px1zvi"&&(p.innerHTML=fe),F=l(e),w(A.$$.fragment,e),O=l(e),G=m(e,"P",{"data-svelte-h":!0}),y(G)!=="svelte-1qucz45"&&(G.innerHTML=ue),B=l(e),S=m(e,"P",{"data-svelte-h":!0}),y(S)!=="svelte-1uddber"&&(S.textContent=he),Y=l(e),P=m(e,"P",{"data-svelte-h":!0}),y(P)!=="svelte-19zkpwq"&&(P.textContent=we),K=l(e),$=m(e,"P",{"data-svelte-h":!0}),y($)!=="svelte-p3ijej"&&($.innerHTML=Te),D=l(e),w(U.$$.fragment,e),ee=l(e),w(C.$$.fragment,e),te=l(e),w(J.$$.fragment,e),ne=l(e),Z=m(e,"UL",{"data-svelte-h":!0}),y(Z)!=="svelte-v6nfyh"&&(Z.innerHTML=ke),se=l(e),w(_.$$.fragment,e),ae=l(e),w(j.$$.fragment,e),oe=l(e),f=m(e,"DIV",{class:!0});var u=pe(f);w(E.$$.fragment,u),ce=l(u),N=m(u,"P",{"data-svelte-h":!0}),y(N)!=="svelte-19f98fg"&&(N.innerHTML=be),me=l(u),W=m(u,"P",{"data-svelte-h":!0}),y(W)!=="svelte-1c3t5ty"&&(W.innerHTML=ve),de=l(u),w(x.$$.fragment,u),ge=l(u),R=m(u,"DIV",{class:!0});var q=pe(R);w(L.$$.fragment,q),q.forEach(n),u.forEach(n),re=l(e),w(I.$$.fragment,e),le=l(e),Q=m(e,"P",{}),pe(Q).forEach(n),this.h()},h(){H(o,"name","hf:doc:metadata"),H(o,"content",je),H(p,"class","flex flex-wrap space-x-1"),H(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){z(document.head,o),s(e,M,t),s(e,d,t),s(e,i,t),T(g,e,t),s(e,a,t),s(e,p,t),s(e,F,t),T(A,e,t),s(e,O,t),s(e,G,t),s(e,B,t),s(e,S,t),s(e,Y,t),s(e,P,t),s(e,K,t),s(e,$,t),s(e,D,t),T(U,e,t),s(e,ee,t),T(C,e,t),s(e,te,t),T(J,e,t),s(e,ne,t),s(e,Z,t),s(e,se,t),T(_,e,t),s(e,ae,t),T(j,e,t),s(e,oe,t),s(e,f,t),T(E,f,null),z(f,ce),z(f,N),z(f,me),z(f,W),z(f,de),T(x,f,null),z(f,ge),z(f,R),T(L,R,null),s(e,re,t),T(I,e,t),s(e,le,t),s(e,Q,t),ie=!0},p(e,[t]){const u={};t&2&&(u.$$scope={dirty:t,ctx:e}),_.$set(u);const q={};t&2&&(q.$$scope={dirty:t,ctx:e}),x.$set(q)},i(e){ie||(k(g.$$.fragment,e),k(A.$$.fragment,e),k(U.$$.fragment,e),k(C.$$.fragment,e),k(J.$$.fragment,e),k(_.$$.fragment,e),k(j.$$.fragment,e),k(E.$$.fragment,e),k(x.$$.fragment,e),k(L.$$.fragment,e),k(I.$$.fragment,e),ie=!0)},o(e){b(g.$$.fragment,e),b(A.$$.fragment,e),b(U.$$.fragment,e),b(C.$$.fragment,e),b(J.$$.fragment,e),b(_.$$.fragment,e),b(j.$$.fragment,e),b(E.$$.fragment,e),b(x.$$.fragment,e),b(L.$$.fragment,e),b(I.$$.fragment,e),ie=!1},d(e){e&&(n(M),n(d),n(i),n(a),n(p),n(F),n(O),n(G),n(B),n(S),n(Y),n(P),n(K),n($),n(D),n(ee),n(te),n(ne),n(Z),n(se),n(ae),n(oe),n(f),n(re),n(le),n(Q)),n(o),v(g,e),v(A,e),v(U,e),v(C,e),v(J,e),v(_,e),v(j,e),v(E),v(x),v(L),v(I,e)}}}const je='{"title":"GPT-Sw3","local":"gpt-sw3","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"GPTSw3Tokenizer","local":"transformers.GPTSw3Tokenizer","sections":[],"depth":2}],"depth":1}';function Ee(V){return ze(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class He extends Ae{constructor(o){super(),Ge(this,o,Ee,Ze,xe,{})}}export{He as component};
