import{s as nt,o as ot,n as He}from"../chunks/scheduler.18a86fab.js";import{S as st,i as at,g as m,s as l,r as T,A as rt,h as p,f as a,c as i,j as Ze,u as M,x as y,k as je,l as lt,y as u,a as r,v as w,d as v,t as $,w as C}from"../chunks/index.98837b22.js";import{T as Ae}from"../chunks/Tip.77304350.js";import{D as Ve}from"../chunks/Docstring.6758ea23.js";import{C as Ee}from"../chunks/CodeBlock.8d0c2e8a.js";import{F as it,M as tt}from"../chunks/Markdown.ae01904b.js";import{E as De}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as Je}from"../chunks/Heading.7e7e0c5b.js";import{E as dt}from"../chunks/index.499f366c.js";function ct(j){let t,h="Example:",n,s,b;return s=new Ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEh1YmVydE1vZGVsJTJDJTIwSHViZXJ0Q29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEh1YmVydCUyMGZhY2Vib29rJTJGaHViZXJ0LWJhc2UtbHM5NjAlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwSHViZXJ0Q29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwZmFjZWJvb2slMkZodWJlcnQtYmFzZS1sczk2MCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwSHViZXJ0TW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HubertModel, HubertConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Hubert facebook/hubert-base-ls960 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = HubertConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the facebook/hubert-base-ls960 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = HubertModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=m("p"),t.textContent=h,n=l(),T(s.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-11lpom8"&&(t.textContent=h),n=i(o),M(s.$$.fragment,o)},m(o,_){r(o,t,_),r(o,n,_),w(s,o,_),b=!0},p:He,i(o){b||(v(s.$$.fragment,o),b=!0)},o(o){$(s.$$.fragment,o),b=!1},d(o){o&&(a(t),a(n)),C(s,o)}}}function mt(j){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=h},l(n){t=p(n,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(n,s){r(n,t,s)},p:He,d(n){n&&a(t)}}}function pt(j){let t,h="Example:",n,s,b;return s=new Ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBIdWJlcnRNb2RlbCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHNvdW5kZmlsZSUyMGFzJTIwc2YlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmh1YmVydC1sYXJnZS1sczk2MC1mdCUyMiklMEFtb2RlbCUyMCUzRCUyMEh1YmVydE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmh1YmVydC1sYXJnZS1sczk2MC1mdCUyMiklMEElMEElMEFkZWYlMjBtYXBfdG9fYXJyYXkoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwc3BlZWNoJTJDJTIwXyUyMCUzRCUyMHNmLnJlYWQoYmF0Y2glNUIlMjJmaWxlJTIyJTVEKSUwQSUyMCUyMCUyMCUyMGJhdGNoJTVCJTIyc3BlZWNoJTIyJTVEJTIwJTNEJTIwc3BlZWNoJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2glMEElMEElMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZHMlMjAlM0QlMjBkcy5tYXAobWFwX3RvX2FycmF5KSUwQSUwQWlucHV0X3ZhbHVlcyUyMCUzRCUyMHByb2Nlc3NvcihkcyU1QiUyMnNwZWVjaCUyMiU1RCU1QjAlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF92YWx1ZXMlMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG1vZGVsKGlucHV0X3ZhbHVlcykubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, HubertModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/hubert-large-ls960-ft&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = HubertModel.from_pretrained(<span class="hljs-string">&quot;facebook/hubert-large-ls960-ft&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_array</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    speech, _ = sf.read(batch[<span class="hljs-string">&quot;file&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;speech&quot;</span>] = speech
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.<span class="hljs-built_in">map</span>(map_to_array)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = processor(ds[<span class="hljs-string">&quot;speech&quot;</span>][<span class="hljs-number">0</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_values  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hidden_states = model(input_values).last_hidden_state`,wrap:!1}}),{c(){t=m("p"),t.textContent=h,n=l(),T(s.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-11lpom8"&&(t.textContent=h),n=i(o),M(s.$$.fragment,o)},m(o,_){r(o,t,_),r(o,n,_),w(s,o,_),b=!0},p:He,i(o){b||(v(s.$$.fragment,o),b=!0)},o(o){$(s.$$.fragment,o),b=!1},d(o){o&&(a(t),a(n)),C(s,o)}}}function ut(j){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=h},l(n){t=p(n,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(n,s){r(n,t,s)},p:He,d(n){n&&a(t)}}}function ht(j){let t,h="Example:",n,s,b;return s=new Ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBIdWJlcnRGb3JDVEMlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmh1YmVydC1iYXNlLWxzOTYwJTIyKSUwQW1vZGVsJTIwJTNEJTIwSHViZXJ0Rm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmh1YmVydC1iYXNlLWxzOTYwJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9pZHMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTBBJTIzJTIwdHJhbnNjcmliZSUyMHNwZWVjaCUwQXRyYW5zY3JpcHRpb24lMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKHByZWRpY3RlZF9pZHMpJTBBdHJhbnNjcmlwdGlvbiU1QjAlNUQlMEElMEFpbnB1dHMlNUIlMjJsYWJlbHMlMjIlNUQlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRGRhdGFzZXQlNUIwJTVEJTVCJTIydGV4dCUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmlucHV0X2lkcyUwQSUwQSUyMyUyMGNvbXB1dGUlMjBsb3NzJTBBbG9zcyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb3NzJTBBcm91bmQobG9zcy5pdGVtKCklMkMlMjAyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, HubertForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/hubert-base-ls960&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = HubertForCTC.from_pretrained(<span class="hljs-string">&quot;facebook/hubert-base-ls960&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># transcribe speech</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription[<span class="hljs-number">0</span>]
...

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;labels&quot;</span>] = processor(text=dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute loss</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){t=m("p"),t.textContent=h,n=l(),T(s.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-11lpom8"&&(t.textContent=h),n=i(o),M(s.$$.fragment,o)},m(o,_){r(o,t,_),r(o,n,_),w(s,o,_),b=!0},p:He,i(o){b||(v(s.$$.fragment,o),b=!0)},o(o){$(s.$$.fragment,o),b=!1},d(o){o&&(a(t),a(n)),C(s,o)}}}function ft(j){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=h},l(n){t=p(n,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(n,s){r(n,t,s)},p:He,d(n){n&&a(t)}}}function gt(j){let t,h="Example of single-label classification:",n,s,b;return s=new Ee({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEh1YmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmh1YmVydC1iYXNlLWxzOTYwJTIyKSUwQW1vZGVsJTIwJTNEJTIwSHViZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZodWJlcnQtYmFzZS1sczk2MCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWQlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KCkuaXRlbSgpJTBBbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkJTVEJTBBJTBBJTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwSHViZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZodWJlcnQtYmFzZS1sczk2MCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcyUwQXJvdW5kKGxvc3MuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, HubertForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/hubert-base-ls960&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = HubertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;facebook/hubert-base-ls960&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.id2label[predicted_class_id]
...

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = HubertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;facebook/hubert-base-ls960&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){t=m("p"),t.textContent=h,n=l(),T(s.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-ykxpe4"&&(t.textContent=h),n=i(o),M(s.$$.fragment,o)},m(o,_){r(o,t,_),r(o,n,_),w(s,o,_),b=!0},p:He,i(o){b||(v(s.$$.fragment,o),b=!0)},o(o){$(s.$$.fragment,o),b=!1},d(o){o&&(a(t),a(n)),C(s,o)}}}function bt(j){let t,h="Example of multi-label classification:",n,s,b;return s=new Ee({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEh1YmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmh1YmVydC1iYXNlLWxzOTYwJTIyKSUwQW1vZGVsJTIwJTNEJTIwSHViZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZodWJlcnQtYmFzZS1sczk2MCUyMiUyQyUyMHByb2JsZW1fdHlwZSUzRCUyMm11bHRpX2xhYmVsX2NsYXNzaWZpY2F0aW9uJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9jbGFzc19pZHMlMjAlM0QlMjB0b3JjaC5hcmFuZ2UoMCUyQyUyMGxvZ2l0cy5zaGFwZSU1Qi0xJTVEKSU1QnRvcmNoLnNpZ21vaWQobG9naXRzKS5zcXVlZXplKGRpbSUzRDApJTIwJTNFJTIwMC41JTVEJTBBJTBBJTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwSHViZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZmFjZWJvb2slMkZodWJlcnQtYmFzZS1sczk2MCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, HubertForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/hubert-base-ls960&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = HubertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;facebook/hubert-base-ls960&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = HubertForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/hubert-base-ls960&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=m("p"),t.textContent=h,n=l(),T(s.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-1l8e32d"&&(t.textContent=h),n=i(o),M(s.$$.fragment,o)},m(o,_){r(o,t,_),r(o,n,_),w(s,o,_),b=!0},p:He,i(o){b||(v(s.$$.fragment,o),b=!0)},o(o){$(s.$$.fragment,o),b=!1},d(o){o&&(a(t),a(n)),C(s,o)}}}function _t(j){let t,h,n,s,b,o,_="The bare Hubert Model outputting raw hidden-states without any specific head on top.",ue,I,F=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,te,U,V=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ne,c,H,Y,N,qe='The <a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertModel">HubertModel</a> forward method, overrides the <code>__call__</code> special method.',fe,Q,Be,R,he,q,le,W,ie,Z,P,Te="Hubert Model with a <code>language modeling</code> head on top for Connectionist Temporal Classification (CTC).",xe,Me,we=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ge,de,Xe=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,be,G,ve,ce,oe,E='The <a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertForCTC">HubertForCTC</a> forward method, overrides the <code>__call__</code> special method.',A,me,se,$e,Ue,B,Fe,x,pe,g,k,D=`Hubert Model with a sequence classification head on top (a linear layer over the pooled output) for tasks like
SUPERB Keyword Spotting.`,z,X,Ge=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ce,ke,Ne=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Oe,O,_e,Le,L,Re='The <a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertForSequenceClassification">HubertForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Qe,ye,Ke,Ie,Ye,ze,Se;return t=new Je({props:{title:"HubertModel",local:"transformers.HubertModel",headingTag:"h2"}}),s=new Ve({props:{name:"class transformers.HubertModel",anchor:"transformers.HubertModel",parameters:[{name:"config",val:": HubertConfig"}],parametersDescription:[{anchor:"transformers.HubertModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertConfig">HubertConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/hubert/modeling_hubert.py#L1116"}}),H=new Ve({props:{name:"forward",anchor:"transformers.HubertModel.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor]"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"mask_time_indices",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.HubertModel.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <code>{processor_class}.__call__</code> for details.`,name:"input_values"},{anchor:"transformers.HubertModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.HubertModel.forward.mask_time_indices",description:`<strong>mask_time_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices to mask extracted features for contrastive loss. When in training mode, model learns to predict
masked extracted features in <em>config.proj_codevector_dim</em> space.`,name:"mask_time_indices"},{anchor:"transformers.HubertModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.HubertModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.HubertModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/hubert/modeling_hubert.py#L1182",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertConfig"
>HubertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new Ae({props:{$$slots:{default:[mt]},$$scope:{ctx:j}}}),R=new De({props:{anchor:"transformers.HubertModel.forward.example",$$slots:{default:[pt]},$$scope:{ctx:j}}}),q=new Je({props:{title:"HubertForCTC",local:"transformers.HubertForCTC",headingTag:"h2"}}),ie=new Ve({props:{name:"class transformers.HubertForCTC",anchor:"transformers.HubertForCTC",parameters:[{name:"config",val:""},{name:"target_lang",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"transformers.HubertForCTC.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertForCTC">HubertForCTC</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.HubertForCTC.target_lang",description:`<strong>target_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Language id of adapter weights. Adapter weights are stored in the format adapter.<lang>.safetensors or
adapter.<lang>.bin. Only relevant when using an instance of <a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertForCTC">HubertForCTC</a> with adapters. Uses &#x2018;eng&#x2019; by
default.</lang></lang>`,name:"target_lang"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/hubert/modeling_hubert.py#L1259"}}),ve=new Ve({props:{name:"forward",anchor:"transformers.HubertForCTC.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor]"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.HubertForCTC.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <code>{processor_class}.__call__</code> for details.`,name:"input_values"},{anchor:"transformers.HubertForCTC.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.HubertForCTC.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.HubertForCTC.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.HubertForCTC.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.HubertForCTC.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, target_length)</code>, <em>optional</em>) &#x2014;
Labels for connectionist temporal classification. Note that <code>target_length</code> has to be smaller or equal to
the sequence length of the output logits. Indices are selected in <code>[-100, 0, ..., config.vocab_size - 1]</code>.
All labels set to <code>-100</code> are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/hubert/modeling_hubert.py#L1342",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertConfig"
>HubertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),me=new Ae({props:{$$slots:{default:[ut]},$$scope:{ctx:j}}}),$e=new De({props:{anchor:"transformers.HubertForCTC.forward.example",$$slots:{default:[ht]},$$scope:{ctx:j}}}),B=new Je({props:{title:"HubertForSequenceClassification",local:"transformers.HubertForSequenceClassification",headingTag:"h2"}}),pe=new Ve({props:{name:"class transformers.HubertForSequenceClassification",anchor:"transformers.HubertForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.HubertForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertForSequenceClassification">HubertForSequenceClassification</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/hubert/modeling_hubert.py#L1414"}}),_e=new Ve({props:{name:"forward",anchor:"transformers.HubertForSequenceClassification.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor]"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.HubertForSequenceClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <code>HubertProcessor.__call__</code> for details.`,name:"input_values"},{anchor:"transformers.HubertForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.HubertForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.HubertForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.HubertForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.HubertForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/hubert/modeling_hubert.py#L1465",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertConfig"
>HubertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ye=new Ae({props:{$$slots:{default:[ft]},$$scope:{ctx:j}}}),Ie=new De({props:{anchor:"transformers.HubertForSequenceClassification.forward.example",$$slots:{default:[gt]},$$scope:{ctx:j}}}),ze=new De({props:{anchor:"transformers.HubertForSequenceClassification.forward.example-2",$$slots:{default:[bt]},$$scope:{ctx:j}}}),{c(){T(t.$$.fragment),h=l(),n=m("div"),T(s.$$.fragment),b=l(),o=m("p"),o.textContent=_,ue=l(),I=m("p"),I.innerHTML=F,te=l(),U=m("p"),U.innerHTML=V,ne=l(),c=m("div"),T(H.$$.fragment),Y=l(),N=m("p"),N.innerHTML=qe,fe=l(),T(Q.$$.fragment),Be=l(),T(R.$$.fragment),he=l(),T(q.$$.fragment),le=l(),W=m("div"),T(ie.$$.fragment),Z=l(),P=m("p"),P.innerHTML=Te,xe=l(),Me=m("p"),Me.innerHTML=we,ge=l(),de=m("p"),de.innerHTML=Xe,be=l(),G=m("div"),T(ve.$$.fragment),ce=l(),oe=m("p"),oe.innerHTML=E,A=l(),T(me.$$.fragment),se=l(),T($e.$$.fragment),Ue=l(),T(B.$$.fragment),Fe=l(),x=m("div"),T(pe.$$.fragment),g=l(),k=m("p"),k.textContent=D,z=l(),X=m("p"),X.innerHTML=Ge,Ce=l(),ke=m("p"),ke.innerHTML=Ne,Oe=l(),O=m("div"),T(_e.$$.fragment),Le=l(),L=m("p"),L.innerHTML=Re,Qe=l(),T(ye.$$.fragment),Ke=l(),T(Ie.$$.fragment),Ye=l(),T(ze.$$.fragment),this.h()},l(d){M(t.$$.fragment,d),h=i(d),n=p(d,"DIV",{class:!0});var J=Ze(n);M(s.$$.fragment,J),b=i(J),o=p(J,"P",{"data-svelte-h":!0}),y(o)!=="svelte-mzxsao"&&(o.textContent=_),ue=i(J),I=p(J,"P",{"data-svelte-h":!0}),y(I)!=="svelte-6pahdo"&&(I.innerHTML=F),te=i(J),U=p(J,"P",{"data-svelte-h":!0}),y(U)!=="svelte-hswkmf"&&(U.innerHTML=V),ne=i(J),c=p(J,"DIV",{class:!0});var S=Ze(c);M(H.$$.fragment,S),Y=i(S),N=p(S,"P",{"data-svelte-h":!0}),y(N)!=="svelte-n2efan"&&(N.innerHTML=qe),fe=i(S),M(Q.$$.fragment,S),Be=i(S),M(R.$$.fragment,S),S.forEach(a),J.forEach(a),he=i(d),M(q.$$.fragment,d),le=i(d),W=p(d,"DIV",{class:!0});var ae=Ze(W);M(ie.$$.fragment,ae),Z=i(ae),P=p(ae,"P",{"data-svelte-h":!0}),y(P)!=="svelte-1ha60hk"&&(P.innerHTML=Te),xe=i(ae),Me=p(ae,"P",{"data-svelte-h":!0}),y(Me)!=="svelte-6pahdo"&&(Me.innerHTML=we),ge=i(ae),de=p(ae,"P",{"data-svelte-h":!0}),y(de)!=="svelte-hswkmf"&&(de.innerHTML=Xe),be=i(ae),G=p(ae,"DIV",{class:!0});var K=Ze(G);M(ve.$$.fragment,K),ce=i(K),oe=p(K,"P",{"data-svelte-h":!0}),y(oe)!=="svelte-lno879"&&(oe.innerHTML=E),A=i(K),M(me.$$.fragment,K),se=i(K),M($e.$$.fragment,K),K.forEach(a),ae.forEach(a),Ue=i(d),M(B.$$.fragment,d),Fe=i(d),x=p(d,"DIV",{class:!0});var re=Ze(x);M(pe.$$.fragment,re),g=i(re),k=p(re,"P",{"data-svelte-h":!0}),y(k)!=="svelte-1c2qyra"&&(k.textContent=D),z=i(re),X=p(re,"P",{"data-svelte-h":!0}),y(X)!=="svelte-6pahdo"&&(X.innerHTML=Ge),Ce=i(re),ke=p(re,"P",{"data-svelte-h":!0}),y(ke)!=="svelte-hswkmf"&&(ke.innerHTML=Ne),Oe=i(re),O=p(re,"DIV",{class:!0});var ee=Ze(O);M(_e.$$.fragment,ee),Le=i(ee),L=p(ee,"P",{"data-svelte-h":!0}),y(L)!=="svelte-13sbc9v"&&(L.innerHTML=Re),Qe=i(ee),M(ye.$$.fragment,ee),Ke=i(ee),M(Ie.$$.fragment,ee),Ye=i(ee),M(ze.$$.fragment,ee),ee.forEach(a),re.forEach(a),this.h()},h(){je(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),je(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),je(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),je(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),je(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),je(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(d,J){w(t,d,J),r(d,h,J),r(d,n,J),w(s,n,null),u(n,b),u(n,o),u(n,ue),u(n,I),u(n,te),u(n,U),u(n,ne),u(n,c),w(H,c,null),u(c,Y),u(c,N),u(c,fe),w(Q,c,null),u(c,Be),w(R,c,null),r(d,he,J),w(q,d,J),r(d,le,J),r(d,W,J),w(ie,W,null),u(W,Z),u(W,P),u(W,xe),u(W,Me),u(W,ge),u(W,de),u(W,be),u(W,G),w(ve,G,null),u(G,ce),u(G,oe),u(G,A),w(me,G,null),u(G,se),w($e,G,null),r(d,Ue,J),w(B,d,J),r(d,Fe,J),r(d,x,J),w(pe,x,null),u(x,g),u(x,k),u(x,z),u(x,X),u(x,Ce),u(x,ke),u(x,Oe),u(x,O),w(_e,O,null),u(O,Le),u(O,L),u(O,Qe),w(ye,O,null),u(O,Ke),w(Ie,O,null),u(O,Ye),w(ze,O,null),Se=!0},p(d,J){const S={};J&2&&(S.$$scope={dirty:J,ctx:d}),Q.$set(S);const ae={};J&2&&(ae.$$scope={dirty:J,ctx:d}),R.$set(ae);const K={};J&2&&(K.$$scope={dirty:J,ctx:d}),me.$set(K);const re={};J&2&&(re.$$scope={dirty:J,ctx:d}),$e.$set(re);const ee={};J&2&&(ee.$$scope={dirty:J,ctx:d}),ye.$set(ee);const Pe={};J&2&&(Pe.$$scope={dirty:J,ctx:d}),Ie.$set(Pe);const e={};J&2&&(e.$$scope={dirty:J,ctx:d}),ze.$set(e)},i(d){Se||(v(t.$$.fragment,d),v(s.$$.fragment,d),v(H.$$.fragment,d),v(Q.$$.fragment,d),v(R.$$.fragment,d),v(q.$$.fragment,d),v(ie.$$.fragment,d),v(ve.$$.fragment,d),v(me.$$.fragment,d),v($e.$$.fragment,d),v(B.$$.fragment,d),v(pe.$$.fragment,d),v(_e.$$.fragment,d),v(ye.$$.fragment,d),v(Ie.$$.fragment,d),v(ze.$$.fragment,d),Se=!0)},o(d){$(t.$$.fragment,d),$(s.$$.fragment,d),$(H.$$.fragment,d),$(Q.$$.fragment,d),$(R.$$.fragment,d),$(q.$$.fragment,d),$(ie.$$.fragment,d),$(ve.$$.fragment,d),$(me.$$.fragment,d),$($e.$$.fragment,d),$(B.$$.fragment,d),$(pe.$$.fragment,d),$(_e.$$.fragment,d),$(ye.$$.fragment,d),$(Ie.$$.fragment,d),$(ze.$$.fragment,d),Se=!1},d(d){d&&(a(h),a(n),a(he),a(le),a(W),a(Ue),a(Fe),a(x)),C(t,d),C(s),C(H),C(Q),C(R),C(q,d),C(ie),C(ve),C(me),C($e),C(B,d),C(pe),C(_e),C(ye),C(Ie),C(ze)}}}function yt(j){let t,h;return t=new tt({props:{$$slots:{default:[_t]},$$scope:{ctx:j}}}),{c(){T(t.$$.fragment)},l(n){M(t.$$.fragment,n)},m(n,s){w(t,n,s),h=!0},p(n,s){const b={};s&2&&(b.$$scope={dirty:s,ctx:n}),t.$set(b)},i(n){h||(v(t.$$.fragment,n),h=!0)},o(n){$(t.$$.fragment,n),h=!1},d(n){C(t,n)}}}function Tt(j){let t,h="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",n,s,b="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,_,ue=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,I,F,te=`<li>a single Tensor with <code>input_values</code> only and nothing else: <code>model(input_values)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_values, attention_mask])</code> or <code>model([input_values, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_values&quot;: input_values, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,U,V,ne=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){t=m("p"),t.innerHTML=h,n=l(),s=m("ul"),s.innerHTML=b,o=l(),_=m("p"),_.innerHTML=ue,I=l(),F=m("ul"),F.innerHTML=te,U=l(),V=m("p"),V.innerHTML=ne},l(c){t=p(c,"P",{"data-svelte-h":!0}),y(t)!=="svelte-1ajbfxg"&&(t.innerHTML=h),n=i(c),s=p(c,"UL",{"data-svelte-h":!0}),y(s)!=="svelte-qm1t26"&&(s.innerHTML=b),o=i(c),_=p(c,"P",{"data-svelte-h":!0}),y(_)!=="svelte-1v9qsc5"&&(_.innerHTML=ue),I=i(c),F=p(c,"UL",{"data-svelte-h":!0}),y(F)!=="svelte-1x9eg56"&&(F.innerHTML=te),U=i(c),V=p(c,"P",{"data-svelte-h":!0}),y(V)!=="svelte-1an3odd"&&(V.innerHTML=ne)},m(c,H){r(c,t,H),r(c,n,H),r(c,s,H),r(c,o,H),r(c,_,H),r(c,I,H),r(c,F,H),r(c,U,H),r(c,V,H)},p:He,d(c){c&&(a(t),a(n),a(s),a(o),a(_),a(I),a(F),a(U),a(V))}}}function Mt(j){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=h},l(n){t=p(n,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(n,s){r(n,t,s)},p:He,d(n){n&&a(t)}}}function wt(j){let t,h="Example:",n,s,b;return s=new Ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBURkh1YmVydE1vZGVsJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwc291bmRmaWxlJTIwYXMlMjBzZiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGaHViZXJ0LWxhcmdlLWxzOTYwLWZ0JTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZIdWJlcnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZodWJlcnQtbGFyZ2UtbHM5NjAtZnQlMjIpJTBBJTBBJTBBZGVmJTIwbWFwX3RvX2FycmF5KGJhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMHNwZWVjaCUyQyUyMF8lMjAlM0QlMjBzZi5yZWFkKGJhdGNoJTVCJTIyZmlsZSUyMiU1RCklMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnNwZWVjaCUyMiU1RCUyMCUzRCUyMHNwZWVjaCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGJhdGNoJTBBJTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRzJTIwJTNEJTIwZHMubWFwKG1hcF90b19hcnJheSklMEElMEFpbnB1dF92YWx1ZXMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIlMjJzcGVlY2glMjIlNUQlNUIwJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMikuaW5wdXRfdmFsdWVzJTIwJTIwJTIzJTIwQmF0Y2glMjBzaXplJTIwMSUwQWhpZGRlbl9zdGF0ZXMlMjAlM0QlMjBtb2RlbChpbnB1dF92YWx1ZXMpLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, TFHubertModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/hubert-large-ls960-ft&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFHubertModel.from_pretrained(<span class="hljs-string">&quot;facebook/hubert-large-ls960-ft&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_array</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    speech, _ = sf.read(batch[<span class="hljs-string">&quot;file&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;speech&quot;</span>] = speech
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.<span class="hljs-built_in">map</span>(map_to_array)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = processor(ds[<span class="hljs-string">&quot;speech&quot;</span>][<span class="hljs-number">0</span>], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>).input_values  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hidden_states = model(input_values).last_hidden_state`,wrap:!1}}),{c(){t=m("p"),t.textContent=h,n=l(),T(s.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-11lpom8"&&(t.textContent=h),n=i(o),M(s.$$.fragment,o)},m(o,_){r(o,t,_),r(o,n,_),w(s,o,_),b=!0},p:He,i(o){b||(v(s.$$.fragment,o),b=!0)},o(o){$(s.$$.fragment,o),b=!1},d(o){o&&(a(t),a(n)),C(s,o)}}}function vt(j){let t,h="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",n,s,b="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",o,_,ue=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,I,F,te=`<li>a single Tensor with <code>input_values</code> only and nothing else: <code>model(input_values)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_values, attention_mask])</code> or <code>model([input_values, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_values&quot;: input_values, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,U,V,ne=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){t=m("p"),t.innerHTML=h,n=l(),s=m("ul"),s.innerHTML=b,o=l(),_=m("p"),_.innerHTML=ue,I=l(),F=m("ul"),F.innerHTML=te,U=l(),V=m("p"),V.innerHTML=ne},l(c){t=p(c,"P",{"data-svelte-h":!0}),y(t)!=="svelte-1ajbfxg"&&(t.innerHTML=h),n=i(c),s=p(c,"UL",{"data-svelte-h":!0}),y(s)!=="svelte-qm1t26"&&(s.innerHTML=b),o=i(c),_=p(c,"P",{"data-svelte-h":!0}),y(_)!=="svelte-1v9qsc5"&&(_.innerHTML=ue),I=i(c),F=p(c,"UL",{"data-svelte-h":!0}),y(F)!=="svelte-1x9eg56"&&(F.innerHTML=te),U=i(c),V=p(c,"P",{"data-svelte-h":!0}),y(V)!=="svelte-1an3odd"&&(V.innerHTML=ne)},m(c,H){r(c,t,H),r(c,n,H),r(c,s,H),r(c,o,H),r(c,_,H),r(c,I,H),r(c,F,H),r(c,U,H),r(c,V,H)},p:He,d(c){c&&(a(t),a(n),a(s),a(o),a(_),a(I),a(F),a(U),a(V))}}}function $t(j){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=h},l(n){t=p(n,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(n,s){r(n,t,s)},p:He,d(n){n&&a(t)}}}function Ct(j){let t,h="Example:",n,s,b;return s=new Ee({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMFRGSHViZXJ0Rm9yQ1RDJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwc291bmRmaWxlJTIwYXMlMjBzZiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGaHViZXJ0LWxhcmdlLWxzOTYwLWZ0JTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZIdWJlcnRGb3JDVEMuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGaHViZXJ0LWxhcmdlLWxzOTYwLWZ0JTIyKSUwQSUwQSUwQWRlZiUyMG1hcF90b19hcnJheShiYXRjaCklM0ElMEElMjAlMjAlMjAlMjBzcGVlY2glMkMlMjBfJTIwJTNEJTIwc2YucmVhZChiYXRjaCU1QiUyMmZpbGUlMjIlNUQpJTBBJTIwJTIwJTIwJTIwYmF0Y2glNUIlMjJzcGVlY2glMjIlNUQlMjAlM0QlMjBzcGVlY2glMEElMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaCUwQSUwQSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkcyUyMCUzRCUyMGRzLm1hcChtYXBfdG9fYXJyYXkpJTBBJTBBaW5wdXRfdmFsdWVzJTIwJTNEJTIwcHJvY2Vzc29yKGRzJTVCJTIyc3BlZWNoJTIyJTVEJTVCMCU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpLmlucHV0X3ZhbHVlcyUyMCUyMCUyMyUyMEJhdGNoJTIwc2l6ZSUyMDElMEFsb2dpdHMlMjAlM0QlMjBtb2RlbChpbnB1dF92YWx1ZXMpLmxvZ2l0cyUwQXByZWRpY3RlZF9pZHMlMjAlM0QlMjB0Zi5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSUwQSUwQXRyYW5zY3JpcHRpb24lMjAlM0QlMjBwcm9jZXNzb3IuZGVjb2RlKHByZWRpY3RlZF9pZHMlNUIwJTVEKSUwQSUwQSUyMyUyMGNvbXB1dGUlMjBsb3NzJTBBdGFyZ2V0X3RyYW5zY3JpcHRpb24lMjAlM0QlMjAlMjJBJTIwTUFOJTIwU0FJRCUyMFRPJTIwVEhFJTIwVU5JVkVSU0UlMjBTSVIlMjBJJTIwRVhJU1QlMjIlMEElMEElMjMlMjBQYXNzJTIwdGhlJTIwdHJhbnNjcmlwdGlvbiUyMGFzJTIwdGV4dCUyMHRvJTIwZW5jb2RlJTIwbGFiZWxzJTBBbGFiZWxzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0R0cmFuc2NyaXB0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMikuaW5wdXRfdmFsdWVzJTBBJTBBbG9zcyUyMCUzRCUyMG1vZGVsKGlucHV0X3ZhbHVlcyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, TFHubertForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> soundfile <span class="hljs-keyword">as</span> sf

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/hubert-large-ls960-ft&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFHubertForCTC.from_pretrained(<span class="hljs-string">&quot;facebook/hubert-large-ls960-ft&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">map_to_array</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    speech, _ = sf.read(batch[<span class="hljs-string">&quot;file&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;speech&quot;</span>] = speech
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch


<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.<span class="hljs-built_in">map</span>(map_to_array)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = processor(ds[<span class="hljs-string">&quot;speech&quot;</span>][<span class="hljs-number">0</span>], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>).input_values  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(input_values).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = tf.argmax(logits, axis=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.decode(predicted_ids[<span class="hljs-number">0</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute loss</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_transcription = <span class="hljs-string">&quot;A MAN SAID TO THE UNIVERSE SIR I EXIST&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pass the transcription as text to encode labels</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = processor(text=transcription, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>).input_values

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(input_values, labels=labels).loss`,wrap:!1}}),{c(){t=m("p"),t.textContent=h,n=l(),T(s.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-11lpom8"&&(t.textContent=h),n=i(o),M(s.$$.fragment,o)},m(o,_){r(o,t,_),r(o,n,_),w(s,o,_),b=!0},p:He,i(o){b||(v(s.$$.fragment,o),b=!0)},o(o){$(s.$$.fragment,o),b=!1},d(o){o&&(a(t),a(n)),C(s,o)}}}function kt(j){let t,h,n,s,b,o,_="The bare TFHubert Model transformer outputting raw hidden-states without any specific head on top.",ue,I,F=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,te,U,V=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,ne,c,H,Y,N,qe,fe,Q='The <a href="/docs/transformers/main/en/model_doc/hubert#transformers.TFHubertModel">TFHubertModel</a> forward method, overrides the <code>__call__</code> special method.',Be,R,he,q,le,W,ie,Z,P,Te,xe,Me="TFHubert Model with a <code>language modeling</code> head on top for Connectionist Temporal Classification (CTC).",we,ge,de=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Xe,be,G=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,ve,ce,oe,E,A,me,se,$e='The <a href="/docs/transformers/main/en/model_doc/hubert#transformers.TFHubertForCTC">TFHubertForCTC</a> forward method, overrides the <code>__call__</code> special method.',Ue,B,Fe,x,pe;return t=new Je({props:{title:"TFHubertModel",local:"transformers.TFHubertModel",headingTag:"h2"}}),s=new Ve({props:{name:"class transformers.TFHubertModel",anchor:"transformers.TFHubertModel",parameters:[{name:"config",val:": HubertConfig"},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFHubertModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertConfig">HubertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/hubert/modeling_tf_hubert.py#L1427"}}),c=new Ae({props:{$$slots:{default:[Tt]},$$scope:{ctx:j}}}),N=new Ve({props:{name:"call",anchor:"transformers.TFHubertModel.call",parameters:[{name:"input_values",val:": tf.Tensor"},{name:"attention_mask",val:": tf.Tensor | None = None"},{name:"token_type_ids",val:": tf.Tensor | None = None"},{name:"position_ids",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"inputs_embeds",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFHubertModel.call.input_values",description:`<strong>input_values</strong> (<code>np.ndarray</code>, <code>tf.Tensor</code>, <code>List[tf.Tensor]</code> <code>Dict[str, tf.Tensor]</code> or <code>Dict[str, np.ndarray]</code> and each example must have the shape <code>({0})</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_values"},{anchor:"transformers.TFHubertModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFHubertModel.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFHubertModel.call.position_ids",description:`<strong>position_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFHubertModel.call.head_mask",description:`<strong>head_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFHubertModel.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0}, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_values</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_values</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFHubertModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFHubertModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFHubertModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFHubertModel.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to \`False&#x201C;) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/hubert/modeling_tf_hubert.py#L1437",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutput"
>transformers.modeling_tf_outputs.TFBaseModelOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertConfig"
>HubertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutput"
>transformers.modeling_tf_outputs.TFBaseModelOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),R=new Ae({props:{$$slots:{default:[Mt]},$$scope:{ctx:j}}}),q=new De({props:{anchor:"transformers.TFHubertModel.call.example",$$slots:{default:[wt]},$$scope:{ctx:j}}}),W=new Je({props:{title:"TFHubertForCTC",local:"transformers.TFHubertForCTC",headingTag:"h2"}}),P=new Ve({props:{name:"class transformers.TFHubertForCTC",anchor:"transformers.TFHubertForCTC",parameters:[{name:"config",val:": HubertConfig"},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFHubertForCTC.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertConfig">HubertConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/hubert/modeling_tf_hubert.py#L1509"}}),ce=new Ae({props:{$$slots:{default:[vt]},$$scope:{ctx:j}}}),A=new Ve({props:{name:"call",anchor:"transformers.TFHubertForCTC.call",parameters:[{name:"input_values",val:": tf.Tensor"},{name:"attention_mask",val:": tf.Tensor | None = None"},{name:"token_type_ids",val:": tf.Tensor | None = None"},{name:"position_ids",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"inputs_embeds",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"labels",val:": tf.Tensor | None = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFHubertForCTC.call.input_values",description:`<strong>input_values</strong> (<code>np.ndarray</code>, <code>tf.Tensor</code>, <code>List[tf.Tensor]</code> <code>Dict[str, tf.Tensor]</code> or <code>Dict[str, np.ndarray]</code> and each example must have the shape <code>({0})</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_values"},{anchor:"transformers.TFHubertForCTC.call.attention_mask",description:`<strong>attention_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFHubertForCTC.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFHubertForCTC.call.position_ids",description:`<strong>position_ids</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFHubertForCTC.call.head_mask",description:`<strong>head_mask</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFHubertForCTC.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>np.ndarray</code> or <code>tf.Tensor</code> of shape <code>({0}, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_values</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_values</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFHubertForCTC.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFHubertForCTC.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFHubertForCTC.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFHubertForCTC.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to \`False&#x201C;) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFHubertForCTC.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> or <code>np.ndarray</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_values</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked),
the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/hubert/modeling_tf_hubert.py#L1543",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFCausalLMOutput"
>transformers.modeling_tf_outputs.TFCausalLMOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertConfig"
>HubertConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFCausalLMOutput"
>transformers.modeling_tf_outputs.TFCausalLMOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),B=new Ae({props:{$$slots:{default:[$t]},$$scope:{ctx:j}}}),x=new De({props:{anchor:"transformers.TFHubertForCTC.call.example",$$slots:{default:[Ct]},$$scope:{ctx:j}}}),{c(){T(t.$$.fragment),h=l(),n=m("div"),T(s.$$.fragment),b=l(),o=m("p"),o.textContent=_,ue=l(),I=m("p"),I.innerHTML=F,te=l(),U=m("p"),U.innerHTML=V,ne=l(),T(c.$$.fragment),H=l(),Y=m("div"),T(N.$$.fragment),qe=l(),fe=m("p"),fe.innerHTML=Q,Be=l(),T(R.$$.fragment),he=l(),T(q.$$.fragment),le=l(),T(W.$$.fragment),ie=l(),Z=m("div"),T(P.$$.fragment),Te=l(),xe=m("p"),xe.innerHTML=Me,we=l(),ge=m("p"),ge.innerHTML=de,Xe=l(),be=m("p"),be.innerHTML=G,ve=l(),T(ce.$$.fragment),oe=l(),E=m("div"),T(A.$$.fragment),me=l(),se=m("p"),se.innerHTML=$e,Ue=l(),T(B.$$.fragment),Fe=l(),T(x.$$.fragment),this.h()},l(g){M(t.$$.fragment,g),h=i(g),n=p(g,"DIV",{class:!0});var k=Ze(n);M(s.$$.fragment,k),b=i(k),o=p(k,"P",{"data-svelte-h":!0}),y(o)!=="svelte-td1wqd"&&(o.textContent=_),ue=i(k),I=p(k,"P",{"data-svelte-h":!0}),y(I)!=="svelte-1qaxm70"&&(I.innerHTML=F),te=i(k),U=p(k,"P",{"data-svelte-h":!0}),y(U)!=="svelte-1be7e3c"&&(U.innerHTML=V),ne=i(k),M(c.$$.fragment,k),H=i(k),Y=p(k,"DIV",{class:!0});var D=Ze(Y);M(N.$$.fragment,D),qe=i(D),fe=p(D,"P",{"data-svelte-h":!0}),y(fe)!=="svelte-6hu5ln"&&(fe.innerHTML=Q),Be=i(D),M(R.$$.fragment,D),he=i(D),M(q.$$.fragment,D),D.forEach(a),k.forEach(a),le=i(g),M(W.$$.fragment,g),ie=i(g),Z=p(g,"DIV",{class:!0});var z=Ze(Z);M(P.$$.fragment,z),Te=i(z),xe=p(z,"P",{"data-svelte-h":!0}),y(xe)!=="svelte-1qjnsya"&&(xe.innerHTML=Me),we=i(z),ge=p(z,"P",{"data-svelte-h":!0}),y(ge)!=="svelte-1qaxm70"&&(ge.innerHTML=de),Xe=i(z),be=p(z,"P",{"data-svelte-h":!0}),y(be)!=="svelte-1be7e3c"&&(be.innerHTML=G),ve=i(z),M(ce.$$.fragment,z),oe=i(z),E=p(z,"DIV",{class:!0});var X=Ze(E);M(A.$$.fragment,X),me=i(X),se=p(X,"P",{"data-svelte-h":!0}),y(se)!=="svelte-h9s201"&&(se.innerHTML=$e),Ue=i(X),M(B.$$.fragment,X),Fe=i(X),M(x.$$.fragment,X),X.forEach(a),z.forEach(a),this.h()},h(){je(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),je(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),je(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),je(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(g,k){w(t,g,k),r(g,h,k),r(g,n,k),w(s,n,null),u(n,b),u(n,o),u(n,ue),u(n,I),u(n,te),u(n,U),u(n,ne),w(c,n,null),u(n,H),u(n,Y),w(N,Y,null),u(Y,qe),u(Y,fe),u(Y,Be),w(R,Y,null),u(Y,he),w(q,Y,null),r(g,le,k),w(W,g,k),r(g,ie,k),r(g,Z,k),w(P,Z,null),u(Z,Te),u(Z,xe),u(Z,we),u(Z,ge),u(Z,Xe),u(Z,be),u(Z,ve),w(ce,Z,null),u(Z,oe),u(Z,E),w(A,E,null),u(E,me),u(E,se),u(E,Ue),w(B,E,null),u(E,Fe),w(x,E,null),pe=!0},p(g,k){const D={};k&2&&(D.$$scope={dirty:k,ctx:g}),c.$set(D);const z={};k&2&&(z.$$scope={dirty:k,ctx:g}),R.$set(z);const X={};k&2&&(X.$$scope={dirty:k,ctx:g}),q.$set(X);const Ge={};k&2&&(Ge.$$scope={dirty:k,ctx:g}),ce.$set(Ge);const Ce={};k&2&&(Ce.$$scope={dirty:k,ctx:g}),B.$set(Ce);const ke={};k&2&&(ke.$$scope={dirty:k,ctx:g}),x.$set(ke)},i(g){pe||(v(t.$$.fragment,g),v(s.$$.fragment,g),v(c.$$.fragment,g),v(N.$$.fragment,g),v(R.$$.fragment,g),v(q.$$.fragment,g),v(W.$$.fragment,g),v(P.$$.fragment,g),v(ce.$$.fragment,g),v(A.$$.fragment,g),v(B.$$.fragment,g),v(x.$$.fragment,g),pe=!0)},o(g){$(t.$$.fragment,g),$(s.$$.fragment,g),$(c.$$.fragment,g),$(N.$$.fragment,g),$(R.$$.fragment,g),$(q.$$.fragment,g),$(W.$$.fragment,g),$(P.$$.fragment,g),$(ce.$$.fragment,g),$(A.$$.fragment,g),$(B.$$.fragment,g),$(x.$$.fragment,g),pe=!1},d(g){g&&(a(h),a(n),a(le),a(ie),a(Z)),C(t,g),C(s),C(c),C(N),C(R),C(q),C(W,g),C(P),C(ce),C(A),C(B),C(x)}}}function Jt(j){let t,h;return t=new tt({props:{$$slots:{default:[kt]},$$scope:{ctx:j}}}),{c(){T(t.$$.fragment)},l(n){M(t.$$.fragment,n)},m(n,s){w(t,n,s),h=!0},p(n,s){const b={};s&2&&(b.$$scope={dirty:s,ctx:n}),t.$set(b)},i(n){h||(v(t.$$.fragment,n),h=!0)},o(n){$(t.$$.fragment,n),h=!1},d(n){C(t,n)}}}function jt(j){let t,h,n,s,b,o,_,ue='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="TensorFlow" src="https://img.shields.io/badge/TensorFlow-FF6F00?style=flat&amp;logo=tensorflow&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',I,F,te,U,V=`Hubert was proposed in <a href="https://arxiv.org/abs/2106.07447" rel="nofollow">HuBERT: Self-Supervised Speech Representation Learning by Masked Prediction of Hidden Units</a> by Wei-Ning Hsu, Benjamin Bolte, Yao-Hung Hubert Tsai, Kushal Lakhotia, Ruslan
Salakhutdinov, Abdelrahman Mohamed.`,ne,c,H="The abstract from the paper is the following:",Y,N,qe=`<em>Self-supervised approaches for speech representation learning are challenged by three unique problems: (1) there are
multiple sound units in each input utterance, (2) there is no lexicon of input sound units during the pre-training
phase, and (3) sound units have variable lengths with no explicit segmentation. To deal with these three problems, we
propose the Hidden-Unit BERT (HuBERT) approach for self-supervised speech representation learning, which utilizes an
offline clustering step to provide aligned target labels for a BERT-like prediction loss. A key ingredient of our
approach is applying the prediction loss over the masked regions only, which forces the model to learn a combined
acoustic and language model over the continuous inputs. HuBERT relies primarily on the consistency of the unsupervised
clustering step rather than the intrinsic quality of the assigned cluster labels. Starting with a simple k-means
teacher of 100 clusters, and using two iterations of clustering, the HuBERT model either matches or improves upon the
state-of-the-art wav2vec 2.0 performance on the Librispeech (960h) and Libri-light (60,000h) benchmarks with 10min, 1h,
10h, 100h, and 960h fine-tuning subsets. Using a 1B parameter model, HuBERT shows up to 19% and 13% relative WER
reduction on the more challenging dev-other and test-other evaluation subsets.</em>`,fe,Q,Be='This model was contributed by <a href="https://huggingface.co/patrickvonplaten" rel="nofollow">patrickvonplaten</a>.',R,he,q,le,W=`<li>Hubert is a speech model that accepts a float array corresponding to the raw waveform of the speech signal.</li> <li>Hubert model was fine-tuned using connectionist temporal classification (CTC) so the model output has to be decoded
using <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a>.</li>`,ie,Z,P,Te,xe="Flash Attention 2 is an faster, optimized version of the model.",Me,we,ge,de,Xe='First, check whether your hardware is compatible with Flash Attention 2. The latest list of compatible hardware can be found in the <a href="https://github.com/Dao-AILab/flash-attention#installation-and-features" rel="nofollow">official documentation</a>. If your hardware is not compatible with Flash Attention 2, you can still benefit from attention kernel optimisations through Better Transformer support covered <a href="https://huggingface.co/docs/transformers/main/en/model_doc/bark#using-better-transformer" rel="nofollow">above</a>.',be,G,ve='Next, <a href="https://github.com/Dao-AILab/flash-attention#installation-and-features" rel="nofollow">install</a> the latest version of Flash Attention 2:',ce,oe,E,A,me,se,$e="Below is an expected speedup diagram comparing the pure inference time between the native implementation in transformers of <code>facebook/hubert-large-ls960-ft</code>, the flash-attention-2 and the sdpa (scale-dot-product-attention) version. We show the average speedup obtained on the <code>librispeech_asr</code> <code>clean</code> validation split:",Ue,B,Fe,x,pe,g,k="Below is an expected speedup diagram comparing the pure inference time between the native implementation in transformers of the <code>facebook/hubert-large-ls960-ft</code> model and the flash-attention-2 and sdpa (scale-dot-product-attention) versions. . We show the average speedup obtained on the <code>librispeech_asr</code> <code>clean</code> validation split:",D,z,X='<img src="https://huggingface.co/datasets/kamilakesbi/transformers_image_doc/resolve/main/data/Hubert_speedup.png"/>',Ge,Ce,ke,Ne,Oe='<li><a href="../tasks/audio_classification">Audio classification task guide</a></li> <li><a href="../tasks/asr">Automatic speech recognition task guide</a></li>',O,_e,Le,L,Re,Qe,ye,Ke=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertModel">HubertModel</a>. It is used to instantiate an
Hubert model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Hubert
<a href="https://huggingface.co/facebook/hubert-base-ls960" rel="nofollow">facebook/hubert-base-ls960</a> architecture.`,Ie,Ye,ze=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Se,d,J,S,ae,K,re,ee,Pe;return b=new Je({props:{title:"Hubert",local:"hubert",headingTag:"h1"}}),F=new Je({props:{title:"Overview",local:"overview",headingTag:"h2"}}),he=new Je({props:{title:"Usage tips",local:"usage-tips",headingTag:"h1"}}),Z=new Je({props:{title:"Using Flash Attention 2",local:"using-flash-attention-2",headingTag:"h2"}}),we=new Je({props:{title:"Installation",local:"installation",headingTag:"h3"}}),oe=new Ee({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),A=new Je({props:{title:"Usage",local:"usage",headingTag:"h3"}}),B=new Ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEh1YmVydE1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbCUyMCUzRCUyMEh1YmVydE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmh1YmVydC1sYXJnZS1sczk2MC1mdCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMikudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HubertModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = HubertModel.from_pretrained(<span class="hljs-string">&quot;facebook/hubert-large-ls960-ft&quot;</span>, torch_dtype=torch.float16, attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
...`,wrap:!1}}),x=new Je({props:{title:"Expected speedups",local:"expected-speedups",headingTag:"h3"}}),Ce=new Je({props:{title:"Resources",local:"resources",headingTag:"h2"}}),_e=new Je({props:{title:"HubertConfig",local:"transformers.HubertConfig",headingTag:"h2"}}),Re=new Ve({props:{name:"class transformers.HubertConfig",anchor:"transformers.HubertConfig",parameters:[{name:"vocab_size",val:" = 32"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout",val:" = 0.1"},{name:"activation_dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.1"},{name:"feat_proj_layer_norm",val:" = True"},{name:"feat_proj_dropout",val:" = 0.0"},{name:"final_dropout",val:" = 0.1"},{name:"layerdrop",val:" = 0.1"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"feat_extract_norm",val:" = 'group'"},{name:"feat_extract_activation",val:" = 'gelu'"},{name:"conv_dim",val:" = (512, 512, 512, 512, 512, 512, 512)"},{name:"conv_stride",val:" = (5, 2, 2, 2, 2, 2, 2)"},{name:"conv_kernel",val:" = (10, 3, 3, 3, 3, 2, 2)"},{name:"conv_bias",val:" = False"},{name:"num_conv_pos_embeddings",val:" = 128"},{name:"num_conv_pos_embedding_groups",val:" = 16"},{name:"conv_pos_batch_norm",val:" = False"},{name:"do_stable_layer_norm",val:" = False"},{name:"apply_spec_augment",val:" = True"},{name:"mask_time_prob",val:" = 0.05"},{name:"mask_time_length",val:" = 10"},{name:"mask_time_min_masks",val:" = 2"},{name:"mask_feature_prob",val:" = 0.0"},{name:"mask_feature_length",val:" = 10"},{name:"mask_feature_min_masks",val:" = 0"},{name:"ctc_loss_reduction",val:" = 'sum'"},{name:"ctc_zero_infinity",val:" = False"},{name:"use_weighted_layer_sum",val:" = False"},{name:"classifier_proj_size",val:" = 256"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.HubertConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Vocabulary size of the Hubert model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertModel">HubertModel</a>. Vocabulary size of the model. Defines the different
tokens that can be represented by the <em>inputs_ids</em> passed to the forward method of <a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertModel">HubertModel</a>.`,name:"vocab_size"},{anchor:"transformers.HubertConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.HubertConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.HubertConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.HubertConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.HubertConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.HubertConfig.hidden_dropout(float,",description:`<strong>hidden_dropout(<code>float</code>,</strong> <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout(float,"},{anchor:"transformers.HubertConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.HubertConfig.attention_dropout(float,",description:`<strong>attention_dropout(<code>float</code>,</strong> <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout(float,"},{anchor:"transformers.HubertConfig.final_dropout",description:`<strong>final_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for the final projection layer of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a>.`,name:"final_dropout"},{anchor:"transformers.HubertConfig.layerdrop",description:`<strong>layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The LayerDrop probability. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>) for more
details.`,name:"layerdrop"},{anchor:"transformers.HubertConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.HubertConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.HubertConfig.feat_extract_norm",description:`<strong>feat_extract_norm</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;group&quot;</code>) &#x2014;
The norm to be applied to 1D convolutional layers in feature encoder. One of <code>&quot;group&quot;</code> for group
normalization of only the first 1D convolutional layer or <code>&quot;layer&quot;</code> for layer normalization of all 1D
convolutional layers.`,name:"feat_extract_norm"},{anchor:"transformers.HubertConfig.feat_proj_dropout",description:`<strong>feat_proj_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for output of the feature encoder.`,name:"feat_proj_dropout"},{anchor:"transformers.HubertConfig.feat_proj_layer_norm",description:`<strong>feat_proj_layer_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to apply LayerNorm to the output of the feature encoder.`,name:"feat_proj_layer_norm"},{anchor:"transformers.HubertConfig.feat_extract_activation",description:"<strong>feat_extract_activation</strong> (<code>str, </code>optional<code>, defaults to </code>&#x201C;gelu&#x201D;<code>) -- The non-linear activation function (function or string) in the 1D convolutional layers of the feature extractor. If string, </code>&#x201C;gelu&#x201D;<code>, </code>&#x201C;relu&#x201D;<code>, </code>&#x201C;selu&#x201D;<code>and</code>&#x201C;gelu_new&#x201D;` are supported.",name:"feat_extract_activation"},{anchor:"transformers.HubertConfig.conv_dim",description:`<strong>conv_dim</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(512, 512, 512, 512, 512, 512, 512)</code>) &#x2014;
A tuple of integers defining the number of input and output channels of each 1D convolutional layer in the
feature encoder. The length of <em>conv_dim</em> defines the number of 1D convolutional layers.`,name:"conv_dim"},{anchor:"transformers.HubertConfig.conv_stride",description:`<strong>conv_stride</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(5, 2, 2, 2, 2, 2, 2)</code>) &#x2014;
A tuple of integers defining the stride of each 1D convolutional layer in the feature encoder. The length
of <em>conv_stride</em> defines the number of convolutional layers and has to match the length of <em>conv_dim</em>.`,name:"conv_stride"},{anchor:"transformers.HubertConfig.conv_kernel",description:`<strong>conv_kernel</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(10, 3, 3, 3, 3, 3, 3)</code>) &#x2014;
A tuple of integers defining the kernel size of each 1D convolutional layer in the feature encoder. The
length of <em>conv_kernel</em> defines the number of convolutional layers and has to match the length of
<em>conv_dim</em>.`,name:"conv_kernel"},{anchor:"transformers.HubertConfig.conv_bias",description:`<strong>conv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the 1D convolutional layers have a bias.`,name:"conv_bias"},{anchor:"transformers.HubertConfig.num_conv_pos_embeddings",description:`<strong>num_conv_pos_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Number of convolutional positional embeddings. Defines the kernel size of 1D convolutional positional
embeddings layer.`,name:"num_conv_pos_embeddings"},{anchor:"transformers.HubertConfig.num_conv_pos_embedding_groups",description:`<strong>num_conv_pos_embedding_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of groups of 1D convolutional positional embeddings layer.`,name:"num_conv_pos_embedding_groups"},{anchor:"transformers.HubertConfig.conv_pos_batch_norm",description:`<strong>conv_pos_batch_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use batch norm instead of weight norm in conv_pos`,name:"conv_pos_batch_norm"},{anchor:"transformers.HubertConfig.do_stable_layer_norm",description:`<strong>do_stable_layer_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether do apply <em>stable</em> layer norm architecture of the Transformer encoder. <code>do_stable_layer_norm is True</code> corresponds to applying layer norm before the attention layer, whereas <code>do_stable_layer_norm is False</code> corresponds to applying layer norm after the attention layer.`,name:"do_stable_layer_norm"},{anchor:"transformers.HubertConfig.apply_spec_augment",description:`<strong>apply_spec_augment</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to apply <em>SpecAugment</em> data augmentation to the outputs of the feature encoder. For reference see
<a href="https://arxiv.org/abs/1904.08779" rel="nofollow">SpecAugment: A Simple Data Augmentation Method for Automatic Speech
Recognition</a>.`,name:"apply_spec_augment"},{anchor:"transformers.HubertConfig.mask_time_prob",description:`<strong>mask_time_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.05) &#x2014;
Percentage (between 0 and 1) of all feature vectors along the time axis which will be masked. The masking
procedure generates &#x201D;mask_time_prob<em>len(time_axis)/mask_time_length&#x201D; independent masks over the axis. If
reasoning from the probability of each feature vector to be chosen as the start of the vector span to be
masked, </em>mask_time_prob<em> should be \`prob_vector_start</em>mask_time_length<code>. Note that overlap may decrease the actual percentage of masked vectors. This is only relevant if </code>apply_spec_augment is True\`.`,name:"mask_time_prob"},{anchor:"transformers.HubertConfig.mask_time_length",description:`<strong>mask_time_length</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Length of vector span along the time axis.`,name:"mask_time_length"},{anchor:"transformers.HubertConfig.mask_time_min_masks",description:`<strong>mask_time_min_masks</strong> (<code>int</code>, <em>optional</em>, defaults to 2), &#x2014;
The minimum number of masks of length <code>mask_feature_length</code> generated along the time axis, each time step,
irrespectively of <code>mask_feature_prob</code>. Only relevant if &#x201D;mask_time_prob*len(time_axis)/mask_time_length &lt;
mask_time_min_masks&#x201D;`,name:"mask_time_min_masks"},{anchor:"transformers.HubertConfig.mask_feature_prob",description:`<strong>mask_feature_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Percentage (between 0 and 1) of all feature vectors along the feature axis which will be masked. The
masking procedure generates &#x201D;mask_feature_prob<em>len(feature_axis)/mask_time_length&#x201D; independent masks over
the axis. If reasoning from the probability of each feature vector to be chosen as the start of the vector
span to be masked, </em>mask_feature_prob<em> should be \`prob_vector_start</em>mask_feature_length<code>. Note that overlap may decrease the actual percentage of masked vectors. This is only relevant if </code>apply_spec_augment is
True\`.`,name:"mask_feature_prob"},{anchor:"transformers.HubertConfig.mask_feature_length",description:`<strong>mask_feature_length</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Length of vector span along the feature axis.`,name:"mask_feature_length"},{anchor:"transformers.HubertConfig.mask_feature_min_masks",description:`<strong>mask_feature_min_masks</strong> (<code>int</code>, <em>optional</em>, defaults to 0), &#x2014;
The minimum number of masks of length <code>mask_feature_length</code> generated along the feature axis, each time
step, irrespectively of <code>mask_feature_prob</code>. Only relevant if
&#x201D;mask_feature_prob*len(feature_axis)/mask_feature_length &lt; mask_feature_min_masks&#x201D;`,name:"mask_feature_min_masks"},{anchor:"transformers.HubertConfig.ctc_loss_reduction",description:`<strong>ctc_loss_reduction</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sum&quot;</code>) &#x2014;
Specifies the reduction to apply to the output of <code>torch.nn.CTCLoss</code>. Only relevant when training an
instance of <a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertForCTC">HubertForCTC</a>.`,name:"ctc_loss_reduction"},{anchor:"transformers.HubertConfig.ctc_zero_infinity",description:`<strong>ctc_zero_infinity</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to zero infinite losses and the associated gradients of <code>torch.nn.CTCLoss</code>. Infinite losses mainly
occur when the inputs are too short to be aligned to the targets. Only relevant when training an instance
of <a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertForCTC">HubertForCTC</a>.`,name:"ctc_zero_infinity"},{anchor:"transformers.HubertConfig.use_weighted_layer_sum",description:`<strong>use_weighted_layer_sum</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a weighted average of layer outputs with learned weights. Only relevant when using an
instance of <a href="/docs/transformers/main/en/model_doc/hubert#transformers.HubertForSequenceClassification">HubertForSequenceClassification</a>.`,name:"use_weighted_layer_sum"},{anchor:"transformers.HubertConfig.classifier_proj_size",description:`<strong>classifier_proj_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the projection before token mean-pooling for classification.`,name:"classifier_proj_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/hubert/configuration_hubert.py#L27"}}),d=new De({props:{anchor:"transformers.HubertConfig.example",$$slots:{default:[ct]},$$scope:{ctx:j}}}),S=new it({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[Jt],pytorch:[yt]},$$scope:{ctx:j}}}),K=new dt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/hubert.md"}}),{c(){t=m("meta"),h=l(),n=m("p"),s=l(),T(b.$$.fragment),o=l(),_=m("div"),_.innerHTML=ue,I=l(),T(F.$$.fragment),te=l(),U=m("p"),U.innerHTML=V,ne=l(),c=m("p"),c.textContent=H,Y=l(),N=m("p"),N.innerHTML=qe,fe=l(),Q=m("p"),Q.innerHTML=Be,R=l(),T(he.$$.fragment),q=l(),le=m("ul"),le.innerHTML=W,ie=l(),T(Z.$$.fragment),P=l(),Te=m("p"),Te.textContent=xe,Me=l(),T(we.$$.fragment),ge=l(),de=m("p"),de.innerHTML=Xe,be=l(),G=m("p"),G.innerHTML=ve,ce=l(),T(oe.$$.fragment),E=l(),T(A.$$.fragment),me=l(),se=m("p"),se.innerHTML=$e,Ue=l(),T(B.$$.fragment),Fe=l(),T(x.$$.fragment),pe=l(),g=m("p"),g.innerHTML=k,D=l(),z=m("div"),z.innerHTML=X,Ge=l(),T(Ce.$$.fragment),ke=l(),Ne=m("ul"),Ne.innerHTML=Oe,O=l(),T(_e.$$.fragment),Le=l(),L=m("div"),T(Re.$$.fragment),Qe=l(),ye=m("p"),ye.innerHTML=Ke,Ie=l(),Ye=m("p"),Ye.innerHTML=ze,Se=l(),T(d.$$.fragment),J=l(),T(S.$$.fragment),ae=l(),T(K.$$.fragment),re=l(),ee=m("p"),this.h()},l(e){const f=rt("svelte-u9bgzb",document.head);t=p(f,"META",{name:!0,content:!0}),f.forEach(a),h=i(e),n=p(e,"P",{}),Ze(n).forEach(a),s=i(e),M(b.$$.fragment,e),o=i(e),_=p(e,"DIV",{class:!0,"data-svelte-h":!0}),y(_)!=="svelte-1xi1xpk"&&(_.innerHTML=ue),I=i(e),M(F.$$.fragment,e),te=i(e),U=p(e,"P",{"data-svelte-h":!0}),y(U)!=="svelte-1co7rq7"&&(U.innerHTML=V),ne=i(e),c=p(e,"P",{"data-svelte-h":!0}),y(c)!=="svelte-vfdo9a"&&(c.textContent=H),Y=i(e),N=p(e,"P",{"data-svelte-h":!0}),y(N)!=="svelte-lape3m"&&(N.innerHTML=qe),fe=i(e),Q=p(e,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-1t6iyb9"&&(Q.innerHTML=Be),R=i(e),M(he.$$.fragment,e),q=i(e),le=p(e,"UL",{"data-svelte-h":!0}),y(le)!=="svelte-1o4dw62"&&(le.innerHTML=W),ie=i(e),M(Z.$$.fragment,e),P=i(e),Te=p(e,"P",{"data-svelte-h":!0}),y(Te)!=="svelte-1r79v6g"&&(Te.textContent=xe),Me=i(e),M(we.$$.fragment,e),ge=i(e),de=p(e,"P",{"data-svelte-h":!0}),y(de)!=="svelte-ib5l43"&&(de.innerHTML=Xe),be=i(e),G=p(e,"P",{"data-svelte-h":!0}),y(G)!=="svelte-1pp3dkd"&&(G.innerHTML=ve),ce=i(e),M(oe.$$.fragment,e),E=i(e),M(A.$$.fragment,e),me=i(e),se=p(e,"P",{"data-svelte-h":!0}),y(se)!=="svelte-1ulfaf5"&&(se.innerHTML=$e),Ue=i(e),M(B.$$.fragment,e),Fe=i(e),M(x.$$.fragment,e),pe=i(e),g=p(e,"P",{"data-svelte-h":!0}),y(g)!=="svelte-s11kpo"&&(g.innerHTML=k),D=i(e),z=p(e,"DIV",{style:!0,"data-svelte-h":!0}),y(z)!=="svelte-10r3n4"&&(z.innerHTML=X),Ge=i(e),M(Ce.$$.fragment,e),ke=i(e),Ne=p(e,"UL",{"data-svelte-h":!0}),y(Ne)!=="svelte-11qmliz"&&(Ne.innerHTML=Oe),O=i(e),M(_e.$$.fragment,e),Le=i(e),L=p(e,"DIV",{class:!0});var We=Ze(L);M(Re.$$.fragment,We),Qe=i(We),ye=p(We,"P",{"data-svelte-h":!0}),y(ye)!=="svelte-h12nr7"&&(ye.innerHTML=Ke),Ie=i(We),Ye=p(We,"P",{"data-svelte-h":!0}),y(Ye)!=="svelte-o55m63"&&(Ye.innerHTML=ze),Se=i(We),M(d.$$.fragment,We),We.forEach(a),J=i(e),M(S.$$.fragment,e),ae=i(e),M(K.$$.fragment,e),re=i(e),ee=p(e,"P",{}),Ze(ee).forEach(a),this.h()},h(){je(t,"name","hf:doc:metadata"),je(t,"content",Ht),je(_,"class","flex flex-wrap space-x-1"),lt(z,"text-align","center"),je(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,f){u(document.head,t),r(e,h,f),r(e,n,f),r(e,s,f),w(b,e,f),r(e,o,f),r(e,_,f),r(e,I,f),w(F,e,f),r(e,te,f),r(e,U,f),r(e,ne,f),r(e,c,f),r(e,Y,f),r(e,N,f),r(e,fe,f),r(e,Q,f),r(e,R,f),w(he,e,f),r(e,q,f),r(e,le,f),r(e,ie,f),w(Z,e,f),r(e,P,f),r(e,Te,f),r(e,Me,f),w(we,e,f),r(e,ge,f),r(e,de,f),r(e,be,f),r(e,G,f),r(e,ce,f),w(oe,e,f),r(e,E,f),w(A,e,f),r(e,me,f),r(e,se,f),r(e,Ue,f),w(B,e,f),r(e,Fe,f),w(x,e,f),r(e,pe,f),r(e,g,f),r(e,D,f),r(e,z,f),r(e,Ge,f),w(Ce,e,f),r(e,ke,f),r(e,Ne,f),r(e,O,f),w(_e,e,f),r(e,Le,f),r(e,L,f),w(Re,L,null),u(L,Qe),u(L,ye),u(L,Ie),u(L,Ye),u(L,Se),w(d,L,null),r(e,J,f),w(S,e,f),r(e,ae,f),w(K,e,f),r(e,re,f),r(e,ee,f),Pe=!0},p(e,[f]){const We={};f&2&&(We.$$scope={dirty:f,ctx:e}),d.$set(We);const et={};f&2&&(et.$$scope={dirty:f,ctx:e}),S.$set(et)},i(e){Pe||(v(b.$$.fragment,e),v(F.$$.fragment,e),v(he.$$.fragment,e),v(Z.$$.fragment,e),v(we.$$.fragment,e),v(oe.$$.fragment,e),v(A.$$.fragment,e),v(B.$$.fragment,e),v(x.$$.fragment,e),v(Ce.$$.fragment,e),v(_e.$$.fragment,e),v(Re.$$.fragment,e),v(d.$$.fragment,e),v(S.$$.fragment,e),v(K.$$.fragment,e),Pe=!0)},o(e){$(b.$$.fragment,e),$(F.$$.fragment,e),$(he.$$.fragment,e),$(Z.$$.fragment,e),$(we.$$.fragment,e),$(oe.$$.fragment,e),$(A.$$.fragment,e),$(B.$$.fragment,e),$(x.$$.fragment,e),$(Ce.$$.fragment,e),$(_e.$$.fragment,e),$(Re.$$.fragment,e),$(d.$$.fragment,e),$(S.$$.fragment,e),$(K.$$.fragment,e),Pe=!1},d(e){e&&(a(h),a(n),a(s),a(o),a(_),a(I),a(te),a(U),a(ne),a(c),a(Y),a(N),a(fe),a(Q),a(R),a(q),a(le),a(ie),a(P),a(Te),a(Me),a(ge),a(de),a(be),a(G),a(ce),a(E),a(me),a(se),a(Ue),a(Fe),a(pe),a(g),a(D),a(z),a(Ge),a(ke),a(Ne),a(O),a(Le),a(L),a(J),a(ae),a(re),a(ee)),a(t),C(b,e),C(F,e),C(he,e),C(Z,e),C(we,e),C(oe,e),C(A,e),C(B,e),C(x,e),C(Ce,e),C(_e,e),C(Re),C(d),C(S,e),C(K,e)}}}const Ht='{"title":"Hubert","local":"hubert","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2}],"depth":1}';function xt(j){return ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nt extends st{constructor(t){super(),at(this,t,xt,jt,nt,{})}}export{Nt as component};
