import{s as Ha,o as Pa,n as I}from"../chunks/scheduler.18a86fab.js";import{S as Aa,i as Da,g as h,s as l,r as g,A as Oa,h as f,f as a,c as i,j as C,u as _,x as w,k as j,l as Ka,y as u,a as d,v as y,d as T,t as b,w as M}from"../chunks/index.98837b22.js";import{T as co}from"../chunks/Tip.77304350.js";import{D as L}from"../chunks/Docstring.6758ea23.js";import{C as F}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as fo}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as W}from"../chunks/Heading.7e7e0c5b.js";import{H as ra,a as ne}from"../chunks/HfOption.6641485e.js";import{E as es}from"../chunks/index.499f366c.js";function ts(J){let t,p=`The Llama 4 family of models comes in two flavors: 109B, and 402B parameters. Both of these flavors are extremely
large and won’t fit on your run-of-the-mill device. See below for some examples to reduce the memory usage of the
model.`,o,r,m=`For the download to be faster and more resilient, we recommend installing the <code>hf_xet</code> dependency as followed:
<code>pip install transformers[hf_xet]</code>`;return{c(){t=h("p"),t.textContent=p,o=l(),r=h("p"),r.innerHTML=m},l(n){t=f(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-59ca8l"&&(t.textContent=p),o=i(n),r=f(n,"P",{"data-svelte-h":!0}),w(r)!=="svelte-a4r835"&&(r.innerHTML=m)},m(n,c){d(n,t,c),d(n,o,c),d(n,r,c)},p:I,d(n){n&&(a(t),a(o),a(r))}}}function os(J){let t,p;return t=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMm1ldGEtbGxhbWElMkZMbGFtYS00LVNjb3V0LTE3Qi0xNkUtSW5zdHJ1Y3QlMjIlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMndoYXQlMjBpcyUyMHRoZSUyMHJlY2lwZSUyMG9mJTIwbWF5b25uYWlzZSUzRiUyMiU3RCUyQyUwQSU1RCUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQSUwQW91dHB1dCUyMCUzRCUyMHBpcGUobWVzc2FnZXMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAwKSUwQXByaW50KG91dHB1dCU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCU1Qi0xJTVEJTVCJTIyY29udGVudCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;meta-llama/Llama-4-Scout-17B-16E-Instruct&quot;</span>

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;what is the recipe of mayonnaise?&quot;</span>},
]

pipe = pipeline(
    <span class="hljs-string">&quot;text-generation&quot;</span>,
    model=model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16
)

output = pipe(messages, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">200</span>)
<span class="hljs-built_in">print</span>(output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][-<span class="hljs-number">1</span>][<span class="hljs-string">&quot;content&quot;</span>])`,wrap:!1}}),{c(){g(t.$$.fragment)},l(o){_(t.$$.fragment,o)},m(o,r){y(t,o,r),p=!0},p:I,i(o){p||(T(t.$$.fragment,o),p=!0)},o(o){b(t.$$.fragment,o),p=!1},d(o){M(t,o)}}}function ns(J){let t,p;return t=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBMbGFtYTRGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTQtU2NvdXQtMTdCLTE2RS1JbnN0cnVjdCUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hvJTIwYXJlJTIweW91JTNGJTIyJTdEJTJDJTBBJTVEJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSklMEElMEFtb2RlbCUyMCUzRCUyMExsYW1hNEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzLnRvKG1vZGVsLmRldmljZSklMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTVCJTNBJTJDJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCLTElNUQlM0ElNUQpJTBBcHJpbnQob3V0cHV0cyU1QjAlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Llama4ForConditionalGeneration
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;meta-llama/Llama-4-Scout-17B-16E-Instruct&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Who are you?&quot;</span>},
]
inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, return_dict=<span class="hljs-literal">True</span>)

model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16
)

outputs = model.generate(**inputs.to(model.device), max_new_tokens=<span class="hljs-number">100</span>)
outputs = tokenizer.batch_decode(outputs[:, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]:])
<span class="hljs-built_in">print</span>(outputs[<span class="hljs-number">0</span>])`,wrap:!1}}),{c(){g(t.$$.fragment)},l(o){_(t.$$.fragment,o)},m(o,r){y(t,o,r),p=!0},p:I,i(o){p||(T(t.$$.fragment,o),p=!0)},o(o){b(t.$$.fragment,o),p=!1},d(o){M(t,o)}}}function as(J){let t,p;return t=new F({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Llama4ForConditionalGeneration
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;meta-llama/Llama-4-Scout-17B-16E-Instruct&quot;</span>

processor = AutoProcessor.from_pretrained(model_id)
model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
)

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/0052a70beed5bf71b92610a43a52df6d286cd5f3/diffusers/rabbit.jpg&quot;</span>
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: img_url},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image in two sentences.&quot;</span>},
        ]
    },
]

inputs = processor.apply_chat_template(
    messages,
    add_generation_prompt=<span class="hljs-literal">True</span>,
    tokenize=<span class="hljs-literal">True</span>,
    return_dict=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
).to(model.device)

outputs = model.generate(
    **inputs,
    max_new_tokens=<span class="hljs-number">256</span>,
)

response = processor.batch_decode(outputs[:, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]:])[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),{c(){g(t.$$.fragment)},l(o){_(t.$$.fragment,o)},m(o,r){y(t,o,r),p=!0},p:I,i(o){p||(T(t.$$.fragment,o),p=!0)},o(o){b(t.$$.fragment,o),p=!1},d(o){M(t,o)}}}function ss(J){let t,p;return t=new F({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Llama4ForConditionalGeneration
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;meta-llama/Llama-4-Scout-17B-16E-Instruct&quot;</span>

processor = AutoProcessor.from_pretrained(model_id)
model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
)

url1 = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/0052a70beed5bf71b92610a43a52df6d286cd5f3/diffusers/rabbit.jpg&quot;</span>
url2 = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/cat_style_layout.png&quot;</span>
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: url1},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: url2},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Can you describe how these two images are similar, and how they differ?&quot;</span>},
        ]
    },
]

inputs = processor.apply_chat_template(
    messages,
    add_generation_prompt=<span class="hljs-literal">True</span>,
    tokenize=<span class="hljs-literal">True</span>,
    return_dict=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
).to(model.device)

outputs = model.generate(
    **inputs,
    max_new_tokens=<span class="hljs-number">256</span>,
)

response = processor.batch_decode(outputs[:, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]:])[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),{c(){g(t.$$.fragment)},l(o){_(t.$$.fragment,o)},m(o,r){y(t,o,r),p=!0},p:I,i(o){p||(T(t.$$.fragment,o),p=!0)},o(o){b(t.$$.fragment,o),p=!1},d(o){M(t,o)}}}function rs(J){let t,p=`Beware: the example below uses both <code>device_map=&quot;auto&quot;</code> and flex-attention.
Please use <code>torchrun</code> to run this example in tensor-parallel mode.`,o,r,m=`We will work to enable running with <code>device_map=&quot;auto&quot;</code> and flex-attention without
tensor-parallel in the future.`,n,c,v;return c=new F({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Llama4ForConditionalGeneration, AutoTokenizer
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> time

file = <span class="hljs-string">&quot;very_long_context_prompt.txt&quot;</span>
model_id = <span class="hljs-string">&quot;meta-llama/Llama-4-Scout-17B-16E-Instruct&quot;</span>

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(file, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
    very_long_text = <span class="hljs-string">&quot;\\n&quot;</span>.join(f.readlines())

tokenizer = AutoTokenizer.from_pretrained(model_id)
model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    attn_implementation=<span class="hljs-string">&quot;flex_attention&quot;</span>,
    torch_dtype=torch.bfloat16
)

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">f&quot;Look at the following texts: [<span class="hljs-subst">{very_long_text}</span>]\\n\\n\\n\\nWhat are the books, and who wrote them? Make me a nice list.&quot;</span>},
]
input_ids = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

torch.cuda.synchronize()
start = time.time()
out = model.generate(
    input_ids.to(model.device),
    prefill_chunk_size=<span class="hljs-number">2048</span>*<span class="hljs-number">8</span>,
    max_new_tokens=<span class="hljs-number">300</span>,
    cache_implementation=<span class="hljs-string">&quot;hybrid&quot;</span>,
)
<span class="hljs-built_in">print</span>(time.time()-start)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(out[:, input_ids.shape[-<span class="hljs-number">1</span>]:]))
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{torch.cuda.max_memory_allocated(model.device) / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GiB&quot;</span>)`,wrap:!1}}),{c(){t=h("p"),t.innerHTML=p,o=l(),r=h("p"),r.innerHTML=m,n=l(),g(c.$$.fragment)},l(U){t=f(U,"P",{"data-svelte-h":!0}),w(t)!=="svelte-ay5yv2"&&(t.innerHTML=p),o=i(U),r=f(U,"P",{"data-svelte-h":!0}),w(r)!=="svelte-18maour"&&(r.innerHTML=m),n=i(U),_(c.$$.fragment,U)},m(U,x){d(U,t,x),d(U,o,x),d(U,r,x),d(U,n,x),y(c,U,x),v=!0},p:I,i(U){v||(T(c.$$.fragment,U),v=!0)},o(U){b(c.$$.fragment,U),v=!1},d(U){U&&(a(t),a(o),a(r),a(n)),M(c,U)}}}function ls(J){let t,p,o,r,m,n,c,v,U,x;return t=new ne({props:{id:"usage",option:"Pipeline",$$slots:{default:[os]},$$scope:{ctx:J}}}),o=new ne({props:{id:"usage",option:"AutoModel - Text only",$$slots:{default:[ns]},$$scope:{ctx:J}}}),m=new ne({props:{id:"usage",option:"AutoModel - Multimodal",$$slots:{default:[as]},$$scope:{ctx:J}}}),c=new ne({props:{id:"usage",option:"AutoModel - Multimodal with multiple images",$$slots:{default:[ss]},$$scope:{ctx:J}}}),U=new ne({props:{id:"usage",option:"AutoModel - Long context",$$slots:{default:[rs]},$$scope:{ctx:J}}}),{c(){g(t.$$.fragment),p=l(),g(o.$$.fragment),r=l(),g(m.$$.fragment),n=l(),g(c.$$.fragment),v=l(),g(U.$$.fragment)},l($){_(t.$$.fragment,$),p=i($),_(o.$$.fragment,$),r=i($),_(m.$$.fragment,$),n=i($),_(c.$$.fragment,$),v=i($),_(U.$$.fragment,$)},m($,k){y(t,$,k),d($,p,k),y(o,$,k),d($,r,k),y(m,$,k),d($,n,k),y(c,$,k),d($,v,k),y(U,$,k),x=!0},p($,k){const ee={};k&2&&(ee.$$scope={dirty:k,ctx:$}),t.$set(ee);const mo={};k&2&&(mo.$$scope={dirty:k,ctx:$}),o.$set(mo);const Ce={};k&2&&(Ce.$$scope={dirty:k,ctx:$}),m.$set(Ce);const te={};k&2&&(te.$$scope={dirty:k,ctx:$}),c.$set(te);const po={};k&2&&(po.$$scope={dirty:k,ctx:$}),U.$set(po)},i($){x||(T(t.$$.fragment,$),T(o.$$.fragment,$),T(m.$$.fragment,$),T(c.$$.fragment,$),T(U.$$.fragment,$),x=!0)},o($){b(t.$$.fragment,$),b(o.$$.fragment,$),b(m.$$.fragment,$),b(c.$$.fragment,$),b(U.$$.fragment,$),x=!1},d($){$&&(a(p),a(r),a(n),a(v)),M(t,$),M(o,$),M(m,$),M(c,$),M(U,$)}}}function is(J){let t,p=`Beware: the example below uses both <code>device_map=&quot;auto&quot;</code> and flex-attention.
Please use <code>torchrun</code> to run this example in tensor-parallel mode.`,o,r,m=`We will work to enable running with <code>device_map=&quot;auto&quot;</code> and flex-attention without
tensor-parallel in the future.`;return{c(){t=h("p"),t.innerHTML=p,o=l(),r=h("p"),r.innerHTML=m},l(n){t=f(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-1jalrl2"&&(t.innerHTML=p),o=i(n),r=f(n,"P",{"data-svelte-h":!0}),w(r)!=="svelte-18maour"&&(r.innerHTML=m)},m(n,c){d(n,t,c),d(n,o,c),d(n,r,c)},p:I,d(n){n&&(a(t),a(o),a(r))}}}function ds(J){let t,p="Setting Flex Attention ensures the best results with the very long context the model can handle.",o,r,m,n,c;return r=new co({props:{warning:!1,$$slots:{default:[is]},$$scope:{ctx:J}}}),n=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hNEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGFtYTRGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsZXhfYXR0ZW50aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Llama4ForConditionalGeneration
<span class="hljs-keyword">import</span> torch

model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    attn_implementation=<span class="hljs-string">&quot;flex_attention&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
)`,wrap:!1}}),{c(){t=h("p"),t.textContent=p,o=l(),g(r.$$.fragment),m=l(),g(n.$$.fragment)},l(v){t=f(v,"P",{"data-svelte-h":!0}),w(t)!=="svelte-heqywl"&&(t.textContent=p),o=i(v),_(r.$$.fragment,v),m=i(v),_(n.$$.fragment,v)},m(v,U){d(v,t,U),d(v,o,U),y(r,v,U),d(v,m,U),y(n,v,U),c=!0},p(v,U){const x={};U&2&&(x.$$scope={dirty:U,ctx:v}),r.$set(x)},i(v){c||(T(r.$$.fragment,v),T(n.$$.fragment,v),c=!0)},o(v){b(r.$$.fragment,v),b(n.$$.fragment,v),c=!1},d(v){v&&(a(t),a(o),a(m)),M(r,v),M(n,v)}}}function cs(J){let t,p="The <code>sdpa</code> attention method is generally more compute-efficient than the <code>eager</code> method.",o,r,m;return r=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hNEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGFtYTRGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMnNkcGElMjIlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Llama4ForConditionalGeneration
<span class="hljs-keyword">import</span> torch

model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    attn_implementation=<span class="hljs-string">&quot;sdpa&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
)`,wrap:!1}}),{c(){t=h("p"),t.innerHTML=p,o=l(),g(r.$$.fragment)},l(n){t=f(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-9cvt94"&&(t.innerHTML=p),o=i(n),_(r.$$.fragment,n)},m(n,c){d(n,t,c),d(n,o,c),y(r,n,c),m=!0},p:I,i(n){m||(T(r.$$.fragment,n),m=!0)},o(n){b(r.$$.fragment,n),m=!1},d(n){n&&(a(t),a(o)),M(r,n)}}}function ms(J){let t,p="The <code>eager</code> attention method is set by default, so no need for anything different when loading the model:",o,r,m;return r=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hNEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGFtYTRGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Llama4ForConditionalGeneration
<span class="hljs-keyword">import</span> torch

model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
)`,wrap:!1}}),{c(){t=h("p"),t.innerHTML=p,o=l(),g(r.$$.fragment)},l(n){t=f(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-wbfcsc"&&(t.innerHTML=p),o=i(n),_(r.$$.fragment,n)},m(n,c){d(n,t,c),d(n,o,c),y(r,n,c),m=!0},p:I,i(n){m||(T(r.$$.fragment,n),m=!0)},o(n){b(r.$$.fragment,n),m=!1},d(n){n&&(a(t),a(o)),M(r,n)}}}function ps(J){let t,p,o,r,m,n;return t=new ne({props:{id:"Attention",option:"Flex Attention",$$slots:{default:[ds]},$$scope:{ctx:J}}}),o=new ne({props:{id:"Attention",option:"SDPA",$$slots:{default:[cs]},$$scope:{ctx:J}}}),m=new ne({props:{id:"Attention",option:"Eager",$$slots:{default:[ms]},$$scope:{ctx:J}}}),{c(){g(t.$$.fragment),p=l(),g(o.$$.fragment),r=l(),g(m.$$.fragment)},l(c){_(t.$$.fragment,c),p=i(c),_(o.$$.fragment,c),r=i(c),_(m.$$.fragment,c)},m(c,v){y(t,c,v),d(c,p,v),y(o,c,v),d(c,r,v),y(m,c,v),n=!0},p(c,v){const U={};v&2&&(U.$$scope={dirty:v,ctx:c}),t.$set(U);const x={};v&2&&(x.$$scope={dirty:v,ctx:c}),o.$set(x);const $={};v&2&&($.$$scope={dirty:v,ctx:c}),m.$set($)},i(c){n||(T(t.$$.fragment,c),T(o.$$.fragment,c),T(m.$$.fragment,c),n=!0)},o(c){b(t.$$.fragment,c),b(o.$$.fragment,c),b(m.$$.fragment,c),n=!1},d(c){c&&(a(p),a(r)),M(t,c),M(o,c),M(m,c)}}}function us(J){let t,p;return t=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBMbGFtYTRGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBGYmdlbW1GcDhDb25maWclMEFpbXBvcnQlMjB0b3JjaCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTQtU2NvdXQtMTdCLTE2RS1JbnN0cnVjdCUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hvJTIwYXJlJTIweW91JTNGJTIyJTdEJTJDJTBBJTVEJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSklMEElMEFtb2RlbCUyMCUzRCUyMExsYW1hNEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNERmJnZW1tRnA4Q29uZmlnKCklMEEpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzLnRvKG1vZGVsLmRldmljZSklMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTVCJTNBJTJDJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCLTElNUQlM0ElNUQpJTBBcHJpbnQob3V0cHV0cyU1QjAlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Llama4ForConditionalGeneration, FbgemmFp8Config
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;meta-llama/Llama-4-Scout-17B-16E-Instruct&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Who are you?&quot;</span>},
]
inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, return_dict=<span class="hljs-literal">True</span>)

model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
    quantization_config=FbgemmFp8Config()
)

outputs = model.generate(**inputs.to(model.device), max_new_tokens=<span class="hljs-number">100</span>)
outputs = tokenizer.batch_decode(outputs[:, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]:])
<span class="hljs-built_in">print</span>(outputs[<span class="hljs-number">0</span>])`,wrap:!1}}),{c(){g(t.$$.fragment)},l(o){_(t.$$.fragment,o)},m(o,r){y(t,o,r),p=!0},p:I,i(o){p||(T(t.$$.fragment,o),p=!0)},o(o){b(t.$$.fragment,o),p=!1},d(o){M(t,o)}}}function hs(J){let t,p="To use the LLM-Compressor technique, we recommend leveraging the pre-quantized FP8 checkpoint available with the release:",o,r,m;return r=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBMbGFtYTRGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTQtTWF2ZXJpY2stMTdCLTEyOEUtSW5zdHJ1Y3QtRlA4JTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaG8lMjBhcmUlMjB5b3UlM0YlMjIlN0QlMkMlMEElNUQlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcmV0dXJuX2RpY3QlM0RUcnVlKSUwQSUwQW1vZGVsJTIwJTNEJTIwTGxhbWE0Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHRwX3BsYW4lM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMudG8obW9kZWwuZGV2aWNlKSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAwKSUwQW91dHB1dHMlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlNUIlM0ElMkMlMjBpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQuc2hhcGUlNUItMSU1RCUzQSU1RCklMEFwcmludChvdXRwdXRzJTVCMCU1RCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Llama4ForConditionalGeneration
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;meta-llama/Llama-4-Maverick-17B-128E-Instruct-FP8&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Who are you?&quot;</span>},
]
inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, return_dict=<span class="hljs-literal">True</span>)

model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    tp_plan=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
)

outputs = model.generate(**inputs.to(model.device), max_new_tokens=<span class="hljs-number">100</span>)
outputs = tokenizer.batch_decode(outputs[:, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]:])
<span class="hljs-built_in">print</span>(outputs[<span class="hljs-number">0</span>])`,wrap:!1}}),{c(){t=h("p"),t.textContent=p,o=l(),g(r.$$.fragment)},l(n){t=f(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-46ylbh"&&(t.textContent=p),o=i(n),_(r.$$.fragment,n)},m(n,c){d(n,t,c),d(n,o,c),y(r,n,c),m=!0},p:I,i(n){m||(T(r.$$.fragment,n),m=!0)},o(n){b(r.$$.fragment,n),m=!1},d(n){n&&(a(t),a(o)),M(r,n)}}}function fs(J){let t,p,o,r;return t=new ne({props:{id:"Quantization",option:"FBGEMM",$$slots:{default:[us]},$$scope:{ctx:J}}}),o=new ne({props:{id:"Quantization",option:"LLM-Compressor",$$slots:{default:[hs]},$$scope:{ctx:J}}}),{c(){g(t.$$.fragment),p=l(),g(o.$$.fragment)},l(m){_(t.$$.fragment,m),p=i(m),_(o.$$.fragment,m)},m(m,n){y(t,m,n),d(m,p,n),y(o,m,n),r=!0},p(m,n){const c={};n&2&&(c.$$scope={dirty:n,ctx:m}),t.$set(c);const v={};n&2&&(v.$$scope={dirty:n,ctx:m}),o.$set(v)},i(m){r||(T(t.$$.fragment,m),T(o.$$.fragment,m),r=!0)},o(m){b(t.$$.fragment,m),b(o.$$.fragment,m),r=!1},d(m){m&&a(p),M(t,m),M(o,m)}}}function gs(J){let t,p;return t=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hNE1vZGVsJTJDJTIwTGxhbWE0Q29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMExsYW1hNCUyMDdCJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMExsYW1hNENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMExsYW1hNCUyMDdCJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBMbGFtYTRNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Llama4Model, Llama4Config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama4 7B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Llama4Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the Llama4 7B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Llama4Model(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){g(t.$$.fragment)},l(o){_(t.$$.fragment,o)},m(o,r){y(t,o,r),p=!0},p:I,i(o){p||(T(t.$$.fragment,o),p=!0)},o(o){b(t.$$.fragment,o),p=!1},d(o){M(t,o)}}}function _s(J){let t,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=h("p"),t.innerHTML=p},l(o){t=f(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=p)},m(o,r){d(o,t,r)},p:I,d(o){o&&a(t)}}}function ys(J){let t,p="Example:",o,r,m;return r=new F({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMExsYXZhRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGF2YUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybGxhdmEtaGYlMkZsbGF2YS0xLjUtN2ItaGYlMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybGxhdmEtaGYlMkZsbGF2YS0xLjUtN2ItaGYlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyVVNFUiUzQSUyMCUzQ2ltYWdlJTNFJTVDbldoYXQncyUyMHRoZSUyMGNvbnRlbnQlMjBvZiUyMHRoZSUyMGltYWdlJTNGJTIwQVNTSVNUQU5UJTNBJTIyJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ3d3cuaWxhbmtlbG1hbi5vcmclMkZzdG9wc2lnbnMlMkZhdXN0cmFsaWEuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwdGV4dCUzRHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTUpJTBBcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RGYWxzZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-1.5-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-1.5-7b-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;USER: &lt;image&gt;\\nWhat&#x27;s the content of the image? ASSISTANT:&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">15</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;USER:  \\nWhat&#x27;s the content of the image? ASSISTANT: The image features a busy city street with a stop sign prominently displayed&quot;</span>`,wrap:!1}}),{c(){t=h("p"),t.textContent=p,o=l(),g(r.$$.fragment)},l(n){t=f(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=p),o=i(n),_(r.$$.fragment,n)},m(n,c){d(n,t,c),d(n,o,c),y(r,n,c),m=!0},p:I,i(n){m||(T(r.$$.fragment,n),m=!0)},o(n){b(r.$$.fragment,n),m=!1},d(n){n&&(a(t),a(o)),M(r,n)}}}function Ts(J){let t,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=h("p"),t.innerHTML=p},l(o){t=f(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=p)},m(o,r){d(o,t,r)},p:I,d(o){o&&a(t)}}}function bs(J){let t,p="Example:",o,r,m;return r=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBMbGFtYTRGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwTGxhbWE0Rm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWE0JTJGTGxhbWE0LTItN2ItaGYlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYTQlMkZMbGFtYTQtMi03Yi1oZiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIZXklMkMlMjBhcmUlMjB5b3UlMjBjb25zY2lvdXMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzLmlucHV0X2lkcyUyQyUyMG1heF9sZW5ndGglM0QzMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzREZhbHNlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Llama4ForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Llama4ForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama4/Llama4-2-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama4/Llama4-2-7b-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){t=h("p"),t.textContent=p,o=l(),g(r.$$.fragment)},l(n){t=f(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=p),o=i(n),_(r.$$.fragment,n)},m(n,c){d(n,t,c),d(n,o,c),y(r,n,c),m=!0},p:I,i(n){m||(T(r.$$.fragment,n),m=!0)},o(n){b(r.$$.fragment,n),m=!1},d(n){n&&(a(t),a(o)),M(r,n)}}}function Ms(J){let t,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=h("p"),t.innerHTML=p},l(o){t=f(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=p)},m(o,r){d(o,t,r)},p:I,d(o){o&&a(t)}}}function ws(J){let t,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=h("p"),t.innerHTML=p},l(o){t=f(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=p)},m(o,r){d(o,t,r)},p:I,d(o){o&&a(t)}}}function vs(J){let t,p="Example:",o,r,m;return r=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBMbGFtYTRGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwTGxhbWE0Rm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWE0JTJGTGxhbWE0LTItN2ItaGYlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYTQlMkZMbGFtYTQtMi03Yi1oZiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIZXklMkMlMjBhcmUlMjB5b3UlMjBjb25zY2lvdXMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzLmlucHV0X2lkcyUyQyUyMG1heF9sZW5ndGglM0QzMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzREZhbHNlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Llama4ForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Llama4ForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama4/Llama4-2-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama4/Llama4-2-7b-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){t=h("p"),t.textContent=p,o=l(),g(r.$$.fragment)},l(n){t=f(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=p),o=i(n),_(r.$$.fragment,n)},m(n,c){d(n,t,c),d(n,o,c),y(r,n,c),m=!0},p:I,i(n){m||(T(r.$$.fragment,n),m=!0)},o(n){b(r.$$.fragment,n),m=!1},d(n){n&&(a(t),a(o)),M(r,n)}}}function Js(J){let t,p="Example:",o,r,m;return r=new F({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME1sbGFtYVZpc2lvbk1vZGVsJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItMTFCLVZpc2lvbiUyMiUwQW1vZGVsJTIwJTNEJTIwTWxsYW1hVmlzaW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnd3dy5pbGFua2VsbWFuLm9yZyUyRnN0b3BzaWducyUyRmF1c3RyYWxpYS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQXByaW50KG91dHB1dC5sYXN0X2hpZGRlbl9zdGF0ZS5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MllamaVisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;meta-llama/Llama-3.2-11B-Vision&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MllamaVisionModel.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(output.last_hidden_state.shape)
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">1025</span>, <span class="hljs-number">7680</span>])`,wrap:!1}}),{c(){t=h("p"),t.textContent=p,o=l(),g(r.$$.fragment)},l(n){t=f(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=p),o=i(n),_(r.$$.fragment,n)},m(n,c){d(n,t,c),d(n,o,c),y(r,n,c),m=!0},p:I,i(n){m||(T(r.$$.fragment,n),m=!0)},o(n){b(r.$$.fragment,n),m=!1},d(n){n&&(a(t),a(o)),M(r,n)}}}function $s(J){let t,p,o,r,m,n,c,v='<div class="flex flex-wrap space-x-1"><img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/></div>',U,x,$=`Llama 4, developed by Meta, introduces a new auto-regressive Mixture-of-Experts (MoE) architecture.
This generation includes two models:`,k,ee,mo=`<li>The highly capable Llama 4 Maverick with 17B active parameters out of ~400B total, with 128 experts.</li> <li>The efficient Llama 4 Scout also  has 17B active parameters out of ~109B total, using just 16 experts.</li> <li>Both models leverage early fusion for native multimodality, enabling them to process text and image inputs.
Maverick and Scout are both trained on up to 40 trillion tokens on data encompassing 200 languages
(with specific fine-tuning support for 12 languages including Arabic, Spanish, German, and Hindi).</li>`,Ce,te,po=`For deployment, Llama 4 Scout is designed for accessibility, fitting on a single server-grade GPU via
on-the-fly 4-bit or 8-bitint4 quantization, while Maverick is available in BF16 and FP8 formats.
These models are released under the custom Llama 4 Community License Agreement, available on the model repositories.`,go,je,la='You can find all the original Llama checkpoints under the <a href="https://huggingface.co/meta-llama" rel="nofollow">meta-llama</a> organization.',_o,le,yo,Le,ia=`The examples below demonstrates how to generate with <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModel">AutoModel</a>. We additionally add an example
showcasing how to toggle the right attributes to enable very long-context generations, as some flavors of Llama 4
have context lengths going up to 10 million tokens.`,To,ie,bo,Ie,Mo,ze,wo,Fe,da='Updating the default attention function can significantly improve compute performance as well as memory usage. Refer to the <a href="../attention_interface">Attention Interface</a> overview for an in-depth explanation of our interface.',vo,Ge,ca=`As of release, the Llama 4 model supports the following attention methods: <code>eager</code>, <code>flex_attention</code>, <code>sdpa</code>. We recommend using <code>flex_attention</code> for best results.
Switching attention mechanism is done at the model initialization step:`,Jo,de,$o,Ze,Uo,We,ma=`Quantization reduces the memory burden of large models by representing the weights in a lower precision. Refer to the <a href="../quantization/overview">Quantization</a> overview for available quantization backends.
At time of release, both FBGEMM and LLM-Compressor are supported; more quantization methods will be supported in the days that follow the release.`,ko,Ve,pa="See below for examples using both:",xo,Be,ua="Here is an example loading an BF16 model in FP8 using the FBGEMM approach:",Co,ce,jo,Re,Lo,qe,ha=`Enabling CPU-offloading means that components of the model might be moved to CPU instead of GPU in case the GPU-memory available isn’t sufficient to load the entire model.
At inference, different components will be loaded/unloaded from/to the GPU on the fly. This ensures that the model can be loaded on smaller machines as long as the CPU-memory is sufficient.
However, this also slows down inference as it adds communication overhead.`,Io,Ee,fa="In order to enable CPU-offloading, you simply need to specify the <code>device_map</code> to <code>auto</code> at model load:",zo,Ne,Fo,Xe,Go,G,Qe,pn,zt,ga=`This is the configuration class to store the configuration of a <code>Llama4Model</code>. It is used to instantiate an
Llama4 model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Llama4 109B.`,un,Ft,_a='e.g. <a href="https://huggingface.co/meta-llama/Llama-4-Scout-17B-16E" rel="nofollow">meta-llama/Llama-4-Scout-17B-16E</a>',hn,Gt,ya=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,fn,me,Zo,Ye,Wo,Z,Se,gn,Zt,Ta=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4TextModel">Llama4TextModel</a>. It is used to instantiate a
Llama4 text model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Llama4 109B.`,_n,Wt,ba='e.g. <a href="https://huggingface.co/meta-llama/Llama-4-Scout-17B-16E" rel="nofollow">meta-llama/Llama-4-Scout-17B-16E</a>',yn,Vt,Ma=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Tn,Bt,wa="Example:",Vo,He,Bo,V,Pe,bn,Rt,va=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4VisionModel">Llama4VisionModel</a>. It is used to instantiate a
Llama4 vision model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Llama4 109B.`,Mn,qt,Ja='e.g. <a href="https://huggingface.co/meta-llama/Llama-4-Scout-17B-16E" rel="nofollow">meta-llama/Llama-4-Scout-17B-16E</a>',wn,Et,$a=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ro,Ae,qo,B,De,vn,Nt,Ua=`Constructs a Llama4 processor which wraps a <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> and
<code>PretrainedTokenizerFast</code> tokenizer into a single processor that inherits both the image processor and
tokenizer functionalities. See the <code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4Processor.decode">decode()</a> for more information.`,Jn,pe,Oe,$n,Xt,ka=`This method forwards all its arguments to PreTrainedTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,Un,ue,Ke,kn,Qt,xa=`This method forwards all its arguments to PreTrainedTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,Eo,et,No,R,tt,xn,Yt,Ca="Constructs a fast Llama4 image processor.",Cn,St,ot,jn,he,nt,Ln,Ht,ja=`Rescale and normalize images.
Override to rescale and normalize the images in torch.bfloat16 as in the original implementation`,Xo,at,Qo,H,st,In,N,rt,zn,Pt,La='The <a href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4ForConditionalGeneration">Llama4ForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Fn,fe,Gn,ge,Zn,_e,lt,Wn,At,Ia="Obtains image last hidden states from the vision tower and apply al projection.",Yo,it,za="<li>forward</li>",So,dt,Ho,ae,ct,Vn,X,mt,Bn,Dt,Fa='The <a href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4ForCausalLM">Llama4ForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Rn,ye,qn,Te,Po,pt,Ga="<li>forward</li>",Ao,ut,Do,z,ht,En,Ot,Za="The bare Llama4 Text Model outputting raw hidden-states without any specific head on to.",Nn,Kt,Wa=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Xn,eo,Va=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Qn,Q,ft,Yn,to,Ba="Generate the following:",Sn,oo,Ra=`‘What’      :  0 ■ ⬚ ⬚ ⬚ ⬚ ⬚    |
‘▁is’       :  1 ■ ■ ⬚ ⬚ ⬚ ⬚     |
‘▁ch’       :  2 ■ ■ ■ ⬚ ⬚ ⬚     |
‘unked’     :  3 ⬚ ⬚ ⬚ ■ ⬚ ⬚    |
‘▁attention’:  4 ⬚ ⬚ ⬚ ■ ■ ⬚    |
’?’         :  5 ⬚ ⬚ ⬚ ■ ■ ■     |`,Hn,no,qa=`If the chunk size is 3.
This can just be applied over the already created attention mask`,Pn,oe,gt,An,ao,Ea='The <a href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4TextModel">Llama4TextModel</a> forward method, overrides the <code>__call__</code> special method.',Dn,be,Oo,_t,Na="<li>forward</li>",Ko,yt,en,se,Tt,On,Y,bt,Kn,so,Xa='The <a href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4ForCausalLM">Llama4ForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',ea,Me,ta,we,tn,Mt,Qa="<li>forward</li>",on,wt,nn,P,vt,oa,ve,Jt,na,Je,aa,$e,$t,sa,ro,Ya="This function is used to fetch the first embedding layer to activate grads on inputs.",an,Ut,Sa="<li>forward</li>",sn,kt,rn,uo,ln;return m=new W({props:{title:"Llama4",local:"llama4",headingTag:"h1"}}),le=new co({props:{warning:!1,$$slots:{default:[ts]},$$scope:{ctx:J}}}),ie=new ra({props:{id:"usage",options:["Pipeline","AutoModel - Text only","AutoModel - Multimodal","AutoModel - Multimodal with multiple images","AutoModel - Long context"],$$slots:{default:[ls]},$$scope:{ctx:J}}}),Ie=new W({props:{title:"Efficiency; how to get the best out of llama 4",local:"efficiency-how-to-get-the-best-out-of-llama-4",headingTag:"h2"}}),ze=new W({props:{title:"The Attention methods",local:"the-attention-methods",headingTag:"h3"}}),de=new ra({props:{id:"Attention",options:["Flex Attention","SDPA","Eager"],$$slots:{default:[ps]},$$scope:{ctx:J}}}),Ze=new W({props:{title:"Quantization",local:"quantization",headingTag:"h3"}}),ce=new ra({props:{id:"Quantization",options:["FBGEMM","LLM-Compressor"],$$slots:{default:[fs]},$$scope:{ctx:J}}}),Re=new W({props:{title:"Offloading",local:"offloading",headingTag:"h3"}}),Ne=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hNEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGFtYTRGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Llama4ForConditionalGeneration
<span class="hljs-keyword">import</span> torch

model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
)`,wrap:!1}}),Xe=new W({props:{title:"Llama4Config",local:"transformers.Llama4Config",headingTag:"h2"}}),Qe=new L({props:{name:"class transformers.Llama4Config",anchor:"transformers.Llama4Config",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"boi_token_index",val:" = 200080"},{name:"eoi_token_index",val:" = 200081"},{name:"image_token_index",val:" = 200092"},{name:"tie_word_embeddings",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Llama4Config.vision_config",description:`<strong>vision_config</strong> (<code>Llama4VisionConfig</code>, <em>optional</em>) &#x2014;
The Llama4 Vision config.`,name:"vision_config"},{anchor:"transformers.Llama4Config.text_config",description:`<strong>text_config</strong> (<code>Llama4TextConfig</code>, <em>optional</em>) &#x2014;
The Llama4 Text config.`,name:"text_config"},{anchor:"transformers.Llama4Config.boi_token_index",description:`<strong>boi_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 200080) &#x2014;
The begin-of-image token index to wrap the image prompt.`,name:"boi_token_index"},{anchor:"transformers.Llama4Config.eoi_token_index",description:`<strong>eoi_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 200081) &#x2014;
The end-of-image token index to wrap the image prompt.`,name:"eoi_token_index"},{anchor:"transformers.Llama4Config.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 200092) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.Llama4Config.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/configuration_llama4.py#L367"}}),me=new fo({props:{anchor:"transformers.Llama4Config.example",$$slots:{default:[gs]},$$scope:{ctx:J}}}),Ye=new W({props:{title:"Llama4TextConfig",local:"transformers.Llama4TextConfig",headingTag:"h2"}}),Se=new L({props:{name:"class transformers.Llama4TextConfig",anchor:"transformers.Llama4TextConfig",parameters:[{name:"vocab_size",val:" = 202048"},{name:"hidden_size",val:" = 5120"},{name:"intermediate_size",val:" = 8192"},{name:"intermediate_size_mlp",val:" = 16384"},{name:"num_hidden_layers",val:" = 48"},{name:"num_attention_heads",val:" = 40"},{name:"num_key_value_heads",val:" = 8"},{name:"head_dim",val:" = 128"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 131072"},{name:"initializer_range",val:" = 0.02"},{name:"rms_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = None"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 500000"},{name:"attention_dropout",val:" = 0.0"},{name:"num_experts_per_tok",val:" = 1"},{name:"num_local_experts",val:" = 16"},{name:"moe_layers",val:" = None"},{name:"interleave_moe_layer_step",val:" = 1"},{name:"use_qk_norm",val:" = True"},{name:"output_router_logits",val:" = False"},{name:"router_aux_loss_coef",val:" = 0.001"},{name:"router_jitter_noise",val:" = 0.0"},{name:"rope_scaling",val:" = None"},{name:"no_rope_layers",val:" = None"},{name:"no_rope_layer_interval",val:" = 4"},{name:"attention_chunk_size",val:" = 8192"},{name:"attn_temperature_tuning",val:" = True"},{name:"floor_scale",val:" = 8192"},{name:"attn_scale",val:" = 0.1"},{name:"cache_implementation",val:" = 'hybrid'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Llama4TextConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 202048) &#x2014;
Vocabulary size of the Llama4 text model. Defines the maximum number of different tokens that can be represented
by the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4TextModel">Llama4TextModel</a>.`,name:"vocab_size"},{anchor:"transformers.Llama4TextConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 5120) &#x2014;
Dimensionality of the embeddings and hidden states.`,name:"hidden_size"},{anchor:"transformers.Llama4TextConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.Llama4TextConfig.intermediate_size_mlp",description:"<strong>intermediate_size_mlp</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014; TODO",name:"intermediate_size_mlp"},{anchor:"transformers.Llama4TextConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 48) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Llama4TextConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 40) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Llama4TextConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If not
specified, will default to <code>num_attention_heads</code>.`,name:"num_key_value_heads"},{anchor:"transformers.Llama4TextConfig.head_dim",description:"<strong>head_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014; TODO",name:"head_dim"},{anchor:"transformers.Llama4TextConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>Callable</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler.`,name:"hidden_act"},{anchor:"transformers.Llama4TextConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 131072) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.Llama4TextConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Llama4TextConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.Llama4TextConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions.`,name:"use_cache"},{anchor:"transformers.Llama4TextConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 128004) &#x2014;
The id of the padding token.`,name:"pad_token_id"},{anchor:"transformers.Llama4TextConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The id of the beginning of sentence token.`,name:"bos_token_id"},{anchor:"transformers.Llama4TextConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The id of the end of sentence token.`,name:"eos_token_id"},{anchor:"transformers.Llama4TextConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.Llama4TextConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>500000.0</code>) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.Llama4TextConfig.attention_dropout",description:"<strong>attention_dropout</strong> (<code>int</code>, <em>optional</em>, defaults to 0.0) &#x2014; TODO",name:"attention_dropout"},{anchor:"transformers.Llama4TextConfig.num_experts_per_tok",description:"<strong>num_experts_per_tok</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014; TODO",name:"num_experts_per_tok"},{anchor:"transformers.Llama4TextConfig.num_local_experts",description:"<strong>num_local_experts</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014; TODO",name:"num_local_experts"},{anchor:"transformers.Llama4TextConfig.moe_layers",description:"<strong>moe_layers</strong> (<code>int</code>, <em>optional</em>) &#x2014; TODO",name:"moe_layers"},{anchor:"transformers.Llama4TextConfig.interleave_moe_layer_step",description:"<strong>interleave_moe_layer_step</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014; TODO",name:"interleave_moe_layer_step"},{anchor:"transformers.Llama4TextConfig.use_qk_norm",description:"<strong>use_qk_norm</strong> (<code>int</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014; TODO",name:"use_qk_norm"},{anchor:"transformers.Llama4TextConfig.output_router_logits",description:"<strong>output_router_logits</strong> (<code>int</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; TODO",name:"output_router_logits"},{anchor:"transformers.Llama4TextConfig.router_aux_loss_coef",description:"<strong>router_aux_loss_coef</strong> (<code>int</code>, <em>optional</em>, defaults to 0.001) &#x2014; TODO",name:"router_aux_loss_coef"},{anchor:"transformers.Llama4TextConfig.router_jitter_noise",description:"<strong>router_jitter_noise</strong> (<code>int</code>, <em>optional</em>, defaults to 0.0) &#x2014; TODO",name:"router_jitter_noise"},{anchor:"transformers.Llama4TextConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. NOTE: if you apply new rope type
and you expect the model to work on longer <code>max_position_embeddings</code>, we recommend you to update this value
accordingly.
Expected contents:
<code>rope_type</code> (<code>str</code>):
The sub-variant of RoPE to use. Can be one of [&#x2018;default&#x2019;, &#x2018;linear&#x2019;, &#x2018;dynamic&#x2019;, &#x2018;yarn&#x2019;, &#x2018;longrope&#x2019;,
&#x2018;llama3&#x2019;], with &#x2018;default&#x2019; being the original RoPE implementation.
<code>factor</code> (<code>float</code>, <em>optional</em>):
Used with all rope types except &#x2018;default&#x2019;. The scaling factor to apply to the RoPE embeddings. In
most scaling types, a <code>factor</code> of x will enable the model to handle sequences of length x <em>
original maximum pre-trained length.
<code>original_max_position_embeddings</code> (<code>int</code>, </em>optional<em>):
Used with &#x2018;dynamic&#x2019;, &#x2018;longrope&#x2019; and &#x2018;llama3&#x2019;. The original max position embeddings used during
pretraining.
<code>attention_factor</code> (<code>float</code>, </em>optional<em>):
Used with &#x2018;yarn&#x2019; and &#x2018;longrope&#x2019;. The scaling factor to be applied on the attention
computation. If unspecified, it defaults to value recommended by the implementation, using the
<code>factor</code> field to infer the suggested value.
<code>beta_fast</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for extrapolation (only) in the linear
ramp function. If unspecified, it defaults to 32.
<code>beta_slow</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for interpolation (only) in the linear
ramp function. If unspecified, it defaults to 1.
<code>short_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to short contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>long_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to long contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>low_freq_factor</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to low frequency components of the RoPE
<code>high_freq_factor</code> (<code>float</code>, </em>optional*):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to high frequency components of the RoPE<todo>
<todo></todo></todo>`,name:"rope_scaling"},{anchor:"transformers.Llama4TextConfig.no_rope_layers",description:`<strong>no_rope_layers</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
List with at least the same length as the number of layers in the model.
A <code>1</code> at an index position indicates that the corresponding layer will use RoPE,
while a <code>0</code> indicates that it&#x2019;s a NoPE layer.`,name:"no_rope_layers"},{anchor:"transformers.Llama4TextConfig.no_rope_layer_interval",description:`<strong>no_rope_layer_interval</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
If <code>no_rope_layers</code> is <code>None</code>, it will be created using a NoPE layer every
<code>no_rope_layer_interval</code> layers.`,name:"no_rope_layer_interval"},{anchor:"transformers.Llama4TextConfig.attention_chunk_size",description:"<strong>attention_chunk_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;<todo></todo>",name:"attention_chunk_size"},{anchor:"transformers.Llama4TextConfig.attn_temperature_tuning",description:`<strong>attn_temperature_tuning</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to dynamically scale the attention temperature for each query token based on sequence length.
Recommended for long sequences (e.g., &gt;32k tokens) to maintain stable output results.`,name:"attn_temperature_tuning"},{anchor:"transformers.Llama4TextConfig.floor_scale",description:"<strong>floor_scale</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014; TODO",name:"floor_scale"},{anchor:"transformers.Llama4TextConfig.attn_scale",description:"<strong>attn_scale</strong> (<code>int</code>, <em>optional</em>, defaults to 0.1) &#x2014; TODO",name:"attn_scale"},{anchor:"transformers.Llama4TextConfig.cache_implementation",description:"<strong>cache_implementation</strong> (<code>&lt;fill_type&gt;</code>, <em>optional</em>, defaults to <code>&quot;hybrid&quot;</code>) &#x2014; <fill_docstring></fill_docstring>",name:"cache_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/configuration_llama4.py#L131"}}),He=new W({props:{title:"Llama4VisionConfig",local:"transformers.Llama4VisionConfig",headingTag:"h2"}}),Pe=new L({props:{name:"class transformers.Llama4VisionConfig",anchor:"transformers.Llama4VisionConfig",parameters:[{name:"hidden_size",val:": int = 768"},{name:"hidden_act",val:": str = 'gelu'"},{name:"num_hidden_layers",val:": int = 34"},{name:"num_attention_heads",val:": int = 16"},{name:"num_channels",val:": int = 3"},{name:"intermediate_size",val:": int = 5632"},{name:"vision_output_dim",val:": int = 7680"},{name:"image_size",val:": int = 448"},{name:"patch_size",val:": int = 14"},{name:"norm_eps",val:": float = 1e-05"},{name:"vision_feature_layer",val:" = -1"},{name:"vision_feature_select_strategy",val:" = 'default'"},{name:"initializer_range",val:": float = 0.02"},{name:"pixel_shuffle_ratio",val:" = 0.5"},{name:"projector_input_dim",val:" = 4096"},{name:"projector_output_dim",val:" = 4096"},{name:"multi_modal_projector_bias",val:" = False"},{name:"projector_dropout",val:" = 0.0"},{name:"attention_dropout",val:" = 0.0"},{name:"rope_theta",val:" = 10000"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Llama4VisionConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.Llama4VisionConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> <code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.Llama4VisionConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 34) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Llama4VisionConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Llama4VisionConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of channels in the input image.`,name:"num_channels"},{anchor:"transformers.Llama4VisionConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 5632) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.Llama4VisionConfig.vision_output_dim",description:`<strong>vision_output_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 7680) &#x2014;
Dimensionality of the vision model output. Includes output of transformer
encoder with intermediate layers and global transformer encoder.`,name:"vision_output_dim"},{anchor:"transformers.Llama4VisionConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 448) &#x2014;
The size (resolution) of each image <em>tile</em>.`,name:"image_size"},{anchor:"transformers.Llama4VisionConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 14) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.Llama4VisionConfig.norm_eps",description:`<strong>norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"norm_eps"},{anchor:"transformers.Llama4VisionConfig.vision_feature_layer",description:"<strong>vision_feature_layer</strong> (&#x201C;, <em>optional</em>, defaults to -1) &#x2014; TODO",name:"vision_feature_layer"},{anchor:"transformers.Llama4VisionConfig.vision_feature_select_strategy",description:"<strong>vision_feature_select_strategy</strong> (<code>int</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014; TODO",name:"vision_feature_select_strategy"},{anchor:"transformers.Llama4VisionConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Llama4VisionConfig.pixel_shuffle_ratio",description:"<strong>pixel_shuffle_ratio</strong> (<code>int</code>, <em>optional</em>, defaults to 0.5) &#x2014; TODO",name:"pixel_shuffle_ratio"},{anchor:"transformers.Llama4VisionConfig.projector_input_dim",description:"<strong>projector_input_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014; TODO",name:"projector_input_dim"},{anchor:"transformers.Llama4VisionConfig.projector_output_dim",description:"<strong>projector_output_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014; TODO",name:"projector_output_dim"},{anchor:"transformers.Llama4VisionConfig.multi_modal_projector_bias",description:"<strong>multi_modal_projector_bias</strong> (<code>int</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; TODO",name:"multi_modal_projector_bias"},{anchor:"transformers.Llama4VisionConfig.projector_dropout",description:"<strong>projector_dropout</strong> (<code>int</code>, <em>optional</em>, defaults to 0.0) &#x2014; TODO",name:"projector_dropout"},{anchor:"transformers.Llama4VisionConfig.attention_dropout",description:"<strong>attention_dropout</strong> (<code>int</code>, <em>optional</em>, defaults to 0.0) &#x2014; TODO",name:"attention_dropout"},{anchor:"transformers.Llama4VisionConfig.rope_theta",description:"<strong>rope_theta</strong> (<code>int</code>, <em>optional</em>, defaults to 10000) &#x2014; TODO",name:"rope_theta"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/configuration_llama4.py#L25"}}),Ae=new W({props:{title:"Llama4Processor",local:"transformers.Llama4Processor",headingTag:"h2"}}),De=new L({props:{name:"class transformers.Llama4Processor",anchor:"transformers.Llama4Processor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"patch_size",val:": int = 14"},{name:"pixel_shuffle_ratio",val:": float = 0.5"},{name:"fake_image_token",val:" = '<|image|>'"},{name:"image_token",val:" = '<|image|>'"},{name:"start_of_image_token",val:" = '<|image_start|>'"},{name:"end_of_image_token",val:" = '<|image_end|>'"},{name:"patch_token",val:" = '<|patch|>'"},{name:"tile_x_separator_token",val:" = '<|tile_x_separator|>'"},{name:"tile_y_separator_token",val:" = '<|tile_y_separator|>'"},{name:"chat_template",val:` = '{{- bos_token }}\\n{%- if custom_tools is defined %}\\n    {%- set tools = custom_tools %}\\n{%- endif %}\\n{%- if not tools_in_user_message is defined %}\\n    {%- set tools_in_user_message = true %}\\n{%- endif %}\\n{%- if not date_string is defined %}\\n    {%- if strftime_now is defined %}\\n        {%- set date_string = strftime_now("%d %b %Y") %}\\n    {%- else %}\\n        {%- set date_string = "26 Jul 2024" %}\\n    {%- endif %}\\n{%- endif %}\\n{%- if not tools is defined %}\\n    {%- set tools = none %}\\n{%- endif %}\\n\\n{#- This block extracts the system message, so we can slot it into the right place. #}\\n{%- if messages[0][\\'role\\'] == \\'system\\' %}    \\n    {%- if messages[0][\\'content\\'] is string %}\\n        {%- set system_message = messages[0][\\'content\\']|trim %}\\n    {%- else %}\\n        {#- FIXME: The processor requires an array, always. #}\\n        {%- set system_message = messages[0][\\'content\\'][0][\\'text\\']|trim %}\\n    {%- endif %}\\n    {%- set messages = messages[1:] %}\\n    {%- set user_supplied_system_message = true %}\\n{%- else %}\\n    {%- set system_message = "" %}\\n    {%- set user_supplied_system_message = false %}\\n{%- endif %}\\n\\n{#- System message if the user supplied one #}\\n{%- if user_supplied_system_message %}\\n    {{- "<|header_start|>system<|header_end|>\\n\\n" }}\\n    {%- if tools is not none %}\\n        {{- "Environment: ipython\\n" }}\\n    {%- endif %}\\n    {%- if tools is not none and not tools_in_user_message %}\\n        {{- "You have access to the following functions. To call a function, please respond with JSON for a function call." }}\\n        {{- \\'Respond in the format {"name": function name, "parameters": dictionary of argument name and its value}.\\' }}\\n        {{- "Do not use variables.\\n\\n" }}\\n        {%- for t in tools %}\\n            {{- t | tojson(indent=4) }}\\n            {{- "\\n\\n" }}\\n        {%- endfor %}\\n    {%- endif %}\\n    {{- system_message }}\\n    {{- "<|eot|>" }}\\n{%- endif %}\\n\\n{#- Custom tools are passed in a user message with some extra guidance #}\\n{%- if tools_in_user_message and not tools is none %}\\n    {#- Extract the first user message so we can plug it in here #}\\n    {%- if messages | length != 0 %}\\n        {%- set first_user_message = messages[0][\\'content\\']|trim %}\\n        {%- set messages = messages[1:] %}\\n    {%- else %}\\n        {{- raise_exception("Cannot put tools in the first user message when there\\'s no first user message!") }}\\n{%- endif %}\\n    {{- \\'<|header_start|>user<|header_end|>\\n\\n\\' -}}\\n    {{- "Given the following functions, please respond with a JSON for a function call " }}\\n    {{- "with its proper arguments that best answers the given prompt.\\n\\n" }}\\n    {{- \\'Respond in the format {"name": function name, "parameters": dictionary of argument name and its value}.\\' }}\\n    {{- "Do not use variables.\\n\\n" }}\\n    {%- for t in tools %}\\n        {{- t | tojson(indent=4) }}\\n        {{- "\\n\\n" }}\\n    {%- endfor %}\\n    {{- first_user_message + "<|eot|>"}}\\n{%- endif %}\\n\\n{%- for message in messages %}\\n    {%- if not (message.role == \\'ipython\\' or message.role == \\'tool\\' or \\'tool_calls\\' in message) %}\\n    {{- \\'<|header_start|>\\' + message[\\'role\\'] + \\'<|header_end|>\\n\\n\\' }}\\n        {%- if message[\\'content\\'] is string %}\\n            {{- message[\\'content\\'] }}\\n        {%- else %}\\n            {%- for content in message[\\'content\\'] %}\\n                {%- if content[\\'type\\'] == \\'image\\' %}\\n                    {{- \\'<|image|>\\' }}\\n                {%- elif content[\\'type\\'] == \\'text\\' %}\\n                    {{- content[\\'text\\'] }}\\n                {%- endif %}\\n            {%- endfor %}\\n        {%- endif %}\\n        {{- "<|eot|>" }}\\n    {%- elif \\'tool_calls\\' in message and message.tool_calls|length > 0 %}\\n       {{- \\'<|header_start|>assistant<|header_end|>\\n\\n\\' -}}\\n       {{- \\'<|python_start|>\\' }}\\n        {%- if message[\\'content\\'] is string %}\\n            {{- message[\\'content\\'] }}\\n        {%- else %}\\n            {%- for content in message[\\'content\\'] %}\\n                {%- if content[\\'type\\'] == \\'image\\' %}\\n                    {{- \\'<|image|>\\' }}\\n                {%- elif content[\\'type\\'] == \\'text\\' %}\\n                    {{- content[\\'text\\'] }}\\n                {%- endif %}\\n            {%- endfor %}\\n        {%- endif %}\\n       {{- \\'<|python_end|>\\' }}\\n        {%- for tool_call in message.tool_calls %}\\n           {{- \\'{"name": "\\' + tool_call.function.name + \\'", \\' }}\\n           {{- \\'"parameters": \\' }}\\n           {{- tool_call.function.arguments | tojson }}\\n           {{- "}" }}\\n        {%- endfor %}\\n       {{- "<|eot|>" }}\\n    {%- elif message.role == "tool" or message.role == "ipython" %}\\n        {{- "<|header_start|>ipython<|header_end|>\\n\\n" }}\\n        {%- if message.content is mapping or message.content is iterable %}\\n            {{- message.content | tojson }}\\n        {%- else %}\\n            {{- message.content }}\\n        {%- endif %}\\n        {{- "<|eot|>" }}\\n    {%- endif %}\\n{%- endfor %}\\n{%- if add_generation_prompt %}\\n    {{- \\'<|header_start|>assistant<|header_end|>\\n\\n\\' }}\\n{%- endif %}\\n'`},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Llama4Processor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.Llama4Processor.tokenizer",description:`<strong>tokenizer</strong> ([<code>PreTrainedTokenizer</code>, <code>PreTrainedTokenizerFast</code>], <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.Llama4Processor.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 28) &#x2014;
The size of image patches for tokenization.`,name:"patch_size"},{anchor:"transformers.Llama4Processor.img_size",description:`<strong>img_size</strong> (<code>int</code>, <em>optional</em>, defaults to 364) &#x2014;
The size of the image to be tokenized. This should correspond to the size given to the image processor.`,name:"img_size"},{anchor:"transformers.Llama4Processor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|image|&gt;&quot;</code>) &#x2014;
The token to be used to represent an image in the text.`,name:"image_token"},{anchor:"transformers.Llama4Processor.downsample_factor",description:`<strong>downsample_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The factor by which to scale the patch size.`,name:"downsample_factor"},{anchor:"transformers.Llama4Processor.start_of_img_token",description:`<strong>start_of_img_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|START_OF_IMG|&gt;&quot;</code>) &#x2014;
The token to be used to represent the start of an image in the text.`,name:"start_of_img_token"},{anchor:"transformers.Llama4Processor.end_of_img_token",description:`<strong>end_of_img_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|END_OF_IMG|&gt;&quot;</code>) &#x2014;
The token to be used to represent the end of an image in the text.`,name:"end_of_img_token"},{anchor:"transformers.Llama4Processor.img_patch_token",description:`<strong>img_patch_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|IMG_PATCH|&gt;&quot;</code>) &#x2014;
The token to be used to represent an image patch in the text.`,name:"img_patch_token"},{anchor:"transformers.Llama4Processor.img_line_break_token",description:`<strong>img_line_break_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|IMG_LINE_BREAK|&gt;&quot;</code>) &#x2014;
The token to be used to represent a line break in the text.`,name:"img_line_break_token"},{anchor:"transformers.Llama4Processor.tile_token",description:`<strong>tile_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;TILE&quot;</code>) &#x2014;
The token to be used to represent an image patch in the text.`,name:"tile_token"},{anchor:"transformers.Llama4Processor.tile_global_token",description:`<strong>tile_global_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;TILE_GLOBAL&quot;</code>) &#x2014;
The token to be used to represent the cover image in the text.`,name:"tile_global_token"},{anchor:"transformers.Llama4Processor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/processing_llama4.py#L51"}}),Oe=new L({props:{name:"batch_decode",anchor:"transformers.Llama4Processor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/processing_llama4.py#L258"}}),Ke=new L({props:{name:"decode",anchor:"transformers.Llama4Processor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/processing_llama4.py#L265"}}),et=new W({props:{title:"Llama4ImageProcessorFast",local:"transformers.Llama4ImageProcessorFast",headingTag:"h2"}}),tt=new L({props:{name:"class transformers.Llama4ImageProcessorFast",anchor:"transformers.Llama4ImageProcessorFast",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llama4.image_processing_llama4_fast.Llama4ImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.Llama4ImageProcessorFast.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.Llama4ImageProcessorFast.size",description:`<strong>size</strong> (<code>dict[str, int]</code>, <em>optional</em>, defaults to <code>{&apos;height&apos; -- 336, &apos;width&apos;: 336}</code>):
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.Llama4ImageProcessorFast.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.Llama4ImageProcessorFast.resample",description:`<strong>resample</strong> (<code>Union[PILImageResampling, F.InterpolationMode, NoneType]</code>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.Llama4ImageProcessorFast.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.Llama4ImageProcessorFast.crop_size",description:`<strong>crop_size</strong> (<code>dict[str, int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.Llama4ImageProcessorFast.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.Llama4ImageProcessorFast.rescale_factor",description:`<strong>rescale_factor</strong> (<code>Union[int, float, NoneType]</code>, defaults to <code>0.00392156862745098</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Llama4ImageProcessorFast.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.Llama4ImageProcessorFast.image_mean",description:`<strong>image_mean</strong> (<code>Union[float, list[float], NoneType]</code>, defaults to <code>[0.5, 0.5, 0.5]</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.Llama4ImageProcessorFast.image_std",description:`<strong>image_std</strong> (<code>Union[float, list[float], NoneType]</code>, defaults to <code>[0.5, 0.5, 0.5]</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.Llama4ImageProcessorFast.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.Llama4ImageProcessorFast.return_tensors",description:"<strong>return_tensors</strong> (<code>Union[str, ~utils.generic.TensorType, NoneType]</code>, defaults to <code>None</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.Llama4ImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.Llama4ImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.Llama4ImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.Llama4ImageProcessorFast.max_patches",description:`<strong>max_patches</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The maximum number of patches to be extracted from the image.
Can be overridden by the <code>max_patches</code> parameter in the <code>preprocess</code> method.`,name:"max_patches"},{anchor:"transformers.Llama4ImageProcessorFast.resize_to_max_canvas",description:`<strong>resize_to_max_canvas</strong> (<code>bool</code>, <em>optional</em>, defaults to False) &#x2014;
Whether to resize the image to the maximum canvas size.
If True, picks the canvas the allows the largest resizing without distortion.
If False, downsample as little as possible, including no resizing at all,
but never upsample, unless the image is smaller than the patch size.`,name:"resize_to_max_canvas"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/image_processing_llama4_fast.py#L342"}}),ot=new L({props:{name:"preprocess",anchor:"transformers.Llama4ImageProcessorFast.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llama4.image_processing_llama4_fast.Llama4ImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.Llama4ImageProcessorFast.preprocess.images",description:`<strong>images</strong> (<code>Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, list[&apos;PIL.Image.Image&apos;], list[numpy.ndarray], list[&apos;torch.Tensor&apos;]]</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.size",description:`<strong>size</strong> (<code>dict[str, int]</code>, <em>optional</em>) &#x2014;
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.resample",description:`<strong>resample</strong> (<code>Union[PILImageResampling, F.InterpolationMode, NoneType]</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>dict[str, int]</code>, <em>optional</em>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>Union[int, float, NoneType]</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>Union[float, list[float], NoneType]</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.image_std",description:`<strong>image_std</strong> (<code>Union[float, list[float], NoneType]</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.return_tensors",description:"<strong>return_tensors</strong> (<code>Union[str, ~utils.generic.TensorType, NoneType]</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.max_patches",description:`<strong>max_patches</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The maximum number of patches to be extracted from the image.
Can be overridden by the <code>max_patches</code> parameter in the <code>preprocess</code> method.`,name:"max_patches"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.resize_to_max_canvas",description:`<strong>resize_to_max_canvas</strong> (<code>bool</code>, <em>optional</em>, defaults to False) &#x2014;
Whether to resize the image to the maximum canvas size.
If True, picks the canvas the allows the largest resizing without distortion.
If False, downsample as little as possible, including no resizing at all,
but never upsample, unless the image is smaller than the patch size.`,name:"resize_to_max_canvas"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/image_processing_llama4_fast.py#L382",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><strong>data</strong> (<code>dict</code>) — Dictionary of lists/arrays/tensors returned by the <strong>call</strong> method (‘pixel_values’, etc.).</li>
<li><strong>tensor_type</strong> (<code>Union[None, str, TensorType]</code>, <em>optional</em>) — You can give a tensor_type here to convert the lists of integers in PyTorch/TensorFlow/Numpy Tensors at
initialization.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>&lt;class 'transformers.image_processing_base.BatchFeature'&gt;</code></p>
`}}),nt=new L({props:{name:"rescale_and_normalize",anchor:"transformers.Llama4ImageProcessorFast.rescale_and_normalize",parameters:[{name:"images",val:": torch.Tensor"},{name:"do_rescale",val:": bool"},{name:"rescale_factor",val:": float"},{name:"do_normalize",val:": bool"},{name:"image_mean",val:": typing.Union[float, typing.List[float]]"},{name:"image_std",val:": typing.Union[float, typing.List[float]]"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/image_processing_llama4_fast.py#L359"}}),at=new W({props:{title:"Llama4ForConditionalGeneration",local:"transformers.Llama4ForConditionalGeneration",headingTag:"h2"}}),st=new L({props:{name:"class transformers.Llama4ForConditionalGeneration",anchor:"transformers.Llama4ForConditionalGeneration",parameters:[{name:"config",val:": Llama4Config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L1455"}}),rt=new L({props:{name:"forward",anchor:"transformers.Llama4ForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"image_sizes",val:": Tensor = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llama4.modeling_llama4.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.Llama4ForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int], NoneType]</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>.`,name:"vision_feature_select_strategy"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, 2)</code>) &#x2014;
The sizes of the images in the batch, being (height, width) for each image.`,name:"image_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L1520",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.llama4.modeling_llama4.Llama4CausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4Config"
>Llama4Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size (batch_size, num_images, sequence_length, hidden_size)\`.
image_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.llama4.modeling_llama4.Llama4CausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),fe=new co({props:{$$slots:{default:[_s]},$$scope:{ctx:J}}}),ge=new fo({props:{anchor:"transformers.Llama4ForConditionalGeneration.forward.example",$$slots:{default:[ys]},$$scope:{ctx:J}}}),lt=new L({props:{name:"get_image_features",anchor:"transformers.Llama4ForConditionalGeneration.get_image_features",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int]]"},{name:"vision_feature_select_strategy",val:": str"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Llama4ForConditionalGeneration.get_image_features.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor]</code> of shape <code>(batch_size, channels, height, width)</code>) &#x2014;
The tensors corresponding to the input images.`,name:"pixel_values"},{anchor:"transformers.Llama4ForConditionalGeneration.get_image_features.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.Llama4ForConditionalGeneration.get_image_features.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>`,name:"vision_feature_select_strategy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L1490",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Image feature tensor of shape <code>(num_images, image_length, embed_dim)</code>).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (<code>torch.Tensor</code>)</p>
`}}),dt=new W({props:{title:"Llama4ForCausalLM",local:"transformers.Llama4ForCausalLM",headingTag:"h2"}}),ct=new L({props:{name:"class transformers.Llama4ForCausalLM",anchor:"transformers.Llama4ForCausalLM",parameters:[{name:"config",val:": Llama4TextConfig"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L828"}}),mt=new L({props:{name:"forward",anchor:"transformers.Llama4ForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.Cache, typing.List[torch.FloatTensor], NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llama4.modeling_llama4.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.Llama4ForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Llama4ForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Llama4ForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Llama4ForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Union[~cache_utils.Cache, List[torch.FloatTensor], NoneType]</code>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Llama4ForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Llama4ForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.Llama4ForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Llama4ForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Llama4ForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Llama4ForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Llama4ForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.Llama4ForCausalLM.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L862",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4Config"
>Llama4Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ye=new co({props:{$$slots:{default:[Ts]},$$scope:{ctx:J}}}),Te=new fo({props:{anchor:"transformers.Llama4ForCausalLM.forward.example",$$slots:{default:[bs]},$$scope:{ctx:J}}}),ut=new W({props:{title:"Llama4TextModel",local:"transformers.Llama4TextModel",headingTag:"h2"}}),ht=new L({props:{name:"class transformers.Llama4TextModel",anchor:"transformers.Llama4TextModel",parameters:[{name:"config",val:": Llama4TextConfig"}],parametersDescription:[{anchor:"transformers.Llama4TextModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4TextConfig">Llama4TextConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L473"}}),ft=new L({props:{name:"create_chunked_attention_mask",anchor:"transformers.Llama4TextModel.create_chunked_attention_mask",parameters:[{name:"attention_chunk_size",val:": int"},{name:"start",val:": int"},{name:"end",val:": int"},{name:"device",val:": device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L743"}}),gt=new L({props:{name:"forward",anchor:"transformers.Llama4TextModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**flash_attn_kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.Llama4TextModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Llama4TextModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Llama4TextModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Llama4TextModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Llama4TextModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Llama4TextModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Llama4TextModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Llama4TextModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Llama4TextModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Llama4TextModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L501",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4Config"
>Llama4Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),be=new co({props:{$$slots:{default:[Ms]},$$scope:{ctx:J}}}),yt=new W({props:{title:"Llama4ForCausalLM",local:"transformers.Llama4ForCausalLM",headingTag:"h2"}}),Tt=new L({props:{name:"class transformers.Llama4ForCausalLM",anchor:"transformers.Llama4ForCausalLM",parameters:[{name:"config",val:": Llama4TextConfig"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L828"}}),bt=new L({props:{name:"forward",anchor:"transformers.Llama4ForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.Cache, typing.List[torch.FloatTensor], NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llama4.modeling_llama4.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.Llama4ForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Llama4ForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Llama4ForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Llama4ForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Union[~cache_utils.Cache, List[torch.FloatTensor], NoneType]</code>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Llama4ForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Llama4ForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.Llama4ForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Llama4ForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Llama4ForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Llama4ForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Llama4ForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.Llama4ForCausalLM.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L862",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4Config"
>Llama4Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Me=new co({props:{$$slots:{default:[ws]},$$scope:{ctx:J}}}),we=new fo({props:{anchor:"transformers.Llama4ForCausalLM.forward.example",$$slots:{default:[vs]},$$scope:{ctx:J}}}),wt=new W({props:{title:"Llama4VisionModel",local:"transformers.Llama4VisionModel",headingTag:"h2"}}),vt=new L({props:{name:"class transformers.Llama4VisionModel",anchor:"transformers.Llama4VisionModel",parameters:[{name:"config",val:": Llama4VisionConfig"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L1321"}}),Jt=new L({props:{name:"forward",anchor:"transformers.Llama4VisionModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L1357"}}),Je=new fo({props:{anchor:"transformers.Llama4VisionModel.forward.example",$$slots:{default:[Js]},$$scope:{ctx:J}}}),$t=new L({props:{name:"get_input_embeddings",anchor:"transformers.Llama4VisionModel.get_input_embeddings",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L1351"}}),kt=new es({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/llama4.md"}}),{c(){t=h("meta"),p=l(),o=h("p"),r=l(),g(m.$$.fragment),n=l(),c=h("div"),c.innerHTML=v,U=l(),x=h("p"),x.textContent=$,k=l(),ee=h("ul"),ee.innerHTML=mo,Ce=l(),te=h("p"),te.textContent=po,go=l(),je=h("p"),je.innerHTML=la,_o=l(),g(le.$$.fragment),yo=l(),Le=h("p"),Le.innerHTML=ia,To=l(),g(ie.$$.fragment),bo=l(),g(Ie.$$.fragment),Mo=l(),g(ze.$$.fragment),wo=l(),Fe=h("p"),Fe.innerHTML=da,vo=l(),Ge=h("p"),Ge.innerHTML=ca,Jo=l(),g(de.$$.fragment),$o=l(),g(Ze.$$.fragment),Uo=l(),We=h("p"),We.innerHTML=ma,ko=l(),Ve=h("p"),Ve.textContent=pa,xo=l(),Be=h("p"),Be.textContent=ua,Co=l(),g(ce.$$.fragment),jo=l(),g(Re.$$.fragment),Lo=l(),qe=h("p"),qe.textContent=ha,Io=l(),Ee=h("p"),Ee.innerHTML=fa,zo=l(),g(Ne.$$.fragment),Fo=l(),g(Xe.$$.fragment),Go=l(),G=h("div"),g(Qe.$$.fragment),pn=l(),zt=h("p"),zt.innerHTML=ga,un=l(),Ft=h("p"),Ft.innerHTML=_a,hn=l(),Gt=h("p"),Gt.innerHTML=ya,fn=l(),g(me.$$.fragment),Zo=l(),g(Ye.$$.fragment),Wo=l(),Z=h("div"),g(Se.$$.fragment),gn=l(),Zt=h("p"),Zt.innerHTML=Ta,_n=l(),Wt=h("p"),Wt.innerHTML=ba,yn=l(),Vt=h("p"),Vt.innerHTML=Ma,Tn=l(),Bt=h("p"),Bt.textContent=wa,Vo=l(),g(He.$$.fragment),Bo=l(),V=h("div"),g(Pe.$$.fragment),bn=l(),Rt=h("p"),Rt.innerHTML=va,Mn=l(),qt=h("p"),qt.innerHTML=Ja,wn=l(),Et=h("p"),Et.innerHTML=$a,Ro=l(),g(Ae.$$.fragment),qo=l(),B=h("div"),g(De.$$.fragment),vn=l(),Nt=h("p"),Nt.innerHTML=Ua,Jn=l(),pe=h("div"),g(Oe.$$.fragment),$n=l(),Xt=h("p"),Xt.innerHTML=ka,Un=l(),ue=h("div"),g(Ke.$$.fragment),kn=l(),Qt=h("p"),Qt.innerHTML=xa,Eo=l(),g(et.$$.fragment),No=l(),R=h("div"),g(tt.$$.fragment),xn=l(),Yt=h("p"),Yt.textContent=Ca,Cn=l(),St=h("div"),g(ot.$$.fragment),jn=l(),he=h("div"),g(nt.$$.fragment),Ln=l(),Ht=h("p"),Ht.textContent=ja,Xo=l(),g(at.$$.fragment),Qo=l(),H=h("div"),g(st.$$.fragment),In=l(),N=h("div"),g(rt.$$.fragment),zn=l(),Pt=h("p"),Pt.innerHTML=La,Fn=l(),g(fe.$$.fragment),Gn=l(),g(ge.$$.fragment),Zn=l(),_e=h("div"),g(lt.$$.fragment),Wn=l(),At=h("p"),At.textContent=Ia,Yo=l(),it=h("ul"),it.innerHTML=za,So=l(),g(dt.$$.fragment),Ho=l(),ae=h("div"),g(ct.$$.fragment),Vn=l(),X=h("div"),g(mt.$$.fragment),Bn=l(),Dt=h("p"),Dt.innerHTML=Fa,Rn=l(),g(ye.$$.fragment),qn=l(),g(Te.$$.fragment),Po=l(),pt=h("ul"),pt.innerHTML=Ga,Ao=l(),g(ut.$$.fragment),Do=l(),z=h("div"),g(ht.$$.fragment),En=l(),Ot=h("p"),Ot.textContent=Za,Nn=l(),Kt=h("p"),Kt.innerHTML=Wa,Xn=l(),eo=h("p"),eo.innerHTML=Va,Qn=l(),Q=h("div"),g(ft.$$.fragment),Yn=l(),to=h("p"),to.textContent=Ba,Sn=l(),oo=h("p"),oo.textContent=Ra,Hn=l(),no=h("p"),no.textContent=qa,Pn=l(),oe=h("div"),g(gt.$$.fragment),An=l(),ao=h("p"),ao.innerHTML=Ea,Dn=l(),g(be.$$.fragment),Oo=l(),_t=h("ul"),_t.innerHTML=Na,Ko=l(),g(yt.$$.fragment),en=l(),se=h("div"),g(Tt.$$.fragment),On=l(),Y=h("div"),g(bt.$$.fragment),Kn=l(),so=h("p"),so.innerHTML=Xa,ea=l(),g(Me.$$.fragment),ta=l(),g(we.$$.fragment),tn=l(),Mt=h("ul"),Mt.innerHTML=Qa,on=l(),g(wt.$$.fragment),nn=l(),P=h("div"),g(vt.$$.fragment),oa=l(),ve=h("div"),g(Jt.$$.fragment),na=l(),g(Je.$$.fragment),aa=l(),$e=h("div"),g($t.$$.fragment),sa=l(),ro=h("p"),ro.textContent=Ya,an=l(),Ut=h("ul"),Ut.innerHTML=Sa,sn=l(),g(kt.$$.fragment),rn=l(),uo=h("p"),this.h()},l(e){const s=Oa("svelte-u9bgzb",document.head);t=f(s,"META",{name:!0,content:!0}),s.forEach(a),p=i(e),o=f(e,"P",{}),C(o).forEach(a),r=i(e),_(m.$$.fragment,e),n=i(e),c=f(e,"DIV",{style:!0,"data-svelte-h":!0}),w(c)!=="svelte-1wvb92v"&&(c.innerHTML=v),U=i(e),x=f(e,"P",{"data-svelte-h":!0}),w(x)!=="svelte-1owo9yl"&&(x.textContent=$),k=i(e),ee=f(e,"UL",{"data-svelte-h":!0}),w(ee)!=="svelte-1y7yvda"&&(ee.innerHTML=mo),Ce=i(e),te=f(e,"P",{"data-svelte-h":!0}),w(te)!=="svelte-omzkf7"&&(te.textContent=po),go=i(e),je=f(e,"P",{"data-svelte-h":!0}),w(je)!=="svelte-1q2xgmk"&&(je.innerHTML=la),_o=i(e),_(le.$$.fragment,e),yo=i(e),Le=f(e,"P",{"data-svelte-h":!0}),w(Le)!=="svelte-nzpejo"&&(Le.innerHTML=ia),To=i(e),_(ie.$$.fragment,e),bo=i(e),_(Ie.$$.fragment,e),Mo=i(e),_(ze.$$.fragment,e),wo=i(e),Fe=f(e,"P",{"data-svelte-h":!0}),w(Fe)!=="svelte-x0ymgx"&&(Fe.innerHTML=da),vo=i(e),Ge=f(e,"P",{"data-svelte-h":!0}),w(Ge)!=="svelte-1mlq2xi"&&(Ge.innerHTML=ca),Jo=i(e),_(de.$$.fragment,e),$o=i(e),_(Ze.$$.fragment,e),Uo=i(e),We=f(e,"P",{"data-svelte-h":!0}),w(We)!=="svelte-3fz0dv"&&(We.innerHTML=ma),ko=i(e),Ve=f(e,"P",{"data-svelte-h":!0}),w(Ve)!=="svelte-ql9del"&&(Ve.textContent=pa),xo=i(e),Be=f(e,"P",{"data-svelte-h":!0}),w(Be)!=="svelte-1e6p2bq"&&(Be.textContent=ua),Co=i(e),_(ce.$$.fragment,e),jo=i(e),_(Re.$$.fragment,e),Lo=i(e),qe=f(e,"P",{"data-svelte-h":!0}),w(qe)!=="svelte-1ey514g"&&(qe.textContent=ha),Io=i(e),Ee=f(e,"P",{"data-svelte-h":!0}),w(Ee)!=="svelte-1ezy410"&&(Ee.innerHTML=fa),zo=i(e),_(Ne.$$.fragment,e),Fo=i(e),_(Xe.$$.fragment,e),Go=i(e),G=f(e,"DIV",{class:!0});var q=C(G);_(Qe.$$.fragment,q),pn=i(q),zt=f(q,"P",{"data-svelte-h":!0}),w(zt)!=="svelte-efaf7b"&&(zt.innerHTML=ga),un=i(q),Ft=f(q,"P",{"data-svelte-h":!0}),w(Ft)!=="svelte-sh2hyl"&&(Ft.innerHTML=_a),hn=i(q),Gt=f(q,"P",{"data-svelte-h":!0}),w(Gt)!=="svelte-o55m63"&&(Gt.innerHTML=ya),fn=i(q),_(me.$$.fragment,q),q.forEach(a),Zo=i(e),_(Ye.$$.fragment,e),Wo=i(e),Z=f(e,"DIV",{class:!0});var E=C(Z);_(Se.$$.fragment,E),gn=i(E),Zt=f(E,"P",{"data-svelte-h":!0}),w(Zt)!=="svelte-zeurjx"&&(Zt.innerHTML=Ta),_n=i(E),Wt=f(E,"P",{"data-svelte-h":!0}),w(Wt)!=="svelte-sh2hyl"&&(Wt.innerHTML=ba),yn=i(E),Vt=f(E,"P",{"data-svelte-h":!0}),w(Vt)!=="svelte-o55m63"&&(Vt.innerHTML=Ma),Tn=i(E),Bt=f(E,"P",{"data-svelte-h":!0}),w(Bt)!=="svelte-11lpom8"&&(Bt.textContent=wa),E.forEach(a),Vo=i(e),_(He.$$.fragment,e),Bo=i(e),V=f(e,"DIV",{class:!0});var A=C(V);_(Pe.$$.fragment,A),bn=i(A),Rt=f(A,"P",{"data-svelte-h":!0}),w(Rt)!=="svelte-115ln58"&&(Rt.innerHTML=va),Mn=i(A),qt=f(A,"P",{"data-svelte-h":!0}),w(qt)!=="svelte-sh2hyl"&&(qt.innerHTML=Ja),wn=i(A),Et=f(A,"P",{"data-svelte-h":!0}),w(Et)!=="svelte-o55m63"&&(Et.innerHTML=$a),A.forEach(a),Ro=i(e),_(Ae.$$.fragment,e),qo=i(e),B=f(e,"DIV",{class:!0});var D=C(B);_(De.$$.fragment,D),vn=i(D),Nt=f(D,"P",{"data-svelte-h":!0}),w(Nt)!=="svelte-py0zio"&&(Nt.innerHTML=Ua),Jn=i(D),pe=f(D,"DIV",{class:!0});var xt=C(pe);_(Oe.$$.fragment,xt),$n=i(xt),Xt=f(xt,"P",{"data-svelte-h":!0}),w(Xt)!=="svelte-1yrf9bj"&&(Xt.innerHTML=ka),xt.forEach(a),Un=i(D),ue=f(D,"DIV",{class:!0});var Ct=C(ue);_(Ke.$$.fragment,Ct),kn=i(Ct),Qt=f(Ct,"P",{"data-svelte-h":!0}),w(Qt)!=="svelte-1jl7gd5"&&(Qt.innerHTML=xa),Ct.forEach(a),D.forEach(a),Eo=i(e),_(et.$$.fragment,e),No=i(e),R=f(e,"DIV",{class:!0});var O=C(R);_(tt.$$.fragment,O),xn=i(O),Yt=f(O,"P",{"data-svelte-h":!0}),w(Yt)!=="svelte-1wru4bd"&&(Yt.textContent=Ca),Cn=i(O),St=f(O,"DIV",{class:!0});var ho=C(St);_(ot.$$.fragment,ho),ho.forEach(a),jn=i(O),he=f(O,"DIV",{class:!0});var jt=C(he);_(nt.$$.fragment,jt),Ln=i(jt),Ht=f(jt,"P",{"data-svelte-h":!0}),w(Ht)!=="svelte-15zn3yd"&&(Ht.textContent=ja),jt.forEach(a),O.forEach(a),Xo=i(e),_(at.$$.fragment,e),Qo=i(e),H=f(e,"DIV",{class:!0});var re=C(H);_(st.$$.fragment,re),In=i(re),N=f(re,"DIV",{class:!0});var K=C(N);_(rt.$$.fragment,K),zn=i(K),Pt=f(K,"P",{"data-svelte-h":!0}),w(Pt)!=="svelte-adacta"&&(Pt.innerHTML=La),Fn=i(K),_(fe.$$.fragment,K),Gn=i(K),_(ge.$$.fragment,K),K.forEach(a),Zn=i(re),_e=f(re,"DIV",{class:!0});var Lt=C(_e);_(lt.$$.fragment,Lt),Wn=i(Lt),At=f(Lt,"P",{"data-svelte-h":!0}),w(At)!=="svelte-s9i4hu"&&(At.textContent=Ia),Lt.forEach(a),re.forEach(a),Yo=i(e),it=f(e,"UL",{"data-svelte-h":!0}),w(it)!=="svelte-n3ow4o"&&(it.innerHTML=za),So=i(e),_(dt.$$.fragment,e),Ho=i(e),ae=f(e,"DIV",{class:!0});var It=C(ae);_(ct.$$.fragment,It),Vn=i(It),X=f(It,"DIV",{class:!0});var Ue=C(X);_(mt.$$.fragment,Ue),Bn=i(Ue),Dt=f(Ue,"P",{"data-svelte-h":!0}),w(Dt)!=="svelte-xnjod6"&&(Dt.innerHTML=Fa),Rn=i(Ue),_(ye.$$.fragment,Ue),qn=i(Ue),_(Te.$$.fragment,Ue),Ue.forEach(a),It.forEach(a),Po=i(e),pt=f(e,"UL",{"data-svelte-h":!0}),w(pt)!=="svelte-n3ow4o"&&(pt.innerHTML=Ga),Ao=i(e),_(ut.$$.fragment,e),Do=i(e),z=f(e,"DIV",{class:!0});var S=C(z);_(ht.$$.fragment,S),En=i(S),Ot=f(S,"P",{"data-svelte-h":!0}),w(Ot)!=="svelte-h0upho"&&(Ot.textContent=Za),Nn=i(S),Kt=f(S,"P",{"data-svelte-h":!0}),w(Kt)!=="svelte-6pahdo"&&(Kt.innerHTML=Wa),Xn=i(S),eo=f(S,"P",{"data-svelte-h":!0}),w(eo)!=="svelte-hswkmf"&&(eo.innerHTML=Va),Qn=i(S),Q=f(S,"DIV",{class:!0});var ke=C(Q);_(ft.$$.fragment,ke),Yn=i(ke),to=f(ke,"P",{"data-svelte-h":!0}),w(to)!=="svelte-1ebclbn"&&(to.textContent=Ba),Sn=i(ke),oo=f(ke,"P",{"data-svelte-h":!0}),w(oo)!=="svelte-1j56vxu"&&(oo.textContent=Ra),Hn=i(ke),no=f(ke,"P",{"data-svelte-h":!0}),w(no)!=="svelte-1k6m2j2"&&(no.textContent=qa),ke.forEach(a),Pn=i(S),oe=f(S,"DIV",{class:!0});var lo=C(oe);_(gt.$$.fragment,lo),An=i(lo),ao=f(lo,"P",{"data-svelte-h":!0}),w(ao)!=="svelte-1mo4gpu"&&(ao.innerHTML=Ea),Dn=i(lo),_(be.$$.fragment,lo),lo.forEach(a),S.forEach(a),Oo=i(e),_t=f(e,"UL",{"data-svelte-h":!0}),w(_t)!=="svelte-n3ow4o"&&(_t.innerHTML=Na),Ko=i(e),_(yt.$$.fragment,e),en=i(e),se=f(e,"DIV",{class:!0});var dn=C(se);_(Tt.$$.fragment,dn),On=i(dn),Y=f(dn,"DIV",{class:!0});var xe=C(Y);_(bt.$$.fragment,xe),Kn=i(xe),so=f(xe,"P",{"data-svelte-h":!0}),w(so)!=="svelte-xnjod6"&&(so.innerHTML=Xa),ea=i(xe),_(Me.$$.fragment,xe),ta=i(xe),_(we.$$.fragment,xe),xe.forEach(a),dn.forEach(a),tn=i(e),Mt=f(e,"UL",{"data-svelte-h":!0}),w(Mt)!=="svelte-n3ow4o"&&(Mt.innerHTML=Qa),on=i(e),_(wt.$$.fragment,e),nn=i(e),P=f(e,"DIV",{class:!0});var io=C(P);_(vt.$$.fragment,io),oa=i(io),ve=f(io,"DIV",{class:!0});var cn=C(ve);_(Jt.$$.fragment,cn),na=i(cn),_(Je.$$.fragment,cn),cn.forEach(a),aa=i(io),$e=f(io,"DIV",{class:!0});var mn=C($e);_($t.$$.fragment,mn),sa=i(mn),ro=f(mn,"P",{"data-svelte-h":!0}),w(ro)!=="svelte-1dcynhg"&&(ro.textContent=Ya),mn.forEach(a),io.forEach(a),an=i(e),Ut=f(e,"UL",{"data-svelte-h":!0}),w(Ut)!=="svelte-n3ow4o"&&(Ut.innerHTML=Sa),sn=i(e),_(kt.$$.fragment,e),rn=i(e),uo=f(e,"P",{}),C(uo).forEach(a),this.h()},h(){j(t,"name","hf:doc:metadata"),j(t,"content",Us),Ka(c,"float","right"),j(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(St,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){u(document.head,t),d(e,p,s),d(e,o,s),d(e,r,s),y(m,e,s),d(e,n,s),d(e,c,s),d(e,U,s),d(e,x,s),d(e,k,s),d(e,ee,s),d(e,Ce,s),d(e,te,s),d(e,go,s),d(e,je,s),d(e,_o,s),y(le,e,s),d(e,yo,s),d(e,Le,s),d(e,To,s),y(ie,e,s),d(e,bo,s),y(Ie,e,s),d(e,Mo,s),y(ze,e,s),d(e,wo,s),d(e,Fe,s),d(e,vo,s),d(e,Ge,s),d(e,Jo,s),y(de,e,s),d(e,$o,s),y(Ze,e,s),d(e,Uo,s),d(e,We,s),d(e,ko,s),d(e,Ve,s),d(e,xo,s),d(e,Be,s),d(e,Co,s),y(ce,e,s),d(e,jo,s),y(Re,e,s),d(e,Lo,s),d(e,qe,s),d(e,Io,s),d(e,Ee,s),d(e,zo,s),y(Ne,e,s),d(e,Fo,s),y(Xe,e,s),d(e,Go,s),d(e,G,s),y(Qe,G,null),u(G,pn),u(G,zt),u(G,un),u(G,Ft),u(G,hn),u(G,Gt),u(G,fn),y(me,G,null),d(e,Zo,s),y(Ye,e,s),d(e,Wo,s),d(e,Z,s),y(Se,Z,null),u(Z,gn),u(Z,Zt),u(Z,_n),u(Z,Wt),u(Z,yn),u(Z,Vt),u(Z,Tn),u(Z,Bt),d(e,Vo,s),y(He,e,s),d(e,Bo,s),d(e,V,s),y(Pe,V,null),u(V,bn),u(V,Rt),u(V,Mn),u(V,qt),u(V,wn),u(V,Et),d(e,Ro,s),y(Ae,e,s),d(e,qo,s),d(e,B,s),y(De,B,null),u(B,vn),u(B,Nt),u(B,Jn),u(B,pe),y(Oe,pe,null),u(pe,$n),u(pe,Xt),u(B,Un),u(B,ue),y(Ke,ue,null),u(ue,kn),u(ue,Qt),d(e,Eo,s),y(et,e,s),d(e,No,s),d(e,R,s),y(tt,R,null),u(R,xn),u(R,Yt),u(R,Cn),u(R,St),y(ot,St,null),u(R,jn),u(R,he),y(nt,he,null),u(he,Ln),u(he,Ht),d(e,Xo,s),y(at,e,s),d(e,Qo,s),d(e,H,s),y(st,H,null),u(H,In),u(H,N),y(rt,N,null),u(N,zn),u(N,Pt),u(N,Fn),y(fe,N,null),u(N,Gn),y(ge,N,null),u(H,Zn),u(H,_e),y(lt,_e,null),u(_e,Wn),u(_e,At),d(e,Yo,s),d(e,it,s),d(e,So,s),y(dt,e,s),d(e,Ho,s),d(e,ae,s),y(ct,ae,null),u(ae,Vn),u(ae,X),y(mt,X,null),u(X,Bn),u(X,Dt),u(X,Rn),y(ye,X,null),u(X,qn),y(Te,X,null),d(e,Po,s),d(e,pt,s),d(e,Ao,s),y(ut,e,s),d(e,Do,s),d(e,z,s),y(ht,z,null),u(z,En),u(z,Ot),u(z,Nn),u(z,Kt),u(z,Xn),u(z,eo),u(z,Qn),u(z,Q),y(ft,Q,null),u(Q,Yn),u(Q,to),u(Q,Sn),u(Q,oo),u(Q,Hn),u(Q,no),u(z,Pn),u(z,oe),y(gt,oe,null),u(oe,An),u(oe,ao),u(oe,Dn),y(be,oe,null),d(e,Oo,s),d(e,_t,s),d(e,Ko,s),y(yt,e,s),d(e,en,s),d(e,se,s),y(Tt,se,null),u(se,On),u(se,Y),y(bt,Y,null),u(Y,Kn),u(Y,so),u(Y,ea),y(Me,Y,null),u(Y,ta),y(we,Y,null),d(e,tn,s),d(e,Mt,s),d(e,on,s),y(wt,e,s),d(e,nn,s),d(e,P,s),y(vt,P,null),u(P,oa),u(P,ve),y(Jt,ve,null),u(ve,na),y(Je,ve,null),u(P,aa),u(P,$e),y($t,$e,null),u($e,sa),u($e,ro),d(e,an,s),d(e,Ut,s),d(e,sn,s),y(kt,e,s),d(e,rn,s),d(e,uo,s),ln=!0},p(e,[s]){const q={};s&2&&(q.$$scope={dirty:s,ctx:e}),le.$set(q);const E={};s&2&&(E.$$scope={dirty:s,ctx:e}),ie.$set(E);const A={};s&2&&(A.$$scope={dirty:s,ctx:e}),de.$set(A);const D={};s&2&&(D.$$scope={dirty:s,ctx:e}),ce.$set(D);const xt={};s&2&&(xt.$$scope={dirty:s,ctx:e}),me.$set(xt);const Ct={};s&2&&(Ct.$$scope={dirty:s,ctx:e}),fe.$set(Ct);const O={};s&2&&(O.$$scope={dirty:s,ctx:e}),ge.$set(O);const ho={};s&2&&(ho.$$scope={dirty:s,ctx:e}),ye.$set(ho);const jt={};s&2&&(jt.$$scope={dirty:s,ctx:e}),Te.$set(jt);const re={};s&2&&(re.$$scope={dirty:s,ctx:e}),be.$set(re);const K={};s&2&&(K.$$scope={dirty:s,ctx:e}),Me.$set(K);const Lt={};s&2&&(Lt.$$scope={dirty:s,ctx:e}),we.$set(Lt);const It={};s&2&&(It.$$scope={dirty:s,ctx:e}),Je.$set(It)},i(e){ln||(T(m.$$.fragment,e),T(le.$$.fragment,e),T(ie.$$.fragment,e),T(Ie.$$.fragment,e),T(ze.$$.fragment,e),T(de.$$.fragment,e),T(Ze.$$.fragment,e),T(ce.$$.fragment,e),T(Re.$$.fragment,e),T(Ne.$$.fragment,e),T(Xe.$$.fragment,e),T(Qe.$$.fragment,e),T(me.$$.fragment,e),T(Ye.$$.fragment,e),T(Se.$$.fragment,e),T(He.$$.fragment,e),T(Pe.$$.fragment,e),T(Ae.$$.fragment,e),T(De.$$.fragment,e),T(Oe.$$.fragment,e),T(Ke.$$.fragment,e),T(et.$$.fragment,e),T(tt.$$.fragment,e),T(ot.$$.fragment,e),T(nt.$$.fragment,e),T(at.$$.fragment,e),T(st.$$.fragment,e),T(rt.$$.fragment,e),T(fe.$$.fragment,e),T(ge.$$.fragment,e),T(lt.$$.fragment,e),T(dt.$$.fragment,e),T(ct.$$.fragment,e),T(mt.$$.fragment,e),T(ye.$$.fragment,e),T(Te.$$.fragment,e),T(ut.$$.fragment,e),T(ht.$$.fragment,e),T(ft.$$.fragment,e),T(gt.$$.fragment,e),T(be.$$.fragment,e),T(yt.$$.fragment,e),T(Tt.$$.fragment,e),T(bt.$$.fragment,e),T(Me.$$.fragment,e),T(we.$$.fragment,e),T(wt.$$.fragment,e),T(vt.$$.fragment,e),T(Jt.$$.fragment,e),T(Je.$$.fragment,e),T($t.$$.fragment,e),T(kt.$$.fragment,e),ln=!0)},o(e){b(m.$$.fragment,e),b(le.$$.fragment,e),b(ie.$$.fragment,e),b(Ie.$$.fragment,e),b(ze.$$.fragment,e),b(de.$$.fragment,e),b(Ze.$$.fragment,e),b(ce.$$.fragment,e),b(Re.$$.fragment,e),b(Ne.$$.fragment,e),b(Xe.$$.fragment,e),b(Qe.$$.fragment,e),b(me.$$.fragment,e),b(Ye.$$.fragment,e),b(Se.$$.fragment,e),b(He.$$.fragment,e),b(Pe.$$.fragment,e),b(Ae.$$.fragment,e),b(De.$$.fragment,e),b(Oe.$$.fragment,e),b(Ke.$$.fragment,e),b(et.$$.fragment,e),b(tt.$$.fragment,e),b(ot.$$.fragment,e),b(nt.$$.fragment,e),b(at.$$.fragment,e),b(st.$$.fragment,e),b(rt.$$.fragment,e),b(fe.$$.fragment,e),b(ge.$$.fragment,e),b(lt.$$.fragment,e),b(dt.$$.fragment,e),b(ct.$$.fragment,e),b(mt.$$.fragment,e),b(ye.$$.fragment,e),b(Te.$$.fragment,e),b(ut.$$.fragment,e),b(ht.$$.fragment,e),b(ft.$$.fragment,e),b(gt.$$.fragment,e),b(be.$$.fragment,e),b(yt.$$.fragment,e),b(Tt.$$.fragment,e),b(bt.$$.fragment,e),b(Me.$$.fragment,e),b(we.$$.fragment,e),b(wt.$$.fragment,e),b(vt.$$.fragment,e),b(Jt.$$.fragment,e),b(Je.$$.fragment,e),b($t.$$.fragment,e),b(kt.$$.fragment,e),ln=!1},d(e){e&&(a(p),a(o),a(r),a(n),a(c),a(U),a(x),a(k),a(ee),a(Ce),a(te),a(go),a(je),a(_o),a(yo),a(Le),a(To),a(bo),a(Mo),a(wo),a(Fe),a(vo),a(Ge),a(Jo),a($o),a(Uo),a(We),a(ko),a(Ve),a(xo),a(Be),a(Co),a(jo),a(Lo),a(qe),a(Io),a(Ee),a(zo),a(Fo),a(Go),a(G),a(Zo),a(Wo),a(Z),a(Vo),a(Bo),a(V),a(Ro),a(qo),a(B),a(Eo),a(No),a(R),a(Xo),a(Qo),a(H),a(Yo),a(it),a(So),a(Ho),a(ae),a(Po),a(pt),a(Ao),a(Do),a(z),a(Oo),a(_t),a(Ko),a(en),a(se),a(tn),a(Mt),a(on),a(nn),a(P),a(an),a(Ut),a(sn),a(rn),a(uo)),a(t),M(m,e),M(le,e),M(ie,e),M(Ie,e),M(ze,e),M(de,e),M(Ze,e),M(ce,e),M(Re,e),M(Ne,e),M(Xe,e),M(Qe),M(me),M(Ye,e),M(Se),M(He,e),M(Pe),M(Ae,e),M(De),M(Oe),M(Ke),M(et,e),M(tt),M(ot),M(nt),M(at,e),M(st),M(rt),M(fe),M(ge),M(lt),M(dt,e),M(ct),M(mt),M(ye),M(Te),M(ut,e),M(ht),M(ft),M(gt),M(be),M(yt,e),M(Tt),M(bt),M(Me),M(we),M(wt,e),M(vt),M(Jt),M(Je),M($t),M(kt,e)}}}const Us='{"title":"Llama4","local":"llama4","sections":[{"title":"Efficiency; how to get the best out of llama 4","local":"efficiency-how-to-get-the-best-out-of-llama-4","sections":[{"title":"The Attention methods","local":"the-attention-methods","sections":[],"depth":3},{"title":"Quantization","local":"quantization","sections":[],"depth":3},{"title":"Offloading","local":"offloading","sections":[],"depth":3}],"depth":2},{"title":"Llama4Config","local":"transformers.Llama4Config","sections":[],"depth":2},{"title":"Llama4TextConfig","local":"transformers.Llama4TextConfig","sections":[],"depth":2},{"title":"Llama4VisionConfig","local":"transformers.Llama4VisionConfig","sections":[],"depth":2},{"title":"Llama4Processor","local":"transformers.Llama4Processor","sections":[],"depth":2},{"title":"Llama4ImageProcessorFast","local":"transformers.Llama4ImageProcessorFast","sections":[],"depth":2},{"title":"Llama4ForConditionalGeneration","local":"transformers.Llama4ForConditionalGeneration","sections":[],"depth":2},{"title":"Llama4ForCausalLM","local":"transformers.Llama4ForCausalLM","sections":[],"depth":2},{"title":"Llama4TextModel","local":"transformers.Llama4TextModel","sections":[],"depth":2},{"title":"Llama4ForCausalLM","local":"transformers.Llama4ForCausalLM","sections":[],"depth":2},{"title":"Llama4VisionModel","local":"transformers.Llama4VisionModel","sections":[],"depth":2}],"depth":1}';function ks(J){return Pa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ws extends Aa{constructor(t){super(),Da(this,t,ks,$s,Ha,{})}}export{Ws as component};
