import{s as eo,o as to,n as E}from"../chunks/scheduler.18a86fab.js";import{S as no,i as oo,g as p,s as a,r as h,A as so,h as m,f as s,c as r,j as B,u as f,x as u,k as U,y as i,a as c,v as g,d as _,t as b,w as M}from"../chunks/index.98837b22.js";import{T as dt}from"../chunks/Tip.77304350.js";import{D as Q}from"../chunks/Docstring.6758ea23.js";import{C as it}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as rt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as S}from"../chunks/Heading.7e7e0c5b.js";import{E as ao}from"../chunks/index.499f366c.js";function ro(v){let t,y="Example:",l,d,T;return d=new it({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1wdENvbmZpZyUyQyUyME1wdE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME1wdCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwTXB0Q29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyME1wdE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MptConfig, MptModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Mpt configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MptConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MptModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=p("p"),t.textContent=y,l=a(),h(d.$$.fragment)},l(n){t=m(n,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=y),l=r(n),f(d.$$.fragment,n)},m(n,w){c(n,t,w),c(n,l,w),g(d,n,w),T=!0},p:E,i(n){T||(_(d.$$.fragment,n),T=!0)},o(n){b(d.$$.fragment,n),T=!1},d(n){n&&(s(t),s(l)),M(d,n)}}}function io(v){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=y},l(l){t=m(l,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(l,d){c(l,t,d)},p:E,d(l){l&&s(t)}}}function lo(v){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=y},l(l){t=m(l,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(l,d){c(l,t,d)},p:E,d(l){l&&s(t)}}}function co(v){let t,y="Example:",l,d,T;return d=new it({props:{code:"",highlighted:"",wrap:!1}}),{c(){t=p("p"),t.textContent=y,l=a(),h(d.$$.fragment)},l(n){t=m(n,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=y),l=r(n),f(d.$$.fragment,n)},m(n,w){c(n,t,w),c(n,l,w),g(d,n,w),T=!0},p:E,i(n){T||(_(d.$$.fragment,n),T=!0)},o(n){b(d.$$.fragment,n),T=!1},d(n){n&&(s(t),s(l)),M(d,n)}}}function po(v){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=y},l(l){t=m(l,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(l,d){c(l,t,d)},p:E,d(l){l&&s(t)}}}function mo(v){let t,y="Example of single-label classification:",l,d,T;return d=new it({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME1wdEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtb3NhaWNtbCUyRm1wdC03YiUyMiklMEFtb2RlbCUyMCUzRCUyME1wdEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1vc2FpY21sJTJGbXB0LTdiJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9jbGFzc19pZCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoKS5pdGVtKCklMEFtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfY2xhc3NfaWQlNUQlMEElMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBNcHRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtb3NhaWNtbCUyRm1wdC03YiUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcyUwQXJvdW5kKGxvc3MuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MptForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MptForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.id2label[predicted_class_id]
...

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MptForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){t=p("p"),t.textContent=y,l=a(),h(d.$$.fragment)},l(n){t=m(n,"P",{"data-svelte-h":!0}),u(t)!=="svelte-ykxpe4"&&(t.textContent=y),l=r(n),f(d.$$.fragment,n)},m(n,w){c(n,t,w),c(n,l,w),g(d,n,w),T=!0},p:E,i(n){T||(_(d.$$.fragment,n),T=!0)},o(n){b(d.$$.fragment,n),T=!1},d(n){n&&(s(t),s(l)),M(d,n)}}}function uo(v){let t,y="Example of multi-label classification:",l,d,T;return d=new it({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME1wdEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtb3NhaWNtbCUyRm1wdC03YiUyMiklMEFtb2RlbCUyMCUzRCUyME1wdEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1vc2FpY21sJTJGbXB0LTdiJTIyJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyYW5nZSgwJTJDJTIwbG9naXRzLnNoYXBlJTVCLTElNUQpJTVCdG9yY2guc2lnbW9pZChsb2dpdHMpLnNxdWVlemUoZGltJTNEMCklMjAlM0UlMjAwLjUlNUQlMEElMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBNcHRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtb3NhaWNtbCUyRm1wdC03YiUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MptForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MptForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MptForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=p("p"),t.textContent=y,l=a(),h(d.$$.fragment)},l(n){t=m(n,"P",{"data-svelte-h":!0}),u(t)!=="svelte-1l8e32d"&&(t.textContent=y),l=r(n),f(d.$$.fragment,n)},m(n,w){c(n,t,w),c(n,l,w),g(d,n,w),T=!0},p:E,i(n){T||(_(d.$$.fragment,n),T=!0)},o(n){b(d.$$.fragment,n),T=!1},d(n){n&&(s(t),s(l)),M(d,n)}}}function ho(v){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=y},l(l){t=m(l,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(l,d){c(l,t,d)},p:E,d(l){l&&s(t)}}}function fo(v){let t,y="Example:",l,d,T;return d=new it({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNcHRGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtb3NhaWNtbCUyRm1wdC03YiUyMiklMEFtb2RlbCUyMCUzRCUyME1wdEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1vc2FpY21sJTJGbXB0LTdiJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJIdWdnaW5nRmFjZSUyMGlzJTIwYSUyMGNvbXBhbnklMjBiYXNlZCUyMGluJTIwUGFyaXMlMjBhbmQlMjBOZXclMjBZb3JrJTIyJTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpJTBBJTBBJTIzJTIwTm90ZSUyMHRoYXQlMjB0b2tlbnMlMjBhcmUlMjBjbGFzc2lmaWVkJTIwcmF0aGVyJTIwdGhlbiUyMGlucHV0JTIwd29yZHMlMjB3aGljaCUyMG1lYW5zJTIwdGhhdCUwQSUyMyUyMHRoZXJlJTIwbWlnaHQlMjBiZSUyMG1vcmUlMjBwcmVkaWN0ZWQlMjB0b2tlbiUyMGNsYXNzZXMlMjB0aGFuJTIwd29yZHMuJTBBJTIzJTIwTXVsdGlwbGUlMjB0b2tlbiUyMGNsYXNzZXMlMjBtaWdodCUyMGFjY291bnQlMjBmb3IlMjB0aGUlMjBzYW1lJTIwd29yZCUwQXByZWRpY3RlZF90b2tlbnNfY2xhc3NlcyUyMCUzRCUyMCU1Qm1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnQuaXRlbSgpJTVEJTIwZm9yJTIwdCUyMGluJTIwcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyU1QjAlNUQlNUQlMEFwcmVkaWN0ZWRfdG9rZW5zX2NsYXNzZXMlMEElMEFsYWJlbHMlMjAlM0QlMjBwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTBBbG9zcyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKS5sb3NzJTBBcm91bmQobG9zcy5pdGVtKCklMkMlMjAyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MptForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MptForTokenClassification.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes
...

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){t=p("p"),t.textContent=y,l=a(),h(d.$$.fragment)},l(n){t=m(n,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=y),l=r(n),f(d.$$.fragment,n)},m(n,w){c(n,t,w),c(n,l,w),g(d,n,w),T=!0},p:E,i(n){T||(_(d.$$.fragment,n),T=!0)},o(n){b(d.$$.fragment,n),T=!1},d(n){n&&(s(t),s(l)),M(d,n)}}}function go(v){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=y},l(l){t=m(l,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(l,d){c(l,t,d)},p:E,d(l){l&&s(t)}}}function _o(v){let t,y="Example:",l,d,T;return d=new it({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNcHRGb3JRdWVzdGlvbkFuc3dlcmluZyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybW9zYWljbWwlMkZtcHQtN2IlMjIpJTBBbW9kZWwlMjAlM0QlMjBNcHRGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIybW9zYWljbWwlMkZtcHQtN2IlMjIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWFuc3dlcl9zdGFydF9pbmRleCUyMCUzRCUyMG91dHB1dHMuc3RhcnRfbG9naXRzLmFyZ21heCgpJTBBYW5zd2VyX2VuZF9pbmRleCUyMCUzRCUyMG91dHB1dHMuZW5kX2xvZ2l0cy5hcmdtYXgoKSUwQSUwQXByZWRpY3RfYW5zd2VyX3Rva2VucyUyMCUzRCUyMGlucHV0cy5pbnB1dF9pZHMlNUIwJTJDJTIwYW5zd2VyX3N0YXJ0X2luZGV4JTIwJTNBJTIwYW5zd2VyX2VuZF9pbmRleCUyMCUyQiUyMDElNUQlMEF0b2tlbml6ZXIuZGVjb2RlKHByZWRpY3RfYW5zd2VyX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQSUwQSUyMyUyMHRhcmdldCUyMGlzJTIwJTIybmljZSUyMHB1cHBldCUyMiUwQXRhcmdldF9zdGFydF9pbmRleCUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxNCU1RCklMEF0YXJnZXRfZW5kX2luZGV4JTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjE1JTVEKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHN0YXJ0X3Bvc2l0aW9ucyUzRHRhcmdldF9zdGFydF9pbmRleCUyQyUyMGVuZF9wb3NpdGlvbnMlM0R0YXJnZXRfZW5kX2luZGV4KSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFyb3VuZChsb3NzLml0ZW0oKSUyQyUyMDIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MptForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MptForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;mosaicml/mpt-7b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = outputs.start_logits.argmax()
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = outputs.end_logits.argmax()

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = inputs.input_ids[<span class="hljs-number">0</span>, answer_start_index : answer_end_index + <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(predict_answer_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
...

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># target is &quot;nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_start_index = torch.tensor([<span class="hljs-number">14</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>target_end_index = torch.tensor([<span class="hljs-number">15</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=target_start_index, end_positions=target_end_index)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){t=p("p"),t.textContent=y,l=a(),h(d.$$.fragment)},l(n){t=m(n,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=y),l=r(n),f(d.$$.fragment,n)},m(n,w){c(n,t,w),c(n,l,w),g(d,n,w),T=!0},p:E,i(n){T||(_(d.$$.fragment,n),T=!0)},o(n){b(d.$$.fragment,n),T=!1},d(n){n&&(s(t),s(l)),M(d,n)}}}function bo(v){let t,y,l,d,T,n,w,wn='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',ct,le,pt,de,vn='The MPT model was proposed by the <a href="https://www.mosaicml.com/" rel="nofollow">MosaicML</a> team and released with multiple sizes and finetuned variants. The MPT models are a series of open source and commercially usable LLMs pre-trained on 1T tokens.',mt,ce,kn="MPT models are GPT-style decoder-only transformers with several improvements: performance-optimized layer implementations, architecture changes that provide greater training stability, and the elimination of context length limits by replacing positional embeddings with ALiBi.",ut,pe,$n="<li>MPT base: MPT base pre-trained models on next token prediction</li> <li>MPT instruct: MPT base models fine-tuned on instruction based tasks</li> <li>MPT storywriter: MPT base models fine-tuned for 2500 steps on 65k-token excerpts of fiction books contained in the books3 corpus, this enables the model to handle very long sequences</li>",ht,me,Cn='The original code is available at the  <a href="https://github.com/mosaicml/llm-foundry/tree/main" rel="nofollow"><code>llm-foundry</code></a> repository.',ft,ue,xn='Read more about it <a href="https://www.mosaicml.com/blog/mpt-7b" rel="nofollow">in the release blogpost</a>',gt,he,_t,fe,jn='<li>Learn more about some techniques behind training of the model <a href="https://github.com/mosaicml/llm-foundry/blob/main/TUTORIAL.md#faqs" rel="nofollow">in this section of llm-foundry repository</a></li> <li>If you want to use the advanced version of the model (triton kernels, direct flash attention integration), you can still use the original model implementation by adding <code>trust_remote_code=True</code> when calling <code>from_pretrained</code>.</li>',bt,ge,Mt,_e,Jn='<li><a href="https://colab.research.google.com/drive/1HCpQkLL7UXW8xJUJJ29X7QAeNJKO0frZ?usp=sharing" rel="nofollow">Fine-tuning Notebook</a> on how to fine-tune MPT-7B on a free Google Colab instance to turn the model into a Chatbot.</li>',yt,be,Tt,F,Me,It,Ze,zn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptModel">MptModel</a>. It is used to instantiate a Mpt model
according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to the Mpt-7b architecture
<a href="https://huggingface.co/mosaicml/mpt-7b" rel="nofollow">mosaicml/mpt-7b</a>.`,Zt,qe,Un=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,qt,O,wt,ye,vt,C,Te,Bt,Be,Fn="The bare Mpt Model outputting raw hidden-states without any specific head on top.",Ht,He,Wn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Lt,Le,Nn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Rt,A,we,Gt,Re,In='The <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptModel">MptModel</a> forward method, overrides the <code>__call__</code> special method.',Xt,D,kt,ve,$t,x,ke,Vt,Ge,Zn=`The MPT Model transformer with a language modeling head on top (linear layer with weights tied to the input
embeddings).`,Pt,Xe,qn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Qt,Ve,Bn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Et,H,$e,At,Pe,Hn='The <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptForCausalLM">MptForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',St,K,Yt,ee,Ct,Ce,xt,k,xe,Ot,Qe,Ln="The MPT Model transformer with a sequence classification head on top (linear layer).",Dt,Ee,Rn=`<a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptForSequenceClassification">MptForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-1) do.`,Kt,Ae,Gn=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,en,Se,Xn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,tn,Ye,Vn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,nn,z,je,on,Oe,Pn='The <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptForSequenceClassification">MptForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',sn,te,an,ne,rn,oe,jt,Je,Jt,j,ze,ln,De,Qn=`The Mpt transformer with a token classification head on top (a linear layer on top of the hidden-states
output) e.g. for Named-Entity-Recognition (NER) tasks.`,dn,Ke,En=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,cn,et,An=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,pn,L,Ue,mn,tt,Sn='The <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptForTokenClassification">MptForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',un,se,hn,ae,zt,Fe,Ut,J,We,fn,nt,Yn=`The Mpt transformer with a span classification head on top for extractive question-answering tasks like
SQuAD (a linear layer on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,gn,ot,On=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,_n,st,Dn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,bn,R,Ne,Mn,at,Kn='The <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptForQuestionAnswering">MptForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',yn,re,Tn,ie,Ft,Ie,Wt,lt,Nt;return T=new S({props:{title:"MPT",local:"mpt",headingTag:"h1"}}),le=new S({props:{title:"Overview",local:"overview",headingTag:"h2"}}),he=new S({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ge=new S({props:{title:"Resources",local:"resources",headingTag:"h2"}}),be=new S({props:{title:"MptConfig",local:"transformers.MptConfig",headingTag:"h2"}}),Me=new Q({props:{name:"class transformers.MptConfig",anchor:"transformers.MptConfig",parameters:[{name:"d_model",val:": int = 2048"},{name:"n_heads",val:": int = 16"},{name:"n_layers",val:": int = 24"},{name:"expansion_ratio",val:": int = 4"},{name:"max_seq_len",val:": int = 2048"},{name:"vocab_size",val:": int = 50368"},{name:"resid_pdrop",val:": float = 0.0"},{name:"layer_norm_epsilon",val:": float = 1e-05"},{name:"emb_pdrop",val:": float = 0.0"},{name:"learned_pos_emb",val:": bool = True"},{name:"attn_config",val:": MptAttentionConfig = None"},{name:"init_device",val:": str = 'cpu'"},{name:"logit_scale",val:": typing.Union[float, str, NoneType] = None"},{name:"no_bias",val:": bool = True"},{name:"verbose",val:": int = 0"},{name:"embedding_fraction",val:": float = 1.0"},{name:"norm_type",val:": str = 'low_precision_layernorm'"},{name:"use_cache",val:": bool = False"},{name:"initializer_range",val:" = 0.02"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MptConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimensionality of the embeddings and hidden states.`,name:"d_model"},{anchor:"transformers.MptConfig.n_heads",description:`<strong>n_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"n_heads"},{anchor:"transformers.MptConfig.n_layers",description:`<strong>n_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"n_layers"},{anchor:"transformers.MptConfig.expansion_ratio",description:`<strong>expansion_ratio</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The ratio of the up/down scale in the MLP.`,name:"expansion_ratio"},{anchor:"transformers.MptConfig.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length of the model.`,name:"max_seq_len"},{anchor:"transformers.MptConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 50368) &#x2014;
Vocabulary size of the Mpt model. Defines the maximum number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptModel">MptModel</a>. Check <a href="https://huggingface.co/bigscience/mpt/discussions/120#633d28389addb8530b406c2a" rel="nofollow">this
discussion</a> on how the
<code>vocab_size</code> has been defined.`,name:"vocab_size"},{anchor:"transformers.MptConfig.resid_pdrop",description:`<strong>resid_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability applied to the attention output before combining with residual.`,name:"resid_pdrop"},{anchor:"transformers.MptConfig.layer_norm_epsilon",description:`<strong>layer_norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon to use in the layer normalization layers.`,name:"layer_norm_epsilon"},{anchor:"transformers.MptConfig.emb_pdrop",description:`<strong>emb_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for the embedding layer.`,name:"emb_pdrop"},{anchor:"transformers.MptConfig.learned_pos_emb",description:`<strong>learned_pos_emb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use learned positional embeddings.`,name:"learned_pos_emb"},{anchor:"transformers.MptConfig.attn_config",description:`<strong>attn_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A dictionary used to configure the model&#x2019;s attention module.`,name:"attn_config"},{anchor:"transformers.MptConfig.init_device",description:`<strong>init_device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to use for parameter initialization. Defined for backward compatibility`,name:"init_device"},{anchor:"transformers.MptConfig.logit_scale",description:`<strong>logit_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If not None, scale the logits by this value.`,name:"logit_scale"},{anchor:"transformers.MptConfig.no_bias",description:`<strong>no_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in all linear layers.`,name:"no_bias"},{anchor:"transformers.MptConfig.verbose",description:`<strong>verbose</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The verbosity level to use for logging. Used in the previous versions of MPT models for logging. This
argument is deprecated.`,name:"verbose"},{anchor:"transformers.MptConfig.embedding_fraction",description:`<strong>embedding_fraction</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The fraction to scale the gradients of the embedding layer by.`,name:"embedding_fraction"},{anchor:"transformers.MptConfig.norm_type",description:`<strong>norm_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;low_precision_layernorm&quot;</code>) &#x2014;
Type of layer norm to use. All MPT models uses the same layer norm implementation. Defined for backward
compatibility.`,name:"norm_type"},{anchor:"transformers.MptConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.MptConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/configuration_mpt.py#L103"}}),O=new rt({props:{anchor:"transformers.MptConfig.example",$$slots:{default:[ro]},$$scope:{ctx:v}}}),ye=new S({props:{title:"MptModel",local:"transformers.MptModel",headingTag:"h2"}}),Te=new Q({props:{name:"class transformers.MptModel",anchor:"transformers.MptModel",parameters:[{name:"config",val:": MptConfig"}],parametersDescription:[{anchor:"transformers.MptModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig">MptConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L275"}}),we=new Q({props:{name:"forward",anchor:"transformers.MptModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor, torch.Tensor], ...]] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MptModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MptModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor, torch.Tensor, ...]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MptModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MptModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MptModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MptModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MptModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MptModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L308",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig"
>MptConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new dt({props:{$$slots:{default:[io]},$$scope:{ctx:v}}}),ve=new S({props:{title:"MptForCausalLM",local:"transformers.MptForCausalLM",headingTag:"h2"}}),ke=new Q({props:{name:"class transformers.MptForCausalLM",anchor:"transformers.MptForCausalLM",parameters:[{name:"config",val:": MptConfig"}],parametersDescription:[{anchor:"transformers.MptForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig">MptConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L435"}}),$e=new Q({props:{name:"forward",anchor:"transformers.MptForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor, torch.Tensor], ...]] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MptForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MptForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor, torch.Tensor, ...]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MptForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MptForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MptForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.MptForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MptForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MptForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MptForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L458",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig"
>MptConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),K=new dt({props:{$$slots:{default:[lo]},$$scope:{ctx:v}}}),ee=new rt({props:{anchor:"transformers.MptForCausalLM.forward.example",$$slots:{default:[co]},$$scope:{ctx:v}}}),Ce=new S({props:{title:"MptForSequenceClassification",local:"transformers.MptForSequenceClassification",headingTag:"h2"}}),xe=new Q({props:{name:"class transformers.MptForSequenceClassification",anchor:"transformers.MptForSequenceClassification",parameters:[{name:"config",val:": MptConfig"}],parametersDescription:[{anchor:"transformers.MptForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig">MptConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L553"}}),je=new Q({props:{name:"forward",anchor:"transformers.MptForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor, torch.Tensor], ...]] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MptForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MptForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor, torch.Tensor, ...]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MptForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MptForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MptForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.MptForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MptForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MptForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MptForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L577",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig"
>MptConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),te=new dt({props:{$$slots:{default:[po]},$$scope:{ctx:v}}}),ne=new rt({props:{anchor:"transformers.MptForSequenceClassification.forward.example",$$slots:{default:[mo]},$$scope:{ctx:v}}}),oe=new rt({props:{anchor:"transformers.MptForSequenceClassification.forward.example-2",$$slots:{default:[uo]},$$scope:{ctx:v}}}),Je=new S({props:{title:"MptForTokenClassification",local:"transformers.MptForTokenClassification",headingTag:"h2"}}),ze=new Q({props:{name:"class transformers.MptForTokenClassification",anchor:"transformers.MptForTokenClassification",parameters:[{name:"config",val:": MptConfig"}],parametersDescription:[{anchor:"transformers.MptForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig">MptConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L681"}}),Ue=new Q({props:{name:"forward",anchor:"transformers.MptForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor, torch.Tensor], ...]] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**deprecated_arguments",val:""}],parametersDescription:[{anchor:"transformers.MptForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MptForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor, torch.Tensor, ...]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MptForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MptForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MptForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.MptForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MptForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MptForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MptForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L700",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig"
>MptConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),se=new dt({props:{$$slots:{default:[ho]},$$scope:{ctx:v}}}),ae=new rt({props:{anchor:"transformers.MptForTokenClassification.forward.example",$$slots:{default:[fo]},$$scope:{ctx:v}}}),Fe=new S({props:{title:"MptForQuestionAnswering",local:"transformers.MptForQuestionAnswering",headingTag:"h2"}}),We=new Q({props:{name:"class transformers.MptForQuestionAnswering",anchor:"transformers.MptForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MptForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mpt#transformers.MptForQuestionAnswering">MptForQuestionAnswering</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L770"}}),Ne=new Q({props:{name:"forward",anchor:"transformers.MptForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"start_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"end_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MptForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MptForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MptForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MptForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.MptForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"},{anchor:"transformers.MptForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MptForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MptForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mpt/modeling_mpt.py#L780",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mpt#transformers.MptConfig"
>MptConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),re=new dt({props:{$$slots:{default:[go]},$$scope:{ctx:v}}}),ie=new rt({props:{anchor:"transformers.MptForQuestionAnswering.forward.example",$$slots:{default:[_o]},$$scope:{ctx:v}}}),Ie=new ao({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/mpt.md"}}),{c(){t=p("meta"),y=a(),l=p("p"),d=a(),h(T.$$.fragment),n=a(),w=p("div"),w.innerHTML=wn,ct=a(),h(le.$$.fragment),pt=a(),de=p("p"),de.innerHTML=vn,mt=a(),ce=p("p"),ce.textContent=kn,ut=a(),pe=p("ul"),pe.innerHTML=$n,ht=a(),me=p("p"),me.innerHTML=Cn,ft=a(),ue=p("p"),ue.innerHTML=xn,gt=a(),h(he.$$.fragment),_t=a(),fe=p("ul"),fe.innerHTML=jn,bt=a(),h(ge.$$.fragment),Mt=a(),_e=p("ul"),_e.innerHTML=Jn,yt=a(),h(be.$$.fragment),Tt=a(),F=p("div"),h(Me.$$.fragment),It=a(),Ze=p("p"),Ze.innerHTML=zn,Zt=a(),qe=p("p"),qe.innerHTML=Un,qt=a(),h(O.$$.fragment),wt=a(),h(ye.$$.fragment),vt=a(),C=p("div"),h(Te.$$.fragment),Bt=a(),Be=p("p"),Be.textContent=Fn,Ht=a(),He=p("p"),He.innerHTML=Wn,Lt=a(),Le=p("p"),Le.innerHTML=Nn,Rt=a(),A=p("div"),h(we.$$.fragment),Gt=a(),Re=p("p"),Re.innerHTML=In,Xt=a(),h(D.$$.fragment),kt=a(),h(ve.$$.fragment),$t=a(),x=p("div"),h(ke.$$.fragment),Vt=a(),Ge=p("p"),Ge.textContent=Zn,Pt=a(),Xe=p("p"),Xe.innerHTML=qn,Qt=a(),Ve=p("p"),Ve.innerHTML=Bn,Et=a(),H=p("div"),h($e.$$.fragment),At=a(),Pe=p("p"),Pe.innerHTML=Hn,St=a(),h(K.$$.fragment),Yt=a(),h(ee.$$.fragment),Ct=a(),h(Ce.$$.fragment),xt=a(),k=p("div"),h(xe.$$.fragment),Ot=a(),Qe=p("p"),Qe.textContent=Ln,Dt=a(),Ee=p("p"),Ee.innerHTML=Rn,Kt=a(),Ae=p("p"),Ae.innerHTML=Gn,en=a(),Se=p("p"),Se.innerHTML=Xn,tn=a(),Ye=p("p"),Ye.innerHTML=Vn,nn=a(),z=p("div"),h(je.$$.fragment),on=a(),Oe=p("p"),Oe.innerHTML=Pn,sn=a(),h(te.$$.fragment),an=a(),h(ne.$$.fragment),rn=a(),h(oe.$$.fragment),jt=a(),h(Je.$$.fragment),Jt=a(),j=p("div"),h(ze.$$.fragment),ln=a(),De=p("p"),De.textContent=Qn,dn=a(),Ke=p("p"),Ke.innerHTML=En,cn=a(),et=p("p"),et.innerHTML=An,pn=a(),L=p("div"),h(Ue.$$.fragment),mn=a(),tt=p("p"),tt.innerHTML=Sn,un=a(),h(se.$$.fragment),hn=a(),h(ae.$$.fragment),zt=a(),h(Fe.$$.fragment),Ut=a(),J=p("div"),h(We.$$.fragment),fn=a(),nt=p("p"),nt.innerHTML=Yn,gn=a(),ot=p("p"),ot.innerHTML=On,_n=a(),st=p("p"),st.innerHTML=Dn,bn=a(),R=p("div"),h(Ne.$$.fragment),Mn=a(),at=p("p"),at.innerHTML=Kn,yn=a(),h(re.$$.fragment),Tn=a(),h(ie.$$.fragment),Ft=a(),h(Ie.$$.fragment),Wt=a(),lt=p("p"),this.h()},l(e){const o=so("svelte-u9bgzb",document.head);t=m(o,"META",{name:!0,content:!0}),o.forEach(s),y=r(e),l=m(e,"P",{}),B(l).forEach(s),d=r(e),f(T.$$.fragment,e),n=r(e),w=m(e,"DIV",{class:!0,"data-svelte-h":!0}),u(w)!=="svelte-13t8s2t"&&(w.innerHTML=wn),ct=r(e),f(le.$$.fragment,e),pt=r(e),de=m(e,"P",{"data-svelte-h":!0}),u(de)!=="svelte-sjs9ru"&&(de.innerHTML=vn),mt=r(e),ce=m(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-1ipzlev"&&(ce.textContent=kn),ut=r(e),pe=m(e,"UL",{"data-svelte-h":!0}),u(pe)!=="svelte-re1aby"&&(pe.innerHTML=$n),ht=r(e),me=m(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-si6x57"&&(me.innerHTML=Cn),ft=r(e),ue=m(e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-124zaeu"&&(ue.innerHTML=xn),gt=r(e),f(he.$$.fragment,e),_t=r(e),fe=m(e,"UL",{"data-svelte-h":!0}),u(fe)!=="svelte-u5wuo0"&&(fe.innerHTML=jn),bt=r(e),f(ge.$$.fragment,e),Mt=r(e),_e=m(e,"UL",{"data-svelte-h":!0}),u(_e)!=="svelte-1bd79e6"&&(_e.innerHTML=Jn),yt=r(e),f(be.$$.fragment,e),Tt=r(e),F=m(e,"DIV",{class:!0});var G=B(F);f(Me.$$.fragment,G),It=r(G),Ze=m(G,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-1i1d0io"&&(Ze.innerHTML=zn),Zt=r(G),qe=m(G,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-o55m63"&&(qe.innerHTML=Un),qt=r(G),f(O.$$.fragment,G),G.forEach(s),wt=r(e),f(ye.$$.fragment,e),vt=r(e),C=m(e,"DIV",{class:!0});var W=B(C);f(Te.$$.fragment,W),Bt=r(W),Be=m(W,"P",{"data-svelte-h":!0}),u(Be)!=="svelte-xk80bb"&&(Be.textContent=Fn),Ht=r(W),He=m(W,"P",{"data-svelte-h":!0}),u(He)!=="svelte-6pahdo"&&(He.innerHTML=Wn),Lt=r(W),Le=m(W,"P",{"data-svelte-h":!0}),u(Le)!=="svelte-hswkmf"&&(Le.innerHTML=Nn),Rt=r(W),A=m(W,"DIV",{class:!0});var Y=B(A);f(we.$$.fragment,Y),Gt=r(Y),Re=m(Y,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-10g2gzo"&&(Re.innerHTML=In),Xt=r(Y),f(D.$$.fragment,Y),Y.forEach(s),W.forEach(s),kt=r(e),f(ve.$$.fragment,e),$t=r(e),x=m(e,"DIV",{class:!0});var N=B(x);f(ke.$$.fragment,N),Vt=r(N),Ge=m(N,"P",{"data-svelte-h":!0}),u(Ge)!=="svelte-fj8rfo"&&(Ge.textContent=Zn),Pt=r(N),Xe=m(N,"P",{"data-svelte-h":!0}),u(Xe)!=="svelte-6pahdo"&&(Xe.innerHTML=qn),Qt=r(N),Ve=m(N,"P",{"data-svelte-h":!0}),u(Ve)!=="svelte-hswkmf"&&(Ve.innerHTML=Bn),Et=r(N),H=m(N,"DIV",{class:!0});var X=B(H);f($e.$$.fragment,X),At=r(X),Pe=m(X,"P",{"data-svelte-h":!0}),u(Pe)!=="svelte-13tbzng"&&(Pe.innerHTML=Hn),St=r(X),f(K.$$.fragment,X),Yt=r(X),f(ee.$$.fragment,X),X.forEach(s),N.forEach(s),Ct=r(e),f(Ce.$$.fragment,e),xt=r(e),k=m(e,"DIV",{class:!0});var $=B(k);f(xe.$$.fragment,$),Ot=r($),Qe=m($,"P",{"data-svelte-h":!0}),u(Qe)!=="svelte-15wt48j"&&(Qe.textContent=Ln),Dt=r($),Ee=m($,"P",{"data-svelte-h":!0}),u(Ee)!=="svelte-q1992o"&&(Ee.innerHTML=Rn),Kt=r($),Ae=m($,"P",{"data-svelte-h":!0}),u(Ae)!=="svelte-10ugs3m"&&(Ae.innerHTML=Gn),en=r($),Se=m($,"P",{"data-svelte-h":!0}),u(Se)!=="svelte-6pahdo"&&(Se.innerHTML=Xn),tn=r($),Ye=m($,"P",{"data-svelte-h":!0}),u(Ye)!=="svelte-hswkmf"&&(Ye.innerHTML=Vn),nn=r($),z=m($,"DIV",{class:!0});var I=B(z);f(je.$$.fragment,I),on=r(I),Oe=m(I,"P",{"data-svelte-h":!0}),u(Oe)!=="svelte-i17e5a"&&(Oe.innerHTML=Pn),sn=r(I),f(te.$$.fragment,I),an=r(I),f(ne.$$.fragment,I),rn=r(I),f(oe.$$.fragment,I),I.forEach(s),$.forEach(s),jt=r(e),f(Je.$$.fragment,e),Jt=r(e),j=m(e,"DIV",{class:!0});var Z=B(j);f(ze.$$.fragment,Z),ln=r(Z),De=m(Z,"P",{"data-svelte-h":!0}),u(De)!=="svelte-3r6btx"&&(De.textContent=Qn),dn=r(Z),Ke=m(Z,"P",{"data-svelte-h":!0}),u(Ke)!=="svelte-6pahdo"&&(Ke.innerHTML=En),cn=r(Z),et=m(Z,"P",{"data-svelte-h":!0}),u(et)!=="svelte-hswkmf"&&(et.innerHTML=An),pn=r(Z),L=m(Z,"DIV",{class:!0});var V=B(L);f(Ue.$$.fragment,V),mn=r(V),tt=m(V,"P",{"data-svelte-h":!0}),u(tt)!=="svelte-1fxeom4"&&(tt.innerHTML=Sn),un=r(V),f(se.$$.fragment,V),hn=r(V),f(ae.$$.fragment,V),V.forEach(s),Z.forEach(s),zt=r(e),f(Fe.$$.fragment,e),Ut=r(e),J=m(e,"DIV",{class:!0});var q=B(J);f(We.$$.fragment,q),fn=r(q),nt=m(q,"P",{"data-svelte-h":!0}),u(nt)!=="svelte-o6aq8i"&&(nt.innerHTML=Yn),gn=r(q),ot=m(q,"P",{"data-svelte-h":!0}),u(ot)!=="svelte-6pahdo"&&(ot.innerHTML=On),_n=r(q),st=m(q,"P",{"data-svelte-h":!0}),u(st)!=="svelte-hswkmf"&&(st.innerHTML=Dn),bn=r(q),R=m(q,"DIV",{class:!0});var P=B(R);f(Ne.$$.fragment,P),Mn=r(P),at=m(P,"P",{"data-svelte-h":!0}),u(at)!=="svelte-1pr97os"&&(at.innerHTML=Kn),yn=r(P),f(re.$$.fragment,P),Tn=r(P),f(ie.$$.fragment,P),P.forEach(s),q.forEach(s),Ft=r(e),f(Ie.$$.fragment,e),Wt=r(e),lt=m(e,"P",{}),B(lt).forEach(s),this.h()},h(){U(t,"name","hf:doc:metadata"),U(t,"content",Mo),U(w,"class","flex flex-wrap space-x-1"),U(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){i(document.head,t),c(e,y,o),c(e,l,o),c(e,d,o),g(T,e,o),c(e,n,o),c(e,w,o),c(e,ct,o),g(le,e,o),c(e,pt,o),c(e,de,o),c(e,mt,o),c(e,ce,o),c(e,ut,o),c(e,pe,o),c(e,ht,o),c(e,me,o),c(e,ft,o),c(e,ue,o),c(e,gt,o),g(he,e,o),c(e,_t,o),c(e,fe,o),c(e,bt,o),g(ge,e,o),c(e,Mt,o),c(e,_e,o),c(e,yt,o),g(be,e,o),c(e,Tt,o),c(e,F,o),g(Me,F,null),i(F,It),i(F,Ze),i(F,Zt),i(F,qe),i(F,qt),g(O,F,null),c(e,wt,o),g(ye,e,o),c(e,vt,o),c(e,C,o),g(Te,C,null),i(C,Bt),i(C,Be),i(C,Ht),i(C,He),i(C,Lt),i(C,Le),i(C,Rt),i(C,A),g(we,A,null),i(A,Gt),i(A,Re),i(A,Xt),g(D,A,null),c(e,kt,o),g(ve,e,o),c(e,$t,o),c(e,x,o),g(ke,x,null),i(x,Vt),i(x,Ge),i(x,Pt),i(x,Xe),i(x,Qt),i(x,Ve),i(x,Et),i(x,H),g($e,H,null),i(H,At),i(H,Pe),i(H,St),g(K,H,null),i(H,Yt),g(ee,H,null),c(e,Ct,o),g(Ce,e,o),c(e,xt,o),c(e,k,o),g(xe,k,null),i(k,Ot),i(k,Qe),i(k,Dt),i(k,Ee),i(k,Kt),i(k,Ae),i(k,en),i(k,Se),i(k,tn),i(k,Ye),i(k,nn),i(k,z),g(je,z,null),i(z,on),i(z,Oe),i(z,sn),g(te,z,null),i(z,an),g(ne,z,null),i(z,rn),g(oe,z,null),c(e,jt,o),g(Je,e,o),c(e,Jt,o),c(e,j,o),g(ze,j,null),i(j,ln),i(j,De),i(j,dn),i(j,Ke),i(j,cn),i(j,et),i(j,pn),i(j,L),g(Ue,L,null),i(L,mn),i(L,tt),i(L,un),g(se,L,null),i(L,hn),g(ae,L,null),c(e,zt,o),g(Fe,e,o),c(e,Ut,o),c(e,J,o),g(We,J,null),i(J,fn),i(J,nt),i(J,gn),i(J,ot),i(J,_n),i(J,st),i(J,bn),i(J,R),g(Ne,R,null),i(R,Mn),i(R,at),i(R,yn),g(re,R,null),i(R,Tn),g(ie,R,null),c(e,Ft,o),g(Ie,e,o),c(e,Wt,o),c(e,lt,o),Nt=!0},p(e,[o]){const G={};o&2&&(G.$$scope={dirty:o,ctx:e}),O.$set(G);const W={};o&2&&(W.$$scope={dirty:o,ctx:e}),D.$set(W);const Y={};o&2&&(Y.$$scope={dirty:o,ctx:e}),K.$set(Y);const N={};o&2&&(N.$$scope={dirty:o,ctx:e}),ee.$set(N);const X={};o&2&&(X.$$scope={dirty:o,ctx:e}),te.$set(X);const $={};o&2&&($.$$scope={dirty:o,ctx:e}),ne.$set($);const I={};o&2&&(I.$$scope={dirty:o,ctx:e}),oe.$set(I);const Z={};o&2&&(Z.$$scope={dirty:o,ctx:e}),se.$set(Z);const V={};o&2&&(V.$$scope={dirty:o,ctx:e}),ae.$set(V);const q={};o&2&&(q.$$scope={dirty:o,ctx:e}),re.$set(q);const P={};o&2&&(P.$$scope={dirty:o,ctx:e}),ie.$set(P)},i(e){Nt||(_(T.$$.fragment,e),_(le.$$.fragment,e),_(he.$$.fragment,e),_(ge.$$.fragment,e),_(be.$$.fragment,e),_(Me.$$.fragment,e),_(O.$$.fragment,e),_(ye.$$.fragment,e),_(Te.$$.fragment,e),_(we.$$.fragment,e),_(D.$$.fragment,e),_(ve.$$.fragment,e),_(ke.$$.fragment,e),_($e.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(Ce.$$.fragment,e),_(xe.$$.fragment,e),_(je.$$.fragment,e),_(te.$$.fragment,e),_(ne.$$.fragment,e),_(oe.$$.fragment,e),_(Je.$$.fragment,e),_(ze.$$.fragment,e),_(Ue.$$.fragment,e),_(se.$$.fragment,e),_(ae.$$.fragment,e),_(Fe.$$.fragment,e),_(We.$$.fragment,e),_(Ne.$$.fragment,e),_(re.$$.fragment,e),_(ie.$$.fragment,e),_(Ie.$$.fragment,e),Nt=!0)},o(e){b(T.$$.fragment,e),b(le.$$.fragment,e),b(he.$$.fragment,e),b(ge.$$.fragment,e),b(be.$$.fragment,e),b(Me.$$.fragment,e),b(O.$$.fragment,e),b(ye.$$.fragment,e),b(Te.$$.fragment,e),b(we.$$.fragment,e),b(D.$$.fragment,e),b(ve.$$.fragment,e),b(ke.$$.fragment,e),b($e.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(Ce.$$.fragment,e),b(xe.$$.fragment,e),b(je.$$.fragment,e),b(te.$$.fragment,e),b(ne.$$.fragment,e),b(oe.$$.fragment,e),b(Je.$$.fragment,e),b(ze.$$.fragment,e),b(Ue.$$.fragment,e),b(se.$$.fragment,e),b(ae.$$.fragment,e),b(Fe.$$.fragment,e),b(We.$$.fragment,e),b(Ne.$$.fragment,e),b(re.$$.fragment,e),b(ie.$$.fragment,e),b(Ie.$$.fragment,e),Nt=!1},d(e){e&&(s(y),s(l),s(d),s(n),s(w),s(ct),s(pt),s(de),s(mt),s(ce),s(ut),s(pe),s(ht),s(me),s(ft),s(ue),s(gt),s(_t),s(fe),s(bt),s(Mt),s(_e),s(yt),s(Tt),s(F),s(wt),s(vt),s(C),s(kt),s($t),s(x),s(Ct),s(xt),s(k),s(jt),s(Jt),s(j),s(zt),s(Ut),s(J),s(Ft),s(Wt),s(lt)),s(t),M(T,e),M(le,e),M(he,e),M(ge,e),M(be,e),M(Me),M(O),M(ye,e),M(Te),M(we),M(D),M(ve,e),M(ke),M($e),M(K),M(ee),M(Ce,e),M(xe),M(je),M(te),M(ne),M(oe),M(Je,e),M(ze),M(Ue),M(se),M(ae),M(Fe,e),M(We),M(Ne),M(re),M(ie),M(Ie,e)}}}const Mo='{"title":"MPT","local":"mpt","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"MptConfig","local":"transformers.MptConfig","sections":[],"depth":2},{"title":"MptModel","local":"transformers.MptModel","sections":[],"depth":2},{"title":"MptForCausalLM","local":"transformers.MptForCausalLM","sections":[],"depth":2},{"title":"MptForSequenceClassification","local":"transformers.MptForSequenceClassification","sections":[],"depth":2},{"title":"MptForTokenClassification","local":"transformers.MptForTokenClassification","sections":[],"depth":2},{"title":"MptForQuestionAnswering","local":"transformers.MptForQuestionAnswering","sections":[],"depth":2}],"depth":1}';function yo(v){return to(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jo extends no{constructor(t){super(),oo(this,t,yo,bo,eo,{})}}export{Jo as component};
