import{s as vt,o as wt,n as ge}from"../chunks/scheduler.18a86fab.js";import{S as kt,i as $t,g as c,s as r,r as g,A as xt,h as u,f as n,c as d,j as se,u as _,x as h,k as H,y as p,a,v as b,d as y,t as T,w as v}from"../chunks/index.98837b22.js";import{T as et}from"../chunks/Tip.77304350.js";import{D as be}from"../chunks/Docstring.6758ea23.js";import{C as ot}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as tt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as fe}from"../chunks/Heading.7e7e0c5b.js";import{E as Mt}from"../chunks/index.499f366c.js";function Pt(x){let t,m='PEGASUS-X uses the same tokenizer as <a href="pegasus">PEGASUS</a>.';return{c(){t=c("p"),t.innerHTML=m},l(i){t=u(i,"P",{"data-svelte-h":!0}),h(t)!=="svelte-15wolpi"&&(t.innerHTML=m)},m(i,l){a(i,t,l)},p:ge,d(i){i&&n(t)}}}function zt(x){let t,m="Example:",i,l,f;return l=new ot({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBlZ2FzdXNYQ29uZmlnJTJDJTIwUGVnYXN1c1hNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBQRUdBU1VTJTIwZ29vZ2xlJTJGcGVnYXN1cy14LWxhcmdlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFBlZ2FzdXNYQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGdvb2dsZSUyRnBlZ2FzdXMteC1sYXJnZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwUGVnYXN1c1hNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PegasusXConfig, PegasusXModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a PEGASUS google/pegasus-x-large style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PegasusXConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the google/pegasus-x-large style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PegasusXModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=c("p"),t.textContent=m,i=r(),g(l.$$.fragment)},l(s){t=u(s,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=m),i=d(s),_(l.$$.fragment,s)},m(s,w){a(s,t,w),a(s,i,w),b(l,s,w),f=!0},p:ge,i(s){f||(y(l.$$.fragment,s),f=!0)},o(s){T(l.$$.fragment,s),f=!1},d(s){s&&(n(t),n(i)),v(l,s)}}}function Xt(x){let t,m=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=m},l(i){t=u(i,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=m)},m(i,l){a(i,t,l)},p:ge,d(i){i&&n(t)}}}function Ct(x){let t,m="Example:",i,l,f;return l=new ot({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBQZWdhc3VzTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZwZWdhc3VzLXgtbGFyZ2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBQZWdhc3VzTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnBlZ2FzdXMteC1sYXJnZSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyU3R1ZGllcyUyMGhhdmUlMjBiZWVuJTIwc2hvd24lMjB0aGF0JTIwb3duaW5nJTIwYSUyMGRvZyUyMGlzJTIwZ29vZCUyMGZvciUyMHlvdSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBZGVjb2Rlcl9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyU3R1ZGllcyUyMHNob3clMjB0aGF0JTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTNEaW5wdXRzLmlucHV0X2lkcyUyQyUyMGRlY29kZXJfaW5wdXRfaWRzJTNEZGVjb2Rlcl9pbnB1dHMuaW5wdXRfaWRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PegasusModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/pegasus-x-large&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PegasusModel.from_pretrained(<span class="hljs-string">&quot;google/pegasus-x-large&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Studies have been shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_inputs = tokenizer(<span class="hljs-string">&quot;Studies show that&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=inputs.input_ids, decoder_input_ids=decoder_inputs.input_ids)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">1024</span>]`,wrap:!1}}),{c(){t=c("p"),t.textContent=m,i=r(),g(l.$$.fragment)},l(s){t=u(s,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=m),i=d(s),_(l.$$.fragment,s)},m(s,w){a(s,t,w),a(s,i,w),b(l,s,w),f=!0},p:ge,i(s){f||(y(l.$$.fragment,s),f=!0)},o(s){T(l.$$.fragment,s),f=!1},d(s){s&&(n(t),n(i)),v(l,s)}}}function qt(x){let t,m=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=m},l(i){t=u(i,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=m)},m(i,l){a(i,t,l)},p:ge,d(i){i&&n(t)}}}function St(x){let t,m="Example:",i,l,f;return l=new ot({props:{code:"",highlighted:"",wrap:!1}}),{c(){t=c("p"),t.textContent=m,i=r(),g(l.$$.fragment)},l(s){t=u(s,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=m),i=d(s),_(l.$$.fragment,s)},m(s,w){a(s,t,w),a(s,i,w),b(l,s,w),f=!0},p:ge,i(s){f||(y(l.$$.fragment,s),f=!0)},o(s){T(l.$$.fragment,s),f=!1},d(s){s&&(n(t),n(i)),v(l,s)}}}function Ft(x){let t,m,i,l,f,s,w,nt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',ye,E,Te,J,st='The PEGASUS-X model was proposed in <a href="https://arxiv.org/abs/2208.04347" rel="nofollow">Investigating Efficiently Extending Transformers for Long Input Summarization</a>  by Jason Phang, Yao Zhao and Peter J. Liu.',ve,L,at="PEGASUS-X (PEGASUS eXtended) extends the PEGASUS models for long input summarization through additional long input pretraining and using staggered block-local attention with global tokens in the encoder.",we,N,rt="The abstract from the paper is the following:",ke,A,dt="<em>While large pretrained Transformer models have proven highly capable at tackling natural language tasks, handling long sequence inputs continues to be a significant challenge. One such task is long input summarization, where inputs are longer than the maximum input context of most pretrained models. Through an extensive set of experiments, we investigate what model architectural changes and pretraining paradigms can most efficiently adapt a pretrained Transformer for long input summarization. We find that a staggered, block-local Transformer with global encoder tokens strikes a good balance of performance and efficiency, and that an additional pretraining phase on long sequences meaningfully improves downstream summarization performance. Based on our findings, we introduce PEGASUS-X, an extension of the PEGASUS model with additional long input pretraining to handle inputs of up to 16K tokens. PEGASUS-X achieves strong performance on long input summarization tasks comparable with much larger models while adding few additional parameters and not requiring model parallelism to train.</em>",$e,O,it='This model was contributed by <a href="https://huggingface.co/zphang" rel="nofollow">zphang</a>. The original code can be found <a href="https://github.com/google-research/pegasus" rel="nofollow">here</a>.',xe,B,Me,R,lt='<li><a href="../tasks/translation">Translation task guide</a></li> <li><a href="../tasks/summarization">Summarization task guide</a></li>',Pe,U,ze,D,Xe,M,V,Ie,ae,ct=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/pegasus_x#transformers.PegasusXModel">PegasusXModel</a>. It is used to instantiate a
PEGASUS-X model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the PEGASUS-X
<a href="https://huggingface.co/google/pegasus-x-large" rel="nofollow">google/pegasus-x-large</a> architecture.`,Ze,re,ut=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,We,G,Ce,Q,qe,k,Y,He,de,pt="The bare Pegasus X Model outputting raw hidden-states without any specific head on top.",Ee,ie,ht=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Je,le,mt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Le,X,K,Ne,ce,ft='The <a href="/docs/transformers/main/en/model_doc/pegasus_x#transformers.PegasusXModel">PegasusXModel</a> forward method, overrides the <code>__call__</code> special method.',Ae,j,Oe,I,Se,ee,Fe,$,te,Be,ue,gt="The PEGASUS-X for conditional generation (e.g. summarization).",Re,pe,_t=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,De,he,bt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ve,C,oe,Qe,me,yt='The <a href="/docs/transformers/main/en/model_doc/pegasus_x#transformers.PegasusXForConditionalGeneration">PegasusXForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Ye,Z,Ke,W,Ue,ne,Ge,_e,je;return f=new fe({props:{title:"PEGASUS-X",local:"pegasus-x",headingTag:"h1"}}),E=new fe({props:{title:"Overview",local:"overview",headingTag:"h2"}}),B=new fe({props:{title:"Documentation resources",local:"documentation-resources",headingTag:"h2"}}),U=new et({props:{$$slots:{default:[Pt]},$$scope:{ctx:x}}}),D=new fe({props:{title:"PegasusXConfig",local:"transformers.PegasusXConfig",headingTag:"h2"}}),V=new be({props:{name:"class transformers.PegasusXConfig",anchor:"transformers.PegasusXConfig",parameters:[{name:"vocab_size",val:" = 96103"},{name:"max_position_embeddings",val:" = 16384"},{name:"encoder_layers",val:" = 16"},{name:"encoder_ffn_dim",val:" = 4096"},{name:"encoder_attention_heads",val:" = 16"},{name:"decoder_layers",val:" = 16"},{name:"decoder_ffn_dim",val:" = 4096"},{name:"decoder_attention_heads",val:" = 16"},{name:"encoder_layerdrop",val:" = 0.0"},{name:"decoder_layerdrop",val:" = 0.0"},{name:"use_cache",val:" = True"},{name:"is_encoder_decoder",val:" = True"},{name:"activation_function",val:" = 'gelu'"},{name:"d_model",val:" = 1024"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"init_std",val:" = 0.02"},{name:"decoder_start_token_id",val:" = 0"},{name:"scale_embedding",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"eos_token_id",val:" = 1"},{name:"forced_eos_token_id",val:" = 1"},{name:"num_global_tokens",val:" = 32"},{name:"block_size",val:" = 512"},{name:"stagger_local_blocks",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PegasusXConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 96103) &#x2014;
Vocabulary size of the PEGASUS-X model. Defines the number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/pegasus_x#transformers.PegasusXModel">PegasusXModel</a>.`,name:"vocab_size"},{anchor:"transformers.PegasusXConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension of the layers and the pooler layer.`,name:"d_model"},{anchor:"transformers.PegasusXConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of encoder layers.`,name:"encoder_layers"},{anchor:"transformers.PegasusXConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.PegasusXConfig.encoder_attention_heads",description:`<strong>encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"encoder_attention_heads"},{anchor:"transformers.PegasusXConfig.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.PegasusXConfig.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.PegasusXConfig.encoder_ffn_dim",description:`<strong>encoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"encoder_ffn_dim"},{anchor:"transformers.PegasusXConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.PegasusXConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.PegasusXConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.PegasusXConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.PegasusXConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.PegasusXConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.PegasusXConfig.encoder_layerdrop",description:`<strong>encoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the encoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"encoder_layerdrop"},{anchor:"transformers.PegasusXConfig.decoder_layerdrop",description:`<strong>decoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"decoder_layerdrop"},{anchor:"transformers.PegasusXConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models)`,name:"use_cache"},{anchor:"transformers.PegasusXConfig.forced_eos_token_id",description:`<strong>forced_eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached. Usually set to
<code>eos_token_id</code>.`,name:"forced_eos_token_id"},{anchor:"transformers.PegasusXConfig.num_global_tokens",description:`<strong>num_global_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Number of global tokens to use for the encoder`,name:"num_global_tokens"},{anchor:"transformers.PegasusXConfig.block_size",description:`<strong>block_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Block size for encoder local attention. Sequence length should be an exact multiple of block size.
block_size must be a multiple of 2 if stagger_local_block is True`,name:"block_size"},{anchor:"transformers.PegasusXConfig.stagger_local_block",description:`<strong>stagger_local_block</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to stagger every other local attention by half a block`,name:"stagger_local_block"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/pegasus_x/configuration_pegasus_x.py#L24"}}),G=new tt({props:{anchor:"transformers.PegasusXConfig.example",$$slots:{default:[zt]},$$scope:{ctx:x}}}),Q=new fe({props:{title:"PegasusXModel",local:"transformers.PegasusXModel",headingTag:"h2"}}),Y=new be({props:{name:"class transformers.PegasusXModel",anchor:"transformers.PegasusXModel",parameters:[{name:"config",val:": PegasusXConfig"}],parametersDescription:[{anchor:"transformers.PegasusXModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/pegasus_x#transformers.PegasusXConfig">PegasusXConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/pegasus_x/modeling_pegasus_x.py#L1195"}}),K=new be({props:{name:"forward",anchor:"transformers.PegasusXModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PegasusXModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PegasusXModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PegasusXModel.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>PEGASUS-X uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).`,name:"decoder_input_ids"},{anchor:"transformers.PegasusXModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.PegasusXModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>Tuple[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.PegasusXModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PegasusXModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PegasusXModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.PegasusXModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PegasusXModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PegasusXModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PegasusXModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/pegasus_x/modeling_pegasus_x.py#L1252",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqModelOutput"
>transformers.modeling_outputs.Seq2SeqModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/pegasus_x#transformers.PegasusXConfig"
>PegasusXConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqModelOutput"
>transformers.modeling_outputs.Seq2SeqModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),j=new et({props:{$$slots:{default:[Xt]},$$scope:{ctx:x}}}),I=new tt({props:{anchor:"transformers.PegasusXModel.forward.example",$$slots:{default:[Ct]},$$scope:{ctx:x}}}),ee=new fe({props:{title:"PegasusXForConditionalGeneration",local:"transformers.PegasusXForConditionalGeneration",headingTag:"h2"}}),te=new be({props:{name:"class transformers.PegasusXForConditionalGeneration",anchor:"transformers.PegasusXForConditionalGeneration",parameters:[{name:"config",val:": PegasusXConfig"}],parametersDescription:[{anchor:"transformers.PegasusXForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/pegasus_x#transformers.PegasusXConfig">PegasusXConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/pegasus_x/modeling_pegasus_x.py#L1354"}}),oe=new be({props:{name:"forward",anchor:"transformers.PegasusXForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PegasusXForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PegasusXForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PegasusXForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>PEGASUS-X uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).`,name:"decoder_input_ids"},{anchor:"transformers.PegasusXForConditionalGeneration.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.PegasusXForConditionalGeneration.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>Tuple[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.PegasusXForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PegasusXForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PegasusXForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.PegasusXForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.PegasusXForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PegasusXForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PegasusXForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PegasusXForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/pegasus_x/modeling_pegasus_x.py#L1406",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/pegasus_x#transformers.PegasusXConfig"
>PegasusXConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Z=new et({props:{$$slots:{default:[qt]},$$scope:{ctx:x}}}),W=new tt({props:{anchor:"transformers.PegasusXForConditionalGeneration.forward.example",$$slots:{default:[St]},$$scope:{ctx:x}}}),ne=new Mt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/pegasus_x.md"}}),{c(){t=c("meta"),m=r(),i=c("p"),l=r(),g(f.$$.fragment),s=r(),w=c("div"),w.innerHTML=nt,ye=r(),g(E.$$.fragment),Te=r(),J=c("p"),J.innerHTML=st,ve=r(),L=c("p"),L.textContent=at,we=r(),N=c("p"),N.textContent=rt,ke=r(),A=c("p"),A.innerHTML=dt,$e=r(),O=c("p"),O.innerHTML=it,xe=r(),g(B.$$.fragment),Me=r(),R=c("ul"),R.innerHTML=lt,Pe=r(),g(U.$$.fragment),ze=r(),g(D.$$.fragment),Xe=r(),M=c("div"),g(V.$$.fragment),Ie=r(),ae=c("p"),ae.innerHTML=ct,Ze=r(),re=c("p"),re.innerHTML=ut,We=r(),g(G.$$.fragment),Ce=r(),g(Q.$$.fragment),qe=r(),k=c("div"),g(Y.$$.fragment),He=r(),de=c("p"),de.textContent=pt,Ee=r(),ie=c("p"),ie.innerHTML=ht,Je=r(),le=c("p"),le.innerHTML=mt,Le=r(),X=c("div"),g(K.$$.fragment),Ne=r(),ce=c("p"),ce.innerHTML=ft,Ae=r(),g(j.$$.fragment),Oe=r(),g(I.$$.fragment),Se=r(),g(ee.$$.fragment),Fe=r(),$=c("div"),g(te.$$.fragment),Be=r(),ue=c("p"),ue.textContent=gt,Re=r(),pe=c("p"),pe.innerHTML=_t,De=r(),he=c("p"),he.innerHTML=bt,Ve=r(),C=c("div"),g(oe.$$.fragment),Qe=r(),me=c("p"),me.innerHTML=yt,Ye=r(),g(Z.$$.fragment),Ke=r(),g(W.$$.fragment),Ue=r(),g(ne.$$.fragment),Ge=r(),_e=c("p"),this.h()},l(e){const o=xt("svelte-u9bgzb",document.head);t=u(o,"META",{name:!0,content:!0}),o.forEach(n),m=d(e),i=u(e,"P",{}),se(i).forEach(n),l=d(e),_(f.$$.fragment,e),s=d(e),w=u(e,"DIV",{class:!0,"data-svelte-h":!0}),h(w)!=="svelte-13t8s2t"&&(w.innerHTML=nt),ye=d(e),_(E.$$.fragment,e),Te=d(e),J=u(e,"P",{"data-svelte-h":!0}),h(J)!=="svelte-1cf9a4l"&&(J.innerHTML=st),ve=d(e),L=u(e,"P",{"data-svelte-h":!0}),h(L)!=="svelte-1ca7lvv"&&(L.textContent=at),we=d(e),N=u(e,"P",{"data-svelte-h":!0}),h(N)!=="svelte-vfdo9a"&&(N.textContent=rt),ke=d(e),A=u(e,"P",{"data-svelte-h":!0}),h(A)!=="svelte-1l56tf7"&&(A.innerHTML=dt),$e=d(e),O=u(e,"P",{"data-svelte-h":!0}),h(O)!=="svelte-1jl4kfe"&&(O.innerHTML=it),xe=d(e),_(B.$$.fragment,e),Me=d(e),R=u(e,"UL",{"data-svelte-h":!0}),h(R)!=="svelte-6ej6p2"&&(R.innerHTML=lt),Pe=d(e),_(U.$$.fragment,e),ze=d(e),_(D.$$.fragment,e),Xe=d(e),M=u(e,"DIV",{class:!0});var q=se(M);_(V.$$.fragment,q),Ie=d(q),ae=u(q,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-8xivau"&&(ae.innerHTML=ct),Ze=d(q),re=u(q,"P",{"data-svelte-h":!0}),h(re)!=="svelte-o55m63"&&(re.innerHTML=ut),We=d(q),_(G.$$.fragment,q),q.forEach(n),Ce=d(e),_(Q.$$.fragment,e),qe=d(e),k=u(e,"DIV",{class:!0});var P=se(k);_(Y.$$.fragment,P),He=d(P),de=u(P,"P",{"data-svelte-h":!0}),h(de)!=="svelte-p6rdya"&&(de.textContent=pt),Ee=d(P),ie=u(P,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-6pahdo"&&(ie.innerHTML=ht),Je=d(P),le=u(P,"P",{"data-svelte-h":!0}),h(le)!=="svelte-hswkmf"&&(le.innerHTML=mt),Le=d(P),X=u(P,"DIV",{class:!0});var S=se(X);_(K.$$.fragment,S),Ne=d(S),ce=u(S,"P",{"data-svelte-h":!0}),h(ce)!=="svelte-1a1wp7s"&&(ce.innerHTML=ft),Ae=d(S),_(j.$$.fragment,S),Oe=d(S),_(I.$$.fragment,S),S.forEach(n),P.forEach(n),Se=d(e),_(ee.$$.fragment,e),Fe=d(e),$=u(e,"DIV",{class:!0});var z=se($);_(te.$$.fragment,z),Be=d(z),ue=u(z,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-pttobx"&&(ue.textContent=gt),Re=d(z),pe=u(z,"P",{"data-svelte-h":!0}),h(pe)!=="svelte-6pahdo"&&(pe.innerHTML=_t),De=d(z),he=u(z,"P",{"data-svelte-h":!0}),h(he)!=="svelte-hswkmf"&&(he.innerHTML=bt),Ve=d(z),C=u(z,"DIV",{class:!0});var F=se(C);_(oe.$$.fragment,F),Qe=d(F),me=u(F,"P",{"data-svelte-h":!0}),h(me)!=="svelte-mbnexy"&&(me.innerHTML=yt),Ye=d(F),_(Z.$$.fragment,F),Ke=d(F),_(W.$$.fragment,F),F.forEach(n),z.forEach(n),Ue=d(e),_(ne.$$.fragment,e),Ge=d(e),_e=u(e,"P",{}),se(_e).forEach(n),this.h()},h(){H(t,"name","hf:doc:metadata"),H(t,"content",Ut),H(w,"class","flex flex-wrap space-x-1"),H(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){p(document.head,t),a(e,m,o),a(e,i,o),a(e,l,o),b(f,e,o),a(e,s,o),a(e,w,o),a(e,ye,o),b(E,e,o),a(e,Te,o),a(e,J,o),a(e,ve,o),a(e,L,o),a(e,we,o),a(e,N,o),a(e,ke,o),a(e,A,o),a(e,$e,o),a(e,O,o),a(e,xe,o),b(B,e,o),a(e,Me,o),a(e,R,o),a(e,Pe,o),b(U,e,o),a(e,ze,o),b(D,e,o),a(e,Xe,o),a(e,M,o),b(V,M,null),p(M,Ie),p(M,ae),p(M,Ze),p(M,re),p(M,We),b(G,M,null),a(e,Ce,o),b(Q,e,o),a(e,qe,o),a(e,k,o),b(Y,k,null),p(k,He),p(k,de),p(k,Ee),p(k,ie),p(k,Je),p(k,le),p(k,Le),p(k,X),b(K,X,null),p(X,Ne),p(X,ce),p(X,Ae),b(j,X,null),p(X,Oe),b(I,X,null),a(e,Se,o),b(ee,e,o),a(e,Fe,o),a(e,$,o),b(te,$,null),p($,Be),p($,ue),p($,Re),p($,pe),p($,De),p($,he),p($,Ve),p($,C),b(oe,C,null),p(C,Qe),p(C,me),p(C,Ye),b(Z,C,null),p(C,Ke),b(W,C,null),a(e,Ue,o),b(ne,e,o),a(e,Ge,o),a(e,_e,o),je=!0},p(e,[o]){const q={};o&2&&(q.$$scope={dirty:o,ctx:e}),U.$set(q);const P={};o&2&&(P.$$scope={dirty:o,ctx:e}),G.$set(P);const S={};o&2&&(S.$$scope={dirty:o,ctx:e}),j.$set(S);const z={};o&2&&(z.$$scope={dirty:o,ctx:e}),I.$set(z);const F={};o&2&&(F.$$scope={dirty:o,ctx:e}),Z.$set(F);const Tt={};o&2&&(Tt.$$scope={dirty:o,ctx:e}),W.$set(Tt)},i(e){je||(y(f.$$.fragment,e),y(E.$$.fragment,e),y(B.$$.fragment,e),y(U.$$.fragment,e),y(D.$$.fragment,e),y(V.$$.fragment,e),y(G.$$.fragment,e),y(Q.$$.fragment,e),y(Y.$$.fragment,e),y(K.$$.fragment,e),y(j.$$.fragment,e),y(I.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(oe.$$.fragment,e),y(Z.$$.fragment,e),y(W.$$.fragment,e),y(ne.$$.fragment,e),je=!0)},o(e){T(f.$$.fragment,e),T(E.$$.fragment,e),T(B.$$.fragment,e),T(U.$$.fragment,e),T(D.$$.fragment,e),T(V.$$.fragment,e),T(G.$$.fragment,e),T(Q.$$.fragment,e),T(Y.$$.fragment,e),T(K.$$.fragment,e),T(j.$$.fragment,e),T(I.$$.fragment,e),T(ee.$$.fragment,e),T(te.$$.fragment,e),T(oe.$$.fragment,e),T(Z.$$.fragment,e),T(W.$$.fragment,e),T(ne.$$.fragment,e),je=!1},d(e){e&&(n(m),n(i),n(l),n(s),n(w),n(ye),n(Te),n(J),n(ve),n(L),n(we),n(N),n(ke),n(A),n($e),n(O),n(xe),n(Me),n(R),n(Pe),n(ze),n(Xe),n(M),n(Ce),n(qe),n(k),n(Se),n(Fe),n($),n(Ue),n(Ge),n(_e)),n(t),v(f,e),v(E,e),v(B,e),v(U,e),v(D,e),v(V),v(G),v(Q,e),v(Y),v(K),v(j),v(I),v(ee,e),v(te),v(oe),v(Z),v(W),v(ne,e)}}}const Ut='{"title":"PEGASUS-X","local":"pegasus-x","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Documentation resources","local":"documentation-resources","sections":[],"depth":2},{"title":"PegasusXConfig","local":"transformers.PegasusXConfig","sections":[],"depth":2},{"title":"PegasusXModel","local":"transformers.PegasusXModel","sections":[],"depth":2},{"title":"PegasusXForConditionalGeneration","local":"transformers.PegasusXForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Gt(x){return wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nt extends kt{constructor(t){super(),$t(this,t,Gt,Ft,vt,{})}}export{Nt as component};
