import{s as oa,o as na,n as Y}from"../chunks/scheduler.18a86fab.js";import{S as sa,i as aa,g as i,s,r as u,A as ra,h as l,f as o,c as a,j as U,u as f,x as c,k as z,y as d,a as n,v as g,d as _,t as T,w as v}from"../chunks/index.98837b22.js";import{T as zt}from"../chunks/Tip.77304350.js";import{D as P}from"../chunks/Docstring.6758ea23.js";import{C as te}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as ts}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as S}from"../chunks/Heading.7e7e0c5b.js";import{E as ia}from"../chunks/index.499f366c.js";function la(k){let r,M=`This method successively calls the <code>.generate</code> function of two different sub-models. You can specify keyword
arguments at two different levels: general arguments that will be passed to both models, or prefixed arguments
that will be passed to one of them.`,h,p,x=`For example, calling <code>.generate(input_ids=input_ids, num_beams=4, speech_do_sample=True)</code> will successively
perform beam-search decoding on the text model, and multinomial beam-search sampling on the speech model.`,m,b,R=`For an overview of generation strategies and code examples, check out the <a href="./generation_strategies">following
guide</a>.`;return{c(){r=i("p"),r.innerHTML=M,h=s(),p=i("p"),p.innerHTML=x,m=s(),b=i("p"),b.innerHTML=R},l(y){r=l(y,"P",{"data-svelte-h":!0}),c(r)!=="svelte-p3kc7q"&&(r.innerHTML=M),h=a(y),p=l(y,"P",{"data-svelte-h":!0}),c(p)!=="svelte-x1gqs1"&&(p.innerHTML=x),m=a(y),b=l(y,"P",{"data-svelte-h":!0}),c(b)!=="svelte-nzkxpe"&&(b.innerHTML=R)},m(y,w){n(y,r,w),n(y,h,w),n(y,p,w),n(y,m,w),n(y,b,w)},p:Y,d(y){y&&(o(r),o(h),o(p),o(m),o(b))}}}function da(k){let r,M=`This method successively calls the <code>.generate</code> function of two different sub-models. You can specify keyword
arguments at two different levels: general arguments that will be passed to both models, or prefixed arguments
that will be passed to one of them.`,h,p,x=`For example, calling <code>.generate(input_ids, num_beams=4, speech_do_sample=True)</code> will successively perform
beam-search decoding on the text model, and multinomial beam-search sampling on the speech model.`,m,b,R=`For an overview of generation strategies and code examples, check out the <a href="./generation_strategies">following
guide</a>.`;return{c(){r=i("p"),r.innerHTML=M,h=s(),p=i("p"),p.innerHTML=x,m=s(),b=i("p"),b.innerHTML=R},l(y){r=l(y,"P",{"data-svelte-h":!0}),c(r)!=="svelte-p3kc7q"&&(r.innerHTML=M),h=a(y),p=l(y,"P",{"data-svelte-h":!0}),c(p)!=="svelte-f4qe4d"&&(p.innerHTML=x),m=a(y),b=l(y,"P",{"data-svelte-h":!0}),c(b)!=="svelte-nzkxpe"&&(b.innerHTML=R)},m(y,w){n(y,r,w),n(y,h,w),n(y,p,w),n(y,m,w),n(y,b,w)},p:Y,d(y){y&&(o(r),o(h),o(p),o(m),o(b))}}}function ca(k){let r,M=`This method successively calls the <code>.generate</code> function of two different sub-models. You can specify keyword
arguments at two different levels: general arguments that will be passed to both models, or prefixed arguments
that will be passed to one of them.`,h,p,x=`For example, calling <code>.generate(input_features, num_beams=4, speech_do_sample=True)</code> will successively perform
beam-search decoding on the text model, and multinomial beam-search sampling on the speech model.`,m,b,R=`For an overview of generation strategies and code examples, check out the <a href="./generation_strategies">following
guide</a>.`;return{c(){r=i("p"),r.innerHTML=M,h=s(),p=i("p"),p.innerHTML=x,m=s(),b=i("p"),b.innerHTML=R},l(y){r=l(y,"P",{"data-svelte-h":!0}),c(r)!=="svelte-p3kc7q"&&(r.innerHTML=M),h=a(y),p=l(y,"P",{"data-svelte-h":!0}),c(p)!=="svelte-v2xo2a"&&(p.innerHTML=x),m=a(y),b=l(y,"P",{"data-svelte-h":!0}),c(b)!=="svelte-nzkxpe"&&(b.innerHTML=R)},m(y,w){n(y,r,w),n(y,h,w),n(y,p,w),n(y,m,w),n(y,b,w)},p:Y,d(y){y&&(o(r),o(h),o(p),o(m),o(b))}}}function ma(k){let r,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=i("p"),r.innerHTML=M},l(h){r=l(h,"P",{"data-svelte-h":!0}),c(r)!=="svelte-fincs2"&&(r.innerHTML=M)},m(h,p){n(h,r,p)},p:Y,d(h){h&&o(r)}}}function pa(k){let r,M="Example:",h,p,x;return p=new te({props:{code:"",highlighted:"",wrap:!1}}),{c(){r=i("p"),r.textContent=M,h=s(),u(p.$$.fragment)},l(m){r=l(m,"P",{"data-svelte-h":!0}),c(r)!=="svelte-11lpom8"&&(r.textContent=M),h=a(m),f(p.$$.fragment,m)},m(m,b){n(m,r,b),n(m,h,b),g(p,m,b),x=!0},p:Y,i(m){x||(_(p.$$.fragment,m),x=!0)},o(m){T(p.$$.fragment,m),x=!1},d(m){m&&(o(r),o(h)),v(p,m)}}}function ha(k){let r,M=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate(), e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,h,p,x=`For an overview of generation strategies and code examples, check out the <a href="./generation_strategies">following
guide</a>.`;return{c(){r=i("p"),r.innerHTML=M,h=s(),p=i("p"),p.innerHTML=x},l(m){r=l(m,"P",{"data-svelte-h":!0}),c(r)!=="svelte-1c5u34l"&&(r.innerHTML=M),h=a(m),p=l(m,"P",{"data-svelte-h":!0}),c(p)!=="svelte-nzkxpe"&&(p.innerHTML=x)},m(m,b){n(m,r,b),n(m,h,b),n(m,p,b)},p:Y,d(m){m&&(o(r),o(h),o(p))}}}function ua(k){let r,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=i("p"),r.innerHTML=M},l(h){r=l(h,"P",{"data-svelte-h":!0}),c(r)!=="svelte-fincs2"&&(r.innerHTML=M)},m(h,p){n(h,r,p)},p:Y,d(h){h&&o(r)}}}function fa(k){let r,M="Example:",h,p,x;return p=new te({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBTZWFtbGVzc000VHYyRm9yU3BlZWNoVG9UZXh0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyJTIyJTIyJTIyKSUwQW1vZGVsJTIwJTNEJTIwU2VhbWxlc3NNNFR2MkZvclNwZWVjaFRvVGV4dC5mcm9tX3ByZXRyYWluZWQoJTIyJTIyJTIyJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9pZHMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTBBJTIzJTIwdHJhbnNjcmliZSUyMHNwZWVjaCUwQXRyYW5zY3JpcHRpb24lMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKHByZWRpY3RlZF9pZHMpJTBBdHJhbnNjcmlwdGlvbiU1QjAlNUQlMEElMEFpbnB1dHMlNUIlMjJsYWJlbHMlMjIlNUQlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRGRhdGFzZXQlNUIwJTVEJTVCJTIydGV4dCUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmlucHV0X2lkcyUwQSUwQSUyMyUyMGNvbXB1dGUlMjBsb3NzJTBBbG9zcyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb3NzJTBBcm91bmQobG9zcy5pdGVtKCklMkMlMjAyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, SeamlessM4Tv2ForSpeechToText
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;&quot;&quot;&quot;)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SeamlessM4Tv2ForSpeechToText.from_pretrained(&quot;&quot;&quot;</span><span class="hljs-string">&quot;)

&gt;&gt;&gt; # audio file is decoded on the fly
&gt;&gt;&gt; inputs = processor(dataset[0][&quot;</span>audio<span class="hljs-string">&quot;][&quot;</span>array<span class="hljs-string">&quot;], sampling_rate=sampling_rate, return_tensors=&quot;</span>pt<span class="hljs-string">&quot;)
&gt;&gt;&gt; with torch.no_grad():
...     logits = model(**inputs).logits
&gt;&gt;&gt; predicted_ids = torch.argmax(logits, dim=-1)

&gt;&gt;&gt; # transcribe speech
&gt;&gt;&gt; transcription = processor.batch_decode(predicted_ids)
&gt;&gt;&gt; transcription[0]
...

&gt;&gt;&gt; inputs[&quot;</span>labels<span class="hljs-string">&quot;] = processor(text=dataset[0][&quot;</span>text<span class="hljs-string">&quot;], return_tensors=&quot;</span>pt<span class="hljs-string">&quot;).input_ids

&gt;&gt;&gt; # compute loss
&gt;&gt;&gt; loss = model(**inputs).loss
&gt;&gt;&gt; round(loss.item(), 2)
...</span>`,wrap:!1}}),{c(){r=i("p"),r.textContent=M,h=s(),u(p.$$.fragment)},l(m){r=l(m,"P",{"data-svelte-h":!0}),c(r)!=="svelte-11lpom8"&&(r.textContent=M),h=a(m),f(p.$$.fragment,m)},m(m,b){n(m,r,b),n(m,h,b),g(p,m,b),x=!0},p:Y,i(m){x||(_(p.$$.fragment,m),x=!0)},o(m){T(p.$$.fragment,m),x=!1},d(m){m&&(o(r),o(h)),v(p,m)}}}function ga(k){let r,M=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate(), e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,h,p,x=`For an overview of generation strategies and code examples, check out the <a href="./generation_strategies">following
guide</a>.`;return{c(){r=i("p"),r.innerHTML=M,h=s(),p=i("p"),p.innerHTML=x},l(m){r=l(m,"P",{"data-svelte-h":!0}),c(r)!=="svelte-1c5u34l"&&(r.innerHTML=M),h=a(m),p=l(m,"P",{"data-svelte-h":!0}),c(p)!=="svelte-nzkxpe"&&(p.innerHTML=x)},m(m,b){n(m,r,b),n(m,h,b),n(m,p,b)},p:Y,d(m){m&&(o(r),o(h),o(p))}}}function _a(k){let r,M;return r=new te({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlYW1sZXNzTTRUdjJNb2RlbCUyQyUyMFNlYW1sZXNzTTRUdjJDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU2VhbWxlc3NNNFR2MiUyMCUyMiUyMiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBTZWFtbGVzc000VHYyQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwJTIyJTIyJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBTZWFtbGVzc000VHYyTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SeamlessM4Tv2Model, SeamlessM4Tv2Config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SeamlessM4Tv2 &quot;&quot; style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SeamlessM4Tv2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the &quot;&quot; style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SeamlessM4Tv2Model(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){u(r.$$.fragment)},l(h){f(r.$$.fragment,h)},m(h,p){g(r,h,p),M=!0},p:Y,i(h){M||(_(r.$$.fragment,h),M=!0)},o(h){T(r.$$.fragment,h),M=!1},d(h){v(r,h)}}}function Ta(k){let r,M,h,p,x,m,b,R='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',y,w,oo,ue,os='The SeamlessM4T-v2 model was proposed in <a href="https://ai.meta.com/research/publications/seamless-multilingual-expressive-and-streaming-speech-translation/" rel="nofollow">Seamless: Multilingual Expressive and Streaming Speech Translation</a> by the Seamless Communication team from Meta AI.',no,fe,ns='SeamlessM4T-v2 is a collection of models designed to provide high quality translation, allowing people from different linguistic communities to communicate effortlessly through speech and text. It is an improvement on the <a href="https://huggingface.co/docs/transformers/main/model_doc/seamless_m4t" rel="nofollow">previous version</a>. For more details on the differences between v1 and v2, refer to section <a href="#difference-with-seamlessm4t-v1">Difference with SeamlessM4T-v1</a>.',so,ge,ss="SeamlessM4T-v2 enables multiple tasks without relying on separate models:",ao,_e,as="<li>Speech-to-speech translation (S2ST)</li> <li>Speech-to-text translation (S2TT)</li> <li>Text-to-speech translation (T2ST)</li> <li>Text-to-text translation (T2TT)</li> <li>Automatic speech recognition (ASR)</li>",ro,Te,rs='<a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Model">SeamlessM4Tv2Model</a> can perform all the above tasks, but each task also has its own dedicated sub-model.',io,ve,is="The abstract from the paper is the following:",lo,be,ls="<em>Recent advancements in automatic speech translation have dramatically expanded language coverage, improved multimodal capabilities, and enabled a wide range of tasks and functionalities. That said, large-scale automatic speech translation systems today lack key features that help machine-mediated communication feel seamless when compared to human-to-human dialogue. In this work, we introduce a family of models that enable end-to-end expressive and multilingual translations in a streaming fashion. First, we contribute an improved version of the massively multilingual and multimodal SeamlessM4T model—SeamlessM4T v2. This newer model, incorporating an updated UnitY2 framework, was trained on more low-resource language data. The expanded version of SeamlessAlign adds 114,800 hours of automatically aligned data for a total of 76 languages. SeamlessM4T v2 provides the foundation on which our two newest models, SeamlessExpressive and SeamlessStreaming, are initiated. SeamlessExpressive enables translation that preserves vocal styles and prosody. Compared to previous efforts in expressive speech research, our work addresses certain underexplored aspects of prosody, such as speech rate and pauses, while also preserving the style of one’s voice. As for SeamlessStreaming, our model leverages the Efficient Monotonic Multihead Attention (EMMA) mechanism to generate low-latency target translations without waiting for complete source utterances. As the first of its kind, SeamlessStreaming enables simultaneous speech-to-speech/text translation for multiple source and target languages. To understand the performance of these models, we combined novel and modified versions of existing automatic metrics to evaluate prosody, latency, and robustness. For human evaluations, we adapted existing protocols tailored for measuring the most relevant attributes in the preservation of meaning, naturalness, and expressivity. To ensure that our models can be used safely and responsibly, we implemented the first known red-teaming effort for multimodal machine translation, a system for the detection and mitigation of added toxicity, a systematic evaluation of gender bias, and an inaudible localized watermarking mechanism designed to dampen the impact of deepfakes. Consequently, we bring major components from SeamlessExpressive and SeamlessStreaming together to form Seamless, the first publicly available system that unlocks expressive cross-lingual communication in real-time. In sum, Seamless gives us a pivotal look at the technical foundation needed to turn the Universal Speech Translator from a science fiction concept into a real-world technology. Finally, contributions in this work—including models, code, and a watermark detector—are publicly released and accessible at the link below.</em>",co,ye,mo,Me,ds="In the following example, we’ll load an Arabic audio sample and an English text sample and convert them into Russian speech and French text.",po,xe,cs="First, load the processor and a checkpoint of the model:",ho,we,uo,ke,ms="You can seamlessly use this model on text or on audio, to generated either translated text or translated audio.",fo,Se,ps="Here is how to use the processor to process text and audio:",go,$e,_o,Ce,To,ze,hs='<a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Model">SeamlessM4Tv2Model</a> can <em>seamlessly</em> generate text or speech with few or no changes. Let’s target Russian voice translation:',vo,Fe,bo,Je,us="With basically the same code, I’ve translated English text and Arabic speech to Russian speech samples.",yo,je,Mo,Ie,fs=`Similarly, you can generate translated text from audio files or from text with the same model. You only have to pass <code>generate_speech=False</code> to <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Model.generate">SeamlessM4Tv2Model.generate()</a>.
This time, let’s translate to French.`,xo,qe,wo,Ue,ko,Le,So,Ne,gs=`<a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Model">SeamlessM4Tv2Model</a> is transformers top level model to generate speech and text, but you can also use dedicated models that perform the task without additional components, thus reducing the memory footprint.
For example, you can replace the audio-to-audio generation snippet with the model dedicated to the S2ST task, the rest is exactly the same code:`,$o,He,Co,Ze,_s="Or you can replace the text-to-text generation snippet with the model dedicated to the T2TT task, you only have to remove <code>generate_speech=False</code>.",zo,Pe,Fo,We,Ts='Feel free to try out <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2ForSpeechToText">SeamlessM4Tv2ForSpeechToText</a> and <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2ForTextToSpeech">SeamlessM4Tv2ForTextToSpeech</a> as well.',Jo,Ge,jo,Re,vs="You have the possibility to change the speaker used for speech synthesis with the <code>speaker_id</code> argument. Some <code>speaker_id</code> works better than other for some languages!",Io,Ve,qo,Be,bs='You can use different <a href="../generation_strategies">generation strategies</a> for text generation, e.g <code>.generate(input_ids=input_ids, text_num_beams=4, text_do_sample=True)</code> which will perform multinomial beam-search decoding on the text model. Note that speech generation only supports greedy - by default - or multinomial sampling, which can be used with e.g. <code>.generate(..., speech_do_sample=True, speech_temperature=0.6)</code>.',Uo,Xe,Lo,Ee,ys='Use <code>return_intermediate_token_ids=True</code> with <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Model">SeamlessM4Tv2Model</a> to return both speech and text !',No,De,Ho,Oe,Ms="SeamlessM4T-v2 features a versatile architecture that smoothly handles the sequential generation of text and speech. This setup comprises two sequence-to-sequence (seq2seq) models. The first model translates the input modality into translated text, while the second model generates speech tokens, known as “unit tokens,” from the translated text.",Zo,Ye,xs='Each modality has its own dedicated encoder with a unique architecture. Additionally, for speech output, a vocoder inspired by the <a href="https://arxiv.org/abs/2010.05646" rel="nofollow">HiFi-GAN</a> architecture is placed on top of the second seq2seq model.',Po,Ae,Wo,Qe,ws="The architecture of this new version differs from the first in a few aspects:",Go,Ke,Ro,et,ks="The second seq2seq model, named text-to-unit model, is now non-auto regressive, meaning that it computes units in a <strong>single forward pass</strong>. This achievement is made possible by:",Vo,tt,Ss="<li>the use of <strong>character-level embeddings</strong>, meaning that each character of the predicted translated text has its own embeddings, which are then used to predict the unit tokens.</li> <li>the use of an intermediate duration predictor, that predicts speech duration at the <strong>character-level</strong> on the predicted translated text.</li> <li>the use of a new text-to-unit decoder mixing convolutions and self-attention to handle longer context.</li>",Bo,ot,Xo,nt,$s="The speech encoder, which is used during the first-pass generation process to predict the translated text, differs mainly from the previous speech encoder through these mechanisms:",Eo,st,Cs='<li>the use of chunked attention mask to prevent attention across chunks, ensuring that each position attends only to positions within its own chunk and a fixed number of previous chunks.</li> <li>the use of relative position embeddings which only considers distance between sequence elements rather than absolute positions. Please refer to <a href="https://arxiv.org/abs/1803.02155" rel="nofollow">Self-Attentionwith Relative Position Representations (Shaw et al.)</a> for more details.</li> <li>the use of a causal depth-wise convolution instead of a non-causal one.</li>',Do,at,Oo,rt,zs="Here’s how the generation process works:",Yo,it,Fs="<li>Input text or speech is processed through its specific encoder.</li> <li>A decoder creates text tokens in the desired language.</li> <li>If speech generation is required, the second seq2seq model, generates unit tokens in an non auto-regressive way.</li> <li>These unit tokens are then passed through the final vocoder to produce the actual speech.</li>",Ao,lt,Js='This model was contributed by <a href="https://huggingface.co/ylacombe" rel="nofollow">ylacombe</a>. The original code can be found <a href="https://github.com/facebookresearch/seamless_communication" rel="nofollow">here</a>.',Qo,dt,Ko,F,ct,un,Ft,js="The original SeamlessM4Tv2 Model transformer which can be used for every tasks available (S2ST, S2TT, T2TT, T2ST).",fn,Jt,Is=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,gn,jt,qs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,_n,B,mt,Tn,It,Us="Generates translated token ids and/or translated audio waveforms.",vn,oe,en,pt,tn,J,ht,bn,qt,Ls="The text-to-speech SeamlessM4Tv2 Model transformer which can be used for T2ST.",yn,Ut,Ns=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Mn,Lt,Hs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,xn,X,ut,wn,Nt,Zs="Generates translated audio waveforms.",kn,ne,on,ft,nn,j,gt,Sn,Ht,Ps="The speech-to-speech SeamlessM4Tv2 Model transformer which can be used for S2ST.",$n,Zt,Ws=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Cn,Pt,Gs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,zn,E,_t,Fn,Wt,Rs="Generates translated audio waveforms.",Jn,se,sn,Tt,an,$,vt,jn,Gt,Vs="The text-to-text SeamlessM4Tv2 Model transformer which can be used for T2TT.",In,Rt,Bs=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,qn,Vt,Xs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Un,W,bt,Ln,Bt,Es='The <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2ForTextToText">SeamlessM4Tv2ForTextToText</a> forward method, overrides the <code>__call__</code> special method.',Nn,ae,Hn,re,Zn,D,yt,Pn,Xt,Ds="Generates sequences of token ids.",Wn,ie,rn,Mt,ln,C,xt,Gn,Et,Os="The speech-to-text SeamlessM4Tv2 Model transformer which can be used for S2TT.",Rn,Dt,Ys=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Vn,Ot,As=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Bn,G,wt,Xn,Yt,Qs='The <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2ForSpeechToText">SeamlessM4Tv2ForSpeechToText</a> forward method, overrides the <code>__call__</code> special method.',En,le,Dn,de,On,O,kt,Yn,At,Ks="Generates sequences of token ids.",An,ce,dn,St,cn,L,$t,Qn,Qt,ea=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Model">~SeamlessM4Tv2Model</a>. It is used to instantiate
an SeamlessM4Tv2 model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the SeamlessM4Tv2
<a href="https://huggingface.co/%22%22" rel="nofollow">&quot;&quot;</a> architecture.`,Kn,Kt,ta=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,es,me,mn,Ct,pn,to,hn;return x=new S({props:{title:"SeamlessM4T-v2",local:"seamlessm4t-v2",headingTag:"h1"}}),w=new S({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ye=new S({props:{title:"Usage",local:"usage",headingTag:"h2"}}),we=new te({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBTZWFtbGVzc000VHYyTW9kZWwlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRnNlYW1sZXNzLW00dC12Mi1sYXJnZSUyMiklMEFtb2RlbCUyMCUzRCUyMFNlYW1sZXNzTTRUdjJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZzZWFtbGVzcy1tNHQtdjItbGFyZ2UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, SeamlessM4Tv2Model

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/seamless-m4t-v2-large&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SeamlessM4Tv2Model.from_pretrained(<span class="hljs-string">&quot;facebook/seamless-m4t-v2-large&quot;</span>)`,wrap:!1}}),$e=new te({props:{code:"JTIzJTIwbGV0J3MlMjBsb2FkJTIwYW4lMjBhdWRpbyUyMHNhbXBsZSUyMGZyb20lMjBhbiUyMEFyYWJpYyUyMHNwZWVjaCUyMGNvcnB1cyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyYXJhYmljX3NwZWVjaF9jb3JwdXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRlc3QlMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWF1ZGlvX3NhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSklNUIlMjJhdWRpbyUyMiU1RCUwQSUwQSUyMyUyMG5vdyUyQyUyMHByb2Nlc3MlMjBpdCUwQWF1ZGlvX2lucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihhdWRpb3MlM0RhdWRpb19zYW1wbGUlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwbm93JTJDJTIwcHJvY2VzcyUyMHNvbWUlMjBFbmdsaXNoJTIwdGV4dCUyMGFzJTIwd2VsbCUwQXRleHRfaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlMjAlM0QlMjAlMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbmclMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># let&#x27;s load an audio sample from an Arabic speech corpus</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;arabic_speech_corpus&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>, streaming=<span class="hljs-literal">True</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))[<span class="hljs-string">&quot;audio&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># now, process it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_inputs = processor(audios=audio_sample[<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># now, process some English text as well</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_inputs = processor(text = <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, src_lang=<span class="hljs-string">&quot;eng&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),Ce=new S({props:{title:"Speech",local:"speech",headingTag:"h3"}}),Fe=new te({props:{code:"YXVkaW9fYXJyYXlfZnJvbV90ZXh0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKip0ZXh0X2lucHV0cyUyQyUyMHRndF9sYW5nJTNEJTIycnVzJTIyKSU1QjAlNUQuY3B1KCkubnVtcHkoKS5zcXVlZXplKCklMEFhdWRpb19hcnJheV9mcm9tX2F1ZGlvJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKiphdWRpb19pbnB1dHMlMkMlMjB0Z3RfbGFuZyUzRCUyMnJ1cyUyMiklNUIwJTVELmNwdSgpLm51bXB5KCkuc3F1ZWV6ZSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>audio_array_from_text = model.generate(**text_inputs, tgt_lang=<span class="hljs-string">&quot;rus&quot;</span>)[<span class="hljs-number">0</span>].cpu().numpy().squeeze()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_array_from_audio = model.generate(**audio_inputs, tgt_lang=<span class="hljs-string">&quot;rus&quot;</span>)[<span class="hljs-number">0</span>].cpu().numpy().squeeze()`,wrap:!1}}),je=new S({props:{title:"Text",local:"text",headingTag:"h3"}}),qe=new te({props:{code:"JTIzJTIwZnJvbSUyMGF1ZGlvJTBBb3V0cHV0X3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqYXVkaW9faW5wdXRzJTJDJTIwdGd0X2xhbmclM0QlMjJmcmElMjIlMkMlMjBnZW5lcmF0ZV9zcGVlY2glM0RGYWxzZSklMEF0cmFuc2xhdGVkX3RleHRfZnJvbV9hdWRpbyUyMCUzRCUyMHByb2Nlc3Nvci5kZWNvZGUob3V0cHV0X3Rva2VucyU1QjAlNUQudG9saXN0KCklNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBJTBBJTIzJTIwZnJvbSUyMHRleHQlMEFvdXRwdXRfdG9rZW5zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKip0ZXh0X2lucHV0cyUyQyUyMHRndF9sYW5nJTNEJTIyZnJhJTIyJTJDJTIwZ2VuZXJhdGVfc3BlZWNoJTNERmFsc2UpJTBBdHJhbnNsYXRlZF90ZXh0X2Zyb21fdGV4dCUyMCUzRCUyMHByb2Nlc3Nvci5kZWNvZGUob3V0cHV0X3Rva2VucyU1QjAlNUQudG9saXN0KCklNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># from audio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_tokens = model.generate(**audio_inputs, tgt_lang=<span class="hljs-string">&quot;fra&quot;</span>, generate_speech=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>translated_text_from_audio = processor.decode(output_tokens[<span class="hljs-number">0</span>].tolist()[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># from text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_tokens = model.generate(**text_inputs, tgt_lang=<span class="hljs-string">&quot;fra&quot;</span>, generate_speech=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>translated_text_from_text = processor.decode(output_tokens[<span class="hljs-number">0</span>].tolist()[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),Ue=new S({props:{title:"Tips",local:"tips",headingTag:"h3"}}),Le=new S({props:{title:"1. Use dedicated models",local:"1-use-dedicated-models",headingTag:"h4"}}),He=new te({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlYW1sZXNzTTRUdjJGb3JTcGVlY2hUb1NwZWVjaCUwQW1vZGVsJTIwJTNEJTIwU2VhbWxlc3NNNFR2MkZvclNwZWVjaFRvU3BlZWNoLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRnNlYW1sZXNzLW00dC12Mi1sYXJnZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SeamlessM4Tv2ForSpeechToSpeech
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SeamlessM4Tv2ForSpeechToSpeech.from_pretrained(<span class="hljs-string">&quot;facebook/seamless-m4t-v2-large&quot;</span>)`,wrap:!1}}),Pe=new te({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlYW1sZXNzTTRUdjJGb3JUZXh0VG9UZXh0JTBBbW9kZWwlMjAlM0QlMjBTZWFtbGVzc000VHYyRm9yVGV4dFRvVGV4dC5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZzZWFtbGVzcy1tNHQtdjItbGFyZ2UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SeamlessM4Tv2ForTextToText
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SeamlessM4Tv2ForTextToText.from_pretrained(<span class="hljs-string">&quot;facebook/seamless-m4t-v2-large&quot;</span>)`,wrap:!1}}),Ge=new S({props:{title:"2. Change the speaker identity",local:"2-change-the-speaker-identity",headingTag:"h4"}}),Ve=new S({props:{title:"3. Change the generation strategy",local:"3-change-the-generation-strategy",headingTag:"h4"}}),Xe=new S({props:{title:"4. Generate speech and text at the same time",local:"4-generate-speech-and-text-at-the-same-time",headingTag:"h4"}}),De=new S({props:{title:"Model architecture",local:"model-architecture",headingTag:"h2"}}),Ae=new S({props:{title:"Difference with SeamlessM4T-v1",local:"difference-with-seamlessm4t-v1",headingTag:"h3"}}),Ke=new S({props:{title:"Improvements on the second-pass model",local:"improvements-on-the-second-pass-model",headingTag:"h4"}}),ot=new S({props:{title:"Difference in the speech encoder",local:"difference-in-the-speech-encoder",headingTag:"h4"}}),at=new S({props:{title:"Generation process",local:"generation-process",headingTag:"h3"}}),dt=new S({props:{title:"SeamlessM4Tv2Model",local:"transformers.SeamlessM4Tv2Model",headingTag:"h2"}}),ct=new P({props:{name:"class transformers.SeamlessM4Tv2Model",anchor:"transformers.SeamlessM4Tv2Model",parameters:[{name:"config",val:""},{name:"current_modality",val:" = 'text'"}],parametersDescription:[{anchor:"transformers.SeamlessM4Tv2Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Model">SeamlessM4Tv2Model</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.SeamlessM4Tv2Model.current_modality",description:`<strong>current_modality</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;text&quot;</code>) &#x2014;
Default modality. Used to initialize the model.`,name:"current_modality"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/seamless_m4t_v2/modeling_seamless_m4t_v2.py#L4063"}}),mt=new P({props:{name:"generate",anchor:"transformers.SeamlessM4Tv2Model.generate",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"input_features",val:": typing.Optional[torch.Tensor] = None"},{name:"return_intermediate_token_ids",val:": typing.Optional[bool] = None"},{name:"tgt_lang",val:": typing.Optional[str] = None"},{name:"speaker_id",val:": typing.Optional[int] = 0"},{name:"generate_speech",val:": typing.Optional[bool] = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SeamlessM4Tv2Model.generate.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TTokenizer">SeamlessM4TTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TProcessor">SeamlessM4TProcessor</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SeamlessM4Tv2Model.generate.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, num_banks)</code>, <em>optional</em>) &#x2014;
Input audio features. This should be returned by the <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TFeatureExtractor">SeamlessM4TFeatureExtractor</a> class or the
<a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TProcessor">SeamlessM4TProcessor</a> class. See <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TFeatureExtractor.__call__">SeamlessM4TFeatureExtractor.<strong>call</strong>()</a> for details.`,name:"input_features"},{anchor:"transformers.SeamlessM4Tv2Model.generate.return_intermediate_token_ids",description:`<strong>return_intermediate_token_ids</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, also returns the intermediate generated text and unit tokens. Set to <code>True</code> if you also want
to get translated text alongside the audio. Note that if <code>generate_speech=True</code>, this parameter will be
ignored.`,name:"return_intermediate_token_ids"},{anchor:"transformers.SeamlessM4Tv2Model.generate.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The language to use as target language for translation.`,name:"tgt_lang"},{anchor:"transformers.SeamlessM4Tv2Model.generate.speaker_id",description:`<strong>speaker_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The id of the speaker used for speech synthesis. Must be lower than <code>config.vocoder_num_spkrs</code>.`,name:"speaker_id"},{anchor:"transformers.SeamlessM4Tv2Model.generate.generate_speech",description:`<strong>generate_speech</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If <code>False</code>, will only returns the text tokens and won&#x2019;t generate speech.`,name:"generate_speech"},{anchor:"transformers.SeamlessM4Tv2Model.generate.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Remaining dictioy of keyword arguments that will be passed to <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">GenerationMixin.generate()</a>. Keyword
arguments are of two types:</p>
<ul>
<li>Without a prefix, they will be entered as <code>**kwargs</code> for the <code>generate</code> method of each sub-model,
except for <code>decoder_input_ids</code> which will only be passed through the text components.</li>
<li>With a <em>text_</em> or <em>speech_</em> prefix, they will be input for the <code>generate</code> method of the
text model and speech model respectively. It has the priority over the keywords without a prefix.</li>
</ul>
<p>This means you can, for example, specify a generation strategy for one generation but not for the
other.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/seamless_m4t_v2/modeling_seamless_m4t_v2.py#L4293",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>If <code>generate_speech</code> and <code>return_intermediate_token_ids</code>, returns <code>SeamlessM4Tv2GenerationOutput</code>.</li>
<li>If <code>generate_speech</code> and not <code>return_intermediate_token_ids</code>, returns a tuple composed of waveforms of
shape <code>(batch_size, sequence_length)</code> and <code>waveform_lengths</code> which gives the length of each sample.</li>
<li>If <code>generate_speech=False</code>, it will returns <code>ModelOutput</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[SeamlessM4Tv2GenerationOutput, Tuple[Tensor], ModelOutput]</code></p>
`}}),oe=new zt({props:{$$slots:{default:[la]},$$scope:{ctx:k}}}),pt=new S({props:{title:"SeamlessM4Tv2ForTextToSpeech",local:"transformers.SeamlessM4Tv2ForTextToSpeech",headingTag:"h2"}}),ht=new P({props:{name:"class transformers.SeamlessM4Tv2ForTextToSpeech",anchor:"transformers.SeamlessM4Tv2ForTextToSpeech",parameters:[{name:"config",val:": SeamlessM4Tv2Config"}],parametersDescription:[{anchor:"transformers.SeamlessM4Tv2ForTextToSpeech.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Config">SeamlessM4Tv2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/seamless_m4t_v2/modeling_seamless_m4t_v2.py#L3298"}}),ut=new P({props:{name:"generate",anchor:"transformers.SeamlessM4Tv2ForTextToSpeech.generate",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"return_intermediate_token_ids",val:": typing.Optional[bool] = None"},{name:"tgt_lang",val:": typing.Optional[str] = None"},{name:"speaker_id",val:": typing.Optional[int] = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SeamlessM4Tv2ForTextToSpeech.generate.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TTokenizer">SeamlessM4TTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TProcessor">SeamlessM4TProcessor</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SeamlessM4Tv2ForTextToSpeech.generate.return_intermediate_token_ids",description:`<strong>return_intermediate_token_ids</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, also returns the intermediate generated text and unit tokens. Set to <code>True</code> if you also want
to get translated text alongside the audio.`,name:"return_intermediate_token_ids"},{anchor:"transformers.SeamlessM4Tv2ForTextToSpeech.generate.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The language to use as target language for translation.`,name:"tgt_lang"},{anchor:"transformers.SeamlessM4Tv2ForTextToSpeech.generate.speaker_id",description:`<strong>speaker_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The id of the speaker used for speech synthesis. Must be lower than <code>config.vocoder_num_spkrs</code>.`,name:"speaker_id"},{anchor:"transformers.SeamlessM4Tv2ForTextToSpeech.generate.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Remaining dictionary of keyword arguments that will be passed to <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">GenerationMixin.generate()</a>. Keyword
arguments are of two types:</p>
<ul>
<li>Without a prefix, they will be entered as <code>**kwargs</code> for the <code>generate</code> method of each sub-model,
except for <code>decoder_input_ids</code> which will only be passed through the text components.</li>
<li>With a <em>text_</em> or <em>speech_</em> prefix, they will be input for the <code>generate</code> method of the
text model and speech model respectively. It has the priority over the keywords without a prefix.</li>
</ul>
<p>This means you can, for example, specify a generation strategy for one generation but not for the
other.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/seamless_m4t_v2/modeling_seamless_m4t_v2.py#L3466",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>If <code>return_intermediate_token_ids</code>, returns <code>SeamlessM4Tv2GenerationOutput</code>.</li>
<li>If not <code>return_intermediate_token_ids</code>, returns a tuple composed of waveforms of shape <code>(batch_size, sequence_length)</code> and <code>waveform_lengths</code> which gives the length of each sample.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[SeamlessM4Tv2GenerationOutput, Tuple[Tensor]]</code></p>
`}}),ne=new zt({props:{$$slots:{default:[da]},$$scope:{ctx:k}}}),ft=new S({props:{title:"SeamlessM4Tv2ForSpeechToSpeech",local:"transformers.SeamlessM4Tv2ForSpeechToSpeech",headingTag:"h2"}}),gt=new P({props:{name:"class transformers.SeamlessM4Tv2ForSpeechToSpeech",anchor:"transformers.SeamlessM4Tv2ForSpeechToSpeech",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SeamlessM4Tv2ForSpeechToSpeech.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2ForSpeechToSpeech">SeamlessM4Tv2ForSpeechToSpeech</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/seamless_m4t_v2/modeling_seamless_m4t_v2.py#L3676"}}),_t=new P({props:{name:"generate",anchor:"transformers.SeamlessM4Tv2ForSpeechToSpeech.generate",parameters:[{name:"input_features",val:": typing.Optional[torch.Tensor] = None"},{name:"return_intermediate_token_ids",val:": typing.Optional[bool] = None"},{name:"tgt_lang",val:": typing.Optional[str] = None"},{name:"speaker_id",val:": typing.Optional[int] = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SeamlessM4Tv2ForSpeechToSpeech.generate.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, num_banks)</code>) &#x2014;
Input audio features. This should be returned by the <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TFeatureExtractor">SeamlessM4TFeatureExtractor</a> class or the
<a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TProcessor">SeamlessM4TProcessor</a> class. See <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TFeatureExtractor.__call__">SeamlessM4TFeatureExtractor.<strong>call</strong>()</a> for details.`,name:"input_features"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToSpeech.generate.return_intermediate_token_ids",description:`<strong>return_intermediate_token_ids</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, also returns the intermediate generated text and unit tokens. Set to <code>True</code> if you also want
to get translated text alongside the audio.`,name:"return_intermediate_token_ids"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToSpeech.generate.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The language to use as target language for translation.`,name:"tgt_lang"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToSpeech.generate.speaker_id",description:`<strong>speaker_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The id of the speaker used for speech synthesis. Must be lower than <code>config.vocoder_num_spkrs</code>.`,name:"speaker_id"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToSpeech.generate.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Remaining dictionary of keyword arguments that will be passed to <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">GenerationMixin.generate()</a>. Keyword
arguments are of two types:</p>
<ul>
<li>Without a prefix, they will be entered as <code>**kwargs</code> for the <code>generate</code> method of each sub-model,
except for <code>decoder_input_ids</code> which will only be passed through the text components.</li>
<li>With a <em>text_</em> or <em>speech_</em> prefix, they will be input for the <code>generate</code> method of the
text model and speech model respectively. It has the priority over the keywords without a prefix.</li>
</ul>
<p>This means you can, for example, specify a generation strategy for one generation but not for the
other.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/seamless_m4t_v2/modeling_seamless_m4t_v2.py#L3847",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>If <code>return_intermediate_token_ids</code>, returns <code>SeamlessM4Tv2GenerationOutput</code>.</li>
<li>If not <code>return_intermediate_token_ids</code>, returns a tuple composed of waveforms of shape <code>(batch_size, sequence_length)</code> and <code>waveform_lengths</code> which gives the length of each sample.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[SeamlessM4Tv2GenerationOutput, Tuple[Tensor]]</code></p>
`}}),se=new zt({props:{$$slots:{default:[ca]},$$scope:{ctx:k}}}),Tt=new S({props:{title:"SeamlessM4Tv2ForTextToText",local:"transformers.SeamlessM4Tv2ForTextToText",headingTag:"h2"}}),vt=new P({props:{name:"class transformers.SeamlessM4Tv2ForTextToText",anchor:"transformers.SeamlessM4Tv2ForTextToText",parameters:[{name:"config",val:": SeamlessM4Tv2Config"}],parametersDescription:[{anchor:"transformers.SeamlessM4Tv2ForTextToText.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Config">SeamlessM4Tv2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/seamless_m4t_v2/modeling_seamless_m4t_v2.py#L2736"}}),bt=new P({props:{name:"forward",anchor:"transformers.SeamlessM4Tv2ForTextToText.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SeamlessM4Tv2ForTextToText.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SeamlessM4Tv2ForTextToText.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SeamlessM4Tv2ForTextToText.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>Bart uses the <code>eos_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code>
is used, optionally only the last <code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>).</p>
<p>For translation and summarization training, <code>decoder_input_ids</code> should be provided. If no
<code>decoder_input_ids</code> is provided, the model will create this tensor by shifting the <code>input_ids</code> to the right
for denoising pre-training following the paper.`,name:"decoder_input_ids"},{anchor:"transformers.SeamlessM4Tv2ForTextToText.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.</p>
<p>If you want to change padding behavior, you should read <code>modeling_bart._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.`,name:"decoder_attention_mask"},{anchor:"transformers.SeamlessM4Tv2ForTextToText.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.SeamlessM4Tv2ForTextToText.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.SeamlessM4Tv2ForTextToText.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape<code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SeamlessM4Tv2ForTextToText.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.SeamlessM4Tv2ForTextToText.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.SeamlessM4Tv2ForTextToText.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.SeamlessM4Tv2ForTextToText.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SeamlessM4Tv2ForTextToText.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SeamlessM4Tv2ForTextToText.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/seamless_m4t_v2/modeling_seamless_m4t_v2.py#L2790",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Config"
>SeamlessM4Tv2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ae=new zt({props:{$$slots:{default:[ma]},$$scope:{ctx:k}}}),re=new ts({props:{anchor:"transformers.SeamlessM4Tv2ForTextToText.forward.example",$$slots:{default:[pa]},$$scope:{ctx:k}}}),yt=new P({props:{name:"generate",anchor:"transformers.SeamlessM4Tv2ForTextToText.generate",parameters:[{name:"input_ids",val:" = None"},{name:"tgt_lang",val:" = None"},{name:"generation_config",val:" = None"},{name:"logits_processor",val:" = None"},{name:"stopping_criteria",val:" = None"},{name:"prefix_allowed_tokens_fn",val:" = None"},{name:"synced_gpus",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SeamlessM4Tv2ForTextToText.generate.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TTokenizer">SeamlessM4TTokenizer</a> or <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TProcessor">SeamlessM4TProcessor</a>. See
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SeamlessM4Tv2ForTextToText.generate.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The language to use as target language for translation.`,name:"tgt_lang"},{anchor:"transformers.SeamlessM4Tv2ForTextToText.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.SeamlessM4Tv2ForTextToText.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.SeamlessM4Tv2ForTextToText.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complement the default stopping criteria built from arguments and a
generation config. If a stopping criteria is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.SeamlessM4Tv2ForTextToText.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.SeamlessM4Tv2ForTextToText.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed to avoid deadlocking with
<code>FullyShardedDataParallel</code> and DeepSpeed ZeRO Stage 3).`,name:"synced_gpus"},{anchor:"transformers.SeamlessM4Tv2ForTextToText.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/seamless_m4t_v2/modeling_seamless_m4t_v2.py#L2888",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.FloatTensor</code>. The possible
<a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateEncoderDecoderOutput"
>GenerateEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateBeamEncoderDecoderOutput"
>GenerateBeamEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),ie=new zt({props:{warning:!0,$$slots:{default:[ha]},$$scope:{ctx:k}}}),Mt=new S({props:{title:"SeamlessM4Tv2ForSpeechToText",local:"transformers.SeamlessM4Tv2ForSpeechToText",headingTag:"h2"}}),xt=new P({props:{name:"class transformers.SeamlessM4Tv2ForSpeechToText",anchor:"transformers.SeamlessM4Tv2ForSpeechToText",parameters:[{name:"config",val:": SeamlessM4Tv2Config"}],parametersDescription:[{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Config">SeamlessM4Tv2Config</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/seamless_m4t_v2/modeling_seamless_m4t_v2.py#L3010"}}),wt=new P({props:{name:"forward",anchor:"transformers.SeamlessM4Tv2ForSpeechToText.forward",parameters:[{name:"input_features",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.forward.input_features",description:`<strong>input_features</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, num_banks)</code>) &#x2014;
Input audio features. This should be returned by the <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TFeatureExtractor">SeamlessM4TFeatureExtractor</a> class or the
<a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TProcessor">SeamlessM4TProcessor</a> class. See <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TFeatureExtractor.__call__">SeamlessM4TFeatureExtractor.<strong>call</strong>()</a> for details.`,name:"input_features"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>Bart uses the <code>eos_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code>
is used, optionally only the last <code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>).</p>
<p>For translation and summarization training, <code>decoder_input_ids</code> should be provided. If no
<code>decoder_input_ids</code> is provided, the model will create this tensor by shifting the <code>input_ids</code> to the right
for denoising pre-training following the paper.`,name:"decoder_input_ids"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.</p>
<p>If you want to change padding behavior, you should read <code>modeling_bart._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.`,name:"decoder_attention_mask"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape<code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/seamless_m4t_v2/modeling_seamless_m4t_v2.py#L3066",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Config"
>SeamlessM4Tv2Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),le=new zt({props:{$$slots:{default:[ua]},$$scope:{ctx:k}}}),de=new ts({props:{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.forward.example",$$slots:{default:[fa]},$$scope:{ctx:k}}}),kt=new P({props:{name:"generate",anchor:"transformers.SeamlessM4Tv2ForSpeechToText.generate",parameters:[{name:"input_features",val:" = None"},{name:"tgt_lang",val:" = None"},{name:"generation_config",val:" = None"},{name:"logits_processor",val:" = None"},{name:"stopping_criteria",val:" = None"},{name:"prefix_allowed_tokens_fn",val:" = None"},{name:"synced_gpus",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.generate.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, num_banks)</code>) &#x2014;
Input audio features. This should be returned by the <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TFeatureExtractor">SeamlessM4TFeatureExtractor</a> class or the
<a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TProcessor">SeamlessM4TProcessor</a> class. See <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TFeatureExtractor.__call__">SeamlessM4TFeatureExtractor.<strong>call</strong>()</a> for details.`,name:"input_features"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.generate.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The language to use as target language for translation.`,name:"tgt_lang"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complement the default stopping criteria built from arguments and a
generation config. If a stopping criteria is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed to avoid deadlocking with
<code>FullyShardedDataParallel</code> and DeepSpeed ZeRO Stage 3).`,name:"synced_gpus"},{anchor:"transformers.SeamlessM4Tv2ForSpeechToText.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/seamless_m4t_v2/modeling_seamless_m4t_v2.py#L3173",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.FloatTensor</code>. The possible
<a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateEncoderDecoderOutput"
>GenerateEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateBeamEncoderDecoderOutput"
>GenerateBeamEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),ce=new zt({props:{warning:!0,$$slots:{default:[ga]},$$scope:{ctx:k}}}),St=new S({props:{title:"SeamlessM4Tv2Config",local:"transformers.SeamlessM4Tv2Config",headingTag:"h2"}}),$t=new P({props:{name:"class transformers.SeamlessM4Tv2Config",anchor:"transformers.SeamlessM4Tv2Config",parameters:[{name:"vocab_size",val:" = 256102"},{name:"t2u_vocab_size",val:" = 10082"},{name:"char_vocab_size",val:" = 10943"},{name:"hidden_size",val:" = 1024"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"max_position_embeddings",val:" = 4096"},{name:"is_encoder_decoder",val:" = True"},{name:"encoder_layerdrop",val:" = 0.05"},{name:"decoder_layerdrop",val:" = 0.05"},{name:"activation_function",val:" = 'relu'"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.1"},{name:"activation_dropout",val:" = 0.0"},{name:"scale_embedding",val:" = True"},{name:"encoder_layers",val:" = 24"},{name:"encoder_ffn_dim",val:" = 8192"},{name:"encoder_attention_heads",val:" = 16"},{name:"decoder_layers",val:" = 24"},{name:"decoder_ffn_dim",val:" = 8192"},{name:"decoder_attention_heads",val:" = 16"},{name:"decoder_start_token_id",val:" = 3"},{name:"max_new_tokens",val:" = 256"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 2"},{name:"eos_token_id",val:" = 3"},{name:"speech_encoder_layers",val:" = 24"},{name:"speech_encoder_attention_heads",val:" = 16"},{name:"speech_encoder_intermediate_size",val:" = 4096"},{name:"speech_encoder_hidden_act",val:" = 'swish'"},{name:"speech_encoder_dropout",val:" = 0.0"},{name:"add_adapter",val:" = True"},{name:"speech_encoder_layerdrop",val:" = 0.1"},{name:"feature_projection_input_dim",val:" = 160"},{name:"adaptor_kernel_size",val:" = 8"},{name:"adaptor_stride",val:" = 8"},{name:"adaptor_dropout",val:" = 0.1"},{name:"num_adapter_layers",val:" = 1"},{name:"position_embeddings_type",val:" = 'relative_key'"},{name:"conv_depthwise_kernel_size",val:" = 31"},{name:"left_max_position_embeddings",val:" = 64"},{name:"right_max_position_embeddings",val:" = 8"},{name:"speech_encoder_chunk_size",val:" = 20000"},{name:"speech_encoder_left_chunk_num",val:" = 128"},{name:"t2u_bos_token_id",val:" = 0"},{name:"t2u_pad_token_id",val:" = 1"},{name:"t2u_eos_token_id",val:" = 2"},{name:"t2u_encoder_layers",val:" = 6"},{name:"t2u_encoder_ffn_dim",val:" = 8192"},{name:"t2u_encoder_attention_heads",val:" = 16"},{name:"t2u_decoder_layers",val:" = 6"},{name:"t2u_decoder_ffn_dim",val:" = 8192"},{name:"t2u_decoder_attention_heads",val:" = 16"},{name:"t2u_max_position_embeddings",val:" = 4096"},{name:"t2u_variance_predictor_embed_dim",val:" = 1024"},{name:"t2u_variance_predictor_hidden_dim",val:" = 256"},{name:"t2u_variance_predictor_kernel_size",val:" = 3"},{name:"t2u_variance_pred_dropout",val:" = 0.5"},{name:"sampling_rate",val:" = 16000"},{name:"upsample_initial_channel",val:" = 512"},{name:"upsample_rates",val:" = [5, 4, 4, 2, 2]"},{name:"upsample_kernel_sizes",val:" = [11, 8, 8, 4, 4]"},{name:"resblock_kernel_sizes",val:" = [3, 7, 11]"},{name:"resblock_dilation_sizes",val:" = [[1, 3, 5], [1, 3, 5], [1, 3, 5]]"},{name:"leaky_relu_slope",val:" = 0.1"},{name:"unit_hifi_gan_vocab_size",val:" = 10000"},{name:"unit_embed_dim",val:" = 1280"},{name:"lang_embed_dim",val:" = 256"},{name:"spkr_embed_dim",val:" = 256"},{name:"vocoder_num_langs",val:" = 36"},{name:"vocoder_num_spkrs",val:" = 200"},{name:"variance_predictor_kernel_size",val:" = 3"},{name:"var_pred_dropout",val:" = 0.5"},{name:"vocoder_offset",val:" = 4"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SeamlessM4Tv2Config.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256102) &#x2014;
Vocabulary size of the text modality of the SeamlessM4Tv2 model. Defines the number of different tokens
that can be represented by the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Model">~SeamlessM4Tv2Model</a>,
<a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2ForTextToSpeech">~SeamlessM4Tv2ForTextToSpeech</a> or <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2ForTextToText">~SeamlessM4Tv2ForTextToText</a>.`,name:"vocab_size"},{anchor:"transformers.SeamlessM4Tv2Config.t2u_vocab_size",description:`<strong>t2u_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 10082) &#x2014;
Unit vocabulary size of the SeamlessM4Tv2 model. Defines the number of different &#x201C;unit tokens&#x201D; that can be
represented by the <code>inputs_ids</code> passed when calling the Text-To-Units sub-model of <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Model">~SeamlessM4Tv2Model</a>,
<a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2ForSpeechToSpeech">~SeamlessM4Tv2ForSpeechToSpeech</a> or <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2ForTextToSpeech">~SeamlessM4Tv2ForTextToSpeech</a>.`,name:"t2u_vocab_size"},{anchor:"transformers.SeamlessM4Tv2Config.char_vocab_size",description:`<strong>char_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 10943) &#x2014;
Character vocabulary size of the SeamlessM4Tv2 model. Defines the number of different character tokens that
can be represented by the <code>char_inputs_ids</code> passed when calling the Text-To-Units sub-model of
<a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Model">~SeamlessM4Tv2Model</a>, <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2ForSpeechToSpeech">~SeamlessM4Tv2ForSpeechToSpeech</a> or <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2ForTextToSpeech">~SeamlessM4Tv2ForTextToSpeech</a>.`,name:"char_vocab_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/seamless_m4t_v2/configuration_seamless_m4t_v2.py#L24",parameterGroups:[{title:"Parameters shared across sub-models",parametersDescription:[{anchor:"transformers.SeamlessM4Tv2Config.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; layers in the architecture.`,name:"hidden_size"},{anchor:"transformers.SeamlessM4Tv2Config.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.SeamlessM4Tv2Config.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.SeamlessM4Tv2Config.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.SeamlessM4Tv2Config.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
The maximum sequence length that this model text encoder and decoder might ever be used with. Typically set
this to something large just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.SeamlessM4Tv2Config.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model is used as an encoder/decoder or not.`,name:"is_encoder_decoder"},{anchor:"transformers.SeamlessM4Tv2Config.encoder_layerdrop",description:`<strong>encoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.05) &#x2014;
The LayerDrop probability for the encoders. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"encoder_layerdrop"},{anchor:"transformers.SeamlessM4Tv2Config.decoder_layerdrop",description:`<strong>decoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.05) &#x2014;
The LayerDrop probability for the decoders. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"decoder_layerdrop"},{anchor:"transformers.SeamlessM4Tv2Config.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder and feed-forward layers. If string,
<code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code>, <code>&quot;swish&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.SeamlessM4Tv2Config.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, decoder, and pooler.`,name:"dropout"},{anchor:"transformers.SeamlessM4Tv2Config.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all attention layers.`,name:"attention_dropout"},{anchor:"transformers.SeamlessM4Tv2Config.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all activation layers in the model.`,name:"activation_dropout"},{anchor:"transformers.SeamlessM4Tv2Config.scale_embedding",description:`<strong>scale_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Scale embeddings by diving by sqrt(d_model).`,name:"scale_embedding"}]},{title:"Text encoder and text decoder specific parameters",parametersDescription:[{anchor:"transformers.SeamlessM4Tv2Config.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of hidden layers in the Transformer text encoder.`,name:"encoder_layers"},{anchor:"transformers.SeamlessM4Tv2Config.encoder_ffn_dim",description:`<strong>encoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer text encoder.`,name:"encoder_ffn_dim"},{anchor:"transformers.SeamlessM4Tv2Config.encoder_attention_heads",description:`<strong>encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer text encoder.`,name:"encoder_attention_heads"},{anchor:"transformers.SeamlessM4Tv2Config.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of hidden layers in the Transformer text decoder.`,name:"decoder_layers"},{anchor:"transformers.SeamlessM4Tv2Config.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer text decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.SeamlessM4Tv2Config.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer text decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.SeamlessM4Tv2Config.decoder_start_token_id",description:`<strong>decoder_start_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
If an encoder-decoder model starts decoding with a different token than <em>bos</em>, the id of that token. Only
applied in the text decoder.`,name:"decoder_start_token_id"},{anchor:"transformers.SeamlessM4Tv2Config.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The maximum numbers of text tokens to generate, ignoring the number of tokens in the prompt.`,name:"max_new_tokens"},{anchor:"transformers.SeamlessM4Tv2Config.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The id of the <em>padding</em> text token. Only applied to the text-decoder model.`,name:"pad_token_id"},{anchor:"transformers.SeamlessM4Tv2Config.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The id of the <em>beginning-of-stream</em> text token. Only applied to the text-decoder model.`,name:"bos_token_id"},{anchor:"transformers.SeamlessM4Tv2Config.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The id of the <em>end-of-stream</em> text token. Only applied to the text-decoder model.`,name:"eos_token_id"}]},{title:"Speech encoder specific parameters",parametersDescription:[{anchor:"transformers.SeamlessM4Tv2Config.speech_encoder_layers",description:`<strong>speech_encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of hidden layers in the Transformer speech encoder.`,name:"speech_encoder_layers"},{anchor:"transformers.SeamlessM4Tv2Config.speech_encoder_attention_heads",description:`<strong>speech_encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer speech encoder.`,name:"speech_encoder_attention_heads"},{anchor:"transformers.SeamlessM4Tv2Config.speech_encoder_intermediate_size",description:`<strong>speech_encoder_intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer speech encoder.`,name:"speech_encoder_intermediate_size"},{anchor:"transformers.SeamlessM4Tv2Config.speech_encoder_hidden_act",description:`<strong>speech_encoder_hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;swish&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the speech encoder. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code>, <code>&quot;swish&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"speech_encoder_hidden_act"},{anchor:"transformers.SeamlessM4Tv2Config.speech_encoder_dropout",description:`<strong>speech_encoder_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all layers in the speech encoder.`,name:"speech_encoder_dropout"},{anchor:"transformers.SeamlessM4Tv2Config.add_adapter",description:`<strong>add_adapter</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Add an adapter layer on top of the speech encoder.`,name:"add_adapter"},{anchor:"transformers.SeamlessM4Tv2Config.speech_encoder_layerdrop",description:`<strong>speech_encoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The LayerDrop probability for the speech encoder. See the [LayerDrop paper](see
<a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>) for more details.`,name:"speech_encoder_layerdrop"},{anchor:"transformers.SeamlessM4Tv2Config.feature_projection_input_dim",description:`<strong>feature_projection_input_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 160) &#x2014;
Input dimension of the input feature projection of the speech encoder, i.e the dimension after processing
input audios with <a href="/docs/transformers/main/en/model_doc/seamless_m4t#transformers.SeamlessM4TFeatureExtractor">SeamlessM4TFeatureExtractor</a>.`,name:"feature_projection_input_dim"},{anchor:"transformers.SeamlessM4Tv2Config.adaptor_kernel_size",description:`<strong>adaptor_kernel_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Kernel size of the convolutional layers in the adapter network. Only relevant if <code>add_adapter is True</code>.`,name:"adaptor_kernel_size"},{anchor:"transformers.SeamlessM4Tv2Config.adaptor_stride",description:`<strong>adaptor_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Stride of the convolutional layers in the adapter network. Only relevant if <code>add_adapter is True</code>.`,name:"adaptor_stride"},{anchor:"transformers.SeamlessM4Tv2Config.adaptor_dropout",description:`<strong>adaptor_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all layers in the speech adapter.`,name:"adaptor_dropout"},{anchor:"transformers.SeamlessM4Tv2Config.num_adapter_layers",description:`<strong>num_adapter_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of convolutional layers that should be used in the adapter network. Only relevant if <code>add_adapter is True</code>.`,name:"num_adapter_layers"},{anchor:"transformers.SeamlessM4Tv2Config.position_embeddings_type",description:`<strong>position_embeddings_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relative_key&quot;</code>) &#x2014;
Can be specified to <code>relative_key</code>. If left to <code>None</code>, no relative position embedding is applied. Only
applied to the speech encoder. For more information on <code>&quot;relative_key&quot;</code>, please refer to <a href="https://arxiv.org/abs/1803.02155" rel="nofollow">Self-Attention
with Relative Position Representations (Shaw et al.)</a>.`,name:"position_embeddings_type"},{anchor:"transformers.SeamlessM4Tv2Config.conv_depthwise_kernel_size",description:`<strong>conv_depthwise_kernel_size</strong> (<code>int</code>, <em>optional</em>, defaults to 31) &#x2014;
Kernel size of convolutional depthwise 1D layer in Conformer blocks. Only applied to the speech encoder.`,name:"conv_depthwise_kernel_size"},{anchor:"transformers.SeamlessM4Tv2Config.left_max_position_embeddings",description:`<strong>left_max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The left clipping value for relative positions.`,name:"left_max_position_embeddings"},{anchor:"transformers.SeamlessM4Tv2Config.right_max_position_embeddings",description:`<strong>right_max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The right clipping value for relative positions.`,name:"right_max_position_embeddings"},{anchor:"transformers.SeamlessM4Tv2Config.speech_encoder_chunk_size",description:"<strong>speech_encoder_chunk_size</strong> (<code>int</code>, <em>optional</em>, defaults to 20000) &#x2014; The size of each attention chunk.",name:"speech_encoder_chunk_size"},{anchor:"transformers.SeamlessM4Tv2Config.speech_encoder_left_chunk_num",description:`<strong>speech_encoder_left_chunk_num</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Number of chunks on the left up to which lookahead is allowed.`,name:"speech_encoder_left_chunk_num"}]},{title:"Text-To-Unit (t2u) model specific parameters",parametersDescription:[{anchor:"transformers.SeamlessM4Tv2Config.t2u_bos_token_id",description:`<strong>t2u_bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The id of the <em>beginning-of-stream</em> unit token. Only applied to the text-to-unit seq2seq model.`,name:"t2u_bos_token_id"},{anchor:"transformers.SeamlessM4Tv2Config.t2u_pad_token_id",description:`<strong>t2u_pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The id of the <em>padding</em> unit token. Only applied to the text-to-unit seq2seq model.`,name:"t2u_pad_token_id"},{anchor:"transformers.SeamlessM4Tv2Config.t2u_eos_token_id",description:`<strong>t2u_eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The id of the <em>end-of-stream</em> unit token. Only applied to the text-to-unit seq2seq model.`,name:"t2u_eos_token_id"},{anchor:"transformers.SeamlessM4Tv2Config.t2u_encoder_layers",description:`<strong>t2u_encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of hidden layers in the Transformer text-to-unit encoder.`,name:"t2u_encoder_layers"},{anchor:"transformers.SeamlessM4Tv2Config.t2u_encoder_ffn_dim",description:`<strong>t2u_encoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer text-to-unit encoder.`,name:"t2u_encoder_ffn_dim"},{anchor:"transformers.SeamlessM4Tv2Config.t2u_encoder_attention_heads",description:`<strong>t2u_encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer text-to-unit encoder.`,name:"t2u_encoder_attention_heads"},{anchor:"transformers.SeamlessM4Tv2Config.t2u_decoder_layers",description:`<strong>t2u_decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of hidden layers in the Transformer text-to-unit decoder.`,name:"t2u_decoder_layers"},{anchor:"transformers.SeamlessM4Tv2Config.t2u_decoder_ffn_dim",description:`<strong>t2u_decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer text-to-unit decoder.`,name:"t2u_decoder_ffn_dim"},{anchor:"transformers.SeamlessM4Tv2Config.t2u_decoder_attention_heads",description:`<strong>t2u_decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer text-to-unit decoder.`,name:"t2u_decoder_attention_heads"},{anchor:"transformers.SeamlessM4Tv2Config.t2u_max_position_embeddings",description:`<strong>t2u_max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
The maximum sequence length that this model text-to-unit component might ever be used with. Typically set
this to something large just in case (e.g., 512 or 1024 or 2048).`,name:"t2u_max_position_embeddings"},{anchor:"transformers.SeamlessM4Tv2Config.t2u_variance_predictor_embed_dim",description:`<strong>t2u_variance_predictor_embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The projection dimension of the text-to-unit&#x2019;s duration predictor.`,name:"t2u_variance_predictor_embed_dim"},{anchor:"transformers.SeamlessM4Tv2Config.t2u_variance_predictor_hidden_dim",description:`<strong>t2u_variance_predictor_hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Internal dimension of the text-to-unit&#x2019;s duration predictor.`,name:"t2u_variance_predictor_hidden_dim"},{anchor:"transformers.SeamlessM4Tv2Config.t2u_variance_predictor_kernel_size",description:`<strong>t2u_variance_predictor_kernel_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Kernel size of the convolutional layers of the text-to-unit&#x2019;s duration predictor.`,name:"t2u_variance_predictor_kernel_size"},{anchor:"transformers.SeamlessM4Tv2Config.t2u_variance_pred_dropout",description:`<strong>t2u_variance_pred_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The dropout probability of the text-to-unit&#x2019;s duration predictor.</p>
<blockquote>
<p>Hifi-Gan Vocoder specific parameters</p>
</blockquote>`,name:"t2u_variance_pred_dropout"},{anchor:"transformers.SeamlessM4Tv2Config.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 16000) &#x2014;
The sampling rate at which the output audio will be generated, expressed in hertz (Hz).`,name:"sampling_rate"},{anchor:"transformers.SeamlessM4Tv2Config.upsample_initial_channel",description:`<strong>upsample_initial_channel</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The number of input channels into the hifi-gan upsampling network. Applies to the vocoder only.`,name:"upsample_initial_channel"},{anchor:"transformers.SeamlessM4Tv2Config.upsample_rates",description:`<strong>upsample_rates</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>[5, 4, 4, 2, 2]</code>) &#x2014;
A tuple of integers defining the stride of each 1D convolutional layer in the vocoder upsampling network.
The length of <em>upsample_rates</em> defines the number of convolutional layers and has to match the length of
<em>upsample_kernel_sizes</em>. Applies to the vocoder only.`,name:"upsample_rates"},{anchor:"transformers.SeamlessM4Tv2Config.upsample_kernel_sizes",description:`<strong>upsample_kernel_sizes</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>[11, 8, 8, 4, 4]</code>) &#x2014;
A tuple of integers defining the kernel size of each 1D convolutional layer in the vocoder upsampling
network. The length of <em>upsample_kernel_sizes</em> defines the number of convolutional layers and has to match
the length of <em>upsample_rates</em>. Applies to the vocoder only.`,name:"upsample_kernel_sizes"},{anchor:"transformers.SeamlessM4Tv2Config.resblock_kernel_sizes",description:`<strong>resblock_kernel_sizes</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 7, 11]</code>) &#x2014;
A tuple of integers defining the kernel sizes of the vocoder 1D convolutional layers in the multi-receptive
field fusion (MRF) module. Applies to the vocoder only.`,name:"resblock_kernel_sizes"},{anchor:"transformers.SeamlessM4Tv2Config.resblock_dilation_sizes",description:`<strong>resblock_dilation_sizes</strong> (<code>Tuple[Tuple[int]]</code> or <code>List[List[int]]</code>, <em>optional</em>, defaults to <code>[[1, 3, 5], [1, 3, 5], [1, 3, 5]]</code>) &#x2014;
A nested tuple of integers defining the dilation rates of the vocoder dilated 1D convolutional layers in
the multi-receptive field fusion (MRF) module. Applies to the vocoder only.`,name:"resblock_dilation_sizes"},{anchor:"transformers.SeamlessM4Tv2Config.leaky_relu_slope",description:`<strong>leaky_relu_slope</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The angle of the negative slope used by the leaky ReLU activation in the vocoder. Applies to the vocoder
only.`,name:"leaky_relu_slope"},{anchor:"transformers.SeamlessM4Tv2Config.unit_hifi_gan_vocab_size",description:`<strong>unit_hifi_gan_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 10000) &#x2014;
Vocabulary size of the SeamlessM4Tv2 vocoder. Defines the number of different unit tokens that can be
represented by the <code>inputs_ids</code> passed when calling the vocoder of <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2Model">~SeamlessM4Tv2Model</a>,
<a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2ForSpeechToSpeech">~SeamlessM4Tv2ForSpeechToSpeech</a> or <a href="/docs/transformers/main/en/model_doc/seamless_m4t_v2#transformers.SeamlessM4Tv2ForTextToSpeech">~SeamlessM4Tv2ForTextToSpeech</a>.`,name:"unit_hifi_gan_vocab_size"},{anchor:"transformers.SeamlessM4Tv2Config.unit_embed_dim",description:`<strong>unit_embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1280) &#x2014;
The projection dimension of the input ids given to the hifi-gan vocoder. Applies to the vocoder only.`,name:"unit_embed_dim"},{anchor:"transformers.SeamlessM4Tv2Config.lang_embed_dim",description:`<strong>lang_embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The projection dimension of the target language given to the hifi-gan vocoder. Applies to the vocoder only.`,name:"lang_embed_dim"},{anchor:"transformers.SeamlessM4Tv2Config.spkr_embed_dim",description:`<strong>spkr_embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The projection dimension of the speaker id given to the hifi-gan vocoder. Applies to the vocoder only.`,name:"spkr_embed_dim"},{anchor:"transformers.SeamlessM4Tv2Config.vocoder_num_langs",description:`<strong>vocoder_num_langs</strong> (<code>int</code>, <em>optional</em>, defaults to 36) &#x2014;
Number of langs supported by the vocoder. Might be different from <code>t2u_num_langs</code>.`,name:"vocoder_num_langs"},{anchor:"transformers.SeamlessM4Tv2Config.vocoder_num_spkrs",description:`<strong>vocoder_num_spkrs</strong> (<code>int</code>, <em>optional</em>, defaults to 200) &#x2014;
Number of speakers supported by the vocoder.`,name:"vocoder_num_spkrs"},{anchor:"transformers.SeamlessM4Tv2Config.variance_predictor_kernel_size",description:`<strong>variance_predictor_kernel_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Kernel size of the duration predictor. Applies to the vocoder only.`,name:"variance_predictor_kernel_size"},{anchor:"transformers.SeamlessM4Tv2Config.var_pred_dropout",description:`<strong>var_pred_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The dropout probability of the duration predictor. Applies to the vocoder only.`,name:"var_pred_dropout"},{anchor:"transformers.SeamlessM4Tv2Config.vocoder_offset",description:`<strong>vocoder_offset</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Offset the unit token ids by this number to account for symbol tokens. Applies to the vocoder only.`,name:"vocoder_offset"}]}]}}),me=new ts({props:{anchor:"transformers.SeamlessM4Tv2Config.example",$$slots:{default:[_a]},$$scope:{ctx:k}}}),Ct=new ia({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/seamless_m4t_v2.md"}}),{c(){r=i("meta"),M=s(),h=i("p"),p=s(),u(x.$$.fragment),m=s(),b=i("div"),b.innerHTML=R,y=s(),u(w.$$.fragment),oo=s(),ue=i("p"),ue.innerHTML=os,no=s(),fe=i("p"),fe.innerHTML=ns,so=s(),ge=i("p"),ge.textContent=ss,ao=s(),_e=i("ul"),_e.innerHTML=as,ro=s(),Te=i("p"),Te.innerHTML=rs,io=s(),ve=i("p"),ve.textContent=is,lo=s(),be=i("p"),be.innerHTML=ls,co=s(),u(ye.$$.fragment),mo=s(),Me=i("p"),Me.textContent=ds,po=s(),xe=i("p"),xe.textContent=cs,ho=s(),u(we.$$.fragment),uo=s(),ke=i("p"),ke.textContent=ms,fo=s(),Se=i("p"),Se.textContent=ps,go=s(),u($e.$$.fragment),_o=s(),u(Ce.$$.fragment),To=s(),ze=i("p"),ze.innerHTML=hs,vo=s(),u(Fe.$$.fragment),bo=s(),Je=i("p"),Je.textContent=us,yo=s(),u(je.$$.fragment),Mo=s(),Ie=i("p"),Ie.innerHTML=fs,xo=s(),u(qe.$$.fragment),wo=s(),u(Ue.$$.fragment),ko=s(),u(Le.$$.fragment),So=s(),Ne=i("p"),Ne.innerHTML=gs,$o=s(),u(He.$$.fragment),Co=s(),Ze=i("p"),Ze.innerHTML=_s,zo=s(),u(Pe.$$.fragment),Fo=s(),We=i("p"),We.innerHTML=Ts,Jo=s(),u(Ge.$$.fragment),jo=s(),Re=i("p"),Re.innerHTML=vs,Io=s(),u(Ve.$$.fragment),qo=s(),Be=i("p"),Be.innerHTML=bs,Uo=s(),u(Xe.$$.fragment),Lo=s(),Ee=i("p"),Ee.innerHTML=ys,No=s(),u(De.$$.fragment),Ho=s(),Oe=i("p"),Oe.textContent=Ms,Zo=s(),Ye=i("p"),Ye.innerHTML=xs,Po=s(),u(Ae.$$.fragment),Wo=s(),Qe=i("p"),Qe.textContent=ws,Go=s(),u(Ke.$$.fragment),Ro=s(),et=i("p"),et.innerHTML=ks,Vo=s(),tt=i("ul"),tt.innerHTML=Ss,Bo=s(),u(ot.$$.fragment),Xo=s(),nt=i("p"),nt.textContent=$s,Eo=s(),st=i("ul"),st.innerHTML=Cs,Do=s(),u(at.$$.fragment),Oo=s(),rt=i("p"),rt.textContent=zs,Yo=s(),it=i("ul"),it.innerHTML=Fs,Ao=s(),lt=i("p"),lt.innerHTML=Js,Qo=s(),u(dt.$$.fragment),Ko=s(),F=i("div"),u(ct.$$.fragment),un=s(),Ft=i("p"),Ft.textContent=js,fn=s(),Jt=i("p"),Jt.innerHTML=Is,gn=s(),jt=i("p"),jt.innerHTML=qs,_n=s(),B=i("div"),u(mt.$$.fragment),Tn=s(),It=i("p"),It.textContent=Us,vn=s(),u(oe.$$.fragment),en=s(),u(pt.$$.fragment),tn=s(),J=i("div"),u(ht.$$.fragment),bn=s(),qt=i("p"),qt.textContent=Ls,yn=s(),Ut=i("p"),Ut.innerHTML=Ns,Mn=s(),Lt=i("p"),Lt.innerHTML=Hs,xn=s(),X=i("div"),u(ut.$$.fragment),wn=s(),Nt=i("p"),Nt.textContent=Zs,kn=s(),u(ne.$$.fragment),on=s(),u(ft.$$.fragment),nn=s(),j=i("div"),u(gt.$$.fragment),Sn=s(),Ht=i("p"),Ht.textContent=Ps,$n=s(),Zt=i("p"),Zt.innerHTML=Ws,Cn=s(),Pt=i("p"),Pt.innerHTML=Gs,zn=s(),E=i("div"),u(_t.$$.fragment),Fn=s(),Wt=i("p"),Wt.textContent=Rs,Jn=s(),u(se.$$.fragment),sn=s(),u(Tt.$$.fragment),an=s(),$=i("div"),u(vt.$$.fragment),jn=s(),Gt=i("p"),Gt.textContent=Vs,In=s(),Rt=i("p"),Rt.innerHTML=Bs,qn=s(),Vt=i("p"),Vt.innerHTML=Xs,Un=s(),W=i("div"),u(bt.$$.fragment),Ln=s(),Bt=i("p"),Bt.innerHTML=Es,Nn=s(),u(ae.$$.fragment),Hn=s(),u(re.$$.fragment),Zn=s(),D=i("div"),u(yt.$$.fragment),Pn=s(),Xt=i("p"),Xt.textContent=Ds,Wn=s(),u(ie.$$.fragment),rn=s(),u(Mt.$$.fragment),ln=s(),C=i("div"),u(xt.$$.fragment),Gn=s(),Et=i("p"),Et.textContent=Os,Rn=s(),Dt=i("p"),Dt.innerHTML=Ys,Vn=s(),Ot=i("p"),Ot.innerHTML=As,Bn=s(),G=i("div"),u(wt.$$.fragment),Xn=s(),Yt=i("p"),Yt.innerHTML=Qs,En=s(),u(le.$$.fragment),Dn=s(),u(de.$$.fragment),On=s(),O=i("div"),u(kt.$$.fragment),Yn=s(),At=i("p"),At.textContent=Ks,An=s(),u(ce.$$.fragment),dn=s(),u(St.$$.fragment),cn=s(),L=i("div"),u($t.$$.fragment),Qn=s(),Qt=i("p"),Qt.innerHTML=ea,Kn=s(),Kt=i("p"),Kt.innerHTML=ta,es=s(),u(me.$$.fragment),mn=s(),u(Ct.$$.fragment),pn=s(),to=i("p"),this.h()},l(e){const t=ra("svelte-u9bgzb",document.head);r=l(t,"META",{name:!0,content:!0}),t.forEach(o),M=a(e),h=l(e,"P",{}),U(h).forEach(o),p=a(e),f(x.$$.fragment,e),m=a(e),b=l(e,"DIV",{class:!0,"data-svelte-h":!0}),c(b)!=="svelte-13t8s2t"&&(b.innerHTML=R),y=a(e),f(w.$$.fragment,e),oo=a(e),ue=l(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-r9t9m0"&&(ue.innerHTML=os),no=a(e),fe=l(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-l8delz"&&(fe.innerHTML=ns),so=a(e),ge=l(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-ddgfbh"&&(ge.textContent=ss),ao=a(e),_e=l(e,"UL",{"data-svelte-h":!0}),c(_e)!=="svelte-7ymha8"&&(_e.innerHTML=as),ro=a(e),Te=l(e,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-1dauaqy"&&(Te.innerHTML=rs),io=a(e),ve=l(e,"P",{"data-svelte-h":!0}),c(ve)!=="svelte-vfdo9a"&&(ve.textContent=is),lo=a(e),be=l(e,"P",{"data-svelte-h":!0}),c(be)!=="svelte-1vw0n52"&&(be.innerHTML=ls),co=a(e),f(ye.$$.fragment,e),mo=a(e),Me=l(e,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-1d1a1h9"&&(Me.textContent=ds),po=a(e),xe=l(e,"P",{"data-svelte-h":!0}),c(xe)!=="svelte-msm04g"&&(xe.textContent=cs),ho=a(e),f(we.$$.fragment,e),uo=a(e),ke=l(e,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-1x6apd2"&&(ke.textContent=ms),fo=a(e),Se=l(e,"P",{"data-svelte-h":!0}),c(Se)!=="svelte-skz2b1"&&(Se.textContent=ps),go=a(e),f($e.$$.fragment,e),_o=a(e),f(Ce.$$.fragment,e),To=a(e),ze=l(e,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-1j5ps84"&&(ze.innerHTML=hs),vo=a(e),f(Fe.$$.fragment,e),bo=a(e),Je=l(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-vy622i"&&(Je.textContent=us),yo=a(e),f(je.$$.fragment,e),Mo=a(e),Ie=l(e,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-bxedlc"&&(Ie.innerHTML=fs),xo=a(e),f(qe.$$.fragment,e),wo=a(e),f(Ue.$$.fragment,e),ko=a(e),f(Le.$$.fragment,e),So=a(e),Ne=l(e,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-1bapxt"&&(Ne.innerHTML=gs),$o=a(e),f(He.$$.fragment,e),Co=a(e),Ze=l(e,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-65k8ai"&&(Ze.innerHTML=_s),zo=a(e),f(Pe.$$.fragment,e),Fo=a(e),We=l(e,"P",{"data-svelte-h":!0}),c(We)!=="svelte-oipcsb"&&(We.innerHTML=Ts),Jo=a(e),f(Ge.$$.fragment,e),jo=a(e),Re=l(e,"P",{"data-svelte-h":!0}),c(Re)!=="svelte-19qvptk"&&(Re.innerHTML=vs),Io=a(e),f(Ve.$$.fragment,e),qo=a(e),Be=l(e,"P",{"data-svelte-h":!0}),c(Be)!=="svelte-vk1805"&&(Be.innerHTML=bs),Uo=a(e),f(Xe.$$.fragment,e),Lo=a(e),Ee=l(e,"P",{"data-svelte-h":!0}),c(Ee)!=="svelte-1nhttb0"&&(Ee.innerHTML=ys),No=a(e),f(De.$$.fragment,e),Ho=a(e),Oe=l(e,"P",{"data-svelte-h":!0}),c(Oe)!=="svelte-19pkkkq"&&(Oe.textContent=Ms),Zo=a(e),Ye=l(e,"P",{"data-svelte-h":!0}),c(Ye)!=="svelte-10jpqyx"&&(Ye.innerHTML=xs),Po=a(e),f(Ae.$$.fragment,e),Wo=a(e),Qe=l(e,"P",{"data-svelte-h":!0}),c(Qe)!=="svelte-1blkwbg"&&(Qe.textContent=ws),Go=a(e),f(Ke.$$.fragment,e),Ro=a(e),et=l(e,"P",{"data-svelte-h":!0}),c(et)!=="svelte-th6qhh"&&(et.innerHTML=ks),Vo=a(e),tt=l(e,"UL",{"data-svelte-h":!0}),c(tt)!=="svelte-k9llxy"&&(tt.innerHTML=Ss),Bo=a(e),f(ot.$$.fragment,e),Xo=a(e),nt=l(e,"P",{"data-svelte-h":!0}),c(nt)!=="svelte-18k5wrt"&&(nt.textContent=$s),Eo=a(e),st=l(e,"UL",{"data-svelte-h":!0}),c(st)!=="svelte-1x9yzdf"&&(st.innerHTML=Cs),Do=a(e),f(at.$$.fragment,e),Oo=a(e),rt=l(e,"P",{"data-svelte-h":!0}),c(rt)!=="svelte-8kbcuu"&&(rt.textContent=zs),Yo=a(e),it=l(e,"UL",{"data-svelte-h":!0}),c(it)!=="svelte-faxz1n"&&(it.innerHTML=Fs),Ao=a(e),lt=l(e,"P",{"data-svelte-h":!0}),c(lt)!=="svelte-mez4is"&&(lt.innerHTML=Js),Qo=a(e),f(dt.$$.fragment,e),Ko=a(e),F=l(e,"DIV",{class:!0});var N=U(F);f(ct.$$.fragment,N),un=a(N),Ft=l(N,"P",{"data-svelte-h":!0}),c(Ft)!=="svelte-1g8ljzb"&&(Ft.textContent=js),fn=a(N),Jt=l(N,"P",{"data-svelte-h":!0}),c(Jt)!=="svelte-6pahdo"&&(Jt.innerHTML=Is),gn=a(N),jt=l(N,"P",{"data-svelte-h":!0}),c(jt)!=="svelte-hswkmf"&&(jt.innerHTML=qs),_n=a(N),B=l(N,"DIV",{class:!0});var A=U(B);f(mt.$$.fragment,A),Tn=a(A),It=l(A,"P",{"data-svelte-h":!0}),c(It)!=="svelte-1v5cwae"&&(It.textContent=Us),vn=a(A),f(oe.$$.fragment,A),A.forEach(o),N.forEach(o),en=a(e),f(pt.$$.fragment,e),tn=a(e),J=l(e,"DIV",{class:!0});var H=U(J);f(ht.$$.fragment,H),bn=a(H),qt=l(H,"P",{"data-svelte-h":!0}),c(qt)!=="svelte-oq5vt6"&&(qt.textContent=Ls),yn=a(H),Ut=l(H,"P",{"data-svelte-h":!0}),c(Ut)!=="svelte-6pahdo"&&(Ut.innerHTML=Ns),Mn=a(H),Lt=l(H,"P",{"data-svelte-h":!0}),c(Lt)!=="svelte-hswkmf"&&(Lt.innerHTML=Hs),xn=a(H),X=l(H,"DIV",{class:!0});var Q=U(X);f(ut.$$.fragment,Q),wn=a(Q),Nt=l(Q,"P",{"data-svelte-h":!0}),c(Nt)!=="svelte-1lcmkdu"&&(Nt.textContent=Zs),kn=a(Q),f(ne.$$.fragment,Q),Q.forEach(o),H.forEach(o),on=a(e),f(ft.$$.fragment,e),nn=a(e),j=l(e,"DIV",{class:!0});var Z=U(j);f(gt.$$.fragment,Z),Sn=a(Z),Ht=l(Z,"P",{"data-svelte-h":!0}),c(Ht)!=="svelte-11pbanq"&&(Ht.textContent=Ps),$n=a(Z),Zt=l(Z,"P",{"data-svelte-h":!0}),c(Zt)!=="svelte-6pahdo"&&(Zt.innerHTML=Ws),Cn=a(Z),Pt=l(Z,"P",{"data-svelte-h":!0}),c(Pt)!=="svelte-hswkmf"&&(Pt.innerHTML=Gs),zn=a(Z),E=l(Z,"DIV",{class:!0});var K=U(E);f(_t.$$.fragment,K),Fn=a(K),Wt=l(K,"P",{"data-svelte-h":!0}),c(Wt)!=="svelte-1lcmkdu"&&(Wt.textContent=Rs),Jn=a(K),f(se.$$.fragment,K),K.forEach(o),Z.forEach(o),sn=a(e),f(Tt.$$.fragment,e),an=a(e),$=l(e,"DIV",{class:!0});var I=U($);f(vt.$$.fragment,I),jn=a(I),Gt=l(I,"P",{"data-svelte-h":!0}),c(Gt)!=="svelte-1ow7o6i"&&(Gt.textContent=Vs),In=a(I),Rt=l(I,"P",{"data-svelte-h":!0}),c(Rt)!=="svelte-6pahdo"&&(Rt.innerHTML=Bs),qn=a(I),Vt=l(I,"P",{"data-svelte-h":!0}),c(Vt)!=="svelte-hswkmf"&&(Vt.innerHTML=Xs),Un=a(I),W=l(I,"DIV",{class:!0});var V=U(W);f(bt.$$.fragment,V),Ln=a(V),Bt=l(V,"P",{"data-svelte-h":!0}),c(Bt)!=="svelte-1g2xmmf"&&(Bt.innerHTML=Es),Nn=a(V),f(ae.$$.fragment,V),Hn=a(V),f(re.$$.fragment,V),V.forEach(o),Zn=a(I),D=l(I,"DIV",{class:!0});var ee=U(D);f(yt.$$.fragment,ee),Pn=a(ee),Xt=l(ee,"P",{"data-svelte-h":!0}),c(Xt)!=="svelte-1puovtq"&&(Xt.textContent=Ds),Wn=a(ee),f(ie.$$.fragment,ee),ee.forEach(o),I.forEach(o),rn=a(e),f(Mt.$$.fragment,e),ln=a(e),C=l(e,"DIV",{class:!0});var q=U(C);f(xt.$$.fragment,q),Gn=a(q),Et=l(q,"P",{"data-svelte-h":!0}),c(Et)!=="svelte-10xfcjy"&&(Et.textContent=Os),Rn=a(q),Dt=l(q,"P",{"data-svelte-h":!0}),c(Dt)!=="svelte-6pahdo"&&(Dt.innerHTML=Ys),Vn=a(q),Ot=l(q,"P",{"data-svelte-h":!0}),c(Ot)!=="svelte-hswkmf"&&(Ot.innerHTML=As),Bn=a(q),G=l(q,"DIV",{class:!0});var pe=U(G);f(wt.$$.fragment,pe),Xn=a(pe),Yt=l(pe,"P",{"data-svelte-h":!0}),c(Yt)!=="svelte-1daezjd"&&(Yt.innerHTML=Qs),En=a(pe),f(le.$$.fragment,pe),Dn=a(pe),f(de.$$.fragment,pe),pe.forEach(o),On=a(q),O=l(q,"DIV",{class:!0});var eo=U(O);f(kt.$$.fragment,eo),Yn=a(eo),At=l(eo,"P",{"data-svelte-h":!0}),c(At)!=="svelte-1puovtq"&&(At.textContent=Ks),An=a(eo),f(ce.$$.fragment,eo),eo.forEach(o),q.forEach(o),dn=a(e),f(St.$$.fragment,e),cn=a(e),L=l(e,"DIV",{class:!0});var he=U(L);f($t.$$.fragment,he),Qn=a(he),Qt=l(he,"P",{"data-svelte-h":!0}),c(Qt)!=="svelte-dx2r91"&&(Qt.innerHTML=ea),Kn=a(he),Kt=l(he,"P",{"data-svelte-h":!0}),c(Kt)!=="svelte-o55m63"&&(Kt.innerHTML=ta),es=a(he),f(me.$$.fragment,he),he.forEach(o),mn=a(e),f(Ct.$$.fragment,e),pn=a(e),to=l(e,"P",{}),U(to).forEach(o),this.h()},h(){z(r,"name","hf:doc:metadata"),z(r,"content",va),z(b,"class","flex flex-wrap space-x-1"),z(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,r),n(e,M,t),n(e,h,t),n(e,p,t),g(x,e,t),n(e,m,t),n(e,b,t),n(e,y,t),g(w,e,t),n(e,oo,t),n(e,ue,t),n(e,no,t),n(e,fe,t),n(e,so,t),n(e,ge,t),n(e,ao,t),n(e,_e,t),n(e,ro,t),n(e,Te,t),n(e,io,t),n(e,ve,t),n(e,lo,t),n(e,be,t),n(e,co,t),g(ye,e,t),n(e,mo,t),n(e,Me,t),n(e,po,t),n(e,xe,t),n(e,ho,t),g(we,e,t),n(e,uo,t),n(e,ke,t),n(e,fo,t),n(e,Se,t),n(e,go,t),g($e,e,t),n(e,_o,t),g(Ce,e,t),n(e,To,t),n(e,ze,t),n(e,vo,t),g(Fe,e,t),n(e,bo,t),n(e,Je,t),n(e,yo,t),g(je,e,t),n(e,Mo,t),n(e,Ie,t),n(e,xo,t),g(qe,e,t),n(e,wo,t),g(Ue,e,t),n(e,ko,t),g(Le,e,t),n(e,So,t),n(e,Ne,t),n(e,$o,t),g(He,e,t),n(e,Co,t),n(e,Ze,t),n(e,zo,t),g(Pe,e,t),n(e,Fo,t),n(e,We,t),n(e,Jo,t),g(Ge,e,t),n(e,jo,t),n(e,Re,t),n(e,Io,t),g(Ve,e,t),n(e,qo,t),n(e,Be,t),n(e,Uo,t),g(Xe,e,t),n(e,Lo,t),n(e,Ee,t),n(e,No,t),g(De,e,t),n(e,Ho,t),n(e,Oe,t),n(e,Zo,t),n(e,Ye,t),n(e,Po,t),g(Ae,e,t),n(e,Wo,t),n(e,Qe,t),n(e,Go,t),g(Ke,e,t),n(e,Ro,t),n(e,et,t),n(e,Vo,t),n(e,tt,t),n(e,Bo,t),g(ot,e,t),n(e,Xo,t),n(e,nt,t),n(e,Eo,t),n(e,st,t),n(e,Do,t),g(at,e,t),n(e,Oo,t),n(e,rt,t),n(e,Yo,t),n(e,it,t),n(e,Ao,t),n(e,lt,t),n(e,Qo,t),g(dt,e,t),n(e,Ko,t),n(e,F,t),g(ct,F,null),d(F,un),d(F,Ft),d(F,fn),d(F,Jt),d(F,gn),d(F,jt),d(F,_n),d(F,B),g(mt,B,null),d(B,Tn),d(B,It),d(B,vn),g(oe,B,null),n(e,en,t),g(pt,e,t),n(e,tn,t),n(e,J,t),g(ht,J,null),d(J,bn),d(J,qt),d(J,yn),d(J,Ut),d(J,Mn),d(J,Lt),d(J,xn),d(J,X),g(ut,X,null),d(X,wn),d(X,Nt),d(X,kn),g(ne,X,null),n(e,on,t),g(ft,e,t),n(e,nn,t),n(e,j,t),g(gt,j,null),d(j,Sn),d(j,Ht),d(j,$n),d(j,Zt),d(j,Cn),d(j,Pt),d(j,zn),d(j,E),g(_t,E,null),d(E,Fn),d(E,Wt),d(E,Jn),g(se,E,null),n(e,sn,t),g(Tt,e,t),n(e,an,t),n(e,$,t),g(vt,$,null),d($,jn),d($,Gt),d($,In),d($,Rt),d($,qn),d($,Vt),d($,Un),d($,W),g(bt,W,null),d(W,Ln),d(W,Bt),d(W,Nn),g(ae,W,null),d(W,Hn),g(re,W,null),d($,Zn),d($,D),g(yt,D,null),d(D,Pn),d(D,Xt),d(D,Wn),g(ie,D,null),n(e,rn,t),g(Mt,e,t),n(e,ln,t),n(e,C,t),g(xt,C,null),d(C,Gn),d(C,Et),d(C,Rn),d(C,Dt),d(C,Vn),d(C,Ot),d(C,Bn),d(C,G),g(wt,G,null),d(G,Xn),d(G,Yt),d(G,En),g(le,G,null),d(G,Dn),g(de,G,null),d(C,On),d(C,O),g(kt,O,null),d(O,Yn),d(O,At),d(O,An),g(ce,O,null),n(e,dn,t),g(St,e,t),n(e,cn,t),n(e,L,t),g($t,L,null),d(L,Qn),d(L,Qt),d(L,Kn),d(L,Kt),d(L,es),g(me,L,null),n(e,mn,t),g(Ct,e,t),n(e,pn,t),n(e,to,t),hn=!0},p(e,[t]){const N={};t&2&&(N.$$scope={dirty:t,ctx:e}),oe.$set(N);const A={};t&2&&(A.$$scope={dirty:t,ctx:e}),ne.$set(A);const H={};t&2&&(H.$$scope={dirty:t,ctx:e}),se.$set(H);const Q={};t&2&&(Q.$$scope={dirty:t,ctx:e}),ae.$set(Q);const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),re.$set(Z);const K={};t&2&&(K.$$scope={dirty:t,ctx:e}),ie.$set(K);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),le.$set(I);const V={};t&2&&(V.$$scope={dirty:t,ctx:e}),de.$set(V);const ee={};t&2&&(ee.$$scope={dirty:t,ctx:e}),ce.$set(ee);const q={};t&2&&(q.$$scope={dirty:t,ctx:e}),me.$set(q)},i(e){hn||(_(x.$$.fragment,e),_(w.$$.fragment,e),_(ye.$$.fragment,e),_(we.$$.fragment,e),_($e.$$.fragment,e),_(Ce.$$.fragment,e),_(Fe.$$.fragment,e),_(je.$$.fragment,e),_(qe.$$.fragment,e),_(Ue.$$.fragment,e),_(Le.$$.fragment,e),_(He.$$.fragment,e),_(Pe.$$.fragment,e),_(Ge.$$.fragment,e),_(Ve.$$.fragment,e),_(Xe.$$.fragment,e),_(De.$$.fragment,e),_(Ae.$$.fragment,e),_(Ke.$$.fragment,e),_(ot.$$.fragment,e),_(at.$$.fragment,e),_(dt.$$.fragment,e),_(ct.$$.fragment,e),_(mt.$$.fragment,e),_(oe.$$.fragment,e),_(pt.$$.fragment,e),_(ht.$$.fragment,e),_(ut.$$.fragment,e),_(ne.$$.fragment,e),_(ft.$$.fragment,e),_(gt.$$.fragment,e),_(_t.$$.fragment,e),_(se.$$.fragment,e),_(Tt.$$.fragment,e),_(vt.$$.fragment,e),_(bt.$$.fragment,e),_(ae.$$.fragment,e),_(re.$$.fragment,e),_(yt.$$.fragment,e),_(ie.$$.fragment,e),_(Mt.$$.fragment,e),_(xt.$$.fragment,e),_(wt.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(kt.$$.fragment,e),_(ce.$$.fragment,e),_(St.$$.fragment,e),_($t.$$.fragment,e),_(me.$$.fragment,e),_(Ct.$$.fragment,e),hn=!0)},o(e){T(x.$$.fragment,e),T(w.$$.fragment,e),T(ye.$$.fragment,e),T(we.$$.fragment,e),T($e.$$.fragment,e),T(Ce.$$.fragment,e),T(Fe.$$.fragment,e),T(je.$$.fragment,e),T(qe.$$.fragment,e),T(Ue.$$.fragment,e),T(Le.$$.fragment,e),T(He.$$.fragment,e),T(Pe.$$.fragment,e),T(Ge.$$.fragment,e),T(Ve.$$.fragment,e),T(Xe.$$.fragment,e),T(De.$$.fragment,e),T(Ae.$$.fragment,e),T(Ke.$$.fragment,e),T(ot.$$.fragment,e),T(at.$$.fragment,e),T(dt.$$.fragment,e),T(ct.$$.fragment,e),T(mt.$$.fragment,e),T(oe.$$.fragment,e),T(pt.$$.fragment,e),T(ht.$$.fragment,e),T(ut.$$.fragment,e),T(ne.$$.fragment,e),T(ft.$$.fragment,e),T(gt.$$.fragment,e),T(_t.$$.fragment,e),T(se.$$.fragment,e),T(Tt.$$.fragment,e),T(vt.$$.fragment,e),T(bt.$$.fragment,e),T(ae.$$.fragment,e),T(re.$$.fragment,e),T(yt.$$.fragment,e),T(ie.$$.fragment,e),T(Mt.$$.fragment,e),T(xt.$$.fragment,e),T(wt.$$.fragment,e),T(le.$$.fragment,e),T(de.$$.fragment,e),T(kt.$$.fragment,e),T(ce.$$.fragment,e),T(St.$$.fragment,e),T($t.$$.fragment,e),T(me.$$.fragment,e),T(Ct.$$.fragment,e),hn=!1},d(e){e&&(o(M),o(h),o(p),o(m),o(b),o(y),o(oo),o(ue),o(no),o(fe),o(so),o(ge),o(ao),o(_e),o(ro),o(Te),o(io),o(ve),o(lo),o(be),o(co),o(mo),o(Me),o(po),o(xe),o(ho),o(uo),o(ke),o(fo),o(Se),o(go),o(_o),o(To),o(ze),o(vo),o(bo),o(Je),o(yo),o(Mo),o(Ie),o(xo),o(wo),o(ko),o(So),o(Ne),o($o),o(Co),o(Ze),o(zo),o(Fo),o(We),o(Jo),o(jo),o(Re),o(Io),o(qo),o(Be),o(Uo),o(Lo),o(Ee),o(No),o(Ho),o(Oe),o(Zo),o(Ye),o(Po),o(Wo),o(Qe),o(Go),o(Ro),o(et),o(Vo),o(tt),o(Bo),o(Xo),o(nt),o(Eo),o(st),o(Do),o(Oo),o(rt),o(Yo),o(it),o(Ao),o(lt),o(Qo),o(Ko),o(F),o(en),o(tn),o(J),o(on),o(nn),o(j),o(sn),o(an),o($),o(rn),o(ln),o(C),o(dn),o(cn),o(L),o(mn),o(pn),o(to)),o(r),v(x,e),v(w,e),v(ye,e),v(we,e),v($e,e),v(Ce,e),v(Fe,e),v(je,e),v(qe,e),v(Ue,e),v(Le,e),v(He,e),v(Pe,e),v(Ge,e),v(Ve,e),v(Xe,e),v(De,e),v(Ae,e),v(Ke,e),v(ot,e),v(at,e),v(dt,e),v(ct),v(mt),v(oe),v(pt,e),v(ht),v(ut),v(ne),v(ft,e),v(gt),v(_t),v(se),v(Tt,e),v(vt),v(bt),v(ae),v(re),v(yt),v(ie),v(Mt,e),v(xt),v(wt),v(le),v(de),v(kt),v(ce),v(St,e),v($t),v(me),v(Ct,e)}}}const va='{"title":"SeamlessM4T-v2","local":"seamlessm4t-v2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage","local":"usage","sections":[{"title":"Speech","local":"speech","sections":[],"depth":3},{"title":"Text","local":"text","sections":[],"depth":3},{"title":"Tips","local":"tips","sections":[{"title":"1. Use dedicated models","local":"1-use-dedicated-models","sections":[],"depth":4},{"title":"2. Change the speaker identity","local":"2-change-the-speaker-identity","sections":[],"depth":4},{"title":"3. Change the generation strategy","local":"3-change-the-generation-strategy","sections":[],"depth":4},{"title":"4. Generate speech and text at the same time","local":"4-generate-speech-and-text-at-the-same-time","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Model architecture","local":"model-architecture","sections":[{"title":"Difference with SeamlessM4T-v1","local":"difference-with-seamlessm4t-v1","sections":[{"title":"Improvements on the second-pass model","local":"improvements-on-the-second-pass-model","sections":[],"depth":4},{"title":"Difference in the speech encoder","local":"difference-in-the-speech-encoder","sections":[],"depth":4}],"depth":3},{"title":"Generation process","local":"generation-process","sections":[],"depth":3}],"depth":2},{"title":"SeamlessM4Tv2Model","local":"transformers.SeamlessM4Tv2Model","sections":[],"depth":2},{"title":"SeamlessM4Tv2ForTextToSpeech","local":"transformers.SeamlessM4Tv2ForTextToSpeech","sections":[],"depth":2},{"title":"SeamlessM4Tv2ForSpeechToSpeech","local":"transformers.SeamlessM4Tv2ForSpeechToSpeech","sections":[],"depth":2},{"title":"SeamlessM4Tv2ForTextToText","local":"transformers.SeamlessM4Tv2ForTextToText","sections":[],"depth":2},{"title":"SeamlessM4Tv2ForSpeechToText","local":"transformers.SeamlessM4Tv2ForSpeechToText","sections":[],"depth":2},{"title":"SeamlessM4Tv2Config","local":"transformers.SeamlessM4Tv2Config","sections":[],"depth":2}],"depth":1}';function ba(k){return na(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class za extends sa{constructor(r){super(),aa(this,r,ba,Ta,oa,{})}}export{za as component};
