import{s as Kt,o as eo,n as ye}from"../chunks/scheduler.18a86fab.js";import{S as to,i as oo,g as m,s as a,r as f,A as no,h as p,f as s,c as r,j as Z,u as h,x as u,k as U,y as i,a as l,v as g,d as _,t as b,w as y}from"../chunks/index.98837b22.js";import{T as jt}from"../chunks/Tip.77304350.js";import{D as Y}from"../chunks/Docstring.6758ea23.js";import{C as nt}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as ot}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as Q}from"../chunks/Heading.7e7e0c5b.js";import{E as so}from"../chunks/index.499f366c.js";function ao(M){let t,w="Example:",c,d,v;return d=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNFV0RDb25maWclMkMlMjBTRVdETW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU0VXLUQlMjBhc2FwcCUyRnNldy1kLXRpbnktMTAwayUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBTRVdEQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGFzYXBwJTJGc2V3LWQtdGlueS0xMDBrJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBTRVdETW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SEWDConfig, SEWDModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SEW-D asapp/sew-d-tiny-100k style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SEWDConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the asapp/sew-d-tiny-100k style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SEWDModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=m("p"),t.textContent=w,c=a(),f(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=w),c=r(o),h(d.$$.fragment,o)},m(o,T){l(o,t,T),l(o,c,T),g(d,o,T),v=!0},p:ye,i(o){v||(_(d.$$.fragment,o),v=!0)},o(o){b(d.$$.fragment,o),v=!1},d(o){o&&(s(t),s(c)),y(d,o)}}}function ro(M){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=w},l(c){t=p(c,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(c,d){l(c,t,d)},p:ye,d(c){c&&s(t)}}}function io(M){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=w},l(c){t=p(c,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(c,d){l(c,t,d)},p:ye,d(c){c&&s(t)}}}function lo(M){let t,w="Example:",c,d,v;return d=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBTRVdERm9yQ1RDJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyYXNhcHAlMkZzZXctZC10aW55LTEwMGslMjIpJTBBbW9kZWwlMjAlM0QlMjBTRVdERm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJhc2FwcCUyRnNldy1kLXRpbnktMTAwayUyMiklMEElMEElMjMlMjBhdWRpbyUyMGZpbGUlMjBpcyUyMGRlY29kZWQlMjBvbiUyMHRoZSUyMGZseSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihkYXRhc2V0JTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEc2FtcGxpbmdfcmF0ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEFwcmVkaWN0ZWRfaWRzJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQSUwQSUyMyUyMHRyYW5zY3JpYmUlMjBzcGVlY2glMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShwcmVkaWN0ZWRfaWRzKSUwQXRyYW5zY3JpcHRpb24lNUIwJTVEJTBBJTBBaW5wdXRzJTVCJTIybGFiZWxzJTIyJTVEJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0RkYXRhc2V0JTVCMCU1RCU1QiUyMnRleHQlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMlMEElMEElMjMlMjBjb21wdXRlJTIwbG9zcyUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9zcyUwQXJvdW5kKGxvc3MuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, SEWDForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;asapp/sew-d-tiny-100k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SEWDForCTC.from_pretrained(<span class="hljs-string">&quot;asapp/sew-d-tiny-100k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># transcribe speech</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription[<span class="hljs-number">0</span>]
...

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;labels&quot;</span>] = processor(text=dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute loss</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){t=m("p"),t.textContent=w,c=a(),f(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=w),c=r(o),h(d.$$.fragment,o)},m(o,T){l(o,t,T),l(o,c,T),g(d,o,T),v=!0},p:ye,i(o){v||(_(d.$$.fragment,o),v=!0)},o(o){b(d.$$.fragment,o),v=!1},d(o){o&&(s(t),s(c)),y(d,o)}}}function co(M){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=w},l(c){t=p(c,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(c,d){l(c,t,d)},p:ye,d(c){c&&s(t)}}}function mo(M){let t,w="Example of single-label classification:",c,d,v;return d=new nt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFNFV0RGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYXNhcHAlMkZzZXctZC10aW55LTEwMGslMjIpJTBBbW9kZWwlMjAlM0QlMjBTRVdERm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYXNhcHAlMkZzZXctZC10aW55LTEwMGslMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkJTIwJTNEJTIwbG9naXRzLmFyZ21heCgpLml0ZW0oKSUwQW1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9jbGFzc19pZCU1RCUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyMFNFV0RGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJhc2FwcCUyRnNldy1kLXRpbnktMTAwayUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcyUwQXJvdW5kKGxvc3MuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SEWDForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;asapp/sew-d-tiny-100k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SEWDForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;asapp/sew-d-tiny-100k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.id2label[predicted_class_id]
...

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SEWDForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;asapp/sew-d-tiny-100k&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){t=m("p"),t.textContent=w,c=a(),f(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),u(t)!=="svelte-ykxpe4"&&(t.textContent=w),c=r(o),h(d.$$.fragment,o)},m(o,T){l(o,t,T),l(o,c,T),g(d,o,T),v=!0},p:ye,i(o){v||(_(d.$$.fragment,o),v=!0)},o(o){b(d.$$.fragment,o),v=!1},d(o){o&&(s(t),s(c)),y(d,o)}}}function po(M){let t,w="Example of multi-label classification:",c,d,v;return d=new nt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFNFV0RGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYXNhcHAlMkZzZXctZC10aW55LTEwMGslMjIpJTBBbW9kZWwlMjAlM0QlMjBTRVdERm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYXNhcHAlMkZzZXctZC10aW55LTEwMGslMjIlMkMlMjBwcm9ibGVtX3R5cGUlM0QlMjJtdWx0aV9sYWJlbF9jbGFzc2lmaWNhdGlvbiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWRzJTIwJTNEJTIwdG9yY2guYXJhbmdlKDAlMkMlMjBsb2dpdHMuc2hhcGUlNUItMSU1RCklNUJ0b3JjaC5zaWdtb2lkKGxvZ2l0cykuc3F1ZWV6ZShkaW0lM0QwKSUyMCUzRSUyMDAuNSU1RCUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyMFNFV0RGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJhc2FwcCUyRnNldy1kLXRpbnktMTAwayUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SEWDForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;asapp/sew-d-tiny-100k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SEWDForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;asapp/sew-d-tiny-100k&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SEWDForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;asapp/sew-d-tiny-100k&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=m("p"),t.textContent=w,c=a(),f(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),u(t)!=="svelte-1l8e32d"&&(t.textContent=w),c=r(o),h(d.$$.fragment,o)},m(o,T){l(o,t,T),l(o,c,T),g(d,o,T),v=!0},p:ye,i(o){v||(_(d.$$.fragment,o),v=!0)},o(o){b(d.$$.fragment,o),v=!1},d(o){o&&(s(t),s(c)),y(d,o)}}}function uo(M){let t,w,c,d,v,o,T,xt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',ze,A,qe,P,Jt=`SEW-D (Squeezed and Efficient Wav2Vec with Disentangled attention) was proposed in <a href="https://arxiv.org/abs/2109.06870" rel="nofollow">Performance-Efficiency Trade-offs
in Unsupervised Pre-training for Speech Recognition</a> by Felix Wu, Kwangyoun Kim,
Jing Pan, Kyu Han, Kilian Q. Weinberger, Yoav Artzi.`,Ze,O,Dt="The abstract from the paper is the following:",Re,K,Ft=`<em>This paper is a study of performance-efficiency trade-offs in pre-trained models for automatic speech recognition
(ASR). We focus on wav2vec 2.0, and formalize several architecture designs that influence both the model performance
and its efficiency. Putting together all our observations, we introduce SEW (Squeezed and Efficient Wav2vec), a
pre-trained model architecture with significant improvements along both performance and efficiency dimensions across a
variety of training setups. For example, under the 100h-960h semi-supervised setup on LibriSpeech, SEW achieves a 1.9x
inference speedup compared to wav2vec 2.0, with a 13.5% relative reduction in word error rate. With a similar inference
time, SEW reduces word error rate by 25-50% across different model sizes.</em>`,Ge,ee,Ut='This model was contributed by <a href="https://huggingface.co/anton-l" rel="nofollow">anton-l</a>.',Ve,te,Ie,oe,zt=`<li>SEW-D is a speech model that accepts a float array corresponding to the raw waveform of the speech signal.</li> <li>SEWDForCTC is fine-tuned using connectionist temporal classification (CTC) so the model output has to be decoded
using <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a>.</li>`,Ne,ne,Be,se,qt='<li><a href="../tasks/audio_classification">Audio classification task guide</a></li> <li><a href="../tasks/asr">Automatic speech recognition task guide</a></li>',He,ae,Le,W,re,st,ve,Zt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDModel">SEWDModel</a>. It is used to instantiate a SEW-D
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the SEW-D
<a href="https://huggingface.co/asapp/sew-d-tiny-100k" rel="nofollow">asapp/sew-d-tiny-100k</a> architecture.`,at,we,Rt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,rt,G,it,V,ie,lt,Te,Gt="Serializes this instance to a Python dictionary.",Xe,le,Ye,C,ce,ct,Me,Vt="The bare Sew D Model outputting raw hidden-states without any specific head on top.",dt,We,It=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,mt,Ce,Nt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,pt,z,de,ut,ke,Bt='The <a href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDModel">SEWDModel</a> forward method, overrides the <code>__call__</code> special method.',ft,I,Qe,me,Ae,k,pe,ht,$e,Ht="SEW-D Model with a <code>language modeling</code> head on top for Connectionist Temporal Classification (CTC).",gt,Se,Lt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,_t,Ee,Xt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,bt,D,ue,yt,je,Yt='The <a href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDForCTC">SEWDForCTC</a> forward method, overrides the <code>__call__</code> special method.',vt,N,wt,B,Pe,fe,Oe,$,he,Tt,xe,Qt=`SEWD Model with a sequence classification head on top (a linear layer over the pooled output) for tasks like SUPERB
Keyword Spotting.`,Mt,Je,At=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Wt,De,Pt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ct,S,ge,kt,Fe,Ot='The <a href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDForSequenceClassification">SEWDForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',$t,H,St,L,Et,X,Ke,_e,et,Ue,tt;return v=new Q({props:{title:"SEW-D",local:"sew-d",headingTag:"h1"}}),A=new Q({props:{title:"Overview",local:"overview",headingTag:"h2"}}),te=new Q({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ne=new Q({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ae=new Q({props:{title:"SEWDConfig",local:"transformers.SEWDConfig",headingTag:"h2"}}),re=new Y({props:{name:"class transformers.SEWDConfig",anchor:"transformers.SEWDConfig",parameters:[{name:"vocab_size",val:" = 32"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"squeeze_factor",val:" = 2"},{name:"max_position_embeddings",val:" = 512"},{name:"position_buckets",val:" = 256"},{name:"share_att_key",val:" = True"},{name:"relative_attention",val:" = True"},{name:"pos_att_type",val:" = ('p2c', 'c2p')"},{name:"norm_rel_ebd",val:" = 'layer_norm'"},{name:"hidden_act",val:" = 'gelu_python'"},{name:"hidden_dropout",val:" = 0.1"},{name:"activation_dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.1"},{name:"feat_proj_dropout",val:" = 0.0"},{name:"final_dropout",val:" = 0.1"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-07"},{name:"feature_layer_norm_eps",val:" = 1e-05"},{name:"feat_extract_norm",val:" = 'group'"},{name:"feat_extract_activation",val:" = 'gelu'"},{name:"conv_dim",val:" = (64, 128, 128, 128, 128, 256, 256, 256, 256, 512, 512, 512, 512)"},{name:"conv_stride",val:" = (5, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1)"},{name:"conv_kernel",val:" = (10, 3, 1, 3, 1, 3, 1, 3, 1, 2, 1, 2, 1)"},{name:"conv_bias",val:" = False"},{name:"num_conv_pos_embeddings",val:" = 128"},{name:"num_conv_pos_embedding_groups",val:" = 16"},{name:"apply_spec_augment",val:" = True"},{name:"mask_time_prob",val:" = 0.05"},{name:"mask_time_length",val:" = 10"},{name:"mask_time_min_masks",val:" = 2"},{name:"mask_feature_prob",val:" = 0.0"},{name:"mask_feature_length",val:" = 10"},{name:"mask_feature_min_masks",val:" = 0"},{name:"ctc_loss_reduction",val:" = 'mean'"},{name:"ctc_zero_infinity",val:" = False"},{name:"use_weighted_layer_sum",val:" = False"},{name:"classifier_proj_size",val:" = 256"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SEWDConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Vocabulary size of the SEW-D model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <code>SEWD</code>.`,name:"vocab_size"},{anchor:"transformers.SEWDConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.SEWDConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.SEWDConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.SEWDConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.SEWDConfig.squeeze_factor",description:`<strong>squeeze_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Sequence length downsampling factor after the encoder and upsampling factor after the transformer.`,name:"squeeze_factor"},{anchor:"transformers.SEWDConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.SEWDConfig.position_buckets",description:`<strong>position_buckets</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The maximum size of relative position embeddings.`,name:"position_buckets"},{anchor:"transformers.SEWDConfig.share_att_key",description:`<strong>share_att_key</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to share attention key with c2p and p2c.`,name:"share_att_key"},{anchor:"transformers.SEWDConfig.relative_attention",description:`<strong>relative_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use relative position encoding.`,name:"relative_attention"},{anchor:"transformers.SEWDConfig.pos_att_type",description:`<strong>pos_att_type</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;p2c&quot;, &quot;c2p&quot;)</code>) &#x2014;
The type of relative position attention, it can be a combination of <code>(&quot;p2c&quot;, &quot;c2p&quot;)</code>, e.g. <code>(&quot;p2c&quot;)</code>,
<code>(&quot;p2c&quot;, &quot;c2p&quot;)</code>, <code>(&quot;p2c&quot;, &quot;c2p&quot;)</code>.`,name:"pos_att_type"},{anchor:"transformers.SEWDConfig.norm_rel_ebd",description:`<strong>norm_rel_ebd</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;layer_norm&quot;</code>) &#x2014;
Whether to use layer norm in relative embedding (<code>&quot;layer_norm&quot;</code> if yes)`,name:"norm_rel_ebd"},{anchor:"transformers.SEWDConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu_python&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code>, <code>&quot;gelu_python&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.SEWDConfig.hidden_dropout",description:`<strong>hidden_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Deprecated. Not used by the model and will be removed in a future version.`,name:"hidden_dropout"},{anchor:"transformers.SEWDConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"activation_dropout"},{anchor:"transformers.SEWDConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.SEWDConfig.final_dropout",description:`<strong>final_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for the final projection layer of <a href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDForCTC">SEWDForCTC</a>.`,name:"final_dropout"},{anchor:"transformers.SEWDConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.SEWDConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-7) &#x2014;
The epsilon used by the layer normalization layers in the transformer encoder.`,name:"layer_norm_eps"},{anchor:"transformers.SEWDConfig.feature_layer_norm_eps",description:`<strong>feature_layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-5) &#x2014;
The epsilon used by the layer normalization after the feature encoder.`,name:"feature_layer_norm_eps"},{anchor:"transformers.SEWDConfig.feat_extract_norm",description:`<strong>feat_extract_norm</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;group&quot;</code>) &#x2014;
The norm to be applied to 1D convolutional layers in feature encoder. One of <code>&quot;group&quot;</code> for group
normalization of only the first 1D convolutional layer or <code>&quot;layer&quot;</code> for layer normalization of all 1D
convolutional layers.`,name:"feat_extract_norm"},{anchor:"transformers.SEWDConfig.feat_proj_dropout",description:`<strong>feat_proj_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for output of the feature encoder.`,name:"feat_proj_dropout"},{anchor:"transformers.SEWDConfig.feat_extract_activation",description:"<strong>feat_extract_activation</strong> (<code>str, </code>optional<code>, defaults to </code>&#x201C;gelu&#x201D;<code>) -- The non-linear activation function (function or string) in the 1D convolutional layers of the feature extractor. If string, </code>&#x201C;gelu&#x201D;<code>, </code>&#x201C;relu&#x201D;<code>, </code>&#x201C;selu&#x201D;<code>and</code>&#x201C;gelu_new&#x201D;` are supported.",name:"feat_extract_activation"},{anchor:"transformers.SEWDConfig.conv_dim",description:`<strong>conv_dim</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(64, 128, 128, 128, 128, 256, 256, 256, 256, 512, 512, 512, 512)</code>) &#x2014;
A tuple of integers defining the number of input and output channels of each 1D convolutional layer in the
feature encoder. The length of <em>conv_dim</em> defines the number of 1D convolutional layers.`,name:"conv_dim"},{anchor:"transformers.SEWDConfig.conv_stride",description:`<strong>conv_stride</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(5, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1)</code>) &#x2014;
A tuple of integers defining the stride of each 1D convolutional layer in the feature encoder. The length
of <em>conv_stride</em> defines the number of convolutional layers and has to match the length of <em>conv_dim</em>.`,name:"conv_stride"},{anchor:"transformers.SEWDConfig.conv_kernel",description:`<strong>conv_kernel</strong> (<code>Tuple[int]</code> or <code>List[int]</code>, <em>optional</em>, defaults to <code>(10, 3, 1, 3, 1, 3, 1, 3, 1, 2, 1, 2, 1)</code>) &#x2014;
A tuple of integers defining the kernel size of each 1D convolutional layer in the feature encoder. The
length of <em>conv_kernel</em> defines the number of convolutional layers and has to match the length of
<em>conv_dim</em>.`,name:"conv_kernel"},{anchor:"transformers.SEWDConfig.conv_bias",description:`<strong>conv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the 1D convolutional layers have a bias.`,name:"conv_bias"},{anchor:"transformers.SEWDConfig.num_conv_pos_embeddings",description:`<strong>num_conv_pos_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Number of convolutional positional embeddings. Defines the kernel size of 1D convolutional positional
embeddings layer.`,name:"num_conv_pos_embeddings"},{anchor:"transformers.SEWDConfig.num_conv_pos_embedding_groups",description:`<strong>num_conv_pos_embedding_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of groups of 1D convolutional positional embeddings layer.`,name:"num_conv_pos_embedding_groups"},{anchor:"transformers.SEWDConfig.apply_spec_augment",description:`<strong>apply_spec_augment</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to apply <em>SpecAugment</em> data augmentation to the outputs of the feature encoder. For reference see
<a href="https://arxiv.org/abs/1904.08779" rel="nofollow">SpecAugment: A Simple Data Augmentation Method for Automatic Speech
Recognition</a>.`,name:"apply_spec_augment"},{anchor:"transformers.SEWDConfig.mask_time_prob",description:`<strong>mask_time_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.05) &#x2014;
Percentage (between 0 and 1) of all feature vectors along the time axis which will be masked. The masking
procedure generates &#x201D;mask_time_prob<em>len(time_axis)/mask_time_length&#x201D; independent masks over the axis. If
reasoning from the probability of each feature vector to be chosen as the start of the vector span to be
masked, </em>mask_time_prob<em> should be \`prob_vector_start</em>mask_time_length<code>. Note that overlap may decrease the actual percentage of masked vectors. This is only relevant if </code>apply_spec_augment is True\`.`,name:"mask_time_prob"},{anchor:"transformers.SEWDConfig.mask_time_length",description:`<strong>mask_time_length</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Length of vector span along the time axis.`,name:"mask_time_length"},{anchor:"transformers.SEWDConfig.mask_time_min_masks",description:`<strong>mask_time_min_masks</strong> (<code>int</code>, <em>optional</em>, defaults to 2), &#x2014;
The minimum number of masks of length <code>mask_feature_length</code> generated along the time axis, each time step,
irrespectively of <code>mask_feature_prob</code>. Only relevant if &#x201D;mask_time_prob*len(time_axis)/mask_time_length &lt;
mask_time_min_masks&#x201D;`,name:"mask_time_min_masks"},{anchor:"transformers.SEWDConfig.mask_feature_prob",description:`<strong>mask_feature_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Percentage (between 0 and 1) of all feature vectors along the feature axis which will be masked. The
masking procedure generates &#x201D;mask_feature_prob<em>len(feature_axis)/mask_time_length&#x201D; independent masks over
the axis. If reasoning from the probability of each feature vector to be chosen as the start of the vector
span to be masked, </em>mask_feature_prob<em> should be \`prob_vector_start</em>mask_feature_length<code>. Note that overlap may decrease the actual percentage of masked vectors. This is only relevant if </code>apply_spec_augment is
True\`.`,name:"mask_feature_prob"},{anchor:"transformers.SEWDConfig.mask_feature_length",description:`<strong>mask_feature_length</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Length of vector span along the feature axis.`,name:"mask_feature_length"},{anchor:"transformers.SEWDConfig.mask_feature_min_masks",description:`<strong>mask_feature_min_masks</strong> (<code>int</code>, <em>optional</em>, defaults to 0), &#x2014;
The minimum number of masks of length <code>mask_feature_length</code> generated along the feature axis, each time
step, irrespectively of <code>mask_feature_prob</code>. Only relevant if
&#x201D;mask_feature_prob*len(feature_axis)/mask_feature_length &lt; mask_feature_min_masks&#x201D;`,name:"mask_feature_min_masks"},{anchor:"transformers.SEWDConfig.diversity_loss_weight",description:`<strong>diversity_loss_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The weight of the codebook diversity loss component.`,name:"diversity_loss_weight"},{anchor:"transformers.SEWDConfig.ctc_loss_reduction",description:`<strong>ctc_loss_reduction</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sum&quot;</code>) &#x2014;
Specifies the reduction to apply to the output of <code>torch.nn.CTCLoss</code>. Only relevant when training an
instance of <a href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDForCTC">SEWDForCTC</a>.`,name:"ctc_loss_reduction"},{anchor:"transformers.SEWDConfig.ctc_zero_infinity",description:`<strong>ctc_zero_infinity</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to zero infinite losses and the associated gradients of <code>torch.nn.CTCLoss</code>. Infinite losses mainly
occur when the inputs are too short to be aligned to the targets. Only relevant when training an instance
of <a href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDForCTC">SEWDForCTC</a>.`,name:"ctc_zero_infinity"},{anchor:"transformers.SEWDConfig.use_weighted_layer_sum",description:`<strong>use_weighted_layer_sum</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a weighted average of layer outputs with learned weights. Only relevant when using an
instance of <a href="/docs/transformers/main/en/model_doc/wav2vec2#transformers.Wav2Vec2ForSequenceClassification">Wav2Vec2ForSequenceClassification</a>.`,name:"use_weighted_layer_sum"},{anchor:"transformers.SEWDConfig.classifier_proj_size",description:`<strong>classifier_proj_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the projection before token mean-pooling for classification.`,name:"classifier_proj_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sew_d/configuration_sew_d.py#L27"}}),G=new ot({props:{anchor:"transformers.SEWDConfig.example",$$slots:{default:[ao]},$$scope:{ctx:M}}}),ie=new Y({props:{name:"to_dict",anchor:"transformers.SEWDConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sew_d/configuration_sew_d.py#L282"}}),le=new Q({props:{title:"SEWDModel",local:"transformers.SEWDModel",headingTag:"h2"}}),ce=new Y({props:{name:"class transformers.SEWDModel",anchor:"transformers.SEWDModel",parameters:[{name:"config",val:": SEWDConfig"}],parametersDescription:[{anchor:"transformers.SEWDModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDConfig">SEWDConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sew_d/modeling_sew_d.py#L1271"}}),de=new Y({props:{name:"forward",anchor:"transformers.SEWDModel.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor]"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"mask_time_indices",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SEWDModel.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <code>{processor_class}.__call__</code> for details.`,name:"input_values"},{anchor:"transformers.SEWDModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SEWDModel.forward.mask_time_indices",description:`<strong>mask_time_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices to mask extracted features for contrastive loss. When in training mode, model learns to predict
masked extracted features in <em>config.proj_codevector_dim</em> space.`,name:"mask_time_indices"},{anchor:"transformers.SEWDModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SEWDModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SEWDModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sew_d/modeling_sew_d.py#L1340",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDConfig"
>SEWDConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),I=new jt({props:{$$slots:{default:[ro]},$$scope:{ctx:M}}}),me=new Q({props:{title:"SEWDForCTC",local:"transformers.SEWDForCTC",headingTag:"h2"}}),pe=new Y({props:{name:"class transformers.SEWDForCTC",anchor:"transformers.SEWDForCTC",parameters:[{name:"config",val:""},{name:"target_lang",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"transformers.SEWDForCTC.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDForCTC">SEWDForCTC</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.SEWDForCTC.target_lang",description:`<strong>target_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Language id of adapter weights. Adapter weights are stored in the format adapter.<lang>.safetensors or
adapter.<lang>.bin. Only relevant when using an instance of <a href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDForCTC">SEWDForCTC</a> with adapters. Uses &#x2018;eng&#x2019; by
default.</lang></lang>`,name:"target_lang"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sew_d/modeling_sew_d.py#L1395"}}),ue=new Y({props:{name:"forward",anchor:"transformers.SEWDForCTC.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor]"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.SEWDForCTC.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <code>{processor_class}.__call__</code> for details.`,name:"input_values"},{anchor:"transformers.SEWDForCTC.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SEWDForCTC.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SEWDForCTC.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SEWDForCTC.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SEWDForCTC.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, target_length)</code>, <em>optional</em>) &#x2014;
Labels for connectionist temporal classification. Note that <code>target_length</code> has to be smaller or equal to
the sequence length of the output logits. Indices are selected in <code>[-100, 0, ..., config.vocab_size - 1]</code>.
All labels set to <code>-100</code> are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sew_d/modeling_sew_d.py#L1479",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDConfig"
>SEWDConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),N=new jt({props:{$$slots:{default:[io]},$$scope:{ctx:M}}}),B=new ot({props:{anchor:"transformers.SEWDForCTC.forward.example",$$slots:{default:[lo]},$$scope:{ctx:M}}}),fe=new Q({props:{title:"SEWDForSequenceClassification",local:"transformers.SEWDForSequenceClassification",headingTag:"h2"}}),he=new Y({props:{name:"class transformers.SEWDForSequenceClassification",anchor:"transformers.SEWDForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SEWDForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDForSequenceClassification">SEWDForSequenceClassification</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sew_d/modeling_sew_d.py#L1551"}}),ge=new Y({props:{name:"forward",anchor:"transformers.SEWDForSequenceClassification.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor]"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.SEWDForSequenceClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform. Values can be obtained by loading a <code>.flac</code> or <code>.wav</code> audio file
into an array of type <code>List[float]</code> or a <code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into <code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a> should be used for padding and
conversion into a tensor of type <code>torch.FloatTensor</code>. See <code>SEWDProcessor.__call__</code> for details.`,name:"input_values"},{anchor:"transformers.SEWDForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SEWDForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SEWDForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SEWDForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SEWDForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/sew_d/modeling_sew_d.py#L1603",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/sew-d#transformers.SEWDConfig"
>SEWDConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),H=new jt({props:{$$slots:{default:[co]},$$scope:{ctx:M}}}),L=new ot({props:{anchor:"transformers.SEWDForSequenceClassification.forward.example",$$slots:{default:[mo]},$$scope:{ctx:M}}}),X=new ot({props:{anchor:"transformers.SEWDForSequenceClassification.forward.example-2",$$slots:{default:[po]},$$scope:{ctx:M}}}),_e=new so({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/sew-d.md"}}),{c(){t=m("meta"),w=a(),c=m("p"),d=a(),f(v.$$.fragment),o=a(),T=m("div"),T.innerHTML=xt,ze=a(),f(A.$$.fragment),qe=a(),P=m("p"),P.innerHTML=Jt,Ze=a(),O=m("p"),O.textContent=Dt,Re=a(),K=m("p"),K.innerHTML=Ft,Ge=a(),ee=m("p"),ee.innerHTML=Ut,Ve=a(),f(te.$$.fragment),Ie=a(),oe=m("ul"),oe.innerHTML=zt,Ne=a(),f(ne.$$.fragment),Be=a(),se=m("ul"),se.innerHTML=qt,He=a(),f(ae.$$.fragment),Le=a(),W=m("div"),f(re.$$.fragment),st=a(),ve=m("p"),ve.innerHTML=Zt,at=a(),we=m("p"),we.innerHTML=Rt,rt=a(),f(G.$$.fragment),it=a(),V=m("div"),f(ie.$$.fragment),lt=a(),Te=m("p"),Te.textContent=Gt,Xe=a(),f(le.$$.fragment),Ye=a(),C=m("div"),f(ce.$$.fragment),ct=a(),Me=m("p"),Me.textContent=Vt,dt=a(),We=m("p"),We.innerHTML=It,mt=a(),Ce=m("p"),Ce.innerHTML=Nt,pt=a(),z=m("div"),f(de.$$.fragment),ut=a(),ke=m("p"),ke.innerHTML=Bt,ft=a(),f(I.$$.fragment),Qe=a(),f(me.$$.fragment),Ae=a(),k=m("div"),f(pe.$$.fragment),ht=a(),$e=m("p"),$e.innerHTML=Ht,gt=a(),Se=m("p"),Se.innerHTML=Lt,_t=a(),Ee=m("p"),Ee.innerHTML=Xt,bt=a(),D=m("div"),f(ue.$$.fragment),yt=a(),je=m("p"),je.innerHTML=Yt,vt=a(),f(N.$$.fragment),wt=a(),f(B.$$.fragment),Pe=a(),f(fe.$$.fragment),Oe=a(),$=m("div"),f(he.$$.fragment),Tt=a(),xe=m("p"),xe.textContent=Qt,Mt=a(),Je=m("p"),Je.innerHTML=At,Wt=a(),De=m("p"),De.innerHTML=Pt,Ct=a(),S=m("div"),f(ge.$$.fragment),kt=a(),Fe=m("p"),Fe.innerHTML=Ot,$t=a(),f(H.$$.fragment),St=a(),f(L.$$.fragment),Et=a(),f(X.$$.fragment),Ke=a(),f(_e.$$.fragment),et=a(),Ue=m("p"),this.h()},l(e){const n=no("svelte-u9bgzb",document.head);t=p(n,"META",{name:!0,content:!0}),n.forEach(s),w=r(e),c=p(e,"P",{}),Z(c).forEach(s),d=r(e),h(v.$$.fragment,e),o=r(e),T=p(e,"DIV",{class:!0,"data-svelte-h":!0}),u(T)!=="svelte-13t8s2t"&&(T.innerHTML=xt),ze=r(e),h(A.$$.fragment,e),qe=r(e),P=p(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-cpeez1"&&(P.innerHTML=Jt),Ze=r(e),O=p(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-vfdo9a"&&(O.textContent=Dt),Re=r(e),K=p(e,"P",{"data-svelte-h":!0}),u(K)!=="svelte-119whrz"&&(K.innerHTML=Ft),Ge=r(e),ee=p(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-1txcwhb"&&(ee.innerHTML=Ut),Ve=r(e),h(te.$$.fragment,e),Ie=r(e),oe=p(e,"UL",{"data-svelte-h":!0}),u(oe)!=="svelte-12z9zbq"&&(oe.innerHTML=zt),Ne=r(e),h(ne.$$.fragment,e),Be=r(e),se=p(e,"UL",{"data-svelte-h":!0}),u(se)!=="svelte-11qmliz"&&(se.innerHTML=qt),He=r(e),h(ae.$$.fragment,e),Le=r(e),W=p(e,"DIV",{class:!0});var E=Z(W);h(re.$$.fragment,E),st=r(E),ve=p(E,"P",{"data-svelte-h":!0}),u(ve)!=="svelte-1ggh5wr"&&(ve.innerHTML=Zt),at=r(E),we=p(E,"P",{"data-svelte-h":!0}),u(we)!=="svelte-o55m63"&&(we.innerHTML=Rt),rt=r(E),h(G.$$.fragment,E),it=r(E),V=p(E,"DIV",{class:!0});var be=Z(V);h(ie.$$.fragment,be),lt=r(be),Te=p(be,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-1ww3wqq"&&(Te.textContent=Gt),be.forEach(s),E.forEach(s),Xe=r(e),h(le.$$.fragment,e),Ye=r(e),C=p(e,"DIV",{class:!0});var j=Z(C);h(ce.$$.fragment,j),ct=r(j),Me=p(j,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-1gjlu75"&&(Me.textContent=Vt),dt=r(j),We=p(j,"P",{"data-svelte-h":!0}),u(We)!=="svelte-6pahdo"&&(We.innerHTML=It),mt=r(j),Ce=p(j,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-hswkmf"&&(Ce.innerHTML=Nt),pt=r(j),z=p(j,"DIV",{class:!0});var R=Z(z);h(de.$$.fragment,R),ut=r(R),ke=p(R,"P",{"data-svelte-h":!0}),u(ke)!=="svelte-1wl0akj"&&(ke.innerHTML=Bt),ft=r(R),h(I.$$.fragment,R),R.forEach(s),j.forEach(s),Qe=r(e),h(me.$$.fragment,e),Ae=r(e),k=p(e,"DIV",{class:!0});var x=Z(k);h(pe.$$.fragment,x),ht=r(x),$e=p(x,"P",{"data-svelte-h":!0}),u($e)!=="svelte-pnpws"&&($e.innerHTML=Ht),gt=r(x),Se=p(x,"P",{"data-svelte-h":!0}),u(Se)!=="svelte-6pahdo"&&(Se.innerHTML=Lt),_t=r(x),Ee=p(x,"P",{"data-svelte-h":!0}),u(Ee)!=="svelte-hswkmf"&&(Ee.innerHTML=Xt),bt=r(x),D=p(x,"DIV",{class:!0});var F=Z(D);h(ue.$$.fragment,F),yt=r(F),je=p(F,"P",{"data-svelte-h":!0}),u(je)!=="svelte-x0u0wv"&&(je.innerHTML=Yt),vt=r(F),h(N.$$.fragment,F),wt=r(F),h(B.$$.fragment,F),F.forEach(s),x.forEach(s),Pe=r(e),h(fe.$$.fragment,e),Oe=r(e),$=p(e,"DIV",{class:!0});var J=Z($);h(he.$$.fragment,J),Tt=r(J),xe=p(J,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-1d37eyv"&&(xe.textContent=Qt),Mt=r(J),Je=p(J,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-6pahdo"&&(Je.innerHTML=At),Wt=r(J),De=p(J,"P",{"data-svelte-h":!0}),u(De)!=="svelte-hswkmf"&&(De.innerHTML=Pt),Ct=r(J),S=p(J,"DIV",{class:!0});var q=Z(S);h(ge.$$.fragment,q),kt=r(q),Fe=p(q,"P",{"data-svelte-h":!0}),u(Fe)!=="svelte-wgsh2v"&&(Fe.innerHTML=Ot),$t=r(q),h(H.$$.fragment,q),St=r(q),h(L.$$.fragment,q),Et=r(q),h(X.$$.fragment,q),q.forEach(s),J.forEach(s),Ke=r(e),h(_e.$$.fragment,e),et=r(e),Ue=p(e,"P",{}),Z(Ue).forEach(s),this.h()},h(){U(t,"name","hf:doc:metadata"),U(t,"content",fo),U(T,"class","flex flex-wrap space-x-1"),U(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){i(document.head,t),l(e,w,n),l(e,c,n),l(e,d,n),g(v,e,n),l(e,o,n),l(e,T,n),l(e,ze,n),g(A,e,n),l(e,qe,n),l(e,P,n),l(e,Ze,n),l(e,O,n),l(e,Re,n),l(e,K,n),l(e,Ge,n),l(e,ee,n),l(e,Ve,n),g(te,e,n),l(e,Ie,n),l(e,oe,n),l(e,Ne,n),g(ne,e,n),l(e,Be,n),l(e,se,n),l(e,He,n),g(ae,e,n),l(e,Le,n),l(e,W,n),g(re,W,null),i(W,st),i(W,ve),i(W,at),i(W,we),i(W,rt),g(G,W,null),i(W,it),i(W,V),g(ie,V,null),i(V,lt),i(V,Te),l(e,Xe,n),g(le,e,n),l(e,Ye,n),l(e,C,n),g(ce,C,null),i(C,ct),i(C,Me),i(C,dt),i(C,We),i(C,mt),i(C,Ce),i(C,pt),i(C,z),g(de,z,null),i(z,ut),i(z,ke),i(z,ft),g(I,z,null),l(e,Qe,n),g(me,e,n),l(e,Ae,n),l(e,k,n),g(pe,k,null),i(k,ht),i(k,$e),i(k,gt),i(k,Se),i(k,_t),i(k,Ee),i(k,bt),i(k,D),g(ue,D,null),i(D,yt),i(D,je),i(D,vt),g(N,D,null),i(D,wt),g(B,D,null),l(e,Pe,n),g(fe,e,n),l(e,Oe,n),l(e,$,n),g(he,$,null),i($,Tt),i($,xe),i($,Mt),i($,Je),i($,Wt),i($,De),i($,Ct),i($,S),g(ge,S,null),i(S,kt),i(S,Fe),i(S,$t),g(H,S,null),i(S,St),g(L,S,null),i(S,Et),g(X,S,null),l(e,Ke,n),g(_e,e,n),l(e,et,n),l(e,Ue,n),tt=!0},p(e,[n]){const E={};n&2&&(E.$$scope={dirty:n,ctx:e}),G.$set(E);const be={};n&2&&(be.$$scope={dirty:n,ctx:e}),I.$set(be);const j={};n&2&&(j.$$scope={dirty:n,ctx:e}),N.$set(j);const R={};n&2&&(R.$$scope={dirty:n,ctx:e}),B.$set(R);const x={};n&2&&(x.$$scope={dirty:n,ctx:e}),H.$set(x);const F={};n&2&&(F.$$scope={dirty:n,ctx:e}),L.$set(F);const J={};n&2&&(J.$$scope={dirty:n,ctx:e}),X.$set(J)},i(e){tt||(_(v.$$.fragment,e),_(A.$$.fragment,e),_(te.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),_(re.$$.fragment,e),_(G.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),_(ce.$$.fragment,e),_(de.$$.fragment,e),_(I.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(ue.$$.fragment,e),_(N.$$.fragment,e),_(B.$$.fragment,e),_(fe.$$.fragment,e),_(he.$$.fragment,e),_(ge.$$.fragment,e),_(H.$$.fragment,e),_(L.$$.fragment,e),_(X.$$.fragment,e),_(_e.$$.fragment,e),tt=!0)},o(e){b(v.$$.fragment,e),b(A.$$.fragment,e),b(te.$$.fragment,e),b(ne.$$.fragment,e),b(ae.$$.fragment,e),b(re.$$.fragment,e),b(G.$$.fragment,e),b(ie.$$.fragment,e),b(le.$$.fragment,e),b(ce.$$.fragment,e),b(de.$$.fragment,e),b(I.$$.fragment,e),b(me.$$.fragment,e),b(pe.$$.fragment,e),b(ue.$$.fragment,e),b(N.$$.fragment,e),b(B.$$.fragment,e),b(fe.$$.fragment,e),b(he.$$.fragment,e),b(ge.$$.fragment,e),b(H.$$.fragment,e),b(L.$$.fragment,e),b(X.$$.fragment,e),b(_e.$$.fragment,e),tt=!1},d(e){e&&(s(w),s(c),s(d),s(o),s(T),s(ze),s(qe),s(P),s(Ze),s(O),s(Re),s(K),s(Ge),s(ee),s(Ve),s(Ie),s(oe),s(Ne),s(Be),s(se),s(He),s(Le),s(W),s(Xe),s(Ye),s(C),s(Qe),s(Ae),s(k),s(Pe),s(Oe),s($),s(Ke),s(et),s(Ue)),s(t),y(v,e),y(A,e),y(te,e),y(ne,e),y(ae,e),y(re),y(G),y(ie),y(le,e),y(ce),y(de),y(I),y(me,e),y(pe),y(ue),y(N),y(B),y(fe,e),y(he),y(ge),y(H),y(L),y(X),y(_e,e)}}}const fo='{"title":"SEW-D","local":"sew-d","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"SEWDConfig","local":"transformers.SEWDConfig","sections":[],"depth":2},{"title":"SEWDModel","local":"transformers.SEWDModel","sections":[],"depth":2},{"title":"SEWDForCTC","local":"transformers.SEWDForCTC","sections":[],"depth":2},{"title":"SEWDForSequenceClassification","local":"transformers.SEWDForSequenceClassification","sections":[],"depth":2}],"depth":1}';function ho(M){return eo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wo extends to{constructor(t){super(),oo(this,t,ho,uo,Kt,{})}}export{Wo as component};
