import{s as no,o as oo,n as lt}from"../chunks/scheduler.18a86fab.js";import{S as so,i as ro,g as i,s as o,r as u,A as ao,h as l,f as r,c as s,j as S,u as f,x as m,k as x,y as t,a as d,v as g,d as _,t as k,w as T}from"../chunks/index.98837b22.js";import{T as wn}from"../chunks/Tip.77304350.js";import{D as F}from"../chunks/Docstring.6758ea23.js";import{C as vn}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as yn}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as O}from"../chunks/Heading.7e7e0c5b.js";import{E as io}from"../chunks/index.499f366c.js";function lo(C){let a,b="Example:",p,h,w;return h=new vn({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwbGludGVyTW9kZWwlMkMlMjBTcGxpbnRlckNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBTcGxpbnRlciUyMHRhdSUyRnNwbGludGVyLWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwU3BsaW50ZXJDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjB0YXUlMkZzcGxpbnRlci1iYXNlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBTcGxpbnRlck1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SplinterModel, SplinterConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Splinter tau/splinter-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SplinterConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the tau/splinter-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SplinterModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){a=i("p"),a.textContent=b,p=o(),u(h.$$.fragment)},l(c){a=l(c,"P",{"data-svelte-h":!0}),m(a)!=="svelte-11lpom8"&&(a.textContent=b),p=s(c),f(h.$$.fragment,c)},m(c,y){d(c,a,y),d(c,p,y),g(h,c,y),w=!0},p:lt,i(c){w||(_(h.$$.fragment,c),w=!0)},o(c){k(h.$$.fragment,c),w=!1},d(c){c&&(r(a),r(p)),T(h,c)}}}function co(C){let a,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=b},l(p){a=l(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-fincs2"&&(a.innerHTML=b)},m(p,h){d(p,a,h)},p:lt,d(p){p&&r(a)}}}function po(C){let a,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=b},l(p){a=l(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-fincs2"&&(a.innerHTML=b)},m(p,h){d(p,a,h)},p:lt,d(p){p&&r(a)}}}function mo(C){let a,b="Example:",p,h,w;return h=new vn({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTcGxpbnRlckZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ0YXUlMkZzcGxpbnRlci1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwU3BsaW50ZXJGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIydGF1JTJGc3BsaW50ZXItYmFzZSUyMiklMEElMEFxdWVzdGlvbiUyQyUyMHRleHQlMjAlM0QlMjAlMjJXaG8lMjB3YXMlMjBKaW0lMjBIZW5zb24lM0YlMjIlMkMlMjAlMjJKaW0lMjBIZW5zb24lMjB3YXMlMjBhJTIwbmljZSUyMHB1cHBldCUyMiUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihxdWVzdGlvbiUyQyUyMHRleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBYW5zd2VyX3N0YXJ0X2luZGV4JTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMuYXJnbWF4KCklMEFhbnN3ZXJfZW5kX2luZGV4JTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRzLmFyZ21heCgpJTBBJTBBcHJlZGljdF9hbnN3ZXJfdG9rZW5zJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcyU1QjAlMkMlMjBhbnN3ZXJfc3RhcnRfaW5kZXglMjAlM0ElMjBhbnN3ZXJfZW5kX2luZGV4JTIwJTJCJTIwMSU1RCUwQXRva2VuaXplci5kZWNvZGUocHJlZGljdF9hbnN3ZXJfdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBJTBBJTIzJTIwdGFyZ2V0JTIwaXMlMjAlMjJuaWNlJTIwcHVwcGV0JTIyJTBBdGFyZ2V0X3N0YXJ0X2luZGV4JTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjE0JTVEKSUwQXRhcmdldF9lbmRfaW5kZXglMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMTUlNUQpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwc3RhcnRfcG9zaXRpb25zJTNEdGFyZ2V0X3N0YXJ0X2luZGV4JTJDJTIwZW5kX3Bvc2l0aW9ucyUzRHRhcmdldF9lbmRfaW5kZXgpJTBBbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQXJvdW5kKGxvc3MuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SplinterForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;tau/splinter-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SplinterForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;tau/splinter-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = outputs.start_logits.argmax()
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = outputs.end_logits.argmax()

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = inputs.input_ids[<span class="hljs-number">0</span>, answer_start_index : answer_end_index + <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(predict_answer_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
...

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># target is &quot;nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_start_index = torch.tensor([<span class="hljs-number">14</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>target_end_index = torch.tensor([<span class="hljs-number">15</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=target_start_index, end_positions=target_end_index)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){a=i("p"),a.textContent=b,p=o(),u(h.$$.fragment)},l(c){a=l(c,"P",{"data-svelte-h":!0}),m(a)!=="svelte-11lpom8"&&(a.textContent=b),p=s(c),f(h.$$.fragment,c)},m(c,y){d(c,a,y),d(c,p,y),g(h,c,y),w=!0},p:lt,i(c){w||(_(h.$$.fragment,c),w=!0)},o(c){k(h.$$.fragment,c),w=!1},d(c){c&&(r(a),r(p)),T(h,c)}}}function ho(C){let a,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=b},l(p){a=l(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-fincs2"&&(a.innerHTML=b)},m(p,h){d(p,a,h)},p:lt,d(p){p&&r(a)}}}function uo(C){let a,b="Example:",p,h,w;return h=new vn({props:{code:"",highlighted:"",wrap:!1}}),{c(){a=i("p"),a.textContent=b,p=o(),u(h.$$.fragment)},l(c){a=l(c,"P",{"data-svelte-h":!0}),m(a)!=="svelte-11lpom8"&&(a.textContent=b),p=s(c),f(h.$$.fragment,c)},m(c,y){d(c,a,y),d(c,p,y),g(h,c,y),w=!0},p:lt,i(c){w||(_(h.$$.fragment,c),w=!0)},o(c){k(h.$$.fragment,c),w=!1},d(c){c&&(r(a),r(p)),T(h,c)}}}function fo(C){let a,b,p,h,w,c,y,$n='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',pt,oe,mt,se,xn=`The Splinter model was proposed in <a href="https://arxiv.org/abs/2101.00438" rel="nofollow">Few-Shot Question Answering by Pretraining Span Selection</a> by Ori Ram, Yuval Kirstain, Jonathan Berant, Amir Globerson, Omer Levy. Splinter
is an encoder-only transformer (similar to BERT) pretrained using the recurring span selection task on a large corpus
comprising Wikipedia and the Toronto Book Corpus.`,ht,re,Sn="The abstract from the paper is the following:",ut,ae,zn=`In several question answering benchmarks, pretrained models have reached human parity through fine-tuning on an order
of 100,000 annotated questions and answers. We explore the more realistic few-shot setting, where only a few hundred
training examples are available, and observe that standard models perform poorly, highlighting the discrepancy between
current pretraining objectives and question answering. We propose a new pretraining scheme tailored for question
answering: recurring span selection. Given a passage with multiple sets of recurring spans, we mask in each set all
recurring spans but one, and ask the model to select the correct span in the passage for each masked span. Masked spans
are replaced with a special token, viewed as a question representation, that is later used during fine-tuning to select
the answer span. The resulting model obtains surprisingly good results on multiple benchmarks (e.g., 72.7 F1 on SQuAD
with only 128 training examples), while maintaining competitive performance in the high-resource setting.`,ft,ie,Mn='This model was contributed by <a href="https://huggingface.co/yuvalkirstain" rel="nofollow">yuvalkirstain</a> and <a href="https://huggingface.co/oriram" rel="nofollow">oriram</a>. The original code can be found <a href="https://github.com/oriram/splinter" rel="nofollow">here</a>.',gt,le,_t,de,qn=`<li>Splinter was trained to predict answers spans conditioned on a special [QUESTION] token. These tokens contextualize
to question representations which are used to predict the answers. This layer is called QASS, and is the default
behaviour in the <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterForQuestionAnswering">SplinterForQuestionAnswering</a> class. Therefore:</li> <li>Use <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterTokenizer">SplinterTokenizer</a> (rather than <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a>), as it already
contains this special token. Also, its default behavior is to use this token when two sequences are given (for
example, in the <em>run_qa.py</em> script).</li> <li>If you plan on using Splinter outside <em>run_qa.py</em>, please keep in mind the question token - it might be important for
the success of your model, especially in a few-shot setting.</li> <li>Please note there are two different checkpoints for each size of Splinter. Both are basically the same, except that
one also has the pretrained weights of the QASS layer (<em>tau/splinter-base-qass</em> and <em>tau/splinter-large-qass</em>) and one
doesn’t (<em>tau/splinter-base</em> and <em>tau/splinter-large</em>). This is done to support randomly initializing this layer at
fine-tuning, as it is shown to yield better results for some cases in the paper.</li>`,kt,ce,Tt,pe,Cn='<li><a href="../tasks/question-answering">Question answering task guide</a></li>',bt,me,wt,P,he,Wt,Ie,Fn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a>. It is used to instantiate an
Splinter model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Splinter
<a href="https://huggingface.co/tau/splinter-base" rel="nofollow">tau/splinter-base</a> architecture.`,Jt,We,Pn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,jt,Z,yt,ue,vt,v,fe,At,Je,Ln="Construct a Splinter tokenizer. Based on WordPiece.",Nt,je,In=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Bt,j,ge,Ut,Ae,Wn=`Build model inputs from a pair of sequence for question answering tasks by concatenating and adding special
tokens. A Splinter sequence has the following format:`,Ht,Ne,Jn="<li>single sequence: <code>[CLS] X [SEP]</code></li> <li>pair of sequences for question answering: <code>[CLS] question_tokens [QUESTION] . [SEP] context_tokens [SEP]</code></li>",Dt,G,_e,Ot,Be,jn=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,Et,A,ke,Qt,Ue,An=`Create the token type IDs corresponding to the sequences passed. <a href="../glossary#token-type-ids">What are token type
IDs?</a>`,Zt,He,Nn="Should be overridden in a subclass if the model has a special way of building those.",Gt,De,Te,$t,be,xt,L,we,Xt,Oe,Bn="Construct a “fast” Splinter tokenizer (backed by HuggingFace’s <em>tokenizers</em> library). Based on WordPiece.",Rt,Ee,Un=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,Vt,N,ye,Yt,Qe,Hn=`Build model inputs from a pair of sequence for question answering tasks by concatenating and adding special
tokens. A Splinter sequence has the following format:`,Kt,Ze,Dn="<li>single sequence: <code>[CLS] X [SEP]</code></li> <li>pair of sequences for question answering: <code>[CLS] question_tokens [QUESTION] . [SEP] context_tokens [SEP]</code></li>",St,ve,zt,z,$e,en,Ge,On="The bare Splinter Model outputting raw hidden-states without any specific head on top.",tn,Xe,En=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,nn,Re,Qn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,on,B,xe,sn,Ve,Zn='The <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a> forward method, overrides the <code>__call__</code> special method.',rn,X,Mt,Se,qt,M,ze,an,Ye,Gn=`The Splinter transformer with a span classification head on top for extractive question-answering tasks like
SQuAD (a linear layer on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,ln,Ke,Xn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,dn,et,Rn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,cn,I,Me,pn,tt,Vn='The <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterForQuestionAnswering">SplinterForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',mn,R,hn,V,Ct,qe,Ft,q,Ce,un,nt,Yn=`Splinter Model for the recurring span selection task as done during the pretraining. The difference to the QA task
is that we do not have a question, but multiple question tokens that replace the occurrences of recurring spans
instead.`,fn,ot,Kn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,gn,st,eo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,_n,W,Fe,kn,rt,to='The <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterForPreTraining">SplinterForPreTraining</a> forward method, overrides the <code>__call__</code> special method.',Tn,Y,bn,K,Pt,Pe,Lt,dt,It;return w=new O({props:{title:"Splinter",local:"splinter",headingTag:"h1"}}),oe=new O({props:{title:"Overview",local:"overview",headingTag:"h2"}}),le=new O({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ce=new O({props:{title:"Resources",local:"resources",headingTag:"h2"}}),me=new O({props:{title:"SplinterConfig",local:"transformers.SplinterConfig",headingTag:"h2"}}),he=new F({props:{name:"class transformers.SplinterConfig",anchor:"transformers.SplinterConfig",parameters:[{name:"vocab_size",val:" = 30522"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 512"},{name:"type_vocab_size",val:" = 2"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"question_token_id",val:" = 104"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SplinterConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30522) &#x2014;
Vocabulary size of the Splinter model. Defines the number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a>.`,name:"vocab_size"},{anchor:"transformers.SplinterConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimension of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.SplinterConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.SplinterConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.SplinterConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.SplinterConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.SplinterConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.SplinterConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.SplinterConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.SplinterConfig.type_vocab_size",description:`<strong>type_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The vocabulary size of the <code>token_type_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a>.`,name:"type_vocab_size"},{anchor:"transformers.SplinterConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.SplinterConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.SplinterConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.SplinterConfig.question_token_id",description:`<strong>question_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 104) &#x2014;
The id of the <code>[QUESTION]</code> token.`,name:"question_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/configuration_splinter.py#L24"}}),Z=new yn({props:{anchor:"transformers.SplinterConfig.example",$$slots:{default:[lo]},$$scope:{ctx:C}}}),ue=new O({props:{title:"SplinterTokenizer",local:"transformers.SplinterTokenizer",headingTag:"h2"}}),fe=new F({props:{name:"class transformers.SplinterTokenizer",anchor:"transformers.SplinterTokenizer",parameters:[{name:"vocab_file",val:""},{name:"do_lower_case",val:" = True"},{name:"do_basic_tokenize",val:" = True"},{name:"never_split",val:" = None"},{name:"unk_token",val:" = '[UNK]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '[PAD]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"question_token",val:" = '[QUESTION]'"},{name:"tokenize_chinese_chars",val:" = True"},{name:"strip_accents",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SplinterTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.SplinterTokenizer.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.SplinterTokenizer.do_basic_tokenize",description:`<strong>do_basic_tokenize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to do basic tokenization before WordPiece.`,name:"do_basic_tokenize"},{anchor:"transformers.SplinterTokenizer.never_split",description:`<strong>never_split</strong> (<code>Iterable</code>, <em>optional</em>) &#x2014;
Collection of tokens which will never be split during tokenization. Only has an effect when
<code>do_basic_tokenize=True</code>`,name:"never_split"},{anchor:"transformers.SplinterTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[UNK]&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.SplinterTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.SplinterTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.SplinterTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.SplinterTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.SplinterTokenizer.question_token",description:`<strong>question_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[QUESTION]&quot;</code>) &#x2014;
The token used for constructing question representations.`,name:"question_token"},{anchor:"transformers.SplinterTokenizer.tokenize_chinese_chars",description:`<strong>tokenize_chinese_chars</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to tokenize Chinese characters.</p>
<p>This should likely be deactivated for Japanese (see this
<a href="https://github.com/huggingface/transformers/issues/328" rel="nofollow">issue</a>).`,name:"tokenize_chinese_chars"},{anchor:"transformers.SplinterTokenizer.strip_accents",description:`<strong>strip_accents</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to strip all accents. If this option is not specified, then it will be determined by the
value for <code>lowercase</code> (as in the original BERT).`,name:"strip_accents"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/tokenization_splinter.py#L52"}}),ge=new F({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.SplinterTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.SplinterTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
The question token IDs if pad_on_right, else context tokens IDs`,name:"token_ids_0"},{anchor:"transformers.SplinterTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
The context token IDs if pad_on_right, else question token IDs`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/tokenization_splinter.py#L191",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),_e=new F({props:{name:"get_special_tokens_mask",anchor:"transformers.SplinterTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.SplinterTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.SplinterTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.SplinterTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/tokenization_splinter.py#L223",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ke=new F({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.SplinterTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.SplinterTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:"<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014; The first tokenized sequence.",name:"token_ids_0"},{anchor:"transformers.SplinterTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:"<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014; The second tokenized sequence.",name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/tokenization_splinter.py#L251",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The token type ids.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Te=new F({props:{name:"save_vocabulary",anchor:"transformers.SplinterTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/tokenization_splinter.py#L280"}}),be=new O({props:{title:"SplinterTokenizerFast",local:"transformers.SplinterTokenizerFast",headingTag:"h2"}}),we=new F({props:{name:"class transformers.SplinterTokenizerFast",anchor:"transformers.SplinterTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"do_lower_case",val:" = True"},{name:"unk_token",val:" = '[UNK]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '[PAD]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"question_token",val:" = '[QUESTION]'"},{name:"tokenize_chinese_chars",val:" = True"},{name:"strip_accents",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SplinterTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.SplinterTokenizerFast.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.SplinterTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[UNK]&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.SplinterTokenizerFast.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.SplinterTokenizerFast.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.SplinterTokenizerFast.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.SplinterTokenizerFast.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.SplinterTokenizerFast.question_token",description:`<strong>question_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[QUESTION]&quot;</code>) &#x2014;
The token used for constructing question representations.`,name:"question_token"},{anchor:"transformers.SplinterTokenizerFast.clean_text",description:`<strong>clean_text</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the text before tokenization by removing any control characters and replacing all
whitespaces by the classic one.`,name:"clean_text"},{anchor:"transformers.SplinterTokenizerFast.tokenize_chinese_chars",description:`<strong>tokenize_chinese_chars</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to tokenize Chinese characters. This should likely be deactivated for Japanese (see <a href="https://github.com/huggingface/transformers/issues/328" rel="nofollow">this
issue</a>).`,name:"tokenize_chinese_chars"},{anchor:"transformers.SplinterTokenizerFast.strip_accents",description:`<strong>strip_accents</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to strip all accents. If this option is not specified, then it will be determined by the
value for <code>lowercase</code> (as in the original BERT).`,name:"strip_accents"},{anchor:"transformers.SplinterTokenizerFast.wordpieces_prefix",description:`<strong>wordpieces_prefix</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;##&quot;</code>) &#x2014;
The prefix for subwords.`,name:"wordpieces_prefix"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/tokenization_splinter_fast.py#L32"}}),ye=new F({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.SplinterTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.SplinterTokenizerFast.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
The question token IDs if pad_on_right, else context tokens IDs`,name:"token_ids_0"},{anchor:"transformers.SplinterTokenizerFast.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
The context token IDs if pad_on_right, else question token IDs`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/tokenization_splinter_fast.py#L127",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ve=new O({props:{title:"SplinterModel",local:"transformers.SplinterModel",headingTag:"h2"}}),$e=new F({props:{name:"class transformers.SplinterModel",anchor:"transformers.SplinterModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SplinterModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/modeling_splinter.py#L536"}}),xe=new F({props:{name:"forward",anchor:"transformers.SplinterModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SplinterModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SplinterModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SplinterModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.Tensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.SplinterModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.Tensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SplinterModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SplinterModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SplinterModel.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention
if the model is configured as a decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.SplinterModel.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on the padding token indices of the encoder input. This mask is used in
the cross-attention if the model is configured as a decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>`,name:"encoder_attention_mask"},{anchor:"transformers.SplinterModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.SplinterModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.SplinterModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SplinterModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SplinterModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/modeling_splinter.py#L568",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterConfig"
>SplinterConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),X=new wn({props:{$$slots:{default:[co]},$$scope:{ctx:C}}}),Se=new O({props:{title:"SplinterForQuestionAnswering",local:"transformers.SplinterForQuestionAnswering",headingTag:"h2"}}),ze=new F({props:{name:"class transformers.SplinterForQuestionAnswering",anchor:"transformers.SplinterForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SplinterForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterForQuestionAnswering">SplinterForQuestionAnswering</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/modeling_splinter.py#L743"}}),Me=new F({props:{name:"forward",anchor:"transformers.SplinterForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"start_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"end_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"question_positions",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.SplinterForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SplinterForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SplinterForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.Tensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.SplinterForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.Tensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SplinterForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SplinterForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SplinterForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.SplinterForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"},{anchor:"transformers.SplinterForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SplinterForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SplinterForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SplinterForQuestionAnswering.forward.question_positions",description:`<strong>question_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_questions)</code>, <em>optional</em>) &#x2014;
The positions of all question tokens. If given, start_logits and end_logits will be of shape <code>(batch_size, num_questions, sequence_length)</code>. If None, the first question token in each sequence in the batch will be
the only one for which start_logits and end_logits are calculated and they will be of shape <code>(batch_size, sequence_length)</code>.`,name:"question_positions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/modeling_splinter.py#L755",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterConfig"
>SplinterConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),R=new wn({props:{$$slots:{default:[po]},$$scope:{ctx:C}}}),V=new yn({props:{anchor:"transformers.SplinterForQuestionAnswering.forward.example",$$slots:{default:[mo]},$$scope:{ctx:C}}}),qe=new O({props:{title:"SplinterForPreTraining",local:"transformers.SplinterForPreTraining",headingTag:"h2"}}),Ce=new F({props:{name:"class transformers.SplinterForPreTraining",anchor:"transformers.SplinterForPreTraining",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SplinterForPreTraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterForPreTraining">SplinterForPreTraining</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/modeling_splinter.py#L890"}}),Fe=new F({props:{name:"forward",anchor:"transformers.SplinterForPreTraining.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"start_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"end_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"question_positions",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.SplinterForPreTraining.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_questions, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SplinterForPreTraining.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SplinterForPreTraining.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.Tensor</code> of shape <code>batch_size, num_questions, sequence_length</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.SplinterForPreTraining.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.Tensor</code> of shape <code>batch_size, num_questions, sequence_length</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SplinterForPreTraining.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SplinterForPreTraining.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_questions, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SplinterForPreTraining.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_questions)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.SplinterForPreTraining.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_questions)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"},{anchor:"transformers.SplinterForPreTraining.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SplinterForPreTraining.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SplinterForPreTraining.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SplinterForPreTraining.forward.question_positions",description:`<strong>question_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_questions)</code>, <em>optional</em>) &#x2014;
The positions of all question tokens. If given, start_logits and end_logits will be of shape <code>(batch_size, num_questions, sequence_length)</code>. If None, the first question token in each sequence in the batch will be
the only one for which start_logits and end_logits are calculated and they will be of shape <code>(batch_size, sequence_length)</code>.`,name:"question_positions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/modeling_splinter.py#L908",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.splinter.modeling_splinter.SplinterForPreTrainingOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterConfig"
>SplinterConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when start and end positions are provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_questions, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_questions, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.splinter.modeling_splinter.SplinterForPreTrainingOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Y=new wn({props:{$$slots:{default:[ho]},$$scope:{ctx:C}}}),K=new yn({props:{anchor:"transformers.SplinterForPreTraining.forward.example",$$slots:{default:[uo]},$$scope:{ctx:C}}}),Pe=new io({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/splinter.md"}}),{c(){a=i("meta"),b=o(),p=i("p"),h=o(),u(w.$$.fragment),c=o(),y=i("div"),y.innerHTML=$n,pt=o(),u(oe.$$.fragment),mt=o(),se=i("p"),se.innerHTML=xn,ht=o(),re=i("p"),re.textContent=Sn,ut=o(),ae=i("p"),ae.textContent=zn,ft=o(),ie=i("p"),ie.innerHTML=Mn,gt=o(),u(le.$$.fragment),_t=o(),de=i("ul"),de.innerHTML=qn,kt=o(),u(ce.$$.fragment),Tt=o(),pe=i("ul"),pe.innerHTML=Cn,bt=o(),u(me.$$.fragment),wt=o(),P=i("div"),u(he.$$.fragment),Wt=o(),Ie=i("p"),Ie.innerHTML=Fn,Jt=o(),We=i("p"),We.innerHTML=Pn,jt=o(),u(Z.$$.fragment),yt=o(),u(ue.$$.fragment),vt=o(),v=i("div"),u(fe.$$.fragment),At=o(),Je=i("p"),Je.textContent=Ln,Nt=o(),je=i("p"),je.innerHTML=In,Bt=o(),j=i("div"),u(ge.$$.fragment),Ut=o(),Ae=i("p"),Ae.textContent=Wn,Ht=o(),Ne=i("ul"),Ne.innerHTML=Jn,Dt=o(),G=i("div"),u(_e.$$.fragment),Ot=o(),Be=i("p"),Be.innerHTML=jn,Et=o(),A=i("div"),u(ke.$$.fragment),Qt=o(),Ue=i("p"),Ue.innerHTML=An,Zt=o(),He=i("p"),He.textContent=Nn,Gt=o(),De=i("div"),u(Te.$$.fragment),$t=o(),u(be.$$.fragment),xt=o(),L=i("div"),u(we.$$.fragment),Xt=o(),Oe=i("p"),Oe.innerHTML=Bn,Rt=o(),Ee=i("p"),Ee.innerHTML=Un,Vt=o(),N=i("div"),u(ye.$$.fragment),Yt=o(),Qe=i("p"),Qe.textContent=Hn,Kt=o(),Ze=i("ul"),Ze.innerHTML=Dn,St=o(),u(ve.$$.fragment),zt=o(),z=i("div"),u($e.$$.fragment),en=o(),Ge=i("p"),Ge.textContent=On,tn=o(),Xe=i("p"),Xe.innerHTML=En,nn=o(),Re=i("p"),Re.innerHTML=Qn,on=o(),B=i("div"),u(xe.$$.fragment),sn=o(),Ve=i("p"),Ve.innerHTML=Zn,rn=o(),u(X.$$.fragment),Mt=o(),u(Se.$$.fragment),qt=o(),M=i("div"),u(ze.$$.fragment),an=o(),Ye=i("p"),Ye.innerHTML=Gn,ln=o(),Ke=i("p"),Ke.innerHTML=Xn,dn=o(),et=i("p"),et.innerHTML=Rn,cn=o(),I=i("div"),u(Me.$$.fragment),pn=o(),tt=i("p"),tt.innerHTML=Vn,mn=o(),u(R.$$.fragment),hn=o(),u(V.$$.fragment),Ct=o(),u(qe.$$.fragment),Ft=o(),q=i("div"),u(Ce.$$.fragment),un=o(),nt=i("p"),nt.textContent=Yn,fn=o(),ot=i("p"),ot.innerHTML=Kn,gn=o(),st=i("p"),st.innerHTML=eo,_n=o(),W=i("div"),u(Fe.$$.fragment),kn=o(),rt=i("p"),rt.innerHTML=to,Tn=o(),u(Y.$$.fragment),bn=o(),u(K.$$.fragment),Pt=o(),u(Pe.$$.fragment),Lt=o(),dt=i("p"),this.h()},l(e){const n=ao("svelte-u9bgzb",document.head);a=l(n,"META",{name:!0,content:!0}),n.forEach(r),b=s(e),p=l(e,"P",{}),S(p).forEach(r),h=s(e),f(w.$$.fragment,e),c=s(e),y=l(e,"DIV",{class:!0,"data-svelte-h":!0}),m(y)!=="svelte-13t8s2t"&&(y.innerHTML=$n),pt=s(e),f(oe.$$.fragment,e),mt=s(e),se=l(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-1nfobji"&&(se.innerHTML=xn),ht=s(e),re=l(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-vfdo9a"&&(re.textContent=Sn),ut=s(e),ae=l(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-m8m8di"&&(ae.textContent=zn),ft=s(e),ie=l(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-1hzgtbk"&&(ie.innerHTML=Mn),gt=s(e),f(le.$$.fragment,e),_t=s(e),de=l(e,"UL",{"data-svelte-h":!0}),m(de)!=="svelte-1bvknpp"&&(de.innerHTML=qn),kt=s(e),f(ce.$$.fragment,e),Tt=s(e),pe=l(e,"UL",{"data-svelte-h":!0}),m(pe)!=="svelte-1orm8os"&&(pe.innerHTML=Cn),bt=s(e),f(me.$$.fragment,e),wt=s(e),P=l(e,"DIV",{class:!0});var J=S(P);f(he.$$.fragment,J),Wt=s(J),Ie=l(J,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-1qexkr4"&&(Ie.innerHTML=Fn),Jt=s(J),We=l(J,"P",{"data-svelte-h":!0}),m(We)!=="svelte-o55m63"&&(We.innerHTML=Pn),jt=s(J),f(Z.$$.fragment,J),J.forEach(r),yt=s(e),f(ue.$$.fragment,e),vt=s(e),v=l(e,"DIV",{class:!0});var $=S(v);f(fe.$$.fragment,$),At=s($),Je=l($,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-1auu3gg"&&(Je.textContent=Ln),Nt=s($),je=l($,"P",{"data-svelte-h":!0}),m(je)!=="svelte-1c3t5ty"&&(je.innerHTML=In),Bt=s($),j=l($,"DIV",{class:!0});var E=S(j);f(ge.$$.fragment,E),Ut=s(E),Ae=l(E,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-1di5c8i"&&(Ae.textContent=Wn),Ht=s(E),Ne=l(E,"UL",{"data-svelte-h":!0}),m(Ne)!=="svelte-18p1y68"&&(Ne.innerHTML=Jn),E.forEach(r),Dt=s($),G=l($,"DIV",{class:!0});var Le=S(G);f(_e.$$.fragment,Le),Ot=s(Le),Be=l(Le,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-1f4f5kp"&&(Be.innerHTML=jn),Le.forEach(r),Et=s($),A=l($,"DIV",{class:!0});var Q=S(A);f(ke.$$.fragment,Q),Qt=s(Q),Ue=l(Q,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-zj1vf1"&&(Ue.innerHTML=An),Zt=s(Q),He=l(Q,"P",{"data-svelte-h":!0}),m(He)!=="svelte-9vptpw"&&(He.textContent=Nn),Q.forEach(r),Gt=s($),De=l($,"DIV",{class:!0});var ct=S(De);f(Te.$$.fragment,ct),ct.forEach(r),$.forEach(r),$t=s(e),f(be.$$.fragment,e),xt=s(e),L=l(e,"DIV",{class:!0});var ee=S(L);f(we.$$.fragment,ee),Xt=s(ee),Oe=l(ee,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-t7sr0h"&&(Oe.innerHTML=Bn),Rt=s(ee),Ee=l(ee,"P",{"data-svelte-h":!0}),m(Ee)!=="svelte-fh0aq"&&(Ee.innerHTML=Un),Vt=s(ee),N=l(ee,"DIV",{class:!0});var at=S(N);f(ye.$$.fragment,at),Yt=s(at),Qe=l(at,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-1di5c8i"&&(Qe.textContent=Hn),Kt=s(at),Ze=l(at,"UL",{"data-svelte-h":!0}),m(Ze)!=="svelte-18p1y68"&&(Ze.innerHTML=Dn),at.forEach(r),ee.forEach(r),St=s(e),f(ve.$$.fragment,e),zt=s(e),z=l(e,"DIV",{class:!0});var U=S(z);f($e.$$.fragment,U),en=s(U),Ge=l(U,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-1lpcrht"&&(Ge.textContent=On),tn=s(U),Xe=l(U,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-6pahdo"&&(Xe.innerHTML=En),nn=s(U),Re=l(U,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-hswkmf"&&(Re.innerHTML=Qn),on=s(U),B=l(U,"DIV",{class:!0});var it=S(B);f(xe.$$.fragment,it),sn=s(it),Ve=l(it,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-pu5pk"&&(Ve.innerHTML=Zn),rn=s(it),f(X.$$.fragment,it),it.forEach(r),U.forEach(r),Mt=s(e),f(Se.$$.fragment,e),qt=s(e),M=l(e,"DIV",{class:!0});var H=S(M);f(ze.$$.fragment,H),an=s(H),Ye=l(H,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-1y4zmue"&&(Ye.innerHTML=Gn),ln=s(H),Ke=l(H,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-6pahdo"&&(Ke.innerHTML=Xn),dn=s(H),et=l(H,"P",{"data-svelte-h":!0}),m(et)!=="svelte-hswkmf"&&(et.innerHTML=Rn),cn=s(H),I=l(H,"DIV",{class:!0});var te=S(I);f(Me.$$.fragment,te),pn=s(te),tt=l(te,"P",{"data-svelte-h":!0}),m(tt)!=="svelte-u5s69c"&&(tt.innerHTML=Vn),mn=s(te),f(R.$$.fragment,te),hn=s(te),f(V.$$.fragment,te),te.forEach(r),H.forEach(r),Ct=s(e),f(qe.$$.fragment,e),Ft=s(e),q=l(e,"DIV",{class:!0});var D=S(q);f(Ce.$$.fragment,D),un=s(D),nt=l(D,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-1fwuwic"&&(nt.textContent=Yn),fn=s(D),ot=l(D,"P",{"data-svelte-h":!0}),m(ot)!=="svelte-6pahdo"&&(ot.innerHTML=Kn),gn=s(D),st=l(D,"P",{"data-svelte-h":!0}),m(st)!=="svelte-hswkmf"&&(st.innerHTML=eo),_n=s(D),W=l(D,"DIV",{class:!0});var ne=S(W);f(Fe.$$.fragment,ne),kn=s(ne),rt=l(ne,"P",{"data-svelte-h":!0}),m(rt)!=="svelte-iz2fqu"&&(rt.innerHTML=to),Tn=s(ne),f(Y.$$.fragment,ne),bn=s(ne),f(K.$$.fragment,ne),ne.forEach(r),D.forEach(r),Pt=s(e),f(Pe.$$.fragment,e),Lt=s(e),dt=l(e,"P",{}),S(dt).forEach(r),this.h()},h(){x(a,"name","hf:doc:metadata"),x(a,"content",go),x(y,"class","flex flex-wrap space-x-1"),x(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){t(document.head,a),d(e,b,n),d(e,p,n),d(e,h,n),g(w,e,n),d(e,c,n),d(e,y,n),d(e,pt,n),g(oe,e,n),d(e,mt,n),d(e,se,n),d(e,ht,n),d(e,re,n),d(e,ut,n),d(e,ae,n),d(e,ft,n),d(e,ie,n),d(e,gt,n),g(le,e,n),d(e,_t,n),d(e,de,n),d(e,kt,n),g(ce,e,n),d(e,Tt,n),d(e,pe,n),d(e,bt,n),g(me,e,n),d(e,wt,n),d(e,P,n),g(he,P,null),t(P,Wt),t(P,Ie),t(P,Jt),t(P,We),t(P,jt),g(Z,P,null),d(e,yt,n),g(ue,e,n),d(e,vt,n),d(e,v,n),g(fe,v,null),t(v,At),t(v,Je),t(v,Nt),t(v,je),t(v,Bt),t(v,j),g(ge,j,null),t(j,Ut),t(j,Ae),t(j,Ht),t(j,Ne),t(v,Dt),t(v,G),g(_e,G,null),t(G,Ot),t(G,Be),t(v,Et),t(v,A),g(ke,A,null),t(A,Qt),t(A,Ue),t(A,Zt),t(A,He),t(v,Gt),t(v,De),g(Te,De,null),d(e,$t,n),g(be,e,n),d(e,xt,n),d(e,L,n),g(we,L,null),t(L,Xt),t(L,Oe),t(L,Rt),t(L,Ee),t(L,Vt),t(L,N),g(ye,N,null),t(N,Yt),t(N,Qe),t(N,Kt),t(N,Ze),d(e,St,n),g(ve,e,n),d(e,zt,n),d(e,z,n),g($e,z,null),t(z,en),t(z,Ge),t(z,tn),t(z,Xe),t(z,nn),t(z,Re),t(z,on),t(z,B),g(xe,B,null),t(B,sn),t(B,Ve),t(B,rn),g(X,B,null),d(e,Mt,n),g(Se,e,n),d(e,qt,n),d(e,M,n),g(ze,M,null),t(M,an),t(M,Ye),t(M,ln),t(M,Ke),t(M,dn),t(M,et),t(M,cn),t(M,I),g(Me,I,null),t(I,pn),t(I,tt),t(I,mn),g(R,I,null),t(I,hn),g(V,I,null),d(e,Ct,n),g(qe,e,n),d(e,Ft,n),d(e,q,n),g(Ce,q,null),t(q,un),t(q,nt),t(q,fn),t(q,ot),t(q,gn),t(q,st),t(q,_n),t(q,W),g(Fe,W,null),t(W,kn),t(W,rt),t(W,Tn),g(Y,W,null),t(W,bn),g(K,W,null),d(e,Pt,n),g(Pe,e,n),d(e,Lt,n),d(e,dt,n),It=!0},p(e,[n]){const J={};n&2&&(J.$$scope={dirty:n,ctx:e}),Z.$set(J);const $={};n&2&&($.$$scope={dirty:n,ctx:e}),X.$set($);const E={};n&2&&(E.$$scope={dirty:n,ctx:e}),R.$set(E);const Le={};n&2&&(Le.$$scope={dirty:n,ctx:e}),V.$set(Le);const Q={};n&2&&(Q.$$scope={dirty:n,ctx:e}),Y.$set(Q);const ct={};n&2&&(ct.$$scope={dirty:n,ctx:e}),K.$set(ct)},i(e){It||(_(w.$$.fragment,e),_(oe.$$.fragment,e),_(le.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(he.$$.fragment,e),_(Z.$$.fragment,e),_(ue.$$.fragment,e),_(fe.$$.fragment,e),_(ge.$$.fragment,e),_(_e.$$.fragment,e),_(ke.$$.fragment,e),_(Te.$$.fragment,e),_(be.$$.fragment,e),_(we.$$.fragment,e),_(ye.$$.fragment,e),_(ve.$$.fragment,e),_($e.$$.fragment,e),_(xe.$$.fragment,e),_(X.$$.fragment,e),_(Se.$$.fragment,e),_(ze.$$.fragment,e),_(Me.$$.fragment,e),_(R.$$.fragment,e),_(V.$$.fragment,e),_(qe.$$.fragment,e),_(Ce.$$.fragment,e),_(Fe.$$.fragment,e),_(Y.$$.fragment,e),_(K.$$.fragment,e),_(Pe.$$.fragment,e),It=!0)},o(e){k(w.$$.fragment,e),k(oe.$$.fragment,e),k(le.$$.fragment,e),k(ce.$$.fragment,e),k(me.$$.fragment,e),k(he.$$.fragment,e),k(Z.$$.fragment,e),k(ue.$$.fragment,e),k(fe.$$.fragment,e),k(ge.$$.fragment,e),k(_e.$$.fragment,e),k(ke.$$.fragment,e),k(Te.$$.fragment,e),k(be.$$.fragment,e),k(we.$$.fragment,e),k(ye.$$.fragment,e),k(ve.$$.fragment,e),k($e.$$.fragment,e),k(xe.$$.fragment,e),k(X.$$.fragment,e),k(Se.$$.fragment,e),k(ze.$$.fragment,e),k(Me.$$.fragment,e),k(R.$$.fragment,e),k(V.$$.fragment,e),k(qe.$$.fragment,e),k(Ce.$$.fragment,e),k(Fe.$$.fragment,e),k(Y.$$.fragment,e),k(K.$$.fragment,e),k(Pe.$$.fragment,e),It=!1},d(e){e&&(r(b),r(p),r(h),r(c),r(y),r(pt),r(mt),r(se),r(ht),r(re),r(ut),r(ae),r(ft),r(ie),r(gt),r(_t),r(de),r(kt),r(Tt),r(pe),r(bt),r(wt),r(P),r(yt),r(vt),r(v),r($t),r(xt),r(L),r(St),r(zt),r(z),r(Mt),r(qt),r(M),r(Ct),r(Ft),r(q),r(Pt),r(Lt),r(dt)),r(a),T(w,e),T(oe,e),T(le,e),T(ce,e),T(me,e),T(he),T(Z),T(ue,e),T(fe),T(ge),T(_e),T(ke),T(Te),T(be,e),T(we),T(ye),T(ve,e),T($e),T(xe),T(X),T(Se,e),T(ze),T(Me),T(R),T(V),T(qe,e),T(Ce),T(Fe),T(Y),T(K),T(Pe,e)}}}const go='{"title":"Splinter","local":"splinter","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"SplinterConfig","local":"transformers.SplinterConfig","sections":[],"depth":2},{"title":"SplinterTokenizer","local":"transformers.SplinterTokenizer","sections":[],"depth":2},{"title":"SplinterTokenizerFast","local":"transformers.SplinterTokenizerFast","sections":[],"depth":2},{"title":"SplinterModel","local":"transformers.SplinterModel","sections":[],"depth":2},{"title":"SplinterForQuestionAnswering","local":"transformers.SplinterForQuestionAnswering","sections":[],"depth":2},{"title":"SplinterForPreTraining","local":"transformers.SplinterForPreTraining","sections":[],"depth":2}],"depth":1}';function _o(C){return oo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class So extends so{constructor(a){super(),ro(this,a,_o,fo,no,{})}}export{So as component};
