import{s as ca,o as ma,n as oa}from"../chunks/scheduler.18a86fab.js";import{S as ra,i as da,g as i,s as l,r as m,A as Ma,h as p,f as e,c as n,j as pa,u as r,x as o,k as W,y as ha,a,v as d,d as M,t as h,w as g,m as ga,n as ua}from"../chunks/index.98837b22.js";import{T as re}from"../chunks/Tip.77304350.js";import{C as f}from"../chunks/CodeBlock.8d0c2e8a.js";import{D as ya}from"../chunks/DocNotebookDropdown.a04a6b2a.js";import{H as J}from"../chunks/Heading.7e7e0c5b.js";import{E as fa}from"../chunks/index.499f366c.js";function Ja(w){let c;return{c(){c=ga("To run the following examples with a non-quantized version of the model checkpoint you will need at least 20GB of GPU memory.")},l(y){c=ua(y,"To run the following examples with a non-quantized version of the model checkpoint you will need at least 20GB of GPU memory.")},m(y,u){a(y,c,u)},d(y){y&&e(c)}}}function wa(w){let c,y=`It is a good idea to include the <code>bad_words_ids</code> in the call to <code>generate</code> to avoid errors arising when increasing
the <code>max_new_tokens</code>: the model will want to generate a new <code>&lt;image&gt;</code> or <code>&lt;fake_token_around_image&gt;</code> token when there
is no image being generated by the model.
You can set it on-the-fly as in this guide, or store in the <code>GenerationConfig</code> as described in the <a href="../generation_strategies">Text generation strategies</a> guide.`;return{c(){c=i("p"),c.innerHTML=y},l(u){c=p(u,"P",{"data-svelte-h":!0}),o(c)!=="svelte-uwc51d"&&(c.innerHTML=y)},m(u,j){a(u,c,j)},p:oa,d(u){u&&e(c)}}}function ja(w){let c,y=`For longer outputs like this, you will greatly benefit from tweaking the text generation strategy. This can help
you significantly improve the quality of the generated output. Check out <a href="../generation_strategies">Text generation strategies</a>
to learn more.`;return{c(){c=i("p"),c.innerHTML=y},l(u){c=p(u,"P",{"data-svelte-h":!0}),o(c)!=="svelte-79vr3a"&&(c.innerHTML=y)},m(u,j){a(u,c,j)},p:oa,d(u){u&&e(c)}}}function Ta(w){let c,y,u,j,v,Yt,N,Ft,_,de=`While individual tasks can be tackled by fine-tuning specialized models, an alternative approach
that has recently emerged and gained popularity is to use large models for a diverse set of tasks without fine-tuning.
For instance, large language models can handle such NLP tasks as summarization, translation, classification, and more.
This approach is no longer limited to a single modality, such as text, and in this guide, we will illustrate how you can
solve image-text tasks with a large multimodal model called IDEFICS.`,St,G,Me=`<a href="../model_doc/idefics">IDEFICS</a> is an open-access vision and language model based on <a href="https://huggingface.co/papers/2204.14198" rel="nofollow">Flamingo</a>,
a state-of-the-art visual language model initially developed by DeepMind. The model accepts arbitrary sequences of image
and text inputs and generates coherent text as output. It can answer questions about images, describe visual content,
create stories grounded in multiple images, and so on. IDEFICS comes in two variants - <a href="https://huggingface.co/HuggingFaceM4/idefics-80b" rel="nofollow">80 billion parameters</a>
and <a href="https://huggingface.co/HuggingFaceM4/idefics-9b" rel="nofollow">9 billion parameters</a>, both of which are available on the 🤗 Hub. For each variant, you can also find fine-tuned instructed
versions of the model adapted for conversational use cases.`,qt,Q,he=`This model is exceptionally versatile and can be used for a wide range of image and multimodal tasks. However,
being a large model means it requires significant computational resources and infrastructure. It is up to you to decide whether
this approach suits your use case better than fine-tuning specialized models for each individual task.`,Dt,B,ge="In this guide, you’ll learn how to:",At,z,ue='<li><a href="#loading-the-model">Load IDEFICS</a> and <a href="#quantized-model">load the quantized version of the model</a></li> <li>Use IDEFICS for: <ul><li><a href="#image-captioning">Image captioning</a></li> <li><a href="#prompted-image-captioning">Prompted image captioning</a></li> <li><a href="#few-shot-prompting">Few-shot prompting</a></li> <li><a href="#visual-question-answering">Visual question answering</a></li> <li><a href="#image-classification">Image classification</a></li> <li><a href="#image-guided-text-generation">Image-guided text generation</a></li></ul></li> <li><a href="#running-inference-in-batch-mode">Run inference in batch mode</a></li> <li><a href="#idefics-instruct-for-conversational-use">Run IDEFICS instruct for conversational use</a></li>',Lt,V,ye="Before you begin, make sure you have all the necessary libraries installed.",Pt,X,Ot,T,Kt,H,ts,$,fe="Let’s start by loading the model’s 9 billion parameters checkpoint:",ss,E,es,Y,Je=`Just like for other Transformers models, you need to load a processor and the model itself from the checkpoint.
The IDEFICS processor wraps a <a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizer">LlamaTokenizer</a> and IDEFICS image processor into a single processor to take care of
preparing text and image inputs for the model.`,as,F,ls,S,we=`Setting <code>device_map</code> to <code>&quot;auto&quot;</code> will automatically determine how to load and store the model weights in the most optimized
manner given existing devices.`,ns,q,is,D,je=`If high-memory GPU availability is an issue, you can load the quantized version of the model. To load the model and the
processor in 4bit precision, pass a <code>BitsAndBytesConfig</code> to the <code>from_pretrained</code> method and the model will be compressed
on the fly while loading.`,ps,A,os,L,Te="Now that you have the model loaded in one of the suggested ways, let’s move on to exploring tasks that you can use IDEFICS for.",cs,P,ms,O,Ue=`Image captioning is the task of predicting a caption for a given image. A common application is to aid visually impaired
people navigate through different situations, for instance, explore image content online.`,rs,K,be="To illustrate the task, get an image to be captioned, e.g.:",ds,U,Ze='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-im-captioning.jpg" alt="Image of a puppy in a flower bed"/>',Ms,tt,Ie='Photo by <a href="https://unsplash.com/@hendoo" rel="nofollow">Hendo Wang</a>.',hs,st,Ce=`IDEFICS accepts text and image prompts. However, to caption an image, you do not have to provide a text prompt to the
model, only the preprocessed input image. Without a text prompt, the model will start generating text from the
BOS (beginning-of-sequence) token thus creating a caption.`,gs,et,ke="As image input to the model, you can use either an image object (<code>PIL.Image</code>) or a url from which the image can be retrieved.",us,at,ys,b,fs,lt,Js,nt,Re=`You can extend image captioning by providing a text prompt, which the model will continue given the image. Let’s take
another image to illustrate:`,ws,Z,xe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-prompted-im-captioning.jpg" alt="Image of the Eiffel Tower at night"/>',js,it,We='Photo by <a href="https://unsplash.com/@dnevozhai" rel="nofollow">Denys Nevozhai</a>.',Ts,pt,ve="Textual and image prompts can be passed to the model’s processor as a single list to create appropriate inputs.",Us,ot,bs,ct,Zs,mt,Ne=`While IDEFICS demonstrates great zero-shot results, your task may require a certain format of the caption, or come with
other restrictions or requirements that increase task’s complexity. Few-shot prompting can be used to enable in-context learning.
By providing examples in the prompt, you can steer the model to generate results that mimic the format of given examples.`,Is,rt,_e=`Let’s use the previous image of the Eiffel Tower as an example for the model and build a prompt that demonstrates to the model
that in addition to learning what the object in an image is, we would also like to get some interesting information about it.
Then, let’s see, if we can get the same response format for an image of the Statue of Liberty:`,Cs,I,Ge='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-few-shot.jpg" alt="Image of the Statue of Liberty"/>',ks,dt,Qe='Photo by <a href="https://unsplash.com/@jmayobres" rel="nofollow">Juan Mayobre</a>.',Rs,Mt,xs,ht,Be=`Notice that just from a single example (i.e., 1-shot) the model has learned how to perform the task. For more complex tasks,
feel free to experiment with a larger number of examples (e.g., 3-shot, 5-shot, etc.).`,Ws,gt,vs,ut,ze=`Visual Question Answering (VQA) is the task of answering open-ended questions based on an image. Similar to image
captioning it can be used in accessibility applications, but also in education (reasoning about visual materials), customer
service (questions about products based on images), and image retrieval.`,Ns,yt,Ve="Let’s get a new image for this task:",_s,C,Xe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-vqa.jpg" alt="Image of a couple having a picnic"/>',Gs,ft,He='Photo by <a href="https://unsplash.com/@jarritos" rel="nofollow">Jarritos Mexican Soda</a>.',Qs,Jt,$e="You can steer the model from image captioning to visual question answering by prompting it with appropriate instructions:",Bs,wt,zs,jt,Vs,Tt,Ee=`IDEFICS is capable of classifying images into different categories without being explicitly trained on data containing
labeled examples from those specific categories. Given a list of categories and using its image and text understanding
capabilities, the model can infer which category the image likely belongs to.`,Xs,Ut,Ye="Say, we have this image of a vegetable stand:",Hs,k,Fe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-classification.jpg" alt="Image of a vegetable stand"/>',$s,bt,Se='Photo by <a href="https://unsplash.com/@peterwendt" rel="nofollow">Peter Wendt</a>.',Es,Zt,qe="We can instruct the model to classify the image into one of the categories that we have:",Ys,It,Fs,Ct,De="In the example above we instruct the model to classify the image into a single category, however, you can also prompt the model to do rank classification.",Ss,kt,qs,Rt,Ae=`For more creative applications, you can use image-guided text generation to generate text based on an image. This can be
useful to create descriptions of products, ads, descriptions of a scene, etc.`,Ds,xt,Le="Let’s prompt IDEFICS to write a story based on a simple image of a red door:",As,R,Pe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-story-generation.jpg" alt="Image of a red door with a pumpkin on the steps"/>',Ls,Wt,Oe='Photo by <a href="https://unsplash.com/@devonshiremedia" rel="nofollow">Craig Tidball</a>.',Ps,vt,Os,Nt,Ke="Looks like IDEFICS noticed the pumpkin on the doorstep and went with a spooky Halloween story about a ghost.",Ks,x,te,_t,se,Gt,ta=`All of the earlier sections illustrated IDEFICS for a single example. In a very similar fashion, you can run inference
for a batch of examples by passing a list of prompts:`,ee,Qt,ae,Bt,le,zt,sa=`For conversational use cases, you can find fine-tuned instructed versions of the model on the 🤗 Hub:
<code>HuggingFaceM4/idefics-80b-instruct</code> and <code>HuggingFaceM4/idefics-9b-instruct</code>.`,ne,Vt,ea=`These checkpoints are the result of fine-tuning the respective base models on a mixture of supervised and instruction
fine-tuning datasets, which boosts the downstream performance while making the models more usable in conversational settings.`,ie,Xt,aa="The use and prompting for the conversational use is very similar to using the base models:",pe,Ht,oe,$t,ce,Et,me;return v=new J({props:{title:"Image tasks with IDEFICS",local:"image-tasks-with-idefics",headingTag:"h1"}}),N=new ya({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/idefics.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/idefics.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/idefics.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/idefics.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/idefics.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/idefics.ipynb"}]}}),X=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwYml0c2FuZGJ5dGVzJTIwc2VudGVuY2VwaWVjZSUyMGFjY2VsZXJhdGUlMjB0cmFuc2Zvcm1lcnM=",highlighted:"pip install -q bitsandbytes sentencepiece accelerate transformers",wrap:!1}}),T=new re({props:{$$slots:{default:[Ja]},$$scope:{ctx:w}}}),H=new J({props:{title:"Loading the model",local:"loading-the-model",headingTag:"h2"}}),E=new f({props:{code:"Y2hlY2twb2ludCUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlTTQlMkZpZGVmaWNzLTliJTIy",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>',wrap:!1}}),F=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dCUyQyUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQW1vZGVsJTIwJTNEJTIwSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> IdeficsForVisionText2Text, AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsForVisionText2Text.from_pretrained(checkpoint, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),q=new J({props:{title:"Quantized model",local:"quantized-model",headingTag:"h3"}}),A=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dCUyQyUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQW1vZGVsJTIwJTNEJTIwSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY2hlY2twb2ludCUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> IdeficsForVisionText2Text, AutoProcessor, BitsAndBytesConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>quantization_config = BitsAndBytesConfig(
<span class="hljs-meta">... </span>    load_in_4bit=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    bnb_4bit_compute_dtype=torch.float16,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsForVisionText2Text.from_pretrained(
<span class="hljs-meta">... </span>    checkpoint,
<span class="hljs-meta">... </span>    quantization_config=quantization_config,
<span class="hljs-meta">... </span>    device_map=<span class="hljs-string">&quot;auto&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),P=new J({props:{title:"Image captioning",local:"image-captioning",headingTag:"h2"}}),at=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZpbWFnZXMudW5zcGxhc2guY29tJTJGcGhvdG8tMTU4MzE2MDI0NzcxMS0yMTkxNzc2YjRiOTElM0ZpeGxpYiUzRHJiLTQuMC4zJTI2aXhpZCUzRE0zd3hNakEzZkRCOE1IeHdhRzkwYnkxd1lXZGxmSHg4ZkdWdWZEQjhmSHg4ZkElMjUzRCUyNTNEJTI2YXV0byUzRGZvcm1hdCUyNmZpdCUzRGNyb3AlMjZ3JTNEMzU0MiUyNnElM0Q4MCUyMiUyQyUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQWJhZF93b3Jkc19pZHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyKCU1QiUyMiUzQ2ltYWdlJTNFJTIyJTJDJTIwJTIyJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlMjIlNUQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSkuaW5wdXRfaWRzJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUyMGJhZF93b3Jkc19pZHMlM0RiYWRfd29yZHNfaWRzKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZ2VuZXJhdGVkX3RleHQlNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1583160247711-2191776b4b91?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3542&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
A puppy <span class="hljs-keyword">in</span> a flower bed`,wrap:!1}}),b=new re({props:{$$slots:{default:[wa]},$$scope:{ctx:w}}}),lt=new J({props:{title:"Prompted image captioning",local:"prompted-image-captioning",headingTag:"h2"}}),ot=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZpbWFnZXMudW5zcGxhc2guY29tJTJGcGhvdG8tMTU0MzM0OTY4OS05YTRkNDI2YmVlOGUlM0ZpeGxpYiUzRHJiLTQuMC4zJTI2aXhpZCUzRE0zd3hNakEzZkRCOE1IeHdhRzkwYnkxd1lXZGxmSHg4ZkdWdWZEQjhmSHg4ZkElMjUzRCUyNTNEJTI2YXV0byUzRGZvcm1hdCUyNmZpdCUzRGNyb3AlMjZ3JTNEMzUwMSUyNnElM0Q4MCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBpcyUyMGFuJTIwaW1hZ2UlMjBvZiUyMCUyMiUyQyUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQWJhZF93b3Jkc19pZHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyKCU1QiUyMiUzQ2ltYWdlJTNFJTIyJTJDJTIwJTIyJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlMjIlNUQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSkuaW5wdXRfaWRzJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUyMGJhZF93b3Jkc19pZHMlM0RiYWRfd29yZHNfaWRzKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZ2VuZXJhdGVkX3RleHQlNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1543349689-9a4d426bee8e?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3501&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;This is an image of &quot;</span>,
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
This <span class="hljs-keyword">is</span> an image of the Eiffel Tower <span class="hljs-keyword">in</span> Paris, France.`,wrap:!1}}),ct=new J({props:{title:"Few-shot prompting",local:"few-shot-prompting",headingTag:"h2"}}),Mt=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTIyVXNlciUzQSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE1NDMzNDk2ODktOWE0ZDQyNmJlZThlJTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDM1MDElMjZxJTNEODAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJEZXNjcmliZSUyMHRoaXMlMjBpbWFnZS4lNUNuQXNzaXN0YW50JTNBJTIwQW4lMjBpbWFnZSUyMG9mJTIwdGhlJTIwRWlmZmVsJTIwVG93ZXIlMjBhdCUyMG5pZ2h0LiUyMEZ1biUyMGZhY3QlM0ElMjB0aGUlMjBFaWZmZWwlMjBUb3dlciUyMGlzJTIwdGhlJTIwc2FtZSUyMGhlaWdodCUyMGFzJTIwYW4lMjA4MS1zdG9yZXklMjBidWlsZGluZy4lNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyVXNlciUzQSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE1MjQwOTkxNjMyNTMtMzJiN2YwMjU2ODY4JTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDMzODclMjZxJTNEODAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJEZXNjcmliZSUyMHRoaXMlMjBpbWFnZS4lNUNuQXNzaXN0YW50JTNBJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBYmFkX3dvcmRzX2lkcyUyMCUzRCUyMHByb2Nlc3Nvci50b2tlbml6ZXIoJTVCJTIyJTNDaW1hZ2UlM0UlMjIlMkMlMjAlMjIlM0NmYWtlX3Rva2VuX2Fyb3VuZF9pbWFnZSUzRSUyMiU1RCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKS5pbnB1dF9pZHMlMEElMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDMwJTJDJTIwYmFkX3dvcmRzX2lkcyUzRGJhZF93b3Jkc19pZHMpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEFwcmludChnZW5lcmF0ZWRfdGV4dCU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">&quot;User:&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;https://images.unsplash.com/photo-1543349689-9a4d426bee8e?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3501&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;Describe this image.\\nAssistant: An image of the Eiffel Tower at night. Fun fact: the Eiffel Tower is the same height as an 81-storey building.\\n&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;User:&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;https://images.unsplash.com/photo-1524099163253-32b7f0256868?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3387&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;Describe this image.\\nAssistant:&quot;</span>
<span class="hljs-meta">... </span>           ]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">30</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
User: Describe this image.
Assistant: An image of the Eiffel Tower at night. Fun fact: the Eiffel Tower <span class="hljs-keyword">is</span> the same height <span class="hljs-keyword">as</span> an <span class="hljs-number">81</span>-storey building. 
User: Describe this image.
Assistant: An image of the Statue of Liberty. Fun fact: the Statue of Liberty <span class="hljs-keyword">is</span> <span class="hljs-number">151</span> feet tall.`,wrap:!1}}),gt=new J({props:{title:"Visual question answering",local:"visual-question-answering",headingTag:"h2"}}),wt=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIySW5zdHJ1Y3Rpb24lM0ElMjBQcm92aWRlJTIwYW4lMjBhbnN3ZXIlMjB0byUyMHRoZSUyMHF1ZXN0aW9uLiUyMFVzZSUyMHRoZSUyMGltYWdlJTIwdG8lMjBhbnN3ZXIuJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE2MjM5NDQ4ODkyODgtY2QxNDdkYmI1MTdjJTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDM1NDAlMjZxJTNEODAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJRdWVzdGlvbiUzQSUyMFdoZXJlJTIwYXJlJTIwdGhlc2UlMjBwZW9wbGUlMjBhbmQlMjB3aGF0J3MlMjB0aGUlMjB3ZWF0aGVyJTIwbGlrZSUzRiUyMEFuc3dlciUzQSUyMiUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQWJhZF93b3Jkc19pZHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyKCU1QiUyMiUzQ2ltYWdlJTNFJTIyJTJDJTIwJTIyJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlMjIlNUQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSkuaW5wdXRfaWRzJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCUyQyUyMGJhZF93b3Jkc19pZHMlM0RiYWRfd29yZHNfaWRzKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZ2VuZXJhdGVkX3RleHQlNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Instruction: Provide an answer to the question. Use the image to answer.\\n&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1623944889288-cd147dbb517c?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3540&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Question: Where are these people and what&#x27;s the weather like? Answer:&quot;</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">20</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
Instruction: Provide an answer to the question. Use the image to answer.
 Question: Where are these people <span class="hljs-keyword">and</span> what<span class="hljs-string">&#x27;s the weather like? Answer: They&#x27;</span>re <span class="hljs-keyword">in</span> a park <span class="hljs-keyword">in</span> New York City, <span class="hljs-keyword">and</span> it<span class="hljs-string">&#x27;s a beautiful day.</span>`,wrap:!1}}),jt=new J({props:{title:"Image classification",local:"image-classification",headingTag:"h2"}}),It=new f({props:{code:"Y2F0ZWdvcmllcyUyMCUzRCUyMCU1QidhbmltYWxzJyUyQyd2ZWdldGFibGVzJyUyQyUyMCdjaXR5JTIwbGFuZHNjYXBlJyUyQyUyMCdjYXJzJyUyQyUyMCdvZmZpY2UnJTVEJTBBcHJvbXB0JTIwJTNEJTIwJTVCZiUyMkluc3RydWN0aW9uJTNBJTIwQ2xhc3NpZnklMjB0aGUlMjBmb2xsb3dpbmclMjBpbWFnZSUyMGludG8lMjBhJTIwc2luZ2xlJTIwY2F0ZWdvcnklMjBmcm9tJTIwdGhlJTIwZm9sbG93aW5nJTIwbGlzdCUzQSUyMCU3QmNhdGVnb3JpZXMlN0QuJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE0NzExOTM5NDU1MDktOWFkMDYxN2FmYWJmJTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDM1NDAlMjZxJTNEODAlMjIlMkMlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjJDYXRlZ29yeSUzQSUyMCUyMiUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQWJhZF93b3Jkc19pZHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyKCU1QiUyMiUzQ2ltYWdlJTNFJTIyJTJDJTIwJTIyJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlMjIlNUQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSkuaW5wdXRfaWRzJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0Q2JTJDJTIwYmFkX3dvcmRzX2lkcyUzRGJhZF93b3Jkc19pZHMpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEFwcmludChnZW5lcmF0ZWRfdGV4dCU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>categories = [<span class="hljs-string">&#x27;animals&#x27;</span>,<span class="hljs-string">&#x27;vegetables&#x27;</span>, <span class="hljs-string">&#x27;city landscape&#x27;</span>, <span class="hljs-string">&#x27;cars&#x27;</span>, <span class="hljs-string">&#x27;office&#x27;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">f&quot;Instruction: Classify the following image into a single category from the following list: <span class="hljs-subst">{categories}</span>.\\n&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1471193945509-9ad0617afabf?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3540&amp;q=80&quot;</span>,    
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Category: &quot;</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">6</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
Instruction: Classify the following image into a single category <span class="hljs-keyword">from</span> the following <span class="hljs-built_in">list</span>: [<span class="hljs-string">&#x27;animals&#x27;</span>, <span class="hljs-string">&#x27;vegetables&#x27;</span>, <span class="hljs-string">&#x27;city landscape&#x27;</span>, <span class="hljs-string">&#x27;cars&#x27;</span>, <span class="hljs-string">&#x27;office&#x27;</span>].
Category: Vegetables`,wrap:!1}}),kt=new J({props:{title:"Image-guided text generation",local:"image-guided-text-generation",headingTag:"h2"}}),vt=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTIySW5zdHJ1Y3Rpb24lM0ElMjBVc2UlMjB0aGUlMjBpbWFnZSUyMHRvJTIwd3JpdGUlMjBhJTIwc3RvcnkuJTIwJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE1MTcwODY4MjIxNTctMmIwMzU4ZTc2ODRhJTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDIyMDMlMjZxJTNEODAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJTdG9yeSUzQSUyMCU1Q24lMjIlNUQlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEFiYWRfd29yZHNfaWRzJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplciglNUIlMjIlM0NpbWFnZSUzRSUyMiUyQyUyMCUyMiUzQ2Zha2VfdG9rZW5fYXJvdW5kX2ltYWdlJTNFJTIyJTVEJTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpLmlucHV0X2lkcyUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG51bV9iZWFtcyUzRDIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUyMGJhZF93b3Jkc19pZHMlM0RiYWRfd29yZHNfaWRzKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZ2VuZXJhdGVkX3RleHQlNUIwJTVEKSUyMCUwQSUwQSUwQSUwQSUwQSUwQSUwQSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">&quot;Instruction: Use the image to write a story. \\n&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1517086822157-2b0358e7684a?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=2203&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Story: \\n&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, num_beams=<span class="hljs-number">2</span>, max_new_tokens=<span class="hljs-number">200</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>]) 
Instruction: Use the image to write a story. 
 Story: 
Once upon a time, there was a little girl who lived <span class="hljs-keyword">in</span> a house <span class="hljs-keyword">with</span> a red door.  She loved her red door.  It was the prettiest door <span class="hljs-keyword">in</span> the whole world.

One day, the little girl was playing <span class="hljs-keyword">in</span> her yard when she noticed a man standing on her doorstep.  He was wearing a long black coat <span class="hljs-keyword">and</span> a top hat.

The little girl ran inside <span class="hljs-keyword">and</span> told her mother about the man.

Her mother said, “Don’t worry, honey.  He’s just a friendly ghost.”

The little girl wasn’t sure <span class="hljs-keyword">if</span> she believed her mother, but she went outside anyway.

When she got to the door, the man was gone.

The <span class="hljs-built_in">next</span> day, the little girl was playing <span class="hljs-keyword">in</span> her yard again when she noticed the man standing on her doorstep.

He was wearing a long black coat <span class="hljs-keyword">and</span> a top hat.

The little girl ran`,wrap:!1}}),x=new re({props:{$$slots:{default:[ja]},$$scope:{ctx:w}}}),_t=new J({props:{title:"Running inference in batch mode",local:"running-inference-in-batch-mode",headingTag:"h2"}}),Qt=new f({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = [
<span class="hljs-meta">... </span>    [   <span class="hljs-string">&quot;https://images.unsplash.com/photo-1543349689-9a4d426bee8e?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3501&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is an image of &quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    [   <span class="hljs-string">&quot;https://images.unsplash.com/photo-1623944889288-cd147dbb517c?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3540&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is an image of &quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    [   <span class="hljs-string">&quot;https://images.unsplash.com/photo-1471193945509-9ad0617afabf?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3540&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is an image of &quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i,t <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(generated_text):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{i}</span>:\\n<span class="hljs-subst">{t}</span>\\n&quot;</span>) 
<span class="hljs-number">0</span>:
This <span class="hljs-keyword">is</span> an image of the Eiffel Tower <span class="hljs-keyword">in</span> Paris, France.

<span class="hljs-number">1</span>:
This <span class="hljs-keyword">is</span> an image of a couple on a picnic blanket.

<span class="hljs-number">2</span>:
This <span class="hljs-keyword">is</span> an image of a vegetable stand.`,wrap:!1}}),Bt=new J({props:{title:"IDEFICS instruct for conversational use",local:"idefics-instruct-for-conversational-use",headingTag:"h2"}}),Ht=new f({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> IdeficsForVisionText2Text, AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend

<span class="hljs-meta">&gt;&gt;&gt; </span>device, _, _ = get_backend() <span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;HuggingFaceM4/idefics-9b-instruct&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsForVisionText2Text.from_pretrained(checkpoint, torch_dtype=torch.bfloat16).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = [
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;User: What is in this image?&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/8/86/Id%C3%A9fix.JPG&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;&lt;end_of_utterance&gt;&quot;</span>,

<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;\\nAssistant: This picture depicts Idefix, the dog of Obelix in Asterix and Obelix. Idefix is running on the ground.&lt;end_of_utterance&gt;&quot;</span>,

<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;\\nUser:&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;https://static.wikia.nocookie.net/asterix/images/2/25/R22b.gif/revision/latest?cb=20110815073052&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;And who is that?&lt;end_of_utterance&gt;&quot;</span>,

<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;\\nAssistant:&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># --batched mode</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompts, add_end_of_utterance_token=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># --single sample mode</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inputs = processor(prompts[0], return_tensors=&quot;pt&quot;).to(device)</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generation args</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>exit_condition = processor.tokenizer(<span class="hljs-string">&quot;&lt;end_of_utterance&gt;&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, eos_token_id=exit_condition, bad_words_ids=bad_words_ids, max_length=<span class="hljs-number">100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(generated_text):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{i}</span>:\\n<span class="hljs-subst">{t}</span>\\n&quot;</span>)`,wrap:!1}}),$t=new fa({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/idefics.md"}}),{c(){c=i("meta"),y=l(),u=i("p"),j=l(),m(v.$$.fragment),Yt=l(),m(N.$$.fragment),Ft=l(),_=i("p"),_.textContent=de,St=l(),G=i("p"),G.innerHTML=Me,qt=l(),Q=i("p"),Q.textContent=he,Dt=l(),B=i("p"),B.textContent=ge,At=l(),z=i("ul"),z.innerHTML=ue,Lt=l(),V=i("p"),V.textContent=ye,Pt=l(),m(X.$$.fragment),Ot=l(),m(T.$$.fragment),Kt=l(),m(H.$$.fragment),ts=l(),$=i("p"),$.textContent=fe,ss=l(),m(E.$$.fragment),es=l(),Y=i("p"),Y.innerHTML=Je,as=l(),m(F.$$.fragment),ls=l(),S=i("p"),S.innerHTML=we,ns=l(),m(q.$$.fragment),is=l(),D=i("p"),D.innerHTML=je,ps=l(),m(A.$$.fragment),os=l(),L=i("p"),L.textContent=Te,cs=l(),m(P.$$.fragment),ms=l(),O=i("p"),O.textContent=Ue,rs=l(),K=i("p"),K.textContent=be,ds=l(),U=i("div"),U.innerHTML=Ze,Ms=l(),tt=i("p"),tt.innerHTML=Ie,hs=l(),st=i("p"),st.textContent=Ce,gs=l(),et=i("p"),et.innerHTML=ke,us=l(),m(at.$$.fragment),ys=l(),m(b.$$.fragment),fs=l(),m(lt.$$.fragment),Js=l(),nt=i("p"),nt.textContent=Re,ws=l(),Z=i("div"),Z.innerHTML=xe,js=l(),it=i("p"),it.innerHTML=We,Ts=l(),pt=i("p"),pt.textContent=ve,Us=l(),m(ot.$$.fragment),bs=l(),m(ct.$$.fragment),Zs=l(),mt=i("p"),mt.textContent=Ne,Is=l(),rt=i("p"),rt.textContent=_e,Cs=l(),I=i("div"),I.innerHTML=Ge,ks=l(),dt=i("p"),dt.innerHTML=Qe,Rs=l(),m(Mt.$$.fragment),xs=l(),ht=i("p"),ht.textContent=Be,Ws=l(),m(gt.$$.fragment),vs=l(),ut=i("p"),ut.textContent=ze,Ns=l(),yt=i("p"),yt.textContent=Ve,_s=l(),C=i("div"),C.innerHTML=Xe,Gs=l(),ft=i("p"),ft.innerHTML=He,Qs=l(),Jt=i("p"),Jt.textContent=$e,Bs=l(),m(wt.$$.fragment),zs=l(),m(jt.$$.fragment),Vs=l(),Tt=i("p"),Tt.textContent=Ee,Xs=l(),Ut=i("p"),Ut.textContent=Ye,Hs=l(),k=i("div"),k.innerHTML=Fe,$s=l(),bt=i("p"),bt.innerHTML=Se,Es=l(),Zt=i("p"),Zt.textContent=qe,Ys=l(),m(It.$$.fragment),Fs=l(),Ct=i("p"),Ct.textContent=De,Ss=l(),m(kt.$$.fragment),qs=l(),Rt=i("p"),Rt.textContent=Ae,Ds=l(),xt=i("p"),xt.textContent=Le,As=l(),R=i("div"),R.innerHTML=Pe,Ls=l(),Wt=i("p"),Wt.innerHTML=Oe,Ps=l(),m(vt.$$.fragment),Os=l(),Nt=i("p"),Nt.textContent=Ke,Ks=l(),m(x.$$.fragment),te=l(),m(_t.$$.fragment),se=l(),Gt=i("p"),Gt.textContent=ta,ee=l(),m(Qt.$$.fragment),ae=l(),m(Bt.$$.fragment),le=l(),zt=i("p"),zt.innerHTML=sa,ne=l(),Vt=i("p"),Vt.textContent=ea,ie=l(),Xt=i("p"),Xt.textContent=aa,pe=l(),m(Ht.$$.fragment),oe=l(),m($t.$$.fragment),ce=l(),Et=i("p"),this.h()},l(t){const s=Ma("svelte-u9bgzb",document.head);c=p(s,"META",{name:!0,content:!0}),s.forEach(e),y=n(t),u=p(t,"P",{}),pa(u).forEach(e),j=n(t),r(v.$$.fragment,t),Yt=n(t),r(N.$$.fragment,t),Ft=n(t),_=p(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-11wnsr"&&(_.textContent=de),St=n(t),G=p(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1nt7nk6"&&(G.innerHTML=Me),qt=n(t),Q=p(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1k5g1sg"&&(Q.textContent=he),Dt=n(t),B=p(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-fp1hdi"&&(B.textContent=ge),At=n(t),z=p(t,"UL",{"data-svelte-h":!0}),o(z)!=="svelte-lzrpc8"&&(z.innerHTML=ue),Lt=n(t),V=p(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-qn4ey1"&&(V.textContent=ye),Pt=n(t),r(X.$$.fragment,t),Ot=n(t),r(T.$$.fragment,t),Kt=n(t),r(H.$$.fragment,t),ts=n(t),$=p(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-pbsmkm"&&($.textContent=fe),ss=n(t),r(E.$$.fragment,t),es=n(t),Y=p(t,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-5idral"&&(Y.innerHTML=Je),as=n(t),r(F.$$.fragment,t),ls=n(t),S=p(t,"P",{"data-svelte-h":!0}),o(S)!=="svelte-10jwul3"&&(S.innerHTML=we),ns=n(t),r(q.$$.fragment,t),is=n(t),D=p(t,"P",{"data-svelte-h":!0}),o(D)!=="svelte-gb566o"&&(D.innerHTML=je),ps=n(t),r(A.$$.fragment,t),os=n(t),L=p(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-vovwl0"&&(L.textContent=Te),cs=n(t),r(P.$$.fragment,t),ms=n(t),O=p(t,"P",{"data-svelte-h":!0}),o(O)!=="svelte-195xyco"&&(O.textContent=Ue),rs=n(t),K=p(t,"P",{"data-svelte-h":!0}),o(K)!=="svelte-syqfn9"&&(K.textContent=be),ds=n(t),U=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-t8y7db"&&(U.innerHTML=Ze),Ms=n(t),tt=p(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-knozkn"&&(tt.innerHTML=Ie),hs=n(t),st=p(t,"P",{"data-svelte-h":!0}),o(st)!=="svelte-10bztc1"&&(st.textContent=Ce),gs=n(t),et=p(t,"P",{"data-svelte-h":!0}),o(et)!=="svelte-sk4o55"&&(et.innerHTML=ke),us=n(t),r(at.$$.fragment,t),ys=n(t),r(b.$$.fragment,t),fs=n(t),r(lt.$$.fragment,t),Js=n(t),nt=p(t,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-15l3yis"&&(nt.textContent=Re),ws=n(t),Z=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(Z)!=="svelte-1ritb1k"&&(Z.innerHTML=xe),js=n(t),it=p(t,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1uz68x8"&&(it.innerHTML=We),Ts=n(t),pt=p(t,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-cncrxa"&&(pt.textContent=ve),Us=n(t),r(ot.$$.fragment,t),bs=n(t),r(ct.$$.fragment,t),Zs=n(t),mt=p(t,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-fytdtn"&&(mt.textContent=Ne),Is=n(t),rt=p(t,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-148v07a"&&(rt.textContent=_e),Cs=n(t),I=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(I)!=="svelte-gin1vp"&&(I.innerHTML=Ge),ks=n(t),dt=p(t,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-s7b8dy"&&(dt.innerHTML=Qe),Rs=n(t),r(Mt.$$.fragment,t),xs=n(t),ht=p(t,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-mpygyg"&&(ht.textContent=Be),Ws=n(t),r(gt.$$.fragment,t),vs=n(t),ut=p(t,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-cnfg69"&&(ut.textContent=ze),Ns=n(t),yt=p(t,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-nptt59"&&(yt.textContent=Ve),_s=n(t),C=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-1j2xr8e"&&(C.innerHTML=Xe),Gs=n(t),ft=p(t,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-1aj82zb"&&(ft.innerHTML=He),Qs=n(t),Jt=p(t,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-tdtrto"&&(Jt.textContent=$e),Bs=n(t),r(wt.$$.fragment,t),zs=n(t),r(jt.$$.fragment,t),Vs=n(t),Tt=p(t,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-a4cfdv"&&(Tt.textContent=Ee),Xs=n(t),Ut=p(t,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-1xbkffx"&&(Ut.textContent=Ye),Hs=n(t),k=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(k)!=="svelte-g02ga3"&&(k.innerHTML=Fe),$s=n(t),bt=p(t,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-17q4ltv"&&(bt.innerHTML=Se),Es=n(t),Zt=p(t,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-13lz1gw"&&(Zt.textContent=qe),Ys=n(t),r(It.$$.fragment,t),Fs=n(t),Ct=p(t,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-571z8p"&&(Ct.textContent=De),Ss=n(t),r(kt.$$.fragment,t),qs=n(t),Rt=p(t,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-1cpi6ml"&&(Rt.textContent=Ae),Ds=n(t),xt=p(t,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-bxfm2h"&&(xt.textContent=Le),As=n(t),R=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(R)!=="svelte-1mf93u3"&&(R.innerHTML=Pe),Ls=n(t),Wt=p(t,"P",{"data-svelte-h":!0}),o(Wt)!=="svelte-75pbgi"&&(Wt.innerHTML=Oe),Ps=n(t),r(vt.$$.fragment,t),Os=n(t),Nt=p(t,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-eumo01"&&(Nt.textContent=Ke),Ks=n(t),r(x.$$.fragment,t),te=n(t),r(_t.$$.fragment,t),se=n(t),Gt=p(t,"P",{"data-svelte-h":!0}),o(Gt)!=="svelte-2k4kpw"&&(Gt.textContent=ta),ee=n(t),r(Qt.$$.fragment,t),ae=n(t),r(Bt.$$.fragment,t),le=n(t),zt=p(t,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-ay5071"&&(zt.innerHTML=sa),ne=n(t),Vt=p(t,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-8tbmhu"&&(Vt.textContent=ea),ie=n(t),Xt=p(t,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-ccrnle"&&(Xt.textContent=aa),pe=n(t),r(Ht.$$.fragment,t),oe=n(t),r($t.$$.fragment,t),ce=n(t),Et=p(t,"P",{}),pa(Et).forEach(e),this.h()},h(){W(c,"name","hf:doc:metadata"),W(c,"content",Ua),W(U,"class","flex justify-center"),W(Z,"class","flex justify-center"),W(I,"class","flex justify-center"),W(C,"class","flex justify-center"),W(k,"class","flex justify-center"),W(R,"class","flex justify-center")},m(t,s){ha(document.head,c),a(t,y,s),a(t,u,s),a(t,j,s),d(v,t,s),a(t,Yt,s),d(N,t,s),a(t,Ft,s),a(t,_,s),a(t,St,s),a(t,G,s),a(t,qt,s),a(t,Q,s),a(t,Dt,s),a(t,B,s),a(t,At,s),a(t,z,s),a(t,Lt,s),a(t,V,s),a(t,Pt,s),d(X,t,s),a(t,Ot,s),d(T,t,s),a(t,Kt,s),d(H,t,s),a(t,ts,s),a(t,$,s),a(t,ss,s),d(E,t,s),a(t,es,s),a(t,Y,s),a(t,as,s),d(F,t,s),a(t,ls,s),a(t,S,s),a(t,ns,s),d(q,t,s),a(t,is,s),a(t,D,s),a(t,ps,s),d(A,t,s),a(t,os,s),a(t,L,s),a(t,cs,s),d(P,t,s),a(t,ms,s),a(t,O,s),a(t,rs,s),a(t,K,s),a(t,ds,s),a(t,U,s),a(t,Ms,s),a(t,tt,s),a(t,hs,s),a(t,st,s),a(t,gs,s),a(t,et,s),a(t,us,s),d(at,t,s),a(t,ys,s),d(b,t,s),a(t,fs,s),d(lt,t,s),a(t,Js,s),a(t,nt,s),a(t,ws,s),a(t,Z,s),a(t,js,s),a(t,it,s),a(t,Ts,s),a(t,pt,s),a(t,Us,s),d(ot,t,s),a(t,bs,s),d(ct,t,s),a(t,Zs,s),a(t,mt,s),a(t,Is,s),a(t,rt,s),a(t,Cs,s),a(t,I,s),a(t,ks,s),a(t,dt,s),a(t,Rs,s),d(Mt,t,s),a(t,xs,s),a(t,ht,s),a(t,Ws,s),d(gt,t,s),a(t,vs,s),a(t,ut,s),a(t,Ns,s),a(t,yt,s),a(t,_s,s),a(t,C,s),a(t,Gs,s),a(t,ft,s),a(t,Qs,s),a(t,Jt,s),a(t,Bs,s),d(wt,t,s),a(t,zs,s),d(jt,t,s),a(t,Vs,s),a(t,Tt,s),a(t,Xs,s),a(t,Ut,s),a(t,Hs,s),a(t,k,s),a(t,$s,s),a(t,bt,s),a(t,Es,s),a(t,Zt,s),a(t,Ys,s),d(It,t,s),a(t,Fs,s),a(t,Ct,s),a(t,Ss,s),d(kt,t,s),a(t,qs,s),a(t,Rt,s),a(t,Ds,s),a(t,xt,s),a(t,As,s),a(t,R,s),a(t,Ls,s),a(t,Wt,s),a(t,Ps,s),d(vt,t,s),a(t,Os,s),a(t,Nt,s),a(t,Ks,s),d(x,t,s),a(t,te,s),d(_t,t,s),a(t,se,s),a(t,Gt,s),a(t,ee,s),d(Qt,t,s),a(t,ae,s),d(Bt,t,s),a(t,le,s),a(t,zt,s),a(t,ne,s),a(t,Vt,s),a(t,ie,s),a(t,Xt,s),a(t,pe,s),d(Ht,t,s),a(t,oe,s),d($t,t,s),a(t,ce,s),a(t,Et,s),me=!0},p(t,[s]){const la={};s&2&&(la.$$scope={dirty:s,ctx:t}),T.$set(la);const na={};s&2&&(na.$$scope={dirty:s,ctx:t}),b.$set(na);const ia={};s&2&&(ia.$$scope={dirty:s,ctx:t}),x.$set(ia)},i(t){me||(M(v.$$.fragment,t),M(N.$$.fragment,t),M(X.$$.fragment,t),M(T.$$.fragment,t),M(H.$$.fragment,t),M(E.$$.fragment,t),M(F.$$.fragment,t),M(q.$$.fragment,t),M(A.$$.fragment,t),M(P.$$.fragment,t),M(at.$$.fragment,t),M(b.$$.fragment,t),M(lt.$$.fragment,t),M(ot.$$.fragment,t),M(ct.$$.fragment,t),M(Mt.$$.fragment,t),M(gt.$$.fragment,t),M(wt.$$.fragment,t),M(jt.$$.fragment,t),M(It.$$.fragment,t),M(kt.$$.fragment,t),M(vt.$$.fragment,t),M(x.$$.fragment,t),M(_t.$$.fragment,t),M(Qt.$$.fragment,t),M(Bt.$$.fragment,t),M(Ht.$$.fragment,t),M($t.$$.fragment,t),me=!0)},o(t){h(v.$$.fragment,t),h(N.$$.fragment,t),h(X.$$.fragment,t),h(T.$$.fragment,t),h(H.$$.fragment,t),h(E.$$.fragment,t),h(F.$$.fragment,t),h(q.$$.fragment,t),h(A.$$.fragment,t),h(P.$$.fragment,t),h(at.$$.fragment,t),h(b.$$.fragment,t),h(lt.$$.fragment,t),h(ot.$$.fragment,t),h(ct.$$.fragment,t),h(Mt.$$.fragment,t),h(gt.$$.fragment,t),h(wt.$$.fragment,t),h(jt.$$.fragment,t),h(It.$$.fragment,t),h(kt.$$.fragment,t),h(vt.$$.fragment,t),h(x.$$.fragment,t),h(_t.$$.fragment,t),h(Qt.$$.fragment,t),h(Bt.$$.fragment,t),h(Ht.$$.fragment,t),h($t.$$.fragment,t),me=!1},d(t){t&&(e(y),e(u),e(j),e(Yt),e(Ft),e(_),e(St),e(G),e(qt),e(Q),e(Dt),e(B),e(At),e(z),e(Lt),e(V),e(Pt),e(Ot),e(Kt),e(ts),e($),e(ss),e(es),e(Y),e(as),e(ls),e(S),e(ns),e(is),e(D),e(ps),e(os),e(L),e(cs),e(ms),e(O),e(rs),e(K),e(ds),e(U),e(Ms),e(tt),e(hs),e(st),e(gs),e(et),e(us),e(ys),e(fs),e(Js),e(nt),e(ws),e(Z),e(js),e(it),e(Ts),e(pt),e(Us),e(bs),e(Zs),e(mt),e(Is),e(rt),e(Cs),e(I),e(ks),e(dt),e(Rs),e(xs),e(ht),e(Ws),e(vs),e(ut),e(Ns),e(yt),e(_s),e(C),e(Gs),e(ft),e(Qs),e(Jt),e(Bs),e(zs),e(Vs),e(Tt),e(Xs),e(Ut),e(Hs),e(k),e($s),e(bt),e(Es),e(Zt),e(Ys),e(Fs),e(Ct),e(Ss),e(qs),e(Rt),e(Ds),e(xt),e(As),e(R),e(Ls),e(Wt),e(Ps),e(Os),e(Nt),e(Ks),e(te),e(se),e(Gt),e(ee),e(ae),e(le),e(zt),e(ne),e(Vt),e(ie),e(Xt),e(pe),e(oe),e(ce),e(Et)),e(c),g(v,t),g(N,t),g(X,t),g(T,t),g(H,t),g(E,t),g(F,t),g(q,t),g(A,t),g(P,t),g(at,t),g(b,t),g(lt,t),g(ot,t),g(ct,t),g(Mt,t),g(gt,t),g(wt,t),g(jt,t),g(It,t),g(kt,t),g(vt,t),g(x,t),g(_t,t),g(Qt,t),g(Bt,t),g(Ht,t),g($t,t)}}}const Ua='{"title":"Image tasks with IDEFICS","local":"image-tasks-with-idefics","sections":[{"title":"Loading the model","local":"loading-the-model","sections":[{"title":"Quantized model","local":"quantized-model","sections":[],"depth":3}],"depth":2},{"title":"Image captioning","local":"image-captioning","sections":[],"depth":2},{"title":"Prompted image captioning","local":"prompted-image-captioning","sections":[],"depth":2},{"title":"Few-shot prompting","local":"few-shot-prompting","sections":[],"depth":2},{"title":"Visual question answering","local":"visual-question-answering","sections":[],"depth":2},{"title":"Image classification","local":"image-classification","sections":[],"depth":2},{"title":"Image-guided text generation","local":"image-guided-text-generation","sections":[],"depth":2},{"title":"Running inference in batch mode","local":"running-inference-in-batch-mode","sections":[],"depth":2},{"title":"IDEFICS instruct for conversational use","local":"idefics-instruct-for-conversational-use","sections":[],"depth":2}],"depth":1}';function ba(w){return ma(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class va extends ra{constructor(c){super(),da(this,c,ba,Ta,ca,{})}}export{va as component};
