import{s as Nt,o as Xt,n as Ke}from"../chunks/scheduler.18a86fab.js";import{S as Ft,i as Pt,g as d,s as o,r as u,A as Lt,h as l,f as n,c as s,j as q,u as f,x as m,k as U,y as i,a,v as g,d as _,t as b,w as y}from"../chunks/index.98837b22.js";import{T as Vt}from"../chunks/Tip.77304350.js";import{D as pe}from"../chunks/Docstring.6758ea23.js";import{C as Ye}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Ht}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as me}from"../chunks/Heading.7e7e0c5b.js";import{E as Dt}from"../chunks/index.499f366c.js";function St(x){let r,k="Examples:",p,h,T;return h=new Ye({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRHZW5lcmF0aW9uQ29uZmlnJTJDJTIwQmVydEdlbmVyYXRpb25FbmNvZGVyJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEJlcnRHZW5lcmF0aW9uJTIwY29uZmlnJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMEJlcnRHZW5lcmF0aW9uQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGNvbmZpZyUwQW1vZGVsJTIwJTNEJTIwQmVydEdlbmVyYXRpb25FbmNvZGVyKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertGenerationConfig, BertGenerationEncoder

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a BertGeneration config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = BertGenerationConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BertGenerationEncoder(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){r=d("p"),r.textContent=k,p=o(),u(h.$$.fragment)},l(c){r=l(c,"P",{"data-svelte-h":!0}),m(r)!=="svelte-kvfsh7"&&(r.textContent=k),p=s(c),f(h.$$.fragment,c)},m(c,v){a(c,r,v),a(c,p,v),g(h,c,v),T=!0},p:Ke,i(c){T||(_(h.$$.fragment,c),T=!0)},o(c){b(h.$$.fragment,c),T=!1},d(c){c&&(n(r),n(p)),y(h,c)}}}function Qt(x){let r,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=d("p"),r.innerHTML=k},l(p){r=l(p,"P",{"data-svelte-h":!0}),m(r)!=="svelte-fincs2"&&(r.innerHTML=k)},m(p,h){a(p,r,h)},p:Ke,d(p){p&&n(r)}}}function At(x){let r,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=d("p"),r.innerHTML=k},l(p){r=l(p,"P",{"data-svelte-h":!0}),m(r)!=="svelte-fincs2"&&(r.innerHTML=k)},m(p,h){a(p,r,h)},p:Ke,d(p){p&&n(r)}}}function Ot(x){let r,k="Example:",p,h,T;return h=new Ye({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBCZXJ0R2VuZXJhdGlvbkRlY29kZXIlMkMlMjBCZXJ0R2VuZXJhdGlvbkNvbmZpZyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGYmVydF9mb3Jfc2VxX2dlbmVyYXRpb25fTC0yNF9iYmNfZW5jb2RlciUyMiklMEFjb25maWclMjAlM0QlMjBCZXJ0R2VuZXJhdGlvbkNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGYmVydF9mb3Jfc2VxX2dlbmVyYXRpb25fTC0yNF9iYmNfZW5jb2RlciUyMiklMEFjb25maWcuaXNfZGVjb2RlciUyMCUzRCUyMFRydWUlMEFtb2RlbCUyMCUzRCUyMEJlcnRHZW5lcmF0aW9uRGVjb2Rlci5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGYmVydF9mb3Jfc2VxX2dlbmVyYXRpb25fTC0yNF9iYmNfZW5jb2RlciUyMiUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90b2tlbl90eXBlX2lkcyUzREZhbHNlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBcHJlZGljdGlvbl9sb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, BertGenerationDecoder, BertGenerationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/bert_for_seq_generation_L-24_bbc_encoder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>config = BertGenerationConfig.from_pretrained(<span class="hljs-string">&quot;google/bert_for_seq_generation_L-24_bbc_encoder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>config.is_decoder = <span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BertGenerationDecoder.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;google/bert_for_seq_generation_L-24_bbc_encoder&quot;</span>, config=config
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_token_type_ids=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>prediction_logits = outputs.logits`,wrap:!1}}),{c(){r=d("p"),r.textContent=k,p=o(),u(h.$$.fragment)},l(c){r=l(c,"P",{"data-svelte-h":!0}),m(r)!=="svelte-11lpom8"&&(r.textContent=k),p=s(c),f(h.$$.fragment,c)},m(c,v){a(c,r,v),a(c,p,v),g(h,c,v),T=!0},p:Ke,i(c){T||(_(h.$$.fragment,c),T=!0)},o(c){b(h.$$.fragment,c),T=!1},d(c){c&&(n(r),n(p)),y(h,c)}}}function Yt(x){let r,k,p,h,T,c,v,yt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',ze,H,Je,N,Tt=`The BertGeneration model is a BERT model that can be leveraged for sequence-to-sequence tasks using
<a href="/docs/transformers/main/en/model_doc/encoder-decoder#transformers.EncoderDecoderModel">EncoderDecoderModel</a> as proposed in <a href="https://arxiv.org/abs/1907.12461" rel="nofollow">Leveraging Pre-trained Checkpoints for Sequence Generation
Tasks</a> by Sascha Rothe, Shashi Narayan, Aliaksei Severyn.`,xe,X,kt="The abstract from the paper is the following:",Ce,F,vt=`<em>Unsupervised pretraining of large neural models has recently revolutionized Natural Language Processing. By
warm-starting from the publicly released checkpoints, NLP practitioners have pushed the state-of-the-art on multiple
benchmarks while saving significant amounts of compute time. So far the focus has been mainly on the Natural Language
Understanding tasks. In this paper, we demonstrate the efficacy of pre-trained checkpoints for Sequence Generation. We
developed a Transformer-based sequence-to-sequence model that is compatible with publicly available pre-trained BERT,
GPT-2 and RoBERTa checkpoints and conducted an extensive empirical study on the utility of initializing our model, both
encoder and decoder, with these checkpoints. Our models result in new state-of-the-art results on Machine Translation,
Text Summarization, Sentence Splitting, and Sentence Fusion.</em>`,Ze,P,Mt=`This model was contributed by <a href="https://huggingface.co/patrickvonplaten" rel="nofollow">patrickvonplaten</a>. The original code can be
found <a href="https://tfhub.dev/s?module-type=text-generation&amp;subtype=module,placeholder" rel="nofollow">here</a>.`,Ue,L,qe,D,wt=`The model can be used in combination with the <a href="/docs/transformers/main/en/model_doc/encoder-decoder#transformers.EncoderDecoderModel">EncoderDecoderModel</a> to leverage two pretrained BERT checkpoints for
subsequent fine-tuning:`,Ee,S,Re,Q,Bt='Pretrained <a href="/docs/transformers/main/en/model_doc/encoder-decoder#transformers.EncoderDecoderModel">EncoderDecoderModel</a> are also directly available in the model hub, e.g.:',We,A,Ie,O,Gt="Tips:",Ve,Y,$t=`<li><a href="/docs/transformers/main/en/model_doc/bert-generation#transformers.BertGenerationEncoder">BertGenerationEncoder</a> and <a href="/docs/transformers/main/en/model_doc/bert-generation#transformers.BertGenerationDecoder">BertGenerationDecoder</a> should be used in
combination with <code>EncoderDecoder</code>.</li> <li>For summarization, sentence splitting, sentence fusion and translation, no special tokens are required for the input.
Therefore, no EOS token should be added to the end of the input.</li>`,He,K,Ne,B,ee,et,he,jt=`This is the configuration class to store the configuration of a <code>BertGenerationPreTrainedModel</code>. It is used to
instantiate a BertGeneration model according to the specified arguments, defining the model architecture.
Instantiating a configuration with the defaults will yield a similar configuration to that of the BertGeneration
<a href="https://huggingface.co/google/bert_for_seq_generation_L-24_bbc_encoder" rel="nofollow">google/bert_for_seq_generation_L-24_bbc_encoder</a>
architecture.`,tt,ue,zt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,nt,E,Xe,te,Fe,G,ne,ot,fe,Jt='Construct a BertGeneration tokenizer. Based on <a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a>.',st,ge,xt=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,at,_e,oe,Pe,se,Le,M,ae,rt,be,Ct="The bare BertGeneration model transformer outputting raw hidden-states without any specific head on top.",it,ye,Zt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,dt,Te,Ut=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,lt,C,re,ct,ke,qt='The <a href="/docs/transformers/main/en/model_doc/bert-generation#transformers.BertGenerationEncoder">BertGenerationEncoder</a> forward method, overrides the <code>__call__</code> special method.',pt,R,De,ie,Se,w,de,mt,ve,Et="BertGeneration Model with a <code>language modeling</code> head on top for CLM fine-tuning.",ht,Me,Rt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ut,we,Wt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ft,j,le,gt,Be,It='The <a href="/docs/transformers/main/en/model_doc/bert-generation#transformers.BertGenerationDecoder">BertGenerationDecoder</a> forward method, overrides the <code>__call__</code> special method.',_t,W,bt,I,Qe,ce,Ae,$e,Oe;return T=new me({props:{title:"BertGeneration",local:"bertgeneration",headingTag:"h1"}}),H=new me({props:{title:"Overview",local:"overview",headingTag:"h2"}}),L=new me({props:{title:"Usage examples and tips",local:"usage-examples-and-tips",headingTag:"h2"}}),S=new Ye({props:{code:"JTIzJTIwbGV2ZXJhZ2UlMjBjaGVja3BvaW50cyUyMGZvciUyMEJlcnQyQmVydCUyMG1vZGVsLi4uJTBBJTIzJTIwdXNlJTIwQkVSVCdzJTIwY2xzJTIwdG9rZW4lMjBhcyUyMEJPUyUyMHRva2VuJTIwYW5kJTIwc2VwJTIwdG9rZW4lMjBhcyUyMEVPUyUyMHRva2VuJTBBZW5jb2RlciUyMCUzRCUyMEJlcnRHZW5lcmF0aW9uRW5jb2Rlci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWxhcmdlLXVuY2FzZWQlMjIlMkMlMjBib3NfdG9rZW5faWQlM0QxMDElMkMlMjBlb3NfdG9rZW5faWQlM0QxMDIpJTBBJTIzJTIwYWRkJTIwY3Jvc3MlMjBhdHRlbnRpb24lMjBsYXllcnMlMjBhbmQlMjB1c2UlMjBCRVJUJ3MlMjBjbHMlMjB0b2tlbiUyMGFzJTIwQk9TJTIwdG9rZW4lMjBhbmQlMjBzZXAlMjB0b2tlbiUyMGFzJTIwRU9TJTIwdG9rZW4lMEFkZWNvZGVyJTIwJTNEJTIwQmVydEdlbmVyYXRpb25EZWNvZGVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJnb29nbGUtYmVydCUyRmJlcnQtbGFyZ2UtdW5jYXNlZCUyMiUyQyUyMGFkZF9jcm9zc19hdHRlbnRpb24lM0RUcnVlJTJDJTIwaXNfZGVjb2RlciUzRFRydWUlMkMlMjBib3NfdG9rZW5faWQlM0QxMDElMkMlMjBlb3NfdG9rZW5faWQlM0QxMDIlMEEpJTBBYmVydDJiZXJ0JTIwJTNEJTIwRW5jb2RlckRlY29kZXJNb2RlbChlbmNvZGVyJTNEZW5jb2RlciUyQyUyMGRlY29kZXIlM0RkZWNvZGVyKSUwQSUwQSUyMyUyMGNyZWF0ZSUyMHRva2VuaXplci4uLiUwQXRva2VuaXplciUyMCUzRCUyMEJlcnRUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1sYXJnZS11bmNhc2VkJTIyKSUwQSUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBhJTIwbG9uZyUyMGFydGljbGUlMjB0byUyMHN1bW1hcml6ZSUyMiUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSkuaW5wdXRfaWRzJTBBbGFiZWxzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoaXMlMjBpcyUyMGElMjBzaG9ydCUyMHN1bW1hcnklMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMlMEElMEElMjMlMjB0cmFpbi4uLiUwQWxvc3MlMjAlM0QlMjBiZXJ0MmJlcnQoaW5wdXRfaWRzJTNEaW5wdXRfaWRzJTJDJTIwZGVjb2Rlcl9pbnB1dF9pZHMlM0RsYWJlbHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpLmxvc3MlMEFsb3NzLmJhY2t3YXJkKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># leverage checkpoints for Bert2Bert model...</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use BERT&#x27;s cls token as BOS token and sep token as EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder = BertGenerationEncoder.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-large-uncased&quot;</span>, bos_token_id=<span class="hljs-number">101</span>, eos_token_id=<span class="hljs-number">102</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add cross attention layers and use BERT&#x27;s cls token as BOS token and sep token as EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = BertGenerationDecoder.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;google-bert/bert-large-uncased&quot;</span>, add_cross_attention=<span class="hljs-literal">True</span>, is_decoder=<span class="hljs-literal">True</span>, bos_token_id=<span class="hljs-number">101</span>, eos_token_id=<span class="hljs-number">102</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bert2bert = EncoderDecoderModel(encoder=encoder, decoder=decoder)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create tokenizer...</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-large-uncased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;This is a long article to summarize&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(<span class="hljs-string">&quot;This is a short summary&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># train...</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = bert2bert(input_ids=input_ids, decoder_input_ids=labels, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span>loss.backward()`,wrap:!1}}),A=new Ye({props:{code:"JTIzJTIwaW5zdGFudGlhdGUlMjBzZW50ZW5jZSUyMGZ1c2lvbiUyMG1vZGVsJTBBc2VudGVuY2VfZnVzZXIlMjAlM0QlMjBFbmNvZGVyRGVjb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZyb2JlcnRhMnJvYmVydGFfTC0yNF9kaXNjb2Z1c2UlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcm9iZXJ0YTJyb2JlcnRhX0wtMjRfZGlzY29mdXNlJTIyKSUwQSUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjB0aGUlMjBmaXJzdCUyMHNlbnRlbmNlLiUyMFRoaXMlMjBpcyUyMHRoZSUyMHNlY29uZCUyMHNlbnRlbmNlLiUyMiUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSkuaW5wdXRfaWRzJTBBJTBBb3V0cHV0cyUyMCUzRCUyMHNlbnRlbmNlX2Z1c2VyLmdlbmVyYXRlKGlucHV0X2lkcyklMEElMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate sentence fusion model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sentence_fuser = EncoderDecoderModel.from_pretrained(<span class="hljs-string">&quot;google/roberta2roberta_L-24_discofuse&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/roberta2roberta_L-24_discofuse&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;This is the first sentence. This is the second sentence.&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = sentence_fuser.generate(input_ids)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),K=new me({props:{title:"BertGenerationConfig",local:"transformers.BertGenerationConfig",headingTag:"h2"}}),ee=new pe({props:{name:"class transformers.BertGenerationConfig",anchor:"transformers.BertGenerationConfig",parameters:[{name:"vocab_size",val:" = 50358"},{name:"hidden_size",val:" = 1024"},{name:"num_hidden_layers",val:" = 24"},{name:"num_attention_heads",val:" = 16"},{name:"intermediate_size",val:" = 4096"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 512"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 2"},{name:"eos_token_id",val:" = 1"},{name:"position_embedding_type",val:" = 'absolute'"},{name:"use_cache",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BertGenerationConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 50358) &#x2014;
Vocabulary size of the BERT model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <code>BertGeneration</code>.`,name:"vocab_size"},{anchor:"transformers.BertGenerationConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.BertGenerationConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.BertGenerationConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.BertGenerationConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often called feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.BertGenerationConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.BertGenerationConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.BertGenerationConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.BertGenerationConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.BertGenerationConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.BertGenerationConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.BertGenerationConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.BertGenerationConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.BertGenerationConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.BertGenerationConfig.position_embedding_type",description:`<strong>position_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;absolute&quot;</code>) &#x2014;
Type of position embedding. Choose one of <code>&quot;absolute&quot;</code>, <code>&quot;relative_key&quot;</code>, <code>&quot;relative_key_query&quot;</code>. For
positional embeddings use <code>&quot;absolute&quot;</code>. For more information on <code>&quot;relative_key&quot;</code>, please refer to
<a href="https://arxiv.org/abs/1803.02155" rel="nofollow">Self-Attention with Relative Position Representations (Shaw et al.)</a>.
For more information on <code>&quot;relative_key_query&quot;</code>, please refer to <em>Method 4</em> in <a href="https://arxiv.org/abs/2009.13658" rel="nofollow">Improve Transformer Models
with Better Relative Position Embeddings (Huang et al.)</a>.`,name:"position_embedding_type"},{anchor:"transformers.BertGenerationConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/bert_generation/configuration_bert_generation.py#L20"}}),E=new Ht({props:{anchor:"transformers.BertGenerationConfig.example",$$slots:{default:[St]},$$scope:{ctx:x}}}),te=new me({props:{title:"BertGenerationTokenizer",local:"transformers.BertGenerationTokenizer",headingTag:"h2"}}),ne=new pe({props:{name:"class transformers.BertGenerationTokenizer",anchor:"transformers.BertGenerationTokenizer",parameters:[{name:"vocab_file",val:""},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"sep_token",val:" = '<::::>'"},{name:"sp_model_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BertGenerationTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a <em>.spm</em> extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.BertGenerationTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The begin of sequence token.`,name:"bos_token"},{anchor:"transformers.BertGenerationTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.BertGenerationTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.BertGenerationTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.BertGenerationTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt; --:::&gt;&quot;</code>):
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.BertGenerationTokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Will be passed to the <code>SentencePieceProcessor.__init__()</code> method. The <a href="https://github.com/google/sentencepiece/tree/master/python" rel="nofollow">Python wrapper for
SentencePiece</a> can be used, among other things,
to set:</p>
<ul>
<li>
<p><code>enable_sampling</code>: Enable subword regularization.</p>
</li>
<li>
<p><code>nbest_size</code>: Sampling parameters for unigram. Invalid for BPE-Dropout.</p>
<ul>
<li><code>nbest_size = {0,1}</code>: No sampling is performed.</li>
<li><code>nbest_size &gt; 1</code>: samples from the nbest_size results.</li>
<li><code>nbest_size &lt; 0</code>: assuming that nbest_size is infinite and samples from the all hypothesis (lattice)
using forward-filtering-and-backward-sampling algorithm.</li>
</ul>
</li>
<li>
<p><code>alpha</code>: Smoothing parameter for unigram sampling, and dropout probability of merge operations for
BPE-dropout.</p>
</li>
</ul>`,name:"sp_model_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/bert_generation/tokenization_bert_generation.py#L33"}}),oe=new pe({props:{name:"save_vocabulary",anchor:"transformers.BertGenerationTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/bert_generation/tokenization_bert_generation.py#L159"}}),se=new me({props:{title:"BertGenerationEncoder",local:"transformers.BertGenerationEncoder",headingTag:"h2"}}),ae=new pe({props:{name:"class transformers.BertGenerationEncoder",anchor:"transformers.BertGenerationEncoder",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.BertGenerationEncoder.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/bert-generation#transformers.BertGenerationEncoder">BertGenerationEncoder</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/bert_generation/modeling_bert_generation.py#L605"}}),re=new pe({props:{name:"forward",anchor:"transformers.BertGenerationEncoder.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BertGenerationEncoder.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BertGenerationEncoder.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.BertGenerationEncoder.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.BertGenerationEncoder.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BertGenerationEncoder.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BertGenerationEncoder.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention
if the model is configured as a decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.BertGenerationEncoder.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on the padding token indices of the encoder input. This mask is used in
the cross-attention if the model is configured as a decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>`,name:"encoder_attention_mask"},{anchor:"transformers.BertGenerationEncoder.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.BertGenerationEncoder.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.BertGenerationEncoder.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BertGenerationEncoder.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BertGenerationEncoder.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/bert_generation/modeling_bert_generation.py#L651",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/bert-generation#transformers.BertGenerationConfig"
>BertGenerationConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),R=new Vt({props:{$$slots:{default:[Qt]},$$scope:{ctx:x}}}),ie=new me({props:{title:"BertGenerationDecoder",local:"transformers.BertGenerationDecoder",headingTag:"h2"}}),de=new pe({props:{name:"class transformers.BertGenerationDecoder",anchor:"transformers.BertGenerationDecoder",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.BertGenerationDecoder.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/bert-generation#transformers.BertGenerationDecoder">BertGenerationDecoder</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/bert_generation/modeling_bert_generation.py#L773"}}),le=new pe({props:{name:"forward",anchor:"transformers.BertGenerationDecoder.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BertGenerationDecoder.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BertGenerationDecoder.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.BertGenerationDecoder.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.BertGenerationDecoder.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BertGenerationDecoder.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BertGenerationDecoder.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention
if the model is configured as a decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.BertGenerationDecoder.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on the padding token indices of the encoder input. This mask is used in
the cross-attention if the model is configured as a decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>`,name:"encoder_attention_mask"},{anchor:"transformers.BertGenerationDecoder.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the left-to-right language modeling loss (next word prediction). Indices should be in
<code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are
ignored (masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.BertGenerationDecoder.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.BertGenerationDecoder.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.BertGenerationDecoder.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BertGenerationDecoder.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BertGenerationDecoder.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/bert_generation/modeling_bert_generation.py#L800",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/bert-generation#transformers.BertGenerationConfig"
>BertGenerationConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),W=new Vt({props:{$$slots:{default:[At]},$$scope:{ctx:x}}}),I=new Ht({props:{anchor:"transformers.BertGenerationDecoder.forward.example",$$slots:{default:[Ot]},$$scope:{ctx:x}}}),ce=new Dt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/bert-generation.md"}}),{c(){r=d("meta"),k=o(),p=d("p"),h=o(),u(T.$$.fragment),c=o(),v=d("div"),v.innerHTML=yt,ze=o(),u(H.$$.fragment),Je=o(),N=d("p"),N.innerHTML=Tt,xe=o(),X=d("p"),X.textContent=kt,Ce=o(),F=d("p"),F.innerHTML=vt,Ze=o(),P=d("p"),P.innerHTML=Mt,Ue=o(),u(L.$$.fragment),qe=o(),D=d("p"),D.innerHTML=wt,Ee=o(),u(S.$$.fragment),Re=o(),Q=d("p"),Q.innerHTML=Bt,We=o(),u(A.$$.fragment),Ie=o(),O=d("p"),O.textContent=Gt,Ve=o(),Y=d("ul"),Y.innerHTML=$t,He=o(),u(K.$$.fragment),Ne=o(),B=d("div"),u(ee.$$.fragment),et=o(),he=d("p"),he.innerHTML=jt,tt=o(),ue=d("p"),ue.innerHTML=zt,nt=o(),u(E.$$.fragment),Xe=o(),u(te.$$.fragment),Fe=o(),G=d("div"),u(ne.$$.fragment),ot=o(),fe=d("p"),fe.innerHTML=Jt,st=o(),ge=d("p"),ge.innerHTML=xt,at=o(),_e=d("div"),u(oe.$$.fragment),Pe=o(),u(se.$$.fragment),Le=o(),M=d("div"),u(ae.$$.fragment),rt=o(),be=d("p"),be.textContent=Ct,it=o(),ye=d("p"),ye.innerHTML=Zt,dt=o(),Te=d("p"),Te.innerHTML=Ut,lt=o(),C=d("div"),u(re.$$.fragment),ct=o(),ke=d("p"),ke.innerHTML=qt,pt=o(),u(R.$$.fragment),De=o(),u(ie.$$.fragment),Se=o(),w=d("div"),u(de.$$.fragment),mt=o(),ve=d("p"),ve.innerHTML=Et,ht=o(),Me=d("p"),Me.innerHTML=Rt,ut=o(),we=d("p"),we.innerHTML=Wt,ft=o(),j=d("div"),u(le.$$.fragment),gt=o(),Be=d("p"),Be.innerHTML=It,_t=o(),u(W.$$.fragment),bt=o(),u(I.$$.fragment),Qe=o(),u(ce.$$.fragment),Ae=o(),$e=d("p"),this.h()},l(e){const t=Lt("svelte-u9bgzb",document.head);r=l(t,"META",{name:!0,content:!0}),t.forEach(n),k=s(e),p=l(e,"P",{}),q(p).forEach(n),h=s(e),f(T.$$.fragment,e),c=s(e),v=l(e,"DIV",{class:!0,"data-svelte-h":!0}),m(v)!=="svelte-13t8s2t"&&(v.innerHTML=yt),ze=s(e),f(H.$$.fragment,e),Je=s(e),N=l(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-qb9cia"&&(N.innerHTML=Tt),xe=s(e),X=l(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-vfdo9a"&&(X.textContent=kt),Ce=s(e),F=l(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-15bi2vw"&&(F.innerHTML=vt),Ze=s(e),P=l(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-dprat4"&&(P.innerHTML=Mt),Ue=s(e),f(L.$$.fragment,e),qe=s(e),D=l(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1c2a8uh"&&(D.innerHTML=wt),Ee=s(e),f(S.$$.fragment,e),Re=s(e),Q=l(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-mxtzso"&&(Q.innerHTML=Bt),We=s(e),f(A.$$.fragment,e),Ie=s(e),O=l(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-axv494"&&(O.textContent=Gt),Ve=s(e),Y=l(e,"UL",{"data-svelte-h":!0}),m(Y)!=="svelte-bgh1j6"&&(Y.innerHTML=$t),He=s(e),f(K.$$.fragment,e),Ne=s(e),B=l(e,"DIV",{class:!0});var z=q(B);f(ee.$$.fragment,z),et=s(z),he=l(z,"P",{"data-svelte-h":!0}),m(he)!=="svelte-1664b7p"&&(he.innerHTML=jt),tt=s(z),ue=l(z,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-o55m63"&&(ue.innerHTML=zt),nt=s(z),f(E.$$.fragment,z),z.forEach(n),Xe=s(e),f(te.$$.fragment,e),Fe=s(e),G=l(e,"DIV",{class:!0});var J=q(G);f(ne.$$.fragment,J),ot=s(J),fe=l(J,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-qeg36l"&&(fe.innerHTML=Jt),st=s(J),ge=l(J,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-1c3t5ty"&&(ge.innerHTML=xt),at=s(J),_e=l(J,"DIV",{class:!0});var je=q(_e);f(oe.$$.fragment,je),je.forEach(n),J.forEach(n),Pe=s(e),f(se.$$.fragment,e),Le=s(e),M=l(e,"DIV",{class:!0});var $=q(M);f(ae.$$.fragment,$),rt=s($),be=l($,"P",{"data-svelte-h":!0}),m(be)!=="svelte-1g5c0ym"&&(be.textContent=Ct),it=s($),ye=l($,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-6pahdo"&&(ye.innerHTML=Zt),dt=s($),Te=l($,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-hswkmf"&&(Te.innerHTML=Ut),lt=s($),C=l($,"DIV",{class:!0});var Ge=q(C);f(re.$$.fragment,Ge),ct=s(Ge),ke=l(Ge,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-1ku2ayb"&&(ke.innerHTML=qt),pt=s(Ge),f(R.$$.fragment,Ge),Ge.forEach(n),$.forEach(n),De=s(e),f(ie.$$.fragment,e),Se=s(e),w=l(e,"DIV",{class:!0});var Z=q(w);f(de.$$.fragment,Z),mt=s(Z),ve=l(Z,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-1avzda8"&&(ve.innerHTML=Et),ht=s(Z),Me=l(Z,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-6pahdo"&&(Me.innerHTML=Rt),ut=s(Z),we=l(Z,"P",{"data-svelte-h":!0}),m(we)!=="svelte-hswkmf"&&(we.innerHTML=Wt),ft=s(Z),j=l(Z,"DIV",{class:!0});var V=q(j);f(le.$$.fragment,V),gt=s(V),Be=l(V,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-kze9rj"&&(Be.innerHTML=It),_t=s(V),f(W.$$.fragment,V),bt=s(V),f(I.$$.fragment,V),V.forEach(n),Z.forEach(n),Qe=s(e),f(ce.$$.fragment,e),Ae=s(e),$e=l(e,"P",{}),q($e).forEach(n),this.h()},h(){U(r,"name","hf:doc:metadata"),U(r,"content",Kt),U(v,"class","flex flex-wrap space-x-1"),U(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,r),a(e,k,t),a(e,p,t),a(e,h,t),g(T,e,t),a(e,c,t),a(e,v,t),a(e,ze,t),g(H,e,t),a(e,Je,t),a(e,N,t),a(e,xe,t),a(e,X,t),a(e,Ce,t),a(e,F,t),a(e,Ze,t),a(e,P,t),a(e,Ue,t),g(L,e,t),a(e,qe,t),a(e,D,t),a(e,Ee,t),g(S,e,t),a(e,Re,t),a(e,Q,t),a(e,We,t),g(A,e,t),a(e,Ie,t),a(e,O,t),a(e,Ve,t),a(e,Y,t),a(e,He,t),g(K,e,t),a(e,Ne,t),a(e,B,t),g(ee,B,null),i(B,et),i(B,he),i(B,tt),i(B,ue),i(B,nt),g(E,B,null),a(e,Xe,t),g(te,e,t),a(e,Fe,t),a(e,G,t),g(ne,G,null),i(G,ot),i(G,fe),i(G,st),i(G,ge),i(G,at),i(G,_e),g(oe,_e,null),a(e,Pe,t),g(se,e,t),a(e,Le,t),a(e,M,t),g(ae,M,null),i(M,rt),i(M,be),i(M,it),i(M,ye),i(M,dt),i(M,Te),i(M,lt),i(M,C),g(re,C,null),i(C,ct),i(C,ke),i(C,pt),g(R,C,null),a(e,De,t),g(ie,e,t),a(e,Se,t),a(e,w,t),g(de,w,null),i(w,mt),i(w,ve),i(w,ht),i(w,Me),i(w,ut),i(w,we),i(w,ft),i(w,j),g(le,j,null),i(j,gt),i(j,Be),i(j,_t),g(W,j,null),i(j,bt),g(I,j,null),a(e,Qe,t),g(ce,e,t),a(e,Ae,t),a(e,$e,t),Oe=!0},p(e,[t]){const z={};t&2&&(z.$$scope={dirty:t,ctx:e}),E.$set(z);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),R.$set(J);const je={};t&2&&(je.$$scope={dirty:t,ctx:e}),W.$set(je);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),I.$set($)},i(e){Oe||(_(T.$$.fragment,e),_(H.$$.fragment,e),_(L.$$.fragment,e),_(S.$$.fragment,e),_(A.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(E.$$.fragment,e),_(te.$$.fragment,e),_(ne.$$.fragment,e),_(oe.$$.fragment,e),_(se.$$.fragment,e),_(ae.$$.fragment,e),_(re.$$.fragment,e),_(R.$$.fragment,e),_(ie.$$.fragment,e),_(de.$$.fragment,e),_(le.$$.fragment,e),_(W.$$.fragment,e),_(I.$$.fragment,e),_(ce.$$.fragment,e),Oe=!0)},o(e){b(T.$$.fragment,e),b(H.$$.fragment,e),b(L.$$.fragment,e),b(S.$$.fragment,e),b(A.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),b(E.$$.fragment,e),b(te.$$.fragment,e),b(ne.$$.fragment,e),b(oe.$$.fragment,e),b(se.$$.fragment,e),b(ae.$$.fragment,e),b(re.$$.fragment,e),b(R.$$.fragment,e),b(ie.$$.fragment,e),b(de.$$.fragment,e),b(le.$$.fragment,e),b(W.$$.fragment,e),b(I.$$.fragment,e),b(ce.$$.fragment,e),Oe=!1},d(e){e&&(n(k),n(p),n(h),n(c),n(v),n(ze),n(Je),n(N),n(xe),n(X),n(Ce),n(F),n(Ze),n(P),n(Ue),n(qe),n(D),n(Ee),n(Re),n(Q),n(We),n(Ie),n(O),n(Ve),n(Y),n(He),n(Ne),n(B),n(Xe),n(Fe),n(G),n(Pe),n(Le),n(M),n(De),n(Se),n(w),n(Qe),n(Ae),n($e)),n(r),y(T,e),y(H,e),y(L,e),y(S,e),y(A,e),y(K,e),y(ee),y(E),y(te,e),y(ne),y(oe),y(se,e),y(ae),y(re),y(R),y(ie,e),y(de),y(le),y(W),y(I),y(ce,e)}}}const Kt='{"title":"BertGeneration","local":"bertgeneration","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage examples and tips","local":"usage-examples-and-tips","sections":[],"depth":2},{"title":"BertGenerationConfig","local":"transformers.BertGenerationConfig","sections":[],"depth":2},{"title":"BertGenerationTokenizer","local":"transformers.BertGenerationTokenizer","sections":[],"depth":2},{"title":"BertGenerationEncoder","local":"transformers.BertGenerationEncoder","sections":[],"depth":2},{"title":"BertGenerationDecoder","local":"transformers.BertGenerationDecoder","sections":[],"depth":2}],"depth":1}';function en(x){return Xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cn extends Ft{constructor(r){super(),Pt(this,r,en,Yt,Nt,{})}}export{cn as component};
