import{s as La,o as $a,n as B}from"../chunks/scheduler.bdbef820.js";import{S as xa,i as Ca,g as i,s as n,r as u,A as za,h as d,f as o,c as a,j as x,u as f,x as p,k as C,y as s,a as l,v as g,d as _,t as b,w as k}from"../chunks/index.33f81d56.js";import{T as Wo}from"../chunks/Tip.34194030.js";import{D as j}from"../chunks/Docstring.662771b3.js";import{C as pe}from"../chunks/CodeBlock.3bad7fc9.js";import{E as Nt}from"../chunks/ExampleCodeBlock.32707fc1.js";import{P as ja}from"../chunks/PipelineTag.d2f354cd.js";import{H as A,E as Fa}from"../chunks/index.e01163b6.js";function Ua(L){let r,y="<code>Llama2</code> 모델은 <code>bfloat16</code>을 사용하여 훈련되었지만, 원래 추론은 <code>float16</code>을 사용합니다. 허브에 업로드된 체크포인트는 <code>torch_dtype = &#39;float16&#39;</code>을 사용하며, 이는 <code>AutoModel</code> API에 의해 체크포인트를 <code>torch.float32</code>에서 <code>torch.float16</code>으로 캐스팅하는 데 사용됩니다.",m,h,v="온라인 가중치의 <code>dtype</code>은 <code>model = AutoModelForCausalLM.from_pretrained(&quot;path&quot;, torch_dtype = &quot;auto&quot;)</code>를 사용하여 모델을 초기화할 때 <code>torch_dtype=&quot;auto&quot;</code>를 사용하지 않는 한 대부분 관련이 없습니다. 그 이유는 모델이 먼저 다운로드될 것이고 (온라인 체크포인트의 <code>dtype</code>을 사용하여) 그다음에 기본 <code>dtype</code>인 <code>torch</code>로 캐스팅하고(<code>torch.float32</code>가 됨), 마지막으로 구성(configuration)에서 제공된 <code>torch_dtype</code>이 있는 경우 이를 사용하기 때문입니다.",c,T,he="모델을 <code>float16</code>에서 훈련하는 것은 권장되지 않으며 <code>nan</code>을 생성하는 것으로 알려져 있습니다. 따라서 모델은 <code>bfloat16</code>에서 훈련되어야 합니다.";return{c(){r=i("p"),r.innerHTML=y,m=n(),h=i("p"),h.innerHTML=v,c=n(),T=i("p"),T.innerHTML=he},l($){r=d($,"P",{"data-svelte-h":!0}),p(r)!=="svelte-17o3s0r"&&(r.innerHTML=y),m=a($),h=d($,"P",{"data-svelte-h":!0}),p(h)!=="svelte-twggkk"&&(h.innerHTML=v),c=a($),T=d($,"P",{"data-svelte-h":!0}),p(T)!=="svelte-ulakwv"&&(T.innerHTML=he)},m($,Q){l($,r,Q),l($,m,Q),l($,h,Q),l($,c,Q),l($,T,Q)},p:B,d($){$&&(o(r),o(m),o(h),o(c),o(T))}}}function Wa(L){let r,y;return r=new pe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hTW9kZWwlMkMlMjBMbGFtYUNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBMTGFNQSUyMGxsYW1hLTdiJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMExsYW1hQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwbGxhbWEtN2IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMExsYW1hTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaModel, LlamaConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a LLaMA llama-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = LlamaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the llama-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlamaModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){u(r.$$.fragment)},l(m){f(r.$$.fragment,m)},m(m,h){g(r,m,h),y=!0},p:B,i(m){y||(_(r.$$.fragment,m),y=!0)},o(m){b(r.$$.fragment,m),y=!1},d(m){k(r,m)}}}function Ja(L){let r,y="sequence pair mask has the following format:",m,h,v;return h=new pe({props:{code:"MCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMEElN0MlMjBmaXJzdCUyMHNlcXVlbmNlJTIwJTIwJTIwJTIwJTdDJTIwc2Vjb25kJTIwc2VxdWVuY2UlMjAlN0M=",highlighted:`0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1 1
| first sequence    | second sequence |`,wrap:!1}}),{c(){r=i("p"),r.textContent=y,m=n(),u(h.$$.fragment)},l(c){r=d(c,"P",{"data-svelte-h":!0}),p(r)!=="svelte-16klr56"&&(r.textContent=y),m=a(c),f(h.$$.fragment,c)},m(c,T){l(c,r,T),l(c,m,T),g(h,c,T),v=!0},p:B,i(c){v||(_(h.$$.fragment,c),v=!0)},o(c){b(h.$$.fragment,c),v=!1},d(c){c&&(o(r),o(m)),k(h,c)}}}function qa(L){let r,y;return r=new pe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hVG9rZW5pemVyRmFzdCUwQSUwQXRva2VuaXplciUyMCUzRCUyMExsYW1hVG9rZW5pemVyRmFzdC5mcm9tX3ByZXRyYWluZWQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxsYW1hLXRva2VuaXplciUyMiklMEF0b2tlbml6ZXIuZW5jb2RlKCUyMkhlbGxvJTIwdGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaTokenizerFast

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = LlamaTokenizerFast.from_pretrained(<span class="hljs-string">&quot;hf-internal-testing/llama-tokenizer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.encode(<span class="hljs-string">&quot;Hello this is a test&quot;</span>)
[<span class="hljs-number">1</span>, <span class="hljs-number">15043</span>, <span class="hljs-number">445</span>, <span class="hljs-number">338</span>, <span class="hljs-number">263</span>, <span class="hljs-number">1243</span>]`,wrap:!1}}),{c(){u(r.$$.fragment)},l(m){f(r.$$.fragment,m)},m(m,h){g(r,m,h),y=!0},p:B,i(m){y||(_(r.$$.fragment,m),y=!0)},o(m){b(r.$$.fragment,m),y=!1},d(m){k(r,m)}}}function Ia(L){let r,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=i("p"),r.innerHTML=y},l(m){r=d(m,"P",{"data-svelte-h":!0}),p(r)!=="svelte-fincs2"&&(r.innerHTML=y)},m(m,h){l(m,r,h)},p:B,d(m){m&&o(r)}}}function Za(L){let r,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=i("p"),r.innerHTML=y},l(m){r=d(m,"P",{"data-svelte-h":!0}),p(r)!=="svelte-fincs2"&&(r.innerHTML=y)},m(m,h){l(m,r,h)},p:B,d(m){m&&o(r)}}}function Ga(L){let r,y="Example:",m,h,v;return h=new pe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBMbGFtYUZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGFtYUZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIZXklMkMlMjBhcmUlMjB5b3UlMjBjb25zY2lvdXMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzLmlucHV0X2lkcyUyQyUyMG1heF9sZW5ndGglM0QzMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzREZhbHNlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, LlamaForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){r=i("p"),r.textContent=y,m=n(),u(h.$$.fragment)},l(c){r=d(c,"P",{"data-svelte-h":!0}),p(r)!=="svelte-11lpom8"&&(r.textContent=y),m=a(c),f(h.$$.fragment,c)},m(c,T){l(c,r,T),l(c,m,T),g(h,c,T),v=!0},p:B,i(c){v||(_(h.$$.fragment,c),v=!0)},o(c){b(h.$$.fragment,c),v=!1},d(c){c&&(o(r),o(m)),k(h,c)}}}function Ha(L){let r,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=i("p"),r.innerHTML=y},l(m){r=d(m,"P",{"data-svelte-h":!0}),p(r)!=="svelte-fincs2"&&(r.innerHTML=y)},m(m,h){l(m,r,h)},p:B,d(m){m&&o(r)}}}function Pa(L){let r,y="Example of single-label classification:",m,h,v;return h=new pe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMExsYW1hRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0yLTdiLWhmJTIyKSUwQW1vZGVsJTIwJTNEJTIwTGxhbWFGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWQlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KCkuaXRlbSgpJTBBbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkJTVEJTBBJTBBJTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwTGxhbWFGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcyUwQXJvdW5kKGxvc3MuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, LlamaForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlamaForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.id2label[predicted_class_id]
...

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlamaForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
...`,wrap:!1}}),{c(){r=i("p"),r.textContent=y,m=n(),u(h.$$.fragment)},l(c){r=d(c,"P",{"data-svelte-h":!0}),p(r)!=="svelte-ykxpe4"&&(r.textContent=y),m=a(c),f(h.$$.fragment,c)},m(c,T){l(c,r,T),l(c,m,T),g(h,c,T),v=!0},p:B,i(c){v||(_(h.$$.fragment,c),v=!0)},o(c){b(h.$$.fragment,c),v=!1},d(c){c&&(o(r),o(m)),k(h,c)}}}function Ea(L){let r,y="Example of multi-label classification:",m,h,v;return h=new pe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMExsYW1hRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0yLTdiLWhmJTIyKSUwQW1vZGVsJTIwJTNEJTIwTGxhbWFGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiUyQyUyMHByb2JsZW1fdHlwZSUzRCUyMm11bHRpX2xhYmVsX2NsYXNzaWZpY2F0aW9uJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9jbGFzc19pZHMlMjAlM0QlMjB0b3JjaC5hcmFuZ2UoMCUyQyUyMGxvZ2l0cy5zaGFwZSU1Qi0xJTVEKSU1QnRvcmNoLnNpZ21vaWQobG9naXRzKS5zcXVlZXplKGRpbSUzRDApJTIwJTNFJTIwMC41JTVEJTBBJTBBJTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwTGxhbWFGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, LlamaForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlamaForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlamaForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){r=i("p"),r.textContent=y,m=n(),u(h.$$.fragment)},l(c){r=d(c,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1l8e32d"&&(r.textContent=y),m=a(c),f(h.$$.fragment,c)},m(c,T){l(c,r,T),l(c,m,T),g(h,c,T),v=!0},p:B,i(c){v||(_(h.$$.fragment,c),v=!0)},o(c){b(h.$$.fragment,c),v=!1},d(c){c&&(o(r),o(m)),k(h,c)}}}function Ra(L){let r,y,m,h,v,c,T,he,$,Q='Llama2 모델은 Hugo Touvron, Louis Martin, Kevin Stone, Peter Albert, Amjad Almahairi, Ya1smine Babaei, Nikolay Bashlykov, Soumya Batra, Prajjwal Bhargava, Shruti Bhosale, Dan Bikel, Lukas Blecher, Cristian Canton Ferrer, Moya Chen, Guillem Cucurull, David Esiobu, Jude Fernandes, Jeremy Fu, Wenyin Fu, Brian Fuller, Cynthia Gao, Vedanuj Goswami, Naman Goyal, Anthony Hartshorn, Saghar Hosseini, Rui Hou, Hakan Inan, Marcin Kardas, Viktor Kerkez Madian Khabsa, Isabel Kloumann, Artem Korenev, Punit Singh Koura, Marie-Anne Lachaux, Thibaut Lavril, Jenya Lee, Diana Liskovich, Yinghai Lu, Yuning Mao, Xavier Martinet, Todor Mihaylov, Pushkar Mishra, Igor Molybog, Yixin Nie, Andrew Poulton, Jeremy Reizenstein, Rashi Rungta, Kalyan Saladi, Alan Schelten, Ruan Silva, Eric Michael Smith, Ranjan Subramanian, Xiaoqing EllenTan, Binh Tang, Ross Taylor, Adina Williams, Jian Xiang Kuan, Puxin Xu, Zheng Yan, Iliyan Zarov, Yuchen Zhang, Angela Fan, Melanie Kambadur, Sharan Narang, Aurelien Rodriguez, Robert Stojnic, Sergey Edunov, Thomas Scialom의 논문 <a href="https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/" rel="nofollow">LLaMA: Open Foundation and Fine-Tuned Chat Models</a>에서 제안되었습니다. 채팅 어플리케이션에 맞게 미세 조정된 체크포인트를 포함된 7B에서 70B 범위의 매개변수를 가진 기초 언어 모델 모음입니다!',Bt,ue,Fn="논문의 초록은 다음과 같습니다:",Xt,fe,Un="<em>이 연구에서 우리는 70억에서 700억 파라미터의 범위에서 사전 훈련 및 미세 조정된 대규모 언어 모델(LLMs)의 모음인 Llama 2를 개발 및 공개합니다. Llama 2-Chat라고 불리는 미세 조정된 LLMs은 대화 사용 사례에 최적화되었습니다. 우리의 모델은 테스트한 대부분의 벤치마크에서 오픈 소스 채팅 모델보다 성능이 뛰어나며, 유용성과 안전성에 대한 인적 평가를 바탕으로 비공개 소스 모델을 대체할 수 있는 적절한 대안이 될 수 있습니다. 우리는 Llama 2-Chat의 미세 조정 및 안전성 향상의 접근 방식에 대한 자세한 설명을 제공하여 커뮤니티가 우리의 작업을 기반으로 LLMs의 책임있는 개발에 기여할 수 있도록 합니다.</em>",At,ge,Wn='<a href="https://huggingface.co/models?search=llama2" rel="nofollow">여기</a>에서 모든 Llama2 모델을 확인할 수 있습니다.',Qt,D,Dt,_e,Jn="🍯 팁:",Ot,be,qn='<li>Llama2 모델의 가중치는 <a href="https://ai.meta.com/resources/models-and-libraries/llama-downloads/" rel="nofollow">이 양식</a>을 작성하여 얻을 수 있습니다.</li> <li>아키텍처는 처음 버전의 Llama와 매우 유사하며, <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">이 논문</a>의 내용에 따라 Grouped Query Attention (GQA)이 추가되었습니다.</li> <li><code>config.pretraining_tp</code>를 1과 다른 값으로 설정하면 더 정확하지만 느린 선형 레이어 계산이 활성화되어 원본 로짓과 더 잘 일치하게 됩니다.</li> <li>원래 모델은 <code>pad_id = -1</code>을 사용하는데, 이는 패딩 토큰이 없음을 의미합니다. 동일한 로직을 사용할 수 없으므로 <code>tokenizer.add_special_tokens({&quot;pad_token&quot;:&quot;&lt;pad&gt;&quot;})</code>를 사용하여 패딩 토큰을 추가하고 이에 따라 토큰 임베딩 크기를 조정해야 합니다. 또한 <code>model.config.pad_token_id</code>를 설정해야 합니다. 모델의 <code>embed_tokens</code> 레이어는 <code>self.embed_tokens = nn.Embedding(config.vocab_size, config.hidden_size, self.config.padding_idx)</code>로 초기화되어, 패딩 토큰 인코딩이 0을 출력하도록 합니다. 따라서 초기화 시에 전달하는 것을 권장합니다.</li> <li>양식을 작성하고 모델 체크포인트 접근 권한을 얻은 후에는 이미 변환된 체크포인트를 사용할 수 있습니다. 그렇지 않고 자신의 모델을 직접 변환하려는 경우, <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/convert_llama_weights_to_hf.py" rel="nofollow">변환 스크립트</a>를 자유롭게 사용하세요. 스크립트는 다음과 같은 예시의 명령어로 호출할 수 있습니다:</li>',Kt,ke,eo,ye,In="<li>변환 후 모델과 토크나이저는 다음과 같이 로드할 수 있습니다:</li>",to,Te,oo,ve,Zn="스크립트를 실행하려면 모델을 float16 정밀도로 전부 호스트할 수 있을 만큼 충분한 CPU RAM이 필요합니다 (가장 큰 버전이 여러 체크포인트로 제공되더라도 각 체크포인트는 모델 가중치의 일부만을 포함하므로 모두 RAM에 로드해야 합니다). 75B 모델의 경우, 총 145GB의 RAM이 필요합니다.",no,Me,Gn='<li>LLaMA 토크나이저는 <a href="https://github.com/google/sentencepiece" rel="nofollow">sentencepiece</a>를 기반으로 한 BPE 모델입니다. sentencepiece의 특징 중 하나는 시퀀스를 디코딩할 때 첫 번째 토큰이 단어의 시작이면 (예: “Banana”) 토크나이저는 문자열 앞에 접두사 공간을 추가하지 않는 것입니다.</li>',ao,we,Hn='이 모델은 <a href="https://huggingface.co/ArthurZ" rel="nofollow">Arthur Zucker</a>가 <a href="https://huggingface.co/lysandre" rel="nofollow">Lysandre Debut</a>의 도움을 받아 제공하였습니다. Hugging Face에서의 구현 코드는 <a href="https://github.com/EleutherAI/gpt-neox" rel="nofollow">여기</a>의 GPT-NeoX 를 기반으로 합니다. 저자의 원래 코드는 <a href="https://github.com/facebookresearch/llama" rel="nofollow">여기</a>에서 찾을 수 있습니다.',so,Le,ro,$e,Pn="LLaMA2를 시작하는 데 도움이 될 Hugging Face의 공식 및 커뮤니티(🌎로 표시) 리소스 목록입니다. 여기에 새로운 리소스를 추가하기 위해서 Pull Request를 열어 주시면 검토하겠습니다! 리소스는 기존 리소스와 중복되지 않는 새로운 것을 보여주는 것이 이상적입니다.",lo,xe,En='<li><a href="https://huggingface.co/blog/llama2" rel="nofollow">Llama 2 is here - get it on Hugging Face</a>, Llama 2에 관한 블로그 포스트와 🤗 Transformers 및 🤗 PEFT와 함께 사용하는 방법에 대한 내용입니다.</li> <li><a href="https://www.philschmid.de/llama-2" rel="nofollow">LLaMA 2 - Every Resource you need</a>, LLaMA 2에 대해 알아보고 빠르게 시작하는 데 필요한 관련 리소스의 모음입니다.</li>',io,Ce,co,ze,Rn='<li>Google Colab에서 QLoRA와 4-bit 정밀도를 사용하여 Llama 2를 미세 조정하는 방법에 대한 <a href="https://colab.research.google.com/drive/1PEQyJO1-f6j0S_XJ8DV50NkpzasXkrzd?usp=sharing" rel="nofollow">노트북</a>입니다. 🌎</li> <li>“Llama-v2-7b-guanaco” 모델을 4-bit QLoRA로 미세 조정하고 PDF에서 Q&amp;A 데이터셋을 생성하는 방법에 대한 <a href="https://colab.research.google.com/drive/134o_cXcMe_lsvl15ZE_4Y75Kstepsntu?usp=sharing" rel="nofollow">노트북</a>입니다. 🌎</li>',mo,je,Nn="⚗️ 최적화",po,Fe,Sn='<li><a href="https://huggingface.co/blog/dpo-trl" rel="nofollow">Llama 2를 DPO로 미세 조정하기</a>, TRL 라이브러리의 DPO 방법을 사용하여 특정 데이터셋에서 Llama 2를 미세 조정하는 방법을 안내하는 가이드입니다.</li> <li><a href="https://www.philschmid.de/instruction-tune-llama-2" rel="nofollow">확장 가이드: Llama 2 명령어 조정</a>, 입력에서 명령어를 생성하도록 Llama 2를 훈련시키는 방법을 안내하는 가이드로, 명령어를 따르는 모델에서 명령어를 주는 모델로 변환합니다.</li> <li>개인 컴퓨터에서 QLoRA와 TRL을 사용하여 Llama 2 모델을 미세 조정하는 방법에 대한 <a href="https://colab.research.google.com/drive/1SYpgFpcmtIUzdE7pxqknrM4ArCASfkFQ?usp=sharing" rel="nofollow">노트북</a>입니다. 🌎</li>',ho,Ue,Vn="⚡️ 추론",uo,We,Yn='<li>AutoGPTQ 라이브러리의 GPTQ를 사용하여 Llama 2 모델을 양자화하는 방법에 대한 <a href="https://colab.research.google.com/drive/1TC56ArKerXUpbgRy5vM3woRsbTEVNq7h?usp=sharing" rel="nofollow">노트북</a>입니다. 🌎</li> <li>로컬 컴퓨터나 Google Colab에서 4-bit 양자화로 Llama 2 채팅 모델을 실행하는 방법에 대한 <a href="https://colab.research.google.com/drive/1X1z9Q6domMKl2CnEM0QGHNwidLfR4dW2?usp=sharing" rel="nofollow">노트북</a>입니다. 🌎</li>',fo,Je,Bn="🚀 배포",go,qe,Xn='<li><a href="https://www.philschmid.de/sagemaker-llama2-qlora" rel="nofollow">Amazon SageMaker에서 LLaMA 2 (7-70B) 미세 조정하기</a>, Amazon SageMaker에서 QLoRA 미세 조정 및 배포에 이르기까지의 완전한 가이드입니다.</li> <li><a href="https://www.philschmid.de/sagemaker-llama-llm" rel="nofollow">Amazon SageMaker에서 Llama 2 7B/13B/70B 배포하기</a>, 안전하고 확장 가능한 배포를 위해 Hugging Face의 LLM DLC 컨테이너를 사용하는 방법에 대한 가이드입니다.</li>',_o,Ie,bo,Z,Ze,Jo,ct,An=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/ko/model_doc/llama2#transformers.LlamaModel">LlamaModel</a>. It is used to instantiate an LLaMA
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the LLaMA-7B.
e.g. <a href="https://huggingface.co/meta-llama/Llama-2-7b-hf" rel="nofollow">meta-llama/Llama-2-7b-hf</a>`,qo,mt,Qn=`Configuration objects inherit from <a href="/docs/transformers/main/ko/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/ko/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Io,O,ko,Ge,yo,F,He,Zo,pt,Dn=`Construct a Llama tokenizer. Based on byte-level Byte-Pair-Encoding. The default padding token is unset as there is
no padding token in the original model.`,Go,ht,Pe,Ho,K,Ee,Po,ut,On=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,Eo,G,Re,Ro,ft,Kn="Creates a mask from the two sequences passed to be used in a sequence-pair classification task. An ALBERT",No,ee,So,gt,ea="if token_ids_1 is None, only returns the first portion of the mask (0s).",Vo,te,Ne,Yo,_t,ta="Save the vocabulary and special tokens file to a directory.",To,Se,vo,M,Ve,Bo,bt,oa="Construct a Llama tokenizer. Based on byte-level Byte-Pair-Encoding.",Xo,kt,na="This uses notably ByteFallback and no normalization.",Ao,oe,Qo,yt,aa=`If you want to change the <code>bos_token</code> or the <code>eos_token</code>, make sure to specify them when initializing the model, or
call <code>tokenizer.update_post_processor()</code> to make sure that the post-processing is correctly done (otherwise the
values of the first token and final token of an encoded sequence will not be correct). For more details, checkout
[post-processors] (<a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">https://huggingface.co/docs/tokenizers/api/post-processors</a>) documentation.`,Do,Tt,sa=`This tokenizer inherits from <code>PreTrainedTokenizerFast</code> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,Oo,vt,Ye,Ko,ne,Be,en,Mt,ra=`Retrieves sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> or <code>encode_plus</code> methods.`,tn,R,Xe,on,wt,la=`Create the token type IDs corresponding to the sequences passed. <a href="../glossary#token-type-ids">What are token type
IDs?</a>`,nn,Lt,ia="Should be overridden in a subclass if the model has a special way of building those.",an,ae,Ae,sn,$t,da="Updates the underlying post processor with the current <code>bos_token</code> and <code>eos_token</code>.",rn,xt,Qe,Mo,De,wo,U,Oe,ln,Ct,ca="The bare Llama Model outputting raw hidden-states without any specific head on top.",dn,zt,ma=`This model inherits from <a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,cn,jt,pa=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,mn,N,Ke,pn,Ft,ha='The <a href="/docs/transformers/main/ko/model_doc/llama2#transformers.LlamaModel">LlamaModel</a> forward method, overrides the <code>__call__</code> special method.',hn,se,Lo,et,$o,W,tt,un,Ut,ua="The Llama Model for causal language modeling.",fn,Wt,fa=`This model inherits from <a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,gn,Jt,ga=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,_n,H,ot,bn,qt,_a='The <a href="/docs/transformers/main/ko/model_doc/llama2#transformers.LlamaForCausalLM">LlamaForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',kn,re,yn,le,xo,nt,Co,z,at,Tn,It,ba="The LLaMa Model transformer with a sequence classification head on top (linear layer).",vn,Zt,ka=`<a href="/docs/transformers/main/ko/model_doc/llama2#transformers.LlamaForSequenceClassification">LlamaForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.`,Mn,Gt,ya=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,wn,Ht,Ta=`This model inherits from <a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ln,Pt,va=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,$n,q,st,xn,Et,Ma='The <a href="/docs/transformers/main/ko/model_doc/llama2#transformers.LlamaForSequenceClassification">LlamaForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Cn,ie,zn,de,jn,ce,zo,rt,jo,St,Fo;return v=new A({props:{title:"Llama2",local:"llama2",headingTag:"h1"}}),T=new A({props:{title:"개요",local:"overview",headingTag:"h2"}}),D=new Wo({props:{warning:!0,$$slots:{default:[Ua]},$$scope:{ctx:L}}}),ke=new pe({props:{code:"cHl0aG9uJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGbGxhbWElMkZjb252ZXJ0X2xsYW1hX3dlaWdodHNfdG9faGYucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLWlucHV0X2RpciUyMCUyRnBhdGglMkZ0byUyRmRvd25sb2FkZWQlMkZsbGFtYSUyRndlaWdodHMlMjAtLW1vZGVsX3NpemUlMjA3QiUyMC0tb3V0cHV0X2RpciUyMCUyRm91dHB1dCUyRnBhdGg=",highlighted:`python src/transformers/models/llama/convert_llama_weights_to_hf.py \\
    --input_dir /path/to/downloaded/llama/weights --model_size 7B --output_dir /output/path`,wrap:!1}}),Te=new pe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hRm9yQ2F1c2FsTE0lMkMlMjBMbGFtYVRva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMExsYW1hVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjIlMkZvdXRwdXQlMkZwYXRoJTIyKSUwQW1vZGVsJTIwJTNEJTIwTGxhbWFGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyJTJGb3V0cHV0JTJGcGF0aCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaForCausalLM, LlamaTokenizer

tokenizer = LlamaTokenizer.from_pretrained(<span class="hljs-string">&quot;/output/path&quot;</span>)
model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;/output/path&quot;</span>)`,wrap:!1}}),Le=new A({props:{title:"리소스",local:"resources",headingTag:"h2"}}),Ce=new ja({props:{pipeline:"text-generation"}}),Ie=new A({props:{title:"LlamaConfig",local:"llamaconfig ][ transformers.LlamaConfig",headingTag:"h2"}}),Ze=new j({props:{name:"class transformers.LlamaConfig",anchor:"transformers.LlamaConfig",parameters:[{name:"vocab_size",val:" = 32000"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 11008"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"num_key_value_heads",val:" = None"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 2048"},{name:"initializer_range",val:" = 0.02"},{name:"rms_norm_eps",val:" = 1e-06"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = None"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"pretraining_tp",val:" = 1"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 10000.0"},{name:"rope_scaling",val:" = None"},{name:"attention_bias",val:" = False"},{name:"attention_dropout",val:" = 0.0"},{name:"mlp_bias",val:" = False"},{name:"head_dim",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlamaConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
Vocabulary size of the LLaMA model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/ko/model_doc/llama2#transformers.LlamaModel">LlamaModel</a>`,name:"vocab_size"},{anchor:"transformers.LlamaConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.LlamaConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 11008) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.LlamaConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.LlamaConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.LlamaConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to
<code>num_attention_heads</code>.`,name:"num_key_value_heads"},{anchor:"transformers.LlamaConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.LlamaConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that this model might ever be used with. Llama 1 supports up to 2048 tokens,
Llama 2 up to 4096, CodeLlama up to 16384.`,name:"max_position_embeddings"},{anchor:"transformers.LlamaConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.LlamaConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.LlamaConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.LlamaConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.LlamaConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.LlamaConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.LlamaConfig.pretraining_tp",description:`<strong>pretraining_tp</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Experimental feature. Tensor parallelism rank used during pretraining. Please refer to <a href="https://huggingface.co/docs/transformers/main/perf_train_gpu_many#tensor-parallelism" rel="nofollow">this
document</a> to
understand more about it. This value is necessary to ensure exact reproducibility of the pretraining
results. Please refer to <a href="https://github.com/pytorch/pytorch/issues/76232" rel="nofollow">this issue</a>.`,name:"pretraining_tp"},{anchor:"transformers.LlamaConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.LlamaConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.LlamaConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. NOTE: if you apply new rope type
and you expect the model to work on longer <code>max_position_embeddings</code>, we recommend you to update this value
accordingly.
Expected contents:
<code>rope_type</code> (<code>str</code>):
The sub-variant of RoPE to use. Can be one of [&#x2018;default&#x2019;, &#x2018;linear&#x2019;, &#x2018;dynamic&#x2019;, &#x2018;yarn&#x2019;, &#x2018;longrope&#x2019;,
&#x2018;llama3&#x2019;], with &#x2018;default&#x2019; being the original RoPE implementation.
<code>factor</code> (<code>float</code>, <em>optional</em>):
Used with all rope types except &#x2018;default&#x2019;. The scaling factor to apply to the RoPE embeddings. In
most scaling types, a <code>factor</code> of x will enable the model to handle sequences of length x <em>
original maximum pre-trained length.
<code>original_max_position_embeddings</code> (<code>int</code>, </em>optional<em>):
Used with &#x2018;dynamic&#x2019;, &#x2018;longrope&#x2019; and &#x2018;llama3&#x2019;. The original max position embeddings used during
pretraining.
<code>attention_factor</code> (<code>float</code>, </em>optional<em>):
Used with &#x2018;yarn&#x2019; and &#x2018;longrope&#x2019;. The scaling factor to be applied on the attention
computation. If unspecified, it defaults to value recommended by the implementation, using the
<code>factor</code> field to infer the suggested value.
<code>beta_fast</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for extrapolation (only) in the linear
ramp function. If unspecified, it defaults to 32.
<code>beta_slow</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for interpolation (only) in the linear
ramp function. If unspecified, it defaults to 1.
<code>short_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to short contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>long_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to long contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>low_freq_factor</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to low frequency components of the RoPE
<code>high_freq_factor</code> (<code>float</code>, </em>optional*):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to high frequency components of the RoPE`,name:"rope_scaling"},{anchor:"transformers.LlamaConfig.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.`,name:"attention_bias"},{anchor:"transformers.LlamaConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.LlamaConfig.mlp_bias",description:`<strong>mlp_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in up_proj, down_proj and gate_proj layers in the MLP layers.`,name:"mlp_bias"},{anchor:"transformers.LlamaConfig.head_dim",description:`<strong>head_dim</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The attention head dimension. If None, it will default to hidden_size // num_attention_heads`,name:"head_dim"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/configuration_llama.py#L26"}}),O=new Nt({props:{anchor:"transformers.LlamaConfig.example",$$slots:{default:[Wa]},$$scope:{ctx:L}}}),Ge=new A({props:{title:"LlamaTokenizer",local:"llamatokenizer ][ transformers.LlamaTokenizer",headingTag:"h2"}}),He=new j({props:{name:"class transformers.LlamaTokenizer",anchor:"transformers.LlamaTokenizer",parameters:[{name:"vocab_file",val:""},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"pad_token",val:" = None"},{name:"sp_model_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"use_default_system_prompt",val:" = False"},{name:"spaces_between_special_tokens",val:" = False"},{name:"legacy",val:" = None"},{name:"add_prefix_space",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlamaTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.LlamaTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.LlamaTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.`,name:"bos_token"},{anchor:"transformers.LlamaTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.LlamaTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>) &#x2014;
A special token used to make arrays of tokens the same size for batching purpose. Will then be ignored by
attention mechanisms or loss computation.`,name:"pad_token"},{anchor:"transformers.LlamaTokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>Dict[str, Any]</code>, <code>Optional</code>, <em>optional</em>) &#x2014;
Will be passed to the <code>SentencePieceProcessor.__init__()</code> method. The <a href="https://github.com/google/sentencepiece/tree/master/python" rel="nofollow">Python wrapper for
SentencePiece</a> can be used, among other things,
to set:</p>
<ul>
<li>
<p><code>enable_sampling</code>: Enable subword regularization.</p>
</li>
<li>
<p><code>nbest_size</code>: Sampling parameters for unigram. Invalid for BPE-Dropout.</p>
<ul>
<li><code>nbest_size = {0,1}</code>: No sampling is performed.</li>
<li><code>nbest_size &gt; 1</code>: samples from the nbest_size results.</li>
<li><code>nbest_size &lt; 0</code>: assuming that nbest_size is infinite and samples from the all hypothesis (lattice)
using forward-filtering-and-backward-sampling algorithm.</li>
</ul>
</li>
<li>
<p><code>alpha</code>: Smoothing parameter for unigram sampling, and dropout probability of merge operations for
BPE-dropout.</p>
</li>
</ul>`,name:"sp_model_kwargs"},{anchor:"transformers.LlamaTokenizer.add_bos_token",description:`<strong>add_bos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to add an <code>bos_token</code> at the start of sequences.`,name:"add_bos_token"},{anchor:"transformers.LlamaTokenizer.add_eos_token",description:`<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add an <code>eos_token</code> at the end of sequences.`,name:"add_eos_token"},{anchor:"transformers.LlamaTokenizer.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to cleanup spaces after decoding, cleanup consists in removing potential artifacts like
extra spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.LlamaTokenizer.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the default system prompt for Llama should be used.`,name:"use_default_system_prompt"},{anchor:"transformers.LlamaTokenizer.spaces_between_special_tokens",description:`<strong>spaces_between_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add spaces between special tokens.`,name:"spaces_between_special_tokens"},{anchor:"transformers.LlamaTokenizer.legacy",description:`<strong>legacy</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the <code>legacy</code> behavior of the tokenizer should be used. Legacy is before the merge of #24622
and #25224 which includes fixes to properly handle tokens that appear after special tokens.
Make sure to also set <code>from_slow</code> to <code>True</code>.
A simple example:</p>
<ul>
<li><code>legacy=True</code>:</li>
</ul>`,name:"legacy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama.py#L55"}}),Pe=new j({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.LlamaTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama.py#L333"}}),Ee=new j({props:{name:"get_special_tokens_mask",anchor:"transformers.LlamaTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.LlamaTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.LlamaTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.LlamaTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama.py#L344",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Re=new j({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.LlamaTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.LlamaTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids.`,name:"token_ids_0"},{anchor:"transformers.LlamaTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama.py#L381",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#token-type-ids">token type IDs</a> according to the given sequence(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ee=new Nt({props:{anchor:"transformers.LlamaTokenizer.create_token_type_ids_from_sequences.example",$$slots:{default:[Ja]},$$scope:{ctx:L}}}),Ne=new j({props:{name:"save_vocabulary",anchor:"transformers.LlamaTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:""},{name:"filename_prefix",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"transformers.LlamaTokenizer.save_vocabulary.save_directory",description:`<strong>save_directory</strong> (<code>str</code>) &#x2014;
The directory in which to save the vocabulary.`,name:"save_directory"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama.py#L306",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Paths to the files saved.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple(str)</code></p>
`}}),Se=new A({props:{title:"LlamaTokenizerFast",local:"llamatokenizerfast ][ transformers.LlamaTokenizerFast",headingTag:"h2"}}),Ve=new j({props:{name:"class transformers.LlamaTokenizerFast",anchor:"transformers.LlamaTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"use_default_system_prompt",val:" = False"},{name:"legacy",val:" = None"},{name:"add_prefix_space",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlamaTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a .model extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.LlamaTokenizerFast.tokenizer_file",description:`<strong>tokenizer_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
<a href="https://github.com/huggingface/tokenizers" rel="nofollow">tokenizers</a> file (generally has a .json extension) that
contains everything needed to load the tokenizer.`,name:"tokenizer_file"},{anchor:"transformers.LlamaTokenizerFast.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to cleanup spaces after decoding, cleanup consists in removing potential artifacts like
extra spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.LlamaTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.LlamaTokenizerFast.bos_token",description:`<strong>bos_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.`,name:"bos_token"},{anchor:"transformers.LlamaTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.LlamaTokenizerFast.add_bos_token",description:`<strong>add_bos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to add an <code>bos_token</code> at the start of sequences.`,name:"add_bos_token"},{anchor:"transformers.LlamaTokenizerFast.add_eos_token",description:`<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add an <code>eos_token</code> at the end of sequences.`,name:"add_eos_token"},{anchor:"transformers.LlamaTokenizerFast.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the default system prompt for Llama should be used`,name:"use_default_system_prompt"},{anchor:"transformers.LlamaTokenizerFast.legacy",description:`<strong>legacy</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the <code>legacy</code> behavior of the tokenizer should be used. Legacy is before the merge of #24622
and #25224 which includes fixes to properly handle tokens that appear after special tokens.
Make sure to also set <code>from_slow</code> to <code>True</code>.
A simple example:</p>
<ul>
<li><code>legacy=True</code>:</li>
</ul>`,name:"legacy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama_fast.py#L46"}}),oe=new Nt({props:{anchor:"transformers.LlamaTokenizerFast.example",$$slots:{default:[qa]},$$scope:{ctx:L}}}),Ye=new j({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.LlamaTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama_fast.py#L243"}}),Be=new j({props:{name:"get_special_tokens_mask",anchor:"transformers.LlamaTokenizerFast.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.LlamaTokenizerFast.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids of the first sequence.`,name:"token_ids_0"},{anchor:"transformers.LlamaTokenizerFast.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
List of ids of the second sequence.`,name:"token_ids_1"},{anchor:"transformers.LlamaTokenizerFast.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L3865",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]</p>
`}}),Xe=new j({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.LlamaTokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.LlamaTokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:"<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014; The first tokenized sequence.",name:"token_ids_0"},{anchor:"transformers.LlamaTokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:"<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014; The second tokenized sequence.",name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L3388",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The token type ids.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Ae=new j({props:{name:"update_post_processor",anchor:"transformers.LlamaTokenizerFast.update_post_processor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama_fast.py#L178"}}),Qe=new j({props:{name:"save_vocabulary",anchor:"transformers.LlamaTokenizerFast.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/tokenization_llama_fast.py#L222"}}),De=new A({props:{title:"LlamaModel",local:"llamamodel ][ transformers.LlamaModel",headingTag:"h2"}}),Oe=new j({props:{name:"class transformers.LlamaModel",anchor:"transformers.LlamaModel",parameters:[{name:"config",val:": LlamaConfig"}],parametersDescription:[{anchor:"transformers.LlamaModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ko/model_doc/llama2#transformers.LlamaConfig">LlamaConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/modeling_llama.py#L363"}}),Ke=new j({props:{name:"forward",anchor:"transformers.LlamaModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**flash_attn_kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.LlamaModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/ko/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/ko/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/ko/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlamaModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.LlamaModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlamaModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/ko/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlamaModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlamaModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlamaModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlamaModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlamaModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/modeling_llama.py#L387",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/ko/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/ko/model_doc/llama2#transformers.LlamaConfig"
>LlamaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/ko/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),se=new Wo({props:{$$slots:{default:[Ia]},$$scope:{ctx:L}}}),et=new A({props:{title:"LlamaForCausalLM",local:"llamaforcausallm ][ transformers.LlamaForCausalLM",headingTag:"h2"}}),tt=new j({props:{name:"class transformers.LlamaForCausalLM",anchor:"transformers.LlamaForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.LlamaForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ko/model_doc/llama2#transformers.LlamaForCausalLM">LlamaForCausalLM</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/modeling_llama.py#L610"}}),ot=new j({props:{name:"forward",anchor:"transformers.LlamaForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llama.modeling_llama.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.LlamaForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/ko/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/ko/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/ko/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlamaForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.LlamaForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlamaForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/ko/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlamaForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlamaForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.LlamaForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlamaForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlamaForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlamaForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.LlamaForCausalLM.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/modeling_llama.py#L643",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/ko/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/ko/model_doc/llama2#transformers.LlamaConfig"
>LlamaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/ko/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),re=new Wo({props:{$$slots:{default:[Za]},$$scope:{ctx:L}}}),le=new Nt({props:{anchor:"transformers.LlamaForCausalLM.forward.example",$$slots:{default:[Ga]},$$scope:{ctx:L}}}),nt=new A({props:{title:"LlamaForSequenceClassification",local:"llamaforsequenceclassification ][ transformers.LlamaForSequenceClassification",headingTag:"h2"}}),at=new j({props:{name:"class transformers.LlamaForSequenceClassification",anchor:"transformers.LlamaForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.LlamaForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ko/model_doc/llama2#transformers.LlamaForSequenceClassification">LlamaForSequenceClassification</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/modeling_llama.py#L719"}}),st=new j({props:{name:"forward",anchor:"transformers.LlamaForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.LlamaForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/ko/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/ko/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/ko/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlamaForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.LlamaForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlamaForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/ko/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlamaForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlamaForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.LlamaForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlamaForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlamaForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/modeling_llama.py#L749",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/ko/model_doc/llama2#transformers.LlamaConfig"
>LlamaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ie=new Wo({props:{$$slots:{default:[Ha]},$$scope:{ctx:L}}}),de=new Nt({props:{anchor:"transformers.LlamaForSequenceClassification.forward.example",$$slots:{default:[Pa]},$$scope:{ctx:L}}}),ce=new Nt({props:{anchor:"transformers.LlamaForSequenceClassification.forward.example-2",$$slots:{default:[Ea]},$$scope:{ctx:L}}}),rt=new Fa({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ko/model_doc/llama2.md"}}),{c(){r=i("meta"),y=n(),m=i("p"),h=n(),u(v.$$.fragment),c=n(),u(T.$$.fragment),he=n(),$=i("p"),$.innerHTML=Q,Bt=n(),ue=i("p"),ue.textContent=Fn,Xt=n(),fe=i("p"),fe.innerHTML=Un,At=n(),ge=i("p"),ge.innerHTML=Wn,Qt=n(),u(D.$$.fragment),Dt=n(),_e=i("p"),_e.textContent=Jn,Ot=n(),be=i("ul"),be.innerHTML=qn,Kt=n(),u(ke.$$.fragment),eo=n(),ye=i("ul"),ye.innerHTML=In,to=n(),u(Te.$$.fragment),oo=n(),ve=i("p"),ve.textContent=Zn,no=n(),Me=i("ul"),Me.innerHTML=Gn,ao=n(),we=i("p"),we.innerHTML=Hn,so=n(),u(Le.$$.fragment),ro=n(),$e=i("p"),$e.textContent=Pn,lo=n(),xe=i("ul"),xe.innerHTML=En,io=n(),u(Ce.$$.fragment),co=n(),ze=i("ul"),ze.innerHTML=Rn,mo=n(),je=i("p"),je.textContent=Nn,po=n(),Fe=i("ul"),Fe.innerHTML=Sn,ho=n(),Ue=i("p"),Ue.textContent=Vn,uo=n(),We=i("ul"),We.innerHTML=Yn,fo=n(),Je=i("p"),Je.textContent=Bn,go=n(),qe=i("ul"),qe.innerHTML=Xn,_o=n(),u(Ie.$$.fragment),bo=n(),Z=i("div"),u(Ze.$$.fragment),Jo=n(),ct=i("p"),ct.innerHTML=An,qo=n(),mt=i("p"),mt.innerHTML=Qn,Io=n(),u(O.$$.fragment),ko=n(),u(Ge.$$.fragment),yo=n(),F=i("div"),u(He.$$.fragment),Zo=n(),pt=i("p"),pt.textContent=Dn,Go=n(),ht=i("div"),u(Pe.$$.fragment),Ho=n(),K=i("div"),u(Ee.$$.fragment),Po=n(),ut=i("p"),ut.innerHTML=On,Eo=n(),G=i("div"),u(Re.$$.fragment),Ro=n(),ft=i("p"),ft.textContent=Kn,No=n(),u(ee.$$.fragment),So=n(),gt=i("p"),gt.textContent=ea,Vo=n(),te=i("div"),u(Ne.$$.fragment),Yo=n(),_t=i("p"),_t.textContent=ta,To=n(),u(Se.$$.fragment),vo=n(),M=i("div"),u(Ve.$$.fragment),Bo=n(),bt=i("p"),bt.textContent=oa,Xo=n(),kt=i("p"),kt.textContent=na,Ao=n(),u(oe.$$.fragment),Qo=n(),yt=i("p"),yt.innerHTML=aa,Do=n(),Tt=i("p"),Tt.innerHTML=sa,Oo=n(),vt=i("div"),u(Ye.$$.fragment),Ko=n(),ne=i("div"),u(Be.$$.fragment),en=n(),Mt=i("p"),Mt.innerHTML=ra,tn=n(),R=i("div"),u(Xe.$$.fragment),on=n(),wt=i("p"),wt.innerHTML=la,nn=n(),Lt=i("p"),Lt.textContent=ia,an=n(),ae=i("div"),u(Ae.$$.fragment),sn=n(),$t=i("p"),$t.innerHTML=da,rn=n(),xt=i("div"),u(Qe.$$.fragment),Mo=n(),u(De.$$.fragment),wo=n(),U=i("div"),u(Oe.$$.fragment),ln=n(),Ct=i("p"),Ct.textContent=ca,dn=n(),zt=i("p"),zt.innerHTML=ma,cn=n(),jt=i("p"),jt.innerHTML=pa,mn=n(),N=i("div"),u(Ke.$$.fragment),pn=n(),Ft=i("p"),Ft.innerHTML=ha,hn=n(),u(se.$$.fragment),Lo=n(),u(et.$$.fragment),$o=n(),W=i("div"),u(tt.$$.fragment),un=n(),Ut=i("p"),Ut.textContent=ua,fn=n(),Wt=i("p"),Wt.innerHTML=fa,gn=n(),Jt=i("p"),Jt.innerHTML=ga,_n=n(),H=i("div"),u(ot.$$.fragment),bn=n(),qt=i("p"),qt.innerHTML=_a,kn=n(),u(re.$$.fragment),yn=n(),u(le.$$.fragment),xo=n(),u(nt.$$.fragment),Co=n(),z=i("div"),u(at.$$.fragment),Tn=n(),It=i("p"),It.textContent=ba,vn=n(),Zt=i("p"),Zt.innerHTML=ka,Mn=n(),Gt=i("p"),Gt.innerHTML=ya,wn=n(),Ht=i("p"),Ht.innerHTML=Ta,Ln=n(),Pt=i("p"),Pt.innerHTML=va,$n=n(),q=i("div"),u(st.$$.fragment),xn=n(),Et=i("p"),Et.innerHTML=Ma,Cn=n(),u(ie.$$.fragment),zn=n(),u(de.$$.fragment),jn=n(),u(ce.$$.fragment),zo=n(),u(rt.$$.fragment),jo=n(),St=i("p"),this.h()},l(e){const t=za("svelte-u9bgzb",document.head);r=d(t,"META",{name:!0,content:!0}),t.forEach(o),y=a(e),m=d(e,"P",{}),x(m).forEach(o),h=a(e),f(v.$$.fragment,e),c=a(e),f(T.$$.fragment,e),he=a(e),$=d(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1mg2hun"&&($.innerHTML=Q),Bt=a(e),ue=d(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-e5r8wp"&&(ue.textContent=Fn),Xt=a(e),fe=d(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-18r1nwx"&&(fe.innerHTML=Un),At=a(e),ge=d(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-yxvvyr"&&(ge.innerHTML=Wn),Qt=a(e),f(D.$$.fragment,e),Dt=a(e),_e=d(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1u4pjic"&&(_e.textContent=Jn),Ot=a(e),be=d(e,"UL",{"data-svelte-h":!0}),p(be)!=="svelte-p2ih1q"&&(be.innerHTML=qn),Kt=a(e),f(ke.$$.fragment,e),eo=a(e),ye=d(e,"UL",{"data-svelte-h":!0}),p(ye)!=="svelte-11p27m1"&&(ye.innerHTML=In),to=a(e),f(Te.$$.fragment,e),oo=a(e),ve=d(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-45syni"&&(ve.textContent=Zn),no=a(e),Me=d(e,"UL",{"data-svelte-h":!0}),p(Me)!=="svelte-w3e8c3"&&(Me.innerHTML=Gn),ao=a(e),we=d(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1yrcdop"&&(we.innerHTML=Hn),so=a(e),f(Le.$$.fragment,e),ro=a(e),$e=d(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-109c5g6"&&($e.textContent=Pn),lo=a(e),xe=d(e,"UL",{"data-svelte-h":!0}),p(xe)!=="svelte-13tfjo2"&&(xe.innerHTML=En),io=a(e),f(Ce.$$.fragment,e),co=a(e),ze=d(e,"UL",{"data-svelte-h":!0}),p(ze)!=="svelte-18uwvgq"&&(ze.innerHTML=Rn),mo=a(e),je=d(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-14a1znp"&&(je.textContent=Nn),po=a(e),Fe=d(e,"UL",{"data-svelte-h":!0}),p(Fe)!=="svelte-10ni5hq"&&(Fe.innerHTML=Sn),ho=a(e),Ue=d(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1x58uo"&&(Ue.textContent=Vn),uo=a(e),We=d(e,"UL",{"data-svelte-h":!0}),p(We)!=="svelte-a0syhq"&&(We.innerHTML=Yn),fo=a(e),Je=d(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-3z2x4b"&&(Je.textContent=Bn),go=a(e),qe=d(e,"UL",{"data-svelte-h":!0}),p(qe)!=="svelte-jjnuxc"&&(qe.innerHTML=Xn),_o=a(e),f(Ie.$$.fragment,e),bo=a(e),Z=d(e,"DIV",{class:!0});var P=x(Z);f(Ze.$$.fragment,P),Jo=a(P),ct=d(P,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-1ej3gng"&&(ct.innerHTML=An),qo=a(P),mt=d(P,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-qr3t5r"&&(mt.innerHTML=Qn),Io=a(P),f(O.$$.fragment,P),P.forEach(o),ko=a(e),f(Ge.$$.fragment,e),yo=a(e),F=d(e,"DIV",{class:!0});var J=x(F);f(He.$$.fragment,J),Zo=a(J),pt=d(J,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-qfiu5a"&&(pt.textContent=Dn),Go=a(J),ht=d(J,"DIV",{class:!0});var Vt=x(ht);f(Pe.$$.fragment,Vt),Vt.forEach(o),Ho=a(J),K=d(J,"DIV",{class:!0});var lt=x(K);f(Ee.$$.fragment,lt),Po=a(lt),ut=d(lt,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-1f4f5kp"&&(ut.innerHTML=On),lt.forEach(o),Eo=a(J),G=d(J,"DIV",{class:!0});var E=x(G);f(Re.$$.fragment,E),Ro=a(E),ft=d(E,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-13bfd60"&&(ft.textContent=Kn),No=a(E),f(ee.$$.fragment,E),So=a(E),gt=d(E,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-wtrslu"&&(gt.textContent=ea),E.forEach(o),Vo=a(J),te=d(J,"DIV",{class:!0});var it=x(te);f(Ne.$$.fragment,it),Yo=a(it),_t=d(it,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-1slb66l"&&(_t.textContent=ta),it.forEach(o),J.forEach(o),To=a(e),f(Se.$$.fragment,e),vo=a(e),M=d(e,"DIV",{class:!0});var w=x(M);f(Ve.$$.fragment,w),Bo=a(w),bt=d(w,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-15tdcz8"&&(bt.textContent=oa),Xo=a(w),kt=d(w,"P",{"data-svelte-h":!0}),p(kt)!=="svelte-llhmpa"&&(kt.textContent=na),Ao=a(w),f(oe.$$.fragment,w),Qo=a(w),yt=d(w,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-cnb6q1"&&(yt.innerHTML=aa),Do=a(w),Tt=d(w,"P",{"data-svelte-h":!0}),p(Tt)!=="svelte-1ndfe3e"&&(Tt.innerHTML=sa),Oo=a(w),vt=d(w,"DIV",{class:!0});var Yt=x(vt);f(Ye.$$.fragment,Yt),Yt.forEach(o),Ko=a(w),ne=d(w,"DIV",{class:!0});var dt=x(ne);f(Be.$$.fragment,dt),en=a(dt),Mt=d(dt,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-1wmjg8a"&&(Mt.innerHTML=ra),dt.forEach(o),tn=a(w),R=d(w,"DIV",{class:!0});var X=x(R);f(Xe.$$.fragment,X),on=a(X),wt=d(X,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-zj1vf1"&&(wt.innerHTML=la),nn=a(X),Lt=d(X,"P",{"data-svelte-h":!0}),p(Lt)!=="svelte-9vptpw"&&(Lt.textContent=ia),X.forEach(o),an=a(w),ae=d(w,"DIV",{class:!0});var Uo=x(ae);f(Ae.$$.fragment,Uo),sn=a(Uo),$t=d(Uo,"P",{"data-svelte-h":!0}),p($t)!=="svelte-nfci2w"&&($t.innerHTML=da),Uo.forEach(o),rn=a(w),xt=d(w,"DIV",{class:!0});var wa=x(xt);f(Qe.$$.fragment,wa),wa.forEach(o),w.forEach(o),Mo=a(e),f(De.$$.fragment,e),wo=a(e),U=d(e,"DIV",{class:!0});var S=x(U);f(Oe.$$.fragment,S),ln=a(S),Ct=d(S,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-ahmvbp"&&(Ct.textContent=ca),dn=a(S),zt=d(S,"P",{"data-svelte-h":!0}),p(zt)!=="svelte-u3dlub"&&(zt.innerHTML=ma),cn=a(S),jt=d(S,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-hswkmf"&&(jt.innerHTML=pa),mn=a(S),N=d(S,"DIV",{class:!0});var Rt=x(N);f(Ke.$$.fragment,Rt),pn=a(Rt),Ft=d(Rt,"P",{"data-svelte-h":!0}),p(Ft)!=="svelte-1hj4k2x"&&(Ft.innerHTML=ha),hn=a(Rt),f(se.$$.fragment,Rt),Rt.forEach(o),S.forEach(o),Lo=a(e),f(et.$$.fragment,e),$o=a(e),W=d(e,"DIV",{class:!0});var V=x(W);f(tt.$$.fragment,V),un=a(V),Ut=d(V,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-a2k4ga"&&(Ut.textContent=ua),fn=a(V),Wt=d(V,"P",{"data-svelte-h":!0}),p(Wt)!=="svelte-u3dlub"&&(Wt.innerHTML=fa),gn=a(V),Jt=d(V,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-hswkmf"&&(Jt.innerHTML=ga),_n=a(V),H=d(V,"DIV",{class:!0});var me=x(H);f(ot.$$.fragment,me),bn=a(me),qt=d(me,"P",{"data-svelte-h":!0}),p(qt)!=="svelte-cwjvpl"&&(qt.innerHTML=_a),kn=a(me),f(re.$$.fragment,me),yn=a(me),f(le.$$.fragment,me),me.forEach(o),V.forEach(o),xo=a(e),f(nt.$$.fragment,e),Co=a(e),z=d(e,"DIV",{class:!0});var I=x(z);f(at.$$.fragment,I),Tn=a(I),It=d(I,"P",{"data-svelte-h":!0}),p(It)!=="svelte-62must"&&(It.textContent=ba),vn=a(I),Zt=d(I,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-1v4exue"&&(Zt.innerHTML=ka),Mn=a(I),Gt=d(I,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-10ugs3m"&&(Gt.innerHTML=ya),wn=a(I),Ht=d(I,"P",{"data-svelte-h":!0}),p(Ht)!=="svelte-u3dlub"&&(Ht.innerHTML=Ta),Ln=a(I),Pt=d(I,"P",{"data-svelte-h":!0}),p(Pt)!=="svelte-hswkmf"&&(Pt.innerHTML=va),$n=a(I),q=d(I,"DIV",{class:!0});var Y=x(q);f(st.$$.fragment,Y),xn=a(Y),Et=d(Y,"P",{"data-svelte-h":!0}),p(Et)!=="svelte-tc4cob"&&(Et.innerHTML=Ma),Cn=a(Y),f(ie.$$.fragment,Y),zn=a(Y),f(de.$$.fragment,Y),jn=a(Y),f(ce.$$.fragment,Y),Y.forEach(o),I.forEach(o),zo=a(e),f(rt.$$.fragment,e),jo=a(e),St=d(e,"P",{}),x(St).forEach(o),this.h()},h(){C(r,"name","hf:doc:metadata"),C(r,"content",Na),C(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){s(document.head,r),l(e,y,t),l(e,m,t),l(e,h,t),g(v,e,t),l(e,c,t),g(T,e,t),l(e,he,t),l(e,$,t),l(e,Bt,t),l(e,ue,t),l(e,Xt,t),l(e,fe,t),l(e,At,t),l(e,ge,t),l(e,Qt,t),g(D,e,t),l(e,Dt,t),l(e,_e,t),l(e,Ot,t),l(e,be,t),l(e,Kt,t),g(ke,e,t),l(e,eo,t),l(e,ye,t),l(e,to,t),g(Te,e,t),l(e,oo,t),l(e,ve,t),l(e,no,t),l(e,Me,t),l(e,ao,t),l(e,we,t),l(e,so,t),g(Le,e,t),l(e,ro,t),l(e,$e,t),l(e,lo,t),l(e,xe,t),l(e,io,t),g(Ce,e,t),l(e,co,t),l(e,ze,t),l(e,mo,t),l(e,je,t),l(e,po,t),l(e,Fe,t),l(e,ho,t),l(e,Ue,t),l(e,uo,t),l(e,We,t),l(e,fo,t),l(e,Je,t),l(e,go,t),l(e,qe,t),l(e,_o,t),g(Ie,e,t),l(e,bo,t),l(e,Z,t),g(Ze,Z,null),s(Z,Jo),s(Z,ct),s(Z,qo),s(Z,mt),s(Z,Io),g(O,Z,null),l(e,ko,t),g(Ge,e,t),l(e,yo,t),l(e,F,t),g(He,F,null),s(F,Zo),s(F,pt),s(F,Go),s(F,ht),g(Pe,ht,null),s(F,Ho),s(F,K),g(Ee,K,null),s(K,Po),s(K,ut),s(F,Eo),s(F,G),g(Re,G,null),s(G,Ro),s(G,ft),s(G,No),g(ee,G,null),s(G,So),s(G,gt),s(F,Vo),s(F,te),g(Ne,te,null),s(te,Yo),s(te,_t),l(e,To,t),g(Se,e,t),l(e,vo,t),l(e,M,t),g(Ve,M,null),s(M,Bo),s(M,bt),s(M,Xo),s(M,kt),s(M,Ao),g(oe,M,null),s(M,Qo),s(M,yt),s(M,Do),s(M,Tt),s(M,Oo),s(M,vt),g(Ye,vt,null),s(M,Ko),s(M,ne),g(Be,ne,null),s(ne,en),s(ne,Mt),s(M,tn),s(M,R),g(Xe,R,null),s(R,on),s(R,wt),s(R,nn),s(R,Lt),s(M,an),s(M,ae),g(Ae,ae,null),s(ae,sn),s(ae,$t),s(M,rn),s(M,xt),g(Qe,xt,null),l(e,Mo,t),g(De,e,t),l(e,wo,t),l(e,U,t),g(Oe,U,null),s(U,ln),s(U,Ct),s(U,dn),s(U,zt),s(U,cn),s(U,jt),s(U,mn),s(U,N),g(Ke,N,null),s(N,pn),s(N,Ft),s(N,hn),g(se,N,null),l(e,Lo,t),g(et,e,t),l(e,$o,t),l(e,W,t),g(tt,W,null),s(W,un),s(W,Ut),s(W,fn),s(W,Wt),s(W,gn),s(W,Jt),s(W,_n),s(W,H),g(ot,H,null),s(H,bn),s(H,qt),s(H,kn),g(re,H,null),s(H,yn),g(le,H,null),l(e,xo,t),g(nt,e,t),l(e,Co,t),l(e,z,t),g(at,z,null),s(z,Tn),s(z,It),s(z,vn),s(z,Zt),s(z,Mn),s(z,Gt),s(z,wn),s(z,Ht),s(z,Ln),s(z,Pt),s(z,$n),s(z,q),g(st,q,null),s(q,xn),s(q,Et),s(q,Cn),g(ie,q,null),s(q,zn),g(de,q,null),s(q,jn),g(ce,q,null),l(e,zo,t),g(rt,e,t),l(e,jo,t),l(e,St,t),Fo=!0},p(e,[t]){const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),D.$set(P);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),O.$set(J);const Vt={};t&2&&(Vt.$$scope={dirty:t,ctx:e}),ee.$set(Vt);const lt={};t&2&&(lt.$$scope={dirty:t,ctx:e}),oe.$set(lt);const E={};t&2&&(E.$$scope={dirty:t,ctx:e}),se.$set(E);const it={};t&2&&(it.$$scope={dirty:t,ctx:e}),re.$set(it);const w={};t&2&&(w.$$scope={dirty:t,ctx:e}),le.$set(w);const Yt={};t&2&&(Yt.$$scope={dirty:t,ctx:e}),ie.$set(Yt);const dt={};t&2&&(dt.$$scope={dirty:t,ctx:e}),de.$set(dt);const X={};t&2&&(X.$$scope={dirty:t,ctx:e}),ce.$set(X)},i(e){Fo||(_(v.$$.fragment,e),_(T.$$.fragment,e),_(D.$$.fragment,e),_(ke.$$.fragment,e),_(Te.$$.fragment,e),_(Le.$$.fragment,e),_(Ce.$$.fragment,e),_(Ie.$$.fragment,e),_(Ze.$$.fragment,e),_(O.$$.fragment,e),_(Ge.$$.fragment,e),_(He.$$.fragment,e),_(Pe.$$.fragment,e),_(Ee.$$.fragment,e),_(Re.$$.fragment,e),_(ee.$$.fragment,e),_(Ne.$$.fragment,e),_(Se.$$.fragment,e),_(Ve.$$.fragment,e),_(oe.$$.fragment,e),_(Ye.$$.fragment,e),_(Be.$$.fragment,e),_(Xe.$$.fragment,e),_(Ae.$$.fragment,e),_(Qe.$$.fragment,e),_(De.$$.fragment,e),_(Oe.$$.fragment,e),_(Ke.$$.fragment,e),_(se.$$.fragment,e),_(et.$$.fragment,e),_(tt.$$.fragment,e),_(ot.$$.fragment,e),_(re.$$.fragment,e),_(le.$$.fragment,e),_(nt.$$.fragment,e),_(at.$$.fragment,e),_(st.$$.fragment,e),_(ie.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(rt.$$.fragment,e),Fo=!0)},o(e){b(v.$$.fragment,e),b(T.$$.fragment,e),b(D.$$.fragment,e),b(ke.$$.fragment,e),b(Te.$$.fragment,e),b(Le.$$.fragment,e),b(Ce.$$.fragment,e),b(Ie.$$.fragment,e),b(Ze.$$.fragment,e),b(O.$$.fragment,e),b(Ge.$$.fragment,e),b(He.$$.fragment,e),b(Pe.$$.fragment,e),b(Ee.$$.fragment,e),b(Re.$$.fragment,e),b(ee.$$.fragment,e),b(Ne.$$.fragment,e),b(Se.$$.fragment,e),b(Ve.$$.fragment,e),b(oe.$$.fragment,e),b(Ye.$$.fragment,e),b(Be.$$.fragment,e),b(Xe.$$.fragment,e),b(Ae.$$.fragment,e),b(Qe.$$.fragment,e),b(De.$$.fragment,e),b(Oe.$$.fragment,e),b(Ke.$$.fragment,e),b(se.$$.fragment,e),b(et.$$.fragment,e),b(tt.$$.fragment,e),b(ot.$$.fragment,e),b(re.$$.fragment,e),b(le.$$.fragment,e),b(nt.$$.fragment,e),b(at.$$.fragment,e),b(st.$$.fragment,e),b(ie.$$.fragment,e),b(de.$$.fragment,e),b(ce.$$.fragment,e),b(rt.$$.fragment,e),Fo=!1},d(e){e&&(o(y),o(m),o(h),o(c),o(he),o($),o(Bt),o(ue),o(Xt),o(fe),o(At),o(ge),o(Qt),o(Dt),o(_e),o(Ot),o(be),o(Kt),o(eo),o(ye),o(to),o(oo),o(ve),o(no),o(Me),o(ao),o(we),o(so),o(ro),o($e),o(lo),o(xe),o(io),o(co),o(ze),o(mo),o(je),o(po),o(Fe),o(ho),o(Ue),o(uo),o(We),o(fo),o(Je),o(go),o(qe),o(_o),o(bo),o(Z),o(ko),o(yo),o(F),o(To),o(vo),o(M),o(Mo),o(wo),o(U),o(Lo),o($o),o(W),o(xo),o(Co),o(z),o(zo),o(jo),o(St)),o(r),k(v,e),k(T,e),k(D,e),k(ke,e),k(Te,e),k(Le,e),k(Ce,e),k(Ie,e),k(Ze),k(O),k(Ge,e),k(He),k(Pe),k(Ee),k(Re),k(ee),k(Ne),k(Se,e),k(Ve),k(oe),k(Ye),k(Be),k(Xe),k(Ae),k(Qe),k(De,e),k(Oe),k(Ke),k(se),k(et,e),k(tt),k(ot),k(re),k(le),k(nt,e),k(at),k(st),k(ie),k(de),k(ce),k(rt,e)}}}const Na='{"title":"Llama2","local":"llama2","sections":[{"title":"개요","local":"overview","sections":[],"depth":2},{"title":"리소스","local":"resources","sections":[],"depth":2},{"title":"LlamaConfig","local":"llamaconfig ][ transformers.LlamaConfig","sections":[],"depth":2},{"title":"LlamaTokenizer","local":"llamatokenizer ][ transformers.LlamaTokenizer","sections":[],"depth":2},{"title":"LlamaTokenizerFast","local":"llamatokenizerfast ][ transformers.LlamaTokenizerFast","sections":[],"depth":2},{"title":"LlamaModel","local":"llamamodel ][ transformers.LlamaModel","sections":[],"depth":2},{"title":"LlamaForCausalLM","local":"llamaforcausallm ][ transformers.LlamaForCausalLM","sections":[],"depth":2},{"title":"LlamaForSequenceClassification","local":"llamaforsequenceclassification ][ transformers.LlamaForSequenceClassification","sections":[],"depth":2}],"depth":1}';function Sa(L){return $a(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ka extends xa{constructor(r){super(),Ca(this,r,Sa,Ra,La,{})}}export{Ka as component};
