import{s as me,n as fe,o as de}from"../chunks/scheduler.8a2cc2fa.js";import{S as be,i as ce,e as s,s as l,c as p,h as ye,a as o,d as n,b as a,f as pe,g as m,j as r,k as O,l as ue,m as i,n as f,t as d,o as b,p as c}from"../chunks/index.7079e750.js";import{C as ge,H as T,E as he}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.ac36d8ed.js";import{C as tt}from"../chunks/CodeBlock.90bbfb62.js";function Me(Ft){let y,it,et,lt,w,at,U,st,_,At="bitsandbytes is widely integrated with many of the libraries in the Hugging Face and wider PyTorch ecosystem. This guide provides a brief overview of the integrations and how to use bitsandbytes with them. For more details, you should refer to the linked documentation for each library.",ot,C,rt,u,Vt='<p>Learn more in the bitsandbytes Transformers integration <a href="https://huggingface.co/docs/transformers/quantization#bitsandbytes" rel="nofollow">guide</a>.</p>',pt,$,qt='With Transformers, it’s very easy to load any model in 4 or 8-bit and quantize them on the fly. To configure the quantization parameters, specify them in the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class.',mt,J,Yt="For example, to load and quantize a model to 4-bits and use the bfloat16 data type for compute:",ft,g,It='<p>bfloat16 is the ideal <code>compute_dtype</code> if your hardware supports it. While the default <code>compute_dtype</code>, float32, ensures backward compatibility (due to wide-ranging hardware support) and numerical stability, it is large and slows down computations. In contrast, float16 is smaller and faster but can lead to numerical instabilities. bfloat16 combines the best aspects of both; it offers the numerical stability of float32 and the reduced memory footprint and speed of a 16-bit data type. Check if your hardware supports bfloat16 and configure it using the <code>bnb_4bit_compute_dtype</code> parameter in <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a>!</p>',dt,v,bt,Z,ct,B,Nt='You can use any of the 8-bit or paged optimizers with Transformers by passing them to the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class on initialization. All bitsandbytes optimizers are supported by passing the correct string in the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a> <code>optim</code> parameter. For example, to load a <a href="/docs/bitsandbytes/main/en/reference/optim/adamw#bitsandbytes.optim.PagedAdamW32bit">PagedAdamW32bit</a> optimizer:',yt,j,ut,X,gt,h,Pt='<p>Learn more in the bitsandbytes PEFT integration <a href="https://huggingface.co/docs/peft/developer_guides/quantization#quantization" rel="nofollow">guide</a>.</p>',ht,k,St="PEFT builds on the bitsandbytes Transformers integration, and extends it for training with a few more steps. Let’s prepare the 4-bit model from the section above for training.",Mt,L,Dt="Call the <code>~peft.prepare_model_for_kbit_training</code> method to prepare the model for training. This only works for Transformers models!",Tt,z,wt,G,Kt="Setup a <code>~peft.LoraConfig</code> to use QLoRA:",Ut,W,_t,R,Ot="Now call the <code>~peft.get_peft_model</code> function on your model and config to create a trainable <code>PeftModel</code>.",Ct,x,$t,H,Jt,M,te='<p>Learn more in the bitsandbytes Accelerate integration <a href="https://huggingface.co/docs/accelerate/usage_guides/quantization" rel="nofollow">guide</a>.</p>',vt,Q,ee='bitsandbytes is also easily usable from Accelerate and you can quantize any PyTorch model by passing a <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.BnbQuantizationConfig" rel="nofollow">BnbQuantizationConfig</a> with your desired settings, and then calling the <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.load_and_quantize_model" rel="nofollow">load_and_quantize_model</a> function to quantize it.',Zt,E,Bt,F,jt,A,ne="bitsandbytes is available from:",Xt,V,ie='<li><a href="https://lightning.ai/docs/pytorch/stable/" rel="nofollow">PyTorch Lightning</a>, a deep learning framework for professional AI researchers and machine learning engineers who need maximal flexibility without sacrificing performance at scale.</li> <li><a href="https://lightning.ai/docs/fabric/stable/" rel="nofollow">Lightning Fabric</a>, a fast and lightweight way to scale PyTorch models without boilerplate.</li>',kt,q,le='Learn more in the bitsandbytes PyTorch Lightning integration <a href="https://lightning.ai/docs/pytorch/stable/common/precision_intermediate.html#quantization-via-bitsandbytes" rel="nofollow">guide</a>.',Lt,Y,zt,I,ae='bitsandbytes is integrated with <a href="https://github.com/Lightning-AI/lit-gpt" rel="nofollow">Lit-GPT</a>, a hackable implementation of state-of-the-art open-source large language models. Lit-GPT is based on Lightning Fabric, and it can be used for quantization during training, finetuning, and inference.',Gt,N,se='Learn more in the bitsandbytes Lit-GPT integration <a href="https://github.com/Lightning-AI/lit-gpt/blob/main/tutorials/quantize.md" rel="nofollow">guide</a>.',Wt,P,Rt,S,oe="To learn in more detail about some of bitsandbytes integrations, take a look at the following blog posts:",xt,D,re='<li><a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a></li> <li><a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">A Gentle Introduction to 8-bit Matrix Multiplication for transformers at scale using Hugging Face Transformers, Accelerate and bitsandbytes</a></li>',Ht,K,Qt,nt,Et;return w=new ge({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new T({props:{title:"Integrations",local:"integrations",headingTag:"h1"}}),C=new T({props:{title:"Transformers",local:"transformers",headingTag:"h2"}}),v=new tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQW1vZGVsXzRiaXQlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmlnc2NpZW5jZSUyRmJsb29tLTFiNyUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0RkZXZpY2VfbWFwJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16)
model_4bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>,
    device_map=device_map,
    quantization_config=quantization_config,
)`,wrap:!1}}),Z=new T({props:{title:"8-bit optimizers",local:"8-bit-optimizers",headingTag:"h3"}}),j=new tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjBvcHRpbSUzRCUyMnBhZ2VkX2FkYW13XzMyYml0JTIyJTJDJTBBKSUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTJDJTIwdHJhaW5pbmdfYXJncyUyQyUyMC4uLiklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

training_args = TrainingArguments(
    ...,
    optim=<span class="hljs-string">&quot;paged_adamw_32bit&quot;</span>,
)
trainer = Trainer(model, training_args, ...)
trainer.train()`,wrap:!1}}),X=new T({props:{title:"PEFT",local:"peft",headingTag:"h2"}}),z=new tt({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBJTBBbW9kZWxfNGJpdCUyMCUzRCUyMHByZXBhcmVfbW9kZWxfZm9yX2tiaXRfdHJhaW5pbmcobW9kZWxfNGJpdCk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_kbit_training

model_4bit = prepare_model_for_kbit_training(model_4bit)`,wrap:!1}}),W=new tt({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTIyYWxsLWxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMEElMjAlMjAlMjAlMjBiaWFzJTNEJTIybm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>,
    lora_dropout=<span class="hljs-number">0.05</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)`,wrap:!1}}),x=new tt({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWxfNGJpdCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model_4bit, config)`,wrap:!1}}),H=new T({props:{title:"Accelerate",local:"accelerate",headingTag:"h2"}}),E=new tt({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMEJuYlF1YW50aXphdGlvbkNvbmZpZyUyQyUyMGxvYWRfYW5kX3F1YW50aXplX21vZGVsJTBBZnJvbSUyMG1pbmdwdC5tb2RlbCUyMGltcG9ydCUyMEdQVCUwQSUwQW1vZGVsX2NvbmZpZyUyMCUzRCUyMEdQVC5nZXRfZGVmYXVsdF9jb25maWcoKSUwQW1vZGVsX2NvbmZpZy5tb2RlbF90eXBlJTIwJTNEJTIwJ2dwdDIteGwnJTBBbW9kZWxfY29uZmlnLnZvY2FiX3NpemUlMjAlM0QlMjA1MDI1NyUwQW1vZGVsX2NvbmZpZy5ibG9ja19zaXplJTIwJTNEJTIwMTAyNCUwQSUwQXdpdGglMjBpbml0X2VtcHR5X3dlaWdodHMoKSUzQSUwQSUyMCUyMCUyMCUyMGVtcHR5X21vZGVsJTIwJTNEJTIwR1BUKG1vZGVsX2NvbmZpZyklMEElMEFibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJuYlF1YW50aXphdGlvbkNvbmZpZyglMEElMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwJTIwJTIzJTIwb3B0aW9uYWwlMEElMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEVHJ1ZSUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMG9wdGlvbmFsJTBBJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMG9wdGlvbmFsJTBBKSUwQSUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMGxvYWRfYW5kX3F1YW50aXplX21vZGVsKCUwQSUyMCUyMGVtcHR5X21vZGVsJTJDJTBBJTIwJTIwd2VpZ2h0c19sb2NhdGlvbiUzRHdlaWdodHNfbG9jYXRpb24lMkMlMEElMjAlMjBibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUzRGJuYl9xdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwZGV2aWNlX21hcCUyMCUzRCUyMCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> BnbQuantizationConfig, load_and_quantize_model
<span class="hljs-keyword">from</span> mingpt.model <span class="hljs-keyword">import</span> GPT

model_config = GPT.get_default_config()
model_config.model_type = <span class="hljs-string">&#x27;gpt2-xl&#x27;</span>
model_config.vocab_size = <span class="hljs-number">50257</span>
model_config.block_size = <span class="hljs-number">1024</span>

<span class="hljs-keyword">with</span> init_empty_weights():
    empty_model = GPT(model_config)

bnb_quantization_config = BnbQuantizationConfig(
  load_in_4bit=<span class="hljs-literal">True</span>,
  bnb_4bit_compute_dtype=torch.bfloat16,  <span class="hljs-comment"># optional</span>
  bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,         <span class="hljs-comment"># optional</span>
  bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>               <span class="hljs-comment"># optional</span>
)

quantized_model = load_and_quantize_model(
  empty_model,
  weights_location=weights_location,
  bnb_quantization_config=bnb_quantization_config,
  device_map = <span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),F=new T({props:{title:"PyTorch Lightning and Lightning Fabric",local:"pytorch-lightning-and-lightning-fabric",headingTag:"h2"}}),Y=new T({props:{title:"Lit-GPT",local:"lit-gpt",headingTag:"h2"}}),P=new T({props:{title:"Blog posts",local:"blog-posts",headingTag:"h2"}}),K=new he({props:{source:"https://github.com/bitsandbytes-foundation/bitsandbytes/blob/main/docs/source/integrations.mdx"}}),{c(){y=s("meta"),it=l(),et=s("p"),lt=l(),p(w.$$.fragment),at=l(),p(U.$$.fragment),st=l(),_=s("p"),_.textContent=At,ot=l(),p(C.$$.fragment),rt=l(),u=s("blockquote"),u.innerHTML=Vt,pt=l(),$=s("p"),$.innerHTML=qt,mt=l(),J=s("p"),J.textContent=Yt,ft=l(),g=s("blockquote"),g.innerHTML=It,dt=l(),p(v.$$.fragment),bt=l(),p(Z.$$.fragment),ct=l(),B=s("p"),B.innerHTML=Nt,yt=l(),p(j.$$.fragment),ut=l(),p(X.$$.fragment),gt=l(),h=s("blockquote"),h.innerHTML=Pt,ht=l(),k=s("p"),k.textContent=St,Mt=l(),L=s("p"),L.innerHTML=Dt,Tt=l(),p(z.$$.fragment),wt=l(),G=s("p"),G.innerHTML=Kt,Ut=l(),p(W.$$.fragment),_t=l(),R=s("p"),R.innerHTML=Ot,Ct=l(),p(x.$$.fragment),$t=l(),p(H.$$.fragment),Jt=l(),M=s("blockquote"),M.innerHTML=te,vt=l(),Q=s("p"),Q.innerHTML=ee,Zt=l(),p(E.$$.fragment),Bt=l(),p(F.$$.fragment),jt=l(),A=s("p"),A.textContent=ne,Xt=l(),V=s("ul"),V.innerHTML=ie,kt=l(),q=s("p"),q.innerHTML=le,Lt=l(),p(Y.$$.fragment),zt=l(),I=s("p"),I.innerHTML=ae,Gt=l(),N=s("p"),N.innerHTML=se,Wt=l(),p(P.$$.fragment),Rt=l(),S=s("p"),S.textContent=oe,xt=l(),D=s("ul"),D.innerHTML=re,Ht=l(),p(K.$$.fragment),Qt=l(),nt=s("p"),this.h()},l(t){const e=ye("svelte-u9bgzb",document.head);y=o(e,"META",{name:!0,content:!0}),e.forEach(n),it=a(t),et=o(t,"P",{}),pe(et).forEach(n),lt=a(t),m(w.$$.fragment,t),at=a(t),m(U.$$.fragment,t),st=a(t),_=o(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-17oloa0"&&(_.textContent=At),ot=a(t),m(C.$$.fragment,t),rt=a(t),u=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(u)!=="svelte-1a8u5ay"&&(u.innerHTML=Vt),pt=a(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-t09m1v"&&($.innerHTML=qt),mt=a(t),J=o(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-fugr8i"&&(J.textContent=Yt),ft=a(t),g=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-1o6oue3"&&(g.innerHTML=It),dt=a(t),m(v.$$.fragment,t),bt=a(t),m(Z.$$.fragment,t),ct=a(t),B=o(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-rupil2"&&(B.innerHTML=Nt),yt=a(t),m(j.$$.fragment,t),ut=a(t),m(X.$$.fragment,t),gt=a(t),h=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-ts8pmq"&&(h.innerHTML=Pt),ht=a(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-945c4h"&&(k.textContent=St),Mt=a(t),L=o(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-16xvigi"&&(L.innerHTML=Dt),Tt=a(t),m(z.$$.fragment,t),wt=a(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-xc51cl"&&(G.innerHTML=Kt),Ut=a(t),m(W.$$.fragment,t),_t=a(t),R=o(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-x8ok68"&&(R.innerHTML=Ot),Ct=a(t),m(x.$$.fragment,t),$t=a(t),m(H.$$.fragment,t),Jt=a(t),M=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-ebimhp"&&(M.innerHTML=te),vt=a(t),Q=o(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-wlkf6t"&&(Q.innerHTML=ee),Zt=a(t),m(E.$$.fragment,t),Bt=a(t),m(F.$$.fragment,t),jt=a(t),A=o(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-zm0jix"&&(A.textContent=ne),Xt=a(t),V=o(t,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-c4dddp"&&(V.innerHTML=ie),kt=a(t),q=o(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-xrv468"&&(q.innerHTML=le),Lt=a(t),m(Y.$$.fragment,t),zt=a(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-jne5kj"&&(I.innerHTML=ae),Gt=a(t),N=o(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-144d081"&&(N.innerHTML=se),Wt=a(t),m(P.$$.fragment,t),Rt=a(t),S=o(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-hhb45g"&&(S.textContent=oe),xt=a(t),D=o(t,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-1opwyey"&&(D.innerHTML=re),Ht=a(t),m(K.$$.fragment,t),Qt=a(t),nt=o(t,"P",{}),pe(nt).forEach(n),this.h()},h(){O(y,"name","hf:doc:metadata"),O(y,"content",Te),O(u,"class","tip"),O(g,"class","warning"),O(h,"class","tip"),O(M,"class","tip")},m(t,e){ue(document.head,y),i(t,it,e),i(t,et,e),i(t,lt,e),f(w,t,e),i(t,at,e),f(U,t,e),i(t,st,e),i(t,_,e),i(t,ot,e),f(C,t,e),i(t,rt,e),i(t,u,e),i(t,pt,e),i(t,$,e),i(t,mt,e),i(t,J,e),i(t,ft,e),i(t,g,e),i(t,dt,e),f(v,t,e),i(t,bt,e),f(Z,t,e),i(t,ct,e),i(t,B,e),i(t,yt,e),f(j,t,e),i(t,ut,e),f(X,t,e),i(t,gt,e),i(t,h,e),i(t,ht,e),i(t,k,e),i(t,Mt,e),i(t,L,e),i(t,Tt,e),f(z,t,e),i(t,wt,e),i(t,G,e),i(t,Ut,e),f(W,t,e),i(t,_t,e),i(t,R,e),i(t,Ct,e),f(x,t,e),i(t,$t,e),f(H,t,e),i(t,Jt,e),i(t,M,e),i(t,vt,e),i(t,Q,e),i(t,Zt,e),f(E,t,e),i(t,Bt,e),f(F,t,e),i(t,jt,e),i(t,A,e),i(t,Xt,e),i(t,V,e),i(t,kt,e),i(t,q,e),i(t,Lt,e),f(Y,t,e),i(t,zt,e),i(t,I,e),i(t,Gt,e),i(t,N,e),i(t,Wt,e),f(P,t,e),i(t,Rt,e),i(t,S,e),i(t,xt,e),i(t,D,e),i(t,Ht,e),f(K,t,e),i(t,Qt,e),i(t,nt,e),Et=!0},p:fe,i(t){Et||(d(w.$$.fragment,t),d(U.$$.fragment,t),d(C.$$.fragment,t),d(v.$$.fragment,t),d(Z.$$.fragment,t),d(j.$$.fragment,t),d(X.$$.fragment,t),d(z.$$.fragment,t),d(W.$$.fragment,t),d(x.$$.fragment,t),d(H.$$.fragment,t),d(E.$$.fragment,t),d(F.$$.fragment,t),d(Y.$$.fragment,t),d(P.$$.fragment,t),d(K.$$.fragment,t),Et=!0)},o(t){b(w.$$.fragment,t),b(U.$$.fragment,t),b(C.$$.fragment,t),b(v.$$.fragment,t),b(Z.$$.fragment,t),b(j.$$.fragment,t),b(X.$$.fragment,t),b(z.$$.fragment,t),b(W.$$.fragment,t),b(x.$$.fragment,t),b(H.$$.fragment,t),b(E.$$.fragment,t),b(F.$$.fragment,t),b(Y.$$.fragment,t),b(P.$$.fragment,t),b(K.$$.fragment,t),Et=!1},d(t){t&&(n(it),n(et),n(lt),n(at),n(st),n(_),n(ot),n(rt),n(u),n(pt),n($),n(mt),n(J),n(ft),n(g),n(dt),n(bt),n(ct),n(B),n(yt),n(ut),n(gt),n(h),n(ht),n(k),n(Mt),n(L),n(Tt),n(wt),n(G),n(Ut),n(_t),n(R),n(Ct),n($t),n(Jt),n(M),n(vt),n(Q),n(Zt),n(Bt),n(jt),n(A),n(Xt),n(V),n(kt),n(q),n(Lt),n(zt),n(I),n(Gt),n(N),n(Wt),n(Rt),n(S),n(xt),n(D),n(Ht),n(Qt),n(nt)),n(y),c(w,t),c(U,t),c(C,t),c(v,t),c(Z,t),c(j,t),c(X,t),c(z,t),c(W,t),c(x,t),c(H,t),c(E,t),c(F,t),c(Y,t),c(P,t),c(K,t)}}}const Te='{"title":"Integrations","local":"integrations","sections":[{"title":"Transformers","local":"transformers","sections":[{"title":"8-bit optimizers","local":"8-bit-optimizers","sections":[],"depth":3}],"depth":2},{"title":"PEFT","local":"peft","sections":[],"depth":2},{"title":"Accelerate","local":"accelerate","sections":[],"depth":2},{"title":"PyTorch Lightning and Lightning Fabric","local":"pytorch-lightning-and-lightning-fabric","sections":[],"depth":2},{"title":"Lit-GPT","local":"lit-gpt","sections":[],"depth":2},{"title":"Blog posts","local":"blog-posts","sections":[],"depth":2}],"depth":1}';function we(Ft){return de(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Je extends be{constructor(y){super(),ce(this,y,we,Me,me,{})}}export{Je as component};
