import{s as Yt,o as Vt,n as it}from"../chunks/scheduler.defa9a21.js";import{S as Bt,i as zt,g as f,s as c,r as h,m as At,A as xt,h as u,f as a,c as n,j as Wt,u as y,x as b,n as Xt,k as Rt,y as Ft,a as l,v as M,d as w,t as $,w as g}from"../chunks/index.fe795e71.js";import{T as st}from"../chunks/Tip.179eb360.js";import{C as k}from"../chunks/CodeBlock.42404125.js";import{H as C,E as Nt}from"../chunks/EditOnGithub.0f575778.js";import{H as Qt,a as Ht}from"../chunks/HfOption.3c290b0f.js";function St(j){let r,T="Accelerate only prepares objects that inherit from their respective PyTorch classes such as <code>torch.optim.Optimizer</code>.";return{c(){r=f("p"),r.innerHTML=T},l(i){r=u(i,"P",{"data-svelte-h":!0}),b(r)!=="svelte-1oh2ah6"&&(r.innerHTML=T)},m(i,m){l(i,r,m)},p:it,d(i){i&&a(r)}}}function Lt(j){let r,T='Accelerate enables automatic mixed precision, so <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.autocast">autocast()</a> is only needed if there are other mixed precision operations besides those performed on loss by <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a> which already handles the scaling.';return{c(){r=f("p"),r.innerHTML=T},l(i){r=u(i,"P",{"data-svelte-h":!0}),b(r)!=="svelte-17p4of7"&&(r.innerHTML=T)},m(i,m){l(i,r,m)},p:it,d(i){i&&a(r)}}}function Pt(j){let r,T='For models from the <a href="https://hf.co/docs/transformers/index" rel="nofollow">Transformers</a> library, save the model with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained" rel="nofollow">save_pretrained</a> method so that it can be reloaded with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained" rel="nofollow">from_pretrained</a> method.',i,m,o;return m=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQXVud3JhcHBlZF9tb2RlbCUyMCUzRCUyMGFjY2VsZXJhdG9yLnVud3JhcF9tb2RlbChtb2RlbCklMEF1bndyYXBwZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnBhdGglMkZ0byUyRm15X21vZGVsX2RpcmVjdG9yeSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlzX21haW5fcHJvY2VzcyUzRGFjY2VsZXJhdG9yLmlzX21haW5fcHJvY2VzcyUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfZnVuY3Rpb24lM0RhY2NlbGVyYXRvci5zYXZlJTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZteV9tb2RlbF9kaXJlY3RvcnklMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

unwrapped_model = accelerator.unwrap_model(model)
unwrapped_model.save_pretrained(
    <span class="hljs-string">&quot;path/to/my_model_directory&quot;</span>,
    is_main_process=accelerator.is_main_process,
    save_function=accelerator.save,
)

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;path/to/my_model_directory&quot;</span>)`,wrap:!1}}),{c(){r=f("p"),r.innerHTML=T,i=c(),h(m.$$.fragment)},l(d){r=u(d,"P",{"data-svelte-h":!0}),b(r)!=="svelte-y3y63b"&&(r.innerHTML=T),i=n(d),y(m.$$.fragment,d)},m(d,_){l(d,r,_),l(d,i,_),M(m,d,_),o=!0},p:it,i(d){o||(w(m.$$.fragment,d),o=!0)},o(d){$(m.$$.fragment,d),o=!1},d(d){d&&(a(r),a(i)),g(m,d)}}}function Et(j){let r,T,i,m,o,d='To load your weights, use the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.unwrap_model">unwrap_model()</a> method to unwrap the model first before loading the weights. All model parameters are references to tensors, so this loads your weights inside <code>model</code>.',_,U,v;return r=new k({props:{code:"YWNjZWxlcmF0b3Iud2FpdF9mb3JfZXZlcnlvbmUoKSUwQWFjY2VsZXJhdG9yLnNhdmVfbW9kZWwobW9kZWwlMkMlMjBzYXZlX2RpcmVjdG9yeSk=",highlighted:`accelerator.wait_for_everyone()
accelerator.save_model(model, save_directory)`,wrap:!1}}),i=new st({props:{$$slots:{default:[Pt]},$$scope:{ctx:j}}}),U=new k({props:{code:"dW53cmFwcGVkX21vZGVsJTIwJTNEJTIwYWNjZWxlcmF0b3IudW53cmFwX21vZGVsKG1vZGVsKSUwQXBhdGhfdG9fY2hlY2twb2ludCUyMCUzRCUyMG9zLnBhdGguam9pbihzYXZlX2RpcmVjdG9yeSUyQyUyMnB5dG9yY2hfbW9kZWwuYmluJTIyKSUwQXVud3JhcHBlZF9tb2RlbC5sb2FkX3N0YXRlX2RpY3QodG9yY2gubG9hZChwYXRoX3RvX2NoZWNrcG9pbnQpKQ==",highlighted:`unwrapped_model = accelerator.unwrap_model(model)
path_to_checkpoint = os.path.join(save_directory,<span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)
unwrapped_model.load_state_dict(torch.load(path_to_checkpoint))`,wrap:!1}}),{c(){h(r.$$.fragment),T=c(),h(i.$$.fragment),m=c(),o=f("p"),o.innerHTML=d,_=c(),h(U.$$.fragment)},l(s){y(r.$$.fragment,s),T=n(s),y(i.$$.fragment,s),m=n(s),o=u(s,"P",{"data-svelte-h":!0}),b(o)!=="svelte-js2qkb"&&(o.innerHTML=d),_=n(s),y(U.$$.fragment,s)},m(s,p){M(r,s,p),l(s,T,p),M(i,s,p),l(s,m,p),l(s,o,p),l(s,_,p),M(U,s,p),v=!0},p(s,p){const J={};p&2&&(J.$$scope={dirty:p,ctx:s}),i.$set(J)},i(s){v||(w(r.$$.fragment,s),w(i.$$.fragment,s),w(U.$$.fragment,s),v=!0)},o(s){$(r.$$.fragment,s),$(i.$$.fragment,s),$(U.$$.fragment,s),v=!1},d(s){s&&(a(T),a(m),a(o),a(_)),g(r,s),g(i,s),g(U,s)}}}function Kt(j){let r,T="Set <code>safe_serialization=True</code> to save the model in the safetensor format.",i,m,o,d,_='To load a sharded checkpoint or a safetensor formatted checkpoint, use the <a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.load_checkpoint_in_model">load_checkpoint_in_model()</a> method. This method allows you to load a checkpoint onto a specific device.',U,v,s;return m=new k({props:{code:"YWNjZWxlcmF0b3Iud2FpdF9mb3JfZXZlcnlvbmUoKSUwQWFjY2VsZXJhdG9yLnNhdmVfbW9kZWwobW9kZWwlMkMlMjBzYXZlX2RpcmVjdG9yeSUyQyUyMG1heF9zaGFyZF9zaXplJTNEJTIyMUdCJTIyJTJDJTIwc2FmZV9zZXJpYWxpemF0aW9uJTNEVHJ1ZSk=",highlighted:`accelerator.wait_for_everyone()
accelerator.save_model(model, save_directory, max_shard_size=<span class="hljs-string">&quot;1GB&quot;</span>, safe_serialization=<span class="hljs-literal">True</span>)`,wrap:!1}}),v=new k({props:{code:"bG9hZF9jaGVja3BvaW50X2luX21vZGVsKHVud3JhcHBlZF9tb2RlbCUyQyUyMHNhdmVfZGlyZWN0b3J5JTJDJTIwZGV2aWNlX21hcCUzRCU3QiUyMiUyMiUzQWRldmljZSU3RCk=",highlighted:'load_checkpoint_in_model(unwrapped_model, save_directory, device_map={<span class="hljs-string">&quot;&quot;</span>:device})',wrap:!1}}),{c(){r=f("p"),r.innerHTML=T,i=c(),h(m.$$.fragment),o=c(),d=f("p"),d.innerHTML=_,U=c(),h(v.$$.fragment)},l(p){r=u(p,"P",{"data-svelte-h":!0}),b(r)!=="svelte-jahj75"&&(r.innerHTML=T),i=n(p),y(m.$$.fragment,p),o=n(p),d=u(p,"P",{"data-svelte-h":!0}),b(d)!=="svelte-1f8c9zt"&&(d.innerHTML=_),U=n(p),y(v.$$.fragment,p)},m(p,J){l(p,r,J),l(p,i,J),M(m,p,J),l(p,o,J),l(p,d,J),l(p,U,J),M(v,p,J),s=!0},p:it,i(p){s||(w(m.$$.fragment,p),w(v.$$.fragment,p),s=!0)},o(p){$(m.$$.fragment,p),$(v.$$.fragment,p),s=!1},d(p){p&&(a(r),a(i),a(o),a(d),a(U)),g(m,p),g(v,p)}}}function qt(j){let r,T,i,m;return r=new Ht({props:{id:"save",option:"single checkpoint",$$slots:{default:[Et]},$$scope:{ctx:j}}}),i=new Ht({props:{id:"save",option:"sharded checkpoint",$$slots:{default:[Kt]},$$scope:{ctx:j}}}),{c(){h(r.$$.fragment),T=c(),h(i.$$.fragment)},l(o){y(r.$$.fragment,o),T=n(o),y(i.$$.fragment,o)},m(o,d){M(r,o,d),l(o,T,d),M(i,o,d),m=!0},p(o,d){const _={};d&2&&(_.$$scope={dirty:d,ctx:o}),r.$set(_);const U={};d&2&&(U.$$scope={dirty:d,ctx:o}),i.$set(U)},i(o){m||(w(r.$$.fragment,o),w(i.$$.fragment,o),m=!0)},o(o){$(r.$$.fragment,o),$(i.$$.fragment,o),m=!1},d(o){o&&a(T),g(r,o),g(i,o)}}}function Dt(j){let r,T,i,m,o,d,_,U="Each distributed training framework has their own way of doing things which can require writing a lot of custom code to adapt it to your PyTorch training code and training environment. Accelerate offers a friendly way to interface with these distributed training frameworks without having to learn the specific details of each one. Accelerate takes care of those details for you, so you can focus on the training code and scale it to any distributed training environment.",v,s,p="In this tutorial, you’ll learn how to adapt your existing PyTorch code with Accelerate and get you on your way toward training on distributed systems with ease! You’ll start with a basic PyTorch training loop (it assumes all the training objects like <code>model</code> and <code>optimizer</code> have been setup already) and progressively integrate Accelerate into it.",J,A,$e,W,ge,X,dt='The <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> is the main class for adapting your code to work with Accelerate. It knows about the distributed setup you’re using such as the number of different processes and your hardware type. This class also provides access to many of the necessary methods for enabling your PyTorch code to work in any distributed training environment and for managing and executing processes across devices.',be,R,pt='That’s why you should always start by importing and creating an <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> instance in your script.',Te,H,_e,Y,mt='The <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> also knows which device to move your PyTorch objects to, so it is recommended to let Accelerate handle this for you.',Ue,V,ve,B,Je,z,ft='Next, you need to prepare your PyTorch objects (model, optimizer, scheduler, etc.) for distributed training. The <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method takes care of placing your model in the appropriate container (like single GPU or multi-GPU) for your training setup, adapting the optimizer and scheduler to use Accelerate’s <a href="/docs/accelerate/main/en/package_reference/torch_wrappers#accelerate.optimizer.AcceleratedOptimizer">AcceleratedOptimizer</a> and <a href="/docs/accelerate/main/en/package_reference/torch_wrappers#accelerate.scheduler.AcceleratedScheduler">AcceleratedScheduler</a>, and creating a new dataloader that can be sharded across processes.',je,G,ke,x,ut="The PyTorch objects are returned in the same order they’re sent.",Ce,F,Ge,N,Ze,Q,ht='Finally, remove the <code>to(device)</code> calls to the inputs and targets in the training loop because Accelerate’s DataLoader classes automatically places them on the right device. You should also replace the usual <code>backward()</code> pass with Accelerate’s <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a> method which scales the gradients for you and uses the appropriate <code>backward()</code> method depending on your distributed setup (for example, DeepSpeed or Megatron).',Ie,S,Ae,L,yt="Put everything together and your new Accelerate training loop should now look like this!",We,P,Xe,E,Re,K,Mt="Accelerate offers additional features - like gradient accumulation, gradient clipping, mixed precision training and more - you can add to your script to improve your training run. Let’s explore these three features.",He,q,Ye,D,wt='Gradient accumulation enables you to train on larger batch sizes by accumulating the gradients over multiple batches before updating the weights. This can be useful for getting around memory limitations. To enable this feature in Accelerate, specify the <code>gradient_accumulation_steps</code> parameter in the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> class and add the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> context manager to your script.',Ve,O,Be,ee,ze,te,$t="Gradient clipping is a technique to prevent “exploding gradients”, and Accelerate offers:",xe,ae,gt='<li><a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.clip_grad_value_">clip<em>grad_value</em>()</a> to clip gradients to a minimum and maximum value</li> <li><a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.clip_grad_norm_">clip<em>grad_norm</em>()</a> for normalizing gradients to a certain value</li>',Fe,le,Ne,re,bt="Mixed precision accelerates training by using a lower precision data type like fp16 (half-precision) to calculate the gradients. For the best performance with Accelerate, the loss should be computed inside your model (like in Transformers models) because computations outside of the model are computed in full precision.",Qe,ce,Tt='Set the mixed precision type to use in the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>, and then use the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.autocast">autocast()</a> context manager to automatically cast the values to the specified data type.',Se,Z,Le,ne,Pe,oe,Ee,ie,_t="Accelerate can also save and load a <em>model</em> once training is complete or you can also save the model and optimizer <em>state</em> which could be useful for resuming training.",Ke,se,qe,de,Ut='Once all processes are complete, unwrap the model with the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.unwrap_model">unwrap_model()</a> method before saving it because the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method wrapped your model into the proper interface for distributed training. If you don’t unwrap the model, saving the model state dictionary also saves any potential extra layers from the larger model and you won’t be able to load the weights back into your base model.',De,pe,vt='You should use the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_model">save_model()</a> method to unwrap and save the model state dictionary. This method can also save a model into sharded checkpoints or into the <a href="https://hf.co/docs/safetensors/index" rel="nofollow">safetensors</a> format.',Oe,I,et,me,tt,fe,Jt='During training, you may want to save the current state of the model, optimizer, random generators, and potentially learning rate schedulers so they can be restored in the <em>same script</em>. You should add the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_state">save_state()</a> and <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.load_state">load_state()</a> methods to your script to save and load states.',at,ue,jt='To further customize where and how states are saved through <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_state">save_state()</a>, use the <a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.ProjectConfiguration">ProjectConfiguration</a> class. For example, if <code>automatic_checkpoint_naming</code> is enabled, each saved checkpoint is stored at <code>Accelerator.project_dir/checkpoints/checkpoint_{checkpoint_number}</code>.',lt,he,kt='Any other stateful items to be stored should be registered with the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.register_for_checkpointing">register_for_checkpointing()</a> method so they can be saved and loaded. Every object passed to this method to be stored must have a <code>load_state_dict</code> and <code>state_dict</code> function.',rt,ye,Ct='If you have <a href="https://github.com/pytorch/data/tree/main" rel="nofollow"><code>torchdata&gt;=0.8.0</code></a> installed, you can additionally pass <code>use_stateful_dataloader=True</code> into your <a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.DataLoaderConfiguration">DataLoaderConfiguration</a>. This extends Accelerate’s DataLoader classes with a <code>load_state_dict</code> and <code>state_dict</code> function, and makes it so <code>Accelerator.save_state</code> and <code>Accelerator.load_state</code> also track how far into the training dataset it has read when persisting the model.',ct,Me,nt,we,ot;return o=new C({props:{title:"Add Accelerate to your code",local:"add-accelerate-to-your-code",headingTag:"h1"}}),A=new k({props:{code:"ZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsLnRvKGRldmljZSklMEElMEFmb3IlMjBiYXRjaCUyMGluJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwdGFyZ2V0cyUyMCUzRCUyMHRhcmdldHMudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGxvc3NfZnVuY3Rpb24ob3V0cHV0cyUyQyUyMHRhcmdldHMpJTBBJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlci5zdGVwKCk=",highlighted:`device = <span class="hljs-string">&quot;cuda&quot;</span>
model.to(device)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
    optimizer.zero_grad()
    inputs, targets = batch
    inputs = inputs.to(device)
    targets = targets.to(device)
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    loss.backward()
    optimizer.step()
    scheduler.step()`,wrap:!1}}),W=new C({props:{title:"Accelerator",local:"accelerator",headingTag:"h2"}}),H=new k({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()`,wrap:!1}}),V=new k({props:{code:"LSUyMGRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEElMkIlMjBkZXZpY2UlMjAlM0QlMjBhY2NlbGVyYXRvci5kZXZpY2UlMEElMjAlMjBtb2RlbC50byhkZXZpY2Up",highlighted:`<span class="hljs-deletion">- device = &quot;cuda&quot;</span>
<span class="hljs-addition">+ device = accelerator.device</span>
  model.to(device)`,wrap:!1}}),B=new C({props:{title:"Prepare PyTorch objects",local:"prepare-pytorch-objects",headingTag:"h2"}}),G=new st({props:{warning:!1,$$slots:{default:[St]},$$scope:{ctx:j}}}),F=new k({props:{code:"bW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluaW5nX2RhdGFsb2FkZXIlMkMlMjBzY2hlZHVsZXIlMEEp",highlighted:`model, optimizer, training_dataloader, scheduler = accelerator.prepare(
    model, optimizer, training_dataloader, scheduler
)`,wrap:!1}}),N=new C({props:{title:"Training loop",local:"training-loop",headingTag:"h2"}}),S=new k({props:{code:"LSUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy50byhkZXZpY2UpJTBBLSUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjB0YXJnZXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmN0aW9uKG91dHB1dHMlMkMlMjB0YXJnZXRzKSUwQS0lMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMkIlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKQ==",highlighted:`<span class="hljs-deletion">-   inputs = inputs.to(device)</span>
<span class="hljs-deletion">-   targets = targets.to(device)</span>
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
<span class="hljs-deletion">-   loss.backward()</span>
<span class="hljs-addition">+   accelerator.backward(loss)</span>`,wrap:!1}}),P=new k({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQWRldmljZSUyMCUzRCUyMGFjY2VsZXJhdG9yLmRldmljZSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTBBKSUwQSUwQWZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbmluZ19kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCklMEElMjAlMjAlMjAlMjBzY2hlZHVsZXIuc3RlcCgp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
accelerator = Accelerator()

device = accelerator.device
model, optimizer, training_dataloader, scheduler = accelerator.prepare(
    model, optimizer, training_dataloader, scheduler
)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
    optimizer.zero_grad()
    inputs, targets = batch
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    accelerator.backward(loss)
    optimizer.step()
    scheduler.step()`,wrap:!1}}),E=new C({props:{title:"Training features",local:"training-features",headingTag:"h2"}}),q=new C({props:{title:"Gradient accumulation",local:"gradient-accumulation",headingTag:"h3"}}),O=new k({props:{code:"JTJCJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0QyKSUwQSUyMCUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyKSUwQSUwQSUyMCUyMGZvciUyMGlucHV0JTJDJTIwbGFiZWwlMjBpbiUyMHRyYWluaW5nX2RhdGFsb2FkZXIlM0ElMEElMkIlMjAlMjAlMjAlMjAlMjB3aXRoJTIwYWNjZWxlcmF0b3IuYWNjdW11bGF0ZShtb2RlbCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMG1vZGVsKGlucHV0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmN0aW9uKHByZWRpY3Rpb25zJTJDJTIwbGFiZWwpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-addition">+ accelerator = Accelerator(gradient_accumulation_steps=2)</span>
  model, optimizer, training_dataloader = accelerator.prepare(model, optimizer, training_dataloader)

  for input, label in training_dataloader:
<span class="hljs-addition">+     with accelerator.accumulate(model):</span>
          predictions = model(input)
          loss = loss_function(predictions, label)
          accelerator.backward(loss)
          optimizer.step()
          scheduler.step()
          optimizer.zero_grad()`,wrap:!1}}),ee=new C({props:{title:"Gradient clipping",local:"gradient-clipping",headingTag:"h3"}}),le=new C({props:{title:"Mixed precision",local:"mixed-precision",headingTag:"h3"}}),Z=new st({props:{warning:!0,$$slots:{default:[Lt]},$$scope:{ctx:j}}}),ne=new k({props:{code:"JTJCJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihtaXhlZF9wcmVjaXNpb24lM0QlMjJmcDE2JTIyKSUwQSUyQiUyMHdpdGglMjBhY2NlbGVyYXRvci5hdXRvY2FzdCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGNvbXBsZXhfbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0KSUzQQ==",highlighted:`<span class="hljs-addition">+ accelerator = Accelerator(mixed_precision=&quot;fp16&quot;)</span>
<span class="hljs-addition">+ with accelerator.autocast():</span>
      loss = complex_loss_function(outputs, target):`,wrap:!1}}),oe=new C({props:{title:"Save and load",local:"save-and-load",headingTag:"h2"}}),se=new C({props:{title:"Model",local:"model",headingTag:"h3"}}),I=new Qt({props:{id:"save",options:["single checkpoint","sharded checkpoint"],$$slots:{default:[qt]},$$scope:{ctx:j}}}),me=new C({props:{title:"State",local:"state",headingTag:"h3"}}),Me=new Nt({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/basic_tutorials/migration.md"}}),{c(){r=f("meta"),T=c(),i=f("p"),m=c(),h(o.$$.fragment),d=c(),_=f("p"),_.textContent=U,v=c(),s=f("p"),s.innerHTML=p,J=c(),h(A.$$.fragment),$e=c(),h(W.$$.fragment),ge=c(),X=f("p"),X.innerHTML=dt,be=c(),R=f("p"),R.innerHTML=pt,Te=c(),h(H.$$.fragment),_e=c(),Y=f("p"),Y.innerHTML=mt,Ue=c(),h(V.$$.fragment),ve=c(),h(B.$$.fragment),Je=c(),z=f("p"),z.innerHTML=ft,je=c(),h(G.$$.fragment),ke=c(),x=f("p"),x.textContent=ut,Ce=c(),h(F.$$.fragment),Ge=c(),h(N.$$.fragment),Ze=c(),Q=f("p"),Q.innerHTML=ht,Ie=c(),h(S.$$.fragment),Ae=c(),L=f("p"),L.textContent=yt,We=c(),h(P.$$.fragment),Xe=c(),h(E.$$.fragment),Re=c(),K=f("p"),K.textContent=Mt,He=c(),h(q.$$.fragment),Ye=c(),D=f("p"),D.innerHTML=wt,Ve=c(),h(O.$$.fragment),Be=c(),h(ee.$$.fragment),ze=c(),te=f("p"),te.textContent=$t,xe=c(),ae=f("ul"),ae.innerHTML=gt,Fe=c(),h(le.$$.fragment),Ne=c(),re=f("p"),re.textContent=bt,Qe=c(),ce=f("p"),ce.innerHTML=Tt,Se=c(),h(Z.$$.fragment),Le=c(),h(ne.$$.fragment),Pe=c(),h(oe.$$.fragment),Ee=c(),ie=f("p"),ie.innerHTML=_t,Ke=c(),h(se.$$.fragment),qe=c(),de=f("p"),de.innerHTML=Ut,De=c(),pe=f("p"),pe.innerHTML=vt,Oe=c(),h(I.$$.fragment),et=c(),h(me.$$.fragment),tt=c(),fe=f("p"),fe.innerHTML=Jt,at=c(),ue=f("p"),ue.innerHTML=jt,lt=c(),he=f("p"),he.innerHTML=kt,rt=At(`
<Note>
`),ye=f("p"),ye.innerHTML=Ct,ct=At(`
</Note>
`),h(Me.$$.fragment),nt=c(),we=f("p"),this.h()},l(e){const t=xt("svelte-u9bgzb",document.head);r=u(t,"META",{name:!0,content:!0}),t.forEach(a),T=n(e),i=u(e,"P",{}),Wt(i).forEach(a),m=n(e),y(o.$$.fragment,e),d=n(e),_=u(e,"P",{"data-svelte-h":!0}),b(_)!=="svelte-19zbp5z"&&(_.textContent=U),v=n(e),s=u(e,"P",{"data-svelte-h":!0}),b(s)!=="svelte-1lmjen8"&&(s.innerHTML=p),J=n(e),y(A.$$.fragment,e),$e=n(e),y(W.$$.fragment,e),ge=n(e),X=u(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-1dn1lk2"&&(X.innerHTML=dt),be=n(e),R=u(e,"P",{"data-svelte-h":!0}),b(R)!=="svelte-zcqlut"&&(R.innerHTML=pt),Te=n(e),y(H.$$.fragment,e),_e=n(e),Y=u(e,"P",{"data-svelte-h":!0}),b(Y)!=="svelte-1csx4md"&&(Y.innerHTML=mt),Ue=n(e),y(V.$$.fragment,e),ve=n(e),y(B.$$.fragment,e),Je=n(e),z=u(e,"P",{"data-svelte-h":!0}),b(z)!=="svelte-wqk9uz"&&(z.innerHTML=ft),je=n(e),y(G.$$.fragment,e),ke=n(e),x=u(e,"P",{"data-svelte-h":!0}),b(x)!=="svelte-l5v2wx"&&(x.textContent=ut),Ce=n(e),y(F.$$.fragment,e),Ge=n(e),y(N.$$.fragment,e),Ze=n(e),Q=u(e,"P",{"data-svelte-h":!0}),b(Q)!=="svelte-i5xqdp"&&(Q.innerHTML=ht),Ie=n(e),y(S.$$.fragment,e),Ae=n(e),L=u(e,"P",{"data-svelte-h":!0}),b(L)!=="svelte-1b6tm11"&&(L.textContent=yt),We=n(e),y(P.$$.fragment,e),Xe=n(e),y(E.$$.fragment,e),Re=n(e),K=u(e,"P",{"data-svelte-h":!0}),b(K)!=="svelte-1ef6475"&&(K.textContent=Mt),He=n(e),y(q.$$.fragment,e),Ye=n(e),D=u(e,"P",{"data-svelte-h":!0}),b(D)!=="svelte-1nruvdz"&&(D.innerHTML=wt),Ve=n(e),y(O.$$.fragment,e),Be=n(e),y(ee.$$.fragment,e),ze=n(e),te=u(e,"P",{"data-svelte-h":!0}),b(te)!=="svelte-bg95gl"&&(te.textContent=$t),xe=n(e),ae=u(e,"UL",{"data-svelte-h":!0}),b(ae)!=="svelte-3kii7l"&&(ae.innerHTML=gt),Fe=n(e),y(le.$$.fragment,e),Ne=n(e),re=u(e,"P",{"data-svelte-h":!0}),b(re)!=="svelte-81s14c"&&(re.textContent=bt),Qe=n(e),ce=u(e,"P",{"data-svelte-h":!0}),b(ce)!=="svelte-mmotdg"&&(ce.innerHTML=Tt),Se=n(e),y(Z.$$.fragment,e),Le=n(e),y(ne.$$.fragment,e),Pe=n(e),y(oe.$$.fragment,e),Ee=n(e),ie=u(e,"P",{"data-svelte-h":!0}),b(ie)!=="svelte-dqdivd"&&(ie.innerHTML=_t),Ke=n(e),y(se.$$.fragment,e),qe=n(e),de=u(e,"P",{"data-svelte-h":!0}),b(de)!=="svelte-nvfiz9"&&(de.innerHTML=Ut),De=n(e),pe=u(e,"P",{"data-svelte-h":!0}),b(pe)!=="svelte-56aoja"&&(pe.innerHTML=vt),Oe=n(e),y(I.$$.fragment,e),et=n(e),y(me.$$.fragment,e),tt=n(e),fe=u(e,"P",{"data-svelte-h":!0}),b(fe)!=="svelte-qzsquh"&&(fe.innerHTML=Jt),at=n(e),ue=u(e,"P",{"data-svelte-h":!0}),b(ue)!=="svelte-cf1uwy"&&(ue.innerHTML=jt),lt=n(e),he=u(e,"P",{"data-svelte-h":!0}),b(he)!=="svelte-uuw2iq"&&(he.innerHTML=kt),rt=Xt(e,`
<Note>
`),ye=u(e,"P",{"data-svelte-h":!0}),b(ye)!=="svelte-4oj7mo"&&(ye.innerHTML=Ct),ct=Xt(e,`
</Note>
`),y(Me.$$.fragment,e),nt=n(e),we=u(e,"P",{}),Wt(we).forEach(a),this.h()},h(){Rt(r,"name","hf:doc:metadata"),Rt(r,"content",Ot)},m(e,t){Ft(document.head,r),l(e,T,t),l(e,i,t),l(e,m,t),M(o,e,t),l(e,d,t),l(e,_,t),l(e,v,t),l(e,s,t),l(e,J,t),M(A,e,t),l(e,$e,t),M(W,e,t),l(e,ge,t),l(e,X,t),l(e,be,t),l(e,R,t),l(e,Te,t),M(H,e,t),l(e,_e,t),l(e,Y,t),l(e,Ue,t),M(V,e,t),l(e,ve,t),M(B,e,t),l(e,Je,t),l(e,z,t),l(e,je,t),M(G,e,t),l(e,ke,t),l(e,x,t),l(e,Ce,t),M(F,e,t),l(e,Ge,t),M(N,e,t),l(e,Ze,t),l(e,Q,t),l(e,Ie,t),M(S,e,t),l(e,Ae,t),l(e,L,t),l(e,We,t),M(P,e,t),l(e,Xe,t),M(E,e,t),l(e,Re,t),l(e,K,t),l(e,He,t),M(q,e,t),l(e,Ye,t),l(e,D,t),l(e,Ve,t),M(O,e,t),l(e,Be,t),M(ee,e,t),l(e,ze,t),l(e,te,t),l(e,xe,t),l(e,ae,t),l(e,Fe,t),M(le,e,t),l(e,Ne,t),l(e,re,t),l(e,Qe,t),l(e,ce,t),l(e,Se,t),M(Z,e,t),l(e,Le,t),M(ne,e,t),l(e,Pe,t),M(oe,e,t),l(e,Ee,t),l(e,ie,t),l(e,Ke,t),M(se,e,t),l(e,qe,t),l(e,de,t),l(e,De,t),l(e,pe,t),l(e,Oe,t),M(I,e,t),l(e,et,t),M(me,e,t),l(e,tt,t),l(e,fe,t),l(e,at,t),l(e,ue,t),l(e,lt,t),l(e,he,t),l(e,rt,t),l(e,ye,t),l(e,ct,t),M(Me,e,t),l(e,nt,t),l(e,we,t),ot=!0},p(e,[t]){const Gt={};t&2&&(Gt.$$scope={dirty:t,ctx:e}),G.$set(Gt);const Zt={};t&2&&(Zt.$$scope={dirty:t,ctx:e}),Z.$set(Zt);const It={};t&2&&(It.$$scope={dirty:t,ctx:e}),I.$set(It)},i(e){ot||(w(o.$$.fragment,e),w(A.$$.fragment,e),w(W.$$.fragment,e),w(H.$$.fragment,e),w(V.$$.fragment,e),w(B.$$.fragment,e),w(G.$$.fragment,e),w(F.$$.fragment,e),w(N.$$.fragment,e),w(S.$$.fragment,e),w(P.$$.fragment,e),w(E.$$.fragment,e),w(q.$$.fragment,e),w(O.$$.fragment,e),w(ee.$$.fragment,e),w(le.$$.fragment,e),w(Z.$$.fragment,e),w(ne.$$.fragment,e),w(oe.$$.fragment,e),w(se.$$.fragment,e),w(I.$$.fragment,e),w(me.$$.fragment,e),w(Me.$$.fragment,e),ot=!0)},o(e){$(o.$$.fragment,e),$(A.$$.fragment,e),$(W.$$.fragment,e),$(H.$$.fragment,e),$(V.$$.fragment,e),$(B.$$.fragment,e),$(G.$$.fragment,e),$(F.$$.fragment,e),$(N.$$.fragment,e),$(S.$$.fragment,e),$(P.$$.fragment,e),$(E.$$.fragment,e),$(q.$$.fragment,e),$(O.$$.fragment,e),$(ee.$$.fragment,e),$(le.$$.fragment,e),$(Z.$$.fragment,e),$(ne.$$.fragment,e),$(oe.$$.fragment,e),$(se.$$.fragment,e),$(I.$$.fragment,e),$(me.$$.fragment,e),$(Me.$$.fragment,e),ot=!1},d(e){e&&(a(T),a(i),a(m),a(d),a(_),a(v),a(s),a(J),a($e),a(ge),a(X),a(be),a(R),a(Te),a(_e),a(Y),a(Ue),a(ve),a(Je),a(z),a(je),a(ke),a(x),a(Ce),a(Ge),a(Ze),a(Q),a(Ie),a(Ae),a(L),a(We),a(Xe),a(Re),a(K),a(He),a(Ye),a(D),a(Ve),a(Be),a(ze),a(te),a(xe),a(ae),a(Fe),a(Ne),a(re),a(Qe),a(ce),a(Se),a(Le),a(Pe),a(Ee),a(ie),a(Ke),a(qe),a(de),a(De),a(pe),a(Oe),a(et),a(tt),a(fe),a(at),a(ue),a(lt),a(he),a(rt),a(ye),a(ct),a(nt),a(we)),a(r),g(o,e),g(A,e),g(W,e),g(H,e),g(V,e),g(B,e),g(G,e),g(F,e),g(N,e),g(S,e),g(P,e),g(E,e),g(q,e),g(O,e),g(ee,e),g(le,e),g(Z,e),g(ne,e),g(oe,e),g(se,e),g(I,e),g(me,e),g(Me,e)}}}const Ot='{"title":"Add Accelerate to your code","local":"add-accelerate-to-your-code","sections":[{"title":"Accelerator","local":"accelerator","sections":[],"depth":2},{"title":"Prepare PyTorch objects","local":"prepare-pytorch-objects","sections":[],"depth":2},{"title":"Training loop","local":"training-loop","sections":[],"depth":2},{"title":"Training features","local":"training-features","sections":[{"title":"Gradient accumulation","local":"gradient-accumulation","sections":[],"depth":3},{"title":"Gradient clipping","local":"gradient-clipping","sections":[],"depth":3},{"title":"Mixed precision","local":"mixed-precision","sections":[],"depth":3}],"depth":2},{"title":"Save and load","local":"save-and-load","sections":[{"title":"Model","local":"model","sections":[],"depth":3},{"title":"State","local":"state","sections":[],"depth":3}],"depth":2}],"depth":1}';function ea(j){return Vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class oa extends Bt{constructor(r){super(),zt(this,r,ea,Dt,Yt,{})}}export{oa as component};
