import{s as us,n as Js,o as Ms}from"../chunks/scheduler.85c25b89.js";import{S as gs,i as js,g as l,s as p,u as c,A as Ts,h as n,f as s,c as i,j as h,v as d,y as m,k as o,o as r,a,w,d as y,t as u,x as J}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as st}from"../chunks/CodeBlock.00597c71.js";function fs(Vt){let M,ht,et,mt,g,v,at,N,St,D,zt="SPNASNet",ct,$,Ht="<strong>Single-Path NAS</strong> is a novel differentiable NAS method for designing hardware-efficient ConvNets in less than 4 hours.",dt,j,U,lt,x,At,q,Ft="How do I use this model on an image?",wt,W,Pt="To load a pretrained model:",yt,Z,ut,E,Lt="To load and preprocess the image:",Jt,B,Mt,G,Dt="To get the model predictions:",gt,_,jt,R,qt="To get the top-5 predictions class names:",Tt,S,ft,A,Kt="Replace the model name with the variant you want to use, e.g. <code>spnasnet_100</code>. You can find the IDs in the model summaries at the top of this page.",bt,X,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',vt,T,I,nt,Q,Xt,K,ts="How do I finetune this model?",Ut,Y,ss="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",It,V,kt,z,es=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Ct,f,k,pt,H,Qt,O,as="How do I train this model?",Nt,F,ls='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',$t,b,C,it,P,Yt,tt,ns="Citation",xt,L,Wt,ot,Zt;return N=new rt({}),x=new rt({}),Z=new st({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3NwbmFzbmV0XzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;spnasnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),B=new st({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),_=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),S=new st({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),Q=new rt({}),V=new st({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc3BuYXNuZXRfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;spnasnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),H=new rt({}),P=new rt({}),L=new st({props:{code:"JTQwbWlzYyU3QnN0YW1vdWxpczIwMTlzaW5nbGVwYXRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JTaW5nbGUtUGF0aCUyME5BUyUzQSUyMERlc2lnbmluZyUyMEhhcmR3YXJlLUVmZmljaWVudCUyMENvbnZOZXRzJTIwaW4lMjBsZXNzJTIwdGhhbiUyMDQlMjBIb3VycyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QkRpbWl0cmlvcyUyMFN0YW1vdWxpcyUyMGFuZCUyMFJ1aXpob3UlMjBEaW5nJTIwYW5kJTIwRGklMjBXYW5nJTIwYW5kJTIwRGltaXRyaW9zJTIwTHltYmVyb3BvdWxvcyUyMGFuZCUyMEJvZGhpJTIwUHJpeWFudGhhJTIwYW5kJTIwSmllJTIwTGl1JTIwYW5kJTIwRGlhbmElMjBNYXJjdWxlc2N1JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTA0LjAyODc3JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuTEclN0QlMEElN0Q=",highlighted:`@misc{stamoulis2019singlepath,
      title={Single-Path NAS: Designing Hardware-Efficient ConvNets in less than <span class="hljs-number">4</span> Hours}, 
      author={<span class="hljs-keyword">Dimitrios </span>Stamoulis <span class="hljs-keyword">and </span>Ruizhou <span class="hljs-keyword">Ding </span><span class="hljs-keyword">and </span><span class="hljs-keyword">Di </span>Wang <span class="hljs-keyword">and </span><span class="hljs-keyword">Dimitrios </span>Lymberopoulos <span class="hljs-keyword">and </span><span class="hljs-keyword">Bodhi </span>Priyantha <span class="hljs-keyword">and </span><span class="hljs-keyword">Jie </span>Liu <span class="hljs-keyword">and </span><span class="hljs-keyword">Diana </span>Marculescu},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1904</span>.<span class="hljs-number">02877</span>},
      archivePrefix={arXiv},
      primaryClass={cs.LG}
}`}}),{c(){M=l("meta"),ht=p(),et=l("p"),mt=p(),g=l("h1"),v=l("a"),at=l("span"),c(N.$$.fragment),St=p(),D=l("span"),D.textContent=zt,ct=p(),$=l("p"),$.innerHTML=Ht,dt=p(),j=l("h2"),U=l("a"),lt=l("span"),c(x.$$.fragment),At=p(),q=l("span"),q.textContent=Ft,wt=p(),W=l("p"),W.textContent=Pt,yt=p(),c(Z.$$.fragment),ut=p(),E=l("p"),E.textContent=Lt,Jt=p(),c(B.$$.fragment),Mt=p(),G=l("p"),G.textContent=Dt,gt=p(),c(_.$$.fragment),jt=p(),R=l("p"),R.textContent=qt,Tt=p(),c(S.$$.fragment),ft=p(),A=l("p"),A.innerHTML=Kt,bt=p(),X=l("p"),X.innerHTML=Ot,vt=p(),T=l("h2"),I=l("a"),nt=l("span"),c(Q.$$.fragment),Xt=p(),K=l("span"),K.textContent=ts,Ut=p(),Y=l("p"),Y.textContent=ss,It=p(),c(V.$$.fragment),kt=p(),z=l("p"),z.innerHTML=es,Ct=p(),f=l("h2"),k=l("a"),pt=l("span"),c(H.$$.fragment),Qt=p(),O=l("span"),O.textContent=as,Nt=p(),F=l("p"),F.innerHTML=ls,$t=p(),b=l("h2"),C=l("a"),it=l("span"),c(P.$$.fragment),Yt=p(),tt=l("span"),tt.textContent=ns,xt=p(),c(L.$$.fragment),Wt=p(),ot=l("p"),this.h()},l(t){const e=Ts("svelte-1phssyn",document.head);M=n(e,"META",{name:!0,content:!0}),e.forEach(s),ht=i(t),et=n(t,"P",{}),h(et).forEach(s),mt=i(t),g=n(t,"H1",{class:!0});var Et=h(g);v=n(Et,"A",{id:!0,class:!0,href:!0});var ps=h(v);at=n(ps,"SPAN",{});var is=h(at);d(N.$$.fragment,is),is.forEach(s),ps.forEach(s),St=i(Et),D=n(Et,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-1msy6vv"&&(D.textContent=zt),Et.forEach(s),ct=i(t),$=n(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-15s7q8i"&&($.innerHTML=Ht),dt=i(t),j=n(t,"H2",{class:!0});var Bt=h(j);U=n(Bt,"A",{id:!0,class:!0,href:!0});var os=h(U);lt=n(os,"SPAN",{});var rs=h(lt);d(x.$$.fragment,rs),rs.forEach(s),os.forEach(s),At=i(Bt),q=n(Bt,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-1c1hspn"&&(q.textContent=Ft),Bt.forEach(s),wt=i(t),W=n(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-18ywhxh"&&(W.textContent=Pt),yt=i(t),d(Z.$$.fragment,t),ut=i(t),E=n(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1c2ipa8"&&(E.textContent=Lt),Jt=i(t),d(B.$$.fragment,t),Mt=i(t),G=n(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1n9qsq1"&&(G.textContent=Dt),gt=i(t),d(_.$$.fragment,t),jt=i(t),R=n(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-19cnvx1"&&(R.textContent=qt),Tt=i(t),d(S.$$.fragment,t),ft=i(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-d1japu"&&(A.innerHTML=Kt),bt=i(t),X=n(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1wmi3ea"&&(X.innerHTML=Ot),vt=i(t),T=n(t,"H2",{class:!0});var Gt=h(T);I=n(Gt,"A",{id:!0,class:!0,href:!0});var hs=h(I);nt=n(hs,"SPAN",{});var ms=h(nt);d(Q.$$.fragment,ms),ms.forEach(s),hs.forEach(s),Xt=i(Gt),K=n(Gt,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=ts),Gt.forEach(s),Ut=i(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-9sr7nh"&&(Y.textContent=ss),It=i(t),d(V.$$.fragment,t),kt=i(t),z=n(t,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1kguc51"&&(z.innerHTML=es),Ct=i(t),f=n(t,"H2",{class:!0});var _t=h(f);k=n(_t,"A",{id:!0,class:!0,href:!0});var cs=h(k);pt=n(cs,"SPAN",{});var ds=h(pt);d(H.$$.fragment,ds),ds.forEach(s),cs.forEach(s),Qt=i(_t),O=n(_t,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=as),_t.forEach(s),Nt=i(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1n0coha"&&(F.innerHTML=ls),$t=i(t),b=n(t,"H2",{class:!0});var Rt=h(b);C=n(Rt,"A",{id:!0,class:!0,href:!0});var ws=h(C);it=n(ws,"SPAN",{});var ys=h(it);d(P.$$.fragment,ys),ys.forEach(s),ws.forEach(s),Yt=i(Rt),tt=n(Rt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ns),Rt.forEach(s),xt=i(t),d(L.$$.fragment,t),Wt=i(t),ot=n(t,"P",{}),h(ot).forEach(s),this.h()},h(){o(M,"name","hf:doc:metadata"),o(M,"content",JSON.stringify(bs)),o(v,"id","spnasnet"),o(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(v,"href","#spnasnet"),o(g,"class","relative group"),o(U,"id","how-do-i-use-this-model-on-an-image"),o(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(U,"href","#how-do-i-use-this-model-on-an-image"),o(j,"class","relative group"),o(I,"id","how-do-i-finetune-this-model"),o(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(I,"href","#how-do-i-finetune-this-model"),o(T,"class","relative group"),o(k,"id","how-do-i-train-this-model"),o(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(k,"href","#how-do-i-train-this-model"),o(f,"class","relative group"),o(C,"id","citation"),o(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(C,"href","#citation"),o(b,"class","relative group")},m(t,e){r(document.head,M),a(t,ht,e),a(t,et,e),a(t,mt,e),a(t,g,e),r(g,v),r(v,at),w(N,at,null),r(g,St),r(g,D),a(t,ct,e),a(t,$,e),a(t,dt,e),a(t,j,e),r(j,U),r(U,lt),w(x,lt,null),r(j,At),r(j,q),a(t,wt,e),a(t,W,e),a(t,yt,e),w(Z,t,e),a(t,ut,e),a(t,E,e),a(t,Jt,e),w(B,t,e),a(t,Mt,e),a(t,G,e),a(t,gt,e),w(_,t,e),a(t,jt,e),a(t,R,e),a(t,Tt,e),w(S,t,e),a(t,ft,e),a(t,A,e),a(t,bt,e),a(t,X,e),a(t,vt,e),a(t,T,e),r(T,I),r(I,nt),w(Q,nt,null),r(T,Xt),r(T,K),a(t,Ut,e),a(t,Y,e),a(t,It,e),w(V,t,e),a(t,kt,e),a(t,z,e),a(t,Ct,e),a(t,f,e),r(f,k),r(k,pt),w(H,pt,null),r(f,Qt),r(f,O),a(t,Nt,e),a(t,F,e),a(t,$t,e),a(t,b,e),r(b,C),r(C,it),w(P,it,null),r(b,Yt),r(b,tt),a(t,xt,e),w(L,t,e),a(t,Wt,e),a(t,ot,e),Zt=!0},p:Js,i(t){Zt||(y(N.$$.fragment,t),y(x.$$.fragment,t),y(Z.$$.fragment,t),y(B.$$.fragment,t),y(_.$$.fragment,t),y(S.$$.fragment,t),y(Q.$$.fragment,t),y(V.$$.fragment,t),y(H.$$.fragment,t),y(P.$$.fragment,t),y(L.$$.fragment,t),Zt=!0)},o(t){u(N.$$.fragment,t),u(x.$$.fragment,t),u(Z.$$.fragment,t),u(B.$$.fragment,t),u(_.$$.fragment,t),u(S.$$.fragment,t),u(Q.$$.fragment,t),u(V.$$.fragment,t),u(H.$$.fragment,t),u(P.$$.fragment,t),u(L.$$.fragment,t),Zt=!1},d(t){t&&(s(ht),s(et),s(mt),s(g),s(ct),s($),s(dt),s(j),s(wt),s(W),s(yt),s(ut),s(E),s(Jt),s(Mt),s(G),s(gt),s(jt),s(R),s(Tt),s(ft),s(A),s(bt),s(X),s(vt),s(T),s(Ut),s(Y),s(It),s(kt),s(z),s(Ct),s(f),s(Nt),s(F),s($t),s(b),s(xt),s(Wt),s(ot)),s(M),J(N),J(x),J(Z,t),J(B,t),J(_,t),J(S,t),J(Q),J(V,t),J(H),J(P),J(L,t)}}}const bs={local:"spnasnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"SPNASNet"};function vs(Vt){return Ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ns extends gs{constructor(M){super(),js(this,M,vs,fs,us,{})}}export{Ns as component};
