import{s as ue,n as we,o as ge}from"../chunks/scheduler.85c25b89.js";import{S as je,i as Je,g as l,s as o,u as c,A as fe,h as n,f as e,c as p,j as h,v as d,y as m,k as i,o as r,a,w as M,d as y,t as u,x as w}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function Te(zt){let g,ht,st,mt,j,v,at,I,St,q,Yt="SE-ResNeXt",ct,$,Ht='<strong>SE ResNeXt</strong> is a variant of a <a href="https://www.paperswithcode.com/method/resneXt" rel="nofollow">ResNext</a> that employs <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a> to enable the network to perform dynamic channel-wise feature recalibration.',dt,J,U,lt,N,Qt,D,Ft="How do I use this model on an image?",Mt,Z,Pt="To load a pretrained model:",yt,E,ut,W,Lt="To load and preprocess the image:",wt,_,gt,B,qt="To get the model predictions:",jt,G,Jt,X,Dt="To get the top-5 predictions class names:",ft,S,Tt,Q,Kt="Replace the model name with the variant you want to use, e.g. <code>seresnext26d_32x4d</code>. You can find the IDs in the model summaries at the top of this page.",bt,R,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',vt,f,C,nt,V,Rt,K,te="How do I finetune this model?",Ut,A,ee="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Ct,z,kt,Y,se=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,xt,T,k,ot,H,Vt,O,ae="How do I train this model?",It,F,le='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',$t,b,x,pt,P,At,tt,ne="Citation",Nt,L,Zt,it,Et;return I=new rt({}),N=new rt({}),E=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3NlcmVzbmV4dDI2ZF8zMng0ZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;seresnext26d_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),_=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),G=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),S=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),V=new rt({}),z=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc2VyZXNuZXh0MjZkXzMyeDRkJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;seresnext26d_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),H=new rt({}),P=new rt({}),L=new et({props:{code:"JTQwbWlzYyU3Qmh1MjAxOXNxdWVlemVhbmRleGNpdGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JTcXVlZXplLWFuZC1FeGNpdGF0aW9uJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JKaWUlMjBIdSUyMGFuZCUyMExpJTIwU2hlbiUyMGFuZCUyMFNhbXVlbCUyMEFsYmFuaWUlMjBhbmQlMjBHYW5nJTIwU3VuJTIwYW5kJTIwRW5odWElMjBXdSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE5JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTcwOS4wMTUwNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`@misc{hu2019squeezeandexcitation,
      title={Squeeze-<span class="hljs-keyword">and-Excitation </span>Networks}, 
      author={<span class="hljs-keyword">Jie </span>Hu <span class="hljs-keyword">and </span>Li <span class="hljs-keyword">Shen </span><span class="hljs-keyword">and </span>Samuel Albanie <span class="hljs-keyword">and </span>Gang Sun <span class="hljs-keyword">and </span>Enhua Wu},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1709</span>.<span class="hljs-number">01507</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`}}),{c(){g=l("meta"),ht=o(),st=l("p"),mt=o(),j=l("h1"),v=l("a"),at=l("span"),c(I.$$.fragment),St=o(),q=l("span"),q.textContent=Yt,ct=o(),$=l("p"),$.innerHTML=Ht,dt=o(),J=l("h2"),U=l("a"),lt=l("span"),c(N.$$.fragment),Qt=o(),D=l("span"),D.textContent=Ft,Mt=o(),Z=l("p"),Z.textContent=Pt,yt=o(),c(E.$$.fragment),ut=o(),W=l("p"),W.textContent=Lt,wt=o(),c(_.$$.fragment),gt=o(),B=l("p"),B.textContent=qt,jt=o(),c(G.$$.fragment),Jt=o(),X=l("p"),X.textContent=Dt,ft=o(),c(S.$$.fragment),Tt=o(),Q=l("p"),Q.innerHTML=Kt,bt=o(),R=l("p"),R.innerHTML=Ot,vt=o(),f=l("h2"),C=l("a"),nt=l("span"),c(V.$$.fragment),Rt=o(),K=l("span"),K.textContent=te,Ut=o(),A=l("p"),A.textContent=ee,Ct=o(),c(z.$$.fragment),kt=o(),Y=l("p"),Y.innerHTML=se,xt=o(),T=l("h2"),k=l("a"),ot=l("span"),c(H.$$.fragment),Vt=o(),O=l("span"),O.textContent=ae,It=o(),F=l("p"),F.innerHTML=le,$t=o(),b=l("h2"),x=l("a"),pt=l("span"),c(P.$$.fragment),At=o(),tt=l("span"),tt.textContent=ne,Nt=o(),c(L.$$.fragment),Zt=o(),it=l("p"),this.h()},l(t){const s=fe("svelte-1phssyn",document.head);g=n(s,"META",{name:!0,content:!0}),s.forEach(e),ht=p(t),st=n(t,"P",{}),h(st).forEach(e),mt=p(t),j=n(t,"H1",{class:!0});var Wt=h(j);v=n(Wt,"A",{id:!0,class:!0,href:!0});var oe=h(v);at=n(oe,"SPAN",{});var pe=h(at);d(I.$$.fragment,pe),pe.forEach(e),oe.forEach(e),St=p(Wt),q=n(Wt,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-1s1s74r"&&(q.textContent=Yt),Wt.forEach(e),ct=p(t),$=n(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-1ygzzjy"&&($.innerHTML=Ht),dt=p(t),J=n(t,"H2",{class:!0});var _t=h(J);U=n(_t,"A",{id:!0,class:!0,href:!0});var ie=h(U);lt=n(ie,"SPAN",{});var re=h(lt);d(N.$$.fragment,re),re.forEach(e),ie.forEach(e),Qt=p(_t),D=n(_t,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-1c1hspn"&&(D.textContent=Ft),_t.forEach(e),Mt=p(t),Z=n(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-18ywhxh"&&(Z.textContent=Pt),yt=p(t),d(E.$$.fragment,t),ut=p(t),W=n(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1c2ipa8"&&(W.textContent=Lt),wt=p(t),d(_.$$.fragment,t),gt=p(t),B=n(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1n9qsq1"&&(B.textContent=qt),jt=p(t),d(G.$$.fragment,t),Jt=p(t),X=n(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-19cnvx1"&&(X.textContent=Dt),ft=p(t),d(S.$$.fragment,t),Tt=p(t),Q=n(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-146ww9r"&&(Q.innerHTML=Kt),bt=p(t),R=n(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1wmi3ea"&&(R.innerHTML=Ot),vt=p(t),f=n(t,"H2",{class:!0});var Bt=h(f);C=n(Bt,"A",{id:!0,class:!0,href:!0});var he=h(C);nt=n(he,"SPAN",{});var me=h(nt);d(V.$$.fragment,me),me.forEach(e),he.forEach(e),Rt=p(Bt),K=n(Bt,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=te),Bt.forEach(e),Ut=p(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-9sr7nh"&&(A.textContent=ee),Ct=p(t),d(z.$$.fragment,t),kt=p(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1kguc51"&&(Y.innerHTML=se),xt=p(t),T=n(t,"H2",{class:!0});var Gt=h(T);k=n(Gt,"A",{id:!0,class:!0,href:!0});var ce=h(k);ot=n(ce,"SPAN",{});var de=h(ot);d(H.$$.fragment,de),de.forEach(e),ce.forEach(e),Vt=p(Gt),O=n(Gt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=ae),Gt.forEach(e),It=p(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1n0coha"&&(F.innerHTML=le),$t=p(t),b=n(t,"H2",{class:!0});var Xt=h(b);x=n(Xt,"A",{id:!0,class:!0,href:!0});var Me=h(x);pt=n(Me,"SPAN",{});var ye=h(pt);d(P.$$.fragment,ye),ye.forEach(e),Me.forEach(e),At=p(Xt),tt=n(Xt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ne),Xt.forEach(e),Nt=p(t),d(L.$$.fragment,t),Zt=p(t),it=n(t,"P",{}),h(it).forEach(e),this.h()},h(){i(g,"name","hf:doc:metadata"),i(g,"content",JSON.stringify(be)),i(v,"id","seresnext"),i(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(v,"href","#seresnext"),i(j,"class","relative group"),i(U,"id","how-do-i-use-this-model-on-an-image"),i(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(U,"href","#how-do-i-use-this-model-on-an-image"),i(J,"class","relative group"),i(C,"id","how-do-i-finetune-this-model"),i(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(C,"href","#how-do-i-finetune-this-model"),i(f,"class","relative group"),i(k,"id","how-do-i-train-this-model"),i(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(k,"href","#how-do-i-train-this-model"),i(T,"class","relative group"),i(x,"id","citation"),i(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(x,"href","#citation"),i(b,"class","relative group")},m(t,s){r(document.head,g),a(t,ht,s),a(t,st,s),a(t,mt,s),a(t,j,s),r(j,v),r(v,at),M(I,at,null),r(j,St),r(j,q),a(t,ct,s),a(t,$,s),a(t,dt,s),a(t,J,s),r(J,U),r(U,lt),M(N,lt,null),r(J,Qt),r(J,D),a(t,Mt,s),a(t,Z,s),a(t,yt,s),M(E,t,s),a(t,ut,s),a(t,W,s),a(t,wt,s),M(_,t,s),a(t,gt,s),a(t,B,s),a(t,jt,s),M(G,t,s),a(t,Jt,s),a(t,X,s),a(t,ft,s),M(S,t,s),a(t,Tt,s),a(t,Q,s),a(t,bt,s),a(t,R,s),a(t,vt,s),a(t,f,s),r(f,C),r(C,nt),M(V,nt,null),r(f,Rt),r(f,K),a(t,Ut,s),a(t,A,s),a(t,Ct,s),M(z,t,s),a(t,kt,s),a(t,Y,s),a(t,xt,s),a(t,T,s),r(T,k),r(k,ot),M(H,ot,null),r(T,Vt),r(T,O),a(t,It,s),a(t,F,s),a(t,$t,s),a(t,b,s),r(b,x),r(x,pt),M(P,pt,null),r(b,At),r(b,tt),a(t,Nt,s),M(L,t,s),a(t,Zt,s),a(t,it,s),Et=!0},p:we,i(t){Et||(y(I.$$.fragment,t),y(N.$$.fragment,t),y(E.$$.fragment,t),y(_.$$.fragment,t),y(G.$$.fragment,t),y(S.$$.fragment,t),y(V.$$.fragment,t),y(z.$$.fragment,t),y(H.$$.fragment,t),y(P.$$.fragment,t),y(L.$$.fragment,t),Et=!0)},o(t){u(I.$$.fragment,t),u(N.$$.fragment,t),u(E.$$.fragment,t),u(_.$$.fragment,t),u(G.$$.fragment,t),u(S.$$.fragment,t),u(V.$$.fragment,t),u(z.$$.fragment,t),u(H.$$.fragment,t),u(P.$$.fragment,t),u(L.$$.fragment,t),Et=!1},d(t){t&&(e(ht),e(st),e(mt),e(j),e(ct),e($),e(dt),e(J),e(Mt),e(Z),e(yt),e(ut),e(W),e(wt),e(gt),e(B),e(jt),e(Jt),e(X),e(ft),e(Tt),e(Q),e(bt),e(R),e(vt),e(f),e(Ut),e(A),e(Ct),e(kt),e(Y),e(xt),e(T),e(It),e(F),e($t),e(b),e(Nt),e(Zt),e(it)),e(g),w(I),w(N),w(E,t),w(_,t),w(G,t),w(S,t),w(V),w(z,t),w(H),w(P),w(L,t)}}}const be={local:"seresnext",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"SE-ResNeXt"};function ve(zt){return ge(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ie extends je{constructor(g){super(),Je(this,g,ve,Te,ue,{})}}export{Ie as component};
