import{s as Lp,o as jp,n as Yl}from"../chunks/scheduler.9bc65507.js";import{S as Dp,i as Hp,g as a,s as i,r as c,A as Gp,h as o,f as l,c as n,j as $p,u as d,x as r,k as _,y as Jp,a as s,v,d as w,t as g,w as P}from"../chunks/index.707bf1b6.js";import{T as Ua}from"../chunks/Tip.c2ecdbf4.js";import{C as x}from"../chunks/CodeBlock.54a9f38d.js";import{H as C}from"../chunks/Heading.342b1fa6.js";import{H as Ip,a as $a}from"../chunks/HfOption.6d864328.js";function kp(T){let p,M=`While the main concepts discussed in this guide are likely applicable across frameworks, here we focus on
PyTorch-based implementations.`;return{c(){p=a("p"),p.textContent=M},l(f){p=o(f,"P",{"data-svelte-h":!0}),r(p)!=="svelte-11nx342"&&(p.textContent=M)},m(f,u){s(f,p,u)},p:Yl,d(f){f&&l(p)}}}function Ep(T){let p,M=`This mechanism is similar to an efficient group backpacking strategy: person A carries the tent, person B carries the stove,
and person C carries the axe. Each night they all share what they have with others and get from others what they don’t have,
and in the morning they pack up their allocated type of gear and continue on their way. This is what ZeRO DP/Sharded DDP is.
Compare this strategy to the simple one where each person has to carry their own tent, stove and axe (similar to
DataParallel (DP and DDP) in PyTorch), which would be far more inefficient.`;return{c(){p=a("p"),p.textContent=M},l(f){p=o(f,"P",{"data-svelte-h":!0}),r(p)!=="svelte-15youi0"&&(p.textContent=M)},m(f,u){s(f,p,u)},p:Yl,d(f){f&&l(p)}}}function Sp(T){let p,M="Use the <code>--nproc_per_node</code> to select how many GPUs to use.",f,u,y;return u=new x({props:{code:"dG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEMiUyMCUyMHRyYWluZXItcHJvZ3JhbS5weSUyMC4uLg==",highlighted:"torchrun --nproc_per_node=2  trainer-program.py ...",wrap:!1}}),{c(){p=a("p"),p.innerHTML=M,f=i(),c(u.$$.fragment)},l(h){p=o(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-ghitll"&&(p.innerHTML=M),f=n(h),d(u.$$.fragment,h)},m(h,m){s(h,p,m),s(h,f,m),v(u,h,m),y=!0},p:Yl,i(h){y||(w(u.$$.fragment,h),y=!0)},o(h){g(u.$$.fragment,h),y=!1},d(h){h&&(l(p),l(f)),P(u,h)}}}function Np(T){let p,M="Use <code>--num_processes</code> to select how many GPUs to use.",f,u,y;return u=new x({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbnVtX3Byb2Nlc3NlcyUyMDIlMjB0cmFpbmVyLXByb2dyYW0ucHklMjAuLi4=",highlighted:"accelerate launch --num_processes 2 trainer-program.py ...",wrap:!1}}),{c(){p=a("p"),p.innerHTML=M,f=i(),c(u.$$.fragment)},l(h){p=o(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-15fv5d7"&&(p.innerHTML=M),f=n(h),d(u.$$.fragment,h)},m(h,m){s(h,p,m),s(h,f,m),v(u,h,m),y=!0},p:Yl,i(h){y||(w(u.$$.fragment,h),y=!0)},o(h){g(u.$$.fragment,h),y=!1},d(h){h&&(l(p),l(f)),P(u,h)}}}function Vp(T){let p,M="Use <code>--num_gpus</code> to select how many GPUs to use.",f,u,y;return u=new x({props:{code:"ZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUyMDIlMjB0cmFpbmVyLXByb2dyYW0ucHklMjAuLi4=",highlighted:"deepspeed --num_gpus 2 trainer-program.py ...",wrap:!1}}),{c(){p=a("p"),p.innerHTML=M,f=i(),c(u.$$.fragment)},l(h){p=o(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-14evfjd"&&(p.innerHTML=M),f=n(h),d(u.$$.fragment,h)},m(h,m){s(h,p,m),s(h,f,m),v(u,h,m),y=!0},p:Yl,i(h){y||(w(u.$$.fragment,h),y=!0)},o(h){g(u.$$.fragment,h),y=!1},d(h){h&&(l(p),l(f)),P(u,h)}}}function Ap(T){let p,M,f,u,y,h;return p=new $a({props:{id:"select-gpu",option:"torchrun",$$slots:{default:[Sp]},$$scope:{ctx:T}}}),f=new $a({props:{id:"select-gpu",option:"Accelerate",$$slots:{default:[Np]},$$scope:{ctx:T}}}),y=new $a({props:{id:"select-gpu",option:"DeepSpeed",$$slots:{default:[Vp]},$$scope:{ctx:T}}}),{c(){c(p.$$.fragment),M=i(),c(f.$$.fragment),u=i(),c(y.$$.fragment)},l(m){d(p.$$.fragment,m),M=n(m),d(f.$$.fragment,m),u=n(m),d(y.$$.fragment,m)},m(m,b){v(p,m,b),s(m,M,b),v(f,m,b),s(m,u,b),v(y,m,b),h=!0},p(m,b){const R={};b&2&&(R.$$scope={dirty:b,ctx:m}),p.$set(R);const U={};b&2&&(U.$$scope={dirty:b,ctx:m}),f.$set(U);const Kl={};b&2&&(Kl.$$scope={dirty:b,ctx:m}),y.$set(Kl)},i(m){h||(w(p.$$.fragment,m),w(f.$$.fragment,m),w(y.$$.fragment,m),h=!0)},o(m){g(p.$$.fragment,m),g(f.$$.fragment,m),g(y.$$.fragment,m),h=!1},d(m){m&&(l(M),l(u)),P(p,m),P(f,m),P(y,m)}}}function Qp(T){let p,M="As with any environment variable, they can be exported instead of being added to the command line. However, this is not recommended because it can be confusing if you forget how the environment variable was setup and you end up using the wrong GPUs. Instead, it is common practice to set the environment variable for a specific training run on the same command line.";return{c(){p=a("p"),p.textContent=M},l(f){p=o(f,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1ky103q"&&(p.textContent=M)},m(f,u){s(f,p,u)},p:Yl,d(f){f&&l(p)}}}function Rp(T){let p,M,f,u,y,h,m,b=`If training a model on a single GPU is too slow or if the model’s weights do not fit in a single GPU’s memory, transitioning
to a multi-GPU setup may be a viable option. Prior to making this transition, thoroughly explore all the strategies covered
in the <a href="perf_train_gpu_one">Methods and tools for efficient training on a single GPU</a> as they are universally applicable
to model training on any number of GPUs. Once you have employed those strategies and found them insufficient for your
case on a single GPU, consider moving to multiple GPUs.`,R,U,Kl=`Transitioning from a single GPU to multiple GPUs requires the introduction of some form of parallelism, as the workload
must be distributed across the resources. Multiple techniques can be employed to achieve parallelism, such as data
parallelism, tensor parallelism, and pipeline parallelism. It’s important to note that there isn’t a one-size-fits-all
solution, and the optimal settings depend on the specific hardware configuration you are using.`,ts,z,La=`This guide offers an in-depth overview of individual types of parallelism, as well as guidance on ways to combine<br/>
techniques and choosing an appropriate approach. For step-by-step tutorials on distributed training, please refer to
the <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">🤗 Accelerate documentation</a>.`,ls,$,ss,B,ja=`Before diving deeper into the specifics of each technique, let’s go over the rough decision process when training
large models on a large infrastructure.`,is,F,ns,W,Da=`Begin by estimating how much vRAM is required to train your model. For models hosted on the 🤗 Hub, use our
<a href="https://huggingface.co/spaces/hf-accelerate/model-memory-usage" rel="nofollow">Model Memory Calculator</a>, which gives you
accurate calculations within a few percent margin.`,as,Z,Ha="<strong>Parallelization strategy for a single Node / multi-GPU setup</strong>",os,X,Ga=`When training a model on a single node with multiple GPUs, your choice of parallelization strategy can significantly
impact performance. Here’s a breakdown of your options:`,rs,O,Ja="<strong>Case 1: Your model fits onto a single GPU</strong>",ps,q,Ia="If your model can comfortably fit onto a single GPU, you have two primary options:",hs,Y,ka="<li>DDP - Distributed DataParallel</li> <li>ZeRO - depending on the situation and configuration used, this method may or may not be faster, however, it’s worth experimenting with it.</li>",ms,K,Ea="<strong>Case 2: Your model doesn’t fit onto a single GPU:</strong>",fs,ee,Sa="If your model is too large for a single GPU, you have several alternatives to consider:",us,te,Na="<li>PipelineParallel (PP)</li> <li>ZeRO</li> <li>TensorParallel (TP)</li>",cs,le,Va=`With very fast inter-node connectivity (e.g., NVLINK or NVSwitch) all three strategies (PP, ZeRO, TP) should result in
similar performance. However, without these, PP will be faster than TP or ZeRO. The degree of TP may also
make a difference. It’s best to experiment with your specific setup to determine the most suitable strategy.`,ds,se,Aa="TP is almost always used within a single node. That is TP size <= GPUs per node.",vs,ie,Qa="<strong>Case 3: Largest layer of your model does not fit onto a single GPU</strong>",ws,ne,Ra='<li>If you are not using ZeRO, you have to use TensorParallel (TP), because PipelineParallel (PP) alone won’t be sufficient to accommodate the large layer.</li> <li>If you are using ZeRO, additionally adopt techniques from the <a href="perf_train_gpu_one">Methods and tools for efficient training on a single GPU</a>.</li>',gs,ae,za="<strong>Parallelization strategy for a multi-Node / multi-GPU setup</strong>",Ps,oe,Ba="<li><p>When you have fast inter-node connectivity (e.g., NVLINK or NVSwitch) consider using one of these options:</p> <ol><li>ZeRO - as it requires close to no modifications to the model</li> <li>A combination of PipelineParallel(PP) with TensorParallel(TP) and DataParallel(DP) - this approach will result in fewer communications, but requires significant changes to the model</li></ol></li> <li><p>When you have slow inter-node connectivity and still low on GPU memory:</p> <ol><li>Employ a combination of DataParallel(DP) with PipelineParallel(PP), TensorParallel(TP), and ZeRO.</li></ol></li>",ys,re,Fa="In the following sections of this guide we dig deeper into how these different parallelism methods work.",Ms,pe,Ts,he,Wa=`Even with only 2 GPUs, you can readily leverage the accelerated training capabilities offered by PyTorch’s built-in features,
such as <code>DataParallel</code> (DP) and <code>DistributedDataParallel</code> (DDP). Note that
<a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">PyTorch documentation</a> recommends to prefer
<code>DistributedDataParallel</code> (DDP) over <code>DataParallel</code> (DP) for multi-GPU training as it works for all models.
Let’s take a look at how these two methods work and what makes them different.`,bs,me,xs,fe,Za="To understand the key differences in inter-GPU communication overhead between the two methods, let’s review the processes per batch:",Cs,ue,Xa='<a href="https://pytorch.org/docs/master/notes/ddp.html" rel="nofollow">DDP</a>:',_s,ce,Oa="<li>At the start time the main process replicates the model once from GPU 0 to the rest of GPUs</li> <li>Then for each batch:<ol><li>Each GPU directly consumes its mini-batch of data.</li> <li>During <code>backward</code>, once the local gradients are ready, they are averaged across all processes.</li></ol></li>",Us,de,qa='<a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">DP</a>:',$s,ve,Ya="For each batch:",Ls,we,Ka="<li>GPU 0 reads the batch of data and then sends a mini-batch to each GPU.</li> <li>The up-to-date model is replicated from GPU 0 to each GPU.</li> <li><code>forward</code> is executed, and output from each GPU is sent to GPU 0 to compute the loss.</li> <li>The loss is distributed from GPU 0 to all GPUs, and <code>backward</code> is run.</li> <li>Gradients from each GPU are sent to GPU 0 and averaged.</li>",js,ge,eo="Key differences include:",Ds,Pe,to=`<li>DDP performs only a single communication per batch - sending gradients, while DP performs five different data exchanges per batch.
DDP copies data using <a href="https://pytorch.org/docs/master/distributed.html" rel="nofollow">torch.distributed</a>, while DP copies data within
the process via Python threads (which introduces limitations associated with GIL). As a result, <strong><code>DistributedDataParallel</code> (DDP) is generally faster than <code>DataParallel</code> (DP)</strong> unless you have slow GPU card inter-connectivity.</li> <li>Under DP, GPU 0 performs significantly more work than other GPUs, resulting in GPU under-utilization.</li> <li>DDP supports distributed training across multiple machines, whereas DP does not.</li>`,Hs,ye,lo=`This is not an exhaustive list of differences between DP and DDP, however, other nuances are out of scope of this guide.
You can get a deeper understanding of these methods by reading this <a href="https://www.telesens.co/2019/04/04/distributed-data-parallel-training-using-pytorch-on-aws/" rel="nofollow">article</a>.`,Gs,Me,so=`Let’s illustrate the differences between DP and DDP with an experiment. We’ll benchmark the differences between DP and
DDP with an added context of NVLink presence:`,Js,Te,io="<li>Hardware: 2x TITAN RTX 24GB each + NVlink with 2 NVLinks (<code>NV2</code> in <code>nvidia-smi topo -m</code>).</li> <li>Software: <code>pytorch-1.8-to-be</code> + <code>cuda-11.0</code> / <code>transformers==4.3.0.dev0</code>.</li>",Is,be,no="To disable the NVLink feature on one of the benchmarks, we use <code>NCCL_P2P_DISABLE=1</code>.",ks,xe,ao="Here is the benchmarking code and outputs:",Es,Ce,oo="<strong>DP</strong>",Ss,_e,Ns,Ue,ro="<strong>DDP w/ NVlink</strong>",Vs,$e,As,Le,po="<strong>DDP w/o NVlink</strong>",Qs,je,Rs,De,ho="Here are the same benchmarking results gathered in a table for convenience:",zs,He,mo='<thead><tr><th align="left">Type</th> <th>NVlink</th> <th align="right">Time</th></tr></thead> <tbody><tr><td align="left">2:DP</td> <td>Y</td> <td align="right">110s</td></tr> <tr><td align="left">2:DDP</td> <td>Y</td> <td align="right">101s</td></tr> <tr><td align="left">2:DDP</td> <td>N</td> <td align="right">131s</td></tr></tbody>',Bs,Ge,fo=`As you can see, in this case DP is ~10% slower than DDP with NVlink, but ~15% faster than DDP without NVlink.
The real difference will depend on how much data each GPU needs to sync with the others - the more there is to sync,
the more a slow link will impede the overall runtime.`,Fs,Je,Ws,Ie,uo='ZeRO-powered data parallelism (ZeRO-DP) is illustrated in the following diagram from this <a href="https://www.microsoft.com/en-us/research/blog/zero-deepspeed-new-system-optimizations-enable-training-models-with-over-100-billion-parameters/" rel="nofollow">blog post</a>.',Zs,L,co='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero.png" alt="DeepSpeed-Image-1"/>',Xs,ke,vo=`While it may appear complex, it is a very similar concept to <code>DataParallel</code> (DP). The difference is that instead of
replicating the full model parameters, gradients and optimizer states, each GPU stores only a slice of it. Then, at
run-time when the full layer parameters are needed just for the given layer, all GPUs synchronize to give each other
parts that they miss.`,Os,Ee,wo=`To illustrate this idea, consider a simple model with 3 layers (La, Lb, and Lc), where each layer has 3 parameters.
Layer La, for example, has weights a0, a1 and a2:`,qs,Se,Ys,Ne,go="If we have 3 GPUs, ZeRO-DP splits the model onto 3 GPUs like so:",Ks,Ve,ei,Ae,Po=`In a way, this is the same horizontal slicing as tensor parallelism, as opposed to Vertical
slicing, where one puts whole layer-groups on different GPUs. Now let’s see how this works:`,ti,Qe,yo="Each of these GPUs will get the usual mini-batch as it works in DP:",li,Re,si,ze,Mo="The inputs are passed without modifications as if they would be processed by the original model.",ii,Be,To="First, the inputs get to the layer <code>La</code>. What happens at this point?",ni,Fe,bo=`On GPU0: the x0 mini-batch requires the a0, a1, a2 parameters to do its forward path through the layer, but the GPU0 has only a0.
It will get a1 from GPU1 and a2 from GPU2, bringing all the pieces of the model together.`,ai,We,xo=`In parallel, GPU1 gets another mini-batch - x1. GPU1 has the a1 parameter, but needs a0 and a2, so it gets those from GPU0 and GPU2.
Same happens to GPU2 that gets the mini-batch x2. It gets a0 and a1 from GPU0 and GPU1.`,oi,Ze,Co=`This way each of the 3 GPUs gets the full tensors reconstructed and makes a forward pass with its own mini-batch.
As soon as the calculation is done, the data that is no longer needed gets dropped - it’s only used during the calculation.
The reconstruction is done efficiently via a pre-fetch.`,ri,Xe,_o="Then the whole process is repeated for layer Lb, then Lc forward-wise, and then backward Lc -> Lb -> La.",pi,j,hi,Oe,Uo=`While reading the literature on this topic you may encounter the following synonyms: Sharded, Partitioned.
If you pay close attention the way ZeRO partitions the model’s weights - it looks very similar to tensor parallelism
which will be discussed later. This is because it partitions/shards each layer’s weights, unlike vertical model parallelism
which is discussed next.`,mi,qe,$o="Implementations:",fi,Ye,Lo='<li><a href="https://www.deepspeed.ai/tutorials/zero/" rel="nofollow">DeepSpeed</a> ZeRO-DP stages 1+2+3</li> <li><a href="https://huggingface.co/docs/accelerate/en/usage_guides/deepspeed" rel="nofollow"><code>Accelerate</code> integration</a></li> <li><a href="main_classes/trainer#trainer-integrations"><code>transformers</code> integration</a></li>',ui,Ke,ci,et,jo=`To explain Pipeline parallelism, we’ll first look into Naive Model Parallelism (MP), also known as Vertical MP. This approach
involves distributing groups of model layers across multiple GPUs by assigning specific layers to specific GPUs with <code>.to()</code>.
As data flows through these layers, it is moved to the same GPU as the layer, while the other layers remain untouched.`,di,tt,Do=`We refer to this Model parallelism as “Vertical” because of how models are typically visualized. For example, the
following diagram shows an 8-layer model split vertically into two slices, placing layers 0-3 onto
GPU0 and 4-7 to GPU1:`,vi,lt,wi,st,Ho=`In this example, when data moves from layer 0 to 3, it’s no different from regular forward pass. However, passing data
from layer 3 to 4 requires moving it from GPU0 to GPU1, introducing a communication overhead. If the participating
GPUs are on the same compute node (e.g. same physical machine) this copying is fast, but if the GPUs are distributed
across different compute nodes (e.g. multiple machines), the communication overhead could be substantially greater.`,gi,it,Go=`Following that, layers 4 to 7 work as they would in the original model. Upon completion of the 7th layer, there is often
a need to send the data back to layer 0 where the labels are (or alternatively send the labels to the last layer). Now the loss can be
computed and the optimizer can do its work.`,Pi,nt,Jo="Naive Model Parallelism comes several shortcomings:",yi,at,Io="<li><strong>All but one GPU are idle at any given moment</strong>: if 4 GPUs are used, it’s nearly identical to quadrupling the amount of memory of a single GPU, and ignoring the rest of the hardware.</li> <li><strong>Overhead in data transfer between devices</strong>:  E.g. 4x 6GB cards will be able to accommodate the same size as 1x 24GB card using naive MP, but a single 24GB card will complete the training faster, because it doesn’t have the data copying overhead. But, say, if you have 40GB cards and need to fit a 45GB model you can with 4x 40GB cards (but barely because of the gradient and optimizer states)</li> <li><strong>Copying shared embeddings</strong>: Shared embeddings may need to get copied back and forth between GPUs.</li>",Mi,ot,ko=`Now that you are familiar with how the naive approach to model parallelism works and its shortcomings, let’s look at Pipeline Parallelism (PP).
PP is almost identical to a naive MP, but it solves the GPU idling problem by chunking the incoming batch into micro-batches
and artificially creating a pipeline, which allows different GPUs to concurrently participate in the computation process.`,Ti,rt,Eo=`The following illustration from the <a href="https://ai.googleblog.com/2019/03/introducing-gpipe-open-source-library.html" rel="nofollow">GPipe paper</a>
shows the naive MP on the top, and PP on the bottom:`,bi,D,So='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-gpipe-bubble.png" alt="MP vs PP"/>',xi,pt,No=`At the bottom of the diagram, you can observe that the Pipeline Parallelism (PP) approach minimizes the number of idle
GPU zones, referred to as ‘bubbles’. Both parts of the diagram show a parallelism level of degree 4, meaning that 4 GPUs
are involved in the pipeline. You can see that there’s a forward path of 4 pipe stages (F0, F1, F2 and F3) followed by
a backward path in reverse order (B3, B2, B1, and B0).`,Ci,ht,Vo=`PP introduces a new hyperparameter to tune - <code>chunks</code>, which determines how many data chunks are sent in a sequence
through the same pipe stage. For example, in the bottom diagram you can see <code>chunks=4</code>. GPU0 performs the same
forward path on chunk 0, 1, 2 and 3 (F0,0, F0,1, F0,2, F0,3) and then it waits for other GPUs to do complete their work.
Only when the other GPUs begin to complete their work, GPU0 starts to work again doing the backward path for chunks
3, 2, 1 and 0 (B0,3, B0,2, B0,1, B0,0).`,_i,mt,Ao=`Note that this is the same concept as gradient accumulation steps. PyTorch uses <code>chunks</code>, while DeepSpeed refers
to the same hyperparameter as gradient accumulation steps.`,Ui,ft,Qo=`Because of the chunks, PP introduces the notion of micro-batches (MBS). DP splits the global data batch size into
mini-batches, so if you have a DP degree of 4, a global batch size of 1024 gets split up into 4 mini-batches of
256 each (1024/4). And if the number of <code>chunks</code> (or GAS) is 32 we end up with a micro-batch size of 8 (256/32). Each
Pipeline stage works with a single micro-batch at a time. To calculate the global batch size of the DP + PP setup,
use the formula: <code>mbs * chunks * dp_degree</code> (<code>8 * 32 * 4 = 1024</code>).
With <code>chunks=1</code> you end up with the naive MP, which is inefficient. With a large <code>chunks</code> value you end up with
tiny micro-batch sizes which is also inefficient. For this reason, we encourage to experiment with the <code>chunks</code> value to
find the one that leads to the most efficient GPUs utilization.`,$i,ut,Ro=`You may notice a bubble of “dead” time on the diagram that can’t be parallelized because the last <code>forward</code> stage
has to wait for <code>backward</code> to complete the pipeline. The purpose of finding the best value for <code>chunks</code> is to enable a high
concurrent GPU utilization across all participating GPUs which translates to minimizing the size of the bubble.`,Li,ct,zo="Pipeline API solutions have been implemented in:",ji,dt,Bo="<li>PyTorch</li> <li>DeepSpeed</li> <li>Megatron-LM</li>",Di,vt,Fo="These come with some shortcomings:",Hi,wt,Wo='<li>They have to modify the model quite heavily, because Pipeline requires one to rewrite the normal flow of modules into a <code>nn.Sequential</code> sequence of the same, which may require changes to the design of the model.</li> <li>Currently the Pipeline API is very restricted. If you had a bunch of Python variables being passed in the very first stage of the Pipeline, you will have to find a way around it. Currently, the pipeline interface requires either a single Tensor or a tuple of Tensors as the only input and output. These tensors must have a batch size as the very first dimension, since pipeline is going to chunk the mini batch into micro-batches. Possible improvements are being discussed here <a href="https://github.com/pytorch/pytorch/pull/50693" rel="nofollow">https://github.com/pytorch/pytorch/pull/50693</a></li> <li>Conditional control flow at the level of pipe stages is not possible - e.g., Encoder-Decoder models like T5 require special workarounds to handle a conditional encoder stage.</li> <li>They have to arrange each layer so that the output of one layer becomes an input to the other layer.</li>',Gi,gt,Zo="More recent solutions include:",Ji,Pt,Xo="<li>Varuna</li> <li>Sagemaker</li>",Ii,yt,Oo=`We have not experimented with Varuna and SageMaker but their papers report that they have overcome the list of problems
mentioned above and that they require smaller changes to the user’s model.`,ki,Mt,qo="Implementations:",Ei,Tt,Yo='<li><a href="https://pytorch.org/docs/stable/pipeline.html" rel="nofollow">PyTorch</a> (initial support in pytorch-1.8, and progressively getting improved in 1.9 and more so in 1.10). Some <a href="https://github.com/pytorch/pytorch/blob/master/benchmarks/distributed/pipeline/pipe.py" rel="nofollow">examples</a></li> <li><a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> has an internal implementation - no API.</li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - this is a proprietary solution that can only be used on AWS.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a> - this is implemented based on the Hugging Face Transformers.</li>',Si,bt,Ko=`🤗 Transformers status: as of this writing none of the models supports full-PP. GPT2 and T5 models have naive MP support.
The main obstacle is being unable to convert the models to <code>nn.Sequential</code> and have all the inputs to be Tensors. This
is because currently the models include many features that make the conversion very complicated, and will need to be removed to accomplish that.`,Ni,xt,er='DeepSpeed and Megatron-LM integrations are available in <a href="https://huggingface.co/docs/accelerate/main/en/usage_guides/deepspeed" rel="nofollow">🤗 Accelerate</a>',Vi,Ct,tr="Other approaches:",Ai,_t,lr='DeepSpeed, Varuna and SageMaker use the concept of an <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-parallel-core-features.html" rel="nofollow">Interleaved Pipeline</a>',Qi,H,sr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-sagemaker-interleaved-pipeline.png" alt="Interleaved pipeline execution"/>',Ri,Ut,ir=`Here the bubble (idle time) is further minimized by prioritizing backward passes. Varuna further attempts to improve the
schedule by using simulations to discover the most efficient scheduling.`,zi,$t,nr="OSLO has pipeline parallelism implementation based on the Transformers without <code>nn.Sequential</code> conversion.",Bi,Lt,Fi,jt,ar=`In Tensor Parallelism, each GPU processes a slice of a tensor and only aggregates the full tensor for operations requiring it.
To describe this method, this section of the guide relies on the concepts and diagrams from the <a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a>
paper: <a href="https://arxiv.org/abs/2104.04473" rel="nofollow">Efficient Large-Scale Language Model Training on GPU Clusters</a>.`,Wi,Dt,or=`The main building block of any transformer is a fully connected <code>nn.Linear</code> followed by a nonlinear activation <code>GeLU</code>.
The dot dot-product part of it, following the Megatron’s paper notation, can be written as <code>Y = GeLU(XA)</code>, where <code>X</code> is
an input vector, <code>Y</code> is the output vector, and <code>A</code> is the weight matrix.`,Zi,Ht,rr="If we look at the computation in matrix form, you can see how the matrix multiplication can be split between multiple GPUs:",Xi,G,pr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_gemm.png" alt="Parallel GEMM"/>',Oi,Gt,hr=`If we split the weight matrix <code>A</code> column-wise across <code>N</code> GPUs and perform matrix multiplications <code>XA_1</code> through <code>XA_n</code> in parallel,
then we will end up with <code>N</code> output vectors <code>Y_1, Y_2, ..., Y_n</code> which can be fed into <code>GeLU</code> independently:`,qi,J,mr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-independent-gelu.png" alt="Independent GeLU"/>',Yi,Jt,fr=`Using this principle, we can update a multi-layer perceptron of arbitrary depth, without the need for any synchronization
between GPUs until the very end, where we need to reconstruct the output vector from shards. The Megatron-LM paper authors
provide a helpful illustration for that:`,Ki,I,ur='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_shard_processing.png" alt="Parallel shard processing"/>',en,It,cr=`Parallelizing the multi-headed attention layers is even simpler, since they are already inherently parallel, due to having
multiple independent heads!`,tn,k,dr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_self_attention.png" alt="Parallel self-attention"/>',ln,kt,vr=`Special considerations: TP requires very fast network, and therefore it’s not advisable to do TP across more than one node.
Practically, if a node has 4 GPUs, the highest TP degree is therefore 4. If you need a TP degree of 8, you need to use
nodes that have at least 8 GPUs.`,sn,Et,wr=`This section is based on the original much more <a href="https://github.com/huggingface/transformers/issues/10321#issuecomment-783543530" rel="nofollow">detailed TP overview</a>.
by <a href="https://github.com/anton-l" rel="nofollow">@anton-l</a>.`,nn,St,gr="Alternative names:",an,Nt,Pr='<li>DeepSpeed calls it <a href="https://www.deepspeed.ai/training/#model-parallelism" rel="nofollow">tensor slicing</a></li>',on,Vt,yr="Implementations:",rn,At,Mr='<li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> has an internal implementation, as it’s very model-specific</li> <li><a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a> (only inference at the moment)</li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - this is a proprietary solution that can only be used on AWS.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a> has the tensor parallelism implementation based on the Transformers.</li>',pn,Qt,Tr="SageMaker combines TP with DP for a more efficient processing.",hn,Rt,br="🤗 Transformers status:",mn,zt,xr='<li>core: not yet implemented in the core</li> <li>but if you want inference <a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a> provides this support for most of our models. So until this is implemented in the core you can use theirs. And hopefully training mode will be supported too.</li> <li>Deepspeed-Inference also supports our BERT, GPT-2, and GPT-Neo models in their super-fast CUDA-kernel-based inference mode, see more <a href="https://www.deepspeed.ai/tutorials/inference-tutorial/" rel="nofollow">here</a></li>',fn,Bt,Cr='🤗 Accelerate integrates with <a href="https://huggingface.co/docs/accelerate/v0.23.0/en/usage_guides/megatron_lm" rel="nofollow">TP from Megatron-LM</a>.',un,Ft,cn,Wt,_r=`The following diagram from the DeepSpeed <a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">pipeline tutorial</a> demonstrates
how one can combine DP with PP.`,dn,E,Ur='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero-dp-pp.png" alt="DP + PP-2d"/>',vn,Zt,$r=`Here it’s important to see how DP rank 0 doesn’t see GPU2 and DP rank 1 doesn’t see GPU3. To DP there is just GPUs 0
and 1 where it feeds data as if there were just 2 GPUs. GPU0 “secretly” offloads some of its load to GPU2 using PP.
And GPU1 does the same by enlisting GPU3 to its aid.`,wn,Xt,Lr="Since each dimension requires at least 2 GPUs, here you’d need at least 4 GPUs.",gn,Ot,jr="Implementations:",Pn,qt,Dr='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',yn,Yt,Hr="🤗 Transformers status: not yet implemented",Mn,Kt,Tn,el,Gr="To get an even more efficient training a 3D parallelism is used where PP is combined with TP and DP. This can be seen in the following diagram.",bn,S,Jr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-deepspeed-3d.png" alt="dp-pp-tp-3d"/>',xn,tl,Ir='This diagram is from a blog post <a href="https://www.microsoft.com/en-us/research/blog/deepspeed-extreme-scale-model-training-for-everyone/" rel="nofollow">3D parallelism: Scaling to trillion-parameter models</a>, which is a good read as well.',Cn,ll,kr="Since each dimension requires at least 2 GPUs, here you’d need at least 8 GPUs.",_n,sl,Er="Implementations:",Un,il,Sr='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> - DeepSpeed also includes an even more efficient DP, which they call ZeRO-DP.</li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',$n,nl,Nr="🤗 Transformers status: not yet implemented, since we have no PP and TP.",Ln,al,jn,ol,Vr=`One of the main features of DeepSpeed is ZeRO, which is a super-scalable extension of DP. It has already been
discussed in <a href="#zero-data-parallelism">ZeRO Data Parallelism</a>. Normally it’s a standalone feature that doesn’t require PP or TP.
But it can be combined with PP and TP.`,Dn,rl,Ar="When ZeRO-DP is combined with PP (and optionally TP) it typically enables only ZeRO stage 1 (optimizer sharding).",Hn,pl,Qr=`While it’s theoretically possible to use ZeRO stage 2 (gradient sharding) with Pipeline Parallelism, it will have negative
performance impacts. There would need to be an additional reduce-scatter collective for every micro-batch to aggregate
the gradients before sharding, which adds a potentially significant communication overhead. By nature of Pipeline Parallelism,
small micro-batches are used and instead the focus is on trying to balance arithmetic intensity (micro-batch size) with
minimizing the Pipeline bubble (number of micro-batches). Therefore those communication costs are going to impact the performance.`,Gn,hl,Rr=`In addition, there are already fewer layers than normal due to PP and so the memory savings won’t be huge. PP already
reduces gradient size by <code>1/PP</code>, and so gradient sharding savings on top of that are less significant than pure DP.`,Jn,ml,zr="ZeRO stage 3 is not a good choice either for the same reason - more inter-node communications required.",In,fl,Br="And since we have ZeRO, the other benefit is ZeRO-Offload. Since this is stage 1 optimizer states can be offloaded to CPU.",kn,ul,Fr="Implementations:",En,cl,Wr='<li><a href="https://github.com/microsoft/Megatron-DeepSpeed" rel="nofollow">Megatron-DeepSpeed</a> and <a href="https://github.com/bigscience-workshop/Megatron-DeepSpeed" rel="nofollow">Megatron-Deepspeed from BigScience</a>, which is the fork of the former repo.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',Sn,dl,Zr="Important papers:",Nn,vl,Xr='<li><a href="https://arxiv.org/abs/2201.11990" rel="nofollow">Using DeepSpeed and Megatron to Train Megatron-Turing NLG 530B, A Large-Scale Generative Language Model</a></li>',Vn,wl,Or="🤗 Transformers status: not yet implemented, since we have no PP and TP.",An,gl,Qn,Pl,qr='<a href="https://github.com/flexflow/FlexFlow" rel="nofollow">FlexFlow</a> also solves the parallelization problem in a slightly different approach.',Rn,yl,Yr='Paper: <a href="https://arxiv.org/abs/1807.05358" rel="nofollow">“Beyond Data and Model Parallelism for Deep Neural Networks” by Zhihao Jia, Matei Zaharia, Alex Aiken</a>',zn,Ml,Kr="It performs a sort of 4D Parallelism over Sample-Operator-Attribute-Parameter.",Bn,Tl,ep="<li>Sample = Data Parallelism (sample-wise parallel)</li> <li>Operator = Parallelize a single operation into several sub-operations</li> <li>Attribute = Data Parallelism (length-wise parallel)</li> <li>Parameter = Model Parallelism (regardless of dimension - horizontal or vertical)</li>",Fn,bl,tp="Examples:",Wn,xl,lp="<li>Sample</li>",Zn,Cl,sp="Let’s take 10 batches of sequence length 512. If we parallelize them by sample dimension into 2 devices, we get 10 x 512 which becomes be 5 x 2 x 512.",Xn,_l,ip="<li>Operator</li>",On,Ul,np=`If we perform layer normalization, we compute std first and mean second, and then we can normalize data.
Operator parallelism allows computing std and mean in parallel. So if we parallelize them by operator dimension into 2
devices (cuda:0, cuda:1), first we copy input data into both devices, and cuda:0 computes std, cuda:1 computes mean at the same time.`,qn,$l,ap="<li>Attribute</li>",Yn,Ll,op="We have 10 batches of 512 length. If we parallelize them by attribute dimension into 2 devices, 10 x 512 will be 10 x 2 x 256.",Kn,jl,rp="<li>Parameter</li>",ea,Dl,pp="It is similar with tensor model parallelism or naive layer-wise model parallelism.",ta,N,hp='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-flexflow.jpeg" alt="flex-flow-soap"/>',la,Hl,mp=`The significance of this framework is that it takes resources like (1) GPU/TPU/CPU vs. (2) RAM/DRAM vs. (3)
fast-intra-connect/slow-inter-connect and it automatically optimizes all these algorithmically deciding which
parallelisation to use where.`,sa,Gl,fp=`One very important aspect is that FlexFlow is designed for optimizing DNN parallelizations for models with static and
fixed workloads, since models with dynamic behavior may prefer different parallelization strategies across iterations.`,ia,Jl,up=`So the promise is very attractive - it runs a 30min simulation on the cluster of choice and it comes up with the best
strategy to utilise this specific environment. If you add/remove/replace any parts it’ll run and re-optimize the plan
for that. And then you can train. A different setup will have its own custom optimization.`,na,Il,cp=`🤗 Transformers status: Transformers models are FX-trace-able via <a href="https://github.com/huggingface/transformers/blob/master/src/transformers/utils/fx.py" rel="nofollow">transformers.utils.fx</a>,
which is a prerequisite for FlexFlow, however, changes are required on the FlexFlow side to make it work with Transformers models.`,aa,kl,oa,El,dp='When training on multiple GPUs, you can specify the number of GPUs to use and in what order. This can be useful for instance when you have GPUs with different computing power and want to use the faster GPU first. The selection process works for both <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html" rel="nofollow">DistributedDataParallel</a> and <a href="https://pytorch.org/docs/stable/generated/torch.nn.DataParallel.html" rel="nofollow">DataParallel</a> to use only a subset of the available GPUs, and you don’t need Accelerate or the <a href="./main_classes/deepspeed">DeepSpeed integration</a>.',ra,Sl,pa,Nl,vp="For example, if you have 4 GPUs and you only want to use the first 2:",ha,V,ma,Vl,fa,Al,wp="Now, to select which GPUs to use and their order, you’ll use the <code>CUDA_VISIBLE_DEVICES</code> environment variable. It is easiest to set the environment variable in a <code>~/bashrc</code> or another startup config file. <code>CUDA_VISIBLE_DEVICES</code> is used to map which GPUs are used. For example, if you have 4 GPUs (0, 1, 2, 3) and you only want to run GPUs 0 and 2:",ua,Ql,ca,Rl,gp="Only the 2 physical GPUs (0 and 2) are “visible” to PyTorch and these are mapped to <code>cuda:0</code> and <code>cuda:1</code> respectively. You can also reverse the order of the GPUs to use 2 first. Now, the mapping is <code>cuda:1</code> for GPU 0 and <code>cuda:0</code> for GPU 2.",da,zl,va,Bl,Pp="You can also set the <code>CUDA_VISIBLE_DEVICES</code> environment variable to an empty value to create an environment without GPUs.",wa,Fl,ga,A,Pa,Wl,yp="<code>CUDA_DEVICE_ORDER</code> is an alternative environment variable you can use to control how the GPUs are ordered. You can either order them by:",ya,Zl,Mp='<li>PCIe bus ID’s that matches the order of <a href="https://developer.nvidia.com/nvidia-system-management-interface" rel="nofollow"><code>nvidia-smi</code></a> and <a href="https://rocm.docs.amd.com/projects/rocm_smi_lib/en/latest/.doxygen/docBin/html/index.html" rel="nofollow"><code>rocm-smi</code></a> for NVIDIA and AMD GPUs respectively</li>',Ma,Xl,Ta,Q,Tp="<li>GPU compute ability</li>",ba,Ol,xa,ql,bp="The <code>CUDA_DEVICE_ORDER</code> is especially useful if your training setup consists of an older and newer GPU, where the older GPU appears first, but you cannot physically swap the cards to make the newer GPU appear first. In this case, set <code>CUDA_DEVICE_ORDER=FASTEST_FIRST</code> to always use the newer and faster GPU first (<code>nvidia-smi</code> or <code>rocm-smi</code> still reports the GPUs in their PCIe order). Or you could also set <code>export CUDA_VISIBLE_DEVICES=1,0</code>.",Ca,es,_a;return y=new C({props:{title:"Efficient Training on Multiple GPUs",local:"efficient-training-on-multiple-gpus",headingTag:"h1"}}),$=new Ua({props:{$$slots:{default:[kp]},$$scope:{ctx:T}}}),F=new C({props:{title:"Scalability strategy",local:"scalability-strategy",headingTag:"h2"}}),pe=new C({props:{title:"Data Parallelism",local:"data-parallelism",headingTag:"h2"}}),me=new C({props:{title:"DataParallel vs DistributedDataParallel",local:"dataparallel-vs-distributeddataparallel",headingTag:"h3"}}),_e=new x({props:{code:"cm0lMjAtciUyMCUyRnRtcCUyRnRlc3QtY2xtJTNCJTIwQ1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTJDMSUyMCU1QyUwQXB5dGhvbiUyMGV4YW1wbGVzJTJGcHl0b3JjaCUyRmxhbmd1YWdlLW1vZGVsaW5nJTJGcnVuX2NsbS5weSUyMCU1QyUwQS0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwZ3B0MiUyMC0tZGF0YXNldF9uYW1lJTIwd2lraXRleHQlMjAtLWRhdGFzZXRfY29uZmlnX25hbWUlMjB3aWtpdGV4dC0yLXJhdy12MSUyMCU1QyUwQS0tZG9fdHJhaW4lMjAtLW91dHB1dF9kaXIlMjAlMkZ0bXAlMkZ0ZXN0LWNsbSUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwNCUyMC0tbWF4X3N0ZXBzJTIwMjAwJTBBJTBBJTdCJ3RyYWluX3J1bnRpbWUnJTNBJTIwMTEwLjU5NDglMkMlMjAndHJhaW5fc2FtcGxlc19wZXJfc2Vjb25kJyUzQSUyMDEuODA4JTJDJTIwJ2Vwb2NoJyUzQSUyMDAuNjklN0Q=",highlighted:`<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">python</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">110</span>.<span class="hljs-string">5948</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">808</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}`,wrap:!1}}),$e=new x({props:{code:"cm0lMjAtciUyMCUyRnRtcCUyRnRlc3QtY2xtJTNCJTIwQ1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTJDMSUyMCU1QyUwQXRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUyMDIlMjBleGFtcGxlcyUyRnB5dG9yY2glMkZsYW5ndWFnZS1tb2RlbGluZyUyRnJ1bl9jbG0ucHklMjAlNUMlMEEtLW1vZGVsX25hbWVfb3JfcGF0aCUyMGdwdDIlMjAtLWRhdGFzZXRfbmFtZSUyMHdpa2l0ZXh0JTIwLS1kYXRhc2V0X2NvbmZpZ19uYW1lJTIwd2lraXRleHQtMi1yYXctdjElMjAlNUMlMEEtLWRvX3RyYWluJTIwLS1vdXRwdXRfZGlyJTIwJTJGdG1wJTJGdGVzdC1jbG0lMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDQlMjAtLW1heF9zdGVwcyUyMDIwMCUwQSUwQSU3Qid0cmFpbl9ydW50aW1lJyUzQSUyMDEwMS45MDAzJTJDJTIwJ3RyYWluX3NhbXBsZXNfcGVyX3NlY29uZCclM0ElMjAxLjk2MyUyQyUyMCdlcG9jaCclM0ElMjAwLjY5JTdE",highlighted:`<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">torchrun</span> <span class="hljs-built_in">--nproc_per_node</span> <span class="hljs-string">2</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">101</span>.<span class="hljs-string">9003</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">963</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}`,wrap:!1}}),je=new x({props:{code:"cm0lMjAtciUyMCUyRnRtcCUyRnRlc3QtY2xtJTNCJTIwTkNDTF9QMlBfRElTQUJMRSUzRDElMjBDVURBX1ZJU0lCTEVfREVWSUNFUyUzRDAlMkMxJTIwJTVDJTBBdG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTIwMiUyMGV4YW1wbGVzJTJGcHl0b3JjaCUyRmxhbmd1YWdlLW1vZGVsaW5nJTJGcnVuX2NsbS5weSUyMCU1QyUwQS0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwZ3B0MiUyMC0tZGF0YXNldF9uYW1lJTIwd2lraXRleHQlMjAtLWRhdGFzZXRfY29uZmlnX25hbWUlMjB3aWtpdGV4dC0yLXJhdy12MSUyMCU1QyUwQS0tZG9fdHJhaW4lMjAtLW91dHB1dF9kaXIlMjAlMkZ0bXAlMkZ0ZXN0LWNsbSUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwNCUyMC0tbWF4X3N0ZXBzJTIwMjAwJTBBJTBBJTdCJ3RyYWluX3J1bnRpbWUnJTNBJTIwMTMxLjQzNjclMkMlMjAndHJhaW5fc2FtcGxlc19wZXJfc2Vjb25kJyUzQSUyMDEuNTIyJTJDJTIwJ2Vwb2NoJyUzQSUyMDAuNjklN0Q=",highlighted:`<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">NCCL_P2P_DISABLE</span>=<span class="hljs-string">1</span> <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">torchrun</span> <span class="hljs-built_in">--nproc_per_node</span> <span class="hljs-string">2</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">131</span>.<span class="hljs-string">4367</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">522</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}`,wrap:!1}}),Je=new C({props:{title:"ZeRO Data Parallelism",local:"zero-data-parallelism",headingTag:"h2"}}),Se=new x({props:{code:"TGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWEwJTIwJTdDJTIwYjAlMjAlN0MlMjBjMCUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQWEyJTIwJTdDJTIwYjIlMjAlN0MlMjBjMg==",highlighted:`La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),Ve=new x({props:{code:"R1BVMCUzQSUwQUxhJTIwJTdDJTIwTGIlMjAlN0MlMjBMYyUwQS0tLSU3Qy0tLS0lN0MtLS0lMEFhMCUyMCU3QyUyMGIwJTIwJTdDJTIwYzAlMEElMEFHUFUxJTNBJTBBTGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQSUwQUdQVTIlM0ElMEFMYSUyMCU3QyUyMExiJTIwJTdDJTIwTGMlMEEtLS0lN0MtLS0tJTdDLS0tJTBBYTIlMjAlN0MlMjBiMiUyMCU3QyUyMGMy",highlighted:`GPU0:
La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0

GPU1:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1

GPU2:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),Re=new x({props:{code:"eDAlMjAlM0QlM0UlMjBHUFUwJTBBeDElMjAlM0QlM0UlMjBHUFUxJTBBeDIlMjAlM0QlM0UlMjBHUFUy",highlighted:`<span class="hljs-attribute">x0</span> <span class="hljs-operator">=</span>&gt; GPU0
<span class="hljs-attribute">x1</span> <span class="hljs-operator">=</span>&gt; GPU1
<span class="hljs-attribute">x2</span> <span class="hljs-operator">=</span>&gt; GPU2`,wrap:!1}}),j=new Ua({props:{$$slots:{default:[Ep]},$$scope:{ctx:T}}}),Ke=new C({props:{title:"From Naive Model Parallelism to Pipeline Parallelism",local:"from-naive-model-parallelism-to-pipeline-parallelism",headingTag:"h2"}}),lt=new x({props:{code:"JTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIwJTIwJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTBBJTdDJTIwJTIwMCUyMCU3QyUyMDElMjAlN0MlMjAyJTIwJTdDJTIwMyUyMCUyMCU3QyUyMCUyMCU3QyUyMCUyMDQlMjAlN0MlMjA1JTIwJTdDJTIwNiUyMCU3QyUyMDclMjAlMjAlN0MlMEElM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMjAlMjAlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBHUFUwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwR1BVMQ==",highlighted:`===================  ===================
|<span class="hljs-string">  0 </span>|<span class="hljs-string"> 1 </span>|<span class="hljs-string"> 2 </span>|<span class="hljs-string"> 3  </span>|<span class="hljs-string">  </span>|<span class="hljs-string">  4 </span>|<span class="hljs-string"> 5 </span>|<span class="hljs-string"> 6 </span>|<span class="hljs-string"> 7  </span>|
===================  ===================
        GPU0                 GPU1`,wrap:!1}}),Lt=new C({props:{title:"Tensor Parallelism",local:"tensor-parallelism",headingTag:"h2"}}),Ft=new C({props:{title:"Data Parallelism + Pipeline Parallelism",local:"data-parallelism--pipeline-parallelism",headingTag:"h2"}}),Kt=new C({props:{title:"Data Parallelism + Pipeline Parallelism + Tensor Parallelism",local:"data-parallelism--pipeline-parallelism--tensor-parallelism",headingTag:"h2"}}),al=new C({props:{title:"ZeRO Data Parallelism + Pipeline Parallelism + Tensor Parallelism",local:"zero-data-parallelism--pipeline-parallelism--tensor-parallelism",headingTag:"h2"}}),gl=new C({props:{title:"FlexFlow",local:"flexflow",headingTag:"h2"}}),kl=new C({props:{title:"GPU selection",local:"gpu-selection",headingTag:"h2"}}),Sl=new C({props:{title:"Number of GPUs",local:"number-of-gpus",headingTag:"h3"}}),V=new Ip({props:{id:"select-gpu",options:["torchrun","Accelerate","DeepSpeed"],$$slots:{default:[Ap]},$$scope:{ctx:T}}}),Vl=new C({props:{title:"Order of GPUs",local:"order-of-gpus",headingTag:"h3"}}),Ql=new x({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTJDMiUyMHRvcmNocnVuJTIwdHJhaW5lci1wcm9ncmFtLnB5JTIwLi4u",highlighted:"CUDA_VISIBLE_DEVICES=0,2 torchrun trainer-program.py ...",wrap:!1}}),zl=new x({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QyJTJDMCUyMHRvcmNocnVuJTIwdHJhaW5lci1wcm9ncmFtLnB5JTIwLi4u",highlighted:"CUDA_VISIBLE_DEVICES=2,0 torchrun trainer-program.py ...",wrap:!1}}),Fl=new x({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QlMjBweXRob24lMjB0cmFpbmVyLXByb2dyYW0ucHklMjAuLi4=",highlighted:"CUDA_VISIBLE_DEVICES= python trainer-program.py ...",wrap:!1}}),A=new Ua({props:{warning:!0,$$slots:{default:[Qp]},$$scope:{ctx:T}}}),Xl=new x({props:{code:"ZXhwb3J0JTIwQ1VEQV9ERVZJQ0VfT1JERVIlM0RQQ0lfQlVTX0lE",highlighted:'<span class="hljs-built_in">export</span> CUDA_DEVICE_ORDER=PCI_BUS_ID',wrap:!1}}),Ol=new x({props:{code:"ZXhwb3J0JTIwQ1VEQV9ERVZJQ0VfT1JERVIlM0RGQVNURVNUX0ZJUlNU",highlighted:'<span class="hljs-built_in">export</span> CUDA_DEVICE_ORDER=FASTEST_FIRST',wrap:!1}}),{c(){p=a("meta"),M=i(),f=a("p"),u=i(),c(y.$$.fragment),h=i(),m=a("p"),m.innerHTML=b,R=i(),U=a("p"),U.textContent=Kl,ts=i(),z=a("p"),z.innerHTML=La,ls=i(),c($.$$.fragment),ss=i(),B=a("p"),B.textContent=ja,is=i(),c(F.$$.fragment),ns=i(),W=a("p"),W.innerHTML=Da,as=i(),Z=a("p"),Z.innerHTML=Ha,os=i(),X=a("p"),X.textContent=Ga,rs=i(),O=a("p"),O.innerHTML=Ja,ps=i(),q=a("p"),q.textContent=Ia,hs=i(),Y=a("ol"),Y.innerHTML=ka,ms=i(),K=a("p"),K.innerHTML=Ea,fs=i(),ee=a("p"),ee.textContent=Sa,us=i(),te=a("ol"),te.innerHTML=Na,cs=i(),le=a("p"),le.textContent=Va,ds=i(),se=a("p"),se.textContent=Aa,vs=i(),ie=a("p"),ie.innerHTML=Qa,ws=i(),ne=a("ol"),ne.innerHTML=Ra,gs=i(),ae=a("p"),ae.innerHTML=za,Ps=i(),oe=a("ul"),oe.innerHTML=Ba,ys=i(),re=a("p"),re.textContent=Fa,Ms=i(),c(pe.$$.fragment),Ts=i(),he=a("p"),he.innerHTML=Wa,bs=i(),c(me.$$.fragment),xs=i(),fe=a("p"),fe.textContent=Za,Cs=i(),ue=a("p"),ue.innerHTML=Xa,_s=i(),ce=a("ul"),ce.innerHTML=Oa,Us=i(),de=a("p"),de.innerHTML=qa,$s=i(),ve=a("p"),ve.textContent=Ya,Ls=i(),we=a("ol"),we.innerHTML=Ka,js=i(),ge=a("p"),ge.textContent=eo,Ds=i(),Pe=a("ol"),Pe.innerHTML=to,Hs=i(),ye=a("p"),ye.innerHTML=lo,Gs=i(),Me=a("p"),Me.textContent=so,Js=i(),Te=a("ul"),Te.innerHTML=io,Is=i(),be=a("p"),be.innerHTML=no,ks=i(),xe=a("p"),xe.textContent=ao,Es=i(),Ce=a("p"),Ce.innerHTML=oo,Ss=i(),c(_e.$$.fragment),Ns=i(),Ue=a("p"),Ue.innerHTML=ro,Vs=i(),c($e.$$.fragment),As=i(),Le=a("p"),Le.innerHTML=po,Qs=i(),c(je.$$.fragment),Rs=i(),De=a("p"),De.textContent=ho,zs=i(),He=a("table"),He.innerHTML=mo,Bs=i(),Ge=a("p"),Ge.textContent=fo,Fs=i(),c(Je.$$.fragment),Ws=i(),Ie=a("p"),Ie.innerHTML=uo,Zs=i(),L=a("div"),L.innerHTML=co,Xs=i(),ke=a("p"),ke.innerHTML=vo,Os=i(),Ee=a("p"),Ee.textContent=wo,qs=i(),c(Se.$$.fragment),Ys=i(),Ne=a("p"),Ne.textContent=go,Ks=i(),c(Ve.$$.fragment),ei=i(),Ae=a("p"),Ae.textContent=Po,ti=i(),Qe=a("p"),Qe.textContent=yo,li=i(),c(Re.$$.fragment),si=i(),ze=a("p"),ze.textContent=Mo,ii=i(),Be=a("p"),Be.innerHTML=To,ni=i(),Fe=a("p"),Fe.textContent=bo,ai=i(),We=a("p"),We.textContent=xo,oi=i(),Ze=a("p"),Ze.textContent=Co,ri=i(),Xe=a("p"),Xe.textContent=_o,pi=i(),c(j.$$.fragment),hi=i(),Oe=a("p"),Oe.textContent=Uo,mi=i(),qe=a("p"),qe.textContent=$o,fi=i(),Ye=a("ul"),Ye.innerHTML=Lo,ui=i(),c(Ke.$$.fragment),ci=i(),et=a("p"),et.innerHTML=jo,di=i(),tt=a("p"),tt.textContent=Do,vi=i(),c(lt.$$.fragment),wi=i(),st=a("p"),st.textContent=Ho,gi=i(),it=a("p"),it.textContent=Go,Pi=i(),nt=a("p"),nt.textContent=Jo,yi=i(),at=a("ul"),at.innerHTML=Io,Mi=i(),ot=a("p"),ot.textContent=ko,Ti=i(),rt=a("p"),rt.innerHTML=Eo,bi=i(),D=a("div"),D.innerHTML=So,xi=i(),pt=a("p"),pt.textContent=No,Ci=i(),ht=a("p"),ht.innerHTML=Vo,_i=i(),mt=a("p"),mt.innerHTML=Ao,Ui=i(),ft=a("p"),ft.innerHTML=Qo,$i=i(),ut=a("p"),ut.innerHTML=Ro,Li=i(),ct=a("p"),ct.textContent=zo,ji=i(),dt=a("ul"),dt.innerHTML=Bo,Di=i(),vt=a("p"),vt.textContent=Fo,Hi=i(),wt=a("ul"),wt.innerHTML=Wo,Gi=i(),gt=a("p"),gt.textContent=Zo,Ji=i(),Pt=a("ul"),Pt.innerHTML=Xo,Ii=i(),yt=a("p"),yt.textContent=Oo,ki=i(),Mt=a("p"),Mt.textContent=qo,Ei=i(),Tt=a("ul"),Tt.innerHTML=Yo,Si=i(),bt=a("p"),bt.innerHTML=Ko,Ni=i(),xt=a("p"),xt.innerHTML=er,Vi=i(),Ct=a("p"),Ct.textContent=tr,Ai=i(),_t=a("p"),_t.innerHTML=lr,Qi=i(),H=a("div"),H.innerHTML=sr,Ri=i(),Ut=a("p"),Ut.textContent=ir,zi=i(),$t=a("p"),$t.innerHTML=nr,Bi=i(),c(Lt.$$.fragment),Fi=i(),jt=a("p"),jt.innerHTML=ar,Wi=i(),Dt=a("p"),Dt.innerHTML=or,Zi=i(),Ht=a("p"),Ht.textContent=rr,Xi=i(),G=a("div"),G.innerHTML=pr,Oi=i(),Gt=a("p"),Gt.innerHTML=hr,qi=i(),J=a("div"),J.innerHTML=mr,Yi=i(),Jt=a("p"),Jt.textContent=fr,Ki=i(),I=a("div"),I.innerHTML=ur,en=i(),It=a("p"),It.textContent=cr,tn=i(),k=a("div"),k.innerHTML=dr,ln=i(),kt=a("p"),kt.textContent=vr,sn=i(),Et=a("p"),Et.innerHTML=wr,nn=i(),St=a("p"),St.textContent=gr,an=i(),Nt=a("ul"),Nt.innerHTML=Pr,on=i(),Vt=a("p"),Vt.textContent=yr,rn=i(),At=a("ul"),At.innerHTML=Mr,pn=i(),Qt=a("p"),Qt.textContent=Tr,hn=i(),Rt=a("p"),Rt.textContent=br,mn=i(),zt=a("ul"),zt.innerHTML=xr,fn=i(),Bt=a("p"),Bt.innerHTML=Cr,un=i(),c(Ft.$$.fragment),cn=i(),Wt=a("p"),Wt.innerHTML=_r,dn=i(),E=a("div"),E.innerHTML=Ur,vn=i(),Zt=a("p"),Zt.textContent=$r,wn=i(),Xt=a("p"),Xt.textContent=Lr,gn=i(),Ot=a("p"),Ot.textContent=jr,Pn=i(),qt=a("ul"),qt.innerHTML=Dr,yn=i(),Yt=a("p"),Yt.textContent=Hr,Mn=i(),c(Kt.$$.fragment),Tn=i(),el=a("p"),el.textContent=Gr,bn=i(),S=a("div"),S.innerHTML=Jr,xn=i(),tl=a("p"),tl.innerHTML=Ir,Cn=i(),ll=a("p"),ll.textContent=kr,_n=i(),sl=a("p"),sl.textContent=Er,Un=i(),il=a("ul"),il.innerHTML=Sr,$n=i(),nl=a("p"),nl.textContent=Nr,Ln=i(),c(al.$$.fragment),jn=i(),ol=a("p"),ol.innerHTML=Vr,Dn=i(),rl=a("p"),rl.textContent=Ar,Hn=i(),pl=a("p"),pl.textContent=Qr,Gn=i(),hl=a("p"),hl.innerHTML=Rr,Jn=i(),ml=a("p"),ml.textContent=zr,In=i(),fl=a("p"),fl.textContent=Br,kn=i(),ul=a("p"),ul.textContent=Fr,En=i(),cl=a("ul"),cl.innerHTML=Wr,Sn=i(),dl=a("p"),dl.textContent=Zr,Nn=i(),vl=a("ul"),vl.innerHTML=Xr,Vn=i(),wl=a("p"),wl.textContent=Or,An=i(),c(gl.$$.fragment),Qn=i(),Pl=a("p"),Pl.innerHTML=qr,Rn=i(),yl=a("p"),yl.innerHTML=Yr,zn=i(),Ml=a("p"),Ml.textContent=Kr,Bn=i(),Tl=a("ol"),Tl.innerHTML=ep,Fn=i(),bl=a("p"),bl.textContent=tp,Wn=i(),xl=a("ul"),xl.innerHTML=lp,Zn=i(),Cl=a("p"),Cl.textContent=sp,Xn=i(),_l=a("ul"),_l.innerHTML=ip,On=i(),Ul=a("p"),Ul.textContent=np,qn=i(),$l=a("ul"),$l.innerHTML=ap,Yn=i(),Ll=a("p"),Ll.textContent=op,Kn=i(),jl=a("ul"),jl.innerHTML=rp,ea=i(),Dl=a("p"),Dl.textContent=pp,ta=i(),N=a("div"),N.innerHTML=hp,la=i(),Hl=a("p"),Hl.textContent=mp,sa=i(),Gl=a("p"),Gl.textContent=fp,ia=i(),Jl=a("p"),Jl.textContent=up,na=i(),Il=a("p"),Il.innerHTML=cp,aa=i(),c(kl.$$.fragment),oa=i(),El=a("p"),El.innerHTML=dp,ra=i(),c(Sl.$$.fragment),pa=i(),Nl=a("p"),Nl.textContent=vp,ha=i(),c(V.$$.fragment),ma=i(),c(Vl.$$.fragment),fa=i(),Al=a("p"),Al.innerHTML=wp,ua=i(),c(Ql.$$.fragment),ca=i(),Rl=a("p"),Rl.innerHTML=gp,da=i(),c(zl.$$.fragment),va=i(),Bl=a("p"),Bl.innerHTML=Pp,wa=i(),c(Fl.$$.fragment),ga=i(),c(A.$$.fragment),Pa=i(),Wl=a("p"),Wl.innerHTML=yp,ya=i(),Zl=a("ol"),Zl.innerHTML=Mp,Ma=i(),c(Xl.$$.fragment),Ta=i(),Q=a("ol"),Q.innerHTML=Tp,ba=i(),c(Ol.$$.fragment),xa=i(),ql=a("p"),ql.innerHTML=bp,Ca=i(),es=a("p"),this.h()},l(e){const t=Gp("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),M=n(e),f=o(e,"P",{}),$p(f).forEach(l),u=n(e),d(y.$$.fragment,e),h=n(e),m=o(e,"P",{"data-svelte-h":!0}),r(m)!=="svelte-pmpw5m"&&(m.innerHTML=b),R=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-6u57b2"&&(U.textContent=Kl),ts=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1fmi0j5"&&(z.innerHTML=La),ls=n(e),d($.$$.fragment,e),ss=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-k4erla"&&(B.textContent=ja),is=n(e),d(F.$$.fragment,e),ns=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-vl1lph"&&(W.innerHTML=Da),as=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-exgbxp"&&(Z.innerHTML=Ha),os=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1ld98nk"&&(X.textContent=Ga),rs=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-owu077"&&(O.innerHTML=Ja),ps=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-108eswe"&&(q.textContent=Ia),hs=n(e),Y=o(e,"OL",{"data-svelte-h":!0}),r(Y)!=="svelte-17djrzw"&&(Y.innerHTML=ka),ms=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1pjlj4x"&&(K.innerHTML=Ea),fs=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1vvmjdr"&&(ee.textContent=Sa),us=n(e),te=o(e,"OL",{"data-svelte-h":!0}),r(te)!=="svelte-1s0wp36"&&(te.innerHTML=Na),cs=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-g99shh"&&(le.textContent=Va),ds=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-bg5rkn"&&(se.textContent=Aa),vs=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1vlifqo"&&(ie.innerHTML=Qa),ws=n(e),ne=o(e,"OL",{"data-svelte-h":!0}),r(ne)!=="svelte-12kjlqq"&&(ne.innerHTML=Ra),gs=n(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-ym8ubp"&&(ae.innerHTML=za),Ps=n(e),oe=o(e,"UL",{"data-svelte-h":!0}),r(oe)!=="svelte-1dtz42n"&&(oe.innerHTML=Ba),ys=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-4bia72"&&(re.textContent=Fa),Ms=n(e),d(pe.$$.fragment,e),Ts=n(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1017dvy"&&(he.innerHTML=Wa),bs=n(e),d(me.$$.fragment,e),xs=n(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1j6eoys"&&(fe.textContent=Za),Cs=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1v8b0bi"&&(ue.innerHTML=Xa),_s=n(e),ce=o(e,"UL",{"data-svelte-h":!0}),r(ce)!=="svelte-ibjm0a"&&(ce.innerHTML=Oa),Us=n(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-2za96j"&&(de.innerHTML=qa),$s=n(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1e3g0sm"&&(ve.textContent=Ya),Ls=n(e),we=o(e,"OL",{"data-svelte-h":!0}),r(we)!=="svelte-n1bojj"&&(we.innerHTML=Ka),js=n(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1yk5hqh"&&(ge.textContent=eo),Ds=n(e),Pe=o(e,"OL",{"data-svelte-h":!0}),r(Pe)!=="svelte-1glndlp"&&(Pe.innerHTML=to),Hs=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-tn8imq"&&(ye.innerHTML=lo),Gs=n(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-196u8fm"&&(Me.textContent=so),Js=n(e),Te=o(e,"UL",{"data-svelte-h":!0}),r(Te)!=="svelte-1p9lena"&&(Te.innerHTML=io),Is=n(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-lyxecx"&&(be.innerHTML=no),ks=n(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1ccu14e"&&(xe.textContent=ao),Es=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1cuy4x"&&(Ce.innerHTML=oo),Ss=n(e),d(_e.$$.fragment,e),Ns=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-ady25n"&&(Ue.innerHTML=ro),Vs=n(e),d($e.$$.fragment,e),As=n(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1bcmt3e"&&(Le.innerHTML=po),Qs=n(e),d(je.$$.fragment,e),Rs=n(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-ammqnu"&&(De.textContent=ho),zs=n(e),He=o(e,"TABLE",{"data-svelte-h":!0}),r(He)!=="svelte-1glyygb"&&(He.innerHTML=mo),Bs=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-3h79hx"&&(Ge.textContent=fo),Fs=n(e),d(Je.$$.fragment,e),Ws=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-rus1tj"&&(Ie.innerHTML=uo),Zs=n(e),L=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(L)!=="svelte-l6ikqh"&&(L.innerHTML=co),Xs=n(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1n0hd1i"&&(ke.innerHTML=vo),Os=n(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-yml45c"&&(Ee.textContent=wo),qs=n(e),d(Se.$$.fragment,e),Ys=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-ycp41i"&&(Ne.textContent=go),Ks=n(e),d(Ve.$$.fragment,e),ei=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-vhaef9"&&(Ae.textContent=Po),ti=n(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-v79p4j"&&(Qe.textContent=yo),li=n(e),d(Re.$$.fragment,e),si=n(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1x8bz4m"&&(ze.textContent=Mo),ii=n(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-9s70m2"&&(Be.innerHTML=To),ni=n(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-18avb09"&&(Fe.textContent=bo),ai=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-ptnnl0"&&(We.textContent=xo),oi=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1e42x7e"&&(Ze.textContent=Co),ri=n(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1qw37a5"&&(Xe.textContent=_o),pi=n(e),d(j.$$.fragment,e),hi=n(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-3x8lv3"&&(Oe.textContent=Uo),mi=n(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1b2mzqh"&&(qe.textContent=$o),fi=n(e),Ye=o(e,"UL",{"data-svelte-h":!0}),r(Ye)!=="svelte-a0zshu"&&(Ye.innerHTML=Lo),ui=n(e),d(Ke.$$.fragment,e),ci=n(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-byke96"&&(et.innerHTML=jo),di=n(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-kfubqe"&&(tt.textContent=Do),vi=n(e),d(lt.$$.fragment,e),wi=n(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-vd21sy"&&(st.textContent=Ho),gi=n(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-vjztmh"&&(it.textContent=Go),Pi=n(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1l6dgyv"&&(nt.textContent=Jo),yi=n(e),at=o(e,"UL",{"data-svelte-h":!0}),r(at)!=="svelte-19omdeq"&&(at.innerHTML=Io),Mi=n(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1yzyde0"&&(ot.textContent=ko),Ti=n(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1lu2bt6"&&(rt.innerHTML=Eo),bi=n(e),D=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(D)!=="svelte-1zwet4"&&(D.innerHTML=So),xi=n(e),pt=o(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-10mywh3"&&(pt.textContent=No),Ci=n(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-qcenct"&&(ht.innerHTML=Vo),_i=n(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-q4rot4"&&(mt.innerHTML=Ao),Ui=n(e),ft=o(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1qpt7zo"&&(ft.innerHTML=Qo),$i=n(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1g0sf3v"&&(ut.innerHTML=Ro),Li=n(e),ct=o(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-18mmroz"&&(ct.textContent=zo),ji=n(e),dt=o(e,"UL",{"data-svelte-h":!0}),r(dt)!=="svelte-1m54oo0"&&(dt.innerHTML=Bo),Di=n(e),vt=o(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-3pifdn"&&(vt.textContent=Fo),Hi=n(e),wt=o(e,"UL",{"data-svelte-h":!0}),r(wt)!=="svelte-p13wwf"&&(wt.innerHTML=Wo),Gi=n(e),gt=o(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-5h607a"&&(gt.textContent=Zo),Ji=n(e),Pt=o(e,"UL",{"data-svelte-h":!0}),r(Pt)!=="svelte-n2xihd"&&(Pt.innerHTML=Xo),Ii=n(e),yt=o(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-1xvp26s"&&(yt.textContent=Oo),ki=n(e),Mt=o(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1b2mzqh"&&(Mt.textContent=qo),Ei=n(e),Tt=o(e,"UL",{"data-svelte-h":!0}),r(Tt)!=="svelte-1kewxhh"&&(Tt.innerHTML=Yo),Si=n(e),bt=o(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-zuoye1"&&(bt.innerHTML=Ko),Ni=n(e),xt=o(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-1nopw2u"&&(xt.innerHTML=er),Vi=n(e),Ct=o(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1djad0c"&&(Ct.textContent=tr),Ai=n(e),_t=o(e,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-vnarcr"&&(_t.innerHTML=lr),Qi=n(e),H=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(H)!=="svelte-xyuwxq"&&(H.innerHTML=sr),Ri=n(e),Ut=o(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-19x9s0e"&&(Ut.textContent=ir),zi=n(e),$t=o(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-1q9n35q"&&($t.innerHTML=nr),Bi=n(e),d(Lt.$$.fragment,e),Fi=n(e),jt=o(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1fj06i7"&&(jt.innerHTML=ar),Wi=n(e),Dt=o(e,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-1ktbklq"&&(Dt.innerHTML=or),Zi=n(e),Ht=o(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-250ai3"&&(Ht.textContent=rr),Xi=n(e),G=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(G)!=="svelte-1ugxk60"&&(G.innerHTML=pr),Oi=n(e),Gt=o(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-s73n1q"&&(Gt.innerHTML=hr),qi=n(e),J=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-gpv8h8"&&(J.innerHTML=mr),Yi=n(e),Jt=o(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-1lnmjiw"&&(Jt.textContent=fr),Ki=n(e),I=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(I)!=="svelte-yslb0f"&&(I.innerHTML=ur),en=n(e),It=o(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-8jgntx"&&(It.textContent=cr),tn=n(e),k=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(k)!=="svelte-b5xtwy"&&(k.innerHTML=dr),ln=n(e),kt=o(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-kplhah"&&(kt.textContent=vr),sn=n(e),Et=o(e,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-hmoxa9"&&(Et.innerHTML=wr),nn=n(e),St=o(e,"P",{"data-svelte-h":!0}),r(St)!=="svelte-1ma7lah"&&(St.textContent=gr),an=n(e),Nt=o(e,"UL",{"data-svelte-h":!0}),r(Nt)!=="svelte-p60tn3"&&(Nt.innerHTML=Pr),on=n(e),Vt=o(e,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-1b2mzqh"&&(Vt.textContent=yr),rn=n(e),At=o(e,"UL",{"data-svelte-h":!0}),r(At)!=="svelte-sudg8s"&&(At.innerHTML=Mr),pn=n(e),Qt=o(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-xqarbt"&&(Qt.textContent=Tr),hn=n(e),Rt=o(e,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-1g6ovc1"&&(Rt.textContent=br),mn=n(e),zt=o(e,"UL",{"data-svelte-h":!0}),r(zt)!=="svelte-13k8bts"&&(zt.innerHTML=xr),fn=n(e),Bt=o(e,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-f1rs41"&&(Bt.innerHTML=Cr),un=n(e),d(Ft.$$.fragment,e),cn=n(e),Wt=o(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-1oq9xy9"&&(Wt.innerHTML=_r),dn=n(e),E=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(E)!=="svelte-jbayi"&&(E.innerHTML=Ur),vn=n(e),Zt=o(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-1xg3nfy"&&(Zt.textContent=$r),wn=n(e),Xt=o(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-4rkar7"&&(Xt.textContent=Lr),gn=n(e),Ot=o(e,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-1b2mzqh"&&(Ot.textContent=jr),Pn=n(e),qt=o(e,"UL",{"data-svelte-h":!0}),r(qt)!=="svelte-1ry6c7"&&(qt.innerHTML=Dr),yn=n(e),Yt=o(e,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-9dc2gy"&&(Yt.textContent=Hr),Mn=n(e),d(Kt.$$.fragment,e),Tn=n(e),el=o(e,"P",{"data-svelte-h":!0}),r(el)!=="svelte-fz9fyw"&&(el.textContent=Gr),bn=n(e),S=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(S)!=="svelte-4i6t8z"&&(S.innerHTML=Jr),xn=n(e),tl=o(e,"P",{"data-svelte-h":!0}),r(tl)!=="svelte-18bvwlv"&&(tl.innerHTML=Ir),Cn=n(e),ll=o(e,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-1hp29wn"&&(ll.textContent=kr),_n=n(e),sl=o(e,"P",{"data-svelte-h":!0}),r(sl)!=="svelte-1b2mzqh"&&(sl.textContent=Er),Un=n(e),il=o(e,"UL",{"data-svelte-h":!0}),r(il)!=="svelte-3ic0jq"&&(il.innerHTML=Sr),$n=n(e),nl=o(e,"P",{"data-svelte-h":!0}),r(nl)!=="svelte-r6xwz8"&&(nl.textContent=Nr),Ln=n(e),d(al.$$.fragment,e),jn=n(e),ol=o(e,"P",{"data-svelte-h":!0}),r(ol)!=="svelte-7uwyc9"&&(ol.innerHTML=Vr),Dn=n(e),rl=o(e,"P",{"data-svelte-h":!0}),r(rl)!=="svelte-172u2n6"&&(rl.textContent=Ar),Hn=n(e),pl=o(e,"P",{"data-svelte-h":!0}),r(pl)!=="svelte-mgnvai"&&(pl.textContent=Qr),Gn=n(e),hl=o(e,"P",{"data-svelte-h":!0}),r(hl)!=="svelte-bdt2fr"&&(hl.innerHTML=Rr),Jn=n(e),ml=o(e,"P",{"data-svelte-h":!0}),r(ml)!=="svelte-q3kikv"&&(ml.textContent=zr),In=n(e),fl=o(e,"P",{"data-svelte-h":!0}),r(fl)!=="svelte-s2rtor"&&(fl.textContent=Br),kn=n(e),ul=o(e,"P",{"data-svelte-h":!0}),r(ul)!=="svelte-1b2mzqh"&&(ul.textContent=Fr),En=n(e),cl=o(e,"UL",{"data-svelte-h":!0}),r(cl)!=="svelte-o5zp0z"&&(cl.innerHTML=Wr),Sn=n(e),dl=o(e,"P",{"data-svelte-h":!0}),r(dl)!=="svelte-1grbiex"&&(dl.textContent=Zr),Nn=n(e),vl=o(e,"UL",{"data-svelte-h":!0}),r(vl)!=="svelte-1oyel1u"&&(vl.innerHTML=Xr),Vn=n(e),wl=o(e,"P",{"data-svelte-h":!0}),r(wl)!=="svelte-r6xwz8"&&(wl.textContent=Or),An=n(e),d(gl.$$.fragment,e),Qn=n(e),Pl=o(e,"P",{"data-svelte-h":!0}),r(Pl)!=="svelte-121cfuq"&&(Pl.innerHTML=qr),Rn=n(e),yl=o(e,"P",{"data-svelte-h":!0}),r(yl)!=="svelte-dou7hg"&&(yl.innerHTML=Yr),zn=n(e),Ml=o(e,"P",{"data-svelte-h":!0}),r(Ml)!=="svelte-oa098n"&&(Ml.textContent=Kr),Bn=n(e),Tl=o(e,"OL",{"data-svelte-h":!0}),r(Tl)!=="svelte-6cxs64"&&(Tl.innerHTML=ep),Fn=n(e),bl=o(e,"P",{"data-svelte-h":!0}),r(bl)!=="svelte-kvfsh7"&&(bl.textContent=tp),Wn=n(e),xl=o(e,"UL",{"data-svelte-h":!0}),r(xl)!=="svelte-1734ihx"&&(xl.innerHTML=lp),Zn=n(e),Cl=o(e,"P",{"data-svelte-h":!0}),r(Cl)!=="svelte-jsce61"&&(Cl.textContent=sp),Xn=n(e),_l=o(e,"UL",{"data-svelte-h":!0}),r(_l)!=="svelte-ilmkvr"&&(_l.innerHTML=ip),On=n(e),Ul=o(e,"P",{"data-svelte-h":!0}),r(Ul)!=="svelte-w2gbdo"&&(Ul.textContent=np),qn=n(e),$l=o(e,"UL",{"data-svelte-h":!0}),r($l)!=="svelte-dyjda9"&&($l.innerHTML=ap),Yn=n(e),Ll=o(e,"P",{"data-svelte-h":!0}),r(Ll)!=="svelte-1qwl5bi"&&(Ll.textContent=op),Kn=n(e),jl=o(e,"UL",{"data-svelte-h":!0}),r(jl)!=="svelte-bzftse"&&(jl.innerHTML=rp),ea=n(e),Dl=o(e,"P",{"data-svelte-h":!0}),r(Dl)!=="svelte-pn1yl1"&&(Dl.textContent=pp),ta=n(e),N=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(N)!=="svelte-1jywqo8"&&(N.innerHTML=hp),la=n(e),Hl=o(e,"P",{"data-svelte-h":!0}),r(Hl)!=="svelte-11n85y7"&&(Hl.textContent=mp),sa=n(e),Gl=o(e,"P",{"data-svelte-h":!0}),r(Gl)!=="svelte-13bz10s"&&(Gl.textContent=fp),ia=n(e),Jl=o(e,"P",{"data-svelte-h":!0}),r(Jl)!=="svelte-iohzxv"&&(Jl.textContent=up),na=n(e),Il=o(e,"P",{"data-svelte-h":!0}),r(Il)!=="svelte-so3ryv"&&(Il.innerHTML=cp),aa=n(e),d(kl.$$.fragment,e),oa=n(e),El=o(e,"P",{"data-svelte-h":!0}),r(El)!=="svelte-18jn5v3"&&(El.innerHTML=dp),ra=n(e),d(Sl.$$.fragment,e),pa=n(e),Nl=o(e,"P",{"data-svelte-h":!0}),r(Nl)!=="svelte-1tfztmr"&&(Nl.textContent=vp),ha=n(e),d(V.$$.fragment,e),ma=n(e),d(Vl.$$.fragment,e),fa=n(e),Al=o(e,"P",{"data-svelte-h":!0}),r(Al)!=="svelte-1gq2rbv"&&(Al.innerHTML=wp),ua=n(e),d(Ql.$$.fragment,e),ca=n(e),Rl=o(e,"P",{"data-svelte-h":!0}),r(Rl)!=="svelte-1jed3my"&&(Rl.innerHTML=gp),da=n(e),d(zl.$$.fragment,e),va=n(e),Bl=o(e,"P",{"data-svelte-h":!0}),r(Bl)!=="svelte-waga1j"&&(Bl.innerHTML=Pp),wa=n(e),d(Fl.$$.fragment,e),ga=n(e),d(A.$$.fragment,e),Pa=n(e),Wl=o(e,"P",{"data-svelte-h":!0}),r(Wl)!=="svelte-qvyxrz"&&(Wl.innerHTML=yp),ya=n(e),Zl=o(e,"OL",{"data-svelte-h":!0}),r(Zl)!=="svelte-dqc5mg"&&(Zl.innerHTML=Mp),Ma=n(e),d(Xl.$$.fragment,e),Ta=n(e),Q=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(Q)!=="svelte-7l4syx"&&(Q.innerHTML=Tp),ba=n(e),d(Ol.$$.fragment,e),xa=n(e),ql=o(e,"P",{"data-svelte-h":!0}),r(ql)!=="svelte-xdw23d"&&(ql.innerHTML=bp),Ca=n(e),es=o(e,"P",{}),$p(es).forEach(l),this.h()},h(){_(p,"name","hf:doc:metadata"),_(p,"content",zp),_(L,"class","flex justify-center"),_(D,"class","flex justify-center"),_(H,"class","flex justify-center"),_(G,"class","flex justify-center"),_(J,"class","flex justify-center"),_(I,"class","flex justify-center"),_(k,"class","flex justify-center"),_(E,"class","flex justify-center"),_(S,"class","flex justify-center"),_(N,"class","flex justify-center"),_(Q,"start","2")},m(e,t){Jp(document.head,p),s(e,M,t),s(e,f,t),s(e,u,t),v(y,e,t),s(e,h,t),s(e,m,t),s(e,R,t),s(e,U,t),s(e,ts,t),s(e,z,t),s(e,ls,t),v($,e,t),s(e,ss,t),s(e,B,t),s(e,is,t),v(F,e,t),s(e,ns,t),s(e,W,t),s(e,as,t),s(e,Z,t),s(e,os,t),s(e,X,t),s(e,rs,t),s(e,O,t),s(e,ps,t),s(e,q,t),s(e,hs,t),s(e,Y,t),s(e,ms,t),s(e,K,t),s(e,fs,t),s(e,ee,t),s(e,us,t),s(e,te,t),s(e,cs,t),s(e,le,t),s(e,ds,t),s(e,se,t),s(e,vs,t),s(e,ie,t),s(e,ws,t),s(e,ne,t),s(e,gs,t),s(e,ae,t),s(e,Ps,t),s(e,oe,t),s(e,ys,t),s(e,re,t),s(e,Ms,t),v(pe,e,t),s(e,Ts,t),s(e,he,t),s(e,bs,t),v(me,e,t),s(e,xs,t),s(e,fe,t),s(e,Cs,t),s(e,ue,t),s(e,_s,t),s(e,ce,t),s(e,Us,t),s(e,de,t),s(e,$s,t),s(e,ve,t),s(e,Ls,t),s(e,we,t),s(e,js,t),s(e,ge,t),s(e,Ds,t),s(e,Pe,t),s(e,Hs,t),s(e,ye,t),s(e,Gs,t),s(e,Me,t),s(e,Js,t),s(e,Te,t),s(e,Is,t),s(e,be,t),s(e,ks,t),s(e,xe,t),s(e,Es,t),s(e,Ce,t),s(e,Ss,t),v(_e,e,t),s(e,Ns,t),s(e,Ue,t),s(e,Vs,t),v($e,e,t),s(e,As,t),s(e,Le,t),s(e,Qs,t),v(je,e,t),s(e,Rs,t),s(e,De,t),s(e,zs,t),s(e,He,t),s(e,Bs,t),s(e,Ge,t),s(e,Fs,t),v(Je,e,t),s(e,Ws,t),s(e,Ie,t),s(e,Zs,t),s(e,L,t),s(e,Xs,t),s(e,ke,t),s(e,Os,t),s(e,Ee,t),s(e,qs,t),v(Se,e,t),s(e,Ys,t),s(e,Ne,t),s(e,Ks,t),v(Ve,e,t),s(e,ei,t),s(e,Ae,t),s(e,ti,t),s(e,Qe,t),s(e,li,t),v(Re,e,t),s(e,si,t),s(e,ze,t),s(e,ii,t),s(e,Be,t),s(e,ni,t),s(e,Fe,t),s(e,ai,t),s(e,We,t),s(e,oi,t),s(e,Ze,t),s(e,ri,t),s(e,Xe,t),s(e,pi,t),v(j,e,t),s(e,hi,t),s(e,Oe,t),s(e,mi,t),s(e,qe,t),s(e,fi,t),s(e,Ye,t),s(e,ui,t),v(Ke,e,t),s(e,ci,t),s(e,et,t),s(e,di,t),s(e,tt,t),s(e,vi,t),v(lt,e,t),s(e,wi,t),s(e,st,t),s(e,gi,t),s(e,it,t),s(e,Pi,t),s(e,nt,t),s(e,yi,t),s(e,at,t),s(e,Mi,t),s(e,ot,t),s(e,Ti,t),s(e,rt,t),s(e,bi,t),s(e,D,t),s(e,xi,t),s(e,pt,t),s(e,Ci,t),s(e,ht,t),s(e,_i,t),s(e,mt,t),s(e,Ui,t),s(e,ft,t),s(e,$i,t),s(e,ut,t),s(e,Li,t),s(e,ct,t),s(e,ji,t),s(e,dt,t),s(e,Di,t),s(e,vt,t),s(e,Hi,t),s(e,wt,t),s(e,Gi,t),s(e,gt,t),s(e,Ji,t),s(e,Pt,t),s(e,Ii,t),s(e,yt,t),s(e,ki,t),s(e,Mt,t),s(e,Ei,t),s(e,Tt,t),s(e,Si,t),s(e,bt,t),s(e,Ni,t),s(e,xt,t),s(e,Vi,t),s(e,Ct,t),s(e,Ai,t),s(e,_t,t),s(e,Qi,t),s(e,H,t),s(e,Ri,t),s(e,Ut,t),s(e,zi,t),s(e,$t,t),s(e,Bi,t),v(Lt,e,t),s(e,Fi,t),s(e,jt,t),s(e,Wi,t),s(e,Dt,t),s(e,Zi,t),s(e,Ht,t),s(e,Xi,t),s(e,G,t),s(e,Oi,t),s(e,Gt,t),s(e,qi,t),s(e,J,t),s(e,Yi,t),s(e,Jt,t),s(e,Ki,t),s(e,I,t),s(e,en,t),s(e,It,t),s(e,tn,t),s(e,k,t),s(e,ln,t),s(e,kt,t),s(e,sn,t),s(e,Et,t),s(e,nn,t),s(e,St,t),s(e,an,t),s(e,Nt,t),s(e,on,t),s(e,Vt,t),s(e,rn,t),s(e,At,t),s(e,pn,t),s(e,Qt,t),s(e,hn,t),s(e,Rt,t),s(e,mn,t),s(e,zt,t),s(e,fn,t),s(e,Bt,t),s(e,un,t),v(Ft,e,t),s(e,cn,t),s(e,Wt,t),s(e,dn,t),s(e,E,t),s(e,vn,t),s(e,Zt,t),s(e,wn,t),s(e,Xt,t),s(e,gn,t),s(e,Ot,t),s(e,Pn,t),s(e,qt,t),s(e,yn,t),s(e,Yt,t),s(e,Mn,t),v(Kt,e,t),s(e,Tn,t),s(e,el,t),s(e,bn,t),s(e,S,t),s(e,xn,t),s(e,tl,t),s(e,Cn,t),s(e,ll,t),s(e,_n,t),s(e,sl,t),s(e,Un,t),s(e,il,t),s(e,$n,t),s(e,nl,t),s(e,Ln,t),v(al,e,t),s(e,jn,t),s(e,ol,t),s(e,Dn,t),s(e,rl,t),s(e,Hn,t),s(e,pl,t),s(e,Gn,t),s(e,hl,t),s(e,Jn,t),s(e,ml,t),s(e,In,t),s(e,fl,t),s(e,kn,t),s(e,ul,t),s(e,En,t),s(e,cl,t),s(e,Sn,t),s(e,dl,t),s(e,Nn,t),s(e,vl,t),s(e,Vn,t),s(e,wl,t),s(e,An,t),v(gl,e,t),s(e,Qn,t),s(e,Pl,t),s(e,Rn,t),s(e,yl,t),s(e,zn,t),s(e,Ml,t),s(e,Bn,t),s(e,Tl,t),s(e,Fn,t),s(e,bl,t),s(e,Wn,t),s(e,xl,t),s(e,Zn,t),s(e,Cl,t),s(e,Xn,t),s(e,_l,t),s(e,On,t),s(e,Ul,t),s(e,qn,t),s(e,$l,t),s(e,Yn,t),s(e,Ll,t),s(e,Kn,t),s(e,jl,t),s(e,ea,t),s(e,Dl,t),s(e,ta,t),s(e,N,t),s(e,la,t),s(e,Hl,t),s(e,sa,t),s(e,Gl,t),s(e,ia,t),s(e,Jl,t),s(e,na,t),s(e,Il,t),s(e,aa,t),v(kl,e,t),s(e,oa,t),s(e,El,t),s(e,ra,t),v(Sl,e,t),s(e,pa,t),s(e,Nl,t),s(e,ha,t),v(V,e,t),s(e,ma,t),v(Vl,e,t),s(e,fa,t),s(e,Al,t),s(e,ua,t),v(Ql,e,t),s(e,ca,t),s(e,Rl,t),s(e,da,t),v(zl,e,t),s(e,va,t),s(e,Bl,t),s(e,wa,t),v(Fl,e,t),s(e,ga,t),v(A,e,t),s(e,Pa,t),s(e,Wl,t),s(e,ya,t),s(e,Zl,t),s(e,Ma,t),v(Xl,e,t),s(e,Ta,t),s(e,Q,t),s(e,ba,t),v(Ol,e,t),s(e,xa,t),s(e,ql,t),s(e,Ca,t),s(e,es,t),_a=!0},p(e,[t]){const xp={};t&2&&(xp.$$scope={dirty:t,ctx:e}),$.$set(xp);const Cp={};t&2&&(Cp.$$scope={dirty:t,ctx:e}),j.$set(Cp);const _p={};t&2&&(_p.$$scope={dirty:t,ctx:e}),V.$set(_p);const Up={};t&2&&(Up.$$scope={dirty:t,ctx:e}),A.$set(Up)},i(e){_a||(w(y.$$.fragment,e),w($.$$.fragment,e),w(F.$$.fragment,e),w(pe.$$.fragment,e),w(me.$$.fragment,e),w(_e.$$.fragment,e),w($e.$$.fragment,e),w(je.$$.fragment,e),w(Je.$$.fragment,e),w(Se.$$.fragment,e),w(Ve.$$.fragment,e),w(Re.$$.fragment,e),w(j.$$.fragment,e),w(Ke.$$.fragment,e),w(lt.$$.fragment,e),w(Lt.$$.fragment,e),w(Ft.$$.fragment,e),w(Kt.$$.fragment,e),w(al.$$.fragment,e),w(gl.$$.fragment,e),w(kl.$$.fragment,e),w(Sl.$$.fragment,e),w(V.$$.fragment,e),w(Vl.$$.fragment,e),w(Ql.$$.fragment,e),w(zl.$$.fragment,e),w(Fl.$$.fragment,e),w(A.$$.fragment,e),w(Xl.$$.fragment,e),w(Ol.$$.fragment,e),_a=!0)},o(e){g(y.$$.fragment,e),g($.$$.fragment,e),g(F.$$.fragment,e),g(pe.$$.fragment,e),g(me.$$.fragment,e),g(_e.$$.fragment,e),g($e.$$.fragment,e),g(je.$$.fragment,e),g(Je.$$.fragment,e),g(Se.$$.fragment,e),g(Ve.$$.fragment,e),g(Re.$$.fragment,e),g(j.$$.fragment,e),g(Ke.$$.fragment,e),g(lt.$$.fragment,e),g(Lt.$$.fragment,e),g(Ft.$$.fragment,e),g(Kt.$$.fragment,e),g(al.$$.fragment,e),g(gl.$$.fragment,e),g(kl.$$.fragment,e),g(Sl.$$.fragment,e),g(V.$$.fragment,e),g(Vl.$$.fragment,e),g(Ql.$$.fragment,e),g(zl.$$.fragment,e),g(Fl.$$.fragment,e),g(A.$$.fragment,e),g(Xl.$$.fragment,e),g(Ol.$$.fragment,e),_a=!1},d(e){e&&(l(M),l(f),l(u),l(h),l(m),l(R),l(U),l(ts),l(z),l(ls),l(ss),l(B),l(is),l(ns),l(W),l(as),l(Z),l(os),l(X),l(rs),l(O),l(ps),l(q),l(hs),l(Y),l(ms),l(K),l(fs),l(ee),l(us),l(te),l(cs),l(le),l(ds),l(se),l(vs),l(ie),l(ws),l(ne),l(gs),l(ae),l(Ps),l(oe),l(ys),l(re),l(Ms),l(Ts),l(he),l(bs),l(xs),l(fe),l(Cs),l(ue),l(_s),l(ce),l(Us),l(de),l($s),l(ve),l(Ls),l(we),l(js),l(ge),l(Ds),l(Pe),l(Hs),l(ye),l(Gs),l(Me),l(Js),l(Te),l(Is),l(be),l(ks),l(xe),l(Es),l(Ce),l(Ss),l(Ns),l(Ue),l(Vs),l(As),l(Le),l(Qs),l(Rs),l(De),l(zs),l(He),l(Bs),l(Ge),l(Fs),l(Ws),l(Ie),l(Zs),l(L),l(Xs),l(ke),l(Os),l(Ee),l(qs),l(Ys),l(Ne),l(Ks),l(ei),l(Ae),l(ti),l(Qe),l(li),l(si),l(ze),l(ii),l(Be),l(ni),l(Fe),l(ai),l(We),l(oi),l(Ze),l(ri),l(Xe),l(pi),l(hi),l(Oe),l(mi),l(qe),l(fi),l(Ye),l(ui),l(ci),l(et),l(di),l(tt),l(vi),l(wi),l(st),l(gi),l(it),l(Pi),l(nt),l(yi),l(at),l(Mi),l(ot),l(Ti),l(rt),l(bi),l(D),l(xi),l(pt),l(Ci),l(ht),l(_i),l(mt),l(Ui),l(ft),l($i),l(ut),l(Li),l(ct),l(ji),l(dt),l(Di),l(vt),l(Hi),l(wt),l(Gi),l(gt),l(Ji),l(Pt),l(Ii),l(yt),l(ki),l(Mt),l(Ei),l(Tt),l(Si),l(bt),l(Ni),l(xt),l(Vi),l(Ct),l(Ai),l(_t),l(Qi),l(H),l(Ri),l(Ut),l(zi),l($t),l(Bi),l(Fi),l(jt),l(Wi),l(Dt),l(Zi),l(Ht),l(Xi),l(G),l(Oi),l(Gt),l(qi),l(J),l(Yi),l(Jt),l(Ki),l(I),l(en),l(It),l(tn),l(k),l(ln),l(kt),l(sn),l(Et),l(nn),l(St),l(an),l(Nt),l(on),l(Vt),l(rn),l(At),l(pn),l(Qt),l(hn),l(Rt),l(mn),l(zt),l(fn),l(Bt),l(un),l(cn),l(Wt),l(dn),l(E),l(vn),l(Zt),l(wn),l(Xt),l(gn),l(Ot),l(Pn),l(qt),l(yn),l(Yt),l(Mn),l(Tn),l(el),l(bn),l(S),l(xn),l(tl),l(Cn),l(ll),l(_n),l(sl),l(Un),l(il),l($n),l(nl),l(Ln),l(jn),l(ol),l(Dn),l(rl),l(Hn),l(pl),l(Gn),l(hl),l(Jn),l(ml),l(In),l(fl),l(kn),l(ul),l(En),l(cl),l(Sn),l(dl),l(Nn),l(vl),l(Vn),l(wl),l(An),l(Qn),l(Pl),l(Rn),l(yl),l(zn),l(Ml),l(Bn),l(Tl),l(Fn),l(bl),l(Wn),l(xl),l(Zn),l(Cl),l(Xn),l(_l),l(On),l(Ul),l(qn),l($l),l(Yn),l(Ll),l(Kn),l(jl),l(ea),l(Dl),l(ta),l(N),l(la),l(Hl),l(sa),l(Gl),l(ia),l(Jl),l(na),l(Il),l(aa),l(oa),l(El),l(ra),l(pa),l(Nl),l(ha),l(ma),l(fa),l(Al),l(ua),l(ca),l(Rl),l(da),l(va),l(Bl),l(wa),l(ga),l(Pa),l(Wl),l(ya),l(Zl),l(Ma),l(Ta),l(Q),l(ba),l(xa),l(ql),l(Ca),l(es)),l(p),P(y,e),P($,e),P(F,e),P(pe,e),P(me,e),P(_e,e),P($e,e),P(je,e),P(Je,e),P(Se,e),P(Ve,e),P(Re,e),P(j,e),P(Ke,e),P(lt,e),P(Lt,e),P(Ft,e),P(Kt,e),P(al,e),P(gl,e),P(kl,e),P(Sl,e),P(V,e),P(Vl,e),P(Ql,e),P(zl,e),P(Fl,e),P(A,e),P(Xl,e),P(Ol,e)}}}const zp='{"title":"Efficient Training on Multiple GPUs","local":"efficient-training-on-multiple-gpus","sections":[{"title":"Scalability strategy","local":"scalability-strategy","sections":[],"depth":2},{"title":"Data Parallelism","local":"data-parallelism","sections":[{"title":"DataParallel vs DistributedDataParallel","local":"dataparallel-vs-distributeddataparallel","sections":[],"depth":3}],"depth":2},{"title":"ZeRO Data Parallelism","local":"zero-data-parallelism","sections":[],"depth":2},{"title":"From Naive Model Parallelism to Pipeline Parallelism","local":"from-naive-model-parallelism-to-pipeline-parallelism","sections":[],"depth":2},{"title":"Tensor Parallelism","local":"tensor-parallelism","sections":[],"depth":2},{"title":"Data Parallelism + Pipeline Parallelism","local":"data-parallelism--pipeline-parallelism","sections":[],"depth":2},{"title":"Data Parallelism + Pipeline Parallelism + Tensor Parallelism","local":"data-parallelism--pipeline-parallelism--tensor-parallelism","sections":[],"depth":2},{"title":"ZeRO Data Parallelism + Pipeline Parallelism + Tensor Parallelism","local":"zero-data-parallelism--pipeline-parallelism--tensor-parallelism","sections":[],"depth":2},{"title":"FlexFlow","local":"flexflow","sections":[],"depth":2},{"title":"GPU selection","local":"gpu-selection","sections":[{"title":"Number of GPUs","local":"number-of-gpus","sections":[],"depth":3},{"title":"Order of GPUs","local":"order-of-gpus","sections":[],"depth":3}],"depth":2}],"depth":1}';function Bp(T){return jp(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yp extends Dp{constructor(p){super(),Hp(this,p,Bp,Rp,Lp,{})}}export{Yp as component};
