import{s as mn,o as hn,n as Fs}from"../chunks/scheduler.37c15a92.js";import{S as wn,i as In,g as e,s as t,r as j,m as Cn,H as xn,A as gn,h as y,f as a,c as p,j as fa,u as i,x as o,n as dn,E as bn,k as on,y as Tn,a as n,v as J,d as c,t as r,w as U}from"../chunks/index.2bf4358c.js";import{T as Ps}from"../chunks/Tip.363c041f.js";import{Y as fn}from"../chunks/Youtube.1e50a667.js";import{C as u}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as qn}from"../chunks/CourseFloatingBanner.06521e8b.js";import{H as da}from"../chunks/Heading.8ada512a.js";function $n(w){let M,m="💡 本节深入介绍 WordPiece,甚至展示完整的实现。如果您只想大致了解标记化算法,可以跳到最后。";return{c(){M=e("p"),M.textContent=m},l(T){M=y(T,"P",{"data-svelte-h":!0}),o(M)!=="svelte-1ell5in"&&(M.textContent=m)},m(T,h){n(T,M,h)},p:Fs,d(T){T&&a(M)}}}function kn(w){let M,m="⚠️ Google 从未开源 WordPiece 训练算法的实现,因此以下是我们基于已发表文献的最佳猜测。它可能不是 100% 准确的。";return{c(){M=e("p"),M.textContent=m},l(T){M=y(T,"P",{"data-svelte-h":!0}),o(M)!=="svelte-1tvekjv"&&(M.textContent=m)},m(T,h){n(T,M,h)},p:Fs,d(T){T&&a(M)}}}function An(w){let M,m="✏️ <strong>现在轮到你了!</strong> 下一个合并规则是什么？";return{c(){M=e("p"),M.innerHTML=m},l(T){M=y(T,"P",{"data-svelte-h":!0}),o(M)!=="svelte-192v8t0"&&(M.innerHTML=m)},m(T,h){n(T,M,h)},p:Fs,d(T){T&&a(M)}}}function Qn(w){let M,m="✏️ <strong>现在轮到你了!</strong> <code>&quot;pugs&quot;</code> 将被如何标记?";return{c(){M=e("p"),M.innerHTML=m},l(T){M=y(T,"P",{"data-svelte-h":!0}),o(M)!=="svelte-17778ne"&&(M.innerHTML=m)},m(T,h){n(T,M,h)},p:Fs,d(T){T&&a(M)}}}function zn(w){let M,m="💡 在同一语料库上使用 <code>train_new_from_iterator()</code> 不会产生完全相同的词汇表。这是因为 🤗 Tokenizers 库没有为训练实现 WordPiece(因为我们不完全确定它的内部结构),而是使用 BPE。";return{c(){M=e("p"),M.innerHTML=m},l(T){M=y(T,"P",{"data-svelte-h":!0}),o(M)!=="svelte-697xbd"&&(M.innerHTML=m)},m(T,h){n(T,M,h)},p:Fs,d(T){T&&a(M)}}}function Bn(w){let M,m,T,h,b,Ks,f,Ls,q,qa="WordPiece 是 Google 为预训练 BERT 而开发的标记化算法。此后,它在不少基于 BERT 的 Transformer 模型中得到重用,例如 DistilBERT、MobileBERT、Funnel Transformers 和 MPNET。它在训练方面与 BPE 非常相似,但实际标记化的方式不同。",Os,$,sl,I,ll,k,al,C,nl,A,$a="与 BPE 一样,WordPiece 从一个小词汇表开始,包括模型使用的特殊标记和初始字母表。因为它通过添加前缀来识别子词 (如同 <code>##</code> 对于 BERT),每个单词最初是通过将该前缀添加到单词内的所有字符来拆分的。所以,例如 <code>&quot;word&quot;</code> ,像这样拆分:",tl,Q,pl,z,ka="因此,初始字母表包含出现在单词开头的所有字符以及出现在单词内部的以 WordPiece 前缀开头的字符。",Ml,B,ba,el,un='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mrow><mi mathvariant="normal">s</mi><mi mathvariant="normal">c</mi><mi mathvariant="normal">o</mi><mi mathvariant="normal">r</mi><mi mathvariant="normal">e</mi></mrow><mo>=</mo><mo stretchy="false">(</mo><mrow><mi mathvariant="normal">f</mi><mi mathvariant="normal">r</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">q</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">o</mi><mi mathvariant="normal">f</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">p</mi><mi mathvariant="normal">a</mi><mi mathvariant="normal">i</mi><mi mathvariant="normal">r</mi></mrow><mo stretchy="false">)</mo><mi mathvariant="normal">/</mi><mo stretchy="false">(</mo><mrow><mi mathvariant="normal">f</mi><mi mathvariant="normal">r</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">q</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">o</mi><mi mathvariant="normal">f</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">f</mi><mi mathvariant="normal">i</mi><mi mathvariant="normal">r</mi><mi mathvariant="normal">s</mi><mi mathvariant="normal">t</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">l</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">m</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">n</mi><mi mathvariant="normal">t</mi></mrow><mo>×</mo><mrow><mi mathvariant="normal">f</mi><mi mathvariant="normal">r</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">q</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">o</mi><mi mathvariant="normal">f</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">s</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">c</mi><mi mathvariant="normal">o</mi><mi mathvariant="normal">n</mi><mi mathvariant="normal">d</mi><mi mathvariant="normal">_</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">l</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">m</mi><mi mathvariant="normal">e</mi><mi mathvariant="normal">n</mi><mi mathvariant="normal">t</mi></mrow><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\mathrm{score} = (\\mathrm{freq\\_of\\_pair}) / (\\mathrm{freq\\_of\\_first\\_element} \\times \\mathrm{freq\\_of\\_second\\_element})</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.4306em;"></span><span class="mord"><span class="mord mathrm">score</span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.06em;vertical-align:-0.31em;"></span><span class="mopen">(</span><span class="mord"><span class="mord mathrm">freq_of_pair</span></span><span class="mclose">)</span><span class="mord">/</span><span class="mopen">(</span><span class="mord"><span class="mord mathrm">freq_of_first_element</span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.06em;vertical-align:-0.31em;"></span><span class="mord"><span class="mord mathrm">freq_of_second_element</span></span><span class="mclose">)</span></span></span></span></span>',yl,v,Aa="通过将配对的频率除以其每个部分的频率的乘积, 该算法优先合并单个部分在词汇表中频率较低的对。例如,它不一定会合并 <code>(&quot;un&quot;, &quot;##able&quot;)</code> 即使这对在词汇表中出现的频率很高,因为 <code>&quot;un&quot;</code> 和 <code>&quot;##able&quot;</code> 很可能每个词都出现在很多其他词中并且出现频率很高。相比之下,像 <code>(&quot;hu&quot;, &quot;##gging&quot;)</code> 可能会更快地合并 (假设 “hugging” 经常出现在词汇表中),因为 <code>&quot;hu&quot;</code> 和 <code>&quot;##gging&quot;</code> 这两个词单独出现地频率可能较低。",jl,Z,Qa="让我们看看我们在 BPE 训练示例中使用的相同词汇:",il,N,Jl,_,za="这里的拆分将是:",cl,E,rl,S,Ba="所以最初的词汇将是 <code>[&quot;b&quot;, &quot;h&quot;, &quot;p&quot;, &quot;##g&quot;, &quot;##n&quot;, &quot;##s&quot;, &quot;##u&quot;]</code> (如果我们暂时忘记特殊标记)。最频繁的一对是 <code>(&quot;##u&quot;, &quot;##g&quot;)</code> (目前20次),但 <code>&quot;##u&quot;</code> 单独出现的频率非常高,所以它的分数不是最高的(它是 1 / 36)。所有带有 <code>&quot;##u&quot;</code> 的对实际上都有相同的分数(1 / 36),所以分数最高的对是 <code>(&quot;##g&quot;, &quot;##s&quot;)</code> — 唯一没有 <code>&quot;##u&quot;</code> 的对— 1 / 20,所以学习的第一个合并是 <code>(&quot;##g&quot;, &quot;##s&quot;) -&gt; (&quot;##gs&quot;)</code>。",Ul,G,va="请注意,当我们合并时,我们删除了两个标记之间的 <code>##</code>,所以我们添加 <code>&quot;##gs&quot;</code> 到词汇表中,并在语料库的单词中应用该合并:",ol,V,Tl,X,Za="在这一点中, <code>&quot;##u&quot;</code> 是在所有可能的对中,因此它们最终都具有相同的分数。假设在这种情况下,第一对被合并, <code>(&quot;h&quot;, &quot;##u&quot;) -&gt; &quot;hu&quot;</code>。这使得我们:",ul,W,ml,H,Na="然后下一个最高的分数由 <code>(&quot;hu&quot;, &quot;##g&quot;)</code> 和 <code>(&quot;hu&quot;, &quot;##gs&quot;)</code> 共享(1/15,与其他所有对的 1/21 相比),因此合并得分最高的第一对:",hl,R,wl,Y,_a="我们继续这样处理,直到达到我们所需的词汇量。",Il,x,Cl,D,xl,P,Ea="WordPiece 和 BPE 中的标记化的不同在于 WordPiece 只保存最终词汇,而不是学习的合并规则。从要标记的单词开始,WordPiece 找到词汇表中最长的子词,然后对其进行拆分。例如,如果我们使用上面例子中学到的词汇,对于单词 <code>&quot;hugs&quot;</code>,词汇表中从头开始的最长子词是 <code>&quot;hug&quot;</code>,所以我们在那里拆分并得到 <code>[&quot;hug&quot;, &quot;##s&quot;]</code>。 然后我们继续使用词汇表中的 <code>&quot;##s&quot;</code>,因此 <code>&quot;hugs&quot;</code> 的标记化是 <code>[&quot;hug&quot;, &quot;##s&quot;]</code>.",gl,F,Sa="使用 BPE, 我们将按顺序应用学习到的合并并将其标记为 <code>[&quot;hu&quot;, &quot;##gs&quot;]</code>,所以编码不同。",dl,K,Ga="再举一个例子,让我们看看 <code>&quot;bugs&quot;</code> 将如何被标记化。 <code>&quot;b&quot;</code> 是从词汇表中单词开头开始的最长子词,所以我们在那里拆分并得到 <code>[&quot;b&quot;, &quot;##ugs&quot;]</code>。然后 <code>&quot;##u&quot;</code> 是词汇表中从 <code>&quot;##ugs&quot;</code> 开始的最长的子词,所以我们在那里拆分并得到 <code>[&quot;b&quot;, &quot;##u, &quot;##gs&quot;]</code>。最后, <code>&quot;##gs&quot;</code> 在词汇表中,所以最后一个列表是 <code>&quot;bugs&quot;</code> 的标记化。",bl,L,Va="当分词达到无法在词汇表中找到子词的阶段时, 整个词被标记为未知 — 例如, <code>&quot;mug&quot;</code> 将被标记为 <code>[&quot;[UNK]&quot;]</code>,就像 <code>&quot;bum&quot;</code> (即使我们可以以 <code>&quot;b&quot;</code> 和 <code>&quot;##u&quot;</code> 开始, <code>&quot;##m&quot;</code> 不在词汇表中,由此产生的标记将只是 <code>[&quot;[UNK]&quot;]</code>, 不是 <code>[&quot;b&quot;, &quot;##u&quot;, &quot;[UNK]&quot;]</code>)。这是与 BPE 的另一个区别,BPE 只会将不在词汇表中的单个字符分类为未知。",fl,g,ql,O,$l,ss,Xa="现在让我们看一下 WordPiece 算法的实现。与 BPE 一样,这只是教学,你将无法在大型语料库中使用它。",kl,ls,Wa="我们将使用与 BPE 示例中相同的语料库:",Al,as,Ql,ns,Ha="首先,我们需要将语料库预先标记为单词。由于我们正在复制 WordPiece 标记器 (如 BERT),因此我们将使用 <code>bert-base-cased</code> 标记器用于预标记化:",zl,ts,Bl,ps,Ra="然后我们在进行预标记化时计算语料库中每个单词的频率:",vl,Ms,Zl,es,Nl,ys,Ya="正如我们之前看到的,字母表是由单词的所有第一个字母组成的唯一集合,以及出现在前缀为 <code>##</code> 的其他字母:",_l,js,El,is,Sl,Js,Da="我们还在该词汇表的开头添加了模型使用的特殊标记。在使用 BERT 的情况下,它是列表 <code>[&quot;[PAD]&quot;, &quot;[UNK]&quot;, &quot;[CLS]&quot;, &quot;[SEP]&quot;, &quot;[MASK]&quot;]</code>:",Gl,cs,Vl,rs,Pa="接下来我们需要拆分每个单词, 所有不是第一个字母的字母都以 <code>##</code> 为前缀:",Xl,Us,Wl,os,Fa="现在我们已经准备好训练了,让我们编写一个函数来计算每对的分数。我们需要在训练的每个步骤中使用它:",Hl,Ts,Rl,us,Ka="让我们来看看这个字典在初始拆分后的一部分:",Yl,ms,Dl,hs,Pl,ws,La="现在,找到得分最高的对只需要一个快速循环:",Fl,Is,Kl,Cs,Ll,xs,Oa="所以第一个要学习的合并是 <code>(&#39;a&#39;, &#39;##b&#39;) -&gt; &#39;ab&#39;</code>, 并且我们添加 <code>&#39;ab&#39;</code> 到词汇表中:",Ol,gs,sa,ds,sn="要继续接下来的步骤,我们需要在我们的 <code>拆分</code> 字典中应用该合并。让我们为此编写另一个函数:",la,bs,aa,fs,ln="我们可以看看第一次合并的结果:",na,qs,ta,$s,pa,ks,an="现在我们有了循环所需的一切,直到我们学会了我们想要的所有合并。我们的目标词汇量为70:",Ma,As,ea,Qs,nn="然后我们可以查看生成的词汇表:",ya,zs,ja,Bs,ia,vs,tn="正如我们所看到的,与 BPE 相比,这个标记器将单词的一部分作为标记学习得更快一些。",Ja,d,ca,Zs,pn="为了对新文本进行分词,我们对其进行预分词、拆分,然后对每个单词应用分词算法。也就是说,我们从第一个词的开头寻找最大的子词并将其拆分,然后我们在第二部分重复这个过程,对于该词的其余部分和文本中的以下词,依此类推:",ra,Ns,Ua,_s,Mn="让我们用词汇表中的一个单词和另一个不在词汇表中的单词进行测试:",oa,Es,Ta,Ss,ua,Gs,en="现在,让我们编写一个标记文本的函数:",ma,Vs,ha,Xs,yn="我们可以在任何文本上尝试:",wa,Ws,Ia,Hs,Ca,Rs,jn="这就是 WordPiece 算法的全部内容!现在让我们来看看 Unigram。",xa,Ds,ga;return b=new da({props:{title:"WordPiece 标记化",local:"WordPiece 标记化",headingTag:"h1"}}),f=new qn({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section6.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section6.ipynb"}]}}),$=new fn({props:{id:"qpv6ms_t_1A"}}),I=new Ps({props:{$$slots:{default:[$n]},$$scope:{ctx:w}}}),k=new da({props:{title:"训练算法",local:"训练算法",headingTag:"h2"}}),C=new Ps({props:{warning:!0,$$slots:{default:[kn]},$$scope:{ctx:w}}}),Q=new u({props:{code:"dyUyMCUyMyUyM28lMjAlMjMlMjNyJTIwJTIzJTIzZA==",highlighted:"w ##o ##r ##d",wrap:!1}}),N=new u({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),E=new u({props:{code:"KCUyMmglMjIlMjAlMjIlMjMlMjN1JTIyJTIwJTIyJTIzJTIzZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM2clMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM24lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMiUyMyUyM3UlMjIlMjAlMjIlMjMlMjNuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMiUyMyUyM3UlMjIlMjAlMjIlMjMlMjNnJTIyJTIwJTIyJTIzJTIzcyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#s</span>&quot;</span>, <span class="hljs-number">5</span>)',wrap:!1}}),V=new u({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJoJTIyJTJDJTIwJTIycCUyMiUyQyUyMCUyMiUyMyUyM2clMjIlMkMlMjAlMjIlMjMlMjNuJTIyJTJDJTIwJTIyJTIzJTIzcyUyMiUyQyUyMCUyMiUyMyUyM3UlMjIlMkMlMjAlMjIlMjMlMjNncyUyMiU1RCUwQUNvcnB1cyUzQSUyMCglMjJoJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM2clMjIlMkMlMjAxMCklMkMlMjAoJTIycCUyMiUyMCUyMiUyMyUyM3UlMjIlMjAlMjIlMjMlMjNnJTIyJTJDJTIwNSklMkMlMjAoJTIycCUyMiUyMCUyMiUyMyUyM3UlMjIlMjAlMjIlMjMlMjNuJTIyJTJDJTIwMTIpJTJDJTIwKCUyMmIlMjIlMjAlMjIlMjMlMjN1JTIyJTIwJTIyJTIzJTIzbiUyMiUyQyUyMDQpJTJDJTIwKCUyMmglMjIlMjAlMjIlMjMlMjN1JTIyJTIwJTIyJTIzJTIzZ3MlMjIlMkMlMjA1KQ==",highlighted:`Vocabulary: [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#s</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#gs</span>&quot;</span>]
Corpus: (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#gs</span>&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),W=new u({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJoJTIyJTJDJTIwJTIycCUyMiUyQyUyMCUyMiUyMyUyM2clMjIlMkMlMjAlMjIlMjMlMjNuJTIyJTJDJTIwJTIyJTIzJTIzcyUyMiUyQyUyMCUyMiUyMyUyM3UlMjIlMkMlMjAlMjIlMjMlMjNncyUyMiUyQyUyMCUyMmh1JTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmh1JTIyJTIwJTIyJTIzJTIzZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM2clMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM24lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMiUyMyUyM3UlMjIlMjAlMjIlMjMlMjNuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHUlMjIlMjAlMjIlMjMlMjNncyUyMiUyQyUyMDUp",highlighted:`Vocabulary: [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#s</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#gs</span>&quot;</span>, <span class="hljs-string">&quot;hu&quot;</span>]
Corpus: (<span class="hljs-string">&quot;hu&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;hu&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#gs</span>&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),R=new u({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJoJTIyJTJDJTIwJTIycCUyMiUyQyUyMCUyMiUyMyUyM2clMjIlMkMlMjAlMjIlMjMlMjNuJTIyJTJDJTIwJTIyJTIzJTIzcyUyMiUyQyUyMCUyMiUyMyUyM3UlMjIlMkMlMjAlMjIlMjMlMjNncyUyMiUyQyUyMCUyMmh1JTIyJTJDJTIwJTIyaHVnJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM2clMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIyJTIzJTIzdSUyMiUyMCUyMiUyMyUyM24lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMiUyMyUyM3UlMjIlMjAlMjIlMjMlMjNuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHUlMjIlMjAlMjIlMjMlMjNncyUyMiUyQyUyMDUp",highlighted:`Vocabulary: [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#s</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span>, <span class="hljs-string">&quot;#<span class="hljs-subst">#gs</span>&quot;</span>, <span class="hljs-string">&quot;hu&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>]
Corpus: (<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#g</span>&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#u</span>&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#n</span>&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;hu&quot;</span> <span class="hljs-string">&quot;#<span class="hljs-subst">#gs</span>&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),x=new Ps({props:{$$slots:{default:[An]},$$scope:{ctx:w}}}),D=new da({props:{title:"标记化算法",local:"标记化算法",headingTag:"h2"}}),g=new Ps({props:{$$slots:{default:[Qn]},$$scope:{ctx:w}}}),O=new da({props:{title:"实现 WordPiece",local:"实现 WordPiece",headingTag:"h2"}}),as=new u({props:{code:"Y29ycHVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBDb3Vyc2UuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGNoYXB0ZXIlMjBpcyUyMGFib3V0JTIwdG9rZW5pemF0aW9uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBzZWN0aW9uJTIwc2hvd3MlMjBzZXZlcmFsJTIwdG9rZW5pemVyJTIwYWxnb3JpdGhtcy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIb3BlZnVsbHklMkMlMjB5b3UlMjB3aWxsJTIwYmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwaG93JTIwdGhleSUyMGFyZSUyMHRyYWluZWQlMjBhbmQlMjBnZW5lcmF0ZSUyMHRva2Vucy4lMjIlMkMlMEElNUQ=",highlighted:`corpus = [
    <span class="hljs-string">&quot;This is the Hugging Face Course.&quot;</span>,
    <span class="hljs-string">&quot;This chapter is about tokenization.&quot;</span>,
    <span class="hljs-string">&quot;This section shows several tokenizer algorithms.&quot;</span>,
    <span class="hljs-string">&quot;Hopefully, you will be able to understand how they are trained and generate tokens.&quot;</span>,
]`,wrap:!1}}),ts=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)`,wrap:!1}}),Ms=new u({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEF3b3JkX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQWZvciUyMHRleHQlMjBpbiUyMGNvcnB1cyUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBuZXdfd29yZHMlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwbmV3X3dvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZF9mcmVxcyU1QndvcmQlNUQlMjAlMkIlM0QlMjAxJTBBJTBBd29yZF9mcmVxcw==",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

word_freqs = defaultdict(<span class="hljs-built_in">int</span>)
<span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> corpus:
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    new_words = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> new_words:
        word_freqs[word] += <span class="hljs-number">1</span>

word_freqs`,wrap:!1}}),es=new u({props:{code:"ZGVmYXVsdGRpY3QoJTBBJTIwJTIwJTIwJTIwaW50JTJDJTIwJTdCJ1RoaXMnJTNBJTIwMyUyQyUyMCdpcyclM0ElMjAyJTJDJTIwJ3RoZSclM0ElMjAxJTJDJTIwJ0h1Z2dpbmcnJTNBJTIwMSUyQyUyMCdGYWNlJyUzQSUyMDElMkMlMjAnQ291cnNlJyUzQSUyMDElMkMlMjAnLiclM0ElMjA0JTJDJTIwJ2NoYXB0ZXInJTNBJTIwMSUyQyUyMCdhYm91dCclM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJ3Rva2VuaXphdGlvbiclM0ElMjAxJTJDJTIwJ3NlY3Rpb24nJTNBJTIwMSUyQyUyMCdzaG93cyclM0ElMjAxJTJDJTIwJ3NldmVyYWwnJTNBJTIwMSUyQyUyMCd0b2tlbml6ZXInJTNBJTIwMSUyQyUyMCdhbGdvcml0aG1zJyUzQSUyMDElMkMlMjAnSG9wZWZ1bGx5JyUzQSUyMDElMkMlMEElMjAlMjAlMjAlMjAnJTJDJyUzQSUyMDElMkMlMjAneW91JyUzQSUyMDElMkMlMjAnd2lsbCclM0ElMjAxJTJDJTIwJ2JlJyUzQSUyMDElMkMlMjAnYWJsZSclM0ElMjAxJTJDJTIwJ3RvJyUzQSUyMDElMkMlMjAndW5kZXJzdGFuZCclM0ElMjAxJTJDJTIwJ2hvdyclM0ElMjAxJTJDJTIwJ3RoZXknJTNBJTIwMSUyQyUyMCdhcmUnJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCd0cmFpbmVkJyUzQSUyMDElMkMlMjAnYW5kJyUzQSUyMDElMkMlMjAnZ2VuZXJhdGUnJTNBJTIwMSUyQyUyMCd0b2tlbnMnJTNBJTIwMSU3RCk=",highlighted:`defaultdict(
    <span class="hljs-built_in">int</span>, {<span class="hljs-string">&#x27;This&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;is&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;the&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Hugging&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Face&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Course&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;.&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;chapter&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;about&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;tokenization&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;section&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;shows&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;several&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;tokenizer&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;algorithms&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Hopefully&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;,&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;you&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;will&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;be&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;able&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;to&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;understand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;how&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;they&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;are&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;trained&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;and&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;generate&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;tokens&#x27;</span>: <span class="hljs-number">1</span>})`,wrap:!1}}),js=new u({props:{code:"YWxwaGFiZXQlMjAlM0QlMjAlNUIlNUQlMEFmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzLmtleXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwd29yZCU1QjAlNUQlMjBub3QlMjBpbiUyMGFscGhhYmV0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWxwaGFiZXQuYXBwZW5kKHdvcmQlNUIwJTVEKSUwQSUyMCUyMCUyMCUyMGZvciUyMGxldHRlciUyMGluJTIwd29yZCU1QjElM0ElNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGYlMjIlMjMlMjMlN0JsZXR0ZXIlN0QlMjIlMjBub3QlMjBpbiUyMGFscGhhYmV0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWxwaGFiZXQuYXBwZW5kKGYlMjIlMjMlMjMlN0JsZXR0ZXIlN0QlMjIpJTBBJTBBYWxwaGFiZXQuc29ydCgpJTBBYWxwaGFiZXQlMEElMEFwcmludChhbHBoYWJldCk=",highlighted:`alphabet = []
<span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys():
    <span class="hljs-keyword">if</span> word[<span class="hljs-number">0</span>] <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> alphabet:
        alphabet.append(word[<span class="hljs-number">0</span>])
    <span class="hljs-keyword">for</span> letter <span class="hljs-keyword">in</span> word[<span class="hljs-number">1</span>:]:
        <span class="hljs-keyword">if</span> <span class="hljs-string">f&quot;##<span class="hljs-subst">{letter}</span>&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> alphabet:
            alphabet.append(<span class="hljs-string">f&quot;##<span class="hljs-subst">{letter}</span>&quot;</span>)

alphabet.sort()
alphabet

<span class="hljs-built_in">print</span>(alphabet)`,wrap:!1}}),is=new u({props:{code:"JTVCJyUyMyUyM2EnJTJDJTIwJyUyMyUyM2InJTJDJTIwJyUyMyUyM2MnJTJDJTIwJyUyMyUyM2QnJTJDJTIwJyUyMyUyM2UnJTJDJTIwJyUyMyUyM2YnJTJDJTIwJyUyMyUyM2cnJTJDJTIwJyUyMyUyM2gnJTJDJTIwJyUyMyUyM2knJTJDJTIwJyUyMyUyM2snJTJDJTIwJyUyMyUyM2wnJTJDJTIwJyUyMyUyM20nJTJDJTIwJyUyMyUyM24nJTJDJTIwJyUyMyUyM28nJTJDJTIwJyUyMyUyM3AnJTJDJTIwJyUyMyUyM3InJTJDJTIwJyUyMyUyM3MnJTJDJTBBJTIwJyUyMyUyM3QnJTJDJTIwJyUyMyUyM3UnJTJDJTIwJyUyMyUyM3YnJTJDJTIwJyUyMyUyM3cnJTJDJTIwJyUyMyUyM3knJTJDJTIwJyUyMyUyM3onJTJDJTIwJyUyQyclMkMlMjAnLiclMkMlMjAnQyclMkMlMjAnRiclMkMlMjAnSCclMkMlMjAnVCclMkMlMjAnYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZyclMkMlMjAnaCclMkMlMjAnaSclMkMlMjAncyclMkMlMjAndCclMkMlMjAndSclMkMlMEElMjAndyclMkMlMjAneSclNUQ=",highlighted:`[<span class="hljs-string">&#x27;##a&#x27;</span>, <span class="hljs-string">&#x27;##b&#x27;</span>, <span class="hljs-string">&#x27;##c&#x27;</span>, <span class="hljs-string">&#x27;##d&#x27;</span>, <span class="hljs-string">&#x27;##e&#x27;</span>, <span class="hljs-string">&#x27;##f&#x27;</span>, <span class="hljs-string">&#x27;##g&#x27;</span>, <span class="hljs-string">&#x27;##h&#x27;</span>, <span class="hljs-string">&#x27;##i&#x27;</span>, <span class="hljs-string">&#x27;##k&#x27;</span>, <span class="hljs-string">&#x27;##l&#x27;</span>, <span class="hljs-string">&#x27;##m&#x27;</span>, <span class="hljs-string">&#x27;##n&#x27;</span>, <span class="hljs-string">&#x27;##o&#x27;</span>, <span class="hljs-string">&#x27;##p&#x27;</span>, <span class="hljs-string">&#x27;##r&#x27;</span>, <span class="hljs-string">&#x27;##s&#x27;</span>,
 <span class="hljs-string">&#x27;##t&#x27;</span>, <span class="hljs-string">&#x27;##u&#x27;</span>, <span class="hljs-string">&#x27;##v&#x27;</span>, <span class="hljs-string">&#x27;##w&#x27;</span>, <span class="hljs-string">&#x27;##y&#x27;</span>, <span class="hljs-string">&#x27;##z&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>,
 <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>]`,wrap:!1}}),cs=new u({props:{code:"dm9jYWIlMjAlM0QlMjAlNUIlMjIlNUJQQUQlNUQlMjIlMkMlMjAlMjIlNUJVTkslNUQlMjIlMkMlMjAlMjIlNUJDTFMlNUQlMjIlMkMlMjAlMjIlNUJTRVAlNUQlMjIlMkMlMjAlMjIlNUJNQVNLJTVEJTIyJTVEJTIwJTJCJTIwYWxwaGFiZXQuY29weSgp",highlighted:'vocab = [<span class="hljs-string">&quot;[PAD]&quot;</span>, <span class="hljs-string">&quot;[UNK]&quot;</span>, <span class="hljs-string">&quot;[CLS]&quot;</span>, <span class="hljs-string">&quot;[SEP]&quot;</span>, <span class="hljs-string">&quot;[MASK]&quot;</span>] + alphabet.copy()',wrap:!1}}),Us=new u({props:{code:"c3BsaXRzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwd29yZCUzQSUyMCU1QmMlMjBpZiUyMGklMjAlM0QlM0QlMjAwJTIwZWxzZSUyMGYlMjIlMjMlMjMlN0JjJTdEJTIyJTIwZm9yJTIwaSUyQyUyMGMlMjBpbiUyMGVudW1lcmF0ZSh3b3JkKSU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHdvcmQlMjBpbiUyMHdvcmRfZnJlcXMua2V5cygpJTBBJTdE",highlighted:`splits = {
    word: [c <span class="hljs-keyword">if</span> i == <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-string">f&quot;##<span class="hljs-subst">{c}</span>&quot;</span> <span class="hljs-keyword">for</span> i, c <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(word)]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys()
}`,wrap:!1}}),Ts=new u({props:{code:"ZGVmJTIwY29tcHV0ZV9wYWlyX3Njb3JlcyhzcGxpdHMpJTNBJTBBJTIwJTIwJTIwJTIwbGV0dGVyX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlMjAlM0QlMjBkZWZhdWx0ZGljdChpbnQpJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyQyUyMGZyZXElMjBpbiUyMHdvcmRfZnJlcXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0JTIwJTNEJTIwc3BsaXRzJTVCd29yZCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGVuKHNwbGl0KSUyMCUzRCUzRCUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsZXR0ZXJfZnJlcXMlNUJzcGxpdCU1QjAlNUQlNUQlMjAlMkIlM0QlMjBmcmVxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udGludWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oc3BsaXQpJTIwLSUyMDEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFpciUyMCUzRCUyMChzcGxpdCU1QmklNUQlMkMlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxldHRlcl9mcmVxcyU1QnNwbGl0JTVCaSU1RCU1RCUyMCUyQiUzRCUyMGZyZXElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYWlyX2ZyZXFzJTVCcGFpciU1RCUyMCUyQiUzRCUyMGZyZXElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsZXR0ZXJfZnJlcXMlNUJzcGxpdCU1Qi0xJTVEJTVEJTIwJTJCJTNEJTIwZnJlcSUwQSUwQSUyMCUyMCUyMCUyMHNjb3JlcyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhaXIlM0ElMjBmcmVxJTIwJTJGJTIwKGxldHRlcl9mcmVxcyU1QnBhaXIlNUIwJTVEJTVEJTIwKiUyMGxldHRlcl9mcmVxcyU1QnBhaXIlNUIxJTVEJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBmcmVxJTIwaW4lMjBwYWlyX2ZyZXFzLml0ZW1zKCklMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzY29yZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_pair_scores</span>(<span class="hljs-params">splits</span>):
    letter_freqs = defaultdict(<span class="hljs-built_in">int</span>)
    pair_freqs = defaultdict(<span class="hljs-built_in">int</span>)
    <span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            letter_freqs[split[<span class="hljs-number">0</span>]] += freq
            <span class="hljs-keyword">continue</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>):
            pair = (split[i], split[i + <span class="hljs-number">1</span>])
            letter_freqs[split[i]] += freq
            pair_freqs[pair] += freq
        letter_freqs[split[-<span class="hljs-number">1</span>]] += freq

    scores = {
        pair: freq / (letter_freqs[pair[<span class="hljs-number">0</span>]] * letter_freqs[pair[<span class="hljs-number">1</span>]])
        <span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items()
    }
    <span class="hljs-keyword">return</span> scores`,wrap:!1}}),ms=new u({props:{code:"cGFpcl9zY29yZXMlMjAlM0QlMjBjb21wdXRlX3BhaXJfc2NvcmVzKHNwbGl0cyklMEFmb3IlMjBpJTJDJTIwa2V5JTIwaW4lMjBlbnVtZXJhdGUocGFpcl9zY29yZXMua2V5cygpKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JrZXklN0QlM0ElMjAlN0JwYWlyX3Njb3JlcyU1QmtleSU1RCU3RCUyMiklMEElMjAlMjAlMjAlMjBpZiUyMGklMjAlM0UlM0QlMjA1JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWs=",highlighted:`pair_scores = compute_pair_scores(splits)
<span class="hljs-keyword">for</span> i, key <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(pair_scores.keys()):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{key}</span>: <span class="hljs-subst">{pair_scores[key]}</span>&quot;</span>)
    <span class="hljs-keyword">if</span> i &gt;= <span class="hljs-number">5</span>:
        <span class="hljs-keyword">break</span>`,wrap:!1}}),hs=new u({props:{code:"KCdUJyUyQyUyMCclMjMlMjNoJyklM0ElMjAwLjEyNSUwQSgnJTIzJTIzaCclMkMlMjAnJTIzJTIzaScpJTNBJTIwMC4wMzQwOTA5MDkwOTA5MDkwOSUwQSgnJTIzJTIzaSclMkMlMjAnJTIzJTIzcycpJTNBJTIwMC4wMjcyNzI3MjcyNzI3MjcyNyUwQSgnaSclMkMlMjAnJTIzJTIzcycpJTNBJTIwMC4xJTBBKCd0JyUyQyUyMCclMjMlMjNoJyklM0ElMjAwLjAzNTcxNDI4NTcxNDI4NTcxJTBBKCclMjMlMjNoJyUyQyUyMCclMjMlMjNlJyklM0ElMjAwLjAxMTkwNDc2MTkwNDc2MTkwNA==",highlighted:`(<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;##h&#x27;</span>): <span class="hljs-number">0.125</span>
(<span class="hljs-string">&#x27;##h&#x27;</span>, <span class="hljs-string">&#x27;##i&#x27;</span>): <span class="hljs-number">0.03409090909090909</span>
(<span class="hljs-string">&#x27;##i&#x27;</span>, <span class="hljs-string">&#x27;##s&#x27;</span>): <span class="hljs-number">0.02727272727272727</span>
(<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;##s&#x27;</span>): <span class="hljs-number">0.1</span>
(<span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;##h&#x27;</span>): <span class="hljs-number">0.03571428571428571</span>
(<span class="hljs-string">&#x27;##h&#x27;</span>, <span class="hljs-string">&#x27;##e&#x27;</span>): <span class="hljs-number">0.011904761904761904</span>`,wrap:!1}}),Is=new u({props:{code:"YmVzdF9wYWlyJTIwJTNEJTIwJTIyJTIyJTBBbWF4X3Njb3JlJTIwJTNEJTIwTm9uZSUwQWZvciUyMHBhaXIlMkMlMjBzY29yZSUyMGluJTIwcGFpcl9zY29yZXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWF4X3Njb3JlJTIwaXMlMjBOb25lJTIwb3IlMjBtYXhfc2NvcmUlMjAlM0MlMjBzY29yZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMHBhaXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfc2NvcmUlMjAlM0QlMjBzY29yZSUwQSUwQXByaW50KGJlc3RfcGFpciUyQyUyMG1heF9zY29yZSk=",highlighted:`best_pair = <span class="hljs-string">&quot;&quot;</span>
max_score = <span class="hljs-literal">None</span>
<span class="hljs-keyword">for</span> pair, score <span class="hljs-keyword">in</span> pair_scores.items():
    <span class="hljs-keyword">if</span> max_score <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_score &lt; score:
        best_pair = pair
        max_score = score

<span class="hljs-built_in">print</span>(best_pair, max_score)`,wrap:!1}}),Cs=new u({props:{code:"KCdhJyUyQyUyMCclMjMlMjNiJyklMjAwLjI=",highlighted:'(<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;##b&#x27;</span>) <span class="hljs-number">0.2</span>',wrap:!1}}),gs=new u({props:{code:"dm9jYWIuYXBwZW5kKCUyMmFiJTIyKQ==",highlighted:'vocab.append(<span class="hljs-string">&quot;ab&quot;</span>)',wrap:!1}}),bs=new u({props:{code:"ZGVmJTIwbWVyZ2VfcGFpcihhJTJDJTIwYiUyQyUyMHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXQlMjAlM0QlMjBzcGxpdHMlNUJ3b3JkJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc3BsaXQpJTIwJTNEJTNEJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnRpbnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaSUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGlsZSUyMGklMjAlM0MlMjBsZW4oc3BsaXQpJTIwLSUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNwbGl0JTVCaSU1RCUyMCUzRCUzRCUyMGElMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwYiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lcmdlJTIwJTNEJTIwYSUyMCUyQiUyMGIlNUIyJTNBJTVEJTIwaWYlMjBiLnN0YXJ0c3dpdGgoJTIyJTIzJTIzJTIyKSUyMGVsc2UlMjBhJTIwJTJCJTIwYiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0JTIwJTNEJTIwc3BsaXQlNUIlM0FpJTVEJTIwJTJCJTIwJTVCbWVyZ2UlNUQlMjAlMkIlMjBzcGxpdCU1QmklMjAlMkIlMjAyJTIwJTNBJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGklMjAlMkIlM0QlMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXRzJTVCd29yZCU1RCUyMCUzRCUyMHNwbGl0JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3BsaXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">merge_pair</span>(<span class="hljs-params">a, b, splits</span>):
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs:
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>
        i = <span class="hljs-number">0</span>
        <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
            <span class="hljs-keyword">if</span> split[i] == a <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == b:
                merge = a + b[<span class="hljs-number">2</span>:] <span class="hljs-keyword">if</span> b.startswith(<span class="hljs-string">&quot;##&quot;</span>) <span class="hljs-keyword">else</span> a + b
                split = split[:i] + [merge] + split[i + <span class="hljs-number">2</span> :]
            <span class="hljs-keyword">else</span>:
                i += <span class="hljs-number">1</span>
        splits[word] = split
    <span class="hljs-keyword">return</span> splits`,wrap:!1}}),qs=new u({props:{code:"c3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpciglMjJhJTIyJTJDJTIwJTIyJTIzJTIzYiUyMiUyQyUyMHNwbGl0cyklMEFzcGxpdHMlNUIlMjJhYm91dCUyMiU1RA==",highlighted:`splits = merge_pair(<span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;##b&quot;</span>, splits)
splits[<span class="hljs-string">&quot;about&quot;</span>]`,wrap:!1}}),$s=new u({props:{code:"JTVCJ2FiJyUyQyUyMCclMjMlMjNvJyUyQyUyMCclMjMlMjN1JyUyQyUyMCclMjMlMjN0JyU1RA==",highlighted:'[<span class="hljs-string">&#x27;ab&#x27;</span>, <span class="hljs-string">&#x27;##o&#x27;</span>, <span class="hljs-string">&#x27;##u&#x27;</span>, <span class="hljs-string">&#x27;##t&#x27;</span>]',wrap:!1}}),As=new u({props:{code:"dm9jYWJfc2l6ZSUyMCUzRCUyMDcwJTBBd2hpbGUlMjBsZW4odm9jYWIpJTIwJTNDJTIwdm9jYWJfc2l6ZSUzQSUwQSUyMCUyMCUyMCUyMHNjb3JlcyUyMCUzRCUyMGNvbXB1dGVfcGFpcl9zY29yZXMoc3BsaXRzKSUwQSUyMCUyMCUyMCUyMGJlc3RfcGFpciUyQyUyMG1heF9zY29yZSUyMCUzRCUyMCUyMiUyMiUyQyUyME5vbmUlMEElMjAlMjAlMjAlMjBmb3IlMjBwYWlyJTJDJTIwc2NvcmUlMjBpbiUyMHNjb3Jlcy5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBtYXhfc2NvcmUlMjBpcyUyME5vbmUlMjBvciUyMG1heF9zY29yZSUyMCUzQyUyMHNjb3JlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmVzdF9wYWlyJTIwJTNEJTIwcGFpciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9zY29yZSUyMCUzRCUyMHNjb3JlJTBBJTIwJTIwJTIwJTIwc3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpcigqYmVzdF9wYWlyJTJDJTIwc3BsaXRzKSUwQSUyMCUyMCUyMCUyMG5ld190b2tlbiUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiZXN0X3BhaXIlNUIwJTVEJTIwJTJCJTIwYmVzdF9wYWlyJTVCMSU1RCU1QjIlM0ElNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGJlc3RfcGFpciU1QjElNUQuc3RhcnRzd2l0aCglMjIlMjMlMjMlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUyMGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHZvY2FiLmFwcGVuZChuZXdfdG9rZW4p",highlighted:`vocab_size = <span class="hljs-number">70</span>
<span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(vocab) &lt; vocab_size:
    scores = compute_pair_scores(splits)
    best_pair, max_score = <span class="hljs-string">&quot;&quot;</span>, <span class="hljs-literal">None</span>
    <span class="hljs-keyword">for</span> pair, score <span class="hljs-keyword">in</span> scores.items():
        <span class="hljs-keyword">if</span> max_score <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_score &lt; score:
            best_pair = pair
            max_score = score
    splits = merge_pair(*best_pair, splits)
    new_token = (
        best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>][<span class="hljs-number">2</span>:]
        <span class="hljs-keyword">if</span> best_pair[<span class="hljs-number">1</span>].startswith(<span class="hljs-string">&quot;##&quot;</span>)
        <span class="hljs-keyword">else</span> best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>]
    )
    vocab.append(new_token)`,wrap:!1}}),zs=new u({props:{code:"cHJpbnQodm9jYWIp",highlighted:'<span class="hljs-built_in">print</span>(vocab)',wrap:!1}}),Bs=new u({props:{code:"JTVCJyU1QlBBRCU1RCclMkMlMjAnJTVCVU5LJTVEJyUyQyUyMCclNUJDTFMlNUQnJTJDJTIwJyU1QlNFUCU1RCclMkMlMjAnJTVCTUFTSyU1RCclMkMlMjAnJTIzJTIzYSclMkMlMjAnJTIzJTIzYiclMkMlMjAnJTIzJTIzYyclMkMlMjAnJTIzJTIzZCclMkMlMjAnJTIzJTIzZSclMkMlMjAnJTIzJTIzZiclMkMlMjAnJTIzJTIzZyclMkMlMjAnJTIzJTIzaCclMkMlMjAnJTIzJTIzaSclMkMlMjAnJTIzJTIzayclMkMlMEElMjAnJTIzJTIzbCclMkMlMjAnJTIzJTIzbSclMkMlMjAnJTIzJTIzbiclMkMlMjAnJTIzJTIzbyclMkMlMjAnJTIzJTIzcCclMkMlMjAnJTIzJTIzciclMkMlMjAnJTIzJTIzcyclMkMlMjAnJTIzJTIzdCclMkMlMjAnJTIzJTIzdSclMkMlMjAnJTIzJTIzdiclMkMlMjAnJTIzJTIzdyclMkMlMjAnJTIzJTIzeSclMkMlMjAnJTIzJTIzeiclMkMlMjAnJTJDJyUyQyUyMCcuJyUyQyUyMCdDJyUyQyUyMCdGJyUyQyUyMCdIJyUyQyUwQSUyMCdUJyUyQyUyMCdhJyUyQyUyMCdiJyUyQyUyMCdjJyUyQyUyMCdnJyUyQyUyMCdoJyUyQyUyMCdpJyUyQyUyMCdzJyUyQyUyMCd0JyUyQyUyMCd1JyUyQyUyMCd3JyUyQyUyMCd5JyUyQyUyMCdhYiclMkMnJTIzJTIzZnUnJTJDJTIwJ0ZhJyUyQyUyMCdGYWMnJTJDJTIwJyUyMyUyM2N0JyUyQyUyMCclMjMlMjNmdWwnJTJDJTIwJyUyMyUyM2Z1bGwnJTJDJTIwJyUyMyUyM2Z1bGx5JyUyQyUwQSUyMCdUaCclMkMlMjAnY2gnJTJDJTIwJyUyMyUyM2htJyUyQyUyMCdjaGEnJTJDJTIwJ2NoYXAnJTJDJTIwJ2NoYXB0JyUyQyUyMCclMjMlMjN0aG0nJTJDJTIwJ0h1JyUyQyUyMCdIdWcnJTJDJTIwJ0h1Z2cnJTJDJTIwJ3NoJyUyQyUyMCd0aCclMkMlMjAnaXMnJTJDJTIwJyUyMyUyM3RobXMnJTJDJTIwJyUyMyUyM3phJyUyQyUyMCclMjMlMjN6YXQnJTJDJTBBJTIwJyUyMyUyM3V0JyU1RA==",highlighted:`[<span class="hljs-string">&#x27;[PAD]&#x27;</span>, <span class="hljs-string">&#x27;[UNK]&#x27;</span>, <span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>, <span class="hljs-string">&#x27;[MASK]&#x27;</span>, <span class="hljs-string">&#x27;##a&#x27;</span>, <span class="hljs-string">&#x27;##b&#x27;</span>, <span class="hljs-string">&#x27;##c&#x27;</span>, <span class="hljs-string">&#x27;##d&#x27;</span>, <span class="hljs-string">&#x27;##e&#x27;</span>, <span class="hljs-string">&#x27;##f&#x27;</span>, <span class="hljs-string">&#x27;##g&#x27;</span>, <span class="hljs-string">&#x27;##h&#x27;</span>, <span class="hljs-string">&#x27;##i&#x27;</span>, <span class="hljs-string">&#x27;##k&#x27;</span>,
 <span class="hljs-string">&#x27;##l&#x27;</span>, <span class="hljs-string">&#x27;##m&#x27;</span>, <span class="hljs-string">&#x27;##n&#x27;</span>, <span class="hljs-string">&#x27;##o&#x27;</span>, <span class="hljs-string">&#x27;##p&#x27;</span>, <span class="hljs-string">&#x27;##r&#x27;</span>, <span class="hljs-string">&#x27;##s&#x27;</span>, <span class="hljs-string">&#x27;##t&#x27;</span>, <span class="hljs-string">&#x27;##u&#x27;</span>, <span class="hljs-string">&#x27;##v&#x27;</span>, <span class="hljs-string">&#x27;##w&#x27;</span>, <span class="hljs-string">&#x27;##y&#x27;</span>, <span class="hljs-string">&#x27;##z&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>,
 <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;ab&#x27;</span>,<span class="hljs-string">&#x27;##fu&#x27;</span>, <span class="hljs-string">&#x27;Fa&#x27;</span>, <span class="hljs-string">&#x27;Fac&#x27;</span>, <span class="hljs-string">&#x27;##ct&#x27;</span>, <span class="hljs-string">&#x27;##ful&#x27;</span>, <span class="hljs-string">&#x27;##full&#x27;</span>, <span class="hljs-string">&#x27;##fully&#x27;</span>,
 <span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;ch&#x27;</span>, <span class="hljs-string">&#x27;##hm&#x27;</span>, <span class="hljs-string">&#x27;cha&#x27;</span>, <span class="hljs-string">&#x27;chap&#x27;</span>, <span class="hljs-string">&#x27;chapt&#x27;</span>, <span class="hljs-string">&#x27;##thm&#x27;</span>, <span class="hljs-string">&#x27;Hu&#x27;</span>, <span class="hljs-string">&#x27;Hug&#x27;</span>, <span class="hljs-string">&#x27;Hugg&#x27;</span>, <span class="hljs-string">&#x27;sh&#x27;</span>, <span class="hljs-string">&#x27;th&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;##thms&#x27;</span>, <span class="hljs-string">&#x27;##za&#x27;</span>, <span class="hljs-string">&#x27;##zat&#x27;</span>,
 <span class="hljs-string">&#x27;##ut&#x27;</span>]`,wrap:!1}}),d=new Ps({props:{$$slots:{default:[zn]},$$scope:{ctx:w}}}),Ns=new u({props:{code:"ZGVmJTIwZW5jb2RlX3dvcmQod29yZCklM0ElMEElMjAlMjAlMjAlMjB0b2tlbnMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjB3aGlsZSUyMGxlbih3b3JkKSUyMCUzRSUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTNEJTIwbGVuKHdvcmQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2hpbGUlMjBpJTIwJTNFJTIwMCUyMGFuZCUyMHdvcmQlNUIlM0FpJTVEJTIwbm90JTIwaW4lMjB2b2NhYiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGklMjAtJTNEJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwaSUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlNUIlMjIlNUJVTkslNUQlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbnMuYXBwZW5kKHdvcmQlNUIlM0FpJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdvcmQlMjAlM0QlMjB3b3JkJTVCaSUzQSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGVuKHdvcmQpJTIwJTNFJTIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdvcmQlMjAlM0QlMjBmJTIyJTIzJTIzJTdCd29yZCU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2Vucw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">encode_word</span>(<span class="hljs-params">word</span>):
    tokens = []
    <span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(word) &gt; <span class="hljs-number">0</span>:
        i = <span class="hljs-built_in">len</span>(word)
        <span class="hljs-keyword">while</span> i &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">and</span> word[:i] <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> vocab:
            i -= <span class="hljs-number">1</span>
        <span class="hljs-keyword">if</span> i == <span class="hljs-number">0</span>:
            <span class="hljs-keyword">return</span> [<span class="hljs-string">&quot;[UNK]&quot;</span>]
        tokens.append(word[:i])
        word = word[i:]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(word) &gt; <span class="hljs-number">0</span>:
            word = <span class="hljs-string">f&quot;##<span class="hljs-subst">{word}</span>&quot;</span>
    <span class="hljs-keyword">return</span> tokens`,wrap:!1}}),Es=new u({props:{code:"cHJpbnQoZW5jb2RlX3dvcmQoJTIySHVnZ2luZyUyMikpJTBBcHJpbnQoZW5jb2RlX3dvcmQoJTIySE9nZ2luZyUyMikp",highlighted:`<span class="hljs-built_in">print</span>(encode_word(<span class="hljs-string">&quot;Hugging&quot;</span>))
<span class="hljs-built_in">print</span>(encode_word(<span class="hljs-string">&quot;HOgging&quot;</span>))`,wrap:!1}}),Ss=new u({props:{code:"JTVCJ0h1Z2cnJTJDJTIwJyUyMyUyM2knJTJDJTIwJyUyMyUyM24nJTJDJTIwJyUyMyUyM2cnJTVEJTBBJTVCJyU1QlVOSyU1RCclNUQ=",highlighted:`[<span class="hljs-string">&#x27;Hugg&#x27;</span>, <span class="hljs-string">&#x27;##i&#x27;</span>, <span class="hljs-string">&#x27;##n&#x27;</span>, <span class="hljs-string">&#x27;##g&#x27;</span>]
[<span class="hljs-string">&#x27;[UNK]&#x27;</span>]`,wrap:!1}}),Vs=new u({props:{code:"ZGVmJTIwdG9rZW5pemUodGV4dCklM0ElMEElMjAlMjAlMjAlMjBwcmVfdG9rZW5pemVfcmVzdWx0JTIwJTNEJTIwdG9rZW5pemVyLl90b2tlbml6ZXIucHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKHRleHQpJTBBJTIwJTIwJTIwJTIwcHJlX3Rva2VuaXplZF90ZXh0JTIwJTNEJTIwJTVCd29yZCUyMGZvciUyMHdvcmQlMkMlMjBvZmZzZXQlMjBpbiUyMHByZV90b2tlbml6ZV9yZXN1bHQlNUQlMEElMjAlMjAlMjAlMjBlbmNvZGVkX3dvcmRzJTIwJTNEJTIwJTVCZW5jb2RlX3dvcmQod29yZCklMjBmb3IlMjB3b3JkJTIwaW4lMjBwcmVfdG9rZW5pemVkX3RleHQlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzdW0oZW5jb2RlZF93b3JkcyUyQyUyMCU1QiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">text</span>):
    pre_tokenize_result = tokenizer._tokenizer.pre_tokenizer.pre_tokenize_str(text)
    pre_tokenized_text = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> pre_tokenize_result]
    encoded_words = [encode_word(word) <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> pre_tokenized_text]
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">sum</span>(encoded_words, [])`,wrap:!1}}),Ws=new u({props:{code:"dG9rZW5pemUoJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBjb3Vyc2UhJTIyKQ==",highlighted:'tokenize(<span class="hljs-string">&quot;This is the Hugging Face course!&quot;</span>)',wrap:!1}}),Hs=new u({props:{code:"JTVCJ1RoJyUyQyUyMCclMjMlMjNpJyUyQyUyMCclMjMlMjNzJyUyQyUyMCdpcyclMkMlMjAndGgnJTJDJTIwJyUyMyUyM2UnJTJDJTIwJ0h1Z2cnJTJDJTIwJyUyMyUyM2knJTJDJTIwJyUyMyUyM24nJTJDJTIwJyUyMyUyM2cnJTJDJTIwJ0ZhYyclMkMlMjAnJTIzJTIzZSclMkMlMjAnYyclMkMlMjAnJTIzJTIzbyclMkMlMjAnJTIzJTIzdSclMkMlMjAnJTIzJTIzciclMkMlMjAnJTIzJTIzcyclMkMlMEElMjAnJTIzJTIzZSclMkMlMjAnJTVCVU5LJTVEJyU1RA==",highlighted:`[<span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;##i&#x27;</span>, <span class="hljs-string">&#x27;##s&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;th&#x27;</span>, <span class="hljs-string">&#x27;##e&#x27;</span>, <span class="hljs-string">&#x27;Hugg&#x27;</span>, <span class="hljs-string">&#x27;##i&#x27;</span>, <span class="hljs-string">&#x27;##n&#x27;</span>, <span class="hljs-string">&#x27;##g&#x27;</span>, <span class="hljs-string">&#x27;Fac&#x27;</span>, <span class="hljs-string">&#x27;##e&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;##o&#x27;</span>, <span class="hljs-string">&#x27;##u&#x27;</span>, <span class="hljs-string">&#x27;##r&#x27;</span>, <span class="hljs-string">&#x27;##s&#x27;</span>,
 <span class="hljs-string">&#x27;##e&#x27;</span>, <span class="hljs-string">&#x27;[UNK]&#x27;</span>]`,wrap:!1}}),{c(){M=e("meta"),m=t(),T=e("p"),h=t(),j(b.$$.fragment),Ks=t(),j(f.$$.fragment),Ls=t(),q=e("p"),q.textContent=qa,Os=t(),j($.$$.fragment),sl=t(),j(I.$$.fragment),ll=t(),j(k.$$.fragment),al=t(),j(C.$$.fragment),nl=t(),A=e("p"),A.innerHTML=$a,tl=t(),j(Q.$$.fragment),pl=t(),z=e("p"),z.textContent=ka,Ml=t(),B=e("p"),ba=Cn(`然后,再次像 BPE 一样,WordPiece 学习合并规则。主要区别在于选择要合并的对的方式。WordPiece 不是选择最频繁的对，而是使用以下公式计算每对的分数:
`),el=new xn(!1),yl=t(),v=e("p"),v.innerHTML=Aa,jl=t(),Z=e("p"),Z.textContent=Qa,il=t(),j(N.$$.fragment),Jl=t(),_=e("p"),_.textContent=za,cl=t(),j(E.$$.fragment),rl=t(),S=e("p"),S.innerHTML=Ba,Ul=t(),G=e("p"),G.innerHTML=va,ol=t(),j(V.$$.fragment),Tl=t(),X=e("p"),X.innerHTML=Za,ul=t(),j(W.$$.fragment),ml=t(),H=e("p"),H.innerHTML=Na,hl=t(),j(R.$$.fragment),wl=t(),Y=e("p"),Y.textContent=_a,Il=t(),j(x.$$.fragment),Cl=t(),j(D.$$.fragment),xl=t(),P=e("p"),P.innerHTML=Ea,gl=t(),F=e("p"),F.innerHTML=Sa,dl=t(),K=e("p"),K.innerHTML=Ga,bl=t(),L=e("p"),L.innerHTML=Va,fl=t(),j(g.$$.fragment),ql=t(),j(O.$$.fragment),$l=t(),ss=e("p"),ss.textContent=Xa,kl=t(),ls=e("p"),ls.textContent=Wa,Al=t(),j(as.$$.fragment),Ql=t(),ns=e("p"),ns.innerHTML=Ha,zl=t(),j(ts.$$.fragment),Bl=t(),ps=e("p"),ps.textContent=Ra,vl=t(),j(Ms.$$.fragment),Zl=t(),j(es.$$.fragment),Nl=t(),ys=e("p"),ys.innerHTML=Ya,_l=t(),j(js.$$.fragment),El=t(),j(is.$$.fragment),Sl=t(),Js=e("p"),Js.innerHTML=Da,Gl=t(),j(cs.$$.fragment),Vl=t(),rs=e("p"),rs.innerHTML=Pa,Xl=t(),j(Us.$$.fragment),Wl=t(),os=e("p"),os.textContent=Fa,Hl=t(),j(Ts.$$.fragment),Rl=t(),us=e("p"),us.textContent=Ka,Yl=t(),j(ms.$$.fragment),Dl=t(),j(hs.$$.fragment),Pl=t(),ws=e("p"),ws.textContent=La,Fl=t(),j(Is.$$.fragment),Kl=t(),j(Cs.$$.fragment),Ll=t(),xs=e("p"),xs.innerHTML=Oa,Ol=t(),j(gs.$$.fragment),sa=t(),ds=e("p"),ds.innerHTML=sn,la=t(),j(bs.$$.fragment),aa=t(),fs=e("p"),fs.textContent=ln,na=t(),j(qs.$$.fragment),ta=t(),j($s.$$.fragment),pa=t(),ks=e("p"),ks.textContent=an,Ma=t(),j(As.$$.fragment),ea=t(),Qs=e("p"),Qs.textContent=nn,ya=t(),j(zs.$$.fragment),ja=t(),j(Bs.$$.fragment),ia=t(),vs=e("p"),vs.textContent=tn,Ja=t(),j(d.$$.fragment),ca=t(),Zs=e("p"),Zs.textContent=pn,ra=t(),j(Ns.$$.fragment),Ua=t(),_s=e("p"),_s.textContent=Mn,oa=t(),j(Es.$$.fragment),Ta=t(),j(Ss.$$.fragment),ua=t(),Gs=e("p"),Gs.textContent=en,ma=t(),j(Vs.$$.fragment),ha=t(),Xs=e("p"),Xs.textContent=yn,wa=t(),j(Ws.$$.fragment),Ia=t(),j(Hs.$$.fragment),Ca=t(),Rs=e("p"),Rs.textContent=jn,xa=t(),Ds=e("p"),this.h()},l(s){const l=gn("svelte-u9bgzb",document.head);M=y(l,"META",{name:!0,content:!0}),l.forEach(a),m=p(s),T=y(s,"P",{}),fa(T).forEach(a),h=p(s),i(b.$$.fragment,s),Ks=p(s),i(f.$$.fragment,s),Ls=p(s),q=y(s,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1migf7z"&&(q.textContent=qa),Os=p(s),i($.$$.fragment,s),sl=p(s),i(I.$$.fragment,s),ll=p(s),i(k.$$.fragment,s),al=p(s),i(C.$$.fragment,s),nl=p(s),A=y(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-9tm62y"&&(A.innerHTML=$a),tl=p(s),i(Q.$$.fragment,s),pl=p(s),z=y(s,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1jzncgn"&&(z.textContent=ka),Ml=p(s),B=y(s,"P",{});var Ys=fa(B);ba=dn(Ys,`然后,再次像 BPE 一样,WordPiece 学习合并规则。主要区别在于选择要合并的对的方式。WordPiece 不是选择最频繁的对，而是使用以下公式计算每对的分数:
`),el=bn(Ys,!1),Ys.forEach(a),yl=p(s),v=y(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-kt6lsm"&&(v.innerHTML=Aa),jl=p(s),Z=y(s,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1vlhnkf"&&(Z.textContent=Qa),il=p(s),i(N.$$.fragment,s),Jl=p(s),_=y(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-121od2u"&&(_.textContent=za),cl=p(s),i(E.$$.fragment,s),rl=p(s),S=y(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1lvsz0w"&&(S.innerHTML=Ba),Ul=p(s),G=y(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1dxfw60"&&(G.innerHTML=va),ol=p(s),i(V.$$.fragment,s),Tl=p(s),X=y(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-97h5q6"&&(X.innerHTML=Za),ul=p(s),i(W.$$.fragment,s),ml=p(s),H=y(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-15w9iq3"&&(H.innerHTML=Na),hl=p(s),i(R.$$.fragment,s),wl=p(s),Y=y(s,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-l3zbsd"&&(Y.textContent=_a),Il=p(s),i(x.$$.fragment,s),Cl=p(s),i(D.$$.fragment,s),xl=p(s),P=y(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1qv976t"&&(P.innerHTML=Ea),gl=p(s),F=y(s,"P",{"data-svelte-h":!0}),o(F)!=="svelte-fr1hrp"&&(F.innerHTML=Sa),dl=p(s),K=y(s,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1ccav78"&&(K.innerHTML=Ga),bl=p(s),L=y(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1pcprjl"&&(L.innerHTML=Va),fl=p(s),i(g.$$.fragment,s),ql=p(s),i(O.$$.fragment,s),$l=p(s),ss=y(s,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-tl8hu6"&&(ss.textContent=Xa),kl=p(s),ls=y(s,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-17q0ff2"&&(ls.textContent=Wa),Al=p(s),i(as.$$.fragment,s),Ql=p(s),ns=y(s,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-1tvaqog"&&(ns.innerHTML=Ha),zl=p(s),i(ts.$$.fragment,s),Bl=p(s),ps=y(s,"P",{"data-svelte-h":!0}),o(ps)!=="svelte-iztpt8"&&(ps.textContent=Ra),vl=p(s),i(Ms.$$.fragment,s),Zl=p(s),i(es.$$.fragment,s),Nl=p(s),ys=y(s,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-16qxofq"&&(ys.innerHTML=Ya),_l=p(s),i(js.$$.fragment,s),El=p(s),i(is.$$.fragment,s),Sl=p(s),Js=y(s,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-og91nk"&&(Js.innerHTML=Da),Gl=p(s),i(cs.$$.fragment,s),Vl=p(s),rs=y(s,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-c6ui3n"&&(rs.innerHTML=Pa),Xl=p(s),i(Us.$$.fragment,s),Wl=p(s),os=y(s,"P",{"data-svelte-h":!0}),o(os)!=="svelte-1qb7ltg"&&(os.textContent=Fa),Hl=p(s),i(Ts.$$.fragment,s),Rl=p(s),us=y(s,"P",{"data-svelte-h":!0}),o(us)!=="svelte-1dpjieb"&&(us.textContent=Ka),Yl=p(s),i(ms.$$.fragment,s),Dl=p(s),i(hs.$$.fragment,s),Pl=p(s),ws=y(s,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-4j7dgo"&&(ws.textContent=La),Fl=p(s),i(Is.$$.fragment,s),Kl=p(s),i(Cs.$$.fragment,s),Ll=p(s),xs=y(s,"P",{"data-svelte-h":!0}),o(xs)!=="svelte-1nclg0t"&&(xs.innerHTML=Oa),Ol=p(s),i(gs.$$.fragment,s),sa=p(s),ds=y(s,"P",{"data-svelte-h":!0}),o(ds)!=="svelte-38z9n2"&&(ds.innerHTML=sn),la=p(s),i(bs.$$.fragment,s),aa=p(s),fs=y(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-3nxfgz"&&(fs.textContent=ln),na=p(s),i(qs.$$.fragment,s),ta=p(s),i($s.$$.fragment,s),pa=p(s),ks=y(s,"P",{"data-svelte-h":!0}),o(ks)!=="svelte-1sdjcpf"&&(ks.textContent=an),Ma=p(s),i(As.$$.fragment,s),ea=p(s),Qs=y(s,"P",{"data-svelte-h":!0}),o(Qs)!=="svelte-ux5sx0"&&(Qs.textContent=nn),ya=p(s),i(zs.$$.fragment,s),ja=p(s),i(Bs.$$.fragment,s),ia=p(s),vs=y(s,"P",{"data-svelte-h":!0}),o(vs)!=="svelte-1pdinme"&&(vs.textContent=tn),Ja=p(s),i(d.$$.fragment,s),ca=p(s),Zs=y(s,"P",{"data-svelte-h":!0}),o(Zs)!=="svelte-kehz37"&&(Zs.textContent=pn),ra=p(s),i(Ns.$$.fragment,s),Ua=p(s),_s=y(s,"P",{"data-svelte-h":!0}),o(_s)!=="svelte-1mof0f0"&&(_s.textContent=Mn),oa=p(s),i(Es.$$.fragment,s),Ta=p(s),i(Ss.$$.fragment,s),ua=p(s),Gs=y(s,"P",{"data-svelte-h":!0}),o(Gs)!=="svelte-17ubbes"&&(Gs.textContent=en),ma=p(s),i(Vs.$$.fragment,s),ha=p(s),Xs=y(s,"P",{"data-svelte-h":!0}),o(Xs)!=="svelte-1yc8t2u"&&(Xs.textContent=yn),wa=p(s),i(Ws.$$.fragment,s),Ia=p(s),i(Hs.$$.fragment,s),Ca=p(s),Rs=y(s,"P",{"data-svelte-h":!0}),o(Rs)!=="svelte-1yqra1i"&&(Rs.textContent=jn),xa=p(s),Ds=y(s,"P",{}),fa(Ds).forEach(a),this.h()},h(){on(M,"name","hf:doc:metadata"),on(M,"content",vn),el.a=null},m(s,l){Tn(document.head,M),n(s,m,l),n(s,T,l),n(s,h,l),J(b,s,l),n(s,Ks,l),J(f,s,l),n(s,Ls,l),n(s,q,l),n(s,Os,l),J($,s,l),n(s,sl,l),J(I,s,l),n(s,ll,l),J(k,s,l),n(s,al,l),J(C,s,l),n(s,nl,l),n(s,A,l),n(s,tl,l),J(Q,s,l),n(s,pl,l),n(s,z,l),n(s,Ml,l),n(s,B,l),Tn(B,ba),el.m(un,B),n(s,yl,l),n(s,v,l),n(s,jl,l),n(s,Z,l),n(s,il,l),J(N,s,l),n(s,Jl,l),n(s,_,l),n(s,cl,l),J(E,s,l),n(s,rl,l),n(s,S,l),n(s,Ul,l),n(s,G,l),n(s,ol,l),J(V,s,l),n(s,Tl,l),n(s,X,l),n(s,ul,l),J(W,s,l),n(s,ml,l),n(s,H,l),n(s,hl,l),J(R,s,l),n(s,wl,l),n(s,Y,l),n(s,Il,l),J(x,s,l),n(s,Cl,l),J(D,s,l),n(s,xl,l),n(s,P,l),n(s,gl,l),n(s,F,l),n(s,dl,l),n(s,K,l),n(s,bl,l),n(s,L,l),n(s,fl,l),J(g,s,l),n(s,ql,l),J(O,s,l),n(s,$l,l),n(s,ss,l),n(s,kl,l),n(s,ls,l),n(s,Al,l),J(as,s,l),n(s,Ql,l),n(s,ns,l),n(s,zl,l),J(ts,s,l),n(s,Bl,l),n(s,ps,l),n(s,vl,l),J(Ms,s,l),n(s,Zl,l),J(es,s,l),n(s,Nl,l),n(s,ys,l),n(s,_l,l),J(js,s,l),n(s,El,l),J(is,s,l),n(s,Sl,l),n(s,Js,l),n(s,Gl,l),J(cs,s,l),n(s,Vl,l),n(s,rs,l),n(s,Xl,l),J(Us,s,l),n(s,Wl,l),n(s,os,l),n(s,Hl,l),J(Ts,s,l),n(s,Rl,l),n(s,us,l),n(s,Yl,l),J(ms,s,l),n(s,Dl,l),J(hs,s,l),n(s,Pl,l),n(s,ws,l),n(s,Fl,l),J(Is,s,l),n(s,Kl,l),J(Cs,s,l),n(s,Ll,l),n(s,xs,l),n(s,Ol,l),J(gs,s,l),n(s,sa,l),n(s,ds,l),n(s,la,l),J(bs,s,l),n(s,aa,l),n(s,fs,l),n(s,na,l),J(qs,s,l),n(s,ta,l),J($s,s,l),n(s,pa,l),n(s,ks,l),n(s,Ma,l),J(As,s,l),n(s,ea,l),n(s,Qs,l),n(s,ya,l),J(zs,s,l),n(s,ja,l),J(Bs,s,l),n(s,ia,l),n(s,vs,l),n(s,Ja,l),J(d,s,l),n(s,ca,l),n(s,Zs,l),n(s,ra,l),J(Ns,s,l),n(s,Ua,l),n(s,_s,l),n(s,oa,l),J(Es,s,l),n(s,Ta,l),J(Ss,s,l),n(s,ua,l),n(s,Gs,l),n(s,ma,l),J(Vs,s,l),n(s,ha,l),n(s,Xs,l),n(s,wa,l),J(Ws,s,l),n(s,Ia,l),J(Hs,s,l),n(s,Ca,l),n(s,Rs,l),n(s,xa,l),n(s,Ds,l),ga=!0},p(s,[l]){const Ys={};l&2&&(Ys.$$scope={dirty:l,ctx:s}),I.$set(Ys);const Jn={};l&2&&(Jn.$$scope={dirty:l,ctx:s}),C.$set(Jn);const cn={};l&2&&(cn.$$scope={dirty:l,ctx:s}),x.$set(cn);const rn={};l&2&&(rn.$$scope={dirty:l,ctx:s}),g.$set(rn);const Un={};l&2&&(Un.$$scope={dirty:l,ctx:s}),d.$set(Un)},i(s){ga||(c(b.$$.fragment,s),c(f.$$.fragment,s),c($.$$.fragment,s),c(I.$$.fragment,s),c(k.$$.fragment,s),c(C.$$.fragment,s),c(Q.$$.fragment,s),c(N.$$.fragment,s),c(E.$$.fragment,s),c(V.$$.fragment,s),c(W.$$.fragment,s),c(R.$$.fragment,s),c(x.$$.fragment,s),c(D.$$.fragment,s),c(g.$$.fragment,s),c(O.$$.fragment,s),c(as.$$.fragment,s),c(ts.$$.fragment,s),c(Ms.$$.fragment,s),c(es.$$.fragment,s),c(js.$$.fragment,s),c(is.$$.fragment,s),c(cs.$$.fragment,s),c(Us.$$.fragment,s),c(Ts.$$.fragment,s),c(ms.$$.fragment,s),c(hs.$$.fragment,s),c(Is.$$.fragment,s),c(Cs.$$.fragment,s),c(gs.$$.fragment,s),c(bs.$$.fragment,s),c(qs.$$.fragment,s),c($s.$$.fragment,s),c(As.$$.fragment,s),c(zs.$$.fragment,s),c(Bs.$$.fragment,s),c(d.$$.fragment,s),c(Ns.$$.fragment,s),c(Es.$$.fragment,s),c(Ss.$$.fragment,s),c(Vs.$$.fragment,s),c(Ws.$$.fragment,s),c(Hs.$$.fragment,s),ga=!0)},o(s){r(b.$$.fragment,s),r(f.$$.fragment,s),r($.$$.fragment,s),r(I.$$.fragment,s),r(k.$$.fragment,s),r(C.$$.fragment,s),r(Q.$$.fragment,s),r(N.$$.fragment,s),r(E.$$.fragment,s),r(V.$$.fragment,s),r(W.$$.fragment,s),r(R.$$.fragment,s),r(x.$$.fragment,s),r(D.$$.fragment,s),r(g.$$.fragment,s),r(O.$$.fragment,s),r(as.$$.fragment,s),r(ts.$$.fragment,s),r(Ms.$$.fragment,s),r(es.$$.fragment,s),r(js.$$.fragment,s),r(is.$$.fragment,s),r(cs.$$.fragment,s),r(Us.$$.fragment,s),r(Ts.$$.fragment,s),r(ms.$$.fragment,s),r(hs.$$.fragment,s),r(Is.$$.fragment,s),r(Cs.$$.fragment,s),r(gs.$$.fragment,s),r(bs.$$.fragment,s),r(qs.$$.fragment,s),r($s.$$.fragment,s),r(As.$$.fragment,s),r(zs.$$.fragment,s),r(Bs.$$.fragment,s),r(d.$$.fragment,s),r(Ns.$$.fragment,s),r(Es.$$.fragment,s),r(Ss.$$.fragment,s),r(Vs.$$.fragment,s),r(Ws.$$.fragment,s),r(Hs.$$.fragment,s),ga=!1},d(s){s&&(a(m),a(T),a(h),a(Ks),a(Ls),a(q),a(Os),a(sl),a(ll),a(al),a(nl),a(A),a(tl),a(pl),a(z),a(Ml),a(B),a(yl),a(v),a(jl),a(Z),a(il),a(Jl),a(_),a(cl),a(rl),a(S),a(Ul),a(G),a(ol),a(Tl),a(X),a(ul),a(ml),a(H),a(hl),a(wl),a(Y),a(Il),a(Cl),a(xl),a(P),a(gl),a(F),a(dl),a(K),a(bl),a(L),a(fl),a(ql),a($l),a(ss),a(kl),a(ls),a(Al),a(Ql),a(ns),a(zl),a(Bl),a(ps),a(vl),a(Zl),a(Nl),a(ys),a(_l),a(El),a(Sl),a(Js),a(Gl),a(Vl),a(rs),a(Xl),a(Wl),a(os),a(Hl),a(Rl),a(us),a(Yl),a(Dl),a(Pl),a(ws),a(Fl),a(Kl),a(Ll),a(xs),a(Ol),a(sa),a(ds),a(la),a(aa),a(fs),a(na),a(ta),a(pa),a(ks),a(Ma),a(ea),a(Qs),a(ya),a(ja),a(ia),a(vs),a(Ja),a(ca),a(Zs),a(ra),a(Ua),a(_s),a(oa),a(Ta),a(ua),a(Gs),a(ma),a(ha),a(Xs),a(wa),a(Ia),a(Ca),a(Rs),a(xa),a(Ds)),a(M),U(b,s),U(f,s),U($,s),U(I,s),U(k,s),U(C,s),U(Q,s),U(N,s),U(E,s),U(V,s),U(W,s),U(R,s),U(x,s),U(D,s),U(g,s),U(O,s),U(as,s),U(ts,s),U(Ms,s),U(es,s),U(js,s),U(is,s),U(cs,s),U(Us,s),U(Ts,s),U(ms,s),U(hs,s),U(Is,s),U(Cs,s),U(gs,s),U(bs,s),U(qs,s),U($s,s),U(As,s),U(zs,s),U(Bs,s),U(d,s),U(Ns,s),U(Es,s),U(Ss,s),U(Vs,s),U(Ws,s),U(Hs,s)}}}const vn='{"title":"WordPiece 标记化","local":"WordPiece 标记化","sections":[{"title":"训练算法","local":"训练算法","sections":[],"depth":2},{"title":"标记化算法","local":"标记化算法","sections":[],"depth":2},{"title":"实现 WordPiece","local":"实现 WordPiece","sections":[],"depth":2}],"depth":1}';function Zn(w){return hn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wn extends wn{constructor(M){super(),In(this,M,Zn,Bn,mn,{})}}export{Wn as component};
