import{s as Ga,o as Xa,n as La}from"../chunks/scheduler.c57aa7ef.js";import{S as Aa,i as Qa,g as i,s,r as p,A as qa,h as o,f as a,c as n,j as Ia,u as d,x as r,k as Ca,y as Va,a as l,v as m,d as h,t as f,w as c}from"../chunks/index.c50cb18e.js";import{T as Wa}from"../chunks/Tip.9268b0ca.js";import{C as w}from"../chunks/CodeBlock.34f0a53d.js";import{H as y}from"../chunks/Heading.c7d7e0e7.js";function Fa(We){let u,T='Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.';return{c(){u=i("p"),u.innerHTML=T},l(M){u=o(M,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1nbpolx"&&(u.innerHTML=T)},m(M,b){l(M,u,b)},p:La,d(M){M&&a(u)}}}function Ha(We){let u,T='There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.';return{c(){u=i("p"),u.innerHTML=T},l(M){u=o(M,"P",{"data-svelte-h":!0}),r(u)!=="svelte-19y7vpj"&&(u.innerHTML=T)},m(M,b){l(M,u,b)},p:La,d(M){M&&a(u)}}}function Ea(We){let u,T,M,b,_,Ge,Z,Pt='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Xe,j,Dt="This guide explores in more detail other options and features for using LoRA.",Ae,$,Qe,U,Kt='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',qe,k,Ot='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',Ve,v,Fe,R,ea="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",He,B,Ee,I,ze,C,xe,W,ta='When quantizing the base model for QLoRA training, consider using the <a href="https://arxiv.org/abs/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. To use LoftQ, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',Ye,L,aa="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",Ne,G,Se,X,la="An easier but more limited way to apply LoftQ initialization is to use the convenience function <code>replace_lora_weights_loftq</code>. This takes the quantized PEFT model as input and replaces the LoRA weights in-place with their LoftQ-initialized counterparts.",Pe,A,De,Q,sa='<code>replace_lora_weights_loftq</code> also allows you to pass a <code>callback</code> argument to give you more control over which layers should be modified or not, which empirically can improve the results quite a lot. To see a more elaborate example of this, check out <a href="https://github.com/huggingface/peft/blob/main/examples/loftq_finetuning/LoftQ_weight_replacement.ipynb" rel="nofollow">this notebook</a>.',Ke,q,na="<code>replace_lora_weights_loftq</code> implements only one iteration step of LoftQ. This means that only the LoRA weights are updated, instead of iteratevily updating LoRA weights and quantized base model weights. This may lead to lower performance but has the advantage that we can use the original quantized weights derived from the base model, instead of having to keep an extra copy of modified quantized weights. Whether this tradeoff is worthwhile depends on the use case.",Oe,V,ia="At the moment, <code>replace_lora_weights_loftq</code> has these additional limitations:",et,F,oa="<li>Model files must be stored as a <code>safetensors</code> file.</li> <li>Only bitsandbytes 4bit quantization is supported.</li>",tt,g,at,H,lt,E,ra='Another way to initialize <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',st,z,nt,x,it,Y,pa='This technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can improve the performance of LoRA, especially at low ranks. For more information on DoRA, see  <a href="https://arxiv.org/abs/2402.09353" rel="nofollow">https://arxiv.org/abs/2402.09353</a>.',ot,N,rt,S,pt,P,da='<li>DoRA only supports linear and Conv2d layers at the momement.</li> <li>DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for inference, see <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">LoraModel.merge_and_unload()</a>.</li> <li>DoRA should work with weights quantized with bitsandbytes (“QDoRA”). However, issues have been reported when using QDoRA with DeepSpeed Zero2.</li>',dt,D,mt,K,ma='The default LoRA settings in PEFT add trainable weights to the query and value layers of each attention block. But <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, which adds trainable weights to all the linear layers of a transformer model, can provide performance equal to a fully finetuned model. To apply LoRA to all the linear layers, like in QLoRA, set <code>target_modules=&quot;all-linear&quot;</code> (easier than specifying individual modules by name which can vary depending on the architecture).',ht,O,ft,ee,ct,te,ha='An approach used to improve the performance of models is to expand a model by duplicating layers in the model to build a larger model from a pretrained model of a given size. For example increasing a 7B model to a 10B model as described in the <a href="https://arxiv.org/abs/2312.15166" rel="nofollow">SOLAR</a> paper. PEFT LoRA supports this kind of expansion in a memory efficient manner that supports further fine-tuning using LoRA adapters attached to the layers post replication of the layers. The replicated layers do not take additional memory as they share the underlying weights so the only additional memory required is the memory for the adapter weights. To use this feature you would create a config with the <code>layer_replication</code> argument.',ut,ae,Mt,le,fa='Assuming the original model had 5 layers <code>[0, 1, 2 ,3, 4]</code>, this would create a model with 7 layers arranged as <code>[0, 1, 2, 3, 2, 3, 4]</code>. This follows the <a href="https://github.com/arcee-ai/mergekit" rel="nofollow">mergekit</a> pass through merge convention where sequences of layers specified as start inclusive and end exclusive tuples are stacked to build the final model. Each layer in the final model gets its own distinct set of LoRA adpaters.',wt,se,ca=`<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B" rel="nofollow">Fewshot-Metamath-OrcaVicuna-Mistral-10B</a> is an example of a model trained using this method on Mistral-7B expanded to 10B. The
<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B/blob/main/adapter_config.json" rel="nofollow">adapter_config.json</a> shows a sample LoRA adapter config applying this method for fine-tuning.`,yt,ne,Tt,ie,ua='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',bt,oe,gt,re,Ma='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',Jt,pe,_t,de,wa='The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',Zt,me,ya="First load the base model:",jt,he,$t,fe,Ta="Then we load the first adapter:",Ut,ce,kt,ue,ba="Then load a different adapter and merge it with the first one:",vt,Me,Rt,J,Bt,we,ga="Now, perform inference:",It,ye,Ct,Te,Wt,be,Ja='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.set_adapter">set_adapter()</a> function.',Lt,ge,Gt,Je,_a='To return the base model, you could use <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',Xt,_e,At,Ze,Qt,je,Za="Normally, each inference batch has to use the same adapter(s) in PEFT. This can sometimes be annoying, because we may have batches that contain samples intended to be used with different LoRA adapters. For example, we could have a base model that works well in English and two more LoRA adapters, one for French and one for German. Usually, we would have to split our batches such that each batch only contains samples of one of the languages, we cannot combine different languages in the same batch.",qt,$e,ja="Thankfully, it is possible to mix different LoRA adapters in the same batch using the <code>adapter_name</code> argument. Below, we show an examle of how this works in practice. First, let’s load the base model, English, and the two adapters, French and German, like this:",Vt,Ue,Ft,ke,$a="Now, we want to generate text on a sample that contains all three languages: The first three samples are in English, the next three are in French, and the last three are in German. We can use the <code>adapter_names</code> argument to specify which adapter to use for each sample. Since our base model is used for English, we use the special string <code>&quot;__base__&quot;</code> for these samples. For the next three samples, we indicate the adapter name of the French LoRA fine-tune, in this case <code>&quot;adapter_fr&quot;</code>. For the last three samples, we indicate the adapter name of the German LoRA fine-tune, in this case <code>&quot;adapter_de&quot;</code>. This way, we can use the base model and the two adapters in a single batch.",Ht,ve,Et,Re,Ua="Note that the order does not matter here, i.e. the samples in the batch don’t need to be grouped by adapter as in the example above. We just need to ensure that the <code>adapter_names</code> argument is aligned correctly with the samples.",zt,Be,xt,Ie,ka="Using this features has some drawbacks, namely:",Yt,Ce,va='<li>It only works for inference, not for training.</li> <li>Disabling adapters using the <code>with model.disable_adapter()</code> context takes precedence over <code>adapter_names</code>.</li> <li>You cannot pass <code>adapter_names</code> when some adapter weights where merged with base weight using the <code>merge_adapter</code> method. Please unmerge all adapters first by calling <code>model.unmerge_adapter()</code>.</li> <li>For obvious reasons, this cannot be used after calling <code>merge_and_unload()</code>, since all the LoRA adapters will be merged into the base weights in this case.</li> <li>This feature does not currently work with DoRA, so set <code>use_dora=False</code> in your <code>LoraConfig</code> if you want to use it.</li> <li>There is an expected overhead for inference with <code>adapter_names</code>, especially if the amount of different adapters in the batch is high. This is because the batch size is effectively reduced to the number of samples per adapter. If runtime performance is your top priority, try the following:<ul><li>Increase the batch size.</li> <li>Try to avoid having a large number of different adapters in the same batch, prefer homogeneous batches. This can be achieved by buffering samples with the same adapter and only perform inference with a small handfull of different adapters.</li> <li>Take a look at alternative implementations such as <a href="https://github.com/predibase/lorax" rel="nofollow">LoRAX</a>, <a href="https://github.com/punica-ai/punica" rel="nofollow">punica</a>, or <a href="https://github.com/S-LoRA/S-LoRA" rel="nofollow">S-LoRA</a>, which are specialized to work with a large number of different adapters.</li></ul></li>',Nt,Le,St;return _=new y({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),$=new y({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),v=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),B=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),I=new y({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),C=new y({props:{title:"Standard approach",local:"standard-approach",headingTag:"h4"}}),G=new y({props:{title:"A more convienient way",local:"a-more-convienient-way",headingTag:"h4"}}),A=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjByZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjAuLi4pJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCguLi4lMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEElMjMlMjBub3RlJTNBJTIwZG9uJ3QlMjBwYXNzJTIwaW5pdF9sb3JhX3dlaWdodHMlM0QlMjJsb2Z0cSUyMiUyMG9yJTIwbG9mdHFfY29uZmlnISUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIpJTBBcGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBsb3JhX2NvbmZpZyklMEFyZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cShwZWZ0X21vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> replace_lora_weights_loftq
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, ...)
base_model = AutoModelForCausalLM.from_pretrained(..., quantization_config=bnb_config)
<span class="hljs-comment"># note: don&#x27;t pass init_lora_weights=&quot;loftq&quot; or loftq_config!</span>
lora_config = LoraConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>)
peft_model = get_peft_model(base_model, lora_config)
replace_lora_weights_loftq(peft_model)`,wrap:!1}}),g=new Wa({props:{$$slots:{default:[Fa]},$$scope:{ctx:We}}}),H=new y({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),z=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),x=new y({props:{title:"Weight-Decomposed Low-Rank Adaptation (DoRA)",local:"weight-decomposed-low-rank-adaptation-dora",headingTag:"h3"}}),N=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfZG9yYSUzRFRydWUlMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),S=new y({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),D=new y({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),O=new w({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),ee=new y({props:{title:"Memory efficient Layer Replication with LoRA",local:"memory-efficient-layer-replication-with-lora",headingTag:"h3"}}),ae=new w({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhsYXllcl9yZXBsaWNhdGlvbiUzRCU1QiU1QjAlMkM0JTVEJTJDJTIwJTVCMiUyQzUlNUQlNUQlMkMlMjAuLi4p",highlighted:'config = LoraConfig(layer_replication=[[<span class="hljs-number">0</span>,<span class="hljs-number">4</span>], [<span class="hljs-number">2</span>,<span class="hljs-number">5</span>]], ...)',wrap:!1}}),ne=new y({props:{title:"Merge adapters",local:"merge-adapters",headingTag:"h2"}}),oe=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),pe=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),he=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),ce=new w({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),Me=new w({props:{code:"d2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTIwJTNEJTIwJTIyc2Z0LWRwbyUyMiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJhbGlnbm1lbnQtaGFuZGJvb2slMkZ6ZXBoeXItN2ItZHBvLWxvcmElMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkcG8lMjIpJTBBbW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJzZnQlMjIlMkMlMjAlMjJkcG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEd2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSklMEFtb2RlbC5zZXRfYWRhcHRlcih3ZWlnaHRlZF9hZGFwdGVyX25hbWUp",highlighted:`weighted_adapter_name = <span class="hljs-string">&quot;sft-dpo&quot;</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=weighted_adapter_name,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)
model.set_adapter(weighted_adapter_name)`,wrap:!1}}),J=new Wa({props:{$$slots:{default:[Ha]},$$scope:{ctx:We}}}),ye=new w({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oJTIyY3VkYSUyMiklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),Te=new y({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),ge=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),_e=new w({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),Ze=new y({props:{title:"Inference with different LoRA adapters in the same batch",local:"inference-with-different-lora-adapters-in-the-same-batch",headingTag:"h2"}}),Ue=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMjMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBGcmVuY2glMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMCUzQ3BhdGglM0UlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyX2ZyJTIyKSUwQSUyMyUyMG5leHQlMkMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBHZXJtYW4lMEFwZWZ0X21vZGVsLmxvYWRfYWRhcHRlciglM0NwYXRoJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl9kZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model_id = ...
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-comment"># load the LoRA adapter for French</span>
peft_model = PeftModel.from_pretrained(model, &lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_fr&quot;</span>)
<span class="hljs-comment"># next, load the LoRA adapter for German</span>
peft_model.load_adapter(&lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_de&quot;</span>)`,wrap:!1}}),ve=new w({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwY2F0JTIwaXMlMjBhd2Vzb21lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySGVsbG8lMkMlMjBteSUyMGZpc2glMjBpcyUyMGdyZWF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBjaGllbiUyMGVzdCUyMG1pZ25vbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlNhbHV0JTJDJTIwbW9uJTIwY2hhdCUyMGVzdCUyMGclQzMlQTluaWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBwb2lzc29uJTIwZXN0JTIwc3VwZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBIdW5kJTIwaXN0JTIwcyVDMyVCQyVDMyU5RiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhhbGxvJTJDJTIwbWVpbmUlMjBLYXR6ZSUyMGlzdCUyMHRvbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBGaXNjaCUyMGlzdCUyMGdybyVDMyU5RmFydGlnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBKSUwQSUwQWFkYXB0ZXJfbmFtZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJfX2Jhc2VfXyUyMiUyQyUyMCUyMl9fYmFzZV9fJTIyJTJDJTIwJTIyX19iYXNlX18lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2ZyJTIyJTJDJTIwJTIyYWRhcHRlcl9mciUyMiUyQyUyMCUyMmFkYXB0ZXJfZnIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2RlJTIyJTJDJTIwJTIyYWRhcHRlcl9kZSUyMiUyQyUyMCUyMmFkYXB0ZXJfZGUlMjIlMkMlMEElNUQlMEFvdXRwdXQlMjAlM0QlMjBwZWZ0X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYWRhcHRlcl9uYW1lcyUzRGFkYXB0ZXJfbmFtZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`inputs = tokenizer(
    [
        <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>,
        <span class="hljs-string">&quot;Hello, my cat is awesome&quot;</span>,
        <span class="hljs-string">&quot;Hello, my fish is great&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chien est mignon&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chat est génial&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon poisson est super&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Hund ist süß&quot;</span>,
        <span class="hljs-string">&quot;Hallo, meine Katze ist toll&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Fisch ist großartig&quot;</span>,
    ],
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    padding=<span class="hljs-literal">True</span>,
)

adapter_names = [
    <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>,
    <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>,
    <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>,
]
output = peft_model.generate(**inputs, adapter_names=adapter_names, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),Be=new y({props:{title:"Caveats",local:"caveats",headingTag:"h3"}}),{c(){u=i("meta"),T=s(),M=i("p"),b=s(),p(_.$$.fragment),Ge=s(),Z=i("p"),Z.innerHTML=Pt,Xe=s(),j=i("p"),j.textContent=Dt,Ae=s(),p($.$$.fragment),Qe=s(),U=i("p"),U.innerHTML=Kt,qe=s(),k=i("p"),k.innerHTML=Ot,Ve=s(),p(v.$$.fragment),Fe=s(),R=i("p"),R.innerHTML=ea,He=s(),p(B.$$.fragment),Ee=s(),p(I.$$.fragment),ze=s(),p(C.$$.fragment),xe=s(),W=i("p"),W.innerHTML=ta,Ye=s(),L=i("p"),L.innerHTML=aa,Ne=s(),p(G.$$.fragment),Se=s(),X=i("p"),X.innerHTML=la,Pe=s(),p(A.$$.fragment),De=s(),Q=i("p"),Q.innerHTML=sa,Ke=s(),q=i("p"),q.innerHTML=na,Oe=s(),V=i("p"),V.innerHTML=ia,et=s(),F=i("ul"),F.innerHTML=oa,tt=s(),p(g.$$.fragment),at=s(),p(H.$$.fragment),lt=s(),E=i("p"),E.innerHTML=ra,st=s(),p(z.$$.fragment),nt=s(),p(x.$$.fragment),it=s(),Y=i("p"),Y.innerHTML=pa,ot=s(),p(N.$$.fragment),rt=s(),p(S.$$.fragment),pt=s(),P=i("ul"),P.innerHTML=da,dt=s(),p(D.$$.fragment),mt=s(),K=i("p"),K.innerHTML=ma,ht=s(),p(O.$$.fragment),ft=s(),p(ee.$$.fragment),ct=s(),te=i("p"),te.innerHTML=ha,ut=s(),p(ae.$$.fragment),Mt=s(),le=i("p"),le.innerHTML=fa,wt=s(),se=i("p"),se.innerHTML=ca,yt=s(),p(ne.$$.fragment),Tt=s(),ie=i("p"),ie.innerHTML=ua,bt=s(),p(oe.$$.fragment),gt=s(),re=i("p"),re.innerHTML=Ma,Jt=s(),p(pe.$$.fragment),_t=s(),de=i("p"),de.innerHTML=wa,Zt=s(),me=i("p"),me.textContent=ya,jt=s(),p(he.$$.fragment),$t=s(),fe=i("p"),fe.textContent=Ta,Ut=s(),p(ce.$$.fragment),kt=s(),ue=i("p"),ue.textContent=ba,vt=s(),p(Me.$$.fragment),Rt=s(),p(J.$$.fragment),Bt=s(),we=i("p"),we.textContent=ga,It=s(),p(ye.$$.fragment),Ct=s(),p(Te.$$.fragment),Wt=s(),be=i("p"),be.innerHTML=Ja,Lt=s(),p(ge.$$.fragment),Gt=s(),Je=i("p"),Je.innerHTML=_a,Xt=s(),p(_e.$$.fragment),At=s(),p(Ze.$$.fragment),Qt=s(),je=i("p"),je.textContent=Za,qt=s(),$e=i("p"),$e.innerHTML=ja,Vt=s(),p(Ue.$$.fragment),Ft=s(),ke=i("p"),ke.innerHTML=$a,Ht=s(),p(ve.$$.fragment),Et=s(),Re=i("p"),Re.innerHTML=Ua,zt=s(),p(Be.$$.fragment),xt=s(),Ie=i("p"),Ie.textContent=ka,Yt=s(),Ce=i("ul"),Ce.innerHTML=va,Nt=s(),Le=i("p"),this.h()},l(e){const t=qa("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(a),T=n(e),M=o(e,"P",{}),Ia(M).forEach(a),b=n(e),d(_.$$.fragment,e),Ge=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-38uxl6"&&(Z.innerHTML=Pt),Xe=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-ovsn32"&&(j.textContent=Dt),Ae=n(e),d($.$$.fragment,e),Qe=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-j883mf"&&(U.innerHTML=Kt),qe=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1fujb7a"&&(k.innerHTML=Ot),Ve=n(e),d(v.$$.fragment,e),Fe=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-mwvui1"&&(R.innerHTML=ea),He=n(e),d(B.$$.fragment,e),Ee=n(e),d(I.$$.fragment,e),ze=n(e),d(C.$$.fragment,e),xe=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1ts8vpq"&&(W.innerHTML=ta),Ye=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-7f0aai"&&(L.innerHTML=aa),Ne=n(e),d(G.$$.fragment,e),Se=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-14vtcq9"&&(X.innerHTML=la),Pe=n(e),d(A.$$.fragment,e),De=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1nywyxh"&&(Q.innerHTML=sa),Ke=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1d2jix1"&&(q.innerHTML=na),Oe=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-yl8kok"&&(V.innerHTML=ia),et=n(e),F=o(e,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-12tl4fy"&&(F.innerHTML=oa),tt=n(e),d(g.$$.fragment,e),at=n(e),d(H.$$.fragment,e),lt=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-omuw13"&&(E.innerHTML=ra),st=n(e),d(z.$$.fragment,e),nt=n(e),d(x.$$.fragment,e),it=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1ukfkwt"&&(Y.innerHTML=pa),ot=n(e),d(N.$$.fragment,e),rt=n(e),d(S.$$.fragment,e),pt=n(e),P=o(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-1lkjk8m"&&(P.innerHTML=da),dt=n(e),d(D.$$.fragment,e),mt=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-15vxux2"&&(K.innerHTML=ma),ht=n(e),d(O.$$.fragment,e),ft=n(e),d(ee.$$.fragment,e),ct=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1mosto0"&&(te.innerHTML=ha),ut=n(e),d(ae.$$.fragment,e),Mt=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1safyei"&&(le.innerHTML=fa),wt=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-foj0wd"&&(se.innerHTML=ca),yt=n(e),d(ne.$$.fragment,e),Tt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1c3h9aa"&&(ie.innerHTML=ua),bt=n(e),d(oe.$$.fragment,e),gt=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-m3cr6r"&&(re.innerHTML=Ma),Jt=n(e),d(pe.$$.fragment,e),_t=n(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-kbqhpl"&&(de.innerHTML=wa),Zt=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1mwdwt1"&&(me.textContent=ya),jt=n(e),d(he.$$.fragment,e),$t=n(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-nuhu05"&&(fe.textContent=Ta),Ut=n(e),d(ce.$$.fragment,e),kt=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1n53hd9"&&(ue.textContent=ba),vt=n(e),d(Me.$$.fragment,e),Rt=n(e),d(J.$$.fragment,e),Bt=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-qwbdkg"&&(we.textContent=ga),It=n(e),d(ye.$$.fragment,e),Ct=n(e),d(Te.$$.fragment,e),Wt=n(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-ke62q2"&&(be.innerHTML=Ja),Lt=n(e),d(ge.$$.fragment,e),Gt=n(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-cvmoj6"&&(Je.innerHTML=_a),Xt=n(e),d(_e.$$.fragment,e),At=n(e),d(Ze.$$.fragment,e),Qt=n(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1fq5tpu"&&(je.textContent=Za),qt=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-6zt8d6"&&($e.innerHTML=ja),Vt=n(e),d(Ue.$$.fragment,e),Ft=n(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-6wkyom"&&(ke.innerHTML=$a),Ht=n(e),d(ve.$$.fragment,e),Et=n(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1o40ch6"&&(Re.innerHTML=Ua),zt=n(e),d(Be.$$.fragment,e),xt=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-fpz5mj"&&(Ie.textContent=ka),Yt=n(e),Ce=o(e,"UL",{"data-svelte-h":!0}),r(Ce)!=="svelte-1jk1r7d"&&(Ce.innerHTML=va),Nt=n(e),Le=o(e,"P",{}),Ia(Le).forEach(a),this.h()},h(){Ca(u,"name","hf:doc:metadata"),Ca(u,"content",za)},m(e,t){Va(document.head,u),l(e,T,t),l(e,M,t),l(e,b,t),m(_,e,t),l(e,Ge,t),l(e,Z,t),l(e,Xe,t),l(e,j,t),l(e,Ae,t),m($,e,t),l(e,Qe,t),l(e,U,t),l(e,qe,t),l(e,k,t),l(e,Ve,t),m(v,e,t),l(e,Fe,t),l(e,R,t),l(e,He,t),m(B,e,t),l(e,Ee,t),m(I,e,t),l(e,ze,t),m(C,e,t),l(e,xe,t),l(e,W,t),l(e,Ye,t),l(e,L,t),l(e,Ne,t),m(G,e,t),l(e,Se,t),l(e,X,t),l(e,Pe,t),m(A,e,t),l(e,De,t),l(e,Q,t),l(e,Ke,t),l(e,q,t),l(e,Oe,t),l(e,V,t),l(e,et,t),l(e,F,t),l(e,tt,t),m(g,e,t),l(e,at,t),m(H,e,t),l(e,lt,t),l(e,E,t),l(e,st,t),m(z,e,t),l(e,nt,t),m(x,e,t),l(e,it,t),l(e,Y,t),l(e,ot,t),m(N,e,t),l(e,rt,t),m(S,e,t),l(e,pt,t),l(e,P,t),l(e,dt,t),m(D,e,t),l(e,mt,t),l(e,K,t),l(e,ht,t),m(O,e,t),l(e,ft,t),m(ee,e,t),l(e,ct,t),l(e,te,t),l(e,ut,t),m(ae,e,t),l(e,Mt,t),l(e,le,t),l(e,wt,t),l(e,se,t),l(e,yt,t),m(ne,e,t),l(e,Tt,t),l(e,ie,t),l(e,bt,t),m(oe,e,t),l(e,gt,t),l(e,re,t),l(e,Jt,t),m(pe,e,t),l(e,_t,t),l(e,de,t),l(e,Zt,t),l(e,me,t),l(e,jt,t),m(he,e,t),l(e,$t,t),l(e,fe,t),l(e,Ut,t),m(ce,e,t),l(e,kt,t),l(e,ue,t),l(e,vt,t),m(Me,e,t),l(e,Rt,t),m(J,e,t),l(e,Bt,t),l(e,we,t),l(e,It,t),m(ye,e,t),l(e,Ct,t),m(Te,e,t),l(e,Wt,t),l(e,be,t),l(e,Lt,t),m(ge,e,t),l(e,Gt,t),l(e,Je,t),l(e,Xt,t),m(_e,e,t),l(e,At,t),m(Ze,e,t),l(e,Qt,t),l(e,je,t),l(e,qt,t),l(e,$e,t),l(e,Vt,t),m(Ue,e,t),l(e,Ft,t),l(e,ke,t),l(e,Ht,t),m(ve,e,t),l(e,Et,t),l(e,Re,t),l(e,zt,t),m(Be,e,t),l(e,xt,t),l(e,Ie,t),l(e,Yt,t),l(e,Ce,t),l(e,Nt,t),l(e,Le,t),St=!0},p(e,[t]){const Ra={};t&2&&(Ra.$$scope={dirty:t,ctx:e}),g.$set(Ra);const Ba={};t&2&&(Ba.$$scope={dirty:t,ctx:e}),J.$set(Ba)},i(e){St||(h(_.$$.fragment,e),h($.$$.fragment,e),h(v.$$.fragment,e),h(B.$$.fragment,e),h(I.$$.fragment,e),h(C.$$.fragment,e),h(G.$$.fragment,e),h(A.$$.fragment,e),h(g.$$.fragment,e),h(H.$$.fragment,e),h(z.$$.fragment,e),h(x.$$.fragment,e),h(N.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(ae.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(he.$$.fragment,e),h(ce.$$.fragment,e),h(Me.$$.fragment,e),h(J.$$.fragment,e),h(ye.$$.fragment,e),h(Te.$$.fragment,e),h(ge.$$.fragment,e),h(_e.$$.fragment,e),h(Ze.$$.fragment,e),h(Ue.$$.fragment,e),h(ve.$$.fragment,e),h(Be.$$.fragment,e),St=!0)},o(e){f(_.$$.fragment,e),f($.$$.fragment,e),f(v.$$.fragment,e),f(B.$$.fragment,e),f(I.$$.fragment,e),f(C.$$.fragment,e),f(G.$$.fragment,e),f(A.$$.fragment,e),f(g.$$.fragment,e),f(H.$$.fragment,e),f(z.$$.fragment,e),f(x.$$.fragment,e),f(N.$$.fragment,e),f(S.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(ae.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),f(ce.$$.fragment,e),f(Me.$$.fragment,e),f(J.$$.fragment,e),f(ye.$$.fragment,e),f(Te.$$.fragment,e),f(ge.$$.fragment,e),f(_e.$$.fragment,e),f(Ze.$$.fragment,e),f(Ue.$$.fragment,e),f(ve.$$.fragment,e),f(Be.$$.fragment,e),St=!1},d(e){e&&(a(T),a(M),a(b),a(Ge),a(Z),a(Xe),a(j),a(Ae),a(Qe),a(U),a(qe),a(k),a(Ve),a(Fe),a(R),a(He),a(Ee),a(ze),a(xe),a(W),a(Ye),a(L),a(Ne),a(Se),a(X),a(Pe),a(De),a(Q),a(Ke),a(q),a(Oe),a(V),a(et),a(F),a(tt),a(at),a(lt),a(E),a(st),a(nt),a(it),a(Y),a(ot),a(rt),a(pt),a(P),a(dt),a(mt),a(K),a(ht),a(ft),a(ct),a(te),a(ut),a(Mt),a(le),a(wt),a(se),a(yt),a(Tt),a(ie),a(bt),a(gt),a(re),a(Jt),a(_t),a(de),a(Zt),a(me),a(jt),a($t),a(fe),a(Ut),a(kt),a(ue),a(vt),a(Rt),a(Bt),a(we),a(It),a(Ct),a(Wt),a(be),a(Lt),a(Gt),a(Je),a(Xt),a(At),a(Qt),a(je),a(qt),a($e),a(Vt),a(Ft),a(ke),a(Ht),a(Et),a(Re),a(zt),a(xt),a(Ie),a(Yt),a(Ce),a(Nt),a(Le)),a(u),c(_,e),c($,e),c(v,e),c(B,e),c(I,e),c(C,e),c(G,e),c(A,e),c(g,e),c(H,e),c(z,e),c(x,e),c(N,e),c(S,e),c(D,e),c(O,e),c(ee,e),c(ae,e),c(ne,e),c(oe,e),c(pe,e),c(he,e),c(ce,e),c(Me,e),c(J,e),c(ye,e),c(Te,e),c(ge,e),c(_e,e),c(Ze,e),c(Ue,e),c(ve,e),c(Be,e)}}}const za='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"LoftQ","local":"loftq","sections":[{"title":"Standard approach","local":"standard-approach","sections":[],"depth":4},{"title":"A more convienient way","local":"a-more-convienient-way","sections":[],"depth":4}],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3},{"title":"Weight-Decomposed Low-Rank Adaptation (DoRA)","local":"weight-decomposed-low-rank-adaptation-dora","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3},{"title":"Memory efficient Layer Replication with LoRA","local":"memory-efficient-layer-replication-with-lora","sections":[],"depth":3}],"depth":2},{"title":"Merge adapters","local":"merge-adapters","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2},{"title":"Inference with different LoRA adapters in the same batch","local":"inference-with-different-lora-adapters-in-the-same-batch","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":3}],"depth":2}],"depth":1}';function xa(We){return Xa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ka extends Aa{constructor(u){super(),Qa(this,u,xa,Ea,Ga,{})}}export{Ka as component};
