import{s as Ee,n as Le,o as Pe}from"../chunks/scheduler.c57aa7ef.js";import{S as He,i as We,g as n,s as l,r as z,A as Ge,h as s,f as o,c as a,j as Re,u as Z,x as r,k as Te,y as Se,a as i,v as I,d as R,t as E,w as L}from"../chunks/index.c50cb18e.js";import{C as Ne}from"../chunks/CodeBlock.34f0a53d.js";import{H as P}from"../chunks/Heading.c7d7e0e7.js";function Qe(ge){let f,G,H,S,p,N,d,we='This conceptual guide gives a brief overview of <a href="https://arxiv.org/abs/2306.07280" rel="nofollow">OFT</a> and <a href="https://arxiv.org/abs/2311.06243" rel="nofollow">BOFT</a>, a parameter-efficient fine-tuning technique that utilizes orthogonal matrix to multiplicatively transform the pretrained weight matrices.',Q,u,_e="To achieve efficient fine-tuning, OFT represents the weight updates with an orthogonal transformation. The orthogonal transformation is parameterized by an orthogonal matrix multiplied to the pretrained weight matrix. These new matrices can be trained to adapt to the new data while keeping the overall number of changes low. The original weight matrix remains frozen and doesn’t receive any further adjustments. To produce the final results, both the original and the adapted weights are multiplied togethor.",A,h,ve="Orthogonal Butterfly (BOFT) generalizes OFT with Butterfly factorization and further improves its parameter efficiency and finetuning flexibility. In short, OFT can be viewed as a special case of BOFT. Different from LoRA that uses additive low-rank weight updates, BOFT uses multiplicative orthogonal weight updates. The comparison is shown below.",V,m,Me='<img src="https://raw.githubusercontent.com/wy1iu/butterfly-oft/main/assets/BOFT_comparison.png"/>',D,b,Fe="BOFT has some advantages compared to LoRA:",X,y,Ce='<li>BOFT proposes a simple yet generic way to finetune pretrained models to downstream tasks, yielding a better preservation of pretraining knowledge and a better parameter efficiency.</li> <li>Through the orthogonality, BOFT introduces a structural constraint, i.e., keeping the <a href="https://arxiv.org/abs/1805.09298" rel="nofollow">hyperspherical energy</a> unchanged during finetuning. This can effectively reduce the forgetting of pretraining knowledge.</li> <li>BOFT uses the butterfly factorization to efficiently parameterize the orthogonal matrix, which yields a compact yet expressive learning space (i.e., hypothesis class).</li> <li>The sparse matrix decomposition in BOFT brings in additional inductive biases that are beneficial to generalization.</li>',Y,T,xe="In principle, BOFT can be applied to any subset of weight matrices in a neural network to reduce the number of trainable parameters. Given the target layers for injecting BOFT parameters, the number of trainable parameters can be determined based on the size of the weight matrices.",K,g,ee,w,Be="Similar to LoRA, the weights learned by OFT/BOFT can be integrated into the pretrained weight matrices using the merge_and_unload() function. This function merges the adapter weights with the base model which allows you to effectively use the newly merged model as a standalone model.",te,c,Oe='<img src="https://raw.githubusercontent.com/wy1iu/butterfly-oft/main/assets/boft_merge.png"/>',oe,_,ke="This works because during training, the orthogonal weight matrix (R in the diagram above) and the pretrained weight matrices are separate. But once training is complete, these weights can actually be merged (multiplied) into a new weight matrix that is equivalent.",ie,v,le,M,ae,F,Ue="As with other methods supported by PEFT, to fine-tune a model using OFT or BOFT, you need to:",ne,C,Je="<li>Instantiate a base model.</li> <li>Create a configuration (<code>OFTConfig</code> or <code>BOFTConfig</code>) where you define OFT/BOFT-specific parameters.</li> <li>Wrap the base model with <code>get_peft_model()</code> to get a trainable <code>PeftModel</code>.</li> <li>Train the <code>PeftModel</code> as you normally would train the base model.</li>",se,x,re,B,$e="<code>BOFTConfig</code> allows you to control how OFT/BOFT is applied to the base model through the following parameters:",fe,O,je=`<li><code>boft_block_size</code>: the BOFT matrix block size across different layers, expressed in <code>int</code>. Smaller block size results in sparser update matrices with fewer trainable paramters. <strong>Note</strong>, please choose <code>boft_block_size</code> to be divisible by most layer’s input dimension (<code>in_features</code>), e.g., 4, 8, 16. Also, please only
specify either <code>boft_block_size</code> or <code>boft_block_num</code>, but not both simultaneously or leaving both to 0, because <code>boft_block_size</code> x <code>boft_block_num</code> must equal the layer’s input dimension.</li> <li><code>boft_block_num</code>: the number of BOFT matrix blocks across different layers, expressed in <code>int</code>. Fewer blocks result in sparser update matrices with fewer trainable paramters. <strong>Note</strong>, please choose <code>boft_block_num</code> to be divisible by most layer’s input dimension (<code>in_features</code>), e.g., 4, 8, 16. Also, please only
specify either <code>boft_block_size</code> or <code>boft_block_num</code>, but not both simultaneously or leaving both to 0, because <code>boft_block_size</code> x <code>boft_block_num</code> must equal the layer’s input dimension.</li> <li><code>boft_n_butterfly_factor</code>: the number of butterfly factors. <strong>Note</strong>, for <code>boft_n_butterfly_factor=1</code>, BOFT is the same as vanilla OFT, for <code>boft_n_butterfly_factor=2</code>, the effective block size of OFT becomes twice as big and the number of blocks become half.</li> <li><code>bias</code>: specify if the <code>bias</code> parameters should be trained. Can be <code>&quot;none&quot;</code>, <code>&quot;all&quot;</code> or <code>&quot;boft_only&quot;</code>.</li> <li><code>boft_dropout</code>: specify the probability of multiplicative dropout.</li> <li><code>target_modules</code>: The modules (for example, attention blocks) to inject the OFT/BOFT matrices.</li> <li><code>modules_to_save</code>: List of modules apart from OFT/BOFT matrices to be set as trainable and saved in the final checkpoint. These typically include model’s custom head that is randomly initialized for the fine-tuning task.</li>`,me,k,ce,U,qe="For an example of the BOFT method application to various downstream tasks, please refer to the following guides:",pe,J,ze="Take a look at the following step-by-step guides on how to finetune a model with BOFT:",de,$,Ze='<li><a href="../task_guides/boft_dreambooth">Dreambooth finetuning with BOFT</a></li> <li><a href="../task_guides/boft_controlnet">Controllable generation finetuning with BOFT (ControlNet)</a></li>',ue,j,Ie="For the task of image classification, one can initialize the BOFT config for a DinoV2 model as follows:",he,q,be,W,ye;return p=new P({props:{title:"Orthogonal Finetuning (OFT and BOFT)",local:"orthogonal-finetuning-oft-and-boft",headingTag:"h1"}}),g=new P({props:{title:"Merge OFT/BOFT weights into the base model",local:"merge-oftboft-weights-into-the-base-model",headingTag:"h2"}}),v=new P({props:{title:"Utils for OFT / BOFT",local:"utils-for-oft--boft",headingTag:"h2"}}),M=new P({props:{title:"Common OFT / BOFT parameters in PEFT",local:"common-oft--boft-parameters-in-peft",headingTag:"h3"}}),x=new P({props:{title:"BOFT-specific paramters",local:"boft-specific-paramters",headingTag:"h3"}}),k=new P({props:{title:"BOFT Example Usage",local:"boft-example-usage",headingTag:"h2"}}),q=new Ne({props:{code:"aW1wb3J0JTIwdHJhbnNmb3JtZXJzJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUyQyUyMEJPRlRDb25maWclMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMEJPRlRDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQWNvbmZpZyUyMCUzRCUyMEJPRlRDb25maWcoJTBBJTIwJTIwJTIwJTIwYm9mdF9ibG9ja19zaXplJTNENCUyQyUwQSUyMCUyMCUyMCUyMGJvZnRfbl9idXR0ZXJmbHlfZmFjdG9yJTNEMiUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiUyQyUyMCUyMmtleSUyMiUyQyUyMCUyMm91dHB1dC5kZW5zZSUyMiUyQyUyMCUyMm1scC5mYzElMjIlMkMlMjAlMjJtbHAuZmMyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwYm9mdF9kcm9wb3V0JTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMmJvZnRfb25seSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjB0cmFuc2Zvcm1lcnMuRGlub3YyRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZmFjZWJvb2slMkZkaW5vdjItbGFyZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fbGFiZWxzJTNEMTAwJTJDJTBBKSUwQSUwQWJvZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">import</span> transformers
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM, BOFTConfig
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> BOFTConfig, get_peft_model

config = BOFTConfig(
    boft_block_size=<span class="hljs-number">4</span>,
    boft_n_butterfly_factor=<span class="hljs-number">2</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>, <span class="hljs-string">&quot;key&quot;</span>, <span class="hljs-string">&quot;output.dense&quot;</span>, <span class="hljs-string">&quot;mlp.fc1&quot;</span>, <span class="hljs-string">&quot;mlp.fc2&quot;</span>],
    boft_dropout=<span class="hljs-number">0.1</span>,
    bias=<span class="hljs-string">&quot;boft_only&quot;</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)

model = transformers.Dinov2ForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;facebook/dinov2-large&quot;</span>,
    num_labels=<span class="hljs-number">100</span>,
)

boft_model = get_peft_model(model, config)`,wrap:!1}}),{c(){f=n("meta"),G=l(),H=n("p"),S=l(),z(p.$$.fragment),N=l(),d=n("p"),d.innerHTML=we,Q=l(),u=n("p"),u.textContent=_e,A=l(),h=n("p"),h.textContent=ve,V=l(),m=n("div"),m.innerHTML=Me,D=l(),b=n("p"),b.textContent=Fe,X=l(),y=n("ul"),y.innerHTML=Ce,Y=l(),T=n("p"),T.textContent=xe,K=l(),z(g.$$.fragment),ee=l(),w=n("p"),w.textContent=Be,te=l(),c=n("div"),c.innerHTML=Oe,oe=l(),_=n("p"),_.textContent=ke,ie=l(),z(v.$$.fragment),le=l(),z(M.$$.fragment),ae=l(),F=n("p"),F.textContent=Ue,ne=l(),C=n("ol"),C.innerHTML=Je,se=l(),z(x.$$.fragment),re=l(),B=n("p"),B.innerHTML=$e,fe=l(),O=n("ul"),O.innerHTML=je,me=l(),z(k.$$.fragment),ce=l(),U=n("p"),U.textContent=qe,pe=l(),J=n("p"),J.textContent=ze,de=l(),$=n("ul"),$.innerHTML=Ze,ue=l(),j=n("p"),j.textContent=Ie,he=l(),z(q.$$.fragment),be=l(),W=n("p"),this.h()},l(e){const t=Ge("svelte-u9bgzb",document.head);f=s(t,"META",{name:!0,content:!0}),t.forEach(o),G=a(e),H=s(e,"P",{}),Re(H).forEach(o),S=a(e),Z(p.$$.fragment,e),N=a(e),d=s(e,"P",{"data-svelte-h":!0}),r(d)!=="svelte-1nfmmal"&&(d.innerHTML=we),Q=a(e),u=s(e,"P",{"data-svelte-h":!0}),r(u)!=="svelte-91fr84"&&(u.textContent=_e),A=a(e),h=s(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-lal94n"&&(h.textContent=ve),V=a(e),m=s(e,"DIV",{class:!0,"data-svelte-h":!0}),r(m)!=="svelte-1veppqu"&&(m.innerHTML=Me),D=a(e),b=s(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1dyux9"&&(b.textContent=Fe),X=a(e),y=s(e,"UL",{"data-svelte-h":!0}),r(y)!=="svelte-1cbqvv5"&&(y.innerHTML=Ce),Y=a(e),T=s(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-18dbsba"&&(T.textContent=xe),K=a(e),Z(g.$$.fragment,e),ee=a(e),w=s(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-10xuh5x"&&(w.textContent=Be),te=a(e),c=s(e,"DIV",{class:!0,"data-svelte-h":!0}),r(c)!=="svelte-1a4qpj5"&&(c.innerHTML=Oe),oe=a(e),_=s(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-6kbdta"&&(_.textContent=ke),ie=a(e),Z(v.$$.fragment,e),le=a(e),Z(M.$$.fragment,e),ae=a(e),F=s(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-qq3gtj"&&(F.textContent=Ue),ne=a(e),C=s(e,"OL",{"data-svelte-h":!0}),r(C)!=="svelte-psegni"&&(C.innerHTML=Je),se=a(e),Z(x.$$.fragment,e),re=a(e),B=s(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-r0gnmm"&&(B.innerHTML=$e),fe=a(e),O=s(e,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-18rexz4"&&(O.innerHTML=je),me=a(e),Z(k.$$.fragment,e),ce=a(e),U=s(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1py8k9k"&&(U.textContent=qe),pe=a(e),J=s(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-5zw2dt"&&(J.textContent=ze),de=a(e),$=s(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-gmf2ro"&&($.innerHTML=Ze),ue=a(e),j=s(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-9y5ksw"&&(j.textContent=Ie),he=a(e),Z(q.$$.fragment,e),be=a(e),W=s(e,"P",{}),Re(W).forEach(o),this.h()},h(){Te(f,"name","hf:doc:metadata"),Te(f,"content",Ae),Te(m,"class","flex justify-center"),Te(c,"class","flex justify-center")},m(e,t){Se(document.head,f),i(e,G,t),i(e,H,t),i(e,S,t),I(p,e,t),i(e,N,t),i(e,d,t),i(e,Q,t),i(e,u,t),i(e,A,t),i(e,h,t),i(e,V,t),i(e,m,t),i(e,D,t),i(e,b,t),i(e,X,t),i(e,y,t),i(e,Y,t),i(e,T,t),i(e,K,t),I(g,e,t),i(e,ee,t),i(e,w,t),i(e,te,t),i(e,c,t),i(e,oe,t),i(e,_,t),i(e,ie,t),I(v,e,t),i(e,le,t),I(M,e,t),i(e,ae,t),i(e,F,t),i(e,ne,t),i(e,C,t),i(e,se,t),I(x,e,t),i(e,re,t),i(e,B,t),i(e,fe,t),i(e,O,t),i(e,me,t),I(k,e,t),i(e,ce,t),i(e,U,t),i(e,pe,t),i(e,J,t),i(e,de,t),i(e,$,t),i(e,ue,t),i(e,j,t),i(e,he,t),I(q,e,t),i(e,be,t),i(e,W,t),ye=!0},p:Le,i(e){ye||(R(p.$$.fragment,e),R(g.$$.fragment,e),R(v.$$.fragment,e),R(M.$$.fragment,e),R(x.$$.fragment,e),R(k.$$.fragment,e),R(q.$$.fragment,e),ye=!0)},o(e){E(p.$$.fragment,e),E(g.$$.fragment,e),E(v.$$.fragment,e),E(M.$$.fragment,e),E(x.$$.fragment,e),E(k.$$.fragment,e),E(q.$$.fragment,e),ye=!1},d(e){e&&(o(G),o(H),o(S),o(N),o(d),o(Q),o(u),o(A),o(h),o(V),o(m),o(D),o(b),o(X),o(y),o(Y),o(T),o(K),o(ee),o(w),o(te),o(c),o(oe),o(_),o(ie),o(le),o(ae),o(F),o(ne),o(C),o(se),o(re),o(B),o(fe),o(O),o(me),o(ce),o(U),o(pe),o(J),o(de),o($),o(ue),o(j),o(he),o(be),o(W)),o(f),L(p,e),L(g,e),L(v,e),L(M,e),L(x,e),L(k,e),L(q,e)}}}const Ae='{"title":"Orthogonal Finetuning (OFT and BOFT)","local":"orthogonal-finetuning-oft-and-boft","sections":[{"title":"Merge OFT/BOFT weights into the base model","local":"merge-oftboft-weights-into-the-base-model","sections":[],"depth":2},{"title":"Utils for OFT / BOFT","local":"utils-for-oft--boft","sections":[{"title":"Common OFT / BOFT parameters in PEFT","local":"common-oft--boft-parameters-in-peft","sections":[],"depth":3},{"title":"BOFT-specific paramters","local":"boft-specific-paramters","sections":[],"depth":3}],"depth":2},{"title":"BOFT Example Usage","local":"boft-example-usage","sections":[],"depth":2}],"depth":1}';function Ve(ge){return Pe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class et extends He{constructor(f){super(),We(this,f,Ve,Qe,Ee,{})}}export{et as component};
