import{s as Nl,n as Ql,o as _l}from"../chunks/scheduler.f6319a2a.js";import{S as Sl,i as xl,g as M,s as a,r as p,A as Rl,h as o,f as t,c as n,j as kl,u as c,x as y,k as bl,y as El,a as e,v as i,d as w,t as J,w as m}from"../chunks/index.85aa684c.js";import{C as u}from"../chunks/CodeBlock.3400fc53.js";import{D as zl}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as Yl,E as Hl}from"../chunks/getInferenceSnippets.743412b2.js";function Al(dl){let U,H,z,A,b,F,d,$,r,rl="在本notebook中，我们将创建一个<strong>基于Agent的网页浏览器自动化系统</strong>！该系统可以自动导航网站、与网页元素交互并提取信息。",q,T,Tl="该Agent将能够：",K,j,hl='<li class="task-list-item"><input type="checkbox" checked="" disabled=""/> 导航到网页</li> <li class="task-list-item"><input type="checkbox" checked="" disabled=""/> 点击元素</li> <li class="task-list-item"><input type="checkbox" checked="" disabled=""/> 在页面内搜索</li> <li class="task-list-item"><input type="checkbox" checked="" disabled=""/> 处理弹出窗口和模态框</li> <li class="task-list-item"><input type="checkbox" checked="" disabled=""/> 提取信息</li>',L,h,Il="让我们一步步搭建这个系统！",D,I,Bl="首先运行以下命令安装所需依赖：",P,B,O,C,Cl="让我们导入所需的库并设置环境变量：",ll,Z,sl,G,Zl="现在我们来创建核心的浏览器交互工具，使我们的Agent能够导航并与网页交互：",tl,W,el,V,Gl="让我们配置使用Chrome浏览器并设置截图功能：",al,v,nl,g,Wl="现在我们来创建网页自动化Agent：",Ml,f,ol,X,Vl="Agent需要获得关于如何使用Helium进行网页自动化的指导。以下是我们将提供的操作说明：",yl,k,pl,N,vl="现在我们可以运行Agent执行任务了！让我们尝试在维基百科上查找信息：",cl,Q,il,_,gl="您可以通过修改请求参数执行不同任务。例如，以下请求可帮助我判断是否需要更加努力工作：",wl,S,Jl,x,fl="该系统在以下任务中尤为有效：",ml,R,Xl="<li>从网站提取数据</li> <li>网页研究自动化</li> <li>用户界面测试与验证</li> <li>内容监控</li>",Ul,E,jl,Y,ul;return b=new Yl({props:{title:"使用Agent实现网页浏览器自动化 🤖🌐",local:"使用agent实现网页浏览器自动化-",headingTag:"h1"}}),d=new zl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/web_browser.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/pytorch/web_browser.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tensorflow/web_browser.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/web_browser.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/pytorch/web_browser.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/zh/tensorflow/web_browser.ipynb"}]}}),B=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlMjBzZWxlbml1bSUyMGhlbGl1bSUyMHBpbGxvdyUyMC1x",highlighted:"pip install smolagents selenium helium pillow -q",wrap:!1}}),Z=new u({props:{code:"ZnJvbSUyMGlvJTIwaW1wb3J0JTIwQnl0ZXNJTyUwQWZyb20lMjB0aW1lJTIwaW1wb3J0JTIwc2xlZXAlMEElMEFpbXBvcnQlMjBoZWxpdW0lMEFmcm9tJTIwZG90ZW52JTIwaW1wb3J0JTIwbG9hZF9kb3RlbnYlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwc2VsZW5pdW0lMjBpbXBvcnQlMjB3ZWJkcml2ZXIlMEFmcm9tJTIwc2VsZW5pdW0ud2ViZHJpdmVyLmNvbW1vbi5ieSUyMGltcG9ydCUyMEJ5JTBBZnJvbSUyMHNlbGVuaXVtLndlYmRyaXZlci5jb21tb24ua2V5cyUyMGltcG9ydCUyMEtleXMlMEElMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMENvZGVBZ2VudCUyQyUyMHRvb2wlMEFmcm9tJTIwc21vbGFnZW50cy5hZ2VudHMlMjBpbXBvcnQlMjBBY3Rpb25TdGVwJTBBJTBBJTIzJTIwTG9hZCUyMGVudmlyb25tZW50JTIwdmFyaWFibGVzJTBBbG9hZF9kb3RlbnYoKQ==",highlighted:`<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> time <span class="hljs-keyword">import</span> sleep

<span class="hljs-keyword">import</span> helium
<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> selenium <span class="hljs-keyword">import</span> webdriver
<span class="hljs-keyword">from</span> selenium.webdriver.common.by <span class="hljs-keyword">import</span> By
<span class="hljs-keyword">from</span> selenium.webdriver.common.keys <span class="hljs-keyword">import</span> Keys

<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, tool
<span class="hljs-keyword">from</span> smolagents.agents <span class="hljs-keyword">import</span> ActionStep

<span class="hljs-comment"># Load environment variables</span>
load_dotenv()`,wrap:!1}}),W=new u({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">search_item_ctrl_f</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span>, nth_result: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Searches for text on the current page via Ctrl + F and jumps to the nth occurrence.
    Args:
        text: The text to search for
        nth_result: Which occurrence to jump to (default: 1)
    &quot;&quot;&quot;</span>
    elements = driver.find_elements(By.XPATH, <span class="hljs-string">f&quot;//*[contains(text(), &#x27;<span class="hljs-subst">{text}</span>&#x27;)]&quot;</span>)
    <span class="hljs-keyword">if</span> nth_result &gt; <span class="hljs-built_in">len</span>(elements):
        <span class="hljs-keyword">raise</span> Exception(<span class="hljs-string">f&quot;Match n°<span class="hljs-subst">{nth_result}</span> not found (only <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span> matches found)&quot;</span>)
    result = <span class="hljs-string">f&quot;Found <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span> matches for &#x27;<span class="hljs-subst">{text}</span>&#x27;.&quot;</span>
    elem = elements[nth_result - <span class="hljs-number">1</span>]
    driver.execute_script(<span class="hljs-string">&quot;arguments[0].scrollIntoView(true);&quot;</span>, elem)
    result += <span class="hljs-string">f&quot;Focused on element <span class="hljs-subst">{nth_result}</span> of <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span>&quot;</span>
    <span class="hljs-keyword">return</span> result

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">go_back</span>() -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-string">&quot;&quot;&quot;Goes back to previous page.&quot;&quot;&quot;</span>
    driver.back()

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">close_popups</span>() -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Closes any visible modal or pop-up on the page. Use this to dismiss pop-up windows!
    This does not work on cookie consent banners.
    &quot;&quot;&quot;</span>
    webdriver.ActionChains(driver).send_keys(Keys.ESCAPE).perform()`,wrap:!1}}),v=new u({props:{code:"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",highlighted:`<span class="hljs-comment"># Configure Chrome options</span>
chrome_options = webdriver.ChromeOptions()
chrome_options.add_argument(<span class="hljs-string">&quot;--force-device-scale-factor=1&quot;</span>)
chrome_options.add_argument(<span class="hljs-string">&quot;--window-size=1000,1350&quot;</span>)
chrome_options.add_argument(<span class="hljs-string">&quot;--disable-pdf-viewer&quot;</span>)
chrome_options.add_argument(<span class="hljs-string">&quot;--window-position=0,0&quot;</span>)

<span class="hljs-comment"># Initialize the browser</span>
driver = helium.start_chrome(headless=<span class="hljs-literal">False</span>, options=chrome_options)

<span class="hljs-comment"># Set up screenshot callback</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">save_screenshot</span>(<span class="hljs-params">memory_step: ActionStep, agent: CodeAgent</span>) -&gt; <span class="hljs-literal">None</span>:
    sleep(<span class="hljs-number">1.0</span>)  <span class="hljs-comment"># Let JavaScript animations happen before taking the screenshot</span>
    driver = helium.get_driver()
    current_step = memory_step.step_number
    <span class="hljs-keyword">if</span> driver <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">for</span> previous_memory_step <span class="hljs-keyword">in</span> agent.memory.steps:  <span class="hljs-comment"># Remove previous screenshots for lean processing</span>
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(previous_memory_step, ActionStep) <span class="hljs-keyword">and</span> previous_memory_step.step_number &lt;= current_step - <span class="hljs-number">2</span>:
                previous_memory_step.observations_images = <span class="hljs-literal">None</span>
        png_bytes = driver.get_screenshot_as_png()
        image = Image.<span class="hljs-built_in">open</span>(BytesIO(png_bytes))
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Captured a browser screenshot: <span class="hljs-subst">{image.size}</span> pixels&quot;</span>)
        memory_step.observations_images = [image.copy()]  <span class="hljs-comment"># Create a copy to ensure it persists</span>

    <span class="hljs-comment"># Update observations with current URL</span>
    url_info = <span class="hljs-string">f&quot;Current url: <span class="hljs-subst">{driver.current_url}</span>&quot;</span>
    memory_step.observations = (
        url_info <span class="hljs-keyword">if</span> memory_step.observations <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> memory_step.observations + <span class="hljs-string">&quot;\\n&quot;</span> + url_info
    )`,wrap:!1}}),f=new u({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjBtb2RlbCUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMy03MEItSW5zdHJ1Y3QlMjIlMjAlMjAlMjMlMjBZb3UlMjBjYW4lMjBjaGFuZ2UlMjB0aGlzJTIwdG8lMjB5b3VyJTIwcHJlZmVycmVkJTIwbW9kZWwlMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEbW9kZWxfaWQpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwdGhlJTIwYWdlbnQlMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QmdvX2JhY2slMkMlMjBjbG9zZV9wb3B1cHMlMkMlMjBzZWFyY2hfaXRlbV9jdHJsX2YlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUIlMjJoZWxpdW0lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBzdGVwX2NhbGxiYWNrcyUzRCU1QnNhdmVfc2NyZWVuc2hvdCU1RCUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDIwJTJDJTBBJTIwJTIwJTIwJTIwdmVyYm9zaXR5X2xldmVsJTNEMiUyQyUwQSklMEElMEElMjMlMjBJbXBvcnQlMjBoZWxpdW0lMjBmb3IlMjB0aGUlMjBhZ2VudCUwQWFnZW50LnB5dGhvbl9leGVjdXRvciglMjJmcm9tJTIwaGVsaXVtJTIwaW1wb3J0JTIwKiUyMiUyQyUyMGFnZW50LnN0YXRlKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel

<span class="hljs-comment"># Initialize the model</span>
model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.3-70B-Instruct&quot;</span>  <span class="hljs-comment"># You can change this to your preferred model</span>
model = InferenceClientModel(model_id=model_id)

<span class="hljs-comment"># Create the agent</span>
agent = CodeAgent(
    tools=[go_back, close_popups, search_item_ctrl_f],
    model=model,
    additional_authorized_imports=[<span class="hljs-string">&quot;helium&quot;</span>],
    step_callbacks=[save_screenshot],
    max_steps=<span class="hljs-number">20</span>,
    verbosity_level=<span class="hljs-number">2</span>,
)

<span class="hljs-comment"># Import helium for the agent</span>
agent.python_executor(<span class="hljs-string">&quot;from helium import *&quot;</span>, agent.state)`,wrap:!1}}),k=new u({props:{code:"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",highlighted:`helium_instructions = <span class="hljs-string">&quot;&quot;&quot;
You can use helium to access websites. Don&#x27;t bother about the helium driver, it&#x27;s already managed.
We&#x27;ve already ran &quot;from helium import *&quot;
Then you can go to pages!
Code:
\`\`\`py
go_to(&#x27;github.com/trending&#x27;)
\`\`\`&lt;end_code&gt;

You can directly click clickable elements by inputting the text that appears on them.
Code:
\`\`\`py
click(&quot;Top products&quot;)
\`\`\`&lt;end_code&gt;

If it&#x27;s a link:
Code:
\`\`\`py
click(Link(&quot;Top products&quot;))
\`\`\`&lt;end_code&gt;

If you try to interact with an element and it&#x27;s not found, you&#x27;ll get a LookupError.
In general stop your action after each button click to see what happens on your screenshot.
Never try to login in a page.

To scroll up or down, use scroll_down or scroll_up with as an argument the number of pixels to scroll from.
Code:
\`\`\`py
scroll_down(num_pixels=1200) # This will scroll one viewport down
\`\`\`&lt;end_code&gt;

When you have pop-ups with a cross icon to close, don&#x27;t try to click the close icon by finding its element or targeting an &#x27;X&#x27; element (this most often fails).
Just use your built-in tool \`close_popups\` to close them:
Code:
\`\`\`py
close_popups()
\`\`\`&lt;end_code&gt;

You can use .exists() to check for the existence of an element. For example:
Code:
\`\`\`py
if Text(&#x27;Accept cookies?&#x27;).exists():
    click(&#x27;I accept&#x27;)
\`\`\`&lt;end_code&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),Q=new u({props:{code:"c2VhcmNoX3JlcXVlc3QlMjAlM0QlMjAlMjIlMjIlMjIlMEFQbGVhc2UlMjBuYXZpZ2F0ZSUyMHRvJTIwaHR0cHMlM0ElMkYlMkZlbi53aWtpcGVkaWEub3JnJTJGd2lraSUyRkNoaWNhZ28lMjBhbmQlMjBnaXZlJTIwbWUlMjBhJTIwc2VudGVuY2UlMjBjb250YWluaW5nJTIwdGhlJTIwd29yZCUyMCUyMjE5OTIlMjIlMjB0aGF0JTIwbWVudGlvbnMlMjBhJTIwY29uc3RydWN0aW9uJTIwYWNjaWRlbnQuJTBBJTIyJTIyJTIyJTBBJTBBYWdlbnRfb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKHNlYXJjaF9yZXF1ZXN0JTIwJTJCJTIwaGVsaXVtX2luc3RydWN0aW9ucyklMEFwcmludCglMjJGaW5hbCUyMG91dHB1dCUzQSUyMiklMEFwcmludChhZ2VudF9vdXRwdXQp",highlighted:`search_request = <span class="hljs-string">&quot;&quot;&quot;
Please navigate to https://en.wikipedia.org/wiki/Chicago and give me a sentence containing the word &quot;1992&quot; that mentions a construction accident.
&quot;&quot;&quot;</span>

agent_output = agent.run(search_request + helium_instructions)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),S=new u({props:{code:"Z2l0aHViX3JlcXVlc3QlMjAlM0QlMjAlMjIlMjIlMjIlMEFJJ20lMjB0cnlpbmclMjB0byUyMGZpbmQlMjBob3clMjBoYXJkJTIwSSUyMGhhdmUlMjB0byUyMHdvcmslMjB0byUyMGdldCUyMGElMjByZXBvJTIwaW4lMjBnaXRodWIuY29tJTJGdHJlbmRpbmcuJTBBQ2FuJTIweW91JTIwbmF2aWdhdGUlMjB0byUyMHRoZSUyMHByb2ZpbGUlMjBmb3IlMjB0aGUlMjB0b3AlMjBhdXRob3IlMjBvZiUyMHRoZSUyMHRvcCUyMHRyZW5kaW5nJTIwcmVwbyUyQyUyMGFuZCUyMGdpdmUlMjBtZSUyMHRoZWlyJTIwdG90YWwlMjBudW1iZXIlMjBvZiUyMGNvbW1pdHMlMjBvdmVyJTIwdGhlJTIwbGFzdCUyMHllYXIlM0YlMEElMjIlMjIlMjIlMEElMEFhZ2VudF9vdXRwdXQlMjAlM0QlMjBhZ2VudC5ydW4oZ2l0aHViX3JlcXVlc3QlMjAlMkIlMjBoZWxpdW1faW5zdHJ1Y3Rpb25zKSUwQXByaW50KCUyMkZpbmFsJTIwb3V0cHV0JTNBJTIyKSUwQXByaW50KGFnZW50X291dHB1dCk=",highlighted:`github_request = <span class="hljs-string">&quot;&quot;&quot;
I&#x27;m trying to find how hard I have to work to get a repo in github.com/trending.
Can you navigate to the profile for the top author of the top trending repo, and give me their total number of commits over the last year?
&quot;&quot;&quot;</span>

agent_output = agent.run(github_request + helium_instructions)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),E=new Hl({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/zh/examples/web_browser.md"}}),{c(){U=M("meta"),H=a(),z=M("p"),A=a(),p(b.$$.fragment),F=a(),p(d.$$.fragment),$=a(),r=M("p"),r.innerHTML=rl,q=a(),T=M("p"),T.textContent=Tl,K=a(),j=M("ul"),j.innerHTML=hl,L=a(),h=M("p"),h.textContent=Il,D=a(),I=M("p"),I.textContent=Bl,P=a(),p(B.$$.fragment),O=a(),C=M("p"),C.textContent=Cl,ll=a(),p(Z.$$.fragment),sl=a(),G=M("p"),G.textContent=Zl,tl=a(),p(W.$$.fragment),el=a(),V=M("p"),V.textContent=Gl,al=a(),p(v.$$.fragment),nl=a(),g=M("p"),g.textContent=Wl,Ml=a(),p(f.$$.fragment),ol=a(),X=M("p"),X.textContent=Vl,yl=a(),p(k.$$.fragment),pl=a(),N=M("p"),N.textContent=vl,cl=a(),p(Q.$$.fragment),il=a(),_=M("p"),_.textContent=gl,wl=a(),p(S.$$.fragment),Jl=a(),x=M("p"),x.textContent=fl,ml=a(),R=M("ul"),R.innerHTML=Xl,Ul=a(),p(E.$$.fragment),jl=a(),Y=M("p"),this.h()},l(l){const s=Rl("svelte-u9bgzb",document.head);U=o(s,"META",{name:!0,content:!0}),s.forEach(t),H=n(l),z=o(l,"P",{}),kl(z).forEach(t),A=n(l),c(b.$$.fragment,l),F=n(l),c(d.$$.fragment,l),$=n(l),r=o(l,"P",{"data-svelte-h":!0}),y(r)!=="svelte-qnpzrx"&&(r.innerHTML=rl),q=n(l),T=o(l,"P",{"data-svelte-h":!0}),y(T)!=="svelte-zjngas"&&(T.textContent=Tl),K=n(l),j=o(l,"UL",{class:!0,"data-svelte-h":!0}),y(j)!=="svelte-179l98a"&&(j.innerHTML=hl),L=n(l),h=o(l,"P",{"data-svelte-h":!0}),y(h)!=="svelte-12hfun9"&&(h.textContent=Il),D=n(l),I=o(l,"P",{"data-svelte-h":!0}),y(I)!=="svelte-dm35fw"&&(I.textContent=Bl),P=n(l),c(B.$$.fragment,l),O=n(l),C=o(l,"P",{"data-svelte-h":!0}),y(C)!=="svelte-10w15qh"&&(C.textContent=Cl),ll=n(l),c(Z.$$.fragment,l),sl=n(l),G=o(l,"P",{"data-svelte-h":!0}),y(G)!=="svelte-1tzm5xm"&&(G.textContent=Zl),tl=n(l),c(W.$$.fragment,l),el=n(l),V=o(l,"P",{"data-svelte-h":!0}),y(V)!=="svelte-1qf76sz"&&(V.textContent=Gl),al=n(l),c(v.$$.fragment,l),nl=n(l),g=o(l,"P",{"data-svelte-h":!0}),y(g)!=="svelte-czbgn0"&&(g.textContent=Wl),Ml=n(l),c(f.$$.fragment,l),ol=n(l),X=o(l,"P",{"data-svelte-h":!0}),y(X)!=="svelte-1lifcrx"&&(X.textContent=Vl),yl=n(l),c(k.$$.fragment,l),pl=n(l),N=o(l,"P",{"data-svelte-h":!0}),y(N)!=="svelte-1gzuxti"&&(N.textContent=vl),cl=n(l),c(Q.$$.fragment,l),il=n(l),_=o(l,"P",{"data-svelte-h":!0}),y(_)!=="svelte-1j23cdx"&&(_.textContent=gl),wl=n(l),c(S.$$.fragment,l),Jl=n(l),x=o(l,"P",{"data-svelte-h":!0}),y(x)!=="svelte-12ic3i3"&&(x.textContent=fl),ml=n(l),R=o(l,"UL",{"data-svelte-h":!0}),y(R)!=="svelte-1edil9s"&&(R.innerHTML=Xl),Ul=n(l),c(E.$$.fragment,l),jl=n(l),Y=o(l,"P",{}),kl(Y).forEach(t),this.h()},h(){bl(U,"name","hf:doc:metadata"),bl(U,"content",Fl),bl(j,"class","contains-task-list")},m(l,s){El(document.head,U),e(l,H,s),e(l,z,s),e(l,A,s),i(b,l,s),e(l,F,s),i(d,l,s),e(l,$,s),e(l,r,s),e(l,q,s),e(l,T,s),e(l,K,s),e(l,j,s),e(l,L,s),e(l,h,s),e(l,D,s),e(l,I,s),e(l,P,s),i(B,l,s),e(l,O,s),e(l,C,s),e(l,ll,s),i(Z,l,s),e(l,sl,s),e(l,G,s),e(l,tl,s),i(W,l,s),e(l,el,s),e(l,V,s),e(l,al,s),i(v,l,s),e(l,nl,s),e(l,g,s),e(l,Ml,s),i(f,l,s),e(l,ol,s),e(l,X,s),e(l,yl,s),i(k,l,s),e(l,pl,s),e(l,N,s),e(l,cl,s),i(Q,l,s),e(l,il,s),e(l,_,s),e(l,wl,s),i(S,l,s),e(l,Jl,s),e(l,x,s),e(l,ml,s),e(l,R,s),e(l,Ul,s),i(E,l,s),e(l,jl,s),e(l,Y,s),ul=!0},p:Ql,i(l){ul||(w(b.$$.fragment,l),w(d.$$.fragment,l),w(B.$$.fragment,l),w(Z.$$.fragment,l),w(W.$$.fragment,l),w(v.$$.fragment,l),w(f.$$.fragment,l),w(k.$$.fragment,l),w(Q.$$.fragment,l),w(S.$$.fragment,l),w(E.$$.fragment,l),ul=!0)},o(l){J(b.$$.fragment,l),J(d.$$.fragment,l),J(B.$$.fragment,l),J(Z.$$.fragment,l),J(W.$$.fragment,l),J(v.$$.fragment,l),J(f.$$.fragment,l),J(k.$$.fragment,l),J(Q.$$.fragment,l),J(S.$$.fragment,l),J(E.$$.fragment,l),ul=!1},d(l){l&&(t(H),t(z),t(A),t(F),t($),t(r),t(q),t(T),t(K),t(j),t(L),t(h),t(D),t(I),t(P),t(O),t(C),t(ll),t(sl),t(G),t(tl),t(el),t(V),t(al),t(nl),t(g),t(Ml),t(ol),t(X),t(yl),t(pl),t(N),t(cl),t(il),t(_),t(wl),t(Jl),t(x),t(ml),t(R),t(Ul),t(jl),t(Y)),t(U),m(b,l),m(d,l),m(B,l),m(Z,l),m(W,l),m(v,l),m(f,l),m(k,l),m(Q,l),m(S,l),m(E,l)}}}const Fl='{"title":"使用Agent实现网页浏览器自动化 🤖🌐","local":"使用agent实现网页浏览器自动化-","sections":[],"depth":1}';function $l(dl){return _l(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ol extends Sl{constructor(U){super(),xl(this,U,$l,Al,Nl,{})}}export{Ol as component};
