import{s as St,a as xt,n as _t,o as Qt}from"../chunks/scheduler.3d32dc09.js";import{S as Ht,i as Lt,e as i,s,c as r,h as Ft,a as o,d as l,b as a,f as Gt,g as u,j as p,k as ge,l as Et,m as n,n as m,t as g,o as M,p as T}from"../chunks/index.f9718211.js";import{C as Nt,H as b,E as Rt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.51c38499.js";import{C as w}from"../chunks/CodeBlock.ab331c21.js";import{D as zt}from"../chunks/DocNotebookDropdown.79c5aa63.js";function At(pt){let c,Me,ue,Te,h,ce,y,be,J,we,d,rt='<p>If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.</p>',de,U,fe,I,ut="Agent runs are complicated to debug.",he,j,mt='Validating that a run went properly is hard, since agent workflows are <a href="../conceptual_guides/intro_agents">unpredictable by design</a> (if they were predictable, you’d just be using good old code).',ye,$,gt="And inspecting a run is hard as well: multi-step agents tend to quickly fill a console with logs, and most of the errors are just “LLM dumb” kind of errors, from which the LLM auto-corrects in the next step by writing better code or tool calls.",Je,v,Mt="So using instrumentation to record agent runs is necessary in production for later inspection and monitoring!",Ue,W,Tt='We’ve adopted the <a href="https://opentelemetry.io/" rel="nofollow">OpenTelemetry</a> standard for instrumenting agent runs.',Ie,C,ct="This means that you can just run some instrumentation code, then run your agents normally, and everything gets logged into your platform. Below are some examples of how to do this with different OpenTelemetry backends.",je,Z,bt="Here’s how it then looks like on the platform:",$e,f,wt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/inspect_run_phoenix.gif"/>',ve,B,We,V,dt='First install the required packages. Here we install <a href="https://github.com/Arize-ai/phoenix" rel="nofollow">Phoenix by Arize AI</a> because that’s a good solution to collect and inspect the logs, but there are other OpenTelemetry-compatible platforms that you could use for this collection &amp; inspection part.',Ce,k,Ze,G,ft="Then run the collector in the background.",Be,S,Ve,x,ht="Finally, set up <code>SmolagentsInstrumentor</code> to trace your agents and send the traces to Phoenix default endpoint.",ke,_,Ge,Q,yt="Then you can run your agents!",Se,H,xe,L,Jt=`Voilà!
You can then navigate to <code>http://0.0.0.0:6006/projects/</code> to inspect your run!`,_e,re,Ut,Qe,F,It="You can see that the CodeAgent called its managed ToolCallingAgent (by the way, the managed agent could have been a CodeAgent as well) to ask it to run the web search for the U.S. 2024 growth rate. Then the managed agent returned its report and the manager agent acted upon it to calculate the economy doubling time! Sweet, isn’t it?",He,E,Le,N,jt="This part shows how to monitor and debug your Hugging Face <strong>smolagents</strong> with <strong>Langfuse</strong> using the <code>SmolagentsInstrumentor</code>.",Fe,R,$t='<p><strong>What is Langfuse?</strong> <a href="https://langfuse.com" rel="nofollow">Langfuse</a> is an open-source platform for LLM engineering. It provides tracing and monitoring capabilities for AI agents, helping developers debug, analyze, and optimize their products. Langfuse integrates with various tools and frameworks via native integrations, OpenTelemetry, and SDKs.</p>',Ee,z,Ne,A,Re,Y,ze,q,vt='Set your Langfuse API keys and configure the OpenTelemetry endpoint to send traces to Langfuse. Get your Langfuse API keys by signing up for <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Cloud</a> or <a href="https://langfuse.com/self-hosting" rel="nofollow">self-hosting Langfuse</a>.',Ae,X,Wt='Also, add your <a href="https://huggingface.co/settings/tokens" rel="nofollow">Hugging Face token</a> (<code>HF_TOKEN</code>) as an environment variable.',Ye,P,qe,D,Ct="With the environment variables set, we can now initialize the Langfuse client. <code>get_client()</code> initializes the Langfuse client using the credentials provided in the environment variables.",Xe,O,Pe,K,De,ee,Zt="Initialize the <code>SmolagentsInstrumentor</code> before your application code.",Oe,te,Ke,le,et,ne,tt,se,lt,ae,Bt='After running the agent, you can view the traces generated by your smolagents application in <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse</a>. You should see detailed steps of the LLM interactions, which can help you debug and optimize your AI agent.',nt,ie,Vt='<img src="https://langfuse.com/images/cookbook/integration-smolagents/smolagent_example_trace.png" alt="smolagents example trace"/>',st,oe,kt='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/ce5160f9bfd5a6cd63b07d2bfcec6f54?timestamp=2025-02-11T09%3A25%3A45.163Z&amp;display=details" rel="nofollow">Public example trace in Langfuse</a></em>',at,pe,it,me,ot;return h=new Nt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new b({props:{title:"Inspecting runs with OpenTelemetry",local:"inspecting-runs-with-opentelemetry",headingTag:"h1"}}),J=new zt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/inspect_runs.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/inspect_runs.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/inspect_runs.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/inspect_runs.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/inspect_runs.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/inspect_runs.ipynb"}]}}),U=new b({props:{title:"Why log your agent runs?",local:"why-log-your-agent-runs",headingTag:"h2"}}),B=new b({props:{title:"Setting up telemetry with Arize AI Phoenix",local:"setting-up-telemetry-with-arize-ai-phoenix",headingTag:"h2"}}),k=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCdGVsZW1ldHJ5JTJDdG9vbGtpdCU1RCc=",highlighted:"pip install &#x27;smolagents[telemetry,toolkit]&#x27;",wrap:!1}}),S=new w({props:{code:"cHl0aG9uJTIwLW0lMjBwaG9lbml4LnNlcnZlci5tYWluJTIwc2VydmU=",highlighted:"python -m phoenix.server.main serve",wrap:!1}}),_=new w({props:{code:"ZnJvbSUyMHBob2VuaXgub3RlbCUyMGltcG9ydCUyMHJlZ2lzdGVyJTBBZnJvbSUyMG9wZW5pbmZlcmVuY2UuaW5zdHJ1bWVudGF0aW9uLnNtb2xhZ2VudHMlMjBpbXBvcnQlMjBTbW9sYWdlbnRzSW5zdHJ1bWVudG9yJTBBJTBBcmVnaXN0ZXIoKSUwQVNtb2xhZ2VudHNJbnN0cnVtZW50b3IoKS5pbnN0cnVtZW50KCk=",highlighted:`<span class="hljs-keyword">from</span> phoenix.otel <span class="hljs-keyword">import</span> register
<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor

register()
SmolagentsInstrumentor().instrument()`,wrap:!1}}),H=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ29kZUFnZW50JTJDJTBBJTIwJTIwJTIwJTIwVG9vbENhbGxpbmdBZ2VudCUyQyUwQSUyMCUyMCUyMCUyMFdlYlNlYXJjaFRvb2wlMkMlMEElMjAlMjAlMjAlMjBWaXNpdFdlYnBhZ2VUb29sJTJDJTBBJTIwJTIwJTIwJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwlMkMlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBJTBBc2VhcmNoX2FnZW50JTIwJTNEJTIwVG9vbENhbGxpbmdBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QldlYlNlYXJjaFRvb2woKSUyQyUyMFZpc2l0V2VicGFnZVRvb2woKSU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyc2VhcmNoX2FnZW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJUaGlzJTIwaXMlMjBhbiUyMGFnZW50JTIwdGhhdCUyMGNhbiUyMGRvJTIwd2ViJTIwc2VhcmNoLiUyMiUyQyUwQSklMEElMEFtYW5hZ2VyX2FnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1hbmFnZWRfYWdlbnRzJTNEJTVCc2VhcmNoX2FnZW50JTVEJTJDJTBBKSUwQW1hbmFnZXJfYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMklmJTIwdGhlJTIwVVMlMjBrZWVwcyUyMGl0cyUyMDIwMjQlMjBncm93dGglMjByYXRlJTJDJTIwaG93JTIwbWFueSUyMHllYXJzJTIwd2lsbCUyMGl0JTIwdGFrZSUyMGZvciUyMHRoZSUyMEdEUCUyMHRvJTIwZG91YmxlJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (
    CodeAgent,
    ToolCallingAgent,
    WebSearchTool,
    VisitWebpageTool,
    InferenceClientModel,
)

model = InferenceClientModel()

search_agent = ToolCallingAgent(
    tools=[WebSearchTool(), VisitWebpageTool()],
    model=model,
    name=<span class="hljs-string">&quot;search_agent&quot;</span>,
    description=<span class="hljs-string">&quot;This is an agent that can do web search.&quot;</span>,
)

manager_agent = CodeAgent(
    tools=[],
    model=model,
    managed_agents=[search_agent],
)
manager_agent.run(
    <span class="hljs-string">&quot;If the US keeps its 2024 growth rate, how many years will it take for the GDP to double?&quot;</span>
)`,wrap:!1}}),E=new b({props:{title:"Setting up telemetry with 🪢 Langfuse",local:"setting-up-telemetry-with--langfuse",headingTag:"h2"}}),z=new b({props:{title:"Step 1: Install Dependencies",local:"step-1-install-dependencies",headingTag:"h3"}}),A=new w({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdmdXNlJTIwJ3Ntb2xhZ2VudHMlNUJ0ZWxlbWV0cnklNUQnJTIwb3BlbmluZmVyZW5jZS1pbnN0cnVtZW50YXRpb24tc21vbGFnZW50cw==",highlighted:'%pip install langfuse <span class="hljs-string">&#x27;smolagents[telemetry]&#x27;</span> openinference-instrumentation-smolagents',wrap:!1}}),Y=new b({props:{title:"Step 2: Set Up Environment Variables",local:"step-2-set-up-environment-variables",headingTag:"h3"}}),P=new w({props:{code:"aW1wb3J0JTIwb3MlMEElMjMlMjBHZXQlMjBrZXlzJTIwZm9yJTIweW91ciUyMHByb2plY3QlMjBmcm9tJTIwdGhlJTIwcHJvamVjdCUyMHNldHRpbmdzJTIwcGFnZSUzQSUyMGh0dHBzJTNBJTJGJTJGY2xvdWQubGFuZ2Z1c2UuY29tJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1BVQkxJQ19LRVklMjIlNUQlMjAlM0QlMjAlMjJway1sZi0uLi4lMjIlMjAlMEFvcy5lbnZpcm9uJTVCJTIyTEFOR0ZVU0VfU0VDUkVUX0tFWSUyMiU1RCUyMCUzRCUyMCUyMnNrLWxmLS4uLiUyMiUyMCUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZjbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQUElRjAlOUYlODclQkElMjBFVSUyMHJlZ2lvbiUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjBVUyUyMHJlZ2lvbiUwQSUyMCUwQSUyMyUyMHlvdXIlMjBIdWdnaW5nJTIwRmFjZSUyMHRva2VuJTBBb3MuZW52aXJvbiU1QiUyMkhGX1RPS0VOJTIyJTVEJTIwJTNEJTIwJTIyaGZfLi4uJTIy",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-comment"># Get keys for your project from the project settings page: https://cloud.langfuse.com</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = <span class="hljs-string">&quot;sk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span> <span class="hljs-comment"># 🇪🇺 EU region</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot; # 🇺🇸 US region</span>
 
<span class="hljs-comment"># your Hugging Face token</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = <span class="hljs-string">&quot;hf_...&quot;</span>`,wrap:!1}}),O=new w({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwZ2V0X2NsaWVudCUwQSUyMCUwQWxhbmdmdXNlJTIwJTNEJTIwZ2V0X2NsaWVudCgpJTBBJTIwJTBBJTIzJTIwVmVyaWZ5JTIwY29ubmVjdGlvbiUwQWlmJTIwbGFuZ2Z1c2UuYXV0aF9jaGVjaygpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyTGFuZ2Z1c2UlMjBjbGllbnQlMjBpcyUyMGF1dGhlbnRpY2F0ZWQlMjBhbmQlMjByZWFkeSElMjIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkF1dGhlbnRpY2F0aW9uJTIwZmFpbGVkLiUyMFBsZWFzZSUyMGNoZWNrJTIweW91ciUyMGNyZWRlbnRpYWxzJTIwYW5kJTIwaG9zdC4lMjIp",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
 
langfuse = get_client()
 
<span class="hljs-comment"># Verify connection</span>
<span class="hljs-keyword">if</span> langfuse.auth_check():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Langfuse client is authenticated and ready!&quot;</span>)
<span class="hljs-keyword">else</span>:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Authentication failed. Please check your credentials and host.&quot;</span>)`,wrap:!1}}),K=new b({props:{title:"Step 3: Initialize the SmolagentsInstrumentor",local:"step-3-initialize-the-smolagentsinstrumentor",headingTag:"h3"}}),te=new w({props:{code:"ZnJvbSUyMG9wZW5pbmZlcmVuY2UuaW5zdHJ1bWVudGF0aW9uLnNtb2xhZ2VudHMlMjBpbXBvcnQlMjBTbW9sYWdlbnRzSW5zdHJ1bWVudG9yJTBBJTIwJTBBU21vbGFnZW50c0luc3RydW1lbnRvcigpLmluc3RydW1lbnQoKQ==",highlighted:`<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor
 
SmolagentsInstrumentor().instrument()`,wrap:!1}}),le=new b({props:{title:"Step 4: Run your smolagent",local:"step-4-run-your-smolagent",headingTag:"h3"}}),ne=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ29kZUFnZW50JTJDJTBBJTIwJTIwJTIwJTIwVG9vbENhbGxpbmdBZ2VudCUyQyUwQSUyMCUyMCUyMCUyMFdlYlNlYXJjaFRvb2wlMkMlMEElMjAlMjAlMjAlMjBWaXNpdFdlYnBhZ2VUb29sJTJDJTBBJTIwJTIwJTIwJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwlMkMlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCUyMmRlZXBzZWVrLWFpJTJGRGVlcFNlZWstUjEtRGlzdGlsbC1Rd2VuLTMyQiUyMiUwQSklMEElMEFzZWFyY2hfYWdlbnQlMjAlM0QlMjBUb29sQ2FsbGluZ0FnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCV2ViU2VhcmNoVG9vbCgpJTJDJTIwVmlzaXRXZWJwYWdlVG9vbCgpJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJzZWFyY2hfYWdlbnQlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlRoaXMlMjBpcyUyMGFuJTIwYWdlbnQlMjB0aGF0JTIwY2FuJTIwZG8lMjB3ZWIlMjBzZWFyY2guJTIyJTJDJTBBKSUwQSUwQW1hbmFnZXJfYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwbWFuYWdlZF9hZ2VudHMlM0QlNUJzZWFyY2hfYWdlbnQlNUQlMkMlMEEpJTBBbWFuYWdlcl9hZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySG93JTIwY2FuJTIwTGFuZ2Z1c2UlMjBiZSUyMHVzZWQlMjB0byUyMG1vbml0b3IlMjBhbmQlMjBpbXByb3ZlJTIwdGhlJTIwcmVhc29uaW5nJTIwYW5kJTIwZGVjaXNpb24tbWFraW5nJTIwb2YlMjBzbW9sYWdlbnRzJTIwd2hlbiUyMHRoZXklMjBleGVjdXRlJTIwbXVsdGktc3RlcCUyMHRhc2tzJTJDJTIwbGlrZSUyMGR5bmFtaWNhbGx5JTIwYWRqdXN0aW5nJTIwYSUyMHJlY2lwZSUyMGJhc2VkJTIwb24lMjB1c2VyJTIwZmVlZGJhY2slMjBvciUyMGF2YWlsYWJsZSUyMGluZ3JlZGllbnRzJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (
    CodeAgent,
    ToolCallingAgent,
    WebSearchTool,
    VisitWebpageTool,
    InferenceClientModel,
)

model = InferenceClientModel(
    model_id=<span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1-Distill-Qwen-32B&quot;</span>
)

search_agent = ToolCallingAgent(
    tools=[WebSearchTool(), VisitWebpageTool()],
    model=model,
    name=<span class="hljs-string">&quot;search_agent&quot;</span>,
    description=<span class="hljs-string">&quot;This is an agent that can do web search.&quot;</span>,
)

manager_agent = CodeAgent(
    tools=[],
    model=model,
    managed_agents=[search_agent],
)
manager_agent.run(
    <span class="hljs-string">&quot;How can Langfuse be used to monitor and improve the reasoning and decision-making of smolagents when they execute multi-step tasks, like dynamically adjusting a recipe based on user feedback or available ingredients?&quot;</span>
)`,wrap:!1}}),se=new b({props:{title:"Step 5: View Traces in Langfuse",local:"step-5-view-traces-in-langfuse",headingTag:"h3"}}),pe=new Rt({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/inspect_runs.md"}}),{c(){c=i("meta"),Me=s(),ue=i("p"),Te=s(),r(h.$$.fragment),ce=s(),r(y.$$.fragment),be=s(),r(J.$$.fragment),we=s(),d=i("blockquote"),d.innerHTML=rt,de=s(),r(U.$$.fragment),fe=s(),I=i("p"),I.textContent=ut,he=s(),j=i("p"),j.innerHTML=mt,ye=s(),$=i("p"),$.textContent=gt,Je=s(),v=i("p"),v.textContent=Mt,Ue=s(),W=i("p"),W.innerHTML=Tt,Ie=s(),C=i("p"),C.textContent=ct,je=s(),Z=i("p"),Z.textContent=bt,$e=s(),f=i("div"),f.innerHTML=wt,ve=s(),r(B.$$.fragment),We=s(),V=i("p"),V.innerHTML=dt,Ce=s(),r(k.$$.fragment),Ze=s(),G=i("p"),G.textContent=ft,Be=s(),r(S.$$.fragment),Ve=s(),x=i("p"),x.innerHTML=ht,ke=s(),r(_.$$.fragment),Ge=s(),Q=i("p"),Q.textContent=yt,Se=s(),r(H.$$.fragment),xe=s(),L=i("p"),L.innerHTML=Jt,_e=s(),re=i("img"),Qe=s(),F=i("p"),F.textContent=It,He=s(),r(E.$$.fragment),Le=s(),N=i("p"),N.innerHTML=jt,Fe=s(),R=i("blockquote"),R.innerHTML=$t,Ee=s(),r(z.$$.fragment),Ne=s(),r(A.$$.fragment),Re=s(),r(Y.$$.fragment),ze=s(),q=i("p"),q.innerHTML=vt,Ae=s(),X=i("p"),X.innerHTML=Wt,Ye=s(),r(P.$$.fragment),qe=s(),D=i("p"),D.innerHTML=Ct,Xe=s(),r(O.$$.fragment),Pe=s(),r(K.$$.fragment),De=s(),ee=i("p"),ee.innerHTML=Zt,Oe=s(),r(te.$$.fragment),Ke=s(),r(le.$$.fragment),et=s(),r(ne.$$.fragment),tt=s(),r(se.$$.fragment),lt=s(),ae=i("p"),ae.innerHTML=Bt,nt=s(),ie=i("p"),ie.innerHTML=Vt,st=s(),oe=i("p"),oe.innerHTML=kt,at=s(),r(pe.$$.fragment),it=s(),me=i("p"),this.h()},l(e){const t=Ft("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(l),Me=a(e),ue=o(e,"P",{}),Gt(ue).forEach(l),Te=a(e),u(h.$$.fragment,e),ce=a(e),u(y.$$.fragment,e),be=a(e),u(J.$$.fragment,e),we=a(e),d=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(d)!=="svelte-1eo9frz"&&(d.innerHTML=rt),de=a(e),u(U.$$.fragment,e),fe=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-b60rwm"&&(I.textContent=ut),he=a(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1vbx0nq"&&(j.innerHTML=mt),ye=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-6dts52"&&($.textContent=gt),Je=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-be9uix"&&(v.textContent=Mt),Ue=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-a44to5"&&(W.innerHTML=Tt),Ie=a(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1fuj4vi"&&(C.textContent=ct),je=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-18al2cw"&&(Z.textContent=bt),$e=a(e),f=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(f)!=="svelte-14dyk5w"&&(f.innerHTML=wt),ve=a(e),u(B.$$.fragment,e),We=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-o5owj0"&&(V.innerHTML=dt),Ce=a(e),u(k.$$.fragment,e),Ze=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1g5pcik"&&(G.textContent=ft),Be=a(e),u(S.$$.fragment,e),Ve=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-y3xi4v"&&(x.innerHTML=ht),ke=a(e),u(_.$$.fragment,e),Ge=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1j1jswr"&&(Q.textContent=yt),Se=a(e),u(H.$$.fragment,e),xe=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-jcl2lc"&&(L.innerHTML=Jt),_e=a(e),re=o(e,"IMG",{src:!0}),Qe=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-11c8ug9"&&(F.textContent=It),He=a(e),u(E.$$.fragment,e),Le=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1klyknm"&&(N.innerHTML=jt),Fe=a(e),R=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(R)!=="svelte-10vakt2"&&(R.innerHTML=$t),Ee=a(e),u(z.$$.fragment,e),Ne=a(e),u(A.$$.fragment,e),Re=a(e),u(Y.$$.fragment,e),ze=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-e5j4hz"&&(q.innerHTML=vt),Ae=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-8df0ib"&&(X.innerHTML=Wt),Ye=a(e),u(P.$$.fragment,e),qe=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-wfv4z0"&&(D.innerHTML=Ct),Xe=a(e),u(O.$$.fragment,e),Pe=a(e),u(K.$$.fragment,e),De=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-pz6aii"&&(ee.innerHTML=Zt),Oe=a(e),u(te.$$.fragment,e),Ke=a(e),u(le.$$.fragment,e),et=a(e),u(ne.$$.fragment,e),tt=a(e),u(se.$$.fragment,e),lt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1207qpx"&&(ae.innerHTML=Bt),nt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-jw4wqs"&&(ie.innerHTML=Vt),st=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-7h9ald"&&(oe.innerHTML=kt),at=a(e),u(pe.$$.fragment,e),it=a(e),me=o(e,"P",{}),Gt(me).forEach(l),this.h()},h(){ge(c,"name","hf:doc:metadata"),ge(c,"content",Yt),ge(d,"class","tip"),ge(f,"class","flex justify-center"),xt(re.src,Ut="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/inspect_run_phoenix.png")||ge(re,"src",Ut)},m(e,t){Et(document.head,c),n(e,Me,t),n(e,ue,t),n(e,Te,t),m(h,e,t),n(e,ce,t),m(y,e,t),n(e,be,t),m(J,e,t),n(e,we,t),n(e,d,t),n(e,de,t),m(U,e,t),n(e,fe,t),n(e,I,t),n(e,he,t),n(e,j,t),n(e,ye,t),n(e,$,t),n(e,Je,t),n(e,v,t),n(e,Ue,t),n(e,W,t),n(e,Ie,t),n(e,C,t),n(e,je,t),n(e,Z,t),n(e,$e,t),n(e,f,t),n(e,ve,t),m(B,e,t),n(e,We,t),n(e,V,t),n(e,Ce,t),m(k,e,t),n(e,Ze,t),n(e,G,t),n(e,Be,t),m(S,e,t),n(e,Ve,t),n(e,x,t),n(e,ke,t),m(_,e,t),n(e,Ge,t),n(e,Q,t),n(e,Se,t),m(H,e,t),n(e,xe,t),n(e,L,t),n(e,_e,t),n(e,re,t),n(e,Qe,t),n(e,F,t),n(e,He,t),m(E,e,t),n(e,Le,t),n(e,N,t),n(e,Fe,t),n(e,R,t),n(e,Ee,t),m(z,e,t),n(e,Ne,t),m(A,e,t),n(e,Re,t),m(Y,e,t),n(e,ze,t),n(e,q,t),n(e,Ae,t),n(e,X,t),n(e,Ye,t),m(P,e,t),n(e,qe,t),n(e,D,t),n(e,Xe,t),m(O,e,t),n(e,Pe,t),m(K,e,t),n(e,De,t),n(e,ee,t),n(e,Oe,t),m(te,e,t),n(e,Ke,t),m(le,e,t),n(e,et,t),m(ne,e,t),n(e,tt,t),m(se,e,t),n(e,lt,t),n(e,ae,t),n(e,nt,t),n(e,ie,t),n(e,st,t),n(e,oe,t),n(e,at,t),m(pe,e,t),n(e,it,t),n(e,me,t),ot=!0},p:_t,i(e){ot||(g(h.$$.fragment,e),g(y.$$.fragment,e),g(J.$$.fragment,e),g(U.$$.fragment,e),g(B.$$.fragment,e),g(k.$$.fragment,e),g(S.$$.fragment,e),g(_.$$.fragment,e),g(H.$$.fragment,e),g(E.$$.fragment,e),g(z.$$.fragment,e),g(A.$$.fragment,e),g(Y.$$.fragment,e),g(P.$$.fragment,e),g(O.$$.fragment,e),g(K.$$.fragment,e),g(te.$$.fragment,e),g(le.$$.fragment,e),g(ne.$$.fragment,e),g(se.$$.fragment,e),g(pe.$$.fragment,e),ot=!0)},o(e){M(h.$$.fragment,e),M(y.$$.fragment,e),M(J.$$.fragment,e),M(U.$$.fragment,e),M(B.$$.fragment,e),M(k.$$.fragment,e),M(S.$$.fragment,e),M(_.$$.fragment,e),M(H.$$.fragment,e),M(E.$$.fragment,e),M(z.$$.fragment,e),M(A.$$.fragment,e),M(Y.$$.fragment,e),M(P.$$.fragment,e),M(O.$$.fragment,e),M(K.$$.fragment,e),M(te.$$.fragment,e),M(le.$$.fragment,e),M(ne.$$.fragment,e),M(se.$$.fragment,e),M(pe.$$.fragment,e),ot=!1},d(e){e&&(l(Me),l(ue),l(Te),l(ce),l(be),l(we),l(d),l(de),l(fe),l(I),l(he),l(j),l(ye),l($),l(Je),l(v),l(Ue),l(W),l(Ie),l(C),l(je),l(Z),l($e),l(f),l(ve),l(We),l(V),l(Ce),l(Ze),l(G),l(Be),l(Ve),l(x),l(ke),l(Ge),l(Q),l(Se),l(xe),l(L),l(_e),l(re),l(Qe),l(F),l(He),l(Le),l(N),l(Fe),l(R),l(Ee),l(Ne),l(Re),l(ze),l(q),l(Ae),l(X),l(Ye),l(qe),l(D),l(Xe),l(Pe),l(De),l(ee),l(Oe),l(Ke),l(et),l(tt),l(lt),l(ae),l(nt),l(ie),l(st),l(oe),l(at),l(it),l(me)),l(c),T(h,e),T(y,e),T(J,e),T(U,e),T(B,e),T(k,e),T(S,e),T(_,e),T(H,e),T(E,e),T(z,e),T(A,e),T(Y,e),T(P,e),T(O,e),T(K,e),T(te,e),T(le,e),T(ne,e),T(se,e),T(pe,e)}}}const Yt='{"title":"Inspecting runs with OpenTelemetry","local":"inspecting-runs-with-opentelemetry","sections":[{"title":"Why log your agent runs?","local":"why-log-your-agent-runs","sections":[],"depth":2},{"title":"Setting up telemetry with Arize AI Phoenix","local":"setting-up-telemetry-with-arize-ai-phoenix","sections":[],"depth":2},{"title":"Setting up telemetry with 🪢 Langfuse","local":"setting-up-telemetry-with--langfuse","sections":[{"title":"Step 1: Install Dependencies","local":"step-1-install-dependencies","sections":[],"depth":3},{"title":"Step 2: Set Up Environment Variables","local":"step-2-set-up-environment-variables","sections":[],"depth":3},{"title":"Step 3: Initialize the SmolagentsInstrumentor","local":"step-3-initialize-the-smolagentsinstrumentor","sections":[],"depth":3},{"title":"Step 4: Run your smolagent","local":"step-4-run-your-smolagent","sections":[],"depth":3},{"title":"Step 5: View Traces in Langfuse","local":"step-5-view-traces-in-langfuse","sections":[],"depth":3}],"depth":2}],"depth":1}';function qt(pt){return Qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class el extends Ht{constructor(c){super(),Lt(this,c,qt,At,St,{})}}export{el as component};
