import{s as Se,n as Fe,o as He}from"../chunks/scheduler.3d32dc09.js";import{S as xe,i as Ye,e as p,s as n,c as i,h as Le,a as o,d as t,b as a,f as Ee,g as y,j as m,k as ze,l as qe,m as l,n as M,t as c,o as r,p as b}from"../chunks/index.f9718211.js";import{C as Pe,H as fe,E as De}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.51c38499.js";import{C as F}from"../chunks/CodeBlock.ab331c21.js";import{D as Ke}from"../chunks/DocNotebookDropdown.79c5aa63.js";function Oe(Ie){let w,Y,H,L,u,q,h,P,J,D,T,Ce=`In the end, an agent can be defined by simple components: it has tools, prompts.
And most importantly, it has a memory of past steps, drawing a history of planning, execution, and errors.`,K,d,O,U,Ze="We propose several features to inspect a past agent run.",ee,j,ve='You can instrument the agent’s run to display it in a great UI that lets you zoom in/out on specific steps, as highlighted in the <a href="./inspect_runs">instrumentation guide</a>.',se,g,Be="You can also use <code>agent.replay()</code>, as follows:",te,f,_e="After the agent has run:",le,I,ne,C,Ve="If you want to replay this last run, just use:",ae,Z,pe,v,oe,B,We="Many advanced use cases require dynamic modification of the agent’s memory.",me,_,ke="You can access the agent’s memory using:",ie,V,ye,W,Xe="Use <code>agent.memory.get_full_steps()</code> to get full steps as dictionaries.",Me,k,$e="You can also use step callbacks to dynamically change the agent’s memory.",ce,X,Ge="Step callbacks can access the <code>agent</code> itself in their arguments, so they can access any memory step as highlighted above, and change it if needed. For instance, let’s say you are observing screenshots of each step performed by a web browser agent. You want to log the newest screenshot, and remove the images from ancient steps to save on token costs.",re,$,Ne=`You could run something like the following.
<em>Note: this code is incomplete, some imports and object definitions have been removed for the sake of concision, visit <a href="https://github.com/huggingface/smolagents/blob/main/src/smolagents/vision_web_browser.py" rel="nofollow">the original script</a> to get the full working code.</em>`,be,G,we,N,Re="Then you should pass this function in the <code>step_callbacks</code> argument upon initialization of your agent:",ue,R,he,Q,Qe='Head to our <a href="https://github.com/huggingface/smolagents/blob/main/src/smolagents/vision_web_browser.py" rel="nofollow">vision web browser code</a> to see the full working example.',Je,A,Te,E,Ae=`This can be useful in case you have tool calls that take days: you can just run your agents step by step.
This will also let you update the memory on each step.`,de,z,Ue,S,je,x,ge;return u=new Pe({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),h=new fe({props:{title:"📚 Manage your agent’s memory",local:"-manage-your-agents-memory",headingTag:"h1"}}),J=new Ke({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/memory.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/memory.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/memory.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/memory.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/memory.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/memory.ipynb"}]}}),d=new fe({props:{title:"Replay your agent’s memory",local:"replay-your-agents-memory",headingTag:"h3"}}),I=new F({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwdmVyYm9zaXR5X2xldmVsJTNEMCklMEElMEFyZXN1bHQlMjAlM0QlMjBhZ2VudC5ydW4oJTIyV2hhdCdzJTIwdGhlJTIwMjB0aCUyMEZpYm9uYWNjaSUyMG51bWJlciUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(tools=[], model=InferenceClientModel(), verbosity_level=<span class="hljs-number">0</span>)

result = agent.run(<span class="hljs-string">&quot;What&#x27;s the 20th Fibonacci number?&quot;</span>)`,wrap:!1}}),Z=new F({props:{code:"YWdlbnQucmVwbGF5KCk=",highlighted:"agent.replay()",wrap:!1}}),v=new fe({props:{title:"Dynamically change the agent’s memory",local:"dynamically-change-the-agents-memory",headingTag:"h3"}}),V=new F({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBBY3Rpb25TdGVwJTBBJTBBc3lzdGVtX3Byb21wdF9zdGVwJTIwJTNEJTIwYWdlbnQubWVtb3J5LnN5c3RlbV9wcm9tcHQlMEFwcmludCglMjJUaGUlMjBzeXN0ZW0lMjBwcm9tcHQlMjBnaXZlbiUyMHRvJTIwdGhlJTIwYWdlbnQlMjB3YXMlM0ElMjIpJTBBcHJpbnQoc3lzdGVtX3Byb21wdF9zdGVwLnN5c3RlbV9wcm9tcHQpJTBBJTBBdGFza19zdGVwJTIwJTNEJTIwYWdlbnQubWVtb3J5LnN0ZXBzJTVCMCU1RCUwQXByaW50KCUyMiU1Q24lNUNuVGhlJTIwZmlyc3QlMjB0YXNrJTIwc3RlcCUyMHdhcyUzQSUyMiklMEFwcmludCh0YXNrX3N0ZXAudGFzayklMEElMEFmb3IlMjBzdGVwJTIwaW4lMjBhZ2VudC5tZW1vcnkuc3RlcHMlM0ElMEElMjAlMjAlMjAlMjBpZiUyMGlzaW5zdGFuY2Uoc3RlcCUyQyUyMEFjdGlvblN0ZXApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzdGVwLmVycm9yJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiU1Q25TdGVwJTIwJTdCc3RlcC5zdGVwX251bWJlciU3RCUyMGdvdCUyMHRoaXMlMjBlcnJvciUzQSU1Q24lN0JzdGVwLmVycm9yJTdEJTVDbiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiU1Q25TdGVwJTIwJTdCc3RlcC5zdGVwX251bWJlciU3RCUyMGdvdCUyMHRoZXNlJTIwb2JzZXJ2YXRpb25zJTNBJTVDbiU3QnN0ZXAub2JzZXJ2YXRpb25zJTdEJTVDbiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ActionStep

system_prompt_step = agent.memory.system_prompt
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The system prompt given to the agent was:&quot;</span>)
<span class="hljs-built_in">print</span>(system_prompt_step.system_prompt)

task_step = agent.memory.steps[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n\\nThe first task step was:&quot;</span>)
<span class="hljs-built_in">print</span>(task_step.task)

<span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> agent.memory.steps:
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(step, ActionStep):
        <span class="hljs-keyword">if</span> step.error <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nStep <span class="hljs-subst">{step.step_number}</span> got this error:\\n<span class="hljs-subst">{step.error}</span>\\n&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nStep <span class="hljs-subst">{step.step_number}</span> got these observations:\\n<span class="hljs-subst">{step.observations}</span>\\n&quot;</span>)`,wrap:!1}}),G=new F({props:{code:"aW1wb3J0JTIwaGVsaXVtJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMGlvJTIwaW1wb3J0JTIwQnl0ZXNJTyUwQWZyb20lMjB0aW1lJTIwaW1wb3J0JTIwc2xlZXAlMEElMEFkZWYlMjB1cGRhdGVfc2NyZWVuc2hvdChtZW1vcnlfc3RlcCUzQSUyMEFjdGlvblN0ZXAlMkMlMjBhZ2VudCUzQSUyMENvZGVBZ2VudCklMjAtJTNFJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMHNsZWVwKDEuMCklMjAlMjAlMjMlMjBMZXQlMjBKYXZhU2NyaXB0JTIwYW5pbWF0aW9ucyUyMGhhcHBlbiUyMGJlZm9yZSUyMHRha2luZyUyMHRoZSUyMHNjcmVlbnNob3QlMEElMjAlMjAlMjAlMjBkcml2ZXIlMjAlM0QlMjBoZWxpdW0uZ2V0X2RyaXZlcigpJTBBJTIwJTIwJTIwJTIwbGF0ZXN0X3N0ZXAlMjAlM0QlMjBtZW1vcnlfc3RlcC5zdGVwX251bWJlciUwQSUyMCUyMCUyMCUyMGZvciUyMHByZXZpb3VzX21lbW9yeV9zdGVwJTIwaW4lMjBhZ2VudC5tZW1vcnkuc3RlcHMlM0ElMjAlMjAlMjMlMjBSZW1vdmUlMjBwcmV2aW91cyUyMHNjcmVlbnNob3RzJTIwZnJvbSUyMGxvZ3MlMjBmb3IlMjBsZWFuJTIwcHJvY2Vzc2luZyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwaXNpbnN0YW5jZShwcmV2aW91c19tZW1vcnlfc3RlcCUyQyUyMEFjdGlvblN0ZXApJTIwYW5kJTIwcHJldmlvdXNfbWVtb3J5X3N0ZXAuc3RlcF9udW1iZXIlMjAlM0MlM0QlMjBsYXRlc3Rfc3RlcCUyMC0lMjAyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJldmlvdXNfbWVtb3J5X3N0ZXAub2JzZXJ2YXRpb25zX2ltYWdlcyUyMCUzRCUyME5vbmUlMEElMjAlMjAlMjAlMjBwbmdfYnl0ZXMlMjAlM0QlMjBkcml2ZXIuZ2V0X3NjcmVlbnNob3RfYXNfcG5nKCklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4oQnl0ZXNJTyhwbmdfYnl0ZXMpKSUwQSUyMCUyMCUyMCUyMG1lbW9yeV9zdGVwLm9ic2VydmF0aW9uc19pbWFnZXMlMjAlM0QlMjAlNUJpbWFnZS5jb3B5KCklNUQ=",highlighted:`<span class="hljs-keyword">import</span> helium
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> time <span class="hljs-keyword">import</span> sleep

<span class="hljs-keyword">def</span> <span class="hljs-title function_">update_screenshot</span>(<span class="hljs-params">memory_step: ActionStep, agent: CodeAgent</span>) -&gt; <span class="hljs-literal">None</span>:
    sleep(<span class="hljs-number">1.0</span>)  <span class="hljs-comment"># Let JavaScript animations happen before taking the screenshot</span>
    driver = helium.get_driver()
    latest_step = memory_step.step_number
    <span class="hljs-keyword">for</span> previous_memory_step <span class="hljs-keyword">in</span> agent.memory.steps:  <span class="hljs-comment"># Remove previous screenshots from logs for lean processing</span>
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(previous_memory_step, ActionStep) <span class="hljs-keyword">and</span> previous_memory_step.step_number &lt;= latest_step - <span class="hljs-number">2</span>:
            previous_memory_step.observations_images = <span class="hljs-literal">None</span>
    png_bytes = driver.get_screenshot_as_png()
    image = Image.<span class="hljs-built_in">open</span>(BytesIO(png_bytes))
    memory_step.observations_images = [image.copy()]`,wrap:!1}}),R=new F({props:{code:"Q29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCV2ViU2VhcmNoVG9vbCgpJTJDJTIwZ29fYmFjayUyQyUyMGNsb3NlX3BvcHVwcyUyQyUyMHNlYXJjaF9pdGVtX2N0cmxfZiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhZGRpdGlvbmFsX2F1dGhvcml6ZWRfaW1wb3J0cyUzRCU1QiUyMmhlbGl1bSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHN0ZXBfY2FsbGJhY2tzJTNEJTVCdXBkYXRlX3NjcmVlbnNob3QlNUQlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMHZlcmJvc2l0eV9sZXZlbCUzRDIlMkMlMEEp",highlighted:`CodeAgent(
    tools=[WebSearchTool(), go_back, close_popups, search_item_ctrl_f],
    model=model,
    additional_authorized_imports=[<span class="hljs-string">&quot;helium&quot;</span>],
    step_callbacks=[update_screenshot],
    max_steps=<span class="hljs-number">20</span>,
    verbosity_level=<span class="hljs-number">2</span>,
)`,wrap:!1}}),A=new fe({props:{title:"Run agents one step at a time",local:"run-agents-one-step-at-a-time",headingTag:"h3"}}),z=new F({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUyQyUyMEFjdGlvblN0ZXAlMkMlMjBUYXNrU3RlcCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwdmVyYm9zaXR5X2xldmVsJTNEMSklMEFhZ2VudC5weXRob25fZXhlY3V0b3Iuc2VuZF90b29scyglN0IqKmFnZW50LnRvb2xzJTdEKSUwQXByaW50KGFnZW50Lm1lbW9yeS5zeXN0ZW1fcHJvbXB0KSUwQSUwQXRhc2slMjAlM0QlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjAyMHRoJTIwRmlib25hY2NpJTIwbnVtYmVyJTNGJTIyJTBBJTBBJTIzJTIwWW91JTIwY291bGQlMjBtb2RpZnklMjB0aGUlMjBtZW1vcnklMjBhcyUyMG5lZWRlZCUyMGhlcmUlMjBieSUyMGlucHV0dGluZyUyMHRoZSUyMG1lbW9yeSUyMG9mJTIwYW5vdGhlciUyMGFnZW50LiUwQSUyMyUyMGFnZW50Lm1lbW9yeS5zdGVwcyUyMCUzRCUyMHByZXZpb3VzX2FnZW50Lm1lbW9yeS5zdGVwcyUwQSUwQSUyMyUyMExldCdzJTIwc3RhcnQlMjBhJTIwbmV3JTIwdGFzayElMEFhZ2VudC5tZW1vcnkuc3RlcHMuYXBwZW5kKFRhc2tTdGVwKHRhc2slM0R0YXNrJTJDJTIwdGFza19pbWFnZXMlM0QlNUIlNUQpKSUwQSUwQWZpbmFsX2Fuc3dlciUyMCUzRCUyME5vbmUlMEFzdGVwX251bWJlciUyMCUzRCUyMDElMEF3aGlsZSUyMGZpbmFsX2Fuc3dlciUyMGlzJTIwTm9uZSUyMGFuZCUyMHN0ZXBfbnVtYmVyJTIwJTNDJTNEJTIwMTAlM0ElMEElMjAlMjAlMjAlMjBtZW1vcnlfc3RlcCUyMCUzRCUyMEFjdGlvblN0ZXAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlcF9udW1iZXIlM0RzdGVwX251bWJlciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9ic2VydmF0aW9uc19pbWFnZXMlM0QlNUIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIzJTIwUnVuJTIwb25lJTIwc3RlcC4lMEElMjAlMjAlMjAlMjBmaW5hbF9hbnN3ZXIlMjAlM0QlMjBhZ2VudC5zdGVwKG1lbW9yeV9zdGVwKSUwQSUyMCUyMCUyMCUyMGFnZW50Lm1lbW9yeS5zdGVwcy5hcHBlbmQobWVtb3J5X3N0ZXApJTBBJTIwJTIwJTIwJTIwc3RlcF9udW1iZXIlMjAlMkIlM0QlMjAxJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwbWVtb3J5JTIwYXMlMjB5b3UlMjBwbGVhc2UhJTBBJTIwJTIwJTIwJTIwJTIzJTIwRm9yJTIwaW5zdGFuY2UlMjB0byUyMHVwZGF0ZSUyMHRoZSUyMGxhdGVzdCUyMHN0ZXAlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBhZ2VudC5tZW1vcnkuc3RlcHMlNUItMSU1RCUyMCUzRCUyMC4uLiUwQSUwQXByaW50KCUyMlRoZSUyMGZpbmFsJTIwYW5zd2VyJTIwaXMlM0ElMjIlMkMlMjBmaW5hbF9hbnN3ZXIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent, ActionStep, TaskStep

agent = CodeAgent(tools=[], model=InferenceClientModel(), verbosity_level=<span class="hljs-number">1</span>)
agent.python_executor.send_tools({**agent.tools})
<span class="hljs-built_in">print</span>(agent.memory.system_prompt)

task = <span class="hljs-string">&quot;What is the 20th Fibonacci number?&quot;</span>

<span class="hljs-comment"># You could modify the memory as needed here by inputting the memory of another agent.</span>
<span class="hljs-comment"># agent.memory.steps = previous_agent.memory.steps</span>

<span class="hljs-comment"># Let&#x27;s start a new task!</span>
agent.memory.steps.append(TaskStep(task=task, task_images=[]))

final_answer = <span class="hljs-literal">None</span>
step_number = <span class="hljs-number">1</span>
<span class="hljs-keyword">while</span> final_answer <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> step_number &lt;= <span class="hljs-number">10</span>:
    memory_step = ActionStep(
        step_number=step_number,
        observations_images=[],
    )
    <span class="hljs-comment"># Run one step.</span>
    final_answer = agent.step(memory_step)
    agent.memory.steps.append(memory_step)
    step_number += <span class="hljs-number">1</span>

    <span class="hljs-comment"># Change the memory as you please!</span>
    <span class="hljs-comment"># For instance to update the latest step:</span>
    <span class="hljs-comment"># agent.memory.steps[-1] = ...</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The final answer is:&quot;</span>, final_answer)`,wrap:!1}}),S=new De({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/memory.md"}}),{c(){w=p("meta"),Y=n(),H=p("p"),L=n(),i(u.$$.fragment),q=n(),i(h.$$.fragment),P=n(),i(J.$$.fragment),D=n(),T=p("p"),T.textContent=Ce,K=n(),i(d.$$.fragment),O=n(),U=p("p"),U.textContent=Ze,ee=n(),j=p("p"),j.innerHTML=ve,se=n(),g=p("p"),g.innerHTML=Be,te=n(),f=p("p"),f.textContent=_e,le=n(),i(I.$$.fragment),ne=n(),C=p("p"),C.textContent=Ve,ae=n(),i(Z.$$.fragment),pe=n(),i(v.$$.fragment),oe=n(),B=p("p"),B.textContent=We,me=n(),_=p("p"),_.textContent=ke,ie=n(),i(V.$$.fragment),ye=n(),W=p("p"),W.innerHTML=Xe,Me=n(),k=p("p"),k.textContent=$e,ce=n(),X=p("p"),X.innerHTML=Ge,re=n(),$=p("p"),$.innerHTML=Ne,be=n(),i(G.$$.fragment),we=n(),N=p("p"),N.innerHTML=Re,ue=n(),i(R.$$.fragment),he=n(),Q=p("p"),Q.innerHTML=Qe,Je=n(),i(A.$$.fragment),Te=n(),E=p("p"),E.textContent=Ae,de=n(),i(z.$$.fragment),Ue=n(),i(S.$$.fragment),je=n(),x=p("p"),this.h()},l(e){const s=Le("svelte-u9bgzb",document.head);w=o(s,"META",{name:!0,content:!0}),s.forEach(t),Y=a(e),H=o(e,"P",{}),Ee(H).forEach(t),L=a(e),y(u.$$.fragment,e),q=a(e),y(h.$$.fragment,e),P=a(e),y(J.$$.fragment,e),D=a(e),T=o(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-102p4os"&&(T.textContent=Ce),K=a(e),y(d.$$.fragment,e),O=a(e),U=o(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-p9bsvd"&&(U.textContent=Ze),ee=a(e),j=o(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-cyladv"&&(j.innerHTML=ve),se=a(e),g=o(e,"P",{"data-svelte-h":!0}),m(g)!=="svelte-1j5hyq7"&&(g.innerHTML=Be),te=a(e),f=o(e,"P",{"data-svelte-h":!0}),m(f)!=="svelte-kdqcx3"&&(f.textContent=_e),le=a(e),y(I.$$.fragment,e),ne=a(e),C=o(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-16cln5c"&&(C.textContent=Ve),ae=a(e),y(Z.$$.fragment,e),pe=a(e),y(v.$$.fragment,e),oe=a(e),B=o(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-8gbd4j"&&(B.textContent=We),me=a(e),_=o(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-dw95g"&&(_.textContent=ke),ie=a(e),y(V.$$.fragment,e),ye=a(e),W=o(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-oqerv4"&&(W.innerHTML=Xe),Me=a(e),k=o(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-2c0lec"&&(k.textContent=$e),ce=a(e),X=o(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1g68dq6"&&(X.innerHTML=Ge),re=a(e),$=o(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-1g8132p"&&($.innerHTML=Ne),be=a(e),y(G.$$.fragment,e),we=a(e),N=o(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1s6pldm"&&(N.innerHTML=Re),ue=a(e),y(R.$$.fragment,e),he=a(e),Q=o(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1c9b7q3"&&(Q.innerHTML=Qe),Je=a(e),y(A.$$.fragment,e),Te=a(e),E=o(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1jw480t"&&(E.textContent=Ae),de=a(e),y(z.$$.fragment,e),Ue=a(e),y(S.$$.fragment,e),je=a(e),x=o(e,"P",{}),Ee(x).forEach(t),this.h()},h(){ze(w,"name","hf:doc:metadata"),ze(w,"content",es)},m(e,s){qe(document.head,w),l(e,Y,s),l(e,H,s),l(e,L,s),M(u,e,s),l(e,q,s),M(h,e,s),l(e,P,s),M(J,e,s),l(e,D,s),l(e,T,s),l(e,K,s),M(d,e,s),l(e,O,s),l(e,U,s),l(e,ee,s),l(e,j,s),l(e,se,s),l(e,g,s),l(e,te,s),l(e,f,s),l(e,le,s),M(I,e,s),l(e,ne,s),l(e,C,s),l(e,ae,s),M(Z,e,s),l(e,pe,s),M(v,e,s),l(e,oe,s),l(e,B,s),l(e,me,s),l(e,_,s),l(e,ie,s),M(V,e,s),l(e,ye,s),l(e,W,s),l(e,Me,s),l(e,k,s),l(e,ce,s),l(e,X,s),l(e,re,s),l(e,$,s),l(e,be,s),M(G,e,s),l(e,we,s),l(e,N,s),l(e,ue,s),M(R,e,s),l(e,he,s),l(e,Q,s),l(e,Je,s),M(A,e,s),l(e,Te,s),l(e,E,s),l(e,de,s),M(z,e,s),l(e,Ue,s),M(S,e,s),l(e,je,s),l(e,x,s),ge=!0},p:Fe,i(e){ge||(c(u.$$.fragment,e),c(h.$$.fragment,e),c(J.$$.fragment,e),c(d.$$.fragment,e),c(I.$$.fragment,e),c(Z.$$.fragment,e),c(v.$$.fragment,e),c(V.$$.fragment,e),c(G.$$.fragment,e),c(R.$$.fragment,e),c(A.$$.fragment,e),c(z.$$.fragment,e),c(S.$$.fragment,e),ge=!0)},o(e){r(u.$$.fragment,e),r(h.$$.fragment,e),r(J.$$.fragment,e),r(d.$$.fragment,e),r(I.$$.fragment,e),r(Z.$$.fragment,e),r(v.$$.fragment,e),r(V.$$.fragment,e),r(G.$$.fragment,e),r(R.$$.fragment,e),r(A.$$.fragment,e),r(z.$$.fragment,e),r(S.$$.fragment,e),ge=!1},d(e){e&&(t(Y),t(H),t(L),t(q),t(P),t(D),t(T),t(K),t(O),t(U),t(ee),t(j),t(se),t(g),t(te),t(f),t(le),t(ne),t(C),t(ae),t(pe),t(oe),t(B),t(me),t(_),t(ie),t(ye),t(W),t(Me),t(k),t(ce),t(X),t(re),t($),t(be),t(we),t(N),t(ue),t(he),t(Q),t(Je),t(Te),t(E),t(de),t(Ue),t(je),t(x)),t(w),b(u,e),b(h,e),b(J,e),b(d,e),b(I,e),b(Z,e),b(v,e),b(V,e),b(G,e),b(R,e),b(A,e),b(z,e),b(S,e)}}}const es='{"title":"📚 Manage your agent’s memory","local":"-manage-your-agents-memory","sections":[{"title":"Replay your agent’s memory","local":"replay-your-agents-memory","sections":[],"depth":3},{"title":"Dynamically change the agent’s memory","local":"dynamically-change-the-agents-memory","sections":[],"depth":3},{"title":"Run agents one step at a time","local":"run-agents-one-step-at-a-time","sections":[],"depth":3}],"depth":1}';function ss(Ie){return He(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class os extends xe{constructor(w){super(),Ye(this,w,ss,Oe,Se,{})}}export{os as component};
