import{s as Qt,n as _t,o as St}from"../chunks/scheduler.3d32dc09.js";import{S as zt,i as Et,e as i,s as n,c as p,h as Yt,a as o,d as l,b as a,f as Ht,g as M,j as r,k as ut,l as Ft,m as s,n as c,t as m,o as u,p as y}from"../chunks/index.f9718211.js";import{C as Lt,H as d,E as Pt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.51c38499.js";import{C as me}from"../chunks/CodeBlock.ab331c21.js";import{D as Dt}from"../chunks/DocNotebookDropdown.79c5aa63.js";function Kt(yt){let w,de,ue,we,g,je,T,Je,h,ge,b,Te,f,dt="Retrieval-Augmented Generation (RAG) combines the power of large language models with external knowledge retrieval to produce more accurate, factual, and contextually relevant responses. At its core, RAG is about “using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base.”",he,U,be,I,wt="RAG offers several significant advantages over using vanilla or fine-tuned LLMs:",fe,v,jt="<li><strong>Factual Grounding</strong>: Reduces hallucinations by anchoring responses in retrieved facts</li> <li><strong>Domain Specialization</strong>: Provides domain-specific knowledge without model retraining</li> <li><strong>Knowledge Recency</strong>: Allows access to information beyond the model’s training cutoff</li> <li><strong>Transparency</strong>: Enables citation of sources for generated content</li> <li><strong>Control</strong>: Offers fine-grained control over what information the model can access</li>",Ue,C,Ie,B,Jt="Despite its benefits, traditional RAG approaches face several challenges:",ve,A,gt="<li><strong>Single Retrieval Step</strong>: If the initial retrieval results are poor, the final generation will suffer</li> <li><strong>Query-Document Mismatch</strong>: User queries (often questions) may not match well with documents containing answers (often statements)</li> <li><strong>Limited Reasoning</strong>: Simple RAG pipelines don’t allow for multi-step reasoning or query refinement</li> <li><strong>Context Window Constraints</strong>: Retrieved documents must fit within the model’s context window</li>",Ce,Z,Be,G,Tt="We can overcome these limitations by implementing an <strong>Agentic RAG</strong> system - essentially an agent equipped with retrieval capabilities. This approach transforms RAG from a rigid pipeline into an interactive, reasoning-driven process.",Ae,R,Ze,$,ht="An agent with retrieval tools can:",Ge,W,bt="<li>✅ <strong>Formulate optimized queries</strong>: The agent can transform user questions into retrieval-friendly queries</li> <li>✅ <strong>Perform multiple retrievals</strong>: The agent can retrieve information iteratively as needed</li> <li>✅ <strong>Reason over retrieved content</strong>: The agent can analyze, synthesize, and draw conclusions from multiple sources</li> <li>✅ <strong>Self-critique and refine</strong>: The agent can evaluate retrieval results and adjust its approach</li>",Re,k,ft="This approach naturally implements advanced RAG techniques:",$e,V,Ut='<li><strong>Hypothetical Document Embedding (HyDE)</strong>: Instead of using the user query directly, the agent formulates retrieval-optimized queries (<a href="https://huggingface.co/papers/2212.10496" rel="nofollow">paper reference</a>)</li> <li><strong>Self-Query Refinement</strong>: The agent can analyze initial results and perform follow-up retrievals with refined queries (<a href="https://docs.llamaindex.ai/en/stable/examples/evaluation/RetryQuery/" rel="nofollow">technique reference</a>)</li>',We,x,ke,X,It="Let’s build a complete Agentic RAG system step by step. We’ll create an agent that can answer questions about the Hugging Face Transformers library by retrieving information from its documentation.",Ve,N,vt='You can follow along with the code snippets below, or check out the full example in the smolagents GitHub repository: <a href="https://github.com/huggingface/smolagents/blob/main/examples/rag.py" rel="nofollow">examples/rag.py</a>.',xe,q,Xe,H,Ct="First, we need to install the necessary packages:",Ne,Q,qe,_,Bt="If you plan to use Hugging Face’s Inference API, you’ll need to set up your API token:",He,S,Qe,z,_e,E,At="We’ll use a dataset containing Hugging Face documentation and prepare it for retrieval:",Se,Y,ze,F,Ee,L,Zt="Now we’ll create a custom tool that our agent can use to retrieve information from the knowledge base:",Ye,P,Fe,j,Gt='<p>We’re using BM25, a lexical retrieval method, for simplicity and speed. For production systems, you might want to use semantic search with embeddings for better retrieval quality. Check the <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">MTEB Leaderboard</a> for high-quality embedding models.</p>',Le,D,Pe,K,Rt="Now we’ll create an agent that can use our retriever tool to answer questions:",De,O,Ke,J,$t='<p>Inference Providers give access to hundreds of models, powered by serverless inference partners. A list of supported providers can be found <a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">here</a>.</p>',Oe,ee,et,te,Wt="Let’s use our agent to answer a question about Transformers:",tt,le,lt,se,st,ne,kt="Agentic RAG systems can be applied to various use cases:",nt,ae,Vt="<li><strong>Technical Documentation Assistance</strong>: Help users navigate complex technical documentation</li> <li><strong>Research Paper Analysis</strong>: Extract and synthesize information from scientific papers</li> <li><strong>Legal Document Review</strong>: Find relevant precedents and clauses in legal documents</li> <li><strong>Customer Support</strong>: Answer questions based on product documentation and knowledge bases</li> <li><strong>Educational Tutoring</strong>: Provide explanations based on textbooks and learning materials</li>",at,ie,it,oe,xt="Agentic RAG represents a significant advancement over traditional RAG pipelines. By combining the reasoning capabilities of LLM agents with the factual grounding of retrieval systems, we can build more powerful, flexible, and accurate information systems.",ot,re,Xt="The approach we’ve demonstrated:",rt,pe,Nt="<li>Overcomes the limitations of single-step retrieval</li> <li>Enables more natural interactions with knowledge bases</li> <li>Provides a framework for continuous improvement through self-critique and query refinement</li>",pt,Me,qt="As you build your own Agentic RAG systems, consider experimenting with different retrieval methods, agent architectures, and knowledge sources to find the optimal configuration for your specific use case.",Mt,ce,ct,ye,mt;return g=new Lt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new d({props:{title:"Agentic RAG",local:"agentic-rag",headingTag:"h1"}}),h=new Dt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/rag.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/rag.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/rag.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/rag.ipynb"}]}}),b=new d({props:{title:"Introduction to Retrieval-Augmented Generation (RAG)",local:"introduction-to-retrieval-augmented-generation-rag",headingTag:"h2"}}),U=new d({props:{title:"Why Use RAG?",local:"why-use-rag",headingTag:"h3"}}),C=new d({props:{title:"Limitations of Traditional RAG",local:"limitations-of-traditional-rag",headingTag:"h3"}}),Z=new d({props:{title:"Agentic RAG: A More Powerful Approach",local:"agentic-rag-a-more-powerful-approach",headingTag:"h2"}}),R=new d({props:{title:"Key Benefits of Agentic RAG",local:"key-benefits-of-agentic-rag",headingTag:"h3"}}),x=new d({props:{title:"Building an Agentic RAG System",local:"building-an-agentic-rag-system",headingTag:"h2"}}),q=new d({props:{title:"Step 1: Install Required Dependencies",local:"step-1-install-required-dependencies",headingTag:"h3"}}),Q=new me({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlMjBwYW5kYXMlMjBsYW5nY2hhaW4lMjBsYW5nY2hhaW4tY29tbXVuaXR5JTIwc2VudGVuY2UtdHJhbnNmb3JtZXJzJTIwZGF0YXNldHMlMjBweXRob24tZG90ZW52JTIwcmFua19ibTI1JTIwLS11cGdyYWRl",highlighted:"pip install smolagents pandas langchain langchain-community sentence-transformers datasets python-dotenv rank_bm25 --upgrade",wrap:!1}}),S=new me({props:{code:"JTIzJTIwTG9hZCUyMGVudmlyb25tZW50JTIwdmFyaWFibGVzJTIwKGluY2x1ZGluZyUyMEhGX1RPS0VOKSUwQWZyb20lMjBkb3RlbnYlMjBpbXBvcnQlMjBsb2FkX2RvdGVudiUwQWxvYWRfZG90ZW52KCk=",highlighted:`<span class="hljs-comment"># Load environment variables (including HF_TOKEN)</span>
<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
load_dotenv()`,wrap:!1}}),z=new d({props:{title:"Step 2: Prepare the Knowledge Base",local:"step-2-prepare-the-knowledge-base",headingTag:"h3"}}),Y=new me({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFmcm9tJTIwbGFuZ2NoYWluLmRvY3N0b3JlLmRvY3VtZW50JTIwaW1wb3J0JTIwRG9jdW1lbnQlMEFmcm9tJTIwbGFuZ2NoYWluLnRleHRfc3BsaXR0ZXIlMjBpbXBvcnQlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIlMEFmcm9tJTIwbGFuZ2NoYWluX2NvbW11bml0eS5yZXRyaWV2ZXJzJTIwaW1wb3J0JTIwQk0yNVJldHJpZXZlciUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBIdWdnaW5nJTIwRmFjZSUyMGRvY3VtZW50YXRpb24lMjBkYXRhc2V0JTBBa25vd2xlZGdlX2Jhc2UlMjAlM0QlMjBkYXRhc2V0cy5sb2FkX2RhdGFzZXQoJTIybS1yaWMlMkZodWdnaW5nZmFjZV9kb2MlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQSUyMyUyMEZpbHRlciUyMHRvJTIwaW5jbHVkZSUyMG9ubHklMjBUcmFuc2Zvcm1lcnMlMjBkb2N1bWVudGF0aW9uJTBBa25vd2xlZGdlX2Jhc2UlMjAlM0QlMjBrbm93bGVkZ2VfYmFzZS5maWx0ZXIobGFtYmRhJTIwcm93JTNBJTIwcm93JTVCJTIyc291cmNlJTIyJTVELnN0YXJ0c3dpdGgoJTIyaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMlMjIpKSUwQSUwQSUyMyUyMENvbnZlcnQlMjBkYXRhc2V0JTIwZW50cmllcyUyMHRvJTIwRG9jdW1lbnQlMjBvYmplY3RzJTIwd2l0aCUyMG1ldGFkYXRhJTBBc291cmNlX2RvY3MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBEb2N1bWVudChwYWdlX2NvbnRlbnQlM0Rkb2MlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwbWV0YWRhdGElM0QlN0IlMjJzb3VyY2UlMjIlM0ElMjBkb2MlNUIlMjJzb3VyY2UlMjIlNUQuc3BsaXQoJTIyJTJGJTIyKSU1QjElNUQlN0QpJTBBJTIwJTIwJTIwJTIwZm9yJTIwZG9jJTIwaW4lMjBrbm93bGVkZ2VfYmFzZSUwQSU1RCUwQSUwQSUyMyUyMFNwbGl0JTIwZG9jdW1lbnRzJTIwaW50byUyMHNtYWxsZXIlMjBjaHVua3MlMjBmb3IlMjBiZXR0ZXIlMjByZXRyaWV2YWwlMEF0ZXh0X3NwbGl0dGVyJTIwJTNEJTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyKCUwQSUyMCUyMCUyMCUyMGNodW5rX3NpemUlM0Q1MDAlMkMlMjAlMjAlMjMlMjBDaGFyYWN0ZXJzJTIwcGVyJTIwY2h1bmslMEElMjAlMjAlMjAlMjBjaHVua19vdmVybGFwJTNENTAlMkMlMjAlMjAlMjMlMjBPdmVybGFwJTIwYmV0d2VlbiUyMGNodW5rcyUyMHRvJTIwbWFpbnRhaW4lMjBjb250ZXh0JTBBJTIwJTIwJTIwJTIwYWRkX3N0YXJ0X2luZGV4JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHN0cmlwX3doaXRlc3BhY2UlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwc2VwYXJhdG9ycyUzRCU1QiUyMiU1Q24lNUNuJTIyJTJDJTIwJTIyJTVDbiUyMiUyQyUyMCUyMi4lMjIlMkMlMjAlMjIlMjAlMjIlMkMlMjAlMjIlMjIlNUQlMkMlMjAlMjAlMjMlMjBQcmlvcml0eSUyMG9yZGVyJTIwZm9yJTIwc3BsaXR0aW5nJTBBKSUwQWRvY3NfcHJvY2Vzc2VkJTIwJTNEJTIwdGV4dF9zcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoc291cmNlX2RvY3MpJTBBJTBBcHJpbnQoZiUyMktub3dsZWRnZSUyMGJhc2UlMjBwcmVwYXJlZCUyMHdpdGglMjAlN0JsZW4oZG9jc19wcm9jZXNzZWQpJTdEJTIwZG9jdW1lbnQlMjBjaHVua3MlMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever

<span class="hljs-comment"># Load the Hugging Face documentation dataset</span>
knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Filter to include only Transformers documentation</span>
knowledge_base = knowledge_base.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> row: row[<span class="hljs-string">&quot;source&quot;</span>].startswith(<span class="hljs-string">&quot;huggingface/transformers&quot;</span>))

<span class="hljs-comment"># Convert dataset entries to Document objects with metadata</span>
source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]})
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

<span class="hljs-comment"># Split documents into smaller chunks for better retrieval</span>
text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">500</span>,  <span class="hljs-comment"># Characters per chunk</span>
    chunk_overlap=<span class="hljs-number">50</span>,  <span class="hljs-comment"># Overlap between chunks to maintain context</span>
    add_start_index=<span class="hljs-literal">True</span>,
    strip_whitespace=<span class="hljs-literal">True</span>,
    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],  <span class="hljs-comment"># Priority order for splitting</span>
)
docs_processed = text_splitter.split_documents(source_docs)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Knowledge base prepared with <span class="hljs-subst">{<span class="hljs-built_in">len</span>(docs_processed)}</span> document chunks&quot;</span>)`,wrap:!1}}),F=new d({props:{title:"Step 3: Create a Retriever Tool",local:"step-3-create-a-retriever-tool",headingTag:"h3"}}),P=new me({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = <span class="hljs-string">&quot;Uses semantic search to retrieve the parts of transformers documentation that could be most relevant to answer your query.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        <span class="hljs-comment"># Initialize the retriever with our processed documents</span>
        self.retriever = BM25Retriever.from_documents(
            docs, k=<span class="hljs-number">10</span>  <span class="hljs-comment"># Return top 10 most relevant documents</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;Execute the retrieval based on the provided query.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        <span class="hljs-comment"># Retrieve relevant documents</span>
        docs = self.retriever.invoke(query)

        <span class="hljs-comment"># Format the retrieved documents for readability</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved documents:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [
                <span class="hljs-string">f&quot;\\n\\n===== Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content
                <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)
            ]
        )

<span class="hljs-comment"># Initialize our retriever tool with the processed documents</span>
retriever_tool = RetrieverTool(docs_processed)`,wrap:!1}}),D=new d({props:{title:"Step 4: Create an Advanced Retrieval Agent",local:"step-4-create-an-advanced-retrieval-agent",headingTag:"h3"}}),O=new me({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjBhZ2VudCUyMHdpdGglMjBvdXIlMjByZXRyaWV2ZXIlMjB0b29sJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJyZXRyaWV2ZXJfdG9vbCU1RCUyQyUyMCUyMCUyMyUyMExpc3QlMjBvZiUyMHRvb2xzJTIwYXZhaWxhYmxlJTIwdG8lMjB0aGUlMjBhZ2VudCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUyQyUyMCUyMCUyMyUyMERlZmF1bHQlMjBtb2RlbCUyMCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDQlMkMlMjAlMjAlMjMlMjBMaW1pdCUyMHRoZSUyMG51bWJlciUyMG9mJTIwcmVhc29uaW5nJTIwc3RlcHMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QyJTJDJTIwJTIwJTIzJTIwU2hvdyUyMGRldGFpbGVkJTIwYWdlbnQlMjByZWFzb25pbmclMEEpJTBBJTBBJTIzJTIwVG8lMjB1c2UlMjBhJTIwc3BlY2lmaWMlMjBtb2RlbCUyQyUyMHlvdSUyMGNhbiUyMHNwZWNpZnklMjBpdCUyMGxpa2UlMjB0aGlzJTNBJTBBJTIzJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbChtb2RlbF9pZCUzRCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjMtNzBCLUluc3RydWN0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-comment"># Initialize the agent with our retriever tool</span>
agent = CodeAgent(
    tools=[retriever_tool],  <span class="hljs-comment"># List of tools available to the agent</span>
    model=InferenceClientModel(),  <span class="hljs-comment"># Default model &quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>
    max_steps=<span class="hljs-number">4</span>,  <span class="hljs-comment"># Limit the number of reasoning steps</span>
    verbosity_level=<span class="hljs-number">2</span>,  <span class="hljs-comment"># Show detailed agent reasoning</span>
)

<span class="hljs-comment"># To use a specific model, you can specify it like this:</span>
<span class="hljs-comment"># model=InferenceClientModel(model_id=&quot;meta-llama/Llama-3.3-70B-Instruct&quot;)</span>`,wrap:!1}}),ee=new d({props:{title:"Step 5: Run the Agent to Answer Questions",local:"step-5-run-the-agent-to-answer-questions",headingTag:"h3"}}),le=new me({props:{code:"JTIzJTIwQXNrJTIwYSUyMHF1ZXN0aW9uJTIwdGhhdCUyMHJlcXVpcmVzJTIwcmV0cmlldmluZyUyMGluZm9ybWF0aW9uJTBBcXVlc3Rpb24lMjAlM0QlMjAlMjJGb3IlMjBhJTIwdHJhbnNmb3JtZXJzJTIwbW9kZWwlMjB0cmFpbmluZyUyQyUyMHdoaWNoJTIwaXMlMjBzbG93ZXIlMkMlMjB0aGUlMjBmb3J3YXJkJTIwb3IlMjB0aGUlMjBiYWNrd2FyZCUyMHBhc3MlM0YlMjIlMEElMEElMjMlMjBSdW4lMjB0aGUlMjBhZ2VudCUyMHRvJTIwZ2V0JTIwYW4lMjBhbnN3ZXIlMEFhZ2VudF9vdXRwdXQlMjAlM0QlMjBhZ2VudC5ydW4ocXVlc3Rpb24pJTBBJTBBJTIzJTIwRGlzcGxheSUyMHRoZSUyMGZpbmFsJTIwYW5zd2VyJTBBcHJpbnQoJTIyJTVDbkZpbmFsJTIwYW5zd2VyJTNBJTIyKSUwQXByaW50KGFnZW50X291dHB1dCk=",highlighted:`<span class="hljs-comment"># Ask a question that requires retrieving information</span>
question = <span class="hljs-string">&quot;For a transformers model training, which is slower, the forward or the backward pass?&quot;</span>

<span class="hljs-comment"># Run the agent to get an answer</span>
agent_output = agent.run(question)

<span class="hljs-comment"># Display the final answer</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nFinal answer:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),se=new d({props:{title:"Practical Applications of Agentic RAG",local:"practical-applications-of-agentic-rag",headingTag:"h2"}}),ie=new d({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),ce=new Pt({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/rag.md"}}),{c(){w=i("meta"),de=n(),ue=i("p"),we=n(),p(g.$$.fragment),je=n(),p(T.$$.fragment),Je=n(),p(h.$$.fragment),ge=n(),p(b.$$.fragment),Te=n(),f=i("p"),f.textContent=dt,he=n(),p(U.$$.fragment),be=n(),I=i("p"),I.textContent=wt,fe=n(),v=i("ol"),v.innerHTML=jt,Ue=n(),p(C.$$.fragment),Ie=n(),B=i("p"),B.textContent=Jt,ve=n(),A=i("ul"),A.innerHTML=gt,Ce=n(),p(Z.$$.fragment),Be=n(),G=i("p"),G.innerHTML=Tt,Ae=n(),p(R.$$.fragment),Ze=n(),$=i("p"),$.textContent=ht,Ge=n(),W=i("ol"),W.innerHTML=bt,Re=n(),k=i("p"),k.textContent=ft,$e=n(),V=i("ul"),V.innerHTML=Ut,We=n(),p(x.$$.fragment),ke=n(),X=i("p"),X.textContent=It,Ve=n(),N=i("p"),N.innerHTML=vt,xe=n(),p(q.$$.fragment),Xe=n(),H=i("p"),H.textContent=Ct,Ne=n(),p(Q.$$.fragment),qe=n(),_=i("p"),_.textContent=Bt,He=n(),p(S.$$.fragment),Qe=n(),p(z.$$.fragment),_e=n(),E=i("p"),E.textContent=At,Se=n(),p(Y.$$.fragment),ze=n(),p(F.$$.fragment),Ee=n(),L=i("p"),L.textContent=Zt,Ye=n(),p(P.$$.fragment),Fe=n(),j=i("blockquote"),j.innerHTML=Gt,Le=n(),p(D.$$.fragment),Pe=n(),K=i("p"),K.textContent=Rt,De=n(),p(O.$$.fragment),Ke=n(),J=i("blockquote"),J.innerHTML=$t,Oe=n(),p(ee.$$.fragment),et=n(),te=i("p"),te.textContent=Wt,tt=n(),p(le.$$.fragment),lt=n(),p(se.$$.fragment),st=n(),ne=i("p"),ne.textContent=kt,nt=n(),ae=i("ol"),ae.innerHTML=Vt,at=n(),p(ie.$$.fragment),it=n(),oe=i("p"),oe.textContent=xt,ot=n(),re=i("p"),re.textContent=Xt,rt=n(),pe=i("ul"),pe.innerHTML=Nt,pt=n(),Me=i("p"),Me.textContent=qt,Mt=n(),p(ce.$$.fragment),ct=n(),ye=i("p"),this.h()},l(e){const t=Yt("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(l),de=a(e),ue=o(e,"P",{}),Ht(ue).forEach(l),we=a(e),M(g.$$.fragment,e),je=a(e),M(T.$$.fragment,e),Je=a(e),M(h.$$.fragment,e),ge=a(e),M(b.$$.fragment,e),Te=a(e),f=o(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-ahsalp"&&(f.textContent=dt),he=a(e),M(U.$$.fragment,e),be=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-3b2p9t"&&(I.textContent=wt),fe=a(e),v=o(e,"OL",{"data-svelte-h":!0}),r(v)!=="svelte-s9vwtj"&&(v.innerHTML=jt),Ue=a(e),M(C.$$.fragment,e),Ie=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-5ohm8g"&&(B.textContent=Jt),ve=a(e),A=o(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-1b6u5vg"&&(A.innerHTML=gt),Ce=a(e),M(Z.$$.fragment,e),Be=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-nkypap"&&(G.innerHTML=Tt),Ae=a(e),M(R.$$.fragment,e),Ze=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-106qzhl"&&($.textContent=ht),Ge=a(e),W=o(e,"OL",{"data-svelte-h":!0}),r(W)!=="svelte-17ov5nb"&&(W.innerHTML=bt),Re=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1vth8dz"&&(k.textContent=ft),$e=a(e),V=o(e,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-1kmp0ag"&&(V.innerHTML=Ut),We=a(e),M(x.$$.fragment,e),ke=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-ebtqsa"&&(X.textContent=It),Ve=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-a2onz5"&&(N.innerHTML=vt),xe=a(e),M(q.$$.fragment,e),Xe=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1yz8wyl"&&(H.textContent=Ct),Ne=a(e),M(Q.$$.fragment,e),qe=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-io6cbu"&&(_.textContent=Bt),He=a(e),M(S.$$.fragment,e),Qe=a(e),M(z.$$.fragment,e),_e=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1r0dacz"&&(E.textContent=At),Se=a(e),M(Y.$$.fragment,e),ze=a(e),M(F.$$.fragment,e),Ee=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-16ovxir"&&(L.textContent=Zt),Ye=a(e),M(P.$$.fragment,e),Fe=a(e),j=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-1j7z97m"&&(j.innerHTML=Gt),Le=a(e),M(D.$$.fragment,e),Pe=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-uyg5h9"&&(K.textContent=Rt),De=a(e),M(O.$$.fragment,e),Ke=a(e),J=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1lti5bi"&&(J.innerHTML=$t),Oe=a(e),M(ee.$$.fragment,e),et=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1cnhgyu"&&(te.textContent=Wt),tt=a(e),M(le.$$.fragment,e),lt=a(e),M(se.$$.fragment,e),st=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1vnmlwn"&&(ne.textContent=kt),nt=a(e),ae=o(e,"OL",{"data-svelte-h":!0}),r(ae)!=="svelte-u8fd9x"&&(ae.innerHTML=Vt),at=a(e),M(ie.$$.fragment,e),it=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1nscnr8"&&(oe.textContent=xt),ot=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-18cofwx"&&(re.textContent=Xt),rt=a(e),pe=o(e,"UL",{"data-svelte-h":!0}),r(pe)!=="svelte-12ngelm"&&(pe.innerHTML=Nt),pt=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-izrxrg"&&(Me.textContent=qt),Mt=a(e),M(ce.$$.fragment,e),ct=a(e),ye=o(e,"P",{}),Ht(ye).forEach(l),this.h()},h(){ut(w,"name","hf:doc:metadata"),ut(w,"content",Ot),ut(j,"class","tip"),ut(J,"class","tip")},m(e,t){Ft(document.head,w),s(e,de,t),s(e,ue,t),s(e,we,t),c(g,e,t),s(e,je,t),c(T,e,t),s(e,Je,t),c(h,e,t),s(e,ge,t),c(b,e,t),s(e,Te,t),s(e,f,t),s(e,he,t),c(U,e,t),s(e,be,t),s(e,I,t),s(e,fe,t),s(e,v,t),s(e,Ue,t),c(C,e,t),s(e,Ie,t),s(e,B,t),s(e,ve,t),s(e,A,t),s(e,Ce,t),c(Z,e,t),s(e,Be,t),s(e,G,t),s(e,Ae,t),c(R,e,t),s(e,Ze,t),s(e,$,t),s(e,Ge,t),s(e,W,t),s(e,Re,t),s(e,k,t),s(e,$e,t),s(e,V,t),s(e,We,t),c(x,e,t),s(e,ke,t),s(e,X,t),s(e,Ve,t),s(e,N,t),s(e,xe,t),c(q,e,t),s(e,Xe,t),s(e,H,t),s(e,Ne,t),c(Q,e,t),s(e,qe,t),s(e,_,t),s(e,He,t),c(S,e,t),s(e,Qe,t),c(z,e,t),s(e,_e,t),s(e,E,t),s(e,Se,t),c(Y,e,t),s(e,ze,t),c(F,e,t),s(e,Ee,t),s(e,L,t),s(e,Ye,t),c(P,e,t),s(e,Fe,t),s(e,j,t),s(e,Le,t),c(D,e,t),s(e,Pe,t),s(e,K,t),s(e,De,t),c(O,e,t),s(e,Ke,t),s(e,J,t),s(e,Oe,t),c(ee,e,t),s(e,et,t),s(e,te,t),s(e,tt,t),c(le,e,t),s(e,lt,t),c(se,e,t),s(e,st,t),s(e,ne,t),s(e,nt,t),s(e,ae,t),s(e,at,t),c(ie,e,t),s(e,it,t),s(e,oe,t),s(e,ot,t),s(e,re,t),s(e,rt,t),s(e,pe,t),s(e,pt,t),s(e,Me,t),s(e,Mt,t),c(ce,e,t),s(e,ct,t),s(e,ye,t),mt=!0},p:_t,i(e){mt||(m(g.$$.fragment,e),m(T.$$.fragment,e),m(h.$$.fragment,e),m(b.$$.fragment,e),m(U.$$.fragment,e),m(C.$$.fragment,e),m(Z.$$.fragment,e),m(R.$$.fragment,e),m(x.$$.fragment,e),m(q.$$.fragment,e),m(Q.$$.fragment,e),m(S.$$.fragment,e),m(z.$$.fragment,e),m(Y.$$.fragment,e),m(F.$$.fragment,e),m(P.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(ie.$$.fragment,e),m(ce.$$.fragment,e),mt=!0)},o(e){u(g.$$.fragment,e),u(T.$$.fragment,e),u(h.$$.fragment,e),u(b.$$.fragment,e),u(U.$$.fragment,e),u(C.$$.fragment,e),u(Z.$$.fragment,e),u(R.$$.fragment,e),u(x.$$.fragment,e),u(q.$$.fragment,e),u(Q.$$.fragment,e),u(S.$$.fragment,e),u(z.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),u(P.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(ie.$$.fragment,e),u(ce.$$.fragment,e),mt=!1},d(e){e&&(l(de),l(ue),l(we),l(je),l(Je),l(ge),l(Te),l(f),l(he),l(be),l(I),l(fe),l(v),l(Ue),l(Ie),l(B),l(ve),l(A),l(Ce),l(Be),l(G),l(Ae),l(Ze),l($),l(Ge),l(W),l(Re),l(k),l($e),l(V),l(We),l(ke),l(X),l(Ve),l(N),l(xe),l(Xe),l(H),l(Ne),l(qe),l(_),l(He),l(Qe),l(_e),l(E),l(Se),l(ze),l(Ee),l(L),l(Ye),l(Fe),l(j),l(Le),l(Pe),l(K),l(De),l(Ke),l(J),l(Oe),l(et),l(te),l(tt),l(lt),l(st),l(ne),l(nt),l(ae),l(at),l(it),l(oe),l(ot),l(re),l(rt),l(pe),l(pt),l(Me),l(Mt),l(ct),l(ye)),l(w),y(g,e),y(T,e),y(h,e),y(b,e),y(U,e),y(C,e),y(Z,e),y(R,e),y(x,e),y(q,e),y(Q,e),y(S,e),y(z,e),y(Y,e),y(F,e),y(P,e),y(D,e),y(O,e),y(ee,e),y(le,e),y(se,e),y(ie,e),y(ce,e)}}}const Ot='{"title":"Agentic RAG","local":"agentic-rag","sections":[{"title":"Introduction to Retrieval-Augmented Generation (RAG)","local":"introduction-to-retrieval-augmented-generation-rag","sections":[{"title":"Why Use RAG?","local":"why-use-rag","sections":[],"depth":3},{"title":"Limitations of Traditional RAG","local":"limitations-of-traditional-rag","sections":[],"depth":3}],"depth":2},{"title":"Agentic RAG: A More Powerful Approach","local":"agentic-rag-a-more-powerful-approach","sections":[{"title":"Key Benefits of Agentic RAG","local":"key-benefits-of-agentic-rag","sections":[],"depth":3}],"depth":2},{"title":"Building an Agentic RAG System","local":"building-an-agentic-rag-system","sections":[{"title":"Step 1: Install Required Dependencies","local":"step-1-install-required-dependencies","sections":[],"depth":3},{"title":"Step 2: Prepare the Knowledge Base","local":"step-2-prepare-the-knowledge-base","sections":[],"depth":3},{"title":"Step 3: Create a Retriever Tool","local":"step-3-create-a-retriever-tool","sections":[],"depth":3},{"title":"Step 4: Create an Advanced Retrieval Agent","local":"step-4-create-an-advanced-retrieval-agent","sections":[],"depth":3},{"title":"Step 5: Run the Agent to Answer Questions","local":"step-5-run-the-agent-to-answer-questions","sections":[],"depth":3}],"depth":2},{"title":"Practical Applications of Agentic RAG","local":"practical-applications-of-agentic-rag","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function el(yt){return St(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class il extends zt{constructor(w){super(),Et(this,w,el,Kt,Qt,{})}}export{il as component};
